#-*- Mode: CPerl -*-

## File: DDC::Client::Distributed.pm
## Author: Bryan Jurish <moocow@cpan.org>
## Description:
##  + DDC Query utilities: clients for distributed server
##======================================================================

package DDC::Client::Distributed;
use DDC::Client;
use Carp;
use Encode qw(encode decode);
use strict;

##======================================================================
## Globals
our @ISA = qw(DDC::Client);

##======================================================================
## Constructors etc

## $dc = $CLASS_OR_OBJ->new(%args)
##  + %args:
##    (
##     start=>$hit_start_index,     ##-- default=0,
##     limit=>$hit_limit_index,     ##-- default=10,
##     timeout=>$hit_timeout_index, ##-- default=60
##
##     connect=>\%connectArgs,      ##-- see DDC::Client->new(), IO::Socket::INET->new()
##    )
sub new {
  my $that = shift;
  return $that->SUPER::new(
			   ##-- defaults
			   start=>0,
			   limit=>10,
			   timeout=>60,

			   ##-- user args
			   @_,
			  );
}

##======================================================================
## Querying

## $buf = $dc->queryRaw($query_string)
## $buf = $dc->queryRaw(\@raw_strings)
sub queryRaw {
  my ($dc,$query) = @_;
  if (UNIVERSAL::isa($query,'ARRAY')) {
    ##-- raw array: send raw data to DDC
    $dc->send(join("\001",@$query));
  }
  elsif ($dc->{mode} =~ /^(?:raw|req)/i) {
    ##-- "raw" or "request" mode: send raw request to DDC
    $dc->send($query);
  }
  else {
    ##-- query string: send 'run-query Distributed'
    $dc->send(join("\001",
		   "run_query Distributed",
		   $query,
		   $dc->{mode},
		   "$dc->{start} $dc->{limit} $dc->{timeout}"));
  }
  ##-- get output buffer
  my $buf = $dc->readData();
  $dc->close(); ##-- this apparently has to happen: bummer
  return $buf;
}

## $obj = $dc->queryJson($query_string)
## $obj = $dc->queryJson(\@raw_strings)
sub queryJson {
  my ($dc,$query) = @_;
  return $dc->decodeJson($dc->queryRaw($query));
}


## $hits = $dc->query($query_string)
sub query {
  my ($dc,$query) = @_;
  return $dc->parseData($dc->queryRaw($query));
}
#
## $expandRaw = $dc->expand_terms($pipeline, $term)
## $expandRaw = $dc->expand_terms($pipeline, $term, $subcorpus)
## $expandRaw = $dc->expand_terms(\@pipeline, \@terms)
## $expandRaw = $dc->expand_terms(\@pipeline, \@terms, $subcorpus)
sub expand_terms {
  my ($dc,$chain,$terms,$subcorpus) = @_;
  $chain = join('|', @$chain)  if (UNIVERSAL::isa($chain,'ARRAY'));
  $terms = join("\t", @$terms) if (UNIVERSAL::isa($terms,'ARRAY'));
  $subcorpus = '' if (!defined($subcorpus));
  $dc->send(join("\x01", 'expand_terms ', $chain, $terms, $dc->{timeout}, $subcorpus));
  ##-- get output buffer
  my $buf = $dc->readData();
  $dc->close(); ##-- this apparently has to happen: bummer
  return $buf;
}




1; ##-- be happy

__END__

##========================================================================
## POD DOCUMENTATION, auto-generated by podextract.perl

##========================================================================
## NAME
=pod

=head1 NAME

DDC::Client::Distributed - DDC Query utilities: client for distributed server

=cut

##========================================================================
## SYNOPSIS
=pod

=head1 SYNOPSIS

 ##========================================================================
 ## PRELIMINARIES

 use DDC::Client;
 use DDC::Client::Distributed;

 ##========================================================================
 ## Constructors etc

 $dc = $CLASS_OR_OBJ->new(%args);

 ##========================================================================
 ## Querying

 $buf  = $dc->queryRaw($query_string);
 $hits = $dc->query($query_string);

 ## ... or any DDC::Client method ...

=cut

##========================================================================
## DESCRIPTION
=pod

=head1 DESCRIPTION

=cut

##----------------------------------------------------------------
## DESCRIPTION: DDC::Client::Distributed: Globals
=pod

=head2 Globals

=over 4

=item Variable: @ISA

DDC::Client::Distributed inherits from DDC::Client.

=back

=cut

##----------------------------------------------------------------
## DESCRIPTION: DDC::Client::Distributed: Constructors etc
=pod

=head2 Constructors etc

=over 4

=item new

 $dc = $CLASS_OR_OBJ->new(%args);

=over 4

=item %args:

   (
    start=>$hit_start_index,     ##-- default=0,
    limit=>$hit_limit_index,     ##-- default=10,
    timeout=>$hit_timeout_index, ##-- default=60
    connect=>\%connectArgs,      ##-- see DDC::Client->new(), IO::Socket::INET->new()
   )

=back

=back

=cut

##----------------------------------------------------------------
## DESCRIPTION: DDC::Client::Distributed: Querying
=pod

=head2 Querying

=over 4

=item query

 $buf = $dc->queryRaw($query_string);

Send a query string to the selected server and returns the raw result buffer.

=item query

 $hits = $dc->query($query_string);

Send a query string to the selected server and parses the result into a list of hits.

=back

=cut

##========================================================================
## END POD DOCUMENTATION, auto-generated by podextract.perl

##======================================================================
## Footer
##======================================================================

=pod

=head1 AUTHOR

Bryan Jurish E<lt>moocow@cpan.orgE<gt>

=head1 COPYRIGHT AND LICENSE

Copyright (C) 2006 by Bryan Jurish

This package is free software; you can redistribute it and/or modify
it under the same terms as Perl itself, either Perl version 5.8.7 or,
at your option, any later version of Perl 5 you may have available.

=cut
