#!perl

use strict;
use warnings;

# This test was generated by inc::CheckJiraInChanges

use Test::More tests => 1;

my @commits = split /\n/, <<'EOC';
44213bc PERL-594 Implement maxAwaitTimeMS CRUD option
8a413b8 PERL-595 Change limit/batchSize behavior to match spec
186ab04 PERL-561 support bypassDocumentValidation
ddd48cd PERL-570 Update MongoDB::Cursor::info documentation
c65a962 PERL-569 Adding batch method to QueryResult
4e90171 PERL-526 Detect stale primaries by election_id
f134dd9 PERL-532 Document loss of precision when serializing long doubles
93b3a1a PERL-475 Optimize 'all' QueryResult method
70af963 PERL-579 Require at least version 0.25 of boolean.pm
a984da5 PERL-493 Don't send writeConcern if it is not set
a9ef8ba PERL-564 Implement Read Concern and Write Concern spec
6d2d055 PERL-575 Copy booleans rather than aliasing them
c0690c1 PERL-198 Validate MongoDB::OID
bb33fa2 PERL-495 Preserve fractional seconds with dt_type raw
5116d24 PERL-571 Include limits.h explicitly
650ca34 PERL-563 Implement find/getMore/killCursors as commands
8dc8191 PERL-558: implement fsyncUnlock as an Op for MongoDB 3.2+
4e19b09 PERL-567 Fix tests for a replica set on 27017
360eead PERL-568 Document replica set connection in MongoDB.pm and MongoClient

EOC

my %ticket_map;
for my $commit ( @commits ) {
    for my $ticket ( $commit =~ /PERL-(\d+)/g ) {
        next if $ENV{CHECK_JIRA_SKIP}
            && grep { $ticket eq $_ } split " ", $ENV{CHECK_JIRA_SKIP};
        $ticket_map{$ticket} ||= [];
        push @{$ticket_map{$ticket}}, $commit;
    }
}

# grab Changes lines from new version to next un-indented line
open my $fh, "<:encoding(UTF-8)", "Changes";
my $changelog = do { local $/; <$fh> };

my @bad;
for my $ticket ( keys %ticket_map ) {
    if ( index( $changelog, "PERL-$ticket" ) < 0 ) {
       push @bad, $ticket;
    }
}

if ( !@commits ) {
    pass("No commits with Jira tickets");
}
else {
    ok( ! scalar @bad, "Jira tickets in Changes")
        or diag "Jira tickets missing:\n"
        . join("\n", map { "  * $_" } map { @{$ticket_map{$_}} } sort { $a <=> $b } @bad );
}
