#!perl

use strict;
use warnings;

# This test was generated by inc::CheckJiraInChanges

use Test::More tests => 1;

my @commits = split /\n/, <<'EOC';
73e4f9c PERL-320 deprecate low-level MongoDB.pm functions
a763566 add Changes entry for PERL-341
8fd59bf PERL-317 clarify documetation about thread support
a409b0e PERL-341 add installation instructions document
646df0d revert incomplete work on PERL-233
6eb1473 Merge branch 'PERL-299-bulk-API'
35f2026 PERL-336 createIndexes fix for additional error code
95a1dbd PERL-323 add windows-specific socket close on error conditions
c289b3c PERL-323 fix socket leaks
acedb93 PERL-233 re-merging forgotten commit for SSL cert validation
4d3e607 PERL-233 merging in SSL cert validation code to master
54e1100 PERL-305 check for connection before attempting SASL auth

EOC

my %ticket_map;
for my $commit ( @commits ) {
    for my $ticket ( $commit =~ /PERL-(\d+)/g ) {
        $ticket_map{$ticket} ||= [];
        push @{$ticket_map{$ticket}}, $commit;
    }
}

# grab Changes lines from new version to next un-indented line
open my $fh, "<:encoding(UTF-8)", "Changes";
my @content = grep { /^v0.703.5(?:\s+|$)/ ... /^\S/ } <$fh>;

# drop the version line
shift @content;

# drop unindented last line and trailing blank lines
pop @content while ( @content && $content[-1] =~ /^(?:\S|\s*$)/ );

my $changelog = join(" ", @content);

my @bad;
for my $ticket ( keys %ticket_map ) {
    if ( index( $changelog, "PERL-$ticket" ) < 0 ) {
       push @bad, $ticket;
    }
}

if ( !@commits ) {
    pass("No commits with Jira tickets");
}
else {
    ok( ! scalar @bad, "Jira tickets in Changes")
        or diag "Jira tickets missing:\n"
        . join("\n", map { "  * $_" } map { @{$ticket_map{$_}} } sort { $a <=> $b } @bad );
}
