#!perl

use Modern::Perl '2010';    ## no critic (Modules::ProhibitUseQuotedVersion)
use Test::More tests => 2;
use Const::Fast;
use List::Util 1.33 'all';
use WebService::NetSuite::SuiteTalk;

const my @NETSUITE_ENVIRONMENT => map {"PERL_TEST_NETSUITE_\U$_"}
    qw(account email password);

SKIP: {
    skip "set @NETSUITE_ENVIRONMENT environment variables to run this test", 2
        if not all { exists $ENV{$_} } @NETSUITE_ENVIRONMENT;

    my $suitetalk = new_ok(
        'WebService::NetSuite::SuiteTalk' => [
            account_id    => $ENV{PERL_TEST_NETSUITE_ACCOUNT},
            email_address => $ENV{PERL_TEST_NETSUITE_EMAIL},
            password      => $ENV{PERL_TEST_NETSUITE_PASSWORD},
            xsi_auto      => 1,
        ],
    );

    my ( $answer_ref, $trace ) = $suitetalk->getDataCenterUrls(
        account  => $suitetalk->account_id,
        email    => $suitetalk->email_address,
        password => $suitetalk->password,
    );

    ok( $answer_ref->{parameters}{getDataCenterUrlsResult}{status}
            {isSuccess} => 'getDataenterUrls' );
}
