#!/bin/perl -w
# $Id: xmlxpath_xpath_cond.t,v 1.5 2004/01/23 23:16:45 mrodrigu Exp $
use strict;

BEGIN 
  { unless( eval( 'require XML::XPath'))
    { print "1..1\nok 1\n"; warn "skipping: XML::XPath not available\n"; exit; }
  }

use XML::Twig::XPath;

$|=1;

my $t= XML::Twig::XPath->new;
$t->parse(
'<doc id="doc">
    <elt id="elt-1">elt 1</elt>
    <elt id="elt-2">elt 2</elt>
    <elt2 id="elt2-1">
      <elt id="elt-3">elt 3</elt>
    </elt2>
    <elt2 id="elt2-2">
      <elt2 att_int="2" id="elt2-3">2</elt2>
      <elt2 att_int="3" id="elt2-4">3</elt2>
    </elt2>
 </doc>');

my @data= grep { !/^##/  && m{\S} } <DATA>;

my @exp;
my %result;

foreach( @data)
  { chomp;
    my ($exp, $id_list) = split /\s*=>\s*/ ;
    $result{$exp}= $id_list;
    push @exp, $exp;
  }

my $nb_tests= keys %result;
print "1..$nb_tests\n";

my $i=1;

foreach my $exp ( @exp)
  { my $expected_result= $result{$exp};
    my @result= $t->findnodes( $exp);
    my $result;
    if( @result)
      { $result= join ' ', map { $_->id } @result; }
    else
      { $result= 'none'; }

    if( $result eq $expected_result)
      { print "ok $i\n"; }
    else
      { print "nok $i\n";
        print STDERR "$exp: expected $expected_result - real $result\n";
      }
    $i++;
  }

__DATA__
/elt                  => none
//elt                 => elt-1 elt-2 elt-3
/doc/elt              => elt-1 elt-2
/doc/elt[ last()]     => elt-2
//elt[@id='elt-1']    => elt-1
//elt[@id="elt-1"] | //elt[@id="elt-2"] | //elt[@id="elt-3"]  => elt-1 elt-2 elt-3
//elt[@id="elt-1" or @id="elt-2" or @id="elt-3"]      => elt-1 elt-2 elt-3
//elt2[@att_int > 2]  => elt2-4
/doc/elt2[ last()]/*  => elt2-3 elt2-4
//*[@id="elt2-2"]        => elt2-2
/doc/elt2[./elt[@id="elt-3"]] => elt2-1

