; Script generated by the Inno Setup Script Wizard.
; SEE THE DOCUMENTATION FOR DETAILS ON CREATING INNO SETUP SCRIPT FILES!

; Assumes iscc commandline parameters, e.g.:
;  iscc.exe  /dMyVer=0.16.2 /dParlPath=C:\Perl\site\bin FontUtils.iss
; where 
;  MyVer is the version for this release in the form n.n.n, and 
;  ParlPath is the name of the folder containing parl.exe

;#define Debug

#define MyFileName StringChange("TTFontUtils_" + MyVer, ".", "_")
#define Parl AddBackslash(ParlPath) + "parl.exe"

[Setup]
AppName=SIL TTF Font Utilities
AppVersion={#MyVer}
AppVerName=SIL TTF Font Utilities {#MyVer}
AppPublisher=SIL International
AppPublisherURL=http://www.sil.org/computing
; AppSupportURL=http://www.sil.org/computing
; AppUpdatesURL=http://www.sil.org/computing
VersionInfoVersion={#MyVer}
VersionInfoCopyright="Copyright (c) 1997-2012 SIL International; released under Perl Artistic License"
DefaultDirName={pf}\SIL\FontUtils
DefaultGroupName=Font Utilities
; uncomment the following line if you want your installation to run on NT 3.51 too.
; MinVersion=4,3.51
PrivilegesRequired=admin
OutputBaseFilename={#MyFileName}
OutputDir=.
; DisableProgramGroupPage=yes
DisableStartupPrompt=yes

[Tasks]
Name: updatepath; Description: "Add installation directory to &PATH";

[Files]
Source: "scripts\fontutils.par"; DestDir: "{app}"; Flags: ignoreversion
Source: "{#Parl}"; DestDir: "{app}"; Flags: ignoreversion

[Run]
Filename: "{app}\parl.exe"; Parameters: """{app}\fontutils.par"" addpath ""{app}"""; Flags: runminimized; Tasks: updatepath
Filename: "{app}\parl.exe"; Parameters: """{app}\fontutils.par"" addbats.pl ""{app}"""; Flags: runminimized

[UninstallRun]
Filename: "{app}\parl.exe"; Parameters: """{app}\fontutils.par"" addpath -r ""{app}"""; Flags: runminimized; Tasks: updatepath
Filename: "{app}\parl.exe"; Parameters: """{app}\fontutils.par"" addbats.pl -r ""{app}"""; Flags: runminimized

#ifdef Debug
  #expr SaveToFile(AddBackslash(SourcePath) + "Preprocessed.iss")
#endif