
use strict;
use warnings;



use ExtUtils::MakeMaker 6.30;



my %WriteMakefileArgs = (
  "ABSTRACT" => "silence Data::Printer except in a controlled scope",
  "AUTHOR" => "Matthew Phillips <mattp\@cpan.org>",
  "BUILD_REQUIRES" => {},
  "CONFIGURE_REQUIRES" => {
    "ExtUtils::MakeMaker" => "6.30"
  },
  "DISTNAME" => "Data-Printer-Scoped",
  "EXE_FILES" => [],
  "LICENSE" => "perl",
  "NAME" => "Data::Printer::Scoped",
  "PREREQ_PM" => {
    "Class::Method::Modifiers" => 0,
    "Data::Printer" => 0,
    "Sub::Exporter::Progressive" => 0
  },
  "TEST_REQUIRES" => {
    "File::HomeDir::Test" => 0,
    "Test::More" => 0
  },
  "VERSION" => "0.001001",
  "test" => {
    "TESTS" => "t/*.t"
  }
);


my %FallbackPrereqs = (
  "Class::Method::Modifiers" => 0,
  "Data::Printer" => 0,
  "File::HomeDir::Test" => 0,
  "Sub::Exporter::Progressive" => 0,
  "Test::More" => 0
);


unless ( eval { ExtUtils::MakeMaker->VERSION(6.63_03) } ) {
  delete $WriteMakefileArgs{TEST_REQUIRES};
  delete $WriteMakefileArgs{BUILD_REQUIRES};
  $WriteMakefileArgs{PREREQ_PM} = \%FallbackPrereqs;
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

WriteMakefile(%WriteMakefileArgs);



