# This file is copied from the Gtk::Simple package. The reason to copy the file
# is to remove dependency on that package because only this file is used

#`{{
List of dynamic libraries found in C:\msys64\mingw64\bin
on Appveyor using MSYS2 environment and
12/03/2019  05:12 AM            54,272 edit.dll
06/09/2020  10:47 AM            53,608 libasprintf-0.dll
10/24/2020  05:09 PM           159,295 libatk-1.0-0.dll
10/31/2020  07:18 PM            36,082 libatomic-1.dll
10/25/2020  08:03 AM           143,395 libbrotlicommon.dll
10/25/2020  08:03 AM            52,874 libbrotlidec.dll
10/25/2020  08:03 AM           654,449 libbrotlienc.dll
07/15/2019  06:00 AM            74,771 libbz2-1.dll
10/24/2020  06:23 PM         1,093,184 libcairo-2.dll
10/24/2020  06:23 PM            35,092 libcairo-gobject-2.dll
10/24/2020  06:23 PM           164,640 libcairo-script-interpreter-2.dll
05/13/2019  06:18 AM            42,682 libcharset-1.dll
09/22/2020  08:33 PM         2,789,703 libcrypto-1_1-x64.dll
08/22/2018  06:08 PM            36,029 libdatrie-1.dll
10/24/2020  12:12 PM         1,736,233 libepoxy-0.dll
10/16/2020  12:50 PM           193,832 libexpat-1.dll
04/09/2020  12:16 PM            32,768 libffi-7.dll
11/01/2020  01:03 AM           305,342 libfontconfig-1.dll
10/01/2019  07:55 AM           307,222 libfreeglut.dll
10/21/2020  12:41 PM           723,628 libfreetype-6.dll
10/24/2020  11:51 AM           143,321 libfribidi-0.dll
10/28/2020  03:00 PM            45,004 libgailutil-3-0.dll
10/31/2020  07:18 PM            82,097 libgcc_s_seh-1.dll
10/28/2020  03:00 PM         1,270,921 libgdk-3-0.dll
10/28/2020  07:15 PM           165,865 libgdk_pixbuf-2.0-0.dll
06/09/2020  10:47 AM         1,959,290 libgettextlib-0-19-8-1.dll
06/09/2020  10:47 AM           397,451 libgettextpo-0.dll
06/09/2020  10:47 AM           327,176 libgettextsrc-0-19-8-1.dll
10/31/2020  07:18 PM         3,034,732 libgfortran-5.dll
10/24/2020  12:31 PM         1,630,500 libgio-2.0-0.dll
10/24/2020  12:31 PM         1,290,052 libglib-2.0-0.dll
10/24/2020  12:31 PM            23,678 libgmodule-2.0-0.dll
10/12/2020  06:22 AM           509,898 libgmp-10.dll
10/12/2020  06:22 AM            30,240 libgmpxx-4.dll
10/31/2020  07:18 PM           213,007 libgnarl-10.dll
10/31/2020  07:18 PM         3,323,987 libgnat-10.dll
10/24/2020  12:31 PM           315,285 libgobject-2.0-0.dll
10/31/2020  07:18 PM           239,897 libgomp-1.dll
09/10/2020  12:45 AM           154,163 libgraphite2.dll
10/24/2020  12:31 PM            15,015 libgthread-2.0-0.dll
10/28/2020  03:00 PM         7,463,648 libgtk-3-0.dll
10/24/2020  05:20 PM           982,148 libharfbuzz-0.dll
10/24/2020  05:20 PM            86,313 libharfbuzz-gobject-0.dll
10/24/2020  05:20 PM            18,695 libharfbuzz-icu-0.dll
10/24/2020  05:20 PM           692,296 libharfbuzz-subset-0.dll
02/17/2020  12:53 PM            63,488 libhistory8.dll
05/13/2019  06:18 AM         1,055,522 libiconv-2.dll
06/09/2020  10:47 AM           133,659 libintl-8.dll
10/29/2020  06:20 PM           424,507 libjasper-4.dll
06/25/2020  09:05 AM           698,765 libjpeg-8.dll
10/24/2020  05:07 PM           159,325 libjson-glib-1.0-0.dll
03/18/2020  07:19 AM           155,136 liblzma-5.dll
03/02/2017  12:52 PM           143,727 liblzo2-2.dll
07/16/2020  07:31 AM            45,070 libmpdec++-2.dll
07/16/2020  07:31 AM           195,765 libmpdec-2.dll
10/31/2020  07:18 PM           100,855 libobjc-4.dll
10/25/2020  10:33 PM         1,024,639 libp11-kit-0.dll
10/24/2020  06:18 PM           296,574 libpango-1.0-0.dll
10/24/2020  06:18 PM            71,724 libpangocairo-1.0-0.dll
10/24/2020  06:18 PM            93,589 libpangoft2-1.0-0.dll
10/24/2020  06:18 PM            91,527 libpangowin32-1.0-0.dll
03/09/2020  04:26 PM           283,648 libpcre-1.dll
03/09/2020  04:26 PM           253,952 libpcre16-0.dll
03/09/2020  04:26 PM           243,200 libpcre32-0.dll
03/09/2020  04:26 PM            60,416 libpcrecpp-0.dll
03/09/2020  04:26 PM            43,008 libpcreposix-0.dll
10/24/2020  12:15 PM           684,803 libpixman-1-0.dll
04/23/2019  09:24 AM           231,911 libpng16-16.dll
11/03/2020  10:43 PM         2,868,224 libpython3.8.dll
10/31/2020  07:18 PM           381,742 libquadmath-0.dll
02/17/2020  12:53 PM           243,712 libreadline8.dll
11/01/2020  04:34 AM         8,643,235 librsvg-2-2.dll
08/21/2020  07:38 AM         1,623,001 libsqlite3-0.dll
09/22/2020  08:33 PM           579,865 libssl-1_1-x64.dll
10/31/2020  07:18 PM            43,429 libssp-0.dll
10/31/2020  07:18 PM         1,752,711 libstdc++-6.dll
01/17/2018  09:00 AM            18,240 libsystre-0.dll
02/23/2020  11:58 AM           101,888 libtasn1-6.dll
08/04/2020  08:15 AM            45,347 libtermcap-0.dll
11/12/2018  07:46 AM            68,018 libthai-0.dll
11/05/2019  07:15 PM           494,592 libtiff-5.dll
11/05/2019  07:15 PM            19,456 libtiffxx-5.dll
01/17/2018  08:54 AM            92,313 libtre-5.dll
06/25/2020  09:05 AM           813,382 libturbojpeg.dll
10/19/2020  03:56 PM            58,539 libwinpthread-1.dll
06/08/2020  06:43 AM         1,359,534 libxml2-2.dll
10/20/2020  07:35 PM            56,898 libxxhash.dll
05/25/2020  08:27 AM           737,792 libzstd.dll
12/23/2019  10:49 AM         1,632,768 tcl86.dll
09/07/2020  08:21 AM         1,542,435 tk86.dll
05/22/2019  12:06 PM            93,720 zlib1.dll
}}

use v6;
use NativeCall;

#-------------------------------------------------------------------------------
unit module Gnome::N::NativeLib;

#-------------------------------------------------------------------------------
# Libraries begin also with 'lib' on windows.
my Str $lib-prefix;
my Bool $is-windows;
my Bool $has-mingw;

unless $lib-prefix {
  $is-windows = $*DISTRO.is-win;
  $has-mingw = ('C:/msys64/mingw64/bin'.IO.e or 'C:/mingw64/bin'.IO.e);
  $lib-prefix = ( $is-windows and $has-mingw ) ?? 'lib' !! '';
}

#-------------------------------------------------------------------------------
sub lib-name (
  Str $name, Str :$linux-version, Str :$windows-version, Str :$after-so = ''
  --> Str
) {
  my Str $lname;
  if $is-windows {
    $lname = $lib-prefix ~ $*VM.platform-library-name((
        [~] $name, ($windows-version.defined ?? "-$windows-version" !! '')
      ).IO
    ).Str
  }

  else {
    $lname = $*VM.platform-library-name((
        [~] $name, ($linux-version.defined ?? "-$linux-version" !! '')
      ).IO
    ).Str;

    $lname ~= '.' ~ $after-so.Str if ?($after-so.Str);
  }

  $lname
}

#-------------------------------------------------------------------------------
# There are more libname subs defined than is needed for the Gnome packages
# so most of them are inhibited until they are needed.

#`{{
# used for Gnome::Atk
sub atk-lib ( --> Str ) is export {
  state Str $lib = lib-name( 'atk', '1.0', 0);
  $lib
}
}}

sub cairo-lib ( --> Str ) is export {
  state Str $lib = lib-name(
    'cairo', :windows-version<2>, :after-so<2>);
  $lib
}

#`{{
sub cairo-gobject-lib ( --> Str ) is export {
  state Str $lib = lib-name( 'cairo-gobject', 2);
  $lib
}

sub ffi-lib ( --> Str ) is expor {
  state Str $lib = lib-name( 'ffi', 7);
  $lib
}

sub fontconfig-lib ( --> Str ) is expor {
  state Str $lib = lib-name( 'fontconfig', 1);
  $lib
}

sub freetype-lib ( --> Str ) is expor {
  state Str $lib = lib-name( 'freetype', 6);
  $lib
}
}}

sub gdk-lib ( --> Str ) is export {
  state Str $lib = lib-name( 'gdk', :windows-version<3-0>, :linux-version<3>);
  $lib
}

sub gdk-pixbuf-lib ( --> Str ) is export {
  state Str $lib = lib-name(
    'gdk_pixbuf', :windows-version<2.0-0>, :linux-version<2.0>
  );
  $lib
}

sub gio-lib ( --> Str ) is export {
  state Str $lib = lib-name(
    'gio', :windows-version<2.0-0>, :linux-version<2.0>
  );
  $lib
}

sub glib-lib ( --> Str ) is export {
  state Str $lib = lib-name(
    'glib', :windows-version<2.0-0>, :linux-version<2.0>
  );
  $lib
}

sub gobject-lib ( --> Str ) is export {
  state Str $lib = lib-name(
    'gobject', :windows-version<2.0-0>, :linux-version<2.0>
  );
  $lib
}

#`{{
sub gmodule-lib ( --> Str ) is export {
  state Str $lib = lib-name( 'gmodule', '2.0', 0);
  $lib
}
}}

sub gtk-lib ( --> Str ) is export {
  state Str $lib = lib-name( 'gtk', :windows-version<3-0>, :linux-version<3>);
  $lib
}

#`{{
sub iconv-lib {
  state Str $lib = lib-name( 'iconv', 2);
  $lib
}

sub intl-lib {
  state Str $lib = lib-name( 'intl', 8);
  $lib
}

sub jpeg-lib ( --> Str ) is export {
  state Str $lib = lib-name( 'jpeg', 8);
  $lib
}

sub lzma-lib {
  state Str $lib = lib-name( 'lzma', 5);
  $lib
}
}}

sub pango-lib ( --> Str ) is export {
  state Str $lib = lib-name(
    'pango', :windows-version<1.0-0>, :linux-version<1.0>
  );
  $lib
}

#`{{
sub pangocairo-lib ( --> Str ) is export {
  state Str $lib = lib-name( 'pangocairo', '1.0', 0);
  $lib
}

sub pangoft2-lib ( --> Str ) is export {
  state Str $lib = lib-name( 'pangoft2', '1.0', 0);
  $lib
}

sub pangowin32-lib ( --> Str ) is export {
  state Str $lib = lib-name( 'pangowin32', '1.0', 0);
  $lib
}

sub pixman-lib ( --> Str ) is export {
  state Str $lib = lib-name( 'pixman', 1, 0);
  $lib
}

sub png-lib ( --> Str ) is export {
  state Str $lib = lib-name( 'png16', 16);
  $lib
}

sub xml-lib ( --> Str ) is export {
  state Str $lib = lib-name( 'xml2', 2);
  $lib
}
}}


=finish


sub atk-lib {
    state $lib;
    unless $lib {
        $lib = find-bundled('libatk-1.0-0.dll');
    }
    $lib
}

sub cairo-gobject-lib {
    state $lib;
    unless $lib {
        try load-cairo-lib;
        try load-glib-lib;
        try load-gobject-lib;
        $lib = find-bundled('libcairo-gobject-2.dll');
    }
    $lib
}

sub cairo-lib is export {
    state $lib;
    unless $lib {
        if $*VM.config<dll> ~~ /dll/ {
#          try load-fontconfig-lib;
#          try load-freetype-lib;
#          try load-pixman-lib;
#          try load-png-lib;
#          try load-zlib-lib;
#          $lib = find-bundled('libcairo-2.dll');
          $lib = $*VM.platform-library-name('cairo-2'.IO).Str;
        } else {
          $lib = $*VM.platform-library-name('cairo'.IO).Str;
        }
    }
    $lib
}

#`{{
sub gdk-pixbuf-lib {
    state $lib;
    unless $lib {
        try load-gio-lib;
        try load-glib-lib;
        try load-gmodule-lib;
        try load-gobject-lib;
        try load-intl-lib;
        try load-png-lib;
        $lib = find-bundled('libgdk_pixbuf-2.0-0.dll');
    }
    $lib
}
}}
#`{{
sub gio-lib {
    state $lib;
    unless $lib {
        try load-glib-lib;
        try load-gmodule-lib;
        try load-gobject-lib;
        try load-intl-lib;
        try load-zlib-lib;
        $lib = find-bundled('libgio-2.0-0.dll');
    }
    $lib
}
}}

sub gmodule-lib {
    state $lib;
    unless $lib {
        $lib = find-bundled('libgmodule-2.0-0.dll');
    }
    $lib
}
sub intl-lib {
    state $lib;
    unless $lib {
        $lib = find-bundled('libintl-8.dll');
    }
    $lib
}
#`{{
sub pango-lib {
    state $lib;
    unless $lib {
        $lib = find-bundled('libpango-1.0-0.dll');
    }
    $lib
}
}}
sub pangocairo-lib {
    state $lib;
    unless $lib {
        try load-pango-lib;
        try load-pangoft2-lib;
        try load-pangowin32-lib;
        try load-cairo-lib;
        try load-fontconfig-lib;
        try load-freetype-lib;
        try load-glib-lib;
        try load-gobject-lib;
        $lib = find-bundled('libpangocairo-1.0-0.dll');
    }
    $lib
}
sub pangowin32-lib {
    state $lib;
    unless $lib {
        $lib = find-bundled('libpangowin32-1.0-0.dll');
    }
    $lib
}
sub fontconfig-lib {
    state $lib;
    unless $lib {
        try load-freetype-lib;
        try load-xml-lib;
        $lib = find-bundled('libfontconfig-1.dll');
    }
    $lib
}
sub freetype-lib {
    state $lib;
    unless $lib {
        try load-zlib-lib;
        $lib = find-bundled('libfreetype-6.dll');
    }
    $lib
}
sub pixman-lib {
    state $lib;
    unless $lib {
        $lib = find-bundled('libpixman-1-0.dll');
    }
    $lib
}
sub png-lib {
    state $lib;
    unless $lib {
        $lib = find-bundled('libpng15-15.dll');
    }
    $lib
}
sub zlib-lib {
    state $lib;
    unless $lib {
        $lib = find-bundled('zlib1.dll');
    }
    $lib
}
sub xml-lib {
    state $lib;
    unless $lib {
        try load-iconv-lib;
        try load-lzma-lib;
        $lib = find-bundled('libxml2-2.dll');
    }
    $lib
}
sub iconv-lib {
    state $lib;
    unless $lib {
        $lib = find-bundled('libiconv-2.dll');
    }
    $lib
}
sub lzma-lib {
    state $lib;
    unless $lib {
        $lib = find-bundled('liblzma-5.dll');
    }
    $lib
}
sub ffi-lib {
    state $lib;
    unless $lib {
        $lib = find-bundled('libffi-6.dll');
    }
    $lib
}
sub pangoft2-lib {
    state $lib;
    unless $lib {
        $lib = find-bundled('libpangoft2-1.0-0.dll');
    }
    $lib
}

sub gtk-lib is export {
    state $lib;
    unless $lib {
        if $*VM.config<dll> ~~ /dll/ {
            try load-gdk-lib;
            try load-atk-lib;
            try load-cairo-gobject-lib;
            try load-cairo-lib;
            try load-gdk-pixbuf-lib;
            try load-gio-lib;
            try load-glib-lib;
            try load-gmodule-lib;
            try load-gobject-lib;
            try load-intl-lib;
            try load-pango-lib;
            try load-pangocairo-lib;
            try load-pangowin32-lib;
            $lib = find-bundled('libgtk-3-0.dll');
        } else {
            $lib = $*VM.platform-library-name('gtk-3'.IO).Str;
        }
    }
    $lib
}

sub gdk-lib is export {
    state $lib;
    unless $lib {
        if $*VM.config<dll> ~~ /dll/ {
            try load-cairo-gobject-lib;
            try load-cairo-lib;
            try load-gdk-pixbuf-lib;
            try load-gio-lib;
            try load-glib-lib;
            try load-gobject-lib;
            try load-intl-lib;
            try load-pango-lib;
            try load-pangocairo-lib;
            $lib = find-bundled('libgdk-3-0.dll');
        } else {
            $lib = $*VM.platform-library-name('gdk-3'.IO).Str;
        }
    }
    $lib
}

sub gdk-pixbuf-lib is export {
    state $lib;
    unless $lib {
        if $*VM.config<dll> ~~ /dll/ {
            try load-gio-lib;
            try load-glib-lib;
            try load-gmodule-lib;
            try load-gobject-lib;
            try load-intl-lib;
            try load-png-lib;
            $lib = find-bundled('libgdk_pixbuf-2.0-0.dll');
        } else {
          $lib = $*VM.platform-library-name('gdk_pixbuf-2.0'.IO).Str;
        }
    }
    $lib
}

sub glib-lib is export {
    state $lib;
    unless $lib {
        if $*VM.config<dll> ~~ /dll/ {
            try load-intl-lib;
            $lib = find-bundled('libglib-2.0-0.dll');
        } else {
            $lib = $*VM.platform-library-name('glib-2.0'.IO).Str;
        }
    }
    $lib
}

sub gobject-lib is export {
    state $lib;
    unless $lib {
        if $*VM.config<dll> ~~ /dll/ {
            try load-glib-lib;
            try load-ffi-lib;
            $lib = find-bundled('libgobject-2.0-0.dll');
        } else {
            $lib = $*VM.platform-library-name('gobject-2.0'.IO).Str;
        }
    }
    $lib
}


sub glib-lib is export {
    state $lib;
    unless $lib {
        if $*VM.config<dll> ~~ /dll/ {
            $lib = $*VM.platform-library-name('glib-2.0'.IO).Str;
        } else {
            $lib = $*VM.platform-library-name('glib-2.0'.IO).Str;
        }
    }
    $lib
}

sub gtk-lib is export {
    state $lib;
    unless $lib {
        if $*VM.config<dll> ~~ /dll/ {
            $lib = $*VM.platform-library-name('gtk-3'.IO).Str;
        } else {
            $lib = $*VM.platform-library-name('gtk-3'.IO).Str;
        }
    }
    $lib
}

sub pango-lib is export {
  state $lib;
  unless $lib {
    if $*VM.config<dll> ~~ /dll/ {
      $lib = find-bundled('libpango-1.0-0.dll');
    } else {
      $lib = $*VM.platform-library-name('pango-1.0'.IO).Str;
    }
  }
  $lib
}

sub gdk-lib is export {
    state $lib;
    unless $lib {
        if $*VM.config<dll> ~~ /dll/ {
            $lib = $*VM.platform-library-name('gdk-3'.IO).Str;
        } else {
            $lib = $*VM.platform-library-name('gdk-3'.IO).Str;
        }
    }
    $lib
}

sub gdk-pixbuf-lib is export {
    state $lib;
    unless $lib {
        if $*VM.config<dll> ~~ /dll/ {
            $lib = $*VM.platform-library-name('gdk_pixbuf-2'.IO).Str;
        } else {
          $lib = $*VM.platform-library-name('gdk_pixbuf-2.0'.IO).Str;
        }
    }
    $lib
}


sub find-bundled($lib is copy) {
#`{{
    # if we can't find one, assume there's a system install
    my $base = "blib/lib/GTK/$lib";

    if my $file = %?RESOURCES{$base} {
            $file.IO.copy($*SPEC.tmpdir ~ '\\' ~ $lib);
            $lib = $*SPEC.tmpdir ~ '\\' ~ $lib;
    }
}}
    $lib;
}

sub load-gdk-lib is native(&gdk-lib) { ... }
sub load-atk-lib is native(&atk-lib) { ... }
sub load-cairo-gobject-lib is native(&cairo-gobject-lib) { ... }
sub load-cairo-lib is native(&cairo-lib) { ... }
sub load-gdk-pixbuf-lib is native(&gdk-pixbuf-lib) { ... }
sub load-gio-lib is native(&gio-lib) { ... }
sub load-glib-lib is native(&glib-lib) { ... }
sub load-gmodule-lib is native(&gmodule-lib) { ... }
sub load-gobject-lib is native(&gobject-lib) { ... }
sub load-intl-lib is native(&intl-lib) { ... }
sub load-pango-lib is native(&pango-lib) { ... }
sub load-pangocairo-lib is native(&pangocairo-lib) { ... }
sub load-pangowin32-lib is native(&pangowin32-lib) { ... }
sub load-fontconfig-lib is native(&fontconfig-lib) { ... }
sub load-freetype-lib is native(&freetype-lib) { ... }
sub load-pixman-lib is native(&pixman-lib) { ... }
sub load-png-lib is native(&png-lib) { ... }
sub load-zlib-lib is native(&zlib-lib) { ... }
sub load-xml-lib is native(&xml-lib) { ... }
sub load-iconv-lib is native(&iconv-lib) { ... }
sub load-lzma-lib is native(&lzma-lib) { ... }
sub load-ffi-lib is native(&ffi-lib) { ... }
sub load-pangoft2-lib is native(&pangoft2-lib) { ... }
