use v6;
use NativeCall;
use Test;

use Gnome::Gtk3::Label;
use Gnome::Gtk3::Button;
use Gnome::Gtk3::HeaderBar;

#use Gnome::N::X;
#Gnome::N::debug(:on);

#-------------------------------------------------------------------------------
my Gnome::Gtk3::HeaderBar $hb;
#-------------------------------------------------------------------------------
subtest 'ISA test', {
  $hb .= new;
  isa-ok $hb, Gnome::Gtk3::HeaderBar, '.new()';
}


#-------------------------------------------------------------------------------
# set environment variable 'raku-test-all' if rest must be tested too.
unless %*ENV<raku_test_all>:exists {
  done-testing;
  exit;
}

#-------------------------------------------------------------------------------
subtest 'Manipulations', {
  my Gnome::Gtk3::Label $l .= new(:text('My Title'));
  $hb.set-custom-title($l);
  is $hb.get-custom-title-rk.get-text, 'My Title',
      '.set-custom-title() / .get-custom-title()';

  $hb.set-decoration-layout('menu:minimize');
  is $hb.get-decoration-layout, 'menu:minimize',
      '.set-decoration-layout() / .get-decoration-layout()';

  $hb.set-has-subtitle(True);
  ok $hb.get-has-subtitle, '.set-has-subtitle() / .get-has-subtitle()';

  $hb.set-show-close-button(True);
  ok $hb.get-show-close-button,
      '.set-show-close-button() / .get-show-close-button()';

  $hb.set-title('Title');
  is $hb.get-title, 'Title', '.set-title() / .get-title()';

  $hb.set-subtitle('And SubTitle');
  is $hb.get-subtitle, 'And SubTitle', '.set-subtitle() / .get-subtitle()';

  lives-ok {
    $hb.pack-start(Gnome::Gtk3::Button.new(:label<Start>));
    $hb.pack-end(Gnome::Gtk3::Button.new(:label<Stopt>));
  }, '.pack-start() / .pack-end()';
}

#-------------------------------------------------------------------------------
subtest 'Inherit Gnome::Gtk3::HeaderBar', {
  class MyClass is Gnome::Gtk3::HeaderBar {
    method new ( |c ) {
      self.bless( :GtkHeaderBar, |c);
    }

    submethod BUILD ( *%options ) {

    }
  }

  my MyClass $mgc .= new;
  isa-ok $mgc, Gnome::Gtk3::HeaderBar, 'MyClass.new()';
}

#-------------------------------------------------------------------------------
subtest 'Properties ...', {
  use Gnome::GObject::Value;
  use Gnome::GObject::Type;

  #my Gnome::Gtk3::HeaderBar $hb .= new;

  sub test-property (
    $type, Str $prop, Str $routine, $value,
    Bool :$approx = False, Bool :$is-local = False
  ) {
    my Gnome::GObject::Value $gv .= new(:init($type));
    $hb.get-property( $prop, $gv);
    my $gv-value = $gv."$routine"();
    if $approx {
      is-approx $gv-value, $value,
        "property $prop, value: " ~ $gv-value;
    }

    # dependency on local settings might result in different values
    elsif $is-local {
      if $gv-value ~~ /$value/ {
        like $gv-value, /$value/, "property $prop, value: " ~ $gv-value;
      }

      else {
        ok 1, "property $prop, value: " ~ $gv-value;
      }
    }

    else {
      is $gv-value, $value,
        "property $prop, value: " ~ $gv-value;
    }
    $gv.clear-object;
  }

  test-property(
    G_TYPE_STRING, 'decoration-layout', 'get-string', 'menu:minimize'
  );
  test-property( G_TYPE_BOOLEAN, 'decoration-layout-set', 'get-boolean', True);
  test-property( G_TYPE_BOOLEAN, 'has-subtitle', 'get-boolean', True);
  test-property( G_TYPE_BOOLEAN, 'show-close-button', 'get-boolean', True);
  test-property( G_TYPE_INT, 'spacing', 'get-int', 6, :is-local);
  test-property( G_TYPE_STRING, 'title', 'get-string', 'Title');
  test-property( G_TYPE_STRING, 'subtitle', 'get-string', 'And SubTitle');

  # example calls
  #test-property( G_TYPE_BOOLEAN, 'homogeneous', 'get-boolean', False);
  #test-property( G_TYPE_STRING, 'label', 'get-string', '...');
  #test-property( G_TYPE_FLOAT, 'xalign', 'get-float', 23e-2, :approx);
}

#-------------------------------------------------------------------------------
done-testing;

=finish

#-------------------------------------------------------------------------------
subtest 'Themes ...', {
}

#-------------------------------------------------------------------------------
subtest 'Signals ...', {
  use Gnome::Gtk3::Main;
  use Gnome::N::GlibToRakuTypes;

  my Gnome::Gtk3::Main $main .= new;

  class SignalHandlers {
    has Bool $!signal-processed = False;

    method ... (
      'any-args',
      Gnome::Gtk3::HeaderBar :$_widget, gulong :$_handler-id
      # --> ...
    ) {

      isa-ok $_widget, Gnome::Gtk3::HeaderBar;
      $!signal-processed = True;
    }

    method signal-emitter ( Gnome::Gtk3::HeaderBar :$widget --> Str ) {

      while $main.gtk-events-pending() { $main.iteration-do(False); }

      $widget.emit-by-name(
        'signal',
      #  'any-args',
      #  :return-type(int32),
      #  :parameters([int32,])
      );
      is $!signal-processed, True, '\'...\' signal processed';

      while $main.gtk-events-pending() { $main.iteration-do(False); }

      #$!signal-processed = False;
      #$widget.emit-by-name(
      #  'signal',
      #  'any-args',
      #  :return-type(int32),
      #  :parameters([int32,])
      #);
      #is $!signal-processed, True, '\'...\' signal processed';

      while $main.gtk-events-pending() { $main.iteration-do(False); }
      sleep(0.4);
      $main.gtk-main-quit;

      'done'
    }
  }

  my Gnome::Gtk3::HeaderBar $hb .= new;

  #my Gnome::Gtk3::Window $w .= new;
  #$w.add($m);

  my SignalHandlers $sh .= new;
  $hb.register-signal( $sh, 'method', 'signal');

  my Promise $p = $hb.start-thread(
    $sh, 'signal-emitter',
    # :!new-context,
    # :start-time(now + 1)
  );

  is $main.gtk-main-level, 0, "loop level 0";
  $main.gtk-main;
  #is $main.gtk-main-level, 0, "loop level is 0 again";

  is $p.result, 'done', 'emitter finished';
}
