use v6;
use TMap::Topic;

package TMap:ver<0.2.0> {

  role Reifiable {
    has $.reifier;

    #---------------------------------------------------------------------------
    #
    method set-reifier(
      $tm where $tm.name ~~ any(<topic topicMap>) = self
    ) {
      if ?self.attribs<reifier> {
        my $topic-ref = self.modify-topic-reference( self.get('filename'),
                                                     self.attribs<reifier>
                                                   );
        $!reifier = $tm.get-topic-from-id($topic-ref);
say "Topic ", $!reifier.attribs<id>, " represents ", self.name if ?$!reifier;
      }
    }

    #---------------------------------------------------------------------------
    #
    # Some getters
    #
    multi method get ( 'reifier' ) { return $!reifier; }
  }
}
