use v6;
use OWL::ClassAxiom;
use OWL::ClassExpression;
use OWL::IRI;

package OWL {

  class SubClassOf is OWL::ClassAxiom {

    has OWL::ClassExpression $.sub-class-expression;
    has OWL::ClassExpression $.super-class-expression;

    #---------------------------------------------------------------------------
    #
    method set ( OWL::IRI $super-class, OWL::IRI $sub-class ) {
      $!sub-class-expression .= new(:iri($sub-class));
      $!super-class-expression .= new(:iri($super-class));

      self.set-type('sub-class-of');
    }

    #---------------------------------------------------------------------------
    #
#    multi method get-iri1 (  ) { return $!sub-class-expression.get-iri; }
#    multi method get-iri2 (  ) { return $!super-class-expression.get-iri; }
  }
}
