package Perl::Critic::Itch;

use warnings;
use strict;

=head1 NAME

Perl::Critic::Itch - A collection of Perl::Critic policies that causes me Itch

=head1 VERSION

Version 1.0

=cut

our $VERSION = '1.0';

=head1 SYNOPSIS

Perl::Critic::Itch - A remedy for some stuff that causes me Itches

=head1 DESCRIPTION

For now, there's only one rule included in Perl::Critic::Itch:

=head2 L<Perl::Critic::Policy::CodeLayout::ProhibitHashBarewords>

Commented-out code is usually noise.  It should be removed.


=head1 AUTHOR

Marcelo, C<< <marcelo at cpan.org> >>

=head1 BUGS

Please report any bugs or feature requests to
C<bug-perl-critic-itch at rt.cpan.org>, or through the web interface at
L<http://rt.cpan.org/NoAuth/ReportBug.html?Queue=Perl-Critic-Itchs>.

=head1 SUPPORT

You can find documentation for this module with the perldoc command.

    perldoc Perl::Critic::Itch

=head1 COPYRIGHT

This library is free software; you can redistribute it and/or modify
it under the terms of either the GNU Public License v3, or the Artistic
License 2.0.

    * http://www.gnu.org/copyleft/gpl.html

    * http://www.opensource.org/licenses/artistic-license-2.0.php

=cut

1; 
