/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server.htmlrunner;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.openqa.selenium.server.SeleniumCommandTimedOutException;
import org.openqa.selenium.server.SeleniumServer;
import org.openqa.selenium.server.browserlaunchers.AsyncExecute;
import org.openqa.selenium.server.browserlaunchers.BrowserLauncher;
import org.openqa.selenium.server.browserlaunchers.BrowserLauncherFactory;
import org.openqa.selenium.server.htmlrunner.HTMLResultsListener;
import org.openqa.selenium.server.htmlrunner.HTMLTestResults;

public class HTMLLauncher
implements HTMLResultsListener {
    private SeleniumServer server;
    private HTMLTestResults results;

    public HTMLLauncher(SeleniumServer server) {
        this.server = server;
    }

    public String runHTMLSuite(String browser, String browserURL, String HTMLSuite, File outputFile, long timeout) throws IOException {
        this.server.handleHTMLRunnerResults(this);
        BrowserLauncherFactory blf = new BrowserLauncherFactory(this.server);
        String sessionId = Long.toString(System.currentTimeMillis());
        BrowserLauncher launcher = blf.getBrowserLauncher(browser, sessionId);
        launcher.launchHTMLSuite(HTMLSuite, browserURL);
        long now = System.currentTimeMillis();
        long end = now + timeout * 1000L;
        while (this.results == null && System.currentTimeMillis() < end) {
            AsyncExecute.sleepTight(500L);
        }
        launcher.close();
        if (this.results == null) {
            throw new SeleniumCommandTimedOutException();
        }
        if (outputFile != null) {
            FileWriter fw = new FileWriter(outputFile);
            this.results.write(fw);
            fw.close();
        }
        return this.results.getResult().toUpperCase();
    }

    public void processResults(HTMLTestResults resultsParm) {
        this.results = resultsParm;
    }
}

