# Copyright: 2001-2003 The Perl Foundation.  All Rights Reserved.
# $Id: revision_c.pl 10933 2006-01-06 01:43:24Z particle $

=head1 NAME

tools/build/revision_c.pl

=head1 DESCRIPTION

Creates F<src/revision.c> with current rev number taken from
F<.svn/entries> or F<.svk/entries> and config rev number of last
Parrot configure run.

=head1 SEE ALSO

F<config/gen/revision.pl>,
F<lib/Parrot/Revision.pm>,
F<include/parrot/config.h>

=cut

use strict;
use Parrot::Revision;

print <<"EOF";
/*
 * !!!!!!!   DO NOT EDIT THIS FILE   !!!!!!!
 *
 * This file is generated automatically by $0.
 *
 * Any changes made here will be lost!
 *
 */

#include "parrot/config.h"

/* also in "parrot/embed.h" */
int Parrot_revision(void);
/* also in "parrot/misc.h" */
int Parrot_config_revision(void);

int Parrot_revision(void)
{
    return ${Parrot::Revision::current};
}

int Parrot_config_revision(void)
{
    return ${Parrot::Revision::config};
}

EOF
