use v5.12;
use warnings;

use Data::Dump;

use Data::DPath 'dpath';
my $data  = {
             AAA  => { BBB => { CCC  => [ qw/ XXX YYY ZZZ / ] },
                       RRR => { CCC  => [ qw/ RR1 RR2 RR3 / ] },
                       DDD => { EEE  => [ qw/ uuu vvv www / ] },
                     },
            };

my @examples =(
     # [ '/AAA/*/CCC',                 =>  q( ) ],
     # [ '/AAA/BBB/CCC/../..',         =>  q( parents  (..)                     ) ],
     # [ '//AAA',                      =>  q( anywhere (//)                     ) ],
     # [ '//AAA/*',                    =>  q( anywhere + anystep                ) ],
     # [ '//AAA/*[size == 3]',         =>  q( filter by arrays/hash size        ) ],
     # [ '//AAA/*/*/[size == 3]',         =>  q( filter by arrays/hash size        ) ],
     # [ '//AAA/*[size != 3]',         =>  q( filter by arrays/hash size        ) ],
     # [ '/"EE/E"/CCC',                =>  q( quote strange keys                ) ],
     # [ '/AAA/BBB/CCC/*[1]',          =>  q( filter by array index             ) ],
     # [ '/AAA/BBB/CCC/*[ idx == 1 ]', =>  q( same, filter by array index  ) ],
     # [ '//AAA/BBB/*[key eq "CCC"]',  =>  q( filter by exact keys         ) ],
     [ '//AAA/*/*[key eq "CCC"]/[ value eq "RR2" ]/../..',  =>  q( filter by exact keys         ) ],
     # [ '//AAA/*[ key =~ /CC/ ]',     =>  q( filter by regex matching keys) ],
     # [ '//CCC/*[ value eq "RR2" ]',  =>  q( filter by values of hashes) ],
   );



for my $ex (@examples){
    my ($path,$comment) = @$ex;
    my @resultlist = dpath($path)->match($data);
    dd "#### $comment","$path",\@resultlist;
}

# ddx my $path = '//AAA/*/CCC/*[1]';
# ddx my @resultlist = dpath($path)->match($data); 

# Perl 5.10 style using overloaded smartmatch operator
#my $resultlist = $data ~~ dpath '/AAA/*/CCC';        # [ ['XXX', 'YYY', 'ZZZ'], [ 'RR1', 'RR2', 'RR3' ] ]
