#!/usr/bin/env perl
# AP-Client: CLI-based client / toolbox for ActivityPub
# Copyright © 2020-2023 AP-Client Authors <https://hacktivis.me/git/ap-client/>
# SPDX-License-Identifier: BSD-3-Clause
use strict;
use utf8;

use Test::More tests => 1;
use Test::Output;

use JSON;
use ActivityPub::PrettyPrint qw(print_object);

# Read whole files
undef $/;

open(USER_JSON, '<', 't/pleroma_user.json') or die "$!";
open(USER_TXT,  '<', 't/pleroma_user.out')  or die "$!";

my $object = decode_json(<USER_JSON>);

output_is(sub { print_object($object) }, <USER_TXT>, '', 'Test printing pleroma user');

close(USER_JSON);
close(USER_TXT);
