package Log::Funlog::Lang;

=head1 NAME

Log::Funlog::Lang - Language pack for Log::Funlog

=head1 SYNOPSIS

 use Log::Funlog::Lang;
 my @text=Log::Funlog::Lang->new( language );

=head1 DESCRIPTION

This is a perl module used by B<Log::Funlog> to obtain a list of funny things in the language of the user.

=head1 OPTIONS

B<Log::Funlog::Lang> try to determinate the language of the user by parsing LC_MESSAGES and LANG. If it doesn't find any infos in these environment variable, it dies.

If it occurs, you must specify the language by the widely used two letters (fr, en, ...)

=over

=item B<language>

Two-letters code specifying language to use.

Available languages are: fr, en

Default to 'en'.

=back

=head1 AUTHOR

Gabriel Guillon, from Chashew team

korsani-spam@free-spam.fr-spam

(remove you-know-what :)

=head1 LICENCE

As Perl itself.

Let me know if you have added some features, or removed some bugs ;)

=cut

BEGIN {
	use Exporter;
	@ISA=qw(Exporter);
	@EXPORT=qw();
	$VERSION='0.2';
}
use strict;
use Carp;
my @fun;
sub new {
	shift;
	my $LC_MESSAGES=lc(shift);
	if (! $LC_MESSAGES) {
		if (exists $ENV{'LC_MESSAGES'}) {
			$LC_MESSAGES=substr($ENV{'LC_MESSAGES'},0,2);
		} elsif (exists $ENV{'LANG'}) {
			$LC_MESSAGES=substr($ENV{'LANG'},0,2);
		} else {
			$LC_MESSAGES='en';
		}
	}
	$LC_MESSAGES=lc($LC_MESSAGES);
	if ($LC_MESSAGES eq 'fr' ) {
		@fun=(
			"-- this line will never be written --",
			"Pfiou... marre de logger, moi",
			"J'ai faim!",
			"Je veux faire pipi!",
			"Dis, t'as pens  manger?",
			"Fait froid dans ce process, non?",
			"Fait quel temps, dehors?",
			"Aller, pastis time!",
			"Je crois que je suis malade...",
			"Dis, tu peux me choper un sandwich?",
			"On se fait une toile?",
			"Aller, dcolle un peu de l'cran",
			"Tu fais quoi ce soir, toi?",
			"On va en bote?",
			"Pousse-toi un peu, je vois rien",
			"Vivement les vacances...",
			"Mince, j'ai pas prvenu ma femme que je finissais tard...",
			"Il est chouette ton projet?",
			"Bon, il est bientt fini, ce process??",
			"Je m'ennuie...",
			"Tu peux me mettre la tl?",
			"Y a quoi ce soir?",
			"J'irais bien faire un tour  Pigalle, moi.",
			"Et si je formattais le disque?",
			"J'me ferais bien le tour du monde...",
			"Je crois que je suis homosexuel...",
			"Bon, je m'en vais, j'ai des choses  faire.",
			"Et si je changeais de taf? OS, c'est mieux que script, non?",
			"J'ai froid!",
			"J'ai chaud!",
			"Tu me prend un caf?",
			"T'es plutt chien ou chat, toi?",
			"Je crois que je vais aller voir un psy...",
			"Tiens, 'longtemps que j'ai pas eu de news de ma soeur!",
			"Comment vont tes parents?",
			"Comment va Arthur, ton poisson rouge?",
			"Ton chien a fini de bouffer les rideaux?",
			"Ton chat pisse encore partout?",
			"Tu sais ce que fait ta fille, l?",
			"T'as pas encore claqu ton chef?",
			"Toi, tu t'es engueul avec ta femme, ce matin...",
			"T'as les yeux en forme de contener. Soucis?",
			"Et si je partais en boucle infinie?",
			"T'es venu  pied?",
			"Et si je veux pas excuter la prochaine commande?",
			"Tiens, je vais me transformer en virus...",
			"Ca t'en bouche un coin, un script qui parle, hein?",
			"Ah m...., j'ai oubli les cls  l'intrieur de la voiture...",
			"T'as pas autre chose  faire, l?",
			"Ca devient relou...",
			"T'as pens  aller voir un psy?",
			"Toi, tu pense  changer de job..."
		)
	} elsif ($LC_MESSAGES eq 'en') {
		@fun=(
			"-- this line will never be written --",
			"(scratch scratch ...)",
			"TOOOOO!!!! A DONUT !!!"
		)
	} else {
		croak("You specified a not implemented language: $LC_MESSAGES");
	};
	return @fun;
}
1;
