=head1 NAME

SPVM::Document::Modules - SPVM Standard Modules

=head1 Description

The list of SPVM Standard Modules.

=head1 Standard Modules

=over 2

=item * L<Fn|SPVM::Fn> - Standard Functions

=item * L<Byte|SPVM::Byte> - byte Object

=item * L<ByteList|SPVM::ByteList> - Dynamic byte Array

=item * L<Cloner|SPVM::Cloner> - Interface Type for the Callback to Clone a Object

=item * L<Cloneable|SPVM::Cloneable> - Interface Type to Clone a Object

=item * L<Comparator::Byte|SPVM::Comparator::Byte> - Interface Type for byte Comparation Callback

=item * L<Comparator::Short|SPVM::Comparator::Short> - Interface Type for short Comparation Callback

=item * L<Comparator::Int|SPVM::Comparator::Int> - Interface Type for int Comparation Callback

=item * L<Comparator::Long|SPVM::Comparator::Long> - Interface Type for long Comparation Callback

=item * L<Comparator::Float|SPVM::Comparator::Float> - Interface Type for float Comparation Callback

=item * L<Comparator::Double|SPVM::Comparator::Double> - Interface Type for double Comparation Callback

=item * L<Comparator::String|SPVM::Comparator::String> - Interface Type for string Comparation Callback

=item * L<Comparator|SPVM::Comparator> - Interface Type for object Comparation Callback

=item * L<Complex_2d|SPVM::Complex_2d> - double Complex Type

=item * L<Complex_2f|SPVM::Complex_2f> - float Complex Type

=item * L<Double|SPVM::Double> - double Object

=item * L<DoubleList|SPVM::DoubleList> - Dynamic double Array

=item * L<EqualityChecker|SPVM::EqualityChecker> - Interface Type for Object Equality Checking Callback

=item * L<EqualityChecker::SameObject|SPVM::EqualityChecker::SameObject> - A Implementation of L<EqualityChecker|SPVM::EqualityChecker> to Check if the Memory Addresses of the Two Objects are Equal.

=item * L<Float|SPVM::Float> - float Object

=item * L<FloatList|SPVM::FloatList> - Dynamic float Array

=item * L<Hash|SPVM::Hash> - Hash Data Structure

=item * L<Hash::Entry|SPVM::Hash::Entry> - Hash Entry

=item * L<Int|SPVM::Int> - int Object

=item * L<IntList|SPVM::IntList> - Dynamic int Array

=item * L<List|SPVM::List> - Dynamic Object Array

=item * L<Long|SPVM::Long> - long Object

=item * L<LongList|SPVM::LongList> - Dynamic long Array

=item * L<Short|SPVM::Short> - short Object

=item * L<ShortList|SPVM::ShortList> - Dynamic short Array

=item * L<StringBuffer|SPVM::StringBuffer> - String Buffer

=item * L<Stringable|SPVM::Stringable> - Interface Type to Stringify a Object

=item * L<Stringer|SPVM::Stringer> - Interface Type for Stringing Callback

=item * L<StringList|SPVM::StringList> - Dynamic string Array

=item * L<Time|SPVM::Time> - Time Manipulation

=item * L<Time::Info|SPVM::Time::Info> - Time Information

=back

=head1 CPAN Modules

The list of some CPAN modules.

=over 2

=item * L<JSON|SPVM::JSON> - JSON

=item * L<Math|SPVM::Math> - Math functions

=item * L<Regex|SPVM::Regex> - Regular Expression

=item * L<Unicode|SPVM::Unicode> - Unicode Utilities

=item * L<Base64|SPVM::Base64> - Base 64

=back

=head2 Resource Modules

See L<SPVM::Document::Resource|/"Resource Modules">.
