#ifndef SPVM_CSOURCE_BUILDER_PRECOMPILE_H
#define SPVM_CSOURCE_BUILDER_PRECOMPILE_H
#include <spvm_native.h>

#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <inttypes.h>
#define SPVM_RUNTIME_API_GET_OBJECT_NO_WEAKEN_ADDRESS(object) ((void*)((intptr_t)object & ~(intptr_t)1))
#define SPVM_RUNTIME_API_GET_REF_COUNT(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset)))
#define SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset))++)
#define SPVM_RUNTIME_API_INC_REF_COUNT(object)\
do {\
  if (object != NULL) {\
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object);\
  }\
} while (0)\

#define SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset))--)
#define SPVM_RUNTIME_API_DEC_REF_COUNT(object)\
do {\
  if (object != NULL) {\
    if (SPVM_RUNTIME_API_GET_REF_COUNT(object) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(object); }\
    else { env->dec_ref_count(env, object); }\
  }\
} while (0)\

#define SPVM_RUNTIME_API_ISWEAK(dist_address) (((intptr_t)*(void**)dist_address) & 1)

#define SPVM_RUNTIME_API_OBJECT_ASSIGN(dist_address, src_object) \
do {\
  void* tmp_object = SPVM_RUNTIME_API_GET_OBJECT_NO_WEAKEN_ADDRESS(src_object);\
  if (tmp_object != NULL) {\
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(tmp_object);\
  }\
  if (*(void**)(dist_address) != NULL) {\
    if (__builtin_expect(SPVM_RUNTIME_API_ISWEAK(dist_address), 0)) { env->unweaken(env, dist_address); }\
    if (SPVM_RUNTIME_API_GET_REF_COUNT(*(void**)(dist_address)) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*(void**)(dist_address)); }\
    else { env->dec_ref_count(env, *(void**)(dist_address)); }\
  }\
  *(void**)(dist_address) = tmp_object;\
} while (0)\

#endif
// Package variable id declarations
// Field id and index declarations
// Sub id declarations
// Basic type id declarations
// Function Declarations
// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Warn__test_warn(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Warn__test_warn_empty(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Warn__test_warn_long_lines(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Warn__test_warn_newline(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Warn__test_warn_undef(SPVM_ENV* env, SPVM_VALUE* stack);


// Function Implementations
int32_t SPPRECOMPILE__TestCase__Warn__test_warn(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int32_t int_vars[6];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x48\x65\x6C\x6C\x6F", 5));
L3: // WARN
  {
    void* object = object_vars[0];
    int32_t empty_or_undef = 0;
    if (object) {
      const char* bytes = (const char*)env->get_elems_byte(env, object);
      int32_t string_length = env->length(env, object);
      if (string_length > 0) {
        size_t ret = fwrite(bytes, 1, string_length, stderr);
        int32_t add_line_file;
        if (bytes[string_length - 1] != '\n') {
          fprintf(stderr, " at %s line %d\n", "TestCase/Warn.spvm", 4);
        }
      }
      else {
        empty_or_undef = 1;
      }
    }
    else {
      empty_or_undef = 1;
    }
    if (empty_or_undef) {
        fprintf(stderr, "Warning: something's wrong at %s line %d\n", "TestCase/Warn.spvm", 4);
    }
  }
L4: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L5: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L8;
L6: // INIT_INT
  int_vars[4] = 0;
L7: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L8;
L8: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L9: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Warn__test_warn_empty(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int32_t int_vars[6];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "", 0));
L3: // WARN
  {
    void* object = object_vars[0];
    int32_t empty_or_undef = 0;
    if (object) {
      const char* bytes = (const char*)env->get_elems_byte(env, object);
      int32_t string_length = env->length(env, object);
      if (string_length > 0) {
        size_t ret = fwrite(bytes, 1, string_length, stderr);
        int32_t add_line_file;
        if (bytes[string_length - 1] != '\n') {
          fprintf(stderr, " at %s line %d\n", "TestCase/Warn.spvm", 21);
        }
      }
      else {
        empty_or_undef = 1;
      }
    }
    else {
      empty_or_undef = 1;
    }
    if (empty_or_undef) {
        fprintf(stderr, "Warning: something's wrong at %s line %d\n", "TestCase/Warn.spvm", 21);
    }
  }
L4: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L5: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L8;
L6: // INIT_INT
  int_vars[4] = 0;
L7: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L8;
L8: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L9: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Warn__test_warn_long_lines(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int32_t int_vars[6];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x0A\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x0A\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x0A\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x0A\x45\x45\x45\x45\x45\x45\x45\x45\x45\x45\x45\x45\x45\x45\x45\x45\x45\x45\x45\x45\x45\x45\x0A\x46\x46\x46\x46\x46\x46\x46\x46\x46\x46\x46\x46\x46\x46\x0A", 126));
L3: // WARN
  {
    void* object = object_vars[0];
    int32_t empty_or_undef = 0;
    if (object) {
      const char* bytes = (const char*)env->get_elems_byte(env, object);
      int32_t string_length = env->length(env, object);
      if (string_length > 0) {
        size_t ret = fwrite(bytes, 1, string_length, stderr);
        int32_t add_line_file;
        if (bytes[string_length - 1] != '\n') {
          fprintf(stderr, " at %s line %d\n", "TestCase/Warn.spvm", 16);
        }
      }
      else {
        empty_or_undef = 1;
      }
    }
    else {
      empty_or_undef = 1;
    }
    if (empty_or_undef) {
        fprintf(stderr, "Warning: something's wrong at %s line %d\n", "TestCase/Warn.spvm", 16);
    }
  }
L4: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L5: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L8;
L6: // INIT_INT
  int_vars[4] = 0;
L7: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L8;
L8: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L9: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Warn__test_warn_newline(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int32_t int_vars[6];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x0A", 1));
L3: // WARN
  {
    void* object = object_vars[0];
    int32_t empty_or_undef = 0;
    if (object) {
      const char* bytes = (const char*)env->get_elems_byte(env, object);
      int32_t string_length = env->length(env, object);
      if (string_length > 0) {
        size_t ret = fwrite(bytes, 1, string_length, stderr);
        int32_t add_line_file;
        if (bytes[string_length - 1] != '\n') {
          fprintf(stderr, " at %s line %d\n", "TestCase/Warn.spvm", 10);
        }
      }
      else {
        empty_or_undef = 1;
      }
    }
    else {
      empty_or_undef = 1;
    }
    if (empty_or_undef) {
        fprintf(stderr, "Warning: something's wrong at %s line %d\n", "TestCase/Warn.spvm", 10);
    }
  }
L4: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L5: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L8;
L6: // INIT_INT
  int_vars[4] = 0;
L7: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L8;
L8: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L9: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Warn__test_warn_undef(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int32_t int_vars[7];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L3: // WARN
  {
    void* object = object_vars[0];
    int32_t empty_or_undef = 0;
    if (object) {
      const char* bytes = (const char*)env->get_elems_byte(env, object);
      int32_t string_length = env->length(env, object);
      if (string_length > 0) {
        size_t ret = fwrite(bytes, 1, string_length, stderr);
        int32_t add_line_file;
        if (bytes[string_length - 1] != '\n') {
          fprintf(stderr, " at %s line %d\n", "TestCase/Warn.spvm", 27);
        }
      }
      else {
        empty_or_undef = 1;
      }
    }
    else {
      empty_or_undef = 1;
    }
    if (empty_or_undef) {
        fprintf(stderr, "Warning: something's wrong at %s line %d\n", "TestCase/Warn.spvm", 27);
    }
  }
L4: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L5: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L8;
L6: // INIT_INT
  int_vars[5] = 0;
L7: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L8;
L8: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L9: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}


