#ifndef SPVM_CSOURCE_BUILDER_PRECOMPILE_H
#define SPVM_CSOURCE_BUILDER_PRECOMPILE_H
#include <spvm_native.h>

#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <inttypes.h>
#define SPVM_RUNTIME_API_GET_OBJECT_NO_WEAKEN_ADDRESS(object) ((void*)((intptr_t)object & ~(intptr_t)1))
#define SPVM_RUNTIME_API_GET_REF_COUNT(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset)))
#define SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset))++)
#define SPVM_RUNTIME_API_INC_REF_COUNT(object)\
do {\
  if (object != NULL) {\
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object);\
  }\
} while (0)\

#define SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset))--)
#define SPVM_RUNTIME_API_DEC_REF_COUNT(object)\
do {\
  if (object != NULL) {\
    if (SPVM_RUNTIME_API_GET_REF_COUNT(object) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(object); }\
    else { env->dec_ref_count(env, object); }\
  }\
} while (0)\

#define SPVM_RUNTIME_API_ISWEAK(dist_address) (((intptr_t)*(void**)dist_address) & 1)

#define SPVM_RUNTIME_API_OBJECT_ASSIGN(dist_address, src_object) \
do {\
  void* tmp_object = SPVM_RUNTIME_API_GET_OBJECT_NO_WEAKEN_ADDRESS(src_object);\
  if (tmp_object != NULL) {\
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(tmp_object);\
  }\
  if (*(void**)(dist_address) != NULL) {\
    if (__builtin_expect(SPVM_RUNTIME_API_ISWEAK(dist_address), 0)) { env->unweaken(env, dist_address); }\
    if (SPVM_RUNTIME_API_GET_REF_COUNT(*(void**)(dist_address)) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*(void**)(dist_address)); }\
    else { env->dec_ref_count(env, *(void**)(dist_address)); }\
  }\
  *(void**)(dist_address) = tmp_object;\
} while (0)\

#endif
// Package variable id declarations
// Field id and index declarations
static int32_t FIELD_ID_SPVM__Byte__val = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__Byte__val = -1;
static int32_t FIELD_ID_SPVM__Double__val = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__Double__val = -1;
static int32_t FIELD_ID_SPVM__Float__val = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__Float__val = -1;
static int32_t FIELD_ID_SPVM__Int__val = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__Int__val = -1;
static int32_t FIELD_ID_SPVM__Long__val = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__Long__val = -1;
static int32_t FIELD_ID_TestCase__Minimal__x = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Minimal__x = -1;
static int32_t FIELD_ID_SPVM__Complex_2d__x = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__Complex_2d__x = -1;
static int32_t FIELD_ID_SPVM__Complex_2d__y = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__Complex_2d__y = -1;
static int32_t FIELD_ID_SPVM__Short__val = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__Short__val = -1;
// Sub id declarations
static int32_t SUB_ID_TestCase__Minimal__new = - 1;
static int32_t SUB_ID_SPVM__Util__INT8_MIN = - 1;
static int32_t SUB_ID_SPVM__Byte__new = - 1;
static int32_t SUB_ID_SPVM__Util__DBL_MIN = - 1;
static int32_t SUB_ID_SPVM__Double__new = - 1;
static int32_t SUB_ID_SPVM__Util__FLT_MIN = - 1;
static int32_t SUB_ID_SPVM__Float__new = - 1;
static int32_t SUB_ID_SPVM__Util__INT32_MIN = - 1;
static int32_t SUB_ID_SPVM__Int__new = - 1;
static int32_t SUB_ID_SPVM__Util__INT64_MIN = - 1;
static int32_t SUB_ID_SPVM__Long__new = - 1;
static int32_t SUB_ID_SPVM__Util__INT16_MIN = - 1;
static int32_t SUB_ID_SPVM__Short__new = - 1;
static int32_t SUB_ID_SPVM__Byte__val = - 1;
static int32_t SUB_ID_SPVM__Double__val = - 1;
static int32_t SUB_ID_SPVM__Float__val = - 1;
static int32_t SUB_ID_SPVM__Int__val = - 1;
static int32_t SUB_ID_SPVM__Long__val = - 1;
static int32_t SUB_ID_SPVM__Short__val = - 1;
// Basic type id declarations
static int32_t BASIC_TYPE_ID_object = -1;
static int32_t BASIC_TYPE_ID_SPVM__Byte = -1;
static int32_t BASIC_TYPE_ID_SPVM__Double = -1;
static int32_t BASIC_TYPE_ID_SPVM__Float = -1;
static int32_t BASIC_TYPE_ID_SPVM__Int = -1;
static int32_t BASIC_TYPE_ID_SPVM__Long = -1;
static int32_t BASIC_TYPE_ID_int = -1;
static int32_t BASIC_TYPE_ID_TestCase__Minimal = -1;
static int32_t BASIC_TYPE_ID_SPVM__Short = -1;
// Function Declarations
// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Assign__assign(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Assign__assign_any_object_to_byte(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Assign__assign_any_object_to_double(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Assign__assign_any_object_to_float(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Assign__assign_any_object_to_int(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Assign__assign_any_object_to_long(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Assign__assign_any_object_to_short(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Assign__assign_byte_object_to_byte(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Assign__assign_byte_to_any_object(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Assign__assign_byte_to_byte_object(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Assign__assign_double_object_to_double(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Assign__assign_double_to_any_object(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Assign__assign_double_to_double_object(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Assign__assign_float_object_to_float(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Assign__assign_float_to_any_object(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Assign__assign_float_to_float_object(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Assign__assign_int_object_to_int(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Assign__assign_int_to_any_object(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Assign__assign_int_to_int_object(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Assign__assign_long_object_to_long(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Assign__assign_long_to_any_object(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Assign__assign_long_to_long_object(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Assign__assign_numeric_to_string(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Assign__assign_ref(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Assign__assign_return_value_array_access_chain(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Assign__assign_return_value_array_access_left_var(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Assign__assign_return_value_array_access_right_not_var(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Assign__assign_return_value_array_access_right_var(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Assign__assign_return_value_byte(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Assign__assign_return_value_constant(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Assign__assign_return_value_double(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Assign__assign_return_value_field_access(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Assign__assign_return_value_float(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Assign__assign_return_value_int(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Assign__assign_return_value_long(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Assign__assign_return_value_multi_numeric_type(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Assign__assign_return_value_my_var(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Assign__assign_return_value_object(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Assign__assign_return_value_ref(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Assign__assign_return_value_short(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Assign__assign_return_value_value_field(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Assign__assign_return_value_var(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Assign__assign_short_object_to_short(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Assign__assign_short_to_any_object(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Assign__assign_short_to_short_object(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Assign__assign_undef_to_numeric_object(SPVM_ENV* env, SPVM_VALUE* stack);


// Function Implementations
int32_t SPPRECOMPILE__TestCase__Assign__assign(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  double double_vars[1];
  float float_vars[2];
  int64_t long_vars[2];
  int32_t int_vars[11];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[2];
  int8_t byte_vars[2];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L2: // MOVE_CONSTANT_INT
  int_vars[3] = 127;
L3: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[3];
L4: // MOVE_CONSTANT_INT
  int_vars[3] = -128;
L5: // CONVERT_INT_TO_BYTE
  byte_vars[1] = (int8_t)int_vars[3];
L6: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[0];
L7: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[1];
L8: // ADD_INT
  int_vars[5] = int_vars[3] + int_vars[4];
L9: // MOVE_CONSTANT_INT
  int_vars[3] = 32767;
L10: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[3];
L11: // MOVE_CONSTANT_INT
  int_vars[3] = -32768;
L12: // CONVERT_INT_TO_SHORT
  short_vars[1] = (int16_t)int_vars[3];
L13: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[0];
L14: // CONVERT_SHORT_TO_INT
  int_vars[4] = (int32_t)short_vars[1];
L15: // ADD_INT
  int_vars[6] = int_vars[3] + int_vars[4];
L16: // MOVE_CONSTANT_LONG
  long_vars[0] = 2147483647LL;
L17: // CONVERT_LONG_TO_INT
  int_vars[3] = (int32_t)long_vars[0];
L18: // MOVE_CONSTANT_LONG
  long_vars[0] = -2147483648LL;
L19: // CONVERT_LONG_TO_INT
  int_vars[4] = (int32_t)long_vars[0];
L20: // ADD_INT
  int_vars[7] = int_vars[3] + int_vars[4];
L21: // MOVE_CONSTANT_INT
  int_vars[8] = -1;
L22: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[8]);
L23: // BOOL_INT
  int_vars[0] = int_vars[0];
L24: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L37; }
L25: // MOVE_CONSTANT_INT
  int_vars[8] = -1;
L26: // EQ_INT
  int_vars[0] = (int_vars[6] == int_vars[8]);
L27: // BOOL_INT
  int_vars[0] = int_vars[0];
L28: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L36; }
L29: // MOVE_CONSTANT_INT
  int_vars[8] = -1;
L30: // EQ_INT
  int_vars[0] = (int_vars[7] == int_vars[8]);
L31: // BOOL_INT
  int_vars[0] = int_vars[0];
L32: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L35; }
L33: // MOVE_CONSTANT_INT
  int_vars[1] = 1;
L34: // GOTO
  goto L35;
L35: // GOTO
  goto L36;
L36: // GOTO
  goto L37;
L37: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L38: // MOVE_CONSTANT_INT
  int_vars[4] = 127;
L39: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[4];
L40: // CONVERT_BYTE_TO_SHORT
  short_vars[0] = (int16_t)byte_vars[0];
L41: // MOVE_CONSTANT_INT
  int_vars[4] = 127;
L42: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[4];
L43: // CONVERT_BYTE_TO_INT
  int_vars[5] = (int32_t)byte_vars[0];
L44: // MOVE_CONSTANT_INT
  int_vars[4] = 127;
L45: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[4];
L46: // CONVERT_BYTE_TO_LONG
  long_vars[0] = (int64_t)byte_vars[0];
L47: // MOVE_CONSTANT_INT
  int_vars[4] = 127;
L48: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[4];
L49: // CONVERT_BYTE_TO_FLOAT
  float_vars[0] = (float)byte_vars[0];
L50: // MOVE_CONSTANT_INT
  int_vars[4] = 127;
L51: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[4];
L52: // CONVERT_BYTE_TO_DOUBLE
  double_vars[0] = (double)byte_vars[0];
L53: // CONVERT_SHORT_TO_INT
  int_vars[4] = (int32_t)short_vars[0];
L54: // MOVE_CONSTANT_INT
  int_vars[6] = 127;
L55: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[6]);
L56: // BOOL_INT
  int_vars[0] = int_vars[0];
L57: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L80; }
L58: // MOVE_CONSTANT_INT
  int_vars[4] = 127;
L59: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[4]);
L60: // BOOL_INT
  int_vars[0] = int_vars[0];
L61: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L79; }
L62: // MOVE_CONSTANT_INT
  int_vars[4] = 127;
L63: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[4];
L64: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[1]);
L65: // BOOL_INT
  int_vars[0] = int_vars[0];
L66: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L78; }
L67: // MOVE_CONSTANT_FLOAT
  float_vars[1] = 127.0;
L68: // EQ_FLOAT
  int_vars[0] = (float_vars[0] == float_vars[1]);
L69: // BOOL_INT
  int_vars[0] = int_vars[0];
L70: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L77; }
L71: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 127.0;
L72: // BOOL_DOUBLE
  int_vars[0] = !!double_vars[0];
L73: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L76; }
L74: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L75: // GOTO
  goto L76;
L76: // GOTO
  goto L77;
L77: // GOTO
  goto L78;
L78: // GOTO
  goto L79;
L79: // GOTO
  goto L80;
L80: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L81: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L82: // CALL_SUB_OBJECT
  // TestCase::Minimal->new
  {
    if (SUB_ID_TestCase__Minimal__new < 0) {
      SUB_ID_TestCase__Minimal__new = env->get_sub_id(env, "TestCase::Minimal", "new", "TestCase::Minimal()");
      if (SUB_ID_TestCase__Minimal__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Minimal new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Minimal__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L83: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Assign";
    const char* sub_name = "assign";
    const char* file = "TestCase/Assign.spvm";
    int32_t line = 298;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L120;
  }
L84: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], object_vars[0]);
L85: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L86: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L87: // BOOL_INT
  int_vars[0] = int_vars[1];
L88: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L97; }
L89: // BOOL_INT
  int_vars[0] = int_vars[3];
L90: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L94; }
L91: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L92: // BOOL_INT
  int_vars[0] = int_vars[5];
L93: // GOTO
  goto L96;
L94: // MOVE_CONSTANT_INT
  int_vars[6] = 0;
L95: // BOOL_INT
  int_vars[0] = int_vars[6];
L96: // GOTO
  goto L99;
L97: // MOVE_CONSTANT_INT
  int_vars[7] = 0;
L98: // BOOL_INT
  int_vars[0] = int_vars[7];
L99: // BOOL_INT
  int_vars[0] = int_vars[0];
L100: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L109; }
L101: // BOOL_INT
  int_vars[0] = int_vars[4];
L102: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L106; }
L103: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L104: // BOOL_INT
  int_vars[0] = int_vars[5];
L105: // GOTO
  goto L108;
L106: // MOVE_CONSTANT_INT
  int_vars[6] = 0;
L107: // BOOL_INT
  int_vars[0] = int_vars[6];
L108: // GOTO
  goto L111;
L109: // MOVE_CONSTANT_INT
  int_vars[7] = 0;
L110: // BOOL_INT
  int_vars[0] = int_vars[7];
L111: // BOOL_INT
  int_vars[0] = int_vars[0];
L112: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L116; }
L113: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L114: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L120;
L115: // GOTO
  goto L116;
L116: // MOVE_CONSTANT_INT
  int_vars[7] = 0;
L117: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[7];
  goto L120;
L118: // INIT_INT
  int_vars[9] = 0;
L119: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[9];
  goto L120;
L120: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L121: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Assign__assign_any_object_to_byte(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[3];
  int32_t mortal_stack_top = 0;
  int8_t byte_vars[2];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MIN
  {
    if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
      SUB_ID_SPVM__Util__INT8_MIN = env->get_sub_id(env, "SPVM::Util", "INT8_MIN", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[0] = *(int8_t*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Assign";
    const char* sub_name = "assign_any_object_to_byte";
    const char* file = "TestCase/Assign.spvm";
    int32_t line = 534;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L27;
  }
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L4: // PUSH_ARG_BYTE
  *(int8_t*)&stack[0] = byte_vars[0];
L5: // CALL_SUB_OBJECT
  // SPVM::Byte->new
  {
    if (SUB_ID_SPVM__Byte__new < 0) {
      SUB_ID_SPVM__Byte__new = env->get_sub_id(env, "SPVM::Byte", "new", "SPVM::Byte(byte)");
      if (SUB_ID_SPVM__Byte__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Byte new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Byte__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Assign";
    const char* sub_name = "assign_any_object_to_byte";
    const char* file = "TestCase/Assign.spvm";
    int32_t line = 534;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L27;
  }
L7: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L8: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object_vars[0]);
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Assign";
    const char* sub_name = "assign_any_object_to_byte";
    const char* file = "TestCase/Assign.spvm";
    int32_t line = 534;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L27;
  }
L10: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L11: // CONVERT_BYTE_OBJECT_TO_BYTE
  {
    void* object = object_vars[1];
    if (object == NULL) {
      void* exception = env->new_string_raw(env, "Can't convert undef value.");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      int32_t object_basic_type_id = *(int32_t*)((intptr_t)object + (intptr_t)env->object_basic_type_id_offset);
      int32_t object_type_dimension_id = *(uint8_t*)((intptr_t)object + (intptr_t)env->object_type_dimension_offset);
      if (object_basic_type_id == (intptr_t)(void*)env->byte_object_basic_type_id && object_type_dimension_id == 0) {
        SPVM_VALUE* fields = (SPVM_VALUE*)((intptr_t)object + object_header_byte_size);
        
byte_vars[0] = *(int8_t*)&fields[0];
      }
      else {
        void* exception = env->new_string_raw(env, "Can't convert imcompatible object type.");
        env->set_exception(env, exception);
        exception_flag = 1;
      }
    }
  }
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Assign";
    const char* sub_name = "assign_any_object_to_byte";
    const char* file = "TestCase/Assign.spvm";
    int32_t line = 535;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L27;
  }
L13: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[0];
L14: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MIN
  {
    if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
      SUB_ID_SPVM__Util__INT8_MIN = env->get_sub_id(env, "SPVM::Util", "INT8_MIN", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[1] = *(int8_t*)&stack[0];
    }
  }
L15: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Assign";
    const char* sub_name = "assign_any_object_to_byte";
    const char* file = "TestCase/Assign.spvm";
    int32_t line = 537;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L27;
  }
L16: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[1];
L17: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L18: // BOOL_INT
  int_vars[0] = int_vars[0];
L19: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L23; }
L20: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L21: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L27;
L22: // GOTO
  goto L23;
L23: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L24: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L27;
L25: // INIT_INT
  int_vars[6] = 0;
L26: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L27;
L27: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L28: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Assign__assign_any_object_to_double(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  double double_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[3];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MIN
  {
    if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
      SUB_ID_SPVM__Util__DBL_MIN = env->get_sub_id(env, "SPVM::Util", "DBL_MIN", "double()");
      if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Assign";
    const char* sub_name = "assign_any_object_to_double";
    const char* file = "TestCase/Assign.spvm";
    int32_t line = 583;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L25;
  }
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L4: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[0];
L5: // CALL_SUB_OBJECT
  // SPVM::Double->new
  {
    if (SUB_ID_SPVM__Double__new < 0) {
      SUB_ID_SPVM__Double__new = env->get_sub_id(env, "SPVM::Double", "new", "SPVM::Double(double)");
      if (SUB_ID_SPVM__Double__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Double new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Double__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Assign";
    const char* sub_name = "assign_any_object_to_double";
    const char* file = "TestCase/Assign.spvm";
    int32_t line = 583;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L25;
  }
L7: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L8: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object_vars[0]);
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Assign";
    const char* sub_name = "assign_any_object_to_double";
    const char* file = "TestCase/Assign.spvm";
    int32_t line = 583;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L25;
  }
L10: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L11: // CONVERT_DOUBLE_OBJECT_TO_DOUBLE
  {
    void* object = object_vars[1];
    if (object == NULL) {
      void* exception = env->new_string_raw(env, "Can't convert undef value.");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      int32_t object_basic_type_id = *(int32_t*)((intptr_t)object + (intptr_t)env->object_basic_type_id_offset);
      int32_t object_type_dimension_id = *(uint8_t*)((intptr_t)object + (intptr_t)env->object_type_dimension_offset);
      if (object_basic_type_id == (intptr_t)(void*)env->double_object_basic_type_id && object_type_dimension_id == 0) {
        SPVM_VALUE* fields = (SPVM_VALUE*)((intptr_t)object + object_header_byte_size);
        
double_vars[0] = *(double*)&fields[0];
      }
      else {
        void* exception = env->new_string_raw(env, "Can't convert imcompatible object type.");
        env->set_exception(env, exception);
        exception_flag = 1;
      }
    }
  }
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Assign";
    const char* sub_name = "assign_any_object_to_double";
    const char* file = "TestCase/Assign.spvm";
    int32_t line = 584;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L25;
  }
L13: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MIN
  {
    if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
      SUB_ID_SPVM__Util__DBL_MIN = env->get_sub_id(env, "SPVM::Util", "DBL_MIN", "double()");
      if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[1] = *(double*)&stack[0];
    }
  }
L14: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Assign";
    const char* sub_name = "assign_any_object_to_double";
    const char* file = "TestCase/Assign.spvm";
    int32_t line = 586;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L25;
  }
L15: // EQ_DOUBLE
  int_vars[0] = (double_vars[0] == double_vars[1]);
L16: // BOOL_INT
  int_vars[0] = int_vars[0];
L17: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L21; }
L18: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L19: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L25;
L20: // GOTO
  goto L21;
L21: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L22: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L25;
L23: // INIT_INT
  int_vars[6] = 0;
L24: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L25;
L25: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L26: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Assign__assign_any_object_to_float(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  float float_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[3];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MIN
  {
    if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
      SUB_ID_SPVM__Util__FLT_MIN = env->get_sub_id(env, "SPVM::Util", "FLT_MIN", "float()");
      if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[0] = *(float*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Assign";
    const char* sub_name = "assign_any_object_to_float";
    const char* file = "TestCase/Assign.spvm";
    int32_t line = 574;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L25;
  }
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L4: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[0];
L5: // CALL_SUB_OBJECT
  // SPVM::Float->new
  {
    if (SUB_ID_SPVM__Float__new < 0) {
      SUB_ID_SPVM__Float__new = env->get_sub_id(env, "SPVM::Float", "new", "SPVM::Float(float)");
      if (SUB_ID_SPVM__Float__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Float new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Float__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Assign";
    const char* sub_name = "assign_any_object_to_float";
    const char* file = "TestCase/Assign.spvm";
    int32_t line = 574;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L25;
  }
L7: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L8: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object_vars[0]);
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Assign";
    const char* sub_name = "assign_any_object_to_float";
    const char* file = "TestCase/Assign.spvm";
    int32_t line = 574;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L25;
  }
L10: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L11: // CONVERT_FLOAT_OBJECT_TO_FLOAT
  {
    void* object = object_vars[1];
    if (object == NULL) {
      void* exception = env->new_string_raw(env, "Can't convert undef value.");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      int32_t object_basic_type_id = *(int32_t*)((intptr_t)object + (intptr_t)env->object_basic_type_id_offset);
      int32_t object_type_dimension_id = *(uint8_t*)((intptr_t)object + (intptr_t)env->object_type_dimension_offset);
      if (object_basic_type_id == (intptr_t)(void*)env->float_object_basic_type_id && object_type_dimension_id == 0) {
        SPVM_VALUE* fields = (SPVM_VALUE*)((intptr_t)object + object_header_byte_size);
        
float_vars[0] = *(float*)&fields[0];
      }
      else {
        void* exception = env->new_string_raw(env, "Can't convert imcompatible object type.");
        env->set_exception(env, exception);
        exception_flag = 1;
      }
    }
  }
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Assign";
    const char* sub_name = "assign_any_object_to_float";
    const char* file = "TestCase/Assign.spvm";
    int32_t line = 575;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L25;
  }
L13: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MIN
  {
    if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
      SUB_ID_SPVM__Util__FLT_MIN = env->get_sub_id(env, "SPVM::Util", "FLT_MIN", "float()");
      if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[1] = *(float*)&stack[0];
    }
  }
L14: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Assign";
    const char* sub_name = "assign_any_object_to_float";
    const char* file = "TestCase/Assign.spvm";
    int32_t line = 577;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L25;
  }
L15: // EQ_FLOAT
  int_vars[0] = (float_vars[0] == float_vars[1]);
L16: // BOOL_INT
  int_vars[0] = int_vars[0];
L17: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L21; }
L18: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L19: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L25;
L20: // GOTO
  goto L21;
L21: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L22: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L25;
L23: // INIT_INT
  int_vars[6] = 0;
L24: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L25;
L25: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L26: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Assign__assign_any_object_to_int(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[3];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_INT
  // SPVM::Util->INT32_MIN
  {
    if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
      SUB_ID_SPVM__Util__INT32_MIN = env->get_sub_id(env, "SPVM::Util", "INT32_MIN", "int()");
      if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[1] = *(int32_t*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Assign";
    const char* sub_name = "assign_any_object_to_int";
    const char* file = "TestCase/Assign.spvm";
    int32_t line = 554;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L25;
  }
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L4: // PUSH_ARG_INT
  *(int32_t*)&stack[0] = int_vars[1];
L5: // CALL_SUB_OBJECT
  // SPVM::Int->new
  {
    if (SUB_ID_SPVM__Int__new < 0) {
      SUB_ID_SPVM__Int__new = env->get_sub_id(env, "SPVM::Int", "new", "SPVM::Int(int)");
      if (SUB_ID_SPVM__Int__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Int new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Int__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Assign";
    const char* sub_name = "assign_any_object_to_int";
    const char* file = "TestCase/Assign.spvm";
    int32_t line = 554;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L25;
  }
L7: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L8: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object_vars[0]);
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Assign";
    const char* sub_name = "assign_any_object_to_int";
    const char* file = "TestCase/Assign.spvm";
    int32_t line = 554;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L25;
  }
L10: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L11: // CONVERT_INT_OBJECT_TO_INT
  {
    void* object = object_vars[1];
    if (object == NULL) {
      void* exception = env->new_string_raw(env, "Can't convert undef value.");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      int32_t object_basic_type_id = *(int32_t*)((intptr_t)object + (intptr_t)env->object_basic_type_id_offset);
      int32_t object_type_dimension_id = *(uint8_t*)((intptr_t)object + (intptr_t)env->object_type_dimension_offset);
      if (object_basic_type_id == (intptr_t)(void*)env->int_object_basic_type_id && object_type_dimension_id == 0) {
        SPVM_VALUE* fields = (SPVM_VALUE*)((intptr_t)object + object_header_byte_size);
        
int_vars[2] = *(int32_t*)&fields[0];
      }
      else {
        void* exception = env->new_string_raw(env, "Can't convert imcompatible object type.");
        env->set_exception(env, exception);
        exception_flag = 1;
      }
    }
  }
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Assign";
    const char* sub_name = "assign_any_object_to_int";
    const char* file = "TestCase/Assign.spvm";
    int32_t line = 555;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L25;
  }
L13: // CALL_SUB_INT
  // SPVM::Util->INT32_MIN
  {
    if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
      SUB_ID_SPVM__Util__INT32_MIN = env->get_sub_id(env, "SPVM::Util", "INT32_MIN", "int()");
      if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L14: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Assign";
    const char* sub_name = "assign_any_object_to_int";
    const char* file = "TestCase/Assign.spvm";
    int32_t line = 557;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L25;
  }
L15: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L16: // BOOL_INT
  int_vars[0] = int_vars[0];
L17: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L21; }
L18: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L19: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L25;
L20: // GOTO
  goto L21;
L21: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L22: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L25;
L23: // INIT_INT
  int_vars[7] = 0;
L24: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[7];
  goto L25;
L25: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L26: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Assign__assign_any_object_to_long(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int64_t long_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[3];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_LONG
  // SPVM::Util->INT64_MIN
  {
    if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
      SUB_ID_SPVM__Util__INT64_MIN = env->get_sub_id(env, "SPVM::Util", "INT64_MIN", "long()");
      if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[0] = *(int64_t*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Assign";
    const char* sub_name = "assign_any_object_to_long";
    const char* file = "TestCase/Assign.spvm";
    int32_t line = 564;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L25;
  }
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L4: // PUSH_ARG_LONG
  *(int64_t*)&stack[0] = long_vars[0];
L5: // CALL_SUB_OBJECT
  // SPVM::Long->new
  {
    if (SUB_ID_SPVM__Long__new < 0) {
      SUB_ID_SPVM__Long__new = env->get_sub_id(env, "SPVM::Long", "new", "SPVM::Long(long)");
      if (SUB_ID_SPVM__Long__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Long new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Long__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Assign";
    const char* sub_name = "assign_any_object_to_long";
    const char* file = "TestCase/Assign.spvm";
    int32_t line = 564;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L25;
  }
L7: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L8: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object_vars[0]);
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Assign";
    const char* sub_name = "assign_any_object_to_long";
    const char* file = "TestCase/Assign.spvm";
    int32_t line = 564;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L25;
  }
L10: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L11: // CONVERT_LONG_OBJECT_TO_LONG
  {
    void* object = object_vars[1];
    if (object == NULL) {
      void* exception = env->new_string_raw(env, "Can't convert undef value.");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      int32_t object_basic_type_id = *(int32_t*)((intptr_t)object + (intptr_t)env->object_basic_type_id_offset);
      int32_t object_type_dimension_id = *(uint8_t*)((intptr_t)object + (intptr_t)env->object_type_dimension_offset);
      if (object_basic_type_id == (intptr_t)(void*)env->long_object_basic_type_id && object_type_dimension_id == 0) {
        SPVM_VALUE* fields = (SPVM_VALUE*)((intptr_t)object + object_header_byte_size);
        
long_vars[0] = *(int64_t*)&fields[0];
      }
      else {
        void* exception = env->new_string_raw(env, "Can't convert imcompatible object type.");
        env->set_exception(env, exception);
        exception_flag = 1;
      }
    }
  }
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Assign";
    const char* sub_name = "assign_any_object_to_long";
    const char* file = "TestCase/Assign.spvm";
    int32_t line = 565;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L25;
  }
L13: // CALL_SUB_LONG
  // SPVM::Util->INT64_MIN
  {
    if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
      SUB_ID_SPVM__Util__INT64_MIN = env->get_sub_id(env, "SPVM::Util", "INT64_MIN", "long()");
      if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[1] = *(int64_t*)&stack[0];
    }
  }
L14: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Assign";
    const char* sub_name = "assign_any_object_to_long";
    const char* file = "TestCase/Assign.spvm";
    int32_t line = 567;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L25;
  }
L15: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[1]);
L16: // BOOL_INT
  int_vars[0] = int_vars[0];
L17: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L21; }
L18: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L19: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L25;
L20: // GOTO
  goto L21;
L21: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L22: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L25;
L23: // INIT_INT
  int_vars[6] = 0;
L24: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L25;
L25: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L26: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Assign__assign_any_object_to_short(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[3];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[2];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MIN
  {
    if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
      SUB_ID_SPVM__Util__INT16_MIN = env->get_sub_id(env, "SPVM::Util", "INT16_MIN", "short()");
      if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[0] = *(int16_t*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Assign";
    const char* sub_name = "assign_any_object_to_short";
    const char* file = "TestCase/Assign.spvm";
    int32_t line = 544;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L27;
  }
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L4: // PUSH_ARG_SHORT
  *(int16_t*)&stack[0] = short_vars[0];
L5: // CALL_SUB_OBJECT
  // SPVM::Short->new
  {
    if (SUB_ID_SPVM__Short__new < 0) {
      SUB_ID_SPVM__Short__new = env->get_sub_id(env, "SPVM::Short", "new", "SPVM::Short(short)");
      if (SUB_ID_SPVM__Short__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Short new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Short__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Assign";
    const char* sub_name = "assign_any_object_to_short";
    const char* file = "TestCase/Assign.spvm";
    int32_t line = 544;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L27;
  }
L7: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L8: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object_vars[0]);
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Assign";
    const char* sub_name = "assign_any_object_to_short";
    const char* file = "TestCase/Assign.spvm";
    int32_t line = 544;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L27;
  }
L10: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L11: // CONVERT_SHORT_OBJECT_TO_SHORT
  {
    void* object = object_vars[1];
    if (object == NULL) {
      void* exception = env->new_string_raw(env, "Can't convert undef value.");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      int32_t object_basic_type_id = *(int32_t*)((intptr_t)object + (intptr_t)env->object_basic_type_id_offset);
      int32_t object_type_dimension_id = *(uint8_t*)((intptr_t)object + (intptr_t)env->object_type_dimension_offset);
      if (object_basic_type_id == (intptr_t)(void*)env->short_object_basic_type_id && object_type_dimension_id == 0) {
        SPVM_VALUE* fields = (SPVM_VALUE*)((intptr_t)object + object_header_byte_size);
        
short_vars[0] = *(int16_t*)&fields[0];
      }
      else {
        void* exception = env->new_string_raw(env, "Can't convert imcompatible object type.");
        env->set_exception(env, exception);
        exception_flag = 1;
      }
    }
  }
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Assign";
    const char* sub_name = "assign_any_object_to_short";
    const char* file = "TestCase/Assign.spvm";
    int32_t line = 545;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L27;
  }
L13: // CONVERT_SHORT_TO_INT
  int_vars[2] = (int32_t)short_vars[0];
L14: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MIN
  {
    if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
      SUB_ID_SPVM__Util__INT16_MIN = env->get_sub_id(env, "SPVM::Util", "INT16_MIN", "short()");
      if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[1] = *(int16_t*)&stack[0];
    }
  }
L15: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Assign";
    const char* sub_name = "assign_any_object_to_short";
    const char* file = "TestCase/Assign.spvm";
    int32_t line = 547;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L27;
  }
L16: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[1];
L17: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L18: // BOOL_INT
  int_vars[0] = int_vars[0];
L19: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L23; }
L20: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L21: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L27;
L22: // GOTO
  goto L23;
L23: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L24: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L27;
L25: // INIT_INT
  int_vars[6] = 0;
L26: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L27;
L27: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L28: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Assign__assign_byte_object_to_byte(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  int8_t byte_vars[2];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MIN
  {
    if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
      SUB_ID_SPVM__Util__INT8_MIN = env->get_sub_id(env, "SPVM::Util", "INT8_MIN", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[0] = *(int8_t*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Assign";
    const char* sub_name = "assign_byte_object_to_byte";
    const char* file = "TestCase/Assign.spvm";
    int32_t line = 475;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L23;
  }
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L4: // PUSH_ARG_BYTE
  *(int8_t*)&stack[0] = byte_vars[0];
L5: // CALL_SUB_OBJECT
  // SPVM::Byte->new
  {
    if (SUB_ID_SPVM__Byte__new < 0) {
      SUB_ID_SPVM__Byte__new = env->get_sub_id(env, "SPVM::Byte", "new", "SPVM::Byte(byte)");
      if (SUB_ID_SPVM__Byte__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Byte new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Byte__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Assign";
    const char* sub_name = "assign_byte_object_to_byte";
    const char* file = "TestCase/Assign.spvm";
    int32_t line = 475;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L23;
  }
L7: // CONVERT_BYTE_OBJECT_TO_BYTE
  {
    void* object = object_vars[0];
    if (object == NULL) {
      void* exception = env->new_string_raw(env, "Can't convert undef value.");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      int32_t object_basic_type_id = *(int32_t*)((intptr_t)object + (intptr_t)env->object_basic_type_id_offset);
      int32_t object_type_dimension_id = *(uint8_t*)((intptr_t)object + (intptr_t)env->object_type_dimension_offset);
      if (object_basic_type_id == (intptr_t)(void*)env->byte_object_basic_type_id && object_type_dimension_id == 0) {
        SPVM_VALUE* fields = (SPVM_VALUE*)((intptr_t)object + object_header_byte_size);
        
byte_vars[0] = *(int8_t*)&fields[0];
      }
      else {
        void* exception = env->new_string_raw(env, "Can't convert imcompatible object type.");
        env->set_exception(env, exception);
        exception_flag = 1;
      }
    }
  }
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Assign";
    const char* sub_name = "assign_byte_object_to_byte";
    const char* file = "TestCase/Assign.spvm";
    int32_t line = 476;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L23;
  }
L9: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[0];
L10: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MIN
  {
    if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
      SUB_ID_SPVM__Util__INT8_MIN = env->get_sub_id(env, "SPVM::Util", "INT8_MIN", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[1] = *(int8_t*)&stack[0];
    }
  }
L11: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Assign";
    const char* sub_name = "assign_byte_object_to_byte";
    const char* file = "TestCase/Assign.spvm";
    int32_t line = 478;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L23;
  }
L12: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[1];
L13: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L14: // BOOL_INT
  int_vars[0] = int_vars[0];
L15: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L19; }
L16: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L17: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L23;
L18: // GOTO
  goto L19;
L19: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L20: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L23;
L21: // INIT_INT
  int_vars[6] = 0;
L22: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L23;
L23: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L24: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Assign__assign_byte_to_any_object(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[3];
  int32_t mortal_stack_top = 0;
  int8_t byte_vars[3];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MIN
  {
    if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
      SUB_ID_SPVM__Util__INT8_MIN = env->get_sub_id(env, "SPVM::Util", "INT8_MIN", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[0] = *(int8_t*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Assign";
    const char* sub_name = "assign_byte_to_any_object";
    const char* file = "TestCase/Assign.spvm";
    int32_t line = 397;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L30;
  }
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L4: // CONVERT_BYTE_TO_BYTE_OBJECT
  {
    int8_t value = byte_vars[0];
    int32_t basic_type_id = (intptr_t)(void*)env->byte_object_basic_type_id;
    void* object = env->new_object_raw(env, basic_type_id);
    SPVM_VALUE* fields = (SPVM_VALUE*)((intptr_t)object + object_header_byte_size);
    *(int8_t*)&fields[0] = value;
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], object);
  }
L5: // IS_TYPE
  {
    if (BASIC_TYPE_ID_SPVM__Byte < 0) {
      BASIC_TYPE_ID_SPVM__Byte = env->get_basic_type_id(env, "SPVM::Byte");
      if (BASIC_TYPE_ID_SPVM__Byte < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found SPVM::Byte");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t check_basic_type_id = BASIC_TYPE_ID_SPVM__Byte;
    int32_t check_type_dimension = 0;
    void* object = object_vars[0];
    if (object) {
      int32_t object_basic_type_id = *(int32_t*)((intptr_t)object + (intptr_t)env->object_basic_type_id_offset);
      int32_t object_type_dimension = *(uint8_t*)((intptr_t)object + (intptr_t)env->object_type_dimension_offset);
int_vars[0]      = env->is_type(env, object, check_basic_type_id, check_type_dimension);
    }
    else {
int_vars[0]      = 0;
    }
  }
L6: // BOOL_INT
  int_vars[0] = int_vars[0];
L7: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L24; }
L8: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L9: // CHECK_OBJECT_TYPE
  {
    if (BASIC_TYPE_ID_SPVM__Byte < 0) {
      BASIC_TYPE_ID_SPVM__Byte = env->get_basic_type_id(env, "SPVM::Byte");
      if (BASIC_TYPE_ID_SPVM__Byte < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found SPVM::Byte");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t check_basic_type_id = BASIC_TYPE_ID_SPVM__Byte;
    int32_t check_type_dimension = 0;
    void* object = object_vars[0];
    if (object != NULL) {
      int32_t object_basic_type_id = *(int32_t*)((intptr_t)object + (intptr_t)env->object_basic_type_id_offset);
      int32_t object_type_dimension_id = *(uint8_t*)((intptr_t)object + (intptr_t)env->object_type_dimension_offset);
      if (object_basic_type_id == check_basic_type_id && object_type_dimension_id == check_type_dimension) {
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object_vars[0]);
      }
      else {
        void* exception = env->new_string_raw(env, "Can't cast uncompatible type.");
        env->set_exception(env, exception);
        exception_flag = 1;
      }
    }
  }
L10: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Assign";
    const char* sub_name = "assign_byte_to_any_object";
    const char* file = "TestCase/Assign.spvm";
    int32_t line = 401;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L30;
  }
L11: // GET_FIELD_BYTE
  {
    if (__builtin_expect(FIELD_ID_SPVM__Byte__val < 0, 0)) {
      FIELD_ID_SPVM__Byte__val = env->get_field_id(env, "SPVM::Byte", "val", "byte");
      if (FIELD_ID_SPVM__Byte__val < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::Byte val");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__Byte__val = env->get_field_offset(env, FIELD_ID_SPVM__Byte__val);
    };
    void* object = object_vars[1];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      byte_vars[1] = *(int8_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__Byte__val);
    }
  }
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Assign";
    const char* sub_name = "assign_byte_to_any_object";
    const char* file = "TestCase/Assign.spvm";
    int32_t line = 402;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L30;
  }
L13: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[1];
L14: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MIN
  {
    if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
      SUB_ID_SPVM__Util__INT8_MIN = env->get_sub_id(env, "SPVM::Util", "INT8_MIN", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[2] = *(int8_t*)&stack[0];
    }
  }
L15: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Assign";
    const char* sub_name = "assign_byte_to_any_object";
    const char* file = "TestCase/Assign.spvm";
    int32_t line = 402;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L30;
  }
L16: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[2];
L17: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L18: // BOOL_INT
  int_vars[0] = int_vars[0];
L19: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L23; }
L20: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L21: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L30;
L22: // GOTO
  goto L23;
L23: // GOTO
  goto L25;
L24: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 1;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L25: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 1;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L26: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L27: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L30;
L28: // INIT_INT
  int_vars[6] = 0;
L29: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L30;
L30: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L31: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Assign__assign_byte_to_byte_object(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  int8_t byte_vars[3];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MIN
  {
    if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
      SUB_ID_SPVM__Util__INT8_MIN = env->get_sub_id(env, "SPVM::Util", "INT8_MIN", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[0] = *(int8_t*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Assign";
    const char* sub_name = "assign_byte_to_byte_object";
    const char* file = "TestCase/Assign.spvm";
    int32_t line = 325;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L25;
  }
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L4: // CONVERT_BYTE_TO_BYTE_OBJECT
  {
    int8_t value = byte_vars[0];
    int32_t basic_type_id = (intptr_t)(void*)env->byte_object_basic_type_id;
    void* object = env->new_object_raw(env, basic_type_id);
    SPVM_VALUE* fields = (SPVM_VALUE*)((intptr_t)object + object_header_byte_size);
    *(int8_t*)&fields[0] = value;
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], object);
  }
L5: // IS_TYPE
  {
    if (BASIC_TYPE_ID_SPVM__Byte < 0) {
      BASIC_TYPE_ID_SPVM__Byte = env->get_basic_type_id(env, "SPVM::Byte");
      if (BASIC_TYPE_ID_SPVM__Byte < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found SPVM::Byte");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t check_basic_type_id = BASIC_TYPE_ID_SPVM__Byte;
    int32_t check_type_dimension = 0;
    void* object = object_vars[0];
    if (object) {
      int32_t object_basic_type_id = *(int32_t*)((intptr_t)object + (intptr_t)env->object_basic_type_id_offset);
      int32_t object_type_dimension = *(uint8_t*)((intptr_t)object + (intptr_t)env->object_type_dimension_offset);
int_vars[0]      = env->is_type(env, object, check_basic_type_id, check_type_dimension);
    }
    else {
int_vars[0]      = 0;
    }
  }
L6: // BOOL_INT
  int_vars[0] = int_vars[0];
L7: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L21; }
L8: // GET_FIELD_BYTE
  {
    if (__builtin_expect(FIELD_ID_SPVM__Byte__val < 0, 0)) {
      FIELD_ID_SPVM__Byte__val = env->get_field_id(env, "SPVM::Byte", "val", "byte");
      if (FIELD_ID_SPVM__Byte__val < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::Byte val");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__Byte__val = env->get_field_offset(env, FIELD_ID_SPVM__Byte__val);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      byte_vars[1] = *(int8_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__Byte__val);
    }
  }
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Assign";
    const char* sub_name = "assign_byte_to_byte_object";
    const char* file = "TestCase/Assign.spvm";
    int32_t line = 329;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L25;
  }
L10: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[1];
L11: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MIN
  {
    if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
      SUB_ID_SPVM__Util__INT8_MIN = env->get_sub_id(env, "SPVM::Util", "INT8_MIN", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[2] = *(int8_t*)&stack[0];
    }
  }
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Assign";
    const char* sub_name = "assign_byte_to_byte_object";
    const char* file = "TestCase/Assign.spvm";
    int32_t line = 329;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L25;
  }
L13: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[2];
L14: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L15: // BOOL_INT
  int_vars[0] = int_vars[0];
L16: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L20; }
L17: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L18: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L25;
L19: // GOTO
  goto L20;
L20: // GOTO
  goto L21;
L21: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L22: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L25;
L23: // INIT_INT
  int_vars[6] = 0;
L24: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L25;
L25: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L26: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Assign__assign_double_object_to_double(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  double double_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MIN
  {
    if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
      SUB_ID_SPVM__Util__DBL_MIN = env->get_sub_id(env, "SPVM::Util", "DBL_MIN", "double()");
      if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Assign";
    const char* sub_name = "assign_double_object_to_double";
    const char* file = "TestCase/Assign.spvm";
    int32_t line = 524;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L21;
  }
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L4: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[0];
L5: // CALL_SUB_OBJECT
  // SPVM::Double->new
  {
    if (SUB_ID_SPVM__Double__new < 0) {
      SUB_ID_SPVM__Double__new = env->get_sub_id(env, "SPVM::Double", "new", "SPVM::Double(double)");
      if (SUB_ID_SPVM__Double__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Double new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Double__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Assign";
    const char* sub_name = "assign_double_object_to_double";
    const char* file = "TestCase/Assign.spvm";
    int32_t line = 524;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L21;
  }
L7: // CONVERT_DOUBLE_OBJECT_TO_DOUBLE
  {
    void* object = object_vars[0];
    if (object == NULL) {
      void* exception = env->new_string_raw(env, "Can't convert undef value.");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      int32_t object_basic_type_id = *(int32_t*)((intptr_t)object + (intptr_t)env->object_basic_type_id_offset);
      int32_t object_type_dimension_id = *(uint8_t*)((intptr_t)object + (intptr_t)env->object_type_dimension_offset);
      if (object_basic_type_id == (intptr_t)(void*)env->double_object_basic_type_id && object_type_dimension_id == 0) {
        SPVM_VALUE* fields = (SPVM_VALUE*)((intptr_t)object + object_header_byte_size);
        
double_vars[0] = *(double*)&fields[0];
      }
      else {
        void* exception = env->new_string_raw(env, "Can't convert imcompatible object type.");
        env->set_exception(env, exception);
        exception_flag = 1;
      }
    }
  }
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Assign";
    const char* sub_name = "assign_double_object_to_double";
    const char* file = "TestCase/Assign.spvm";
    int32_t line = 525;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L21;
  }
L9: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MIN
  {
    if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
      SUB_ID_SPVM__Util__DBL_MIN = env->get_sub_id(env, "SPVM::Util", "DBL_MIN", "double()");
      if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[1] = *(double*)&stack[0];
    }
  }
L10: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Assign";
    const char* sub_name = "assign_double_object_to_double";
    const char* file = "TestCase/Assign.spvm";
    int32_t line = 527;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L21;
  }
L11: // EQ_DOUBLE
  int_vars[0] = (double_vars[0] == double_vars[1]);
L12: // BOOL_INT
  int_vars[0] = int_vars[0];
L13: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L17; }
L14: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L15: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L21;
L16: // GOTO
  goto L17;
L17: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L18: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L21;
L19: // INIT_INT
  int_vars[6] = 0;
L20: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L21;
L21: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L22: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Assign__assign_double_to_any_object(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  double double_vars[3];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[3];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MIN
  {
    if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
      SUB_ID_SPVM__Util__DBL_MIN = env->get_sub_id(env, "SPVM::Util", "DBL_MIN", "double()");
      if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Assign";
    const char* sub_name = "assign_double_to_any_object";
    const char* file = "TestCase/Assign.spvm";
    int32_t line = 462;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L28;
  }
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L4: // CONVERT_DOUBLE_TO_DOUBLE_OBJECT
  {
    double value = double_vars[0];
    int32_t basic_type_id = (intptr_t)(void*)env->double_object_basic_type_id;
    void* object = env->new_object_raw(env, basic_type_id);
    SPVM_VALUE* fields = (SPVM_VALUE*)((intptr_t)object + object_header_byte_size);
    *(double*)&fields[0] = value;
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], object);
  }
L5: // IS_TYPE
  {
    if (BASIC_TYPE_ID_SPVM__Double < 0) {
      BASIC_TYPE_ID_SPVM__Double = env->get_basic_type_id(env, "SPVM::Double");
      if (BASIC_TYPE_ID_SPVM__Double < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found SPVM::Double");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t check_basic_type_id = BASIC_TYPE_ID_SPVM__Double;
    int32_t check_type_dimension = 0;
    void* object = object_vars[0];
    if (object) {
      int32_t object_basic_type_id = *(int32_t*)((intptr_t)object + (intptr_t)env->object_basic_type_id_offset);
      int32_t object_type_dimension = *(uint8_t*)((intptr_t)object + (intptr_t)env->object_type_dimension_offset);
int_vars[0]      = env->is_type(env, object, check_basic_type_id, check_type_dimension);
    }
    else {
int_vars[0]      = 0;
    }
  }
L6: // BOOL_INT
  int_vars[0] = int_vars[0];
L7: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L22; }
L8: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L9: // CHECK_OBJECT_TYPE
  {
    if (BASIC_TYPE_ID_SPVM__Double < 0) {
      BASIC_TYPE_ID_SPVM__Double = env->get_basic_type_id(env, "SPVM::Double");
      if (BASIC_TYPE_ID_SPVM__Double < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found SPVM::Double");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t check_basic_type_id = BASIC_TYPE_ID_SPVM__Double;
    int32_t check_type_dimension = 0;
    void* object = object_vars[0];
    if (object != NULL) {
      int32_t object_basic_type_id = *(int32_t*)((intptr_t)object + (intptr_t)env->object_basic_type_id_offset);
      int32_t object_type_dimension_id = *(uint8_t*)((intptr_t)object + (intptr_t)env->object_type_dimension_offset);
      if (object_basic_type_id == check_basic_type_id && object_type_dimension_id == check_type_dimension) {
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object_vars[0]);
      }
      else {
        void* exception = env->new_string_raw(env, "Can't cast uncompatible type.");
        env->set_exception(env, exception);
        exception_flag = 1;
      }
    }
  }
L10: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Assign";
    const char* sub_name = "assign_double_to_any_object";
    const char* file = "TestCase/Assign.spvm";
    int32_t line = 466;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L28;
  }
L11: // GET_FIELD_DOUBLE
  {
    if (__builtin_expect(FIELD_ID_SPVM__Double__val < 0, 0)) {
      FIELD_ID_SPVM__Double__val = env->get_field_id(env, "SPVM::Double", "val", "double");
      if (FIELD_ID_SPVM__Double__val < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::Double val");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__Double__val = env->get_field_offset(env, FIELD_ID_SPVM__Double__val);
    };
    void* object = object_vars[1];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      double_vars[1] = *(double*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__Double__val);
    }
  }
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Assign";
    const char* sub_name = "assign_double_to_any_object";
    const char* file = "TestCase/Assign.spvm";
    int32_t line = 467;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L28;
  }
L13: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MIN
  {
    if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
      SUB_ID_SPVM__Util__DBL_MIN = env->get_sub_id(env, "SPVM::Util", "DBL_MIN", "double()");
      if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[2] = *(double*)&stack[0];
    }
  }
L14: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Assign";
    const char* sub_name = "assign_double_to_any_object";
    const char* file = "TestCase/Assign.spvm";
    int32_t line = 467;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L28;
  }
L15: // EQ_DOUBLE
  int_vars[0] = (double_vars[1] == double_vars[2]);
L16: // BOOL_INT
  int_vars[0] = int_vars[0];
L17: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L21; }
L18: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L19: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L28;
L20: // GOTO
  goto L21;
L21: // GOTO
  goto L23;
L22: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 1;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L23: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 1;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L24: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L25: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L28;
L26: // INIT_INT
  int_vars[6] = 0;
L27: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L28;
L28: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L29: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Assign__assign_double_to_double_object(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  double double_vars[3];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MIN
  {
    if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
      SUB_ID_SPVM__Util__DBL_MIN = env->get_sub_id(env, "SPVM::Util", "DBL_MIN", "double()");
      if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Assign";
    const char* sub_name = "assign_double_to_double_object";
    const char* file = "TestCase/Assign.spvm";
    int32_t line = 385;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L23;
  }
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L4: // CONVERT_DOUBLE_TO_DOUBLE_OBJECT
  {
    double value = double_vars[0];
    int32_t basic_type_id = (intptr_t)(void*)env->double_object_basic_type_id;
    void* object = env->new_object_raw(env, basic_type_id);
    SPVM_VALUE* fields = (SPVM_VALUE*)((intptr_t)object + object_header_byte_size);
    *(double*)&fields[0] = value;
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], object);
  }
L5: // IS_TYPE
  {
    if (BASIC_TYPE_ID_SPVM__Double < 0) {
      BASIC_TYPE_ID_SPVM__Double = env->get_basic_type_id(env, "SPVM::Double");
      if (BASIC_TYPE_ID_SPVM__Double < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found SPVM::Double");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t check_basic_type_id = BASIC_TYPE_ID_SPVM__Double;
    int32_t check_type_dimension = 0;
    void* object = object_vars[0];
    if (object) {
      int32_t object_basic_type_id = *(int32_t*)((intptr_t)object + (intptr_t)env->object_basic_type_id_offset);
      int32_t object_type_dimension = *(uint8_t*)((intptr_t)object + (intptr_t)env->object_type_dimension_offset);
int_vars[0]      = env->is_type(env, object, check_basic_type_id, check_type_dimension);
    }
    else {
int_vars[0]      = 0;
    }
  }
L6: // BOOL_INT
  int_vars[0] = int_vars[0];
L7: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L19; }
L8: // GET_FIELD_DOUBLE
  {
    if (__builtin_expect(FIELD_ID_SPVM__Double__val < 0, 0)) {
      FIELD_ID_SPVM__Double__val = env->get_field_id(env, "SPVM::Double", "val", "double");
      if (FIELD_ID_SPVM__Double__val < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::Double val");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__Double__val = env->get_field_offset(env, FIELD_ID_SPVM__Double__val);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      double_vars[1] = *(double*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__Double__val);
    }
  }
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Assign";
    const char* sub_name = "assign_double_to_double_object";
    const char* file = "TestCase/Assign.spvm";
    int32_t line = 389;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L23;
  }
L10: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MIN
  {
    if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
      SUB_ID_SPVM__Util__DBL_MIN = env->get_sub_id(env, "SPVM::Util", "DBL_MIN", "double()");
      if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[2] = *(double*)&stack[0];
    }
  }
L11: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Assign";
    const char* sub_name = "assign_double_to_double_object";
    const char* file = "TestCase/Assign.spvm";
    int32_t line = 389;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L23;
  }
L12: // EQ_DOUBLE
  int_vars[0] = (double_vars[1] == double_vars[2]);
L13: // BOOL_INT
  int_vars[0] = int_vars[0];
L14: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L18; }
L15: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L16: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L23;
L17: // GOTO
  goto L18;
L18: // GOTO
  goto L19;
L19: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L20: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L23;
L21: // INIT_INT
  int_vars[6] = 0;
L22: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L23;
L23: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L24: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Assign__assign_float_object_to_float(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  float float_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MIN
  {
    if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
      SUB_ID_SPVM__Util__FLT_MIN = env->get_sub_id(env, "SPVM::Util", "FLT_MIN", "float()");
      if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[0] = *(float*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Assign";
    const char* sub_name = "assign_float_object_to_float";
    const char* file = "TestCase/Assign.spvm";
    int32_t line = 515;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L21;
  }
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L4: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[0];
L5: // CALL_SUB_OBJECT
  // SPVM::Float->new
  {
    if (SUB_ID_SPVM__Float__new < 0) {
      SUB_ID_SPVM__Float__new = env->get_sub_id(env, "SPVM::Float", "new", "SPVM::Float(float)");
      if (SUB_ID_SPVM__Float__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Float new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Float__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Assign";
    const char* sub_name = "assign_float_object_to_float";
    const char* file = "TestCase/Assign.spvm";
    int32_t line = 515;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L21;
  }
L7: // CONVERT_FLOAT_OBJECT_TO_FLOAT
  {
    void* object = object_vars[0];
    if (object == NULL) {
      void* exception = env->new_string_raw(env, "Can't convert undef value.");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      int32_t object_basic_type_id = *(int32_t*)((intptr_t)object + (intptr_t)env->object_basic_type_id_offset);
      int32_t object_type_dimension_id = *(uint8_t*)((intptr_t)object + (intptr_t)env->object_type_dimension_offset);
      if (object_basic_type_id == (intptr_t)(void*)env->float_object_basic_type_id && object_type_dimension_id == 0) {
        SPVM_VALUE* fields = (SPVM_VALUE*)((intptr_t)object + object_header_byte_size);
        
float_vars[0] = *(float*)&fields[0];
      }
      else {
        void* exception = env->new_string_raw(env, "Can't convert imcompatible object type.");
        env->set_exception(env, exception);
        exception_flag = 1;
      }
    }
  }
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Assign";
    const char* sub_name = "assign_float_object_to_float";
    const char* file = "TestCase/Assign.spvm";
    int32_t line = 516;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L21;
  }
L9: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MIN
  {
    if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
      SUB_ID_SPVM__Util__FLT_MIN = env->get_sub_id(env, "SPVM::Util", "FLT_MIN", "float()");
      if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[1] = *(float*)&stack[0];
    }
  }
L10: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Assign";
    const char* sub_name = "assign_float_object_to_float";
    const char* file = "TestCase/Assign.spvm";
    int32_t line = 518;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L21;
  }
L11: // EQ_FLOAT
  int_vars[0] = (float_vars[0] == float_vars[1]);
L12: // BOOL_INT
  int_vars[0] = int_vars[0];
L13: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L17; }
L14: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L15: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L21;
L16: // GOTO
  goto L17;
L17: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L18: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L21;
L19: // INIT_INT
  int_vars[6] = 0;
L20: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L21;
L21: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L22: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Assign__assign_float_to_any_object(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  float float_vars[3];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[3];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MIN
  {
    if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
      SUB_ID_SPVM__Util__FLT_MIN = env->get_sub_id(env, "SPVM::Util", "FLT_MIN", "float()");
      if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[0] = *(float*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Assign";
    const char* sub_name = "assign_float_to_any_object";
    const char* file = "TestCase/Assign.spvm";
    int32_t line = 449;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L28;
  }
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L4: // CONVERT_FLOAT_TO_FLOAT_OBJECT
  {
    float value = float_vars[0];
    int32_t basic_type_id = (intptr_t)(void*)env->float_object_basic_type_id;
    void* object = env->new_object_raw(env, basic_type_id);
    SPVM_VALUE* fields = (SPVM_VALUE*)((intptr_t)object + object_header_byte_size);
    *(float*)&fields[0] = value;
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], object);
  }
L5: // IS_TYPE
  {
    if (BASIC_TYPE_ID_SPVM__Float < 0) {
      BASIC_TYPE_ID_SPVM__Float = env->get_basic_type_id(env, "SPVM::Float");
      if (BASIC_TYPE_ID_SPVM__Float < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found SPVM::Float");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t check_basic_type_id = BASIC_TYPE_ID_SPVM__Float;
    int32_t check_type_dimension = 0;
    void* object = object_vars[0];
    if (object) {
      int32_t object_basic_type_id = *(int32_t*)((intptr_t)object + (intptr_t)env->object_basic_type_id_offset);
      int32_t object_type_dimension = *(uint8_t*)((intptr_t)object + (intptr_t)env->object_type_dimension_offset);
int_vars[0]      = env->is_type(env, object, check_basic_type_id, check_type_dimension);
    }
    else {
int_vars[0]      = 0;
    }
  }
L6: // BOOL_INT
  int_vars[0] = int_vars[0];
L7: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L22; }
L8: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L9: // CHECK_OBJECT_TYPE
  {
    if (BASIC_TYPE_ID_SPVM__Float < 0) {
      BASIC_TYPE_ID_SPVM__Float = env->get_basic_type_id(env, "SPVM::Float");
      if (BASIC_TYPE_ID_SPVM__Float < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found SPVM::Float");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t check_basic_type_id = BASIC_TYPE_ID_SPVM__Float;
    int32_t check_type_dimension = 0;
    void* object = object_vars[0];
    if (object != NULL) {
      int32_t object_basic_type_id = *(int32_t*)((intptr_t)object + (intptr_t)env->object_basic_type_id_offset);
      int32_t object_type_dimension_id = *(uint8_t*)((intptr_t)object + (intptr_t)env->object_type_dimension_offset);
      if (object_basic_type_id == check_basic_type_id && object_type_dimension_id == check_type_dimension) {
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object_vars[0]);
      }
      else {
        void* exception = env->new_string_raw(env, "Can't cast uncompatible type.");
        env->set_exception(env, exception);
        exception_flag = 1;
      }
    }
  }
L10: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Assign";
    const char* sub_name = "assign_float_to_any_object";
    const char* file = "TestCase/Assign.spvm";
    int32_t line = 453;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L28;
  }
L11: // GET_FIELD_FLOAT
  {
    if (__builtin_expect(FIELD_ID_SPVM__Float__val < 0, 0)) {
      FIELD_ID_SPVM__Float__val = env->get_field_id(env, "SPVM::Float", "val", "float");
      if (FIELD_ID_SPVM__Float__val < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::Float val");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__Float__val = env->get_field_offset(env, FIELD_ID_SPVM__Float__val);
    };
    void* object = object_vars[1];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      float_vars[1] = *(float*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__Float__val);
    }
  }
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Assign";
    const char* sub_name = "assign_float_to_any_object";
    const char* file = "TestCase/Assign.spvm";
    int32_t line = 454;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L28;
  }
L13: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MIN
  {
    if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
      SUB_ID_SPVM__Util__FLT_MIN = env->get_sub_id(env, "SPVM::Util", "FLT_MIN", "float()");
      if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[2] = *(float*)&stack[0];
    }
  }
L14: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Assign";
    const char* sub_name = "assign_float_to_any_object";
    const char* file = "TestCase/Assign.spvm";
    int32_t line = 454;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L28;
  }
L15: // EQ_FLOAT
  int_vars[0] = (float_vars[1] == float_vars[2]);
L16: // BOOL_INT
  int_vars[0] = int_vars[0];
L17: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L21; }
L18: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L19: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L28;
L20: // GOTO
  goto L21;
L21: // GOTO
  goto L23;
L22: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 1;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L23: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 1;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L24: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L25: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L28;
L26: // INIT_INT
  int_vars[6] = 0;
L27: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L28;
L28: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L29: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Assign__assign_float_to_float_object(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  float float_vars[3];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MIN
  {
    if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
      SUB_ID_SPVM__Util__FLT_MIN = env->get_sub_id(env, "SPVM::Util", "FLT_MIN", "float()");
      if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[0] = *(float*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Assign";
    const char* sub_name = "assign_float_to_float_object";
    const char* file = "TestCase/Assign.spvm";
    int32_t line = 373;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L23;
  }
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L4: // CONVERT_FLOAT_TO_FLOAT_OBJECT
  {
    float value = float_vars[0];
    int32_t basic_type_id = (intptr_t)(void*)env->float_object_basic_type_id;
    void* object = env->new_object_raw(env, basic_type_id);
    SPVM_VALUE* fields = (SPVM_VALUE*)((intptr_t)object + object_header_byte_size);
    *(float*)&fields[0] = value;
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], object);
  }
L5: // IS_TYPE
  {
    if (BASIC_TYPE_ID_SPVM__Float < 0) {
      BASIC_TYPE_ID_SPVM__Float = env->get_basic_type_id(env, "SPVM::Float");
      if (BASIC_TYPE_ID_SPVM__Float < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found SPVM::Float");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t check_basic_type_id = BASIC_TYPE_ID_SPVM__Float;
    int32_t check_type_dimension = 0;
    void* object = object_vars[0];
    if (object) {
      int32_t object_basic_type_id = *(int32_t*)((intptr_t)object + (intptr_t)env->object_basic_type_id_offset);
      int32_t object_type_dimension = *(uint8_t*)((intptr_t)object + (intptr_t)env->object_type_dimension_offset);
int_vars[0]      = env->is_type(env, object, check_basic_type_id, check_type_dimension);
    }
    else {
int_vars[0]      = 0;
    }
  }
L6: // BOOL_INT
  int_vars[0] = int_vars[0];
L7: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L19; }
L8: // GET_FIELD_FLOAT
  {
    if (__builtin_expect(FIELD_ID_SPVM__Float__val < 0, 0)) {
      FIELD_ID_SPVM__Float__val = env->get_field_id(env, "SPVM::Float", "val", "float");
      if (FIELD_ID_SPVM__Float__val < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::Float val");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__Float__val = env->get_field_offset(env, FIELD_ID_SPVM__Float__val);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      float_vars[1] = *(float*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__Float__val);
    }
  }
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Assign";
    const char* sub_name = "assign_float_to_float_object";
    const char* file = "TestCase/Assign.spvm";
    int32_t line = 377;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L23;
  }
L10: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MIN
  {
    if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
      SUB_ID_SPVM__Util__FLT_MIN = env->get_sub_id(env, "SPVM::Util", "FLT_MIN", "float()");
      if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[2] = *(float*)&stack[0];
    }
  }
L11: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Assign";
    const char* sub_name = "assign_float_to_float_object";
    const char* file = "TestCase/Assign.spvm";
    int32_t line = 377;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L23;
  }
L12: // EQ_FLOAT
  int_vars[0] = (float_vars[1] == float_vars[2]);
L13: // BOOL_INT
  int_vars[0] = int_vars[0];
L14: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L18; }
L15: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L16: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L23;
L17: // GOTO
  goto L18;
L18: // GOTO
  goto L19;
L19: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L20: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L23;
L21: // INIT_INT
  int_vars[6] = 0;
L22: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L23;
L23: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L24: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Assign__assign_int_object_to_int(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_INT
  // SPVM::Util->INT32_MIN
  {
    if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
      SUB_ID_SPVM__Util__INT32_MIN = env->get_sub_id(env, "SPVM::Util", "INT32_MIN", "int()");
      if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[1] = *(int32_t*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Assign";
    const char* sub_name = "assign_int_object_to_int";
    const char* file = "TestCase/Assign.spvm";
    int32_t line = 495;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L21;
  }
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L4: // PUSH_ARG_INT
  *(int32_t*)&stack[0] = int_vars[1];
L5: // CALL_SUB_OBJECT
  // SPVM::Int->new
  {
    if (SUB_ID_SPVM__Int__new < 0) {
      SUB_ID_SPVM__Int__new = env->get_sub_id(env, "SPVM::Int", "new", "SPVM::Int(int)");
      if (SUB_ID_SPVM__Int__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Int new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Int__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Assign";
    const char* sub_name = "assign_int_object_to_int";
    const char* file = "TestCase/Assign.spvm";
    int32_t line = 495;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L21;
  }
L7: // CONVERT_INT_OBJECT_TO_INT
  {
    void* object = object_vars[0];
    if (object == NULL) {
      void* exception = env->new_string_raw(env, "Can't convert undef value.");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      int32_t object_basic_type_id = *(int32_t*)((intptr_t)object + (intptr_t)env->object_basic_type_id_offset);
      int32_t object_type_dimension_id = *(uint8_t*)((intptr_t)object + (intptr_t)env->object_type_dimension_offset);
      if (object_basic_type_id == (intptr_t)(void*)env->int_object_basic_type_id && object_type_dimension_id == 0) {
        SPVM_VALUE* fields = (SPVM_VALUE*)((intptr_t)object + object_header_byte_size);
        
int_vars[2] = *(int32_t*)&fields[0];
      }
      else {
        void* exception = env->new_string_raw(env, "Can't convert imcompatible object type.");
        env->set_exception(env, exception);
        exception_flag = 1;
      }
    }
  }
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Assign";
    const char* sub_name = "assign_int_object_to_int";
    const char* file = "TestCase/Assign.spvm";
    int32_t line = 496;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L21;
  }
L9: // CALL_SUB_INT
  // SPVM::Util->INT32_MIN
  {
    if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
      SUB_ID_SPVM__Util__INT32_MIN = env->get_sub_id(env, "SPVM::Util", "INT32_MIN", "int()");
      if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L10: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Assign";
    const char* sub_name = "assign_int_object_to_int";
    const char* file = "TestCase/Assign.spvm";
    int32_t line = 498;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L21;
  }
L11: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L12: // BOOL_INT
  int_vars[0] = int_vars[0];
L13: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L17; }
L14: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L15: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L21;
L16: // GOTO
  goto L17;
L17: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L18: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L21;
L19: // INIT_INT
  int_vars[7] = 0;
L20: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[7];
  goto L21;
L21: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L22: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Assign__assign_int_to_any_object(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[3];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_INT
  // SPVM::Util->INT32_MIN
  {
    if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
      SUB_ID_SPVM__Util__INT32_MIN = env->get_sub_id(env, "SPVM::Util", "INT32_MIN", "int()");
      if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[1] = *(int32_t*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Assign";
    const char* sub_name = "assign_int_to_any_object";
    const char* file = "TestCase/Assign.spvm";
    int32_t line = 423;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L28;
  }
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L4: // CONVERT_INT_TO_INT_OBJECT
  {
    int32_t value = int_vars[1];
    int32_t basic_type_id = (intptr_t)(void*)env->int_object_basic_type_id;
    void* object = env->new_object_raw(env, basic_type_id);
    SPVM_VALUE* fields = (SPVM_VALUE*)((intptr_t)object + object_header_byte_size);
    *(int32_t*)&fields[0] = value;
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], object);
  }
L5: // IS_TYPE
  {
    if (BASIC_TYPE_ID_SPVM__Int < 0) {
      BASIC_TYPE_ID_SPVM__Int = env->get_basic_type_id(env, "SPVM::Int");
      if (BASIC_TYPE_ID_SPVM__Int < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found SPVM::Int");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t check_basic_type_id = BASIC_TYPE_ID_SPVM__Int;
    int32_t check_type_dimension = 0;
    void* object = object_vars[0];
    if (object) {
      int32_t object_basic_type_id = *(int32_t*)((intptr_t)object + (intptr_t)env->object_basic_type_id_offset);
      int32_t object_type_dimension = *(uint8_t*)((intptr_t)object + (intptr_t)env->object_type_dimension_offset);
int_vars[0]      = env->is_type(env, object, check_basic_type_id, check_type_dimension);
    }
    else {
int_vars[0]      = 0;
    }
  }
L6: // BOOL_INT
  int_vars[0] = int_vars[0];
L7: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L22; }
L8: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L9: // CHECK_OBJECT_TYPE
  {
    if (BASIC_TYPE_ID_SPVM__Int < 0) {
      BASIC_TYPE_ID_SPVM__Int = env->get_basic_type_id(env, "SPVM::Int");
      if (BASIC_TYPE_ID_SPVM__Int < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found SPVM::Int");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t check_basic_type_id = BASIC_TYPE_ID_SPVM__Int;
    int32_t check_type_dimension = 0;
    void* object = object_vars[0];
    if (object != NULL) {
      int32_t object_basic_type_id = *(int32_t*)((intptr_t)object + (intptr_t)env->object_basic_type_id_offset);
      int32_t object_type_dimension_id = *(uint8_t*)((intptr_t)object + (intptr_t)env->object_type_dimension_offset);
      if (object_basic_type_id == check_basic_type_id && object_type_dimension_id == check_type_dimension) {
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object_vars[0]);
      }
      else {
        void* exception = env->new_string_raw(env, "Can't cast uncompatible type.");
        env->set_exception(env, exception);
        exception_flag = 1;
      }
    }
  }
L10: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Assign";
    const char* sub_name = "assign_int_to_any_object";
    const char* file = "TestCase/Assign.spvm";
    int32_t line = 427;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L28;
  }
L11: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_SPVM__Int__val < 0, 0)) {
      FIELD_ID_SPVM__Int__val = env->get_field_id(env, "SPVM::Int", "val", "int");
      if (FIELD_ID_SPVM__Int__val < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::Int val");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__Int__val = env->get_field_offset(env, FIELD_ID_SPVM__Int__val);
    };
    void* object = object_vars[1];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[3] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__Int__val);
    }
  }
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Assign";
    const char* sub_name = "assign_int_to_any_object";
    const char* file = "TestCase/Assign.spvm";
    int32_t line = 428;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L28;
  }
L13: // CALL_SUB_INT
  // SPVM::Util->INT32_MIN
  {
    if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
      SUB_ID_SPVM__Util__INT32_MIN = env->get_sub_id(env, "SPVM::Util", "INT32_MIN", "int()");
      if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L14: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Assign";
    const char* sub_name = "assign_int_to_any_object";
    const char* file = "TestCase/Assign.spvm";
    int32_t line = 428;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L28;
  }
L15: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[4]);
L16: // BOOL_INT
  int_vars[0] = int_vars[0];
L17: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L21; }
L18: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L19: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L28;
L20: // GOTO
  goto L21;
L21: // GOTO
  goto L23;
L22: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 1;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L23: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 1;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L24: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L25: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L28;
L26: // INIT_INT
  int_vars[7] = 0;
L27: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[7];
  goto L28;
L28: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L29: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Assign__assign_int_to_int_object(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_INT
  // SPVM::Util->INT32_MIN
  {
    if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
      SUB_ID_SPVM__Util__INT32_MIN = env->get_sub_id(env, "SPVM::Util", "INT32_MIN", "int()");
      if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[1] = *(int32_t*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Assign";
    const char* sub_name = "assign_int_to_int_object";
    const char* file = "TestCase/Assign.spvm";
    int32_t line = 349;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L23;
  }
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L4: // CONVERT_INT_TO_INT_OBJECT
  {
    int32_t value = int_vars[1];
    int32_t basic_type_id = (intptr_t)(void*)env->int_object_basic_type_id;
    void* object = env->new_object_raw(env, basic_type_id);
    SPVM_VALUE* fields = (SPVM_VALUE*)((intptr_t)object + object_header_byte_size);
    *(int32_t*)&fields[0] = value;
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], object);
  }
L5: // IS_TYPE
  {
    if (BASIC_TYPE_ID_SPVM__Int < 0) {
      BASIC_TYPE_ID_SPVM__Int = env->get_basic_type_id(env, "SPVM::Int");
      if (BASIC_TYPE_ID_SPVM__Int < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found SPVM::Int");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t check_basic_type_id = BASIC_TYPE_ID_SPVM__Int;
    int32_t check_type_dimension = 0;
    void* object = object_vars[0];
    if (object) {
      int32_t object_basic_type_id = *(int32_t*)((intptr_t)object + (intptr_t)env->object_basic_type_id_offset);
      int32_t object_type_dimension = *(uint8_t*)((intptr_t)object + (intptr_t)env->object_type_dimension_offset);
int_vars[0]      = env->is_type(env, object, check_basic_type_id, check_type_dimension);
    }
    else {
int_vars[0]      = 0;
    }
  }
L6: // BOOL_INT
  int_vars[0] = int_vars[0];
L7: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L19; }
L8: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_SPVM__Int__val < 0, 0)) {
      FIELD_ID_SPVM__Int__val = env->get_field_id(env, "SPVM::Int", "val", "int");
      if (FIELD_ID_SPVM__Int__val < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::Int val");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__Int__val = env->get_field_offset(env, FIELD_ID_SPVM__Int__val);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[3] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__Int__val);
    }
  }
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Assign";
    const char* sub_name = "assign_int_to_int_object";
    const char* file = "TestCase/Assign.spvm";
    int32_t line = 353;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L23;
  }
L10: // CALL_SUB_INT
  // SPVM::Util->INT32_MIN
  {
    if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
      SUB_ID_SPVM__Util__INT32_MIN = env->get_sub_id(env, "SPVM::Util", "INT32_MIN", "int()");
      if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L11: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Assign";
    const char* sub_name = "assign_int_to_int_object";
    const char* file = "TestCase/Assign.spvm";
    int32_t line = 353;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L23;
  }
L12: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[4]);
L13: // BOOL_INT
  int_vars[0] = int_vars[0];
L14: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L18; }
L15: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L16: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L23;
L17: // GOTO
  goto L18;
L18: // GOTO
  goto L19;
L19: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L20: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L23;
L21: // INIT_INT
  int_vars[7] = 0;
L22: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[7];
  goto L23;
L23: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L24: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Assign__assign_long_object_to_long(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int64_t long_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_LONG
  // SPVM::Util->INT64_MIN
  {
    if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
      SUB_ID_SPVM__Util__INT64_MIN = env->get_sub_id(env, "SPVM::Util", "INT64_MIN", "long()");
      if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[0] = *(int64_t*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Assign";
    const char* sub_name = "assign_long_object_to_long";
    const char* file = "TestCase/Assign.spvm";
    int32_t line = 505;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L21;
  }
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L4: // PUSH_ARG_LONG
  *(int64_t*)&stack[0] = long_vars[0];
L5: // CALL_SUB_OBJECT
  // SPVM::Long->new
  {
    if (SUB_ID_SPVM__Long__new < 0) {
      SUB_ID_SPVM__Long__new = env->get_sub_id(env, "SPVM::Long", "new", "SPVM::Long(long)");
      if (SUB_ID_SPVM__Long__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Long new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Long__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Assign";
    const char* sub_name = "assign_long_object_to_long";
    const char* file = "TestCase/Assign.spvm";
    int32_t line = 505;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L21;
  }
L7: // CONVERT_LONG_OBJECT_TO_LONG
  {
    void* object = object_vars[0];
    if (object == NULL) {
      void* exception = env->new_string_raw(env, "Can't convert undef value.");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      int32_t object_basic_type_id = *(int32_t*)((intptr_t)object + (intptr_t)env->object_basic_type_id_offset);
      int32_t object_type_dimension_id = *(uint8_t*)((intptr_t)object + (intptr_t)env->object_type_dimension_offset);
      if (object_basic_type_id == (intptr_t)(void*)env->long_object_basic_type_id && object_type_dimension_id == 0) {
        SPVM_VALUE* fields = (SPVM_VALUE*)((intptr_t)object + object_header_byte_size);
        
long_vars[0] = *(int64_t*)&fields[0];
      }
      else {
        void* exception = env->new_string_raw(env, "Can't convert imcompatible object type.");
        env->set_exception(env, exception);
        exception_flag = 1;
      }
    }
  }
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Assign";
    const char* sub_name = "assign_long_object_to_long";
    const char* file = "TestCase/Assign.spvm";
    int32_t line = 506;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L21;
  }
L9: // CALL_SUB_LONG
  // SPVM::Util->INT64_MIN
  {
    if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
      SUB_ID_SPVM__Util__INT64_MIN = env->get_sub_id(env, "SPVM::Util", "INT64_MIN", "long()");
      if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[1] = *(int64_t*)&stack[0];
    }
  }
L10: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Assign";
    const char* sub_name = "assign_long_object_to_long";
    const char* file = "TestCase/Assign.spvm";
    int32_t line = 508;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L21;
  }
L11: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[1]);
L12: // BOOL_INT
  int_vars[0] = int_vars[0];
L13: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L17; }
L14: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L15: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L21;
L16: // GOTO
  goto L17;
L17: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L18: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L21;
L19: // INIT_INT
  int_vars[6] = 0;
L20: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L21;
L21: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L22: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Assign__assign_long_to_any_object(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int64_t long_vars[3];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[3];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_LONG
  // SPVM::Util->INT64_MIN
  {
    if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
      SUB_ID_SPVM__Util__INT64_MIN = env->get_sub_id(env, "SPVM::Util", "INT64_MIN", "long()");
      if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[0] = *(int64_t*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Assign";
    const char* sub_name = "assign_long_to_any_object";
    const char* file = "TestCase/Assign.spvm";
    int32_t line = 436;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L28;
  }
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L4: // CONVERT_LONG_TO_LONG_OBJECT
  {
    int64_t value = long_vars[0];
    int32_t basic_type_id = (intptr_t)(void*)env->long_object_basic_type_id;
    void* object = env->new_object_raw(env, basic_type_id);
    SPVM_VALUE* fields = (SPVM_VALUE*)((intptr_t)object + object_header_byte_size);
    *(int64_t*)&fields[0] = value;
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], object);
  }
L5: // IS_TYPE
  {
    if (BASIC_TYPE_ID_SPVM__Long < 0) {
      BASIC_TYPE_ID_SPVM__Long = env->get_basic_type_id(env, "SPVM::Long");
      if (BASIC_TYPE_ID_SPVM__Long < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found SPVM::Long");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t check_basic_type_id = BASIC_TYPE_ID_SPVM__Long;
    int32_t check_type_dimension = 0;
    void* object = object_vars[0];
    if (object) {
      int32_t object_basic_type_id = *(int32_t*)((intptr_t)object + (intptr_t)env->object_basic_type_id_offset);
      int32_t object_type_dimension = *(uint8_t*)((intptr_t)object + (intptr_t)env->object_type_dimension_offset);
int_vars[0]      = env->is_type(env, object, check_basic_type_id, check_type_dimension);
    }
    else {
int_vars[0]      = 0;
    }
  }
L6: // BOOL_INT
  int_vars[0] = int_vars[0];
L7: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L22; }
L8: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L9: // CHECK_OBJECT_TYPE
  {
    if (BASIC_TYPE_ID_SPVM__Long < 0) {
      BASIC_TYPE_ID_SPVM__Long = env->get_basic_type_id(env, "SPVM::Long");
      if (BASIC_TYPE_ID_SPVM__Long < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found SPVM::Long");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t check_basic_type_id = BASIC_TYPE_ID_SPVM__Long;
    int32_t check_type_dimension = 0;
    void* object = object_vars[0];
    if (object != NULL) {
      int32_t object_basic_type_id = *(int32_t*)((intptr_t)object + (intptr_t)env->object_basic_type_id_offset);
      int32_t object_type_dimension_id = *(uint8_t*)((intptr_t)object + (intptr_t)env->object_type_dimension_offset);
      if (object_basic_type_id == check_basic_type_id && object_type_dimension_id == check_type_dimension) {
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object_vars[0]);
      }
      else {
        void* exception = env->new_string_raw(env, "Can't cast uncompatible type.");
        env->set_exception(env, exception);
        exception_flag = 1;
      }
    }
  }
L10: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Assign";
    const char* sub_name = "assign_long_to_any_object";
    const char* file = "TestCase/Assign.spvm";
    int32_t line = 440;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L28;
  }
L11: // GET_FIELD_LONG
  {
    if (__builtin_expect(FIELD_ID_SPVM__Long__val < 0, 0)) {
      FIELD_ID_SPVM__Long__val = env->get_field_id(env, "SPVM::Long", "val", "long");
      if (FIELD_ID_SPVM__Long__val < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::Long val");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__Long__val = env->get_field_offset(env, FIELD_ID_SPVM__Long__val);
    };
    void* object = object_vars[1];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      long_vars[1] = *(int64_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__Long__val);
    }
  }
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Assign";
    const char* sub_name = "assign_long_to_any_object";
    const char* file = "TestCase/Assign.spvm";
    int32_t line = 441;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L28;
  }
L13: // CALL_SUB_LONG
  // SPVM::Util->INT64_MIN
  {
    if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
      SUB_ID_SPVM__Util__INT64_MIN = env->get_sub_id(env, "SPVM::Util", "INT64_MIN", "long()");
      if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[2] = *(int64_t*)&stack[0];
    }
  }
L14: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Assign";
    const char* sub_name = "assign_long_to_any_object";
    const char* file = "TestCase/Assign.spvm";
    int32_t line = 441;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L28;
  }
L15: // EQ_LONG
  int_vars[0] = (long_vars[1] == long_vars[2]);
L16: // BOOL_INT
  int_vars[0] = int_vars[0];
L17: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L21; }
L18: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L19: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L28;
L20: // GOTO
  goto L21;
L21: // GOTO
  goto L23;
L22: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 1;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L23: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 1;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L24: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L25: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L28;
L26: // INIT_INT
  int_vars[6] = 0;
L27: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L28;
L28: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L29: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Assign__assign_long_to_long_object(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int64_t long_vars[3];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_LONG
  // SPVM::Util->INT64_MIN
  {
    if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
      SUB_ID_SPVM__Util__INT64_MIN = env->get_sub_id(env, "SPVM::Util", "INT64_MIN", "long()");
      if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[0] = *(int64_t*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Assign";
    const char* sub_name = "assign_long_to_long_object";
    const char* file = "TestCase/Assign.spvm";
    int32_t line = 361;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L23;
  }
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L4: // CONVERT_LONG_TO_LONG_OBJECT
  {
    int64_t value = long_vars[0];
    int32_t basic_type_id = (intptr_t)(void*)env->long_object_basic_type_id;
    void* object = env->new_object_raw(env, basic_type_id);
    SPVM_VALUE* fields = (SPVM_VALUE*)((intptr_t)object + object_header_byte_size);
    *(int64_t*)&fields[0] = value;
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], object);
  }
L5: // IS_TYPE
  {
    if (BASIC_TYPE_ID_SPVM__Long < 0) {
      BASIC_TYPE_ID_SPVM__Long = env->get_basic_type_id(env, "SPVM::Long");
      if (BASIC_TYPE_ID_SPVM__Long < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found SPVM::Long");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t check_basic_type_id = BASIC_TYPE_ID_SPVM__Long;
    int32_t check_type_dimension = 0;
    void* object = object_vars[0];
    if (object) {
      int32_t object_basic_type_id = *(int32_t*)((intptr_t)object + (intptr_t)env->object_basic_type_id_offset);
      int32_t object_type_dimension = *(uint8_t*)((intptr_t)object + (intptr_t)env->object_type_dimension_offset);
int_vars[0]      = env->is_type(env, object, check_basic_type_id, check_type_dimension);
    }
    else {
int_vars[0]      = 0;
    }
  }
L6: // BOOL_INT
  int_vars[0] = int_vars[0];
L7: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L19; }
L8: // GET_FIELD_LONG
  {
    if (__builtin_expect(FIELD_ID_SPVM__Long__val < 0, 0)) {
      FIELD_ID_SPVM__Long__val = env->get_field_id(env, "SPVM::Long", "val", "long");
      if (FIELD_ID_SPVM__Long__val < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::Long val");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__Long__val = env->get_field_offset(env, FIELD_ID_SPVM__Long__val);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      long_vars[1] = *(int64_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__Long__val);
    }
  }
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Assign";
    const char* sub_name = "assign_long_to_long_object";
    const char* file = "TestCase/Assign.spvm";
    int32_t line = 365;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L23;
  }
L10: // CALL_SUB_LONG
  // SPVM::Util->INT64_MIN
  {
    if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
      SUB_ID_SPVM__Util__INT64_MIN = env->get_sub_id(env, "SPVM::Util", "INT64_MIN", "long()");
      if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[2] = *(int64_t*)&stack[0];
    }
  }
L11: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Assign";
    const char* sub_name = "assign_long_to_long_object";
    const char* file = "TestCase/Assign.spvm";
    int32_t line = 365;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L23;
  }
L12: // EQ_LONG
  int_vars[0] = (long_vars[1] == long_vars[2]);
L13: // BOOL_INT
  int_vars[0] = int_vars[0];
L14: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L18; }
L15: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L16: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L23;
L17: // GOTO
  goto L18;
L18: // GOTO
  goto L19;
L19: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L20: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L23;
L21: // INIT_INT
  int_vars[6] = 0;
L22: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L23;
L23: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L24: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Assign__assign_numeric_to_string(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[5] = {0};
  double double_vars[1];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[7];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 25;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // CONVERT_INT_TO_STRING
  {
    sprintf(convert_string_buffer, "%" PRId32, int_vars[1]);
    int32_t string_length = strlen(convert_string_buffer);
    void* string = env->new_string_len_raw(env, convert_string_buffer, string_length);
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], string);
  }
L4: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 0.25;
L5: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L6: // CONVERT_DOUBLE_TO_STRING
  {
    sprintf(convert_string_buffer, "%g", double_vars[0]);
    int32_t string_length = strlen(convert_string_buffer);
    void* string = env->new_string_len_raw(env, convert_string_buffer, string_length);
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], string);
  }
L7: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L8: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], object_vars[0]);
L9: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L10: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], object_vars[1]);
L11: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L12: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], env->new_string_len_raw(env, "\x32\x35", 2));
L13: // STRING_EQ
  {
    void* object1 = object_vars[2];
    void* object2 = object_vars[4];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 0);
    }
  }
L14: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Assign";
    const char* sub_name = "assign_numeric_to_string";
    const char* file = "TestCase/Assign.spvm";
    int32_t line = 317;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L44;
  }
L15: // BOOL_INT
  int_vars[0] = int_vars[0];
L16: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L31; }
L17: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], NULL);
L18: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L19: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], env->new_string_len_raw(env, "\x30\x2E\x32\x35", 4));
L20: // STRING_EQ
  {
    void* object1 = object_vars[3];
    void* object2 = object_vars[4];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 0);
    }
  }
L21: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Assign";
    const char* sub_name = "assign_numeric_to_string";
    const char* file = "TestCase/Assign.spvm";
    int32_t line = 317;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L44;
  }
L22: // BOOL_INT
  int_vars[0] = int_vars[0];
L23: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L28; }
L24: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], NULL);
L25: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L26: // BOOL_INT
  int_vars[0] = int_vars[2];
L27: // GOTO
  goto L30;
L28: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L29: // BOOL_INT
  int_vars[0] = int_vars[3];
L30: // GOTO
  goto L34;
L31: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 5;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L32: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L33: // BOOL_INT
  int_vars[0] = int_vars[4];
L34: // BOOL_INT
  int_vars[0] = int_vars[0];
L35: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L39; }
L36: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L37: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L44;
L38: // GOTO
  goto L39;
L39: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 4;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L40: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L41: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L44;
L42: // INIT_INT
  int_vars[6] = 0;
L43: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L44;
L44: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L45: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Assign__assign_ref(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* ref_vars[2] = {0};
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 1;
L2: // REF_INT
  *(void**)&ref_vars[0] = &int_vars[1];
L3: // MOVE_REF
  ref_vars[1] = ref_vars[0];
L4: // GET_DEREF_INT
  int_vars[3] = *(int32_t*)*(void**)&ref_vars[1];
L5: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L6: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[4]);
L7: // BOOL_INT
  int_vars[0] = int_vars[0];
L8: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L12; }
L9: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L10: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L16;
L11: // GOTO
  goto L12;
L12: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L13: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L16;
L14: // INIT_INT
  int_vars[7] = 0;
L15: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[7];
  goto L16;
L16: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Assign__assign_return_value_array_access_chain(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 2;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_INT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_int_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Assign";
    const char* sub_name = "assign_return_value_array_access_chain";
    const char* file = "TestCase/Assign.spvm";
    int32_t line = 223;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L58;
  }
L5: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L6: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L7: // ARRAY_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[2];
      } 
    } 
  } 
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Assign";
    const char* sub_name = "assign_return_value_array_access_chain";
    const char* file = "TestCase/Assign.spvm";
    int32_t line = 225;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L58;
  }
L9: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L10: // ARRAY_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[2];
      } 
    } 
  } 
L11: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Assign";
    const char* sub_name = "assign_return_value_array_access_chain";
    const char* file = "TestCase/Assign.spvm";
    int32_t line = 225;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L58;
  }
L12: // MOVE_INT
  int_vars[5] = int_vars[2];
L13: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L14: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[2]);
L15: // BOOL_INT
  int_vars[0] = int_vars[0];
L16: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L30; }
L17: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L18: // ARRAY_FETCH_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[3] = ((int32_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L19: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Assign";
    const char* sub_name = "assign_return_value_array_access_chain";
    const char* file = "TestCase/Assign.spvm";
    int32_t line = 227;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L58;
  }
L20: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L21: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[4]);
L22: // BOOL_INT
  int_vars[0] = int_vars[0];
L23: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L27; }
L24: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L25: // BOOL_INT
  int_vars[0] = int_vars[2];
L26: // GOTO
  goto L29;
L27: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L28: // BOOL_INT
  int_vars[0] = int_vars[3];
L29: // GOTO
  goto L32;
L30: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L31: // BOOL_INT
  int_vars[0] = int_vars[4];
L32: // BOOL_INT
  int_vars[0] = int_vars[0];
L33: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L47; }
L34: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L35: // ARRAY_FETCH_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[3] = ((int32_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L36: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Assign";
    const char* sub_name = "assign_return_value_array_access_chain";
    const char* file = "TestCase/Assign.spvm";
    int32_t line = 227;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L58;
  }
L37: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L38: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[4]);
L39: // BOOL_INT
  int_vars[0] = int_vars[0];
L40: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L44; }
L41: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L42: // BOOL_INT
  int_vars[0] = int_vars[2];
L43: // GOTO
  goto L46;
L44: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L45: // BOOL_INT
  int_vars[0] = int_vars[3];
L46: // GOTO
  goto L49;
L47: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L48: // BOOL_INT
  int_vars[0] = int_vars[4];
L49: // BOOL_INT
  int_vars[0] = int_vars[0];
L50: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L54; }
L51: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L52: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L58;
L53: // GOTO
  goto L54;
L54: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L55: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L58;
L56: // INIT_INT
  int_vars[7] = 0;
L57: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[7];
  goto L58;
L58: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L59: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Assign__assign_return_value_array_access_left_var(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int32_t int_vars[10];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 1;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_INT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_int_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Assign";
    const char* sub_name = "assign_return_value_array_access_left_var";
    const char* file = "TestCase/Assign.spvm";
    int32_t line = 210;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L39;
  }
L5: // INIT_INT
  int_vars[2] = 0;
L6: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L7: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L8: // ARRAY_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[3];
      } 
    } 
  } 
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Assign";
    const char* sub_name = "assign_return_value_array_access_left_var";
    const char* file = "TestCase/Assign.spvm";
    int32_t line = 213;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L39;
  }
L10: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L11: // ARRAY_FETCH_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[2] = ((int32_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Assign";
    const char* sub_name = "assign_return_value_array_access_left_var";
    const char* file = "TestCase/Assign.spvm";
    int32_t line = 214;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L39;
  }
L13: // MOVE_INT
  int_vars[4] = int_vars[2];
L14: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L15: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[3]);
L16: // BOOL_INT
  int_vars[0] = int_vars[0];
L17: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L28; }
L18: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L19: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L20: // BOOL_INT
  int_vars[0] = int_vars[0];
L21: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L25; }
L22: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L23: // BOOL_INT
  int_vars[0] = int_vars[3];
L24: // GOTO
  goto L27;
L25: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L26: // BOOL_INT
  int_vars[0] = int_vars[5];
L27: // GOTO
  goto L30;
L28: // MOVE_CONSTANT_INT
  int_vars[6] = 0;
L29: // BOOL_INT
  int_vars[0] = int_vars[6];
L30: // BOOL_INT
  int_vars[0] = int_vars[0];
L31: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L35; }
L32: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L33: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L39;
L34: // GOTO
  goto L35;
L35: // MOVE_CONSTANT_INT
  int_vars[6] = 0;
L36: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L39;
L37: // INIT_INT
  int_vars[8] = 0;
L38: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[8];
  goto L39;
L39: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L40: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Assign__assign_return_value_array_access_right_not_var(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 1;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_INT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_int_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Assign";
    const char* sub_name = "assign_return_value_array_access_right_not_var";
    const char* file = "TestCase/Assign.spvm";
    int32_t line = 199;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L21;
  }
L5: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L6: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L7: // ARRAY_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[2];
      } 
    } 
  } 
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Assign";
    const char* sub_name = "assign_return_value_array_access_right_not_var";
    const char* file = "TestCase/Assign.spvm";
    int32_t line = 201;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L21;
  }
L9: // MOVE_INT
  int_vars[4] = int_vars[2];
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L11: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[2]);
L12: // BOOL_INT
  int_vars[0] = int_vars[0];
L13: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L17; }
L14: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L15: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L21;
L16: // GOTO
  goto L17;
L17: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L18: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L21;
L19: // INIT_INT
  int_vars[7] = 0;
L20: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[7];
  goto L21;
L21: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L22: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Assign__assign_return_value_array_access_right_var(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int32_t int_vars[10];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 1;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_INT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_int_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Assign";
    const char* sub_name = "assign_return_value_array_access_right_var";
    const char* file = "TestCase/Assign.spvm";
    int32_t line = 187;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L21;
  }
L5: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L6: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L7: // ARRAY_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[2];
      } 
    } 
  } 
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Assign";
    const char* sub_name = "assign_return_value_array_access_right_var";
    const char* file = "TestCase/Assign.spvm";
    int32_t line = 190;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L21;
  }
L9: // MOVE_INT
  int_vars[4] = int_vars[2];
L10: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L11: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[3]);
L12: // BOOL_INT
  int_vars[0] = int_vars[0];
L13: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L17; }
L14: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L15: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L21;
L16: // GOTO
  goto L17;
L17: // MOVE_CONSTANT_INT
  int_vars[6] = 0;
L18: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L21;
L19: // INIT_INT
  int_vars[8] = 0;
L20: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[8];
  goto L21;
L21: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L22: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Assign__assign_return_value_byte(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int8_t byte_vars[3];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // INIT_BYTE
  byte_vars[0] = 0;
L2: // INIT_BYTE
  byte_vars[1] = 0;
L3: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MIN
  {
    if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
      SUB_ID_SPVM__Util__INT8_MIN = env->get_sub_id(env, "SPVM::Util", "INT8_MIN", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[2] = *(int8_t*)&stack[0];
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Assign";
    const char* sub_name = "assign_return_value_byte";
    const char* file = "TestCase/Assign.spvm";
    int32_t line = 79;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L21;
  }
L5: // MOVE_BYTE
  byte_vars[0] = byte_vars[2];
L6: // MOVE_BYTE
  byte_vars[1] = byte_vars[0];
L7: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[1];
L8: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MIN
  {
    if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
      SUB_ID_SPVM__Util__INT8_MIN = env->get_sub_id(env, "SPVM::Util", "INT8_MIN", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[2] = *(int8_t*)&stack[0];
    }
  }
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Assign";
    const char* sub_name = "assign_return_value_byte";
    const char* file = "TestCase/Assign.spvm";
    int32_t line = 81;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L21;
  }
L10: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[2];
L11: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L12: // BOOL_INT
  int_vars[0] = int_vars[0];
L13: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L17; }
L14: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L15: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L21;
L16: // GOTO
  goto L17;
L17: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L18: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L21;
L19: // INIT_INT
  int_vars[6] = 0;
L20: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L21;
L21: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Assign__assign_return_value_constant(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[11];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // INIT_INT
  int_vars[1] = 0;
L2: // INIT_INT
  int_vars[3] = 0;
L3: // INIT_INT
  int_vars[4] = 0;
L4: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L5: // MOVE_INT
  int_vars[4] = int_vars[3];
L6: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L7: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L8: // BOOL_INT
  int_vars[0] = int_vars[0];
L9: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L13; }
L10: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L11: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L17;
L12: // GOTO
  goto L13;
L13: // MOVE_CONSTANT_INT
  int_vars[7] = 0;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[7];
  goto L17;
L15: // INIT_INT
  int_vars[9] = 0;
L16: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[9];
  goto L17;
L17: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Assign__assign_return_value_double(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[3];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // INIT_DOUBLE
  double_vars[0] = 0;
L2: // INIT_DOUBLE
  double_vars[1] = 0;
L3: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MIN
  {
    if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
      SUB_ID_SPVM__Util__DBL_MIN = env->get_sub_id(env, "SPVM::Util", "DBL_MIN", "double()");
      if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[2] = *(double*)&stack[0];
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Assign";
    const char* sub_name = "assign_return_value_double";
    const char* file = "TestCase/Assign.spvm";
    int32_t line = 139;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L19;
  }
L5: // MOVE_DOUBLE
  double_vars[0] = double_vars[2];
L6: // MOVE_DOUBLE
  double_vars[1] = double_vars[0];
L7: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MIN
  {
    if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
      SUB_ID_SPVM__Util__DBL_MIN = env->get_sub_id(env, "SPVM::Util", "DBL_MIN", "double()");
      if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[2] = *(double*)&stack[0];
    }
  }
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Assign";
    const char* sub_name = "assign_return_value_double";
    const char* file = "TestCase/Assign.spvm";
    int32_t line = 141;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L19;
  }
L9: // EQ_DOUBLE
  int_vars[0] = (double_vars[1] == double_vars[2]);
L10: // BOOL_INT
  int_vars[0] = int_vars[0];
L11: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L15; }
L12: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L13: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L19;
L14: // GOTO
  goto L15;
L15: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L16: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L19;
L17: // INIT_INT
  int_vars[6] = 0;
L18: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L19;
L19: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Assign__assign_return_value_field_access(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // INIT_INT
  int_vars[1] = 0;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // CALL_SUB_OBJECT
  // TestCase::Minimal->new
  {
    if (SUB_ID_TestCase__Minimal__new < 0) {
      SUB_ID_TestCase__Minimal__new = env->get_sub_id(env, "TestCase::Minimal", "new", "TestCase::Minimal()");
      if (SUB_ID_TestCase__Minimal__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Minimal new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Minimal__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Assign";
    const char* sub_name = "assign_return_value_field_access";
    const char* file = "TestCase/Assign.spvm";
    int32_t line = 236;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L20;
  }
L5: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L6: // SET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Minimal__x < 0, 0)) {
      FIELD_ID_TestCase__Minimal__x = env->get_field_id(env, "TestCase::Minimal", "x", "int");
      if (FIELD_ID_TestCase__Minimal__x < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Minimal x");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Minimal__x = env->get_field_offset(env, FIELD_ID_TestCase__Minimal__x);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Minimal__x) = int_vars[3];
    }
  }
L7: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Assign";
    const char* sub_name = "assign_return_value_field_access";
    const char* file = "TestCase/Assign.spvm";
    int32_t line = 237;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L20;
  }
L8: // MOVE_INT
  int_vars[1] = int_vars[3];
L9: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L10: // EQ_INT
  int_vars[0] = (int_vars[1] == int_vars[3]);
L11: // BOOL_INT
  int_vars[0] = int_vars[0];
L12: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L16; }
L13: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L20;
L15: // GOTO
  goto L16;
L16: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L17: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L20;
L18: // INIT_INT
  int_vars[7] = 0;
L19: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[7];
  goto L20;
L20: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L21: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Assign__assign_return_value_float(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  float float_vars[3];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // INIT_FLOAT
  float_vars[0] = 0;
L2: // INIT_FLOAT
  float_vars[1] = 0;
L3: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MIN
  {
    if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
      SUB_ID_SPVM__Util__FLT_MIN = env->get_sub_id(env, "SPVM::Util", "FLT_MIN", "float()");
      if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[2] = *(float*)&stack[0];
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Assign";
    const char* sub_name = "assign_return_value_float";
    const char* file = "TestCase/Assign.spvm";
    int32_t line = 127;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L19;
  }
L5: // MOVE_FLOAT
  float_vars[0] = float_vars[2];
L6: // MOVE_FLOAT
  float_vars[1] = float_vars[0];
L7: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MIN
  {
    if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
      SUB_ID_SPVM__Util__FLT_MIN = env->get_sub_id(env, "SPVM::Util", "FLT_MIN", "float()");
      if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[2] = *(float*)&stack[0];
    }
  }
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Assign";
    const char* sub_name = "assign_return_value_float";
    const char* file = "TestCase/Assign.spvm";
    int32_t line = 129;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L19;
  }
L9: // EQ_FLOAT
  int_vars[0] = (float_vars[1] == float_vars[2]);
L10: // BOOL_INT
  int_vars[0] = int_vars[0];
L11: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L15; }
L12: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L13: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L19;
L14: // GOTO
  goto L15;
L15: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L16: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L19;
L17: // INIT_INT
  int_vars[6] = 0;
L18: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L19;
L19: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Assign__assign_return_value_int(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[10];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // INIT_INT
  int_vars[1] = 0;
L2: // INIT_INT
  int_vars[3] = 0;
L3: // CALL_SUB_INT
  // SPVM::Util->INT32_MIN
  {
    if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
      SUB_ID_SPVM__Util__INT32_MIN = env->get_sub_id(env, "SPVM::Util", "INT32_MIN", "int()");
      if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Assign";
    const char* sub_name = "assign_return_value_int";
    const char* file = "TestCase/Assign.spvm";
    int32_t line = 103;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L19;
  }
L5: // MOVE_INT
  int_vars[1] = int_vars[4];
L6: // MOVE_INT
  int_vars[3] = int_vars[1];
L7: // CALL_SUB_INT
  // SPVM::Util->INT32_MIN
  {
    if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
      SUB_ID_SPVM__Util__INT32_MIN = env->get_sub_id(env, "SPVM::Util", "INT32_MIN", "int()");
      if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Assign";
    const char* sub_name = "assign_return_value_int";
    const char* file = "TestCase/Assign.spvm";
    int32_t line = 105;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L19;
  }
L9: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[4]);
L10: // BOOL_INT
  int_vars[0] = int_vars[0];
L11: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L15; }
L12: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L13: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L19;
L14: // GOTO
  goto L15;
L15: // MOVE_CONSTANT_INT
  int_vars[6] = 0;
L16: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L19;
L17: // INIT_INT
  int_vars[8] = 0;
L18: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[8];
  goto L19;
L19: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Assign__assign_return_value_long(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int64_t long_vars[3];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // INIT_LONG
  long_vars[0] = 0;
L2: // INIT_LONG
  long_vars[1] = 0;
L3: // CALL_SUB_LONG
  // SPVM::Util->INT64_MIN
  {
    if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
      SUB_ID_SPVM__Util__INT64_MIN = env->get_sub_id(env, "SPVM::Util", "INT64_MIN", "long()");
      if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[2] = *(int64_t*)&stack[0];
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Assign";
    const char* sub_name = "assign_return_value_long";
    const char* file = "TestCase/Assign.spvm";
    int32_t line = 115;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L19;
  }
L5: // MOVE_LONG
  long_vars[0] = long_vars[2];
L6: // MOVE_LONG
  long_vars[1] = long_vars[0];
L7: // CALL_SUB_LONG
  // SPVM::Util->INT64_MIN
  {
    if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
      SUB_ID_SPVM__Util__INT64_MIN = env->get_sub_id(env, "SPVM::Util", "INT64_MIN", "long()");
      if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[2] = *(int64_t*)&stack[0];
    }
  }
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Assign";
    const char* sub_name = "assign_return_value_long";
    const char* file = "TestCase/Assign.spvm";
    int32_t line = 117;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L19;
  }
L9: // EQ_LONG
  int_vars[0] = (long_vars[1] == long_vars[2]);
L10: // BOOL_INT
  int_vars[0] = int_vars[0];
L11: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L15; }
L12: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L13: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L19;
L14: // GOTO
  goto L15;
L15: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L16: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L19;
L17: // INIT_INT
  int_vars[6] = 0;
L18: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L19;
L19: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Assign__assign_return_value_multi_numeric_type(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[8];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // INIT_MULNUM_DOUBLE
  double_vars[0] = 0;
  double_vars[1] = 0;
L2: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L3: // CONVERT_INT_TO_DOUBLE
  double_vars[2] = (double)int_vars[2];
L4: // MULNUM_SET_FIELD_DOUBLE
  double_vars[0] = double_vars[2];
L5: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L6: // CONVERT_INT_TO_DOUBLE
  double_vars[2] = (double)int_vars[2];
L7: // MULNUM_SET_FIELD_DOUBLE
  double_vars[1] = double_vars[2];
L8: // INIT_MULNUM_DOUBLE
  double_vars[3] = 0;
  double_vars[4] = 0;
L9: // INIT_MULNUM_DOUBLE
  double_vars[5] = 0;
  double_vars[6] = 0;
L10: // MULNUM_MOVE_DOUBLE
  double_vars[3] = double_vars[0];
  double_vars[4] = double_vars[1];
L11: // MULNUM_MOVE_DOUBLE
  double_vars[5] = double_vars[0];
  double_vars[6] = double_vars[1];
L12: // MULNUM_GET_FIELD_DOUBLE
  double_vars[2] = double_vars[5];
L13: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L14: // CONVERT_INT_TO_DOUBLE
  double_vars[7] = (double)int_vars[2];
L15: // EQ_DOUBLE
  int_vars[0] = (double_vars[2] == double_vars[7]);
L16: // BOOL_INT
  int_vars[0] = int_vars[0];
L17: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L30; }
L18: // MULNUM_GET_FIELD_DOUBLE
  double_vars[2] = double_vars[6];
L19: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L20: // CONVERT_INT_TO_DOUBLE
  double_vars[7] = (double)int_vars[2];
L21: // EQ_DOUBLE
  int_vars[0] = (double_vars[2] == double_vars[7]);
L22: // BOOL_INT
  int_vars[0] = int_vars[0];
L23: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L27; }
L24: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L25: // BOOL_INT
  int_vars[0] = int_vars[2];
L26: // GOTO
  goto L29;
L27: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L28: // BOOL_INT
  int_vars[0] = int_vars[3];
L29: // GOTO
  goto L32;
L30: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L31: // BOOL_INT
  int_vars[0] = int_vars[4];
L32: // BOOL_INT
  int_vars[0] = int_vars[0];
L33: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L46; }
L34: // MULNUM_GET_FIELD_DOUBLE
  double_vars[2] = double_vars[3];
L35: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L36: // CONVERT_INT_TO_DOUBLE
  double_vars[7] = (double)int_vars[2];
L37: // EQ_DOUBLE
  int_vars[0] = (double_vars[2] == double_vars[7]);
L38: // BOOL_INT
  int_vars[0] = int_vars[0];
L39: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L43; }
L40: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L41: // BOOL_INT
  int_vars[0] = int_vars[2];
L42: // GOTO
  goto L45;
L43: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L44: // BOOL_INT
  int_vars[0] = int_vars[3];
L45: // GOTO
  goto L48;
L46: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L47: // BOOL_INT
  int_vars[0] = int_vars[4];
L48: // BOOL_INT
  int_vars[0] = int_vars[0];
L49: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L62; }
L50: // MULNUM_GET_FIELD_DOUBLE
  double_vars[2] = double_vars[4];
L51: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L52: // CONVERT_INT_TO_DOUBLE
  double_vars[7] = (double)int_vars[2];
L53: // EQ_DOUBLE
  int_vars[0] = (double_vars[2] == double_vars[7]);
L54: // BOOL_INT
  int_vars[0] = int_vars[0];
L55: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L59; }
L56: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L57: // BOOL_INT
  int_vars[0] = int_vars[2];
L58: // GOTO
  goto L61;
L59: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L60: // BOOL_INT
  int_vars[0] = int_vars[3];
L61: // GOTO
  goto L64;
L62: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L63: // BOOL_INT
  int_vars[0] = int_vars[4];
L64: // BOOL_INT
  int_vars[0] = int_vars[0];
L65: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L69; }
L66: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L67: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L73;
L68: // GOTO
  goto L69;
L69: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L70: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L73;
L71: // INIT_INT
  int_vars[6] = 0;
L72: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L73;
L73: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Assign__assign_return_value_my_var(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 1;
L2: // BOOL_INT
  int_vars[0] = int_vars[1];
L3: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L7; }
L4: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L5: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L11;
L6: // GOTO
  goto L7;
L7: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L8: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[1];
  goto L11;
L9: // INIT_INT
  int_vars[6] = 0;
L10: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L11;
L11: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Assign__assign_return_value_object(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[3];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L4: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L5: // CALL_SUB_OBJECT
  // TestCase::Minimal->new
  {
    if (SUB_ID_TestCase__Minimal__new < 0) {
      SUB_ID_TestCase__Minimal__new = env->get_sub_id(env, "TestCase::Minimal", "new", "TestCase::Minimal()");
      if (SUB_ID_TestCase__Minimal__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Minimal new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Minimal__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Assign";
    const char* sub_name = "assign_return_value_object";
    const char* file = "TestCase/Assign.spvm";
    int32_t line = 178;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L18;
  }
L7: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object_vars[0]);
L8: // IS_TYPE
  {
    if (BASIC_TYPE_ID_TestCase__Minimal < 0) {
      BASIC_TYPE_ID_TestCase__Minimal = env->get_basic_type_id(env, "TestCase::Minimal");
      if (BASIC_TYPE_ID_TestCase__Minimal < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase::Minimal");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t check_basic_type_id = BASIC_TYPE_ID_TestCase__Minimal;
    int32_t check_type_dimension = 0;
    void* object = object_vars[1];
    if (object) {
      int32_t object_basic_type_id = *(int32_t*)((intptr_t)object + (intptr_t)env->object_basic_type_id_offset);
      int32_t object_type_dimension = *(uint8_t*)((intptr_t)object + (intptr_t)env->object_type_dimension_offset);
int_vars[0]      = env->is_type(env, object, check_basic_type_id, check_type_dimension);
    }
    else {
int_vars[0]      = 0;
    }
  }
L9: // BOOL_INT
  int_vars[0] = int_vars[0];
L10: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L14; }
L11: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L18;
L13: // GOTO
  goto L14;
L14: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L15: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L18;
L16: // INIT_INT
  int_vars[6] = 0;
L17: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L18;
L18: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L19: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Assign__assign_return_value_ref(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* ref_vars[2] = {0};
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 1;
L2: // REF_INT
  *(void**)&ref_vars[1] = &int_vars[1];
L3: // MOVE_REF
  ref_vars[0] = ref_vars[1];
L4: // GET_DEREF_INT
  int_vars[3] = *(int32_t*)*(void**)&ref_vars[0];
L5: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L6: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[4]);
L7: // BOOL_INT
  int_vars[0] = int_vars[0];
L8: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L20; }
L9: // GET_DEREF_INT
  int_vars[3] = *(int32_t*)*(void**)&ref_vars[1];
L10: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L11: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[4]);
L12: // BOOL_INT
  int_vars[0] = int_vars[0];
L13: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L17; }
L14: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L15: // BOOL_INT
  int_vars[0] = int_vars[3];
L16: // GOTO
  goto L19;
L17: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L18: // BOOL_INT
  int_vars[0] = int_vars[4];
L19: // GOTO
  goto L22;
L20: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L21: // BOOL_INT
  int_vars[0] = int_vars[5];
L22: // BOOL_INT
  int_vars[0] = int_vars[0];
L23: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L27; }
L24: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L25: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L31;
L26: // GOTO
  goto L27;
L27: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L28: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L31;
L29: // INIT_INT
  int_vars[7] = 0;
L30: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[7];
  goto L31;
L31: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Assign__assign_return_value_short(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[3];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // INIT_SHORT
  short_vars[0] = 0;
L2: // INIT_SHORT
  short_vars[1] = 0;
L3: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MIN
  {
    if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
      SUB_ID_SPVM__Util__INT16_MIN = env->get_sub_id(env, "SPVM::Util", "INT16_MIN", "short()");
      if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[2] = *(int16_t*)&stack[0];
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Assign";
    const char* sub_name = "assign_return_value_short";
    const char* file = "TestCase/Assign.spvm";
    int32_t line = 91;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L21;
  }
L5: // MOVE_SHORT
  short_vars[0] = short_vars[2];
L6: // MOVE_SHORT
  short_vars[1] = short_vars[0];
L7: // CONVERT_SHORT_TO_INT
  int_vars[2] = (int32_t)short_vars[1];
L8: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MIN
  {
    if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
      SUB_ID_SPVM__Util__INT16_MIN = env->get_sub_id(env, "SPVM::Util", "INT16_MIN", "short()");
      if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[2] = *(int16_t*)&stack[0];
    }
  }
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Assign";
    const char* sub_name = "assign_return_value_short";
    const char* file = "TestCase/Assign.spvm";
    int32_t line = 93;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L21;
  }
L10: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[2];
L11: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L12: // BOOL_INT
  int_vars[0] = int_vars[0];
L13: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L17; }
L14: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L15: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L21;
L16: // GOTO
  goto L17;
L17: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L18: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L21;
L19: // INIT_INT
  int_vars[6] = 0;
L20: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L21;
L21: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Assign__assign_return_value_value_field(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[5];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // INIT_MULNUM_DOUBLE
  double_vars[0] = 0;
  double_vars[1] = 0;
L2: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L3: // CONVERT_INT_TO_DOUBLE
  double_vars[2] = (double)int_vars[2];
L4: // MULNUM_SET_FIELD_DOUBLE
  double_vars[1] = double_vars[2];
L5: // INIT_DOUBLE
  double_vars[2] = 0;
L6: // INIT_DOUBLE
  double_vars[3] = 0;
L7: // MULNUM_GET_FIELD_DOUBLE
  double_vars[3] = double_vars[1];
L8: // MOVE_DOUBLE
  double_vars[2] = double_vars[3];
L9: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L10: // CONVERT_INT_TO_DOUBLE
  double_vars[4] = (double)int_vars[2];
L11: // EQ_DOUBLE
  int_vars[0] = (double_vars[2] == double_vars[4]);
L12: // BOOL_INT
  int_vars[0] = int_vars[0];
L13: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L25; }
L14: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L15: // CONVERT_INT_TO_DOUBLE
  double_vars[4] = (double)int_vars[2];
L16: // EQ_DOUBLE
  int_vars[0] = (double_vars[3] == double_vars[4]);
L17: // BOOL_INT
  int_vars[0] = int_vars[0];
L18: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L22; }
L19: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L20: // BOOL_INT
  int_vars[0] = int_vars[2];
L21: // GOTO
  goto L24;
L22: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L23: // BOOL_INT
  int_vars[0] = int_vars[3];
L24: // GOTO
  goto L27;
L25: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L26: // BOOL_INT
  int_vars[0] = int_vars[4];
L27: // BOOL_INT
  int_vars[0] = int_vars[0];
L28: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L32; }
L29: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L30: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L36;
L31: // GOTO
  goto L32;
L32: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L33: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L36;
L34: // INIT_INT
  int_vars[6] = 0;
L35: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L36;
L36: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Assign__assign_return_value_var(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[11];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // INIT_INT
  int_vars[1] = 0;
L2: // INIT_INT
  int_vars[3] = 0;
L3: // INIT_INT
  int_vars[4] = 0;
L4: // MOVE_CONSTANT_INT
  int_vars[1] = 1;
L5: // MOVE_INT
  int_vars[3] = int_vars[1];
L6: // MOVE_INT
  int_vars[4] = int_vars[1];
L7: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L8: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L9: // BOOL_INT
  int_vars[0] = int_vars[0];
L10: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L21; }
L11: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L12: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[5]);
L13: // BOOL_INT
  int_vars[0] = int_vars[0];
L14: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L18; }
L15: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L16: // BOOL_INT
  int_vars[0] = int_vars[5];
L17: // GOTO
  goto L20;
L18: // MOVE_CONSTANT_INT
  int_vars[6] = 0;
L19: // BOOL_INT
  int_vars[0] = int_vars[6];
L20: // GOTO
  goto L23;
L21: // MOVE_CONSTANT_INT
  int_vars[7] = 0;
L22: // BOOL_INT
  int_vars[0] = int_vars[7];
L23: // BOOL_INT
  int_vars[0] = int_vars[0];
L24: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L28; }
L25: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L26: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L32;
L27: // GOTO
  goto L28;
L28: // MOVE_CONSTANT_INT
  int_vars[7] = 0;
L29: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[7];
  goto L32;
L30: // INIT_INT
  int_vars[9] = 0;
L31: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[9];
  goto L32;
L32: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Assign__assign_short_object_to_short(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[2];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MIN
  {
    if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
      SUB_ID_SPVM__Util__INT16_MIN = env->get_sub_id(env, "SPVM::Util", "INT16_MIN", "short()");
      if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[0] = *(int16_t*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Assign";
    const char* sub_name = "assign_short_object_to_short";
    const char* file = "TestCase/Assign.spvm";
    int32_t line = 485;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L23;
  }
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L4: // PUSH_ARG_SHORT
  *(int16_t*)&stack[0] = short_vars[0];
L5: // CALL_SUB_OBJECT
  // SPVM::Short->new
  {
    if (SUB_ID_SPVM__Short__new < 0) {
      SUB_ID_SPVM__Short__new = env->get_sub_id(env, "SPVM::Short", "new", "SPVM::Short(short)");
      if (SUB_ID_SPVM__Short__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Short new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Short__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Assign";
    const char* sub_name = "assign_short_object_to_short";
    const char* file = "TestCase/Assign.spvm";
    int32_t line = 485;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L23;
  }
L7: // CONVERT_SHORT_OBJECT_TO_SHORT
  {
    void* object = object_vars[0];
    if (object == NULL) {
      void* exception = env->new_string_raw(env, "Can't convert undef value.");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      int32_t object_basic_type_id = *(int32_t*)((intptr_t)object + (intptr_t)env->object_basic_type_id_offset);
      int32_t object_type_dimension_id = *(uint8_t*)((intptr_t)object + (intptr_t)env->object_type_dimension_offset);
      if (object_basic_type_id == (intptr_t)(void*)env->short_object_basic_type_id && object_type_dimension_id == 0) {
        SPVM_VALUE* fields = (SPVM_VALUE*)((intptr_t)object + object_header_byte_size);
        
short_vars[0] = *(int16_t*)&fields[0];
      }
      else {
        void* exception = env->new_string_raw(env, "Can't convert imcompatible object type.");
        env->set_exception(env, exception);
        exception_flag = 1;
      }
    }
  }
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Assign";
    const char* sub_name = "assign_short_object_to_short";
    const char* file = "TestCase/Assign.spvm";
    int32_t line = 486;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L23;
  }
L9: // CONVERT_SHORT_TO_INT
  int_vars[2] = (int32_t)short_vars[0];
L10: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MIN
  {
    if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
      SUB_ID_SPVM__Util__INT16_MIN = env->get_sub_id(env, "SPVM::Util", "INT16_MIN", "short()");
      if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[1] = *(int16_t*)&stack[0];
    }
  }
L11: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Assign";
    const char* sub_name = "assign_short_object_to_short";
    const char* file = "TestCase/Assign.spvm";
    int32_t line = 488;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L23;
  }
L12: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[1];
L13: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L14: // BOOL_INT
  int_vars[0] = int_vars[0];
L15: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L19; }
L16: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L17: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L23;
L18: // GOTO
  goto L19;
L19: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L20: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L23;
L21: // INIT_INT
  int_vars[6] = 0;
L22: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L23;
L23: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L24: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Assign__assign_short_to_any_object(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[3];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[3];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MIN
  {
    if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
      SUB_ID_SPVM__Util__INT16_MIN = env->get_sub_id(env, "SPVM::Util", "INT16_MIN", "short()");
      if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[0] = *(int16_t*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Assign";
    const char* sub_name = "assign_short_to_any_object";
    const char* file = "TestCase/Assign.spvm";
    int32_t line = 410;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L30;
  }
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L4: // CONVERT_SHORT_TO_SHORT_OBJECT
  {
    int16_t value = short_vars[0];
    int32_t basic_type_id = (intptr_t)(void*)env->short_object_basic_type_id;
    void* object = env->new_object_raw(env, basic_type_id);
    SPVM_VALUE* fields = (SPVM_VALUE*)((intptr_t)object + object_header_byte_size);
    *(int16_t*)&fields[0] = value;
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], object);
  }
L5: // IS_TYPE
  {
    if (BASIC_TYPE_ID_SPVM__Short < 0) {
      BASIC_TYPE_ID_SPVM__Short = env->get_basic_type_id(env, "SPVM::Short");
      if (BASIC_TYPE_ID_SPVM__Short < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found SPVM::Short");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t check_basic_type_id = BASIC_TYPE_ID_SPVM__Short;
    int32_t check_type_dimension = 0;
    void* object = object_vars[0];
    if (object) {
      int32_t object_basic_type_id = *(int32_t*)((intptr_t)object + (intptr_t)env->object_basic_type_id_offset);
      int32_t object_type_dimension = *(uint8_t*)((intptr_t)object + (intptr_t)env->object_type_dimension_offset);
int_vars[0]      = env->is_type(env, object, check_basic_type_id, check_type_dimension);
    }
    else {
int_vars[0]      = 0;
    }
  }
L6: // BOOL_INT
  int_vars[0] = int_vars[0];
L7: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L24; }
L8: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L9: // CHECK_OBJECT_TYPE
  {
    if (BASIC_TYPE_ID_SPVM__Short < 0) {
      BASIC_TYPE_ID_SPVM__Short = env->get_basic_type_id(env, "SPVM::Short");
      if (BASIC_TYPE_ID_SPVM__Short < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found SPVM::Short");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t check_basic_type_id = BASIC_TYPE_ID_SPVM__Short;
    int32_t check_type_dimension = 0;
    void* object = object_vars[0];
    if (object != NULL) {
      int32_t object_basic_type_id = *(int32_t*)((intptr_t)object + (intptr_t)env->object_basic_type_id_offset);
      int32_t object_type_dimension_id = *(uint8_t*)((intptr_t)object + (intptr_t)env->object_type_dimension_offset);
      if (object_basic_type_id == check_basic_type_id && object_type_dimension_id == check_type_dimension) {
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object_vars[0]);
      }
      else {
        void* exception = env->new_string_raw(env, "Can't cast uncompatible type.");
        env->set_exception(env, exception);
        exception_flag = 1;
      }
    }
  }
L10: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Assign";
    const char* sub_name = "assign_short_to_any_object";
    const char* file = "TestCase/Assign.spvm";
    int32_t line = 414;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L30;
  }
L11: // GET_FIELD_SHORT
  {
    if (__builtin_expect(FIELD_ID_SPVM__Short__val < 0, 0)) {
      FIELD_ID_SPVM__Short__val = env->get_field_id(env, "SPVM::Short", "val", "short");
      if (FIELD_ID_SPVM__Short__val < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::Short val");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__Short__val = env->get_field_offset(env, FIELD_ID_SPVM__Short__val);
    };
    void* object = object_vars[1];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      short_vars[1] = *(int16_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__Short__val);
    }
  }
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Assign";
    const char* sub_name = "assign_short_to_any_object";
    const char* file = "TestCase/Assign.spvm";
    int32_t line = 415;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L30;
  }
L13: // CONVERT_SHORT_TO_INT
  int_vars[2] = (int32_t)short_vars[1];
L14: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MIN
  {
    if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
      SUB_ID_SPVM__Util__INT16_MIN = env->get_sub_id(env, "SPVM::Util", "INT16_MIN", "short()");
      if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[2] = *(int16_t*)&stack[0];
    }
  }
L15: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Assign";
    const char* sub_name = "assign_short_to_any_object";
    const char* file = "TestCase/Assign.spvm";
    int32_t line = 415;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L30;
  }
L16: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[2];
L17: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L18: // BOOL_INT
  int_vars[0] = int_vars[0];
L19: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L23; }
L20: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L21: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L30;
L22: // GOTO
  goto L23;
L23: // GOTO
  goto L25;
L24: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 1;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L25: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 1;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L26: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L27: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L30;
L28: // INIT_INT
  int_vars[6] = 0;
L29: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L30;
L30: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L31: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Assign__assign_short_to_short_object(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[3];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MIN
  {
    if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
      SUB_ID_SPVM__Util__INT16_MIN = env->get_sub_id(env, "SPVM::Util", "INT16_MIN", "short()");
      if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[0] = *(int16_t*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Assign";
    const char* sub_name = "assign_short_to_short_object";
    const char* file = "TestCase/Assign.spvm";
    int32_t line = 337;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L25;
  }
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L4: // CONVERT_SHORT_TO_SHORT_OBJECT
  {
    int16_t value = short_vars[0];
    int32_t basic_type_id = (intptr_t)(void*)env->short_object_basic_type_id;
    void* object = env->new_object_raw(env, basic_type_id);
    SPVM_VALUE* fields = (SPVM_VALUE*)((intptr_t)object + object_header_byte_size);
    *(int16_t*)&fields[0] = value;
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], object);
  }
L5: // IS_TYPE
  {
    if (BASIC_TYPE_ID_SPVM__Short < 0) {
      BASIC_TYPE_ID_SPVM__Short = env->get_basic_type_id(env, "SPVM::Short");
      if (BASIC_TYPE_ID_SPVM__Short < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found SPVM::Short");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t check_basic_type_id = BASIC_TYPE_ID_SPVM__Short;
    int32_t check_type_dimension = 0;
    void* object = object_vars[0];
    if (object) {
      int32_t object_basic_type_id = *(int32_t*)((intptr_t)object + (intptr_t)env->object_basic_type_id_offset);
      int32_t object_type_dimension = *(uint8_t*)((intptr_t)object + (intptr_t)env->object_type_dimension_offset);
int_vars[0]      = env->is_type(env, object, check_basic_type_id, check_type_dimension);
    }
    else {
int_vars[0]      = 0;
    }
  }
L6: // BOOL_INT
  int_vars[0] = int_vars[0];
L7: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L21; }
L8: // GET_FIELD_SHORT
  {
    if (__builtin_expect(FIELD_ID_SPVM__Short__val < 0, 0)) {
      FIELD_ID_SPVM__Short__val = env->get_field_id(env, "SPVM::Short", "val", "short");
      if (FIELD_ID_SPVM__Short__val < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::Short val");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__Short__val = env->get_field_offset(env, FIELD_ID_SPVM__Short__val);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      short_vars[1] = *(int16_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__Short__val);
    }
  }
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Assign";
    const char* sub_name = "assign_short_to_short_object";
    const char* file = "TestCase/Assign.spvm";
    int32_t line = 341;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L25;
  }
L10: // CONVERT_SHORT_TO_INT
  int_vars[2] = (int32_t)short_vars[1];
L11: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MIN
  {
    if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
      SUB_ID_SPVM__Util__INT16_MIN = env->get_sub_id(env, "SPVM::Util", "INT16_MIN", "short()");
      if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[2] = *(int16_t*)&stack[0];
    }
  }
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Assign";
    const char* sub_name = "assign_short_to_short_object";
    const char* file = "TestCase/Assign.spvm";
    int32_t line = 341;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L25;
  }
L13: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[2];
L14: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L15: // BOOL_INT
  int_vars[0] = int_vars[0];
L16: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L20; }
L17: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L18: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L25;
L19: // GOTO
  goto L20;
L20: // GOTO
  goto L21;
L21: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L22: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L25;
L23: // INIT_INT
  int_vars[6] = 0;
L24: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L25;
L25: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L26: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Assign__assign_undef_to_numeric_object(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 1;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // PUSH_ARG_INT
  *(int32_t*)&stack[0] = int_vars[1];
L4: // CALL_SUB_OBJECT
  // SPVM::Int->new
  {
    if (SUB_ID_SPVM__Int__new < 0) {
      SUB_ID_SPVM__Int__new = env->get_sub_id(env, "SPVM::Int", "new", "SPVM::Int(int)");
      if (SUB_ID_SPVM__Int__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Int new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Int__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Assign";
    const char* sub_name = "assign_undef_to_numeric_object";
    const char* file = "TestCase/Assign.spvm";
    int32_t line = 592;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L17;
  }
L6: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L7: // IS_UNDEF
  int_vars[0] = object_vars[0] == NULL;
L8: // BOOL_INT
  int_vars[0] = int_vars[0];
L9: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L13; }
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L11: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L17;
L12: // GOTO
  goto L13;
L13: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L17;
L15: // INIT_INT
  int_vars[6] = 0;
L16: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L17;
L17: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L18: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}


