use Test::More;
use Test::Mojo;
use Mojo::Facebook;

plan skip_all => 'TOKEN is not set' unless $ENV{TOKEN};

my $fb = Mojo::Facebook->new(access_token => $ENV{TOKEN});

$fb->post(
    'this is just a test @[790975580:Jan] with tags',
    {
        link => 'http://github.com/jhthorsen',
        name => 'Link to my github page',
        caption => 'This message was generated by Mojo::Facebook',
        description => '...and I will delete this post soon',
        picture => 'https://secure.gravatar.com/avatar/806800a3aeddbad6af673dade958933b',
    },
    sub { $tx = $_[1]->{__tx}; Mojo::IOLoop->stop },
);

Mojo::IOLoop->start;
diag $tx->req->url;
diag $tx->req->body;
diag $tx->res->error;
diag $tx->res->body;
like($tx->res->json->{id}, qr{^\w+$}, 'got post id in return');

done_testing;
