package Locale::CLDR::Bn;
# This file auto generated from Data\common\main\bn.xml
#	on Tue 22 Jul 10:36:06 am GMT
# XML file generated 2014-03-14 12:20:13 -0500 (Fri, 14 Mar 2014)

use version;

our $VERSION = version->declare('v0.25.5');

use v5.10;
use mro 'c3';
use utf8;
use if $^V ge v5.12.0, feature => 'unicode_strings';

use Moose;

extends('Locale::CLDR::Root');
# Need to add code for Key type pattern
sub display_name_pattern {
	my ($self, $name, $territory, $script, $variant) = @_;

	my $display_pattern = '{0} ({1})';
	$display_pattern =~s/\{0\}/$name/g;
	my $subtags = join '{0}, {1}', grep {$_} (
		$territory,
		$script,
		$variant,
	);

	$display_pattern =~s/\{1\}/$subtags/g;
	return $display_pattern;
}

has 'display_name_language' => (
	is			=> 'ro',
	isa			=> 'CodeRef',
	init_arg	=> undef,
	default		=> sub { 
		 sub {
			 my %languages = (
				'aa' => 'আফার',
 				'ab' => 'আব্খাজিয়',
 				'ace' => 'আচিনিয়',
 				'ach' => 'আকোলী',
 				'ada' => 'অদাগ্মে',
 				'ady' => 'আদেগে',
 				'ae' => 'আবেস্তীয়',
 				'af' => 'আফ্রিকান্স',
 				'afh' => 'আফ্রিহিলি',
 				'ain' => 'আইনু',
 				'ak' => 'আকান',
 				'akk' => 'আক্কাদিয়ান',
 				'ale' => 'আলেউত',
 				'alt' => 'দক্ষিন আলতাই',
 				'am' => 'আমহারিক',
 				'an' => 'আর্গোনিজ',
 				'ang' => 'প্রাচীন ইংরেজী',
 				'anp' => 'আঙ্গীকা',
 				'ar' => 'আরবী',
 				'ar_001' => 'আধুনিক আদর্শ আরবী',
 				'arc' => 'আরামাইক',
 				'arn' => 'অ্যারোকেনিয়',
 				'arp' => 'আরাপাহো',
 				'arw' => 'আরাওয়াক',
 				'as' => 'আসামি',
 				'ast' => 'আস্তুরিয়',
 				'av' => 'আভেরিক',
 				'awa' => 'আওয়াধি',
 				'ay' => 'আয়মারা',
 				'az' => 'আজারবাইজানীয়',
 				'az@alt=short' => 'আজেরি',
 				'ba' => 'বাশকির',
 				'bal' => 'বেলুচী',
 				'ban' => 'বালিনীয়',
 				'bas' => 'বাসা',
 				'be' => 'বেলারুশিয়',
 				'bej' => 'বেজা',
 				'bem' => 'বেম্বা',
 				'bg' => 'বুলগেরিয়',
 				'bho' => 'ভোজপুরি',
 				'bi' => 'বিসলামা',
 				'bik' => 'বিকোল',
 				'bin' => 'বিনি',
 				'bla' => 'সিকসিকা',
 				'bm' => 'বামবারা',
 				'bn' => 'বাংলা',
 				'bo' => 'তিব্বতি',
 				'br' => 'ব্রেটন',
 				'bra' => 'ব্রাজ',
 				'bs' => 'বসনীয়',
 				'bua' => 'বুরিয়াত',
 				'bug' => 'বুগিনি',
 				'byn' => 'ব্লিন',
 				'ca' => 'কাতালান',
 				'cad' => 'ক্যাডো',
 				'car' => 'ক্যারিব',
 				'cch' => 'আত্সাম',
 				'ce' => 'চেচেন',
 				'ceb' => 'চেবুয়ানো',
 				'ch' => 'চামেরো',
 				'chb' => 'চিবচা',
 				'chg' => 'চাগাতাই',
 				'chk' => 'চুকি',
 				'chm' => 'মারি',
 				'chn' => 'চিনুক পরিভাষা',
 				'cho' => 'চক্টো',
 				'chp' => 'চিপেওয়ান',
 				'chr' => 'চেরোকি',
 				'chy' => 'শাইয়েন',
 				'ckb' => 'সোরানি কুর্দিশ',
 				'co' => 'কর্সিকান',
 				'cop' => 'কপটিক',
 				'cr' => 'ক্রি',
 				'crh' => 'ক্রিমিয়ান তুর্কি',
 				'cs' => 'চেক',
 				'csb' => 'কাশুবিয়ান',
 				'cu' => 'চার্চ স্লাভিও',
 				'cv' => 'চুবাস',
 				'cy' => 'ওয়েলশ',
 				'da' => 'ডেনিশ',
 				'dak' => 'ডাকোটা',
 				'dar' => 'দার্গওয়া',
 				'de' => 'জার্মান',
 				'de_AT' => 'অস্ট্রিয়ান জার্মানি',
 				'de_CH' => 'সুইস উচ্চ জার্মানি',
 				'del' => 'ডেলাওয়ের',
 				'den' => 'স্ল্যাভ',
 				'dgr' => 'দোগ্রীব',
 				'din' => 'ডিংকা',
 				'doi' => 'দোগরি',
 				'dsb' => 'নিম্নতর সোর্বিয়ান',
 				'dua' => 'দুয়ালা',
 				'dum' => 'মধ্য ডাচ',
 				'dv' => 'দিবেহি',
 				'dyu' => 'ডিউলা',
 				'dz' => 'ভুটানি',
 				'ee' => 'ইউই',
 				'efi' => 'এফিক',
 				'egy' => 'প্রাচীন মিশরীয়',
 				'eka' => 'ইকাজুক',
 				'el' => 'গ্রিক',
 				'elx' => 'এলামাইট',
 				'en' => 'ইংরেজি',
 				'en_AU' => 'অস্ট্রেলীয় ইংরেজি',
 				'en_CA' => 'কানাডীয় ইংরেজি',
 				'en_GB' => 'ব্রিটিশ ইংরেজি',
 				'en_GB@alt=short' => 'যুক্তরাজ্য ইংরেজি',
 				'en_US' => 'যুক্তরাষ্ট্র ইংরেজি',
 				'en_US@alt=short' => 'যুক্তরাষ্ট্র ইংরেজি',
 				'enm' => 'মধ্য ইংরেজি',
 				'eo' => 'এস্পেরান্তো',
 				'es' => 'স্পেনীয়',
 				'es_419' => 'ল্যাটিন আমেরিকান স্প্যানিশ',
 				'es_ES' => 'ইউরোপীয় স্প্যানিশ',
 				'es_MX' => 'ম্যাক্সিকান স্প্যানিশ',
 				'et' => 'এস্তোনীয়',
 				'eu' => 'বাস্ক',
 				'ewo' => 'ইওন্ডো',
 				'fa' => 'ফার্সি',
 				'fan' => 'ফ্যাঙ্গ',
 				'fat' => 'ফান্তি',
 				'ff' => 'ফুলাহ্',
 				'fi' => 'ফিনিশ',
 				'fil' => 'ফিলিপিনো',
 				'fj' => 'ফিজিও',
 				'fo' => 'ফেরাউনি',
 				'fon' => 'ফন',
 				'fr' => 'ফরাসি',
 				'fr_CA' => 'কানাডীয় ফরাসি',
 				'fr_CH' => 'সুইস ফরাসি',
 				'frm' => 'মধ্য ফরাসি',
 				'fro' => 'প্রাচীন ফরাসি',
 				'frr' => 'উত্তরাঞ্চলীয় ফ্রিসিয়ান',
 				'frs' => 'পূর্ব ফ্রিসিয়',
 				'fur' => 'ফ্রিউলিয়ান',
 				'fy' => 'পশ্চিম ফ্রিসিয়',
 				'ga' => 'আইরিশ',
 				'gaa' => 'গা',
 				'gay' => 'গায়ো',
 				'gba' => 'বায়া',
 				'gd' => 'স্কটস-গ্যেলিক',
 				'gez' => 'গীজ',
 				'gil' => 'গিলবার্টিজ',
 				'gl' => 'গ্যালিশিয়',
 				'gmh' => 'মধ্য-উচ্চ জার্মানি',
 				'gn' => 'গুয়ারানি',
 				'goh' => 'প্রাচীন উচ্চ জার্মানি',
 				'gon' => 'গোন্ডি',
 				'gor' => 'গোরোন্তালো',
 				'got' => 'গথিক',
 				'grb' => 'গ্রেবো',
 				'grc' => 'প্রাচীন গ্রীক',
 				'gsw' => 'সুইস জার্মান',
 				'gu' => 'গুজরাটি',
 				'gv' => 'ম্যাঙ্কস',
 				'gwi' => 'গওইচ্’ইন',
 				'ha' => 'হাউসা',
 				'hai' => 'হাইডা',
 				'haw' => 'হাওয়াইয়ান',
 				'he' => 'হিব্রু',
 				'hi' => 'হিন্দি',
 				'hil' => 'হিলিগ্যায়নোন',
 				'hit' => 'হিট্টিট',
 				'hmn' => 'হ্‌মোঙ',
 				'ho' => 'হিরি মোতু',
 				'hr' => 'ক্রোয়েশীয়',
 				'hsb' => 'উচ্চ সোর্বিয়ান',
 				'ht' => 'হাইতিয়ান',
 				'hu' => 'হাঙ্গেরীয়',
 				'hup' => 'হুপা',
 				'hy' => 'আর্মেনিয়',
 				'hz' => 'হেরেরো',
 				'ia' => 'ইন্টারলিঙ্গুয়া',
 				'iba' => 'ইবান',
 				'id' => 'ইন্দোনেশীয়',
 				'ie' => 'ইন্টারলিঙ্গ',
 				'ig' => 'ইগ্‌বো',
 				'ii' => 'সিচুয়ান য়ি',
 				'ik' => 'ইনুপিয়াক',
 				'ilo' => 'ইলোকো',
 				'inh' => 'ইঙ্গুশ',
 				'io' => 'ইডো',
 				'is' => 'আইসল্যান্ডীয়',
 				'it' => 'ইতালীয়',
 				'iu' => 'ইনুক্টিটুট',
 				'ja' => 'জাপানি',
 				'jbo' => 'লোজবান',
 				'jpr' => 'জুদেও ফার্সি',
 				'jrb' => 'জুদেও আরবি',
 				'jv' => 'জাভানি',
 				'ka' => 'জর্জিয়ান',
 				'kaa' => 'কারা-কাল্পাক',
 				'kab' => 'কাবাইলে',
 				'kac' => 'কাচিন',
 				'kaj' => 'অজ্জু',
 				'kam' => 'কাম্বা',
 				'kaw' => 'কাউই',
 				'kbd' => 'কাবার্ডিয়ান',
 				'kcg' => 'টাইয়াপ',
 				'kfo' => 'কোরো',
 				'kg' => 'কঙ্গো',
 				'kha' => 'খাশি',
 				'kho' => 'খোটানিজ',
 				'ki' => 'কিকু্ইয়ু',
 				'kj' => 'কোয়ানিয়ামা',
 				'kk' => 'কাজাখ',
 				'kl' => 'ক্যালাল্লিসুট',
 				'km' => 'খমের',
 				'kmb' => 'কিম্বুন্দু',
 				'kn' => 'কান্নাড়ী',
 				'ko' => 'কোরিয়ান',
 				'kok' => 'কোঙ্কানি',
 				'kos' => 'কোস্রাইন',
 				'kpe' => 'ক্‌পেল্লে',
 				'kr' => 'কানুরি',
 				'krc' => 'কারচে-বাল্কার',
 				'krl' => 'কারেলিয়ান',
 				'kru' => 'কুরুখ',
 				'ks' => 'কাশ্মীরী',
 				'ku' => 'কুর্দি',
 				'kum' => 'কুমিক',
 				'kut' => 'কুটেনাই',
 				'kv' => 'কোমি',
 				'kw' => 'কর্ণিশ',
 				'ky' => 'কির্গিজ',
 				'la' => 'লাটিন',
 				'lad' => 'লাডিনো',
 				'lah' => 'লান্ডা',
 				'lam' => 'লাম্বা',
 				'lb' => 'লুক্সেমবার্গীয়',
 				'lez' => 'লেজঘিয়ান',
 				'lg' => 'গান্ডা',
 				'li' => 'লিম্বুর্গিশ',
 				'ln' => 'লিঙ্গালা',
 				'lo' => 'লাও',
 				'lol' => 'মোঙ্গো',
 				'loz' => 'লোজি',
 				'lt' => 'লিথুয়েনীয়',
 				'lu' => 'লুবা-কাটাঙ্গা',
 				'lua' => 'লুবা-লুলুয়া',
 				'lui' => 'লুইসেনো',
 				'lun' => 'লুন্ডা',
 				'luo' => 'লুয়ো',
 				'lus' => 'লুশাই',
 				'lv' => 'লাত্‌ভীয়',
 				'mad' => 'মাদুরেসে',
 				'mag' => 'মাগাহি',
 				'mai' => 'মৈথিলি',
 				'mak' => 'ম্যাকাসার',
 				'man' => 'ম্যান্ডিঙ্গো',
 				'mas' => 'মাসাই',
 				'mdf' => 'মোকশা',
 				'mdr' => 'ম্যাণ্ডার',
 				'men' => 'মেন্ডে',
 				'mfe' => 'মরিসিয়ান',
 				'mg' => 'মালাগাসি',
 				'mga' => 'মধ্য আইরিশ',
 				'mh' => 'মার্শালিজ',
 				'mi' => 'মাওরি',
 				'mic' => 'মিকম্যাক',
 				'min' => 'মিনাঙ্গ্‌কাবাউ',
 				'mk' => 'ম্যাসেডোনীয়',
 				'ml' => 'মালেয়ালাম',
 				'mn' => 'মঙ্গোলিয়',
 				'mnc' => 'মাঞ্চু',
 				'mni' => 'মণিপুরী',
 				'moh' => 'মোহাওক',
 				'mos' => 'মসি',
 				'mr' => 'মারাঠি',
 				'ms' => 'মালে',
 				'mt' => 'মল্টিয়',
 				'mul' => 'বহুগুণিতক ভাষাসমূহ',
 				'mus' => 'ক্রিক',
 				'mwl' => 'মিরান্ডিজ',
 				'mwr' => 'মারোয়ারি',
 				'my' => 'বর্মি',
 				'myv' => 'এরজিয়া',
 				'na' => 'নাউরু',
 				'nap' => 'নেয়াপোলিটান',
 				'nb' => 'নরওয়ে বোকমাল',
 				'nd' => 'উত্তর এন্দেবিলি',
 				'nds' => 'নিম্ন জার্মানি',
 				'ne' => 'নেপালী',
 				'new' => 'নেওয়ারি',
 				'ng' => 'এন্দোঙ্গা',
 				'nia' => 'নিয়াস',
 				'niu' => 'নিউয়ান',
 				'nl' => 'ডাচ',
 				'nl_BE' => 'ফ্লেমিশ',
 				'nn' => 'নরওয়েজীয়ান নিনর্স্ক',
 				'no' => 'নরওয়েজীয়',
 				'nog' => 'নোগাই',
 				'non' => 'প্রাচীন নর্স',
 				'nqo' => 'এন’কো',
 				'nr' => 'দক্ষিণ এনডেবেলে',
 				'nso' => 'উত্তরাঞ্চলীয় সোথো',
 				'nv' => 'নাভাজো',
 				'nwc' => 'প্রাচীন নেওয়ারী',
 				'ny' => 'নায়াঞ্জা',
 				'nym' => 'ন্যায়ামওয়েজি',
 				'nyn' => 'ন্যায়াঙ্কোলে',
 				'nyo' => 'ন্যোরো',
 				'nzi' => 'এন্.জিমা',
 				'oc' => 'অক্সিটান',
 				'oj' => 'ওজিবওয়া',
 				'om' => 'অরোমো',
 				'or' => 'ওড়িয়া',
 				'os' => 'ওসেটিক',
 				'osa' => 'ওসেজ',
 				'ota' => 'অটোমান তুর্কি',
 				'pa' => 'পাঞ্জাবী',
 				'pag' => 'পাঙ্গাসিনান',
 				'pal' => 'পাহ্লাভি',
 				'pam' => 'পাম্পাঙ্গা',
 				'pap' => 'পাপিয়ামেন্টো',
 				'pau' => 'পালায়ুয়ান',
 				'peo' => 'প্রাচীন ফার্সি',
 				'phn' => 'ফোনিশীয়ান',
 				'pi' => 'পালি',
 				'pl' => 'পোলিশ',
 				'pon' => 'পোহ্নপেইয়ান',
 				'pro' => 'প্রাচীন প্রোভেনসাল',
 				'ps' => 'পশ্তু',
 				'ps@alt=variant' => 'পুশতো',
 				'pt' => 'পর্তুগীজ',
 				'pt_BR' => 'ব্রাজিলীয় পর্তুগীজ',
 				'pt_PT' => 'ইউরোপিয় পর্তুগীজ',
 				'qu' => 'কেচুয়া',
 				'raj' => 'রাজস্থানী',
 				'rap' => 'রাপানুই',
 				'rar' => 'রারোটোংগান',
 				'rm' => 'রোমান্স',
 				'rn' => 'রুন্দি',
 				'ro' => 'রোমানীয়',
 				'ro_MD' => 'মলদাভিয়',
 				'rom' => 'রোমানি',
 				'root' => 'মূল',
 				'ru' => 'রুশ',
 				'rup' => 'আরোমানিয়',
 				'rw' => 'কিনয়ারোয়ান্ডা',
 				'sa' => 'সংষ্কৃত',
 				'sad' => 'স্যান্ডাওয়ে',
 				'sah' => 'ইয়াকুট',
 				'sam' => 'সামারিটান আরামিক',
 				'sas' => 'সাসাক',
 				'sat' => 'সাঁওতালি',
 				'sc' => 'সার্ডিনিয়ান',
 				'scn' => 'সিসিলিয়ান',
 				'sco' => 'স্কটস',
 				'sd' => 'সিন্ধি',
 				'se' => 'উত্তরাঞ্চলীয় সামি',
 				'sel' => 'সেল্কুপ',
 				'sg' => 'সাঙ্গো',
 				'sga' => 'প্রাচীন আইরিশ',
 				'sh' => 'সার্বো-ক্রোয়েশিয়',
 				'shn' => 'শান',
 				'si' => 'সিংহলী',
 				'sid' => 'সিডামো',
 				'sk' => 'স্লোভাক',
 				'sl' => 'স্লোভেনীয়',
 				'sm' => 'সামোয়ান',
 				'sma' => 'দক্ষিণাঞ্চলীয় সামি',
 				'smj' => 'লুলে সামি',
 				'smn' => 'ইনারি সামি',
 				'sms' => 'স্কোল্ট সামি',
 				'sn' => 'শোনা',
 				'snk' => 'সোনিঙ্কে',
 				'so' => 'সোমালী',
 				'sog' => 'সোগডিয়ান',
 				'sq' => 'আলবেনীয়',
 				'sr' => 'সার্বীয়',
 				'srn' => 'স্রানান টোঙ্গো',
 				'srr' => 'সেরের',
 				'ss' => 'সোয়াতি',
 				'st' => 'দক্ষিন সোথো',
 				'su' => 'সুদানী',
 				'suk' => 'সুকুমা',
 				'sus' => 'সুসু',
 				'sux' => 'সুমেরীয়',
 				'sv' => 'সুইডিশ',
 				'sw' => 'সোয়াহিলি',
 				'swb' => 'কমোরিয়ান',
 				'syc' => 'প্রাচীন সিরিও',
 				'syr' => 'সিরিয়াক',
 				'ta' => 'তামিল',
 				'te' => 'তেলেগু',
 				'tem' => 'টাইম্নে',
 				'ter' => 'তেরেনো',
 				'tet' => 'তেতুম',
 				'tg' => 'তাজিক',
 				'th' => 'থাই',
 				'ti' => 'তিগরিনিয়া',
 				'tig' => 'টাইগ্রে',
 				'tiv' => 'টিভ',
 				'tk' => 'তুর্কমেনী',
 				'tkl' => 'টোকেলাউ',
 				'tl' => 'তাগালগ',
 				'tlh' => 'ক্লিঙ্গন',
 				'tli' => 'ত্লিঙ্গিট',
 				'tmh' => 'তামাশেক',
 				'tn' => 'সোয়ানা',
 				'to' => 'টোঙ্গান',
 				'tog' => 'নায়াসা টোঙ্গা',
 				'tpi' => 'টোক পিসিন',
 				'tr' => 'তুর্কী',
 				'ts' => 'সঙ্গা',
 				'tsi' => 'সিমশিয়ান',
 				'tt' => 'তাতার',
 				'tum' => 'তুম্বুকা',
 				'tvl' => 'টুভালু',
 				'tw' => 'টোয়াই',
 				'ty' => 'তাহিতিয়ান',
 				'tyv' => 'টুভিনিয়ান',
 				'udm' => 'উডমুর্ট',
 				'ug' => 'উইগুর',
 				'uga' => 'উগারিটিক',
 				'uk' => 'ইউক্রেনীয়',
 				'umb' => 'উম্বুন্দু',
 				'und' => 'অজানা ভাষা',
 				'ur' => 'উর্দু',
 				'uz' => 'উজবেকীয়',
 				'vai' => 'ভাই',
 				've' => 'ভেন্ডা',
 				'vi' => 'ভিয়েতনামী',
 				'vo' => 'ভোলাপুক',
 				'vot' => 'ভোটিক',
 				'wa' => 'ওয়ালুন',
 				'wal' => 'ওয়ালামো',
 				'war' => 'ওয়ারে',
 				'was' => 'ওয়াশো',
 				'wo' => 'উওলোফ',
 				'xal' => 'কাল্মইক',
 				'xh' => 'জোসা',
 				'yao' => 'ইয়াও',
 				'yap' => 'ইয়াপেসে',
 				'yi' => 'য়িদ্দিশ',
 				'yo' => 'ইওরুবা',
 				'yue' => 'ক্যানটোনীজ',
 				'za' => 'ঝু্য়াঙ',
 				'zap' => 'জাপোটেক',
 				'zbl' => 'চিত্র ভাষা',
 				'zen' => 'জেনাগা',
 				'zgh' => 'আদর্শ মরক্কোন তামাজিগাত',
 				'zh' => 'চীনা',
 				'zh_Hans' => 'সরলীকৃত চীনা',
 				'zh_Hant' => 'ঐতিহ্যবাহি চীনা',
 				'zu' => 'জুলু',
 				'zun' => 'জুনি',
 				'zxx' => 'ভাষাতাত্তিক বিষয়সূচী বহির্ভুত',
 				'zza' => 'জাজা',

			);
			if (@_) {
				return $languages{$_[0]};
			}
			return \%languages;
		}
	},
);

has 'display_name_script' => (
	is			=> 'ro',
	isa			=> 'CodeRef',
	init_arg	=> undef,
	default		=> sub {
		sub {
			my %scripts = (
			'Arab' => 'আরবি',
 			'Arab@alt=variant' => 'ফারসি-আরবি',
 			'Armi' => 'আরমি',
 			'Armn' => 'আর্মেনীয়',
 			'Avst' => 'আভেসতান',
 			'Bali' => 'বালীয়',
 			'Batk' => 'বাটাক',
 			'Beng' => 'বাংলা',
 			'Blis' => 'ব্লিসপ্রতীক',
 			'Bopo' => 'বোপোমোফো',
 			'Brah' => 'ব্রাহ্মী',
 			'Brai' => 'ব্রেইল',
 			'Bugi' => 'বুগি',
 			'Buhd' => 'বুহিড',
 			'Cakm' => 'চাকমা',
 			'Cans' => 'সংযুক্ত কানাডিয়ান অ্যাব্রোজিনিয়ান সিলেবিক্স',
 			'Cari' => 'ক্যারিয়ান',
 			'Cham' => 'চ্যাম',
 			'Cher' => 'চেরোকি',
 			'Cirt' => 'কির্ট',
 			'Copt' => 'কোপ্টিক',
 			'Cprt' => 'সাইপ্রোয়েট',
 			'Cyrl' => 'সিরিলিক',
 			'Cyrs' => 'প্রাচীন চার্চ স্লাভোনিক সিরিলিক',
 			'Deva' => 'দেবনাগরি',
 			'Dsrt' => 'দেসেরাত',
 			'Egyd' => 'মিশরীয় ডেমোটিক',
 			'Egyh' => 'মিশরীয় হায়রেটিক',
 			'Egyp' => 'মিশরীয় হায়ারোগ্লিপ',
 			'Ethi' => 'ইথিওপিয়',
 			'Geok' => 'জর্জিয় খুৎসুরি',
 			'Geor' => 'জর্জিয়ান',
 			'Glag' => 'গ্লাগোলিটিক',
 			'Goth' => 'গোথিক',
 			'Grek' => 'গ্রিক',
 			'Gujr' => 'গুজরাটি',
 			'Guru' => 'গুরুমুখি',
 			'Hang' => 'হাঙ্গুল',
 			'Hani' => 'হ্যান',
 			'Hano' => 'হ্যানুনু',
 			'Hans' => 'সরলীকৃত',
 			'Hans@alt=stand-alone' => 'সরলিকৃত হ্যান',
 			'Hant' => 'প্রথাগত',
 			'Hant@alt=stand-alone' => 'ঐতিহ্যবাহী হ্যান',
 			'Hebr' => 'হিব্রু',
 			'Hira' => 'হিরাগানা',
 			'Hmng' => 'ফাহাও মঙ',
 			'Hrkt' => 'কাটাকানা অথবা হিরাগানা',
 			'Hung' => 'পুরোনো হাঙ্গেরীয়',
 			'Inds' => 'সিন্ধু',
 			'Ital' => 'প্রাচীন ইতালি',
 			'Java' => 'জাভানিজ',
 			'Jpan' => 'জাপানী',
 			'Kali' => 'কায়াহ লি',
 			'Kana' => 'কাটাকানা',
 			'Khar' => 'খরোষ্ঠী',
 			'Khmr' => 'খমের',
 			'Knda' => 'কানাড়া',
 			'Kore' => 'কোরিয়ান',
 			'Kthi' => 'কাইথি',
 			'Lana' => 'লান্না',
 			'Laoo' => 'লাও',
 			'Latf' => 'ফ্রাক্টুর ল্যাটিন',
 			'Latg' => 'গ্যালিক ল্যাটিন',
 			'Latn' => 'ল্যাটিন',
 			'Lepc' => 'লেপ্চা',
 			'Limb' => 'লিম্বু',
 			'Lina' => 'লিনিয়ার এ',
 			'Linb' => 'লিনিয়ার বি',
 			'Lyci' => 'লাইসিয়ান',
 			'Lydi' => 'লাইডিয়ান',
 			'Mand' => 'ম্যান্ডায়ীন',
 			'Mani' => 'ম্যানিচাইন',
 			'Maya' => 'মায়ান হায়ারোগ্লিপ',
 			'Mero' => 'মেরোইটিক',
 			'Mlym' => 'মালায়ালাম',
 			'Mong' => 'মোঙ্গোলীয়',
 			'Moon' => 'মুন',
 			'Mtei' => 'মেইটেই মায়েক',
 			'Mymr' => 'মায়ানমার',
 			'Nkoo' => 'এনকো',
 			'Ogam' => 'ওঘাম',
 			'Olck' => 'ওল চিকি',
 			'Orkh' => 'অর্খোন',
 			'Orya' => 'ওড়িয়া',
 			'Osma' => 'ওসমানিয়',
 			'Perm' => 'প্রাচীন পার্মিক',
 			'Phag' => 'ফাগ্স-পা',
 			'Phli' => 'খদিত পাহলভি',
 			'Phlp' => 'সল্টার পাহলভি',
 			'Phlv' => 'পুস্তক পাহলভি',
 			'Phnx' => 'ফিনিশিয়',
 			'Plrd' => 'পোলার্ড ধ্বনিক',
 			'Prti' => 'পার্থিয়ন',
 			'Rjng' => 'রেজ্যাঙ্গ',
 			'Roro' => 'রোঙ্গোরোঙ্গো',
 			'Runr' => 'রুনিক',
 			'Samr' => 'সমেরিটন',
 			'Sara' => 'সারাতি',
 			'Saur' => 'সৌরাষ্ট্র',
 			'Sgnw' => 'চিহ্ন লিখন',
 			'Shaw' => 'সাভিয়ান',
 			'Sinh' => 'সিংহলি',
 			'Sund' => 'সান্দানিজ',
 			'Sylo' => 'সিলেটি নাগরি',
 			'Syrc' => 'সিরিয়াক',
 			'Syre' => 'এস্ট্রেঙ্গেলো সিরিয়াক',
 			'Syrj' => 'পশ্চিমাঞ্চলীয় সিরিয়াক',
 			'Syrn' => 'পূর্বাঞ্চলীয় সিরিয়াক',
 			'Tagb' => 'টাগোওয়ানা',
 			'Tale' => 'তাইলে',
 			'Talu' => 'নতুন তাই লু',
 			'Taml' => 'তামিল',
 			'Tavt' => 'তাই ভিয়েৎ',
 			'Telu' => 'তেলেগু',
 			'Teng' => 'তেঙ্গোয়ার',
 			'Tfng' => 'তিফিনাগ',
 			'Tglg' => 'টাগালগ',
 			'Thaa' => 'থানা',
 			'Thai' => 'থাই',
 			'Tibt' => 'তিব্বতি',
 			'Ugar' => 'উগারিটিক',
 			'Vaii' => 'ভাই',
 			'Visp' => 'দৃশ্যমান ভাষা',
 			'Xpeo' => 'প্রাচীন ফার্সি',
 			'Xsux' => 'সুমের-আক্কাদীয় কীলকরূপ',
 			'Yiii' => 'উই',
 			'Zinh' => 'কাই',
 			'Zmth' => 'গানিতিক চিহ্ন',
 			'Zsym' => 'প্রতীকসমুহ',
 			'Zxxx' => 'অলিখিত',
 			'Zyyy' => 'সাধারন',
 			'Zzzz' => 'অজানা লিপি',

			);
			if ( @_ ) {
				return $scripts{$_[0]};
			}
			return \%scripts;
		}
	}
);

has 'display_name_territory' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'001' => 'পৃথিবী',
 			'002' => 'আফ্রিকা',
 			'003' => 'উত্তর আমেরিক',
 			'005' => 'দক্ষিন আমেরিকা',
 			'009' => 'ওসানিয়া',
 			'011' => 'পশ্চিমাঞ্চলীয় আফ্রিকা',
 			'013' => 'মধ্য আমেরিকা',
 			'014' => 'পূর্ব আফ্রিকা',
 			'015' => 'উত্তর আফ্রিকা',
 			'017' => 'মধ্য আফ্রিকা',
 			'018' => 'দক্ষিণাঞ্চলীয় আফ্রিকা',
 			'019' => 'আমেরিকাস',
 			'021' => 'উত্তরাঞ্চলীয় আমেরিকা',
 			'029' => 'ক্যারাবিয়ান',
 			'030' => 'পূর্ব এশিয়া',
 			'034' => 'দক্ষিণাঞ্চলীয় এশিয়া',
 			'035' => 'দক্ষিন পূর্ব এশিয়া',
 			'039' => 'দক্ষিণাঞ্চলীয় ইউরোপ',
 			'053' => 'অস্ট্রেলিয়া এবং নিউজিল্যান্ড',
 			'054' => 'ম্যালেনেশিয়া',
 			'057' => 'ম্যালেনিশা অঞ্চল',
 			'061' => 'পলিনেশিয়া',
 			'142' => 'এশিয়া',
 			'143' => 'মধ্য এশিয়া',
 			'145' => 'পশ্চিমাঞ্চলীয় এশিয়া',
 			'150' => 'ইউরোপ',
 			'151' => 'পূর্ব ইউরোপ',
 			'154' => 'উত্তরাঞ্চলীয় ইউরোপ',
 			'155' => 'পশ্চিমাঞ্চলীয় ইউরোপ',
 			'419' => 'ল্যাটিন আমেরিকা',
 			'AC' => 'অ্যাসসেনশন আইল্যান্ড',
 			'AD' => 'এ্যান্ডোরা',
 			'AE' => 'সংযুক্ত আরব আমিরাত',
 			'AF' => 'আফগানিস্তান',
 			'AG' => 'এন্টিগুয়া ও বারবুডা',
 			'AI' => 'এ্যাঙ্গুইলা',
 			'AL' => 'আলব্যানিয়া',
 			'AM' => 'আর্মেনিয়া',
 			'AN' => 'নেদারল্যান্ডস এ্যান্টিলিস',
 			'AO' => 'এ্যাঙ্গোলা',
 			'AQ' => 'অ্যান্টার্কটিকা',
 			'AR' => 'আর্জেণ্টাইনা',
 			'AS' => 'আমেরিকান সামোয়া',
 			'AT' => 'অস্ট্রিয়া',
 			'AU' => 'অস্ট্রেলিয়া',
 			'AW' => 'আরুবা',
 			'AX' => 'আলান্ড দ্বীপপুঞ্জ',
 			'AZ' => 'আজারবাইজান',
 			'BA' => 'বসনিয়া ও হার্জেগোভিনা',
 			'BB' => 'বারবাদোস',
 			'BD' => 'বাংলাদেশ',
 			'BE' => 'বেলজিয়াম',
 			'BF' => 'বুরকিনা ফাসো',
 			'BG' => 'বুলগেরিয়া',
 			'BH' => 'বাহরাইন',
 			'BI' => 'বুরুন্ডি',
 			'BJ' => 'বেনিন',
 			'BL' => 'সেন্ট বারথেলিমি',
 			'BM' => 'বারমুডা',
 			'BN' => 'ব্রুনেই',
 			'BO' => 'বোলিভিয়া',
 			'BQ' => 'ক্যারিবিয়ান নেদারল্যান্ডস',
 			'BR' => 'ব্রাজিল',
 			'BS' => 'বাহামা দ্বীপপুঞ্জ',
 			'BT' => 'ভুটান',
 			'BV' => 'বোভেট দ্বীপ',
 			'BW' => 'বতসোয়ানা',
 			'BY' => 'বেলোরুশিয়া',
 			'BZ' => 'বেলিয',
 			'CA' => 'কানাডা',
 			'CC' => 'কোকোস দ্বীপপুঞ্জ',
 			'CD' => 'কঙ্গো - কিনসাসা',
 			'CD@alt=variant' => 'কঙ্গো(DRC)',
 			'CF' => 'মধ্য আফ্রিকান প্রজাতন্ত্র',
 			'CG' => 'কঙ্গো - ব্রাজাভিল',
 			'CG@alt=variant' => 'কঙ্গো (প্রজাতন্ত্র)',
 			'CH' => 'সুইজারল্যান্ড',
 			'CI' => 'আইভরি কোস্ট',
 			'CK' => 'কুক দ্বীপপুঞ্জ',
 			'CL' => 'চিলি',
 			'CM' => 'ক্যামেরুন',
 			'CN' => 'চীন',
 			'CO' => 'কোলোম্বিয়া',
 			'CP' => 'ক্লিপারটন আইল্যান্ড',
 			'CR' => 'কোস্টারিকা',
 			'CU' => 'কিউবা',
 			'CV' => 'কেপভার্দে',
 			'CW' => 'কুরাসাও',
 			'CX' => 'ক্রিসমাস দ্বীপ',
 			'CY' => 'সাইপ্রাস',
 			'CZ' => 'চেক প্রজাতন্ত্র',
 			'DE' => 'জার্মানি',
 			'DG' => 'দিয়েগো গার্সিয়া',
 			'DJ' => 'জিবুতি',
 			'DK' => 'ডেনমার্ক',
 			'DM' => 'ডোমিনিকা',
 			'DO' => 'ডোমেনিকান প্রজাতন্ত্র',
 			'DZ' => 'এলজিরিয়া',
 			'EA' => 'কুউটা এবং মেলিলা',
 			'EC' => 'ইকুয়েডর',
 			'EE' => 'এস্তোনিয়া',
 			'EG' => 'মিশর',
 			'EH' => 'পশ্চিমী সাহারা',
 			'ER' => 'ইরিত্রিয়া',
 			'ES' => 'স্পেন',
 			'ET' => 'ইফিওপিয়া',
 			'EU' => 'ইউরোপীয় ইউনিয়ন',
 			'FI' => 'ফিনল্যান্ড',
 			'FJ' => 'ফিজি',
 			'FK' => 'ফকল্যান্ড দ্বীপপুঞ্জ',
 			'FK@alt=variant' => 'ফকল্যান্ড আইল্যান্ড ( ইসল্যাস মাসভেনিস)',
 			'FM' => 'মাইক্রোনেশিয়া',
 			'FO' => 'ফ্যারও দ্বীপপুঞ্জ',
 			'FR' => 'ফ্রান্স',
 			'GA' => 'গ্যাবন',
 			'GB' => 'যুক্তরাজ্য',
 			'GB@alt=short' => 'U.K.',
 			'GD' => 'গ্রেনাডা',
 			'GE' => 'জর্জিয়া',
 			'GF' => 'ফরাসী গায়ানা',
 			'GG' => 'গ্রাঞ্জি',
 			'GH' => 'ঘানা',
 			'GI' => 'জিব্রাল্টার',
 			'GL' => 'গ্রীনল্যান্ড',
 			'GM' => 'গাম্বিয়া',
 			'GN' => 'গিনি',
 			'GP' => 'গুয়াদেলৌপ',
 			'GQ' => 'নিরক্ষীয় গিনি',
 			'GR' => 'গ্রীস্',
 			'GS' => 'দক্ষিণ জর্জিয়া ও দক্ষিণ স্যান্ডউইচ দ্বীপপুঞ',
 			'GT' => 'গোয়াটিমালা',
 			'GU' => 'গুয়াম',
 			'GW' => 'গিনি-বিসাউ',
 			'GY' => 'গিয়ানা',
 			'HK' => 'হংকং এসএআর চীনা',
 			'HK@alt=short' => 'হংকং',
 			'HM' => 'হার্ড দ্বীপ এবং ম্যাকডোনাল্ড দ্বীপপুঞ্জ',
 			'HN' => 'হণ্ডুরাস',
 			'HR' => 'ক্রোয়েশিয়া',
 			'HT' => 'হাইতি',
 			'HU' => 'হাঙ্গেরি',
 			'IC' => 'ক্যানারি দ্বীপপুঞ্জ',
 			'ID' => 'ইন্দোনেশিয়া',
 			'IE' => 'আয়ার্লণ্ড',
 			'IL' => 'ইস্রায়েল',
 			'IM' => 'আইল অফ ম্যান',
 			'IN' => 'ভারত',
 			'IO' => 'ব্রিটিশ ভারত মহাসাগরীয় অঞ্চল',
 			'IQ' => 'ইরাক',
 			'IR' => 'ইরান',
 			'IS' => 'আইসলণ্ড',
 			'IT' => 'ইতালী',
 			'JE' => 'জার্সি',
 			'JM' => 'জ্যামেকা',
 			'JO' => 'জর্ডন',
 			'JP' => 'জাপান',
 			'KE' => 'কেনিয়া',
 			'KG' => 'কির্গিজিয়া',
 			'KH' => 'কাম্বোজ',
 			'KI' => 'কিরিবাতি',
 			'KM' => 'কমোরোস',
 			'KN' => 'সেন্ট কিটস ও নেভিস',
 			'KP' => 'উত্তর কোরিয়া',
 			'KR' => 'দক্ষিণ কোরিয়া',
 			'KW' => 'কুয়েত',
 			'KY' => 'কেম্যান দ্বীপপুঞ্জ',
 			'KZ' => 'কাজাকস্থান',
 			'LA' => 'লাওস',
 			'LB' => 'লেবানন',
 			'LC' => 'সেন্ট লুসিয়া',
 			'LI' => 'লিচেনস্টেইন',
 			'LK' => 'শ্রীলঙ্কা',
 			'LR' => 'লাইবেরিয়া',
 			'LS' => 'লেসোথো',
 			'LT' => 'লিত্ভা',
 			'LU' => 'লাক্সেমবার্গ',
 			'LV' => 'লাত্ভিয়া',
 			'LY' => 'লিবিয়া',
 			'MA' => 'মোরক্কো',
 			'MC' => 'মোনাকো',
 			'MD' => 'মোল্দাভিয়া',
 			'ME' => 'মন্টিনিগ্রো',
 			'MF' => 'সেন্ট মার্টিন',
 			'MG' => 'মাদাগাস্কার',
 			'MH' => 'মার্শাল দ্বীপপুঞ্জ',
 			'MK' => 'ম্যাসাডোনিয়া',
 			'MK@alt=variant' => 'মেসিডোনিয়া(FYROM)',
 			'ML' => 'মালি',
 			'MM' => 'মায়ানমার (বার্মা)',
 			'MN' => 'মঙ্গোলিয়া',
 			'MO' => 'ম্যাকাও এসএআর চীনা',
 			'MO@alt=short' => 'ম্যাকাও',
 			'MP' => 'উত্তরাঞ্চলীয় মারিয়ানা দ্বীপপুঞ্জ',
 			'MQ' => 'মার্টিনিক',
 			'MR' => 'মরিতানিয়া',
 			'MS' => 'মন্টসেরাট',
 			'MT' => 'মাল্টা',
 			'MU' => 'মরিশাস',
 			'MV' => 'মালদ্বীপ',
 			'MW' => 'মালাউই',
 			'MX' => 'মক্সিকো',
 			'MY' => 'মাল্যাশিয়া',
 			'MZ' => 'মোজাম্বিক',
 			'NA' => 'নামিবিয়া',
 			'NC' => 'নিউ ক্যালেডোনিয়া',
 			'NE' => 'নাইজার',
 			'NF' => 'নিরফোক দ্বীপ',
 			'NG' => 'নাইজেরিয়া',
 			'NI' => 'নিকারাগুয়া',
 			'NL' => 'নেদারল্যান্ডস',
 			'NO' => 'নরওয়ে',
 			'NP' => 'নেপাল',
 			'NR' => 'নাউরু',
 			'NU' => 'নিউয়ে',
 			'NZ' => 'নিউ জিলণ্ড',
 			'OM' => 'ওমান',
 			'PA' => 'পানামা',
 			'PE' => 'পিরু',
 			'PF' => 'ফরাসী পলিনেশিয়া',
 			'PG' => 'পাপুয়া নিউ গিনি',
 			'PH' => 'ফিলিপাইন',
 			'PK' => 'পাকিস্তান',
 			'PL' => 'পোল্যাণ্ড',
 			'PM' => 'সেন্ট পিয়ের ও মিকুয়েলন',
 			'PN' => 'পিটকেয়ার্ন দ্বীপপুঞ্জ',
 			'PR' => 'পুয়ের্টোরিকো',
 			'PS' => 'ফিলিস্তিন অঞ্চলসমূহ',
 			'PS@alt=short' => 'ফিলিস্তিন',
 			'PT' => 'পর্তুগাল',
 			'PW' => 'পালাউ',
 			'PY' => 'প্যারাগোয়ে',
 			'QA' => 'কাতার',
 			'QO' => 'আউটলাইনিং ওসানিয়া',
 			'RE' => 'রিইউনিয়ন',
 			'RO' => 'রুমানিয়া',
 			'RS' => 'সারবিয়া',
 			'RU' => 'রাশিয়া',
 			'RW' => 'রুয়ান্ডা',
 			'SA' => 'সাউদি আরব',
 			'SB' => 'সলোমন দ্বীপপুঞ্জ',
 			'SC' => 'সিসিলি',
 			'SD' => 'সুদান',
 			'SE' => 'সুইডেন',
 			'SG' => 'সিঙ্গাপুর',
 			'SH' => 'সেন্ট হেলেনা',
 			'SI' => 'স্লোভানিয়া',
 			'SJ' => 'স্বালবার্ড ও জান মেয়েন',
 			'SK' => 'শ্লোভাকিয়া',
 			'SL' => 'সিয়েরালিওন',
 			'SM' => 'সান মারিনো',
 			'SN' => 'সেনেগাল',
 			'SO' => 'সোমালি',
 			'SR' => 'সুরিনাম',
 			'SS' => 'দক্ষিন সুদান',
 			'ST' => 'সাওটোমা ও প্রিন্সিপি',
 			'SV' => 'এল সালভেদর',
 			'SX' => 'সিন্ট মার্টেন',
 			'SY' => 'সিরিয়া',
 			'SZ' => 'সোয়াজিল্যান্ড',
 			'TA' => 'ট্রিস্টান ডা কুনা',
 			'TC' => 'তুর্কস ও কাইকোস দ্বীপপুঞ্জ',
 			'TD' => 'চাদ',
 			'TF' => 'ফরাসী দক্ষিণাঞ্চল',
 			'TG' => 'টোগো',
 			'TH' => 'থাই',
 			'TJ' => 'তাজিকস্থান',
 			'TK' => 'টোকেলাউ',
 			'TL' => 'পূর্ব-তিমুর',
 			'TL@alt=variant' => 'পূর্ব টিমোর',
 			'TM' => 'তুর্কমেনিয়া',
 			'TN' => 'টিউনিস্',
 			'TO' => 'টোঙ্গা',
 			'TR' => 'তুরস্ক',
 			'TT' => 'ত্রিনিনাদ ও টোব্যাগো',
 			'TV' => 'টুভালু',
 			'TW' => 'তাইওয়ান',
 			'TZ' => 'তাঞ্জানিয়া',
 			'UA' => 'ইউক্রেইন',
 			'UG' => 'উগান্ডা',
 			'UM' => 'যুক্তরাষ্ট্রের পার্শ্ববর্তী দ্বীপপুঞ্জ',
 			'US' => 'মার্কিন যুক্তরাষ্ট্র',
 			'US@alt=short' => 'U.S.',
 			'UY' => 'উরুগোয়ে',
 			'UZ' => 'উজ্বেকিস্থান',
 			'VA' => 'ভ্যাটিকান সিটি',
 			'VC' => 'সেন্ট ভিনসেন্ট ও দ্যা গ্রেনাডিনস',
 			'VE' => 'ভেনেজুয়েলা',
 			'VG' => 'ব্রিটিশ ভার্জিন দ্বীপপুঞ্জ',
 			'VI' => 'মার্কিন ভার্জিন দ্বীপপুঞ্জ',
 			'VN' => 'ভিয়েতনাম',
 			'VU' => 'ভানুয়াটু',
 			'WF' => 'ওয়ালিস ও ফুটুনা',
 			'WS' => 'সামোয়া',
 			'XK' => 'কসোভো',
 			'YE' => 'ইমেন',
 			'YT' => 'মায়োত্তে',
 			'ZA' => 'দক্ষিণ আফ্রিকা',
 			'ZM' => 'জাম্বিয়া',
 			'ZW' => 'জিম্বাবুয়ে',
 			'ZZ' => 'অজানা স্থান',

		}
	},
);

has 'display_name_variant' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'PINYIN' => 'পিনইন রোমানাইজেশন',
 			'WADEGILE' => 'ওয়াদে-গিলেস রোমানাইজেশন',

		}
	},
);

has 'display_name_key' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'calendar' => 'বর্ষপঞ্জী',
 			'colalternate' => 'প্রতীক বাছাইকরণ উপেক্ষা করুন',
 			'colbackwards' => 'বিপরীত করা স্বরাঘাত বাছাইকরণ',
 			'colcasefirst' => 'বড়হাতের/ছোটহাতের অক্ষর ক্রম',
 			'colcaselevel' => 'কেস সংবেদী বাছাইকরণ',
 			'colhiraganaquaternary' => 'কানা বাছাইকরণ',
 			'collation' => 'বাছাই বিন্যাস',
 			'colnormalization' => 'স্বাভাবিককৃত বাছাইকরণ',
 			'colnumeric' => 'সংখ্যাসূচক বাছাইকরণ',
 			'colstrength' => 'বাছাইকরণ শক্তি',
 			'currency' => 'মুদ্রা',
 			'numbers' => 'সংখ্যাসমূহ',
 			'timezone' => 'সময় জোন',
 			'va' => 'স্থানীয় ভিন্নতা',
 			'variabletop' => 'প্রতীক হিসেবে বাছাই করুন',
 			'x' => 'বক্তিগত- ব্যবহার',

		}
	},
);

has 'display_name_type' => (
	is			=> 'ro',
	isa			=> 'HashRef[HashRef[Str]]',
	init_arg	=> undef,
	default		=> sub {
		{
			'calendar' => {
 				'buddhist' => q{বৌদ্ধ বর্ষপঞ্জী},
 				'chinese' => q{চীনা বর্ষপঞ্জী},
 				'coptic' => q{কপটিক ক্যালেন্ডার},
 				'ethiopic' => q{ইথিওপিক ক্যালেন্ডার},
 				'ethiopic-amete-alem' => q{ইথিওপিও আমেতে আলেম ক্যালেন্ডার},
 				'gregorian' => q{গ্রিগোরিয়ান বর্ষপঞ্জী},
 				'hebrew' => q{হিব্রু বর্ষপঞ্জী},
 				'indian' => q{ভারতীয় জাতীয় বর্ষপঞ্জী},
 				'islamic' => q{ইসলামিক বর্ষপঞ্জী},
 				'islamic-civil' => q{ইসলামিক-সিভিল বর্ষপঞ্জী},
 				'japanese' => q{জাপানি বর্ষপঞ্জী},
 				'persian' => q{ফারসি ক্যালেন্ডার},
 				'roc' => q{গণপ্রজাতন্ত্রী চীনা বর্ষপঞ্জী},
 			},
 			'colalternate' => {
 				'non-ignorable' => q{প্রতীক বাছাই করুন},
 				'shifted' => q{উপেক্ষা প্রতীক বাছাই করুন},
 			},
 			'colbackwards' => {
 				'no' => q{স্বরাঘাত সাধারণতভাবে বাছাই করুন},
 				'yes' => q{স্বরাঘাত বিপরীত বাছাই করুন},
 			},
 			'colcasefirst' => {
 				'lower' => q{প্রথমে ছোট হাতের অক্ষর বাছাই করুন},
 				'no' => q{সাধারন কেস ক্রম বাছাই করুন},
 				'upper' => q{প্রথমে বড়হাতের অক্ষর বাছাই করুন},
 			},
 			'colcaselevel' => {
 				'no' => q{কেস অসংবেদী বাছাই করুন},
 				'yes' => q{কেস সংবেদী বাছাই করুন},
 			},
 			'colhiraganaquaternary' => {
 				'no' => q{কানা আলাদাভাবে বাছাই করুন},
 				'yes' => q{কানা ভিন্নভাবে বাছাই করুন},
 			},
 			'collation' => {
 				'big5han' => q{প্রথাগত চীনা সজ্জাক্রম - বিগ৫},
 				'dictionary' => q{অভিধান বাছাই বিন্যাস},
 				'ducet' => q{ডিফল্ট ইউনিকোড বাছাই বিন্যাস},
 				'gb2312han' => q{সাধারণ চীনা সজ্জাক্রম - জিবি২৩১২},
 				'phonebook' => q{ফোনবুক সজ্জাক্রম},
 				'phonetic' => q{ধ্বনি নির্দেশক বাছাই ক্রম},
 				'pinyin' => q{পিনিন সজ্জাক্রম},
 				'reformed' => q{রিফর্মড বাছাই বিন্যাস},
 				'search' => q{সাধারণ-উদ্দেশ্যে অনুসন্ধান},
 				'searchjl' => q{হাঙ্গুল প্রাথমিক ব্যঞ্জনবর্ণ দ্বারা অনুসন্ধান করুন},
 				'standard' => q{আদর্শ বাছাই বিন্যাস},
 				'stroke' => q{আবর্তিত সজ্জাক্রম},
 				'traditional' => q{প্রথাগত সজ্জাক্রম},
 				'unihan' => q{রাডিকেল স্ট্রোক বাছাই বিন্যাস},
 			},
 			'colnormalization' => {
 				'no' => q{স্বাভাবিক ছাড়া বাছাই করুন},
 				'yes' => q{স্বাভাবিকৃত ইউনিকোড বাছাই করুন},
 			},
 			'colnumeric' => {
 				'no' => q{সংখ্যা পৃথকভাবে বাছাই করুন},
 				'yes' => q{সংখ্যা সংখ্যাসূচকভাবে বাছাই করুন},
 			},
 			'colstrength' => {
 				'identical' => q{সমস্ত বাছাই করুন},
 				'primary' => q{কেবল বুনিয়াদি বর্ণ বাছাই করুন},
 				'quaternary' => q{স্বরাঘাত/কেস/প্রস্থ/কানা বাছাই করুন},
 				'secondary' => q{স্বরাঘাত বাছাই করুন},
 				'tertiary' => q{স্বরাঘাত/কেস/প্রস্থ বাছাই করুন},
 			},
 			'numbers' => {
 				'arab' => q{আরবি-ভারতীয় সংখ্যা},
 				'arabext' => q{প্রসারিত আরবি -ভারতীয় সংখ্যা},
 				'armn' => q{আর্মেনীয় সংখ্যা},
 				'armnlow' => q{আর্মেনীয় ছোটহাতের সংখ্যা},
 				'beng' => q{বাংলা সংখ্যা},
 				'deva' => q{দেবনাগরি সংখ্যা},
 				'ethi' => q{ইথীয়োপিক সংখ্যা},
 				'finance' => q{অর্থনৈতিক সংখ্যাসূচক},
 				'fullwide' => q{পূর্ণ চওড়া সংখ্যা},
 				'geor' => q{জর্জিয়ান সংখ্যা},
 				'grek' => q{গ্রিক সংখ্যা},
 				'greklow' => q{গ্রীক ছোট হাতের সংখ্যা},
 				'gujr' => q{গুজরাতি শংখ্যা},
 				'guru' => q{গুরুমুখি সংখ্যা},
 				'hanidec' => q{চৈনিক দশমিক সংখ্যা},
 				'hans' => q{সরলিকৃত চৈনিক সংখ্যা},
 				'hansfin' => q{সরলিকৃত চৈনিক আর্থিক সংখ্যা},
 				'hant' => q{ঐতিহ্যাবাহী চৈনিক সংখ্যা},
 				'hantfin' => q{ঐতিহ্যবাহী চৈনিক আর্থিক সংখ্যা},
 				'hebr' => q{হিব্রু সংখ্যা},
 				'jpan' => q{জাপানি সংখ্যা},
 				'jpanfin' => q{জাপানি আর্থিক সংখ্যা},
 				'khmr' => q{খেমের সংখ্যা},
 				'knda' => q{কান্নাডা শংখ্যা},
 				'laoo' => q{লাও সংখ্যা},
 				'latn' => q{পশ্চিমি শংখ্যা},
 				'mlym' => q{মালয়ালম শংখ্যা},
 				'mong' => q{মঙ্গোলীয় সংখ্যা},
 				'mymr' => q{মায়ানমার সংখ্যা},
 				'native' => q{স্থানীয় সংখ্যা},
 				'orya' => q{ওড়িয়া শংখ্যা},
 				'roman' => q{রোমান সংখ্যা},
 				'romanlow' => q{রোমান ছোটহাতের সংখ্যা},
 				'taml' => q{ঐতিহ্যবাহী তামিল সংখ্যা},
 				'tamldec' => q{তামিল সংখ্যা},
 				'telu' => q{তেলুগু সংখ্যা},
 				'thai' => q{থাই সংখ্যা},
 				'tibt' => q{তিব্বতি সংখ্যা},
 				'traditional' => q{ঐতিহ্যগত সংখ্যাসূচক},
 				'vaii' => q{ভাই সংখ্যা},
 			},

		}
	},
);

has 'display_name_measurement_system' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'metric' => q{মেট্রিক},
 			'UK' => q{ইউকে},
 			'US' => q{মার্কিন},

		}
	},
);

has 'display_name_transform_name' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'bgn' => 'BGN',
 			'numeric' => 'সাংখিক',
 			'tone' => 'স্বরভঙ্গি',
 			'ungegn' => 'UNGEGN',
 			'x-accents' => 'অ্যাসেন্টস',
 			'x-fullwidth' => 'পূর্ণচওড়া',
 			'x-halfwidth' => 'অর্ধচওড়া',
 			'x-jamo' => 'জ্যামো',
 			'x-pinyin' => 'পিনইন',
 			'x-publishing' => 'প্রকাশনা',

		}
	},
);

has 'display_name_code_patterns' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'language' => 'ভাষা: {0}',
 			'script' => 'লিপি: {0}',
 			'territory' => 'অঞ্চল: {0}',

		}
	},
);

has 'characters' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> $^V ge v5.18.0
	? eval <<'EOT'
	sub {
		no warnings 'experimental::regex_sets';
		return {
			auxiliary => qr{(?^u:[‌‍ ৲ ৳ ৴ ৵ ৶ ৷ ৸ ৹ ৰ ৱ])},
			index => ['অ', 'আ', 'ই', 'ঈ', 'উ', 'ঊ', 'ঋ', 'এ', 'ঐ', 'ও', 'ঔ', 'ক', '{ক\u09CDষ}', 'খ', 'গ', 'ঘ', 'ঙ', 'চ', 'ছ', 'জ', 'ঝ', 'ঞ', 'ট', 'ঠ', 'ড', 'ঢ', 'ণ', 'ত', 'থ', 'দ', 'ধ', 'ন', 'প', 'ফ', 'ব', 'ভ', 'ম', 'য', 'র', 'ল', 'শ', 'ষ', 'স', 'হ'],
			main => qr{(?^u:[় ৺ অ আ ই ঈ উ ঊ ঋ ৠ ঌ ৡ এ ঐ ও ঔ ং ঃ ঁ ক {ক্ষ} খ গ ঘ ঙ চ ছ জ ঝ ঞ ট ঠ ড {ড়} ঢ {ঢ়} ণ ত ৎ থ দ ধ ন প ফ ব ভ ম য {য়} র ল শ ষ স হ ঽ া ি ী ু ূ ৃ ৄ ৢ ৣ ে ৈ ো ৌ ্ ৗ])},
		};
	},
EOT
: sub {
		return { index => ['অ', 'আ', 'ই', 'ঈ', 'উ', 'ঊ', 'ঋ', 'এ', 'ঐ', 'ও', 'ঔ', 'ক', '{ক\u09CDষ}', 'খ', 'গ', 'ঘ', 'ঙ', 'চ', 'ছ', 'জ', 'ঝ', 'ঞ', 'ট', 'ঠ', 'ড', 'ঢ', 'ণ', 'ত', 'থ', 'দ', 'ধ', 'ন', 'প', 'ফ', 'ব', 'ভ', 'ম', 'য', 'র', 'ল', 'শ', 'ষ', 'স', 'হ'], };
},
);


has 'ellipsis' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub {
		return {
			'final' => '{0} …',
			'initial' => '… {0}',
			'medial' => '{0} … {1}',
			'word-final' => '{0} …',
			'word-initial' => '… {0}',
			'word-medial' => '{0} … {1}',
		};
	},
);

has 'more_information' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> qq{?},
);

has 'quote_start' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> qq{“},
);

has 'quote_end' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> qq{”},
);

has 'alternate_quote_start' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> qq{‘},
);

has 'alternate_quote_end' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> qq{’},
);

has 'duration_units' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { {
				hm => 'h:mm',
				hms => 'h:mm:ss',
				ms => 'm:ss',
			} }
);

has 'units' => (
	is			=> 'ro',
	isa			=> 'HashRef[HashRef[HashRef[Str]]]',
	init_arg	=> undef,
	default		=> sub { {
				'long' => {
					'acre' => {
						'one' => q({0} একর),
						'other' => q({0} একর),
					},
					'arc-minute' => {
						'one' => q({0}মিনিট),
						'other' => q({0}মিনিট),
					},
					'arc-second' => {
						'one' => q({0}সেকেন্ড),
						'other' => q({0}সেকেন্ড),
					},
					'celsius' => {
						'one' => q({0}ডিগ্রী সেলসিয়াস),
						'other' => q({0}ডিগ্রী সেলসিয়াস),
					},
					'centimeter' => {
						'one' => q({0} সেন্টিমিটার),
						'other' => q({0} সেন্টিমিটার),
					},
					'cubic-kilometer' => {
						'one' => q({0} কিউবিক কিলোমিটার),
						'other' => q({0} কিউবিক কিলোমিটার),
					},
					'cubic-mile' => {
						'one' => q({0} কিউবিক মাইল),
						'other' => q({0} কিউবিক মাইল),
					},
					'day' => {
						'one' => q({0} দিন),
						'other' => q({0} দিন),
					},
					'degree' => {
						'one' => q({0}ডিগ্রী),
						'other' => q({0}ডিগ্রী),
					},
					'fahrenheit' => {
						'one' => q({0}ডিগ্রী ফারেনহাইট),
						'other' => q({0}ডিগ্রী ফারেনহাইট),
					},
					'foot' => {
						'one' => q({0} ফুট),
						'other' => q({0} ফুট),
					},
					'g-force' => {
						'one' => q({0} জি-বল),
						'other' => q({0} জি-বল),
					},
					'gram' => {
						'one' => q({0} গ্রাম),
						'other' => q({0} গ্রাম),
					},
					'hectare' => {
						'one' => q({0} হেক্টর),
						'other' => q({0} হেক্টর),
					},
					'hectopascal' => {
						'one' => q({0} হেক্টোপাসকল),
						'other' => q({0} হেক্টোপাসকল),
					},
					'horsepower' => {
						'one' => q({0} হর্সপাওয়ার),
						'other' => q({0} হর্সপাওয়ার),
					},
					'hour' => {
						'one' => q({0} ঘন্টা),
						'other' => q({0} ঘন্টা),
					},
					'inch' => {
						'one' => q({0} ইঞ্চি),
						'other' => q({0} ইঞ্চি),
					},
					'inch-hg' => {
						'one' => q({0} ইঞ্চি পারদ),
						'other' => q({0} ইঞ্চি পারদ),
					},
					'kilogram' => {
						'one' => q({0} কিলোগ্রাম),
						'other' => q({0} কিলোগ্রাম),
					},
					'kilometer' => {
						'one' => q({0} কিলোমিটার),
						'other' => q({0} কিলোমিটার),
					},
					'kilometer-per-hour' => {
						'one' => q({0} ঘন্টা প্রতি কিলোমিটার),
						'other' => q({0} ঘন্টা প্রতি কিলোমিটার),
					},
					'kilowatt' => {
						'one' => q({0} কিলোওয়াট),
						'other' => q({0} কিলোওয়াট),
					},
					'light-year' => {
						'one' => q({0} আলোকবর্ষ),
						'other' => q({0} আলোকবর্ষ),
					},
					'liter' => {
						'one' => q({0} লিটার),
						'other' => q({0} লিটার),
					},
					'meter' => {
						'one' => q({0} মিটার),
						'other' => q({0} মিটার),
					},
					'meter-per-second' => {
						'one' => q({0} মিটার প্রতি সেকেন্ড),
						'other' => q({0} মিটার প্রতি সেকেন্ড),
					},
					'mile' => {
						'one' => q({0} মাইল),
						'other' => q({0} মাইল),
					},
					'mile-per-hour' => {
						'one' => q({0} ঘন্টা প্রতি মাইল),
						'other' => q({0} ঘন্টা প্রতি মাইল),
					},
					'millibar' => {
						'one' => q({0} মিলিবার),
						'other' => q({0} মিলিবার),
					},
					'millimeter' => {
						'one' => q({0} মিলিমিটার),
						'other' => q({0} মিলিমিটার),
					},
					'millisecond' => {
						'one' => q({0} ms),
						'other' => q({0} ms),
					},
					'minute' => {
						'one' => q({0} মিনিট),
						'other' => q({0} মিনিট),
					},
					'month' => {
						'one' => q({0} মাস),
						'other' => q({0} মাস),
					},
					'ounce' => {
						'one' => q({0} আউন্স),
						'other' => q({0} আউন্স),
					},
					'per' => {
						'' => q({1} প্রতি {0}),
					},
					'picometer' => {
						'one' => q({0} পিকোমিটার),
						'other' => q({0} পিকোমিটার),
					},
					'pound' => {
						'one' => q({0} পাউন্ড),
						'other' => q({0} পাউন্ড),
					},
					'second' => {
						'one' => q({0} সেকেন্ড),
						'other' => q({0} সেকেন্ড),
					},
					'square-foot' => {
						'one' => q({0} বর্গ ফুট),
						'other' => q({0} বর্গ ফুট),
					},
					'square-kilometer' => {
						'one' => q({0} বর্গ কিলোমিটার),
						'other' => q({0} বর্গ কিলোমিটার),
					},
					'square-meter' => {
						'one' => q({0} বর্গ মিটার),
						'other' => q({0} বর্গ মিটার),
					},
					'square-mile' => {
						'one' => q({0} বর্গ মাইল),
						'other' => q({0} বর্গ মাইল),
					},
					'watt' => {
						'one' => q({0} ওয়াট),
						'other' => q({0} ওয়াট),
					},
					'week' => {
						'one' => q({0} সপ্তাহ),
						'other' => q({0} সপ্তাহ),
					},
					'yard' => {
						'one' => q({0} গজ),
						'other' => q({0} গজ),
					},
					'year' => {
						'one' => q({0} বছর),
						'other' => q({0} বছর),
					},
				},
				'narrow' => {
					'acre' => {
						'one' => q({0} একর),
						'other' => q({0} একর),
					},
					'arc-minute' => {
						'one' => q({0}মিনিট),
						'other' => q({0}মিনিট),
					},
					'arc-second' => {
						'one' => q({0}সেকেন্ড),
						'other' => q({0}সেকেন্ড),
					},
					'celsius' => {
						'one' => q({0}°),
						'other' => q({0}°),
					},
					'centimeter' => {
						'one' => q({0} সেমি),
						'other' => q({0} সেমি),
					},
					'cubic-kilometer' => {
						'one' => q({0}km³),
						'other' => q({0}km³),
					},
					'cubic-mile' => {
						'one' => q({0}mi³),
						'other' => q({0}mi³),
					},
					'day' => {
						'one' => q({0} দিন),
						'other' => q({0} দিন),
					},
					'degree' => {
						'one' => q({0}ডিগ্রী),
						'other' => q({0}ডিগ্রী),
					},
					'fahrenheit' => {
						'one' => q({0}°F),
						'other' => q({0}°F),
					},
					'foot' => {
						'one' => q({0} ফুট),
						'other' => q({0} ফুট),
					},
					'g-force' => {
						'one' => q({0} জি-বল),
						'other' => q({0} জি-বল),
					},
					'gram' => {
						'one' => q({0} গ্রাম),
						'other' => q({0} গ্রাম),
					},
					'hectare' => {
						'one' => q({0} হেক্টর),
						'other' => q({0} হেক্টর),
					},
					'hectopascal' => {
						'one' => q({0} hPa),
						'other' => q({0} hPa),
					},
					'horsepower' => {
						'one' => q({0} hp),
						'other' => q({0} hp),
					},
					'hour' => {
						'one' => q({0} ঘন্টা),
						'other' => q({0} ঘন্টা),
					},
					'inch' => {
						'one' => q({0} ইঞ্চি),
						'other' => q({0} ইঞ্চি),
					},
					'inch-hg' => {
						'one' => q({0} inHg),
						'other' => q({0} inHg),
					},
					'kilogram' => {
						'one' => q({0} কেজি),
						'other' => q({0} কেজি),
					},
					'kilometer' => {
						'one' => q({0} কিমি),
						'other' => q({0} কিমি),
					},
					'kilometer-per-hour' => {
						'one' => q({0}kph),
						'other' => q({0}kpm),
					},
					'kilowatt' => {
						'one' => q({0} kW),
						'other' => q({0} kW),
					},
					'light-year' => {
						'one' => q({0} আলোকবর্ষ),
						'other' => q({0} আলোকবর্ষ),
					},
					'liter' => {
						'one' => q({0} লিটার),
						'other' => q({0} লিটার),
					},
					'meter' => {
						'one' => q({0} মিটার),
						'other' => q({0} মিটার),
					},
					'meter-per-second' => {
						'one' => q({0}m/s),
						'other' => q({0}m/s),
					},
					'mile' => {
						'one' => q({0} মাইল),
						'other' => q({0} মাইল),
					},
					'mile-per-hour' => {
						'one' => q({0}mph),
						'other' => q({0}mph),
					},
					'millibar' => {
						'one' => q({0} mb),
						'other' => q({0} mb),
					},
					'millimeter' => {
						'one' => q({0} মিমি),
						'other' => q({0} মিমি),
					},
					'millisecond' => {
						'one' => q({0} ms),
						'other' => q({0} ms),
					},
					'minute' => {
						'one' => q({0} মিনিট),
						'other' => q({0} মিনিট),
					},
					'month' => {
						'one' => q({0} মাস),
						'other' => q({0} মাস),
					},
					'ounce' => {
						'one' => q({0} আউন্স),
						'other' => q({0} আউন্স),
					},
					'per' => {
						'' => q({0}/{1}),
					},
					'picometer' => {
						'one' => q({0} পিমি),
						'other' => q({0} পিমি),
					},
					'pound' => {
						'one' => q({0} পাউন্ড),
						'other' => q({0} পাউন্ড),
					},
					'second' => {
						'one' => q({0} সেকেন্ড),
						'other' => q({0} সেকেন্ড),
					},
					'square-foot' => {
						'one' => q({0} বর্গ ফুট),
						'other' => q({0} বর্গ ফুট),
					},
					'square-kilometer' => {
						'one' => q({0} বর্গ কিমি),
						'other' => q({0} বর্গ কিমি),
					},
					'square-meter' => {
						'one' => q({0} m²),
						'other' => q({0} m²),
					},
					'square-mile' => {
						'one' => q({0} বর্গ মাইল),
						'other' => q({0} বর্গ মাইল),
					},
					'watt' => {
						'one' => q({0} ওয়াট),
						'other' => q({0} ওয়াট),
					},
					'week' => {
						'one' => q({0} সপ্তাহ),
						'other' => q({0} সপ্তাহ),
					},
					'yard' => {
						'one' => q({0} গজ),
						'other' => q({0} গজ),
					},
					'year' => {
						'one' => q({0} বছর),
						'other' => q({0} বছর),
					},
				},
				'short' => {
					'acre' => {
						'one' => q({0} একর),
						'other' => q({0} একর),
					},
					'arc-minute' => {
						'one' => q({0}মিনিট),
						'other' => q({0}মিনিট),
					},
					'arc-second' => {
						'one' => q({0}সেকেন্ড),
						'other' => q({0}সেকেন্ড),
					},
					'celsius' => {
						'one' => q({0}°C),
						'other' => q({0}°C),
					},
					'centimeter' => {
						'one' => q({0} সেমি),
						'other' => q({0} সেমি),
					},
					'cubic-kilometer' => {
						'one' => q({0} কিউবিক কিলোমিটার),
						'other' => q({0} কিউবিক কিলোমিটার),
					},
					'cubic-mile' => {
						'one' => q({0} কিউবিক মাইল),
						'other' => q({0} কিউবিক মাইল),
					},
					'day' => {
						'one' => q({0} দিন),
						'other' => q({0} দিন),
					},
					'degree' => {
						'one' => q({0}ডিগ্রী),
						'other' => q({0}ডিগ্রী),
					},
					'fahrenheit' => {
						'one' => q({0}°F),
						'other' => q({0}°F),
					},
					'foot' => {
						'one' => q({0} ফুট),
						'other' => q({0} ফুট),
					},
					'g-force' => {
						'one' => q({0} জি-বল),
						'other' => q({0} জি-বল),
					},
					'gram' => {
						'one' => q({0}গ্রাম),
						'other' => q({0} গ্রাম),
					},
					'hectare' => {
						'one' => q({0} হেক্টর),
						'other' => q({0} হেক্টর),
					},
					'hectopascal' => {
						'one' => q({0} hPa),
						'other' => q({0} hPa),
					},
					'horsepower' => {
						'one' => q({0} hp),
						'other' => q({0} hp),
					},
					'hour' => {
						'one' => q({0} ঘন্টা),
						'other' => q({0} ঘন্টা),
					},
					'inch' => {
						'one' => q({0} ইঞ্চি),
						'other' => q({0} ইঞ্চি),
					},
					'inch-hg' => {
						'one' => q({0} inHg),
						'other' => q({0} inHg),
					},
					'kilogram' => {
						'one' => q({0} কেজি),
						'other' => q({0} কেজি),
					},
					'kilometer' => {
						'one' => q({0} কিমি),
						'other' => q({0} কিমি),
					},
					'kilometer-per-hour' => {
						'one' => q({0} ঘন্টা প্রতি কিলোমিটার),
						'other' => q({0} ঘন্টা প্রতি কিলোমিটার),
					},
					'kilowatt' => {
						'one' => q({0} kW),
						'other' => q({0} kW),
					},
					'light-year' => {
						'one' => q({0} আলোকবর্ষ),
						'other' => q({0} আলোকবর্ষ),
					},
					'liter' => {
						'one' => q({0} লিটার),
						'other' => q({0} লিটার),
					},
					'meter' => {
						'one' => q({0} মিটার),
						'other' => q({0} মিটার),
					},
					'meter-per-second' => {
						'one' => q({0} মিটার প্রতি সেকেন্ড),
						'other' => q({0} মিটার প্রতি সেকেন্ড),
					},
					'mile' => {
						'one' => q({0} মাইল),
						'other' => q({0} মাইল),
					},
					'mile-per-hour' => {
						'one' => q({0} ঘন্টা প্রতি মাইল),
						'other' => q({0} ঘন্টা প্রতি মাইল),
					},
					'millibar' => {
						'one' => q({0} mbar),
						'other' => q({0} mbar),
					},
					'millimeter' => {
						'one' => q({0} মিমি),
						'other' => q({0} মিমি),
					},
					'millisecond' => {
						'one' => q({0} ms),
						'other' => q({0} ms),
					},
					'minute' => {
						'one' => q({0} মিনিট),
						'other' => q({0} মিনিট),
					},
					'month' => {
						'one' => q({0} মাস),
						'other' => q({0} মাস),
					},
					'ounce' => {
						'one' => q({0} আউন্স),
						'other' => q({0} আউন্স),
					},
					'per' => {
						'' => q({0}/{1}),
					},
					'picometer' => {
						'one' => q({0} পিকোমিটার),
						'other' => q({0} পিকোমিটার),
					},
					'pound' => {
						'one' => q({0} পাউন্ড),
						'other' => q({0} পাউন্ড),
					},
					'second' => {
						'one' => q({0} সেকেন্ড),
						'other' => q({0} সেকেন্ড),
					},
					'square-foot' => {
						'one' => q({0}বর্গ ফুট),
						'other' => q({0} বর্গ ফুট),
					},
					'square-kilometer' => {
						'one' => q({0} বর্গ কিমি),
						'other' => q({0} বর্গ কিমি),
					},
					'square-meter' => {
						'one' => q({0} বর্গ মিটার),
						'other' => q({0} বর্গ মিটার),
					},
					'square-mile' => {
						'one' => q({0} বর্গ মাইল),
						'other' => q({0} বর্গ মাইল),
					},
					'watt' => {
						'one' => q({0} ওয়াট),
						'other' => q({0} ওয়াট),
					},
					'week' => {
						'one' => q({0} সপ্তাহ),
						'other' => q({0} সপ্তাহ),
					},
					'yard' => {
						'one' => q({0} গজ),
						'other' => q({0} গজ),
					},
					'year' => {
						'one' => q({0} বছর),
						'other' => q({0} বছর),
					},
				},
			} }
);

has 'yesstr' => (
	is			=> 'ro',
	isa			=> 'RegexpRef',
	init_arg	=> undef,
	default		=> sub { qr'^(?i:হাঁ|yes|y)$' }
);

has 'nostr' => (
	is			=> 'ro',
	isa			=> 'RegexpRef',
	init_arg	=> undef,
	default		=> sub { qr'^(?i:না|no|n)$' }
);

has 'listPatterns' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
				start => q({0}, {1}),
				middle => q({0}, {1}),
				end => q({0}, {1}),
				2 => q({0} এবং {1}),
		} }
);

has 'default_numbering_system' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> 'beng',
);

has native_numbering_system => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> 'beng',
);

has 'number_symbols' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'beng' => {
			'decimal' => q(),
			'exponential' => q(),
			'group' => q(),
			'infinity' => q(),
			'list' => q(),
			'minusSign' => q(),
			'nan' => q(সংখ্যা না),
			'perMille' => q(),
			'percentSign' => q(),
			'plusSign' => q(),
			'superscriptingExponent' => q(),
		},
		'latn' => {
			'decimal' => q(.),
			'exponential' => q(E),
			'group' => q(,),
			'infinity' => q(∞),
			'list' => q(;),
			'minusSign' => q(-),
			'nan' => q(NaN),
			'perMille' => q(‰),
			'percentSign' => q(%),
			'plusSign' => q(+),
			'superscriptingExponent' => q(×),
		},
	} }
);

has 'number_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		decimalFormat => {
			'default' => {
				'0' => {
					'default' => '#,##,##0.###',
				},
				'1000' => {
					'one' => '0K',
					'other' => '0K',
				},
				'10000' => {
					'one' => '00K',
					'other' => '00K',
				},
				'100000' => {
					'one' => '0 লাখ',
					'other' => '0 লাখ',
				},
				'1000000' => {
					'one' => '0M',
					'other' => '0M',
				},
				'10000000' => {
					'one' => '00M',
					'other' => '00M',
				},
				'100000000' => {
					'one' => '000M',
					'other' => '000M',
				},
				'1000000000' => {
					'one' => '0B',
					'other' => '0B',
				},
				'10000000000' => {
					'one' => '00B',
					'other' => '00B',
				},
				'100000000000' => {
					'one' => '000B',
					'other' => '000B',
				},
				'1000000000000' => {
					'one' => '0T',
					'other' => '0T',
				},
				'10000000000000' => {
					'one' => '00T',
					'other' => '00T',
				},
				'100000000000000' => {
					'one' => '000T',
					'other' => '000T',
				},
			},
			'long' => {
				'1000' => {
					'one' => '0 হাজার',
					'other' => '0 হাজার',
				},
				'10000' => {
					'one' => '00 হাজার',
					'other' => '00 হাজার',
				},
				'100000' => {
					'one' => '0 লাখ',
					'other' => '0 লাখ',
				},
				'1000000' => {
					'one' => '0 মিলিয়ন',
					'other' => '0 মিলিয়ন',
				},
				'10000000' => {
					'one' => '00 মিলিয়ন',
					'other' => '00 মিলিয়ন',
				},
				'100000000' => {
					'one' => '000 মিলিয়ন',
					'other' => '000 মিলিয়ন',
				},
				'1000000000' => {
					'one' => '0 বিলিয়ন',
					'other' => '0 বিলিয়ন',
				},
				'10000000000' => {
					'one' => '00 বিলিয়ন',
					'other' => '00 বিলিয়ন',
				},
				'100000000000' => {
					'one' => '000 বিলিয়ন',
					'other' => '000 বিলিয়ন',
				},
				'1000000000000' => {
					'one' => '0 ট্রিলিয়ন',
					'other' => '0 ট্রিলিয়ন',
				},
				'10000000000000' => {
					'one' => '00 ট্রিলিয়ন',
					'other' => '00 ট্রিলিয়ন',
				},
				'100000000000000' => {
					'one' => '000 ট্রিলিয়ন',
					'other' => '000 ট্রিলিয়ন',
				},
			},
			'short' => {
				'1000' => {
					'one' => '0K',
					'other' => '0K',
				},
				'10000' => {
					'one' => '00K',
					'other' => '00K',
				},
				'100000' => {
					'one' => '0 লাখ',
					'other' => '0 লাখ',
				},
				'1000000' => {
					'one' => '0M',
					'other' => '0M',
				},
				'10000000' => {
					'one' => '00M',
					'other' => '00M',
				},
				'100000000' => {
					'one' => '000M',
					'other' => '000M',
				},
				'1000000000' => {
					'one' => '0B',
					'other' => '0B',
				},
				'10000000000' => {
					'one' => '00B',
					'other' => '00B',
				},
				'100000000000' => {
					'one' => '000B',
					'other' => '000B',
				},
				'1000000000000' => {
					'one' => '0T',
					'other' => '0T',
				},
				'10000000000000' => {
					'one' => '00T',
					'other' => '00T',
				},
				'100000000000000' => {
					'one' => '000T',
					'other' => '000T',
				},
			},
		},
		percentFormat => {
			'default' => {
				'0' => {
					'default' => '#,##,##0%',
				},
			},
		},
		scientificFormat => {
			'default' => {
				'0' => {
					'default' => '#E0',
				},
			},
		},
} },
);

has 'number_currency_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'latn' => {
			'pattern' => {
				'default' => {
					'accounting' => {
						'negative' => '(#,##,##0.00¤)',
						'positive' => '#,##,##0.00¤',
					},
					'standard' => {
						'negative' => '#,##,##0.00¤',
						'positive' => '#,##,##0.00¤',
					},
				},
			},
		},
} },
);

has 'curriencies' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'ADP' => {
			display_name => {
				'currency' => q(এ্যান্ডোরান পেসেতা),
			},
		},
		'AED' => {
			display_name => {
				'currency' => q(সংযুক্ত আরব আমিরাত দিরহাম),
				'one' => q(সংযুক্ত আরব আমিরাত দিরহাম),
				'other' => q(সংযুক্ত আরব আমিরাত দিরহাম),
			},
		},
		'AFA' => {
			display_name => {
				'currency' => q(আফগানি \(১৯২৭–২০০২\)),
			},
		},
		'AFN' => {
			display_name => {
				'currency' => q(আফগানি),
				'one' => q(আফগানি),
				'other' => q(আফগানি),
			},
		},
		'ALL' => {
			display_name => {
				'currency' => q(আলবেনিয়ান লেক),
				'one' => q(আলবেনিয়ান লেক),
				'other' => q(আলবেনিয়ান লেক),
			},
		},
		'AMD' => {
			display_name => {
				'currency' => q(আরমেনিয়ান দ্রাম),
				'one' => q(আরমেনিয়ান দ্রাম),
				'other' => q(আরমেনিয়ান দ্রাম),
			},
		},
		'ANG' => {
			display_name => {
				'currency' => q(নেদারল্যান্ড এ্যান্টিলিয়ান গুল্ডের),
				'one' => q(নেদারল্যান্ড এ্যান্টিলিয়ান গুল্ডের),
				'other' => q(নেদারল্যান্ড এ্যান্টিলিয়ান গুল্ডের),
			},
		},
		'AOA' => {
			display_name => {
				'currency' => q(এ্যাঙ্গোলান কওয়ানজা),
				'one' => q(এ্যাঙ্গোলান কওয়ানজা),
				'other' => q(এ্যাঙ্গোলান কওয়ানজা),
			},
		},
		'AOK' => {
			display_name => {
				'currency' => q(এ্যাঙ্গোলান কওয়ানজা \(১৯৭৭–১৯৯০\)),
			},
		},
		'AON' => {
			display_name => {
				'currency' => q(এ্যাঙ্গোলান নতুন কওয়ানজা \(১৯৯৫–২০০০\)),
			},
		},
		'AOR' => {
			display_name => {
				'currency' => q(এ্যাঙ্গোলান কওয়ানজা \(১৯৯৫–১৯৯৯\)),
			},
		},
		'ARA' => {
			display_name => {
				'currency' => q(আর্জেন্টিনা অস্ট্রাল),
			},
		},
		'ARP' => {
			display_name => {
				'currency' => q(আর্জেন্টিনা পেসো \(১৯৮৩–১৯৮৫\)),
			},
		},
		'ARS' => {
			display_name => {
				'currency' => q(আর্জেন্টিনা পেসো),
				'one' => q(আর্জেন্টিনা পেসো),
				'other' => q(আর্জেন্টিনা পেসো),
			},
		},
		'ATS' => {
			display_name => {
				'currency' => q(অস্ট্রিয়ান শিলিং),
			},
		},
		'AUD' => {
			symbol => 'A$',
			display_name => {
				'currency' => q(অস্ট্রেলিয়ান ডলার),
				'one' => q(অস্ট্রেলিয়ান ডলার),
				'other' => q(অস্ট্রেলিয়ান ডলার),
			},
		},
		'AWG' => {
			display_name => {
				'currency' => q(আরুবা গিল্ডার),
				'one' => q(আরুবা গিল্ডার),
				'other' => q(আরুবা গিল্ডার),
			},
		},
		'AZM' => {
			display_name => {
				'currency' => q(আজারবাইজান মানাত \(১৯৯৩–২০০৬\)),
			},
		},
		'AZN' => {
			display_name => {
				'currency' => q(আজারবাইজান মানাত),
				'one' => q(আজারবাইজান মানাত),
				'other' => q(আজারবাইজান মানাত),
			},
		},
		'BAD' => {
			display_name => {
				'currency' => q(বসনিয়া এবং হার্জেগোভিনা দিনার),
			},
		},
		'BAM' => {
			display_name => {
				'currency' => q(বসনিয়া এবং হার্জেগোভিনা মার্ক),
				'one' => q(বসনিয়া এবং হার্জেগোভিনা মার্ক),
				'other' => q(বসনিয়া এবং হার্জেগোভিনা মার্ক),
			},
		},
		'BBD' => {
			display_name => {
				'currency' => q(বার্বেডোজ ডলার),
				'one' => q(বার্বেডোজ ডলার),
				'other' => q(বার্বেডোজ ডলার),
			},
		},
		'BDT' => {
			symbol => '৳',
			display_name => {
				'currency' => q(বাংলাদেশী টাকা),
				'one' => q(বাংলাদেশী টাকা),
				'other' => q(বাংলাদেশী টাকা),
			},
		},
		'BEC' => {
			display_name => {
				'currency' => q(বেলজিয়ান ফ্রাঙ্ক \(রূপান্তরযোগ্য\)),
			},
		},
		'BEF' => {
			display_name => {
				'currency' => q(বেলজিয়ান ফ্রাঙ্ক),
			},
		},
		'BEL' => {
			display_name => {
				'currency' => q(বেলজিয়ান ফ্রাঙ্ক \(আর্থিক\)),
			},
		},
		'BGL' => {
			display_name => {
				'currency' => q(বুলগেরীয় হার্ড লেভ),
			},
		},
		'BGN' => {
			display_name => {
				'currency' => q(বুলগেরীয় নিউ লেভ),
				'one' => q(বুলগেরীয় নিউ লেভ),
				'other' => q(বুলগেরীয় নিউ লেভ),
			},
		},
		'BHD' => {
			display_name => {
				'currency' => q(বাহরাইনি দিনার),
				'one' => q(বাহরাইনি দিনার),
				'other' => q(বাহরাইনি দিনার),
			},
		},
		'BIF' => {
			display_name => {
				'currency' => q(বুরুন্ডি ফ্রাঙ্ক),
				'one' => q(বুরুন্ডি ফ্রাঙ্ক),
				'other' => q(বুরুন্ডি ফ্রাঙ্ক),
			},
		},
		'BMD' => {
			display_name => {
				'currency' => q(বারমিউডান ডলার),
				'one' => q(বারমিউডান ডলার),
				'other' => q(বারমিউডান ডলার),
			},
		},
		'BND' => {
			display_name => {
				'currency' => q(ব্রুনেই ডলার),
				'one' => q(ব্রুনেই ডলার),
				'other' => q(ব্রুনেই ডলার),
			},
		},
		'BOB' => {
			display_name => {
				'currency' => q(বলিভিয়ানো),
				'one' => q(বলিভিয়ানো),
				'other' => q(বলিভিয়ানো),
			},
		},
		'BOP' => {
			display_name => {
				'currency' => q(বলিভিয়ান পেসো),
			},
		},
		'BOV' => {
			display_name => {
				'currency' => q(বলিভিয়ান মভডোল),
			},
		},
		'BRB' => {
			display_name => {
				'currency' => q(ব্রাজিলিয়ান ক্রুজেয়রোনোভো \(১৯৬৭–১৯৮৬\)),
			},
		},
		'BRC' => {
			display_name => {
				'currency' => q(ব্রাজিলিয়ান ক্রুজেইডাউ),
			},
		},
		'BRE' => {
			display_name => {
				'currency' => q(ব্রাজিলিয়ান ক্রুজেয়রো \(১৯৯০–১৯৯৩\)),
			},
		},
		'BRL' => {
			symbol => 'R$',
			display_name => {
				'currency' => q(ব্রাজিলিয়ান রিয়েল),
				'one' => q(ব্রাজিলিয়ান রিয়েল),
				'other' => q(ব্রাজিলিয়ান রিয়েল),
			},
		},
		'BRN' => {
			display_name => {
				'currency' => q(ব্রাজিলিয়ান ক্রুজেইডো নোভো),
			},
		},
		'BRR' => {
			display_name => {
				'currency' => q(ব্রাজিলিয়ান ক্রুজেয়রো),
			},
		},
		'BSD' => {
			display_name => {
				'currency' => q(বাহামিয়ান ডলার),
				'one' => q(বাহামিয়ান ডলার),
				'other' => q(বাহামিয়ান ডলার),
			},
		},
		'BTN' => {
			display_name => {
				'currency' => q(ভুটানি এনগুল্ট্রুম),
				'one' => q(ভুটানি এনগুল্ট্রুম),
				'other' => q(ভুটানি এনগুল্ট্রুম),
			},
		},
		'BUK' => {
			display_name => {
				'currency' => q(বর্মি কিয়াৎ),
			},
		},
		'BWP' => {
			display_name => {
				'currency' => q(বতসোয়ানা পুলা),
				'one' => q(বতসোয়ানা পুলা),
				'other' => q(বতসোয়ানা পুলা),
			},
		},
		'BYB' => {
			display_name => {
				'currency' => q(বেলারুশিয়ান নিউ রুবেল \(১৯৯৪–১৯৯৯\)),
			},
		},
		'BYR' => {
			display_name => {
				'currency' => q(বেলারুশিয়ান রুবেল),
				'one' => q(বেলারুশিয়ান রুবেল),
				'other' => q(বেলারুশিয়ান রুবেল),
			},
		},
		'BZD' => {
			display_name => {
				'currency' => q(বেলিজ ডলার),
				'one' => q(বেলিজ ডলার),
				'other' => q(বেলিজ ডলার),
			},
		},
		'CAD' => {
			symbol => 'CA$',
			display_name => {
				'currency' => q(কানাডিয়ান ডলার),
				'one' => q(কানাডিয়ান ডলার),
				'other' => q(কানাডিয়ান ডলার),
			},
		},
		'CDF' => {
			display_name => {
				'currency' => q(কঙ্গো ফ্র্যাঙ্ক কঙ্গোলাইস),
				'one' => q(কঙ্গো ফ্র্যাঙ্ক কঙ্গোলাইস),
				'other' => q(কঙ্গো ফ্র্যাঙ্ক কঙ্গোলাইস),
			},
		},
		'CHE' => {
			display_name => {
				'currency' => q(সুইজারল্যান্ড ইউরো),
			},
		},
		'CHF' => {
			display_name => {
				'currency' => q(সুইস ফ্রাঙ্ক),
				'one' => q(সুইস ফ্রাঙ্ক),
				'other' => q(সুইস ফ্রাঙ্ক),
			},
		},
		'CHW' => {
			display_name => {
				'currency' => q(সুইজারল্যান্ড ফ্রাঙ্ক),
			},
		},
		'CLF' => {
			display_name => {
				'currency' => q(চিলিয়ান উনিদাদেস দি ফোমেন্তো),
			},
		},
		'CLP' => {
			display_name => {
				'currency' => q(চিলি পেসো),
				'one' => q(চিলি পেসো),
				'other' => q(চিলি পেসো),
			},
		},
		'CNY' => {
			symbol => 'CN¥',
			display_name => {
				'currency' => q(চীনা য়ুয়ান রেন্মিন্‌বি),
				'one' => q(চীনা য়ুয়ান রেন্মিন্‌বি),
				'other' => q(চীনা য়ুয়ান রেন্মিন্‌বি),
			},
		},
		'COP' => {
			display_name => {
				'currency' => q(কলোম্বিয়ান পেসো),
				'one' => q(কলোম্বিয়ান পেসো),
				'other' => q(কলোম্বিয়ান পেসো),
			},
		},
		'COU' => {
			display_name => {
				'currency' => q(উনিদাদ দি ভ্যালোর রিয়েল),
			},
		},
		'CRC' => {
			display_name => {
				'currency' => q(কোস্টা রিকা কোলোন),
				'one' => q(কোস্টা রিকা কোলোন),
				'other' => q(কোস্টা রিকা কোলোন),
			},
		},
		'CSD' => {
			display_name => {
				'currency' => q(প্রাচীন সারবিয়ান দিনার),
			},
		},
		'CSK' => {
			display_name => {
				'currency' => q(চেকোস্লোভাক হার্ড কোরুনা),
			},
		},
		'CUC' => {
			display_name => {
				'currency' => q(কিউবান রূপান্তরযোগ্য পেসো),
				'one' => q(কিউবান রূপান্তরযোগ্য পেসো),
				'other' => q(কিউবান রূপান্তরযোগ্য পেসো),
			},
		},
		'CUP' => {
			display_name => {
				'currency' => q(কিউবান পেসো),
				'one' => q(কিউবান পেসো),
				'other' => q(কিউবান পেসো),
			},
		},
		'CVE' => {
			display_name => {
				'currency' => q(কেপ ভার্দে এসকুডো),
				'one' => q(কেপ ভার্দে এসকুডো),
				'other' => q(কেপ ভার্দে এসকুডো),
			},
		},
		'CYP' => {
			display_name => {
				'currency' => q(সাইপ্রাস পাউন্ড),
			},
		},
		'CZK' => {
			display_name => {
				'currency' => q(চেকোস্লোভাক কোরুনা),
				'one' => q(চেকোস্লোভাক কোরুনা),
				'other' => q(চেকোস্লোভাক কোরুনা),
			},
		},
		'DDM' => {
			display_name => {
				'currency' => q(পূর্ব জার্মান মার্ক),
			},
		},
		'DEM' => {
			display_name => {
				'currency' => q(ডয়চ্ মার্ক),
			},
		},
		'DJF' => {
			display_name => {
				'currency' => q(জিবুতি ফ্রাঙ্ক),
				'one' => q(জিবুতি ফ্রাঙ্ক),
				'other' => q(জিবুতি ফ্রাঙ্ক),
			},
		},
		'DKK' => {
			display_name => {
				'currency' => q(ড্যানিশ ক্রৌন),
				'one' => q(ড্যানিশ ক্রৌন),
				'other' => q(ড্যানিশ ক্রৌন),
			},
		},
		'DOP' => {
			display_name => {
				'currency' => q(ডোমিনিকান পেসো),
				'one' => q(ডোমিনিকান পেসো),
				'other' => q(ডোমিনিকান পেসো),
			},
		},
		'DZD' => {
			display_name => {
				'currency' => q(আলজেরীয় দিনার),
				'one' => q(আলজেরীয় দিনার),
				'other' => q(আলজেরীয় দিনার),
			},
		},
		'ECS' => {
			display_name => {
				'currency' => q(ইকুয়াডোর সুক্রে),
			},
		},
		'ECV' => {
			display_name => {
				'currency' => q(ইকুয়াডোর উনিদাদেস দি ভেলর কনসতান্তে \(ইউভিসি\)),
			},
		},
		'EEK' => {
			display_name => {
				'currency' => q(এস্তোনিয়া ক্রুনি),
			},
		},
		'EGP' => {
			display_name => {
				'currency' => q(মিশরীয় পাউন্ড),
				'one' => q(মিশরীয় পাউন্ড),
				'other' => q(মিশরীয় পাউন্ড),
			},
		},
		'ERN' => {
			display_name => {
				'currency' => q(এরিট্রিয়েন নাকফা),
				'one' => q(এরিট্রিয়েন নাকফা),
				'other' => q(এরিট্রিয়েন নাকফা),
			},
		},
		'ESA' => {
			display_name => {
				'currency' => q(স্প্যানিশ পেসেতা \(একই হিসাব\)),
			},
		},
		'ESB' => {
			display_name => {
				'currency' => q(স্প্যানিশ পেসেতা \(রূপান্তরযোগ্য হিসাব\)),
			},
		},
		'ESP' => {
			display_name => {
				'currency' => q(স্প্যানিশ পেসেতা),
			},
		},
		'ETB' => {
			display_name => {
				'currency' => q(ইথিওপিয়ান বির),
				'one' => q(ইথিওপিয়ান বির),
				'other' => q(ইথিওপিয়ান বির),
			},
		},
		'EUR' => {
			symbol => '€',
			display_name => {
				'currency' => q(ইউরো),
				'one' => q(ইউরো),
				'other' => q(ইউরো),
			},
		},
		'FIM' => {
			display_name => {
				'currency' => q(ফিনিস মার্কা),
			},
		},
		'FJD' => {
			display_name => {
				'currency' => q(ফিজি ডলার),
				'one' => q(ফিজি ডলার),
				'other' => q(ফিজি ডলার),
			},
		},
		'FKP' => {
			display_name => {
				'currency' => q(ফকল্যান্ড দ্বীপপুঞ্জ পাউন্ড),
				'one' => q(ফকল্যান্ড দ্বীপপুঞ্জ পাউন্ড),
				'other' => q(ফকল্যান্ড দ্বীপপুঞ্জ পাউন্ড),
			},
		},
		'FRF' => {
			display_name => {
				'currency' => q(ফরাসি ফ্রাঙ্ক),
			},
		},
		'GBP' => {
			symbol => '£',
			display_name => {
				'currency' => q(ব্রিটিশ পাউন্ড স্টার্লিং),
				'one' => q(ব্রিটিশ পাউন্ড স্টার্লিং),
				'other' => q(ব্রিটিশ পাউন্ড স্টার্লিং),
			},
		},
		'GEK' => {
			display_name => {
				'currency' => q(জর্জিয়ান কুপন লারিট),
			},
		},
		'GEL' => {
			display_name => {
				'currency' => q(জর্জিয়ান লারি),
				'one' => q(জর্জিয়ান লারি),
				'other' => q(জর্জিয়ান লারি),
			},
		},
		'GHC' => {
			display_name => {
				'currency' => q(ঘানা সেডি \(১৯৭৯–২০০৭\)),
			},
		},
		'GHS' => {
			display_name => {
				'currency' => q(ঘানা সেডি),
				'one' => q(ঘানা সেডি),
				'other' => q(ঘানা সেডি),
			},
		},
		'GIP' => {
			display_name => {
				'currency' => q(জিব্রাল্টার পাউন্ড),
				'one' => q(জিব্রাল্টার পাউন্ড),
				'other' => q(জিব্রাল্টার পাউন্ড),
			},
		},
		'GMD' => {
			display_name => {
				'currency' => q(গাম্বিয়া ডালাসি),
				'one' => q(গাম্বিয়া ডালাসি),
				'other' => q(গাম্বিয়া ডালাসি),
			},
		},
		'GNF' => {
			display_name => {
				'currency' => q(গিনি ফ্রাঙ্ক),
				'one' => q(গিনি ফ্রাঙ্ক),
				'other' => q(গিনি ফ্রাঙ্ক),
			},
		},
		'GNS' => {
			display_name => {
				'currency' => q(গিনি সাইলি),
			},
		},
		'GQE' => {
			display_name => {
				'currency' => q(ইকুয়েটোরিয়াল গিনি ইকুয়িলি),
			},
		},
		'GRD' => {
			display_name => {
				'currency' => q(গ্রীক দ্রাচমা),
			},
		},
		'GTQ' => {
			display_name => {
				'currency' => q(গুয়াতেমালা কুয়েৎজাল),
				'one' => q(গুয়াতেমালা কুয়েৎজাল),
				'other' => q(গুয়াতেমালা কুয়েৎজাল),
			},
		},
		'GWE' => {
			display_name => {
				'currency' => q(পর্তুগিজ গিনি এসকুডো),
			},
		},
		'GWP' => {
			display_name => {
				'currency' => q(গিনি বিসাউ পেসো),
			},
		},
		'GYD' => {
			display_name => {
				'currency' => q(গাইয়েনা ডলার),
				'one' => q(গাইয়েনা ডলার),
				'other' => q(গাইয়েনা ডলার),
			},
		},
		'HKD' => {
			symbol => 'HK$',
			display_name => {
				'currency' => q(হংকং ডলার),
				'one' => q(হংকং ডলার),
				'other' => q(হংকং ডলার),
			},
		},
		'HNL' => {
			display_name => {
				'currency' => q(হন্ডুরাস লেম্পিরা),
				'one' => q(হন্ডুরাস লেম্পিরা),
				'other' => q(হন্ডুরাস লেম্পিরা),
			},
		},
		'HRD' => {
			display_name => {
				'currency' => q(ক্রোয়েশিয়ান দিনার),
			},
		},
		'HRK' => {
			display_name => {
				'currency' => q(ক্রোয়েশিয়ান কুনা),
				'one' => q(ক্রোয়েশিয়ান কুনাস),
				'other' => q(ক্রোয়েশিয়ান কুনাস),
			},
		},
		'HTG' => {
			display_name => {
				'currency' => q(হাইতি গৌর্দে),
				'one' => q(হাইতি গৌর্দে),
				'other' => q(হাইতি গৌর্দে),
			},
		},
		'HUF' => {
			display_name => {
				'currency' => q(হাঙ্গেরিয়ান ফোরিন্ট),
				'one' => q(হাঙ্গেরিয়ান ফোরিন্ট),
				'other' => q(হাঙ্গেরিয়ান ফোরিন্ট),
			},
		},
		'IDR' => {
			display_name => {
				'currency' => q(ইন্দোনেশিয়ান রুপিয়াহ),
				'one' => q(ইন্দোনেশিয়ান রুপিয়াহ),
				'other' => q(ইন্দোনেশিয়ান রুপিয়াহ),
			},
		},
		'IEP' => {
			display_name => {
				'currency' => q(ইরিশ পাউন্ড),
			},
		},
		'ILP' => {
			display_name => {
				'currency' => q(ইস্রাইলি পাউন্ড),
			},
		},
		'ILS' => {
			symbol => '₪',
			display_name => {
				'currency' => q(ইস্রাইলি নতুন শেকেল),
				'one' => q(ইস্রাইলি নতুন শেকেল),
				'other' => q(ইস্রাইলি নতুন শেকেল),
			},
		},
		'INR' => {
			symbol => '₹',
			display_name => {
				'currency' => q(ভারতীয় রুপি),
				'one' => q(ভারতীয় রুপি),
				'other' => q(ভারতীয় রুপি),
			},
		},
		'IQD' => {
			display_name => {
				'currency' => q(ইরাকি দিনার),
				'one' => q(ইরাকি দিনার),
				'other' => q(ইরাকি দিনার),
			},
		},
		'IRR' => {
			display_name => {
				'currency' => q(ইরানিয়ান রিয়াল),
				'one' => q(ইরানিয়ান রিয়াল),
				'other' => q(ইরানিয়ান রিয়াল),
			},
		},
		'ISK' => {
			display_name => {
				'currency' => q(আইসল্যান্ড ক্রৌন),
				'one' => q(আইসল্যান্ড ক্রৌন),
				'other' => q(আইসল্যান্ড ক্রৌন),
			},
		},
		'ITL' => {
			display_name => {
				'currency' => q(ইতালীয় লিরা),
			},
		},
		'JMD' => {
			display_name => {
				'currency' => q(জ্যামাইকান ডলার),
				'one' => q(জ্যামাইকান ডলার),
				'other' => q(জ্যামাইকান ডলার),
			},
		},
		'JOD' => {
			display_name => {
				'currency' => q(জর্ডানিয়ান দিনার),
				'one' => q(জর্ডানিয়ান দিনার),
				'other' => q(জর্ডানিয়ান দিনার),
			},
		},
		'JPY' => {
			symbol => 'JP¥',
			display_name => {
				'currency' => q(জাপানিজ ইয়েন),
				'one' => q(জাপানিজ ইয়েন),
				'other' => q(জাপানিজ ইয়েন),
			},
		},
		'KES' => {
			display_name => {
				'currency' => q(কেনিয়ান শিলিং),
				'one' => q(কেনিয়ান শিলিং),
				'other' => q(কেনিয়ান শিলিং),
			},
		},
		'KGS' => {
			display_name => {
				'currency' => q(কিরগিজস্তান সোম),
				'one' => q(কিরগিজস্তান সোম),
				'other' => q(কিরগিজস্তান সোম),
			},
		},
		'KHR' => {
			display_name => {
				'currency' => q(কম্বোডিয়ান রিয়েল),
				'one' => q(কম্বোডিয়ান রিয়েল),
				'other' => q(কম্বোডিয়ান রিয়েল),
			},
		},
		'KMF' => {
			display_name => {
				'currency' => q(কম্বোরো ফ্রাঙ্ক),
				'one' => q(কম্বোরো ফ্রাঙ্ক),
				'other' => q(কম্বোরো ফ্রাঙ্ক),
			},
		},
		'KPW' => {
			display_name => {
				'currency' => q(নাইজেরিয়ান পাউন্ড),
				'one' => q(নাইজেরিয়ান পাউন্ড),
				'other' => q(নাইজেরিয়ান পাউন্ড),
			},
		},
		'KRW' => {
			symbol => '₩',
			display_name => {
				'currency' => q(দক্ষিণ কোরিয়ান ওন),
				'one' => q(দক্ষিণ কোরিয়ান ওন),
				'other' => q(দক্ষিণ কোরিয়ান ওন),
			},
		},
		'KWD' => {
			display_name => {
				'currency' => q(কুয়েতি দিনার),
				'one' => q(কুয়েতি দিনার),
				'other' => q(কুয়েতি দিনার),
			},
		},
		'KYD' => {
			display_name => {
				'currency' => q(কেম্যান দ্বীপপুঞ্জের ডলার),
				'one' => q(কেম্যান দ্বীপপুঞ্জের ডলার),
				'other' => q(কেম্যান দ্বীপপুঞ্জের ডলার),
			},
		},
		'KZT' => {
			display_name => {
				'currency' => q(কাজাক্সটান টেঙ্গে),
				'one' => q(কাজাক্সটান টেঙ্গে),
				'other' => q(কাজাক্সটান টেঙ্গে),
			},
		},
		'LAK' => {
			display_name => {
				'currency' => q(লেউশান কিপ),
				'one' => q(লেউশান কিপ),
				'other' => q(লেউশান কিপ),
			},
		},
		'LBP' => {
			display_name => {
				'currency' => q(লেবানিজ পাউন্ড),
				'one' => q(লেবানিজ পাউন্ড),
				'other' => q(লেবানিজ পাউন্ড),
			},
		},
		'LKR' => {
			display_name => {
				'currency' => q(শ্রীলঙ্কান রুপি),
				'one' => q(শ্রীলঙ্কান রুপি),
				'other' => q(শ্রীলঙ্কান রুপি),
			},
		},
		'LRD' => {
			display_name => {
				'currency' => q(লাইবেরিয়ান ডলার),
				'one' => q(লাইবেরিয়ান ডলার),
				'other' => q(লাইবেরিয়ান ডলার),
			},
		},
		'LSL' => {
			display_name => {
				'currency' => q(লেসুটু লোটি),
			},
		},
		'LTL' => {
			display_name => {
				'currency' => q(লিথুইনিয়ান লিটা),
				'one' => q(লিথুইনিয়ান লিটা),
				'other' => q(লিথুইনিয়ান লিটা),
			},
		},
		'LTT' => {
			display_name => {
				'currency' => q(লিথুইনিয়ান টালোন্যাস),
			},
		},
		'LUC' => {
			display_name => {
				'currency' => q(লুক্সেমবার্গ রুপান্তযোগ্য ফ্রাঙ্ক),
			},
		},
		'LUF' => {
			display_name => {
				'currency' => q(লুক্সেমবার্গ ফ্রাঙ্ক),
			},
		},
		'LUL' => {
			display_name => {
				'currency' => q(লুক্সেমবার্গ ফাইনেনশিয়াল ফ্রাঙ্ক),
			},
		},
		'LVL' => {
			display_name => {
				'currency' => q(ল্যাটভিয়ান ল্যাট্‌স),
				'one' => q(ল্যাটভিয়ান ল্যাট্‌স),
				'other' => q(ল্যাটভিয়ান ল্যাট্‌স),
			},
		},
		'LVR' => {
			display_name => {
				'currency' => q(ল্যাটভিয়ান রুবল),
			},
		},
		'LYD' => {
			display_name => {
				'currency' => q(লিবিয়ান ডলার),
				'one' => q(লিবিয়ান ডলার),
				'other' => q(লিবিয়ান ডলার),
			},
		},
		'MAD' => {
			display_name => {
				'currency' => q(মোরোক্কান দিরহাম),
				'one' => q(মোরোক্কান দিরহাম),
				'other' => q(মোরোক্কান দিরহাম),
			},
		},
		'MAF' => {
			display_name => {
				'currency' => q(মোরোক্কান ফ্রাঙ্ক),
			},
		},
		'MDL' => {
			display_name => {
				'currency' => q(মোল্ডোভান লেয়ু),
				'one' => q(মোল্ডোভান লেয়ু),
				'other' => q(মোল্ডোভান লেয়ু),
			},
		},
		'MGA' => {
			display_name => {
				'currency' => q(মাদাগাস্কার আরিয়ারি),
				'one' => q(মাদাগাস্কার আরিয়ারি),
				'other' => q(মাদাগাস্কার আরিয়ারি),
			},
		},
		'MGF' => {
			display_name => {
				'currency' => q(মাদাগাস্কার ফ্রাঙ্ক),
			},
		},
		'MKD' => {
			display_name => {
				'currency' => q(ম্যাসেডোনিয়ান দিনার),
				'one' => q(ম্যাসেডোনিয়ান দিনার),
				'other' => q(ম্যাসেডোনিয়ান দিনার),
			},
		},
		'MLF' => {
			display_name => {
				'currency' => q(মালি ফ্রাঙ্ক),
			},
		},
		'MMK' => {
			display_name => {
				'currency' => q(মায়ানমার কিয়াত),
				'one' => q(মায়ানমার কিয়াত),
				'other' => q(মায়ানমার কিয়াত),
			},
		},
		'MNT' => {
			display_name => {
				'currency' => q(মঙ্গোলিয়ান তুগরিক),
				'one' => q(মঙ্গোলিয়ান তুগরিক),
				'other' => q(মঙ্গোলিয়ান তুগরিক),
			},
		},
		'MOP' => {
			display_name => {
				'currency' => q(ম্যাক্যাও পাটাকা),
				'one' => q(ম্যাক্যাও পাটাকা),
				'other' => q(ম্যাক্যাও পাটাকা),
			},
		},
		'MRO' => {
			display_name => {
				'currency' => q(মৌরিতানিয়ান ওউগুইয়া),
				'one' => q(মৌরিতানিয়ান ওউগুইয়া),
				'other' => q(মৌরিতানিয়ান ওউগুইয়া),
			},
		},
		'MTL' => {
			display_name => {
				'currency' => q(মাল্টা লিরা),
			},
		},
		'MTP' => {
			display_name => {
				'currency' => q(মাল্টা পাউন্ড),
			},
		},
		'MUR' => {
			display_name => {
				'currency' => q(মৌরিতানিয়ান রুপি),
				'one' => q(মৌরিতানিয়ান রুপি),
				'other' => q(মৌরিতানিয়ান রুপি),
			},
		},
		'MVR' => {
			display_name => {
				'currency' => q(মালদিভিয়ান রুফিয়া),
				'one' => q(মালদিভিয়ান রুফিয়া),
				'other' => q(মালদিভিয়ান রুফিয়া),
			},
		},
		'MWK' => {
			display_name => {
				'currency' => q(মালাউইয়ান কওয়াচ),
				'one' => q(মালাউইয়ান কওয়াচ),
				'other' => q(মালাউইয়ান কওয়াচ),
			},
		},
		'MXN' => {
			symbol => 'MX$',
			display_name => {
				'currency' => q(ম্যাক্সিকান পেসো),
				'one' => q(ম্যাক্সিকান পেসো),
				'other' => q(ম্যাক্সিকান পেসো),
			},
		},
		'MXP' => {
			display_name => {
				'currency' => q(ম্যাক্সিকান সিলভার পেসো \(১৮৬১–১৯৯২\)),
			},
		},
		'MXV' => {
			display_name => {
				'currency' => q(মেক্সিকান উনিদাদ দি ইনভার্সান \(UDI\)),
			},
		},
		'MYR' => {
			display_name => {
				'currency' => q(মালয়েশিয়ান রিঙ্গিৎ),
				'one' => q(মালয়েশিয়ান রিঙ্গিৎ),
				'other' => q(মালয়েশিয়ান রিঙ্গিৎ),
			},
		},
		'MZE' => {
			display_name => {
				'currency' => q(মোজাম্বিক এসকুডো),
			},
		},
		'MZM' => {
			display_name => {
				'currency' => q(প্রাচীন মোজাম্বিক মেটিকেল),
			},
		},
		'MZN' => {
			display_name => {
				'currency' => q(মোজাম্বিক মেটিকেল),
				'one' => q(মোজাম্বিক মেটিকেল),
				'other' => q(মোজাম্বিক মেটিকেল),
			},
		},
		'NAD' => {
			display_name => {
				'currency' => q(নামিবিয়া ডলার),
				'one' => q(নামিবিয়া ডলার),
				'other' => q(নামিবিয়া ডলার),
			},
		},
		'NGN' => {
			display_name => {
				'currency' => q(নাইজেরিয়ান নায়রা),
				'one' => q(নাইজেরিয়ান নায়রা),
				'other' => q(নাইজেরিয়ান নায়রা),
			},
		},
		'NIC' => {
			display_name => {
				'currency' => q(নিকারাগুয়ান কর্ডোবা \(১৯৮৮–১৯৯১\)),
			},
		},
		'NIO' => {
			display_name => {
				'currency' => q(নিকারাগুয়ান কর্ডোবা),
				'one' => q(নিকারাগুয়ান কর্ডোবা),
				'other' => q(নিকারাগুয়ান কর্ডোবা),
			},
		},
		'NLG' => {
			display_name => {
				'currency' => q(নেদারল্যান্ড গুল্ডের),
			},
		},
		'NOK' => {
			display_name => {
				'currency' => q(নরওয়ে ক্রৌন),
				'one' => q(নরওয়ে ক্রৌন),
				'other' => q(নরওয়ে ক্রৌন),
			},
		},
		'NPR' => {
			display_name => {
				'currency' => q(নেপালি রুপি),
				'one' => q(নেপালি রুপি),
				'other' => q(নেপালি রুপি),
			},
		},
		'NZD' => {
			symbol => 'NZ$',
			display_name => {
				'currency' => q(নিউজিল্যান্ড ডলার),
				'one' => q(নিউজিল্যান্ড ডলার),
				'other' => q(নিউজিল্যান্ড ডলার),
			},
		},
		'OMR' => {
			display_name => {
				'currency' => q(ওমানি রিয়াল),
				'one' => q(ওমানি রিয়াল),
				'other' => q(ওমানি রিয়াল),
			},
		},
		'PAB' => {
			display_name => {
				'currency' => q(পানামা বেলবোয়া),
				'one' => q(পানামা বেলবোয়া),
				'other' => q(পানামা বেলবোয়া),
			},
		},
		'PEI' => {
			display_name => {
				'currency' => q(পেরুভিয়ান ইন্তি),
			},
		},
		'PEN' => {
			display_name => {
				'currency' => q(পেরুভিয়ান সোল নুয়েভো),
				'one' => q(পেরুভিয়ান সোল নুয়েভো),
				'other' => q(পেরুভিয়ান সোল নুয়েভো),
			},
		},
		'PES' => {
			display_name => {
				'currency' => q(পেরুভিয়ান সোল),
			},
		},
		'PGK' => {
			display_name => {
				'currency' => q(পপুয়ানিউগিনি কিনা),
				'one' => q(পপুয়ানিউগিনি কিনা),
				'other' => q(পপুয়ানিউগিনি কিনা),
			},
		},
		'PHP' => {
			display_name => {
				'currency' => q(ফিলিপাইন পেসো),
				'one' => q(ফিলিপাইন পেসো),
				'other' => q(ফিলিপাইন পেসো),
			},
		},
		'PKR' => {
			display_name => {
				'currency' => q(পাকিস্তানি রুপি),
				'one' => q(পাকিস্তানি রুপি),
				'other' => q(পাকিস্তানি রুপি),
			},
		},
		'PLN' => {
			display_name => {
				'currency' => q(পোলিশ জ্লোটি),
				'one' => q(পোলিশ জ্লোটি),
				'other' => q(পোলিশ জ্লোটি),
			},
		},
		'PLZ' => {
			display_name => {
				'currency' => q(পোলিশ জ্লোটি \(১৯৫০–১৯৯৫\)),
			},
		},
		'PTE' => {
			display_name => {
				'currency' => q(পর্তুগিজ এসকুডো),
			},
		},
		'PYG' => {
			display_name => {
				'currency' => q(প্যারগুয়ান),
				'one' => q(প্যারগুয়ান),
				'other' => q(প্যারগুয়ান),
			},
		},
		'QAR' => {
			display_name => {
				'currency' => q(কাতার রিয়্যাল),
				'one' => q(কাতার রিয়্যাল),
				'other' => q(কাতার রিয়্যাল),
			},
		},
		'RHD' => {
			display_name => {
				'currency' => q(রোডেশিয়ান ডলার),
			},
		},
		'ROL' => {
			display_name => {
				'currency' => q(প্রাচীন রুমানিয়া লেয়ু),
			},
		},
		'RON' => {
			display_name => {
				'currency' => q(রুমানিয়া লেয়ু),
				'one' => q(রুমানিয়া লেয়ু),
				'other' => q(রুমানিয়া লেয়ু),
			},
		},
		'RSD' => {
			display_name => {
				'currency' => q(সারবিয়ান দিনার),
				'one' => q(সারবিয়ান দিনার),
				'other' => q(সারবিয়ান দিনার),
			},
		},
		'RUB' => {
			display_name => {
				'currency' => q(রাশিয়ান রুবেল),
				'one' => q(রাশিয়ান রুবেল),
				'other' => q(রাশিয়ান রুবেল),
			},
		},
		'RUR' => {
			display_name => {
				'currency' => q(রাশিয়ান রুবল \(১৯৯১–১৯৯৮\)),
			},
		},
		'RWF' => {
			display_name => {
				'currency' => q(রুয়ান্ডান ফ্রাঙ্ক),
				'one' => q(রুয়ান্ডান ফ্রাঙ্ক),
				'other' => q(রুয়ান্ডান ফ্রাঙ্ক),
			},
		},
		'SAR' => {
			display_name => {
				'currency' => q(সৌদি রিয়্যাল),
				'one' => q(সৌদি রিয়্যাল),
				'other' => q(সৌদি রিয়্যাল),
			},
		},
		'SBD' => {
			display_name => {
				'currency' => q(সলোমন দ্বীপপুঞ্জ ডলার),
				'one' => q(সলোমন দ্বীপপুঞ্জ ডলার),
				'other' => q(সলোমন দ্বীপপুঞ্জ ডলার),
			},
		},
		'SCR' => {
			display_name => {
				'currency' => q(সেয়চেল্লোইস রুপি),
				'one' => q(সেয়চেল্লোইস রুপি),
				'other' => q(সেয়চেল্লোইস রুপি),
			},
		},
		'SDD' => {
			display_name => {
				'currency' => q(প্রাচীন সুদানি দিনার),
			},
		},
		'SDG' => {
			display_name => {
				'currency' => q(সুদানি পাউন্ড),
				'one' => q(সুদানি পাউন্ড),
				'other' => q(সুদানি পাউন্ড),
			},
		},
		'SDP' => {
			display_name => {
				'currency' => q(প্রাচীন সুদানি পাউন্ড),
			},
		},
		'SEK' => {
			display_name => {
				'currency' => q(সুইডিশ ক্রোনা),
				'one' => q(সুইডিশ ক্রোনা),
				'other' => q(সুইডিশ ক্রোনা),
			},
		},
		'SGD' => {
			display_name => {
				'currency' => q(সিঙ্গাপুর ডলার),
				'one' => q(সিঙ্গাপুর ডলার),
				'other' => q(সিঙ্গাপুর ডলার),
			},
		},
		'SHP' => {
			display_name => {
				'currency' => q(সেন্ট হেলেনা পাউন্ড),
				'one' => q(সেন্ট হেলেনা পাউন্ড),
				'other' => q(সেন্ট হেলেনা পাউন্ড),
			},
		},
		'SIT' => {
			display_name => {
				'currency' => q(স্লোভানিয়া টোলার),
			},
		},
		'SKK' => {
			display_name => {
				'currency' => q(স্লোভাক কোরুনা),
			},
		},
		'SLL' => {
			display_name => {
				'currency' => q(সিয়েরালিয়ন লিয়ন),
				'one' => q(সিয়েরালিয়ন লিয়ন),
				'other' => q(সিয়েরালিয়ন লিয়ন),
			},
		},
		'SOS' => {
			display_name => {
				'currency' => q(সোমালি শিলিং),
				'one' => q(সোমালি শিলিং),
				'other' => q(সোমালি শিলিং),
			},
		},
		'SRD' => {
			display_name => {
				'currency' => q(সুরিনাম ডলার),
				'one' => q(সুরিনাম ডলার),
				'other' => q(সুরিনাম ডলার),
			},
		},
		'SRG' => {
			display_name => {
				'currency' => q(সুরিনাম গিল্ডার),
			},
		},
		'SSP' => {
			display_name => {
				'currency' => q(দক্ষিণ সুদানি পাউন্ড),
				'one' => q(দক্ষিণ সুদানি পাউন্ড),
				'other' => q(দক্ষিণ সুদানি পাউন্ড),
			},
		},
		'STD' => {
			display_name => {
				'currency' => q(সাও টোমে এবং প্রিন্সিপে ডোবরা),
				'one' => q(সাও টোমে এবং প্রিন্সিপে ডোবরা),
				'other' => q(সাও টোমে এবং প্রিন্সিপে ডোবরা),
			},
		},
		'SUR' => {
			display_name => {
				'currency' => q(সোভিয়েত রুবল),
			},
		},
		'SVC' => {
			display_name => {
				'currency' => q(এল স্যালভোডোর কোলোন),
			},
		},
		'SYP' => {
			display_name => {
				'currency' => q(সিরিয়ান পাউন্ড),
				'one' => q(সিরিয়ান পাউন্ড),
				'other' => q(সিরিয়ান পাউন্ড),
			},
		},
		'SZL' => {
			display_name => {
				'currency' => q(সোয়াজিল্যান্ড লিলাঙ্গেনি),
				'one' => q(সোয়াজিল্যান্ড লিলাঙ্গেনি),
				'other' => q(সোয়াজিল্যান্ড লিলাঙ্গেনি),
			},
		},
		'THB' => {
			symbol => '฿',
			display_name => {
				'currency' => q(থাই বাত),
				'one' => q(থাই বাত),
				'other' => q(থাই বাত),
			},
		},
		'TJR' => {
			display_name => {
				'currency' => q(তাজিকিস্তান রুবল),
			},
		},
		'TJS' => {
			display_name => {
				'currency' => q(তাজিকিস্তান সোমোনি),
				'one' => q(তাজিকিস্তান সোমোনি),
				'other' => q(তাজিকিস্তান সোমোনি),
			},
		},
		'TMM' => {
			display_name => {
				'currency' => q(তুর্কমেনিস্টানি মানাত),
			},
		},
		'TMT' => {
			display_name => {
				'currency' => q(তুর্কমেনিস্তান নতুন মানত),
				'one' => q(তুর্কমেনিস্তান নতুন মানত),
				'other' => q(তুর্কমেনিস্তান নতুন মানত),
			},
		},
		'TND' => {
			display_name => {
				'currency' => q(তিউনেশিয়ান দিনার),
				'one' => q(তিউনেশিয়ান দিনার),
				'other' => q(তিউনেশিয়ান দিনার),
			},
		},
		'TOP' => {
			display_name => {
				'currency' => q(টোঙ্গা পা’আঙ্গা),
				'one' => q(টোঙ্গা পা’আঙ্গা),
				'other' => q(টোঙ্গা পা’আঙ্গা),
			},
		},
		'TPE' => {
			display_name => {
				'currency' => q(তিমুর এসকুডো),
			},
		},
		'TRL' => {
			display_name => {
				'currency' => q(প্রাচীন তুর্কি লিরা),
			},
		},
		'TRY' => {
			display_name => {
				'currency' => q(তুর্কি লিরা),
				'one' => q(তুর্কি লিরা),
				'other' => q(তুর্কি লিরা),
			},
		},
		'TTD' => {
			display_name => {
				'currency' => q(ত্রিনিদাদ এবং টোবাগো ডলার),
				'one' => q(ত্রিনিদাদ এবং টোবাগো ডলার),
				'other' => q(ত্রিনিদাদ এবং টোবাগো ডলার),
			},
		},
		'TWD' => {
			symbol => 'NT$',
			display_name => {
				'currency' => q(নূতন তাইওয়ান ক্যারাবিয়ান ডলার),
				'one' => q(নূতন তাইওয়ান ক্যারাবিয়ান ডলার),
				'other' => q(নূতন তাইওয়ান ক্যারাবিয়ান ডলার),
			},
		},
		'TZS' => {
			display_name => {
				'currency' => q(তাঞ্জনিয়া শিলিং),
				'one' => q(তাঞ্জনিয়া শিলিং),
				'other' => q(তাঞ্জনিয়া শিলিং),
			},
		},
		'UAH' => {
			display_name => {
				'currency' => q(ইউক্রেইন হৃভনিয়া),
				'one' => q(ইউক্রেইন হৃভনিয়া),
				'other' => q(ইউক্রেইন হৃভনিয়া),
			},
		},
		'UAK' => {
			display_name => {
				'currency' => q(ইউক্রেইন কার্বোভ্যান্টস),
			},
		},
		'UGS' => {
			display_name => {
				'currency' => q(উগান্ডান শিলিং \(১৯৬৬–১৯৮৭\)),
			},
		},
		'UGX' => {
			display_name => {
				'currency' => q(উগান্ডান শিলিং),
				'one' => q(উগান্ডান শিলিং),
				'other' => q(উগান্ডান শিলিং),
			},
		},
		'USD' => {
			symbol => 'US$',
			display_name => {
				'currency' => q(মার্কিন ডলার),
				'one' => q(মার্কিন ডলার),
				'other' => q(মার্কিন ডলার),
			},
		},
		'USN' => {
			display_name => {
				'currency' => q(মার্কিন ডলার \(পরবর্তী দিন\)),
			},
		},
		'USS' => {
			display_name => {
				'currency' => q(মার্কিন ডলার \(একই দিন\)),
			},
		},
		'UYI' => {
			display_name => {
				'currency' => q(উরুগুয়ায়ান পেসো এন উনিদাদেস ইনডেক্সেডাস),
			},
		},
		'UYP' => {
			display_name => {
				'currency' => q(উরুগুয়ে পেসো \(১৯৭৫–১৯৯৩\)),
			},
		},
		'UYU' => {
			display_name => {
				'currency' => q(উরুগুয়ে পেসো),
				'one' => q(উরুগুয়ে পেসো উরুগুয়েও),
				'other' => q(উরুগুয়ে পেসো উরুগুয়েও),
			},
		},
		'UZS' => {
			display_name => {
				'currency' => q(উজবেকিস্তানি সোম),
				'one' => q(উজবেকিস্তানি সোম),
				'other' => q(উজবেকিস্তানি সোম),
			},
		},
		'VEB' => {
			display_name => {
				'currency' => q(ভেনিজুয়েলান বলিভার \(১৮৭১–২০০৮\)),
			},
		},
		'VEF' => {
			display_name => {
				'currency' => q(ভেনিজুয়েলীয় বলিভার),
				'one' => q(ভেনিজুয়েলীয় বলিভার),
				'other' => q(ভেনিজুয়েলীয় বলিভার),
			},
		},
		'VND' => {
			symbol => '₫',
			display_name => {
				'currency' => q(ভিয়েতনামি ডঙ্গ),
				'one' => q(ভিয়েতনামি ডঙ্গ),
				'other' => q(ভিয়েতনামি ডঙ্গ),
			},
		},
		'VUV' => {
			display_name => {
				'currency' => q(ভানুয়াতু ভাতু),
				'one' => q(ভানুয়াতু ভাতু),
				'other' => q(ভানুয়াতু ভাতু),
			},
		},
		'WST' => {
			display_name => {
				'currency' => q(পশ্চিমাঞ্চলীয় সামোয়ান টালা),
				'one' => q(পশ্চিমাঞ্চলীয় সামোয়ান টালা),
				'other' => q(পশ্চিমাঞ্চলীয় সামোয়ান টালা),
			},
		},
		'XAF' => {
			symbol => 'FCFA',
			display_name => {
				'currency' => q(সিএফএ ফ্র্যাঙ্ক বিইএসি),
				'one' => q(সিএফএ ফ্র্যাঙ্ক বিইএসি),
				'other' => q(সিএফএ ফ্র্যাঙ্ক বিইএসি),
			},
		},
		'XAG' => {
			display_name => {
				'currency' => q(সিলভার),
			},
		},
		'XAU' => {
			display_name => {
				'currency' => q(গোল্ড),
			},
		},
		'XBB' => {
			display_name => {
				'currency' => q(ইউরোপীয় আর্থিক একক),
			},
		},
		'XCD' => {
			symbol => 'EC$',
			display_name => {
				'currency' => q(পূর্ব ক্যারাবিয়ান ডলার),
				'one' => q(পূর্ব ক্যারাবিয়ান ডলার),
				'other' => q(পূর্ব ক্যারাবিয়ান ডলার),
			},
		},
		'XEU' => {
			display_name => {
				'currency' => q(ইউরোপীয় মুদ্রা একক),
			},
		},
		'XFO' => {
			display_name => {
				'currency' => q(ফরাসি গোল্ড ফ্রাঙ্ক),
			},
		},
		'XFU' => {
			display_name => {
				'currency' => q(ফরাসি ইউআইসি - ফ্রাঙ্ক),
			},
		},
		'XOF' => {
			symbol => 'CFA',
			display_name => {
				'currency' => q(সিএফএ ফ্র্যাঙ্ক বিসিইএও),
				'one' => q(সিএফএ ফ্র্যাঙ্ক বিসিইএও),
				'other' => q(সিএফএ ফ্র্যাঙ্ক বিসিইএও),
			},
		},
		'XPD' => {
			display_name => {
				'currency' => q(প্যালেডিয়াম),
			},
		},
		'XPF' => {
			symbol => 'CFPF',
			display_name => {
				'currency' => q(সিএফপি ফ্র্যাঙ্ক),
				'one' => q(সিএফপি ফ্র্যাঙ্ক),
				'other' => q(সিএফপি ফ্র্যাঙ্ক),
			},
		},
		'XPT' => {
			display_name => {
				'currency' => q(প্লাটিনাম),
			},
		},
		'XXX' => {
			display_name => {
				'currency' => q(অজানা বা ভুল মুদ্রা),
				'one' => q(অজানা বা ভুল মুদ্রা),
				'other' => q(অজানা বা ভুল মুদ্রা),
			},
		},
		'YDD' => {
			display_name => {
				'currency' => q(ইয়েমেনি দিনার),
			},
		},
		'YER' => {
			display_name => {
				'currency' => q(ইয়েমেনি রিয়াল),
				'one' => q(ইয়েমেনি রিয়াল),
				'other' => q(ইয়েমেনি রিয়াল),
			},
		},
		'YUD' => {
			display_name => {
				'currency' => q(যুগোশ্লাভিয় হার্ড দিনার),
			},
		},
		'YUM' => {
			display_name => {
				'currency' => q(যুগোশ্লাভিয় নোভি দিনার),
			},
		},
		'YUN' => {
			display_name => {
				'currency' => q(যুগোশ্লাভিয় রুপান্তরযোগ্য দিনার),
			},
		},
		'ZAL' => {
			display_name => {
				'currency' => q(দক্ষিণ আফ্রিকান র‌্যান্ড),
			},
		},
		'ZAR' => {
			display_name => {
				'currency' => q(দক্ষিণ আফ্রিকান রেন্ড),
				'one' => q(দক্ষিণ আফ্রিকান রেন্ড),
				'other' => q(দক্ষিণ আফ্রিকান রেন্ড),
			},
		},
		'ZMK' => {
			display_name => {
				'currency' => q(জাম্বিয়ান কওয়াচা \(১৯৬৮–২০১২\)),
			},
		},
		'ZMW' => {
			display_name => {
				'currency' => q(জাম্বিয়ান কওয়াচা),
				'one' => q(জাম্বিয়ান কওয়াচা),
				'other' => q(জাম্বিয়ান কওয়াচা),
			},
		},
		'ZRN' => {
			display_name => {
				'currency' => q(জাইরিয়ান নিউ জাইরে),
			},
		},
		'ZRZ' => {
			display_name => {
				'currency' => q(জাইরিয়ান জাইরে),
			},
		},
		'ZWD' => {
			display_name => {
				'currency' => q(জিম্বাবুয়ে ডলার \(১৯৮০–২০০৮\)),
			},
		},
		'ZWL' => {
			display_name => {
				'currency' => q(জিম্বাবুয়ে ডলার \(২০০৯\)),
			},
		},
		'ZWR' => {
			display_name => {
				'currency' => q(জিম্বাবুয়ে ডলার \(২০০৮\)),
			},
		},
	} },
);


has 'calendar_months' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'জানুয়ারী',
							'ফেব্রুয়ারী',
							'মার্চ',
							'এপ্রিল',
							'মে',
							'জুন',
							'জুলাই',
							'আগস্ট',
							'সেপ্টেম্বর',
							'অক্টোবর',
							'নভেম্বর',
							'ডিসেম্বর'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'জা',
							'ফে',
							'মা',
							'এ',
							'মে',
							'জুন',
							'জু',
							'আ',
							'সে',
							'অ',
							'ন',
							'ডি'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'জানুয়ারী',
							'ফেব্রুয়ারী',
							'মার্চ',
							'এপ্রিল',
							'মে',
							'জুন',
							'জুলাই',
							'আগস্ট',
							'সেপ্টেম্বর',
							'অক্টোবর',
							'নভেম্বর',
							'ডিসেম্বর'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'জানুয়ারী',
							'ফেব্রুয়ারী',
							'মার্চ',
							'এপ্রিল',
							'মে',
							'জুন',
							'জুলাই',
							'আগস্ট',
							'সেপ্টেম্বর',
							'অক্টোবর',
							'নভেম্বর',
							'ডিসেম্বর'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'জা',
							'ফে',
							'মা',
							'এ',
							'মে',
							'জুন',
							'জু',
							'আ',
							'সে',
							'অ',
							'ন',
							'ডি'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'জানুয়ারী',
							'ফেব্রুয়ারী',
							'মার্চ',
							'এপ্রিল',
							'মে',
							'জুন',
							'জুলাই',
							'আগস্ট',
							'সেপ্টেম্বর',
							'অক্টোবর',
							'নভেম্বর',
							'ডিসেম্বর'
						],
						leap => [
							
						],
					},
				},
			},
			'indian' => {
				'format' => {
					wide => {
						nonleap => [
							'চৈত্র',
							'বৈশাখ',
							'জৈষ্ঠ্য',
							'আষাঢ়',
							'শ্রাবণ',
							'ভাদ্র',
							'আশ্বিন',
							'কার্তিক',
							'অগ্রহায়ণ',
							'পৌষ',
							'মাঘ',
							'ফাল্গুন'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					narrow => {
						nonleap => [
							'১',
							'২',
							'৩',
							'৪',
							'৫',
							'৬',
							'৭',
							'৮',
							'৯',
							'১০',
							'১১',
							'১২'
						],
						leap => [
							
						],
					},
				},
			},
			'islamic' => {
				'format' => {
					wide => {
						nonleap => [
							'মহররম',
							'সফর',
							'রবিউল আউয়াল',
							'রবিউস সানি',
							'জমাদিউল আউয়াল',
							'জমাদিউস সানি',
							'রজব',
							'শা\'বান',
							'রমজান',
							'শাওয়াল',
							'জ্বিলকদ',
							'জ্বিলহজ্জ'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					narrow => {
						nonleap => [
							'১',
							'২',
							'৩',
							'৪',
							'৫',
							'৬',
							'৭',
							'৮',
							'৯',
							'১০',
							'১১',
							'১২'
						],
						leap => [
							
						],
					},
				},
			},
	} },
);

has 'calendar_days' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {
						mon => 'সোম',
						tue => 'মঙ্গল',
						wed => 'বুধ',
						thu => 'বৃহস্পতি',
						fri => 'শুক্র',
						sat => 'শনি',
						sun => 'রবি'
					},
					narrow => {
						mon => 'সো',
						tue => 'ম',
						wed => 'বু',
						thu => 'বৃ',
						fri => 'শু',
						sat => 'শ',
						sun => 'র'
					},
					short => {
						mon => 'সোঃ',
						tue => 'মঃ',
						wed => 'বুঃ',
						thu => 'বৃঃ',
						fri => 'শুঃ',
						sat => 'শোঃ',
						sun => 'রঃ'
					},
					wide => {
						mon => 'সোমবার',
						tue => 'মঙ্গলবার',
						wed => 'বুধবার',
						thu => 'বৃহষ্পতিবার',
						fri => 'শুক্রবার',
						sat => 'শনিবার',
						sun => 'রবিবার'
					},
				},
				'stand-alone' => {
					abbreviated => {
						mon => 'সোম',
						tue => 'মঙ্গল',
						wed => 'বুধ',
						thu => 'বৃহস্পতি',
						fri => 'শুক্র',
						sat => 'শনি',
						sun => 'রবি'
					},
					narrow => {
						mon => 'সো',
						tue => 'ম',
						wed => 'বু',
						thu => 'বৃ',
						fri => 'শু',
						sat => 'শ',
						sun => 'র'
					},
					short => {
						mon => 'সোঃ',
						tue => 'মঃ',
						wed => 'বুঃ',
						thu => 'বৃঃ',
						fri => 'শুঃ',
						sat => 'শোঃ',
						sun => 'রঃ'
					},
					wide => {
						mon => 'সোমবার',
						tue => 'মঙ্গলবার',
						wed => 'বুধবার',
						thu => 'বৃহষ্পতিবার',
						fri => 'শুক্রবার',
						sat => 'শনিবার',
						sun => 'রবিবার'
					},
				},
			},
	} },
);

has 'calendar_quarters' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {0 => 'চতুর্থাংশ ১',
						1 => 'চতুর্থাংশ ২',
						2 => 'চতুর্থাংশ ৩',
						3 => 'চতুর্থাংশ ৪'
					},
					narrow => {0 => '১',
						1 => '২',
						2 => '৩',
						3 => '৪'
					},
					wide => {0 => 'প্রথম চতুর্থাংশ',
						1 => 'দ্বিতীয় চতুর্থাংশ',
						2 => 'তৃতীয় চতুর্থাংশ',
						3 => 'চতুর্থ চতুর্থাংশ'
					},
				},
				'stand-alone' => {
					abbreviated => {0 => 'চতুর্থাংশ ১',
						1 => 'চতুর্থাংশ ২',
						2 => 'চতুর্থাংশ ৩',
						3 => 'চতুর্থাংশ ৪'
					},
					narrow => {0 => '১',
						1 => '২',
						2 => '৩',
						3 => '৪'
					},
					wide => {0 => 'প্রথম চতুর্থাংশ',
						1 => 'দ্বিতীয় চতুর্থাংশ',
						2 => 'তৃতীয় চতুর্থাংশ',
						3 => 'চতুর্থ চতুর্থাংশ'
					},
				},
			},
	} },
);

has 'day_periods' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			'format' => {
				'wide' => {
					'pm' => q{অপরাহ্ণ},
					'am' => q{পূর্বাহ্ণ},
				},
				'narrow' => {
					'am' => q{পূর্বাহ্ণ},
					'pm' => q{অপরাহ্ণ},
				},
			},
		},
	} },
);

has 'eras' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
		},
		'gregorian' => {
			abbreviated => {
				'0' => 'খ্রিস্টপূর্ব',
				'1' => 'খৃষ্টাব্দ'
			},
		},
		'indian' => {
			abbreviated => {
				'0' => 'সাল'
			},
		},
		'islamic' => {
			abbreviated => {
				'0' => 'যুগ'
			},
		},
	} },
);

has 'date_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			'full' => q{EEEE, d MMMM, y G},
			'long' => q{d MMMM, y G},
			'medium' => q{d MMM, y G},
			'short' => q{d/M/y GGGGG},
		},
		'gregorian' => {
			'full' => q{EEEE, d MMMM, y},
			'long' => q{d MMMM, y},
			'medium' => q{d MMM, y},
			'short' => q{d/M/yy},
		},
		'indian' => {
		},
		'islamic' => {
		},
	} },
);

has 'time_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
		},
		'gregorian' => {
			'full' => q{h:mm:ss a zzzz},
			'long' => q{h:mm:ss a z},
			'medium' => q{h:mm:ss a},
			'short' => q{h:mm a},
		},
		'indian' => {
		},
		'islamic' => {
		},
	} },
);

has 'datetime_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			'full' => q{{1} {0}},
			'long' => q{{1} {0}},
			'medium' => q{{1} {0}},
			'short' => q{{1} {0}},
		},
		'gregorian' => {
			'full' => q{{1} {0}},
			'long' => q{{1} {0}},
			'medium' => q{{1} {0}},
			'short' => q{{1} {0}},
		},
		'indian' => {
		},
		'islamic' => {
		},
	} },
);

has 'datetime_formats_available_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			Ed => q{d E},
			Gy => q{y G},
			GyMMM => q{MMM y G},
			GyMMMEd => q{E, d MMM, y G},
			GyMMMd => q{d MMM, y G},
			H => q{HH},
			Hm => q{HH:mm},
			Hms => q{HH:mm:ss},
			M => q{L},
			MEd => q{E, d-M},
			MMM => q{LLL},
			MMMEd => q{E d MMM},
			MMMMEd => q{E d MMMM},
			MMMMd => q{d MMMM},
			MMMd => q{d MMM},
			MMdd => q{dd-MM},
			Md => q{d/M},
			d => q{d},
			h => q{h a},
			hm => q{h:mm a},
			hms => q{h:mm:ss a},
			ms => q{mm:ss},
			y => q{y G},
			yyyy => q{y G},
			yyyyM => q{M/y G},
			yyyyMEd => q{E, d/M/y G},
			yyyyMM => q{MM-y G},
			yyyyMMM => q{MMM y G},
			yyyyMMMEd => q{E, d MMM, y G},
			yyyyMMMM => q{MMMM y G},
			yyyyMMMd => q{d MMM, y G},
			yyyyMd => q{d/M/y G},
			yyyyQQQ => q{QQQ y G},
			yyyyQQQQ => q{QQQQ y G},
		},
		'gregorian' => {
			EHm => q{E HH:mm},
			EHms => q{E HH:mm:ss},
			Ed => q{d E},
			Ehm => q{E h:mm a},
			Ehms => q{E h:mm:ss a},
			Gy => q{y G},
			GyMMM => q{MMM y G},
			GyMMMEd => q{E, d MMM, y G},
			GyMMMd => q{d MMM, y G},
			H => q{HH},
			Hm => q{HH:mm},
			Hms => q{HH:mm:ss},
			M => q{L},
			MEd => q{E, d-M},
			MMM => q{LLL},
			MMMEd => q{E d MMM},
			MMMMEd => q{E d MMMM},
			MMMMd => q{d MMMM},
			MMMd => q{d MMM},
			MMdd => q{dd-MM},
			Md => q{d/M},
			d => q{d},
			h => q{h a},
			hm => q{h:mm a},
			hms => q{h:mm:ss a},
			ms => q{mm:ss},
			y => q{y},
			yM => q{M/y},
			yMEd => q{E, d/M/y},
			yMM => q{MM-y},
			yMMM => q{MMM y},
			yMMMEd => q{E, d MMM, y},
			yMMMM => q{MMMM y},
			yMMMd => q{d MMM, y},
			yMd => q{d/M/y},
			yQQQ => q{QQQ y},
			yQQQQ => q{QQQQ y},
		},
	} },
);

has 'datetime_formats_append_item' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			'Timezone' => '{0} {1}',
		},
	} },
);

has 'datetime_formats_interval' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			H => {
				H => q{HH–HH},
			},
			Hm => {
				H => q{HH:mm–HH:mm},
				m => q{HH:mm–HH:mm},
			},
			Hmv => {
				H => q{HH:mm–HH:mm v},
				m => q{HH:mm–HH:mm v},
			},
			Hv => {
				H => q{HH–HH v},
			},
			M => {
				M => q{M-M},
			},
			MEd => {
				M => q{E, d/M – E, d/M},
				d => q{E, d/M – E, d/M},
			},
			MMM => {
				M => q{LLL-LLL},
			},
			MMMEd => {
				M => q{E, d MMM – E, d MMM},
				d => q{E, d MMM – E, d MMM},
			},
			MMMd => {
				M => q{d MMM – d MMM},
				d => q{d–d MMM},
			},
			Md => {
				M => q{d/M - d/M},
				d => q{d/M - d/M},
			},
			d => {
				d => q{d-d},
			},
			fallback => '{0} – {1}',
			h => {
				a => q{h a – h a},
				h => q{h–h a},
			},
			hm => {
				a => q{h:mm a – h:mm a},
				h => q{h:mm–h:mm a},
				m => q{h:mm–h:mm a},
			},
			hmv => {
				a => q{h:mm a – h:mm a v},
				h => q{h:mm–h:mm a v},
				m => q{h:mm–h:mm a v},
			},
			hv => {
				a => q{h a – h a v},
				h => q{h–h a v},
			},
			y => {
				y => q{y-y G},
			},
			yM => {
				M => q{M/y – M/y G},
				y => q{M/y – M/y G},
			},
			yMEd => {
				M => q{E, d/M/y – E, d/M/y G},
				d => q{E, d/M/y – E, d/M/y G},
				y => q{E, d/M/y – E, d/M/y G},
			},
			yMMM => {
				M => q{MMM–MMM y G},
				y => q{MMM y – MMM y G},
			},
			yMMMEd => {
				M => q{E, d MMM – E, d MMM, y G},
				d => q{E, d MMM – E, d MMM, y G},
				y => q{E, d MMM, y – E, d MMM, y G},
			},
			yMMMM => {
				M => q{MMMM–MMMM y G},
				y => q{MMMM y – MMMM y G},
			},
			yMMMd => {
				M => q{d MMM – d MMM, y G},
				d => q{d–d MMM, y G},
				y => q{d MMM, y – d MMM, y G},
			},
			yMd => {
				M => q{d/M/y – d/M/y G},
				d => q{d/M/y – d/M/y G},
				y => q{d/M/y – d/M/y G},
			},
		},
		'gregorian' => {
			H => {
				H => q{HH–HH},
			},
			Hm => {
				H => q{HH:mm–HH:mm},
				m => q{HH:mm–HH:mm},
			},
			Hmv => {
				H => q{HH:mm–HH:mm v},
				m => q{HH:mm–HH:mm v},
			},
			Hv => {
				H => q{HH–HH v},
			},
			M => {
				M => q{M-M},
			},
			MEd => {
				M => q{E, d/M – E, d/M},
				d => q{E, d/M – E, d/M},
			},
			MMM => {
				M => q{LLL-LLL},
			},
			MMMEd => {
				M => q{E, d MMM – E, d MMM},
				d => q{E, d MMM – E, d MMM},
			},
			MMMd => {
				M => q{d MMM – d MMM},
				d => q{d–d MMM},
			},
			Md => {
				M => q{d/M - d/M},
				d => q{d/M - d/M},
			},
			d => {
				d => q{d-d},
			},
			fallback => '{0} – {1}',
			h => {
				a => q{h a – h a},
				h => q{h–h a},
			},
			hm => {
				a => q{h:mm a – h:mm a},
				h => q{h:mm–h:mm a},
				m => q{h:mm–h:mm a},
			},
			hmv => {
				a => q{h:mm a – h:mm a v},
				h => q{h:mm–h:mm a v},
				m => q{h:mm–h:mm a v},
			},
			hv => {
				a => q{h a – h a v},
				h => q{h–h a v},
			},
			y => {
				y => q{y-y},
			},
			yM => {
				M => q{M/y – M/y},
				y => q{M/y – M/y},
			},
			yMEd => {
				M => q{E, d/M/y – E, d/M/y},
				d => q{E, d/M/y – E, d/M/y},
				y => q{E, d/M/y – E, d/M/y},
			},
			yMMM => {
				M => q{MMM–MMM y},
				y => q{MMM y – MMM y},
			},
			yMMMEd => {
				M => q{E, d MMM – E, d MMM, y},
				d => q{E, d MMM – E, d MMM, y},
				y => q{E, d MMM, y – E, d MMM, y},
			},
			yMMMM => {
				M => q{MMMM–MMMM y},
				y => q{MMMM y – MMMM y},
			},
			yMMMd => {
				M => q{d MMM – d MMM, y},
				d => q{d–d MMM, y},
				y => q{d MMM, y – d MMM, y},
			},
			yMd => {
				M => q{d/M/y – d/M/y},
				d => q{d/M/y – d/M/y},
				y => q{d/M/y – d/M/y},
			},
		},
	} },
);

has 'time_zone_names' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default	=> sub { {
		hourFormat => q(+HH:mm;-HH:mm),
		gmtFormat => q(GMT {0}),
		gmtZeroFormat => q(গ্রীনিচ মান সময়),
		regionFormat => q({0} সময়),
		regionFormat => q({0} দিবালোক সময়),
		regionFormat => q({0} আদর্শ সময়),
		fallbackFormat => q({1} ({0})),
		'Acre' => {
			long => {
				'daylight' => q(একর গ্রীষ্মকাল সময়),
				'generic' => q(একর সময়),
				'standard' => q(একর মানক সময়),
			},
		},
		'Afghanistan' => {
			long => {
				'standard' => q(আফগানিস্তান সময়),
			},
		},
		'Africa/Abidjan' => {
			exemplarCity => q#আবিদজান#,
		},
		'Africa/Accra' => {
			exemplarCity => q#আক্রা#,
		},
		'Africa/Addis_Ababa' => {
			exemplarCity => q#আদ্দিস আবাবা#,
		},
		'Africa/Algiers' => {
			exemplarCity => q#আলজিয়ার্স#,
		},
		'Africa/Asmera' => {
			exemplarCity => q#অ্যাসমারাহু#,
		},
		'Africa/Bamako' => {
			exemplarCity => q#বাম্যাকো#,
		},
		'Africa/Bangui' => {
			exemplarCity => q#বাঙ্গি#,
		},
		'Africa/Banjul' => {
			exemplarCity => q#বাঞ্জুল#,
		},
		'Africa/Bissau' => {
			exemplarCity => q#বিসোউ#,
		},
		'Africa/Blantyre' => {
			exemplarCity => q#ব্ল্যানটায়ের#,
		},
		'Africa/Brazzaville' => {
			exemplarCity => q#ব্রাজউহভিল#,
		},
		'Africa/Bujumbura' => {
			exemplarCity => q#বুজুমবুরহু#,
		},
		'Africa/Cairo' => {
			exemplarCity => q#কায়রো#,
		},
		'Africa/Casablanca' => {
			exemplarCity => q#কাসাব্লাঙ্কা#,
		},
		'Africa/Ceuta' => {
			exemplarCity => q#সেউটা#,
		},
		'Africa/Conakry' => {
			exemplarCity => q#কনাক্রি#,
		},
		'Africa/Dakar' => {
			exemplarCity => q#ডাকার#,
		},
		'Africa/Dar_es_Salaam' => {
			exemplarCity => q#দার এস সালাম#,
		},
		'Africa/Djibouti' => {
			exemplarCity => q#জিবুটি#,
		},
		'Africa/Douala' => {
			exemplarCity => q#ডোয়ালা#,
		},
		'Africa/El_Aaiun' => {
			exemplarCity => q#এল আহইউন#,
		},
		'Africa/Freetown' => {
			exemplarCity => q#ফ্রীটাউন#,
		},
		'Africa/Gaborone' => {
			exemplarCity => q#গ্যাবুরনি#,
		},
		'Africa/Harare' => {
			exemplarCity => q#হারারে#,
		},
		'Africa/Johannesburg' => {
			exemplarCity => q#জোহানেসবার্গ#,
		},
		'Africa/Juba' => {
			exemplarCity => q#জুবা#,
		},
		'Africa/Kampala' => {
			exemplarCity => q#কামপালা#,
		},
		'Africa/Khartoum' => {
			exemplarCity => q#খার্তুম#,
		},
		'Africa/Kigali' => {
			exemplarCity => q#কিগালি#,
		},
		'Africa/Kinshasa' => {
			exemplarCity => q#কিনশাসা#,
		},
		'Africa/Lagos' => {
			exemplarCity => q#লাগোস#,
		},
		'Africa/Libreville' => {
			exemplarCity => q#লিব্রুভিল#,
		},
		'Africa/Lome' => {
			exemplarCity => q#লোমায়#,
		},
		'Africa/Luanda' => {
			exemplarCity => q#লোয়ান্ডা#,
		},
		'Africa/Lubumbashi' => {
			exemplarCity => q#লুবুম্বাশি#,
		},
		'Africa/Lusaka' => {
			exemplarCity => q#লুসাকা#,
		},
		'Africa/Malabo' => {
			exemplarCity => q#মালাবো#,
		},
		'Africa/Maputo' => {
			exemplarCity => q#মাপুতো#,
		},
		'Africa/Maseru' => {
			exemplarCity => q#মাহসুরু#,
		},
		'Africa/Mbabane' => {
			exemplarCity => q#অমবাবান#,
		},
		'Africa/Mogadishu' => {
			exemplarCity => q#মাওগাদিসু#,
		},
		'Africa/Monrovia' => {
			exemplarCity => q#মনরোভিয়া#,
		},
		'Africa/Nairobi' => {
			exemplarCity => q#নাইরোবি#,
		},
		'Africa/Ndjamena' => {
			exemplarCity => q#এনজমেনা#,
		},
		'Africa/Niamey' => {
			exemplarCity => q#নিয়ামে#,
		},
		'Africa/Nouakchott' => {
			exemplarCity => q#নোয়াকশট#,
		},
		'Africa/Ouagadougou' => {
			exemplarCity => q#ওয়াহগুডোগু#,
		},
		'Africa/Porto-Novo' => {
			exemplarCity => q#পোর্টো-নোভো#,
		},
		'Africa/Sao_Tome' => {
			exemplarCity => q#সাও টোম#,
		},
		'Africa/Tripoli' => {
			exemplarCity => q#ত্রিপোলি#,
		},
		'Africa/Tunis' => {
			exemplarCity => q#টিউনিস#,
		},
		'Africa/Windhoek' => {
			exemplarCity => q#উইনধোক#,
		},
		'Africa_Central' => {
			long => {
				'standard' => q(মধ্য আফ্রিকা সময়),
			},
		},
		'Africa_Eastern' => {
			long => {
				'standard' => q(পূর্ব আফ্রিকা সময়),
			},
		},
		'Africa_Southern' => {
			long => {
				'standard' => q(দক্ষিণ আফ্রিকা মানক সময়),
			},
		},
		'Africa_Western' => {
			long => {
				'daylight' => q(পশ্চিম আফ্রিকা গ্রীষ্মকালীন সময়),
				'generic' => q(পশ্চিম আফ্রিকা সময়),
				'standard' => q(পশ্চিম আফ্রিকা মানক সময়),
			},
		},
		'Alaska' => {
			long => {
				'daylight' => q(আলাস্কা দিবালোক সময়),
				'generic' => q(আলাস্কা সময়),
				'standard' => q(আলাস্কা মানক সময়),
			},
		},
		'Almaty' => {
			long => {
				'daylight' => q(আল্মাটি গ্রীষ্মকাল সময়),
				'generic' => q(আল্মাটি সময়),
				'standard' => q(আল্মাটি মানক সময়),
			},
		},
		'Amazon' => {
			long => {
				'daylight' => q(অ্যামাজন গ্রীষ্মকালীন সময়),
				'generic' => q(অ্যামাজন সময়),
				'standard' => q(আমাজন মানক সময়),
			},
		},
		'America/Adak' => {
			exemplarCity => q#আডাক#,
		},
		'America/Anchorage' => {
			exemplarCity => q#এনকোরেজ#,
		},
		'America/Anguilla' => {
			exemplarCity => q#অ্যাঙ্গুইলা#,
		},
		'America/Antigua' => {
			exemplarCity => q#অ্যান্টিগুয়াগা#,
		},
		'America/Araguaina' => {
			exemplarCity => q#আরাগুয়াইনা#,
		},
		'America/Argentina/La_Rioja' => {
			exemplarCity => q#লা রিওহা#,
		},
		'America/Argentina/Rio_Gallegos' => {
			exemplarCity => q#রিও গায়েগোস#,
		},
		'America/Argentina/Salta' => {
			exemplarCity => q#স্যালটা#,
		},
		'America/Argentina/San_Juan' => {
			exemplarCity => q#সান হুয়ান#,
		},
		'America/Argentina/San_Luis' => {
			exemplarCity => q#সান লুইস#,
		},
		'America/Argentina/Tucuman' => {
			exemplarCity => q#টুকুমান#,
		},
		'America/Argentina/Ushuaia' => {
			exemplarCity => q#উশুয়াইয়া#,
		},
		'America/Aruba' => {
			exemplarCity => q#এরুবা#,
		},
		'America/Asuncion' => {
			exemplarCity => q#আসুনসিয়ন#,
		},
		'America/Bahia' => {
			exemplarCity => q#বাহিয়া#,
		},
		'America/Bahia_Banderas' => {
			exemplarCity => q#বাহিয়া বানড্রাস#,
		},
		'America/Barbados' => {
			exemplarCity => q#বার্বাডোজ#,
		},
		'America/Belem' => {
			exemplarCity => q#বেলেম#,
		},
		'America/Belize' => {
			exemplarCity => q#বেলিজ#,
		},
		'America/Blanc-Sablon' => {
			exemplarCity => q#ব্লাঙ্ক-সাব্লোন#,
		},
		'America/Boa_Vista' => {
			exemplarCity => q#বোয়া ভিস্তা#,
		},
		'America/Bogota' => {
			exemplarCity => q#বোগোটা#,
		},
		'America/Boise' => {
			exemplarCity => q#বয়জি#,
		},
		'America/Buenos_Aires' => {
			exemplarCity => q#বুয়েনোস আয়েরেস#,
		},
		'America/Cambridge_Bay' => {
			exemplarCity => q#কেমব্রিজ বে#,
		},
		'America/Campo_Grande' => {
			exemplarCity => q#কাম্পো গ্রান্ডে#,
		},
		'America/Cancun' => {
			exemplarCity => q#ক্যানকুন#,
		},
		'America/Caracas' => {
			exemplarCity => q#ক্যারাকাস#,
		},
		'America/Catamarca' => {
			exemplarCity => q#ক্যাটামার্কা#,
		},
		'America/Cayenne' => {
			exemplarCity => q#কাহেন#,
		},
		'America/Cayman' => {
			exemplarCity => q#কামেন#,
		},
		'America/Chicago' => {
			exemplarCity => q#শিকাগো#,
		},
		'America/Chihuahua' => {
			exemplarCity => q#চিহুয়াহুয়া#,
		},
		'America/Coral_Harbour' => {
			exemplarCity => q#কোরাল হার্বার#,
		},
		'America/Cordoba' => {
			exemplarCity => q#কর্ডোবা#,
		},
		'America/Costa_Rica' => {
			exemplarCity => q#কোস্টারিকা#,
		},
		'America/Creston' => {
			exemplarCity => q#ক্রিস্টান#,
		},
		'America/Cuiaba' => {
			exemplarCity => q#কুইয়াবা#,
		},
		'America/Curacao' => {
			exemplarCity => q#কুরাসাও#,
		},
		'America/Danmarkshavn' => {
			exemplarCity => q#ডানমার্কশ্যাভন#,
		},
		'America/Dawson' => {
			exemplarCity => q#ডসোন#,
		},
		'America/Dawson_Creek' => {
			exemplarCity => q#ডসোন ক্রিক#,
		},
		'America/Denver' => {
			exemplarCity => q#ডেনভার#,
		},
		'America/Detroit' => {
			exemplarCity => q#ডেট্রোইট#,
		},
		'America/Dominica' => {
			exemplarCity => q#ডোমিনিকা#,
		},
		'America/Edmonton' => {
			exemplarCity => q#এডমন্টোন#,
		},
		'America/Eirunepe' => {
			exemplarCity => q#আইরুনেপে#,
		},
		'America/El_Salvador' => {
			exemplarCity => q#এল সালভাদোর#,
		},
		'America/Fortaleza' => {
			exemplarCity => q#ফোর্টালেজা#,
		},
		'America/Glace_Bay' => {
			exemplarCity => q#গ্লাস বে#,
		},
		'America/Godthab' => {
			exemplarCity => q#নুক#,
		},
		'America/Goose_Bay' => {
			exemplarCity => q#গুস বে#,
		},
		'America/Grand_Turk' => {
			exemplarCity => q#গ্র্যান্ড তুর্ক#,
		},
		'America/Grenada' => {
			exemplarCity => q#গ্রেনাডা#,
		},
		'America/Guadeloupe' => {
			exemplarCity => q#গুয়াদেলোপ#,
		},
		'America/Guatemala' => {
			exemplarCity => q#গুয়াতেমালা#,
		},
		'America/Guayaquil' => {
			exemplarCity => q#গোয়াইয়াকিল#,
		},
		'America/Guyana' => {
			exemplarCity => q#গায়ানা#,
		},
		'America/Halifax' => {
			exemplarCity => q#হ্যালিফ্যাক্স#,
		},
		'America/Havana' => {
			exemplarCity => q#হাভানা#,
		},
		'America/Hermosillo' => {
			exemplarCity => q#হারমোসিল্লো#,
		},
		'America/Indiana/Knox' => {
			exemplarCity => q#নক্স, ইন্ডিয়ানা#,
		},
		'America/Indiana/Marengo' => {
			exemplarCity => q#মারেঙ্গো, ইন্ডিয়ানা#,
		},
		'America/Indiana/Petersburg' => {
			exemplarCity => q#পিটারর্সবার্গ, ইন্ডিয়ানা#,
		},
		'America/Indiana/Tell_City' => {
			exemplarCity => q#টেলসিটি, ইন্ডিয়ানা#,
		},
		'America/Indiana/Vevay' => {
			exemplarCity => q#ভেভেয়, ইন্ডিয়ানা#,
		},
		'America/Indiana/Vincennes' => {
			exemplarCity => q#ভিনসেন্নেস, ইন্ডিয়ানা#,
		},
		'America/Indiana/Winamac' => {
			exemplarCity => q#উইনাম্যাক, ইন্ডিয়ানা#,
		},
		'America/Indianapolis' => {
			exemplarCity => q#ইন্ডিয়ানাপোলিস#,
		},
		'America/Inuvik' => {
			exemplarCity => q#ইনুভ্যাক#,
		},
		'America/Iqaluit' => {
			exemplarCity => q#ইকুয়ালুইট#,
		},
		'America/Jamaica' => {
			exemplarCity => q#জামাইকা#,
		},
		'America/Jujuy' => {
			exemplarCity => q#হুহুই#,
		},
		'America/Juneau' => {
			exemplarCity => q#জুনো#,
		},
		'America/Kentucky/Monticello' => {
			exemplarCity => q#মন্টিচেলো, কেন্টাকি#,
		},
		'America/Kralendijk' => {
			exemplarCity => q#ক্রেলেন্ডাজিক#,
		},
		'America/La_Paz' => {
			exemplarCity => q#লা পাজ#,
		},
		'America/Lima' => {
			exemplarCity => q#লিমা#,
		},
		'America/Los_Angeles' => {
			exemplarCity => q#লস এ্যাঞ্জেলেস#,
		},
		'America/Louisville' => {
			exemplarCity => q#লুইসভিল#,
		},
		'America/Lower_Princes' => {
			exemplarCity => q#লোয়ার প্রিন্সেস কোয়ার্টার#,
		},
		'America/Maceio' => {
			exemplarCity => q#মাসেয়ো#,
		},
		'America/Managua' => {
			exemplarCity => q#মানাগুয়া#,
		},
		'America/Manaus' => {
			exemplarCity => q#মানাউস#,
		},
		'America/Marigot' => {
			exemplarCity => q#মারিগো#,
		},
		'America/Martinique' => {
			exemplarCity => q#মারটিনিক#,
		},
		'America/Matamoros' => {
			exemplarCity => q#মাতামোরস#,
		},
		'America/Mazatlan' => {
			exemplarCity => q#মাজাটলান#,
		},
		'America/Mendoza' => {
			exemplarCity => q#মেন্ডোজা#,
		},
		'America/Menominee' => {
			exemplarCity => q#মেনোমিনি#,
		},
		'America/Merida' => {
			exemplarCity => q#মেরিডা#,
		},
		'America/Metlakatla' => {
			exemplarCity => q#ম্যাকওয়ারি#,
		},
		'America/Mexico_City' => {
			exemplarCity => q#মেক্সিকো সিটি#,
		},
		'America/Miquelon' => {
			exemplarCity => q#মিকুলন#,
		},
		'America/Moncton' => {
			exemplarCity => q#মঙ্কটোন#,
		},
		'America/Monterrey' => {
			exemplarCity => q#মন্টেরি#,
		},
		'America/Montevideo' => {
			exemplarCity => q#মন্টেভিডিও#,
		},
		'America/Montserrat' => {
			exemplarCity => q#মন্তসেরাত#,
		},
		'America/Nassau' => {
			exemplarCity => q#নাসাউ#,
		},
		'America/New_York' => {
			exemplarCity => q#নিউইয়র্ক#,
		},
		'America/Nipigon' => {
			exemplarCity => q#নিপিগোন#,
		},
		'America/Nome' => {
			exemplarCity => q#নোম#,
		},
		'America/Noronha' => {
			exemplarCity => q#নরোন্‌হা#,
		},
		'America/North_Dakota/Beulah' => {
			exemplarCity => q#বেউলা, উত্তর ডাকোটা#,
		},
		'America/North_Dakota/Center' => {
			exemplarCity => q#মধ্য, উত্তর ডাকোটা#,
		},
		'America/North_Dakota/New_Salem' => {
			exemplarCity => q#নিউ সালেম, উত্তর ডাকোটা#,
		},
		'America/Ojinaga' => {
			exemplarCity => q#ওজিঙ্গা#,
		},
		'America/Panama' => {
			exemplarCity => q#পানামা#,
		},
		'America/Pangnirtung' => {
			exemplarCity => q#প্যাঙ্গনির্টুং#,
		},
		'America/Paramaribo' => {
			exemplarCity => q#প্যারামেরিবো#,
		},
		'America/Phoenix' => {
			exemplarCity => q#ফিনিক্স#,
		},
		'America/Port-au-Prince' => {
			exemplarCity => q#পোর্ট-অহ-প্রিন্স#,
		},
		'America/Port_of_Spain' => {
			exemplarCity => q#পোর্ট অফ স্পেন#,
		},
		'America/Porto_Velho' => {
			exemplarCity => q#পোর্তো ভেল্‌হো#,
		},
		'America/Puerto_Rico' => {
			exemplarCity => q#পুয়েরতো রিকো#,
		},
		'America/Rainy_River' => {
			exemplarCity => q#রেইনি রিভার#,
		},
		'America/Rankin_Inlet' => {
			exemplarCity => q#র‌্যাঙ্কিন ইনলেট#,
		},
		'America/Recife' => {
			exemplarCity => q#রেসিফে#,
		},
		'America/Regina' => {
			exemplarCity => q#রেজিনা#,
		},
		'America/Resolute' => {
			exemplarCity => q#রেসোলুট#,
		},
		'America/Rio_Branco' => {
			exemplarCity => q#রিও ব্রাঙ্কো#,
		},
		'America/Santa_Isabel' => {
			exemplarCity => q#সান্তা ইসাবেল#,
		},
		'America/Santarem' => {
			exemplarCity => q#সেনটুরেম#,
		},
		'America/Santiago' => {
			exemplarCity => q#সান্টিয়াগো#,
		},
		'America/Santo_Domingo' => {
			exemplarCity => q#স্যান্টো ডোমিংগো#,
		},
		'America/Sao_Paulo' => {
			exemplarCity => q#সাও পাউলো#,
		},
		'America/Scoresbysund' => {
			exemplarCity => q#ইটকুয়োরটুরমিট#,
		},
		'America/Sitka' => {
			exemplarCity => q#শিটকা#,
		},
		'America/St_Barthelemy' => {
			exemplarCity => q#সেন্ট.বার্থেলেমি#,
		},
		'America/St_Johns' => {
			exemplarCity => q#সেন্ট জন্স#,
		},
		'America/St_Kitts' => {
			exemplarCity => q#সেন্ট. কিটস#,
		},
		'America/St_Lucia' => {
			exemplarCity => q#সেন্ট. লুসিয়া#,
		},
		'America/St_Thomas' => {
			exemplarCity => q#সেন্ট. থমাস#,
		},
		'America/St_Vincent' => {
			exemplarCity => q#সেন্ট. ভিনসেন্ট#,
		},
		'America/Swift_Current' => {
			exemplarCity => q#সুইফ্ট কারেন্ট#,
		},
		'America/Tegucigalpa' => {
			exemplarCity => q#তেগুসিগালপা#,
		},
		'America/Thule' => {
			exemplarCity => q#থুলি#,
		},
		'America/Thunder_Bay' => {
			exemplarCity => q#থান্ডার বে#,
		},
		'America/Tijuana' => {
			exemplarCity => q#তিয়াওয়ানা#,
		},
		'America/Toronto' => {
			exemplarCity => q#টোরন্টো#,
		},
		'America/Tortola' => {
			exemplarCity => q#টরটোলা#,
		},
		'America/Vancouver' => {
			exemplarCity => q#ভ্যাঙ্কুভার#,
		},
		'America/Whitehorse' => {
			exemplarCity => q#হো্য়াইট হর্স#,
		},
		'America/Winnipeg' => {
			exemplarCity => q#উইনিপেগ#,
		},
		'America/Yakutat' => {
			exemplarCity => q#ইয়াকুটাট#,
		},
		'America/Yellowknife' => {
			exemplarCity => q#ইয়েলোনাইফ#,
		},
		'America_Central' => {
			long => {
				'daylight' => q(উত্তর আমিরিকা কেন্দ্রীয় দিবালোক মসয়),
				'generic' => q(উত্তর আমিরিকা কেন্দ্রীয় সময়),
				'standard' => q(উত্তর আমিরিকা কেন্দ্রীয় মানক সময়),
			},
		},
		'America_Eastern' => {
			long => {
				'daylight' => q(উত্তর আমিরিকা পূর্ব দিবালোক সময়),
				'generic' => q(উত্তর আমিরিকা পূর্বাঞ্চলীয় সময়),
				'standard' => q(উত্তর আমিরিকা পূর্ব মানক সময়),
			},
		},
		'America_Mountain' => {
			long => {
				'daylight' => q(উত্তর আমেরিকা মাউনটেন দিবালোক সময়),
				'generic' => q(উত্তর আমেরিকা মাউন্টেন সময়),
				'standard' => q(উত্তর আমিরিকা মাউনটেন মানক সময়),
			},
		},
		'America_Pacific' => {
			long => {
				'daylight' => q(উত্তর আমিরিকা প্রশান্ত মহাসাগরীয় দিবালোক সময়),
				'generic' => q(উত্তর আমিরিকা প্রশান্ত মহাসাগরীয় সময়),
				'standard' => q(প্রশান্ত মহাসাগরীয় মানক সময়),
			},
		},
		'Anadyr' => {
			long => {
				'daylight' => q(অনদ্য্র্ গ্রীষ্মকালীন সময়),
				'generic' => q(অনদ্য্র্ সময়),
				'standard' => q(অনদ্য্র্ মানক সময়),
			},
		},
		'Antarctica/Casey' => {
			exemplarCity => q#কেইসি#,
		},
		'Antarctica/Davis' => {
			exemplarCity => q#ডেভিস#,
		},
		'Antarctica/DumontDUrville' => {
			exemplarCity => q#ডুমন্ট ডি’উরভিল#,
		},
		'Antarctica/Macquarie' => {
			exemplarCity => q#ম্যাককুয়্যারি#,
		},
		'Antarctica/Mawson' => {
			exemplarCity => q#মসোন#,
		},
		'Antarctica/McMurdo' => {
			exemplarCity => q#ম্যাকমুর্ডো#,
		},
		'Antarctica/Palmer' => {
			exemplarCity => q#পামার#,
		},
		'Antarctica/Rothera' => {
			exemplarCity => q#রথেরা#,
		},
		'Antarctica/Syowa' => {
			exemplarCity => q#সিওয়া#,
		},
		'Antarctica/Vostok' => {
			exemplarCity => q#ভস্টোক#,
		},
		'Aqtau' => {
			long => {
				'daylight' => q(আকটাও গ্রীষ্মকাল সময়),
				'generic' => q(আকটাও সময়),
				'standard' => q(আকটাও মানক সময়),
			},
		},
		'Aqtobe' => {
			long => {
				'daylight' => q(আকটোব গ্রীষ্মকাল সময়),
				'generic' => q(আকটোব সময়),
				'standard' => q(আকটোব মানক সময়),
			},
		},
		'Arabian' => {
			long => {
				'daylight' => q(আরবি দিবালোক সময়),
				'generic' => q(আরবি সময়),
				'standard' => q(আরবি মানক সময়),
			},
		},
		'Arctic/Longyearbyen' => {
			exemplarCity => q#লঞ্জিয়বিয়েঁন#,
		},
		'Argentina' => {
			long => {
				'daylight' => q(আর্জেনটিনা গৃষ্মকালীন সময়),
				'generic' => q(আর্জেনটিনা সময়),
				'standard' => q(আর্জেনটিনা মানক সময়),
			},
		},
		'Argentina_Western' => {
			long => {
				'daylight' => q(আর্জেনটিনা পশ্চিমি গৃষ্মকালীন সময়),
				'generic' => q(আর্জেনটিনা পশ্চিমি সময়),
				'standard' => q(পশ্চিমি আর্জেনটিনা সময়),
			},
		},
		'Armenia' => {
			long => {
				'daylight' => q(আর্মেনিয়া গ্রীষ্মকালীন সময়),
				'generic' => q(আর্মেনিয়া সময়),
				'standard' => q(আর্মেনিয়া মানক সময়),
			},
		},
		'Asia/Aden' => {
			exemplarCity => q#আহদেন#,
		},
		'Asia/Almaty' => {
			exemplarCity => q#আলমাটি#,
		},
		'Asia/Amman' => {
			exemplarCity => q#আম্মান#,
		},
		'Asia/Anadyr' => {
			exemplarCity => q#অ্যানাডির#,
		},
		'Asia/Aqtau' => {
			exemplarCity => q#আকটাউ#,
		},
		'Asia/Aqtobe' => {
			exemplarCity => q#আকটোবে#,
		},
		'Asia/Ashgabat' => {
			exemplarCity => q#আশগুবাদ#,
		},
		'Asia/Baghdad' => {
			exemplarCity => q#বাগদাদ#,
		},
		'Asia/Bahrain' => {
			exemplarCity => q#বাহরিন#,
		},
		'Asia/Baku' => {
			exemplarCity => q#বাকু#,
		},
		'Asia/Bangkok' => {
			exemplarCity => q#ব্যাংকক#,
		},
		'Asia/Beirut' => {
			exemplarCity => q#বেইরুট#,
		},
		'Asia/Bishkek' => {
			exemplarCity => q#বিশকেক#,
		},
		'Asia/Brunei' => {
			exemplarCity => q#ব্রুনেই#,
		},
		'Asia/Calcutta' => {
			exemplarCity => q#কলকাতা#,
		},
		'Asia/Choibalsan' => {
			exemplarCity => q#চোইবাল্‌স্যান#,
		},
		'Asia/Chongqing' => {
			exemplarCity => q#চোঙকিং#,
		},
		'Asia/Colombo' => {
			exemplarCity => q#কলম্বো#,
		},
		'Asia/Damascus' => {
			exemplarCity => q#দামাস্কাস#,
		},
		'Asia/Dhaka' => {
			exemplarCity => q#ঢাকা#,
		},
		'Asia/Dili' => {
			exemplarCity => q#দিলি#,
		},
		'Asia/Dubai' => {
			exemplarCity => q#দুবাই#,
		},
		'Asia/Dushanbe' => {
			exemplarCity => q#দুশানবে#,
		},
		'Asia/Gaza' => {
			exemplarCity => q#গাজা#,
		},
		'Asia/Harbin' => {
			exemplarCity => q#হার্বিন#,
		},
		'Asia/Hebron' => {
			exemplarCity => q#হেব্রোন#,
		},
		'Asia/Hong_Kong' => {
			exemplarCity => q#হং কং#,
		},
		'Asia/Hovd' => {
			exemplarCity => q#হোভ্ড#,
		},
		'Asia/Irkutsk' => {
			exemplarCity => q#ইর্কুট্স্ক#,
		},
		'Asia/Jakarta' => {
			exemplarCity => q#জাকার্তা#,
		},
		'Asia/Jayapura' => {
			exemplarCity => q#জয়াপুরা#,
		},
		'Asia/Jerusalem' => {
			exemplarCity => q#জেরুজালেম#,
		},
		'Asia/Kabul' => {
			exemplarCity => q#কাবুল#,
		},
		'Asia/Kamchatka' => {
			exemplarCity => q#কামচাটকা#,
		},
		'Asia/Karachi' => {
			exemplarCity => q#করাচি#,
		},
		'Asia/Kashgar' => {
			exemplarCity => q#ক্যাশগার#,
		},
		'Asia/Katmandu' => {
			exemplarCity => q#কাঠমান্ডু#,
		},
		'Asia/Khandyga' => {
			exemplarCity => q#খানডিয়াগা#,
		},
		'Asia/Krasnoyarsk' => {
			exemplarCity => q#ক্রাসনোইয়ার্স্ক#,
		},
		'Asia/Kuala_Lumpur' => {
			exemplarCity => q#কুয়ালালামপুর#,
		},
		'Asia/Kuching' => {
			exemplarCity => q#কুচিং#,
		},
		'Asia/Kuwait' => {
			exemplarCity => q#কুয়েত#,
		},
		'Asia/Macau' => {
			exemplarCity => q#ম্যাকাও#,
		},
		'Asia/Magadan' => {
			exemplarCity => q#ম্যাগাডান#,
		},
		'Asia/Makassar' => {
			exemplarCity => q#মাকাসসার#,
		},
		'Asia/Manila' => {
			exemplarCity => q#ম্যানিলা#,
		},
		'Asia/Muscat' => {
			exemplarCity => q#মাসকাট#,
		},
		'Asia/Nicosia' => {
			exemplarCity => q#নিকোসিয়া#,
		},
		'Asia/Novokuznetsk' => {
			exemplarCity => q#নভকুয়েতস্নক#,
		},
		'Asia/Novosibirsk' => {
			exemplarCity => q#নভোসিবির্স্ক#,
		},
		'Asia/Omsk' => {
			exemplarCity => q#ওম্স্ক#,
		},
		'Asia/Oral' => {
			exemplarCity => q#ওরাল#,
		},
		'Asia/Phnom_Penh' => {
			exemplarCity => q#নম পেন#,
		},
		'Asia/Pontianak' => {
			exemplarCity => q#পন্টিয়ান্যাক#,
		},
		'Asia/Pyongyang' => {
			exemplarCity => q#পিয়ংইয়ং#,
		},
		'Asia/Qatar' => {
			exemplarCity => q#কাতার#,
		},
		'Asia/Qyzylorda' => {
			exemplarCity => q#কিজিলর্ডা#,
		},
		'Asia/Rangoon' => {
			exemplarCity => q#রেঙ্গুন#,
		},
		'Asia/Riyadh' => {
			exemplarCity => q#রিয়াধ#,
		},
		'Asia/Saigon' => {
			exemplarCity => q#হো চি মিন শহর#,
		},
		'Asia/Sakhalin' => {
			exemplarCity => q#সাখালিন#,
		},
		'Asia/Samarkand' => {
			exemplarCity => q#সমরখন্দ#,
		},
		'Asia/Seoul' => {
			exemplarCity => q#সোল#,
		},
		'Asia/Shanghai' => {
			exemplarCity => q#সাংঘাই#,
		},
		'Asia/Singapore' => {
			exemplarCity => q#সিঙ্গাপুর#,
		},
		'Asia/Taipei' => {
			exemplarCity => q#তাইপেই#,
		},
		'Asia/Tashkent' => {
			exemplarCity => q#তাসখন্দ#,
		},
		'Asia/Tbilisi' => {
			exemplarCity => q#তুবুলিসি#,
		},
		'Asia/Tehran' => {
			exemplarCity => q#তেহেরান#,
		},
		'Asia/Thimphu' => {
			exemplarCity => q#থিম্ফু#,
		},
		'Asia/Tokyo' => {
			exemplarCity => q#টোকিও#,
		},
		'Asia/Ulaanbaatar' => {
			exemplarCity => q#উলানবাতার#,
		},
		'Asia/Urumqi' => {
			exemplarCity => q#উরুমকি#,
		},
		'Asia/Ust-Nera' => {
			exemplarCity => q#উস্ত- নেরা#,
		},
		'Asia/Vientiane' => {
			exemplarCity => q#ভিয়েনতায়েন#,
		},
		'Asia/Vladivostok' => {
			exemplarCity => q#ভ্লাদিভস্তোক#,
		},
		'Asia/Yakutsk' => {
			exemplarCity => q#ইয়াকুট্স্ক#,
		},
		'Asia/Yekaterinburg' => {
			exemplarCity => q#ইয়েকাটেরিনবার্গ#,
		},
		'Asia/Yerevan' => {
			exemplarCity => q#ইয়েরাভান#,
		},
		'Atlantic' => {
			long => {
				'daylight' => q(অতলান্তিক দিবালোক সময়),
				'generic' => q(অতলান্তিক সময়),
				'standard' => q(অতলান্তিক মানক সময়),
			},
		},
		'Atlantic/Azores' => {
			exemplarCity => q#আজোরেস#,
		},
		'Atlantic/Bermuda' => {
			exemplarCity => q#বারমুডা#,
		},
		'Atlantic/Canary' => {
			exemplarCity => q#কানেরি#,
		},
		'Atlantic/Cape_Verde' => {
			exemplarCity => q#কেপ ভার্দ#,
		},
		'Atlantic/Faeroe' => {
			exemplarCity => q#ফ্যারো#,
		},
		'Atlantic/Madeira' => {
			exemplarCity => q#মাডেইরা#,
		},
		'Atlantic/Reykjavik' => {
			exemplarCity => q#রিকজাভিক#,
		},
		'Atlantic/South_Georgia' => {
			exemplarCity => q#দক্ষিণ জর্জিয়া#,
		},
		'Atlantic/St_Helena' => {
			exemplarCity => q#সেন্ট. হেলেনা#,
		},
		'Atlantic/Stanley' => {
			exemplarCity => q#স্টানলী#,
		},
		'Australia/Adelaide' => {
			exemplarCity => q#এ্যাডেলেইড#,
		},
		'Australia/Brisbane' => {
			exemplarCity => q#ব্রিসবেন#,
		},
		'Australia/Broken_Hill' => {
			exemplarCity => q#ব্রোকেন হিল#,
		},
		'Australia/Currie' => {
			exemplarCity => q#কিউরি#,
		},
		'Australia/Darwin' => {
			exemplarCity => q#ডারউইন#,
		},
		'Australia/Eucla' => {
			exemplarCity => q#ইউক্লা#,
		},
		'Australia/Hobart' => {
			exemplarCity => q#হোবার্ট#,
		},
		'Australia/Lindeman' => {
			exemplarCity => q#লিনডেম্যান#,
		},
		'Australia/Lord_Howe' => {
			exemplarCity => q#লর্ড হাও#,
		},
		'Australia/Melbourne' => {
			exemplarCity => q#মেলবার্ন#,
		},
		'Australia/Perth' => {
			exemplarCity => q#পার্থ#,
		},
		'Australia/Sydney' => {
			exemplarCity => q#সিডনি#,
		},
		'Australia_Central' => {
			long => {
				'daylight' => q(অস্ট্রেলীয় কেন্দ্রীয় দিবালোক সময়),
				'generic' => q(কেন্দ্রীয় অস্ট্রেলীয় সময়),
				'standard' => q(অস্ট্রেলীয় কেন্দ্রীয় মানক সময়),
			},
		},
		'Australia_CentralWestern' => {
			long => {
				'daylight' => q(অস্ট্রেলীয় কেন্দ্রীয় পশ্চিমি দিবালোক সময়),
				'generic' => q(অস্ট্রেলীয় কেন্দ্রীয় পশ্চিমি সময়),
				'standard' => q(অস্ট্রেলীয় কেন্দ্রীয় পশ্চিমি মানক সময়),
			},
		},
		'Australia_Eastern' => {
			long => {
				'daylight' => q(অস্ট্রেলীয় পূর্ব দিবালোক সময়),
				'generic' => q(পূর্ব অস্ট্রেলীয় সময়),
				'standard' => q(অস্ট্রেলীয় পূর্ব মানক সময়),
			},
		},
		'Australia_Western' => {
			long => {
				'daylight' => q(অস্ট্রেলীয় পশ্চিমি দিবালোক সময়),
				'generic' => q(পশ্চিমি অস্ট্রেলীয় সময়),
				'standard' => q(অস্ট্রেলিয়ান পশ্চিমি মানক সময়),
			},
		},
		'Azerbaijan' => {
			long => {
				'daylight' => q(আজারবাইজান গ্রীষ্মকালীন সময়),
				'generic' => q(আজারবাইজান সময়),
				'standard' => q(আজারবাইজান মানক সময়),
			},
		},
		'Azores' => {
			long => {
				'daylight' => q(এজোরেস গ্রীষ্মকালীন সময়),
				'generic' => q(এজোরেস সময়),
				'standard' => q(এজোরেস মানক সময়),
			},
		},
		'Bangladesh' => {
			long => {
				'daylight' => q(বাংলাদেশ গ্রীষ্মকালীন সময়),
				'generic' => q(বাংলাদেশ সময়),
				'standard' => q(বাংলাদেশ মানক সময়),
			},
		},
		'Bhutan' => {
			long => {
				'standard' => q(ভুটান সময়),
			},
		},
		'Bolivia' => {
			long => {
				'standard' => q(বোলিভিয়া সময়),
			},
		},
		'Brasilia' => {
			long => {
				'daylight' => q(ব্রাসিলিয়া গৃষ্মকালীন সময়),
				'generic' => q(ব্রাসিলিয়া সময়),
				'standard' => q(ব্রাসিলিয়া মানক সময়),
			},
		},
		'Brunei' => {
			long => {
				'standard' => q(ব্রুনেই দারুসসালাম সময়),
			},
		},
		'Cape_Verde' => {
			long => {
				'daylight' => q(কেপ ভার্দ গ্রীষ্মকালীন সময়),
				'generic' => q(কেপ ভার্দ সময়),
				'standard' => q(কেপ ভার্দ মানক সময়),
			},
		},
		'Chamorro' => {
			long => {
				'standard' => q(চামেরো মানক সময়),
			},
		},
		'Chatham' => {
			long => {
				'daylight' => q(চ্যাথাম দিবালোক সময়),
				'generic' => q(চ্যাথাম সময়),
				'standard' => q(চ্যাথাম মানক সময়),
			},
		},
		'Chile' => {
			long => {
				'daylight' => q(চিলি গ্রীষ্মকাল সময়),
				'generic' => q(চিলি সময়),
				'standard' => q(চিলি মানক সময়),
			},
		},
		'China' => {
			long => {
				'daylight' => q(চীন দিবালোক সময়),
				'generic' => q(চীন সময়),
				'standard' => q(চীন মানক সময়),
			},
		},
		'Choibalsan' => {
			long => {
				'daylight' => q(চয়বালসন গ্রীষ্মকালীন সময়),
				'generic' => q(চয়বালসন সময়),
				'standard' => q(চয়বালসন মানক সময়),
			},
		},
		'Christmas' => {
			long => {
				'standard' => q(ক্রিসমাস দ্বীপ সময়),
			},
		},
		'Cocos' => {
			long => {
				'standard' => q(কোকোস দ্বীপপুঞ্জ সময়),
			},
		},
		'Colombia' => {
			long => {
				'daylight' => q(কোলোম্বিয়া গ্রীষ্মকালীন সময়),
				'generic' => q(কোলোম্বিয়া সময়),
				'standard' => q(কোলোম্বিয়া মানক সময়),
			},
		},
		'Cook' => {
			long => {
				'daylight' => q(কুক দ্বীপপুঞ্জ হাফ মানক সময়),
				'generic' => q(কুক দ্বীপপুঞ্জ সময়),
				'standard' => q(কুক দ্বীপপুঞ্জ মানক সময়),
			},
		},
		'Cuba' => {
			long => {
				'daylight' => q(কিউবা দিবালোক সময়),
				'generic' => q(কিউবা সময়),
				'standard' => q(কিউবা মানক সময়),
			},
		},
		'Davis' => {
			long => {
				'standard' => q(ডেভিস সময়),
			},
		},
		'DumontDUrville' => {
			long => {
				'standard' => q(ডুমন্ট-দ্য'উরভিলে সময়),
			},
		},
		'East_Timor' => {
			long => {
				'standard' => q(পূর্ব টিমর সময়),
			},
		},
		'Easter' => {
			long => {
				'daylight' => q(ইস্টার দ্বীপ গ্রীষ্মকালীন সময়),
				'generic' => q(ইস্টার দ্বীপ সময়),
				'standard' => q(ইস্টার দ্বীপ মানক সময়),
			},
		},
		'Ecuador' => {
			long => {
				'standard' => q(ইকুয়েডর সময়),
			},
		},
		'Etc/Unknown' => {
			exemplarCity => q#অজানা শহর#,
		},
		'Europe/Amsterdam' => {
			exemplarCity => q#আমস্টারডাম#,
		},
		'Europe/Andorra' => {
			exemplarCity => q#অ্যান্ডোরা#,
		},
		'Europe/Athens' => {
			exemplarCity => q#এথেন্স#,
		},
		'Europe/Belgrade' => {
			exemplarCity => q#বেলগ্রেড#,
		},
		'Europe/Berlin' => {
			exemplarCity => q#বার্লিন#,
		},
		'Europe/Bratislava' => {
			exemplarCity => q#ব্রাতিস্লাভা#,
		},
		'Europe/Brussels' => {
			exemplarCity => q#ব্রাসেলস#,
		},
		'Europe/Bucharest' => {
			exemplarCity => q#বুখারেস্ট#,
		},
		'Europe/Budapest' => {
			exemplarCity => q#বুডাপেস্ট#,
		},
		'Europe/Busingen' => {
			exemplarCity => q#বুসিনগেন#,
		},
		'Europe/Chisinau' => {
			exemplarCity => q#কিসিনাহু#,
		},
		'Europe/Copenhagen' => {
			exemplarCity => q#কোপেনহেগেন#,
		},
		'Europe/Dublin' => {
			exemplarCity => q#ডাবলিন#,
			long => {
				'daylight' => q(আইরিশ গ্রীষ্মকালীন সময়),
			},
		},
		'Europe/Gibraltar' => {
			exemplarCity => q#জিব্রাল্টার#,
		},
		'Europe/Guernsey' => {
			exemplarCity => q#গেরেনজি#,
		},
		'Europe/Helsinki' => {
			exemplarCity => q#হেলসিঙ্কি#,
		},
		'Europe/Isle_of_Man' => {
			exemplarCity => q#আইল অফ ম্যান#,
		},
		'Europe/Istanbul' => {
			exemplarCity => q#ইস্তানবুল#,
		},
		'Europe/Jersey' => {
			exemplarCity => q#জার্সি#,
		},
		'Europe/Kaliningrad' => {
			exemplarCity => q#কালিনিঙগ্রাড#,
		},
		'Europe/Kiev' => {
			exemplarCity => q#কিয়েভ#,
		},
		'Europe/Lisbon' => {
			exemplarCity => q#লিসবন#,
		},
		'Europe/Ljubljana' => {
			exemplarCity => q#লুবলিয়ানা#,
		},
		'Europe/London' => {
			exemplarCity => q#লন্ডন#,
			long => {
				'daylight' => q(ব্রিটিশ গ্রীষ্মকালীন সময়),
			},
		},
		'Europe/Luxembourg' => {
			exemplarCity => q#লুক্সেমবার্গ#,
		},
		'Europe/Madrid' => {
			exemplarCity => q#মাদ্রিদ#,
		},
		'Europe/Malta' => {
			exemplarCity => q#মল্টা#,
		},
		'Europe/Mariehamn' => {
			exemplarCity => q#মরিয়েহামেন#,
		},
		'Europe/Minsk' => {
			exemplarCity => q#মিন্সক#,
		},
		'Europe/Monaco' => {
			exemplarCity => q#মোনাকো#,
		},
		'Europe/Moscow' => {
			exemplarCity => q#মস্কো#,
		},
		'Europe/Oslo' => {
			exemplarCity => q#অসলো#,
		},
		'Europe/Paris' => {
			exemplarCity => q#প্যারিস#,
		},
		'Europe/Podgorica' => {
			exemplarCity => q#পডগরিত্সা#,
		},
		'Europe/Prague' => {
			exemplarCity => q#প্রাগ#,
		},
		'Europe/Riga' => {
			exemplarCity => q#রিগা#,
		},
		'Europe/Rome' => {
			exemplarCity => q#রোম#,
		},
		'Europe/Samara' => {
			exemplarCity => q#সামারা#,
		},
		'Europe/San_Marino' => {
			exemplarCity => q#সান মেরিনো#,
		},
		'Europe/Sarajevo' => {
			exemplarCity => q#সারাজিভো#,
		},
		'Europe/Simferopol' => {
			exemplarCity => q#সিমফেরোপোল#,
		},
		'Europe/Skopje' => {
			exemplarCity => q#স্কপয়ে#,
		},
		'Europe/Sofia' => {
			exemplarCity => q#সোফিয়া#,
		},
		'Europe/Stockholm' => {
			exemplarCity => q#স্টকহোম#,
		},
		'Europe/Tallinn' => {
			exemplarCity => q#তাহলিন#,
		},
		'Europe/Tirane' => {
			exemplarCity => q#তিরানা#,
		},
		'Europe/Uzhgorod' => {
			exemplarCity => q#উঝগোরোড#,
		},
		'Europe/Vaduz' => {
			exemplarCity => q#ভাদুজ#,
		},
		'Europe/Vatican' => {
			exemplarCity => q#ভাটিকান#,
		},
		'Europe/Vienna' => {
			exemplarCity => q#ভিয়েনা#,
		},
		'Europe/Vilnius' => {
			exemplarCity => q#ভিলনিওস#,
		},
		'Europe/Volgograd' => {
			exemplarCity => q#ভোল্গোগ্রাদ#,
		},
		'Europe/Warsaw' => {
			exemplarCity => q#ওয়ারশ#,
		},
		'Europe/Zagreb' => {
			exemplarCity => q#জাগ্রেব#,
		},
		'Europe/Zaporozhye' => {
			exemplarCity => q#জাপোরোঝা#,
		},
		'Europe/Zurich' => {
			exemplarCity => q#জুরিখ#,
		},
		'Europe_Central' => {
			long => {
				'daylight' => q(কেন্দ্রীয় ইউরোপীয় গ্রীষ্মকালীন সময়),
				'generic' => q(মধ্য ইউরোপীয় সময়),
				'standard' => q(কেন্দ্রীয় ইউরোপীয় মানক সময়),
			},
		},
		'Europe_Eastern' => {
			long => {
				'daylight' => q(পূর্ব ইউরোপীয় গ্রীষ্মকালীন সময়),
				'generic' => q(পূর্ব ইউরোপীয় সময়),
				'standard' => q(পূর্ব ইউরোপীয় মানক সময়),
			},
		},
		'Europe_Western' => {
			long => {
				'daylight' => q(পশ্চিম ইউরোপীয় গ্রীষ্মকালীন সময়),
				'generic' => q(পশ্চিম ইওরোপীয় সময়),
				'standard' => q(পশ্চিম ইওরোপীয় মানক সময়),
			},
		},
		'Falkland' => {
			long => {
				'daylight' => q(ফকল্যান্ড দ্বীপপুঞ্জ গ্রীষ্মকালীন সময়),
				'generic' => q(ফকল্যান্ড দ্বীপপুঞ্জ সময়),
				'standard' => q(ফকল্যান্ড দ্বীপপুঞ্জ মানক সময়),
			},
		},
		'Fiji' => {
			long => {
				'daylight' => q(ফিজি গ্রীষ্মকালীন সময়),
				'generic' => q(ফিজি সময়),
				'standard' => q(ফিজি মানক সময়),
			},
		},
		'French_Guiana' => {
			long => {
				'standard' => q(ফরাসি গায়ানা সময়),
			},
		},
		'French_Southern' => {
			long => {
				'standard' => q(ফরাসি দক্ষিন ও দক্ষিণ মেরুদেশীয় সময়),
			},
		},
		'GMT' => {
			long => {
				'standard' => q(গ্রিনউইচ মিন টাইম),
			},
		},
		'Galapagos' => {
			long => {
				'standard' => q(গালাপাগোস সময়),
			},
		},
		'Gambier' => {
			long => {
				'standard' => q(গ্যাম্বিয়ার সময়),
			},
		},
		'Georgia' => {
			long => {
				'daylight' => q(জর্জিয়া গ্রীষ্মকালীন সময়),
				'generic' => q(জর্জিয়া সময়),
				'standard' => q(জর্জিয়া মানক সময়),
			},
		},
		'Gilbert_Islands' => {
			long => {
				'standard' => q(গিলবার্ট দ্বীপপুঞ্জ সময়),
			},
		},
		'Greenland_Eastern' => {
			long => {
				'daylight' => q(পূর্ব গ্রীনল্যান্ড গ্রীষ্মকালীন সময়),
				'generic' => q(পূর্ব গ্রীনল্যান্ড সময়),
				'standard' => q(পূর্ব গ্রীনল্যান্ড মানক সময়),
			},
		},
		'Greenland_Western' => {
			long => {
				'daylight' => q(পশ্চিম গ্রীনল্যান্ড গ্রীষ্মকালীন সময়),
				'generic' => q(পশ্চিম গ্রীনল্যান্ড সময়),
				'standard' => q(পশ্চিম গ্রীনল্যান্ড মানক সময়),
			},
		},
		'Guam' => {
			long => {
				'standard' => q(গুয়াম মান সময়),
			},
		},
		'Gulf' => {
			long => {
				'standard' => q(উপসাগরীয় মানক সময়),
			},
		},
		'Guyana' => {
			long => {
				'standard' => q(গিয়ানা সময়),
			},
		},
		'Hawaii_Aleutian' => {
			long => {
				'daylight' => q(হাওয়াই-আলেউত দিবালোক সময়),
				'generic' => q(হাওয়াই অ্যালিউটিয়ান সময়),
				'standard' => q(হাওয়াই-আলেউত মানক সময়),
			},
		},
		'Hong_Kong' => {
			long => {
				'daylight' => q(হং কং গ্রীষ্মকালীন সময়),
				'generic' => q(হং কং সময়),
				'standard' => q(হং কং মানক সময়),
			},
		},
		'Hovd' => {
			long => {
				'daylight' => q(হোভড গ্রীষ্মকালীন সময়),
				'generic' => q(হোভড সময়),
				'standard' => q(হোভড মানক সময়),
			},
		},
		'India' => {
			long => {
				'standard' => q(ভারতীয় মানক সময়),
			},
			short => {
				'standard' => q(IST),
			},
		},
		'Indian/Antananarivo' => {
			exemplarCity => q#আন্তুনানারিভো#,
		},
		'Indian/Chagos' => {
			exemplarCity => q#ছাগোস#,
		},
		'Indian/Christmas' => {
			exemplarCity => q#বড়দিন#,
		},
		'Indian/Cocos' => {
			exemplarCity => q#কোকোস#,
		},
		'Indian/Comoro' => {
			exemplarCity => q#কোমোরো#,
		},
		'Indian/Kerguelen' => {
			exemplarCity => q#কার্গুলেন#,
		},
		'Indian/Mahe' => {
			exemplarCity => q#মাহে#,
		},
		'Indian/Maldives' => {
			exemplarCity => q#মালদ্বীপ#,
		},
		'Indian/Mauritius' => {
			exemplarCity => q#মরিশাস#,
		},
		'Indian/Mayotte' => {
			exemplarCity => q#মায়োতো#,
		},
		'Indian/Reunion' => {
			exemplarCity => q#রিইউনিয়ন#,
		},
		'Indian_Ocean' => {
			long => {
				'standard' => q(ভারত মহাসাগর সময়),
			},
		},
		'Indochina' => {
			long => {
				'standard' => q(ইন্দোচীন সময়),
			},
		},
		'Indonesia_Central' => {
			long => {
				'standard' => q(কেন্দ্রীয় ইন্দোনেশিয়া সময়),
			},
		},
		'Indonesia_Eastern' => {
			long => {
				'standard' => q(পূর্ব ইন্দোনেশিয়া সময়),
			},
		},
		'Indonesia_Western' => {
			long => {
				'standard' => q(পশ্চিমী ইন্দোনেশিয়া সময়),
			},
		},
		'Iran' => {
			long => {
				'daylight' => q(ইরান দিবালোক সময়),
				'generic' => q(ইরান সময়),
				'standard' => q(ইরান মানক সময়),
			},
		},
		'Irkutsk' => {
			long => {
				'daylight' => q(য়াকুটস্ক গৃষ্মকালীন সময়),
				'generic' => q(য়াকুটস্ক সময়),
				'standard' => q(য়াকুটস্ক মানক সময়),
			},
		},
		'Israel' => {
			long => {
				'daylight' => q(ইজরায়েল দিবালোক সময়),
				'generic' => q(ইজরায়েল সময়),
				'standard' => q(ইজরায়েল মানক সময়),
			},
		},
		'Japan' => {
			long => {
				'daylight' => q(জাপান দিবালোক সময়),
				'generic' => q(জাপান সময়),
				'standard' => q(জাপান মানক সময়),
			},
		},
		'Kamchatka' => {
			long => {
				'daylight' => q(পিত্রেপ্যাভলস্ক- ক্যামচ্যাটস্কি গৃষ্মকালীন সময়),
				'generic' => q(পিত্রেপ্যাভলস্ক- ক্যামচ্যাটস্কি সময়),
				'standard' => q(পিত্রেপ্যাভলস্ক- ক্যামচ্যাটস্কি মান সময়),
			},
		},
		'Kazakhstan_Eastern' => {
			long => {
				'standard' => q(পূর্ব কজাকস্তান মানক সময়),
			},
		},
		'Kazakhstan_Western' => {
			long => {
				'standard' => q(পশ্চিম কজাকস্তান মানক সময়),
			},
		},
		'Korea' => {
			long => {
				'daylight' => q(কোরিয়ান দিবালোক সময়),
				'generic' => q(কোরিয়ান সময়),
				'standard' => q(কোরিয়ান মানক সময়),
			},
		},
		'Kosrae' => {
			long => {
				'standard' => q(কসরে সময়),
			},
		},
		'Krasnoyarsk' => {
			long => {
				'daylight' => q(ক্রাসনোয়ার্স্কি গ্রীষ্মকালীন সময়),
				'generic' => q(ক্রাসনোয়ার্স্কি সময়),
				'standard' => q(ক্রাসনোয়ার্স্কি মানক সময়),
			},
		},
		'Kyrgystan' => {
			long => {
				'standard' => q(কিরগিস্তান সময়),
			},
		},
		'Lanka' => {
			long => {
				'standard' => q(লঙ্কা সময়),
			},
		},
		'Line_Islands' => {
			long => {
				'standard' => q(লাইন দ্বীপপুঞ্জ সময়),
			},
		},
		'Lord_Howe' => {
			long => {
				'daylight' => q(লর্ড হাওয়ে দিবালোক মসয়),
				'generic' => q(লর্ড হাওয়ে সময়),
				'standard' => q(লর্ড হাওয়ে মানক মসয়),
			},
		},
		'Macau' => {
			long => {
				'daylight' => q(মাকাও গ্রীষ্মকাল সময়),
				'generic' => q(মাকাও সময়),
				'standard' => q(মাকাও মান সময়),
			},
		},
		'Macquarie' => {
			long => {
				'standard' => q(ম্যাককুরি দ্বীপ সময়),
			},
		},
		'Magadan' => {
			long => {
				'daylight' => q(ম্যাগাডান গ্রীষ্মকালীন সময়),
				'generic' => q(ম্যাগাডান সময়),
				'standard' => q(ম্যাগাডান মানক সময়),
			},
		},
		'Malaysia' => {
			long => {
				'standard' => q(মালয়েশিয়া সময়),
			},
		},
		'Maldives' => {
			long => {
				'standard' => q(মালদ্বীপ সময়),
			},
		},
		'Marquesas' => {
			long => {
				'standard' => q(মার্কেসাস সময়),
			},
		},
		'Marshall_Islands' => {
			long => {
				'standard' => q(মার্শাল দ্বীপপুঞ্জ সময়),
			},
		},
		'Mauritius' => {
			long => {
				'daylight' => q(মরিশাস গ্রীষ্মকালীন সময়),
				'generic' => q(মরিশাস সময়),
				'standard' => q(মরিশাস মানক সময়),
			},
		},
		'Mawson' => {
			long => {
				'standard' => q(মসন সময়),
			},
		},
		'Mongolia' => {
			long => {
				'daylight' => q(উলান বাতোর গ্রীষ্মকালীন সময়),
				'generic' => q(উলান বাতোর সময়),
				'standard' => q(উলান বাতোর মানক সময়),
			},
		},
		'Moscow' => {
			long => {
				'daylight' => q(মস্কো গৃষ্মকালীন সময়),
				'generic' => q(মস্কো সময়),
				'standard' => q(মস্কো মানক সময়),
			},
		},
		'Myanmar' => {
			long => {
				'standard' => q(মায়ানমার সময়),
			},
		},
		'Nauru' => {
			long => {
				'standard' => q(নাউরু সময়),
			},
		},
		'Nepal' => {
			long => {
				'standard' => q(নেপাল সময়),
			},
		},
		'New_Caledonia' => {
			long => {
				'daylight' => q(নিউ ক্যালেডোনিয়া গ্রীষ্মকালীন সময়),
				'generic' => q(নিউ ক্যালেডোনিয়া সময়),
				'standard' => q(নিউ ক্যালেডোনিয়া মানক সময়),
			},
		},
		'New_Zealand' => {
			long => {
				'daylight' => q(নিউজিল্যান্ড দিবালোক সময়),
				'generic' => q(নিউজিল্যান্ড সময়),
				'standard' => q(নিউজিল্যান্ড মানক সময়),
			},
		},
		'Newfoundland' => {
			long => {
				'daylight' => q(নিউফাউন্ডল্যান্ড দিবালোক সময়),
				'generic' => q(নিউফাউন্ডল্যান্ড সময়),
				'standard' => q(নিউফাউন্ডল্যান্ড মানক সময়),
			},
		},
		'Niue' => {
			long => {
				'standard' => q(নিউই সময়),
			},
		},
		'Norfolk' => {
			long => {
				'standard' => q(নরফোক দ্বীপপুঞ্জ সময়),
			},
		},
		'Noronha' => {
			long => {
				'daylight' => q(ফারন্যান্ডো ডে নোরোনহা গৃষ্মকালীন সময়),
				'generic' => q(নোরোনহা সময়),
				'standard' => q(ফারন্যান্ডো ডে নোরোনহা সময়),
			},
		},
		'North_Mariana' => {
			long => {
				'standard' => q(উত্তর মেরিন দ্বীপপুঞ্জ সময়),
			},
		},
		'Novosibirsk' => {
			long => {
				'daylight' => q(নোভোসিবির্স্ক গ্রীষ্মকালীন সময়),
				'generic' => q(নোভোসিবির্স্ক সময়),
				'standard' => q(নোভোসিবির্স্ক মানক সময়),
			},
		},
		'Omsk' => {
			long => {
				'daylight' => q(ওমস্ক গৃষ্মকালীন সময়),
				'generic' => q(ওমস্ক সময়),
				'standard' => q(ওমস্ক মানক সময়),
			},
		},
		'Pacific/Apia' => {
			exemplarCity => q#আপিয়া#,
		},
		'Pacific/Auckland' => {
			exemplarCity => q#অকল্যান্ড#,
		},
		'Pacific/Chatham' => {
			exemplarCity => q#চ্যাঠাম#,
		},
		'Pacific/Easter' => {
			exemplarCity => q#ইস্টার#,
		},
		'Pacific/Efate' => {
			exemplarCity => q#ইফাতে#,
		},
		'Pacific/Enderbury' => {
			exemplarCity => q#এন্ডারবারি#,
		},
		'Pacific/Fakaofo' => {
			exemplarCity => q#ফ্যাকাওফো#,
		},
		'Pacific/Fiji' => {
			exemplarCity => q#ফিজি#,
		},
		'Pacific/Funafuti' => {
			exemplarCity => q#ফুনাফুটি#,
		},
		'Pacific/Galapagos' => {
			exemplarCity => q#গ্যালাপ্যাগোস#,
		},
		'Pacific/Gambier' => {
			exemplarCity => q#গাম্বিয়ের#,
		},
		'Pacific/Guadalcanal' => {
			exemplarCity => q#গোয়াদালকুনাল#,
		},
		'Pacific/Guam' => {
			exemplarCity => q#গুয়াম#,
		},
		'Pacific/Honolulu' => {
			exemplarCity => q#হনোলুলু#,
		},
		'Pacific/Johnston' => {
			exemplarCity => q#জনস্টন#,
		},
		'Pacific/Kiritimati' => {
			exemplarCity => q#কিরিতিমাতি#,
		},
		'Pacific/Kosrae' => {
			exemplarCity => q#কোসরায়#,
		},
		'Pacific/Kwajalein' => {
			exemplarCity => q#কোয়াজালেইন#,
		},
		'Pacific/Majuro' => {
			exemplarCity => q#মাজুরো#,
		},
		'Pacific/Marquesas' => {
			exemplarCity => q#মার্কেসাস#,
		},
		'Pacific/Midway' => {
			exemplarCity => q#মিডওয়ে#,
		},
		'Pacific/Nauru' => {
			exemplarCity => q#নাউরু#,
		},
		'Pacific/Niue' => {
			exemplarCity => q#নিউয়ি#,
		},
		'Pacific/Norfolk' => {
			exemplarCity => q#নরফক#,
		},
		'Pacific/Noumea' => {
			exemplarCity => q#নুমিয়া#,
		},
		'Pacific/Pago_Pago' => {
			exemplarCity => q#প্যাগো প্যাগো#,
		},
		'Pacific/Palau' => {
			exemplarCity => q#পালাউ#,
		},
		'Pacific/Pitcairn' => {
			exemplarCity => q#পিটকেয়ার্ন#,
		},
		'Pacific/Ponape' => {
			exemplarCity => q#পোনাপে#,
		},
		'Pacific/Port_Moresby' => {
			exemplarCity => q#পোর্ট মৌরজবি#,
		},
		'Pacific/Rarotonga' => {
			exemplarCity => q#রারউহতুঙ্গা#,
		},
		'Pacific/Saipan' => {
			exemplarCity => q#সাইপান#,
		},
		'Pacific/Tahiti' => {
			exemplarCity => q#তাহিতি#,
		},
		'Pacific/Tarawa' => {
			exemplarCity => q#টারাওয়া#,
		},
		'Pacific/Tongatapu' => {
			exemplarCity => q#টোঙ্গাটাপু#,
		},
		'Pacific/Truk' => {
			exemplarCity => q#ট্রুক#,
		},
		'Pacific/Wake' => {
			exemplarCity => q#ওয়েক#,
		},
		'Pacific/Wallis' => {
			exemplarCity => q#ওলিস#,
		},
		'Pakistan' => {
			long => {
				'daylight' => q(পাকিস্তান গ্রীষ্মকালীন সময়),
				'generic' => q(পাকিস্তান সময়),
				'standard' => q(পাকিস্তান মানক সময়),
			},
		},
		'Palau' => {
			long => {
				'standard' => q(পালাউ সময়),
			},
		},
		'Papua_New_Guinea' => {
			long => {
				'standard' => q(পাপুয়া নিউ গিনি সময়),
			},
		},
		'Paraguay' => {
			long => {
				'daylight' => q(প্যারাগুয়ে গ্রীষ্মকালীন সময়),
				'generic' => q(প্যারাগুয়ে সময়),
				'standard' => q(প্যারাগুয়ে মানক সময়),
			},
		},
		'Peru' => {
			long => {
				'daylight' => q(পেরু গ্রীষ্মকালীন সময়),
				'generic' => q(পেরু সময়),
				'standard' => q(পেরু মানক সময়),
			},
		},
		'Philippines' => {
			long => {
				'daylight' => q(ফিলিপাইন গ্রীষ্মকালীন সময়),
				'generic' => q(ফিলিপাইন সময়),
				'standard' => q(ফিলিপাইন মানক সময়),
			},
		},
		'Phoenix_Islands' => {
			long => {
				'standard' => q(ফোনিক্স দ্বীপপুঞ্জ সময়),
			},
		},
		'Pierre_Miquelon' => {
			long => {
				'daylight' => q(সেন্ট পিয়ের ও মিকেলন দিবালোক সময়),
				'generic' => q(সেন্ট পিয়ের ও মিকেলন সময়),
				'standard' => q(সেন্ট পিয়ের ও মিকেলন মানক সময়),
			},
		},
		'Pitcairn' => {
			long => {
				'standard' => q(পিটকেয়ার্ন সময়),
			},
		},
		'Ponape' => {
			long => {
				'standard' => q(পোনাপে সময়),
			},
		},
		'Qyzylorda' => {
			long => {
				'daylight' => q(কিজিলোর্ডা গ্রীষ্মকাল সময়),
				'generic' => q(কিজিলোর্ডা সময়),
				'standard' => q(কিজিলোর্ডা মান সময়),
			},
		},
		'Reunion' => {
			long => {
				'standard' => q(রিইউনিয়ন সময়),
			},
		},
		'Rothera' => {
			long => {
				'standard' => q(রথেরা সময়),
			},
		},
		'Sakhalin' => {
			long => {
				'daylight' => q(সাখালিন গ্রীষ্মকালীন সময়),
				'generic' => q(সাখালিন সময়),
				'standard' => q(সাখালিন মানক সময়),
			},
		},
		'Samara' => {
			long => {
				'daylight' => q(সামারা গৃষ্মকালীন সময়),
				'generic' => q(সামারা সময়),
				'standard' => q(সামারা মান সময়),
			},
		},
		'Samoa' => {
			long => {
				'daylight' => q(সামোয়া গৃষ্মকালীন সময়),
				'generic' => q(সামোয়া সময়),
				'standard' => q(সামোয়া মানক সময়),
			},
		},
		'Seychelles' => {
			long => {
				'standard' => q(সেশেলস সময়),
			},
		},
		'Singapore' => {
			long => {
				'standard' => q(সিঙ্গাপুর মানক সময়),
			},
		},
		'Solomon' => {
			long => {
				'standard' => q(সলোমন দ্বীপপুঞ্জ সময়),
			},
		},
		'South_Georgia' => {
			long => {
				'standard' => q(দক্ষিণ জর্জিয়া সময়),
			},
		},
		'Suriname' => {
			long => {
				'standard' => q(সুরিনাম সময়),
			},
		},
		'Syowa' => {
			long => {
				'standard' => q(সায়োওয়া সময়),
			},
		},
		'Tahiti' => {
			long => {
				'standard' => q(তাহিতি সময়),
			},
		},
		'Taipei' => {
			long => {
				'daylight' => q(তাইপেই দিবালোক সময়),
				'generic' => q(তাইপেই সময়),
				'standard' => q(তাইপেই মানক সময়),
			},
		},
		'Tajikistan' => {
			long => {
				'standard' => q(তাজাখাস্তান সময়),
			},
		},
		'Tokelau' => {
			long => {
				'standard' => q(টোকেলাউ সময়),
			},
		},
		'Tonga' => {
			long => {
				'daylight' => q(টোঙ্গা গ্রীষ্মকালীন সময়),
				'generic' => q(টোঙ্গা সময়),
				'standard' => q(টোঙ্গা মানক সময়),
			},
		},
		'Truk' => {
			long => {
				'standard' => q(চুক সময়),
			},
		},
		'Turkmenistan' => {
			long => {
				'daylight' => q(তুর্কমেনিস্তান গ্রীষ্মকালীন সময়),
				'generic' => q(তুর্কমেনিস্তান সময়),
				'standard' => q(তুর্কমেনিস্তান মানক সময়),
			},
		},
		'Tuvalu' => {
			long => {
				'standard' => q(টুভালু সময়),
			},
		},
		'Uruguay' => {
			long => {
				'daylight' => q(উরুগুয়ে গ্রীষ্মকালীন সময়),
				'generic' => q(উরুগুয়ে সময়),
				'standard' => q(উরুগুয়ে মানক সময়),
			},
		},
		'Uzbekistan' => {
			long => {
				'daylight' => q(উজবেকিস্তান গ্রীষ্মকালীন সময়),
				'generic' => q(উজবেকিস্তান সময়),
				'standard' => q(উজবেকিস্তান মানক সময়),
			},
		},
		'Vanuatu' => {
			long => {
				'daylight' => q(ভানুয়াতু গ্রীষ্মকালীন সময়),
				'generic' => q(ভানুয়াতু সময়),
				'standard' => q(ভানুয়াতু মানক সময়),
			},
		},
		'Venezuela' => {
			long => {
				'standard' => q(ভেনেজুয়েলা সময়),
			},
		},
		'Vladivostok' => {
			long => {
				'daylight' => q(ব্লাদিবোস্তোক গ্রীষ্মকালীন সময়),
				'generic' => q(ব্লাদিবোস্তোক সময়),
				'standard' => q(ব্লাদিবোস্তোক মানক সময়),
			},
		},
		'Volgograd' => {
			long => {
				'daylight' => q(ভলগোগ্রাড গ্রীষ্মকালীন সময়),
				'generic' => q(ভলগোগ্রাড সময়),
				'standard' => q(ভলগোগ্রাড মানক সময়),
			},
		},
		'Vostok' => {
			long => {
				'standard' => q(ভস্টক সময়),
			},
		},
		'Wake' => {
			long => {
				'standard' => q(ওয়েক দ্বীপ সময়),
			},
		},
		'Wallis' => {
			long => {
				'standard' => q(ওয়ালিস এবং ফুটুনা সময়),
			},
		},
		'Yakutsk' => {
			long => {
				'daylight' => q(য়াকুতস্ক গ্রীষ্মকালীন সময়),
				'generic' => q(য়াকুতস্ক সময়),
				'standard' => q(য়াকুতস্ক মানক সময়),
			},
		},
		'Yekaterinburg' => {
			long => {
				'daylight' => q(ইয়েকাতেরিনবুর্গ গ্রীষ্মকালীন সময়),
				'generic' => q(ইয়েকাতেরিনবুর্গ সময়),
				'standard' => q(ইয়েকাতেরিনবুর্গ মানক সময়),
			},
		},
	 } }
);
no Moose;
__PACKAGE__->meta->make_immutable;

1;

# vim: tabstop=4
