package Locale::CLDR::Lo v0.25.1;
# This file auto generated from Data\common\main\lo.xml
#	on Sat 10 May 11:35:22 pm GMT
# XML file generated 2014-02-28 23:57:43 -0600 (Fri, 28 Feb 2014)

use v5.10;
use mro 'c3';
use utf8;

use Moose;

extends('Locale::CLDR::Root');
# Need to add code for Key type pattern
sub display_name_pattern {
	my ($self, $name, $territory, $script, $variant) = @_;

	my $display_pattern = '{0} ({1})';
	$display_pattern =~s/\{0\}/$name/g;
	my $subtags = join '{0}, {1}', grep {$_} (
		$territory,
		$script,
		$variant,
	);

	$display_pattern =~s/\{1\}/$subtags/g;
	return $display_pattern;
}

has 'display_name_language' => (
	is			=> 'ro',
	isa			=> 'CodeRef',
	init_arg	=> undef,
	default		=> sub { 
		 sub {
			 my %languages = (
				'aa' => 'ອະຟາ',
 				'ab' => 'ແອບຄາຊຽນ',
 				'ace' => 'ແອັກຊີເນັສ',
 				'ach' => 'ອາໂຄລີ',
 				'ada' => 'ອາແດງມີ',
 				'ady' => 'ເອດີຮິ',
 				'ae' => 'ອາເວັສແຕນ',
 				'af' => 'ອາຟຣິການ',
 				'afh' => 'ແອຟີຮີລີ',
 				'agq' => 'ອາເຮັມ',
 				'ain' => 'ໄອນູ',
 				'ak' => 'ອາການ',
 				'akk' => 'ອັກກາດຽມ',
 				'ale' => 'ອາເລີດ',
 				'alt' => 'ອານໄຕໃຕ້',
 				'am' => 'ອຳຮາຣິກ',
 				'an' => 'ອາຣາໂກເນັດ',
 				'ang' => 'ອັງກິດໂບຮານ',
 				'anp' => 'ແອນຈີກາ',
 				'ar' => 'ອາຣັບ',
 				'ar_001' => 'ອາຣາບິກມາດຕະຖານສະໄໝໃໝ່',
 				'arc' => 'ອາລາມິກ',
 				'arn' => 'ອາຣົວຄານຽນ',
 				'arp' => 'ອາຣາປາໂຮ',
 				'arw' => 'ອາຣາແວກ',
 				'as' => 'ອັສຊຳມີສ',
 				'asa' => 'ອາຊູ',
 				'ast' => 'ອັສຕູຮຽນ',
 				'av' => 'ອາວາຣິກ',
 				'awa' => 'ອາວາຮິ',
 				'ay' => 'ອາຍມາລາ',
 				'az' => 'ອາເຊີໄບຈານິ',
 				'ba' => 'ບາຣກີ',
 				'bal' => 'ບາລູຊີ',
 				'ban' => 'ບາລີເນັດ',
 				'bas' => 'ບາຊາ',
 				'bax' => 'ບາມຸນ',
 				'bbj' => 'ໂຄມາລາ',
 				'be' => 'ເບລາຣັສຊຽນ',
 				'bej' => 'ບີເຈ',
 				'bem' => 'ເບັມບາ',
 				'bez' => 'ບີນາ',
 				'bfd' => 'ບາຟັດ',
 				'bg' => 'ບັງກາຣຽນ',
 				'bho' => 'ໂບພູຣິ',
 				'bi' => 'ບິສລະມາ',
 				'bik' => 'ບີຄອນ',
 				'bin' => 'ບີນີ',
 				'bkm' => 'ກົມ',
 				'bla' => 'ຊິກຊິກາ',
 				'bm' => 'ບາມບາຣາ',
 				'bn' => 'ເບັງກາລີ',
 				'bo' => 'ທິເບທັນ',
 				'br' => 'ເບຣຕັນ',
 				'bra' => 'ບຣາ',
 				'brx' => 'ໂບດູ',
 				'bs' => 'ບອສນຽນ',
 				'bss' => 'ອາຄຸດ',
 				'bua' => 'ບູຣຽດ',
 				'bug' => 'ບູຈີເນັດ',
 				'bum' => 'ບູລູ',
 				'byn' => 'ບລິນ',
 				'byv' => 'ເມດູມບາ',
 				'ca' => 'ຄາຕາລານ',
 				'cad' => 'ແຄດໂດ',
 				'car' => 'ຄາຣິບ',
 				'cay' => 'ຄາຢູກາ',
 				'cch' => 'ອາດແຊມ',
 				'ce' => 'ຊີເຄນ',
 				'ceb' => 'ຊີບູໂນ',
 				'cgg' => 'ຊີກາ',
 				'ch' => 'ຊາມໍໂຣ',
 				'chb' => 'ຊິບຊາ',
 				'chg' => 'ຊາກາໄຕ',
 				'chk' => 'ຊູເກດ',
 				'chm' => 'ມາຣິ',
 				'chn' => 'ຊີນຸກຈາກອນ',
 				'cho' => 'ຊອກຕິວ',
 				'chp' => 'ຊີພິວຢານ',
 				'chr' => 'ຊີໂຣກີ',
 				'chy' => 'ຊີເຢນນີ',
 				'ckb' => 'ໂຊນານີເຄີດີຊ',
 				'co' => 'ຄໍຊິກາ',
 				'cop' => 'ຄອບຕິກ',
 				'cr' => 'ຄີ',
 				'crh' => 'ຄຣີເມນເຕີຄິຊ',
 				'cs' => 'ເຊກ',
 				'csb' => 'ກາຊູບຽນ',
 				'cu' => 'ໂບດສລາວິກ',
 				'cv' => 'ຊູວາຊ',
 				'cy' => 'ເວວ',
 				'da' => 'ແດນິຊ',
 				'dak' => 'ດາໂກຕາ',
 				'dar' => 'ດາກວາ',
 				'dav' => 'ໄຕຕາ',
 				'de' => 'ເຢຍລະມັນ',
 				'de_AT' => 'ອອສຕຣຽນ ເຈີແມນ',
 				'de_CH' => 'ສະວິສ ໄຮ ເຈີແມນ',
 				'del' => 'ເດລາວາ',
 				'den' => 'ຊີເລັບ',
 				'dgr' => 'ໂດກຣິບ',
 				'din' => 'ດິນກາ',
 				'dje' => 'ຊາມາ',
 				'doi' => 'ດອກຣີ',
 				'dsb' => 'ຊໍບຽນຕໍ່ກວ່າ',
 				'dua' => 'ດົວລາ',
 				'dum' => 'ດັກກາງ',
 				'dv' => 'ດີວີຮີ',
 				'dyo' => 'ໂຈລາ-ຝອນຢີ',
 				'dyu' => 'ດູລາ',
 				'dz' => 'ດີຊອງຄາ',
 				'dzg' => 'ດາຊາກາ',
 				'ebu' => 'ເອັມບູ',
 				'ee' => 'ອິວາ',
 				'efi' => 'ອີຟິກ',
 				'egy' => 'ອີຢິບບູຮານ',
 				'eka' => 'ອີກາຈັກ',
 				'el' => 'ກຣີກ',
 				'elx' => 'ອີລາໄມ',
 				'en' => 'ອັງກິດ',
 				'en_AU' => 'ອັງກິດ (ອອສເຕຣລຽນ)',
 				'en_CA' => 'ອັງກິດ (ເຄເນດຽນ)',
 				'en_GB' => 'ອັງກິດ (ບຣິທິຊ)',
 				'en_GB@alt=short' => 'ອັງກິດ (ສະຫະລາດຊະອານາຈັກ)',
 				'en_US' => 'ອັງກິດ (ອາເມລິກັນ)',
 				'en_US@alt=short' => 'ອັງກິດ (ສະຫະລັດອາເມລິກາ)',
 				'enm' => 'ອັງກິດກາງ',
 				'eo' => 'ເອສເປີຣັນໂຕ',
 				'es' => 'ສະແປນນິຊ',
 				'es_419' => 'ລາຕິນ ອາເມຣິກັນ ສະແປນນິຊ',
 				'es_ES' => 'ຢູໂຣປຽນ ສະແປນນິຊ',
 				'es_MX' => 'ເມັກຊິກັນ ສະແປນນິຊ',
 				'et' => 'ເອສໂຕນຽນ',
 				'eu' => 'ບັສກີ',
 				'ewo' => 'ອີວອນດູ',
 				'fa' => 'ເປີຊຽນ',
 				'fan' => 'ແຟງ',
 				'fat' => 'ແຟນຕີ',
 				'ff' => 'ຟູລາ',
 				'fi' => 'ຟິນນິຊ',
 				'fil' => 'ຟີລິປີໂນ',
 				'fj' => 'ຟິຈຽນ',
 				'fo' => 'ຟາໂຣສ',
 				'fon' => 'ຟອນ',
 				'fr' => 'ຝຣັ່ງ',
 				'fr_CA' => 'ເຄເນດຽນ ຝຣັ່ງ',
 				'fr_CH' => 'ສະວິສ ຝຣັ່ງ',
 				'frm' => 'ຟຮັ່ງເສດກາງ',
 				'fro' => 'ຟຮັ່ງເສດໂບຮານ',
 				'frr' => 'ຟຣີຊຽນເໜືອ',
 				'frs' => 'ຟຣີຊຽນຕາເວັນອອກ',
 				'fur' => 'ຟຣີລຽນ',
 				'fy' => 'ເວສເທີນ ຟຣິຊຽນ',
 				'ga' => 'ໄອຣິສ',
 				'gaa' => 'ກາ',
 				'gay' => 'ກາໂຢ',
 				'gba' => 'ບາຍາ',
 				'gd' => 'ສະກັອດເກລິກ',
 				'gez' => 'ກີ',
 				'gil' => 'ກິນເບີເທັດ',
 				'gl' => 'ກາລິຊຽນ',
 				'gmh' => 'ເຢຍລະມັນສູງກາງ',
 				'gn' => 'ກົວຣານີ',
 				'goh' => 'ເຢຍລະມັນສູງໂບຮານ',
 				'gon' => 'ກອນດີ',
 				'gor' => 'ໂກຣອນຕາໂຣ',
 				'got' => 'ກອດຮິກ',
 				'grb' => 'ກຣີໂບ',
 				'grc' => 'ແອນຊຽນກຣີກ',
 				'gsw' => 'ສະວິສ ເຈີແມນ',
 				'gu' => 'ກູຈາຣາຕິ',
 				'guz' => 'ກູຊິ',
 				'gv' => 'ແມນ',
 				'gwi' => 'ວິດອິນ',
 				'ha' => 'ຮໍຊາ',
 				'hai' => 'ໄຮດາ',
 				'haw' => 'ຮາໄວອຽນ',
 				'he' => 'ຮີບຣິວ',
 				'hi' => 'ຮິນດິ',
 				'hil' => 'ຮິຣິໄກນອນ',
 				'hit' => 'ຮິດໄຕ',
 				'hmn' => 'ມອງ',
 				'ho' => 'ຮິຣິໂມຕູ',
 				'hr' => 'ໂຄຣຕຽນ',
 				'hsb' => 'ຊຸບເປີຊໍບຽນ',
 				'ht' => 'ໄຮຕຽນ',
 				'hu' => 'ຮັງກາຣຽນ',
 				'hup' => 'ຮູປາ',
 				'hy' => 'ອາເມນຽນ',
 				'hz' => 'ເຮິຮິໂຣ',
 				'ia' => 'ອິນເຕີລິງລົວ',
 				'iba' => 'ໄອບານ',
 				'ibb' => 'ໄອໄບໄບໂອ',
 				'id' => 'ອິນໂດເນຊຽນ',
 				'ie' => 'ອິນເຕີລິງກຣີ',
 				'ig' => 'ອິກໂບ',
 				'ii' => 'ເຊສວຍຢີ',
 				'ik' => 'ອິນນູປຽກ',
 				'ilo' => 'ໄອໂລໂກ',
 				'inh' => 'ອິນກັຊ',
 				'io' => 'ອີໂດ',
 				'is' => 'ໄອສແລນດິກ',
 				'it' => 'ອິຕາລຽນ',
 				'iu' => 'ອິນນຸກຕິຕັດ',
 				'ja' => 'ຍີ່ປຸ່ນ',
 				'jbo' => 'ໂລບບັນ',
 				'jmc' => 'ມາແຊມ',
 				'jpr' => 'ຈູແດວ-ເພີຊຽນ',
 				'jrb' => 'ຈູແດວ-ອາລາບິກ',
 				'jv' => 'ຈາແວນີສ',
 				'ka' => 'ຈໍຈຽນ',
 				'kaa' => 'ກາຣາ-ການປາກ',
 				'kab' => 'ກາໄບຣ',
 				'kac' => 'ກາຊິນ',
 				'kaj' => 'ຈຣູ',
 				'kam' => 'ກາມບາ',
 				'kaw' => 'ກະວີ',
 				'kbd' => 'ກາບາດຽນ',
 				'kbl' => 'ຄາແນມບູ',
 				'kcg' => 'ຕີບ',
 				'kde' => 'ມາຄອນເດ',
 				'kea' => 'ຄາເວີເດຍນູ',
 				'kfo' => 'ໂຄໂລ',
 				'kg' => 'ຄອງໂກ',
 				'kha' => 'ຄາສິ',
 				'kho' => 'ໂຄຕັນ',
 				'khq' => 'ຄອຍຣາຊິນີ',
 				'ki' => 'ຄິຄູຢຸ',
 				'kj' => 'ກວນຍາມາ',
 				'kk' => 'ຄາຊັກ',
 				'kkj' => 'ຄາໂກ',
 				'kl' => 'ກຣີນແລນລິດ',
 				'kln' => 'ຄາເລັນຈິນ',
 				'km' => 'ຂະເໝນ',
 				'kmb' => 'ຄິມບັນດູ',
 				'kn' => 'ຄັນນາດາ',
 				'ko' => 'ເກົາຫລີ',
 				'kok' => 'ກອນການີ',
 				'kos' => 'ຄູສໄລ',
 				'kpe' => 'ກາແປຣ',
 				'kr' => 'ຄານຸລິ',
 				'krc' => 'ກາຣາໄຊ-ບານກາ',
 				'krl' => 'ກາເຣລຽນ',
 				'kru' => 'ກູຣູກ',
 				'ks' => 'ຄັດຊະມີຣີ',
 				'ksb' => 'ຊຳບາລ້າ',
 				'ksf' => 'ບາເຝຍ',
 				'ksh' => 'ໂຄລອກນຽນ',
 				'ku' => 'ເຄີດິສ',
 				'kum' => 'ຄູມີກ',
 				'kut' => 'ຄູເທໄນ',
 				'kv' => 'ໂຄມິ',
 				'kw' => 'ຄໍນິຊ',
 				'ky' => 'ເກຍກີສ',
 				'la' => 'ລາຕິນ',
 				'lad' => 'ລາດີໂນ',
 				'lag' => 'ແລນກິ',
 				'lah' => 'ລານດາ',
 				'lam' => 'ແລມບາ',
 				'lb' => 'ລັກເຊມບວກກິຊ',
 				'lez' => 'ລີຊຽນ',
 				'lg' => 'ແກນດາ',
 				'li' => 'ລິມເບີກີຊ',
 				'ln' => 'ລິງກາລາ',
 				'lo' => 'ລາວ',
 				'lol' => 'ແມັງໂກ້',
 				'loz' => 'ໂລຊິ',
 				'lt' => 'ລີທົວນຽນ',
 				'lu' => 'ລູບາ-ຄາຕັງກາ',
 				'lua' => 'ລູບາ-ລູລົວ',
 				'lui' => 'ລູເຊໂນ',
 				'lun' => 'ລຸນດາ',
 				'luo' => 'ລົວ',
 				'lus' => 'ລູໄຊ',
 				'luy' => 'ລູໄຍ',
 				'lv' => 'ລັດວຽນ',
 				'mad' => 'ມາດູລາ',
 				'maf' => 'ມາຟາ',
 				'mag' => 'ມາກາຮິ',
 				'mai' => 'ໄມທີລິ',
 				'mak' => 'ມາກາຊາຣ',
 				'man' => 'ມັນດິງກາ',
 				'mas' => 'ມາໄຊ',
 				'mde' => 'ມາບາ',
 				'mdf' => 'ມອກຊາ',
 				'mdr' => 'ມານດາຣ',
 				'men' => 'ເມນເດ',
 				'mer' => 'ເມລູ',
 				'mfe' => 'ມໍລິສເຍນ',
 				'mg' => 'ມາລາກາສຊີ',
 				'mga' => 'ໄອລິດກາງ',
 				'mgh' => 'ມາຄູວາ-ມີດໂຕ',
 				'mh' => 'ມາຊານເລັດ',
 				'mi' => 'ມາວຣິ',
 				'mic' => 'ມິກແມກ',
 				'min' => 'ທີແນງກາບູ',
 				'mk' => 'ແມັກເຊໂດນຽນ',
 				'ml' => 'ມາເລອາລຳ',
 				'mn' => 'ມ່ອງໂກເລ້ຍ',
 				'mnc' => 'ແມນຈູ',
 				'mni' => 'ມານີພູຣິ',
 				'moh' => 'ໂມຫາ',
 				'mos' => 'ມອສຊີ',
 				'mr' => 'ມາຣາທິ',
 				'ms' => 'ມາເລ',
 				'mt' => 'ມອລທີສ',
 				'mua' => 'ມັນດັງ',
 				'mul' => 'ຫລາຍພາສາ',
 				'mus' => 'ຄຣິກ',
 				'mwl' => 'ມີລັນດາ',
 				'mwr' => 'ມາວາຣິ',
 				'my' => 'ມຽນມາ',
 				'mye' => 'ມໍຢິນ',
 				'myv' => 'ເອີຍາ',
 				'na' => 'ນາຢູລູ',
 				'nap' => 'ນາໂປລີ',
 				'naq' => 'ນາມາ',
 				'nb' => 'ນໍເວຈຽນ ບັອກມອລ',
 				'nd' => 'ເອັນເດເບເລເໜືອ',
 				'nds' => 'ເຢຍລະມັນຕ່ຳ ແຊກຊອນຕໍ່ຳ',
 				'ne' => 'ເນປາລີ',
 				'new' => 'ນີວາຣິ',
 				'ng' => 'ເອັນດອງກາ',
 				'nia' => 'ນີ່ອັດ',
 				'niu' => 'ນີ່ອູ',
 				'nl' => 'ດັຊ',
 				'nl_BE' => 'ຟລີມິຊ',
 				'nmg' => 'ກວາຊີໂອ',
 				'nn' => 'ນໍເວຈຽນ ນີນອກ',
 				'nnh' => 'ຈີ່ມບູນ',
 				'no' => 'ນໍເວຍ',
 				'nog' => 'ນໍໄກ',
 				'non' => 'ນໍໂບຮານ',
 				'nqo' => 'ເອັນໂກ',
 				'nr' => 'ນີບີລີໃຕ້',
 				'nso' => 'ໂຊໂທເໜືອ',
 				'nus' => 'ເນີ',
 				'nv' => 'ນາວາໂຈ',
 				'nwc' => 'ເນວາດັ້ງເດີມ',
 				'ny' => 'ນານຈາ',
 				'nym' => 'ນາມວີຊິ',
 				'nyn' => 'ນານຄອນ',
 				'nyo' => 'ໂນໂຣ',
 				'nzi' => 'ນິມາ',
 				'oc' => 'ອັອກຊີຕານ',
 				'oj' => 'ໂອຈິບວາ',
 				'om' => 'ໂອໂລໂມ',
 				'or' => 'ໂອຣິຢາ',
 				'os' => 'ອອດເຊຕິກ',
 				'osa' => 'ໂອແຊກ',
 				'ota' => 'ຕູກີອອດໂຕມັນ',
 				'pa' => 'ປັນຈາບີ',
 				'pag' => 'ປານກາຊີມານ',
 				'pal' => 'ພາລາວີ',
 				'pam' => 'ປາມປານກາ',
 				'pap' => 'ປາມເປຍເມັນໂທ',
 				'pau' => 'ປາລົວອານ',
 				'peo' => 'ເປີເຊຍໂບຮານ',
 				'phn' => 'ຟີນີເຊຍ',
 				'pi' => 'ປາລີ',
 				'pl' => 'ໂປລິຊ',
 				'pon' => 'ພອນເພ',
 				'pro' => 'ໂປວອງຊານໂບຮານ',
 				'ps' => 'ປາສໂຕ',
 				'pt' => 'ປໍຕູກີສ',
 				'pt_BR' => 'ບຣາຊິລຽນ ປໍຕູກີສ',
 				'pt_PT' => 'ຢູໂຣປຽນ ປໍຕູກີສ',
 				'qu' => 'ຄີຊົວ',
 				'raj' => 'ຣາຈັສທານິ',
 				'rap' => 'ຣາປານຸຍ',
 				'rar' => 'ຣາໂຣທອນການ',
 				'rm' => 'ໂຣແມນ',
 				'rn' => 'ບຸລຸນດີ',
 				'ro' => 'ໂຣແມນຽນ',
 				'ro_MD' => 'ໂມດາເວຍ',
 				'rof' => 'ຣົມໂບ',
 				'rom' => 'ໂຣເມນີ',
 				'root' => 'ລູດ',
 				'ru' => 'ຣັດຊຽນ',
 				'rup' => 'ອາໂຣມານຽນ',
 				'rw' => 'ຄິນຢາວານດາ',
 				'rwk' => 'ອາຣວາ',
 				'sa' => 'ສັນສະກິດ',
 				'sad' => 'ຊັນດາວ',
 				'sah' => 'ຊາກາ',
 				'sam' => 'ສາມາຣິແຕນ-',
 				'saq' => 'ຊຳບູລູ',
 				'sas' => 'ຊາຊັກ',
 				'sat' => 'ຊານທາລິ',
 				'sba' => 'ກຳເບ',
 				'sbp' => 'ຊານກູ',
 				'sc' => 'ສາດີນຽນ',
 				'scn' => 'ຊີຊິລີນ',
 				'sco' => 'ສກອດ',
 				'sd' => 'ສິນທິ',
 				'se' => 'ຊາມິເໜືອ',
 				'see' => 'ຊີນີກາ',
 				'seh' => 'ຊີນາ',
 				'sel' => 'ເຊນຄັບ',
 				'ses' => 'ໂຄຣຍລາໂບໂລເຊນນິ',
 				'sg' => 'ແຊງໂກ',
 				'sga' => 'ອີຣິຊເກົ່າ',
 				'sh' => 'ເຊີໂບ-ໂກເຊຍ',
 				'shi' => 'ທາເຊວຫິດ',
 				'shn' => 'ໄທໃຫ່ຍ',
 				'shu' => 'ອາລັບ-ຊາດ',
 				'si' => 'ສິນຫາລາ',
 				'sid' => 'ຊິດາໂມ',
 				'sk' => 'ສະໂລແວັກ',
 				'sl' => 'ສະໂລເວນຽນ',
 				'sm' => 'ຊາມົວ',
 				'sma' => 'ຊາມິໃຕ້',
 				'smj' => 'ລຸນຊາມິ',
 				'smn' => 'ອີນາຣິຊາມິ',
 				'sms' => 'ສກອດຊາມິ',
 				'sn' => 'ໂຊຣນາ',
 				'snk' => 'ໂຊນິນກີ',
 				'so' => 'ໂຊມາລີ',
 				'sog' => 'ຊອກດິນ',
 				'sq' => 'ອານບານຽນ',
 				'sr' => 'ເຊີບຽນ',
 				'srn' => 'ສຣານນານຕອນໂກ',
 				'srr' => 'ເຊເລີ',
 				'ss' => 'ຊຣາຕິ',
 				'ssy' => 'ຊາໂຮ',
 				'st' => 'ໂຊໂທໃຕ້',
 				'su' => 'ຊຸນແດນນີສ',
 				'suk' => 'ຊູຄູມ້າ',
 				'sus' => 'ຊູຊູ',
 				'sux' => 'ຊູເມີເລຍ',
 				'sv' => 'ສະວີດິຊ',
 				'sw' => 'ຊວາຮີລິ',
 				'swb' => 'ໂຄໂນຣຽນ',
 				'swc' => 'ຊາວາຮີລີ-ຄອງໂກ',
 				'syc' => 'ຊີເລຍແບບດັ້ງເດີມ',
 				'syr' => 'ຊີເລຍ',
 				'ta' => 'ທາມິວ',
 				'te' => 'ເຕລູກູ',
 				'tem' => 'ທີມເນ',
 				'teo' => 'ເຕໂຊ',
 				'ter' => 'ເຕເລໂນ',
 				'tet' => 'ເຕຕູມ',
 				'tg' => 'ທາຈິກ',
 				'th' => 'ໄທ',
 				'ti' => 'ຕິກຣິນຢາ',
 				'tig' => 'ໄທກຣີ',
 				'tiv' => 'ຕີວ',
 				'tk' => 'ເທີກເມັນ',
 				'tkl' => 'ໂຕເກເລົາ',
 				'tl' => 'ຕາກາລອກ',
 				'tlh' => 'ຄຣິງກອນ',
 				'tli' => 'ທລີງກິດ',
 				'tmh' => 'ທາມາກເຊກ',
 				'tn' => 'ເຕສະວານາ',
 				'to' => 'ທອງກັນ',
 				'tog' => 'ນາຍອາຊາຕອງກາ',
 				'tpi' => 'ທອກພີຊິນ',
 				'tr' => 'ເທີຄິຊ',
 				'trv' => 'ຕາໂລໂກ',
 				'ts' => 'ເຕຊອງກາ',
 				'tsi' => 'ຊີມຊີແອນ',
 				'tt' => 'ທາທາ',
 				'tum' => 'ຕຳບູກາ',
 				'tvl' => 'ຕູວາລູ',
 				'tw' => 'ທວີ',
 				'twq' => 'ຕາຊາວາ',
 				'ty' => 'ຕາຮີຕຽນ',
 				'tyv' => 'ຕູວີນຽນ',
 				'tzm' => 'ເບີເບີຣ-ໂມລະໂຄກາງ',
 				'udm' => 'ອຸດມັດ',
 				'ug' => 'ອຸຍເຄີ',
 				'uga' => 'ຢູກາລິກ',
 				'uk' => 'ຢູເຄຣນຽນ',
 				'umb' => 'ອຳບັນດູ',
 				'und' => 'ບໍ່ສາມາດລະບຸພາສາ',
 				'ur' => 'ອູຣະດູ',
 				'uz' => 'ອຸສເບກ',
 				'vai' => 'ໄວ',
 				've' => 'ເວນດາ',
 				'vi' => 'ຫວຽດນາມ',
 				'vo' => 'ໂວລາພັກ',
 				'vot' => 'ໂວຕິກ',
 				'vun' => 'ວັນໂຈ',
 				'wa' => 'ວໍລູມ',
 				'wae' => 'ວາເຊີ',
 				'wal' => 'ວາລາໂມ',
 				'war' => 'ວາເລ',
 				'was' => 'ວາໂຊ',
 				'wo' => 'ວໍລອບ',
 				'xal' => 'ການມິກ',
 				'xh' => 'ໂຮຊາ',
 				'xog' => 'ໂຊກາ',
 				'yao' => 'ເຢົ້າ',
 				'yap' => 'ຢັບ',
 				'yav' => 'ແຍງເບນ',
 				'ybb' => 'ແຢມບາ',
 				'yi' => 'ຢິວ',
 				'yo' => 'ໂຢຣູບາ',
 				'yue' => 'ກວາງຕຸ້ງ',
 				'za' => 'ຊວາງ',
 				'zap' => 'ຊາໂປແຕບ',
 				'zbl' => 'ສັນຍາລັກບລີຊິມ',
 				'zen' => 'ເຊນາກາ',
 				'zgh' => 'ໂມຣັອກແຄນ ທາມາຊີກ ມາດຕະຖານ',
 				'zh' => 'ຈີນ',
 				'zh_Hans' => 'ຈີນແບບຮຽບງ່າຍ',
 				'zh_Hant' => 'ຈີນແບບດັ້ງເດີມ',
 				'zu' => 'ຊູລູ',
 				'zun' => 'ຊູນີ',
 				'zxx' => 'ບໍ່ມີເນື້ອຫາພາສາ',
 				'zza' => 'ຊາຊາ',

			);
			if (@_) {
				return $languages{$_[0]};
			}
			return \%languages;
		}
	},
);

has 'display_name_script' => (
	is			=> 'ro',
	isa			=> 'CodeRef',
	init_arg	=> undef,
	default		=> sub {
		sub {
			my %scripts = (
			'Afak' => 'ອັບຟາກາ',
 			'Arab' => 'ອາຣາບິກ',
 			'Armi' => 'ອິມພີຮຽນ ອາເມອິກ',
 			'Armn' => 'ອາເມນຽນ',
 			'Avst' => 'ອະເວສຕະ',
 			'Bali' => 'ບາລີ',
 			'Bamu' => 'ບາມູມ',
 			'Bass' => 'ບັດຊາ',
 			'Batk' => 'ບາຕັກ',
 			'Beng' => 'ເບັງກາລິ',
 			'Blis' => 'ບລິກຊິມໂບລສ',
 			'Bopo' => 'ຈູ້ອິນ',
 			'Brah' => 'ພຮາຫມີ',
 			'Brai' => 'ເບຣວ',
 			'Bugi' => 'ບູກິສ',
 			'Buhd' => 'ບູຮິດ',
 			'Cakm' => 'ຊາກມາ',
 			'Cans' => 'ສັນຍາລັກຊົນເຜົ່າພື້ນເມືອງແຄນນາດາ',
 			'Cari' => 'ຄາເຮຍ',
 			'Cham' => 'ຈາມ',
 			'Cher' => 'ເຊໂຮກີ',
 			'Cirt' => 'ເຊີຮ',
 			'Copt' => 'ຄອບຕິກ',
 			'Cprt' => 'ໄຊເປຍ',
 			'Cyrl' => 'ຊີຣິວລິກ',
 			'Cyrs' => 'ເຊຮັດສລາ ໂວນິກຊີຮິກລິກໂບຮານ',
 			'Deva' => 'ດີວານາກາຣີ',
 			'Dsrt' => 'ເດເຊເຮ',
 			'Dupl' => 'ຊົວເລດັບໂລຍັນ',
 			'Egyd' => 'ດີໂມຕິກອີຍິບ',
 			'Egyh' => 'ເຮຍຮາຕິກອີຍິບ',
 			'Egyp' => 'ເຮຍໂຮກລິຟອີຍິບ',
 			'Ethi' => 'ອີທິໂອປິກ',
 			'Geok' => 'ຄອດຊູຮີຈໍເຈຍ',
 			'Geor' => 'ຈໍຈຽນ',
 			'Glag' => 'ກລາໂກລິຕິກ',
 			'Goth' => 'ໂກຮິກ',
 			'Gran' => 'ເຄນທາ',
 			'Grek' => 'ກຣີກ',
 			'Gujr' => 'ຈູຈາຣາທີ',
 			'Guru' => 'ກົວມູຄີ',
 			'Hang' => 'ຮັນກູນ',
 			'Hani' => 'ຮານ',
 			'Hano' => 'ຮານູໂນໂອ',
 			'Hans' => 'ແບບຮຽບງ່າຍ',
 			'Hans@alt=stand-alone' => 'ຈີນ (ແບບງ່າຍ)',
 			'Hant' => 'ແບບດັ້ງເດີມ',
 			'Hant@alt=stand-alone' => 'ຈີນ (ດັ້ງເດີມ)',
 			'Hebr' => 'ຮີບຣິວ',
 			'Hira' => 'ຮິຣາການາ',
 			'Hluw' => 'ອັກລຮະອານາໂຕເລຍ',
 			'Hmng' => 'ປາເຮາເມັງ',
 			'Hrkt' => 'ຄະຕະກະນະຫຮືຮີຮະງະນະ',
 			'Hung' => 'ຮັງກາຮີໂບຮານ',
 			'Inds' => 'ອິນດັດ',
 			'Ital' => 'ອີຕາລີໂບຮານ',
 			'Java' => 'ຈາວາ',
 			'Jpan' => 'ຍີ່ປຸ່ນ',
 			'Jurc' => 'ຈູຮເຊັນ',
 			'Kali' => 'ຄຍາ',
 			'Kana' => 'ຄາຕະການາ',
 			'Khar' => 'ຂໍໂຮກສີ',
 			'Khmr' => 'ຂະແມ',
 			'Khoj' => 'ຄໍຈຄີ',
 			'Knda' => 'ແຄນາດາ',
 			'Kore' => 'ເກົາຫຼີ',
 			'Kpel' => 'ເປລເລ',
 			'Kthi' => 'ກາຍຕິ',
 			'Lana' => 'ລ້ານນາ',
 			'Laoo' => 'ລາວ',
 			'Latf' => 'ລາຕິນ-ຟຮັ່ງເຕຣ',
 			'Latg' => 'ລາຕິນ-ແກລິກ',
 			'Latn' => 'ລາຕິນ',
 			'Lepc' => 'ເລຊາ',
 			'Limb' => 'ລິມບູ',
 			'Lina' => 'ລີເນຍ',
 			'Linb' => 'ລີເນຍຣ',
 			'Lisu' => 'ເຟຣເຊຮ',
 			'Loma' => 'ໂລມາ',
 			'Lyci' => 'ໄລເຊຍ',
 			'Lydi' => 'ລີເດຍ',
 			'Mand' => 'ແມນດຽນ',
 			'Mani' => 'ມານິແຊນ',
 			'Maya' => 'ມາຍາໄຮໂຮກລິບ',
 			'Mend' => 'ເມນເດ',
 			'Merc' => 'ເຄເລີຊີເມໂຮອິຕິກ',
 			'Mero' => 'ເມໂຮຕິກ',
 			'Mlym' => 'ມາເລອາລຳ',
 			'Mong' => 'ມົງໂກລຽນ',
 			'Moon' => 'ມູນ',
 			'Mroo' => 'ເມໂຮ',
 			'Mtei' => 'ເມເທມາເຍກ',
 			'Mymr' => 'ມຽນມາ',
 			'Narb' => 'ອາຮະເບຍເໜືອໂບຮານ',
 			'Nbat' => 'ນາບາທາທຽນ',
 			'Nkgb' => 'ກີບາ-ນາຊີ',
 			'Nkoo' => 'ເອັນໂກ',
 			'Nshu' => 'ນຸຊຸ',
 			'Ogam' => 'ອອກຄອນ',
 			'Olck' => 'ໂອຊິກິ',
 			'Orkh' => 'ອອກສມັນຍາ',
 			'Orya' => 'ໂອຣິຢາ',
 			'Palm' => 'ພາລໄມຮິນ',
 			'Perm' => 'ເພີມີໂບຮານ',
 			'Phag' => 'ຟາກສ-ປາ',
 			'Phli' => 'ປະຫລາວີອິນສຄິບຊັນແນລ',
 			'Phlp' => 'ປະຫລາວີຊອດເຕຮ໌',
 			'Phlv' => 'ປະຫລາວີບຸກ',
 			'Phnx' => 'ຟີນິເຊຍ',
 			'Plrd' => 'ສັດຕະສາດພໍຮລາ',
 			'Prti' => 'ພາຮ໌ເທຍອິນສຄຮິປຊັນແນລ',
 			'Rjng' => 'ເຮຈັງ',
 			'Roro' => 'ຮອງໂກຮອງໂກ',
 			'Runr' => 'ຮູນິກ',
 			'Samr' => 'ຊາມາເລຍ',
 			'Sara' => 'ຊາຮາຕິ',
 			'Sarb' => 'ອາລະເບຍໃຕ້ໂບຮານ',
 			'Saur' => 'ໂສຮັດຕຣະ',
 			'Sgnw' => 'ໄຊນ໌ໄຮຕີ້ງ',
 			'Shaw' => 'ຊອວຽນ',
 			'Shrd' => 'ຊາຮາດາ',
 			'Sind' => 'ດຸດາວາດີ',
 			'Sinh' => 'ສິນຫາລາ',
 			'Sora' => 'ໂສຮາສົມເປັງ',
 			'Sund' => 'ຊຸນດາ',
 			'Sylo' => 'ຊີໂລຕິນາກຣີ',
 			'Syrc' => 'ຊີເຮຍ',
 			'Syre' => 'ຊີເຮຍເອສທຮານຈີໂລ',
 			'Syrj' => 'ຊີເຮຍຕາເວັນຕົກ',
 			'Syrn' => 'ຊີເຮຍຕາເວັນອອກ',
 			'Tagb' => 'ຕັກບັນວາ',
 			'Takr' => 'ທາຄຮີ',
 			'Tale' => 'ໄທເລ',
 			'Talu' => 'ໄທລື້ໃໝ່',
 			'Taml' => 'ທາມິວ',
 			'Tang' => 'ຕັນກັນ',
 			'Tavt' => 'ໄທຫວຽດ',
 			'Telu' => 'ເຕລູກູ',
 			'Teng' => 'ເທງກວາຮ',
 			'Tfng' => 'ທີຟີນາກ',
 			'Tglg' => 'ຕາກາລອກ',
 			'Thaa' => 'ທານາ',
 			'Thai' => 'ໄທ',
 			'Tibt' => 'ທິເບທັນ',
 			'Tirh' => 'ເທຮຸທາ',
 			'Ugar' => 'ຍູກາຮິດ',
 			'Vaii' => 'ໄວ',
 			'Visp' => 'ຄຳເວົ້າທີ່ເບີ່ງເຫັນໄດ້',
 			'Wara' => 'ວາຮັງກສິຕິ',
 			'Wole' => 'ໂອລີເອ',
 			'Xpeo' => 'ເປຮເຊຍໂບຮານ',
 			'Xsux' => 'ອັກສອນຮູບປລີ່ມສຸເມເຮຍ-ອັດຄາເດຍ',
 			'Yiii' => 'ຍີ',
 			'Zinh' => 'ອິນເຮຮິດ',
 			'Zmth' => 'ເຄື່ອງໝາຍທາງຄະນິດສາດ',
 			'Zsym' => 'ສັນຍາລັກ',
 			'Zxxx' => 'ບໍ່ມີພາສາຂຽນ',
 			'Zyyy' => 'ສາມັນ',
 			'Zzzz' => 'ການຂຽນທີ່ບໍ່ຮູ້ຈັກ',

			);
			if ( @_ ) {
				return $scripts{$_[0]};
			}
			return \%scripts;
		}
	}
);

has 'display_name_territory' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'001' => 'ໂລກ',
 			'002' => 'ອາຟຣິກາ',
 			'003' => 'ອາເມລິກາເໜືອ',
 			'005' => 'ອາເມລິກາໃຕ້',
 			'009' => 'ໂອຊີເນຍ',
 			'011' => 'ອາຟຣິກາຕາເວັນຕົກ',
 			'013' => 'ອາເມລິກາກາງ',
 			'014' => 'ອາຟຣິກາຕາເວັນອອກ',
 			'015' => 'ອາຟຣິກາເໜືອ',
 			'017' => 'ອາຟຣິກາກາງ',
 			'018' => 'ອາຟຣິກາໃຕ້',
 			'019' => 'ອາເມຣິກາ',
 			'021' => 'ອາເມລິກາເໜືອສຸດ',
 			'029' => 'ຄາຣິບບຽນ',
 			'030' => 'ເອເຊຍຕາເວັນອອກ',
 			'034' => 'ເອເຊຍໃຕ້',
 			'035' => 'ເອເຊຍຕາເວັນອອກສ່ຽງໃຕ້',
 			'039' => 'ຢູໂຣບໃຕ້',
 			'053' => 'ອອສເຕຣເລເຊຍ',
 			'054' => 'ເມລານີເຊຍ',
 			'057' => 'ເຂດໄມໂຄຣເນຊຽນ',
 			'061' => 'ໂພລີນີເຊຍ',
 			'142' => 'ເອເຊຍ',
 			'143' => 'ເອເຊຍກາງ',
 			'145' => 'ເອເຊຍຕາເວັນຕົກ',
 			'150' => 'ຢູໂຣບ',
 			'151' => 'ຢູໂຣບຕາເວັນອອກ',
 			'154' => 'ຢູໂຣບເໜືອ',
 			'155' => 'ຢູໂຣບຕາເວັນຕົກ',
 			'419' => 'ອາເມລິກາ ລາຕິນ',
 			'AC' => 'ເກາະອາເຊນຊັນ',
 			'AD' => 'ອັນດໍຣາ',
 			'AE' => 'ສະຫະລັດອາຫຣັບເອມິເຣດ',
 			'AF' => 'ອາຟການິສຖານ',
 			'AG' => 'ອາທິກົວ ບາບູດາ',
 			'AI' => 'ແອນກຸຍລາ',
 			'AL' => 'ແອວເບເນຍ',
 			'AM' => 'ອາມີເນຍ',
 			'AN' => 'ເນເທີແລນແອນເທິນ',
 			'AO' => 'ອັນໂກລາ',
 			'AQ' => 'ແອນຕາດຕິກາ',
 			'AR' => 'ອາເຈນທິນາ',
 			'AS' => 'ອາເມຣິກາ ຊາມົວ',
 			'AT' => 'ອອສເທຣຍ',
 			'AU' => 'ອອສເຕຣເລຍ',
 			'AW' => 'ອໍຣູບາ',
 			'AX' => 'ຫມູ່ເກາະໂອລັນ',
 			'AZ' => 'ອາເຊີໄບຈານ',
 			'BA' => 'ບອດສະເນຍ ແລະ ແຮສໂກວີນາ',
 			'BB' => 'ບາບາໂດສ',
 			'BD' => 'ບັງກະລາເທດ',
 			'BE' => 'ເບວຢຽມ',
 			'BF' => 'ເບີກິນາ ຟາໂຊ',
 			'BG' => 'ບັງກາເຣຍ',
 			'BH' => 'ບາເຣນ',
 			'BI' => 'ບູຣຸນດິ',
 			'BJ' => 'ເບນິນ',
 			'BL' => 'ເຊນ ບາເທເລມີ',
 			'BM' => 'ເບີມິວດາ',
 			'BN' => 'ບຣູໄນ',
 			'BO' => 'ໂບລິເວຍ',
 			'BQ' => 'ຄາຣິບບຽນ ເນເທີແລນ',
 			'BR' => 'ບຣາຊິວ',
 			'BS' => 'ບາຮາມາສ',
 			'BT' => 'ພູຖານ',
 			'BV' => 'ເກາະບູເວດ',
 			'BW' => 'ບອດສະວານາ',
 			'BY' => 'ເບວບາຣຸສ',
 			'BZ' => 'ເບລີຊ',
 			'CA' => 'ແຄນາດາ',
 			'CC' => 'ຫມູ່ເກາະໂກໂກສ',
 			'CD' => 'ຄອງໂກ - ຄິນຊາຊາ',
 			'CD@alt=variant' => 'ຄອງໂກ (ສາທາລະນະລັດປະຊາທິປະໄຕ)',
 			'CF' => 'ສາທາລະນະລັດອາຟຣິກາກາງ',
 			'CG' => 'ຄອງໂກ - ບຣາຊາວິວ',
 			'CG@alt=variant' => 'ສາທາລະນະລັດຄອງໂກ',
 			'CH' => 'ສະວິດເຊີແລນ',
 			'CI' => 'ໂຄຕີ ວົວ',
 			'CI@alt=variant' => 'ໄອໂວຣີ ໂຄທ',
 			'CK' => 'ຫມູ່ເກາະຄູກ',
 			'CL' => 'ຊິລີ',
 			'CM' => 'ຄາເມຣູນ',
 			'CN' => 'ຈີນ',
 			'CO' => 'ໂຄລົມເບຍ',
 			'CP' => 'ເກາະຄລິບເປີຕັນ',
 			'CR' => 'ໂຄສຕາ ຣິກາ',
 			'CU' => 'ຄິວບາ',
 			'CV' => 'ເຄບ ເວີດ',
 			'CW' => 'ຄູຣາຊາວ',
 			'CX' => 'ເກາະຄຣິສມາດ',
 			'CY' => 'ໄຊປຣັສ',
 			'CZ' => 'ສາທາລະນະລັດເຊກ',
 			'DE' => 'ເຢຍລະມັນ',
 			'DG' => 'ດິເອໂກ ກາເຊຍ',
 			'DJ' => 'ຈິບູຕິ',
 			'DK' => 'ເດນມາກ',
 			'DM' => 'ໂດມີນິຄາ',
 			'DO' => 'ສາທາລະນະລັດ ໂດມິນິກັນ',
 			'DZ' => 'ອັລຈິເຣຍ',
 			'EA' => 'ເຊວຕາ ແລະເມລິນລາ',
 			'EC' => 'ເອກກວາດໍ',
 			'EE' => 'ເອສໂຕເນຍ',
 			'EG' => 'ອີຢິບ',
 			'EH' => 'ຊາຮາຣາຕາເວັນຕົກ',
 			'ER' => 'ເອຣິເທຣຍ',
 			'ES' => 'ສະເປນ',
 			'ET' => 'ອີທິໂອເປຍ',
 			'EU' => 'ສະຫະພາບຢູໂຣບ',
 			'FI' => 'ຟິນແລນ',
 			'FJ' => 'ຟິຈິ',
 			'FK' => 'ຫມູ່ເກາະຟອກແລນ',
 			'FK@alt=variant' => 'ໝູ່ເກາະຟອກແລນ (ອິສລາສ ມາວິນນາສ)',
 			'FM' => 'ໄມໂຄຣນີເຊຍ',
 			'FO' => 'ຫມູ່ເກາະແຟໂຣ',
 			'FR' => 'ຝຣັ່ງ',
 			'GA' => 'ກາບອນ',
 			'GB' => 'ສະຫະລາດຊະອະນາຈັກ',
 			'GB@alt=short' => 'ສະຫະລາດຊະອະນາຈັກຯ',
 			'GD' => 'ເກຣເນດາ',
 			'GE' => 'ຈໍເຈຍ',
 			'GF' => 'ເຟຣນຊ ກຸຍອານາ',
 			'GG' => 'ເກີນຊີ',
 			'GH' => 'ການ່າ',
 			'GI' => 'ຈິບບຣອນທາ',
 			'GL' => 'ກຣີນແລນ',
 			'GM' => 'ສາທາລະນະລັດແກມເບຍ',
 			'GN' => 'ກິນີ',
 			'GP' => 'ກົວດາລູບ',
 			'GQ' => 'ອີຄົວໂຕຣຽວ ກີນີ',
 			'GR' => 'ກຣີຊ',
 			'GS' => 'ເກາະຈອດເຈຍໃຕ້ແລະຫມູ່ເກາະແຊນວິດຕອນໃຕ້',
 			'GT' => 'ກົວເທມາລາ',
 			'GU' => 'ກວມ',
 			'GW' => 'ກິນີ-ບິສໂຊ',
 			'GY' => 'ກາຍຢານາ',
 			'HK' => 'ຮົງກົງ ເຂດປົກຄອງພິເສດ ຈີນ',
 			'HK@alt=short' => 'ຮົງກົງ',
 			'HM' => 'ເກາະເຮີດແລະຫມູ່ເກາະແມັກໂດນອລ',
 			'HN' => 'ຮອນດູຣັສ',
 			'HR' => 'ໂຄເອເຊຍ',
 			'HT' => 'ເຮທີ',
 			'HU' => 'ຮັງກາຣີ',
 			'IC' => 'ໝູ່ເກາະຄານາຣີ',
 			'ID' => 'ອິນໂດເນເຊຍ',
 			'IE' => 'ໄອແລນ',
 			'IL' => 'ອິສຣາເອວ',
 			'IM' => 'ເອວ ອອບ ແມນ',
 			'IN' => 'ອິນເດຍ',
 			'IO' => 'ເຂດແດນບຣິທິສອິນດຽນໂອຊຽນ',
 			'IQ' => 'ອີຣັກ',
 			'IR' => 'ອີຣ່ານ',
 			'IS' => 'ໄອສແລນ',
 			'IT' => 'ອິຕາລີ',
 			'JE' => 'ເຈີຊີ',
 			'JM' => 'ຈາໄມຄາ',
 			'JO' => 'ຈໍແດນ',
 			'JP' => 'ຍີ່ປຸ່ນ',
 			'KE' => 'ເຄນຢາ',
 			'KG' => 'ຄີກິສຖານ',
 			'KH' => 'ກຳປູເຈຍ',
 			'KI' => 'ຄຣິບາຕິ',
 			'KM' => 'ໂຄໂມໂຣສ',
 			'KN' => 'ເຊນ ຄິດ ແລະ ເນວິສ',
 			'KP' => 'ເກົາຫລີເໜືອ',
 			'KR' => 'ເກົາຫລີໃຕ້',
 			'KW' => 'ຄູເວດ',
 			'KY' => 'ເຄແມນ ໄອສແລນ',
 			'KZ' => 'ຄາຊັກສະຖານ',
 			'LA' => 'ລາວ',
 			'LB' => 'ເລບານອນ',
 			'LC' => 'ເຊນ ລູເຊຍ',
 			'LI' => 'ລິດເທນສະຕາຍ',
 			'LK' => 'ສີລັງກາ',
 			'LR' => 'ລິເບີເຣຍ',
 			'LS' => 'ເລໂຊໂທ',
 			'LT' => 'ລິທົວເນຍ',
 			'LU' => 'ລຸກແຊມເບີກ',
 			'LV' => 'ລັດເວຍ',
 			'LY' => 'ລິເບຍ',
 			'MA' => 'ໂມຣັອກໂຄ',
 			'MC' => 'ໂມນາໂຄ',
 			'MD' => 'ໂມນໂດວາ',
 			'ME' => 'ມອນເຕເນໂກຣ',
 			'MF' => 'ເຊນ ມາທິນ',
 			'MG' => 'ມາດາກາສກາ',
 			'MH' => 'ຫມູ່ເກາະມາແຊວ',
 			'MK' => 'ແມຊິໂດເນຍ',
 			'MK@alt=variant' => 'ແມຊິໂດເນຍ (FYROM)',
 			'ML' => 'ມາລິ',
 			'MM' => 'ມຽນມາ pເບີມາ)',
 			'MN' => 'ມອງໂກເລຍ',
 			'MO' => 'ມາເກົ້າ ເຂດປົກຄອງພິເສດ ຈີນ',
 			'MO@alt=short' => 'ມາເກົ້າ',
 			'MP' => 'ຫມູ່ເກາະມາແຊວຕອນເຫນືອ',
 			'MQ' => 'ມາຕິນີກ',
 			'MR' => 'ມົວຣິເທເນຍ',
 			'MS' => 'ມອນເຊີຣາດ',
 			'MT' => 'ມອນທາ',
 			'MU' => 'ມົວຣິຊຽສ',
 			'MV' => 'ມັນດິຟ',
 			'MW' => 'ມາລາວີ',
 			'MX' => 'ເມັກຊິໂກ',
 			'MY' => 'ມາເລເຊຍ',
 			'MZ' => 'ໂມແຊມບິກ',
 			'NA' => 'ນາມີເບຍ',
 			'NC' => 'ນິວ ຄາເລໂດເນຍ',
 			'NE' => 'ນິເຈີ',
 			'NF' => 'ເກາະນໍໂຟກ',
 			'NG' => 'ໄນຈີເຣຍ',
 			'NI' => 'ນິກຄາຣາກົວ',
 			'NL' => 'ເນເທີແລນ',
 			'NO' => 'ນໍເວ',
 			'NP' => 'ເນປານ',
 			'NR' => 'ນາອູຣູ',
 			'NU' => 'ນີອູເອ',
 			'NZ' => 'ນິວຊີແລນ',
 			'OM' => 'ໂອມານ',
 			'PA' => 'ພານາມາ',
 			'PE' => 'ເພີຣູ',
 			'PF' => 'ເຟຣນຊ ໂພລີເນເຂຍ',
 			'PG' => 'ປາປົວນິວກີນີ',
 			'PH' => 'ຟິລິບປິນ',
 			'PK' => 'ປາກິສຖານ',
 			'PL' => 'ໂປແລນ',
 			'PM' => 'ເຊນ ປີແອ ມິເກວລອນ',
 			'PN' => 'ໝູ່ເກາະພິດແຄນ',
 			'PR' => 'ເພືອໂຕ ຣິໂກ',
 			'PS' => 'ດິນແດນ ປາເລສຕິນຽນ',
 			'PS@alt=short' => 'ປາເລສຕິນ',
 			'PT' => 'ພອລທູໂກ',
 			'PW' => 'ປາເລົາ',
 			'PY' => 'ພາຣາກວຍ',
 			'QA' => 'ກາຕາ',
 			'QO' => 'ເຂດຫ່າງໄກໂອຊີເນຍ',
 			'RE' => 'ເຣອູນິຍົງ',
 			'RO' => 'ໂຣແມເນຍ',
 			'RS' => 'ເຊີເບຍ',
 			'RU' => 'ຣັດເຊຍ',
 			'RW' => 'ວັນດາ',
 			'SA' => 'ຊາອຸດິ ອາຣາເບຍ',
 			'SB' => 'ຫມູ່ເກາະໂຊໂລມອນ',
 			'SC' => 'ເຊເຊວເລສ',
 			'SD' => 'ຊູດານ',
 			'SE' => 'ສະວີເດັນ',
 			'SG' => 'ສິງກະໂປ',
 			'SH' => 'ເຊນ ເຮເລນາ',
 			'SI' => 'ສະໂລເວເນຍ',
 			'SJ' => 'ສະວາບາ ແລະ ແຢນ ມາເຢນ',
 			'SK' => 'ສະໂລວາເກຍ',
 			'SL' => 'ເຊຍຣາ ລີໂອນ',
 			'SM' => 'ແຊນ ມາຣິໂນ',
 			'SN' => 'ເຊນີໂກລ',
 			'SO' => 'ໂຊມາເລຍ',
 			'SR' => 'ຊູຣິນາມ',
 			'SS' => 'ຊູດານໃຕ້',
 			'ST' => 'ເຊົາທູເມ ແລະ ພຣິນຊິບ',
 			'SV' => 'ເອວ ຊໍວາດໍ',
 			'SX' => 'ຊິນ ມາທິນ',
 			'SY' => 'ຊີເຣຍ',
 			'SZ' => 'ສະວາຊິແລນ',
 			'TA' => 'ທຣິສຕັນ ດາ ກັນຮາ',
 			'TC' => 'ໝູ່ເກາະ ເທີກ ແລະ ໄຄໂຄສ',
 			'TD' => 'ແຊດ',
 			'TF' => 'ອານາເຂດທາງໃຕ້ຂອງຝຣັ່ງ',
 			'TG' => 'ໂຕໂກ',
 			'TH' => 'ໄທ',
 			'TJ' => 'ທາຈິກິສຖານ',
 			'TK' => 'ໂຕເກເລົາ',
 			'TL' => 'ທິມໍ-ເລສເຕ',
 			'TL@alt=variant' => 'ທິມໍ ຕາເວັນອອກ',
 			'TM' => 'ເທີກເມນິສຖານ',
 			'TN' => 'ຕູນິເຊຍ',
 			'TO' => 'ທອງກາ',
 			'TR' => 'ເທີຄີ',
 			'TT' => 'ທຣິນິແດດ ແລະ ໂທແບໂກ',
 			'TV' => 'ຕູວາລູ',
 			'TW' => 'ໄຕ້ຫວັນ',
 			'TZ' => 'ທານຊາເນຍ',
 			'UA' => 'ຢູເຄຣນ',
 			'UG' => 'ອູການດາ',
 			'UM' => 'ຫມູ່ເກາະຮອບນອກຂອງສະຫະລັດ',
 			'US' => 'ສະຫະລັດ',
 			'US@alt=short' => 'ສະຫະລັດຯ',
 			'UY' => 'ອູຣຸກວຍ',
 			'UZ' => 'ອຸສເບກິສຖານ',
 			'VA' => 'ນະຄອນ ວາຕິກັນ',
 			'VC' => 'ເຊນ ວິນເຊນ ແລະ ເດິ ເກຣເນດິນ',
 			'VE' => 'ເວເນຊູເອລາ',
 			'VG' => 'ໝູ່ເກາະ ບຣິທິຊ ເວີຈິນ',
 			'VI' => 'ໝູ່ເກາະ ຢູເອສ ເວີຈິນ',
 			'VN' => 'ຫວຽດນາມ',
 			'VU' => 'ວານົວຕູ',
 			'WF' => 'ວາລິສ ແລະ ຟຸຕູນາ',
 			'WS' => 'ຊາມົວ',
 			'XK' => 'ໂຄໂຊໂວ',
 			'YE' => 'ເຢເມນ',
 			'YT' => 'ມາຢອດ',
 			'ZA' => 'ອາຟະລິກາໃຕ້',
 			'ZM' => 'ແຊມເບຍ',
 			'ZW' => 'ຊິມບັບເວ',
 			'ZZ' => 'ຂົງເຂດທີ່ບໍ່ຮູ້ຈັກ',

		}
	},
);

has 'display_name_variant' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'1901' => 'ເຢຍລະມັນອໍໂທກຣາຟີດັ້ງເດີມ',
 			'1994' => 'ອັກສອນເຣຊ່ຽນມາດຕະຖານ',
 			'1996' => 'ເຢຍລະມັນອໍໂທກຣາຟີປີ1996',
 			'1606NICT' => 'ປາຍຍຸກກາງຝຣັ່ງເຖິງປີ ຄສ 1606',
 			'1694ACAD' => 'ຕອນຕົ້ນຍຸກໃໝ່ຝຣັ່ງ',
 			'1959ACAD' => 'ວິຊາການ',
 			'ALALC97' => 'ການຖອດອັກສອນເປັນອັກສອນໂຣມັນຕາມເກນຂອງສະມາຄົມຫ້ອງສະໝຸດອາເມລິກາແລະຫ້ອງສະໝຸດລັດຖະສະພາ ສະບັບພິມປີ 1997',
 			'ALUKU' => 'ພາສາພື້ນເມືອງອລູຄຸ',
 			'AREVELA' => 'ອາເມເນຍຕາເວັນອອກ',
 			'AREVMDA' => 'ອາເມເນຍຕາເວັນຕົກ',
 			'BAKU1926' => 'ຕົວອັກສອນລາຕິນເທີກິກແບບຄົບວົງຈອນ',
 			'BAUDDHA' => 'ພະພຸດທະເຈົ້າ',
 			'BISCAYAN' => 'ບິສຄາຍັນ',
 			'BISKE' => 'ພາສາພື້ນເມືອງຊານຈິໂອໂຈ/ບິລາ',
 			'BOONT' => 'ບູນທລິ່ງ',
 			'FONIPA' => 'ສັດທະສາດອັກສອນສາກົນ',
 			'FONUPA' => 'ສັດທະສາດອັກສອນ UPA',
 			'FONXSAMP' => 'ຟອນແຊມ',
 			'HEPBURN' => 'ການຖອດອັກສອນແບບເຮບເບິນ',
 			'HOGNORSK' => 'ພາສານໍວີຈ່ຽນສູງ',
 			'ITIHASA' => 'ອິຕິຫາສະ',
 			'JAUER' => 'ເຍົາເອີ',
 			'JYUTPING' => 'ການຖອດອັກສອນແບບຍູດພິງ',
 			'KKCOR' => 'ອັກຂະລະວິທີສາມັນ',
 			'LAUKIKA' => 'ລົວກິກາ',
 			'LIPAW' => 'ພາສາພື້ນເມືອງລິໂພວາຊ໌ຂອງເຣຊ່ຽນ',
 			'LUNA1918' => 'ລູນ່າ1918',
 			'MONOTON' => 'ໂມໂນໂທນິກ',
 			'NDYUKA' => 'ພາສາພື້ນເມືອງດິວຄາ',
 			'NEDIS' => 'ພາສາພື້ນເມືອງນາທິໂຊເນ',
 			'NJIVA' => 'ພາສາພື້ນເມືອງຈີວາ/ນີວາ',
 			'OSOJS' => 'ພາສາພື້ນເມືອງໂອຊຽກໂຄ/ໂອໂຊຍາເນ',
 			'PAMAKA' => 'ພາສາພື້ນເມືອງພາມາຄາ',
 			'PETR1708' => 'ພີທ໌1708',
 			'PINYIN' => 'ພິນຢິນ',
 			'POLYTON' => 'ໂພລີໂທນິກ',
 			'POSIX' => 'ຄອມພິວເຕີ',
 			'PUTER' => 'ພິວເຕີ',
 			'REVISED' => 'ອັກຂະລະວິທີສະບັບປັບປຸງ',
 			'ROZAJ' => 'ເຣຊ່ຽນ',
 			'RUMGR' => 'ຣຳກຣ໌',
 			'SAAHO' => 'ຊາໂຮ',
 			'SCOTLAND' => 'ພາສາອັງກິດມາດຕະຖານສະກັອດ',
 			'SCOUSE' => 'ສະເກົາສ໌',
 			'SOLBA' => 'ພາສາພື້ນເມືອງສະໂຕວິຊ໌ຊ່າ/ໂຊລ໌ບີກາ',
 			'SURMIRAN' => 'ຊູຣ໌ມິລານ',
 			'SURSILV' => 'ຊູຣ໌ຊີລ໌',
 			'SUTSILV' => 'ຊຸຕ໌ຊີລ໌',
 			'TARASK' => 'ອັກຂະລະວິທີທາຣາຊ໌ເຄຍວິກາ',
 			'UCCOR' => 'ອັກຂະລະວິທີແບບຄົບວົງຈອນ',
 			'UCRCOR' => 'ອັກຂະລະວິທີສະບັບປັບປຸງແບບຄົບວົງຈອນ',
 			'ULSTER' => 'ອັລສະເຕີ',
 			'VAIDIKA' => 'ເວດິກາ',
 			'VALENCIA' => 'ວາເລັນເຊຍ',
 			'VALLADER' => 'ວັລລາເດີ',
 			'WADEGILE' => 'ການຖອດອັກສອນແບບເວດ-ໄຈລ໌',

		}
	},
);

has 'display_name_key' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'calendar' => 'ປະຕິທິນ',
 			'collation' => 'ຮຽງລຳດັບ',
 			'currency' => 'ເງິນຕາ',
 			'numbers' => 'ຕົວເລກ',

		}
	},
);

has 'display_name_type' => (
	is			=> 'ro',
	isa			=> 'HashRef[HashRef[Str]]',
	init_arg	=> undef,
	default		=> sub {
		{
			'calendar' => {
 				'buddhist' => q{ປະຕິທິນພຸດ},
 				'chinese' => q{ປະຕິທິນຈີນ},
 				'coptic' => q{ປະຕິທິນຄັອບຕິກ},
 				'ethiopic' => q{ປະຕິທິນເອທິໂອເປຍ},
 				'ethiopic-amete-alem' => q{ປະຕິທິນປີໂອເອທິໂອເປຍ},
 				'gregorian' => q{ປະຕິທິນເກຣໂກຣຽນ},
 				'hebrew' => q{ປະຕິທິນຮິບບິວ},
 				'indian' => q{ປະຕິທິນແຫ່ງຊາດອິນເດຍ},
 				'islamic' => q{ປະຕິທິນອິສະລາມ},
 				'islamic-civil' => q{ປະຕິທິນອິດສະລາມ},
 				'japanese' => q{ປະຕິທິນຍີ່ປຸ່ນ},
 				'persian' => q{ປະຕິທິນເປີຊຽນ},
 				'roc' => q{ປະຕິທິນໄຕ້ຫວັນ},
 			},
 			'collation' => {
 				'big5han' => q{ລຽງຕາມອັກສອນຈີນດັ້ງເດີມ},
 				'dictionary' => q{ລຽງຕາມພົດຈະນານຸກົມ},
 				'ducet' => q{ຮຽງຕາມລຳດັບຢູນິໂຄດເລີ່ມຕົ້ນ},
 				'gb2312han' => q{ລຽງຕາມອັກສອນຈີນປະຍຸກ},
 				'phonebook' => q{ລຽງຕາມສະໝຸດໂທລະສັບ},
 				'pinyin' => q{ລຽງຕາມການອອກສຽງພາສາຈີນ},
 				'reformed' => q{ລຽງຕາມລຳດັບສຸດທ້າຍ},
 				'search' => q{ການຊອກຫາທົ່ວໄປ},
 				'searchjl' => q{ຄົ້ນຫາຕາມພະຍັນຊະນະຂຶ້ນຕົ້ນທີ່ເປັນຮັງກີຣ},
 				'standard' => q{ຮຽງຕາມມາດຕະຖານ},
 				'stroke' => q{ລຽງຕາມການລາກເສັ້ນ},
 				'traditional' => q{ລຽງຕາມແບບດັ້ງເດີມ},
 				'unihan' => q{ລຽງລຳດັບຕາມຈຳນວນຂີດ},
 			},
 			'numbers' => {
 				'arab' => q{ຕົວເລກອາຣາບິກ-ອິນດິກ},
 				'arabext' => q{ຕົວເລກອາຣາບິກ-ອິນດິກຕົວເຕັມ},
 				'armn' => q{ຕົວເລກອາເມນຽນ},
 				'armnlow' => q{ຕົວເລກອາເມນຽນຕົວພິມນ້ອຍ},
 				'bali' => q{ຕົວເລກບາລີ},
 				'beng' => q{ຕົວເລກເບັງກາລີ},
 				'cham' => q{ຕົວເລກຊຣາມ},
 				'deva' => q{ຕົວເລກເດວັນເນກາ},
 				'ethi' => q{ຕົວເລກເອທິໂອປິກ},
 				'fullwide' => q{ຕົວເລກຄວາມກວ້າງເຕັມ},
 				'geor' => q{ຕົວເລກຈໍຈຽນ},
 				'grek' => q{ຕົວເລກກຣີກ},
 				'greklow' => q{ຕົວເລກກຣີກຕົວພິມນ້ອຍ},
 				'gujr' => q{ຕົວເລກກຸຈາລາຕິ},
 				'guru' => q{ຕົວເລກກົວມູຄິ},
 				'hanidec' => q{ຕົວເລກທົດສະນິນົມຈີນ},
 				'hans' => q{ຕົວເລກຈີນແບບຮຽບງ່າຍ},
 				'hansfin' => q{ຕົວເລກທາງການເງິນແບບຮຽບງ່າຍຂອງຈີນ},
 				'hant' => q{ຕົວເລກຈີນແບບດັ້ງເດີມ},
 				'hantfin' => q{ຕົວເລກທາງການເງິນແບບດັ້ງເດີມຂອງຈີນ},
 				'hebr' => q{ຕົວເລກຮິບຣິວ},
 				'java' => q{ຕົວເລກຊົວ},
 				'jpan' => q{ຕົວເລກຍີ່ປຸ່ນ},
 				'jpanfin' => q{ຕົວເລກທາງການເງິນຂອງຍີ່ປຸ່ນ},
 				'kali' => q{ຕົວເລກກາຢາ},
 				'khmr' => q{ຕົວເລກຂະແມ},
 				'knda' => q{ຕົວເລກແຄນນາດາ},
 				'lana' => q{ຕົວເລກໄທທຳໂຮລາ},
 				'lanatham' => q{ຕົວເລກໄທທຳທຳ},
 				'laoo' => q{ຕົວເລກລາວ},
 				'latn' => q{ຕົວເລກຕາເວັນຕົກ},
 				'lepc' => q{ຕົວເລກເລຊາ},
 				'limb' => q{ຕົວເລກລິມບູ},
 				'mlym' => q{ຕົວເລກມາເລອາລຳ},
 				'mong' => q{ຕົວເລກມ່ອງໂກເລຍ},
 				'mtei' => q{ຕົວເລກເມໄຕມາເຢກ},
 				'mymr' => q{ຕົວເລກມຽນມາ},
 				'mymrshan' => q{ຕົວເລກຊານພະມ້າ},
 				'nkoo' => q{ຕົວເລກເອັນໂກ້},
 				'olck' => q{ຕົວເລກໂອລຈິກິ},
 				'orya' => q{ຕົວເລກໂອຣິຢາ},
 				'roman' => q{ຕົວເລກໂຣມັນ},
 				'romanlow' => q{ຕົວເລກໂຣມັນຕົວພິມນ້ອຍ},
 				'saur' => q{ຕົວເລກເສົາລັດທາ},
 				'sund' => q{ຕົວເລກຊຸນດາ},
 				'talu' => q{ຕົວເລກໄຕລື້ໃໝ່},
 				'taml' => q{ຕົວເລກທາມິວແບບດັ້ງເດີມ},
 				'tamldec' => q{ຕົວເລກທາມິວ},
 				'telu' => q{ຕົວເລກເຕລູກູ},
 				'thai' => q{ຕົວເລກໄທ},
 				'tibt' => q{ຕົວເລກທິເບດ},
 				'vaii' => q{ຕົວເລກໃນລະບົບໄວ},
 			},

		}
	},
);

has 'display_name_measurement_system' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'metric' => q{ເມທຣິກ},
 			'UK' => q{ອັງກິດ},
 			'US' => q{ອາເມລິກາ},

		}
	},
);

has 'display_name_code_patterns' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'language' => '{0}',
 			'script' => '{0}',
 			'territory' => '{0}',

		}
	},
);

has 'characters' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub {
		no warnings 'experimental::regex_sets';
		return {
			auxiliary => qr{(?^u:[​ ໐ ໑ ໒ ໓ ໔ ໕ ໖ ໗ ໘ ໙])},
			index => ['ກ', 'ຂ', 'ຄ', 'ງ', 'ຈ', 'ສ', 'ຊ', 'ຍ', 'ດ', 'ຕ', 'ຖ', 'ທ', 'ນ', 'ບ', 'ປ', 'ຜ', 'ຝ', 'ພ', 'ຟ', 'ມ', 'ຢ', 'ຣ', 'ລ', 'ວ', 'ຫ', '{ຫງ}', '{ຫຍ}', '{ຫນ}', '{ຫມ}', '{ຫລ}', '{ຫວ}', 'ອ', 'ຮ'],
			main => qr{(?^u:[່ ້ ໊ ໋ ໌ ໍ ໆ ກ ຂ ຄ ງ ຈ ສ ຊ ຍ ດ ຕ ຖ ທ ນ ບ ປ ຜ ຝ ພ ຟ ມ ຢ ຣ ລ ວ ຫ ໜ ໝ ອ ຮ ຯ ະ ັ າ ຳ ິ ີ ຶ ື ຸ ູ ົ ຼ ຽ ເ ແ ໂ ໃ ໄ])},
		};
	},
);

has 'ellipsis' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub {
		return {
			'final' => '{0}…',
			'initial' => '…{0}',
			'medial' => '{0}…{1}',
			'word-final' => '{0} …',
			'word-initial' => '… {0}',
			'word-medial' => '{0} … {1}',
		};
	},
);

has 'more_information' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> qq{ຂໍ້ມູນເພີ່ມເຕີມ},
);

has 'quote_start' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> qq{“},
);

has 'quote_end' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> qq{”},
);

has 'alternate_quote_start' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> qq{‘},
);

has 'alternate_quote_end' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> qq{’},
);

has 'duration_units' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { {
				hm => 'h:mm',
				hms => 'h:mm:ss',
				ms => 'm:ss',
			} }
);

has 'units' => (
	is			=> 'ro',
	isa			=> 'HashRef[HashRef[HashRef[Str]]]',
	init_arg	=> undef,
	default		=> sub { {
				'long' => {
					'acre' => {
						'other' => q({0} ເອເຄີ),
					},
					'arc-minute' => {
						'other' => q({0} ນາທີ),
					},
					'arc-second' => {
						'other' => q({0} ວິນາທີ),
					},
					'celsius' => {
						'other' => q({0} ອົງສາເຊວຊຽສ),
					},
					'centimeter' => {
						'other' => q({0} ຊັງຕີແມັດ),
					},
					'cubic-kilometer' => {
						'other' => q({0} ກິໂລແມັດກ້ອນ),
					},
					'cubic-mile' => {
						'other' => q({0} ໄມກ້ອນ),
					},
					'day' => {
						'other' => q({0} ມື້),
					},
					'degree' => {
						'other' => q({0} ອົງສາ),
					},
					'fahrenheit' => {
						'other' => q({0} ອົງສາຟາເຣນຮາຍ),
					},
					'foot' => {
						'other' => q({0} ຟຸດ),
					},
					'g-force' => {
						'other' => q({0} ແຮງຈີ),
					},
					'gram' => {
						'other' => q({0} ກຣາມ),
					},
					'hectare' => {
						'other' => q({0} ເຮັກຕາ),
					},
					'hectopascal' => {
						'other' => q({0} hPa),
					},
					'horsepower' => {
						'other' => q({0} ແຮງມ້າ),
					},
					'hour' => {
						'other' => q({0} ຊົ່ວໂມງ),
					},
					'inch' => {
						'other' => q({0} ນິ້ວ),
					},
					'inch-hg' => {
						'other' => q({0} inHg),
					},
					'kilogram' => {
						'other' => q({0} ກິໂລກຣາມ),
					},
					'kilometer' => {
						'other' => q({0} ກິໂລແມັດ),
					},
					'kilometer-per-hour' => {
						'other' => q({0} ກິໂລແມັດຕໍ່ຊົ່ວໂມງ),
					},
					'kilowatt' => {
						'other' => q({0} ກິໂລວັດ),
					},
					'light-year' => {
						'other' => q({0} ປີແສງ),
					},
					'liter' => {
						'other' => q({0} ລິດ),
					},
					'meter' => {
						'other' => q({0} ແມັດ),
					},
					'meter-per-second' => {
						'other' => q({0} ແມັດຕໍ່ນາທີ),
					},
					'mile' => {
						'other' => q({0} ໄມ),
					},
					'mile-per-hour' => {
						'other' => q({0} ໄມຕໍ່ຊົ່ວໂມງ),
					},
					'millibar' => {
						'other' => q({0} ມິນລິບາ),
					},
					'millimeter' => {
						'other' => q({0} ມິນລິແມັດ),
					},
					'millisecond' => {
						'other' => q({0} ມິນລີວິນາທີ),
					},
					'minute' => {
						'other' => q({0} ນາທີ),
					},
					'month' => {
						'other' => q({0} ເດືອນ),
					},
					'ounce' => {
						'other' => q({0} ອອນ),
					},
					'per' => {
						'' => q({0} ຕໍ່ {1}),
					},
					'picometer' => {
						'other' => q({0} ປິໂກແມັດ),
					},
					'pound' => {
						'other' => q({0} ປອນ),
					},
					'second' => {
						'other' => q({0} ວິນາທີ),
					},
					'square-foot' => {
						'other' => q({0} ft²),
					},
					'square-kilometer' => {
						'other' => q({0} ກິໂລຕາແມັດ),
					},
					'square-meter' => {
						'other' => q({0} ຕາແມັດ),
					},
					'square-mile' => {
						'other' => q({0} ຕາໄມ),
					},
					'watt' => {
						'other' => q({0} ວັດ),
					},
					'week' => {
						'other' => q({0} ອາທິດ),
					},
					'yard' => {
						'other' => q({0} ຫລາ),
					},
					'year' => {
						'other' => q({0} ປີ),
					},
				},
				'narrow' => {
					'acre' => {
						'other' => q({0} ac),
					},
					'arc-minute' => {
						'other' => q({0}′),
					},
					'arc-second' => {
						'other' => q({0}″),
					},
					'celsius' => {
						'other' => q({0} ອົງສາ ຊີ.),
					},
					'centimeter' => {
						'other' => q({0} ຊມ),
					},
					'cubic-kilometer' => {
						'other' => q({0} km³),
					},
					'cubic-mile' => {
						'other' => q({0} mi³),
					},
					'day' => {
						'other' => q({0} ມື້),
					},
					'degree' => {
						'other' => q({0}°),
					},
					'fahrenheit' => {
						'other' => q({0} ອົງສາ ຟ.),
					},
					'foot' => {
						'other' => q({0} ຟ),
					},
					'gram' => {
						'other' => q({0} ກຼ),
					},
					'hectare' => {
						'other' => q({0} ຮຕ),
					},
					'hectopascal' => {
						'other' => q({0} hPa),
					},
					'horsepower' => {
						'other' => q({0} hp),
					},
					'hour' => {
						'other' => q({0} ຊມ),
					},
					'inch' => {
						'other' => q({0} ນ),
					},
					'inch-hg' => {
						'other' => q({0} inHg),
					},
					'kilogram' => {
						'other' => q({0} ກລ),
					},
					'kilometer' => {
						'other' => q({0} ກມ),
					},
					'kilometer-per-hour' => {
						'other' => q({0} km/h),
					},
					'kilowatt' => {
						'other' => q({0} kW),
					},
					'light-year' => {
						'other' => q({0} ປສ),
					},
					'liter' => {
						'other' => q({0} ລ),
					},
					'meter' => {
						'other' => q({0} ມ),
					},
					'meter-per-second' => {
						'other' => q({0} m/s),
					},
					'mile' => {
						'other' => q({0} ໄມ),
					},
					'mile-per-hour' => {
						'other' => q({0} mi/h),
					},
					'millibar' => {
						'other' => q({0} ມິນ. ບາ),
					},
					'millimeter' => {
						'other' => q({0} ມິນ),
					},
					'millisecond' => {
						'other' => q({0} ມລ. ວິ.),
					},
					'minute' => {
						'other' => q({0} ນທ),
					},
					'month' => {
						'other' => q({0} ດ),
					},
					'ounce' => {
						'other' => q({0} ອ),
					},
					'per' => {
						'' => q({0}/{1}),
					},
					'picometer' => {
						'other' => q({0} ປກມ),
					},
					'pound' => {
						'other' => q({0} ປ),
					},
					'second' => {
						'other' => q({0} ວິ),
					},
					'square-foot' => {
						'other' => q({0} ft²),
					},
					'square-kilometer' => {
						'other' => q({0} km²),
					},
					'square-meter' => {
						'other' => q({0} m²),
					},
					'square-mile' => {
						'other' => q({0} mi²),
					},
					'watt' => {
						'other' => q({0} W),
					},
					'week' => {
						'other' => q({0} ອທ),
					},
					'yard' => {
						'other' => q({0} ຫລາ),
					},
					'year' => {
						'other' => q({0} ປ),
					},
				},
				'short' => {
					'acre' => {
						'other' => q({0} ເອເຄີ),
					},
					'arc-minute' => {
						'other' => q({0} ນທ.),
					},
					'arc-second' => {
						'other' => q({0} ວິ.),
					},
					'celsius' => {
						'other' => q({0} ອົງສາ ຊີ.),
					},
					'centimeter' => {
						'other' => q({0} ຊມ),
					},
					'cubic-kilometer' => {
						'other' => q({0} km³),
					},
					'cubic-mile' => {
						'other' => q({0} mi³),
					},
					'day' => {
						'other' => q({0} ມື້),
					},
					'degree' => {
						'other' => q({0} ອົງສາ),
					},
					'fahrenheit' => {
						'other' => q({0} ອົງສາ ຟ.),
					},
					'foot' => {
						'other' => q({0} ຟ),
					},
					'g-force' => {
						'other' => q({0} g force),
					},
					'gram' => {
						'other' => q({0} ກຼ),
					},
					'hectare' => {
						'other' => q({0} ຮຕ.),
					},
					'hectopascal' => {
						'other' => q({0} hPa),
					},
					'horsepower' => {
						'other' => q({0} hp),
					},
					'hour' => {
						'other' => q({0} ຊມ.),
					},
					'inch' => {
						'other' => q({0} ນິ),
					},
					'inch-hg' => {
						'other' => q({0} inHg),
					},
					'kilogram' => {
						'other' => q({0} ກິໂລ),
					},
					'kilometer' => {
						'other' => q({0} ກມ),
					},
					'kilometer-per-hour' => {
						'other' => q({0} ກມ/ຊມ),
					},
					'kilowatt' => {
						'other' => q({0} ກລ. ວັດ),
					},
					'light-year' => {
						'other' => q({0} ປສ),
					},
					'liter' => {
						'other' => q({0} ລິດ),
					},
					'meter' => {
						'other' => q({0} ມ),
					},
					'meter-per-second' => {
						'other' => q({0} ມ/ນທ),
					},
					'mile' => {
						'other' => q({0} ໄມ),
					},
					'mile-per-hour' => {
						'other' => q({0} ໄມ/ຊມ),
					},
					'millibar' => {
						'other' => q({0} ມິນ. ບາ),
					},
					'millimeter' => {
						'other' => q({0} ມິນ),
					},
					'millisecond' => {
						'other' => q({0} ມລ ວິນາທີ),
					},
					'minute' => {
						'other' => q({0} ນທ.),
					},
					'month' => {
						'other' => q({0} ດ.),
					},
					'ounce' => {
						'other' => q({0} ອ),
					},
					'per' => {
						'' => q({0}/{1}),
					},
					'picometer' => {
						'other' => q({0} ປກມ),
					},
					'pound' => {
						'other' => q({0} ປ),
					},
					'second' => {
						'other' => q({0} ວິ.),
					},
					'square-foot' => {
						'other' => q({0} ft²),
					},
					'square-kilometer' => {
						'other' => q({0} km²),
					},
					'square-meter' => {
						'other' => q({0} m²),
					},
					'square-mile' => {
						'other' => q({0} mi²),
					},
					'watt' => {
						'other' => q({0} W),
					},
					'week' => {
						'other' => q({0} ອທ.),
					},
					'yard' => {
						'other' => q({0} ຫລາ),
					},
					'year' => {
						'other' => q({0} ປີ),
					},
				},
			} }
);

has 'yesstr' => (
	is			=> 'ro',
	isa			=> 'RegexpRef',
	init_arg	=> undef,
	default		=> sub { qr'^(?i:ແມ່ນ|yes|y)$' }
);

has 'nostr' => (
	is			=> 'ro',
	isa			=> 'RegexpRef',
	init_arg	=> undef,
	default		=> sub { qr'^(?i:ບໍ່ແມ່ນ|no|n)$' }
);

has 'listPatterns' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
				start => q({0}, {1}),
				middle => q({0}, {1}),
				end => q({0}, {1}),
				2 => q({0}, {1}),
		} }
);

has 'default_numbering_system' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> 'latn',
);

has native_numbering_system => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> 'laoo',
);

has 'number_symbols' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'latn' => {
			'decimal' => q(,),
			'exponential' => q(E),
			'group' => q(.),
			'infinity' => q(∞),
			'list' => q(;),
			'minusSign' => q(-),
			'nan' => q(ບໍ່ແມ່ນໂຕເລກ),
			'perMille' => q(‰),
			'percentSign' => q(%),
			'plusSign' => q(+),
			'superscriptingExponent' => q(×),
		},
	} }
);

has 'number_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		decimalFormat => {
			'default' => {
				'0' => {
					'default' => '#,##0.###',
				},
				'1000' => {
					'other' => '0 ພັນ',
				},
				'10000' => {
					'other' => '00 ພັນ',
				},
				'100000' => {
					'other' => '000 ກີບ',
				},
				'1000000' => {
					'other' => '0 ລ້ານ',
				},
				'10000000' => {
					'other' => '00 ລ້ານ',
				},
				'100000000' => {
					'other' => '000 ລ້ານ',
				},
				'1000000000' => {
					'other' => '0 ຕື້',
				},
				'10000000000' => {
					'other' => '00 ຕື້',
				},
				'100000000000' => {
					'other' => '000 ຕື້',
				},
				'1000000000000' => {
					'other' => '0 ລ້ານລ້ານ',
				},
				'10000000000000' => {
					'other' => '00 ລ້ານລ້ານ',
				},
				'100000000000000' => {
					'other' => '000 ລ້ານລ້ານ',
				},
			},
			'long' => {
				'1000' => {
					'other' => '0 ພັນ',
				},
				'10000' => {
					'other' => '00 ພັນ',
				},
				'100000' => {
					'other' => '0 ແສນ',
				},
				'1000000' => {
					'other' => '0 ລ້ານ',
				},
				'10000000' => {
					'other' => '00 ລ້ານ',
				},
				'100000000' => {
					'other' => '000 ລ້ານ',
				},
				'1000000000' => {
					'other' => '0 ຕື້',
				},
				'10000000000' => {
					'other' => '00 ຕື້',
				},
				'100000000000' => {
					'other' => '000 ຕື້',
				},
				'1000000000000' => {
					'other' => '0 ລ້ານລ້ານ',
				},
				'10000000000000' => {
					'other' => '00 ລ້ານລ້ານ',
				},
				'100000000000000' => {
					'other' => '000 ລ້ານລ້ານ',
				},
			},
			'short' => {
				'1000' => {
					'other' => '0 ພັນ',
				},
				'10000' => {
					'other' => '00 ພັນ',
				},
				'100000' => {
					'other' => '000 ກີບ',
				},
				'1000000' => {
					'other' => '0 ລ້ານ',
				},
				'10000000' => {
					'other' => '00 ລ້ານ',
				},
				'100000000' => {
					'other' => '000 ລ້ານ',
				},
				'1000000000' => {
					'other' => '0 ຕື້',
				},
				'10000000000' => {
					'other' => '00 ຕື້',
				},
				'100000000000' => {
					'other' => '000 ຕື້',
				},
				'1000000000000' => {
					'other' => '0 ລ້ານລ້ານ',
				},
				'10000000000000' => {
					'other' => '00 ລ້ານລ້ານ',
				},
				'100000000000000' => {
					'other' => '000 ລ້ານລ້ານ',
				},
			},
		},
		percentFormat => {
			'default' => {
				'0' => {
					'default' => '#,##0%',
				},
			},
		},
		scientificFormat => {
			'default' => {
				'0' => {
					'default' => '#',
				},
			},
		},
} },
);

has 'number_currency_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'latn' => {
			'pattern' => {
				'default' => {
					'standard' => {
						'negative' => '¤-#,##0.00',
						'positive' => '¤#,##0.00',
					},
				},
			},
		},
} },
);

has 'curriencies' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'ADP' => {
			display_name => {
				'currency' => q(ເປເຊຕາ ອັນໂດລາ),
			},
		},
		'AED' => {
			display_name => {
				'currency' => q(ດີແຮມ ສະຫະລັດອາຣັບ ເອມີເຣດ),
			},
		},
		'AFA' => {
			display_name => {
				'currency' => q(ອັບການິ ອັບການິສະຖານ \(1927–2002\)),
			},
		},
		'AFN' => {
			display_name => {
				'currency' => q(ອັບການິ ອັບກັນນິສະຖານ),
			},
		},
		'ALL' => {
			display_name => {
				'currency' => q(ແລັກ ອານບາເນຍ),
			},
		},
		'AMD' => {
			display_name => {
				'currency' => q(ດຣມອາເມເນຍ),
			},
		},
		'ANG' => {
			display_name => {
				'currency' => q(ຫຼຽນເງິນ ເນເທີແລນ),
			},
		},
		'AOA' => {
			display_name => {
				'currency' => q(ກວານຊາ ແອງໂກລາ),
			},
		},
		'AOK' => {
			display_name => {
				'currency' => q(ກວານຊາ ແອງໂກລາ \(1977–1991\)),
			},
		},
		'AON' => {
			display_name => {
				'currency' => q(ກວານຊາ ແອງໂກລາ ໃໝ່ \(1995–1999\)),
			},
		},
		'AOR' => {
			display_name => {
				'currency' => q(ກວານຊາກທີ່ແກ້ໄຂໃໝ່ ແອງກູລາ \(1995–1999\)),
			},
		},
		'ARA' => {
			display_name => {
				'currency' => q(ອອສຕຣານ ອາກຊັງຕິນ),
			},
		},
		'ARL' => {
			display_name => {
				'currency' => q(ເປໂຊເລ ອາກຊັງຕິນ \(1970–1983\)),
			},
		},
		'ARM' => {
			display_name => {
				'currency' => q(ເປໂຊ ອາກຊັງຕິນ \(1881–1970\)),
			},
		},
		'ARP' => {
			display_name => {
				'currency' => q(ເປໂຊ ອາກຊັງຕິນ \(1983–1985\)),
			},
		},
		'ARS' => {
			display_name => {
				'currency' => q(ເປໂຊ ອາເຈນຕີນາ),
			},
		},
		'ATS' => {
			display_name => {
				'currency' => q(ຊິລລິງ ອົດສະຕາລີ),
			},
		},
		'AUD' => {
			symbol => 'A$',
			display_name => {
				'currency' => q(ໂດລາ ອອດສະເຕເລຍ),
			},
		},
		'AWG' => {
			display_name => {
				'currency' => q(ອະຣູແບນ ຟລໍຣິນ),
				'other' => q(ຟລໍຣິນ),
			},
		},
		'AZM' => {
			display_name => {
				'currency' => q(ມານັດ ອາແຊກບາຍຊານ \(1993–2006\)),
			},
		},
		'AZN' => {
			display_name => {
				'currency' => q(ມານັດ ອາຊັກບາຍຊານ),
			},
		},
		'BAD' => {
			display_name => {
				'currency' => q(ດີນາ ບອສເນຍ ເຮີເຊໂບວາເນຍ \(1992–1994\)),
			},
		},
		'BAM' => {
			display_name => {
				'currency' => q(ມາກບອສເນຍ ເຮເຊໂກເວນາ),
			},
		},
		'BAN' => {
			display_name => {
				'currency' => q(ດີນາໃໝ່ ບອສເນຍ ເຮີເຊໂບວີນາ\(1994–1997\)),
			},
		},
		'BBD' => {
			display_name => {
				'currency' => q(ໂດລ່າ ບາບາດຽນ),
				'other' => q(ດອນລາ ບາເບດຽນ),
			},
		},
		'BDT' => {
			display_name => {
				'currency' => q(ຕາກາ ບັງກາເດດ),
			},
		},
		'BEC' => {
			display_name => {
				'currency' => q(ຟຣັງ ບູນກາລີ \(ປ່ຽນແປງໄດ້\)),
			},
		},
		'BEF' => {
			display_name => {
				'currency' => q(ຟຣັງ ບູນກາລີ),
			},
		},
		'BEL' => {
			display_name => {
				'currency' => q(ຟຣັງ ບູນກາລີ \(ການເງິນ\)),
			},
		},
		'BGL' => {
			display_name => {
				'currency' => q(ຮາດເລບ ບູນກາລີ),
			},
		},
		'BGM' => {
			display_name => {
				'currency' => q(ເລບ ສັງຄົມບູນກາລີ),
			},
		},
		'BGN' => {
			display_name => {
				'currency' => q(ເລບ ບັງແກເຣຍ),
			},
		},
		'BGO' => {
			display_name => {
				'currency' => q(ເລບ ບູນກາລີ \(1879–1952\)),
			},
		},
		'BHD' => {
			display_name => {
				'currency' => q(ດີນາ ບາເຣນ),
			},
		},
		'BIF' => {
			display_name => {
				'currency' => q(ຟຣັງ ບຸຣັນດີ),
			},
		},
		'BMD' => {
			display_name => {
				'currency' => q(ໂດລ່າເບີມູແດນ),
				'other' => q(ໂດລ່າເບີມູແດນ),
			},
		},
		'BND' => {
			display_name => {
				'currency' => q(ໂດລາ ບຣູໄນ),
			},
		},
		'BOB' => {
			display_name => {
				'currency' => q(ໂບລິເວຍໂນ ໂລລິເວຍ),
			},
		},
		'BOL' => {
			display_name => {
				'currency' => q(ໂລລິເວຍໂນ ໂລລິເວຍ \(1863–1963\)),
			},
		},
		'BOP' => {
			display_name => {
				'currency' => q(ເປໂຊໂລລິເວຍ),
			},
		},
		'BOV' => {
			display_name => {
				'currency' => q(ມະດອນ ໂລລິເວຍ),
			},
		},
		'BRB' => {
			display_name => {
				'currency' => q(ກຣູເຊໂດບາຊິ ໃໝ່ \(1967–1986\)),
			},
		},
		'BRC' => {
			display_name => {
				'currency' => q(ກຣູຊາໂດບາຊິວ \(1986–1989\)),
			},
		},
		'BRE' => {
			display_name => {
				'currency' => q(ກຣູເຊໂຣ ບາຊິ ກຣູໂຊ ບາຊິວ \(1993–1994\)),
			},
		},
		'BRL' => {
			symbol => 'R$',
			display_name => {
				'currency' => q(ຣຽນ ບຣາຊິນ),
			},
		},
		'BRN' => {
			display_name => {
				'currency' => q(ກຣູຊາໂດ ບາຊິວ ໃໝ່ \(1989–1990\)),
			},
		},
		'BRR' => {
			display_name => {
				'currency' => q(ກຣູເຊໂຣ ບາຊິວ \(1993–1994\)),
			},
		},
		'BRZ' => {
			display_name => {
				'currency' => q(ກຣູເຊໂຣ ບາຊິວ \(1942–1967\)),
			},
		},
		'BSD' => {
			display_name => {
				'currency' => q(ໂດລ່າ ບາຮາມຽນ),
				'other' => q(ໂດລ່າ ບາຮາມຽນ),
			},
		},
		'BTN' => {
			display_name => {
				'currency' => q(ອັງກູຕຣາມ ບູຖານ),
			},
		},
		'BUK' => {
			display_name => {
				'currency' => q(ຈາດ ພະມ້າ),
			},
		},
		'BWP' => {
			display_name => {
				'currency' => q(ປູລາ ບອສວານາ),
			},
		},
		'BYB' => {
			display_name => {
				'currency' => q(ຣູໂບ ເບຣາຣຸສ ໃໝ່\(1994–1999\)),
			},
		},
		'BYR' => {
			display_name => {
				'currency' => q(ຣູໂບ ເບຣາຣູສ),
			},
		},
		'BZD' => {
			display_name => {
				'currency' => q(ໂດລ່າ ເບວລິຊ),
				'other' => q(ໂດລ່າ ເບວລິຊ),
			},
		},
		'CAD' => {
			symbol => 'CA$',
			display_name => {
				'currency' => q(ໂດລ່າຄານາດາ),
				'other' => q(ໂດລ່າຄານາດາ),
			},
		},
		'CDF' => {
			display_name => {
				'currency' => q(ຟຣັງ ຄອງໂກ),
			},
		},
		'CHE' => {
			display_name => {
				'currency' => q(ເອີໂຣ WIR),
			},
		},
		'CHF' => {
			display_name => {
				'currency' => q(ຟຣັງ ສະວິດເຊີແລນ),
			},
		},
		'CHW' => {
			display_name => {
				'currency' => q(ຟຣັງ WIR),
			},
		},
		'CLE' => {
			display_name => {
				'currency' => q(ເອສກູໂດ ຊິລີ),
			},
		},
		'CLF' => {
			display_name => {
				'currency' => q(ຫົວໜ່ວຍບັນຊີ \(UF\) ຊິລີ),
			},
		},
		'CLP' => {
			display_name => {
				'currency' => q(ເປໂຊ ຊິລີ),
			},
		},
		'CNY' => {
			symbol => 'CN¥',
			display_name => {
				'currency' => q(ຢວນ ຈີນ),
			},
		},
		'COP' => {
			display_name => {
				'currency' => q(ເປໂຊໂຄລຳເບຍ),
			},
		},
		'COU' => {
			display_name => {
				'currency' => q(ຫົວໜ່ວຍຄ່າຈິງ ໂຄລັມເບຍ),
			},
		},
		'CRC' => {
			display_name => {
				'currency' => q(ໂຄສຕາ ຣິກັນ ໂຄລອນ),
				'other' => q(ໂຄລອນ),
			},
		},
		'CSD' => {
			display_name => {
				'currency' => q(ດີນາ ເຊີເບຍ \(2002–2006\)),
			},
		},
		'CSK' => {
			display_name => {
				'currency' => q(ຮາດໂກຣູນາ ເຊັກໂກສະໂລວັກ),
			},
		},
		'CUC' => {
			display_name => {
				'currency' => q(ຄິວແບນ ຄອນເວີດຕິໂບ ເປໂຊ),
				'other' => q(ຄິວແບນ ຄອນເວີດຕິໂບ ເປໂຊ),
			},
		},
		'CUP' => {
			display_name => {
				'currency' => q(ຄິວແບນ ເປໂຊ),
				'other' => q(ຄິວແບນ ເປໂຊ),
			},
		},
		'CVE' => {
			display_name => {
				'currency' => q(ເອສກູໂດ ເຄບເວີດ),
			},
		},
		'CYP' => {
			display_name => {
				'currency' => q(ປອນ ໄຊປຣັດ),
			},
		},
		'CZK' => {
			display_name => {
				'currency' => q(ໂຄຣູນາ ສາທາລະນະລັດເຊັກ),
			},
		},
		'DDM' => {
			display_name => {
				'currency' => q(ມາກ ເຢຍລະມັນ ຕາເວັນອອກ),
			},
		},
		'DEM' => {
			display_name => {
				'currency' => q(ມາກ ເຢຍລະມັນ),
			},
		},
		'DJF' => {
			display_name => {
				'currency' => q(ຟຣັງ ຈິບູຕິ),
			},
		},
		'DKK' => {
			display_name => {
				'currency' => q(ໂຄຣນ ເດັນມາກ),
			},
		},
		'DOP' => {
			display_name => {
				'currency' => q(ເປໂຊໂດມິນິການ),
			},
		},
		'DZD' => {
			display_name => {
				'currency' => q(ດີນາ ອາຍຈີເຣຍ),
			},
		},
		'ECS' => {
			display_name => {
				'currency' => q(ຊູເກ ເອກາວາດໍ),
			},
		},
		'ECV' => {
			display_name => {
				'currency' => q(ຫົວໜ່ວຍຄ່າຄົງທີ່ຂອງເອກາວາດໍ),
			},
		},
		'EEK' => {
			display_name => {
				'currency' => q(ຄຣູນເອສ ໂຕເນຍ),
			},
		},
		'EGP' => {
			display_name => {
				'currency' => q(ປອນ ອີຢິບ),
			},
		},
		'ERN' => {
			display_name => {
				'currency' => q(ແນກຟຣາ ອີຣິເທຣຍ),
			},
		},
		'ESA' => {
			display_name => {
				'currency' => q(ເປເຊຕາສະເປັນ \(ບັນຊີ\)),
			},
		},
		'ESB' => {
			display_name => {
				'currency' => q(ເປເຊຕາສະເປນ \(ປ່ຽນແປງໄດ້\)),
			},
		},
		'ESP' => {
			display_name => {
				'currency' => q(ເປເຊຕາ ສະເປນ),
			},
		},
		'ETB' => {
			display_name => {
				'currency' => q(ເບີ ເອທີໂອເປຍ),
			},
		},
		'EUR' => {
			symbol => '€',
			display_name => {
				'currency' => q(ເອີໂຣ),
			},
		},
		'FIM' => {
			display_name => {
				'currency' => q(ມາກກາ ຟິນແລນ),
			},
		},
		'FJD' => {
			display_name => {
				'currency' => q(ໂດລາ ຟິຈິ),
			},
		},
		'FKP' => {
			display_name => {
				'currency' => q(ປອນ ໝູ່ເກາະ ຟໍແລນ),
			},
		},
		'FRF' => {
			display_name => {
				'currency' => q(ຟຣັງ ຝຣັ່ງ),
			},
		},
		'GBP' => {
			symbol => '£',
			display_name => {
				'currency' => q(ປອນສະເຕີຣິງ \(ອັງກິດ\)),
			},
		},
		'GEK' => {
			display_name => {
				'currency' => q(ກູປອນ ລາຣິທ ຈໍເຈຍ),
			},
		},
		'GEL' => {
			display_name => {
				'currency' => q(ລາຣິ ຈໍເຈຍ),
			},
		},
		'GHC' => {
			display_name => {
				'currency' => q(ເຊດີ ການາ \(1979–2007\)),
			},
		},
		'GHS' => {
			display_name => {
				'currency' => q(ເຊດີການາ),
			},
		},
		'GIP' => {
			display_name => {
				'currency' => q(ປອນ ຍິບຣາຕາ),
			},
		},
		'GMD' => {
			display_name => {
				'currency' => q(ດາລາຊິ ແກມເບຍ),
			},
		},
		'GNF' => {
			display_name => {
				'currency' => q(ຟຣັງ ກິນີ),
			},
		},
		'GNS' => {
			display_name => {
				'currency' => q(ໄຊລິ ກີນີ),
			},
		},
		'GQE' => {
			display_name => {
				'currency' => q(ເອັກເວເລ ອີຄວາຕິຣຽວ ກິນີ),
			},
		},
		'GRD' => {
			display_name => {
				'currency' => q(ດາກຊະມາ ເກຣັກ),
			},
		},
		'GTQ' => {
			display_name => {
				'currency' => q(ກົວເຕມາລານ ເຄັດຊອນ),
				'other' => q(ເຄັດຊອນ),
			},
		},
		'GWE' => {
			display_name => {
				'currency' => q(ເອສກູໂດ ກີນີໂປຕູເກດ),
			},
		},
		'GWP' => {
			display_name => {
				'currency' => q(ເປໂຊກິນີ-ບິສເຊົາ),
			},
		},
		'GYD' => {
			display_name => {
				'currency' => q(ດອນລາ ກາຍອານາ),
			},
		},
		'HKD' => {
			symbol => 'HK$',
			display_name => {
				'currency' => q(ດອນລາ ຮົງກົງ),
			},
		},
		'HNL' => {
			display_name => {
				'currency' => q(ຮອນດູແຣນ ເລມພິຣາ),
				'other' => q(ເລມພິຣາ),
			},
		},
		'HRD' => {
			display_name => {
				'currency' => q(ດີນາ ໂຄຣເອເຊຍ),
			},
		},
		'HRK' => {
			display_name => {
				'currency' => q(ຄູນາ ໂກຣເອເຊຍ),
			},
		},
		'HTG' => {
			display_name => {
				'currency' => q(ກູດເຮຕິ),
			},
		},
		'HUF' => {
			display_name => {
				'currency' => q(ຟໍຣິນ ຮົງກາຣີ),
			},
		},
		'IDR' => {
			display_name => {
				'currency' => q(ຣູປີ ອິນໂດເນເຊຍ),
			},
		},
		'IEP' => {
			display_name => {
				'currency' => q(ປອນ ໄອຣິຊ),
			},
		},
		'ILP' => {
			display_name => {
				'currency' => q(ປອນ ອີສະລາເອວ),
			},
		},
		'ILS' => {
			symbol => '₪',
			display_name => {
				'currency' => q(ນິວເຊເກນ ອີສະລາແອນ),
			},
		},
		'INR' => {
			symbol => '₹',
			display_name => {
				'currency' => q(ຣູປີ ອິນເດຍ),
			},
		},
		'IQD' => {
			display_name => {
				'currency' => q(ດີນາ ອີຣັກ),
			},
		},
		'IRR' => {
			display_name => {
				'currency' => q(ຣີວ ອີຣ່ານ),
			},
		},
		'ISK' => {
			display_name => {
				'currency' => q(ໂຄຣນາ ໄອສແລນ),
			},
		},
		'ITL' => {
			display_name => {
				'currency' => q(ລິຣາ ອີຕາລີ),
			},
		},
		'JMD' => {
			display_name => {
				'currency' => q(ດອນລາ ຈາເມກາ),
			},
		},
		'JOD' => {
			display_name => {
				'currency' => q(ດີນາ ຈໍແດນ),
			},
		},
		'JPY' => {
			symbol => 'JP¥',
			display_name => {
				'currency' => q(ເຢນ ຍີ່ປຸ່ນ),
			},
		},
		'KES' => {
			display_name => {
				'currency' => q(ຊິລລິງ ເຄນຢາ),
			},
		},
		'KGS' => {
			display_name => {
				'currency' => q(ໂຊມ ຄຣີກິສະຖານ),
			},
		},
		'KHR' => {
			display_name => {
				'currency' => q(ຫຼຽນກຳປູເຈ້ຍ),
			},
		},
		'KMF' => {
			display_name => {
				'currency' => q(ຟຣັງ ໂກໂມໂຣສ),
			},
		},
		'KPW' => {
			display_name => {
				'currency' => q(ວອນ ເກົາຫຼີເໜືອ),
			},
		},
		'KRH' => {
			display_name => {
				'currency' => q(ຮາວານ ເກົາຫຼີເນື້),
			},
		},
		'KRO' => {
			display_name => {
				'currency' => q(ວອນ ເກົາຫຼີໃຕ້ \(1945–1953\)),
			},
		},
		'KRW' => {
			symbol => '₩',
			display_name => {
				'currency' => q(ວອນ ເກົາຫຼີໃຕ້),
			},
		},
		'KWD' => {
			display_name => {
				'currency' => q(ດີນາ ຄູເວດ),
			},
		},
		'KYD' => {
			display_name => {
				'currency' => q(ດອນລາໝູ່ເກາະເກແມນ),
			},
		},
		'KZT' => {
			display_name => {
				'currency' => q(ເຕັງເຈ ກາຊັກສະຖານ),
			},
		},
		'LAK' => {
			symbol => '₭',
			display_name => {
				'currency' => q(ກີບ ລາວ),
			},
		},
		'LBP' => {
			display_name => {
				'currency' => q(ປອນ ເລບານອນ),
			},
		},
		'LKR' => {
			display_name => {
				'currency' => q(ຣູປີ ສີຣັງກາ),
			},
		},
		'LRD' => {
			display_name => {
				'currency' => q(ດອນລາ ໄລບິເລຍ),
			},
		},
		'LSL' => {
			display_name => {
				'currency' => q(ໂລຕິ ເລໂຊໂຕ),
			},
		},
		'LTL' => {
			display_name => {
				'currency' => q(ລິຕັສ ລິທົວເນຍ),
			},
		},
		'LTT' => {
			display_name => {
				'currency' => q(ທາໂລນັສ ລິທົວເນຍ),
			},
		},
		'LUC' => {
			display_name => {
				'currency' => q(ຟຣັງ ລຸກຊຳບວກ ທີ່ປ່ຽນແປງ),
			},
		},
		'LUF' => {
			display_name => {
				'currency' => q(ຟຣັງ ລຸກຊຳບວກ),
			},
		},
		'LUL' => {
			display_name => {
				'currency' => q(ຟຣັງ ລຸກຊຳບວກ ການເງິນ),
			},
		},
		'LVL' => {
			display_name => {
				'currency' => q(ລັສ ລັດເວຍ),
			},
		},
		'LVR' => {
			display_name => {
				'currency' => q(ຣູໂບ ລາວຽນ),
			},
		},
		'LYD' => {
			display_name => {
				'currency' => q(ດີນາ ລິເບຍ),
			},
		},
		'MAD' => {
			display_name => {
				'currency' => q(ດີຮາມ ໂມລອກໂກ),
			},
		},
		'MAF' => {
			display_name => {
				'currency' => q(ຟຣັງ ໂມຣອກໂກ),
			},
		},
		'MCF' => {
			display_name => {
				'currency' => q(ຟຣັງ ໂມດາໂກ),
			},
		},
		'MDC' => {
			display_name => {
				'currency' => q(ບັດປັນສ່ວນ ມອງໂດວາ),
			},
		},
		'MDL' => {
			display_name => {
				'currency' => q(ເລອູ ມອງໂດວາ),
			},
		},
		'MGA' => {
			display_name => {
				'currency' => q(ອາເຣຍຣີ ມາດາກາສກາ),
			},
		},
		'MGF' => {
			display_name => {
				'currency' => q(ຟຣັງ ມາດາກັດສະກາ),
			},
		},
		'MKD' => {
			display_name => {
				'currency' => q(ເດນາ ມາຊິໂດເນຍ),
			},
		},
		'MKN' => {
			display_name => {
				'currency' => q(ດີນາ ມາຊີໂດເນຍ \(1992–1993\)),
			},
		},
		'MLF' => {
			display_name => {
				'currency' => q(ຟຣັງ ມາລີ),
			},
		},
		'MMK' => {
			display_name => {
				'currency' => q(ຈາດ ມ່ຽນມາ),
			},
		},
		'MNT' => {
			display_name => {
				'currency' => q(ຕຸກຣີ ມົງໂກເລຍ),
			},
		},
		'MOP' => {
			display_name => {
				'currency' => q(ປາຕາກາ ມາເກົາ),
			},
		},
		'MRO' => {
			display_name => {
				'currency' => q(ອໍກິວຢາ ມໍຣິເຕເນຍ),
			},
		},
		'MTL' => {
			display_name => {
				'currency' => q(ລິຣາ ມອນຕາ),
			},
		},
		'MTP' => {
			display_name => {
				'currency' => q(ປອນ ມອນຕາ),
			},
		},
		'MUR' => {
			display_name => {
				'currency' => q(ຣູປີ ມໍຣີເຊຍ),
			},
		},
		'MVR' => {
			display_name => {
				'currency' => q(ຣູຟີຢາ ມາດີເວຍ),
			},
		},
		'MWK' => {
			display_name => {
				'currency' => q(ຄວາຊາມາລາວີ),
			},
		},
		'MXN' => {
			symbol => 'MX$',
			display_name => {
				'currency' => q(ເມັກຊິກັນ ເປໂຊ),
				'other' => q(ເປໂຊ),
			},
		},
		'MXP' => {
			display_name => {
				'currency' => q(ຫົວໜ່ວຍເງິນ ເປໂຊ ແມັກຊິໂກ\(1861–1992\)),
			},
		},
		'MXV' => {
			display_name => {
				'currency' => q(ຫົວໜ່ວຍການລົງທຶນ ແມັກຊິໂກ),
			},
		},
		'MYR' => {
			display_name => {
				'currency' => q(ຣິງກິດ ມາເລເຂຍ),
			},
		},
		'MZE' => {
			display_name => {
				'currency' => q(ເອສກູໂດ ໂມຊຳບິກ),
			},
		},
		'MZM' => {
			display_name => {
				'currency' => q(ເມຕິຄໍ ໂມຊຳບິກ \(1980–2006\)),
			},
		},
		'MZN' => {
			display_name => {
				'currency' => q(ເມຕິຄໍ ໂມຊັມບິກ),
			},
		},
		'NAD' => {
			display_name => {
				'currency' => q(ດອນລາ ນາມິເບຍ),
			},
		},
		'NGN' => {
			display_name => {
				'currency' => q(ໄນຣາ ໄນຈີເຣຍ),
			},
		},
		'NIC' => {
			display_name => {
				'currency' => q(ຄໍໂດບາ ນິກາຣາກົວ \(1988–1991\)),
			},
		},
		'NIO' => {
			display_name => {
				'currency' => q(ນິກາຣາກວນ ໂຄໂດບາ),
				'other' => q(ໂຄໂດບາ),
			},
		},
		'NLG' => {
			display_name => {
				'currency' => q(ກິລເດີ ເນເທີແລນ),
			},
		},
		'NOK' => {
			display_name => {
				'currency' => q(ໂຄຣນ ນອກເວ),
			},
		},
		'NPR' => {
			display_name => {
				'currency' => q(ຣູປີ ເນປານ),
			},
		},
		'NZD' => {
			symbol => 'NZ$',
			display_name => {
				'currency' => q(ໂດລາ ນີວຊີແລນ),
			},
		},
		'OMR' => {
			display_name => {
				'currency' => q(ຣຽວ ໂອມານ),
			},
		},
		'PAB' => {
			display_name => {
				'currency' => q(ພານາມານຽນ ບອນບົວ),
				'other' => q(ບອນບົວ),
			},
		},
		'PEI' => {
			display_name => {
				'currency' => q(ອິນຕິ ເປຣູ),
			},
		},
		'PEN' => {
			display_name => {
				'currency' => q(ນູໂວຊໍ ເປຣູ),
			},
		},
		'PES' => {
			display_name => {
				'currency' => q(ໂຊນ ເປຣູ \(1863–1965\)),
			},
		},
		'PGK' => {
			display_name => {
				'currency' => q(ກີນາ ປາປົວນີວກຸນນີນ),
			},
		},
		'PHP' => {
			display_name => {
				'currency' => q(ເປໂຊ ຟີລິປິນ),
			},
		},
		'PKR' => {
			display_name => {
				'currency' => q(ຣູປີ ປາກີສະຖານ),
			},
		},
		'PLN' => {
			display_name => {
				'currency' => q(ຊລໍຕີ ໂປແລນ),
			},
		},
		'PLZ' => {
			display_name => {
				'currency' => q(ຊະລອສຕີ ໂປແລນ \(1950–1995\)),
			},
		},
		'PTE' => {
			display_name => {
				'currency' => q(ເອສກູໂດ ໂປຕູເກສ),
			},
		},
		'PYG' => {
			display_name => {
				'currency' => q(ກວາຣານີ ປາຣາກວາຍ),
			},
		},
		'QAR' => {
			display_name => {
				'currency' => q(ຣຽວ ກາຕາ),
			},
		},
		'RHD' => {
			display_name => {
				'currency' => q(ດອນລາ ໂຣດີເຊຍ),
			},
		},
		'ROL' => {
			display_name => {
				'currency' => q(ລິວ ໂຣມາເນຍເກົ່າ),
			},
		},
		'RON' => {
			display_name => {
				'currency' => q(ເລອູ ໂຣມາເນຍ),
			},
		},
		'RSD' => {
			display_name => {
				'currency' => q(ດີນາ ເຊີເບຍ),
			},
		},
		'RUB' => {
			display_name => {
				'currency' => q(ຣູໂລ ຣັດເຊຍ),
			},
		},
		'RUR' => {
			display_name => {
				'currency' => q(ຣູໂບ ຣັດເຊຍ \(1991–1998\)),
			},
		},
		'RWF' => {
			display_name => {
				'currency' => q(ຟຣັງ ວັນດາ),
			},
		},
		'SAR' => {
			display_name => {
				'currency' => q(ຣີຢອນ ຊາອຸດິດອາຣາບີ),
			},
		},
		'SBD' => {
			display_name => {
				'currency' => q(ໂດລາ ໝູ່ເກາະໂຊໂລມອນ),
			},
		},
		'SCR' => {
			display_name => {
				'currency' => q(ຣູປີ ເຊເຊລ),
			},
		},
		'SDD' => {
			display_name => {
				'currency' => q(ດີນາ ຊູດານເກົ່າ),
			},
		},
		'SDG' => {
			display_name => {
				'currency' => q(ປອນ ຊູດານ),
			},
		},
		'SDP' => {
			display_name => {
				'currency' => q(ປອນ ຊູດານເກົ່າ),
			},
		},
		'SEK' => {
			display_name => {
				'currency' => q(ໂຄຣນາ ສະວີເດັນ),
			},
		},
		'SGD' => {
			display_name => {
				'currency' => q(ໂດລາ ສິງກະໂປ),
			},
		},
		'SHP' => {
			display_name => {
				'currency' => q(ປອນ ເຊັນເຮເຣນາ),
			},
		},
		'SIT' => {
			display_name => {
				'currency' => q(ໂຕລາ ສະໂລວິເນຍ),
			},
		},
		'SKK' => {
			display_name => {
				'currency' => q(ຄູໂຣນາ ສະໂລວັກ),
			},
		},
		'SLL' => {
			display_name => {
				'currency' => q(ເລໂອນ ຊີລາເລໂອນ),
			},
		},
		'SOS' => {
			display_name => {
				'currency' => q(ຊິລລິງ ໂຊມາເລຍ),
			},
		},
		'SRD' => {
			display_name => {
				'currency' => q(ດອນລາ ຊູຣິນາເມ),
			},
		},
		'SRG' => {
			display_name => {
				'currency' => q(ກິລເດີ ຊູຣິນາເມ),
			},
		},
		'SSP' => {
			display_name => {
				'currency' => q(ປອນ ຊູດານໃຕ້),
			},
		},
		'STD' => {
			display_name => {
				'currency' => q(ໂດບຣາ ຊາວຕົວເມ ແລະ ປຣິນຊິບປີ),
			},
		},
		'SUR' => {
			display_name => {
				'currency' => q(ຣູໂບ ໂຊວຽດ),
			},
		},
		'SVC' => {
			display_name => {
				'currency' => q(ໂກລອງ ເອກາວາດໍ),
			},
		},
		'SYP' => {
			display_name => {
				'currency' => q(ປອນ ຊິເຣຍ),
			},
		},
		'SZL' => {
			display_name => {
				'currency' => q(ລິລັນກິນີ ສະວາຊິແລນ),
			},
		},
		'THB' => {
			symbol => '฿',
			display_name => {
				'currency' => q(ບາດ ໄທ),
			},
		},
		'TJR' => {
			display_name => {
				'currency' => q(ຣູໂບ ຕັຈີກິສຖານ),
			},
		},
		'TJS' => {
			display_name => {
				'currency' => q(ໂຊໂມນີ ທາຈິກິສຖານ),
			},
		},
		'TMM' => {
			display_name => {
				'currency' => q(ມານັດ ຕວກເມນິສຖານ \(1966–1987\)),
			},
		},
		'TMT' => {
			display_name => {
				'currency' => q(ເມນັດ ຕວກເມນິດສະຖານ),
			},
		},
		'TND' => {
			display_name => {
				'currency' => q(ດີນາ ຕູນີເຊຍ),
			},
		},
		'TOP' => {
			display_name => {
				'currency' => q(ປາອັງກາ ຕອງກາ),
			},
		},
		'TPE' => {
			display_name => {
				'currency' => q(ເອສກູໂດ ຕີມໍ),
			},
		},
		'TRL' => {
			display_name => {
				'currency' => q(ລີຕາ ຕູຣາກີເກົ່າ),
			},
		},
		'TRY' => {
			display_name => {
				'currency' => q(ລິຣາ ເທີກີ),
			},
		},
		'TTD' => {
			display_name => {
				'currency' => q(ດອນລາທຣິນິແດດ ແລະ ໂທເບໂກ),
			},
		},
		'TWD' => {
			symbol => 'NT$',
			display_name => {
				'currency' => q(ໂດລາ ໄຕຫວັນ),
			},
		},
		'TZS' => {
			display_name => {
				'currency' => q(ຊິລລິງ ຕາຊາເນຍ),
			},
		},
		'UAH' => {
			display_name => {
				'currency' => q(ຮາຣິບເນຍ ຢູເຄຣນ),
			},
		},
		'UAK' => {
			display_name => {
				'currency' => q(ຄາໂບວາເນດ ອູແກຣນ),
			},
		},
		'UGS' => {
			display_name => {
				'currency' => q(ຊິນລິງ ອູກັນດາ \(1966–1987\)),
			},
		},
		'UGX' => {
			display_name => {
				'currency' => q(ຊິລລິງ ອູການດາ),
			},
		},
		'USD' => {
			symbol => 'US$',
			display_name => {
				'currency' => q(ໂດລ່າ ສະຫະລັດຯ),
				'other' => q(ໂດລ່າ ສະຫະລັດຯ),
			},
		},
		'USN' => {
			display_name => {
				'currency' => q(ດອນລາສະຫະລັດ \(ມື້ຖັດໄປ\)),
			},
		},
		'USS' => {
			display_name => {
				'currency' => q(ດອນລາສະຫະລັດ \(ມື້ດຽວກັນ\)),
			},
		},
		'UYI' => {
			display_name => {
				'currency' => q(ເປໂຊອູຣຸກວຍ \(ຫົວໜ່ວຍອິນເດັກ\)),
			},
		},
		'UYP' => {
			display_name => {
				'currency' => q(ເປໂຊ ອູຣຸກວຍ \(1975–1993\)),
			},
		},
		'UYU' => {
			display_name => {
				'currency' => q(ເປໂຊ ອູຣູກວາຍ),
			},
		},
		'UZS' => {
			display_name => {
				'currency' => q(ໂຊມ ອຸສເບກິສຖາານ),
			},
		},
		'VEB' => {
			display_name => {
				'currency' => q(ໂບລີວາ ເວເນຊູເອລາ \(1871–2008\)),
			},
		},
		'VEF' => {
			display_name => {
				'currency' => q(ໂບລິວາ ເວເນຊູເອລາ),
			},
		},
		'VND' => {
			symbol => '₫',
			display_name => {
				'currency' => q(ດົງ ຫວຽດນາມ),
			},
		},
		'VNN' => {
			display_name => {
				'currency' => q(ດົງ ຫວຽດນາມ \(1978–1985\)),
			},
		},
		'VUV' => {
			display_name => {
				'currency' => q(ວາຕູ ວານົວຕູ),
			},
		},
		'WST' => {
			display_name => {
				'currency' => q(ຕາລາ ຊາມົວ),
			},
		},
		'XAF' => {
			symbol => 'FCFA',
			display_name => {
				'currency' => q(ຟຣັງ ເຊຟານ ທະນາຄານລັດອາຟຣິກາກາງ),
			},
		},
		'XAG' => {
			display_name => {
				'currency' => q(ເງິນ),
			},
		},
		'XAU' => {
			display_name => {
				'currency' => q(ຄຳ),
			},
		},
		'XBA' => {
			display_name => {
				'currency' => q(ຫົວໜ່ວຍຄອມໂປຊິດ ເອີຣົບ),
			},
		},
		'XBB' => {
			display_name => {
				'currency' => q(ຫົວໜ່ວຍໂມນີແທຣີ ເອີຣົບ),
			},
		},
		'XBC' => {
			display_name => {
				'currency' => q(ຫົວໜ່ວຍບັນຊີເອີຣົບ \(XBC\)),
			},
		},
		'XBD' => {
			display_name => {
				'currency' => q(ຫົວໜ່ວຍບັນຊີເອີຣົບ \(XBD\)),
			},
		},
		'XCD' => {
			symbol => 'EC$',
			display_name => {
				'currency' => q(ດອນລາຄາຣີບຽນຕາເວັນອອກ),
			},
		},
		'XDR' => {
			display_name => {
				'currency' => q(ສິດທິຖອນເງິນພິເສດ),
			},
		},
		'XEU' => {
			display_name => {
				'currency' => q(ຫົວໜ່ວຍສະກຸນເງິນ ເອີຣົບ),
			},
		},
		'XFO' => {
			display_name => {
				'currency' => q(ຟຣັງ ຄຳຝຣັ່ງ),
			},
		},
		'XFU' => {
			display_name => {
				'currency' => q(ຟຣັງ ຢູໄອຊີ ຝຣັ່ງ),
			},
		},
		'XOF' => {
			symbol => 'CFA',
			display_name => {
				'currency' => q(ຟັງເຊຟານ ອາຟຣິກາຕາເວັນຕົກ),
			},
		},
		'XPD' => {
			display_name => {
				'currency' => q(ແພເລດຽມ),
			},
		},
		'XPF' => {
			symbol => 'CFPF',
			display_name => {
				'currency' => q(ຊີເອັບພີ ຝຣັ່ງ),
			},
		},
		'XPT' => {
			display_name => {
				'currency' => q(ແພລັດຕິນຳ),
			},
		},
		'XRE' => {
			display_name => {
				'currency' => q(ກອງທຶນໄຣເນັດ),
			},
		},
		'XTS' => {
			display_name => {
				'currency' => q(ລະຫັດທົດສອບສະກຸນເງິນ),
			},
		},
		'XXX' => {
			display_name => {
				'currency' => q(ສະກຸນເງິນທີ່ບໍ່ຮູ້ຈັກ),
				'other' => q(ສະກຸນເງິນທີ່ບໍ່ຮູ້ຈັກ),
			},
		},
		'YDD' => {
			display_name => {
				'currency' => q(ດີນາ ເຢເມນ),
			},
		},
		'YER' => {
			display_name => {
				'currency' => q(ຣຽວ ເຢເມນ),
			},
		},
		'YUD' => {
			display_name => {
				'currency' => q(ຮາດດີນາ ຢູໂກສະລາວີ),
			},
		},
		'YUM' => {
			display_name => {
				'currency' => q(ດີນາໃໝ່ ຢູໂກສະລາວີ \(1994–2002\)),
			},
		},
		'YUN' => {
			display_name => {
				'currency' => q(ດີນາ ທີ່ປ່ຽນສະພາບ ຢູໂກສະລາວີ \(1990–1992\)),
			},
		},
		'YUR' => {
			display_name => {
				'currency' => q(ດີນາ ປະຕິຮູບ ຢູໂກສະລາວີ \(1992–1993\)),
			},
		},
		'ZAL' => {
			display_name => {
				'currency' => q(ແຣນ ອາຟຣິກາໃຕ້ \(ການເງິນ\)),
			},
		},
		'ZAR' => {
			display_name => {
				'currency' => q(ແຣນ ອາຟຣິກາໃຕ້),
			},
		},
		'ZMK' => {
			display_name => {
				'currency' => q(ຄວາຊາ ຊັມເບຍ \(1968–2012\)),
			},
		},
		'ZMW' => {
			display_name => {
				'currency' => q(ຄວາຊາ ຊັມເບຍ),
			},
		},
		'ZRN' => {
			display_name => {
				'currency' => q(ແຊ ຄອງໂກໃໝ່),
			},
		},
		'ZRZ' => {
			display_name => {
				'currency' => q(ແຊຄອງໂກ),
			},
		},
		'ZWD' => {
			display_name => {
				'currency' => q(ດອນລາ ຊິມບັບເວ \(1980–2008\)),
			},
		},
		'ZWL' => {
			display_name => {
				'currency' => q(ດອນລາ ຊິມບັບເວ \(2009\)),
			},
		},
		'ZWR' => {
			display_name => {
				'currency' => q(ດອນລາ ຊິມບັບເວ \(2008\)),
			},
		},
	} },
);


has 'calendar_months' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
			'chinese' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'1',
							'2',
							'3',
							'4',
							'5',
							'6',
							'7',
							'8',
							'9',
							'10',
							'11',
							'12'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'1',
							'2',
							'3',
							'4',
							'5',
							'6',
							'7',
							'8',
							'9',
							'10',
							'11',
							'12'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'1',
							'2',
							'3',
							'4',
							'5',
							'6',
							'7',
							'8',
							'9',
							'10',
							'11',
							'12'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'1',
							'2',
							'3',
							'4',
							'5',
							'6',
							'7',
							'8',
							'9',
							'10',
							'11',
							'12'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'1',
							'2',
							'3',
							'4',
							'5',
							'6',
							'7',
							'8',
							'9',
							'10',
							'11',
							'12'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'1',
							'2',
							'3',
							'4',
							'5',
							'6',
							'7',
							'8',
							'9',
							'10',
							'11',
							'12'
						],
						leap => [
							
						],
					},
				},
			},
			'coptic' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'ເທົາ',
							'ບາບາ',
							'ຮາໂຕ',
							'ເຄຍ',
							'ໂທບາ',
							'ອຳເຊີ',
							'ບາລຳຮາດ',
							'ບາລາມູດາ',
							'ບາສຮານ',
							'ເປົານາ',
							'ອີແປບ',
							'ມາສລາ',
							'ນາຊິວ'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'1',
							'2',
							'3',
							'4',
							'5',
							'6',
							'7',
							'8',
							'9',
							'10',
							'11',
							'12',
							'13'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'ເທົາ',
							'ບາບາ',
							'ຮາໂຕ',
							'ເຄຍ',
							'ໂທບາ',
							'ອາເຊີ',
							'ບາລຳຮາດ',
							'ບາລາມູດາ',
							'ບາສຮານ',
							'ເປົານາ',
							'ອີແປບ',
							'ມາສລາ',
							'ນາຊີວ'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'ເທົາ',
							'ບາບາ',
							'ຮາໂຕ',
							'ເຄຍ',
							'ໂທບາ',
							'ອຳເຊີ',
							'ບາລຳຮາດ',
							'ບາລາມູດາ',
							'ບາສຮານ',
							'ເປົານາ',
							'ອີແປບ',
							'ມາສລາ',
							'ນາຊີວ'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'1',
							'2',
							'3',
							'4',
							'5',
							'6',
							'7',
							'8',
							'9',
							'10',
							'11',
							'12',
							'13'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'ເທົາ',
							'ບາບາ',
							'ຮາໂຕ',
							'ເຄຍ',
							'ໂທບາ',
							'ອຳເຊີ',
							'ບາລຳຮາດ',
							'ບາລາມູດາ',
							'ບາສຮານ',
							'ເປົານາ',
							'ອີແປບ',
							'ມາສລາ',
							'ນາຊີວ'
						],
						leap => [
							
						],
					},
				},
			},
			'ethiopic' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'ແມສເຄີແຣມ',
							'ເຕເກມ',
							'ເຮດາ',
							'ທາຊັສ',
							'ເທີ',
							'ເຍຄາທິດ',
							'ເມກາບິດ',
							'ເມຍເຊຍ',
							'ເຈນບອດ',
							'ເຊເນ',
							'ຮຳເລ',
							'ເນແຮສ໌',
							'ພາກູເມນ'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'1',
							'2',
							'3',
							'4',
							'5',
							'6',
							'7',
							'8',
							'9',
							'10',
							'11',
							'12',
							'13'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'ແມສເຄີແຣມ',
							'ເຕເກມ',
							'ເຮດາ',
							'ທາຊັສ',
							'ເທີ',
							'ເຍຄາທິດ',
							'ເມກາບິດ',
							'ເມຍເຊຍ',
							'ເຈນບອດ',
							'ເຊເນ',
							'ຮຳເລ',
							'ເນແຮສ໌',
							'ພາກູເມນ'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'ແມສເຄີແຣມ',
							'ເຕເກມ',
							'ເຮດາ',
							'ທາຊັສ',
							'ເທີ',
							'ເຍຄາທິດ',
							'ເມກາບິດ',
							'ເມຍເຊຍ',
							'ເຈນບອດ',
							'ເຊເນ',
							'ຮຳເລ',
							'ເນແຮສ໌',
							'ພາກູເມນ'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'1',
							'2',
							'3',
							'4',
							'5',
							'6',
							'7',
							'8',
							'9',
							'10',
							'11',
							'12',
							'13'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'ແມສເຄີແຣມ',
							'ເຕເກມ',
							'ເຮດາ',
							'ທາຊັສ',
							'ເທີ',
							'ເຍຄາທິດ',
							'ເມກາບິດ',
							'ເມຍເຊຍ',
							'ເຈນບອດ',
							'ເຊເນ',
							'ຮຳເລ',
							'ເນແຮສ໌',
							'ພາກູເມນ'
						],
						leap => [
							
						],
					},
				},
			},
			'gregorian' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'ມ.ກ.',
							'ກ.ພ.',
							'ມ.ນ.',
							'ມ.ສ.',
							'ພ.ພ.',
							'ມິ.ຖ.',
							'ກ.ລ.',
							'ສ.ຫ.',
							'ກ.ຍ.',
							'ຕ.ລ.',
							'ພ.ຈ.',
							'ທ.ວ.'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'1',
							'2',
							'3',
							'4',
							'5',
							'6',
							'7',
							'8',
							'9',
							'10',
							'11',
							'12'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'ມັງກອນ',
							'ກຸມພາ',
							'ມີນາ',
							'ເມສາ',
							'ພຶດສະພາ',
							'ມິຖຸນາ',
							'ກໍລະກົດ',
							'ສິງຫາ',
							'ກັນຍາ',
							'ຕຸລາ',
							'ພະຈິກ',
							'ທັນວາ'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'ມ.ກ.',
							'ກ.ພ.',
							'ມ.ນ.',
							'ມ.ສ.',
							'ພ.ພ.',
							'ມິ.ຖ.',
							'ກ.ລ.',
							'ສ.ຫ.',
							'ກ.ຍ.',
							'ຕ.ລ.',
							'ພ.ຈ.',
							'ທ.ວ.'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'1',
							'2',
							'3',
							'4',
							'5',
							'6',
							'7',
							'8',
							'9',
							'10',
							'11',
							'12'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'ມັງກອນ',
							'ກຸມພາ',
							'ມີນາ',
							'ເມສາ',
							'ພຶດສະພາ',
							'ມິຖຸນາ',
							'ກໍລະກົດ',
							'ສິງຫາ',
							'ກັນຍາ',
							'ຕຸລາ',
							'ພະຈິກ',
							'ທັນວາ'
						],
						leap => [
							
						],
					},
				},
			},
			'hebrew' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'ທຣິດຣີ',
							'ເຮວານ',
							'ກິດເລບ',
							'ເຕເວດ',
							'ຊີວັດ',
							'ອາດາ I',
							'ອາດາ',
							'ນິດຊານ',
							'ອີຍາຣ',
							'ສີວານ',
							'ຕາມູ',
							'ເອບ',
							'ອີລູ'
						],
						leap => [
							'',
							'',
							'',
							'',
							'',
							'',
							'ອາດາ II'
						],
					},
					wide => {
						nonleap => [
							'ທຣິດຣີ',
							'ເຮວານ',
							'ກິດເລບ',
							'ເຕເວດ',
							'ຊີວັດ',
							'ອາດາ I',
							'ອາດາ',
							'ນິດຊານ',
							'ອີຍາ',
							'ສີວານ',
							'ຕາມູ',
							'ເອບ',
							'ອີລູ'
						],
						leap => [
							'',
							'',
							'',
							'',
							'',
							'',
							'ອາດ II'
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'ທຣິດຣີ',
							'ເຮວານ',
							'ກິດເລບ',
							'ເຕເວດ',
							'ຊີວັດ',
							'ອາດາ I',
							'ອາດາ',
							'ນິດຊານ',
							'ອີຍາຣ',
							'ສີວານ',
							'ຕາມູ',
							'ເອບ',
							'ອີລູ'
						],
						leap => [
							'',
							'',
							'',
							'',
							'',
							'',
							'ອາດາ II'
						],
					},
					wide => {
						nonleap => [
							'ທຣິດຣີ',
							'ເຮວານ',
							'ກິດເລບ',
							'ເຕເວດ',
							'ຊີວັດ',
							'ອາດາ I',
							'ອາດາ',
							'ນິດຊານ',
							'ອີຍາ',
							'ສີວານ',
							'ຕາມູ',
							'ເອບ',
							'ອີລູ'
						],
						leap => [
							'',
							'',
							'',
							'',
							'',
							'',
							'ອາດາ II'
						],
					},
				},
			},
			'indian' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'ຈິຕຣາ',
							'ວິສາຂະ',
							'ເຊດຖາ',
							'ອັດສາ',
							'ສາຣາວານາ',
							'ພະຕຣາ',
							'ອັສວິຊາ',
							'ການຕິກາ',
							'ອັກຣາຮາຢານາ',
							'ປຸສາ',
							'ມາຄະ',
							'ຜາລກຸນີ'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'1',
							'2',
							'3',
							'4',
							'5',
							'6',
							'7',
							'8',
							'9',
							'10',
							'11',
							'12'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'ຈິຕຣາ',
							'ວິສາຂະ',
							'ເຊດຖາ',
							'ອັດສາ',
							'ສາຣາວານາ',
							'ພະຕຣາ',
							'ອັສວິຊາ',
							'ການຕິກາ',
							'ອັກຣາຮາຢານາ',
							'ປຸສະຍາ',
							'ມາຄະ',
							'ຜາລກຸນີ'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'ຈິຕຣາ',
							'ວິສາຂະ',
							'ເຊດຖາ',
							'ອັດສາ',
							'ສາຣາວານາ',
							'ພະຕຣາ',
							'ອັສວິຊາ',
							'ການຕິກາ',
							'ອັກຣາຮາຢານາ',
							'ປຸສະຍາ',
							'ມາຄະ',
							'ຜາລກຸນີ'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'1',
							'2',
							'3',
							'4',
							'5',
							'6',
							'7',
							'8',
							'9',
							'10',
							'11',
							'12'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'ຈິຕຣາ',
							'ວິສາຂະ',
							'ເຊດຖາ',
							'ອັດສາ',
							'ສາຣາວານາ',
							'ພະຕຣາ',
							'ອັສວິຊາ',
							'ການຕິກາ',
							'ອັກຣາຮາຢານາ',
							'ປຸສະຍາ',
							'ມາຄະ',
							'ຜາລກຸນີ'
						],
						leap => [
							
						],
					},
				},
			},
			'islamic' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'ມຸຮັດ',
							'ເຄາະ',
							'ຮອດບີ 1',
							'ຮອກບີ 2',
							'ນຸມາ 1',
							'ນຸມາ 2',
							'ເຮາະ',
							'ຊະອ໌',
							'ເຮາະມະ',
							'ເຊົາ',
							'ຊຸລກິອຸ',
							'ຊຸລຫິຈ'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'1',
							'2',
							'3',
							'4',
							'5',
							'6',
							'7',
							'8',
							'9',
							'10',
							'11',
							'12'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'ມຸຣະຮອມ',
							'ຊາຟາຣ',
							'ຮາບີ 1',
							'ຮາບີ 2',
							'ຈຸມາດາ 1',
							'ຈຸມາດາ 2',
							'ຮາຈັບ',
							'ຊະບານ',
							'ຮາມາດອນ',
							'ເຊົາວັດ',
							'ດຸອັດກິດະ',
							'ດຸອັດກິຈະ'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'ມຸຮັດ',
							'ເຄາະ',
							'ຮອກບີ 1',
							'ຮອກບີ 2',
							'ນຸມາ 1',
							'ນຸມາ 2',
							'ເຮາະ',
							'ຊາ',
							'ເຮາະມະ',
							'ເຊົາ',
							'ຊຸລກິອຸ',
							'ຊຸລຫິຈ'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'1',
							'2',
							'3',
							'4',
							'5',
							'6',
							'7',
							'8',
							'9',
							'10',
							'11',
							'12'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'ມຸຣະຮອມ',
							'ຊາຟາຣ',
							'ຮາບີ 1',
							'ຮາບີ 2',
							'ຈຸມາດາ 1',
							'ຈຸມາດາ 2',
							'ຮາຈັບ',
							'ຊະບານ',
							'ຮາມາດອນ',
							'ເຊົາວັດ',
							'ດຸອັດກິດະ',
							'ດຸອັດກິຈະ'
						],
						leap => [
							
						],
					},
				},
			},
			'persian' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'ຟາຣວາດິນ',
							'ອໍຣດີບີເຫຣດ',
							'ຄໍຣເດດ',
							'ແຕຣ',
							'ມໍຣເດດ',
							'ຊາຣຫິວາ',
							'ເມີ',
							'ອາບານ',
							'ອາຊາ',
							'ດີຣ',
							'ບຣາມານ',
							'ເອສຟານ'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'1',
							'2',
							'3',
							'4',
							'5',
							'6',
							'7',
							'8',
							'9',
							'10',
							'11',
							'12'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'ຟຣາວາດິນ',
							'ອໍຣດີບີເຫຣດ',
							'ຄໍຣເດດ',
							'ແຕຣ',
							'ມໍຣດາເ',
							'ຊາຣຫິວາ',
							'ເມີ',
							'ອາບານ',
							'ອາຊາຣ',
							'ດີຣ',
							'ບຣາແມນ',
							'ເອສຟານ'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'ຟຣາວາດິນ',
							'ອໍຣດີບີເຫຮດ',
							'ຄໍຣເດດ',
							'ແຕຣ',
							'ມໍຣເດດ',
							'ຊາຣລິວາ',
							'ເມີ',
							'ອາບານ',
							'ອາຊາ',
							'ດີຣ',
							'ບຣາມານ',
							'ເອສຟານ'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'1',
							'2',
							'3',
							'4',
							'5',
							'6',
							'7',
							'8',
							'9',
							'10',
							'11',
							'12'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'ຟຣາວາດິນ',
							'ອໍຣດີບີເຫຣດ',
							'ຄໍຣເດດ',
							'ແຕຣ',
							'ມໍຣເດດ',
							'ຊາຣຫິວາ',
							'ເມີ',
							'ອາບານ',
							'ອາຊາຣ',
							'ດີຣ',
							'ບຣາແມນ',
							'ເອສຟານ'
						],
						leap => [
							
						],
					},
				},
			},
	} },
);

has 'calendar_days' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {
						mon => 'ວັນຈັນ',
						tue => 'ວັນອັງຄານ',
						wed => 'ວັນພຸດ',
						thu => 'ວັນພະຫັດ',
						fri => 'ວັນສຸກ',
						sat => 'ວັນເສົາ',
						sun => 'ວັນອາທິດ'
					},
					narrow => {
						mon => '2',
						tue => '3',
						wed => '4',
						thu => '5',
						fri => '6',
						sat => '7',
						sun => '1'
					},
					short => {
						mon => 'ວັນຈັນ',
						tue => 'ວັນອັງຄານ',
						wed => 'ວັນພຸດ',
						thu => 'ວັນພະຫັດ',
						fri => 'ວັນສຸກ',
						sat => 'ວັນເສົາ',
						sun => 'ວັນອາທິດ'
					},
					wide => {
						mon => 'ວັນຈັນ',
						tue => 'ວັນອັງຄານ',
						wed => 'ວັນພຸດ',
						thu => 'ວັນພະຫັດ',
						fri => 'ວັນສຸກ',
						sat => 'ວັນເສົາ',
						sun => 'ວັນອາທິດ'
					},
				},
				'stand-alone' => {
					abbreviated => {
						mon => 'ວັນຈັນ',
						tue => 'ວັນອັງຄານ',
						wed => 'ວັນພຸດ',
						thu => 'ວັນພະຫັດ',
						fri => 'ວັນສຸກ',
						sat => 'ວັນເສົາ',
						sun => 'ວັນອາທິດ'
					},
					narrow => {
						mon => 'ຈ',
						tue => 'ຄ',
						wed => '​ພຸ',
						thu => 'ພ',
						fri => '​ສຸ',
						sat => 'ສ',
						sun => 'ທ'
					},
					short => {
						mon => 'ຈັນ',
						tue => 'ຄ',
						wed => 'ພ',
						thu => 'ພຫ',
						fri => 'ວັນສຸກ',
						sat => 'ເສົາ',
						sun => 'ອ.ທ.'
					},
					wide => {
						mon => 'ວັນຈັນ',
						tue => 'ວັນອັງຄານ',
						wed => 'ວັນພຸດ',
						thu => 'ວັນພະຫັດ',
						fri => 'ວັນສຸກ',
						sat => 'ວັນເສົາ',
						sun => 'ວັນອາທິດ'
					},
				},
			},
	} },
);

has 'calendar_quarters' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {0 => 'ຕມ1',
						1 => 'ຕມ2',
						2 => 'ຕມ3',
						3 => 'ຕມ4'
					},
					narrow => {0 => '1',
						1 => '2',
						2 => '3',
						3 => '4'
					},
					wide => {0 => 'ໄຕຣມາດ 1',
						1 => 'ໄຕຣມາດ 2',
						2 => 'ໄຕຣມາດ 3',
						3 => 'ໄຕຣມາດ 4'
					},
				},
				'stand-alone' => {
					abbreviated => {0 => 'ຕ1',
						1 => 'ຕ2',
						2 => 'ຕ3',
						3 => 'ຕ4'
					},
					narrow => {0 => '1',
						1 => '2',
						2 => '3',
						3 => '4'
					},
					wide => {0 => 'ໄຕຣມາດ 1',
						1 => 'ໄຕຣມາດ 2',
						2 => 'ໄຕຣມາດ 3',
						3 => 'ໄຕຣມາດ 4'
					},
				},
			},
	} },
);

has 'day_periods' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			'format' => {
				'wide' => {
					'pm' => q{ຫຼັງທ່ຽງ},
					'am' => q{ກ່ອນທ່ຽງ},
				},
			},
		},
	} },
);

has 'eras' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'buddhist' => {
			abbreviated => {
				'0' => 'ພ.ສ.'
			},
		},
		'chinese' => {
		},
		'coptic' => {
		},
		'ethiopic' => {
		},
		'generic' => {
		},
		'gregorian' => {
			abbreviated => {
				'0' => 'ກ່ອນ ຄ.ສ.',
				'1' => 'ຄ.ສ.'
			},
		},
		'hebrew' => {
			abbreviated => {
				'0' => 'AM'
			},
		},
		'indian' => {
			abbreviated => {
				'0' => 'ມ.ສ.'
			},
		},
		'islamic' => {
			abbreviated => {
				'0' => 'AH'
			},
		},
		'japanese' => {
			abbreviated => {
				'0' => 'ທະອິກະ (645–650)',
				'1' => 'ຮາກູຊິ (650–671)',
				'2' => 'ຮາກູໂຮ (672–686)',
				'3' => 'ຊູໂຊ (686–701)',
				'4' => 'ທາອິໂຮ (701–704)',
				'5' => 'ເຄອຸງ (704–708)',
				'6' => 'ວະໂດ (708–715)',
				'7' => 'ເຣອິກິ (715–717)',
				'8' => 'ໂຢໂຣ (717–724)',
				'9' => 'ຈິງກິ (724–729)',
				'10' => 'ເທັມປຽວ (729–749)',
				'11' => 'ເທັມປຽວ-ຄໍາໂປ (749–749)',
				'12' => 'ເທັມປຽວ-ໂຊໂຮ (749–757)',
				'13' => 'ເທັມປຽວ-ໂຮຈິ (757–765)',
				'14' => 'ເທັມປຽວ-ຈິງໂງະ (765–767)',
				'15' => 'ຈິງໂງະ-ເຄອຸງ (767–770)',
				'16' => 'ໂຮກິ (770–780)',
				'17' => 'ເທັນ-ໂອ (781–782)',
				'18' => 'ເອັນຣຢາກຸ (782–806)',
				'19' => 'ດາອິໂດ (806–810)',
				'20' => 'ໂກນິນ (810–824)',
				'21' => 'ເທັນໂຊ (824–834)',
				'22' => 'ໂຊວະ (834–848)',
				'23' => 'ກະໂຈ (848–851)',
				'24' => 'ນິນຈູ (851–854)',
				'25' => 'ສະອິໂກະ (854–857)',
				'26' => 'ເທັນນານ (857–859)',
				'27' => 'ໂຈງານ (859–877)',
				'28' => 'ເກັນເກ (877–885)',
				'29' => 'ນິນນາ (885–889)',
				'30' => 'ກໍາປຽວ (889–898)',
				'31' => 'ໂຊຕາອິ (898–901)',
				'32' => 'ເອັນງິ (901–923)',
				'33' => 'ເອັນໂຊ (923–931)',
				'34' => 'ໂຊເຮ (931–938)',
				'35' => 'ເທັນງຽວ (938–947)',
				'36' => 'ເທັນຣຢາກູ (947–957)',
				'37' => 'ເທັນໂຕະກຸ (957–961)',
				'38' => 'ໂອວະ (961–964)',
				'39' => 'ໂກໂຮ (964–968)',
				'40' => 'ອານະ (968–970)',
				'41' => 'ເທັນໂຣະກຸ (970–973)',
				'42' => 'ເທັນ-ເອັນ (973–976)',
				'43' => 'ໂຈເງັນ (976–978)',
				'44' => 'ເທັນເງັນ (978–983)',
				'45' => 'ເອການ (983–985)',
				'46' => 'ການນະ (985–987)',
				'47' => 'ເອ-ເອັນ (987–989)',
				'48' => 'ເອໂຊ (989–990)',
				'49' => 'ໂຊຣຢະກຸ (990–995)',
				'50' => 'ໂຊໂຕະກຸ (995–999)',
				'51' => 'ໂຊໂຮ (999–1004)',
				'52' => 'ການໂກ (1004–1012)',
				'53' => 'ໂຊຫວະ (1012–1017)',
				'54' => 'ການນິງ (1017–1021)',
				'55' => 'ຈິອານ (1021–1024)',
				'56' => 'ມານຈຸ (1024–1028)',
				'57' => 'ໂຊເງັນ (1028–1037)',
				'58' => 'ໂຊເຣຢະກຸ (1037–1040)',
				'59' => 'ໂຊຄິວ (1040–1044)',
				'60' => 'ການໂຕະກຸ (1044–1046)',
				'61' => 'ເອະໂຊ (1046–1053)',
				'62' => 'ເທັນງິ (1053–1058)',
				'63' => 'ໂກເຮ (1058–1065)',
				'64' => 'ຈິເຣຢະກຸ (1065–1069)',
				'65' => 'ເອັນຄິວ (1069–1074)',
				'66' => 'ໂຊະໂຮ (1074–1077)',
				'67' => 'ໂຊະເຣຢະກຸ (1077–1081)',
				'68' => 'ເອໂຊະ (1081–1084)',
				'69' => 'ໂອໂຕະກຸ (1084–1087)',
				'70' => 'ການຈິ (1087–1094)',
				'71' => 'ກາໂຊ (1094–1096)',
				'72' => 'ເອະໂຊະ (1096–1097)',
				'73' => 'ໂຊະໂຕະກຸ (1097–1099)',
				'74' => 'ໂກະວະ (1099–1104)',
				'75' => 'ໂຊະຈິ (1104–1106)',
				'76' => 'ກາໂຊະ (1106–1108)',
				'77' => 'ເທັນນິນ (1108–1110)',
				'78' => 'ເທັນ-ອິ (1110–1113)',
				'79' => 'ເອກິວ (1113–1118)',
				'80' => 'ເຄັນ-ເອ (1118–1120)',
				'81' => 'ໂຮະອານ (1120–1124)',
				'82' => 'ເທັນຈິ (1124–1126)',
				'83' => 'ດາອິຈິ (1126–1131)',
				'84' => 'ເທັນໂຊະ (1131–1132)',
				'85' => 'ໂຊະໂຊະ (1132–1135)',
				'86' => 'ໂຮເອັນ (1135–1141)',
				'87' => 'ເອຈິ (1141–1142)',
				'88' => 'ໂກະຈິ (1142–1144)',
				'89' => 'ເທັນໂຢະ (1144–1145)',
				'90' => 'ຄິວອານ (1145–1151)',
				'91' => 'ນິນເປ (1151–1154)',
				'92' => 'ຄິວຈຸ (1154–1156)',
				'93' => 'ໂຮເຄັນ (1156–1159)',
				'94' => 'ເຮຈິ (1159–1160)',
				'95' => 'ເອເຣຢະກຸ (1160–1161)',
				'96' => 'ໂອໂຊ (1161–1163)',
				'97' => 'ໂຊະການ (1163–1165)',
				'98' => 'ເອມານ (1165–1166)',
				'99' => 'ນິນ-ອານ (1166–1169)',
				'100' => 'ກະໂອ (1169–1171)',
				'101' => 'ໂຊະອານ (1171–1175)',
				'102' => 'ອານເຄັນ (1175–1177)',
				'103' => 'ຈິໂຊະ (1177–1181)',
				'104' => 'ໂຢະວະ (1181–1182)',
				'105' => 'ຈຸເອະ (1182–1184)',
				'106' => 'ເຄັນເຣຢຸກິ (1184–1185)',
				'107' => 'ບັນຈິ (1185–1190)',
				'108' => 'ເກັນຄິວ (1190–1199)',
				'109' => 'ໂຊຈິ (1199–1201)',
				'110' => 'ເກັນນິນ (1201–1204)',
				'111' => 'ເຄັນກິວ (1204–1206)',
				'112' => 'ເກັນ-ເອະ (1206–1207)',
				'113' => 'ໂຊະເຄັນ (1207–1211)',
				'114' => 'ເກັນເຣຢະກຸ (1211–1213)',
				'115' => 'ເກັນໂປະ (1213–1219)',
				'116' => 'ໂຊະກິວ (1219–1222)',
				'117' => 'ໂຈະໂອະ (1222–1224)',
				'118' => 'ເຄັນນິນ (1224–1225)',
				'119' => 'ກາໂຮກຸ (1225–1227)',
				'120' => 'ອານເຕະ (1227–1229)',
				'121' => 'ການກິ (1229–1232)',
				'122' => 'ໂຈະເອະ (1232–1233)',
				'123' => 'ເທັມປຸກຸ (1233–1234)',
				'124' => 'ບັນເຣຢະກຸ (1234–1235)',
				'125' => 'ກາເຕະ (1235–1238)',
				'126' => 'ເຣຢະກຸນິນ (1238–1239)',
				'127' => 'ເອັນ-ໂອ (1239–1240)',
				'128' => 'ນິນຈີ (1240–1243)',
				'129' => 'ຄານເຈນ (1243–1247)',
				'130' => 'ໂຫຈີ (1247–1249)',
				'131' => 'ເຄນໂຊ (1249–1256)',
				'132' => 'ໂຄເຈນ (1256–1257)',
				'133' => 'ໂຊກາ (1257–1259)',
				'134' => 'ໂຊເກນ (1259–1260)',
				'135' => 'ບຸນ-ໂອ (1260–1261)',
				'136' => 'ໂຄໂຊ (1261–1264)',
				'137' => 'ບຸນ-ອີ (1264–1275)',
				'138' => 'ເຄນຈີ (1275–1278)',
				'139' => 'ເຄິນ (1278–1288)',
				'140' => 'ໂຊ (1288–1293)',
				'141' => 'ອິນນິນ (1293–1299)',
				'142' => 'ເຊີນ (1299–1302)',
				'143' => 'ເຄນເຈນ (1302–1303)',
				'144' => 'ຄາເຈນ (1303–1306)',
				'145' => 'ໂຕກູຈິ (1306–1308)',
				'146' => 'ອິນກິ (1308–1311)',
				'147' => 'ໂອໂຊ (1300–1312)',
				'148' => 'ໂຊວາ (1312–1317)',
				'149' => 'ບຸນໂປ (1317–1319)',
				'150' => 'ຈີໂນ (1319–1321)',
				'151' => 'ເຈນກຽວ (1321–1324)',
				'152' => 'ໂຊຊິ (1324–1326)',
				'153' => 'ຄາຣາກິ (1326–1329)',
				'154' => 'ເຈນໂຕກູ (1329–1331)',
				'155' => 'ເຈນໂກ (1331–1334)',
				'156' => 'ເກັມມຸ (1334–1336)',
				'157' => 'ເອັນເຈັນ (1336–1340)',
				'158' => 'ໂກໂກກຸ (1340–1346)',
				'159' => 'ໂຊຊິ (1346–1370)',
				'160' => 'ເຄນໂຕກຸ (1370–1372)',
				'161' => 'ບຸນຊຸ (1372–1375)',
				'162' => 'ເທັນຈຸ (1375–1379)',
				'163' => 'ຄໍຢາກຸ (1379–1381)',
				'164' => 'ໂກວາ (1381–1384)',
				'165' => 'ເຈັນຊຸ (1384–1392)',
				'166' => 'ມີໂຕກຸ (1384–1387)',
				'167' => 'ກາກິ (1387–1389)',
				'168' => 'ຄູ (1389–1390)',
				'169' => 'ມິໂຕກຸ (1390–1394)',
				'170' => 'ໂອອິ (1394–1428)',
				'171' => 'ໂຊໂຊ (1428–1429)',
				'172' => 'ອິກຽວ (1429–1441)',
				'173' => 'ກາກິຊຸ (1441–1444)',
				'174' => 'ບຸນ-ອານ (1444–1449)',
				'175' => 'ໂຫໂຕກຸ (1449–1452)',
				'176' => 'ກຽວໂຕກຸ (1452–1455)',
				'177' => 'ເກໂຊ (1455–1457)',
				'178' => 'ໂຊໂຣກຸ (1457–1460)',
				'179' => 'ຄານໂຊ (1460–1466)',
				'180' => 'ບຸນໂຊ (1466–1467)',
				'181' => 'ໂອນິນ (1467–1469)',
				'182' => 'ບຸນມິ (1469–1487)',
				'183' => 'ໂຊກຽວ (1487–1489)',
				'184' => 'ເອັນໂຕກຸ (1489–1492)',
				'185' => 'ມິໂອ (1492–1501)',
				'186' => 'ບຸນກິ (1501–1504)',
				'187' => 'ອິໂຊ (1504–1521)',
				'188' => 'ໄຕອິ (1521–1528)',
				'189' => 'ກຽວໂຣກຸ (1528–1532)',
				'190' => 'ເທັນມອນ (1532–1555)',
				'191' => 'ໂກຈິ (1555–1558)',
				'192' => 'ອິໂຣກຸ (1558–1570)',
				'193' => 'ເຈັນກິ (1570–1573)',
				'194' => 'ເທັນໂຊ (1573–1592)',
				'195' => 'ບຸນໂຣກຸ (1592–1596)',
				'196' => 'ຄິໂຊ (1596–1615)',
				'197' => 'ເກັນວາ (1615–1624)',
				'198' => 'ຄານ-ອິ (1624–1644)',
				'199' => 'ໂຊໂຊ (1644–1648)',
				'200' => 'ຄຽນ (1648–1652)',
				'201' => 'ຊຸ (1652–1655)',
				'202' => 'ເມຍຢາກຸ (1655–1658)',
				'203' => 'ແມນຈິ (1658–1661)',
				'204' => 'ການບຸນ (1661–1673)',
				'205' => 'ເອັນໂປ (1673–1681)',
				'206' => 'ເທັນວາ (1681–1684)',
				'207' => 'ໂຈກຽວ (1684–1688)',
				'208' => 'ເຈັນໂຣກຸ (1688–1704)',
				'209' => 'ໂຫອິ (1704–1711)',
				'210' => 'ຊຸຕຸກຸ (1711–1716)',
				'211' => 'ກຽວຫຸ (1716–1736)',
				'212' => 'ເຈັນບຸນ (1736–1741)',
				'213' => 'ຄານໂປ (1741–1744)',
				'214' => 'ເອັນກຽວ (1744–1748)',
				'215' => 'ຄານ-ອິນ (1748–1751)',
				'216' => 'ໂຫຢາກຸ (1751–1764)',
				'217' => 'ເມຍວາ (1764–1772)',
				'218' => 'ເອັນ-ອິ (1772–1781)',
				'219' => 'ເທັນມິ (1781–1789)',
				'220' => 'ຄານຊິ (1789–1801)',
				'221' => 'ກຽວວາ (1801–1804)',
				'222' => 'ບຸນກາ (1804–1818)',
				'223' => 'ບຸນຊິ (1818–1830)',
				'224' => 'ເທັນໂປ (1830–1844)',
				'225' => 'ກຸກາ (1844–1848)',
				'226' => 'ກາອິ (1848–1854)',
				'227' => 'ແອັນຊິ (1854–1860)',
				'228' => 'ແມັນ-ເອັນ (1860–1861)',
				'229' => 'ບຸນກຸ (1861–1864)',
				'230' => 'ເຈນຈີ (1864–1865)',
				'231' => 'ຄີໂອ (1865–1868)',
				'232' => 'ມີຈີ',
				'233' => 'ໄຕໂຊ',
				'234' => 'ໂຊວາ',
				'235' => 'ຮີຊີ'
			},
		},
		'persian' => {
			abbreviated => {
				'0' => 'ປີເປີເຊຍ'
			},
		},
		'roc' => {
			abbreviated => {
				'0' => 'ກ່ອນ R.O.C.'
			},
		},
	} },
);

has 'date_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'buddhist' => {
		},
		'chinese' => {
			'full' => q{EEEE, U MMMM dd},
			'long' => q{U MMMM d},
			'medium' => q{U MMM d},
			'short' => q{y-M-d},
		},
		'coptic' => {
		},
		'ethiopic' => {
		},
		'generic' => {
			'full' => q{EEEEທີ d MMMM y G},
			'long' => q{d MMMM y G},
			'medium' => q{d MMM y G},
			'short' => q{d/M/y GGGGG},
		},
		'gregorian' => {
			'full' => q{EEEE ທີ d MMMM G y},
			'long' => q{d MMMM y},
			'medium' => q{d MMM y},
			'short' => q{d/M/y},
		},
		'hebrew' => {
		},
		'indian' => {
		},
		'islamic' => {
			'full' => q{EEEE, y MMMM dd},
			'long' => q{y MMMM d},
			'medium' => q{y MMM d},
			'short' => q{y-MM-dd},
		},
		'japanese' => {
		},
		'persian' => {
		},
		'roc' => {
		},
	} },
);

has 'time_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'buddhist' => {
		},
		'chinese' => {
		},
		'coptic' => {
		},
		'ethiopic' => {
		},
		'generic' => {
		},
		'gregorian' => {
			'full' => q{H ໂມງ m ນາທີ ss ວິນາທີ zzzz},
			'long' => q{H ໂມງ m ນາທີ ss ວິນາທີ z},
			'medium' => q{H:mm:ss},
			'short' => q{H:mm},
		},
		'hebrew' => {
		},
		'indian' => {
		},
		'islamic' => {
		},
		'japanese' => {
		},
		'persian' => {
		},
		'roc' => {
		},
	} },
);

has 'datetime_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'buddhist' => {
		},
		'chinese' => {
		},
		'coptic' => {
		},
		'ethiopic' => {
		},
		'generic' => {
			'full' => q{{1}, {0}},
			'long' => q{{1}, {0}},
			'medium' => q{{1}, {0}},
			'short' => q{{1}, {0}},
		},
		'gregorian' => {
			'full' => q{{1}, {0}},
			'long' => q{{1}, {0}},
			'medium' => q{{1}, {0}},
			'short' => q{{1}, {0}},
		},
		'hebrew' => {
		},
		'indian' => {
		},
		'islamic' => {
		},
		'japanese' => {
		},
		'persian' => {
		},
		'roc' => {
		},
	} },
);

has 'datetime_formats_available_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			EHm => q{E HH:mm},
			EHms => q{E HH:mm:ss},
			Ed => q{E, d},
			Ehm => q{E h:mm a},
			Ehms => q{E h:mm:ss a},
			Gy => q{G y},
			GyMMM => q{MMM, G y},
			GyMMMEd => q{E d MMMM, G y},
			GyMMMd => q{d MMMM, G y},
			H => q{HH},
			Hm => q{HH:mm},
			Hms => q{HH:mm:ss},
			M => q{L},
			MEd => q{E, d/M},
			MMM => q{LLL},
			MMMEd => q{E d MMM},
			MMMd => q{d MMM},
			Md => q{d/M},
			d => q{d},
			h => q{h ໂມງa},
			hm => q{h:mm a},
			hms => q{h:mm:ss a},
			ms => q{mm:ss},
			y => q{y},
			yM => q{M/y},
			yMEd => q{E, d/M/y},
			yMMM => q{MMM y},
			yMMMEd => q{E, d MMM y},
			yMMMd => q{d MMM y},
			yMd => q{d/M/y},
			yQQQ => q{QQQ y},
			yQQQQ => q{QQQQ y},
		},
		'islamic' => {
			H => q{H},
			Hm => q{H:mm},
			Hms => q{HH:mm:ss},
			M => q{L},
			MEd => q{E, d/M},
			MMM => q{LLL},
			MMMEd => q{E MMM d},
			MMMd => q{d MMM},
			Md => q{d/M},
			d => q{d},
			h => q{ha},
			hm => q{h mm a},
			hms => q{H:mm:ss},
			ms => q{mm:ss},
			y => q{y},
			yM => q{M/y},
			yMEd => q{E M/d/y},
			yMMM => q{MMM y},
			yMMMEd => q{E,MMM d,y},
			yQQQ => q{QQQ y},
			yQQQQ => q{QQQQ y},
		},
		'generic' => {
			Ed => q{E d},
			Gy => q{G y},
			GyMMM => q{G MMM y},
			GyMMMEd => q{G E, d MMM y},
			GyMMMd => q{G d MMM y},
			H => q{HH},
			Hm => q{HH:mm},
			Hms => q{HH:mm:ss},
			M => q{L},
			MEd => q{E, d/M},
			MMM => q{LLL},
			MMMEd => q{E d MMM},
			MMMd => q{d MMM},
			Md => q{d/M},
			d => q{d},
			h => q{h ໂມງa},
			hm => q{h:mm a},
			hms => q{h:mm:ss a},
			ms => q{mm:ss},
			y => q{G y},
			yyyy => q{G y},
			yyyyM => q{G M/y},
			yyyyMEd => q{E, G d/M/y},
			yyyyMMM => q{G MMM y},
			yyyyMMMEd => q{E, G d MMM y},
			yyyyMMMd => q{G d MMM y},
			yyyyMd => q{G d/M/y},
			yyyyQQQ => q{G QQQ y},
			yyyyQQQQ => q{G y QQQQ},
		},
	} },
);

has 'datetime_formats_append_item' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			'Timezone' => '{0} {1}',
		},
	} },
);

has 'datetime_formats_interval' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			H => {
				H => q{HH–HH},
			},
			Hm => {
				H => q{HH:mm–HH:mm},
				m => q{HH:mm–HH:mm},
			},
			Hmv => {
				H => q{HH:mm–HH:mm v},
				m => q{HH:mm–HH:mm v},
			},
			Hv => {
				H => q{HH–HH v},
			},
			M => {
				M => q{M–M},
			},
			MEd => {
				M => q{E, dd/MM – E, dd/MM},
				d => q{E, dd/MM – E, dd/MM},
			},
			MMM => {
				M => q{LLL–LLL},
			},
			MMMEd => {
				M => q{E, d/MM – E, d/MM},
				d => q{E, d/MM – E, d/MM},
			},
			MMMd => {
				M => q{d/MM – d/MM},
				d => q{d/MM – d/MM},
			},
			Md => {
				M => q{dd/MM – dd/MM},
				d => q{dd/MM – dd/MM},
			},
			d => {
				d => q{d–d},
			},
			fallback => '{0} – {1}',
			h => {
				a => q{h a – h a},
				h => q{h–h a},
			},
			hm => {
				a => q{h:mm a – h:mm a},
				h => q{h:mm–h:mm a},
				m => q{h:mm–h:mm a},
			},
			hmv => {
				a => q{h:mm a – h:mm a v},
				h => q{h:mm–h:mm a v},
				m => q{h:mm–h:mm a v},
			},
			hv => {
				a => q{h a – h a v},
				h => q{h–h a v},
			},
			y => {
				y => q{y–y},
			},
			yM => {
				M => q{MM/y – MM/y},
				y => q{y/MM – y/MM},
			},
			yMEd => {
				M => q{E, dd/MM/y – E, dd/MM/y},
				d => q{E, dd/MM/y – E, dd/MM/y},
				y => q{E, dd/MM/y – E, dd/MM/y},
			},
			yMMM => {
				M => q{MM/y – MM/y},
				y => q{MM/y – MM/y},
			},
			yMMMEd => {
				M => q{E, dd/MM/y – E, dd/MM/y},
				d => q{E, dd/MM/y – E, dd/MM/y},
				y => q{E, dd/MM/y – E, dd/MM/y},
			},
			yMMMM => {
				M => q{MM/y – MM},
				y => q{MM/y – MM/y},
			},
			yMMMd => {
				M => q{d/MM/y – d/MM},
				d => q{d/MM/y – d/MM/y},
				y => q{dd/MM/y – dd/MM/y},
			},
			yMd => {
				M => q{dd/MM/y – dd/MM/y},
				d => q{dd/MM/y – dd/MM/y},
				y => q{dd/MM/y – dd/MM/y},
			},
		},
		'generic' => {
			H => {
				H => q{HH–HH},
			},
			Hm => {
				H => q{HH:mm–HH:mm},
				m => q{HH:mm–HH:mm},
			},
			Hmv => {
				H => q{HH:mm–HH:mm v},
				m => q{HH:mm–HH:mm v},
			},
			Hv => {
				H => q{HH–HH v},
			},
			M => {
				M => q{M–M},
			},
			MEd => {
				M => q{E, MM-dd – E, MM-dd},
				d => q{E, MM-dd – E, MM-dd},
			},
			MMM => {
				M => q{LLL–LLL},
			},
			MMMEd => {
				M => q{E, MM-d – E, MM-d},
				d => q{E, MM-d – E, MM-d},
			},
			MMMd => {
				M => q{MM-d – MM-d},
				d => q{MM-d – d},
			},
			Md => {
				M => q{MM-dd – MM-dd},
				d => q{MM-dd – dd},
			},
			d => {
				d => q{d–d},
			},
			fallback => '{0} – {1}',
			h => {
				a => q{h a – h a},
				h => q{h–h a},
			},
			hm => {
				a => q{h:mm a – h:mm a},
				h => q{h:mm–h:mm a},
				m => q{h:mm–h:mm a},
			},
			hmv => {
				a => q{h:mm a – h:mm a v},
				h => q{h:mm–h:mm a v},
				m => q{h:mm–h:mm a v},
			},
			hv => {
				a => q{h a – h a v},
				h => q{h–h a v},
			},
			y => {
				y => q{G y–y},
			},
			yM => {
				M => q{G y-MM – MM},
				y => q{G y-MM – y-MM},
			},
			yMEd => {
				M => q{E, G y-MM-dd – E, y-MM-dd},
				d => q{E, G y-MM-dd – E, y-MM-dd},
				y => q{E, G y-MM-dd – E, y-MM-dd},
			},
			yMMM => {
				M => q{G y-MM – MM},
				y => q{G y-MM – y-MM},
			},
			yMMMEd => {
				M => q{E, G y-MM-dd – E, y-MM-dd},
				d => q{E, G y-MM-dd – E, y-MM-dd},
				y => q{E, G y-MM-dd – E, y-MM-dd},
			},
			yMMMM => {
				M => q{G y-MM – MM},
				y => q{G y-MM – y-MM},
			},
			yMMMd => {
				M => q{G y-MM-dd – MM-d},
				d => q{G y-MM-d – d},
				y => q{G y-MM-dd – y-MM-dd},
			},
			yMd => {
				M => q{G y-MM-dd – MM-dd},
				d => q{G y-MM-dd – dd},
				y => q{G y-MM-dd – y-MM-dd},
			},
		},
	} },
);

has 'time_zone_names' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default	=> sub { {
		hourFormat => q(+HH:mm;-HH:mm),
		gmtFormat => q(GMT{0}),
		gmtZeroFormat => q(GMT),
		regionFormat => q(ເວລາ {0}),
		regionFormat => q({0} (+1)),
		regionFormat => q({0} (+0)),
		fallbackFormat => q({1} ({0})),
		'Acre' => {
			long => {
				'daylight' => q(ເວລາລະດູຮ້ອນຂອງອາເກຣ),
				'generic' => q(ເວລາຂອງອາເກຣ),
				'standard' => q(ເວລາມາດຕະຖານຂອງອາເກຣ),
			},
		},
		'Afghanistan' => {
			long => {
				'standard' => q(ເວລາ ອັຟການິສຖານ),
			},
		},
		'Africa/Abidjan' => {
			exemplarCity => q#ອາບິດແຈນ#,
		},
		'Africa/Accra' => {
			exemplarCity => q#ອັກກາ#,
		},
		'Africa/Addis_Ababa' => {
			exemplarCity => q#ແອດດິດອາບາບາ#,
		},
		'Africa/Algiers' => {
			exemplarCity => q#ແອເຈຍ#,
		},
		'Africa/Asmera' => {
			exemplarCity => q#ອາສມາລາ#,
		},
		'Africa/Bamako' => {
			exemplarCity => q#ບາມາໂກ#,
		},
		'Africa/Bangui' => {
			exemplarCity => q#ບັງກີ#,
		},
		'Africa/Banjul' => {
			exemplarCity => q#ບານຈູ#,
		},
		'Africa/Bissau' => {
			exemplarCity => q#ບິດເຊົາ#,
		},
		'Africa/Blantyre' => {
			exemplarCity => q#ແບນໄທສ#,
		},
		'Africa/Brazzaville' => {
			exemplarCity => q#ບາຊາວິດ#,
		},
		'Africa/Bujumbura' => {
			exemplarCity => q#ບູຈູມບູລາ#,
		},
		'Africa/Cairo' => {
			exemplarCity => q#ໄຄໂລ#,
		},
		'Africa/Casablanca' => {
			exemplarCity => q#ຄາຊາບລັງກາ#,
		},
		'Africa/Ceuta' => {
			exemplarCity => q#ຊີວຕາ#,
		},
		'Africa/Conakry' => {
			exemplarCity => q#ໂກນາກີ#,
		},
		'Africa/Dakar' => {
			exemplarCity => q#ດາກາສ#,
		},
		'Africa/Dar_es_Salaam' => {
			exemplarCity => q#ດາເອສສະລາມ#,
		},
		'Africa/Djibouti' => {
			exemplarCity => q#ຈີບູຕິ#,
		},
		'Africa/Douala' => {
			exemplarCity => q#ດູອາລາ#,
		},
		'Africa/El_Aaiun' => {
			exemplarCity => q#ເອວອີອຸງ#,
		},
		'Africa/Freetown' => {
			exemplarCity => q#ຟີທາວ#,
		},
		'Africa/Gaborone' => {
			exemplarCity => q#ກາໂບລອນ#,
		},
		'Africa/Harare' => {
			exemplarCity => q#ຮາລາເລ້#,
		},
		'Africa/Johannesburg' => {
			exemplarCity => q#ໂຈຮັນເນດສເບີກ#,
		},
		'Africa/Juba' => {
			exemplarCity => q#ຈູບາ#,
		},
		'Africa/Kampala' => {
			exemplarCity => q#ຄຳປາລາ#,
		},
		'Africa/Khartoum' => {
			exemplarCity => q#ຄາທູມ#,
		},
		'Africa/Kigali' => {
			exemplarCity => q#ຄີກາລີ#,
		},
		'Africa/Kinshasa' => {
			exemplarCity => q#ກິນຊາຊາ#,
		},
		'Africa/Lagos' => {
			exemplarCity => q#ລາໂກດສ#,
		},
		'Africa/Libreville' => {
			exemplarCity => q#ລີເບີເລີວີວ#,
		},
		'Africa/Lome' => {
			exemplarCity => q#ລຳ#,
		},
		'Africa/Luanda' => {
			exemplarCity => q#ແລມດາ#,
		},
		'Africa/Lubumbashi' => {
			exemplarCity => q#ລູບຳບາຊິ#,
		},
		'Africa/Lusaka' => {
			exemplarCity => q#ລູຊາກ້າ#,
		},
		'Africa/Malabo' => {
			exemplarCity => q#ມາລາໂບ#,
		},
		'Africa/Maputo' => {
			exemplarCity => q#ມາປູໂຕ#,
		},
		'Africa/Maseru' => {
			exemplarCity => q#ມາເຊໂລ#,
		},
		'Africa/Mbabane' => {
			exemplarCity => q#ອຳບາບາເນ#,
		},
		'Africa/Mogadishu' => {
			exemplarCity => q#ໂມກາດີຊູ#,
		},
		'Africa/Monrovia' => {
			exemplarCity => q#ມອນໂລເວຍ#,
		},
		'Africa/Nairobi' => {
			exemplarCity => q#ໄນໂລບີ#,
		},
		'Africa/Ndjamena' => {
			exemplarCity => q#ເອນຈາເມນ່າ#,
		},
		'Africa/Niamey' => {
			exemplarCity => q#ນີອາມີ້#,
		},
		'Africa/Nouakchott' => {
			exemplarCity => q#ນູແອກຊອດ#,
		},
		'Africa/Ouagadougou' => {
			exemplarCity => q#ອູກາດູກູ#,
		},
		'Africa/Porto-Novo' => {
			exemplarCity => q#ປໍໂຕ-ໂນໂວ#,
		},
		'Africa/Sao_Tome' => {
			exemplarCity => q#ຊາວໂຕເມ#,
		},
		'Africa/Tripoli' => {
			exemplarCity => q#ຕີໂປລີ#,
		},
		'Africa/Tunis' => {
			exemplarCity => q#ຕູນິດ#,
		},
		'Africa/Windhoek' => {
			exemplarCity => q#ວີນຮູດ#,
		},
		'Africa_Central' => {
			long => {
				'standard' => q(ເວລາອາຟຣິລິກາກາງ),
			},
		},
		'Africa_Eastern' => {
			long => {
				'standard' => q(ເວລາອາຟຣິລິກາຕາເວັນອອກ),
			},
		},
		'Africa_Southern' => {
			long => {
				'standard' => q(ເວລາອາຟຣິລິກາໃຕ້),
			},
		},
		'Africa_Western' => {
			long => {
				'daylight' => q(ເວລາລະດູຮ້ອນອາຟຣິລິກາຕາເວັນຕົກ),
				'generic' => q(ເວລາອາຟຣິລິກາຕາເວັນຕົກ),
				'standard' => q(ເວລາມາດຕະຖານອາຟຣິລິກາຕາເວັນຕົກ),
			},
		},
		'Alaska' => {
			long => {
				'daylight' => q(ເວລາຕອນທ່ຽງຂອງອະແລສກາ),
				'generic' => q(ເວລາອະແລສກາ),
				'standard' => q(ເວລາມາດຕະຖານອະແລສກາ),
			},
		},
		'Almaty' => {
			long => {
				'daylight' => q(ເວລາລະດູຮ້ອນອໍມາຕີ),
				'generic' => q(ເວລາອໍມາຕີ),
				'standard' => q(ເວລາມາດຕະຖານອໍມາຕີ),
			},
		},
		'Amazon' => {
			long => {
				'daylight' => q(ເວລາລະດູຮ້ອນອາມາໂຊນ),
				'generic' => q(ເວລາອາມາໂຊນ),
				'standard' => q(ເວລາມາດຕະຖານອາມາໂຊນ),
			},
		},
		'America/Adak' => {
			exemplarCity => q#ອາແດກ#,
		},
		'America/Anchorage' => {
			exemplarCity => q#ແອນເຄີເຣກ#,
		},
		'America/Anguilla' => {
			exemplarCity => q#ແອນກິນລາ#,
		},
		'America/Antigua' => {
			exemplarCity => q#ແອນຕີກາ#,
		},
		'America/Araguaina' => {
			exemplarCity => q#ອາລາກົວນາ#,
		},
		'America/Argentina/La_Rioja' => {
			exemplarCity => q#ເລ ຣີໂອຈາ#,
		},
		'America/Argentina/Rio_Gallegos' => {
			exemplarCity => q#ຣີໂອ ການເລກອດ#,
		},
		'America/Argentina/Salta' => {
			exemplarCity => q#ຊານຕາ#,
		},
		'America/Argentina/San_Juan' => {
			exemplarCity => q#ແຊນຈືນ#,
		},
		'America/Argentina/San_Luis' => {
			exemplarCity => q#ແຊນລຸຍ#,
		},
		'America/Argentina/Tucuman' => {
			exemplarCity => q#ຕູຄູແມນ#,
		},
		'America/Argentina/Ushuaia' => {
			exemplarCity => q#ອູຊູເອຍ#,
		},
		'America/Aruba' => {
			exemplarCity => q#ອາຣູບາ#,
		},
		'America/Asuncion' => {
			exemplarCity => q#ອາຊຸນຊີອອນ#,
		},
		'America/Bahia' => {
			exemplarCity => q#ບີເຍຍ#,
		},
		'America/Bahia_Banderas' => {
			exemplarCity => q#ບາເຮຍ ແບນເດີຣາສ#,
		},
		'America/Barbados' => {
			exemplarCity => q#ບາເບດອສ#,
		},
		'America/Belem' => {
			exemplarCity => q#ບີແລນ#,
		},
		'America/Belize' => {
			exemplarCity => q#ເບຊິນ#,
		},
		'America/Blanc-Sablon' => {
			exemplarCity => q#ບລານ-ຊາບລອນ#,
		},
		'America/Boa_Vista' => {
			exemplarCity => q#ບົວວີສຕາ#,
		},
		'America/Bogota' => {
			exemplarCity => q#ໂບໂກຕ້າ#,
		},
		'America/Boise' => {
			exemplarCity => q#ບອຍຊີ#,
		},
		'America/Buenos_Aires' => {
			exemplarCity => q#ເບີນອດແອ#,
		},
		'America/Cambridge_Bay' => {
			exemplarCity => q#ອ່າວແຄມບຣິດ#,
		},
		'America/Campo_Grande' => {
			exemplarCity => q#ກຳໂປກັນດີ#,
		},
		'America/Cancun' => {
			exemplarCity => q#ແຄນກຸນ#,
		},
		'America/Caracas' => {
			exemplarCity => q#ກາລາກາດສ#,
		},
		'America/Catamarca' => {
			exemplarCity => q#ກາຕາມາກາ#,
		},
		'America/Cayenne' => {
			exemplarCity => q#ກາເຢນ#,
		},
		'America/Cayman' => {
			exemplarCity => q#ຄາຍແມນ#,
		},
		'America/Chicago' => {
			exemplarCity => q#ຊີຄາໂກ#,
		},
		'America/Chihuahua' => {
			exemplarCity => q#ຊີຫົວຫົວ#,
		},
		'America/Coral_Harbour' => {
			exemplarCity => q#ອາທິໂຄຄານ#,
		},
		'America/Cordoba' => {
			exemplarCity => q#ຄໍໂດບາ#,
		},
		'America/Costa_Rica' => {
			exemplarCity => q#ຄອສຕາຣິກາ#,
		},
		'America/Creston' => {
			exemplarCity => q#ເຄຣສຕັນ#,
		},
		'America/Cuiaba' => {
			exemplarCity => q#ກຸຍບາ#,
		},
		'America/Curacao' => {
			exemplarCity => q#ເຄີລາຄາວ#,
		},
		'America/Danmarkshavn' => {
			exemplarCity => q#ດານນາຊາວ#,
		},
		'America/Dawson' => {
			exemplarCity => q#ດໍສັນ#,
		},
		'America/Dawson_Creek' => {
			exemplarCity => q#ດໍສັນ ຄຣີກ#,
		},
		'America/Denver' => {
			exemplarCity => q#ເດັນເວີ#,
		},
		'America/Detroit' => {
			exemplarCity => q#ດີທຣອຍ#,
		},
		'America/Dominica' => {
			exemplarCity => q#ໂດມິນິກາ#,
		},
		'America/Edmonton' => {
			exemplarCity => q#ເອດມັນຕັນ#,
		},
		'America/Eirunepe' => {
			exemplarCity => q#ເອລູເນປີ#,
		},
		'America/El_Salvador' => {
			exemplarCity => q#ເອວຊັນວາເດີ#,
		},
		'America/Fortaleza' => {
			exemplarCity => q#ຟໍຕາເລຊາ#,
		},
		'America/Glace_Bay' => {
			exemplarCity => q#ເກລັກເບ#,
		},
		'America/Godthab' => {
			exemplarCity => q#ກອດແທບ#,
		},
		'America/Goose_Bay' => {
			exemplarCity => q#ກູສເບ#,
		},
		'America/Grand_Turk' => {
			exemplarCity => q#ແກຣນທັກ#,
		},
		'America/Grenada' => {
			exemplarCity => q#ເກຣນາດາ#,
		},
		'America/Guadeloupe' => {
			exemplarCity => q#ກາວເດລູບ#,
		},
		'America/Guatemala' => {
			exemplarCity => q#ກົວເຕມາລາ#,
		},
		'America/Guayaquil' => {
			exemplarCity => q#ກົວຢາກິ#,
		},
		'America/Guyana' => {
			exemplarCity => q#ກູຢານາ#,
		},
		'America/Halifax' => {
			exemplarCity => q#ຫາລີແຟັກ#,
		},
		'America/Havana' => {
			exemplarCity => q#ຮາວານາ#,
		},
		'America/Hermosillo' => {
			exemplarCity => q#ຮີໂມຊິນໂລ#,
		},
		'America/Indiana/Knox' => {
			exemplarCity => q#ນ໋ອກ, ອິນດີແອນາ#,
		},
		'America/Indiana/Marengo' => {
			exemplarCity => q#ມາເຣນໂກ, ອິນດີເອນາ#,
		},
		'America/Indiana/Petersburg' => {
			exemplarCity => q#ປີເຕີເບີກ, ອິນດີເອນາ#,
		},
		'America/Indiana/Tell_City' => {
			exemplarCity => q#ເທວຊິຕີ, ອິນດີເອນາ#,
		},
		'America/Indiana/Vevay' => {
			exemplarCity => q#ວີເວ, ອິນດີເອນາ#,
		},
		'America/Indiana/Vincennes' => {
			exemplarCity => q#ວິນເຊນເນັດ, ອິນດີເອນາ#,
		},
		'America/Indiana/Winamac' => {
			exemplarCity => q#ວິນນາແມັກ, ອິນດີເອນາ#,
		},
		'America/Indianapolis' => {
			exemplarCity => q#ອິນດີເອນາໂພລິສ#,
		},
		'America/Inuvik' => {
			exemplarCity => q#ອີນູວິກ#,
		},
		'America/Iqaluit' => {
			exemplarCity => q#ອີກົວລິດ#,
		},
		'America/Jamaica' => {
			exemplarCity => q#ຈາໄມກາ#,
		},
		'America/Jujuy' => {
			exemplarCity => q#ຈູຈຸຍ#,
		},
		'America/Juneau' => {
			exemplarCity => q#ຈູໂນ#,
		},
		'America/Kentucky/Monticello' => {
			exemplarCity => q#ມອນຕີເຊວໂລ, ເຄນທັກກີ#,
		},
		'America/Kralendijk' => {
			exemplarCity => q#ຄຣາເລນດິກ#,
		},
		'America/La_Paz' => {
			exemplarCity => q#ລາປາສ#,
		},
		'America/Lima' => {
			exemplarCity => q#ລີມາ#,
		},
		'America/Los_Angeles' => {
			exemplarCity => q#ລອສແອນເຈີລິດ#,
		},
		'America/Louisville' => {
			exemplarCity => q#ລຸຍວິນເລ#,
		},
		'America/Lower_Princes' => {
			exemplarCity => q#ໂລເວີແປຣນໂກຕາ#,
		},
		'America/Maceio' => {
			exemplarCity => q#ມາເຊໂອ#,
		},
		'America/Managua' => {
			exemplarCity => q#ມານາກົວ#,
		},
		'America/Manaus' => {
			exemplarCity => q#ມານົວ#,
		},
		'America/Marigot' => {
			exemplarCity => q#ມາຣີໂກດ#,
		},
		'America/Martinique' => {
			exemplarCity => q#ມາທີນິກ#,
		},
		'America/Matamoros' => {
			exemplarCity => q#ມາຕາໂມຣອສ#,
		},
		'America/Mazatlan' => {
			exemplarCity => q#ມາຊາດລານ#,
		},
		'America/Mendoza' => {
			exemplarCity => q#ເມັນໂດຊ່າ#,
		},
		'America/Menominee' => {
			exemplarCity => q#ມີໂນມີນີ#,
		},
		'America/Merida' => {
			exemplarCity => q#ມີຣິດາ#,
		},
		'America/Metlakatla' => {
			exemplarCity => q#ເມັດລາກັດລາ#,
		},
		'America/Mexico_City' => {
			exemplarCity => q#ແມັກຊິໂກ ຊີຕີ#,
		},
		'America/Miquelon' => {
			exemplarCity => q#ມີກົວລອນ#,
		},
		'America/Moncton' => {
			exemplarCity => q#ມອນຕັນ#,
		},
		'America/Monterrey' => {
			exemplarCity => q#ມອນເຕີເຣຍ#,
		},
		'America/Montevideo' => {
			exemplarCity => q#ມອນເຕດີເວໂອ#,
		},
		'America/Montserrat' => {
			exemplarCity => q#ມອນເຊີຣັດ#,
		},
		'America/Nassau' => {
			exemplarCity => q#ແນສຊໍ#,
		},
		'America/New_York' => {
			exemplarCity => q#ນິວຢອກ#,
		},
		'America/Nipigon' => {
			exemplarCity => q#ນີປີກອນ#,
		},
		'America/Nome' => {
			exemplarCity => q#ນອມ#,
		},
		'America/Noronha' => {
			exemplarCity => q#ນໍລອນຮາ#,
		},
		'America/North_Dakota/Beulah' => {
			exemplarCity => q#ເບີລາ, ດາໂກຕາເໜືອ#,
		},
		'America/North_Dakota/Center' => {
			exemplarCity => q#ສູນກາງ, ດາໂກດາເໝືອ#,
		},
		'America/North_Dakota/New_Salem' => {
			exemplarCity => q#ນີວສາເລັມ, ດາໂກຕາເໜືອ#,
		},
		'America/Ojinaga' => {
			exemplarCity => q#ໂອຈິນາກາ#,
		},
		'America/Panama' => {
			exemplarCity => q#ປານາມາ#,
		},
		'America/Pangnirtung' => {
			exemplarCity => q#ພາງນີທັງ#,
		},
		'America/Paramaribo' => {
			exemplarCity => q#ປາລາມາລີໂບ#,
		},
		'America/Phoenix' => {
			exemplarCity => q#ໂພນິກ#,
		},
		'America/Port-au-Prince' => {
			exemplarCity => q#ພອດອັນແປຣນ#,
		},
		'America/Port_of_Spain' => {
			exemplarCity => q#ພອດຂອງສະເປນ#,
		},
		'America/Porto_Velho' => {
			exemplarCity => q#ປໍໂຕເວໂຢ#,
		},
		'America/Puerto_Rico' => {
			exemplarCity => q#ເປີໂທຣິໂກ#,
		},
		'America/Rainy_River' => {
			exemplarCity => q#ເຣນນີ ຣີເວີ#,
		},
		'America/Rankin_Inlet' => {
			exemplarCity => q#ແຣນກິນອິນເລັດ#,
		},
		'America/Recife' => {
			exemplarCity => q#ເລຊີເຟ#,
		},
		'America/Regina' => {
			exemplarCity => q#ຣີຈີນາ#,
		},
		'America/Resolute' => {
			exemplarCity => q#ເຣໂຊລຸດ#,
		},
		'America/Rio_Branco' => {
			exemplarCity => q#ລີໂອບັງໂກ#,
		},
		'America/Santa_Isabel' => {
			exemplarCity => q#ຊານຕາ ອິດຊາເບວ#,
		},
		'America/Santarem' => {
			exemplarCity => q#ຊັນຕາເລມ#,
		},
		'America/Santiago' => {
			exemplarCity => q#ຊັນຕີອາໂກ#,
		},
		'America/Santo_Domingo' => {
			exemplarCity => q#ຊານໂຕໂດມິນໂກ#,
		},
		'America/Sao_Paulo' => {
			exemplarCity => q#ຊາວໂປໂລ#,
		},
		'America/Scoresbysund' => {
			exemplarCity => q#ສະກໍເຣນໄບຊັນ#,
		},
		'America/Sitka' => {
			exemplarCity => q#ຊິດກາ#,
		},
		'America/St_Barthelemy' => {
			exemplarCity => q#ຊຽນບາທີລີມີ#,
		},
		'America/St_Johns' => {
			exemplarCity => q#ເຊນຈອນ#,
		},
		'America/St_Kitts' => {
			exemplarCity => q#ຊຽນຄີສ#,
		},
		'America/St_Lucia' => {
			exemplarCity => q#ຊຽນລູເຊຍ#,
		},
		'America/St_Thomas' => {
			exemplarCity => q#ຊຽນໂທມັສ#,
		},
		'America/St_Vincent' => {
			exemplarCity => q#ຊຽນວິນເຊນ#,
		},
		'America/Swift_Current' => {
			exemplarCity => q#ສະວິດເຄີເຣນ#,
		},
		'America/Tegucigalpa' => {
			exemplarCity => q#ເຕກູຊີການປາ#,
		},
		'America/Thule' => {
			exemplarCity => q#ທູເລ#,
		},
		'America/Thunder_Bay' => {
			exemplarCity => q#ທັນເດີເບ#,
		},
		'America/Tijuana' => {
			exemplarCity => q#ທີຈົວນາ#,
		},
		'America/Toronto' => {
			exemplarCity => q#ໂທຣອນໂຕ#,
		},
		'America/Tortola' => {
			exemplarCity => q#ທໍໂຕລາ#,
		},
		'America/Vancouver' => {
			exemplarCity => q#ແວນຄູເວີ#,
		},
		'America/Whitehorse' => {
			exemplarCity => q#ໄວຫອກສ#,
		},
		'America/Winnipeg' => {
			exemplarCity => q#ວິນນີເພກ#,
		},
		'America/Yakutat' => {
			exemplarCity => q#ຢາຄູຕັດ#,
		},
		'America/Yellowknife' => {
			exemplarCity => q#ເຢນໂລໄນ#,
		},
		'America_Central' => {
			long => {
				'daylight' => q(ເວລາຕອນທ່ຽງຂອງອາເມລິກາເໝືອ),
				'generic' => q(ເວລາຕອນທ່ຽງ),
				'standard' => q(ເວລາມາດຕະຖານ),
			},
		},
		'America_Eastern' => {
			long => {
				'daylight' => q(ເວລາຕອນທ່ຽງທາງຕາເວັນອອກ),
				'generic' => q(ເວລາຕາເວັນອອກ),
				'standard' => q(ເວລາມາດຕະຖານຕາເວັນອອກ),
			},
		},
		'America_Mountain' => {
			long => {
				'daylight' => q(ເວລາຕອນທ່ຽງແຖວພູເຂົາ),
				'generic' => q(ເວລາແຖບພູເຂົາ),
				'standard' => q(ເວລາມາດຕະຖານແຖບພູເຂົົາ),
			},
		},
		'America_Pacific' => {
			long => {
				'daylight' => q(ເວລາຕອນທ່ຽງຂອງປາຊີຟິກ),
				'generic' => q(ເວລາປາຊີຟິກ),
				'standard' => q(ເວລາມາດຕະຖານຂອງປາຊີຟິກ),
			},
		},
		'Antarctica/Casey' => {
			exemplarCity => q#ເຄຊີ#,
		},
		'Antarctica/Davis' => {
			exemplarCity => q#ດາວີສ#,
		},
		'Antarctica/DumontDUrville' => {
			exemplarCity => q#ດູມອນດີຍູວີວສ໌#,
		},
		'Antarctica/Macquarie' => {
			exemplarCity => q#ແມັກຄົວຣີ#,
		},
		'Antarctica/Mawson' => {
			exemplarCity => q#ເມົາຊັນ#,
		},
		'Antarctica/McMurdo' => {
			exemplarCity => q#ແມັກມົວໂດ#,
		},
		'Antarctica/Palmer' => {
			exemplarCity => q#ພາມເມີ#,
		},
		'Antarctica/Rothera' => {
			exemplarCity => q#ໂຣເທຣາ#,
		},
		'Antarctica/Syowa' => {
			exemplarCity => q#ເຊຍວາ#,
		},
		'Antarctica/Vostok' => {
			exemplarCity => q#ວໍສະຕອກ#,
		},
		'Aqtau' => {
			long => {
				'daylight' => q(ເວລາລະດູຮ້ອນອັດຕາອູ),
				'generic' => q(ເວລາອັດຕາອູ),
				'standard' => q(ເວລາມາດຕະຖານອັດຕາອູ),
			},
		},
		'Aqtobe' => {
			long => {
				'daylight' => q(ເວລາລະດູຮ້ອນອັດໂຕເບ),
				'generic' => q(ເວລາອັດໂຕເບ),
				'standard' => q(ເວລາມາດຕະຖານອັດໂຕເບ),
			},
		},
		'Arabian' => {
			long => {
				'daylight' => q(ເວລາກາງເວັນອາລາບຽນ),
				'generic' => q(ເວລາອາລາບຽນ),
				'standard' => q(ເວລາມາດຕະຖານອາລາບຽນ),
			},
		},
		'Arctic/Longyearbyen' => {
			exemplarCity => q#ລອງເຢຍບຽນ#,
		},
		'Argentina' => {
			long => {
				'daylight' => q(ເວລາລະດູຮ້ອນອາເຈນຕີນາ),
				'generic' => q(ເວລາອາເຈນຕີນາ),
				'standard' => q(ເວລາມາດຕະຖານອາເຈນຕີນາ),
			},
		},
		'Argentina_Western' => {
			long => {
				'daylight' => q(ເວລາລະດູຮ້ອນທາງຕາເວັນຕົກຂອງອາເຈນຕີນາ),
				'generic' => q(ເວລາຕາເວັນຕົກຂອງອາເຈນຕີນາ),
				'standard' => q(ເວລາມາດຕະຖານຕາເວັນຕົກຂອງອາເຈນຕີນາ),
			},
		},
		'Armenia' => {
			long => {
				'daylight' => q(ເວລາລະດູຮ້ອນອາເມເນຍ),
				'generic' => q(ເວລາອາເມເນຍ),
				'standard' => q(ເວລາມາດຕະຖານອາເມເນຍ),
			},
		},
		'Asia/Aden' => {
			exemplarCity => q#ເອເດັນ#,
		},
		'Asia/Almaty' => {
			exemplarCity => q#ອໍມາຕີ#,
		},
		'Asia/Amman' => {
			exemplarCity => q#ອຳມານ#,
		},
		'Asia/Anadyr' => {
			exemplarCity => q#ອານາດີ#,
		},
		'Asia/Aqtau' => {
			exemplarCity => q#ອັດຕາອູ#,
		},
		'Asia/Aqtobe' => {
			exemplarCity => q#ອັດໂທບີ#,
		},
		'Asia/Ashgabat' => {
			exemplarCity => q#ອາດກາບັດ#,
		},
		'Asia/Baghdad' => {
			exemplarCity => q#ແບກແດດ#,
		},
		'Asia/Bahrain' => {
			exemplarCity => q#ບາເຫເຣນ#,
		},
		'Asia/Baku' => {
			exemplarCity => q#ບາກູ#,
		},
		'Asia/Bangkok' => {
			exemplarCity => q#ບາງກອກ#,
		},
		'Asia/Beirut' => {
			exemplarCity => q#ເບຣຸດ#,
		},
		'Asia/Bishkek' => {
			exemplarCity => q#ບິດເຄກ#,
		},
		'Asia/Brunei' => {
			exemplarCity => q#ບຣູໄນ#,
		},
		'Asia/Calcutta' => {
			exemplarCity => q#ໂກຣກາຕາ#,
		},
		'Asia/Choibalsan' => {
			exemplarCity => q#ຊອຍບາຣຊານ#,
		},
		'Asia/Chongqing' => {
			exemplarCity => q#ຈົງຊິ່ງ#,
		},
		'Asia/Colombo' => {
			exemplarCity => q#ໂຄລຳໂບ#,
		},
		'Asia/Damascus' => {
			exemplarCity => q#ດາມັດກັດ#,
		},
		'Asia/Dhaka' => {
			exemplarCity => q#ດາກາ#,
		},
		'Asia/Dili' => {
			exemplarCity => q#ດີລີ#,
		},
		'Asia/Dubai' => {
			exemplarCity => q#ດູໃບ#,
		},
		'Asia/Dushanbe' => {
			exemplarCity => q#ດູຊານເບ#,
		},
		'Asia/Gaza' => {
			exemplarCity => q#ກາຊາ#,
		},
		'Asia/Harbin' => {
			exemplarCity => q#ຮາຣ໌ບິນ#,
		},
		'Asia/Hebron' => {
			exemplarCity => q#ເຮບຣອນ#,
		},
		'Asia/Hong_Kong' => {
			exemplarCity => q#ຮ່ອງກົງ#,
		},
		'Asia/Hovd' => {
			exemplarCity => q#ຮອບ#,
		},
		'Asia/Irkutsk' => {
			exemplarCity => q#ອີຄຸດສ#,
		},
		'Asia/Jakarta' => {
			exemplarCity => q#ຈາກາຣ໌ຕາ#,
		},
		'Asia/Jayapura' => {
			exemplarCity => q#ຈາຍາປູຣະ#,
		},
		'Asia/Jerusalem' => {
			exemplarCity => q#ເຍຣູສະແລັມ#,
		},
		'Asia/Kabul' => {
			exemplarCity => q#ກາບູຣ#,
		},
		'Asia/Kamchatka' => {
			exemplarCity => q#ຄາມຊາດກາ#,
		},
		'Asia/Karachi' => {
			exemplarCity => q#ກາຣາຈີ#,
		},
		'Asia/Kashgar' => {
			exemplarCity => q#ຄາດຣ໌ກາ#,
		},
		'Asia/Katmandu' => {
			exemplarCity => q#ກາດສ໌ມັນດູ#,
		},
		'Asia/Khandyga' => {
			exemplarCity => q#ແຄນດີກາ#,
		},
		'Asia/Krasnoyarsk' => {
			exemplarCity => q#ຄາດສນໍຢາດສ#,
		},
		'Asia/Kuala_Lumpur' => {
			exemplarCity => q#ກູລາລຳເປີ#,
		},
		'Asia/Kuching' => {
			exemplarCity => q#ກູຊີງ#,
		},
		'Asia/Kuwait' => {
			exemplarCity => q#ຄູເວດ#,
		},
		'Asia/Macau' => {
			exemplarCity => q#ມາເກົາ#,
		},
		'Asia/Magadan' => {
			exemplarCity => q#ມາກາແດນ#,
		},
		'Asia/Makassar' => {
			exemplarCity => q#ມາກາດຣ໌ຊາ#,
		},
		'Asia/Manila' => {
			exemplarCity => q#ມານີລາ#,
		},
		'Asia/Muscat' => {
			exemplarCity => q#ມາດກັດ#,
		},
		'Asia/Nicosia' => {
			exemplarCity => q#ນິໂຄເຊຍ#,
		},
		'Asia/Novokuznetsk' => {
			exemplarCity => q#ໂນໂວຄຸສເນັດ#,
		},
		'Asia/Novosibirsk' => {
			exemplarCity => q#ໂນໂວຊີບີລາດສ#,
		},
		'Asia/Omsk' => {
			exemplarCity => q#ໂອມາດສ#,
		},
		'Asia/Oral' => {
			exemplarCity => q#ອໍຣໍ#,
		},
		'Asia/Phnom_Penh' => {
			exemplarCity => q#ພະນົມເປັນ#,
		},
		'Asia/Pontianak' => {
			exemplarCity => q#ພອນເທຍນັກ#,
		},
		'Asia/Pyongyang' => {
			exemplarCity => q#ປຽງຢາງ#,
		},
		'Asia/Qatar' => {
			exemplarCity => q#ກາຕາຣ#,
		},
		'Asia/Qyzylorda' => {
			exemplarCity => q#ໄຄຊີລໍດາ#,
		},
		'Asia/Rangoon' => {
			exemplarCity => q#ຍາງກຸ້ງ#,
		},
		'Asia/Riyadh' => {
			exemplarCity => q#ຣີຢາດ#,
		},
		'Asia/Saigon' => {
			exemplarCity => q#ໂຮ່ຈີມິງ#,
		},
		'Asia/Sakhalin' => {
			exemplarCity => q#ຊາຄາລິນ#,
		},
		'Asia/Samarkand' => {
			exemplarCity => q#ສາມາກກາດ#,
		},
		'Asia/Seoul' => {
			exemplarCity => q#ໂຊຣ#,
		},
		'Asia/Shanghai' => {
			exemplarCity => q#ຊ່ຽງໄຮ້#,
		},
		'Asia/Singapore' => {
			exemplarCity => q#ສິງກະໂປ#,
		},
		'Asia/Taipei' => {
			exemplarCity => q#ໄທເປ#,
		},
		'Asia/Tashkent' => {
			exemplarCity => q#ທາດສ໌ເຄນ#,
		},
		'Asia/Tbilisi' => {
			exemplarCity => q#ທີບີລີຊີ#,
		},
		'Asia/Tehran' => {
			exemplarCity => q#ເຕຫະຣານ#,
		},
		'Asia/Thimphu' => {
			exemplarCity => q#ທິມພູ#,
		},
		'Asia/Tokyo' => {
			exemplarCity => q#ໂຕກຽວ#,
		},
		'Asia/Ulaanbaatar' => {
			exemplarCity => q#ອູລານບາຕາຣ໌#,
		},
		'Asia/Urumqi' => {
			exemplarCity => q#ອູຣຸມຊີ#,
		},
		'Asia/Ust-Nera' => {
			exemplarCity => q#ອຸສ ເນຣາ#,
		},
		'Asia/Vientiane' => {
			exemplarCity => q#ວຽງຈັນ#,
		},
		'Asia/Vladivostok' => {
			exemplarCity => q#ວາດີໂວຕອກ#,
		},
		'Asia/Yakutsk' => {
			exemplarCity => q#ຢາຄູທາດສ#,
		},
		'Asia/Yekaterinburg' => {
			exemplarCity => q#ຢີຄາເຕີລີນແບກ#,
		},
		'Asia/Yerevan' => {
			exemplarCity => q#ເຍເຣວານ#,
		},
		'Atlantic' => {
			long => {
				'daylight' => q(ເວລາຕອນທ່ຽງຂອງອາແລນຕິກ),
				'generic' => q(ເວລາຂອງອາແລນຕິກ),
				'standard' => q(ເວລາມາດຕະຖານຂອງອາແລນຕິກ),
			},
		},
		'Atlantic/Azores' => {
			exemplarCity => q#ອາຊໍເຣດ#,
		},
		'Atlantic/Bermuda' => {
			exemplarCity => q#ເບີມູດາ#,
		},
		'Atlantic/Canary' => {
			exemplarCity => q#ຄານາຣີ#,
		},
		'Atlantic/Cape_Verde' => {
			exemplarCity => q#ເຄບເວີດ#,
		},
		'Atlantic/Faeroe' => {
			exemplarCity => q#ເຟໂລ#,
		},
		'Atlantic/Madeira' => {
			exemplarCity => q#ມາເດຣາ#,
		},
		'Atlantic/Reykjavik' => {
			exemplarCity => q#ເລດຢາວິກ#,
		},
		'Atlantic/South_Georgia' => {
			exemplarCity => q#ເຊົາຈໍເຈຍ#,
		},
		'Atlantic/St_Helena' => {
			exemplarCity => q#ເຊນເຮລີນ່າ#,
		},
		'Atlantic/Stanley' => {
			exemplarCity => q#ສະແຕນລີ#,
		},
		'Australia/Adelaide' => {
			exemplarCity => q#ເອດີແລດ#,
		},
		'Australia/Brisbane' => {
			exemplarCity => q#ບຣິດເບນ#,
		},
		'Australia/Broken_Hill' => {
			exemplarCity => q#ໂບເຄນຮີວ#,
		},
		'Australia/Currie' => {
			exemplarCity => q#ກູຣີ#,
		},
		'Australia/Darwin' => {
			exemplarCity => q#ດາຣວິນ#,
		},
		'Australia/Eucla' => {
			exemplarCity => q#ຍູລາ#,
		},
		'Australia/Hobart' => {
			exemplarCity => q#ໂຮບາດ#,
		},
		'Australia/Lindeman' => {
			exemplarCity => q#ລິນດີແມນ#,
		},
		'Australia/Lord_Howe' => {
			exemplarCity => q#ໂລດໂຮວີ#,
		},
		'Australia/Melbourne' => {
			exemplarCity => q#ເມວເບິຣນ#,
		},
		'Australia/Perth' => {
			exemplarCity => q#ເພີດ#,
		},
		'Australia/Sydney' => {
			exemplarCity => q#ຊິດນີ#,
		},
		'Australia_Central' => {
			long => {
				'daylight' => q(ເວລາກາງເວັນ ອົດສະຕາລີກາງ),
				'generic' => q(ເວລາ ອົດສະຕາລີກາງ),
				'standard' => q(ເວລາມາດຕະຖານ ອົດສະຕາລີກາງ),
			},
		},
		'Australia_CentralWestern' => {
			long => {
				'daylight' => q(ເວລາກາງເວັນ ຕາເວັນຕົກຕອນກາງຂອງອົດສະຕາລີ),
				'generic' => q(ເວລາ ຕາເວັນຕົກຕອນກາງຂອງອົດສະຕາລີ),
				'standard' => q(ເວລາມາດຕະຖານ ຕາເວັນຕົກຕອນກາງຂອງອົດສະຕາລີ),
			},
		},
		'Australia_Eastern' => {
			long => {
				'daylight' => q(ເວລາກາງເວັນ ອົດສະຕາລີຕາເວັນອອກ),
				'generic' => q(ເວລາອົດສະຕາລີຕາເວັນອອກ),
				'standard' => q(ເວລາມາດຕະຖານອົດສະຕາລີຕາເວັນອອກ),
			},
		},
		'Australia_Western' => {
			long => {
				'daylight' => q(ເວລາກາງເວັນອົດສະຕາລີຕາເວັນຕົກ),
				'generic' => q(ເວລາອົດສະຕາລີຕາເວັນຕົກ),
				'standard' => q(ເວລາມາດຕະຖານ ອົດສະຕາລີຕາເວັນຕົກ),
			},
		},
		'Azerbaijan' => {
			long => {
				'daylight' => q(ເວລາລະດູຮ້ອນອັສເຊີໄບຈັນ),
				'generic' => q(ເວລາອັສເຊີໄບຈັນ),
				'standard' => q(ເວລາມາດຕະຖານອັສເຊີໄບຈັນ),
			},
		},
		'Azores' => {
			long => {
				'daylight' => q(ເວລາລະດູຮ້ອນອາໂຊເລສ),
				'generic' => q(ເວລາອາໂຊເລສ),
				'standard' => q(ເວລາມາດຕະຖານອາໂຊເລສ),
			},
		},
		'Bangladesh' => {
			long => {
				'daylight' => q(ເວລາ ລະດູຮ້ອນ ບັງກະລາເທດ),
				'generic' => q(ເວລາ ບັງກະລາເທດ),
				'standard' => q(ເວລາມາດຕະຖານ ບັງກະລາເທດ),
			},
		},
		'Bhutan' => {
			long => {
				'standard' => q(ເວລາ ບູຖານ),
			},
		},
		'Bolivia' => {
			long => {
				'standard' => q(ເວລາໂບລີເວີຍ),
			},
		},
		'Brasilia' => {
			long => {
				'daylight' => q(ເວລາລະດູຮ້ອນເບຣຊີເລຍ),
				'generic' => q(ເວລາເບຣຊີເລຍ),
				'standard' => q(ເວລາມາດຕາຖານເບຣຊີເລຍ),
			},
		},
		'Brunei' => {
			long => {
				'standard' => q(ເວລາບຼູນາຍດາລູຊາແລັມ),
			},
		},
		'Cape_Verde' => {
			long => {
				'daylight' => q(ເວລາລະດູຮ້ອນຂອງເຄບເວິຣດ),
				'generic' => q(ເວລາເຄບເວິຣດ),
				'standard' => q(ເວລາມາດຕະຖານເຄບເວິຣດ),
			},
		},
		'Casey' => {
			long => {
				'standard' => q(ເວລາເຄຊີ),
			},
		},
		'Chamorro' => {
			long => {
				'standard' => q(ເວລາຊາມໍໂລ),
			},
		},
		'Chatham' => {
			long => {
				'daylight' => q(ເວລາກາງເວັນ ຊາທາມ),
				'generic' => q(ເວລາ ຊາທາມ),
				'standard' => q(ເວລາມາດຕະຖານ ຊາທາມ),
			},
		},
		'Chile' => {
			long => {
				'daylight' => q(ເວລາລະດູຮ້ອນຊີລີ),
				'generic' => q(ເວລາຊີລີ),
				'standard' => q(ເວລາມາດຕາຖານຊີລີ),
			},
		},
		'China' => {
			long => {
				'daylight' => q(ເວລາກາງເວັນ ຈີນ),
				'generic' => q(ເວລາຂອງຈີນ),
				'standard' => q(ເວລາມາດຕະຖານຈີນ),
			},
		},
		'Choibalsan' => {
			long => {
				'daylight' => q(ເວລາລະດູຮ້ອນ ໂຊຍບາຊັນ),
				'generic' => q(ເວລາ ໂຊຍບາຊັນ),
				'standard' => q(ເວລາມາດຕະຖານໂຊຍບາຊັນ),
			},
		},
		'Christmas' => {
			long => {
				'standard' => q(ເວລາເກາະຄຣິສມາດ),
			},
		},
		'Cocos' => {
			long => {
				'standard' => q(ເວລາຫມູ່ເກາະໂກໂກສ),
			},
		},
		'Colombia' => {
			long => {
				'daylight' => q(ເວລາລະດູຮ້ອນໂຄລໍາເບຍ),
				'generic' => q(ເວລາໂຄລໍາເບຍ),
				'standard' => q(ເວລາມາດຕະຖານໂຄລຳເບຍ),
			},
		},
		'Cook' => {
			long => {
				'daylight' => q(ເວລາເຄີ່ງລະດູຮ້ອນຫມູ່ເກາະຄຸກ),
				'generic' => q(ເວລາຫມູ່ເກາະຄຸກ),
				'standard' => q(ເວລາມາດຕະຖານຫມູ່ເກາະຄຸກ),
			},
		},
		'Cuba' => {
			long => {
				'daylight' => q(ເວລາຕອນທ່ຽງຂອງຄິວບາ),
				'generic' => q(ເວລາຄິວບາ),
				'standard' => q(ເວລາມາດຕະຖານຂອງຄິວບາ),
			},
		},
		'Davis' => {
			long => {
				'standard' => q(ເວລາເດວິດ),
			},
		},
		'DumontDUrville' => {
			long => {
				'standard' => q(ເວລາດູມອງດູວິລ),
			},
		},
		'East_Timor' => {
			long => {
				'standard' => q(ເວລາຕີມໍຕາເວັນອອກ),
			},
		},
		'Easter' => {
			long => {
				'daylight' => q(ເວລາລະດູຮ້ອນຂອງເກາະອີແລນ),
				'generic' => q(ເວລາເກາະອີແລນ),
				'standard' => q(ເວລາມາດຕະຖານເກາະອີແລນ),
			},
		},
		'Ecuador' => {
			long => {
				'standard' => q(ເວລາເອວາດໍ),
			},
		},
		'Etc/Unknown' => {
			exemplarCity => q#ບໍ່ຮູ້ຈັກ#,
		},
		'Europe/Amsterdam' => {
			exemplarCity => q#ອຳເຕີດຳ#,
		},
		'Europe/Andorra' => {
			exemplarCity => q#ອັນໂດລາ#,
		},
		'Europe/Athens' => {
			exemplarCity => q#ເອເທນ#,
		},
		'Europe/Belgrade' => {
			exemplarCity => q#ເບວເກຣດ#,
		},
		'Europe/Berlin' => {
			exemplarCity => q#ເບີລີນ#,
		},
		'Europe/Bratislava' => {
			exemplarCity => q#ບຮາຕີສລາວາ#,
		},
		'Europe/Brussels' => {
			exemplarCity => q#ບາສເຊວ#,
		},
		'Europe/Bucharest' => {
			exemplarCity => q#ບູຊາເລດສ#,
		},
		'Europe/Budapest' => {
			exemplarCity => q#ບູດາເປດສ#,
		},
		'Europe/Busingen' => {
			exemplarCity => q#ບັດຊິນເກນ#,
		},
		'Europe/Chisinau' => {
			exemplarCity => q#ຄີຊີເນົາ#,
		},
		'Europe/Copenhagen' => {
			exemplarCity => q#ໂກເປນຮາເກັນ#,
		},
		'Europe/Dublin' => {
			exemplarCity => q#ດັບລິນ#,
			long => {
				'daylight' => q(ເວລາລະດູຮ້ອນໄອແລນ),
			},
		},
		'Europe/Gibraltar' => {
			exemplarCity => q#ຢີບຣໍຕາຣ#,
		},
		'Europe/Guernsey' => {
			exemplarCity => q#ເກີນຊີ#,
		},
		'Europe/Helsinki' => {
			exemplarCity => q#ຮໍຊິນກິ#,
		},
		'Europe/Isle_of_Man' => {
			exemplarCity => q#ເກາະແມນ#,
		},
		'Europe/Istanbul' => {
			exemplarCity => q#ອິດຕານບູ#,
		},
		'Europe/Jersey' => {
			exemplarCity => q#ເຈີຊີ#,
		},
		'Europe/Kaliningrad' => {
			exemplarCity => q#ກາລີນິງກາດສ#,
		},
		'Europe/Kiev' => {
			exemplarCity => q#ເຄຍ#,
		},
		'Europe/Lisbon' => {
			exemplarCity => q#ຣິດບອນ#,
		},
		'Europe/Ljubljana' => {
			exemplarCity => q#ລູບລີຍານາ#,
		},
		'Europe/London' => {
			exemplarCity => q#ລອນດອນ#,
			long => {
				'daylight' => q(ເວລາລະດູຮ້ອນອັງກິດ),
			},
		},
		'Europe/Luxembourg' => {
			exemplarCity => q#ລັກແຊມເບີກ#,
		},
		'Europe/Madrid' => {
			exemplarCity => q#ມາດຣິດ#,
		},
		'Europe/Malta' => {
			exemplarCity => q#ມໍຕາ#,
		},
		'Europe/Mariehamn' => {
			exemplarCity => q#ມາລີຮາມ#,
		},
		'Europe/Minsk' => {
			exemplarCity => q#ມີນາດສ#,
		},
		'Europe/Monaco' => {
			exemplarCity => q#ໂມນາໂຄ#,
		},
		'Europe/Moscow' => {
			exemplarCity => q#ມອດສໂກ#,
		},
		'Europe/Oslo' => {
			exemplarCity => q#ອໍໂລ#,
		},
		'Europe/Paris' => {
			exemplarCity => q#ປາຮີດ#,
		},
		'Europe/Podgorica' => {
			exemplarCity => q#ພອດກໍຣີກາ#,
		},
		'Europe/Prague' => {
			exemplarCity => q#ປາກີ#,
		},
		'Europe/Riga' => {
			exemplarCity => q#ລີກາ#,
		},
		'Europe/Rome' => {
			exemplarCity => q#ໂຣມ#,
		},
		'Europe/Samara' => {
			exemplarCity => q#ຊາມາລາ#,
		},
		'Europe/San_Marino' => {
			exemplarCity => q#ຊານມາຣີໂນ#,
		},
		'Europe/Sarajevo' => {
			exemplarCity => q#ສາຣາເຍໂວ#,
		},
		'Europe/Simferopol' => {
			exemplarCity => q#ຊີມເຟໂລໂປ#,
		},
		'Europe/Skopje' => {
			exemplarCity => q#ສະໂກເປຍ#,
		},
		'Europe/Sofia' => {
			exemplarCity => q#ໂຊເຟຍ#,
		},
		'Europe/Stockholm' => {
			exemplarCity => q#ສະຕອກໂຮມ#,
		},
		'Europe/Tallinn' => {
			exemplarCity => q#ທໍລິນ#,
		},
		'Europe/Tirane' => {
			exemplarCity => q#ຕີລານີ#,
		},
		'Europe/Uzhgorod' => {
			exemplarCity => q#ອາສໂກລອດດ#,
		},
		'Europe/Vaduz' => {
			exemplarCity => q#ວາດາຊ#,
		},
		'Europe/Vatican' => {
			exemplarCity => q#ວາຕິກັນ#,
		},
		'Europe/Vienna' => {
			exemplarCity => q#ວຽນນາ#,
		},
		'Europe/Vilnius' => {
			exemplarCity => q#ວີນີອຸດ#,
		},
		'Europe/Volgograd' => {
			exemplarCity => q#ວໍໂກກາດສ#,
		},
		'Europe/Warsaw' => {
			exemplarCity => q#ວອດຊາວ#,
		},
		'Europe/Zagreb' => {
			exemplarCity => q#ຊາແກັບ#,
		},
		'Europe/Zaporozhye' => {
			exemplarCity => q#ຊາໂປໂລຊີ#,
		},
		'Europe/Zurich' => {
			exemplarCity => q#ຊູຣິກ#,
		},
		'Europe_Central' => {
			long => {
				'daylight' => q(ເວລາລະດູຮ້ອນເອີຣົບກາງ),
				'generic' => q(ເວລາເອີຣົບກາງ),
				'standard' => q(ເວລາມາດຕະຖານເອີຮົບກາງ),
			},
		},
		'Europe_Eastern' => {
			long => {
				'daylight' => q(ເວລາລະດູຮ້ອນເອີຣົບຕາເວັນອອກ),
				'generic' => q(ເວລາເອີຣົບຕາເວັນອອກ),
				'standard' => q(ເວລາມາດຕະຖານເອີຣົບຕາເວັນອອກ),
			},
		},
		'Europe_Western' => {
			long => {
				'daylight' => q(ເວລາລະດູຮ້ອນເອີຣົບຕາເວັນຕົກ),
				'generic' => q(ເວລາເອີຣົບຕາເວັນຕົກ),
				'standard' => q(ເວລາມາດຕະຖານເອີຣົບຕາເວັນຕົກ),
			},
		},
		'Falkland' => {
			long => {
				'daylight' => q(ເວລາລະດູຮ້ອນຟອກແລນ),
				'generic' => q(ເວລາຟອກແລນ),
				'standard' => q(ເວລາມາດຕະຖານຟອກແລນ),
			},
		},
		'Fiji' => {
			long => {
				'daylight' => q(ເວລາລະດູຮ້ອນຟິຈິ),
				'generic' => q(ເວລາຟິຈິ),
				'standard' => q(ເວລາມາດຕະຖານຟິຈິ),
			},
		},
		'French_Guiana' => {
			long => {
				'standard' => q(ເວລາກີອານາຝຮັ່ງ),
			},
		},
		'French_Southern' => {
			long => {
				'standard' => q(ເວລາຝຣັ່ງຕອນໃຕ້ແລະແອນຕາກຕິກ),
			},
		},
		'GMT' => {
			long => {
				'standard' => q(ເວລາກຣີນີສ),
			},
		},
		'Galapagos' => {
			long => {
				'standard' => q(ເວລາກາລາປາໂກ),
			},
		},
		'Gambier' => {
			long => {
				'standard' => q(ເວລາແກມເບຍ),
			},
		},
		'Georgia' => {
			long => {
				'daylight' => q(ເວລາລະດູຮ້ອນຈໍເຈຍ),
				'generic' => q(ເວລາຈໍເຈຍ),
				'standard' => q(ເວລາມາດຕະຖານຈໍເຈຍ),
			},
		},
		'Gilbert_Islands' => {
			long => {
				'standard' => q(ເວລາຫມູ່ເກາະກິລເບີດ),
			},
		},
		'Greenland_Eastern' => {
			long => {
				'daylight' => q(ເວລາລະດູຮ້ອນກຮີນແລນຕາເວັນອອກ),
				'generic' => q(ເວລາຕາເວັນອອກຂອງກຮີນແລນ),
				'standard' => q(ເວລາມາດຕະຖານຕາເວັນອອກກຮີນແລນ),
			},
		},
		'Greenland_Western' => {
			long => {
				'daylight' => q(ເວລາຕອນທ່ຽງກຮີນແລນຕາເວັນຕົກ),
				'generic' => q(ເວລາກຮີນແລນຕາເວັນຕົກ),
				'standard' => q(ເວລາມາດຕະຖານກຮີນແລນຕາເວັນຕົກ),
			},
		},
		'Guam' => {
			long => {
				'standard' => q(ເວລາກວມ),
			},
		},
		'Gulf' => {
			long => {
				'standard' => q(ເວລາກຣູ),
			},
		},
		'Guyana' => {
			long => {
				'standard' => q(ເວລາກາຍອານາ),
			},
		},
		'Hawaii_Aleutian' => {
			long => {
				'daylight' => q(ເວລາຕອນທ່ຽງຮາວາຍ-ເອລູທຽນ),
				'generic' => q(ເວລາຮາວາຍ-ເອລູທຽນ),
				'standard' => q(ເວລາມາດຕະຖານຮາວາຍ-ເອລູທຽນ),
			},
		},
		'Hong_Kong' => {
			long => {
				'daylight' => q(ເວລາລະດູຮ້ອນ ຮົງກົງ),
				'generic' => q(ເວລາ ຮົງກົງ),
				'standard' => q(ເວລາມາດຕະຖານຮົງກົງ),
			},
		},
		'Hovd' => {
			long => {
				'daylight' => q(ເວລາລະດູຮ້ອນ ຮອຟ),
				'generic' => q(ເວລາ ຮອຟ),
				'standard' => q(ເວລາມາດຕະຖານ ຮອຟ),
			},
		},
		'India' => {
			long => {
				'standard' => q(ເວລາ ອິນເດຍ),
			},
		},
		'Indian/Antananarivo' => {
			exemplarCity => q#ອັນຕານານາລີໂວ#,
		},
		'Indian/Chagos' => {
			exemplarCity => q#ຊາກັດ#,
		},
		'Indian/Christmas' => {
			exemplarCity => q#ຄຣິດສະມາດ#,
		},
		'Indian/Cocos' => {
			exemplarCity => q#ໂຄໂຄດ#,
		},
		'Indian/Comoro' => {
			exemplarCity => q#ໂຄໂມໂລ້#,
		},
		'Indian/Kerguelen' => {
			exemplarCity => q#ແກເກີເລນ#,
		},
		'Indian/Mahe' => {
			exemplarCity => q#ມາເຮ#,
		},
		'Indian/Maldives' => {
			exemplarCity => q#ມໍດີເວດສ໌#,
		},
		'Indian/Mauritius' => {
			exemplarCity => q#ມູເລຕຽດ#,
		},
		'Indian/Mayotte' => {
			exemplarCity => q#ມາໂຢເຕ#,
		},
		'Indian/Reunion' => {
			exemplarCity => q#ລຸຍນີອອນ#,
		},
		'Indian_Ocean' => {
			long => {
				'standard' => q(ເວລາຫມະຫາສະຫມຸດອິນເດຍ),
			},
		},
		'Indochina' => {
			long => {
				'standard' => q(ເວລາອິນດູຈີນ),
			},
		},
		'Indonesia_Central' => {
			long => {
				'standard' => q(ເວລາອິນໂດເນເຊັຍກາງ),
			},
		},
		'Indonesia_Eastern' => {
			long => {
				'standard' => q(ເວລາອິນໂດເນເຊັຍຕາເວັນອອກ),
			},
		},
		'Indonesia_Western' => {
			long => {
				'standard' => q(ເວລາອິນໂດເນເຊັຍຕາເວັນຕົກ),
			},
		},
		'Iran' => {
			long => {
				'daylight' => q(ເວລາກາງເວັນ ອີຣານ),
				'generic' => q(ເວລາ ອີຣານ),
				'standard' => q(ເວລາມາດຕະຖານ ອີີຣານ),
			},
		},
		'Irkutsk' => {
			long => {
				'daylight' => q(ເວລາລະດູຮ້ອນອີຣກຣູດ),
				'generic' => q(ເວລາອີຣກຣູດ),
				'standard' => q(ເວລາມາດຕະຖານອີຣກຣູດ),
			},
		},
		'Israel' => {
			long => {
				'daylight' => q(ເວລາກາງເວັນອິດສະລາແອນ),
				'generic' => q(ເວລາອິດສະລາແອນ),
				'standard' => q(ເວລາມາດຕະຖານອິດສະລາແອນ),
			},
		},
		'Japan' => {
			long => {
				'daylight' => q(ເວລາກາງເວັນ ຍີ່ປູ່ນ),
				'generic' => q(ເວລາ ຍີ່ປຸ່ນ),
				'standard' => q(ເວລາມາດຕະຖານຂອງຍີ່ປຸ່ນ),
			},
		},
		'Kazakhstan_Eastern' => {
			long => {
				'standard' => q(ເວລາກາຊັກສະຖານຕາເວັນອອກ),
			},
		},
		'Kazakhstan_Western' => {
			long => {
				'standard' => q(ເວລາກາຊັກສະຖານຕາເວັນຕົກ),
			},
		},
		'Korea' => {
			long => {
				'daylight' => q(ເວລາກາງເວັນ ເກົາຫຼີ),
				'generic' => q(ເວລາເກົາຫຼີ),
				'standard' => q(ເວລາ ມາດຕະຖານ ເກົາຫຼີ),
			},
		},
		'Kosrae' => {
			long => {
				'standard' => q(ເວລາຄອສແຣ),
			},
		},
		'Krasnoyarsk' => {
			long => {
				'daylight' => q(ເວລາລະດູຮ້ອນຄຣາສໂນຢາດສ),
				'generic' => q(ເວລາຄຣາສໂນຢາດສ),
				'standard' => q(ເວລາມາດຕະຖານຄຣາສໂນຢາດສ),
			},
		},
		'Kyrgystan' => {
			long => {
				'standard' => q(ເວລາຄຣີກິສຖານ),
			},
		},
		'Lanka' => {
			long => {
				'standard' => q(ເວລາລັງກາ),
			},
		},
		'Line_Islands' => {
			long => {
				'standard' => q(ເວລາຫມູ່ເກາະໄລນ໌),
			},
		},
		'Lord_Howe' => {
			long => {
				'daylight' => q(ເວລາກາງເວັນ ລອດໂຮ),
				'generic' => q(ເວລາ ລອດໂຮ),
				'standard' => q(ເວລາ ມາດຕະຖານລອດໂຮ),
			},
		},
		'Macau' => {
			long => {
				'daylight' => q(ເວລາລະດູຮ້ອນມາເກົາ),
				'generic' => q(ເວລາມາເກົາ),
				'standard' => q(ເວລາມາດຕະຖານມາເກົາ),
			},
		},
		'Macquarie' => {
			long => {
				'standard' => q(ເວລາແມັກຄໍຣີ),
			},
		},
		'Magadan' => {
			long => {
				'daylight' => q(ເວລາລະດູຮ້ອນເມັກກາເດນ),
				'generic' => q(ເວລາເມັກກາເດນ),
				'standard' => q(ເວລາມາດຕະຖານເມັກກາເດນ),
			},
		},
		'Malaysia' => {
			long => {
				'standard' => q(ເວລາມາເລເຊັຍ),
			},
		},
		'Maldives' => {
			long => {
				'standard' => q(ເວລາມັນດີຟ),
			},
		},
		'Marquesas' => {
			long => {
				'standard' => q(ເວລາມາເຄີຊັສ),
			},
		},
		'Marshall_Islands' => {
			long => {
				'standard' => q(ເວລາຫມູ່ເກາະມາແຊລ໌),
			},
		},
		'Mauritius' => {
			long => {
				'daylight' => q(ເວລາລະດູຮ້ອນຂອງມໍຣິເຊຍ),
				'generic' => q(ເວລາມໍຣິເຊຍ),
				'standard' => q(ເວລາມາດຕະຖານມໍຣິເຊຍ),
			},
		},
		'Mawson' => {
			long => {
				'standard' => q(ເວລາມໍສັນ),
			},
		},
		'Mongolia' => {
			long => {
				'daylight' => q(ເວລາລະດູຮ້ອນອູລານບາເຕີ),
				'generic' => q(ເວລາ ອູລານບາເຕີ),
				'standard' => q(ເວລາມາດຕະຖານ ອູລານບາເຕີ),
			},
		},
		'Moscow' => {
			long => {
				'daylight' => q(ເວລາລະດູຮ້ອນໂມ້ສໂກ),
				'generic' => q(ເວລາໂມ້ສໂກ),
				'standard' => q(ເວລາມາດຕະຖານໂມ້ສໂກ),
			},
		},
		'Myanmar' => {
			long => {
				'standard' => q(ເວລາມຽນມາ),
			},
		},
		'Nauru' => {
			long => {
				'standard' => q(ເວລານາອຸລຸ),
			},
		},
		'Nepal' => {
			long => {
				'standard' => q(ເວລາ ເນປານ),
			},
		},
		'New_Caledonia' => {
			long => {
				'daylight' => q(ເວລາລະດູຮ້ອນນິວແຄລິໂດເນຍ),
				'generic' => q(ເວລານິວແຄລິໂດເນຍ),
				'standard' => q(ເວລາມາດຕະຖານນິວແຄລິໂດເນຍ),
			},
		},
		'New_Zealand' => {
			long => {
				'daylight' => q(ເວລາກາງເວັນ ນິວຊີແລນ),
				'generic' => q(ເວລາ ນິວຊີແລນ),
				'standard' => q(ເວລາມາດຕະຖານ ນິວຊີແລນ),
			},
		},
		'Newfoundland' => {
			long => {
				'daylight' => q(ເວລາຕອນທ່ຽງນິວຟັນແລນ),
				'generic' => q(ເວລານິວຟັນແລນ),
				'standard' => q(ເວລາມາດຕະຖານນິວຟັນແລນ),
			},
		},
		'Niue' => {
			long => {
				'standard' => q(ເວລານິອູເອ),
			},
		},
		'Norfolk' => {
			long => {
				'standard' => q(ເວລາ ເກາະ ນອກຟອກ),
			},
		},
		'Noronha' => {
			long => {
				'daylight' => q(ເວລາລະດູຮ້ອນເຟນັນໂດເດໂນຮອນຮາ),
				'generic' => q(ເວລາເຟນັນໂດເດໂນຮອນຮາ),
				'standard' => q(ເວລາມາດຕະຖານເຟນັນໂດເດໂນຮອນຮາ),
			},
		},
		'North_Mariana' => {
			long => {
				'standard' => q(ເວລາຫມູ່ເກາະມາເຣຍນາເຫນືອ),
			},
		},
		'Novosibirsk' => {
			long => {
				'daylight' => q(ເວລາລະດູຮ້ອນໂນໂວຊີບຣິສ),
				'generic' => q(ເວລາໂນໂວຊີບຣິສ),
				'standard' => q(ເວລາມາດຕະຖານໂນໂວຊີບຣິສ),
			},
		},
		'Omsk' => {
			long => {
				'daylight' => q(ເວລາລະດູຮ້ອນໂອ້ມສ),
				'generic' => q(ເວລາໂອ້ມສ),
				'standard' => q(ເວລາມາດຕະຖານໂອ້ມສ),
			},
		},
		'Pacific/Apia' => {
			exemplarCity => q#ເອປີອາ#,
		},
		'Pacific/Auckland' => {
			exemplarCity => q#ອັກແລນ#,
		},
		'Pacific/Chatham' => {
			exemplarCity => q#ແຊແທມ#,
		},
		'Pacific/Easter' => {
			exemplarCity => q#ເອສເຕີ#,
		},
		'Pacific/Efate' => {
			exemplarCity => q#ເອຟາເຕ#,
		},
		'Pacific/Enderbury' => {
			exemplarCity => q#ເອັນເດີເບີລີ#,
		},
		'Pacific/Fakaofo' => {
			exemplarCity => q#ຟາກາວໂຟ#,
		},
		'Pacific/Fiji' => {
			exemplarCity => q#ຟູຈິ#,
		},
		'Pacific/Funafuti' => {
			exemplarCity => q#ຟູນະຟູຕິ#,
		},
		'Pacific/Galapagos' => {
			exemplarCity => q#ກາລາປາໂກດສ#,
		},
		'Pacific/Gambier' => {
			exemplarCity => q#ແກມເບຍ#,
		},
		'Pacific/Guadalcanal' => {
			exemplarCity => q#ກົວດັດຄານັດ#,
		},
		'Pacific/Guam' => {
			exemplarCity => q#ກຣວມ#,
		},
		'Pacific/Honolulu' => {
			exemplarCity => q#ໂຫໂນລູລູ#,
		},
		'Pacific/Johnston' => {
			exemplarCity => q#ຈອນສະໂຕນ#,
		},
		'Pacific/Kiritimati' => {
			exemplarCity => q#ຄີຣິທີມາຕີ#,
		},
		'Pacific/Kosrae' => {
			exemplarCity => q#ຄໍສແຣ#,
		},
		'Pacific/Kwajalein' => {
			exemplarCity => q#ຄວາຈາເລນ#,
		},
		'Pacific/Majuro' => {
			exemplarCity => q#ມາຈູໂຣ#,
		},
		'Pacific/Marquesas' => {
			exemplarCity => q#ມາຄິວຊັດ#,
		},
		'Pacific/Midway' => {
			exemplarCity => q#ມິດເວ#,
		},
		'Pacific/Nauru' => {
			exemplarCity => q#ນາອູຣູ#,
		},
		'Pacific/Niue' => {
			exemplarCity => q#ນີອູເອ#,
		},
		'Pacific/Norfolk' => {
			exemplarCity => q#ນໍຟຣອກ#,
		},
		'Pacific/Noumea' => {
			exemplarCity => q#ນູເມອາ#,
		},
		'Pacific/Pago_Pago' => {
			exemplarCity => q#ປາໂກປາໂກ#,
		},
		'Pacific/Palau' => {
			exemplarCity => q#ປາເລົາ#,
		},
		'Pacific/Pitcairn' => {
			exemplarCity => q#ພິດເຄຣນ#,
		},
		'Pacific/Ponape' => {
			exemplarCity => q#ໂປນາເປ#,
		},
		'Pacific/Port_Moresby' => {
			exemplarCity => q#ພອດມໍສບີ#,
		},
		'Pacific/Rarotonga' => {
			exemplarCity => q#ຣາໂຣຕອງກາ#,
		},
		'Pacific/Saipan' => {
			exemplarCity => q#ໄຊປານ#,
		},
		'Pacific/Tahiti' => {
			exemplarCity => q#ທາຮີຕິ#,
		},
		'Pacific/Tarawa' => {
			exemplarCity => q#ຕາຣາວາ#,
		},
		'Pacific/Tongatapu' => {
			exemplarCity => q#ຕອງກາຕາປູ#,
		},
		'Pacific/Truk' => {
			exemplarCity => q#ຈັກ#,
		},
		'Pacific/Wake' => {
			exemplarCity => q#ເວກ#,
		},
		'Pacific/Wallis' => {
			exemplarCity => q#ວາລິດ#,
		},
		'Pakistan' => {
			long => {
				'daylight' => q(ເວລາລະດູຮ້ອນ ປາກິສຖານ),
				'generic' => q(ເວລາປາກິສຖານ),
				'standard' => q(ເວລາມາດຕະຖານປາກິສຖານ),
			},
		},
		'Palau' => {
			long => {
				'standard' => q(ເວລາປາເລົາ),
			},
		},
		'Papua_New_Guinea' => {
			long => {
				'standard' => q(ເວລາປາປົວກິນີ),
			},
		},
		'Paraguay' => {
			long => {
				'daylight' => q(ເວລາລະດູຮ້ອນປາຮາກວາຍ),
				'generic' => q(ເວລາປາຮາກວາຍ),
				'standard' => q(ເວລາມາດຕະຖານປາຮາກວາຍ),
			},
		},
		'Peru' => {
			long => {
				'daylight' => q(ເວລາລະດູຮ້ອນຂອງເປຮູ),
				'generic' => q(ເວລາເປຮູ),
				'standard' => q(ເວລາມາດຕະຖານເປຮູ),
			},
		},
		'Philippines' => {
			long => {
				'daylight' => q(ເວລາຟີລີປີນຍາມຮ້ອນ),
				'generic' => q(ເວລາຟີລີປິນ),
				'standard' => q(ເວລາມາດຕະຖານຟີລີປີນ),
			},
		},
		'Phoenix_Islands' => {
			long => {
				'standard' => q(ເວລາຫມູ່ເກາະຟີນິກ),
			},
		},
		'Pierre_Miquelon' => {
			long => {
				'daylight' => q(ເວລາຕອນທ່ຽງປີແຍຮແລະມີເກີລົງ),
				'generic' => q(ເວລາປີແຍຮແລະມີເກີລົງ),
				'standard' => q(ເວລາມາດຕະຖານປີແຍຮແລະມີເກີລົງ),
			},
		},
		'Pitcairn' => {
			long => {
				'standard' => q(ເວລາພິດແຄຣ໌ນ),
			},
		},
		'Ponape' => {
			long => {
				'standard' => q(ເວລາໂປເນບ),
			},
		},
		'Qyzylorda' => {
			long => {
				'daylight' => q(ເວລາລະດູຮ້ອນຄີວລໍດາ),
				'generic' => q(ເວລາຄີວລໍດາ),
				'standard' => q(ເວລາມາດຕະຖານຄີວລໍດາ),
			},
		},
		'Reunion' => {
			long => {
				'standard' => q(ເວລາເຮອູເນຍ),
			},
		},
		'Rothera' => {
			long => {
				'standard' => q(ເວລາ ໂຣທີຕາ),
			},
		},
		'Sakhalin' => {
			long => {
				'daylight' => q(ເວລາລະດູຮ້ອນສາຄາລິງ),
				'generic' => q(ເວລາສາຄາລິງ),
				'standard' => q(ເວລາມາດຕະຖານສາຄາລິງ),
			},
		},
		'Samoa' => {
			long => {
				'daylight' => q(ເວລາລະດູຮ້ອນຊາມົວ),
				'generic' => q(ເວລາຊາມົວ),
				'standard' => q(ເວລາມາດຕະຖານຊາມົວ),
			},
		},
		'Seychelles' => {
			long => {
				'standard' => q(ເວລາເຊເຊວ),
			},
		},
		'Singapore' => {
			long => {
				'standard' => q(ເວລາສີງກະໂປ),
			},
		},
		'Solomon' => {
			long => {
				'standard' => q(ເວລາຫມູ່ເກາະໂຊໂລມອນ),
			},
		},
		'South_Georgia' => {
			long => {
				'standard' => q(ເວລາຈໍເຈຍໃຕ້),
			},
		},
		'Suriname' => {
			long => {
				'standard' => q(ເວລາຊູຮິນາເມ),
			},
		},
		'Syowa' => {
			long => {
				'standard' => q(ເວລາ ໂຊວາ),
			},
		},
		'Tahiti' => {
			long => {
				'standard' => q(ເວລາທາຮິຕິ),
			},
		},
		'Taipei' => {
			long => {
				'daylight' => q(ເວລາກາງເວັນ ໄທເປ),
				'generic' => q(ເວລາ ໄທເປ),
				'standard' => q(ເວລາມາດຕະຖານ ໄທເປ),
			},
		},
		'Tajikistan' => {
			long => {
				'standard' => q(ເວລາທາຈິກິສຖານ),
			},
		},
		'Tokelau' => {
			long => {
				'standard' => q(ເວລາໂຕເກເລົາ),
			},
		},
		'Tonga' => {
			long => {
				'daylight' => q(ເວລາລະດູຮ້ອນຕອງກາ),
				'generic' => q(ເວລາຕອງກາ),
				'standard' => q(ເວລາມາດຕະຖານຕອງກາ),
			},
		},
		'Truk' => {
			long => {
				'standard' => q(ເວລາຊຸກ),
			},
		},
		'Turkmenistan' => {
			long => {
				'daylight' => q(ເວລາລະດູຮ້ອນ ຕວກເມນິສຖານ),
				'generic' => q(ເວລາຕວກເມນິສຖານ),
				'standard' => q(ເວລາມາດຕະຖານຕວກເມນິສຖານ),
			},
		},
		'Tuvalu' => {
			long => {
				'standard' => q(ເວລາຕູວາລູ),
			},
		},
		'Uruguay' => {
			long => {
				'daylight' => q(ເວລາລະດູຮ້ອນອຸກູໄວ),
				'generic' => q(ເວລາອຸກູໄວ),
				'standard' => q(ເວລາມາດຕະຖານອຸກູໄວ),
			},
		},
		'Uzbekistan' => {
			long => {
				'daylight' => q(ເວລາລະດູຮ້ອນອຸສເບກິດສະຖານ),
				'generic' => q(ເວລາອຸສເບກິດສະຖານ),
				'standard' => q(ເວລາມາດຕະຖານອຸສເບກິດສະຖານ),
			},
		},
		'Vanuatu' => {
			long => {
				'daylight' => q(ເວລາລະດູຮ້ອນວານູອາຕູ),
				'generic' => q(ເວລາວານູອາຕູ),
				'standard' => q(ເວລາມາດຕະຖານວານູອາຕູ),
			},
		},
		'Venezuela' => {
			long => {
				'standard' => q(ເວລາເວເນຊູລາ),
			},
		},
		'Vladivostok' => {
			long => {
				'daylight' => q(ເວລາລະດູຮ້ອນລາດີໂວສຕົກ),
				'generic' => q(ເວລາລາດີໂວສຕົກ),
				'standard' => q(ເວລາມາດຕະຖານລາດີໂວສຕົກ),
			},
		},
		'Volgograd' => {
			long => {
				'daylight' => q(ເວລາລະດູຮ້ອນໂວໂກກຣາດ),
				'generic' => q(ເວລາໂວໂກກຣາດ),
				'standard' => q(ເວລາມາດຕະຖານໂວໂກກຣາດ),
			},
		},
		'Vostok' => {
			long => {
				'standard' => q(ເວລາ ວອສໂຕກ),
			},
		},
		'Wake' => {
			long => {
				'standard' => q(ເວລາເກາະເວກ),
			},
		},
		'Wallis' => {
			long => {
				'standard' => q(ເວລາວາລລີສແລະຟຸຕູນາ),
			},
		},
		'Yakutsk' => {
			long => {
				'daylight' => q(ເວລາລະດູຮ້ອນຢາກູດສ),
				'generic' => q(ເວລາຢາກູດສ),
				'standard' => q(ເວລາມາດຕະຖານຢາກູດສ),
			},
		},
		'Yekaterinburg' => {
			long => {
				'daylight' => q(ເວລາລະດູຮ້ອນເຢກາເຕລິນເບີກ),
				'generic' => q(ເວລາເຢກາເຕລິນເບີກ),
				'standard' => q(ເວລາມາດຕະຖານເຢກາເຕລິນເບີກ),
			},
		},
	 } }
);
no Moose;
__PACKAGE__->meta->make_immutable;

1;

# vim: tabstop=4
