package Locale::CLDR::Transformations::Bgn::Ru_latn::Ru;
# This file auto generated from Data\common\transforms\ru_Latn-ru-BGN.xml
#	on Tue 10 Oct  8:08:59 pm GMT

use strict;
use warnings;
use version;

our $VERSION = version->declare('v0.34.2');

use v5.10.1;
use mro 'c3';
use utf8;
use if $^V ge v5.12.0, feature => 'unicode_strings';
use Types::Standard qw( Str Int HashRef ArrayRef CodeRef RegexpRef );
use Moo;

BEGIN {
	die "Transliteration requires Perl 5.18 or above"
		unless $^V ge v5.18.0;
}

no warnings 'experimental::regex_sets';
has 'transforms' => (
	is => 'ro',
	isa => ArrayRef,
	init_arg => undef,
	default => sub { [
		qr/(?^um:\G.)/,
		{
			type => 'transform',
			data => [
				{
					from => q(Any),
					to => q(NFC),
				},
			],
		},
		{
			type => 'conversion',
			data => [
				{
					before  => q(\p{Upper}),
					after   => q([^[:Lower:]]),
					replace => q(ʹ),
					result  => q(Ь),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ʹ),
					result  => q(ь),
					revisit => 0,
				},
				{
					before  => q(\p{Upper}),
					after   => q([^[:Lower:]]),
					replace => q(ʺ),
					result  => q(Ъ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ʺ),
					result  => q(ъ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(K[Hh]),
					result  => q(Х),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(k[Hh]),
					result  => q(х),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(T·S),
					result  => q(ТС),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(T·s),
					result  => q(Тс),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(t·S),
					result  => q(тС),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(t·s),
					result  => q(тс),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(T[Ss]),
					result  => q(Ц),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(t[Ss]),
					result  => q(ц),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(C[Hh]),
					result  => q(Ч),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(c[Hh]),
					result  => q(ч),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(S[Hh]·C[Hh]),
					result  => q(ШЧ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(S[Hh]·c[Hh]),
					result  => q(Шч),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(s[Hh]·C[Hh]),
					result  => q(шЧ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(s[Hh]·c[Hh]),
					result  => q(шч),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(S[Hh][Cc][Hh]),
					result  => q(Щ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(s[Hh][Cc][Hh]),
					result  => q(щ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(S[Hh]),
					result  => q(Ш),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(s[Hh]),
					result  => q(ш),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(Y[Ee]),
					result  => q(Е),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(y[Ee]),
					result  => q(е),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(Y[Ëë]),
					result  => q(Ё),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(y[Ëë]),
					result  => q(ё),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(Y[Uu]),
					result  => q(Ю),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(y[Uu]),
					result  => q(ю),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(Y[Aa]),
					result  => q(Я),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(y[Aa]),
					result  => q(я),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^ \p{L} \p{M} \p{N}]),
					replace => q(yy),
					result  => q(ый),
					revisit => 0,
				},
				{
					before  => q([^ \p{L} \p{M} \p{N}]),
					after   => q([^aeëiouyAEËIOUY]),
					replace => q(Y),
					result  => q(Ы),
					revisit => 0,
				},
				{
					before  => q([^ \p{L} \p{M} \p{N}]),
					after   => q([^aeëiouyAEËIOUY]),
					replace => q(y),
					result  => q(ы),
					revisit => 0,
				},
				{
					before  => q((?:[БВГДЖЙКЛМНПРСТФХЦЧШЩЭ]|[бвгджйклмнпрстфхцчшщэ])),
					after   => q(),
					replace => q(Y),
					result  => q(Ы),
					revisit => 0,
				},
				{
					before  => q((?:[БВГДЖЙКЛМНПРСТФХЦЧШЩЭ]|[бвгджйклмнпрстфхцчшщэ])),
					after   => q(),
					replace => q(y),
					result  => q(ы),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(Y),
					result  => q(Й),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(y),
					result  => q(й),
					revisit => 0,
				},
				{
					before  => q([^ \p{L} \p{M} \p{N}]),
					after   => q(),
					replace => q(E),
					result  => q(Э),
					revisit => 0,
				},
				{
					before  => q([^ \p{L} \p{M} \p{N}]),
					after   => q(),
					replace => q(e),
					result  => q(э),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(·E),
					result  => q(Э),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(·e),
					result  => q(э),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(E),
					result  => q(Е),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(e),
					result  => q(е),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(A),
					result  => q(А),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(a),
					result  => q(а),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(B),
					result  => q(Б),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(b),
					result  => q(б),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(V),
					result  => q(В),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(v),
					result  => q(в),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(G),
					result  => q(Г),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(g),
					result  => q(г),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(D),
					result  => q(Д),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(d),
					result  => q(д),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(Ë),
					result  => q(Ё),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ë),
					result  => q(ё),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(Z[Hh]),
					result  => q(Ж),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(z[Hh]),
					result  => q(ж),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(Z),
					result  => q(З),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(z),
					result  => q(з),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(I),
					result  => q(И),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(i),
					result  => q(и),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(K),
					result  => q(К),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(k),
					result  => q(к),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(L),
					result  => q(Л),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(l),
					result  => q(л),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(M),
					result  => q(М),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(m),
					result  => q(м),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(N),
					result  => q(Н),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(n),
					result  => q(н),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(O),
					result  => q(О),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(o),
					result  => q(о),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(P),
					result  => q(П),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(p),
					result  => q(п),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(R),
					result  => q(Р),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(r),
					result  => q(р),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(S),
					result  => q(С),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(s),
					result  => q(с),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(T),
					result  => q(Т),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(t),
					result  => q(т),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(U),
					result  => q(У),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(u),
					result  => q(у),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(F),
					result  => q(Ф),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(f),
					result  => q(ф),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(·Y),
					result  => q(Ы),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(·y),
					result  => q(ы),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(·),
					result  => q(),
					revisit => 0,
				},
			]
		},
	] },
);

no Moo;

1;

# vim: tabstop=4
