=encoding utf8

=head1 NAME

Locale::CLDR::Locales::Ug - Package for language Uyghur

=cut

package Locale::CLDR::Locales::Ug;
# This file auto generated from Data\common\main\ug.xml
#	on Wed 28 Feb 12:16:00 am GMT

use strict;
use warnings;
use version;

our $VERSION = version->declare('v0.44.1');

use v5.10.1;
use mro 'c3';
use utf8;
use if $^V ge v5.12.0, feature => 'unicode_strings';
use Types::Standard qw( Str Int HashRef ArrayRef CodeRef RegexpRef );
use Moo;

extends('Locale::CLDR::Locales::Root');
has 'display_name_language' => (
	is			=> 'ro',
	isa			=> CodeRef,
	init_arg	=> undef,
	default		=> sub {
		 sub {
			 my %languages = (
				'aa' => 'ئافارچە',
 				'ab' => 'ئابخازچە',
 				'ace' => 'ئاتجېچە',
 				'ach' => 'ئاچولىچە',
 				'ada' => 'ئاداڭمېچە',
 				'ady' => 'ئادىگېيچە',
 				'ae' => 'ئاۋېستاچە',
 				'af' => 'ئافرىكانچە',
 				'afh' => 'ئافرىخىلىچە',
 				'agq' => 'ئاگەمچە',
 				'ain' => 'ئاينۇچە',
 				'ak' => 'ئاكانچە',
 				'akk' => 'ئاككادچە',
 				'ale' => 'ئالېيۇتچە',
 				'alt' => 'جەنۇبى ئالتاي تىللىرى',
 				'am' => 'ئامھارچە',
 				'an' => 'ئاراگونچە',
 				'ang' => 'قەدىمكى ئىنگلىزچە',
 				'anp' => 'ئانگىكاچە',
 				'ar' => 'ئەرەبچە',
 				'ar_001' => 'ھازىرقى زامان ئۆلچەملىك ئەرەبچە',
 				'arc' => 'ئارامۇچە',
 				'arn' => 'ماپۇدۇنگۇنچە',
 				'arp' => 'ئاراپاخوچە',
 				'arw' => 'ئاراۋاكچە',
 				'as' => 'ئاسامچە',
 				'asa' => 'ئاسۇچە',
 				'ast' => 'ئاستۇرىيەچە',
 				'av' => 'ئاۋارچە',
 				'awa' => 'ئاۋادىچە',
 				'ay' => 'ئايماراچە',
 				'az' => 'ئەزەربەيجانچە',
 				'ba' => 'باشقىرتچە',
 				'bal' => 'بېلۇجىچە',
 				'ban' => 'بالىچە',
 				'bas' => 'باساچە',
 				'bax' => 'بامۇنچە',
 				'bbj' => 'گومالاچە',
 				'be' => 'بېلارۇسچە',
 				'bej' => 'بېجاچە',
 				'bem' => 'بېمباچە',
 				'bez' => 'بېناچە',
 				'bfd' => 'بافۇتچە',
 				'bg' => 'بۇلغارچە',
 				'bho' => 'بوجپۇرىچە',
 				'bi' => 'بىسلاماچە',
 				'bik' => 'بىكولچە',
 				'bin' => 'بىنىچە',
 				'bkm' => 'كومچە',
 				'bla' => 'سىكسىكاچە',
 				'bm' => 'بامباراچە',
 				'bn' => 'بېنگالچە',
 				'bo' => 'تىبەتچە',
 				'br' => 'بىرېتونچە',
 				'bra' => 'بىراجچە',
 				'brx' => 'بودوچە',
 				'bs' => 'بوسىنچە',
 				'bss' => 'ئاكۇسچە',
 				'bua' => 'بۇرىياتچە',
 				'bug' => 'بۇگىچە',
 				'bum' => 'بۇلۇچە',
 				'byn' => 'بىلىنچە',
 				'byv' => 'مېدۇمباچە',
 				'ca' => 'كاتالانچە',
 				'cad' => 'كاددوچە',
 				'car' => 'كارىبچە',
 				'cay' => 'كايۇگاچە',
 				'cch' => 'ئاتسامچە',
 				'ce' => 'چېچىنچە',
 				'ceb' => 'سېبۇچە',
 				'cgg' => 'چىگاچە',
 				'ch' => 'چامورروچە',
 				'chb' => 'چىبچاچە',
 				'chg' => 'چاغاتايچە',
 				'chk' => 'چۇكچە',
 				'chm' => 'مارىچە',
 				'chn' => 'چىنۇك-ژارگونچە',
 				'cho' => 'چوكتاۋچە',
 				'chp' => 'چىپېۋيانچە',
 				'chr' => 'چېروكىچە',
 				'chy' => 'چېيېنچە',
 				'ckb' => 'مەركىزىي كۇردچە',
 				'co' => 'كورسۇچە',
 				'cop' => 'كوپتىكچە',
 				'cr' => 'كرىچە',
 				'crh' => 'قىرىم تۈركچە',
 				'cs' => 'چېخچە',
 				'csb' => 'كاسزۇبىچە',
 				'cu' => 'قەدىمكى سلاۋيانچە',
 				'cv' => 'چۇۋاشچە',
 				'cy' => 'ۋېلشچە',
 				'da' => 'دانىشچە',
 				'dak' => 'داكوتاچە',
 				'dar' => 'دارگىۋاچە',
 				'dav' => 'تايتاچە',
 				'de' => 'گېرمانچە',
 				'de_AT' => 'ئاۋستىرىيە گېرمانچە',
 				'de_CH' => 'شىۋىتسارىيە ئېگىزلىك گېرمانچە',
 				'del' => 'دېلاۋارېچە',
 				'den' => 'سلاۋچە',
 				'dgr' => 'دوگرىبچە',
 				'din' => 'دىنكاچە',
 				'dje' => 'زارماچە',
 				'doi' => 'دوگرىچە',
 				'dsb' => 'تۆۋەن سوربچە',
 				'dua' => 'دۇئالاچە',
 				'dum' => 'ئوتتۇرا گوللاندىيەچە',
 				'dv' => 'دىۋېخچە',
 				'dyo' => 'جولاچە',
 				'dyu' => 'دىيۇلاچە',
 				'dz' => 'زوڭخاچە',
 				'dzg' => 'دازاگاچە',
 				'ebu' => 'ئېمبۇچە',
 				'ee' => 'ئېۋېچە',
 				'efi' => 'ئېفىكچە',
 				'egy' => 'قەدىمكى مىسىرچە',
 				'eka' => 'ئېكاجۇكچە',
 				'el' => 'گىرېكچە',
 				'elx' => 'ئېلامىتچە',
 				'en' => 'ئىنگلىزچە',
 				'en_AU' => 'ئاۋسترالىيە ئىنگلىزچە',
 				'en_CA' => 'كانادا ئىنگلىزچە',
 				'en_GB' => 'ئەنگلىيە ئىنگلىزچە',
 				'en_US' => 'ئامېرىكا ئىنگلىزچە',
 				'enm' => 'ئوتتۇرا ئەسىر ئىنگلىزچە',
 				'eo' => 'ئېسپرانتوچە',
 				'es' => 'ئىسپانچە',
 				'es_419' => 'لاتىن ئامېرىكا ئىسپانچە',
 				'es_ES' => 'ياۋروپا ئىسپانچە',
 				'es_MX' => 'مېكسىكا ئىسپانچە',
 				'et' => 'ئېستونچە',
 				'eu' => 'باسكىچە',
 				'ewo' => 'ئېۋوندوچە',
 				'fa' => 'پارسچە',
 				'fan' => 'فاڭچە',
 				'fat' => 'فانتىچە',
 				'ff' => 'فۇلاھچە',
 				'fi' => 'فىنچە',
 				'fil' => 'فىلىپپىنچە',
 				'fj' => 'فىجىچە',
 				'fo' => 'فائېروچە',
 				'fon' => 'فونچە',
 				'fr' => 'فىرانسۇزچە',
 				'fr_CA' => 'كانادا فىرانسۇزچە',
 				'fr_CH' => 'شىۋىتسارىيە فىرانسۇزچە',
 				'frm' => 'ئوتتۇرا ئەسىر فىرانسۇزچە',
 				'fro' => 'قەدىمكى فىرانسۇزچە',
 				'frr' => 'شىمالى فىرىزيەچە',
 				'frs' => 'شەرقى فىرىزيەچە',
 				'fur' => 'فىرىئۇلىچە',
 				'fy' => 'غەربىي فىرسچە',
 				'ga' => 'ئىرېلاندچە',
 				'gaa' => 'گاچە',
 				'gay' => 'گايوچە',
 				'gba' => 'گىباياچە',
 				'gd' => 'شوتلاندىيە گايلچىسى',
 				'gez' => 'گىزچە',
 				'gil' => 'گىلبېرتچە',
 				'gl' => 'گالىچە',
 				'gmh' => 'ئوتتۇرا ئەسىر ئېگىزلىك گېرمانچە',
 				'gn' => 'گۇئارانىچە',
 				'goh' => 'قەدىمكى ئېگىزلىك گېرمانچە',
 				'gon' => 'گوندىچە',
 				'gor' => 'گورونتالوچە',
 				'got' => 'گوتچە',
 				'grb' => 'گرېبوچە',
 				'grc' => 'قەدىمكى گىرېكچە',
 				'gsw' => 'گېرمانچە شىۋىتسارىيە',
 				'gu' => 'گۇجاراتچە',
 				'guz' => 'گۇسىچە',
 				'gv' => 'مانچە',
 				'gwi' => 'گىۋىچىنچە',
 				'ha' => 'خائۇساچە',
 				'hai' => 'ھەيدەچە',
 				'haw' => 'ھاۋايچە',
 				'he' => 'ئىبرانىيچە',
 				'hi' => 'ھىندىچە',
 				'hil' => 'خىلىگاينونچە',
 				'hit' => 'خىتتىتچە',
 				'hmn' => 'مۆڭچە',
 				'ho' => 'ھىرى موتۇچە',
 				'hr' => 'كىرودىچە',
 				'hsb' => 'ئۈستۈن سوربچە',
 				'ht' => 'ھايتىچە',
 				'hu' => 'ۋېنگىرچە',
 				'hup' => 'خۇپاچە',
 				'hy' => 'ئەرمېنچە',
 				'hz' => 'خېرېروچە',
 				'ia' => 'ئارىلىق تىل',
 				'iba' => 'ئىبانچە',
 				'ibb' => 'ئىبىبىئوچە',
 				'id' => 'ھىندونېزچە',
 				'ie' => 'ئىنتىرلىڭچە',
 				'ig' => 'ئىگبوچە',
 				'ii' => 'يىچە (سىچۈەن)',
 				'ik' => 'ئىنۇپىكچە',
 				'ilo' => 'ئىلوكانوچە',
 				'inh' => 'ئىنگۇشچە',
 				'io' => 'ئىدوچە',
 				'is' => 'ئىسلاندچە',
 				'it' => 'ئىتالىيانچە',
 				'iu' => 'ئىنۇكتىتۇتچە',
 				'ja' => 'ياپونچە',
 				'jbo' => 'لوجبانچە',
 				'jgo' => 'نگومباچە',
 				'jmc' => 'ماچامچە',
 				'jpr' => 'ئىبرانى پارسچە',
 				'jrb' => 'ئىبرانى ئەرەبچە',
 				'jv' => 'ياۋاچە',
 				'ka' => 'گىرۇزچە',
 				'kaa' => 'قارا-قالپاقچە',
 				'kab' => 'كابىلېچە',
 				'kac' => 'كاچىنچە',
 				'kaj' => 'جۇچە',
 				'kam' => 'كامباچە',
 				'kaw' => 'كاۋىچە',
 				'kbd' => 'كاباردەيچە',
 				'kbl' => 'كانېمبۇچە',
 				'kcg' => 'تياپچە',
 				'kde' => 'ماكوندېچە',
 				'kea' => 'كابۇۋېردىيانچە',
 				'kfo' => 'كوروچە',
 				'kg' => 'كونگوچە',
 				'kha' => 'كاسىچە',
 				'kho' => 'خوتەنچە',
 				'khq' => 'كويرا چىنىچە',
 				'ki' => 'كىكۇيۇچە',
 				'kj' => 'كىۋانياماچە',
 				'kk' => 'قازاقچە',
 				'kkj' => 'كاكوچە',
 				'kl' => 'گىرېنلاندچە',
 				'kln' => 'كالېنجىنچە',
 				'km' => 'كىمېرچە',
 				'kmb' => 'كىمبۇندۇچە',
 				'kn' => 'كانناداچە',
 				'ko' => 'كورېيەچە',
 				'kok' => 'كونكانچە',
 				'kos' => 'كوسرايېچە',
 				'kpe' => 'كىپەللېچە',
 				'kr' => 'كانۇرچە',
 				'krc' => 'قاراچاي-بالقارچە',
 				'krl' => 'كارەلچە',
 				'kru' => 'كۇرۇخچە',
 				'ks' => 'كەشمىرچە',
 				'ksb' => 'شامبالاچە',
 				'ksf' => 'بافىياچە',
 				'ksh' => 'كولىشچە',
 				'ku' => 'كۇردچە',
 				'kum' => 'قۇمۇقچە',
 				'kut' => 'كۇتەنايچە',
 				'kv' => 'كومىچە',
 				'kw' => 'كورنىشچە',
 				'ky' => 'قىرغىزچە',
 				'la' => 'لاتىنچە',
 				'lad' => 'لادىنوچە',
 				'lag' => 'لانگىچە',
 				'lah' => 'لانداچە',
 				'lam' => 'لامباچە',
 				'lb' => 'لىيۇكسېمبۇرگچە',
 				'lez' => 'لېزگىنچە',
 				'lg' => 'گانداچە',
 				'li' => 'لىمبۇرگچە',
 				'ln' => 'لىنگالاچە',
 				'lo' => 'لائوسچە',
 				'lol' => 'مونگوچە',
 				'loz' => 'لوزىچە',
 				'lt' => 'لىتۋانىچە',
 				'lu' => 'لۇبا-كاتانگاچە',
 				'lua' => 'لۇبا-لۇئاچە',
 				'lui' => 'لۇيسېنگوچە',
 				'lun' => 'لۇنداچە',
 				'luo' => 'لۇئوچە',
 				'lus' => 'مىزوچە',
 				'luy' => 'لۇياچە',
 				'lv' => 'لاتچە',
 				'mad' => 'مادۇرېسچە',
 				'maf' => 'مافاچە',
 				'mag' => 'ماگاخىچە',
 				'mai' => 'مايتىلىچە',
 				'mak' => 'ماكاسارچە',
 				'man' => 'ماندىنگوچە',
 				'mas' => 'ماسايچە',
 				'mde' => 'ماباچە',
 				'mdf' => 'موكشاچە',
 				'mdr' => 'ماندارچە',
 				'men' => 'مېندېچە',
 				'mer' => 'مېرۇچە',
 				'mfe' => 'مورىسيېنچە',
 				'mg' => 'مالاگاسچە',
 				'mga' => 'ئوتتۇرا ئەسىر ئىرېلاندچە',
 				'mgh' => 'ماكۇۋاچە',
 				'mgo' => 'مېتاچە’',
 				'mh' => 'مارشالچە',
 				'mi' => 'ماۋرىچە',
 				'mic' => 'مىكماكچە',
 				'min' => 'مىناڭكابائۇچە',
 				'mk' => 'ماكېدونچە',
 				'ml' => 'مالايالامچە',
 				'mn' => 'موڭغۇلچە',
 				'mnc' => 'مانجۇچە',
 				'mni' => 'مانىپۇرچە',
 				'moh' => 'موخاۋكچە',
 				'mos' => 'موسسىچە',
 				'mr' => 'ماراتىچە',
 				'ms' => 'مالايچە',
 				'mt' => 'مالتاچە',
 				'mua' => 'مۇنداڭچە',
 				'mul' => 'كۆپ تىللار',
 				'mus' => 'كىرىكچە',
 				'mwl' => 'مىراندېسچە',
 				'mwr' => 'مارۋارىچە',
 				'my' => 'بىرماچە',
 				'mye' => 'ميېنېچە',
 				'myv' => 'ئېرزاچە',
 				'na' => 'ناۋرۇچە',
 				'nap' => 'ناپولىچە',
 				'naq' => 'ناماچە',
 				'nb' => 'نورۋىگىيە بوكمالچە',
 				'nd' => 'شىمالى ندەبەلەچە',
 				'nds' => 'تۆۋەن گېرمانچە',
 				'ne' => 'نېپالچە',
 				'new' => 'نېۋارىچە',
 				'ng' => 'ندونگاچە',
 				'nia' => 'نىئاسچە',
 				'niu' => 'نيۇئېچە',
 				'nl' => 'گوللاندچە',
 				'nmg' => 'كۋاسىيوچە',
 				'nn' => 'يېڭى نورۋېگچە',
 				'nnh' => 'نگېمبۇنچە',
 				'no' => 'نورۋېگچە',
 				'nog' => 'نوغايچە',
 				'non' => 'قەدىمكى نورۋېگچە',
 				'nqo' => 'نىكوچە',
 				'nr' => 'جەنۇبى ندەبەلەچە',
 				'nso' => 'شىمالىي سوتوچە',
 				'nus' => 'مۇئېرچە',
 				'nv' => 'ناۋاخوچە',
 				'nwc' => 'نېۋارچە',
 				'ny' => 'نىيانجاچە',
 				'nym' => 'نيامۋېزىچە',
 				'nyn' => 'نىيانكولېچە',
 				'nyo' => 'نىئوروچە',
 				'nzi' => 'نىزەماچە',
 				'oc' => 'ئوكسىتچە',
 				'oj' => 'ئوجىبۋاچە',
 				'om' => 'ئوروموچە',
 				'or' => 'ئودىياچە',
 				'os' => 'ئوسسېتچەچە',
 				'osa' => 'ئوساگېلارچە',
 				'ota' => 'ئوسمان تۈركچە',
 				'pa' => 'پەنجابچە',
 				'pag' => 'پانگاسىنانچە',
 				'pal' => 'پەھلەۋىچە',
 				'pam' => 'پامپانگاچە',
 				'pap' => 'پاپىيامېنتوچە',
 				'pau' => 'پالاۋچە',
 				'peo' => 'قەدىمكى پارىسچە',
 				'phn' => 'فىنىكىيەچە',
 				'pi' => 'پالىچە',
 				'pl' => 'پولەكچە',
 				'pon' => 'پوناپېئانچە',
 				'pro' => 'قەدىمكى پروۋېنچالچە',
 				'ps' => 'پۇشتۇچە',
 				'pt' => 'پورتۇگالچە',
 				'pt_BR' => 'بىرازىلىيە پورتۇگالچە',
 				'pt_PT' => 'ياۋروپا پورتۇگالچە',
 				'qu' => 'كېچىۋاچە',
 				'raj' => 'راجاستانچە',
 				'rap' => 'راپانىيچە',
 				'rm' => 'رومانسچە',
 				'rn' => 'رۇندىچە',
 				'ro' => 'رومىنچە',
 				'rof' => 'رومبوچە',
 				'rom' => 'سىگانچە',
 				'ru' => 'رۇسچە',
 				'rup' => 'ئارومانچە',
 				'rw' => 'كېنىيەرىۋانداچە',
 				'rwk' => 'رىۋاچە',
 				'sa' => 'سانسكرىتچە',
 				'sad' => 'سانداۋېچە',
 				'sah' => 'ساخاچە',
 				'sam' => 'سامارىتانچە',
 				'saq' => 'سامبۇرۇچە',
 				'sas' => 'ساساكچە',
 				'sat' => 'سانتالچە',
 				'sba' => 'نگامبايچە',
 				'sbp' => 'سانگۇچە',
 				'sc' => 'ساردىنىيەچە',
 				'scn' => 'سىتسىلىيەچە',
 				'sco' => 'شوتلاندىيەچە',
 				'sd' => 'سىندىچە',
 				'se' => 'شىمالىي سامىچە',
 				'see' => 'سېكنېكاچە',
 				'seh' => 'سېناچە',
 				'sel' => 'سېلكاپچە',
 				'ses' => 'شەرقىي سوڭخايچە',
 				'sg' => 'سانگوچە',
 				'sga' => 'قەدىمكى ئىرېلاندچە',
 				'sh' => 'سېرب-كرودىيەچە',
 				'shi' => 'شىلخاچە',
 				'shn' => 'شانچە',
 				'shu' => 'چاد ئەرەبچە',
 				'si' => 'سىنگالچە',
 				'sid' => 'سىداموچە',
 				'sk' => 'سىلوۋاكچە',
 				'sl' => 'سىلوۋېنچە',
 				'sm' => 'ساموئاچە',
 				'sma' => 'جەنۇبىي سامىچە',
 				'smj' => 'لۇلې سامىچە',
 				'smn' => 'ئىنارى سامىچە',
 				'sms' => 'سكولت سامىچە',
 				'sn' => 'شوناچە',
 				'snk' => 'سونىنكەچە',
 				'so' => 'سومالىچە',
 				'sog' => 'سوغدىچە',
 				'sq' => 'ئالبانچە',
 				'sr' => 'سېربچە',
 				'srn' => 'سىرانان-توڭوچە',
 				'srr' => 'سېرېرچە',
 				'ss' => 'سىۋاتىچە',
 				'ssy' => 'ساخوچە',
 				'st' => 'سوتوچە',
 				'su' => 'سۇنداچە',
 				'suk' => 'سۇكۇماچە',
 				'sus' => 'سۇسۇچە',
 				'sux' => 'سۈمەرچە',
 				'sv' => 'شىۋېدچە',
 				'sw' => 'سىۋاھىلچە',
 				'sw_CD' => 'كونگو سىۋالىچە',
 				'swb' => 'كومورىچە',
 				'syc' => 'قەدىمىي سۇرىيەچە',
 				'syr' => 'سۇرىيەچە',
 				'ta' => 'تامىلچە',
 				'te' => 'تېلۇگۇچە',
 				'tem' => 'تېمنېچە',
 				'teo' => 'تېسوچە',
 				'ter' => 'تېرېناچە',
 				'tet' => 'تېتۇمچە',
 				'tg' => 'تاجىكچە',
 				'th' => 'تايلاندچە',
 				'ti' => 'تىگرىنياچە',
 				'tig' => 'تىگرېچە',
 				'tiv' => 'تىۋچە',
 				'tk' => 'تۈركمەنچە',
 				'tkl' => 'توكېلاۋچە',
 				'tl' => 'تاگالوگچە',
 				'tlh' => 'كىلىنگونچە',
 				'tli' => 'تىلىنگىتچە',
 				'tmh' => 'تاماشېكچە',
 				'tn' => 'سىۋاناچە',
 				'to' => 'تونگانچە',
 				'tog' => 'نياسا توڭانچە',
 				'tpi' => 'توك-پىسىنچە',
 				'tr' => 'تۈركچە',
 				'trv' => 'توروكوچە',
 				'ts' => 'سونگاچە',
 				'tsi' => 'سىمشيانچە',
 				'tt' => 'تاتارچە',
 				'tum' => 'تۇمبۇكاچە',
 				'tvl' => 'تۇۋالۇچە',
 				'tw' => 'تىۋىچە',
 				'twq' => 'شىمالىي سوڭخايچە',
 				'ty' => 'تاختىچە',
 				'tyv' => 'توۋاچە',
 				'tzm' => 'مەركىزىي ئاتلاس تامازايتچە',
 				'udm' => 'ئۇدمۇرتچە',
 				'ug' => 'ئۇيغۇرچە',
 				'uga' => 'ئۇگارىتىكچە',
 				'uk' => 'ئۇكرائىنچە',
 				'umb' => 'ئۇمبۇندۇچە',
 				'und' => 'يوچۇن تىل',
 				'ur' => 'ئوردۇچە',
 				'uz' => 'ئۆزبېكچە',
 				'vai' => 'ۋايچە',
 				've' => 'ۋېنداچە',
 				'vi' => 'ۋىيېتنامچە',
 				'vo' => 'ۋولاپۇكچە',
 				'vot' => 'ۋوتېچە',
 				'vun' => 'ۋۇنجوچە',
 				'wa' => 'ۋاللۇنچە',
 				'wae' => 'ۋالسېرچە',
 				'wal' => 'ۋولايتاچە',
 				'war' => 'ۋارايچە',
 				'was' => 'ۋاشوچە',
 				'wo' => 'ۋولوفچە',
 				'xal' => 'قالماقچە',
 				'xh' => 'خوساچە',
 				'xog' => 'سوگاچە',
 				'yao' => 'ياۋچە',
 				'yap' => 'ياپچە',
 				'yav' => 'ياڭبەنچە',
 				'ybb' => 'يېمباچە',
 				'yi' => 'يىددىشچە',
 				'yo' => 'يورۇباچە',
 				'yue' => 'گۇاڭدوڭچە',
 				'za' => 'جۇاڭچە',
 				'zap' => 'زاپوتېكچە',
 				'zbl' => 'بىلىس بەلگىلىرى',
 				'zen' => 'زېناگاچە',
 				'zgh' => 'ئۆلچەملىك ماراكەش تامازىتچە',
 				'zh' => 'خەنزۇچە',
 				'zh_Hans' => 'ئاددىي خەنچە',
 				'zh_Hant' => 'مۇرەككەپ خەنچە',
 				'zu' => 'زۇلۇچە',
 				'zun' => 'زۇنىچە',
 				'zxx' => 'تىل مەزمۇنى يوق',
 				'zza' => 'زازاچە',

			);
			if (@_) {
				return $languages{$_[0]};
			}
			return \%languages;
		}
	},
);

has 'display_name_script' => (
	is			=> 'ro',
	isa			=> CodeRef,
	init_arg	=> undef,
	default		=> sub {
		sub {
			my %scripts = (
			'Afak' => 'ئافاكا',
 			'Arab' => 'ئەرەب',
 			'Armi' => 'خان جەمەتى ئارامۇ',
 			'Armn' => 'ئەرمەن',
 			'Avst' => 'ئاۋېستا',
 			'Bali' => 'بالى',
 			'Bamu' => 'بامۇم',
 			'Bass' => 'باسسا',
 			'Batk' => 'باتاك',
 			'Beng' => 'بېنگال',
 			'Blis' => 'بىلىس بەلگىلىرى',
 			'Bopo' => 'خەنچە پىنيىن',
 			'Brah' => 'براخمى',
 			'Brai' => 'برائىل ئەمالار يېزىقى',
 			'Bugi' => 'بۇگى',
 			'Buhd' => 'بۇخىت',
 			'Cakm' => 'چاكما',
 			'Cans' => 'بىرلىككە كەلگەن كانادا يەرلىك بوغۇم جەدۋىلى',
 			'Cari' => 'كارىيا',
 			'Cham' => 'چام',
 			'Cher' => 'چېروكى',
 			'Cirt' => 'كىرسچە',
 			'Copt' => 'كوپتىك',
 			'Cprt' => 'سىپرۇس',
 			'Cyrl' => 'كىرىل',
 			'Cyrs' => 'قەدىمكى چىركاۋ سىلاۋيانچە كىرىل',
 			'Deva' => 'دېۋاناگارى',
 			'Dsrt' => 'دېزېرېت',
 			'Dupl' => 'دۇپلويان تېز خاتىرىلەش',
 			'Egyd' => 'دېموتىكچە مىسىر',
 			'Egyh' => 'خىيەراتىكچە مىسىر',
 			'Egyp' => 'تەسۋىرىي يېزىق مىسىر',
 			'Ethi' => 'ئېفىيوپىيەچە',
 			'Geok' => 'خۇتسۇرى گىرۇزىنچە',
 			'Geor' => 'گىرۇزىنچە',
 			'Glag' => 'گىلاگوتچە',
 			'Goth' => 'گوتچە',
 			'Gran' => 'گىرانتاچە',
 			'Grek' => 'گىرېكچە',
 			'Gujr' => 'گۇجاراتچە',
 			'Guru' => 'گۇرمۇكىچە',
 			'Hani' => 'خەنچە',
 			'Hano' => 'خانۇنۇچە',
 			'Hans' => 'ئاددىي خەنچە',
 			'Hant' => 'مۇرەككەپ خەنچە',
 			'Hebr' => 'ئىبرانىچە',
 			'Hira' => 'خىراگانا',
 			'Hluw' => 'ئاناتولىيە تەسۋىرىي يېزىق',
 			'Hmng' => 'مۆڭچە',
 			'Hrkt' => 'ياپونچە خىراگانا ياكى كاتاكانا',
 			'Hung' => 'قەدىمكى ماجارچە',
 			'Inds' => 'ئىندۇسچە',
 			'Ital' => 'قەدىمكى ئىتاليانچە',
 			'Java' => 'ياۋاچە',
 			'Jpan' => 'ياپونچە',
 			'Jurc' => 'جۇرچېنچە',
 			'Kali' => 'كاياھچە',
 			'Kana' => 'كاتاكانا',
 			'Khar' => 'كاروشتىچە',
 			'Khmr' => 'كېخمېرچە',
 			'Khoj' => 'خوجكىچە',
 			'Knda' => 'كانناداچە',
 			'Kore' => 'كورېيەچە',
 			'Kpel' => 'كپېللېچە',
 			'Kthi' => 'كاياتىچە',
 			'Lana' => 'لانناچە',
 			'Laoo' => 'لائوسچە',
 			'Latf' => 'فىراكتۇر لاتىنچە',
 			'Latg' => 'سىكوت لاتىنچە',
 			'Latn' => 'لاتىنچە',
 			'Lepc' => 'لەپچاچە',
 			'Limb' => 'لىمبۇچە',
 			'Lina' => 'سىزىقلىق A',
 			'Linb' => 'سىزىقلىق B',
 			'Lisu' => 'فراسېرچە',
 			'Loma' => 'لوماچە',
 			'Lyci' => 'لىسىيانچە',
 			'Lydi' => 'لىدىيەچە',
 			'Mand' => 'ماندائىكچە',
 			'Mani' => 'مانەكېزەمچە',
 			'Maya' => 'ماياچە تەسۋىرىي يېزىق',
 			'Mend' => 'مېندېچە',
 			'Merc' => 'مېتروئىت يازمىچە',
 			'Mero' => 'مېتروئىت',
 			'Mlym' => 'مالايامچە',
 			'Mong' => 'موڭغۇلچە',
 			'Moon' => 'كورىيە',
 			'Mroo' => 'مروچە',
 			'Mtei' => 'مانىپۇرىچە',
 			'Mymr' => 'بىرماچە',
 			'Narb' => 'قەدىمكى شىمالىي ئەرەبچە',
 			'Nbat' => 'ئانباتچە',
 			'Nkgb' => 'ناشىچە',
 			'Nkoo' => 'نىكوچە',
 			'Nshu' => 'نۈشۇچە',
 			'Ogam' => 'ئوگەمچە',
 			'Olck' => 'ئول-چىكىچە',
 			'Orkh' => 'ئورخۇنچە',
 			'Orya' => 'ئورىياچە',
 			'Osma' => 'ئوسمانيە',
 			'Palm' => 'پالمىراچە',
 			'Perm' => 'قەدىمكى پېرمىكچە',
 			'Phag' => 'پاسپاچە',
 			'Phli' => 'پەھلىۋىچە ئويما خەت',
 			'Phlp' => 'پەھلىۋىچە شېئىرىي تىل',
 			'Phlv' => 'پەھلىۋىچە كىتابى تىل',
 			'Phnx' => 'فىنىكچە',
 			'Plrd' => 'پوللارد تاۋۇشلىرى',
 			'Prti' => 'پارتىئانچە ئويما خەت',
 			'Rjng' => 'رېجاڭچە',
 			'Roro' => 'روڭگوروڭگو',
 			'Runr' => 'رۇنىكچە',
 			'Samr' => 'سامارىچە',
 			'Sara' => 'ساراتىچە',
 			'Sarb' => 'قەدىمكى جەنۇبى ئەرەبچە',
 			'Saur' => 'سائۇراشتىراچە',
 			'Sgnw' => 'ئىشارەت تىلى',
 			'Shaw' => 'شاۋىيانچە',
 			'Shrd' => 'شاراداچە',
 			'Sind' => 'كۇداۋادچە',
 			'Sinh' => 'سىنخالاچە',
 			'Sora' => 'سورا سامپىڭ',
 			'Sund' => 'سۇنداچە',
 			'Sylo' => 'سىيولوتى-ناگرىچە',
 			'Syrc' => 'سۈرىيەچە',
 			'Syre' => 'سۈرىيەچە ئەبجەت',
 			'Syrj' => 'غەربىي سۈرىيەچە',
 			'Syrn' => 'شەرقىي سۈرىيەچە',
 			'Tagb' => 'تاگبانۋاچە',
 			'Takr' => 'تاكرىچە',
 			'Tale' => 'تاي-لەچە',
 			'Talu' => 'يېڭى تاي-لەچە',
 			'Taml' => 'تامىلچە',
 			'Tang' => 'تاڭغۇتچە',
 			'Tavt' => 'تايلاندچە-ۋىيېتنامچە',
 			'Telu' => 'تېلۇگۇچە',
 			'Teng' => 'تېڭۋارچە',
 			'Tfng' => 'تىفىناغچە',
 			'Tglg' => 'تاگالوگچە',
 			'Thaa' => 'تاناچە',
 			'Thai' => 'تايلاندچە',
 			'Tibt' => 'تىبەتچە',
 			'Tirh' => 'تىرخۇتاچە',
 			'Ugar' => 'ئۇگارىتىكچە',
 			'Vaii' => 'ۋايچە',
 			'Visp' => 'كۆرۈنۈشچان تاۋۇش',
 			'Wara' => 'ۋاراڭ كىشىتى',
 			'Wole' => 'ۋولىئاي',
 			'Xpeo' => 'قەدىمكى پارىسچە',
 			'Xsux' => 'سۇمېر-ئاككادىيان مىخ خەت',
 			'Yiii' => 'يىچە',
 			'Zinh' => 'ئىرسىيەت ئاتالغۇ',
 			'Zmth' => 'ماتېماتىكىلىق بەلگە',
 			'Zsym' => 'بەلگە',
 			'Zxxx' => 'يېزىلمىغان',
 			'Zyyy' => 'ئورتاق',
 			'Zzzz' => 'يوچۇن يېزىق',

			);
			if ( @_ ) {
				return $scripts{$_[0]};
			}
			return \%scripts;
		}
	}
);

has 'display_name_region' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'001' => 'دۇنيا',
 			'002' => 'ئافرىقا',
 			'003' => 'شىمالىي ئامېرىكا',
 			'005' => 'جەنۇبىي ئامېرىكا',
 			'009' => 'ئوكيانىيە',
 			'011' => 'غەربىي ئافرىقا',
 			'013' => 'ئوتتۇرا ئامېرىكا',
 			'014' => 'شەرقىي ئافرىقا',
 			'015' => 'شىمالىي ئافرىقا',
 			'017' => 'ئوتتۇرا ئافرىقا',
 			'018' => 'جەنۇبىي ئافرىقا رايونى',
 			'019' => 'ئامېرىكا',
 			'021' => 'شىمالىي ئامېرىكا رايونى',
 			'029' => 'كارىب دېڭىزى',
 			'030' => 'شەرقىي ئاسىيا',
 			'034' => 'جەنۇبىي ئاسىيا',
 			'035' => 'شەرقىي جەنۇبىي ئاسىيا',
 			'039' => 'جەنۇبىي ياۋروپا',
 			'053' => 'ئاۋسترالئاسىيا',
 			'054' => 'مېلانېسىيە',
 			'057' => 'مىكرونېزىيە رايونى',
 			'061' => 'پولىنىزىيە',
 			'142' => 'ئاسىيا',
 			'143' => 'ئوتتۇرا ئاسىيا',
 			'145' => 'غەربىي ئاسىيا',
 			'150' => 'ياۋروپا',
 			'151' => 'شەرقىي ياۋروپا',
 			'154' => 'شىمالىي ياۋروپا',
 			'155' => 'غەربىي ياۋروپا',
 			'419' => 'لاتىن ئامېرىكا',
 			'AC' => 'ئاسسېنسىيون ئارىلى',
 			'AD' => 'ئاندوررا',
 			'AE' => 'ئەرەب بىرلەشمە خەلىپىلىكى',
 			'AF' => 'ئافغانىستان',
 			'AG' => 'ئانتىگۇئا ۋە باربۇدا',
 			'AI' => 'ئانگۋىللا',
 			'AL' => 'ئالبانىيە',
 			'AM' => 'ئەرمېنىيە',
 			'AO' => 'ئانگولا',
 			'AQ' => 'ئانتاركتىكا',
 			'AR' => 'ئارگېنتىنا',
 			'AS' => 'ئامېرىكا ساموئا',
 			'AT' => 'ئاۋىستىرىيە',
 			'AU' => 'ئاۋسترالىيە',
 			'AW' => 'ئارۇبا',
 			'AX' => 'ئالاند ئاراللىرى',
 			'AZ' => 'ئەزەربەيجان',
 			'BA' => 'بوسىنىيە ۋە گېرتسېگوۋىنا',
 			'BB' => 'باربادوس',
 			'BD' => 'بېنگال',
 			'BE' => 'بېلگىيە',
 			'BF' => 'بۇركىنا فاسو',
 			'BG' => 'بۇلغارىيە',
 			'BH' => 'بەھرەين',
 			'BI' => 'بۇرۇندى',
 			'BJ' => 'بېنىن',
 			'BL' => 'ساينت بارتېلېمى',
 			'BM' => 'بېرمۇدا',
 			'BN' => 'بىرۇنېي',
 			'BO' => 'بولىۋىيە',
 			'BQ' => 'كارىب دېڭىزى گوللاندىيە',
 			'BR' => 'بىرازىلىيە',
 			'BS' => 'باھاما',
 			'BT' => 'بۇتان',
 			'BV' => 'بوۋېت ئارىلى',
 			'BW' => 'بوتسۋانا',
 			'BY' => 'بېلارۇسىيە',
 			'BZ' => 'بېلىز',
 			'CA' => 'كانادا',
 			'CC' => 'كوكوس (كىلىڭ) ئاراللىرى',
 			'CD' => 'كونگو - كىنشاسا',
 			'CD@alt=variant' => 'كونگو (ك د ج)',
 			'CF' => 'ئوتتۇرا ئافرىقا جۇمھۇرىيىتى',
 			'CG' => 'كونگو - بىراززاۋىل',
 			'CG@alt=variant' => 'كونگو (جۇمھۇرىيىتى)',
 			'CH' => 'شىۋېتسارىيە',
 			'CI' => 'كوتې دې ئىۋوئىر',
 			'CI@alt=variant' => 'پىل چىشى قىرغىقى',
 			'CK' => 'كۇك ئاراللىرى',
 			'CL' => 'چىلى',
 			'CM' => 'كامېرون',
 			'CN' => 'جۇڭگو',
 			'CO' => 'كولومبىيە',
 			'CP' => 'كىلىپپېرتون ئاراللىرى',
 			'CR' => 'كوستارىكا',
 			'CU' => 'كۇبا',
 			'CV' => 'يېشىل تۇمشۇق',
 			'CW' => 'كۇراچاۋ',
 			'CX' => 'مىلاد ئارىلى',
 			'CY' => 'سىپرۇس',
 			'CZ' => 'چېخ جۇمھۇرىيىتى',
 			'DE' => 'گېرمانىيە',
 			'DG' => 'دېگو-گارشىيا',
 			'DJ' => 'جىبۇتى',
 			'DK' => 'دانىيە',
 			'DM' => 'دومىنىكا',
 			'DO' => 'دومىنىكا جۇمھۇرىيىتى',
 			'DZ' => 'ئالجىرىيە',
 			'EA' => 'سېيتا ۋە مېلىلا',
 			'EC' => 'ئېكۋاتور',
 			'EE' => 'ئېستونىيە',
 			'EG' => 'مىسىر',
 			'EH' => 'غەربىي ساخارا',
 			'ER' => 'ئېرىترىيە',
 			'ES' => 'ئىسپانىيە',
 			'ET' => 'ئېفىيوپىيە',
 			'EU' => 'ياۋروپا ئىتتىپاقى',
 			'FI' => 'فىنلاندىيە',
 			'FJ' => 'فىجى',
 			'FK' => 'فالكلاند ئاراللىرى',
 			'FK@alt=variant' => 'فالكلاند ئاراللىرى (ئىسلاس مالۋىناس)',
 			'FM' => 'مىكرونېزىيە',
 			'FO' => 'فارو ئاراللىرى',
 			'FR' => 'فىرانسىيە',
 			'GA' => 'گابون',
 			'GB' => 'بىرلەشمە پادىشاھلىق',
 			'GB@alt=short' => 'ئەنگلىيە',
 			'GD' => 'گىرېنادا',
 			'GE' => 'گىرۇزىيە',
 			'GF' => 'فىرانسىيەگە قاراشلىق گىۋىيانا',
 			'GG' => 'گۇرنسېي',
 			'GH' => 'گانا',
 			'GI' => 'جەبىلتارىق',
 			'GL' => 'گىرېنلاندىيە',
 			'GM' => 'گامبىيە',
 			'GN' => 'گىۋىنىيە',
 			'GP' => 'گىۋادېلۇپ',
 			'GQ' => 'ئېكۋاتور گىۋىنىيەسى',
 			'GR' => 'گىرېتسىيە',
 			'GS' => 'جەنۇبىي جورجىيە ۋە جەنۇبىي ساندۋىچ ئاراللىرى',
 			'GT' => 'گىۋاتېمالا',
 			'GU' => 'گۇئام',
 			'GW' => 'گىۋىنىيە بىسسائۇ',
 			'GY' => 'گىۋىيانا',
 			'HK' => 'شياڭگاڭ ئالاھىدە مەمۇرىي رايونى (جۇڭگو)',
 			'HK@alt=short' => 'شياڭگاڭ',
 			'HM' => 'ھېرد ئارىلى ۋە ماكدونالد ئاراللىرى',
 			'HN' => 'ھوندۇراس',
 			'HR' => 'كىرودىيە',
 			'HT' => 'ھايتى',
 			'HU' => 'ۋېنگىرىيە',
 			'IC' => 'كانارى ئاراللىرى',
 			'ID' => 'ھىندونېزىيە',
 			'IE' => 'ئىرېلاندىيە',
 			'IL' => 'ئىسرائىلىيە',
 			'IM' => 'مان ئارىلى',
 			'IN' => 'ھىندىستان',
 			'IO' => 'ئەنگلىيەگە قاراشلىق ھىندى ئوكيان تېررىتورىيەسى',
 			'IQ' => 'ئىراق',
 			'IR' => 'ئىران',
 			'IS' => 'ئىسلاندىيە',
 			'IT' => 'ئىتالىيە',
 			'JE' => 'جېرسېي',
 			'JM' => 'يامايكا',
 			'JO' => 'ئىيوردانىيە',
 			'JP' => 'ياپونىيە',
 			'KE' => 'كېنىيە',
 			'KG' => 'قىرغىزىستان',
 			'KH' => 'كامبودژا',
 			'KI' => 'كىرىباتى',
 			'KM' => 'كومورو',
 			'KN' => 'ساينت كىتىس ۋە نېۋىس',
 			'KP' => 'چاۋشيەن',
 			'KR' => 'كورېيە',
 			'KW' => 'كۇۋەيت',
 			'KY' => 'كايمان ئاراللىرى',
 			'KZ' => 'قازاقىستان',
 			'LA' => 'لائوس',
 			'LB' => 'لىۋان',
 			'LC' => 'ساينت لۇسىيە',
 			'LI' => 'لىكتېنستېين',
 			'LK' => 'سىرىلانكا',
 			'LR' => 'لىبېرىيە',
 			'LS' => 'لېسوتو',
 			'LT' => 'لىتۋانىيە',
 			'LU' => 'لىيۇكسېمبۇرگ',
 			'LV' => 'لاتۋىيە',
 			'LY' => 'لىۋىيە',
 			'MA' => 'ماراكەش',
 			'MC' => 'موناكو',
 			'MD' => 'مولدوۋا',
 			'ME' => 'قارا تاغ',
 			'MF' => 'ساينت مارتىن',
 			'MG' => 'ماداغاسقار',
 			'MH' => 'مارشال ئاراللىرى',
 			'MK' => 'شىمالىي ماكېدونىيە',
 			'ML' => 'مالى',
 			'MM' => 'بىرما',
 			'MN' => 'موڭغۇلىيە',
 			'MO' => 'ئاۋمېن ئالاھىدە مەمۇرىي رايونى',
 			'MO@alt=short' => 'ئاۋمېن',
 			'MP' => 'شىمالىي مارىيانا ئاراللىرى',
 			'MQ' => 'مارتىنىكا',
 			'MR' => 'ماۋرىتانىيە',
 			'MS' => 'مونتسېررات',
 			'MT' => 'مالتا',
 			'MU' => 'ماۋرىتىيۇس',
 			'MV' => 'مالدىۋې',
 			'MW' => 'مالاۋى',
 			'MX' => 'مېكسىكا',
 			'MY' => 'مالايسىيا',
 			'MZ' => 'موزامبىك',
 			'NA' => 'نامىبىيە',
 			'NC' => 'يېڭى كالېدونىيە',
 			'NE' => 'نىگېر',
 			'NF' => 'نورفولك ئارىلى',
 			'NG' => 'نىگېرىيە',
 			'NI' => 'نىكاراگۇئا',
 			'NL' => 'گوللاندىيە',
 			'NO' => 'نورۋېگىيە',
 			'NP' => 'نېپال',
 			'NR' => 'ناۋرۇ',
 			'NU' => 'نيۇئې',
 			'NZ' => 'يېڭى زېلاندىيە',
 			'OM' => 'ئومان',
 			'PA' => 'پاناما',
 			'PE' => 'پېرۇ',
 			'PF' => 'فىرانسىيەگە قاراشلىق پولىنېزىيە',
 			'PG' => 'پاپۇئا يېڭى گىۋىنىيەسى',
 			'PH' => 'فىلىپپىن',
 			'PK' => 'پاكىستان',
 			'PL' => 'پولشا',
 			'PM' => 'ساينت پىيېر ۋە مىكېلون ئاراللىرى',
 			'PN' => 'پىتكايرن ئاراللىرى',
 			'PR' => 'پۇئېرتو رىكو',
 			'PS' => 'پەلەستىن زېمىنى',
 			'PS@alt=short' => 'پەلەستىن',
 			'PT' => 'پورتۇگالىيە',
 			'PW' => 'پالائۇ',
 			'PY' => 'پاراگۋاي',
 			'QA' => 'قاتار',
 			'QO' => 'ئوكيانىيە ئەتراپىدىكى ئاراللار',
 			'RE' => 'رېيۇنىيون',
 			'RO' => 'رومىنىيە',
 			'RS' => 'سېربىيە',
 			'RU' => 'رۇسىيە',
 			'RW' => 'رىۋاندا',
 			'SA' => 'سەئۇدىي ئەرەبىستان',
 			'SB' => 'سولومون ئاراللىرى',
 			'SC' => 'سېيشېل',
 			'SD' => 'سۇدان',
 			'SE' => 'شىۋېتسىيە',
 			'SG' => 'سىنگاپور',
 			'SH' => 'ساينىت ھېلېنا',
 			'SI' => 'سىلوۋېنىيە',
 			'SJ' => 'سىۋالبارد ۋە يان مايېن',
 			'SK' => 'سىلوۋاكىيە',
 			'SL' => 'سېررالېئون',
 			'SM' => 'سان مارىنو',
 			'SN' => 'سېنېگال',
 			'SO' => 'سومالى',
 			'SR' => 'سۇرىنام',
 			'SS' => 'جەنۇبىي سۇدان',
 			'ST' => 'سان تومې ۋە پرىنسىپې',
 			'SV' => 'سالۋادور',
 			'SX' => 'سىنت مارتېن',
 			'SY' => 'سۇرىيە',
 			'SZ' => 'سىۋېزىلاند',
 			'TA' => 'ترىستان داكۇنھا',
 			'TC' => 'تۇركس ۋە كايكوس ئاراللىرى',
 			'TD' => 'چاد',
 			'TF' => 'فىرانسىيەنىڭ جەنۇبىي زېمىنى',
 			'TG' => 'توگو',
 			'TH' => 'تايلاند',
 			'TJ' => 'تاجىكىستان',
 			'TK' => 'توكېلاۋ',
 			'TL' => 'شەرقىي تىمور',
 			'TM' => 'تۈركمەنىستان',
 			'TN' => 'تۇنىس',
 			'TO' => 'تونگا',
 			'TR' => 'تۈركىيە',
 			'TT' => 'تىرىنىداد ۋە توباگو',
 			'TV' => 'تۇۋالۇ',
 			'TW' => 'تەيۋەن',
 			'TZ' => 'تانزانىيە',
 			'UA' => 'ئۇكرائىنا',
 			'UG' => 'ئۇگاندا',
 			'UM' => 'ئا ق ش تاشقى ئاراللىرى',
 			'US' => 'ئامېرىكا قوشما ئىشتاتلىرى',
 			'US@alt=short' => 'ئا ق ش',
 			'UY' => 'ئۇرۇگۋاي',
 			'UZ' => 'ئۆزبېكىستان',
 			'VA' => 'ۋاتىكان',
 			'VC' => 'ساينت ۋىنسېنت ۋە گىرېنادىنېس',
 			'VE' => 'ۋېنېسۇئېلا',
 			'VG' => 'ئەنگلىيە ۋىرگىن ئاراللىرى',
 			'VI' => 'ئا ق ش ۋىرگىن ئاراللىرى',
 			'VN' => 'ۋىيېتنام',
 			'VU' => 'ۋانۇئاتۇ',
 			'WF' => 'ۋاللىس ۋە فۇتۇنا',
 			'WS' => 'ساموئا',
 			'XK' => 'كوسوۋو',
 			'YE' => 'يەمەن',
 			'YT' => 'مايوتى',
 			'ZA' => 'جەنۇبىي ئافرىقا',
 			'ZM' => 'زامبىيە',
 			'ZW' => 'زىمبابۋې',
 			'ZZ' => 'يوچۇن جاي',

		}
	},
);

has 'display_name_variant' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'1901' => 'ئەنئەنىۋى گېرمانچە ئىملا قائىدىسى',
 			'1994' => 'ئۆلچەملەشتۈرۈلگەن رېسىيان ئىملا قائىدىسى',
 			'1996' => 'گېرمانچە ئىملا قائىدىسى 1996',
 			'1606NICT' => 'ئوتتۇرا ئاخىرقى دەۋردىكى فىرانسۇزچە 1606',
 			'1694ACAD' => 'دەسلەپكى مەزگىلدىكى زامانىۋى فىرانسۇزچە',
 			'1959ACAD' => 'ئاكادېمىك',
 			'ALALC97' => 'ALA-LC لاتىنلاشتۇرۇش، 1997 نەشرى',
 			'ALUKU' => 'ئالۇكۇ شىۋەسى',
 			'AREVELA' => 'شەرقىي ئەرمەنچە',
 			'AREVMDA' => 'غەربىي ئەرمەنچە',
 			'BAKU1926' => 'بىرلىككە كەلگەن تۈرك لاتىن ئېلىپبەسى',
 			'BISKE' => 'سان گىيورگىيو/بىلا شىۋەسى',
 			'BOHORIC' => 'بوخورىچ ئېلىپبەسى',
 			'BOONT' => 'بۇنتلىڭچە',
 			'DAJNKO' => 'داژىنكو ئېلىپبەسى',
 			'EMODENG' => 'دەسلەپكى مەزگىلدىكى زامانىۋى ئىنگلىزچە',
 			'FONIPA' => 'IPA تاۋۇشلىرى',
 			'FONUPA' => 'UPA تاۋۇشلىرى',
 			'HEPBURN' => 'خېپبۇرن لاتىنلاشتۇرۇش',
 			'KKCOR' => 'ئورتاق ئىملا قائىدىسى',
 			'KSCOR' => 'ئۆلچەملىك ئىملا قائىدىسى',
 			'LIPAW' => 'رېسىياننىڭ لىپوۋاز شىۋەسى',
 			'METELKO' => 'مېتېلكو ئېلىپبەسى',
 			'MONOTON' => 'ئاددىي',
 			'NDYUKA' => 'نىديۇكا شىۋەسى',
 			'NEDIS' => 'ناتىسون شىۋەسى',
 			'NJIVA' => 'گىنىۋا/نىجىۋا شىۋەسى',
 			'NULIK' => 'زامانىۋى ۋولاپۇكچە',
 			'OSOJS' => 'ئوسېئاككو/ئوسوجەن شىۋەسى',
 			'PAMAKA' => 'پاماكا شىۋەسى',
 			'PINYIN' => 'پىنيىن لاتىنلاشتۇرۇش',
 			'POLYTON' => 'پولىتونىك',
 			'POSIX' => 'كومپيۇتېر',
 			'REVISED' => 'تۈزىتىلگەن ئىملا قائىدىسى',
 			'RIGIK' => 'ئەنئەنىۋى ۋولاپۇكچە',
 			'ROZAJ' => 'رېسىيان',
 			'SAAHO' => 'ساخوچە',
 			'SCOTLAND' => 'شوتلاندىيە ئۆلچەملىك ئىنگلىزچە',
 			'SCOUSE' => 'سىكاۋۇز',
 			'SOLBA' => 'سىتولۋىززا/سولبىكا شىۋەسى',
 			'TARASK' => 'تاراسكىۋىتسا ئىملا قائىدىسى',
 			'UCCOR' => 'بىرلىككە كەلگەن ئىملا قائىدىسى',
 			'UCRCOR' => 'بىرلىككە كەلگەن تۈزىتىلگەن ئىملا قائىدىسى',
 			'VALENCIA' => 'ۋالېنسىيە',
 			'WADEGILE' => 'ۋېي ئائىلىسى پىنيىن لاتىنلاشتۇرۇش',

		}
	},
);

has 'display_name_key' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'calendar' => 'يىلنامە',
 			'collation' => 'تەرتىپلەش تەرتىپى',
 			'currency' => 'پۇل',
 			'numbers' => 'سان',

		}
	},
);

has 'display_name_type' => (
	is			=> 'ro',
	isa			=> HashRef[HashRef[Str]],
	init_arg	=> undef,
	default		=> sub {
		{
			'calendar' => {
 				'buddhist' => q{بۇددا يىلنامەسى},
 				'chinese' => q{دېھقانلار يىلنامەسى},
 				'coptic' => q{كوپتىك يىلنامەسى},
 				'dangi' => q{دانگى يىلنامەسى},
 				'ethiopic' => q{ئېفىيوپىيە يىلنامەسى},
 				'ethiopic-amete-alem' => q{ئېفىيوپىيە ئامېتې ئالېم يىلنامەسى},
 				'gregorian' => q{مىلادىيە يىلنامەسى},
 				'hebrew' => q{يەھۇدى يىلنامەسى},
 				'indian' => q{ھىندىستان دۆلەت يىلنامەسى},
 				'islamic' => q{ئىسلام ھىجرىيە يىلنامەسى},
 				'islamic-civil' => q{ئىسلام ھىجرىيە يىلنامەسى (مەدىنە)},
 				'islamic-rgsa' => q{ئىسلام ھىجرىيە يىلنامەسى (سەئۇدى ئەرەبىستان ئاي)},
 				'islamic-tbla' => q{ئىسلام ھىجرىيە يىلنامەسى (ئاسترونومىيە دەۋرى)},
 				'islamic-umalqura' => q{ئىسلام ھىجرىيە يىلنامەسى (ئۇم ئەلقۇرا)},
 				'iso8601' => q{ISO-8601 يىلنامەسى},
 				'japanese' => q{ياپونىيە يىلنامەسى},
 				'persian' => q{پارىس يىلنامەسى},
 				'roc' => q{مىنگو يىلنامەسى},
 			},
 			'collation' => {
 				'big5han' => q{مۇرەككەپ خەنچە تىزىش تەرتىپى - Big5},
 				'dictionary' => q{لۇغەت تىزىش تەرتىپى},
 				'ducet' => q{كۆڭۈلدىكى يۇنىكود تىزىش تەرتىپى},
 				'eor' => q{ياۋروپا تەرتىپلەش قائىدىسى},
 				'gb2312han' => q{ئاددىي خەنچە تىزىش تەرتىپى - GB2312},
 				'phonebook' => q{تېلېفون نومۇر تىزىش تەرتىپى},
 				'pinyin' => q{پىنيىن تىزىش تەرتىپى},
 				'reformed' => q{ياخشىلانغان تەرتىپلەش تەرتىپى},
 				'search' => q{ئادەتتىكى ئىزدەش},
 				'searchjl' => q{كورىيەچە ئۈزۈك تاۋۇش بويىچە ئىزدەش},
 				'standard' => q{ئۆلچەملىك تەرتىپلەش تەرتىپى},
 				'stroke' => q{سىزىق بويىچە تەرتىپلەش},
 				'traditional' => q{ئەنئەنىۋى تەرتىپلەش تەرتىپى},
 				'unihan' => q{يان بۆلەك سىزىق بويچە تەرتىپلەش تەرتىپى},
 				'zhuyin' => q{ترانسكرىپسىيە تەرتىپلەش تەرتىپى},
 			},
 			'numbers' => {
 				'arab' => q{ئەرەبچە-ھىندىچە رەقەملەر},
 				'arabext' => q{كېڭەيتىلگەن ئەرەبچە-ھىندىچە رەقەملەر},
 				'armn' => q{ئەرمەنچە رەقەملەر},
 				'armnlow' => q{ئەرەبچە رەقەملەر (كىچىك ھەرپ)},
 				'bali' => q{بالىچە رەقەملەر},
 				'beng' => q{بېنگالچە رەقەملەر},
 				'brah' => q{بىراخمىچە رەقەملەر},
 				'cakm' => q{چاكماچە رەقەملەر},
 				'cham' => q{چامچە رەقەملەر},
 				'deva' => q{دېۋاناگارىچە رەقەملەر},
 				'ethi' => q{ئېفىيوپىيەچە رەقەملەر},
 				'fullwide' => q{تولۇق كەڭلىكتىكى رەقەملەر},
 				'geor' => q{گىرۇزىنچە رەقەملەر},
 				'grek' => q{گىرېكچە رەقەملەر},
 				'greklow' => q{گىرېكچە رەقەملەر (كىچىك ھەرپ)},
 				'gujr' => q{گۇجاراتچە رەقەملەر},
 				'guru' => q{گۇرمۇكىچە رەقەملەر},
 				'hanidec' => q{خەنچە ئونلۇق رەقەملەر},
 				'hans' => q{ئاددىي خەنچە رەقەملەر},
 				'hansfin' => q{ئاددىي خەنچە پۇل-مۇئامىلە رەقەملەر},
 				'hant' => q{مۇرەككەپ خەنچە رەقەملەر},
 				'hantfin' => q{مۇرەككەپ خەنچە پۇل-مۇئامىلە رەقەملەر},
 				'hebr' => q{ئىبرانىچە رەقەملەر},
 				'java' => q{ياۋاچە رەقەملەر},
 				'jpan' => q{ياپونچە رەقەملەر},
 				'jpanfin' => q{ياپونچە پۇل-مۇئامىلە رەقەملەر},
 				'kali' => q{كاياھچە رەقەملەر},
 				'khmr' => q{كېخمېرچە رەقەملەر},
 				'knda' => q{كانناداچە رەقەملەر},
 				'lana' => q{تاي تامچە خورا رەقەملەر},
 				'lanatham' => q{تاي تامچە تام رەقەملەر},
 				'laoo' => q{لائوسچە رەقەملەر},
 				'latn' => q{غەربچە رەقەملەر},
 				'lepc' => q{لەپچاچە رەقەملەر},
 				'limb' => q{لىمبۇچە رەقەملەر},
 				'mlym' => q{مالايالامچە رەقەملەر},
 				'mong' => q{موڭغۇلچە رەقەملەر},
 				'mtei' => q{مانىپۇرىچە رەقەملەر},
 				'mymr' => q{بېرماچە رەقەملەر},
 				'mymrshan' => q{بېرما شانچە رەقەملەر},
 				'nkoo' => q{نىكوچە رەقەملەر},
 				'olck' => q{ئول-چىكىچە رەقەملەر},
 				'orya' => q{ئورىياچە رەقەملەر},
 				'osma' => q{ئوسمانىيە رەقەملەر},
 				'roman' => q{رىم رەقەملەر},
 				'romanlow' => q{رىم رەقەملەر (كىچىك ھەرپ)},
 				'saur' => q{سائۇراشتىراچە رەقەملەر},
 				'shrd' => q{شاراداچە رەقەملەر},
 				'sora' => q{سورا سومپېڭ رەقەملەر},
 				'sund' => q{سۇنداچە رەقەملەر},
 				'takr' => q{تاكرىچە رەقەملەر},
 				'talu' => q{يېڭى تاي-لەچە رەقەملەر},
 				'taml' => q{ئەنئەنىۋى تامىلچە رەقەملەر},
 				'tamldec' => q{تامىلچە رەقەملەر},
 				'telu' => q{تېلۇگۇچە رەقەملەر},
 				'thai' => q{تايلاندچە رەقەملەر},
 				'tibt' => q{تىبەتچە رەقەملەر},
 				'vaii' => q{ۋايچە رەقەملەر},
 			},

		}
	},
);

has 'display_name_measurement_system' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'metric' => q{مېتىر},
 			'UK' => q{ئەنگلىيە ئۆلچىمى},
 			'US' => q{ئامېرىكا ئۆلچىمى},

		}
	},
);

has 'display_name_code_patterns' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'language' => 'تىل: {0}',
 			'script' => 'يېزىق: {0}',
 			'region' => 'رايون: {0}',

		}
	},
);

has 'text_orientation' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub { return {
			lines => '',
			characters => 'right-to-left',
		}}
);

has 'characters' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> $^V ge v5.18.0
	? eval <<'EOT'
	sub {
		no warnings 'experimental::regex_sets';
		return {
			auxiliary => qr{[‎‏ ئ]},
			index => ['{ئا}', '{ئه}', '{ئو}', '{ئۇ}', '{ئۆ}', '{ئۈ}', '{ئې}', '{ئى}', 'ا', 'ە', 'ب', 'پ', 'ت', 'ج', 'چ', 'خ', 'د', 'ر', 'ز', 'ژ', 'س', 'ش', 'غ', 'ف', 'ق', 'ك', 'گ', 'ڭ', 'ل', 'م', 'ن', 'ھ', 'و', 'ۇ', 'ۆ', 'ۈ', 'ۋ', 'ې', 'ى', 'ي'],
			main => qr{[{ئا} {ئه} {ئو} {ئۇ} {ئۆ} {ئۈ} {ئې} {ئى} ا ە ب پ ت ج چ خ د ر ز ژ س ش غ ف ق ك گ ڭ ل م ن ھ و ۇ ۆ ۈ ۋ ې ى ي]},
		};
	},
EOT
: sub {
		return { index => ['{ئا}', '{ئه}', '{ئو}', '{ئۇ}', '{ئۆ}', '{ئۈ}', '{ئې}', '{ئى}', 'ا', 'ە', 'ب', 'پ', 'ت', 'ج', 'چ', 'خ', 'د', 'ر', 'ز', 'ژ', 'س', 'ش', 'غ', 'ف', 'ق', 'ك', 'گ', 'ڭ', 'ل', 'م', 'ن', 'ھ', 'و', 'ۇ', 'ۆ', 'ۈ', 'ۋ', 'ې', 'ى', 'ي'], };
},
);


has 'quote_start' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{»},
);

has 'quote_end' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{«},
);

has 'alternate_quote_start' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{›},
);

has 'alternate_quote_end' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{‹},
);

has 'units' => (
	is			=> 'ro',
	isa			=> HashRef[HashRef[HashRef[Str]]],
	init_arg	=> undef,
	default		=> sub { {
				'long' => {
					# Long Unit Identifier
					'acceleration-g-force' => {
						'one' => q({0} ئېغىرلىق كۈچى),
						'other' => q({0} ئېغىرلىق كۈچى),
					},
					# Core Unit Identifier
					'g-force' => {
						'one' => q({0} ئېغىرلىق كۈچى),
						'other' => q({0} ئېغىرلىق كۈچى),
					},
					# Long Unit Identifier
					'area-hectare' => {
						'one' => q({0} گېكتار),
						'other' => q({0} hectares),
					},
					# Core Unit Identifier
					'hectare' => {
						'one' => q({0} گېكتار),
						'other' => q({0} hectares),
					},
					# Long Unit Identifier
					'area-square-kilometer' => {
						'one' => q({0} كۋادرات كىلومېتىر),
						'other' => q({0} كۋادرات كىلومېتىر),
					},
					# Core Unit Identifier
					'square-kilometer' => {
						'one' => q({0} كۋادرات كىلومېتىر),
						'other' => q({0} كۋادرات كىلومېتىر),
					},
					# Long Unit Identifier
					'area-square-meter' => {
						'one' => q({0} كۋادرات مېتىر),
						'other' => q({0} كۋادرات مېتىر),
					},
					# Core Unit Identifier
					'square-meter' => {
						'one' => q({0} كۋادرات مېتىر),
						'other' => q({0} كۋادرات مېتىر),
					},
					# Long Unit Identifier
					'duration-millisecond' => {
						'one' => q({0} مىللى سېكۇنت),
						'other' => q({0} مىللى سېكۇنت),
					},
					# Core Unit Identifier
					'millisecond' => {
						'one' => q({0} مىللى سېكۇنت),
						'other' => q({0} مىللى سېكۇنت),
					},
					# Long Unit Identifier
					'length-foot' => {
						'one' => q({0} فۇت),
						'other' => q({0} فۇت),
					},
					# Core Unit Identifier
					'foot' => {
						'one' => q({0} فۇت),
						'other' => q({0} فۇت),
					},
					# Long Unit Identifier
					'length-inch' => {
						'one' => q({0} ديۇيم),
						'other' => q({0} ديۇيم),
					},
					# Core Unit Identifier
					'inch' => {
						'one' => q({0} ديۇيم),
						'other' => q({0} ديۇيم),
					},
					# Long Unit Identifier
					'mass-gram' => {
						'one' => q({0} گرام),
						'other' => q({0} گرام),
					},
					# Core Unit Identifier
					'gram' => {
						'one' => q({0} گرام),
						'other' => q({0} گرام),
					},
					# Long Unit Identifier
					'mass-kilogram' => {
						'one' => q({0} كىلوگرام),
						'other' => q({0} كىلوگرام),
					},
					# Core Unit Identifier
					'kilogram' => {
						'one' => q({0} كىلوگرام),
						'other' => q({0} كىلوگرام),
					},
					# Long Unit Identifier
					'power-kilowatt' => {
						'one' => q({0} كىلوۋات),
						'other' => q({0} كىلوۋات),
					},
					# Core Unit Identifier
					'kilowatt' => {
						'one' => q({0} كىلوۋات),
						'other' => q({0} كىلوۋات),
					},
					# Long Unit Identifier
					'power-watt' => {
						'one' => q({0} ۋات),
						'other' => q({0} ۋات),
					},
					# Core Unit Identifier
					'watt' => {
						'one' => q({0} ۋات),
						'other' => q({0} ۋات),
					},
					# Long Unit Identifier
					'pressure-hectopascal' => {
						'one' => q({0} يۈز پاسكال),
						'other' => q({0} يۈز پاسكال),
					},
					# Core Unit Identifier
					'hectopascal' => {
						'one' => q({0} يۈز پاسكال),
						'other' => q({0} يۈز پاسكال),
					},
					# Long Unit Identifier
					'pressure-inch-ofhg' => {
						'one' => q({0} ديۇيم سىماب تۈۋرۇكى),
						'other' => q({0} ديۇيم سىماب تۈۋرۇكى),
					},
					# Core Unit Identifier
					'inch-ofhg' => {
						'one' => q({0} ديۇيم سىماب تۈۋرۇكى),
						'other' => q({0} ديۇيم سىماب تۈۋرۇكى),
					},
					# Long Unit Identifier
					'pressure-millibar' => {
						'one' => q({0} مىللىبار),
						'other' => q({0} مىللىبار),
					},
					# Core Unit Identifier
					'millibar' => {
						'one' => q({0} مىللىبار),
						'other' => q({0} مىللىبار),
					},
					# Long Unit Identifier
					'speed-kilometer-per-hour' => {
						'one' => q({0} كىلومېتىر ھەر سائەت),
						'other' => q({0} كىلومېتىر ھەر سائەت),
					},
					# Core Unit Identifier
					'kilometer-per-hour' => {
						'one' => q({0} كىلومېتىر ھەر سائەت),
						'other' => q({0} كىلومېتىر ھەر سائەت),
					},
					# Long Unit Identifier
					'speed-meter-per-second' => {
						'one' => q({0} مېتىر ھەر سېكۇنت),
						'other' => q({0} مېتىر ھەر سېكۇنت),
					},
					# Core Unit Identifier
					'meter-per-second' => {
						'one' => q({0} مېتىر ھەر سېكۇنت),
						'other' => q({0} مېتىر ھەر سېكۇنت),
					},
					# Long Unit Identifier
					'speed-mile-per-hour' => {
						'one' => q({0} مىل ھەر سائەت),
						'other' => q({0} مىل ھەر سائەت),
					},
					# Core Unit Identifier
					'mile-per-hour' => {
						'one' => q({0} مىل ھەر سائەت),
						'other' => q({0} مىل ھەر سائەت),
					},
					# Long Unit Identifier
					'temperature-celsius' => {
						'one' => q({0} سېلسىيە گرادۇس),
						'other' => q({0} سېلسىيە گرادۇس),
					},
					# Core Unit Identifier
					'celsius' => {
						'one' => q({0} سېلسىيە گرادۇس),
						'other' => q({0} سېلسىيە گرادۇس),
					},
					# Long Unit Identifier
					'temperature-fahrenheit' => {
						'one' => q({0} فارېنگېيت گرادۇس),
						'other' => q({0} فارېنگېيت گرادۇس),
					},
					# Core Unit Identifier
					'fahrenheit' => {
						'one' => q({0} فارېنگېيت گرادۇس),
						'other' => q({0} فارېنگېيت گرادۇس),
					},
					# Long Unit Identifier
					'volume-cubic-kilometer' => {
						'one' => q({0} كۇب كىلومېتىر),
						'other' => q({0} كۇب كىلومېتىر),
					},
					# Core Unit Identifier
					'cubic-kilometer' => {
						'one' => q({0} كۇب كىلومېتىر),
						'other' => q({0} كۇب كىلومېتىر),
					},
					# Long Unit Identifier
					'volume-cubic-mile' => {
						'one' => q({0} كۇب مىل),
						'other' => q({0} كۇب مىل),
					},
					# Core Unit Identifier
					'cubic-mile' => {
						'one' => q({0} كۇب مىل),
						'other' => q({0} كۇب مىل),
					},
					# Long Unit Identifier
					'volume-liter' => {
						'one' => q({0} لىتېر),
						'other' => q({0} لىتېر),
					},
					# Core Unit Identifier
					'liter' => {
						'one' => q({0} لىتېر),
						'other' => q({0} لىتېر),
					},
				},
				'narrow' => {
					# Long Unit Identifier
					'acceleration-g-force' => {
						'one' => q({0}G),
						'other' => q({0}Gs),
					},
					# Core Unit Identifier
					'g-force' => {
						'one' => q({0}G),
						'other' => q({0}Gs),
					},
					# Long Unit Identifier
					'angle-degree' => {
						'one' => q({0}°),
						'other' => q({0}°),
					},
					# Core Unit Identifier
					'degree' => {
						'one' => q({0}°),
						'other' => q({0}°),
					},
					# Long Unit Identifier
					'area-acre' => {
						'one' => q({0}ac),
						'other' => q({0}ac),
					},
					# Core Unit Identifier
					'acre' => {
						'one' => q({0}ac),
						'other' => q({0}ac),
					},
					# Long Unit Identifier
					'area-hectare' => {
						'one' => q({0}گېكتار),
						'other' => q({0}گېكتار),
					},
					# Core Unit Identifier
					'hectare' => {
						'one' => q({0}گېكتار),
						'other' => q({0}گېكتار),
					},
					# Long Unit Identifier
					'area-square-foot' => {
						'one' => q({0}ft²),
						'other' => q({0}ft²),
					},
					# Core Unit Identifier
					'square-foot' => {
						'one' => q({0}ft²),
						'other' => q({0}ft²),
					},
					# Long Unit Identifier
					'area-square-mile' => {
						'one' => q({0}mi²),
						'other' => q({0}mi²),
					},
					# Core Unit Identifier
					'square-mile' => {
						'one' => q({0}mi²),
						'other' => q({0}mi²),
					},
					# Long Unit Identifier
					'duration-hour' => {
						'one' => q({0}h),
						'other' => q({0}h),
					},
					# Core Unit Identifier
					'hour' => {
						'one' => q({0}h),
						'other' => q({0}h),
					},
					# Long Unit Identifier
					'duration-millisecond' => {
						'one' => q({0}ms),
						'other' => q({0}ms),
					},
					# Core Unit Identifier
					'millisecond' => {
						'one' => q({0}ms),
						'other' => q({0}ms),
					},
					# Long Unit Identifier
					'duration-minute' => {
						'one' => q({0}m),
						'other' => q({0}m),
					},
					# Core Unit Identifier
					'minute' => {
						'one' => q({0}m),
						'other' => q({0}m),
					},
					# Long Unit Identifier
					'duration-second' => {
						'one' => q({0}s),
						'other' => q({0}s),
					},
					# Core Unit Identifier
					'second' => {
						'one' => q({0}s),
						'other' => q({0}s),
					},
					# Long Unit Identifier
					'length-centimeter' => {
						'one' => q({0}cm),
						'other' => q({0}cm),
					},
					# Core Unit Identifier
					'centimeter' => {
						'one' => q({0}cm),
						'other' => q({0}cm),
					},
					# Long Unit Identifier
					'length-foot' => {
						'one' => q({0}′),
						'other' => q({0}′),
					},
					# Core Unit Identifier
					'foot' => {
						'one' => q({0}′),
						'other' => q({0}′),
					},
					# Long Unit Identifier
					'length-inch' => {
						'one' => q({0}″),
						'other' => q({0}″),
					},
					# Core Unit Identifier
					'inch' => {
						'one' => q({0}″),
						'other' => q({0}″),
					},
					# Long Unit Identifier
					'length-kilometer' => {
						'one' => q({0}km),
						'other' => q({0}km),
					},
					# Core Unit Identifier
					'kilometer' => {
						'one' => q({0}km),
						'other' => q({0}km),
					},
					# Long Unit Identifier
					'length-light-year' => {
						'one' => q({0}ly),
						'other' => q({0}ly),
					},
					# Core Unit Identifier
					'light-year' => {
						'one' => q({0}ly),
						'other' => q({0}ly),
					},
					# Long Unit Identifier
					'length-meter' => {
						'one' => q({0}m),
						'other' => q({0}m),
					},
					# Core Unit Identifier
					'meter' => {
						'one' => q({0}m),
						'other' => q({0}m),
					},
					# Long Unit Identifier
					'length-mile' => {
						'one' => q({0}mi),
						'other' => q({0}mi),
					},
					# Core Unit Identifier
					'mile' => {
						'one' => q({0}mi),
						'other' => q({0}mi),
					},
					# Long Unit Identifier
					'length-millimeter' => {
						'one' => q({0}mm),
						'other' => q({0}mm),
					},
					# Core Unit Identifier
					'millimeter' => {
						'one' => q({0}mm),
						'other' => q({0}mm),
					},
					# Long Unit Identifier
					'length-picometer' => {
						'one' => q({0}pm),
						'other' => q({0}pm),
					},
					# Core Unit Identifier
					'picometer' => {
						'one' => q({0}pm),
						'other' => q({0}pm),
					},
					# Long Unit Identifier
					'length-yard' => {
						'one' => q({0}yd),
						'other' => q({0}yd),
					},
					# Core Unit Identifier
					'yard' => {
						'one' => q({0}yd),
						'other' => q({0}yd),
					},
					# Long Unit Identifier
					'mass-gram' => {
						'one' => q({0}g),
						'other' => q({0}g),
					},
					# Core Unit Identifier
					'gram' => {
						'one' => q({0}g),
						'other' => q({0}g),
					},
					# Long Unit Identifier
					'mass-kilogram' => {
						'one' => q({0}kg),
						'other' => q({0}kg),
					},
					# Core Unit Identifier
					'kilogram' => {
						'one' => q({0}kg),
						'other' => q({0}kg),
					},
					# Long Unit Identifier
					'mass-ounce' => {
						'one' => q({0}oz),
						'other' => q({0}oz),
					},
					# Core Unit Identifier
					'ounce' => {
						'one' => q({0}oz),
						'other' => q({0}oz),
					},
					# Long Unit Identifier
					'mass-pound' => {
						'one' => q({0}#),
						'other' => q({0}#),
					},
					# Core Unit Identifier
					'pound' => {
						'one' => q({0}#),
						'other' => q({0}#),
					},
					# Long Unit Identifier
					'power-horsepower' => {
						'one' => q({0}hp),
						'other' => q({0}hp),
					},
					# Core Unit Identifier
					'horsepower' => {
						'one' => q({0}hp),
						'other' => q({0}hp),
					},
					# Long Unit Identifier
					'power-kilowatt' => {
						'one' => q({0}kW),
						'other' => q({0}kW),
					},
					# Core Unit Identifier
					'kilowatt' => {
						'one' => q({0}kW),
						'other' => q({0}kW),
					},
					# Long Unit Identifier
					'power-watt' => {
						'one' => q({0}W),
						'other' => q({0}W),
					},
					# Core Unit Identifier
					'watt' => {
						'one' => q({0}W),
						'other' => q({0}W),
					},
					# Long Unit Identifier
					'pressure-hectopascal' => {
						'one' => q({0}hPa),
						'other' => q({0}hPa),
					},
					# Core Unit Identifier
					'hectopascal' => {
						'one' => q({0}hPa),
						'other' => q({0}hPa),
					},
					# Long Unit Identifier
					'pressure-inch-ofhg' => {
						'one' => q({0}" Hg),
						'other' => q({0}" Hg),
					},
					# Core Unit Identifier
					'inch-ofhg' => {
						'one' => q({0}" Hg),
						'other' => q({0}" Hg),
					},
					# Long Unit Identifier
					'pressure-millibar' => {
						'one' => q({0}mb),
						'other' => q({0}mb),
					},
					# Core Unit Identifier
					'millibar' => {
						'one' => q({0}mb),
						'other' => q({0}mb),
					},
					# Long Unit Identifier
					'speed-kilometer-per-hour' => {
						'one' => q({0}kph),
						'other' => q({0}kph),
					},
					# Core Unit Identifier
					'kilometer-per-hour' => {
						'one' => q({0}kph),
						'other' => q({0}kph),
					},
					# Long Unit Identifier
					'speed-meter-per-second' => {
						'one' => q({0}m/s),
						'other' => q({0}m/s),
					},
					# Core Unit Identifier
					'meter-per-second' => {
						'one' => q({0}m/s),
						'other' => q({0}m/s),
					},
					# Long Unit Identifier
					'speed-mile-per-hour' => {
						'one' => q({0}mph),
						'other' => q({0}mph),
					},
					# Core Unit Identifier
					'mile-per-hour' => {
						'one' => q({0}mph),
						'other' => q({0}mph),
					},
					# Long Unit Identifier
					'temperature-celsius' => {
						'one' => q({0}°),
						'other' => q({0}°),
					},
					# Core Unit Identifier
					'celsius' => {
						'one' => q({0}°),
						'other' => q({0}°),
					},
					# Long Unit Identifier
					'volume-cubic-kilometer' => {
						'one' => q({0}km³),
						'other' => q({0}km³),
					},
					# Core Unit Identifier
					'cubic-kilometer' => {
						'one' => q({0}km³),
						'other' => q({0}km³),
					},
					# Long Unit Identifier
					'volume-cubic-mile' => {
						'one' => q({0}mi³),
						'other' => q({0}mi³),
					},
					# Core Unit Identifier
					'cubic-mile' => {
						'one' => q({0}mi³),
						'other' => q({0}mi³),
					},
					# Long Unit Identifier
					'volume-liter' => {
						'one' => q({0}l),
						'other' => q({0}l),
					},
					# Core Unit Identifier
					'liter' => {
						'one' => q({0}l),
						'other' => q({0}l),
					},
				},
				'short' => {
					# Long Unit Identifier
					'acceleration-g-force' => {
						'name' => q(ئېغىرلىق كۈچى),
					},
					# Core Unit Identifier
					'g-force' => {
						'name' => q(ئېغىرلىق كۈچى),
					},
					# Long Unit Identifier
					'angle-degree' => {
						'name' => q(گىرادۇس),
						'one' => q({0} گىرادۇس),
						'other' => q({0} گىرادۇس),
					},
					# Core Unit Identifier
					'degree' => {
						'name' => q(گىرادۇس),
						'one' => q({0} گىرادۇس),
						'other' => q({0} گىرادۇس),
					},
					# Long Unit Identifier
					'area-acre' => {
						'name' => q(ئىنگلىز موسى),
						'one' => q({0} ئىنگلىز موسى),
						'other' => q({0} ئىنگلىز موسى),
					},
					# Core Unit Identifier
					'acre' => {
						'name' => q(ئىنگلىز موسى),
						'one' => q({0} ئىنگلىز موسى),
						'other' => q({0} ئىنگلىز موسى),
					},
					# Long Unit Identifier
					'area-hectare' => {
						'name' => q(hectares),
						'one' => q({0} گېكتار),
						'other' => q({0} گېكتار),
					},
					# Core Unit Identifier
					'hectare' => {
						'name' => q(hectares),
						'one' => q({0} گېكتار),
						'other' => q({0} گېكتار),
					},
					# Long Unit Identifier
					'area-square-foot' => {
						'name' => q(كۋادرات فۇت),
						'one' => q({0} كۋادرات فۇت),
						'other' => q({0} كۋادرات فۇت),
					},
					# Core Unit Identifier
					'square-foot' => {
						'name' => q(كۋادرات فۇت),
						'one' => q({0} كۋادرات فۇت),
						'other' => q({0} كۋادرات فۇت),
					},
					# Long Unit Identifier
					'area-square-kilometer' => {
						'name' => q(كۋادرات كىلومېتىر),
					},
					# Core Unit Identifier
					'square-kilometer' => {
						'name' => q(كۋادرات كىلومېتىر),
					},
					# Long Unit Identifier
					'area-square-meter' => {
						'name' => q(كۋادرات مېتىر),
					},
					# Core Unit Identifier
					'square-meter' => {
						'name' => q(كۋادرات مېتىر),
					},
					# Long Unit Identifier
					'area-square-mile' => {
						'name' => q(كۋادرات مىل),
						'one' => q({0} كۋادرات مىل),
						'other' => q({0} كۋادرات مىل),
					},
					# Core Unit Identifier
					'square-mile' => {
						'name' => q(كۋادرات مىل),
						'one' => q({0} كۋادرات مىل),
						'other' => q({0} كۋادرات مىل),
					},
					# Long Unit Identifier
					'duration-day' => {
						'name' => q(كۈن),
						'one' => q({0} كۈن),
						'other' => q({0} كۈن),
					},
					# Core Unit Identifier
					'day' => {
						'name' => q(كۈن),
						'one' => q({0} كۈن),
						'other' => q({0} كۈن),
					},
					# Long Unit Identifier
					'duration-hour' => {
						'name' => q(سائەت),
						'one' => q({0} سائەت),
						'other' => q({0} سائەت),
					},
					# Core Unit Identifier
					'hour' => {
						'name' => q(سائەت),
						'one' => q({0} سائەت),
						'other' => q({0} سائەت),
					},
					# Long Unit Identifier
					'duration-millisecond' => {
						'name' => q(مىللى سېكۇنت),
						'one' => q({0} مىللىسېكۇنت),
						'other' => q({0} مىللىسېكۇنت),
					},
					# Core Unit Identifier
					'millisecond' => {
						'name' => q(مىللى سېكۇنت),
						'one' => q({0} مىللىسېكۇنت),
						'other' => q({0} مىللىسېكۇنت),
					},
					# Long Unit Identifier
					'duration-minute' => {
						'name' => q(مىنۇت),
						'one' => q({0} مىنۇت),
						'other' => q({0} مىنۇت),
					},
					# Core Unit Identifier
					'minute' => {
						'name' => q(مىنۇت),
						'one' => q({0} مىنۇت),
						'other' => q({0} مىنۇت),
					},
					# Long Unit Identifier
					'duration-month' => {
						'name' => q(ئاي),
						'one' => q({0} ئاي),
						'other' => q({0} ئاي),
					},
					# Core Unit Identifier
					'month' => {
						'name' => q(ئاي),
						'one' => q({0} ئاي),
						'other' => q({0} ئاي),
					},
					# Long Unit Identifier
					'duration-second' => {
						'name' => q(سېكۇنت),
						'one' => q({0} سېكۇنت),
						'other' => q({0} سېكۇنت),
					},
					# Core Unit Identifier
					'second' => {
						'name' => q(سېكۇنت),
						'one' => q({0} سېكۇنت),
						'other' => q({0} سېكۇنت),
					},
					# Long Unit Identifier
					'duration-week' => {
						'name' => q(ھەپتە),
						'one' => q({0} ھەپتە),
						'other' => q({0} ھەپتە),
					},
					# Core Unit Identifier
					'week' => {
						'name' => q(ھەپتە),
						'one' => q({0} ھەپتە),
						'other' => q({0} ھەپتە),
					},
					# Long Unit Identifier
					'duration-year' => {
						'name' => q(يىل),
						'one' => q({0} يىل),
						'other' => q({0} يىل),
					},
					# Core Unit Identifier
					'year' => {
						'name' => q(يىل),
						'one' => q({0} يىل),
						'other' => q({0} يىل),
					},
					# Long Unit Identifier
					'length-centimeter' => {
						'name' => q(سانتىمېتىر),
						'one' => q({0} سانتىمېتىر),
						'other' => q({0} سانتىمېتىر),
					},
					# Core Unit Identifier
					'centimeter' => {
						'name' => q(سانتىمېتىر),
						'one' => q({0} سانتىمېتىر),
						'other' => q({0} سانتىمېتىر),
					},
					# Long Unit Identifier
					'length-foot' => {
						'name' => q(فۇت),
						'one' => q({0} پۇت),
						'other' => q({0} پۇت),
					},
					# Core Unit Identifier
					'foot' => {
						'name' => q(فۇت),
						'one' => q({0} پۇت),
						'other' => q({0} پۇت),
					},
					# Long Unit Identifier
					'length-inch' => {
						'name' => q(ديۇيم),
						'one' => q({0} ئىنگلىز چىسى),
						'other' => q({0} ئىنگلىز چىسى),
					},
					# Core Unit Identifier
					'inch' => {
						'name' => q(ديۇيم),
						'one' => q({0} ئىنگلىز چىسى),
						'other' => q({0} ئىنگلىز چىسى),
					},
					# Long Unit Identifier
					'length-kilometer' => {
						'name' => q(كىلومېتىر),
						'one' => q({0} كىلومېتىر),
						'other' => q({0} كىلومېتىر),
					},
					# Core Unit Identifier
					'kilometer' => {
						'name' => q(كىلومېتىر),
						'one' => q({0} كىلومېتىر),
						'other' => q({0} كىلومېتىر),
					},
					# Long Unit Identifier
					'length-light-year' => {
						'name' => q(يورۇقلۇق يىلى),
						'one' => q({0} يورۇقلۇق يىلى),
						'other' => q({0} يورۇقلۇق يىلى),
					},
					# Core Unit Identifier
					'light-year' => {
						'name' => q(يورۇقلۇق يىلى),
						'one' => q({0} يورۇقلۇق يىلى),
						'other' => q({0} يورۇقلۇق يىلى),
					},
					# Long Unit Identifier
					'length-meter' => {
						'name' => q(مېتىر),
						'one' => q({0} مېتىر),
						'other' => q({0} مېتىر),
					},
					# Core Unit Identifier
					'meter' => {
						'name' => q(مېتىر),
						'one' => q({0} مېتىر),
						'other' => q({0} مېتىر),
					},
					# Long Unit Identifier
					'length-mile' => {
						'name' => q(مىل),
						'one' => q({0} مىل),
						'other' => q({0} مىل),
					},
					# Core Unit Identifier
					'mile' => {
						'name' => q(مىل),
						'one' => q({0} مىل),
						'other' => q({0} مىل),
					},
					# Long Unit Identifier
					'length-millimeter' => {
						'name' => q(مىللىمېتىر),
						'one' => q({0} مىللىمېتىر),
						'other' => q({0} مىللىمېتىر),
					},
					# Core Unit Identifier
					'millimeter' => {
						'name' => q(مىللىمېتىر),
						'one' => q({0} مىللىمېتىر),
						'other' => q({0} مىللىمېتىر),
					},
					# Long Unit Identifier
					'length-picometer' => {
						'name' => q(پىكومېتىر),
						'one' => q({0} پىكومېتىر),
						'other' => q({0} پىكومېتىر),
					},
					# Core Unit Identifier
					'picometer' => {
						'name' => q(پىكومېتىر),
						'one' => q({0} پىكومېتىر),
						'other' => q({0} پىكومېتىر),
					},
					# Long Unit Identifier
					'length-yard' => {
						'name' => q(يارد),
						'one' => q({0} يارد),
						'other' => q({0} يارد),
					},
					# Core Unit Identifier
					'yard' => {
						'name' => q(يارد),
						'one' => q({0} يارد),
						'other' => q({0} يارد),
					},
					# Long Unit Identifier
					'mass-gram' => {
						'name' => q(گرام),
					},
					# Core Unit Identifier
					'gram' => {
						'name' => q(گرام),
					},
					# Long Unit Identifier
					'mass-kilogram' => {
						'name' => q(كىلوگرام),
					},
					# Core Unit Identifier
					'kilogram' => {
						'name' => q(كىلوگرام),
					},
					# Long Unit Identifier
					'mass-ounce' => {
						'name' => q(ئۇنسىيە),
						'one' => q({0} ئۇنسىيە),
						'other' => q({0} ئۇنسىيە),
					},
					# Core Unit Identifier
					'ounce' => {
						'name' => q(ئۇنسىيە),
						'one' => q({0} ئۇنسىيە),
						'other' => q({0} ئۇنسىيە),
					},
					# Long Unit Identifier
					'mass-pound' => {
						'name' => q(قاداق),
						'one' => q({0} قاداق),
						'other' => q({0} قاداق),
					},
					# Core Unit Identifier
					'pound' => {
						'name' => q(قاداق),
						'one' => q({0} قاداق),
						'other' => q({0} قاداق),
					},
					# Long Unit Identifier
					'power-horsepower' => {
						'name' => q(ئات كۈچى),
						'one' => q({0} ئات كۈچى),
						'other' => q({0} ئات كۈچى),
					},
					# Core Unit Identifier
					'horsepower' => {
						'name' => q(ئات كۈچى),
						'one' => q({0} ئات كۈچى),
						'other' => q({0} ئات كۈچى),
					},
					# Long Unit Identifier
					'power-kilowatt' => {
						'name' => q(كىلوۋات),
					},
					# Core Unit Identifier
					'kilowatt' => {
						'name' => q(كىلوۋات),
					},
					# Long Unit Identifier
					'power-watt' => {
						'name' => q(ۋات),
					},
					# Core Unit Identifier
					'watt' => {
						'name' => q(ۋات),
					},
					# Long Unit Identifier
					'pressure-hectopascal' => {
						'name' => q(يۈز پاسكال),
						'one' => q({0} ھېكتوپاسكال),
						'other' => q({0} ھېكتوپاسكال),
					},
					# Core Unit Identifier
					'hectopascal' => {
						'name' => q(يۈز پاسكال),
						'one' => q({0} ھېكتوپاسكال),
						'other' => q({0} ھېكتوپاسكال),
					},
					# Long Unit Identifier
					'pressure-inch-ofhg' => {
						'name' => q(ديۇيم سىماب تۈۋرۇكى),
					},
					# Core Unit Identifier
					'inch-ofhg' => {
						'name' => q(ديۇيم سىماب تۈۋرۇكى),
					},
					# Long Unit Identifier
					'pressure-millibar' => {
						'name' => q(مىللىبار),
					},
					# Core Unit Identifier
					'millibar' => {
						'name' => q(مىللىبار),
					},
					# Long Unit Identifier
					'speed-kilometer-per-hour' => {
						'name' => q(كىلومېتىر ھەر سائەت),
						'one' => q({0} سائەت/كىلومېتىر),
						'other' => q({0} سائەت/كىلومېتىر),
					},
					# Core Unit Identifier
					'kilometer-per-hour' => {
						'name' => q(كىلومېتىر ھەر سائەت),
						'one' => q({0} سائەت/كىلومېتىر),
						'other' => q({0} سائەت/كىلومېتىر),
					},
					# Long Unit Identifier
					'speed-meter-per-second' => {
						'name' => q(مېتىر ھەر سېكۇنت),
						'one' => q({0} سېكۇنت/مېتىر),
						'other' => q({0} سېكۇنت/مېتىر),
					},
					# Core Unit Identifier
					'meter-per-second' => {
						'name' => q(مېتىر ھەر سېكۇنت),
						'one' => q({0} سېكۇنت/مېتىر),
						'other' => q({0} سېكۇنت/مېتىر),
					},
					# Long Unit Identifier
					'speed-mile-per-hour' => {
						'name' => q(مىل ھەر سائەت),
						'one' => q({0} سائەت/مىل),
						'other' => q({0} سائەت/مىل),
					},
					# Core Unit Identifier
					'mile-per-hour' => {
						'name' => q(مىل ھەر سائەت),
						'one' => q({0} سائەت/مىل),
						'other' => q({0} سائەت/مىل),
					},
					# Long Unit Identifier
					'temperature-celsius' => {
						'name' => q(سېلسىيە گرادۇس),
					},
					# Core Unit Identifier
					'celsius' => {
						'name' => q(سېلسىيە گرادۇس),
					},
					# Long Unit Identifier
					'temperature-fahrenheit' => {
						'name' => q(فارېنگېيت گرادۇس),
					},
					# Core Unit Identifier
					'fahrenheit' => {
						'name' => q(فارېنگېيت گرادۇس),
					},
					# Long Unit Identifier
					'volume-cubic-kilometer' => {
						'name' => q(كۇب كىلومېتىر),
					},
					# Core Unit Identifier
					'cubic-kilometer' => {
						'name' => q(كۇب كىلومېتىر),
					},
					# Long Unit Identifier
					'volume-cubic-mile' => {
						'name' => q(كۇب مىل),
					},
					# Core Unit Identifier
					'cubic-mile' => {
						'name' => q(كۇب مىل),
					},
					# Long Unit Identifier
					'volume-liter' => {
						'name' => q(لىتېر),
					},
					# Core Unit Identifier
					'liter' => {
						'name' => q(لىتېر),
					},
				},
			} }
);

has 'yesstr' => (
	is			=> 'ro',
	isa			=> RegexpRef,
	init_arg	=> undef,
	default		=> sub { qr'^(?i:ھەئە|ھەئە|yes|y)$' }
);

has 'nostr' => (
	is			=> 'ro',
	isa			=> RegexpRef,
	init_arg	=> undef,
	default		=> sub { qr'^(?i:ياق|ياق|no|n)$' }
);

has 'listPatterns' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
				end => q({0}, and {1}),
				2 => q({0} and {1}),
		} }
);

has native_numbering_system => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> 'arabext',
);

has 'number_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		decimalFormat => {
			'long' => {
				'1000' => {
					'one' => '0 مىڭ',
					'other' => '0 مىڭ',
				},
				'10000' => {
					'one' => '00 مىڭ',
					'other' => '00 مىڭ',
				},
				'100000' => {
					'one' => '000 مىڭ',
					'other' => '000 مىڭ',
				},
				'1000000' => {
					'one' => '0 مىليون',
					'other' => '0 مىليون',
				},
				'10000000' => {
					'one' => '00 مىليون',
					'other' => '00 مىليون',
				},
				'100000000' => {
					'one' => '000 مىليون',
					'other' => '000 مىليون',
				},
				'1000000000' => {
					'one' => '0 مىليارد',
					'other' => '0 مىليارد',
				},
				'10000000000' => {
					'one' => '00 مىليارد',
					'other' => '00 مىليارد',
				},
				'100000000000' => {
					'one' => '000 مىليارد',
					'other' => '000 مىليارد',
				},
				'1000000000000' => {
					'one' => '0 تىرىليون',
					'other' => '0 تىرىليون',
				},
				'10000000000000' => {
					'one' => '00 تىرىليون',
					'other' => '00 تىرىليون',
				},
				'100000000000000' => {
					'one' => '000 تىرىليون',
					'other' => '000 تىرىليون',
				},
			},
			'short' => {
				'1000' => {
					'one' => '0مىڭ',
					'other' => '0مىڭ',
				},
				'10000' => {
					'one' => '00مىڭ',
					'other' => '00مىڭ',
				},
				'100000' => {
					'one' => '000مىڭ',
					'other' => '000مىڭ',
				},
				'1000000' => {
					'one' => '0مىليون',
					'other' => '0مىليون',
				},
				'10000000' => {
					'one' => '00مىليون',
					'other' => '00مىليون',
				},
				'100000000' => {
					'one' => '000مىليون',
					'other' => '000مىليون',
				},
				'1000000000' => {
					'one' => '0مىليارد',
					'other' => '0مىليارد',
				},
				'10000000000' => {
					'one' => '00مىليارد',
					'other' => '00مىليارد',
				},
				'100000000000' => {
					'one' => '000مىليارد',
					'other' => '000مىليارد',
				},
			},
		},
} },
);

has 'number_currency_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'latn' => {
			'pattern' => {
				'default' => {
					'accounting' => {
						'negative' => '(¤#,##0.00)',
						'positive' => '¤#,##0.00',
					},
					'standard' => {
						'positive' => '¤#,##0.00',
					},
				},
			},
		},
} },
);

has 'currencies' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'ADP' => {
			display_name => {
				'currency' => q(ئاندورران پېسېتاسى),
			},
		},
		'AED' => {
			display_name => {
				'currency' => q(ئەرەب بىرلەشمە خەلىپىلىكى دەرھەمى),
			},
		},
		'AFA' => {
			display_name => {
				'currency' => q(ئافغان ئافغانى \(1927–2002\)),
				'one' => q(ئافغان ئافغانى \(1927–2002\)),
				'other' => q(Aئافغان ئافغانى \(1927–2002\)),
			},
		},
		'AFN' => {
			display_name => {
				'currency' => q(ئافغان ئافغانى),
			},
		},
		'ALK' => {
			display_name => {
				'currency' => q(ئالبانىيە لېكى \(1946–1965\)),
			},
		},
		'ALL' => {
			display_name => {
				'currency' => q(ئالبانىيە لېكى),
			},
		},
		'AMD' => {
			display_name => {
				'currency' => q(ئەرمېنىيە دىرامى),
			},
		},
		'ANG' => {
			display_name => {
				'currency' => q(گوللاندىيەگە قاراشلىق ئانتىللېن گۇلدېنى),
			},
		},
		'AOA' => {
			display_name => {
				'currency' => q(ئانگولا كۇۋانزاسى),
			},
		},
		'AOK' => {
			display_name => {
				'currency' => q(ئانگولا كۇۋانزاسى \(1977–1991\)),
				'one' => q(ئانگولا كۇۋانزاسى \(1977–1991\)),
				'other' => q(ئانگولا كۇۋانزاسى \(1977–1991\)\)),
			},
		},
		'AON' => {
			display_name => {
				'currency' => q(ئانگولا يېڭى كۇۋانزاسى \(1990–2000\)),
			},
		},
		'AOR' => {
			display_name => {
				'currency' => q(ئانگولا قايتا تەڭشەلگەن كۇۋانزاسى \(1995–1999\)),
			},
		},
		'ARA' => {
			display_name => {
				'currency' => q(ئارگېنتىنا ئاۋسترالى),
			},
		},
		'ARL' => {
			display_name => {
				'currency' => q(ئارگېنتىنا پېسو لېيى \(1970–1983\)),
			},
		},
		'ARM' => {
			display_name => {
				'currency' => q(ئارگېنتىنا پېسوسى \(1881–1970\)),
			},
		},
		'ARP' => {
			display_name => {
				'currency' => q(ئارگېنتىنا پېسوسى \(1983–1985\)),
			},
		},
		'ARS' => {
			display_name => {
				'currency' => q(ئارگېنتىنا پېسوسى),
			},
		},
		'ATS' => {
			display_name => {
				'currency' => q(ئاۋسترىيە شىللىڭى),
			},
		},
		'AUD' => {
			display_name => {
				'currency' => q(ئاۋسترالىيە دوللىرى),
			},
		},
		'AWG' => {
			display_name => {
				'currency' => q(ئارۇبان فىلورۇنى),
			},
		},
		'AZM' => {
			display_name => {
				'currency' => q(ئەزەربەيجان ماناتى \(1993–2006\)),
			},
		},
		'AZN' => {
			display_name => {
				'currency' => q(ئەزەربەيجان ماناتى),
			},
		},
		'BAD' => {
			display_name => {
				'currency' => q(بوسنىيە-خېرتسېگوۋىنا دىنارى \(1992–1994\)),
			},
		},
		'BAM' => {
			display_name => {
				'currency' => q(بوسنىيە-خېرتسېگوۋىنا ئالماشتۇرۇشچان ماركى),
			},
		},
		'BAN' => {
			display_name => {
				'currency' => q(بوسنىيە-خېرتسېگوۋىنا يېڭى دىنارى \(1994–1997\)),
			},
		},
		'BBD' => {
			display_name => {
				'currency' => q(باربادوس دوللىرى),
			},
		},
		'BDT' => {
			display_name => {
				'currency' => q(باڭلادىش تاكاسى),
			},
		},
		'BEC' => {
			display_name => {
				'currency' => q(بېلگىيە فرانكى \(ئالماشتۇرۇشچان\)),
			},
		},
		'BEF' => {
			display_name => {
				'currency' => q(بېلگىيە فرانكى),
			},
		},
		'BEL' => {
			display_name => {
				'currency' => q(بېلگىيە فرانكى \(پۇل–مۇئامىلە\)),
			},
		},
		'BGL' => {
			display_name => {
				'currency' => q(بۇلغارىيە قاتتىق لېۋاسى),
			},
		},
		'BGM' => {
			display_name => {
				'currency' => q(بۇلغارىيە ئىجتىمائىي لېۋاسى),
			},
		},
		'BGN' => {
			display_name => {
				'currency' => q(بۇلغارىيە لېۋاسى),
			},
		},
		'BGO' => {
			display_name => {
				'currency' => q(بۇلغارىيە لېۋاسى \(1879–1952\)),
			},
		},
		'BHD' => {
			display_name => {
				'currency' => q(بەھرەين دىنارى),
			},
		},
		'BIF' => {
			display_name => {
				'currency' => q(بۇرۇندى فرانكى),
			},
		},
		'BMD' => {
			display_name => {
				'currency' => q(بېرمۇدا دوللىرى),
			},
		},
		'BND' => {
			display_name => {
				'currency' => q(بىرۇنېي دوللىرى),
			},
		},
		'BOB' => {
			display_name => {
				'currency' => q(بولىۋىيە بولىۋىيانوسى),
			},
		},
		'BOL' => {
			display_name => {
				'currency' => q(بولىۋىيە بولىۋىيانوسى \(1863–1963\)),
			},
		},
		'BOP' => {
			display_name => {
				'currency' => q(بولىۋىيە پىسوسى),
			},
		},
		'BOV' => {
			display_name => {
				'currency' => q(بولىۋىيە مۇدولى),
			},
		},
		'BRB' => {
			display_name => {
				'currency' => q(بىرازىلىيە يېڭى كرۇزېروسى \(1967–1986\)),
			},
		},
		'BRC' => {
			display_name => {
				'currency' => q(بىرازىلىيە كرۇزادوسى \(1986–1989\)),
			},
		},
		'BRE' => {
			display_name => {
				'currency' => q(بىرازىلىيە يېڭى كرۇزېروسى \(1990–1993\)),
			},
		},
		'BRL' => {
			display_name => {
				'currency' => q(بىرازىلىيە رىيالى),
			},
		},
		'BRN' => {
			display_name => {
				'currency' => q(بىرازىلىيە يېڭى كرۇزادوسى \(1989–1990\)),
			},
		},
		'BRR' => {
			display_name => {
				'currency' => q(بىرازىلىيە كرۇزېروسى \(1993–1994\)),
			},
		},
		'BRZ' => {
			display_name => {
				'currency' => q(بىرازىلىيە كرۇزېروسى \(1942–1967\)),
			},
		},
		'BSD' => {
			display_name => {
				'currency' => q(باھاما دوللىرى),
			},
		},
		'BTN' => {
			display_name => {
				'currency' => q(بۇتان نگۇلترۇمى),
			},
		},
		'BUK' => {
			display_name => {
				'currency' => q(بىرما كىياتى),
			},
		},
		'BWP' => {
			display_name => {
				'currency' => q(بوتسۋانا پۇلاسى),
			},
		},
		'BYB' => {
			display_name => {
				'currency' => q(بېلارۇسىيە يېڭى رۇبلىسى \(1994–1999\)),
			},
		},
		'BYN' => {
			display_name => {
				'currency' => q(بېلارۇسىيە رۇبلىسى),
			},
		},
		'BYR' => {
			display_name => {
				'currency' => q(بېلارۇسىيە رۇبلىسى \(۲۰۰۰–۲۰۱۶\)),
			},
		},
		'BZD' => {
			display_name => {
				'currency' => q(بېلىز دوللىرى),
			},
		},
		'CAD' => {
			display_name => {
				'currency' => q(كانادا دوللىرى),
			},
		},
		'CDF' => {
			display_name => {
				'currency' => q(كونگو فرانكى),
			},
		},
		'CHE' => {
			display_name => {
				'currency' => q(WIR ياۋرو),
			},
		},
		'CHF' => {
			display_name => {
				'currency' => q(شىۋېتسىيە فرانكى),
			},
		},
		'CHW' => {
			display_name => {
				'currency' => q(WIR فرانكى),
			},
		},
		'CLE' => {
			display_name => {
				'currency' => q(چىلى ئېسكۇدوسى),
			},
		},
		'CLF' => {
			display_name => {
				'currency' => q(چىلى ھېسابات بىرلىكى \(UF\)),
			},
		},
		'CLP' => {
			display_name => {
				'currency' => q(چىلى پېسوسى),
			},
		},
		'CNX' => {
			display_name => {
				'currency' => q(جۇڭگو خەلق بانكىسى دوللىرى),
			},
		},
		'CNY' => {
			symbol => '￥',
			display_name => {
				'currency' => q(جۇڭگو يۈەنى),
			},
		},
		'COP' => {
			display_name => {
				'currency' => q(كولومبىيە پېسوسى),
			},
		},
		'COU' => {
			display_name => {
				'currency' => q(كولومبىيە ھەقىقىي قىممەت بىرلىكى),
			},
		},
		'CRC' => {
			display_name => {
				'currency' => q(كوستارىكا كولونى),
			},
		},
		'CSD' => {
			display_name => {
				'currency' => q(سېربىيە دىنارى \(2002–2006\)),
			},
		},
		'CSK' => {
			display_name => {
				'currency' => q(چېخسىلوۋاكىيە قاتتىق كورۇناسى),
			},
		},
		'CUC' => {
			display_name => {
				'currency' => q(كۇبا ئالماشتۇرۇشچان پېسوسى),
			},
		},
		'CUP' => {
			display_name => {
				'currency' => q(كۇبا پېسوسى),
			},
		},
		'CVE' => {
			display_name => {
				'currency' => q(يېشىل تۇمشۇق ئېسكۇدوسى),
			},
		},
		'CYP' => {
			display_name => {
				'currency' => q(سىپرۇس فوند ستېرلىڭى),
			},
		},
		'CZK' => {
			display_name => {
				'currency' => q(چېخ جۇمھۇرىيىتى كورۇناسى),
			},
		},
		'DDM' => {
			display_name => {
				'currency' => q(شەرقىي گېرمانىيە ماركى),
			},
		},
		'DEM' => {
			display_name => {
				'currency' => q(گېرمانىيە ماركى),
			},
		},
		'DJF' => {
			display_name => {
				'currency' => q(جىبۇتى فرانكى),
			},
		},
		'DKK' => {
			display_name => {
				'currency' => q(دانىيە كرونى),
			},
		},
		'DOP' => {
			display_name => {
				'currency' => q(دومىنىكا پېسوسى),
			},
		},
		'DZD' => {
			display_name => {
				'currency' => q(ئالجىرىيە دىنارى),
			},
		},
		'ECS' => {
			display_name => {
				'currency' => q(ئېكۋادور سۇكرېسى),
			},
		},
		'ECV' => {
			display_name => {
				'currency' => q(ئېكۋادور تۇراقلىق قىممەت بىرلىكى),
			},
		},
		'EEK' => {
			display_name => {
				'currency' => q(ئېستونىيە كرۇنى),
			},
		},
		'EGP' => {
			display_name => {
				'currency' => q(مىسىر فوند سىتېرلىڭى),
			},
		},
		'ERN' => {
			display_name => {
				'currency' => q(ئېرىترېيە ناكفاسى),
			},
		},
		'ESA' => {
			display_name => {
				'currency' => q(ئىسپانىيە پېسېتاسى \(A ھېسابات\)),
			},
		},
		'ESB' => {
			display_name => {
				'currency' => q(ئىسپانىيە پېسېتاسى \(ئالماشتۇرۇش ھېساباتى\)),
			},
		},
		'ESP' => {
			display_name => {
				'currency' => q(ئىسپانىيە پېسېتاسى),
			},
		},
		'ETB' => {
			display_name => {
				'currency' => q(ئېفىيوپىيە بىررى),
			},
		},
		'EUR' => {
			display_name => {
				'currency' => q(ياۋرو),
			},
		},
		'FIM' => {
			display_name => {
				'currency' => q(فىنلاندىيە مارككاسى),
			},
		},
		'FJD' => {
			display_name => {
				'currency' => q(فىجى دوللىرى),
			},
		},
		'FKP' => {
			display_name => {
				'currency' => q(فالكلاند ئاراللىرى فوند سىتېرلىڭى),
			},
		},
		'FRF' => {
			display_name => {
				'currency' => q(فىرانسىيە فرانكى),
			},
		},
		'GBP' => {
			display_name => {
				'currency' => q(ئەنگلىيە فوند سىتېرلىڭى),
			},
		},
		'GEK' => {
			display_name => {
				'currency' => q(گىرۇزىيە كۇپون لارىتى),
			},
		},
		'GEL' => {
			display_name => {
				'currency' => q(گىرۇزىيە لارىسى),
			},
		},
		'GHC' => {
			display_name => {
				'currency' => q(گانا سېدىسى \(1979–2007\)),
			},
		},
		'GHS' => {
			display_name => {
				'currency' => q(گانا سېدىسى),
			},
		},
		'GIP' => {
			display_name => {
				'currency' => q(جەبىلتارىق فوند سىتېرلىڭى),
			},
		},
		'GMD' => {
			display_name => {
				'currency' => q(گامبىيە دالاسى),
			},
		},
		'GNF' => {
			display_name => {
				'currency' => q(گىۋىنېيە فرانكى),
			},
		},
		'GNS' => {
			display_name => {
				'currency' => q(گىۋىنېيە سىلىسى),
			},
		},
		'GQE' => {
			display_name => {
				'currency' => q(ئېكۋاتور گىۋىنېيە ئېكۋېلېسى),
			},
		},
		'GRD' => {
			display_name => {
				'currency' => q(گىرېتسىيە دراخماسى),
			},
		},
		'GTQ' => {
			display_name => {
				'currency' => q(گىۋاتېمالا كۇۋېتزالى),
			},
		},
		'GWE' => {
			display_name => {
				'currency' => q(پورتۇگالىيە گىۋىنېيە ئېسكۇدوسى),
			},
		},
		'GWP' => {
			display_name => {
				'currency' => q(گىۋىنېيە-بىسسائۇ پېسوسى),
			},
		},
		'GYD' => {
			display_name => {
				'currency' => q(گىۋىئانا دوللىرى),
			},
		},
		'HKD' => {
			display_name => {
				'currency' => q(شياڭگاڭ دوللىرى),
			},
		},
		'HNL' => {
			display_name => {
				'currency' => q(ھوندۇراس لېمپىراسى),
			},
		},
		'HRD' => {
			display_name => {
				'currency' => q(كىرودىيە دىنارى),
			},
		},
		'HRK' => {
			display_name => {
				'currency' => q(كىرودىيە كۇناسى),
			},
		},
		'HTG' => {
			display_name => {
				'currency' => q(ھايتى گۇردېسى),
			},
		},
		'HUF' => {
			display_name => {
				'currency' => q(ۋېنگىرىيە فورېنتى),
			},
		},
		'IDR' => {
			display_name => {
				'currency' => q(ھىندونېزىيە رۇپىيەسى),
			},
		},
		'IEP' => {
			display_name => {
				'currency' => q(ئىرېلاندىيە فوندستېرلىڭى),
			},
		},
		'ILP' => {
			display_name => {
				'currency' => q(ئىسرائىلىيە فوندستېرلىڭى),
			},
		},
		'ILR' => {
			display_name => {
				'currency' => q(ئىسرائىل شېكېلى \(1980–1985\)),
			},
		},
		'ILS' => {
			display_name => {
				'currency' => q(ئىسرائىل يېڭى شېكېلى),
			},
		},
		'INR' => {
			display_name => {
				'currency' => q(ھىندىستان رۇپىسى),
			},
		},
		'IQD' => {
			display_name => {
				'currency' => q(ئىراق دىنارى),
			},
		},
		'IRR' => {
			display_name => {
				'currency' => q(ئىران رىيالى),
			},
		},
		'ISJ' => {
			display_name => {
				'currency' => q(ئىسلاندىيە كروناسى \(1918–1981\)),
			},
		},
		'ISK' => {
			display_name => {
				'currency' => q(ئىسلاندىيە كروناسى),
			},
		},
		'ITL' => {
			display_name => {
				'currency' => q(ئىتالىيە لىراسى),
			},
		},
		'JMD' => {
			display_name => {
				'currency' => q(يامايكا دوللىرى),
			},
		},
		'JOD' => {
			display_name => {
				'currency' => q(ئىيوردانىيە دىنارى),
			},
		},
		'JPY' => {
			display_name => {
				'currency' => q(ياپونىيە يېنى),
			},
		},
		'KES' => {
			display_name => {
				'currency' => q(كېنىيە شىللىڭى),
			},
		},
		'KGS' => {
			display_name => {
				'currency' => q(قىرغىزىستان سومى),
			},
		},
		'KHR' => {
			display_name => {
				'currency' => q(كامبودژا رىئېلى),
			},
		},
		'KMF' => {
			display_name => {
				'currency' => q(كومورو فرانكى),
			},
		},
		'KPW' => {
			display_name => {
				'currency' => q(شىمالىي كورېيە ۋونى),
			},
		},
		'KRH' => {
			display_name => {
				'currency' => q(جەنۇبىي كورېيە خۋانى \(1953–1962\)),
			},
		},
		'KRO' => {
			display_name => {
				'currency' => q(جەنۇبىي كورېيە ۋونى \(1945–1953\)),
			},
		},
		'KRW' => {
			display_name => {
				'currency' => q(جەنۇبىي كورېيە ۋونى),
			},
		},
		'KWD' => {
			display_name => {
				'currency' => q(كۇۋەيت دىنارى),
			},
		},
		'KYD' => {
			display_name => {
				'currency' => q(كايمان ئاراللىرى دوللىرى),
			},
		},
		'KZT' => {
			display_name => {
				'currency' => q(قازاقىستان تەڭگىسى),
			},
		},
		'LAK' => {
			display_name => {
				'currency' => q(لائوس كىپى),
			},
		},
		'LBP' => {
			display_name => {
				'currency' => q(لىۋان فوند سىتېرلىڭى),
			},
		},
		'LKR' => {
			display_name => {
				'currency' => q(سىرىلانكا رۇپىسى),
			},
		},
		'LRD' => {
			display_name => {
				'currency' => q(لىبېرىيە دوللىرى),
			},
		},
		'LSL' => {
			display_name => {
				'currency' => q(لېسوتو لوتىسى),
			},
		},
		'LTL' => {
			display_name => {
				'currency' => q(لىتۋا لىتاسى),
			},
		},
		'LTT' => {
			display_name => {
				'currency' => q(لىتۋا تالوناسى),
			},
		},
		'LUC' => {
			display_name => {
				'currency' => q(ليۇكسېمبۇرگ ئالماشتۇرۇشچان پېسوسى),
			},
		},
		'LUF' => {
			display_name => {
				'currency' => q(ليۇكسېمبۇرگ فرانكى),
			},
		},
		'LUL' => {
			display_name => {
				'currency' => q(لىيۇكسېمبۇرگ پۇل-مۇئامىلە فرانكى),
			},
		},
		'LVL' => {
			display_name => {
				'currency' => q(لاتۋىيە لاتى),
			},
		},
		'LVR' => {
			display_name => {
				'currency' => q(لاتۋىيە رۇبلىسى),
			},
		},
		'LYD' => {
			display_name => {
				'currency' => q(لىۋىيە دىنارى),
			},
		},
		'MAD' => {
			display_name => {
				'currency' => q(ماراكەش دىرھەمى),
			},
		},
		'MAF' => {
			display_name => {
				'currency' => q(ماراكەش فرانكى),
			},
		},
		'MCF' => {
			display_name => {
				'currency' => q(موناكو فرانكى),
			},
		},
		'MDC' => {
			display_name => {
				'currency' => q(مولدوۋا كۇپونى),
			},
		},
		'MDL' => {
			display_name => {
				'currency' => q(مولدوۋا لېۋى),
			},
		},
		'MGA' => {
			display_name => {
				'currency' => q(ماداغاسقار ئارىئارىسى),
			},
		},
		'MGF' => {
			display_name => {
				'currency' => q(ماداغاسقار فرانكى),
			},
		},
		'MKD' => {
			display_name => {
				'currency' => q(ماكېدونىيە دىنارى),
			},
		},
		'MKN' => {
			display_name => {
				'currency' => q(ماكېدونىيە دىنارى \(1992–1993\)),
			},
		},
		'MLF' => {
			display_name => {
				'currency' => q(مالى فرانكى),
			},
		},
		'MMK' => {
			display_name => {
				'currency' => q(مىيانمار كىياتى),
			},
		},
		'MNT' => {
			display_name => {
				'currency' => q(موڭغۇلىيە تۈگرىكى),
			},
		},
		'MOP' => {
			display_name => {
				'currency' => q(ئاۋمېن پاتاكاسى),
			},
		},
		'MRO' => {
			display_name => {
				'currency' => q(ماۋرىتانىيە ئۇگىيەسى \(1973–2017\)),
			},
		},
		'MRU' => {
			display_name => {
				'currency' => q(ماۋرىتانىيە ئۇگىيەسى),
			},
		},
		'MTL' => {
			display_name => {
				'currency' => q(مالتا لىراسى),
			},
		},
		'MTP' => {
			display_name => {
				'currency' => q(مالتا فوندستېرلىڭى),
			},
		},
		'MUR' => {
			display_name => {
				'currency' => q(ماۋرىتىئۇس رۇپىسى),
			},
		},
		'MVP' => {
			display_name => {
				'currency' => q(مالدىۋى رۇپىسى),
			},
		},
		'MVR' => {
			display_name => {
				'currency' => q(مالدىۋى رۇفىياسى),
			},
		},
		'MWK' => {
			display_name => {
				'currency' => q(مالاۋى كۋاچاسى),
			},
		},
		'MXN' => {
			display_name => {
				'currency' => q(مېكسىكا پېسوسى),
			},
		},
		'MXP' => {
			display_name => {
				'currency' => q(مېكسىكا كۈمۈش پېسوسى \(1861–1992\)),
			},
		},
		'MXV' => {
			display_name => {
				'currency' => q(مېكسىكا مەبلەغ بىرلىكى),
			},
		},
		'MYR' => {
			display_name => {
				'currency' => q(مالايشىيا رىڭگىتى),
			},
		},
		'MZE' => {
			display_name => {
				'currency' => q(موزامبىك ئېسكۇدوسى),
			},
		},
		'MZM' => {
			display_name => {
				'currency' => q(موزامبىك مېتىكالى \(1980–2006\)),
			},
		},
		'MZN' => {
			display_name => {
				'currency' => q(موزامبىك مېتىكالى),
			},
		},
		'NAD' => {
			display_name => {
				'currency' => q(نامىبىيە دوللىرى),
			},
		},
		'NGN' => {
			display_name => {
				'currency' => q(نىگېرىيە نايراسى),
			},
		},
		'NIC' => {
			display_name => {
				'currency' => q(نىگېرىيە كوردوباسى \(1988–1991\)),
			},
		},
		'NIO' => {
			display_name => {
				'currency' => q(نىگېرىيە كوردوباسى),
			},
		},
		'NLG' => {
			display_name => {
				'currency' => q(گوللاندىيە گۈلدىنى),
			},
		},
		'NOK' => {
			display_name => {
				'currency' => q(نورۋېگىيە كرونى),
			},
		},
		'NPR' => {
			display_name => {
				'currency' => q(نېپال رۇپىسى),
			},
		},
		'NZD' => {
			display_name => {
				'currency' => q(يېڭى زېلاندىيە دوللىرى),
			},
		},
		'OMR' => {
			display_name => {
				'currency' => q(ئومان رىيالى),
			},
		},
		'PAB' => {
			display_name => {
				'currency' => q(پاناما بالبوئاسى),
			},
		},
		'PEI' => {
			display_name => {
				'currency' => q(پېرۇ ئىنتىسى),
			},
		},
		'PEN' => {
			display_name => {
				'currency' => q(پېرۇ سولى),
			},
		},
		'PES' => {
			display_name => {
				'currency' => q(پېرۇ سولى \(1863–1965\)),
			},
		},
		'PGK' => {
			display_name => {
				'currency' => q(پاپۇئا يېڭى گىۋىنېيە كىناسى),
			},
		},
		'PHP' => {
			display_name => {
				'currency' => q(فىلىپپىن پېسوسى),
			},
		},
		'PKR' => {
			display_name => {
				'currency' => q(پاكىستان رۇپىسى),
			},
		},
		'PLN' => {
			display_name => {
				'currency' => q(پولشا زىلوتى),
			},
		},
		'PLZ' => {
			display_name => {
				'currency' => q(پولشا زىلوتى \(1950–1995\)),
			},
		},
		'PTE' => {
			display_name => {
				'currency' => q(پورتۇگالىيە ئېسكۇدوسى),
			},
		},
		'PYG' => {
			display_name => {
				'currency' => q(پاراگۋاي گۇئارانىسى),
			},
		},
		'QAR' => {
			display_name => {
				'currency' => q(قاتار رىيالى),
			},
		},
		'RHD' => {
			display_name => {
				'currency' => q(رودېزىيە دوللىرى),
			},
		},
		'ROL' => {
			display_name => {
				'currency' => q(رۇمىنىيە لېيى \(1952–2006\)),
			},
		},
		'RON' => {
			display_name => {
				'currency' => q(رۇمىنىيە لېيى),
			},
		},
		'RSD' => {
			display_name => {
				'currency' => q(سېربىيە دىنارى),
			},
		},
		'RUB' => {
			display_name => {
				'currency' => q(رۇسىيە رۇبلىسى),
			},
		},
		'RUR' => {
			display_name => {
				'currency' => q(رۇسىيە رۇبلىسى \(1991–1998\)),
			},
		},
		'RWF' => {
			display_name => {
				'currency' => q(رۋاندا فرانكى),
			},
		},
		'SAR' => {
			display_name => {
				'currency' => q(سەئۇدى رىيالى),
			},
		},
		'SBD' => {
			display_name => {
				'currency' => q(سولومون ئاراللىرى دوللىرى),
			},
		},
		'SCR' => {
			display_name => {
				'currency' => q(سېيشېل رۇپىسى),
			},
		},
		'SDD' => {
			display_name => {
				'currency' => q(سۇدان دىنارى \(1992–2007\)),
			},
		},
		'SDG' => {
			display_name => {
				'currency' => q(سۇدان فوندستېرلىڭى),
			},
		},
		'SDP' => {
			display_name => {
				'currency' => q(سۇدان فوندستېرلىڭى \(1957–1998\)),
			},
		},
		'SEK' => {
			display_name => {
				'currency' => q(شىۋېتسىيە كروناسى),
			},
		},
		'SGD' => {
			display_name => {
				'currency' => q(سىنگاپور دوللىرى),
			},
		},
		'SHP' => {
			display_name => {
				'currency' => q(ساينىت-ھېلېنا فوندستېرلىڭى),
			},
		},
		'SIT' => {
			display_name => {
				'currency' => q(سىلوۋېنىيە تولارى),
			},
		},
		'SKK' => {
			display_name => {
				'currency' => q(سىلوۋاكىيە كورۇناسى),
			},
		},
		'SLE' => {
			display_name => {
				'currency' => q(سېررالېئون لېئونېسى),
			},
		},
		'SLL' => {
			display_name => {
				'currency' => q(سېررالېئون لېئونېسى - 1964-2022),
			},
		},
		'SOS' => {
			display_name => {
				'currency' => q(سومالى شىللىڭى),
			},
		},
		'SRD' => {
			display_name => {
				'currency' => q(سۇرىنام دوللىرى),
			},
		},
		'SRG' => {
			display_name => {
				'currency' => q(سۇرىنام گۈلدىنى),
			},
		},
		'SSP' => {
			display_name => {
				'currency' => q(جەنۇبىي سۇدان فوندستېرلىڭى),
			},
		},
		'STD' => {
			display_name => {
				'currency' => q(سان-تومې ۋە پىرىنسىپى دوبراسى \(1977–2017\)),
			},
		},
		'STN' => {
			display_name => {
				'currency' => q(سان-تومې ۋە پىرىنسىپى دوبراسى),
			},
		},
		'SUR' => {
			display_name => {
				'currency' => q(سوۋىت رۇبلىسى),
			},
		},
		'SVC' => {
			display_name => {
				'currency' => q(سالۋادور كولونى),
			},
		},
		'SYP' => {
			display_name => {
				'currency' => q(سۈرىيە فوندستېرلىڭى),
			},
		},
		'SZL' => {
			display_name => {
				'currency' => q(سىۋېزىلاند لىلانگېنى),
			},
		},
		'THB' => {
			display_name => {
				'currency' => q(تايلاند باختى),
			},
		},
		'TJR' => {
			display_name => {
				'currency' => q(تاجىكىستان رۇبلىسى),
			},
		},
		'TJS' => {
			display_name => {
				'currency' => q(تاجىكىستان سومونىسى),
			},
		},
		'TMM' => {
			display_name => {
				'currency' => q(تۈركمەنىستان ماناتى \(1993–2009\)),
			},
		},
		'TMT' => {
			display_name => {
				'currency' => q(تۈركمەنىستان ماناتى),
			},
		},
		'TND' => {
			display_name => {
				'currency' => q(تۇنىس دىنارى),
			},
		},
		'TOP' => {
			display_name => {
				'currency' => q(تونگا پائانگاسى),
			},
		},
		'TPE' => {
			display_name => {
				'currency' => q(تىمور ئېسكۇدوسى),
			},
		},
		'TRL' => {
			display_name => {
				'currency' => q(تۈركىيە لىراسى \(1922–2005\)),
			},
		},
		'TRY' => {
			display_name => {
				'currency' => q(تۈركىيە لىراسى),
			},
		},
		'TTD' => {
			display_name => {
				'currency' => q(تىرىنىداد ۋە توباگو دوللىرى),
			},
		},
		'TWD' => {
			display_name => {
				'currency' => q(يېڭى تەيۋەن دوللىرى),
			},
		},
		'TZS' => {
			display_name => {
				'currency' => q(تانزانىيە شىللىڭى),
			},
		},
		'UAH' => {
			display_name => {
				'currency' => q(ئۇكرائىنا خرىۋناسى),
			},
		},
		'UAK' => {
			display_name => {
				'currency' => q(ئۇكرائىنا كاربوۋانېتسى),
			},
		},
		'UGS' => {
			display_name => {
				'currency' => q(ئۇگاندا شىللىڭى \(1966–1987\)),
			},
		},
		'UGX' => {
			display_name => {
				'currency' => q(ئۇگاندا شىللىڭى),
			},
		},
		'USD' => {
			symbol => '$',
			display_name => {
				'currency' => q(ئامېرىكا دوللىرى),
			},
		},
		'USN' => {
			display_name => {
				'currency' => q(ئامېرىكا دوللىرى \(كېيىنكى كۈن\)),
			},
		},
		'USS' => {
			display_name => {
				'currency' => q(ئامېرىكا دوللىرى \(ئوخشاش كۈن\)),
			},
		},
		'UYI' => {
			display_name => {
				'currency' => q(ئۇرۇگۋاي پېسوسى \(ئىندېكىسلاش بىرلىكى\)),
			},
		},
		'UYP' => {
			display_name => {
				'currency' => q(ئۇرۇگۋاي پېسوسى \(1975–1993\)),
			},
		},
		'UYU' => {
			display_name => {
				'currency' => q(ئۇرۇگۋاي پېسوسى),
			},
		},
		'UZS' => {
			display_name => {
				'currency' => q(ئۆزبېكىستان سومى),
			},
		},
		'VEB' => {
			display_name => {
				'currency' => q(ۋېنېزۇئېلا بولىۋارى \(1871–2008\)),
			},
		},
		'VEF' => {
			display_name => {
				'currency' => q(ۋېنېزۇئېلا بولىۋارى \(2008–2018\)),
			},
		},
		'VES' => {
			display_name => {
				'currency' => q(ۋېنېزۇئېلا بولىۋارى),
			},
		},
		'VND' => {
			display_name => {
				'currency' => q(ۋىيېتنام دوڭى),
			},
		},
		'VNN' => {
			display_name => {
				'currency' => q(ۋىيېتنام دوڭى \(1978–1985\)),
			},
		},
		'VUV' => {
			display_name => {
				'currency' => q(ۋانۇئاتۇ ۋاتۇسى),
			},
		},
		'WST' => {
			display_name => {
				'currency' => q(ساموئا تالاسى),
			},
		},
		'XAF' => {
			display_name => {
				'currency' => q(ئافرىقا قىتئەسى پۇل-مۇئامىلە ئىتتىپاقى فرانكى),
			},
		},
		'XAG' => {
			display_name => {
				'currency' => q(كۈمۈش),
				'one' => q(ئالتۇن ئۈنسىيە بىرلىكىدىكى كۈمۈش),
				'other' => q(ئالتۇن ئۈنسىيە بىرلىكىدىكى كۈمۈش),
			},
		},
		'XAU' => {
			display_name => {
				'currency' => q(ئالتۇن),
				'one' => q(ئالتۇن ئۈنسىيە بىرلىكىدىكى ئالتۇن),
				'other' => q(ئالتۇن ئۈنسىيە بىرلىكىدىكى ئالتۇن),
			},
		},
		'XBA' => {
			display_name => {
				'currency' => q(ياۋروپا مۇرەككەپ بىرلىكى),
			},
		},
		'XBB' => {
			display_name => {
				'currency' => q(ياۋروپا پۇل بىرلىكى \(XBB\)),
			},
		},
		'XBC' => {
			display_name => {
				'currency' => q(ياۋروپا ھېسابات بىرلىكى \(XBC\)),
			},
		},
		'XBD' => {
			display_name => {
				'currency' => q(ياۋروپا ھېسابات بىرلىكى \(XBD\)),
			},
		},
		'XCD' => {
			display_name => {
				'currency' => q(شەرقىي كارىب دوللىرى),
			},
		},
		'XDR' => {
			display_name => {
				'currency' => q(ئالاھىدە پۇل ئېلىش ھوقۇقى),
			},
		},
		'XEU' => {
			display_name => {
				'currency' => q(ياۋروپا پۇل بىرلىكى),
			},
		},
		'XFO' => {
			display_name => {
				'currency' => q(فىرانسىيە ئالتۇن فرانكى),
			},
		},
		'XFU' => {
			display_name => {
				'currency' => q(فىرانسىيە UIC فرانكى),
			},
		},
		'XOF' => {
			display_name => {
				'currency' => q(ئافرىقا قىتئەسى پۇل-مۇئامىلە ئىتتىپاقى فرانكى \(BCEAO\)),
			},
		},
		'XPD' => {
			display_name => {
				'currency' => q(پاللادىي),
				'one' => q(ئالتۇن ئۈنسىيە بىرلىكىدىكى پاللادىي),
				'other' => q(ئالتۇن ئۈنسىيە بىرلىكىدىكى پاللادىي),
			},
		},
		'XPF' => {
			display_name => {
				'currency' => q(تىنچ ئوكيان پۇل-مۇئامىلە ئورتاق گەۋدىسى فرانكى),
			},
		},
		'XPT' => {
			display_name => {
				'currency' => q(پىلاتىنا),
				'one' => q(ئالتۇن ئۈنسىيە بىرلىكىدىكى پىلاتىنا),
				'other' => q(ئالتۇن ئۈنسىيە بىرلىكىدىكى پىلاتىنا),
			},
		},
		'XRE' => {
			display_name => {
				'currency' => q(RINET فوندى),
				'one' => q(RINET فوندى بىرلىكى),
				'other' => q(RINET فوندى بىرلىكى),
			},
		},
		'XSU' => {
			display_name => {
				'currency' => q(سۇكرې),
			},
		},
		'XTS' => {
			display_name => {
				'currency' => q(پۇل سىناش بىرلىكى),
			},
		},
		'XUA' => {
			display_name => {
				'currency' => q(ئاسىيا تەرەققىيات بانكىسى ھېسابات بىرلىكى),
			},
		},
		'XXX' => {
			display_name => {
				'currency' => q(يوچۇن پۇل),
				'one' => q(\(يوچۇن پۇل بىرلىكى\)),
				'other' => q(\(يوچۇن پۇل\)),
			},
		},
		'YDD' => {
			display_name => {
				'currency' => q(يەمەن دىنارى),
			},
		},
		'YER' => {
			display_name => {
				'currency' => q(يەمەن رىيالى),
			},
		},
		'YUD' => {
			display_name => {
				'currency' => q(يۇگوسلاۋىيە قاتتىق دىنارى \(1966–1990\)),
			},
		},
		'YUM' => {
			display_name => {
				'currency' => q(يۇگوسلاۋىيە يېڭى دىنارى \(1994–2002\)),
			},
		},
		'YUN' => {
			display_name => {
				'currency' => q(يۇگوسلاۋىيە ئالماشتۇرۇشچان دىنارى \(1990–1992\)),
			},
		},
		'YUR' => {
			display_name => {
				'currency' => q(يۇگوسلاۋىيە ئىسلاھات دىنارى \(1992–1993\)),
			},
		},
		'ZAL' => {
			display_name => {
				'currency' => q(جەنۇبىي ئافرىقا راندى \(پۇل–مۇئامىلە\)),
			},
		},
		'ZAR' => {
			display_name => {
				'currency' => q(جەنۇبىي ئافرىقا راندى),
			},
		},
		'ZMK' => {
			display_name => {
				'currency' => q(زامبىيە كۋاچاسى \(1968–2012\)),
			},
		},
		'ZMW' => {
			display_name => {
				'currency' => q(زامبىيە كۋاچاسى),
			},
		},
		'ZRN' => {
			display_name => {
				'currency' => q(زايىر يېڭى زايىرى \(1993–1998\)),
			},
		},
		'ZRZ' => {
			display_name => {
				'currency' => q(زايىر زايىرى \(1971–1993\)),
			},
		},
		'ZWD' => {
			display_name => {
				'currency' => q(زىمبابۋې دوللىرى \(1980–2008\)),
			},
		},
		'ZWL' => {
			display_name => {
				'currency' => q(زىمبابۋې دوللىرى \(2009\)),
			},
		},
		'ZWR' => {
			display_name => {
				'currency' => q(زىمبابۋې دوللىرى \(2008\)),
			},
		},
	} },
);


has 'calendar_months' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'chinese' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'Mo1',
							'Mo2',
							'Mo3',
							'Mo4',
							'Mo5',
							'Mo6',
							'Mo7',
							'Mo8',
							'Mo9',
							'Mo10',
							'Mo11',
							'Mo12'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'Month1',
							'Month2',
							'Month3',
							'Month4',
							'Month5',
							'Month6',
							'Month7',
							'Month8',
							'Month9',
							'Month10',
							'Month11',
							'Month12'
						],
						leap => [
							
						],
					},
				},
			},
			'gregorian' => {
				'format' => {
					wide => {
						nonleap => [
							'يانۋار',
							'فېۋرال',
							'مارت',
							'ئاپرېل',
							'ماي',
							'ئىيۇن',
							'ئىيۇل',
							'ئاۋغۇست',
							'سېنتەبىر',
							'ئۆكتەبىر',
							'نويابىر',
							'دېكابىر'
						],
						leap => [
							
						],
					},
				},
			},
			'islamic' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'مۇھەررەم',
							'سەپەر',
							'رەبىئۇلئەۋۋەل',
							'رەبىئۇلئاخىر',
							'جەمادىيەلئەۋۋەل',
							'جەمادىيەلئاخىر',
							'رەجەب',
							'شەئبان',
							'رامىزان',
							'شەۋۋال',
							'زۇلقەئدە',
							'زۇلھەججە'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'مۇھەررەم',
							'سەپەر',
							'رەبىئۇلئەۋۋەل',
							'رەبىئۇلئاخىر',
							'جەمادىيەلئەۋۋەل',
							'جەمادىيەلئاخىر',
							'رەجەب',
							'شەئبان',
							'رامىزان',
							'شەۋۋال',
							'زۇلقەئدە',
							'زۇلھەججە'
						],
						leap => [
							
						],
					},
				},
			},
	} },
);

has 'calendar_days' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {
						mon => 'دۈ',
						tue => 'سە',
						wed => 'چا',
						thu => 'پە',
						fri => 'جۈ',
						sat => 'شە',
						sun => 'يە'
					},
					short => {
						mon => 'د',
						tue => 'س',
						wed => 'چ',
						thu => 'پ',
						fri => 'ج',
						sat => 'ش',
						sun => 'ي'
					},
					wide => {
						mon => 'دۈشەنبە',
						tue => 'سەيشەنبە',
						wed => 'چارشەنبە',
						thu => 'پەيشەنبە',
						fri => 'جۈمە',
						sat => 'شەنبە',
						sun => 'يەكشەنبە'
					},
				},
				'stand-alone' => {
					narrow => {
						mon => 'د',
						tue => 'س',
						wed => 'چ',
						thu => 'پ',
						fri => 'ج',
						sat => 'ش',
						sun => 'ي'
					},
				},
			},
	} },
);

has 'calendar_quarters' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {0 => '1-پەسىل',
						1 => '2-پەسىل',
						2 => '3-پەسىل',
						3 => '4-پەسىل'
					},
					wide => {0 => 'بىرىنچى پەسىل',
						1 => 'ئىككىنچى پەسىل',
						2 => 'ئۈچىنچى پەسىل',
						3 => 'تۆتىنچى پەسىل'
					},
				},
			},
	} },
);

has 'day_periods' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			'format' => {
				'abbreviated' => {
					'am' => q{چ.ب},
					'pm' => q{چ.ك},
				},
				'narrow' => {
					'am' => q{ب},
					'pm' => q{ك},
				},
				'wide' => {
					'am' => q{چۈشتىن بۇرۇن},
					'pm' => q{چۈشتىن كېيىن},
				},
			},
		},
	} },
);

has 'eras' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'buddhist' => {
			wide => {
				'0' => 'بۇددا يىلنامەسى'
			},
		},
		'chinese' => {
		},
		'generic' => {
		},
		'gregorian' => {
			abbreviated => {
				'1' => 'مىلادىيە'
			},
			wide => {
				'0' => 'مىلادىيەدىن بۇرۇن'
			},
		},
		'islamic' => {
			abbreviated => {
				'0' => 'ھىجرىيە'
			},
		},
		'japanese' => {
		},
		'roc' => {
			abbreviated => {
				'1' => 'مىنگو'
			},
			wide => {
				'0' => 'جۇڭخۇا مىنگودىن بۇرۇن'
			},
		},
	} },
);

has 'date_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'buddhist' => {
		},
		'chinese' => {
			'full' => q{EEEE، MMMM d، U},
			'long' => q{MMMM d، U},
			'medium' => q{MMM d، U},
			'short' => q{M/d/yy},
		},
		'generic' => {
			'full' => q{EEEE، MMMM d، y G},
			'long' => q{MMMM d، y G},
			'medium' => q{MMM d، y G},
			'short' => q{M/d/y GGGGG},
		},
		'gregorian' => {
			'full' => q{y d-MMMM، EEEE},
			'long' => q{d-MMMM، y},
			'medium' => q{d-MMM، y},
			'short' => q{y-MM-dd},
		},
		'islamic' => {
			'full' => q{EEEE، d MMMM، y G},
			'long' => q{d MMMM، y G},
			'medium' => q{d MMM، y G},
			'short' => q{d‏/M‏/y GGGGG},
		},
		'japanese' => {
			'full' => q{EEEE, MMMM d، y G},
			'long' => q{MMMM d، y G},
			'medium' => q{MMM d، y G},
			'short' => q{M/d/y GGGGG},
		},
		'roc' => {
		},
	} },
);

has 'time_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'buddhist' => {
		},
		'chinese' => {
		},
		'generic' => {
		},
		'gregorian' => {
			'full' => q{HH:mm:ss zzzz},
			'long' => q{HH:mm:ss z},
			'medium' => q{HH:mm:ss},
			'short' => q{HH:mm},
		},
		'islamic' => {
		},
		'japanese' => {
		},
		'roc' => {
		},
	} },
);

has 'datetime_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'buddhist' => {
		},
		'chinese' => {
		},
		'generic' => {
			'full' => q{{1} {0}},
			'long' => q{{1} {0}},
			'medium' => q{{1}، {0}},
			'short' => q{{1}، {0}},
		},
		'gregorian' => {
			'full' => q{{1} {0}},
			'long' => q{{1} {0}},
			'medium' => q{{1}، {0}},
			'short' => q{{1}، {0}},
		},
		'islamic' => {
		},
		'japanese' => {
		},
		'roc' => {
		},
	} },
);

has 'datetime_formats_available_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			Ed => q{d E},
			Gy => q{y G},
			GyMMM => q{MMM y G},
			GyMMMEd => q{E، MMM d، y G},
			GyMMMd => q{MMM d، y G},
			MEd => q{E، M/d},
			MMMEd => q{E، MMM d},
			Md => q{M/d},
			y => q{y G},
			yyyy => q{y G},
			yyyyM => q{M/y GGGGG},
			yyyyMEd => q{E، M/d/y GGGGG},
			yyyyMMM => q{MMM y G},
			yyyyMMMEd => q{E، MMM d، y G},
			yyyyMMMd => q{MMM d، y G},
			yyyyMd => q{M/d/y GGGGG},
			yyyyQQQ => q{QQQ y G},
			yyyyQQQQ => q{QQQQ y G},
		},
		'gregorian' => {
			Ed => q{d E},
			Gy => q{y G},
			GyMMM => q{y MMM G},
			GyMMMEd => q{y d-MMM، E G},
			GyMMMd => q{y d-MMM G},
			MEd => q{d-M، E},
			MMMEd => q{d-MMM، E},
			MMMMW => q{MMMM، W-ھەپتە},
			MMMMd => q{d-MMMM},
			MMMd => q{d-MMM},
			Md => q{d-M},
			yM => q{M-y},
			yMEd => q{y-d-M، E},
			yMMMEd => q{y d-MMM، E},
			yMMMd => q{y d-MMM},
			yMd => q{y-d-M},
			yw => q{Y، w-ھەپتە},
		},
		'islamic' => {
			Md => q{d/‏M},
			yyyyM => q{M‏/y G},
			yyyyMEd => q{E، d/‏M/‏y G},
			yyyyMd => q{d‏/M‏/y G},
		},
	} },
);

has 'datetime_formats_append_item' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
	} },
);

has 'datetime_formats_interval' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			M => {
				M => q{M – M},
			},
			MEd => {
				M => q{E، M/d – E، M/d},
				d => q{E، M/d – E، M/d},
			},
			MMM => {
				M => q{MMM – MMM},
			},
			MMMEd => {
				M => q{E، MMM d – E، MMM d},
				d => q{E، MMM d – E، MMM d},
			},
			MMMd => {
				d => q{MMM d – d},
			},
			Md => {
				M => q{M/d – M/d},
				d => q{M/d – M/d},
			},
			d => {
				d => q{d – d},
			},
			fallback => '{0} – {1}',
			y => {
				y => q{y – y G},
			},
			yM => {
				M => q{M/y – M/y GGGGG},
				y => q{M/y – M/y GGGGG},
			},
			yMEd => {
				M => q{E، M/d/y – E، M/d/y GGGGG},
				d => q{E، M/d/y – E، M/d/y GGGGG},
				y => q{E، M/d/y – E، M/d/y GGGGG},
			},
			yMMM => {
				M => q{MMM – MMM y G},
				y => q{MMM y – MMM y G},
			},
			yMMMEd => {
				M => q{E، MMM d – E، MMM d، y G},
				d => q{E، MMM d – E، MMM d، y G},
				y => q{E، MMM d، y – E، MMM d، y G},
			},
			yMMMM => {
				M => q{MMMM – MMMM y G},
				y => q{MMMM y – MMMM y G},
			},
			yMMMd => {
				M => q{MMM d – MMM d، y G},
				d => q{MMM d – d، y G},
				y => q{MMM d، y – MMM d، y G},
			},
			yMd => {
				M => q{M/d/y – M/d/y GGGGG},
				d => q{M/d/y – M/d/y GGGGG},
				y => q{M/d/y – M/d/y GGGGG},
			},
		},
		'gregorian' => {
			H => {
				H => q{HH – HH},
			},
			Hm => {
				H => q{HH:mm – HH:mm},
				m => q{HH:mm – HH:mm},
			},
			Hmv => {
				H => q{HH:mm – HH:mm v},
				m => q{HH:mm – HH:mm v},
			},
			Hv => {
				H => q{HH – HH v},
			},
			M => {
				M => q{M – M},
			},
			MEd => {
				M => q{E، M/d – E، M/d},
				d => q{E، M/d – E، M/d},
			},
			MMM => {
				M => q{MMM – MMM},
			},
			MMMEd => {
				M => q{E، MMM d – E، MMM d},
				d => q{E، MMM d – E، MMM d},
			},
			MMMd => {
				d => q{MMM d – d},
			},
			Md => {
				M => q{M/d – M/d},
				d => q{M/d – M/d},
			},
			d => {
				d => q{d – d},
			},
			fallback => '{0} – {1}',
			h => {
				h => q{h – h a},
			},
			hm => {
				h => q{h:mm – h:mm a},
				m => q{h:mm – h:mm a},
			},
			hmv => {
				h => q{h:mm – h:mm a v},
				m => q{h:mm – h:mm a v},
			},
			hv => {
				h => q{h – h a v},
			},
			y => {
				y => q{y – y},
			},
			yM => {
				M => q{M/y – M/y},
				y => q{M/y – M/y},
			},
			yMEd => {
				M => q{E، M/d/y – E، M/d/y},
				d => q{E، M/d/y – E، M/d/y},
				y => q{E، M/d/y – E، M/d/y},
			},
			yMMM => {
				M => q{MMM – MMM y},
				y => q{MMM y – MMM y},
			},
			yMMMEd => {
				M => q{E، MMM d – E، MMM d، y},
				d => q{E، MMM d – E، MMM d، y},
				y => q{E، MMM d، y – E، MMM d، y},
			},
			yMMMM => {
				M => q{MMMM – MMMM y},
				y => q{MMMM y – MMMM y},
			},
			yMMMd => {
				M => q{MMM d – MMM d، y},
				d => q{MMM d – d، y},
				y => q{MMM d، y – MMM d، y},
			},
			yMd => {
				M => q{M/d/y – M/d/y},
				d => q{M/d/y – M/d/y},
				y => q{M/d/y – M/d/y},
			},
		},
	} },
);

has 'cyclic_name_sets' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'chinese' => {
			'zodiacs' => {
				'format' => {
					'abbreviated' => {
						0 => q(چاشقان),
						1 => q(كالا),
						2 => q(يولۋاس),
						3 => q(توشقان),
						4 => q(ئەجدىھا),
						5 => q(يىلان),
						6 => q(ئات),
						7 => q(قوي),
						8 => q(مايمۇن),
						9 => q(توخۇ),
						10 => q(ئىت),
						11 => q(چوشقا),
					},
				},
			},
		},
	} },
);

has 'time_zone_names' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default	=> sub { {
		regionFormat => q({0} ۋاقتى),
		regionFormat => q({0} يازلىق ۋاقتى),
		regionFormat => q({0} ئۆلچەملىك ۋاقتى),
		'Acre' => {
			long => {
				'daylight' => q#ئاكرى يازلىق ۋاقتى#,
				'generic' => q#ئاكرې ۋاقتى#,
				'standard' => q#ئاكرې ئۆلچەملىك ۋاقتى#,
			},
		},
		'Afghanistan' => {
			long => {
				'standard' => q#ئافغانىستان ۋاقتى#,
			},
		},
		'Africa/Sao_Tome' => {
			exemplarCity => q#سان-تومې#,
		},
		'Africa_Central' => {
			long => {
				'standard' => q#ئوتتۇرا ئافرىقا ۋاقتى#,
			},
		},
		'Africa_Eastern' => {
			long => {
				'standard' => q#شەرقىي ئافرىقا ۋاقتى#,
			},
		},
		'Africa_Southern' => {
			long => {
				'standard' => q#جەنۇبىي ئافرىقا ئۆلچەملىك ۋاقتى#,
			},
		},
		'Africa_Western' => {
			long => {
				'daylight' => q#غەربىي ئافرىقا يازلىق ۋاقتى#,
				'generic' => q#غەربىي ئافرىقا ۋاقتى#,
				'standard' => q#غەربىي ئافرىقا ئۆلچەملىك ۋاقتى#,
			},
		},
		'Alaska' => {
			long => {
				'daylight' => q#ئالياسكا يازلىق ۋاقتى#,
				'generic' => q#ئالياسكا ۋاقتى#,
				'standard' => q#ئالياسكا ئۆلچەملىك ۋاقتى#,
			},
		},
		'Almaty' => {
			long => {
				'daylight' => q#ئالمۇتا يازلىق ۋاقتى#,
				'generic' => q#ئالمۇتا ۋاقتى#,
				'standard' => q#ئالمۇتا ئۆلچەملىك ۋاقتى#,
			},
		},
		'Amazon' => {
			long => {
				'daylight' => q#ئامازون يازلىق ۋاقتى#,
				'generic' => q#ئامازون ۋاقتى#,
				'standard' => q#ئامازون ئۆلچەملىك ۋاقتى#,
			},
		},
		'America/Asuncion' => {
			exemplarCity => q#ئاسۇنسىيون#,
		},
		'America/Curacao' => {
			exemplarCity => q#كۇراسو#,
		},
		'America/St_Barthelemy' => {
			exemplarCity => q#ساينىت-بارتھېلەمىي#,
		},
		'America_Central' => {
			long => {
				'daylight' => q#ئوتتۇرا قىسىم يازلىق ۋاقتى#,
				'generic' => q#ئوتتۇرا قىسىم ۋاقتى#,
				'standard' => q#ئوتتۇرا قىسىم ئۆلچەملىك ۋاقتى#,
			},
		},
		'America_Eastern' => {
			long => {
				'daylight' => q#شەرقىي قىسىم يازلىق ۋاقتى#,
				'generic' => q#شەرقىي قىسىم ۋاقتى#,
				'standard' => q#شەرقىي قىسىم ئۆلچەملىك ۋاقتى#,
			},
		},
		'America_Mountain' => {
			long => {
				'daylight' => q#تاغ يازلىق ۋاقتى#,
				'generic' => q#تاغ ۋاقتى#,
				'standard' => q#تاغ ئۆلچەملىك ۋاقتى#,
			},
		},
		'America_Pacific' => {
			long => {
				'daylight' => q#تىنچ ئوكيان يازلىق ۋاقتى#,
				'generic' => q#تىنچ ئوكيان ۋاقتى#,
				'standard' => q#تىنچ ئوكيان ئۆلچەملىك ۋاقتى#,
			},
		},
		'Anadyr' => {
			long => {
				'daylight' => q#ئانادىر يازلىق ۋاقتى#,
				'generic' => q#ئانادىر ۋاقتى#,
				'standard' => q#ئانادىر ئۆلچەملىك ۋاقتى#,
			},
		},
		'Antarctica/DumontDUrville' => {
			exemplarCity => q#دۇمونت دۇرۋىللې#,
		},
		'Aqtau' => {
			long => {
				'daylight' => q#ئاقتاي يازلىق ۋاقتى#,
				'generic' => q#ئاقتاي ۋاقتى#,
				'standard' => q#ئاقتاي ئۆلچەملىك ۋاقتى#,
			},
		},
		'Aqtobe' => {
			long => {
				'daylight' => q#ئاقتۆبە يازلىق ۋاقتى#,
				'generic' => q#ئاقتۆبە ۋاقتى#,
				'standard' => q#ئاقتۆبە ئۆلچەملىك ۋاقتى#,
			},
		},
		'Arabian' => {
			long => {
				'daylight' => q#ئەرەب يازلىق ۋاقتى#,
				'generic' => q#ئەرەب ۋاقتى#,
				'standard' => q#ئەرەب ئۆلچەملىك ۋاقتى#,
			},
		},
		'Argentina' => {
			long => {
				'daylight' => q#ئارگېنتىنا يازلىق ۋاقتى#,
				'generic' => q#ئارگېنتىنا ۋاقتى#,
				'standard' => q#ئارگېنتىنا ئۆلچەملىك ۋاقتى#,
			},
		},
		'Argentina_Western' => {
			long => {
				'daylight' => q#غەربىي ئارگېنتىنا يازلىق ۋاقتى#,
				'generic' => q#غەربىي ئارگېنتىنا ۋاقتى#,
				'standard' => q#غەربىي ئارگېنتىنا ئۆلچەملىك ۋاقتى#,
			},
		},
		'Armenia' => {
			long => {
				'daylight' => q#ئەرمېنىيە يازلىق ۋاقتى#,
				'generic' => q#ئەرمېنىيە ۋاقتى#,
				'standard' => q#ئەرمېنىيە ئۆلچەملىك ۋاقتى#,
			},
		},
		'Asia/Saigon' => {
			exemplarCity => q#خوچىمىن شەھىرى#,
		},
		'Atlantic' => {
			long => {
				'daylight' => q#ئاتلانتىك ئوكيان يازلىق ۋاقتى#,
				'generic' => q#ئاتلانتىك ئوكيان ۋاقتى#,
				'standard' => q#ئاتلانتىك ئوكيان ئۆلچەملىك ۋاقتى#,
			},
		},
		'Australia_Central' => {
			long => {
				'daylight' => q#ئاۋسترالىيە ئوتتۇرا قىسىم يازلىق ۋاقتى#,
				'generic' => q#ئاۋسترالىيە ئوتتۇرا قىسىم ۋاقتى#,
				'standard' => q#ئاۋسترالىيە ئوتتۇرا قىسىم ئۆلچەملىك ۋاقتى#,
			},
		},
		'Australia_CentralWestern' => {
			long => {
				'daylight' => q#ئاۋسترالىيە ئوتتۇرا غەربىي قىسىم يازلىق ۋاقتى#,
				'generic' => q#ئاۋسترالىيە ئوتتۇرا غەربىي قىسىم ۋاقتى#,
				'standard' => q#ئاۋستىرالىيە ئوتتۇرا غەربىي قىسىم ئۆلچەملىك ۋاقتى#,
			},
		},
		'Australia_Eastern' => {
			long => {
				'daylight' => q#ئاۋسترالىيە شەرقىي قىسىم يازلىق ۋاقتى#,
				'generic' => q#ئاۋسترالىيە شەرقىي قىسىم ۋاقتى#,
				'standard' => q#ئاۋسترالىيە شەرقىي قىسىم ئۆلچەملىك ۋاقتى#,
			},
		},
		'Australia_Western' => {
			long => {
				'daylight' => q#ئاۋسترالىيە غەربىي قىسىم يازلىق ۋاقتى#,
				'generic' => q#ئاۋسترالىيە غەربىي قىسىم ۋاقتى#,
				'standard' => q#ئاۋسترالىيە غەربىي قىسىم ئۆلچەملىك ۋاقتى#,
			},
		},
		'Azerbaijan' => {
			long => {
				'daylight' => q#ئەزەربەيجان يازلىق ۋاقتى#,
				'generic' => q#ئەزەربەيجان ۋاقتى#,
				'standard' => q#ئەزەربەيجان ئۆلچەملىك ۋاقتى#,
			},
		},
		'Azores' => {
			long => {
				'daylight' => q#ئازور يازلىق ۋاقتى#,
				'generic' => q#ئازور ۋاقتى#,
				'standard' => q#ئازور ئۆلچەملىك ۋاقتى#,
			},
		},
		'Bangladesh' => {
			long => {
				'daylight' => q#باڭلادىش يازلىق ۋاقتى#,
				'generic' => q#باڭلادىش ۋاقتى#,
				'standard' => q#باڭلادىش ئۆلچەملىك ۋاقتى#,
			},
		},
		'Bhutan' => {
			long => {
				'standard' => q#بۇتان ۋاقتى#,
			},
		},
		'Bolivia' => {
			long => {
				'standard' => q#بولىۋىيە ۋاقتى#,
			},
		},
		'Brasilia' => {
			long => {
				'daylight' => q#بىرازىلىيە يازلىق ۋاقتى#,
				'generic' => q#بىرازىلىيە ۋاقتى#,
				'standard' => q#بىرازىلىيە ئۆلچەملىك ۋاقتى#,
			},
		},
		'Brunei' => {
			long => {
				'standard' => q#بىرۇنىي دارۇسسالام ۋاقتى#,
			},
		},
		'Cape_Verde' => {
			long => {
				'daylight' => q#يېشىل تۇمشۇق يازلىق ۋاقتى#,
				'generic' => q#يېشىل تۇمشۇق ۋاقتى#,
				'standard' => q#يېشىل تۇمشۇق ئۆلچەملىك ۋاقتى#,
			},
		},
		'Casey' => {
			long => {
				'standard' => q#كاسېي ۋاقتى#,
			},
		},
		'Chamorro' => {
			long => {
				'standard' => q#چاموررو ئۆلچەملىك ۋاقتى#,
			},
		},
		'Chatham' => {
			long => {
				'daylight' => q#چاتام يازلىق ۋاقتى#,
				'generic' => q#چاتام ۋاقتى#,
				'standard' => q#چاتام ئۆلچەملىك ۋاقتى#,
			},
		},
		'Chile' => {
			long => {
				'daylight' => q#چىلى يازلىق ۋاقتى#,
				'generic' => q#چىلى ۋاقتى#,
				'standard' => q#چىلى ئۆلچەملىك ۋاقتى#,
			},
		},
		'China' => {
			long => {
				'daylight' => q#جۇڭگو يازلىق ۋاقتى#,
				'generic' => q#جۇڭگو ۋاقتى#,
				'standard' => q#جۇڭگو ئۆلچەملىك ۋاقتى#,
			},
		},
		'Choibalsan' => {
			long => {
				'daylight' => q#چويبالسان يازلىق ۋاقتى#,
				'generic' => q#چويبالسان ۋاقتى#,
				'standard' => q#چويبالسان ئۆلچەملىك ۋاقتى#,
			},
		},
		'Christmas' => {
			long => {
				'standard' => q#روژدېستۋو ئارىلى ۋاقتى#,
			},
		},
		'Cocos' => {
			long => {
				'standard' => q#كوكۇس ئارىلى ۋاقتى#,
			},
		},
		'Colombia' => {
			long => {
				'daylight' => q#كولومبىيە يازلىق ۋاقتى#,
				'generic' => q#كولومبىيە ۋاقتى#,
				'standard' => q#كولومبىيە ئۆلچەملىك ۋاقتى#,
			},
		},
		'Cook' => {
			long => {
				'daylight' => q#كۇك ئاراللىرى يېرىم يازلىق ۋاقتى#,
				'generic' => q#كۇك ئاراللىرى ۋاقتى#,
				'standard' => q#كۇك ئاراللىرى ئۆلچەملىك ۋاقتى#,
			},
		},
		'Cuba' => {
			long => {
				'daylight' => q#كۇبا يازلىق ۋاقتى#,
				'generic' => q#كۇبا ۋاقتى#,
				'standard' => q#كۇبا ئۆلچەملىك ۋاقتى#,
			},
		},
		'Davis' => {
			long => {
				'standard' => q#داۋىس ۋاقتى#,
			},
		},
		'DumontDUrville' => {
			long => {
				'standard' => q#دۇمونت-دۇرۋىل ۋاقتى#,
			},
		},
		'East_Timor' => {
			long => {
				'standard' => q#شەرقىي تىمور ۋاقتى#,
			},
		},
		'Easter' => {
			long => {
				'daylight' => q#ئېستېر ئارىلى يازلىق ۋاقتى#,
				'generic' => q#ئېستېر ئارىلى ۋاقتى#,
				'standard' => q#پاسكاليا ئارىلى ئۆلچەملىك ۋاقتى#,
			},
		},
		'Ecuador' => {
			long => {
				'standard' => q#ئېكۋادور ۋاقتى#,
			},
		},
		'Etc/Unknown' => {
			exemplarCity => q#يوچۇن شەھەر#,
		},
		'Europe/Dublin' => {
			long => {
				'daylight' => q#ئىرېلاند يازلىق ۋاقتى#,
			},
		},
		'Europe/London' => {
			long => {
				'daylight' => q#ئەنگلىيە يازلىق ۋاقتى#,
			},
		},
		'Europe_Central' => {
			long => {
				'daylight' => q#ئوتتۇرا ياۋروپا يازلىق ۋاقتى#,
				'generic' => q#ئوتتۇرا ياۋروپا ۋاقتى#,
				'standard' => q#ئوتتۇرا ياۋروپا ئۆلچەملىك ۋاقتى#,
			},
		},
		'Europe_Eastern' => {
			long => {
				'daylight' => q#شەرقىي ياۋروپا يازلىق ۋاقتى#,
				'generic' => q#شەرقىي ياۋروپا ۋاقتى#,
				'standard' => q#شەرقىي ياۋروپا ئۆلچەملىك ۋاقتى#,
			},
		},
		'Europe_Western' => {
			long => {
				'daylight' => q#غەربىي ياۋروپا يازلىق ۋاقتى#,
				'generic' => q#غەربىي ياۋروپا ۋاقتى#,
				'standard' => q#غەربىي ياۋروپا ئۆلچەملىك ۋاقتى#,
			},
		},
		'Falkland' => {
			long => {
				'daylight' => q#فالكلاند ئاراللىرى يازلىق ۋاقتى#,
				'generic' => q#فالكلاند ئاراللىرى ۋاقتى#,
				'standard' => q#فالكلاند ئاراللىرى ئۆلچەملىك ۋاقتى#,
			},
		},
		'Fiji' => {
			long => {
				'daylight' => q#فىجى يازلىق ۋاقتى#,
				'generic' => q#فىجى ۋاقتى#,
				'standard' => q#فىجى ئۆلچەملىك ۋاقتى#,
			},
		},
		'French_Guiana' => {
			long => {
				'standard' => q#فىرانسىيەگە قاراشلىق گىۋىيانا ۋاقتى#,
			},
		},
		'French_Southern' => {
			long => {
				'standard' => q#فىرانسىيەگە قاراشلىق جەنۇبىي ۋە ئانتاركتىكا ۋاقتى#,
			},
		},
		'GMT' => {
			long => {
				'standard' => q#گىرىنۋىچ ۋاقتى#,
			},
		},
		'Galapagos' => {
			long => {
				'standard' => q#گالاپاگوس ۋاقتى#,
			},
		},
		'Gambier' => {
			long => {
				'standard' => q#گامبىيېر ۋاقتى#,
			},
		},
		'Georgia' => {
			long => {
				'daylight' => q#گىرۇزىيە يازلىق ۋاقتى#,
				'generic' => q#گىرۇزىيە ۋاقتى#,
				'standard' => q#گىرۇزىيە ئۆلچەملىك ۋاقتى#,
			},
		},
		'Gilbert_Islands' => {
			long => {
				'standard' => q#گىلبېرت ئاراللىرى ۋاقتى#,
			},
		},
		'Greenland_Eastern' => {
			long => {
				'daylight' => q#شەرقىي گىرېنلاند يازلىق ۋاقتى#,
				'generic' => q#شەرقىي گىرېنلاند ۋاقتى#,
				'standard' => q#شەرقىي گىرېنلاند ئۆلچەملىك ۋاقتى#,
			},
		},
		'Greenland_Western' => {
			long => {
				'daylight' => q#غەربىي گىرېنلاند يازلىق ۋاقتى#,
				'generic' => q#غەربىي گىرېنلاند ۋاقتى#,
				'standard' => q#غەربىي گىرېنلاند ئۆلچەملىك ۋاقتى#,
			},
		},
		'Guam' => {
			long => {
				'standard' => q#گۇئام ئۆلچەملىك ۋاقتى#,
			},
		},
		'Gulf' => {
			long => {
				'standard' => q#گۇلف ئۆلچەملىك ۋاقتى#,
			},
		},
		'Guyana' => {
			long => {
				'standard' => q#گىۋىيانا ۋاقتى#,
			},
		},
		'Hawaii_Aleutian' => {
			long => {
				'daylight' => q#ھاۋاي-ئالېيۇت يازلىق ۋاقتى#,
				'generic' => q#ھاۋاي-ئالېيۇت ۋاقتى#,
				'standard' => q#ھاۋاي-ئالېيۇت ئۆلچەملىك ۋاقتى#,
			},
		},
		'Hong_Kong' => {
			long => {
				'daylight' => q#شياڭگاڭ يازلىق ۋاقتى#,
				'generic' => q#شياڭگاڭ ۋاقتى#,
				'standard' => q#شياڭگاڭ ئۆلچەملىك ۋاقتى#,
			},
		},
		'Hovd' => {
			long => {
				'daylight' => q#خوۋد يازلىق ۋاقتى#,
				'generic' => q#خوۋد ۋاقتى#,
				'standard' => q#خوۋد ئۆلچەملىك ۋاقتى#,
			},
		},
		'India' => {
			long => {
				'standard' => q#ھىندىستان ئۆلچەملىك ۋاقتى#,
			},
		},
		'Indian/Reunion' => {
			exemplarCity => q#رېئونىيون#,
		},
		'Indian_Ocean' => {
			long => {
				'standard' => q#ھىندى ئوكيان ۋاقتى#,
			},
		},
		'Indochina' => {
			long => {
				'standard' => q#ھىندى چىنى ۋاقتى#,
			},
		},
		'Indonesia_Central' => {
			long => {
				'standard' => q#ئوتتۇرا ھىندونېزىيە ۋاقتى#,
			},
		},
		'Indonesia_Eastern' => {
			long => {
				'standard' => q#شەرقىي ھىندونېزىيە ۋاقتى#,
			},
		},
		'Indonesia_Western' => {
			long => {
				'standard' => q#غەربىي ھىندونېزىيە ۋاقتى#,
			},
		},
		'Iran' => {
			long => {
				'daylight' => q#ئىران يازلىق ۋاقتى#,
				'generic' => q#ئىران ۋاقتى#,
				'standard' => q#ئىران ئۆلچەملىك ۋاقتى#,
			},
		},
		'Irkutsk' => {
			long => {
				'daylight' => q#ئىركۇتسك يازلىق ۋاقتى#,
				'generic' => q#ئىركۇتسك ۋاقتى#,
				'standard' => q#ئىركۇتسك ئۆلچەملىك ۋاقتى#,
			},
		},
		'Israel' => {
			long => {
				'daylight' => q#ئىسرائىلىيە يازلىق ۋاقتى#,
				'generic' => q#ئىسرائىلىيە ۋاقتى#,
				'standard' => q#ئىسرائىلىيە ئۆلچەملىك ۋاقتى#,
			},
		},
		'Japan' => {
			long => {
				'daylight' => q#ياپونىيە يازلىق ۋاقتى#,
				'generic' => q#ياپونىيە ۋاقتى#,
				'standard' => q#ياپونىيە ئۆلچەملىك ۋاقتى#,
			},
		},
		'Kamchatka' => {
			long => {
				'daylight' => q#پېتروپاۋلوۋسك-كامچاتكسكى يازلىق ۋاقتى#,
				'generic' => q#پېتروپاۋلوۋسك-كامچاتكسكى ۋاقتى#,
				'standard' => q#پېتروپاۋلوۋسك-كامچاتكسكى ئۆلچەملىك ۋاقتى#,
			},
		},
		'Kazakhstan_Eastern' => {
			long => {
				'standard' => q#شەرقىي قازاقىستان ۋاقتى#,
			},
		},
		'Kazakhstan_Western' => {
			long => {
				'standard' => q#غەربىي قازاقىستان ۋاقتى#,
			},
		},
		'Korea' => {
			long => {
				'daylight' => q#كورىيە يازلىق ۋاقتى#,
				'generic' => q#كورىيە ۋاقتى#,
				'standard' => q#كورىيە ئۆلچەملىك ۋاقتى#,
			},
		},
		'Kosrae' => {
			long => {
				'standard' => q#كوسرائې ۋاقتى#,
			},
		},
		'Krasnoyarsk' => {
			long => {
				'daylight' => q#كىراسنويارسك يازلىق ۋاقتى#,
				'generic' => q#كىراسنويارسك ۋاقتى#,
				'standard' => q#كىراسنويارسك ئۆلچەملىك ۋاقتى#,
			},
		},
		'Kyrgystan' => {
			long => {
				'standard' => q#قىرغىزىستان ۋاقتى#,
			},
		},
		'Lanka' => {
			long => {
				'standard' => q#سىرى لانكا ۋاقتى#,
			},
		},
		'Line_Islands' => {
			long => {
				'standard' => q#لاين ئاراللىرى ۋاقتى#,
			},
		},
		'Lord_Howe' => {
			long => {
				'daylight' => q#لورد-خاي يازلىق ۋاقتى#,
				'generic' => q#لورد-خاي ۋاقتى#,
				'standard' => q#لورد-خاي ئۆلچەملىك ۋاقتى#,
			},
		},
		'Macau' => {
			long => {
				'daylight' => q#ئاۋمېن يازلىق ۋاقتى#,
				'generic' => q#ئاۋمېن ۋاقتى#,
				'standard' => q#ئاۋمېن ئۆلچەملىك ۋاقتى#,
			},
		},
		'Macquarie' => {
			long => {
				'standard' => q#ماككۇۋارى ئاراللىرى ۋاقتى#,
			},
		},
		'Magadan' => {
			long => {
				'daylight' => q#ماگادان يازلىق ۋاقتى#,
				'generic' => q#ماگادان ۋاقتى#,
				'standard' => q#ماگادان ئۆلچەملىك ۋاقتى#,
			},
		},
		'Malaysia' => {
			long => {
				'standard' => q#مالايشىيا ۋاقتى#,
			},
		},
		'Maldives' => {
			long => {
				'standard' => q#مالدىۋې ۋاقتى#,
			},
		},
		'Marquesas' => {
			long => {
				'standard' => q#ماركىز ۋاقتى#,
			},
		},
		'Marshall_Islands' => {
			long => {
				'standard' => q#مارشال ئاراللىرى ۋاقتى#,
			},
		},
		'Mauritius' => {
			long => {
				'daylight' => q#ماۋرىتىئۇس يازلىق ۋاقتى#,
				'generic' => q#ماۋرىتىئۇس ۋاقتى#,
				'standard' => q#ماۋرىتىئۇس ئۆلچەملىك ۋاقتى#,
			},
		},
		'Mawson' => {
			long => {
				'standard' => q#ماۋسون ۋاقتى#,
			},
		},
		'Mexico_Northwest' => {
			long => {
				'daylight' => q#مېكسىكا غەربىي شىمالىي قىسىم يازلىق ۋاقتى#,
				'generic' => q#مېكسىكا غەربىي شىمالىي قىسىم ۋاقتى#,
				'standard' => q#مېكسىكا غەربىي شىمالىي قىسىم ئۆلچەملىك ۋاقتى#,
			},
		},
		'Mexico_Pacific' => {
			long => {
				'daylight' => q#مېكسىكا تىنچ ئوكيان يازلىق ۋاقتى#,
				'generic' => q#مېكسىكا تىنچ ئوكيان ۋاقتى#,
				'standard' => q#مېكسىكا تىنچ ئوكيان ئۆلچەملىك ۋاقتى#,
			},
		},
		'Mongolia' => {
			long => {
				'daylight' => q#ئۇلانباتور يازلىق ۋاقتى#,
				'generic' => q#ئۇلانباتور ۋاقتى#,
				'standard' => q#ئۇلانباتور ئۆلچەملىك ۋاقتى#,
			},
		},
		'Moscow' => {
			long => {
				'daylight' => q#موسكۋا يازلىق ۋاقتى#,
				'generic' => q#موسكۋا ۋاقتى#,
				'standard' => q#موسكۋا ئۆلچەملىك ۋاقتى#,
			},
		},
		'Myanmar' => {
			long => {
				'standard' => q#بىرما ۋاقتى#,
			},
		},
		'Nauru' => {
			long => {
				'standard' => q#ناۋرۇ ۋاقتى#,
			},
		},
		'Nepal' => {
			long => {
				'standard' => q#نېپال ۋاقتى#,
			},
		},
		'New_Caledonia' => {
			long => {
				'daylight' => q#يېڭى كالېدونىيە يازلىق ۋاقتى#,
				'generic' => q#يېڭى كالېدونىيە ۋاقتى#,
				'standard' => q#يېڭى كالېدونىيە ئۆلچەملىك ۋاقتى#,
			},
		},
		'New_Zealand' => {
			long => {
				'daylight' => q#يېڭى زېلاندىيە يازلىق ۋاقتى#,
				'generic' => q#يېڭى زېلاندىيە ۋاقتى#,
				'standard' => q#يېڭى زېلاندىيە ئۆلچەملىك ۋاقتى#,
			},
		},
		'Newfoundland' => {
			long => {
				'daylight' => q#نىۋفوئۇنلاند يازلىق ۋاقتى#,
				'generic' => q#نىۋفوئۇنلاند ۋاقتى#,
				'standard' => q#نىۋفوئۇنلاند ئۆلچەملىك ۋاقتى#,
			},
		},
		'Niue' => {
			long => {
				'standard' => q#نىيۇئې ۋاقتى#,
			},
		},
		'Norfolk' => {
			long => {
				'daylight' => q#نورفولك ئاراللىرى يازلىق ۋاقتى#,
				'generic' => q#نورفولك ئاراللىرى ۋاقتى#,
				'standard' => q#نورفولك ئاراللىرى ئۆلچەملىك ۋاقتى#,
			},
		},
		'Noronha' => {
			long => {
				'daylight' => q#فېرناندو-نورونخا يازلىق ۋاقتى#,
				'generic' => q#فېرناندو-نورونخا ۋاقتى#,
				'standard' => q#فېرناندو-نورونخا ئۆلچەملىك ۋاقتى#,
			},
		},
		'North_Mariana' => {
			long => {
				'standard' => q#شىمالىي مارىيانا ئاراللىرى ۋاقتى#,
			},
		},
		'Novosibirsk' => {
			long => {
				'daylight' => q#نوۋوسىبىرسك يازلىق ۋاقتى#,
				'generic' => q#نوۋوسىبىرسك ۋاقتى#,
				'standard' => q#نوۋوسىبىرسك ئۆلچەملىك ۋاقتى#,
			},
		},
		'Omsk' => {
			long => {
				'daylight' => q#ئومسك يازلىق ۋاقتى#,
				'generic' => q#ئومسك ۋاقتى#,
				'standard' => q#ئومسك ئۆلچەملىك ۋاقتى#,
			},
		},
		'Pakistan' => {
			long => {
				'daylight' => q#پاكىستان يازلىق ۋاقتى#,
				'generic' => q#پاكىستان ۋاقتى#,
				'standard' => q#پاكىستان ئۆلچەملىك ۋاقتى#,
			},
		},
		'Palau' => {
			long => {
				'standard' => q#پالاۋ ۋاقتى#,
			},
		},
		'Papua_New_Guinea' => {
			long => {
				'standard' => q#پاپۇئا يېڭى گىۋىنېيەسى ۋاقتى#,
			},
		},
		'Paraguay' => {
			long => {
				'daylight' => q#پاراگۋاي يازلىق ۋاقتى#,
				'generic' => q#پاراگۋاي ۋاقتى#,
				'standard' => q#پاراگۋاي ئۆلچەملىك ۋاقتى#,
			},
		},
		'Peru' => {
			long => {
				'daylight' => q#پېرۇ يازلىق ۋاقتى#,
				'generic' => q#پېرۇ ۋاقتى#,
				'standard' => q#پېرۇ ئۆلچەملىك ۋاقتى#,
			},
		},
		'Philippines' => {
			long => {
				'daylight' => q#فىلىپپىن يازلىق ۋاقتى#,
				'generic' => q#فىلىپپىن ۋاقتى#,
				'standard' => q#فىلىپپىن ئۆلچەملىك ۋاقتى#,
			},
		},
		'Phoenix_Islands' => {
			long => {
				'standard' => q#فېنىكس ئاراللىرى ۋاقتى#,
			},
		},
		'Pierre_Miquelon' => {
			long => {
				'daylight' => q#ساينىت پىئېر ۋە مىكېلون يازلىق ۋاقتى#,
				'generic' => q#ساينىت پىئېر ۋە مىكېلون ۋاقتى#,
				'standard' => q#ساينىت پىئېر ۋە مىكېلون ئۆلچەملىك ۋاقتى#,
			},
		},
		'Pitcairn' => {
			long => {
				'standard' => q#پىتكاير ۋاقتى#,
			},
		},
		'Ponape' => {
			long => {
				'standard' => q#پونپېي ۋاقتى#,
			},
		},
		'Qyzylorda' => {
			long => {
				'daylight' => q#قىزىلئوردا يازلىق ۋاقتى#,
				'generic' => q#قىزىلئوردا ۋاقتى#,
				'standard' => q#قىزىلئوردا ئۆلچەملىك ۋاقتى#,
			},
		},
		'Reunion' => {
			long => {
				'standard' => q#رېئونىيون ۋاقتى#,
			},
		},
		'Rothera' => {
			long => {
				'standard' => q#روتېرا ۋاقتى#,
			},
		},
		'Sakhalin' => {
			long => {
				'daylight' => q#ساخارىن يازلىق ۋاقتى#,
				'generic' => q#ساخارىن ۋاقتى#,
				'standard' => q#ساخارىن ئۆلچەملىك ۋاقتى#,
			},
		},
		'Samara' => {
			long => {
				'daylight' => q#سامارا يازلىق ۋاقتى#,
				'generic' => q#سامارا ۋاقتى#,
				'standard' => q#سامارا ئۆلچەملىك ۋاقتى#,
			},
		},
		'Samoa' => {
			long => {
				'daylight' => q#سەمەرقەنت يازلىق ۋاقتى#,
				'generic' => q#ساموئا ۋاقتى#,
				'standard' => q#ساموئا ئۆلچەملىك ۋاقتى#,
			},
		},
		'Seychelles' => {
			long => {
				'standard' => q#سېيشېل ۋاقتى#,
			},
		},
		'Singapore' => {
			long => {
				'standard' => q#سىنگاپور ۋاقتى#,
			},
		},
		'Solomon' => {
			long => {
				'standard' => q#سولومون ئاراللىرى ۋاقتى#,
			},
		},
		'South_Georgia' => {
			long => {
				'standard' => q#جەنۇبىي جورجىيە ۋاقتى#,
			},
		},
		'Suriname' => {
			long => {
				'standard' => q#سۇرىنام ۋاقتى#,
			},
		},
		'Syowa' => {
			long => {
				'standard' => q#شوۋا ۋاقتى#,
			},
		},
		'Tahiti' => {
			long => {
				'standard' => q#تايتى ۋاقتى#,
			},
		},
		'Taipei' => {
			long => {
				'daylight' => q#تەيبېي يازلىق ۋاقتى#,
				'generic' => q#تەيبېي ۋاقتى#,
				'standard' => q#تەيبېي ئۆلچەملىك ۋاقتى#,
			},
		},
		'Tajikistan' => {
			long => {
				'standard' => q#تاجىكىستان ۋاقتى#,
			},
		},
		'Tokelau' => {
			long => {
				'standard' => q#توكېلاۋ ۋاقتى#,
			},
		},
		'Tonga' => {
			long => {
				'daylight' => q#تونگا يازلىق ۋاقتى#,
				'generic' => q#تونگا ۋاقتى#,
				'standard' => q#تونگا ئۆلچەملىك ۋاقتى#,
			},
		},
		'Truk' => {
			long => {
				'standard' => q#چۇك ۋاقتى#,
			},
		},
		'Turkmenistan' => {
			long => {
				'daylight' => q#تۈركمەنىستان يازلىق ۋاقتى#,
				'generic' => q#تۈركمەنىستان ۋاقتى#,
				'standard' => q#تۈركمەنىستان ئۆلچەملىك ۋاقتى#,
			},
		},
		'Tuvalu' => {
			long => {
				'standard' => q#تۇۋالۇ ۋاقتى#,
			},
		},
		'Uruguay' => {
			long => {
				'daylight' => q#ئۇرۇگۋاي يازلىق ۋاقتى#,
				'generic' => q#ئۇرۇگۋاي ۋاقتى#,
				'standard' => q#ئۇرۇگۋاي ئۆلچەملىك ۋاقتى#,
			},
		},
		'Uzbekistan' => {
			long => {
				'daylight' => q#ئۆزبېكىستان يازلىق ۋاقتى#,
				'generic' => q#ئۆزبېكىستان ۋاقتى#,
				'standard' => q#ئۆزبېكىستان ئۆلچەملىك ۋاقتى#,
			},
		},
		'Vanuatu' => {
			long => {
				'daylight' => q#ۋانۇئاتۇ يازلىق ۋاقتى#,
				'generic' => q#ۋانۇئاتۇ ۋاقتى#,
				'standard' => q#ۋانۇئاتۇ ئۆلچەملىك ۋاقتى#,
			},
		},
		'Venezuela' => {
			long => {
				'standard' => q#ۋېنېزۇئېلا ۋاقتى#,
			},
		},
		'Vladivostok' => {
			long => {
				'daylight' => q#ۋىلادىۋوستوك يازلىق ۋاقتى#,
				'generic' => q#ۋىلادىۋوستوك ۋاقتى#,
				'standard' => q#ۋىلادىۋوستوك ئۆلچەملىك ۋاقتى#,
			},
		},
		'Volgograd' => {
			long => {
				'daylight' => q#ۋولگاگراد يازلىق ۋاقتى#,
				'generic' => q#ۋولگاگراد ۋاقتى#,
				'standard' => q#ۋولگاگراد ئۆلچەملىك ۋاقتى#,
			},
		},
		'Vostok' => {
			long => {
				'standard' => q#ۋوستوك ۋاقتى#,
			},
		},
		'Wake' => {
			long => {
				'standard' => q#ۋېيك ئارىلى ۋاقتى#,
			},
		},
		'Wallis' => {
			long => {
				'standard' => q#ۋاللىس ۋە فۇتۇنا ۋاقتى#,
			},
		},
		'Yakutsk' => {
			long => {
				'daylight' => q#ياكۇتسك يازلىق ۋاقتى#,
				'generic' => q#ياكۇتسك ۋاقتى#,
				'standard' => q#ياكۇتسك ئۆلچەملىك ۋاقتى#,
			},
		},
		'Yekaterinburg' => {
			long => {
				'daylight' => q#يېكاتېرىنبۇرگ يازلىق ۋاقتى#,
				'generic' => q#يېكاتېرىنبۇرگ ۋاقتى#,
				'standard' => q#يېكاتېرىنبۇرگ ئۆلچەملىك ۋاقتى#,
			},
		},
	 } }
);
no Moo;

1;

# vim: tabstop=4
