=encoding utf8

=head1 NAME

Locale::CLDR::Locales::Ps - Package for language Pashto

=cut

package Locale::CLDR::Locales::Ps;
# This file auto generated from Data\common\main\ps.xml
#	on Sat  6 Jan 12:50:56 am GMT

use strict;
use warnings;
use version;

our $VERSION = version->declare('v0.40.0');

use v5.10.1;
use mro 'c3';
use utf8;
use if $^V ge v5.12.0, feature => 'unicode_strings';
use Types::Standard qw( Str Int HashRef ArrayRef CodeRef RegexpRef );
use Moo;

extends('Locale::CLDR::Locales::Root');
has 'display_name_language' => (
	is			=> 'ro',
	isa			=> CodeRef,
	init_arg	=> undef,
	default		=> sub {
		 sub {
			 my %languages = (
				'aa' => 'افري',
 				'ab' => 'ابخازي',
 				'ace' => 'اچيني',
 				'ada' => 'ادانگمي',
 				'ady' => 'اديغي',
 				'af' => 'افریکانسي',
 				'agq' => 'اغیمي',
 				'ain' => 'اينويي',
 				'ak' => 'اکاني',
 				'ale' => 'اليوتي',
 				'alt' => 'سویل الټای',
 				'am' => 'امهاري',
 				'an' => 'اراگونېسي',
 				'anp' => 'انگيکي',
 				'ar' => 'عربي',
 				'ar_001' => 'نوې معياري عربي',
 				'arn' => 'ماپوچه',
 				'arp' => 'اراپاهوي',
 				'as' => 'اسامي',
 				'asa' => 'اسويي',
 				'ast' => 'استورياني',
 				'av' => 'اواري',
 				'awa' => 'اوادي',
 				'ay' => 'ایماري',
 				'az' => 'اذربایجاني',
 				'az@alt=short' => 'اذري',
 				'ba' => 'باشکير',
 				'bal' => 'بلوڅي',
 				'ban' => 'بالنی',
 				'bas' => 'باسا',
 				'be' => 'بېلاروسي',
 				'bem' => 'بيمبا',
 				'bez' => 'بينا',
 				'bg' => 'بلغاري',
 				'bho' => 'بهوجپوري',
 				'bi' => 'بسلاما',
 				'bin' => 'بینی',
 				'bla' => 'سکسيکا',
 				'bm' => 'بمبارا',
 				'bn' => 'بنگالي',
 				'bo' => 'تبتي',
 				'br' => 'برېتون',
 				'brx' => 'بودو',
 				'bs' => 'بوسني',
 				'bug' => 'بگنيايي',
 				'byn' => 'بلین',
 				'ca' => 'کټلاني',
 				'ccp' => 'چکما',
 				'ce' => 'چيچني',
 				'ceb' => 'سیبوانوي',
 				'cgg' => 'چيگايي',
 				'ch' => 'چمورو',
 				'chk' => 'چواوکي',
 				'chm' => 'ماري',
 				'cho' => 'چوکټاوي',
 				'chr' => 'چېروکي',
 				'chy' => 'شيني',
 				'ckb' => 'منځنۍ کوردي',
 				'co' => 'کورسيکاني',
 				'crs' => 'سسيلوا ڪروئل فرانسوي',
 				'cs' => 'چېکي',
 				'cu' => 'د کليسا سلاوي',
 				'cv' => 'چوواشي',
 				'cy' => 'ويلشي',
 				'da' => 'ډنمارکي',
 				'dak' => 'داکوتا',
 				'dar' => 'درگوا',
 				'dav' => 'ټایټا',
 				'de' => 'الماني',
 				'de_AT' => 'اتريشي آلماني',
 				'de_CH' => 'سویس های جرمن',
 				'dgr' => 'داگرب',
 				'dje' => 'زرما',
 				'doi' => 'ډوګري',
 				'dsb' => 'کښته سربيايي',
 				'dua' => 'دوالا',
 				'dv' => 'ديویهی',
 				'dyo' => 'جولا فوني',
 				'dz' => 'ژونگکه',
 				'dzg' => 'ډزاګا',
 				'ebu' => 'ايمبو',
 				'ee' => 'ايو',
 				'efi' => 'افک',
 				'eka' => 'اکجک',
 				'el' => 'یوناني',
 				'en' => 'انګليسي',
 				'en_AU' => 'آسټرالياوي انګليسي',
 				'en_CA' => 'کاناډايي انګلیسي',
 				'en_GB' => 'بريتانوی انګلیسي',
 				'en_GB@alt=short' => 'یو کي انګلیسي',
 				'en_US@alt=short' => 'د متحده آيالاتو انګليسي',
 				'eo' => 'اسپرانتو',
 				'es' => 'هسپانوي',
 				'es_419' => 'لاتيني امريکايي هسپانوي',
 				'es_ES' => 'اروپايي هسپانوي',
 				'es_MX' => 'ميکسيکي هسپانوي',
 				'et' => 'حبشي',
 				'eu' => 'باسکي',
 				'ewo' => 'اوونڊو',
 				'fa' => 'فارسي',
 				'fa_AF' => 'دری (افغانستان)',
 				'ff' => 'فولاح',
 				'fi' => 'فینلنډي',
 				'fil' => 'فلیپیني',
 				'fj' => 'فجیان',
 				'fo' => 'فاروئې',
 				'fon' => 'فان',
 				'fr' => 'فرانسوي',
 				'fr_CA' => 'کاناډايي فرانسوي',
 				'fr_CH' => 'سويسي فرانسوي',
 				'fur' => 'فرائیلیین',
 				'fy' => 'لوېديځ فريشي',
 				'ga' => 'ائيرلېنډي',
 				'gd' => 'سکاټلېنډي ګېلک',
 				'gez' => 'ګیز',
 				'gil' => 'گلبرتي',
 				'gl' => 'ګلېشيايي',
 				'gn' => 'ګوراني',
 				'gor' => 'ګورن ټالو',
 				'gsw' => 'سویس جرمن',
 				'gu' => 'ګجراتي',
 				'guz' => 'ګوسي',
 				'gv' => 'مینکس',
 				'gwi' => 'ګیچین',
 				'ha' => 'هوسا',
 				'haw' => 'هوایی',
 				'he' => 'عبراني',
 				'hi' => 'هندي',
 				'hil' => 'ھلیګینون',
 				'hmn' => 'همونګ',
 				'hr' => 'کروايشيايي',
 				'hsb' => 'پورته سربيايي',
 				'ht' => 'هيټي کريول',
 				'hu' => 'هنګري',
 				'hup' => 'ھوپا',
 				'hy' => 'آرمينيايي',
 				'hz' => 'هیرورو',
 				'ia' => 'انټرلنګوا',
 				'iba' => 'ابن',
 				'ibb' => 'ابیبیو',
 				'id' => 'انډونېزي',
 				'ie' => 'آسا نا جبة',
 				'ig' => 'اګبو',
 				'ii' => 'سیچیان یی',
 				'ilo' => 'الوکو',
 				'inh' => 'انگش',
 				'io' => 'اڊو',
 				'is' => 'ايسلنډي',
 				'it' => 'ایټالوي',
 				'iu' => 'انوکتیتوت',
 				'ja' => 'جاپاني',
 				'jbo' => 'لوجبان',
 				'jgo' => 'نګومبا',
 				'jmc' => 'ماچمی',
 				'jv' => 'جاوايي',
 				'ka' => 'جورجيائي',
 				'kab' => 'کیبیل',
 				'kac' => 'کاچین',
 				'kaj' => 'ججو',
 				'kam' => 'کامبا',
 				'kbd' => 'کابیرین',
 				'kcg' => 'تایپ',
 				'kde' => 'ميکونډي',
 				'kea' => 'کابوورډیانو',
 				'kfo' => 'کورو',
 				'kha' => 'خاسې',
 				'khq' => 'کویرا چینی',
 				'ki' => 'ککوؤو',
 				'kj' => 'کواناما',
 				'kk' => 'قازق',
 				'kkj' => 'کاکو',
 				'kl' => 'کلالیسٹ',
 				'kln' => 'کلینجن',
 				'km' => 'خمر',
 				'kmb' => 'کیمبوندو',
 				'kn' => 'کناډا',
 				'ko' => 'کوریایی',
 				'kok' => 'کونکاني',
 				'kpe' => 'کیلي',
 				'kr' => 'کنوری',
 				'krc' => 'کراچی بالکر',
 				'krl' => 'کاریلین',
 				'kru' => 'کورخ',
 				'ks' => 'کشمیري',
 				'ksb' => 'شمبالا',
 				'ksf' => 'بفیا',
 				'ksh' => 'کولوګنيايي',
 				'ku' => 'کردي',
 				'kum' => 'کومک',
 				'kv' => 'کومی',
 				'kw' => 'کورنيشي',
 				'ky' => 'کرغيزي',
 				'la' => 'لاتیني',
 				'lad' => 'لاډینو',
 				'lag' => 'لنګی',
 				'lb' => 'لوګزامبورګي',
 				'lez' => 'لیګغیان',
 				'lg' => 'ګانده',
 				'li' => 'لمبرگیانی',
 				'lkt' => 'لکوټا',
 				'ln' => 'لنګالا',
 				'lo' => 'لاو',
 				'loz' => 'لوزی',
 				'lrc' => 'شمالي لوری',
 				'lt' => 'ليتواني',
 				'lu' => 'لوبا-کټنګا',
 				'lua' => 'لبا لولوا',
 				'lun' => 'لندا',
 				'luo' => 'لو',
 				'lus' => 'ميزو',
 				'luy' => 'لویا',
 				'lv' => 'لېټواني',
 				'mad' => 'مدراسی',
 				'mag' => 'مګهي',
 				'mai' => 'مایتھلي',
 				'mak' => 'مکاسار',
 				'mas' => 'ماسائي',
 				'mdf' => 'موکشا',
 				'men' => 'مینڊي',
 				'mer' => 'ميرو',
 				'mfe' => 'ماریسیسن',
 				'mg' => 'ملغاسي',
 				'mgh' => 'مکھوامیتو',
 				'mgo' => 'ميټا',
 				'mh' => 'مارشلیز',
 				'mi' => 'ماوري',
 				'mic' => 'ممکق',
 				'min' => 'مينيگاباو',
 				'mk' => 'مقدوني',
 				'ml' => 'مالايالم',
 				'mn' => 'منګولیایی',
 				'mni' => 'مانی پوری',
 				'moh' => 'محاواک',
 				'mos' => 'ماسي',
 				'mr' => 'مراټهي',
 				'ms' => 'ملایا',
 				'mt' => 'مالټايي',
 				'mua' => 'مندانګ',
 				'mul' => 'متعدد ژبې',
 				'mus' => 'کريکي',
 				'mwl' => 'مرانديز',
 				'my' => 'برمایی',
 				'myv' => 'ارزيا',
 				'mzn' => 'مزاندراني',
 				'na' => 'نایرو',
 				'nap' => 'نيپالين',
 				'naq' => 'ناما',
 				'nb' => 'ناروېئي (بوکمال)',
 				'nd' => 'شمالي نديبل',
 				'nds' => 'کښته آلماني',
 				'ne' => 'نېپالي',
 				'new' => 'نيواري',
 				'ng' => 'ندونگا',
 				'nia' => 'نياس',
 				'niu' => 'نیان',
 				'nl' => 'هالېنډي',
 				'nl_BE' => 'فلېمېشي',
 				'nmg' => 'کواسیو',
 				'nn' => 'ناروېئي (نائنورسک)',
 				'nnh' => 'نایجیمون',
 				'no' => 'ناروېئي',
 				'nog' => 'نوګی',
 				'nqo' => 'نکو',
 				'nr' => 'سويلي نديبيل',
 				'nso' => 'شمالي سوتو',
 				'nus' => 'نویر',
 				'nv' => 'نواجو',
 				'ny' => 'نیانجا',
 				'nyn' => 'نینکول',
 				'oc' => 'اوکسيټاني',
 				'om' => 'اورومو',
 				'or' => 'اوڊيا',
 				'os' => 'اوسيټک',
 				'pa' => 'پنجابي',
 				'pag' => 'پانګاسین',
 				'pam' => 'پمپانگا',
 				'pap' => 'پاپيامينتو',
 				'pau' => 'پالان',
 				'pcm' => 'نائجیریا پیدجن',
 				'pl' => 'پولنډي',
 				'prg' => 'پروشين',
 				'ps' => 'پښتو',
 				'pt' => 'پورتګالي',
 				'pt_BR' => 'برازیلي پرتګالي',
 				'pt_PT' => 'اروپايي پرتګالي',
 				'qu' => 'کېچوا',
 				'quc' => 'کچی',
 				'rap' => 'رپانوئي',
 				'rar' => 'راروټانګان',
 				'rhg' => 'روهینګیا',
 				'rm' => 'رومانیش',
 				'rn' => 'رونډی',
 				'ro' => 'رومانیایی',
 				'ro_MD' => 'مولداویایی',
 				'rof' => 'رومبو',
 				'ru' => 'روسي',
 				'rup' => 'اروماني',
 				'rw' => 'کینیارونډا',
 				'rwk' => 'روا',
 				'sa' => 'سنسکریټ',
 				'sad' => 'سنډاوی',
 				'sah' => 'سخا',
 				'saq' => 'سمبورو',
 				'sat' => 'سنتالي',
 				'sba' => 'نګبای',
 				'sbp' => 'سانګوو',
 				'sc' => 'سارڊيني',
 				'scn' => 'سیلیسي',
 				'sco' => 'سکاټس',
 				'sd' => 'سندهي',
 				'se' => 'شمالي سامي',
 				'seh' => 'سینا',
 				'ses' => 'کوییرابورو سینی',
 				'sg' => 'سانګو',
 				'sh' => 'سرب-کروشيايي',
 				'shi' => 'تاکلهیټ',
 				'shn' => 'شان',
 				'si' => 'سينهالي',
 				'sk' => 'سلوواکي',
 				'sl' => 'سلوواني',
 				'sm' => 'ساموآن',
 				'sma' => 'سویلي سامی',
 				'smj' => 'لول سامي',
 				'smn' => 'اناري سميع',
 				'sms' => 'سکولټ سمیع',
 				'sn' => 'شونا',
 				'snk' => 'سونینګ',
 				'so' => 'سومالي',
 				'sq' => 'الباني',
 				'sr' => 'سربيائي',
 				'srn' => 'سوران ټونګو',
 				'ss' => 'سواتی',
 				'ssy' => 'سهو',
 				'st' => 'سويلي سوتو',
 				'su' => 'سوډاني',
 				'suk' => 'سکوما',
 				'sv' => 'سویډنی',
 				'sw' => 'سواهېلي',
 				'sw_CD' => 'کانګو سواهلی',
 				'swb' => 'کومورياني',
 				'syr' => 'سوریاني',
 				'ta' => 'تامل',
 				'te' => 'تېليګو',
 				'tem' => 'تیمني',
 				'teo' => 'تیسو',
 				'tet' => 'تتوم',
 				'tg' => 'تاجکي',
 				'th' => 'تايلېنډي',
 				'ti' => 'تيګريني',
 				'tig' => 'تیګر',
 				'tk' => 'ترکمني',
 				'tlh' => 'کلينګاني',
 				'tn' => 'سووانا',
 				'to' => 'تونګان',
 				'tpi' => 'توک پیسین',
 				'tr' => 'ترکي',
 				'trv' => 'تاروکو',
 				'ts' => 'سونګا',
 				'tt' => 'تاتار',
 				'tum' => 'تامبوکا',
 				'tvl' => 'تووالو',
 				'tw' => 'توی',
 				'twq' => 'تساواق',
 				'ty' => 'تاهیتي',
 				'tyv' => 'توینیان',
 				'tzm' => 'مرکزی اطلس تمازائيٹ',
 				'udm' => 'ادمورت',
 				'ug' => 'اويغوري',
 				'uk' => 'اوکرايني',
 				'umb' => 'امبوندو',
 				'und' => 'نامعلومه ژبه',
 				'ur' => 'اردو',
 				'uz' => 'اوزبکي',
 				'vai' => 'وای',
 				've' => 'ویندا',
 				'vi' => 'وېتنامي',
 				'vo' => 'والاپوک',
 				'vun' => 'وونجو',
 				'wa' => 'والون',
 				'wae' => 'ولسیر',
 				'wal' => 'ولایټا',
 				'war' => 'وارۍ',
 				'wo' => 'ولوف',
 				'xal' => 'کالمک',
 				'xh' => 'خوسا',
 				'xog' => 'سوګا',
 				'yav' => 'ینګبین',
 				'ybb' => 'یمبا',
 				'yi' => 'يديش',
 				'yo' => 'یوروبا',
 				'yue' => 'کانټوني',
 				'yue@alt=menu' => 'چايني، کانټونيز',
 				'zgh' => 'معياري مراکشي تمازيټ',
 				'zh' => 'چیني',
 				'zh@alt=menu' => 'چيني، ماندرين',
 				'zh_Hans' => 'ساده چيني',
 				'zh_Hans@alt=long' => 'چيني ماندرين چيني',
 				'zh_Hant' => 'دوديزه چيني',
 				'zh_Hant@alt=long' => 'دوديزه ماندرين چيني',
 				'zu' => 'زولو',
 				'zun' => 'زوني',
 				'zxx' => 'نه ژبني منځپانګه',
 				'zza' => 'زازا',

			);
			if (@_) {
				return $languages{$_[0]};
			}
			return \%languages;
		}
	},
);

has 'display_name_script' => (
	is			=> 'ro',
	isa			=> CodeRef,
	init_arg	=> undef,
	default		=> sub {
		sub {
			my %scripts = (
			'Arab' => 'عربي',
 			'Armn' => 'ارمانیایي',
 			'Beng' => 'بنګله',
 			'Bopo' => 'بوپوموفو',
 			'Brai' => 'بریلي',
 			'Cyrl' => 'سیریلیک',
 			'Deva' => 'دیواناګري',
 			'Ethi' => 'ایتوپي',
 			'Geor' => 'ګرجستاني',
 			'Grek' => 'یوناني',
 			'Gujr' => 'ګجراتي',
 			'Guru' => 'ګرومي',
 			'Hanb' => 'هن او بوپوفومو',
 			'Hang' => 'هنګولي',
 			'Hani' => 'هن',
 			'Hans' => 'ساده شوی',
 			'Hans@alt=stand-alone' => 'ساده هان',
 			'Hant' => 'دودیزه',
 			'Hant@alt=stand-alone' => 'دوديزه هان',
 			'Hebr' => 'عبراني',
 			'Hira' => 'هیراګانا',
 			'Hrkt' => 'د جاپاني سیلابري',
 			'Jamo' => 'جامو',
 			'Jpan' => 'جاپاني',
 			'Kana' => 'کاتاکانا',
 			'Khmr' => 'خمر',
 			'Knda' => 'کناډا',
 			'Kore' => 'کوریایی',
 			'Laoo' => 'لاوو',
 			'Latn' => 'لاتين/لاتيني',
 			'Mlym' => 'مالایالم',
 			'Mong' => 'منګولیایي',
 			'Mymr' => 'میانمار',
 			'Orya' => 'اوديا',
 			'Sinh' => 'سنهالا',
 			'Taml' => 'تامل',
 			'Telu' => 'تیلیګو',
 			'Thaa' => 'تهانا',
 			'Thai' => 'تایلنډي',
 			'Tibt' => 'تبتي',
 			'Zmth' => 'د ریاضیاتو نوټیشن',
 			'Zsye' => 'ایموجي',
 			'Zsym' => 'سمبولونه',
 			'Zxxx' => 'ناليکلی',
 			'Zyyy' => 'عام',
 			'Zzzz' => 'نامعلومه سکرېپټ',

			);
			if ( @_ ) {
				return $scripts{$_[0]};
			}
			return \%scripts;
		}
	}
);

has 'display_name_region' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'001' => 'نړۍ',
 			'002' => 'افريقا',
 			'003' => 'شمالی امریکا',
 			'005' => 'سويلي امريکا',
 			'009' => 'اوقيانوسيه',
 			'011' => 'لویدیځ افریقا',
 			'013' => 'منخنۍ امريکا',
 			'014' => 'ختیځ افریقا',
 			'015' => 'شمالي افریقا',
 			'017' => 'منځنۍ افریقا',
 			'018' => 'سويلي افريقا',
 			'019' => 'امريکې',
 			'021' => 'شمالي امریکا',
 			'029' => 'کیریبین',
 			'030' => 'ختیځ آسیا',
 			'034' => 'سويلي آسيا',
 			'035' => 'سويلي ختيځ آسيا',
 			'039' => 'سويلي اروپا',
 			'053' => 'آسترالیا',
 			'054' => 'ملانشیا',
 			'057' => 'د مایکرونیسینین سیمه',
 			'061' => 'پولنيسيا',
 			'142' => 'آسيا',
 			'143' => 'منځنۍ آسيا',
 			'145' => 'لویدیځ آسیا',
 			'150' => 'اروپا',
 			'151' => 'ختيځ اروپا',
 			'154' => 'شمالي اروپا',
 			'155' => 'لوېديځ اروپا',
 			'202' => 'سب سهارن افريقا',
 			'419' => 'لاتیني امریکا',
 			'AC' => 'اسينشان ټاپو',
 			'AD' => 'اندورا',
 			'AE' => 'متحده عرب امارات',
 			'AF' => 'افغانستان',
 			'AG' => 'انټيګوا او باربودا',
 			'AI' => 'انګیلا',
 			'AL' => 'البانیه',
 			'AM' => 'ارمنستان',
 			'AO' => 'انګولا',
 			'AQ' => 'انتارکتیکا',
 			'AR' => 'ارجنټاين',
 			'AS' => 'امریکایی ساماوا',
 			'AT' => 'اتریش',
 			'AU' => 'آسټرالیا',
 			'AW' => 'آروبا',
 			'AX' => 'الاند ټاپوان',
 			'AZ' => 'اذربايجان',
 			'BA' => 'بوسنيا او هېرزګوينا',
 			'BB' => 'باربادوس',
 			'BD' => 'بنگله دېش',
 			'BE' => 'بیلجیم',
 			'BF' => 'بورکینا فاسو',
 			'BG' => 'بلغاریه',
 			'BH' => 'بحرين',
 			'BI' => 'بروندي',
 			'BJ' => 'بینن',
 			'BL' => 'سينټ بارتيلمي',
 			'BM' => 'برمودا',
 			'BN' => 'برونائي',
 			'BO' => 'بولیویا',
 			'BQ' => 'کیریبین هالینډ',
 			'BR' => 'برازیل',
 			'BS' => 'باهماس',
 			'BT' => 'بهوټان',
 			'BV' => 'بوویټ ټاپو',
 			'BW' => 'بوتسوانه',
 			'BY' => 'بیلاروس',
 			'BZ' => 'بلیز',
 			'CA' => 'کاناډا',
 			'CC' => 'کوکوز (کيلنګ) ټاپوګان',
 			'CD' => 'کانګو - کینشاسا',
 			'CD@alt=variant' => 'کانګو (DRC)',
 			'CF' => 'وسطي افريقا جمهور',
 			'CG' => 'کانګو - بروزوییل',
 			'CG@alt=variant' => 'کانګو (جمهوریه)',
 			'CH' => 'سویس',
 			'CI' => 'د عاج ساحل',
 			'CI@alt=variant' => 'ایوري ساحل',
 			'CK' => 'کوک ټاپوګان',
 			'CL' => 'چیلي',
 			'CM' => 'کامرون',
 			'CN' => 'چین',
 			'CO' => 'کولمبیا',
 			'CP' => 'د کلپرټون ټاپو',
 			'CR' => 'کوستاریکا',
 			'CU' => 'کیوبا',
 			'CV' => 'کیپ ورد',
 			'CW' => 'کوراکاو',
 			'CX' => 'د کريسمس ټاپو',
 			'CY' => 'قبرس',
 			'CZ' => 'چکیا',
 			'CZ@alt=variant' => 'جمهوريه چيک',
 			'DE' => 'المان',
 			'DG' => 'ډایګو ګارسیا',
 			'DJ' => 'جبوتي',
 			'DK' => 'ډنمارک',
 			'DM' => 'دومینیکا',
 			'DO' => 'جمهوريه ډومينيکن',
 			'DZ' => 'الجزایر',
 			'EA' => 'سيوتا او ماليلا',
 			'EC' => 'اکوادور',
 			'EE' => 'استونیا',
 			'EG' => 'مصر',
 			'EH' => 'لويديځ صحارا',
 			'ER' => 'اریتره',
 			'ES' => 'هسپانیه',
 			'ET' => 'حبشه',
 			'EU' => 'اروپايي اتحاديه',
 			'EZ' => 'اروپايي سيمه',
 			'FI' => 'فنلینډ',
 			'FJ' => 'فجي',
 			'FK' => 'فاکلينډ ټاپوګان',
 			'FK@alt=variant' => 'فاکلينډ ټاپوګان (آيزلز مالويناس)',
 			'FM' => 'میکرونیزیا',
 			'FO' => 'فارو ټاپو',
 			'FR' => 'فرانسه',
 			'GA' => 'ګابن',
 			'GB' => 'برتانیه',
 			'GB@alt=short' => 'انګلستان',
 			'GD' => 'ګرنادا',
 			'GE' => 'گورجستان',
 			'GF' => 'فرانسوي ګانا',
 			'GG' => 'ګرنسي',
 			'GH' => 'ګانا',
 			'GI' => 'جبل الطارق',
 			'GL' => 'ګرینلینډ',
 			'GM' => 'ګامبیا',
 			'GN' => 'ګینه',
 			'GP' => 'ګوادلوپ',
 			'GQ' => 'استوایی ګیني',
 			'GR' => 'یونان',
 			'GS' => 'سويلي جارجيا او سويلي سېنډوچ ټاپوګان',
 			'GT' => 'ګواتیمالا',
 			'GU' => 'ګوام',
 			'GW' => 'ګینه بیسو',
 			'GY' => 'ګیانا',
 			'HK' => 'هانګ کانګ SAR چین',
 			'HK@alt=short' => 'هانګ کانګ',
 			'HM' => 'هارډ او ميکډانلډ ټاپوګان',
 			'HN' => 'هانډوراس',
 			'HR' => 'کرواشيا',
 			'HT' => 'هایټي',
 			'HU' => 'مجارستان',
 			'IC' => 'د کناري ټاپوګان',
 			'ID' => 'اندونیزیا',
 			'IE' => 'آيرلېنډ',
 			'IL' => 'اسراييل',
 			'IM' => 'د آئل آف مین',
 			'IN' => 'هند',
 			'IO' => 'د برتانوي هند سمندري سيمه',
 			'IQ' => 'عراق',
 			'IR' => 'ايران',
 			'IS' => 'آیسلینډ',
 			'IT' => 'ایټالیه',
 			'JE' => 'جرسی',
 			'JM' => 'جمیکا',
 			'JO' => 'اردن',
 			'JP' => 'جاپان',
 			'KE' => 'کینیا',
 			'KG' => 'قرغزستان',
 			'KH' => 'کمبودیا',
 			'KI' => 'کیري باتي',
 			'KM' => 'کوموروس',
 			'KN' => 'سینټ کټس او نیویس',
 			'KP' => 'شمالی کوریا',
 			'KR' => 'سویلي کوریا',
 			'KW' => 'کويت',
 			'KY' => 'کیمان ټاپوګان',
 			'KZ' => 'قزاقستان',
 			'LA' => 'لاوس',
 			'LB' => 'لبنان',
 			'LC' => 'سینټ لوسیا',
 			'LI' => 'لیختن اشتاین',
 			'LK' => 'سريلنکا',
 			'LR' => 'لايبيريا',
 			'LS' => 'لسوتو',
 			'LT' => 'لیتوانیا',
 			'LU' => 'لوګزامبورګ',
 			'LV' => 'ليتهويا',
 			'LY' => 'لیبیا',
 			'MA' => 'مراکش',
 			'MC' => 'موناکو',
 			'MD' => 'مولدوا',
 			'ME' => 'مونټینیګرو',
 			'MF' => 'سینټ مارټن',
 			'MG' => 'مدغاسکر',
 			'MH' => 'مارشل ټاپوګان',
 			'MK' => 'شمالي مقدونيه',
 			'ML' => 'مالي',
 			'MM' => 'ميانمار (برما)',
 			'MN' => 'منګوليا',
 			'MO' => 'مکاو SAR چین',
 			'MO@alt=short' => 'مکاو',
 			'MP' => 'شمالي ماريانا ټاپوګان',
 			'MQ' => 'مارټینیک',
 			'MR' => 'موریتانیا',
 			'MS' => 'مانټیسیرت',
 			'MT' => 'مالټا',
 			'MU' => 'موریشیس',
 			'MV' => 'مالديپ',
 			'MW' => 'مالاوي',
 			'MX' => 'میکسیکو',
 			'MY' => 'مالیزیا',
 			'MZ' => 'موزمبيق',
 			'NA' => 'نیمبیا',
 			'NC' => 'نوی کالیډونیا',
 			'NE' => 'نايجير',
 			'NF' => 'نارفولک ټاپوګان',
 			'NG' => 'نایجیریا',
 			'NI' => 'نکاراګوا',
 			'NL' => 'هالېنډ',
 			'NO' => 'ناروۍ',
 			'NP' => 'نیپال',
 			'NR' => 'نایرو',
 			'NU' => 'نیوو',
 			'NZ' => 'نیوزیلنډ',
 			'OM' => 'عمان',
 			'PA' => 'پاناما',
 			'PE' => 'پیرو',
 			'PF' => 'فرانسوي پولينيسيا',
 			'PG' => 'پاپوا نيو ګيني',
 			'PH' => 'فلپين',
 			'PK' => 'پاکستان',
 			'PL' => 'پولنډ',
 			'PM' => 'سینټ پییر او میکولون',
 			'PN' => 'پيټکيرن ټاپوګان',
 			'PR' => 'پورتو ریکو',
 			'PS' => 'فلسطیني سيمې',
 			'PS@alt=short' => 'فلسطين',
 			'PT' => 'پورتګال',
 			'PW' => 'پلاؤ',
 			'PY' => 'پاراګوی',
 			'QA' => 'قطر',
 			'QO' => 'بهرنۍ اوسيانه',
 			'RE' => 'ریونین',
 			'RO' => 'رومانیا',
 			'RS' => 'سربيا',
 			'RU' => 'روسیه',
 			'RW' => 'روندا',
 			'SA' => 'سعودي عربستان',
 			'SB' => 'سليمان ټاپوګان',
 			'SC' => 'سیچیلیس',
 			'SD' => 'سوډان',
 			'SE' => 'سویډن',
 			'SG' => 'سينگاپور',
 			'SH' => 'سینټ هیلینا',
 			'SI' => 'سلوانیا',
 			'SJ' => 'سوالبارد او جان ميين',
 			'SK' => 'سلواکیا',
 			'SL' => 'سییرا لیون',
 			'SM' => 'سان مارینو',
 			'SN' => 'سينيګال',
 			'SO' => 'سومالیا',
 			'SR' => 'سورینام',
 			'SS' => 'سويلي سوډان',
 			'ST' => 'ساو ټیم او پرنسیپ',
 			'SV' => 'سالوېډور',
 			'SX' => 'سینټ مارټین',
 			'SY' => 'سوریه',
 			'SZ' => 'اسواټيني',
 			'SZ@alt=variant' => 'سوازيلېنډ',
 			'TA' => 'تریستان دا کنها',
 			'TC' => 'د ترکیې او کیکاسو ټاپو',
 			'TD' => 'چاډ',
 			'TF' => 'د فرانسې جنوبي سیمې',
 			'TG' => 'ټوګو',
 			'TH' => 'تهايلنډ',
 			'TJ' => 'تاجکستان',
 			'TK' => 'توکیلو',
 			'TL' => 'تيمور-ليسټ',
 			'TL@alt=variant' => 'ختيځ تيمور',
 			'TM' => 'تورکمنستان',
 			'TN' => 'تونس',
 			'TO' => 'تونګا',
 			'TR' => 'ترکي',
 			'TT' => 'ټرينيډاډ او ټوباګو',
 			'TV' => 'توالیو',
 			'TW' => 'تائيوان',
 			'TZ' => 'تنزانیا',
 			'UA' => 'اوکراین',
 			'UG' => 'یوګانډا',
 			'UM' => 'د متحده ایالاتو ټاپوګان',
 			'UN' => 'ملگري ملتونه',
 			'US' => 'متحده آيالات',
 			'UY' => 'یوروګوی',
 			'UZ' => 'اوزبکستان',
 			'VA' => 'واتیکان ښار',
 			'VC' => 'سینټ ویسنټینټ او ګرینډینز',
 			'VE' => 'وینزویلا',
 			'VG' => 'بریتانوی ویګور ټاپوګان',
 			'VI' => 'د متحده آيالاتو ورجن ټاپوګان',
 			'VN' => 'وېتنام',
 			'VU' => 'واناتو',
 			'WF' => 'والیس او فوتونا',
 			'WS' => 'ساماوا',
 			'XA' => 'جعلي خج',
 			'XB' => 'سیډو بیډی',
 			'XK' => 'کوسوو',
 			'YE' => 'یمن',
 			'YT' => 'مايوټ',
 			'ZA' => 'سویلي افریقا',
 			'ZM' => 'زیمبیا',
 			'ZW' => 'زیمبابوی',
 			'ZZ' => 'نامعلومه سيمه',

		}
	},
);

has 'display_name_key' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'calendar' => 'جنتري',
 			'cf' => 'اسعارو بڼه',
 			'collation' => 'ترتيب',
 			'currency' => 'اسعارو',
 			'hc' => 'د ساعت چکر (۱۲ پرتله ۲۴)',
 			'lb' => 'د ماتې کرښې ډول',
 			'ms' => 'د ناپ نظام',
 			'numbers' => 'شمېرې',

		}
	},
);

has 'display_name_type' => (
	is			=> 'ro',
	isa			=> HashRef[HashRef[Str]],
	init_arg	=> undef,
	default		=> sub {
		{
			'calendar' => {
 				'buddhist' => q{بودايي جنتري},
 				'chinese' => q{د چين جنتري},
 				'dangi' => q{ډانګي جنتري},
 				'ethiopic' => q{ایتوپيک جنتري},
 				'gregorian' => q{ګريګورين جنتري},
 				'hebrew' => q{جورجویان جنتري},
 				'islamic' => q{اسلامي جنتري},
 				'islamic-civil' => q{اسلامي جنتري (جدولي، مدني عصر)},
 				'islamic-tbla' => q{اسلامي جنتري (جدولي، ستورپوهنيز عصر)},
 				'iso8601' => q{ISO-8601 جنتري},
 				'japanese' => q{جاپاني جنتري},
 				'persian' => q{فارسي جنتري},
 				'roc' => q{منگوو جنتري},
 			},
 			'cf' => {
 				'account' => q{محاسبه اسعارو بڼه},
 				'standard' => q{معياري اسعارو بڼه},
 			},
 			'collation' => {
 				'ducet' => q{ډيفالټ يونيکوډ ترتيب},
 				'search' => q{د عمومي موخي لټون},
 				'standard' => q{د معیاري لټي ترتیب},
 			},
 			'hc' => {
 				'h11' => q{د ۱۲ ساعتو نظام (۰ـ۱۱)},
 				'h12' => q{د ۱۲ ساعتو نظام (۱ ـ ۱۲)},
 				'h23' => q{د ۲۴ ساعتو نظام (۰ـ۲۳)},
 				'h24' => q{د ساعتو نظام (۱ـ۲۴)},
 			},
 			'lb' => {
 				'loose' => q{د غړندې ماتې کرښې ډول},
 				'normal' => q{د عادي ماتې کرښې ډول},
 				'strict' => q{د سختې ماتې کرښې ډول},
 			},
 			'ms' => {
 				'metric' => q{ميټرک نظام},
 				'uksystem' => q{امپيريل د ناپ نظام},
 				'ussystem' => q{د متحده آيالاتو د ناپ نظام},
 			},
 			'numbers' => {
 				'arab' => q{عربي - انډیک عددونه},
 				'arabext' => q{غځېدلې عربي ۔ اينډيک عدد},
 				'armn' => q{آرمينيايي اعداد},
 				'armnlow' => q{آرمينيايي کوچني اعداد},
 				'beng' => q{د بنګلا اعداد},
 				'deva' => q{ديوانګري اعداد},
 				'ethi' => q{ايتهوپيايي اعداد},
 				'fullwide' => q{د بشپړه پراختيا اعداد},
 				'geor' => q{ګريګورين اعداد},
 				'grek' => q{يوناني اعداد},
 				'greklow' => q{يوناني کوچني اعداد},
 				'gujr' => q{ګوجراتي اعداد},
 				'guru' => q{ګرمخې اعداد},
 				'hanidec' => q{چايني اعشاري اعداد},
 				'hans' => q{ساده چيني اعداد},
 				'hansfin' => q{ساده چيني مالي اعداد},
 				'hant' => q{دوديز چيني اعداد},
 				'hantfin' => q{دوديز چيني مالي اعداد},
 				'hebr' => q{عبراني اعداد},
 				'jpan' => q{جاپاني اعداد},
 				'jpanfin' => q{جاپاني مالي اعداد},
 				'khmr' => q{خمري اعداد},
 				'knda' => q{کاناډا يي اعداد},
 				'laoo' => q{لاوي اعداد},
 				'latn' => q{لويديځ عددونه},
 				'mlym' => q{ملاي لام اعداد},
 				'mymr' => q{د ميانمار اعداد},
 				'orya' => q{د اوډيا اعداد},
 				'roman' => q{رومن اعداد},
 				'romanlow' => q{رومن کوچني اعداد},
 				'taml' => q{دوديز تامل اعداد},
 				'tamldec' => q{تامل اعداد},
 				'telu' => q{تيلوګو اعداد},
 				'thai' => q{تايي اعداد},
 				'tibt' => q{تبتي اعداد},
 			},

		}
	},
);

has 'display_name_measurement_system' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'metric' => q{مېټرک},
 			'UK' => q{برتانوې},
 			'US' => q{متحده ايالات},

		}
	},
);

has 'display_name_code_patterns' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'language' => 'ژبه: {0}',
 			'script' => 'سکرېپټ: {0}',
 			'region' => 'سيمه: {0}',

		}
	},
);

has 'text_orientation' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub { return {
			lines => '',
			characters => 'right-to-left',
		}}
);

has 'characters' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> $^V ge v5.18.0
	? eval <<'EOT'
	sub {
		no warnings 'experimental::regex_sets';
		return {
			auxiliary => qr{[‌ ‍ ‎‏ ے]},
			index => ['آ', 'ا', 'ء', 'ب', 'پ', 'ت', 'ټ', 'ث', 'ج', 'ځ', 'چ', 'څ', 'ح', 'خ', 'د', 'ډ', 'ذ', 'ر', 'ړ', 'ز', 'ژ', 'ږ', 'س', 'ش', 'ښ', 'ص', 'ض', 'ط', 'ظ', 'ع', 'غ', 'ف', 'ق', 'ک', 'ګ', 'ل', 'م', 'ن', 'ڼ', 'ه', 'و', 'ی'],
			main => qr{[َ ِ ُ ً ٍ ٌ ّ ْ ٔ ٰ آ ا أ ء ب پ ت ټ ث ج ځ چ څ ح خ د ډ ذ ر ړ ز ژ ږ س ش ښ ص ض ط ظ ع غ ف ق ک ګ گ ل م ن ڼ ه ة و ؤ ی ي ې ۍ ئ]},
			numbers => qr{[‎ \- ‑ , ٫ ٬ . % ٪ ‰ ؉ + − 0۰ 1۱ 2۲ 3۳ 4۴ 5۵ 6۶ 7۷ 8۸ 9۹]},
			punctuation => qr{[، ; \: ! ۔ ' ‘ ( ) \[ \] \{ \} /]},
		};
	},
EOT
: sub {
		return { index => ['آ', 'ا', 'ء', 'ب', 'پ', 'ت', 'ټ', 'ث', 'ج', 'ځ', 'چ', 'څ', 'ح', 'خ', 'د', 'ډ', 'ذ', 'ر', 'ړ', 'ز', 'ژ', 'ږ', 'س', 'ش', 'ښ', 'ص', 'ض', 'ط', 'ظ', 'ع', 'غ', 'ف', 'ق', 'ک', 'ګ', 'ل', 'م', 'ن', 'ڼ', 'ه', 'و', 'ی'], };
},
);


has 'duration_units' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub { {
				hm => 'h:mm',
				hms => 'h:mm:ss',
				ms => 'm:ss',
			} }
);

has 'units' => (
	is			=> 'ro',
	isa			=> HashRef[HashRef[HashRef[Str]]],
	init_arg	=> undef,
	default		=> sub { {
				'long' => {
					# Long Unit Identifier
					'' => {
						'name' => q(کارډنل اړخ),
					},
					# Core Unit Identifier
					'' => {
						'name' => q(کارډنل اړخ),
					},
					# Long Unit Identifier
					'10p-1' => {
						'1' => q(پرېکړه{0}),
					},
					# Core Unit Identifier
					'1' => {
						'1' => q(پرېکړه{0}),
					},
					# Long Unit Identifier
					'10p-12' => {
						'1' => q(پیکو {0}),
					},
					# Core Unit Identifier
					'12' => {
						'1' => q(پیکو {0}),
					},
					# Long Unit Identifier
					'10p-15' => {
						'1' => q(فيمتو {0}),
					},
					# Core Unit Identifier
					'15' => {
						'1' => q(فيمتو {0}),
					},
					# Long Unit Identifier
					'10p-18' => {
						'1' => q(أتو{0}),
					},
					# Core Unit Identifier
					'18' => {
						'1' => q(أتو{0}),
					},
					# Long Unit Identifier
					'10p-2' => {
						'1' => q(سانتي {0}),
					},
					# Core Unit Identifier
					'2' => {
						'1' => q(سانتي {0}),
					},
					# Long Unit Identifier
					'10p-21' => {
						'1' => q(زیپټو {0}),
					},
					# Core Unit Identifier
					'21' => {
						'1' => q(زیپټو {0}),
					},
					# Long Unit Identifier
					'10p-24' => {
						'1' => q(یکوټو {0}),
					},
					# Core Unit Identifier
					'24' => {
						'1' => q(یکوټو {0}),
					},
					# Long Unit Identifier
					'10p-3' => {
						'1' => q(ملی {0}),
					},
					# Core Unit Identifier
					'3' => {
						'1' => q(ملی {0}),
					},
					# Long Unit Identifier
					'10p-6' => {
						'1' => q(مایکرو {0}),
					},
					# Core Unit Identifier
					'6' => {
						'1' => q(مایکرو {0}),
					},
					# Long Unit Identifier
					'10p-9' => {
						'1' => q(نانو {0}),
					},
					# Core Unit Identifier
					'9' => {
						'1' => q(نانو {0}),
					},
					# Long Unit Identifier
					'10p1' => {
						'1' => q(ډیکا {0}),
					},
					# Core Unit Identifier
					'10p1' => {
						'1' => q(ډیکا {0}),
					},
					# Long Unit Identifier
					'10p12' => {
						'1' => q(تیرا {0}),
					},
					# Core Unit Identifier
					'10p12' => {
						'1' => q(تیرا {0}),
					},
					# Long Unit Identifier
					'10p15' => {
						'1' => q(پیټا {0}),
					},
					# Core Unit Identifier
					'10p15' => {
						'1' => q(پیټا {0}),
					},
					# Long Unit Identifier
					'10p18' => {
						'1' => q(إکساء {0}),
					},
					# Core Unit Identifier
					'10p18' => {
						'1' => q(إکساء {0}),
					},
					# Long Unit Identifier
					'10p2' => {
						'1' => q(هیکو {0}),
					},
					# Core Unit Identifier
					'10p2' => {
						'1' => q(هیکو {0}),
					},
					# Long Unit Identifier
					'10p21' => {
						'1' => q(زیټا {0}),
					},
					# Core Unit Identifier
					'10p21' => {
						'1' => q(زیټا {0}),
					},
					# Long Unit Identifier
					'10p24' => {
						'1' => q(یوټا {0}),
					},
					# Core Unit Identifier
					'10p24' => {
						'1' => q(یوټا {0}),
					},
					# Long Unit Identifier
					'10p3' => {
						'1' => q(کیلو {0}),
					},
					# Core Unit Identifier
					'10p3' => {
						'1' => q(کیلو {0}),
					},
					# Long Unit Identifier
					'10p6' => {
						'1' => q(میگا {0}),
					},
					# Core Unit Identifier
					'10p6' => {
						'1' => q(میگا {0}),
					},
					# Long Unit Identifier
					'10p9' => {
						'1' => q(ګیګا {0}),
					},
					# Core Unit Identifier
					'10p9' => {
						'1' => q(ګیګا {0}),
					},
					# Long Unit Identifier
					'acceleration-g-force' => {
						'name' => q(د جاذبې قوه),
						'one' => q({0} د جاذبې قوه),
						'other' => q({0} د جاذبې قوه),
					},
					# Core Unit Identifier
					'g-force' => {
						'name' => q(د جاذبې قوه),
						'one' => q({0} د جاذبې قوه),
						'other' => q({0} د جاذبې قوه),
					},
					# Long Unit Identifier
					'acceleration-meter-per-square-second' => {
						'name' => q(ميترز في مربع سيکنډ),
						'one' => q({0} ميتر في مربع سيکنډ),
						'other' => q({0} ميتر في مربع سيکنډ),
					},
					# Core Unit Identifier
					'meter-per-square-second' => {
						'name' => q(ميترز في مربع سيکنډ),
						'one' => q({0} ميتر في مربع سيکنډ),
						'other' => q({0} ميتر في مربع سيکنډ),
					},
					# Long Unit Identifier
					'angle-arc-minute' => {
						'name' => q(آرکمنټس),
						'one' => q({0} آرکمنټ),
						'other' => q({0} آرکمنټس),
					},
					# Core Unit Identifier
					'arc-minute' => {
						'name' => q(آرکمنټس),
						'one' => q({0} آرکمنټ),
						'other' => q({0} آرکمنټس),
					},
					# Long Unit Identifier
					'angle-arc-second' => {
						'name' => q(آرک ثانيې),
						'one' => q({0} آرک ثانيه),
						'other' => q({0} آرک ثانيې),
					},
					# Core Unit Identifier
					'arc-second' => {
						'name' => q(آرک ثانيې),
						'one' => q({0} آرک ثانيه),
						'other' => q({0} آرک ثانيې),
					},
					# Long Unit Identifier
					'angle-degree' => {
						'name' => q(درجې),
						'one' => q({0} درجې),
						'other' => q({0} درجې),
					},
					# Core Unit Identifier
					'degree' => {
						'name' => q(درجې),
						'one' => q({0} درجې),
						'other' => q({0} درجې),
					},
					# Long Unit Identifier
					'angle-radian' => {
						'name' => q(رادیان),
						'one' => q({0} راديان),
						'other' => q({0} راديان),
					},
					# Core Unit Identifier
					'radian' => {
						'name' => q(رادیان),
						'one' => q({0} راديان),
						'other' => q({0} راديان),
					},
					# Long Unit Identifier
					'angle-revolution' => {
						'name' => q(انقلاب),
						'one' => q({0} انقلاب),
						'other' => q({0} انقلاب),
					},
					# Core Unit Identifier
					'revolution' => {
						'name' => q(انقلاب),
						'one' => q({0} انقلاب),
						'other' => q({0} انقلاب),
					},
					# Long Unit Identifier
					'area-acre' => {
						'name' => q(ايکړز),
						'one' => q({0} ايکړ),
						'other' => q({0} ايکړز),
					},
					# Core Unit Identifier
					'acre' => {
						'name' => q(ايکړز),
						'one' => q({0} ايکړ),
						'other' => q({0} ايکړز),
					},
					# Long Unit Identifier
					'area-dunam' => {
						'name' => q(دونمز),
						'one' => q({0} دونم),
						'other' => q({0} دونمز),
					},
					# Core Unit Identifier
					'dunam' => {
						'name' => q(دونمز),
						'one' => q({0} دونم),
						'other' => q({0} دونمز),
					},
					# Long Unit Identifier
					'area-hectare' => {
						'name' => q(هيکترې),
						'one' => q({0} هيکتر),
						'other' => q({0} هيکترې),
					},
					# Core Unit Identifier
					'hectare' => {
						'name' => q(هيکترې),
						'one' => q({0} هيکتر),
						'other' => q({0} هيکترې),
					},
					# Long Unit Identifier
					'area-square-centimeter' => {
						'name' => q(مربع سنتي متر),
						'one' => q({0} مربع سنتي متر),
						'other' => q({0} مربع سنتي متر),
						'per' => q({0} في مربع سنتي متر),
					},
					# Core Unit Identifier
					'square-centimeter' => {
						'name' => q(مربع سنتي متر),
						'one' => q({0} مربع سنتي متر),
						'other' => q({0} مربع سنتي متر),
						'per' => q({0} في مربع سنتي متر),
					},
					# Long Unit Identifier
					'area-square-foot' => {
						'name' => q(مربع فټ),
						'one' => q({0} مربع فټ),
						'other' => q({0} مربع فټ),
					},
					# Core Unit Identifier
					'square-foot' => {
						'name' => q(مربع فټ),
						'one' => q({0} مربع فټ),
						'other' => q({0} مربع فټ),
					},
					# Long Unit Identifier
					'area-square-inch' => {
						'name' => q(مربع انچ),
						'one' => q({0} مربع انچ),
						'other' => q({0} مربع انچ),
						'per' => q({0} في مربع انچ),
					},
					# Core Unit Identifier
					'square-inch' => {
						'name' => q(مربع انچ),
						'one' => q({0} مربع انچ),
						'other' => q({0} مربع انچ),
						'per' => q({0} في مربع انچ),
					},
					# Long Unit Identifier
					'area-square-kilometer' => {
						'name' => q(مربع کيلو متره),
						'one' => q({0} مربع کيلو متر),
						'other' => q({0} مربع کيلو متره),
						'per' => q({0} في مربع کيلو متر),
					},
					# Core Unit Identifier
					'square-kilometer' => {
						'name' => q(مربع کيلو متره),
						'one' => q({0} مربع کيلو متر),
						'other' => q({0} مربع کيلو متره),
						'per' => q({0} في مربع کيلو متر),
					},
					# Long Unit Identifier
					'area-square-meter' => {
						'name' => q(مربع متره),
						'one' => q({0} مربع متر),
						'other' => q({0} مربع متره),
						'per' => q({0} في مربع متر),
					},
					# Core Unit Identifier
					'square-meter' => {
						'name' => q(مربع متره),
						'one' => q({0} مربع متر),
						'other' => q({0} مربع متره),
						'per' => q({0} في مربع متر),
					},
					# Long Unit Identifier
					'area-square-mile' => {
						'name' => q(مربع ميل),
						'one' => q({0} مربع ميل),
						'other' => q({0} مربع ميل),
						'per' => q({0} في مربع ميل),
					},
					# Core Unit Identifier
					'square-mile' => {
						'name' => q(مربع ميل),
						'one' => q({0} مربع ميل),
						'other' => q({0} مربع ميل),
						'per' => q({0} في مربع ميل),
					},
					# Long Unit Identifier
					'area-square-yard' => {
						'name' => q(مربع ګر),
						'one' => q({0} مربع ګز),
						'other' => q({0} مربع ګز),
					},
					# Core Unit Identifier
					'square-yard' => {
						'name' => q(مربع ګر),
						'one' => q({0} مربع ګز),
						'other' => q({0} مربع ګز),
					},
					# Long Unit Identifier
					'concentr-item' => {
						'name' => q(توکي),
						'one' => q({0} توکی),
						'other' => q({0} توکی),
					},
					# Core Unit Identifier
					'item' => {
						'name' => q(توکي),
						'one' => q({0} توکی),
						'other' => q({0} توکی),
					},
					# Long Unit Identifier
					'concentr-karat' => {
						'name' => q(قيراط),
						'one' => q({0} قيراط),
						'other' => q({0} قيراط),
					},
					# Core Unit Identifier
					'karat' => {
						'name' => q(قيراط),
						'one' => q({0} قيراط),
						'other' => q({0} قيراط),
					},
					# Long Unit Identifier
					'concentr-milligram-ofglucose-per-deciliter' => {
						'name' => q(ملي ګرام في ډيسي ليټر),
						'one' => q({0} ملي ګرام في ډيسي ليټر),
						'other' => q({0} ملي ګرام في ډيسي ليټر),
					},
					# Core Unit Identifier
					'milligram-ofglucose-per-deciliter' => {
						'name' => q(ملي ګرام في ډيسي ليټر),
						'one' => q({0} ملي ګرام في ډيسي ليټر),
						'other' => q({0} ملي ګرام في ډيسي ليټر),
					},
					# Long Unit Identifier
					'concentr-millimole-per-liter' => {
						'name' => q(ملي مولز في ليټر),
						'one' => q({0} ملي مول في ليټر),
						'other' => q({0} ملي مول في ليټر),
					},
					# Core Unit Identifier
					'millimole-per-liter' => {
						'name' => q(ملي مولز في ليټر),
						'one' => q({0} ملي مول في ليټر),
						'other' => q({0} ملي مول في ليټر),
					},
					# Long Unit Identifier
					'concentr-mole' => {
						'name' => q(مولز),
						'one' => q({0} مول),
						'other' => q({0} مولز),
					},
					# Core Unit Identifier
					'mole' => {
						'name' => q(مولز),
						'one' => q({0} مول),
						'other' => q({0} مولز),
					},
					# Long Unit Identifier
					'concentr-percent' => {
						'name' => q(سلنه),
						'one' => q({0} سلنه),
						'other' => q({0} سلنه),
					},
					# Core Unit Identifier
					'percent' => {
						'name' => q(سلنه),
						'one' => q({0} سلنه),
						'other' => q({0} سلنه),
					},
					# Long Unit Identifier
					'concentr-permille' => {
						'name' => q(في ميل),
						'one' => q({0} في ميل),
						'other' => q({0} في ميل),
					},
					# Core Unit Identifier
					'permille' => {
						'name' => q(في ميل),
						'one' => q({0} في ميل),
						'other' => q({0} في ميل),
					},
					# Long Unit Identifier
					'concentr-permillion' => {
						'name' => q(پارټتس في مليون),
						'one' => q({0} پارټ في مليون),
						'other' => q({0} پارټس في مليون),
					},
					# Core Unit Identifier
					'permillion' => {
						'name' => q(پارټتس في مليون),
						'one' => q({0} پارټ في مليون),
						'other' => q({0} پارټس في مليون),
					},
					# Long Unit Identifier
					'concentr-permyriad' => {
						'name' => q(زرمه),
						'one' => q({0} زرمه),
						'other' => q({0} زرمه),
					},
					# Core Unit Identifier
					'permyriad' => {
						'name' => q(زرمه),
						'one' => q({0} زرمه),
						'other' => q({0} زرمه),
					},
					# Long Unit Identifier
					'consumption-liter-per-100-kilometer' => {
						'name' => q(ليټرز في ۱۰۰ کيلو مترز),
						'one' => q({0} ليټر في ۱۰۰ کلو ميترز),
						'other' => q({0} ليټرز في ۱۰۰ کيلو مترز),
					},
					# Core Unit Identifier
					'liter-per-100-kilometer' => {
						'name' => q(ليټرز في ۱۰۰ کيلو مترز),
						'one' => q({0} ليټر في ۱۰۰ کلو ميترز),
						'other' => q({0} ليټرز في ۱۰۰ کيلو مترز),
					},
					# Long Unit Identifier
					'consumption-liter-per-kilometer' => {
						'name' => q(ليټرز في کيلو متر),
						'one' => q({0} ليټر في کيلو متر),
						'other' => q({0} ليټرز في کيلو متر),
					},
					# Core Unit Identifier
					'liter-per-kilometer' => {
						'name' => q(ليټرز في کيلو متر),
						'one' => q({0} ليټر في کيلو متر),
						'other' => q({0} ليټرز في کيلو متر),
					},
					# Long Unit Identifier
					'consumption-mile-per-gallon' => {
						'name' => q(ميلز في ګيلن),
						'one' => q({0} ميل في ګيلن),
						'other' => q({0} ميلز في ګيلن),
					},
					# Core Unit Identifier
					'mile-per-gallon' => {
						'name' => q(ميلز في ګيلن),
						'one' => q({0} ميل في ګيلن),
						'other' => q({0} ميلز في ګيلن),
					},
					# Long Unit Identifier
					'consumption-mile-per-gallon-imperial' => {
						'name' => q(ميلز في ايمپيريل ګيلن),
						'one' => q({0} ميل في ايمپيريل ګيلن),
						'other' => q({0} ميلز في ايمپيريل ګيلن),
					},
					# Core Unit Identifier
					'mile-per-gallon-imperial' => {
						'name' => q(ميلز في ايمپيريل ګيلن),
						'one' => q({0} ميل في ايمپيريل ګيلن),
						'other' => q({0} ميلز في ايمپيريل ګيلن),
					},
					# Long Unit Identifier
					'coordinate' => {
						'east' => q({0} ختيځ),
						'north' => q({0} شمال),
						'south' => q({0} سويل),
						'west' => q({0} لوېديځ),
					},
					# Core Unit Identifier
					'coordinate' => {
						'east' => q({0} ختيځ),
						'north' => q({0} شمال),
						'south' => q({0} سويل),
						'west' => q({0} لوېديځ),
					},
					# Long Unit Identifier
					'digital-bit' => {
						'name' => q(بټس),
						'one' => q({0} بټ),
						'other' => q({0} بټس),
					},
					# Core Unit Identifier
					'bit' => {
						'name' => q(بټس),
						'one' => q({0} بټ),
						'other' => q({0} بټس),
					},
					# Long Unit Identifier
					'digital-byte' => {
						'name' => q(بايټس),
						'one' => q({0} بايټ),
						'other' => q({0} بايټس),
					},
					# Core Unit Identifier
					'byte' => {
						'name' => q(بايټس),
						'one' => q({0} بايټ),
						'other' => q({0} بايټس),
					},
					# Long Unit Identifier
					'digital-gigabit' => {
						'name' => q(ګيګا بټس),
						'one' => q({0} ګيګا بټ),
						'other' => q({0} ګيګا بټس),
					},
					# Core Unit Identifier
					'gigabit' => {
						'name' => q(ګيګا بټس),
						'one' => q({0} ګيګا بټ),
						'other' => q({0} ګيګا بټس),
					},
					# Long Unit Identifier
					'digital-gigabyte' => {
						'name' => q(ګيګا بايټس),
						'one' => q({0} ګيګا بايټس),
						'other' => q({0} ګيګا بايټس),
					},
					# Core Unit Identifier
					'gigabyte' => {
						'name' => q(ګيګا بايټس),
						'one' => q({0} ګيګا بايټس),
						'other' => q({0} ګيګا بايټس),
					},
					# Long Unit Identifier
					'digital-kilobit' => {
						'name' => q(کيلو بټس),
						'one' => q({0} کيلو بټ),
						'other' => q({0} کيلو بټس),
					},
					# Core Unit Identifier
					'kilobit' => {
						'name' => q(کيلو بټس),
						'one' => q({0} کيلو بټ),
						'other' => q({0} کيلو بټس),
					},
					# Long Unit Identifier
					'digital-kilobyte' => {
						'name' => q(کيلو بايټس),
						'one' => q({0} کيلو بايټ),
						'other' => q({0} کيلو بايټس),
					},
					# Core Unit Identifier
					'kilobyte' => {
						'name' => q(کيلو بايټس),
						'one' => q({0} کيلو بايټ),
						'other' => q({0} کيلو بايټس),
					},
					# Long Unit Identifier
					'digital-megabit' => {
						'name' => q(ميګا بټس),
						'one' => q({0} ميګا بټ),
						'other' => q({0} ميګا بټس),
					},
					# Core Unit Identifier
					'megabit' => {
						'name' => q(ميګا بټس),
						'one' => q({0} ميګا بټ),
						'other' => q({0} ميګا بټس),
					},
					# Long Unit Identifier
					'digital-megabyte' => {
						'name' => q(ميګا بايټس),
						'one' => q({0} ميګا بايټ),
						'other' => q({0} ميګا بايټس),
					},
					# Core Unit Identifier
					'megabyte' => {
						'name' => q(ميګا بايټس),
						'one' => q({0} ميګا بايټ),
						'other' => q({0} ميګا بايټس),
					},
					# Long Unit Identifier
					'digital-petabyte' => {
						'name' => q(پيټا بايټس),
						'one' => q({0} پيټا بايټ),
						'other' => q({0} پيټا بايټس),
					},
					# Core Unit Identifier
					'petabyte' => {
						'name' => q(پيټا بايټس),
						'one' => q({0} پيټا بايټ),
						'other' => q({0} پيټا بايټس),
					},
					# Long Unit Identifier
					'digital-terabit' => {
						'name' => q(ټرا بايټس),
						'one' => q({0} ټرا بايټ),
						'other' => q({0} ټرا بايټس),
					},
					# Core Unit Identifier
					'terabit' => {
						'name' => q(ټرا بايټس),
						'one' => q({0} ټرا بايټ),
						'other' => q({0} ټرا بايټس),
					},
					# Long Unit Identifier
					'digital-terabyte' => {
						'name' => q(ټيرا بايټس),
						'one' => q({0} ټيرا بايټ),
						'other' => q({0} ټيرا بايټس),
					},
					# Core Unit Identifier
					'terabyte' => {
						'name' => q(ټيرا بايټس),
						'one' => q({0} ټيرا بايټ),
						'other' => q({0} ټيرا بايټس),
					},
					# Long Unit Identifier
					'duration-century' => {
						'name' => q(پېړۍ),
						'one' => q({0} پېړۍ),
						'other' => q({0} پيړۍ),
					},
					# Core Unit Identifier
					'century' => {
						'name' => q(پېړۍ),
						'one' => q({0} پېړۍ),
						'other' => q({0} پيړۍ),
					},
					# Long Unit Identifier
					'duration-day' => {
						'name' => q(ورځې),
						'one' => q({0} ورځ),
						'other' => q({0} ورځې),
						'per' => q({0} په هره ورځ کې),
					},
					# Core Unit Identifier
					'day' => {
						'name' => q(ورځې),
						'one' => q({0} ورځ),
						'other' => q({0} ورځې),
						'per' => q({0} په هره ورځ کې),
					},
					# Long Unit Identifier
					'duration-decade' => {
						'name' => q(لسيزې),
						'one' => q({0} لسيزه),
						'other' => q({0} لسيزې),
					},
					# Core Unit Identifier
					'decade' => {
						'name' => q(لسيزې),
						'one' => q({0} لسيزه),
						'other' => q({0} لسيزې),
					},
					# Long Unit Identifier
					'duration-microsecond' => {
						'name' => q(مايکرو ثانيې),
						'one' => q({0} μs),
						'other' => q({0} μs),
					},
					# Core Unit Identifier
					'microsecond' => {
						'name' => q(مايکرو ثانيې),
						'one' => q({0} μs),
						'other' => q({0} μs),
					},
					# Long Unit Identifier
					'duration-minute' => {
						'name' => q(دقيقې),
					},
					# Core Unit Identifier
					'minute' => {
						'name' => q(دقيقې),
					},
					# Long Unit Identifier
					'duration-month' => {
						'name' => q(مياشتې),
						'one' => q({0} مياشت),
						'other' => q({0} مياشتې),
						'per' => q({0}/m),
					},
					# Core Unit Identifier
					'month' => {
						'name' => q(مياشتې),
						'one' => q({0} مياشت),
						'other' => q({0} مياشتې),
						'per' => q({0}/m),
					},
					# Long Unit Identifier
					'duration-nanosecond' => {
						'name' => q(نينو ثانيې),
						'one' => q({0} ns),
						'other' => q({0} ns),
					},
					# Core Unit Identifier
					'nanosecond' => {
						'name' => q(نينو ثانيې),
						'one' => q({0} ns),
						'other' => q({0} ns),
					},
					# Long Unit Identifier
					'duration-second' => {
						'name' => q(ثانيې),
					},
					# Core Unit Identifier
					'second' => {
						'name' => q(ثانيې),
					},
					# Long Unit Identifier
					'duration-week' => {
						'name' => q(اونۍ),
						'one' => q(اونۍ),
						'other' => q({0} اونۍ),
						'per' => q({0} په هره اونۍ کې),
					},
					# Core Unit Identifier
					'week' => {
						'name' => q(اونۍ),
						'one' => q(اونۍ),
						'other' => q({0} اونۍ),
						'per' => q({0} په هره اونۍ کې),
					},
					# Long Unit Identifier
					'duration-year' => {
						'name' => q(کالونه),
						'one' => q({0} کال),
						'other' => q({0} کالونه),
						'per' => q({0} په هر کال کې),
					},
					# Core Unit Identifier
					'year' => {
						'name' => q(کالونه),
						'one' => q({0} کال),
						'other' => q({0} کالونه),
						'per' => q({0} په هر کال کې),
					},
					# Long Unit Identifier
					'electric-ampere' => {
						'name' => q(ايمپيرز),
						'one' => q({0} ايمپير),
						'other' => q({0} ايمپيرز),
					},
					# Core Unit Identifier
					'ampere' => {
						'name' => q(ايمپيرز),
						'one' => q({0} ايمپير),
						'other' => q({0} ايمپيرز),
					},
					# Long Unit Identifier
					'electric-milliampere' => {
						'name' => q(ملي ايمپيرز),
						'one' => q({0} ملي ايمپير),
						'other' => q({0} ملي ايمپيرز),
					},
					# Core Unit Identifier
					'milliampere' => {
						'name' => q(ملي ايمپيرز),
						'one' => q({0} ملي ايمپير),
						'other' => q({0} ملي ايمپيرز),
					},
					# Long Unit Identifier
					'electric-ohm' => {
						'name' => q(اوهمز),
						'one' => q({0} اوهم),
						'other' => q({0} اوهمز),
					},
					# Core Unit Identifier
					'ohm' => {
						'name' => q(اوهمز),
						'one' => q({0} اوهم),
						'other' => q({0} اوهمز),
					},
					# Long Unit Identifier
					'electric-volt' => {
						'name' => q(وولټس),
						'one' => q({0} وولټ),
						'other' => q({0} وولټس),
					},
					# Core Unit Identifier
					'volt' => {
						'name' => q(وولټس),
						'one' => q({0} وولټ),
						'other' => q({0} وولټس),
					},
					# Long Unit Identifier
					'energy-british-thermal-unit' => {
						'name' => q(بريتانوي ترمل يونټس),
						'one' => q(برتانوي ترمل یونټ),
						'other' => q({0} برتانوي ترمل يونټس),
					},
					# Core Unit Identifier
					'british-thermal-unit' => {
						'name' => q(بريتانوي ترمل يونټس),
						'one' => q(برتانوي ترمل یونټ),
						'other' => q({0} برتانوي ترمل يونټس),
					},
					# Long Unit Identifier
					'energy-calorie' => {
						'name' => q(کيلريز),
						'one' => q({0} کيلري),
						'other' => q({0} کيلريز),
					},
					# Core Unit Identifier
					'calorie' => {
						'name' => q(کيلريز),
						'one' => q({0} کيلري),
						'other' => q({0} کيلريز),
					},
					# Long Unit Identifier
					'energy-electronvolt' => {
						'name' => q(اليکټران وولټس),
						'one' => q({0} اليکټران وولټ),
						'other' => q({0} اليکټران وولټس),
					},
					# Core Unit Identifier
					'electronvolt' => {
						'name' => q(اليکټران وولټس),
						'one' => q({0} اليکټران وولټ),
						'other' => q({0} اليکټران وولټس),
					},
					# Long Unit Identifier
					'energy-foodcalorie' => {
						'name' => q(کيلريز),
						'one' => q({0} کيلري),
						'other' => q({0} کيلريز),
					},
					# Core Unit Identifier
					'foodcalorie' => {
						'name' => q(کيلريز),
						'one' => q({0} کيلري),
						'other' => q({0} کيلريز),
					},
					# Long Unit Identifier
					'energy-joule' => {
						'name' => q(جولز),
						'one' => q({0} جول),
						'other' => q({0} جولز),
					},
					# Core Unit Identifier
					'joule' => {
						'name' => q(جولز),
						'one' => q({0} جول),
						'other' => q({0} جولز),
					},
					# Long Unit Identifier
					'energy-kilocalorie' => {
						'name' => q(کيلو کيلريز),
						'one' => q({0} کيلو کيلري),
						'other' => q({0} کيلو کيلريز),
					},
					# Core Unit Identifier
					'kilocalorie' => {
						'name' => q(کيلو کيلريز),
						'one' => q({0} کيلو کيلري),
						'other' => q({0} کيلو کيلريز),
					},
					# Long Unit Identifier
					'energy-kilojoule' => {
						'name' => q(کيلو جولز),
						'one' => q({0} کيلو جول),
						'other' => q({0} کيلو جولز),
					},
					# Core Unit Identifier
					'kilojoule' => {
						'name' => q(کيلو جولز),
						'one' => q({0} کيلو جول),
						'other' => q({0} کيلو جولز),
					},
					# Long Unit Identifier
					'energy-kilowatt-hour' => {
						'name' => q(کيلو واټ ساعته),
						'one' => q({0} کيلو واټ ساعت),
						'other' => q({0} کيلو واټ ساعته),
					},
					# Core Unit Identifier
					'kilowatt-hour' => {
						'name' => q(کيلو واټ ساعته),
						'one' => q({0} کيلو واټ ساعت),
						'other' => q({0} کيلو واټ ساعته),
					},
					# Long Unit Identifier
					'energy-therm-us' => {
						'name' => q(متحده ایالاتو ترمامونه),
					},
					# Core Unit Identifier
					'therm-us' => {
						'name' => q(متحده ایالاتو ترمامونه),
					},
					# Long Unit Identifier
					'force-newton' => {
						'name' => q(نيوټنز),
						'one' => q({0} نيوټن),
						'other' => q({0} نيوټنز),
					},
					# Core Unit Identifier
					'newton' => {
						'name' => q(نيوټنز),
						'one' => q({0} نيوټن),
						'other' => q({0} نيوټنز),
					},
					# Long Unit Identifier
					'force-pound-force' => {
						'name' => q(د قوې پاونډز),
						'one' => q({0} د قوې پاونډ),
						'other' => q({0} د قوې پاونډز),
					},
					# Core Unit Identifier
					'pound-force' => {
						'name' => q(د قوې پاونډز),
						'one' => q({0} د قوې پاونډ),
						'other' => q({0} د قوې پاونډز),
					},
					# Long Unit Identifier
					'frequency-gigahertz' => {
						'name' => q(ګيګا هرټز),
						'one' => q({0} ګيګا هرټز),
						'other' => q({0} ګيګا هرټز),
					},
					# Core Unit Identifier
					'gigahertz' => {
						'name' => q(ګيګا هرټز),
						'one' => q({0} ګيګا هرټز),
						'other' => q({0} ګيګا هرټز),
					},
					# Long Unit Identifier
					'frequency-hertz' => {
						'name' => q(هرټز),
						'one' => q({0} هرټز),
						'other' => q({0} هرټز),
					},
					# Core Unit Identifier
					'hertz' => {
						'name' => q(هرټز),
						'one' => q({0} هرټز),
						'other' => q({0} هرټز),
					},
					# Long Unit Identifier
					'frequency-kilohertz' => {
						'name' => q(کيلو هرټز),
						'one' => q({0} کيلو هرټز),
						'other' => q({0} کيلو هرټز),
					},
					# Core Unit Identifier
					'kilohertz' => {
						'name' => q(کيلو هرټز),
						'one' => q({0} کيلو هرټز),
						'other' => q({0} کيلو هرټز),
					},
					# Long Unit Identifier
					'frequency-megahertz' => {
						'name' => q(ميګا هرټز),
						'one' => q({0} ميګا هرټز),
						'other' => q({0} ميګا هرټز),
					},
					# Core Unit Identifier
					'megahertz' => {
						'name' => q(ميګا هرټز),
						'one' => q({0} ميګا هرټز),
						'other' => q({0} ميګا هرټز),
					},
					# Long Unit Identifier
					'graphics-em' => {
						'name' => q(ټايپو ګرافيک em),
					},
					# Core Unit Identifier
					'em' => {
						'name' => q(ټايپو ګرافيک em),
					},
					# Long Unit Identifier
					'graphics-megapixel' => {
						'name' => q(ميګا فکسلسز),
					},
					# Core Unit Identifier
					'megapixel' => {
						'name' => q(ميګا فکسلسز),
					},
					# Long Unit Identifier
					'length-astronomical-unit' => {
						'name' => q(فلکي احدې),
						'one' => q({0} فلکي احد),
						'other' => q({0} فلکي احدې),
					},
					# Core Unit Identifier
					'astronomical-unit' => {
						'name' => q(فلکي احدې),
						'one' => q({0} فلکي احد),
						'other' => q({0} فلکي احدې),
					},
					# Long Unit Identifier
					'length-centimeter' => {
						'name' => q(سنتي متره),
						'one' => q({0} سنتي متر),
						'other' => q({0} سنتي متره),
						'per' => q({0} هر سنتي متر),
					},
					# Core Unit Identifier
					'centimeter' => {
						'name' => q(سنتي متره),
						'one' => q({0} سنتي متر),
						'other' => q({0} سنتي متره),
						'per' => q({0} هر سنتي متر),
					},
					# Long Unit Identifier
					'length-decimeter' => {
						'name' => q(ډيسي متره),
						'one' => q({0} ډيسي متر),
						'other' => q({0} ډيسي متره),
					},
					# Core Unit Identifier
					'decimeter' => {
						'name' => q(ډيسي متره),
						'one' => q({0} ډيسي متر),
						'other' => q({0} ډيسي متره),
					},
					# Long Unit Identifier
					'length-fathom' => {
						'name' => q(فتومونه),
						'one' => q({0} fathom),
						'other' => q({0} فتومونه),
					},
					# Core Unit Identifier
					'fathom' => {
						'name' => q(فتومونه),
						'one' => q({0} fathom),
						'other' => q({0} فتومونه),
					},
					# Long Unit Identifier
					'length-foot' => {
						'name' => q(فټه),
						'one' => q({0} فټ),
						'other' => q({0} فټه),
						'per' => q({0}هر فټ),
					},
					# Core Unit Identifier
					'foot' => {
						'name' => q(فټه),
						'one' => q({0} فټ),
						'other' => q({0} فټه),
						'per' => q({0}هر فټ),
					},
					# Long Unit Identifier
					'length-furlong' => {
						'one' => q({0} fur),
						'other' => q({0} فرلانګونه),
					},
					# Core Unit Identifier
					'furlong' => {
						'one' => q({0} fur),
						'other' => q({0} فرلانګونه),
					},
					# Long Unit Identifier
					'length-inch' => {
						'name' => q(انچې),
						'one' => q({0} انچ),
						'other' => q({0} انچې),
						'per' => q({0} هر انچ),
					},
					# Core Unit Identifier
					'inch' => {
						'name' => q(انچې),
						'one' => q({0} انچ),
						'other' => q({0} انچې),
						'per' => q({0} هر انچ),
					},
					# Long Unit Identifier
					'length-kilometer' => {
						'name' => q(کيلو ميتره),
						'one' => q({0} کيلومتر),
						'other' => q({0} کيلومتره),
						'per' => q({0}هر کيلو ميتر),
					},
					# Core Unit Identifier
					'kilometer' => {
						'name' => q(کيلو ميتره),
						'one' => q({0} کيلومتر),
						'other' => q({0} کيلومتره),
						'per' => q({0}هر کيلو ميتر),
					},
					# Long Unit Identifier
					'length-light-year' => {
						'name' => q(نوري کالونه),
						'one' => q({0} نوري کال),
						'other' => q({0} نوري کالونه),
					},
					# Core Unit Identifier
					'light-year' => {
						'name' => q(نوري کالونه),
						'one' => q({0} نوري کال),
						'other' => q({0} نوري کالونه),
					},
					# Long Unit Identifier
					'length-meter' => {
						'name' => q(متره),
						'one' => q({0} متر),
						'other' => q({0} متره),
						'per' => q({0}هر متر),
					},
					# Core Unit Identifier
					'meter' => {
						'name' => q(متره),
						'one' => q({0} متر),
						'other' => q({0} متره),
						'per' => q({0}هر متر),
					},
					# Long Unit Identifier
					'length-micrometer' => {
						'name' => q(مايکرو متره),
						'one' => q({0} مايکرو متر),
						'other' => q({0} مايکرو متره),
					},
					# Core Unit Identifier
					'micrometer' => {
						'name' => q(مايکرو متره),
						'one' => q({0} مايکرو متر),
						'other' => q({0} مايکرو متره),
					},
					# Long Unit Identifier
					'length-mile' => {
						'name' => q(ميلونه),
						'one' => q({0} ميل),
						'other' => q({0} ميلونه),
					},
					# Core Unit Identifier
					'mile' => {
						'name' => q(ميلونه),
						'one' => q({0} ميل),
						'other' => q({0} ميلونه),
					},
					# Long Unit Identifier
					'length-mile-scandinavian' => {
						'name' => q(سکېنډنيوين ميل),
						'one' => q({0} سکېنډنيوين ميل),
						'other' => q({0} سکېنډنيوين ميلونه),
					},
					# Core Unit Identifier
					'mile-scandinavian' => {
						'name' => q(سکېنډنيوين ميل),
						'one' => q({0} سکېنډنيوين ميل),
						'other' => q({0} سکېنډنيوين ميلونه),
					},
					# Long Unit Identifier
					'length-millimeter' => {
						'name' => q(ملي متره),
						'one' => q({0} ملي متر),
						'other' => q({0} ملي متره),
					},
					# Core Unit Identifier
					'millimeter' => {
						'name' => q(ملي متره),
						'one' => q({0} ملي متر),
						'other' => q({0} ملي متره),
					},
					# Long Unit Identifier
					'length-nanometer' => {
						'name' => q(نينو متره),
						'one' => q({0} نينو متر),
						'other' => q({0} نينو متره),
					},
					# Core Unit Identifier
					'nanometer' => {
						'name' => q(نينو متره),
						'one' => q({0} نينو متر),
						'other' => q({0} نينو متره),
					},
					# Long Unit Identifier
					'length-nautical-mile' => {
						'name' => q(بحري ميلونه),
						'one' => q({0} بحري ميل),
						'other' => q({0} بحري ميلونه),
					},
					# Core Unit Identifier
					'nautical-mile' => {
						'name' => q(بحري ميلونه),
						'one' => q({0} بحري ميل),
						'other' => q({0} بحري ميلونه),
					},
					# Long Unit Identifier
					'length-parsec' => {
						'name' => q(پارسيکس),
						'one' => q({0} في ثانيه),
						'other' => q({0} في ثانيې),
					},
					# Core Unit Identifier
					'parsec' => {
						'name' => q(پارسيکس),
						'one' => q({0} في ثانيه),
						'other' => q({0} في ثانيې),
					},
					# Long Unit Identifier
					'length-picometer' => {
						'name' => q(پيکو متره),
						'one' => q({0} پيکو متر),
						'other' => q({0} پيکو متره),
					},
					# Core Unit Identifier
					'picometer' => {
						'name' => q(پيکو متره),
						'one' => q({0} پيکو متر),
						'other' => q({0} پيکو متره),
					},
					# Long Unit Identifier
					'length-point' => {
						'name' => q(نمرې),
						'one' => q({0} نمره),
						'other' => q({0} نمرې),
					},
					# Core Unit Identifier
					'point' => {
						'name' => q(نمرې),
						'one' => q({0} نمره),
						'other' => q({0} نمرې),
					},
					# Long Unit Identifier
					'length-solar-radius' => {
						'name' => q(لمريزې وړانګې),
						'one' => q({0} لمريزه وړانګه),
						'other' => q({0} لمريزې وړانګې),
					},
					# Core Unit Identifier
					'solar-radius' => {
						'name' => q(لمريزې وړانګې),
						'one' => q({0} لمريزه وړانګه),
						'other' => q({0} لمريزې وړانګې),
					},
					# Long Unit Identifier
					'length-yard' => {
						'name' => q(ګز),
						'one' => q({0} ګز),
						'other' => q({0} ګزه),
					},
					# Core Unit Identifier
					'yard' => {
						'name' => q(ګز),
						'one' => q({0} ګز),
						'other' => q({0} ګزه),
					},
					# Long Unit Identifier
					'light-lux' => {
						'name' => q(لکس),
					},
					# Core Unit Identifier
					'lux' => {
						'name' => q(لکس),
					},
					# Long Unit Identifier
					'light-solar-luminosity' => {
						'name' => q(لمريز ځلښتونه),
						'one' => q({0} لمريز ځلښت),
						'other' => q({0} لمريز ځلښتونه),
					},
					# Core Unit Identifier
					'solar-luminosity' => {
						'name' => q(لمريز ځلښتونه),
						'one' => q({0} لمريز ځلښت),
						'other' => q({0} لمريز ځلښتونه),
					},
					# Long Unit Identifier
					'mass-carat' => {
						'name' => q(قيراط),
						'one' => q({0} قيراط),
						'other' => q({0} قيراط),
					},
					# Core Unit Identifier
					'carat' => {
						'name' => q(قيراط),
						'one' => q({0} قيراط),
						'other' => q({0} قيراط),
					},
					# Long Unit Identifier
					'mass-dalton' => {
						'name' => q(ډالټنز),
						'one' => q({0} ډالټن),
						'other' => q({0} ډالټنز),
					},
					# Core Unit Identifier
					'dalton' => {
						'name' => q(ډالټنز),
						'one' => q({0} ډالټن),
						'other' => q({0} ډالټنز),
					},
					# Long Unit Identifier
					'mass-earth-mass' => {
						'name' => q(د زمکې حجم),
						'one' => q({0} د زمکې حجم),
						'other' => q({0} د زمکې حجمونه),
					},
					# Core Unit Identifier
					'earth-mass' => {
						'name' => q(د زمکې حجم),
						'one' => q({0} د زمکې حجم),
						'other' => q({0} د زمکې حجمونه),
					},
					# Long Unit Identifier
					'mass-gram' => {
						'name' => q(ګرامز),
						'one' => q({0} ګرام),
						'other' => q({0} ګرامز),
						'per' => q({0} في ګرام),
					},
					# Core Unit Identifier
					'gram' => {
						'name' => q(ګرامز),
						'one' => q({0} ګرام),
						'other' => q({0} ګرامز),
						'per' => q({0} في ګرام),
					},
					# Long Unit Identifier
					'mass-kilogram' => {
						'name' => q(کيلو ګرامز),
						'one' => q({0} کيلو ګرام),
						'other' => q({0} کيلو ګرامز),
						'per' => q({0} في کيلو ګرام),
					},
					# Core Unit Identifier
					'kilogram' => {
						'name' => q(کيلو ګرامز),
						'one' => q({0} کيلو ګرام),
						'other' => q({0} کيلو ګرامز),
						'per' => q({0} في کيلو ګرام),
					},
					# Long Unit Identifier
					'mass-metric-ton' => {
						'name' => q(ميټرک ټنز),
						'one' => q({0} ميټرک ټن),
						'other' => q({0} ميټرک ټنز),
					},
					# Core Unit Identifier
					'metric-ton' => {
						'name' => q(ميټرک ټنز),
						'one' => q({0} ميټرک ټن),
						'other' => q({0} ميټرک ټنز),
					},
					# Long Unit Identifier
					'mass-microgram' => {
						'name' => q(مايکرو ګرامز),
						'one' => q({0} مايکرو ګرام),
						'other' => q({0} مايکرو ګرامز),
					},
					# Core Unit Identifier
					'microgram' => {
						'name' => q(مايکرو ګرامز),
						'one' => q({0} مايکرو ګرام),
						'other' => q({0} مايکرو ګرامز),
					},
					# Long Unit Identifier
					'mass-milligram' => {
						'name' => q(ملي ګرامز),
						'one' => q({0} ملي ګرام),
						'other' => q({0} ملي ګرامز),
					},
					# Core Unit Identifier
					'milligram' => {
						'name' => q(ملي ګرامز),
						'one' => q({0} ملي ګرام),
						'other' => q({0} ملي ګرامز),
					},
					# Long Unit Identifier
					'mass-ounce' => {
						'name' => q(اونسز),
						'one' => q({0} اونس),
						'other' => q({0} اونسز),
						'per' => q({0} في اونس),
					},
					# Core Unit Identifier
					'ounce' => {
						'name' => q(اونسز),
						'one' => q({0} اونس),
						'other' => q({0} اونسز),
						'per' => q({0} في اونس),
					},
					# Long Unit Identifier
					'mass-ounce-troy' => {
						'name' => q(ټراي اونسز),
						'one' => q({0} ټرای اونس),
						'other' => q({0} ټرای اونسز),
					},
					# Core Unit Identifier
					'ounce-troy' => {
						'name' => q(ټراي اونسز),
						'one' => q({0} ټرای اونس),
						'other' => q({0} ټرای اونسز),
					},
					# Long Unit Identifier
					'mass-pound' => {
						'name' => q(پاونډز),
						'one' => q({0} پاونډ),
						'other' => q({0} پاونډز),
						'per' => q({0} في پاونډ),
					},
					# Core Unit Identifier
					'pound' => {
						'name' => q(پاونډز),
						'one' => q({0} پاونډ),
						'other' => q({0} پاونډز),
						'per' => q({0} في پاونډ),
					},
					# Long Unit Identifier
					'mass-solar-mass' => {
						'name' => q(لمريز حجم),
						'one' => q({0} لمريز حجم),
						'other' => q({0} لمريز حجم),
					},
					# Core Unit Identifier
					'solar-mass' => {
						'name' => q(لمريز حجم),
						'one' => q({0} لمريز حجم),
						'other' => q({0} لمريز حجم),
					},
					# Long Unit Identifier
					'mass-ton' => {
						'name' => q(ټنز),
						'one' => q({0} ټن),
						'other' => q({0} ټنز),
					},
					# Core Unit Identifier
					'ton' => {
						'name' => q(ټنز),
						'one' => q({0} ټن),
						'other' => q({0} ټنز),
					},
					# Long Unit Identifier
					'per' => {
						'1' => q({0}في {1}),
					},
					# Core Unit Identifier
					'per' => {
						'1' => q({0}في {1}),
					},
					# Long Unit Identifier
					'power-gigawatt' => {
						'name' => q(ګيګا واټس),
						'one' => q({0} ګيګا واټ),
						'other' => q({0} ګيګا واټس),
					},
					# Core Unit Identifier
					'gigawatt' => {
						'name' => q(ګيګا واټس),
						'one' => q({0} ګيګا واټ),
						'other' => q({0} ګيګا واټس),
					},
					# Long Unit Identifier
					'power-horsepower' => {
						'name' => q(هارس پاور),
						'one' => q({0} هارس پاور),
						'other' => q({0} هارس پاور),
					},
					# Core Unit Identifier
					'horsepower' => {
						'name' => q(هارس پاور),
						'one' => q({0} هارس پاور),
						'other' => q({0} هارس پاور),
					},
					# Long Unit Identifier
					'power-kilowatt' => {
						'name' => q(کيلو واټس),
						'one' => q({0} کيلو واټ),
						'other' => q({0} کيلو واټس),
					},
					# Core Unit Identifier
					'kilowatt' => {
						'name' => q(کيلو واټس),
						'one' => q({0} کيلو واټ),
						'other' => q({0} کيلو واټس),
					},
					# Long Unit Identifier
					'power-megawatt' => {
						'name' => q(ميګا واټس),
						'one' => q({0} ميګا واټ),
						'other' => q({0} ميګا واټس),
					},
					# Core Unit Identifier
					'megawatt' => {
						'name' => q(ميګا واټس),
						'one' => q({0} ميګا واټ),
						'other' => q({0} ميګا واټس),
					},
					# Long Unit Identifier
					'power-milliwatt' => {
						'name' => q(ملي واټس),
						'one' => q({0} ملي واټ),
						'other' => q({0} ملي واټس),
					},
					# Core Unit Identifier
					'milliwatt' => {
						'name' => q(ملي واټس),
						'one' => q({0} ملي واټ),
						'other' => q({0} ملي واټس),
					},
					# Long Unit Identifier
					'power-watt' => {
						'name' => q(واټس),
						'one' => q({0} واټ),
						'other' => q({0} واټس),
					},
					# Core Unit Identifier
					'watt' => {
						'name' => q(واټس),
						'one' => q({0} واټ),
						'other' => q({0} واټس),
					},
					# Long Unit Identifier
					'power2' => {
						'one' => q({0}مربع),
						'other' => q({0} مربع),
					},
					# Core Unit Identifier
					'power2' => {
						'one' => q({0}مربع),
						'other' => q({0} مربع),
					},
					# Long Unit Identifier
					'power3' => {
						'one' => q(کیوبک {0}),
						'other' => q({0}معکب),
					},
					# Core Unit Identifier
					'power3' => {
						'one' => q(کیوبک {0}),
						'other' => q({0}معکب),
					},
					# Long Unit Identifier
					'pressure-atmosphere' => {
						'name' => q(اټموسپیرز),
						'one' => q({0} اتموسپير),
						'other' => q({0} اتموسپيرز),
					},
					# Core Unit Identifier
					'atmosphere' => {
						'name' => q(اټموسپیرز),
						'one' => q({0} اتموسپير),
						'other' => q({0} اتموسپيرز),
					},
					# Long Unit Identifier
					'pressure-hectopascal' => {
						'name' => q(هيکټو پاسکیلز),
						'one' => q({0} هيکټو پاسکیل),
						'other' => q({0} هيکټو پاسکیلز),
					},
					# Core Unit Identifier
					'hectopascal' => {
						'name' => q(هيکټو پاسکیلز),
						'one' => q({0} هيکټو پاسکیل),
						'other' => q({0} هيکټو پاسکیلز),
					},
					# Long Unit Identifier
					'pressure-inch-ofhg' => {
						'name' => q(د پارې انچې),
						'one' => q({0} د پارې انچ),
						'other' => q({0} د پارې انچې),
					},
					# Core Unit Identifier
					'inch-ofhg' => {
						'name' => q(د پارې انچې),
						'one' => q({0} د پارې انچ),
						'other' => q({0} د پارې انچې),
					},
					# Long Unit Identifier
					'pressure-kilopascal' => {
						'name' => q(کيلو پاسکیلز),
						'one' => q({0} کيلو پاسکیل),
						'other' => q({0} کيلو پاسکیلز),
					},
					# Core Unit Identifier
					'kilopascal' => {
						'name' => q(کيلو پاسکیلز),
						'one' => q({0} کيلو پاسکیل),
						'other' => q({0} کيلو پاسکیلز),
					},
					# Long Unit Identifier
					'pressure-megapascal' => {
						'name' => q(ميګا پاسکلیلز),
						'one' => q({0} ميګا پاسکیل),
						'other' => q({0} ميګا پاسکیلز),
					},
					# Core Unit Identifier
					'megapascal' => {
						'name' => q(ميګا پاسکلیلز),
						'one' => q({0} ميګا پاسکیل),
						'other' => q({0} ميګا پاسکیلز),
					},
					# Long Unit Identifier
					'pressure-millibar' => {
						'name' => q(ملي بارز),
						'one' => q({0} ملي بار),
						'other' => q({0} ملي بارز),
					},
					# Core Unit Identifier
					'millibar' => {
						'name' => q(ملي بارز),
						'one' => q({0} ملي بار),
						'other' => q({0} ملي بارز),
					},
					# Long Unit Identifier
					'pressure-millimeter-ofhg' => {
						'name' => q(د پارې ملي مترز),
						'one' => q({0} د پارې ملي متر),
						'other' => q({0} د پارې ملي مترز),
					},
					# Core Unit Identifier
					'millimeter-ofhg' => {
						'name' => q(د پارې ملي مترز),
						'one' => q({0} د پارې ملي متر),
						'other' => q({0} د پارې ملي مترز),
					},
					# Long Unit Identifier
					'pressure-pascal' => {
						'name' => q(پاسکیلز),
					},
					# Core Unit Identifier
					'pascal' => {
						'name' => q(پاسکیلز),
					},
					# Long Unit Identifier
					'pressure-pound-force-per-square-inch' => {
						'one' => q({0} پاونډ في مربع انچ),
						'other' => q({0} پاونډز في مربع انچ),
					},
					# Core Unit Identifier
					'pound-force-per-square-inch' => {
						'one' => q({0} پاونډ في مربع انچ),
						'other' => q({0} پاونډز في مربع انچ),
					},
					# Long Unit Identifier
					'speed-kilometer-per-hour' => {
						'name' => q(کيلو متر في ساعت),
						'one' => q({0} کيلو متر في ساعت),
						'other' => q({0} کيلو متر في ساعت),
					},
					# Core Unit Identifier
					'kilometer-per-hour' => {
						'name' => q(کيلو متر في ساعت),
						'one' => q({0} کيلو متر في ساعت),
						'other' => q({0} کيلو متر في ساعت),
					},
					# Long Unit Identifier
					'speed-knot' => {
						'name' => q(ناټس),
						'one' => q({0} ناټ),
						'other' => q({0} ناټس),
					},
					# Core Unit Identifier
					'knot' => {
						'name' => q(ناټس),
						'one' => q({0} ناټ),
						'other' => q({0} ناټس),
					},
					# Long Unit Identifier
					'speed-meter-per-second' => {
						'name' => q(متر في ثانيه),
						'one' => q({0} متر في ثانيه),
						'other' => q({0} متر في ثانيه),
					},
					# Core Unit Identifier
					'meter-per-second' => {
						'name' => q(متر في ثانيه),
						'one' => q({0} متر في ثانيه),
						'other' => q({0} متر في ثانيه),
					},
					# Long Unit Identifier
					'speed-mile-per-hour' => {
						'name' => q(ميل في ساعت),
						'one' => q({0} ميل في ساعت),
						'other' => q({0} ميل في ساعت),
					},
					# Core Unit Identifier
					'mile-per-hour' => {
						'name' => q(ميل في ساعت),
						'one' => q({0} ميل في ساعت),
						'other' => q({0} ميل في ساعت),
					},
					# Long Unit Identifier
					'temperature-celsius' => {
						'name' => q(درجې سيلسيس),
						'one' => q({0} درجې سيلسيس),
						'other' => q({0} درجې سيلسيس),
					},
					# Core Unit Identifier
					'celsius' => {
						'name' => q(درجې سيلسيس),
						'one' => q({0} درجې سيلسيس),
						'other' => q({0} درجې سيلسيس),
					},
					# Long Unit Identifier
					'temperature-fahrenheit' => {
						'name' => q(درجې فارنهايټ),
						'one' => q({0} درجې فارنهايټ),
						'other' => q({0} درجې فارنهايټ),
					},
					# Core Unit Identifier
					'fahrenheit' => {
						'name' => q(درجې فارنهايټ),
						'one' => q({0} درجې فارنهايټ),
						'other' => q({0} درجې فارنهايټ),
					},
					# Long Unit Identifier
					'temperature-generic' => {
						'name' => q(°),
					},
					# Core Unit Identifier
					'generic' => {
						'name' => q(°),
					},
					# Long Unit Identifier
					'temperature-kelvin' => {
						'name' => q(کيلونز),
						'one' => q({0} کيلون),
						'other' => q({0} کيلونز),
					},
					# Core Unit Identifier
					'kelvin' => {
						'name' => q(کيلونز),
						'one' => q({0} کيلون),
						'other' => q({0} کيلونز),
					},
					# Long Unit Identifier
					'torque-newton-meter' => {
						'name' => q(نيوټن ميټرز),
						'one' => q({0} نيوټن ميټر),
						'other' => q({0} نيوټن ميټرز),
					},
					# Core Unit Identifier
					'newton-meter' => {
						'name' => q(نيوټن ميټرز),
						'one' => q({0} نيوټن ميټر),
						'other' => q({0} نيوټن ميټرز),
					},
					# Long Unit Identifier
					'torque-pound-force-foot' => {
						'name' => q(پاونډ فټونه),
						'one' => q({0} پاونډ فټ),
						'other' => q({0} پاونډ فټونه),
					},
					# Core Unit Identifier
					'pound-force-foot' => {
						'name' => q(پاونډ فټونه),
						'one' => q({0} پاونډ فټ),
						'other' => q({0} پاونډ فټونه),
					},
					# Long Unit Identifier
					'volume-acre-foot' => {
						'name' => q(اکړ فټ),
						'one' => q({0} اکړ فټ),
						'other' => q({0} اکړ فټ),
					},
					# Core Unit Identifier
					'acre-foot' => {
						'name' => q(اکړ فټ),
						'one' => q({0} اکړ فټ),
						'other' => q({0} اکړ فټ),
					},
					# Long Unit Identifier
					'volume-barrel' => {
						'name' => q(بيرلز),
						'one' => q({0} بېرل),
						'other' => q({0} بېرلز),
					},
					# Core Unit Identifier
					'barrel' => {
						'name' => q(بيرلز),
						'one' => q({0} بېرل),
						'other' => q({0} بېرلز),
					},
					# Long Unit Identifier
					'volume-bushel' => {
						'one' => q({0} bu),
						'other' => q({0} بوشیل),
					},
					# Core Unit Identifier
					'bushel' => {
						'one' => q({0} bu),
						'other' => q({0} بوشیل),
					},
					# Long Unit Identifier
					'volume-centiliter' => {
						'name' => q(سنټي ليټرز),
						'one' => q({0} سنټي ليټر),
						'other' => q({0} سنټي ليټرز),
					},
					# Core Unit Identifier
					'centiliter' => {
						'name' => q(سنټي ليټرز),
						'one' => q({0} سنټي ليټر),
						'other' => q({0} سنټي ليټرز),
					},
					# Long Unit Identifier
					'volume-cubic-centimeter' => {
						'name' => q(مکعب سنتي متر),
						'one' => q({0} مکعب سنتي متر),
						'other' => q({0} مکعب سنتي متر),
						'per' => q({0} في مکعب سنتي متر),
					},
					# Core Unit Identifier
					'cubic-centimeter' => {
						'name' => q(مکعب سنتي متر),
						'one' => q({0} مکعب سنتي متر),
						'other' => q({0} مکعب سنتي متر),
						'per' => q({0} في مکعب سنتي متر),
					},
					# Long Unit Identifier
					'volume-cubic-foot' => {
						'name' => q(مکعب فټ),
						'one' => q({0} مکعب فټ),
						'other' => q({0} مکعب فټ),
					},
					# Core Unit Identifier
					'cubic-foot' => {
						'name' => q(مکعب فټ),
						'one' => q({0} مکعب فټ),
						'other' => q({0} مکعب فټ),
					},
					# Long Unit Identifier
					'volume-cubic-inch' => {
						'name' => q(مکعب انچ),
						'one' => q({0} مکعب انچ),
						'other' => q({0} مکعب انچ),
					},
					# Core Unit Identifier
					'cubic-inch' => {
						'name' => q(مکعب انچ),
						'one' => q({0} مکعب انچ),
						'other' => q({0} مکعب انچ),
					},
					# Long Unit Identifier
					'volume-cubic-kilometer' => {
						'name' => q(مکعب کيلو متر),
						'one' => q(مکعب کيلو متر),
						'other' => q({0} مکعب کيلو متر),
					},
					# Core Unit Identifier
					'cubic-kilometer' => {
						'name' => q(مکعب کيلو متر),
						'one' => q(مکعب کيلو متر),
						'other' => q({0} مکعب کيلو متر),
					},
					# Long Unit Identifier
					'volume-cubic-meter' => {
						'name' => q(مکعب متر),
						'one' => q({0} مکعب متر),
						'other' => q({0} مکعب متر),
						'per' => q({0} في مکعب متر),
					},
					# Core Unit Identifier
					'cubic-meter' => {
						'name' => q(مکعب متر),
						'one' => q({0} مکعب متر),
						'other' => q({0} مکعب متر),
						'per' => q({0} في مکعب متر),
					},
					# Long Unit Identifier
					'volume-cubic-mile' => {
						'name' => q(مکعب ميل),
						'one' => q({0} مکعب ميل),
						'other' => q({0} مکعب ميل),
					},
					# Core Unit Identifier
					'cubic-mile' => {
						'name' => q(مکعب ميل),
						'one' => q({0} مکعب ميل),
						'other' => q({0} مکعب ميل),
					},
					# Long Unit Identifier
					'volume-cubic-yard' => {
						'name' => q(مکعب ګز),
						'one' => q({0} مکعب ګز),
						'other' => q({0} مکعب ګز),
					},
					# Core Unit Identifier
					'cubic-yard' => {
						'name' => q(مکعب ګز),
						'one' => q({0} مکعب ګز),
						'other' => q({0} مکعب ګز),
					},
					# Long Unit Identifier
					'volume-cup' => {
						'name' => q(پيالې),
						'one' => q({0} پياله),
						'other' => q({0} پيالې),
					},
					# Core Unit Identifier
					'cup' => {
						'name' => q(پيالې),
						'one' => q({0} پياله),
						'other' => q({0} پيالې),
					},
					# Long Unit Identifier
					'volume-deciliter' => {
						'name' => q(ډيسي ليټرز),
						'one' => q({0} ډيسي ليټر),
						'other' => q({0} ډيسي ليټرز),
					},
					# Core Unit Identifier
					'deciliter' => {
						'name' => q(ډيسي ليټرز),
						'one' => q({0} ډيسي ليټر),
						'other' => q({0} ډيسي ليټرز),
					},
					# Long Unit Identifier
					'volume-dessert-spoon' => {
						'name' => q(مچ چمچ),
						'one' => q({0} dessert spoon),
						'other' => q({0} مچ چمچ),
					},
					# Core Unit Identifier
					'dessert-spoon' => {
						'name' => q(مچ چمچ),
						'one' => q({0} dessert spoon),
						'other' => q({0} مچ چمچ),
					},
					# Long Unit Identifier
					'volume-dram' => {
						'name' => q(ډرام),
						'one' => q({0} ډرام),
						'other' => q({0} ډرام),
					},
					# Core Unit Identifier
					'dram' => {
						'name' => q(ډرام),
						'one' => q({0} ډرام),
						'other' => q({0} ډرام),
					},
					# Long Unit Identifier
					'volume-drop' => {
						'one' => q({0} څاڅک),
						'other' => q({0} څاڅک),
					},
					# Core Unit Identifier
					'drop' => {
						'one' => q({0} څاڅک),
						'other' => q({0} څاڅک),
					},
					# Long Unit Identifier
					'volume-fluid-ounce-imperial' => {
						'name' => q(امپيريل مايع اونس),
						'one' => q({0} امپيريل مايع اونس),
						'other' => q({0} امپيريل مايع اونس),
					},
					# Core Unit Identifier
					'fluid-ounce-imperial' => {
						'name' => q(امپيريل مايع اونس),
						'one' => q({0} امپيريل مايع اونس),
						'other' => q({0} امپيريل مايع اونس),
					},
					# Long Unit Identifier
					'volume-gallon' => {
						'name' => q(ګيلنز),
						'one' => q({0} ګيلن),
						'other' => q({0} ګيلنز),
						'per' => q({0} في ګيلن),
					},
					# Core Unit Identifier
					'gallon' => {
						'name' => q(ګيلنز),
						'one' => q({0} ګيلن),
						'other' => q({0} ګيلنز),
						'per' => q({0} في ګيلن),
					},
					# Long Unit Identifier
					'volume-hectoliter' => {
						'name' => q(هيکټو ليټرز),
						'one' => q({0} هيکټو ليټر),
						'other' => q({0} هيکټو ليټرز),
					},
					# Core Unit Identifier
					'hectoliter' => {
						'name' => q(هيکټو ليټرز),
						'one' => q({0} هيکټو ليټر),
						'other' => q({0} هيکټو ليټرز),
					},
					# Long Unit Identifier
					'volume-liter' => {
						'name' => q(ليټرز),
						'one' => q({0} ليټر),
						'other' => q({0} ليټرز),
						'per' => q({0} في ليټر),
					},
					# Core Unit Identifier
					'liter' => {
						'name' => q(ليټرز),
						'one' => q({0} ليټر),
						'other' => q({0} ليټرز),
						'per' => q({0} في ليټر),
					},
					# Long Unit Identifier
					'volume-megaliter' => {
						'name' => q(ميګا ليټرز),
						'one' => q({0} ميګا ليټر),
						'other' => q({0} ميګا ليټرز),
					},
					# Core Unit Identifier
					'megaliter' => {
						'name' => q(ميګا ليټرز),
						'one' => q({0} ميګا ليټر),
						'other' => q({0} ميګا ليټرز),
					},
					# Long Unit Identifier
					'volume-milliliter' => {
						'name' => q(ملي ليټرز),
						'one' => q({0} ملي ليټر),
						'other' => q({0} ملي ليټرز),
					},
					# Core Unit Identifier
					'milliliter' => {
						'name' => q(ملي ليټرز),
						'one' => q({0} ملي ليټر),
						'other' => q({0} ملي ليټرز),
					},
					# Long Unit Identifier
					'volume-pinch' => {
						'name' => q(چنه),
						'one' => q({0} چنه),
						'other' => q({0} چنه),
					},
					# Core Unit Identifier
					'pinch' => {
						'name' => q(چنه),
						'one' => q({0} چنه),
						'other' => q({0} چنه),
					},
					# Long Unit Identifier
					'volume-quart' => {
						'name' => q(څلورمه),
						'one' => q({0} څلورمه),
						'other' => q({0} څلورمه),
					},
					# Core Unit Identifier
					'quart' => {
						'name' => q(څلورمه),
						'one' => q({0} څلورمه),
						'other' => q({0} څلورمه),
					},
					# Long Unit Identifier
					'volume-quart-imperial' => {
						'one' => q({0} Imp. quart),
						'other' => q({0} Imp. quart),
					},
					# Core Unit Identifier
					'quart-imperial' => {
						'one' => q({0} Imp. quart),
						'other' => q({0} Imp. quart),
					},
					# Long Unit Identifier
					'volume-tablespoon' => {
						'name' => q(د ميز کاچوغه),
					},
					# Core Unit Identifier
					'tablespoon' => {
						'name' => q(د ميز کاچوغه),
					},
					# Long Unit Identifier
					'volume-teaspoon' => {
						'name' => q(د ميز کاچوغې),
						'one' => q({0} د ميز کاچوغه),
						'other' => q({0} د ميز کاچوغې),
					},
					# Core Unit Identifier
					'teaspoon' => {
						'name' => q(د ميز کاچوغې),
						'one' => q({0} د ميز کاچوغه),
						'other' => q({0} د ميز کاچوغې),
					},
				},
				'narrow' => {
					# Long Unit Identifier
					'' => {
						'name' => q(اړخ),
					},
					# Core Unit Identifier
					'' => {
						'name' => q(اړخ),
					},
					# Long Unit Identifier
					'10p-1' => {
						'1' => q(d{0}),
					},
					# Core Unit Identifier
					'1' => {
						'1' => q(d{0}),
					},
					# Long Unit Identifier
					'10p-12' => {
						'1' => q(p{0}),
					},
					# Core Unit Identifier
					'12' => {
						'1' => q(p{0}),
					},
					# Long Unit Identifier
					'10p-15' => {
						'1' => q(f{0}),
					},
					# Core Unit Identifier
					'15' => {
						'1' => q(f{0}),
					},
					# Long Unit Identifier
					'10p-18' => {
						'1' => q(a{0}),
					},
					# Core Unit Identifier
					'18' => {
						'1' => q(a{0}),
					},
					# Long Unit Identifier
					'10p-2' => {
						'1' => q(c{0}),
					},
					# Core Unit Identifier
					'2' => {
						'1' => q(c{0}),
					},
					# Long Unit Identifier
					'10p-21' => {
						'1' => q(z{0}),
					},
					# Core Unit Identifier
					'21' => {
						'1' => q(z{0}),
					},
					# Long Unit Identifier
					'10p-24' => {
						'1' => q(y{0}),
					},
					# Core Unit Identifier
					'24' => {
						'1' => q(y{0}),
					},
					# Long Unit Identifier
					'10p-3' => {
						'1' => q(m{0}),
					},
					# Core Unit Identifier
					'3' => {
						'1' => q(m{0}),
					},
					# Long Unit Identifier
					'10p-6' => {
						'1' => q(μ{0}),
					},
					# Core Unit Identifier
					'6' => {
						'1' => q(μ{0}),
					},
					# Long Unit Identifier
					'10p-9' => {
						'1' => q(n{0}),
					},
					# Core Unit Identifier
					'9' => {
						'1' => q(n{0}),
					},
					# Long Unit Identifier
					'10p1' => {
						'1' => q(da{0}),
					},
					# Core Unit Identifier
					'10p1' => {
						'1' => q(da{0}),
					},
					# Long Unit Identifier
					'10p12' => {
						'1' => q(T{0}),
					},
					# Core Unit Identifier
					'10p12' => {
						'1' => q(T{0}),
					},
					# Long Unit Identifier
					'10p15' => {
						'1' => q(P{0}),
					},
					# Core Unit Identifier
					'10p15' => {
						'1' => q(P{0}),
					},
					# Long Unit Identifier
					'10p18' => {
						'1' => q(E{0}),
					},
					# Core Unit Identifier
					'10p18' => {
						'1' => q(E{0}),
					},
					# Long Unit Identifier
					'10p2' => {
						'1' => q(h{0}),
					},
					# Core Unit Identifier
					'10p2' => {
						'1' => q(h{0}),
					},
					# Long Unit Identifier
					'10p21' => {
						'1' => q(Z{0}),
					},
					# Core Unit Identifier
					'10p21' => {
						'1' => q(Z{0}),
					},
					# Long Unit Identifier
					'10p24' => {
						'1' => q(Y{0}),
					},
					# Core Unit Identifier
					'10p24' => {
						'1' => q(Y{0}),
					},
					# Long Unit Identifier
					'10p3' => {
						'1' => q(k{0}),
					},
					# Core Unit Identifier
					'10p3' => {
						'1' => q(k{0}),
					},
					# Long Unit Identifier
					'10p6' => {
						'1' => q(M{0}),
					},
					# Core Unit Identifier
					'10p6' => {
						'1' => q(M{0}),
					},
					# Long Unit Identifier
					'10p9' => {
						'1' => q(G{0}),
					},
					# Core Unit Identifier
					'10p9' => {
						'1' => q(G{0}),
					},
					# Long Unit Identifier
					'concentr-item' => {
						'name' => q(توکی),
						'one' => q({0} توکی),
						'other' => q({0} توکی),
					},
					# Core Unit Identifier
					'item' => {
						'name' => q(توکی),
						'one' => q({0} توکی),
						'other' => q({0} توکی),
					},
					# Long Unit Identifier
					'concentr-percent' => {
						'name' => q(سلنه),
						'one' => q({0}%),
						'other' => q({0}%),
					},
					# Core Unit Identifier
					'percent' => {
						'name' => q(سلنه),
						'one' => q({0}%),
						'other' => q({0}%),
					},
					# Long Unit Identifier
					'consumption-liter-per-100-kilometer' => {
						'name' => q(L/100km),
						'one' => q({0} L/100km),
						'other' => q({0} L/100km),
					},
					# Core Unit Identifier
					'liter-per-100-kilometer' => {
						'name' => q(L/100km),
						'one' => q({0} L/100km),
						'other' => q({0} L/100km),
					},
					# Long Unit Identifier
					'consumption-mile-per-gallon-imperial' => {
						'name' => q(mpg UK),
					},
					# Core Unit Identifier
					'mile-per-gallon-imperial' => {
						'name' => q(mpg UK),
					},
					# Long Unit Identifier
					'coordinate' => {
						'east' => q({0}خ),
						'north' => q({0}ش),
						'south' => q({0}س),
						'west' => q({0}ل),
					},
					# Core Unit Identifier
					'coordinate' => {
						'east' => q({0}خ),
						'north' => q({0}ش),
						'south' => q({0}س),
						'west' => q({0}ل),
					},
					# Long Unit Identifier
					'duration-day' => {
						'name' => q(ورځ),
						'one' => q({0} ورځ),
						'other' => q({0}d),
					},
					# Core Unit Identifier
					'day' => {
						'name' => q(ورځ),
						'one' => q({0} ورځ),
						'other' => q({0}d),
					},
					# Long Unit Identifier
					'duration-hour' => {
						'name' => q(hr),
						'one' => q({0} h),
						'other' => q({0} h),
					},
					# Core Unit Identifier
					'hour' => {
						'name' => q(hr),
						'one' => q({0} h),
						'other' => q({0} h),
					},
					# Long Unit Identifier
					'duration-millisecond' => {
						'name' => q(ms),
						'one' => q({0} ms),
						'other' => q({0} ms),
					},
					# Core Unit Identifier
					'millisecond' => {
						'name' => q(ms),
						'one' => q({0} ms),
						'other' => q({0} ms),
					},
					# Long Unit Identifier
					'duration-minute' => {
						'name' => q(min),
						'one' => q({0} min),
						'other' => q({0}m),
					},
					# Core Unit Identifier
					'minute' => {
						'name' => q(min),
						'one' => q({0} min),
						'other' => q({0}m),
					},
					# Long Unit Identifier
					'duration-month' => {
						'name' => q(مياشت),
						'one' => q({0} m),
						'other' => q({0} m),
					},
					# Core Unit Identifier
					'month' => {
						'name' => q(مياشت),
						'one' => q({0} m),
						'other' => q({0} m),
					},
					# Long Unit Identifier
					'duration-second' => {
						'name' => q(sec),
						'one' => q({0} s),
						'other' => q({0} s),
					},
					# Core Unit Identifier
					'second' => {
						'name' => q(sec),
						'one' => q({0} s),
						'other' => q({0} s),
					},
					# Long Unit Identifier
					'duration-week' => {
						'name' => q(اونۍ),
						'one' => q({0} w),
						'other' => q({0} w),
					},
					# Core Unit Identifier
					'week' => {
						'name' => q(اونۍ),
						'one' => q({0} w),
						'other' => q({0} w),
					},
					# Long Unit Identifier
					'duration-year' => {
						'name' => q(yr),
						'one' => q({0} y),
						'other' => q({0} y),
					},
					# Core Unit Identifier
					'year' => {
						'name' => q(yr),
						'one' => q({0} y),
						'other' => q({0} y),
					},
					# Long Unit Identifier
					'force-kilowatt-hour-per-100-kilometer' => {
						'one' => q({0} kWh/100km),
						'other' => q({0}kWh/100km),
					},
					# Core Unit Identifier
					'kilowatt-hour-per-100-kilometer' => {
						'one' => q({0} kWh/100km),
						'other' => q({0}kWh/100km),
					},
					# Long Unit Identifier
					'length-centimeter' => {
						'name' => q(cm),
						'one' => q({0}cm),
						'other' => q({0}cm),
					},
					# Core Unit Identifier
					'centimeter' => {
						'name' => q(cm),
						'one' => q({0}cm),
						'other' => q({0}cm),
					},
					# Long Unit Identifier
					'length-kilometer' => {
						'name' => q(km),
						'one' => q({0} km),
						'other' => q({0} km),
					},
					# Core Unit Identifier
					'kilometer' => {
						'name' => q(km),
						'one' => q({0} km),
						'other' => q({0} km),
					},
					# Long Unit Identifier
					'length-meter' => {
						'name' => q(m),
						'one' => q({0} m),
						'other' => q({0} m),
					},
					# Core Unit Identifier
					'meter' => {
						'name' => q(m),
						'one' => q({0} m),
						'other' => q({0} m),
					},
					# Long Unit Identifier
					'length-millimeter' => {
						'name' => q(mm),
						'one' => q({0}mm),
						'other' => q({0}mm),
					},
					# Core Unit Identifier
					'millimeter' => {
						'name' => q(mm),
						'one' => q({0}mm),
						'other' => q({0}mm),
					},
					# Long Unit Identifier
					'mass-gram' => {
						'name' => q(ګرام),
						'one' => q({0}g),
						'other' => q({0}g),
					},
					# Core Unit Identifier
					'gram' => {
						'name' => q(ګرام),
						'one' => q({0}g),
						'other' => q({0}g),
					},
					# Long Unit Identifier
					'mass-kilogram' => {
						'name' => q(kg),
						'one' => q({0}kg),
						'other' => q({0}kg),
					},
					# Core Unit Identifier
					'kilogram' => {
						'name' => q(kg),
						'one' => q({0}kg),
						'other' => q({0}kg),
					},
					# Long Unit Identifier
					'per' => {
						'1' => q({0}/{1}),
					},
					# Core Unit Identifier
					'per' => {
						'1' => q({0}/{1}),
					},
					# Long Unit Identifier
					'power2' => {
						'1' => q({0}²),
						'one' => q(مربع {0}),
						'other' => q({0}²),
					},
					# Core Unit Identifier
					'power2' => {
						'1' => q({0}²),
						'one' => q(مربع {0}),
						'other' => q({0}²),
					},
					# Long Unit Identifier
					'power3' => {
						'1' => q({0}³),
					},
					# Core Unit Identifier
					'power3' => {
						'1' => q({0}³),
					},
					# Long Unit Identifier
					'speed-kilometer-per-hour' => {
						'name' => q(km/hr),
						'one' => q({0}kph),
						'other' => q({0}kph),
					},
					# Core Unit Identifier
					'kilometer-per-hour' => {
						'name' => q(km/hr),
						'one' => q({0}kph),
						'other' => q({0}kph),
					},
					# Long Unit Identifier
					'temperature-celsius' => {
						'name' => q(°C),
						'one' => q({0}°C),
						'other' => q({0}°C),
					},
					# Core Unit Identifier
					'celsius' => {
						'name' => q(°C),
						'one' => q({0}°C),
						'other' => q({0}°C),
					},
					# Long Unit Identifier
					'volume-dessert-spoon-imperial' => {
						'one' => q({0}dsp-Imp),
						'other' => q({0}dsp-Imp),
					},
					# Core Unit Identifier
					'dessert-spoon-imperial' => {
						'one' => q({0}dsp-Imp),
						'other' => q({0}dsp-Imp),
					},
					# Long Unit Identifier
					'volume-fluid-ounce-imperial' => {
						'one' => q({0}fl oz Im),
						'other' => q({0}fl oz Im),
					},
					# Core Unit Identifier
					'fluid-ounce-imperial' => {
						'one' => q({0}fl oz Im),
						'other' => q({0}fl oz Im),
					},
					# Long Unit Identifier
					'volume-gallon-imperial' => {
						'one' => q({0}galIm),
						'other' => q({0}galIm),
					},
					# Core Unit Identifier
					'gallon-imperial' => {
						'one' => q({0}galIm),
						'other' => q({0}galIm),
					},
					# Long Unit Identifier
					'volume-liter' => {
						'name' => q(لیټر),
						'one' => q({0}L),
						'other' => q({0}L),
					},
					# Core Unit Identifier
					'liter' => {
						'name' => q(لیټر),
						'one' => q({0}L),
						'other' => q({0}L),
					},
				},
				'short' => {
					# Long Unit Identifier
					'' => {
						'name' => q(اړخ),
					},
					# Core Unit Identifier
					'' => {
						'name' => q(اړخ),
					},
					# Long Unit Identifier
					'1024p3' => {
						'1' => q(Gi{0}),
					},
					# Core Unit Identifier
					'1024p3' => {
						'1' => q(Gi{0}),
					},
					# Long Unit Identifier
					'10p-1' => {
						'1' => q(d{0}),
					},
					# Core Unit Identifier
					'1' => {
						'1' => q(d{0}),
					},
					# Long Unit Identifier
					'10p-12' => {
						'1' => q(p{0}),
					},
					# Core Unit Identifier
					'12' => {
						'1' => q(p{0}),
					},
					# Long Unit Identifier
					'10p-15' => {
						'1' => q(f{0}),
					},
					# Core Unit Identifier
					'15' => {
						'1' => q(f{0}),
					},
					# Long Unit Identifier
					'10p-18' => {
						'1' => q(a{0}),
					},
					# Core Unit Identifier
					'18' => {
						'1' => q(a{0}),
					},
					# Long Unit Identifier
					'10p-2' => {
						'1' => q(c{0}),
					},
					# Core Unit Identifier
					'2' => {
						'1' => q(c{0}),
					},
					# Long Unit Identifier
					'10p-21' => {
						'1' => q(z{0}),
					},
					# Core Unit Identifier
					'21' => {
						'1' => q(z{0}),
					},
					# Long Unit Identifier
					'10p-24' => {
						'1' => q(y{0}),
					},
					# Core Unit Identifier
					'24' => {
						'1' => q(y{0}),
					},
					# Long Unit Identifier
					'10p-3' => {
						'1' => q(m{0}),
					},
					# Core Unit Identifier
					'3' => {
						'1' => q(m{0}),
					},
					# Long Unit Identifier
					'10p-6' => {
						'1' => q(μ{0}),
					},
					# Core Unit Identifier
					'6' => {
						'1' => q(μ{0}),
					},
					# Long Unit Identifier
					'10p-9' => {
						'1' => q(n{0}),
					},
					# Core Unit Identifier
					'9' => {
						'1' => q(n{0}),
					},
					# Long Unit Identifier
					'10p1' => {
						'1' => q(da{0}),
					},
					# Core Unit Identifier
					'10p1' => {
						'1' => q(da{0}),
					},
					# Long Unit Identifier
					'10p12' => {
						'1' => q(T{0}),
					},
					# Core Unit Identifier
					'10p12' => {
						'1' => q(T{0}),
					},
					# Long Unit Identifier
					'10p15' => {
						'1' => q(P{0}),
					},
					# Core Unit Identifier
					'10p15' => {
						'1' => q(P{0}),
					},
					# Long Unit Identifier
					'10p18' => {
						'1' => q(E{0}),
					},
					# Core Unit Identifier
					'10p18' => {
						'1' => q(E{0}),
					},
					# Long Unit Identifier
					'10p2' => {
						'1' => q(h{0}),
					},
					# Core Unit Identifier
					'10p2' => {
						'1' => q(h{0}),
					},
					# Long Unit Identifier
					'10p21' => {
						'1' => q(Z{0}),
					},
					# Core Unit Identifier
					'10p21' => {
						'1' => q(Z{0}),
					},
					# Long Unit Identifier
					'10p24' => {
						'1' => q(Y{0}),
					},
					# Core Unit Identifier
					'10p24' => {
						'1' => q(Y{0}),
					},
					# Long Unit Identifier
					'10p3' => {
						'1' => q(k{0}),
					},
					# Core Unit Identifier
					'10p3' => {
						'1' => q(k{0}),
					},
					# Long Unit Identifier
					'10p6' => {
						'1' => q(M{0}),
					},
					# Core Unit Identifier
					'10p6' => {
						'1' => q(M{0}),
					},
					# Long Unit Identifier
					'10p9' => {
						'1' => q(G{0}),
					},
					# Core Unit Identifier
					'10p9' => {
						'1' => q(G{0}),
					},
					# Long Unit Identifier
					'acceleration-g-force' => {
						'name' => q(د جاذبې قوه),
						'one' => q({0} G),
						'other' => q({0} G),
					},
					# Core Unit Identifier
					'g-force' => {
						'name' => q(د جاذبې قوه),
						'one' => q({0} G),
						'other' => q({0} G),
					},
					# Long Unit Identifier
					'acceleration-meter-per-square-second' => {
						'one' => q({0} m/s²),
						'other' => q({0} m/s²),
					},
					# Core Unit Identifier
					'meter-per-square-second' => {
						'one' => q({0} m/s²),
						'other' => q({0} m/s²),
					},
					# Long Unit Identifier
					'angle-arc-minute' => {
						'name' => q(arcmins),
						'one' => q({0}′),
						'other' => q({0}′),
					},
					# Core Unit Identifier
					'arc-minute' => {
						'name' => q(arcmins),
						'one' => q({0}′),
						'other' => q({0}′),
					},
					# Long Unit Identifier
					'angle-arc-second' => {
						'name' => q(آرکسیکس),
						'one' => q({0}″),
						'other' => q({0}″),
					},
					# Core Unit Identifier
					'arc-second' => {
						'name' => q(آرکسیکس),
						'one' => q({0}″),
						'other' => q({0}″),
					},
					# Long Unit Identifier
					'angle-degree' => {
						'name' => q(درجې),
						'one' => q({0}°),
						'other' => q({0}°),
					},
					# Core Unit Identifier
					'degree' => {
						'name' => q(درجې),
						'one' => q({0}°),
						'other' => q({0}°),
					},
					# Long Unit Identifier
					'angle-radian' => {
						'name' => q(رادیان),
						'one' => q({0} rad),
						'other' => q({0} rad),
					},
					# Core Unit Identifier
					'radian' => {
						'name' => q(رادیان),
						'one' => q({0} rad),
						'other' => q({0} rad),
					},
					# Long Unit Identifier
					'angle-revolution' => {
						'name' => q(rev),
						'one' => q({0} rev),
						'other' => q({0} rev),
					},
					# Core Unit Identifier
					'revolution' => {
						'name' => q(rev),
						'one' => q({0} rev),
						'other' => q({0} rev),
					},
					# Long Unit Identifier
					'area-acre' => {
						'name' => q(ايکړز),
						'one' => q({0} ac),
						'other' => q({0} ac),
					},
					# Core Unit Identifier
					'acre' => {
						'name' => q(ايکړز),
						'one' => q({0} ac),
						'other' => q({0} ac),
					},
					# Long Unit Identifier
					'area-dunam' => {
						'name' => q(دونمز),
						'one' => q({0} دونم),
						'other' => q({0} دونم),
					},
					# Core Unit Identifier
					'dunam' => {
						'name' => q(دونمز),
						'one' => q({0} دونم),
						'other' => q({0} دونم),
					},
					# Long Unit Identifier
					'area-hectare' => {
						'name' => q(هيکترې),
						'one' => q({0} ha),
						'other' => q({0} ha),
					},
					# Core Unit Identifier
					'hectare' => {
						'name' => q(هيکترې),
						'one' => q({0} ha),
						'other' => q({0} ha),
					},
					# Long Unit Identifier
					'area-square-centimeter' => {
						'name' => q(cm²),
						'one' => q({0} cm²),
						'other' => q({0} cm²),
						'per' => q({0}/cm²),
					},
					# Core Unit Identifier
					'square-centimeter' => {
						'name' => q(cm²),
						'one' => q({0} cm²),
						'other' => q({0} cm²),
						'per' => q({0}/cm²),
					},
					# Long Unit Identifier
					'area-square-foot' => {
						'name' => q(sq feet),
						'one' => q({0} sq ft),
						'other' => q({0} sq ft),
					},
					# Core Unit Identifier
					'square-foot' => {
						'name' => q(sq feet),
						'one' => q({0} sq ft),
						'other' => q({0} sq ft),
					},
					# Long Unit Identifier
					'area-square-inch' => {
						'name' => q(inches²),
						'one' => q({0} in²),
						'other' => q({0} in²),
						'per' => q({0}/in²),
					},
					# Core Unit Identifier
					'square-inch' => {
						'name' => q(inches²),
						'one' => q({0} in²),
						'other' => q({0} in²),
						'per' => q({0}/in²),
					},
					# Long Unit Identifier
					'area-square-kilometer' => {
						'name' => q(km²),
						'one' => q({0} km²),
						'other' => q({0} km²),
						'per' => q({0}/km²),
					},
					# Core Unit Identifier
					'square-kilometer' => {
						'name' => q(km²),
						'one' => q({0} km²),
						'other' => q({0} km²),
						'per' => q({0}/km²),
					},
					# Long Unit Identifier
					'area-square-meter' => {
						'name' => q(meters²),
						'one' => q({0} m²),
						'other' => q({0} m²),
						'per' => q({0}/m²),
					},
					# Core Unit Identifier
					'square-meter' => {
						'name' => q(meters²),
						'one' => q({0} m²),
						'other' => q({0} m²),
						'per' => q({0}/m²),
					},
					# Long Unit Identifier
					'area-square-mile' => {
						'name' => q(sq miles),
						'one' => q({0} sq mi),
						'other' => q({0} sq mi),
						'per' => q({0}/mi²),
					},
					# Core Unit Identifier
					'square-mile' => {
						'name' => q(sq miles),
						'one' => q({0} sq mi),
						'other' => q({0} sq mi),
						'per' => q({0}/mi²),
					},
					# Long Unit Identifier
					'area-square-yard' => {
						'name' => q(yards²),
						'one' => q({0} yd²),
						'other' => q({0} yd²),
					},
					# Core Unit Identifier
					'square-yard' => {
						'name' => q(yards²),
						'one' => q({0} yd²),
						'other' => q({0} yd²),
					},
					# Long Unit Identifier
					'concentr-item' => {
						'name' => q(توکی),
						'one' => q({0} توکی),
						'other' => q({0} توکی),
					},
					# Core Unit Identifier
					'item' => {
						'name' => q(توکی),
						'one' => q({0} توکی),
						'other' => q({0} توکی),
					},
					# Long Unit Identifier
					'concentr-karat' => {
						'name' => q(قيراط),
						'one' => q({0} kt),
						'other' => q({0} kt),
					},
					# Core Unit Identifier
					'karat' => {
						'name' => q(قيراط),
						'one' => q({0} kt),
						'other' => q({0} kt),
					},
					# Long Unit Identifier
					'concentr-milligram-ofglucose-per-deciliter' => {
						'name' => q(mg/dL),
						'one' => q({0} mg/dL),
						'other' => q({0} mg/dL),
					},
					# Core Unit Identifier
					'milligram-ofglucose-per-deciliter' => {
						'name' => q(mg/dL),
						'one' => q({0} mg/dL),
						'other' => q({0} mg/dL),
					},
					# Long Unit Identifier
					'concentr-millimole-per-liter' => {
						'name' => q(ملي مول/ليټر),
						'one' => q({0} mmol/L),
						'other' => q({0} mmol/L),
					},
					# Core Unit Identifier
					'millimole-per-liter' => {
						'name' => q(ملي مول/ليټر),
						'one' => q({0} mmol/L),
						'other' => q({0} mmol/L),
					},
					# Long Unit Identifier
					'concentr-mole' => {
						'name' => q(مول),
						'one' => q({0} مول),
						'other' => q({0} مول),
					},
					# Core Unit Identifier
					'mole' => {
						'name' => q(مول),
						'one' => q({0} مول),
						'other' => q({0} مول),
					},
					# Long Unit Identifier
					'concentr-percent' => {
						'name' => q(سلنه),
						'one' => q({0}%),
						'other' => q({0}%),
					},
					# Core Unit Identifier
					'percent' => {
						'name' => q(سلنه),
						'one' => q({0}%),
						'other' => q({0}%),
					},
					# Long Unit Identifier
					'concentr-permille' => {
						'name' => q(في ميل),
						'one' => q({0}‰),
						'other' => q({0}‰),
					},
					# Core Unit Identifier
					'permille' => {
						'name' => q(في ميل),
						'one' => q({0}‰),
						'other' => q({0}‰),
					},
					# Long Unit Identifier
					'concentr-permillion' => {
						'name' => q(پارټس/مليون),
						'one' => q({0} ppm),
						'other' => q({0} ppm),
					},
					# Core Unit Identifier
					'permillion' => {
						'name' => q(پارټس/مليون),
						'one' => q({0} ppm),
						'other' => q({0} ppm),
					},
					# Long Unit Identifier
					'concentr-permyriad' => {
						'name' => q(زرمه),
					},
					# Core Unit Identifier
					'permyriad' => {
						'name' => q(زرمه),
					},
					# Long Unit Identifier
					'consumption-liter-per-100-kilometer' => {
						'name' => q(L/100km),
						'one' => q({0} L/100km),
						'other' => q({0} L/100km),
					},
					# Core Unit Identifier
					'liter-per-100-kilometer' => {
						'name' => q(L/100km),
						'one' => q({0} L/100km),
						'other' => q({0} L/100km),
					},
					# Long Unit Identifier
					'consumption-liter-per-kilometer' => {
						'name' => q(L/km),
						'one' => q({0} L/km),
						'other' => q({0} L/km),
					},
					# Core Unit Identifier
					'liter-per-kilometer' => {
						'name' => q(L/km),
						'one' => q({0} L/km),
						'other' => q({0} L/km),
					},
					# Long Unit Identifier
					'consumption-mile-per-gallon' => {
						'name' => q(mpg US),
						'one' => q({0} mpg US),
						'other' => q({0} mpg US),
					},
					# Core Unit Identifier
					'mile-per-gallon' => {
						'name' => q(mpg US),
						'one' => q({0} mpg US),
						'other' => q({0} mpg US),
					},
					# Long Unit Identifier
					'consumption-mile-per-gallon-imperial' => {
						'name' => q(ميلز/ګيلن ايمپيريل),
						'one' => q({0} mpg Imp.),
						'other' => q({0} mpg Imp.),
					},
					# Core Unit Identifier
					'mile-per-gallon-imperial' => {
						'name' => q(ميلز/ګيلن ايمپيريل),
						'one' => q({0} mpg Imp.),
						'other' => q({0} mpg Imp.),
					},
					# Long Unit Identifier
					'coordinate' => {
						'east' => q({0} خ),
						'north' => q({0} ش),
						'south' => q({0} س),
						'west' => q({0} ل),
					},
					# Core Unit Identifier
					'coordinate' => {
						'east' => q({0} خ),
						'north' => q({0} ش),
						'south' => q({0} س),
						'west' => q({0} ل),
					},
					# Long Unit Identifier
					'digital-bit' => {
						'name' => q(bit),
						'one' => q({0} bit),
						'other' => q({0} bit),
					},
					# Core Unit Identifier
					'bit' => {
						'name' => q(bit),
						'one' => q({0} bit),
						'other' => q({0} bit),
					},
					# Long Unit Identifier
					'digital-byte' => {
						'name' => q(byte),
						'one' => q({0} byte),
						'other' => q({0} byte),
					},
					# Core Unit Identifier
					'byte' => {
						'name' => q(byte),
						'one' => q({0} byte),
						'other' => q({0} byte),
					},
					# Long Unit Identifier
					'digital-gigabit' => {
						'name' => q(Gbit),
						'one' => q({0} Gb),
						'other' => q({0} Gb),
					},
					# Core Unit Identifier
					'gigabit' => {
						'name' => q(Gbit),
						'one' => q({0} Gb),
						'other' => q({0} Gb),
					},
					# Long Unit Identifier
					'digital-gigabyte' => {
						'name' => q(GByte),
						'one' => q({0} GB),
						'other' => q({0} GB),
					},
					# Core Unit Identifier
					'gigabyte' => {
						'name' => q(GByte),
						'one' => q({0} GB),
						'other' => q({0} GB),
					},
					# Long Unit Identifier
					'digital-kilobit' => {
						'name' => q(kbit),
						'one' => q({0} kb),
						'other' => q({0} kb),
					},
					# Core Unit Identifier
					'kilobit' => {
						'name' => q(kbit),
						'one' => q({0} kb),
						'other' => q({0} kb),
					},
					# Long Unit Identifier
					'digital-kilobyte' => {
						'name' => q(kByte),
						'one' => q({0} kB),
						'other' => q({0} kB),
					},
					# Core Unit Identifier
					'kilobyte' => {
						'name' => q(kByte),
						'one' => q({0} kB),
						'other' => q({0} kB),
					},
					# Long Unit Identifier
					'digital-megabit' => {
						'name' => q(Mbit),
						'one' => q({0} Mb),
						'other' => q({0} Mb),
					},
					# Core Unit Identifier
					'megabit' => {
						'name' => q(Mbit),
						'one' => q({0} Mb),
						'other' => q({0} Mb),
					},
					# Long Unit Identifier
					'digital-megabyte' => {
						'name' => q(MByte),
						'one' => q({0} MB),
						'other' => q({0} MB),
					},
					# Core Unit Identifier
					'megabyte' => {
						'name' => q(MByte),
						'one' => q({0} MB),
						'other' => q({0} MB),
					},
					# Long Unit Identifier
					'digital-petabyte' => {
						'name' => q(PByte),
						'one' => q({0} PB),
						'other' => q({0} PB),
					},
					# Core Unit Identifier
					'petabyte' => {
						'name' => q(PByte),
						'one' => q({0} PB),
						'other' => q({0} PB),
					},
					# Long Unit Identifier
					'digital-terabit' => {
						'name' => q(Tbit),
						'one' => q({0} Tb),
						'other' => q({0} Tb),
					},
					# Core Unit Identifier
					'terabit' => {
						'name' => q(Tbit),
						'one' => q({0} Tb),
						'other' => q({0} Tb),
					},
					# Long Unit Identifier
					'digital-terabyte' => {
						'name' => q(TByte),
						'one' => q({0} TB),
						'other' => q({0} TB),
					},
					# Core Unit Identifier
					'terabyte' => {
						'name' => q(TByte),
						'one' => q({0} TB),
						'other' => q({0} TB),
					},
					# Long Unit Identifier
					'duration-century' => {
						'name' => q(c),
						'one' => q({0} c),
						'other' => q({0} c),
					},
					# Core Unit Identifier
					'century' => {
						'name' => q(c),
						'one' => q({0} c),
						'other' => q({0} c),
					},
					# Long Unit Identifier
					'duration-day' => {
						'name' => q(ورځې),
						'one' => q({0} ورځ),
						'other' => q({0} ورځې),
						'per' => q({0}/d),
					},
					# Core Unit Identifier
					'day' => {
						'name' => q(ورځې),
						'one' => q({0} ورځ),
						'other' => q({0} ورځې),
						'per' => q({0}/d),
					},
					# Long Unit Identifier
					'duration-decade' => {
						'name' => q(لسيزه),
						'one' => q({0} لسيزه),
						'other' => q({0} لسيزه),
					},
					# Core Unit Identifier
					'decade' => {
						'name' => q(لسيزه),
						'one' => q({0} لسيزه),
						'other' => q({0} لسيزه),
					},
					# Long Unit Identifier
					'duration-hour' => {
						'name' => q(ساعتونه),
						'one' => q({0} h),
						'other' => q({0} h),
						'per' => q({0}/h),
					},
					# Core Unit Identifier
					'hour' => {
						'name' => q(ساعتونه),
						'one' => q({0} h),
						'other' => q({0} h),
						'per' => q({0}/h),
					},
					# Long Unit Identifier
					'duration-millisecond' => {
						'name' => q(ms),
						'one' => q({0} ms),
						'other' => q({0} ms),
					},
					# Core Unit Identifier
					'millisecond' => {
						'name' => q(ms),
						'one' => q({0} ms),
						'other' => q({0} ms),
					},
					# Long Unit Identifier
					'duration-minute' => {
						'name' => q(mins),
						'one' => q({0} min),
						'other' => q({0} min),
						'per' => q({0}/min),
					},
					# Core Unit Identifier
					'minute' => {
						'name' => q(mins),
						'one' => q({0} min),
						'other' => q({0} min),
						'per' => q({0}/min),
					},
					# Long Unit Identifier
					'duration-month' => {
						'name' => q(مياشتې),
						'one' => q({0} m),
						'other' => q({0} mths),
						'per' => q({0}/m),
					},
					# Core Unit Identifier
					'month' => {
						'name' => q(مياشتې),
						'one' => q({0} m),
						'other' => q({0} mths),
						'per' => q({0}/m),
					},
					# Long Unit Identifier
					'duration-nanosecond' => {
						'name' => q(ns),
						'one' => q({0} ns),
						'other' => q({0} ns),
					},
					# Core Unit Identifier
					'nanosecond' => {
						'name' => q(ns),
						'one' => q({0} ns),
						'other' => q({0} ns),
					},
					# Long Unit Identifier
					'duration-second' => {
						'name' => q(ثانيې),
						'one' => q({0} s),
						'other' => q({0} s),
						'per' => q({0}/s),
					},
					# Core Unit Identifier
					'second' => {
						'name' => q(ثانيې),
						'one' => q({0} s),
						'other' => q({0} s),
						'per' => q({0}/s),
					},
					# Long Unit Identifier
					'duration-week' => {
						'name' => q(اونۍ),
						'one' => q({0} w),
						'other' => q({0} wks),
						'per' => q({0}/w),
					},
					# Core Unit Identifier
					'week' => {
						'name' => q(اونۍ),
						'one' => q({0} w),
						'other' => q({0} wks),
						'per' => q({0}/w),
					},
					# Long Unit Identifier
					'duration-year' => {
						'name' => q(کالونه),
						'one' => q({0} y),
						'other' => q({0} y),
						'per' => q({0}/y),
					},
					# Core Unit Identifier
					'year' => {
						'name' => q(کالونه),
						'one' => q({0} y),
						'other' => q({0} y),
						'per' => q({0}/y),
					},
					# Long Unit Identifier
					'electric-ampere' => {
						'name' => q(amps),
						'one' => q({0} A),
						'other' => q({0} A),
					},
					# Core Unit Identifier
					'ampere' => {
						'name' => q(amps),
						'one' => q({0} A),
						'other' => q({0} A),
					},
					# Long Unit Identifier
					'electric-milliampere' => {
						'name' => q(milliamps),
						'one' => q({0} mA),
						'other' => q({0} mA),
					},
					# Core Unit Identifier
					'milliampere' => {
						'name' => q(milliamps),
						'one' => q({0} mA),
						'other' => q({0} mA),
					},
					# Long Unit Identifier
					'electric-ohm' => {
						'name' => q(اوهمز),
						'one' => q({0} Ω),
						'other' => q({0} Ω),
					},
					# Core Unit Identifier
					'ohm' => {
						'name' => q(اوهمز),
						'one' => q({0} Ω),
						'other' => q({0} Ω),
					},
					# Long Unit Identifier
					'electric-volt' => {
						'name' => q(volts),
						'one' => q({0} V),
						'other' => q({0} V),
					},
					# Core Unit Identifier
					'volt' => {
						'name' => q(volts),
						'one' => q({0} V),
						'other' => q({0} V),
					},
					# Long Unit Identifier
					'energy-british-thermal-unit' => {
						'name' => q(BTU),
						'one' => q({0} Btu),
						'other' => q({0} Btu),
					},
					# Core Unit Identifier
					'british-thermal-unit' => {
						'name' => q(BTU),
						'one' => q({0} Btu),
						'other' => q({0} Btu),
					},
					# Long Unit Identifier
					'energy-calorie' => {
						'name' => q(cal),
						'one' => q({0} cal),
						'other' => q({0} cal),
					},
					# Core Unit Identifier
					'calorie' => {
						'name' => q(cal),
						'one' => q({0} cal),
						'other' => q({0} cal),
					},
					# Long Unit Identifier
					'energy-electronvolt' => {
						'name' => q(اليکټران وولټ),
					},
					# Core Unit Identifier
					'electronvolt' => {
						'name' => q(اليکټران وولټ),
					},
					# Long Unit Identifier
					'energy-foodcalorie' => {
						'name' => q(Cal),
						'one' => q({0} Cal),
						'other' => q({0} Cal),
					},
					# Core Unit Identifier
					'foodcalorie' => {
						'name' => q(Cal),
						'one' => q({0} Cal),
						'other' => q({0} Cal),
					},
					# Long Unit Identifier
					'energy-joule' => {
						'name' => q(جولز),
						'one' => q({0} J),
						'other' => q({0} J),
					},
					# Core Unit Identifier
					'joule' => {
						'name' => q(جولز),
						'one' => q({0} J),
						'other' => q({0} J),
					},
					# Long Unit Identifier
					'energy-kilocalorie' => {
						'name' => q(kcal),
						'one' => q({0} kcal),
						'other' => q({0} kcal),
					},
					# Core Unit Identifier
					'kilocalorie' => {
						'name' => q(kcal),
						'one' => q({0} kcal),
						'other' => q({0} kcal),
					},
					# Long Unit Identifier
					'energy-kilojoule' => {
						'name' => q(کيلو جول),
						'one' => q({0} kJ),
						'other' => q({0} kJ),
					},
					# Core Unit Identifier
					'kilojoule' => {
						'name' => q(کيلو جول),
						'one' => q({0} kJ),
						'other' => q({0} kJ),
					},
					# Long Unit Identifier
					'energy-kilowatt-hour' => {
						'name' => q(kW-hour),
						'one' => q({0} kWh),
						'other' => q({0} kWh),
					},
					# Core Unit Identifier
					'kilowatt-hour' => {
						'name' => q(kW-hour),
						'one' => q({0} kWh),
						'other' => q({0} kWh),
					},
					# Long Unit Identifier
					'energy-therm-us' => {
						'name' => q(US تهرم),
						'one' => q({0} US therm),
						'other' => q({0} US therm),
					},
					# Core Unit Identifier
					'therm-us' => {
						'name' => q(US تهرم),
						'one' => q({0} US therm),
						'other' => q({0} US therm),
					},
					# Long Unit Identifier
					'force-newton' => {
						'name' => q(نيوټن),
					},
					# Core Unit Identifier
					'newton' => {
						'name' => q(نيوټن),
					},
					# Long Unit Identifier
					'force-pound-force' => {
						'name' => q(پاونډ قوه),
					},
					# Core Unit Identifier
					'pound-force' => {
						'name' => q(پاونډ قوه),
					},
					# Long Unit Identifier
					'frequency-gigahertz' => {
						'name' => q(GHz),
						'one' => q({0} GHz),
						'other' => q({0} GHz),
					},
					# Core Unit Identifier
					'gigahertz' => {
						'name' => q(GHz),
						'one' => q({0} GHz),
						'other' => q({0} GHz),
					},
					# Long Unit Identifier
					'frequency-hertz' => {
						'name' => q(Hz),
						'one' => q({0} Hz),
						'other' => q({0} Hz),
					},
					# Core Unit Identifier
					'hertz' => {
						'name' => q(Hz),
						'one' => q({0} Hz),
						'other' => q({0} Hz),
					},
					# Long Unit Identifier
					'frequency-kilohertz' => {
						'name' => q(kHz),
						'one' => q({0} kHz),
						'other' => q({0} kHz),
					},
					# Core Unit Identifier
					'kilohertz' => {
						'name' => q(kHz),
						'one' => q({0} kHz),
						'other' => q({0} kHz),
					},
					# Long Unit Identifier
					'frequency-megahertz' => {
						'name' => q(MHz),
						'one' => q({0} MHz),
						'other' => q({0} MHz),
					},
					# Core Unit Identifier
					'megahertz' => {
						'name' => q(MHz),
						'one' => q({0} MHz),
						'other' => q({0} MHz),
					},
					# Long Unit Identifier
					'graphics-dot-per-centimeter' => {
						'name' => q(dpcm),
					},
					# Core Unit Identifier
					'dot-per-centimeter' => {
						'name' => q(dpcm),
					},
					# Long Unit Identifier
					'graphics-em' => {
						'name' => q(em),
					},
					# Core Unit Identifier
					'em' => {
						'name' => q(em),
					},
					# Long Unit Identifier
					'graphics-megapixel' => {
						'one' => q({0} MP),
						'other' => q({0} MP),
					},
					# Core Unit Identifier
					'megapixel' => {
						'one' => q({0} MP),
						'other' => q({0} MP),
					},
					# Long Unit Identifier
					'length-astronomical-unit' => {
						'name' => q(au),
						'one' => q({0} au),
						'other' => q({0} au),
					},
					# Core Unit Identifier
					'astronomical-unit' => {
						'name' => q(au),
						'one' => q({0} au),
						'other' => q({0} au),
					},
					# Long Unit Identifier
					'length-centimeter' => {
						'name' => q(cm),
						'one' => q({0} cm),
						'other' => q({0} cm),
						'per' => q({0}/cm),
					},
					# Core Unit Identifier
					'centimeter' => {
						'name' => q(cm),
						'one' => q({0} cm),
						'other' => q({0} cm),
						'per' => q({0}/cm),
					},
					# Long Unit Identifier
					'length-decimeter' => {
						'name' => q(dm),
						'one' => q({0} dm),
						'other' => q({0} dm),
					},
					# Core Unit Identifier
					'decimeter' => {
						'name' => q(dm),
						'one' => q({0} dm),
						'other' => q({0} dm),
					},
					# Long Unit Identifier
					'length-earth-radius' => {
						'one' => q({0} R⊕),
						'other' => q({0} R⊕),
					},
					# Core Unit Identifier
					'earth-radius' => {
						'one' => q({0} R⊕),
						'other' => q({0} R⊕),
					},
					# Long Unit Identifier
					'length-fathom' => {
						'name' => q(فتومونه),
						'one' => q({0} fth),
						'other' => q({0} fth),
					},
					# Core Unit Identifier
					'fathom' => {
						'name' => q(فتومونه),
						'one' => q({0} fth),
						'other' => q({0} fth),
					},
					# Long Unit Identifier
					'length-foot' => {
						'name' => q(فټه),
						'one' => q({0} ft),
						'other' => q({0} ft),
						'per' => q({0}/ft),
					},
					# Core Unit Identifier
					'foot' => {
						'name' => q(فټه),
						'one' => q({0} ft),
						'other' => q({0} ft),
						'per' => q({0}/ft),
					},
					# Long Unit Identifier
					'length-furlong' => {
						'name' => q(فرلانګونه),
						'one' => q({0} fur),
						'other' => q({0} fur),
					},
					# Core Unit Identifier
					'furlong' => {
						'name' => q(فرلانګونه),
						'one' => q({0} fur),
						'other' => q({0} fur),
					},
					# Long Unit Identifier
					'length-inch' => {
						'name' => q(انچې),
						'one' => q({0} in),
						'other' => q({0} in),
						'per' => q({0}/in),
					},
					# Core Unit Identifier
					'inch' => {
						'name' => q(انچې),
						'one' => q({0} in),
						'other' => q({0} in),
						'per' => q({0}/in),
					},
					# Long Unit Identifier
					'length-kilometer' => {
						'name' => q(km),
						'one' => q({0} km),
						'other' => q({0} km),
						'per' => q({0}/km),
					},
					# Core Unit Identifier
					'kilometer' => {
						'name' => q(km),
						'one' => q({0} km),
						'other' => q({0} km),
						'per' => q({0}/km),
					},
					# Long Unit Identifier
					'length-light-year' => {
						'name' => q(light yrs),
						'one' => q({0} ly),
						'other' => q({0} ly),
					},
					# Core Unit Identifier
					'light-year' => {
						'name' => q(light yrs),
						'one' => q({0} ly),
						'other' => q({0} ly),
					},
					# Long Unit Identifier
					'length-meter' => {
						'name' => q(m),
						'one' => q({0} m),
						'other' => q({0} m),
						'per' => q({0}/m),
					},
					# Core Unit Identifier
					'meter' => {
						'name' => q(m),
						'one' => q({0} m),
						'other' => q({0} m),
						'per' => q({0}/m),
					},
					# Long Unit Identifier
					'length-micrometer' => {
						'name' => q(μmeters),
						'one' => q({0} μm),
						'other' => q({0} μm),
					},
					# Core Unit Identifier
					'micrometer' => {
						'name' => q(μmeters),
						'one' => q({0} μm),
						'other' => q({0} μm),
					},
					# Long Unit Identifier
					'length-mile' => {
						'name' => q(ميلونه),
						'one' => q({0} mi),
						'other' => q({0} mi),
					},
					# Core Unit Identifier
					'mile' => {
						'name' => q(ميلونه),
						'one' => q({0} mi),
						'other' => q({0} mi),
					},
					# Long Unit Identifier
					'length-mile-scandinavian' => {
						'name' => q(smi),
						'one' => q({0} smi),
						'other' => q({0} smi),
					},
					# Core Unit Identifier
					'mile-scandinavian' => {
						'name' => q(smi),
						'one' => q({0} smi),
						'other' => q({0} smi),
					},
					# Long Unit Identifier
					'length-millimeter' => {
						'name' => q(mm),
						'one' => q({0} mm),
						'other' => q({0} mm),
					},
					# Core Unit Identifier
					'millimeter' => {
						'name' => q(mm),
						'one' => q({0} mm),
						'other' => q({0} mm),
					},
					# Long Unit Identifier
					'length-nanometer' => {
						'name' => q(nm),
						'one' => q({0} nm),
						'other' => q({0} nm),
					},
					# Core Unit Identifier
					'nanometer' => {
						'name' => q(nm),
						'one' => q({0} nm),
						'other' => q({0} nm),
					},
					# Long Unit Identifier
					'length-nautical-mile' => {
						'name' => q(nmi),
						'one' => q({0} nmi),
						'other' => q({0} nmi),
					},
					# Core Unit Identifier
					'nautical-mile' => {
						'name' => q(nmi),
						'one' => q({0} nmi),
						'other' => q({0} nmi),
					},
					# Long Unit Identifier
					'length-parsec' => {
						'name' => q(پارسيکس),
						'one' => q({0} pc),
						'other' => q({0} pc),
					},
					# Core Unit Identifier
					'parsec' => {
						'name' => q(پارسيکس),
						'one' => q({0} pc),
						'other' => q({0} pc),
					},
					# Long Unit Identifier
					'length-picometer' => {
						'name' => q(pm),
						'one' => q({0} pm),
						'other' => q({0} pm),
					},
					# Core Unit Identifier
					'picometer' => {
						'name' => q(pm),
						'one' => q({0} pm),
						'other' => q({0} pm),
					},
					# Long Unit Identifier
					'length-point' => {
						'name' => q(pt),
						'one' => q({0} pt),
						'other' => q({0} pt),
					},
					# Core Unit Identifier
					'point' => {
						'name' => q(pt),
						'one' => q({0} pt),
						'other' => q({0} pt),
					},
					# Long Unit Identifier
					'length-solar-radius' => {
						'name' => q(لمريزې وړانګې),
					},
					# Core Unit Identifier
					'solar-radius' => {
						'name' => q(لمريزې وړانګې),
					},
					# Long Unit Identifier
					'length-yard' => {
						'name' => q(ګزه),
						'one' => q({0} yd),
						'other' => q({0} yd),
					},
					# Core Unit Identifier
					'yard' => {
						'name' => q(ګزه),
						'one' => q({0} yd),
						'other' => q({0} yd),
					},
					# Long Unit Identifier
					'light-lux' => {
						'name' => q(lx),
						'one' => q({0} lx),
						'other' => q({0} lx),
					},
					# Core Unit Identifier
					'lux' => {
						'name' => q(lx),
						'one' => q({0} lx),
						'other' => q({0} lx),
					},
					# Long Unit Identifier
					'light-solar-luminosity' => {
						'name' => q(لمريز ځلښتونه),
					},
					# Core Unit Identifier
					'solar-luminosity' => {
						'name' => q(لمريز ځلښتونه),
					},
					# Long Unit Identifier
					'mass-carat' => {
						'name' => q(قيراط),
						'one' => q({0} CD),
						'other' => q({0} CD),
					},
					# Core Unit Identifier
					'carat' => {
						'name' => q(قيراط),
						'one' => q({0} CD),
						'other' => q({0} CD),
					},
					# Long Unit Identifier
					'mass-dalton' => {
						'name' => q(ډالټنز),
					},
					# Core Unit Identifier
					'dalton' => {
						'name' => q(ډالټنز),
					},
					# Long Unit Identifier
					'mass-earth-mass' => {
						'name' => q(د زمکې حجمونه),
					},
					# Core Unit Identifier
					'earth-mass' => {
						'name' => q(د زمکې حجمونه),
					},
					# Long Unit Identifier
					'mass-gram' => {
						'name' => q(ګرامز),
						'one' => q({0} g),
						'other' => q({0} g),
						'per' => q({0}/g),
					},
					# Core Unit Identifier
					'gram' => {
						'name' => q(ګرامز),
						'one' => q({0} g),
						'other' => q({0} g),
						'per' => q({0}/g),
					},
					# Long Unit Identifier
					'mass-kilogram' => {
						'name' => q(kg),
						'one' => q({0} kg),
						'other' => q({0} kg),
						'per' => q({0}/kg),
					},
					# Core Unit Identifier
					'kilogram' => {
						'name' => q(kg),
						'one' => q({0} kg),
						'other' => q({0} kg),
						'per' => q({0}/kg),
					},
					# Long Unit Identifier
					'mass-metric-ton' => {
						'name' => q(t),
						'one' => q({0} t),
						'other' => q({0} t),
					},
					# Core Unit Identifier
					'metric-ton' => {
						'name' => q(t),
						'one' => q({0} t),
						'other' => q({0} t),
					},
					# Long Unit Identifier
					'mass-microgram' => {
						'name' => q(μg),
						'one' => q({0} μg),
						'other' => q({0} μg),
					},
					# Core Unit Identifier
					'microgram' => {
						'name' => q(μg),
						'one' => q({0} μg),
						'other' => q({0} μg),
					},
					# Long Unit Identifier
					'mass-milligram' => {
						'name' => q(mg),
						'one' => q({0} mg),
						'other' => q({0} mg),
					},
					# Core Unit Identifier
					'milligram' => {
						'name' => q(mg),
						'one' => q({0} mg),
						'other' => q({0} mg),
					},
					# Long Unit Identifier
					'mass-ounce' => {
						'name' => q(oz),
						'one' => q({0} oz),
						'other' => q({0} oz),
						'per' => q({0}/oz),
					},
					# Core Unit Identifier
					'ounce' => {
						'name' => q(oz),
						'one' => q({0} oz),
						'other' => q({0} oz),
						'per' => q({0}/oz),
					},
					# Long Unit Identifier
					'mass-ounce-troy' => {
						'name' => q(oz troy),
						'one' => q({0} oz t),
						'other' => q({0} oz t),
					},
					# Core Unit Identifier
					'ounce-troy' => {
						'name' => q(oz troy),
						'one' => q({0} oz t),
						'other' => q({0} oz t),
					},
					# Long Unit Identifier
					'mass-pound' => {
						'name' => q(پاونډز),
						'one' => q({0} lb),
						'other' => q({0} lb),
						'per' => q({0}/lb),
					},
					# Core Unit Identifier
					'pound' => {
						'name' => q(پاونډز),
						'one' => q({0} lb),
						'other' => q({0} lb),
						'per' => q({0}/lb),
					},
					# Long Unit Identifier
					'mass-solar-mass' => {
						'name' => q(لمريز حجم),
					},
					# Core Unit Identifier
					'solar-mass' => {
						'name' => q(لمريز حجم),
					},
					# Long Unit Identifier
					'mass-ton' => {
						'name' => q(ټنز),
						'one' => q({0} tn),
						'other' => q({0} tn),
					},
					# Core Unit Identifier
					'ton' => {
						'name' => q(ټنز),
						'one' => q({0} tn),
						'other' => q({0} tn),
					},
					# Long Unit Identifier
					'per' => {
						'1' => q({0}/{1}),
					},
					# Core Unit Identifier
					'per' => {
						'1' => q({0}/{1}),
					},
					# Long Unit Identifier
					'power-gigawatt' => {
						'name' => q(GW),
						'one' => q({0} GW),
						'other' => q({0} GW),
					},
					# Core Unit Identifier
					'gigawatt' => {
						'name' => q(GW),
						'one' => q({0} GW),
						'other' => q({0} GW),
					},
					# Long Unit Identifier
					'power-horsepower' => {
						'name' => q(hp),
						'one' => q({0} hp),
						'other' => q({0} hp),
					},
					# Core Unit Identifier
					'horsepower' => {
						'name' => q(hp),
						'one' => q({0} hp),
						'other' => q({0} hp),
					},
					# Long Unit Identifier
					'power-kilowatt' => {
						'name' => q(kW),
						'one' => q({0} kW),
						'other' => q({0} kW),
					},
					# Core Unit Identifier
					'kilowatt' => {
						'name' => q(kW),
						'one' => q({0} kW),
						'other' => q({0} kW),
					},
					# Long Unit Identifier
					'power-megawatt' => {
						'name' => q(MW),
						'one' => q({0} MW),
						'other' => q({0} MW),
					},
					# Core Unit Identifier
					'megawatt' => {
						'name' => q(MW),
						'one' => q({0} MW),
						'other' => q({0} MW),
					},
					# Long Unit Identifier
					'power-milliwatt' => {
						'name' => q(mW),
						'one' => q({0} mW),
						'other' => q({0} mW),
					},
					# Core Unit Identifier
					'milliwatt' => {
						'name' => q(mW),
						'one' => q({0} mW),
						'other' => q({0} mW),
					},
					# Long Unit Identifier
					'power-watt' => {
						'name' => q(واټس),
						'one' => q({0} W),
						'other' => q({0} W),
					},
					# Core Unit Identifier
					'watt' => {
						'name' => q(واټس),
						'one' => q({0} W),
						'other' => q({0} W),
					},
					# Long Unit Identifier
					'power2' => {
						'1' => q({0}²),
						'one' => q(مربع {0}),
						'other' => q({0}²),
					},
					# Core Unit Identifier
					'power2' => {
						'1' => q({0}²),
						'one' => q(مربع {0}),
						'other' => q({0}²),
					},
					# Long Unit Identifier
					'power3' => {
						'1' => q({0}³),
						'one' => q({0}³),
						'other' => q({0}³),
					},
					# Core Unit Identifier
					'power3' => {
						'1' => q({0}³),
						'one' => q({0}³),
						'other' => q({0}³),
					},
					# Long Unit Identifier
					'pressure-atmosphere' => {
						'name' => q(atm),
						'one' => q({0} atm),
						'other' => q({0} atm),
					},
					# Core Unit Identifier
					'atmosphere' => {
						'name' => q(atm),
						'one' => q({0} atm),
						'other' => q({0} atm),
					},
					# Long Unit Identifier
					'pressure-bar' => {
						'name' => q(bar),
						'one' => q({0} bar),
						'other' => q({0} bar),
					},
					# Core Unit Identifier
					'bar' => {
						'name' => q(bar),
						'one' => q({0} bar),
						'other' => q({0} bar),
					},
					# Long Unit Identifier
					'pressure-hectopascal' => {
						'name' => q(hPa),
						'one' => q({0} hPa),
						'other' => q({0} hPa),
					},
					# Core Unit Identifier
					'hectopascal' => {
						'name' => q(hPa),
						'one' => q({0} hPa),
						'other' => q({0} hPa),
					},
					# Long Unit Identifier
					'pressure-inch-ofhg' => {
						'name' => q(inHg),
						'one' => q({0} inHg),
						'other' => q({0} inHg),
					},
					# Core Unit Identifier
					'inch-ofhg' => {
						'name' => q(inHg),
						'one' => q({0} inHg),
						'other' => q({0} inHg),
					},
					# Long Unit Identifier
					'pressure-millibar' => {
						'name' => q(mbar),
						'one' => q({0} mbar),
						'other' => q({0} mbar),
					},
					# Core Unit Identifier
					'millibar' => {
						'name' => q(mbar),
						'one' => q({0} mbar),
						'other' => q({0} mbar),
					},
					# Long Unit Identifier
					'pressure-millimeter-ofhg' => {
						'name' => q(mmHg),
						'one' => q({0} mmHg),
						'other' => q({0} mmHg),
					},
					# Core Unit Identifier
					'millimeter-ofhg' => {
						'name' => q(mmHg),
						'one' => q({0} mmHg),
						'other' => q({0} mmHg),
					},
					# Long Unit Identifier
					'pressure-pound-force-per-square-inch' => {
						'name' => q(psi),
						'one' => q({0} psi),
						'other' => q({0} psi),
					},
					# Core Unit Identifier
					'pound-force-per-square-inch' => {
						'name' => q(psi),
						'one' => q({0} psi),
						'other' => q({0} psi),
					},
					# Long Unit Identifier
					'speed-kilometer-per-hour' => {
						'name' => q(km/hour),
						'one' => q({0} kph),
						'other' => q({0} kph),
					},
					# Core Unit Identifier
					'kilometer-per-hour' => {
						'name' => q(km/hour),
						'one' => q({0} kph),
						'other' => q({0} kph),
					},
					# Long Unit Identifier
					'speed-knot' => {
						'name' => q(kn),
						'one' => q({0} kn),
						'other' => q({0} kn),
					},
					# Core Unit Identifier
					'knot' => {
						'name' => q(kn),
						'one' => q({0} kn),
						'other' => q({0} kn),
					},
					# Long Unit Identifier
					'speed-meter-per-second' => {
						'name' => q(meters/sec),
						'one' => q({0} m/s),
						'other' => q({0} m/s),
					},
					# Core Unit Identifier
					'meter-per-second' => {
						'name' => q(meters/sec),
						'one' => q({0} m/s),
						'other' => q({0} m/s),
					},
					# Long Unit Identifier
					'speed-mile-per-hour' => {
						'name' => q(miles/hour),
						'one' => q({0} mph),
						'other' => q({0} mph),
					},
					# Core Unit Identifier
					'mile-per-hour' => {
						'name' => q(miles/hour),
						'one' => q({0} mph),
						'other' => q({0} mph),
					},
					# Long Unit Identifier
					'temperature-celsius' => {
						'name' => q(deg. C),
						'one' => q({0}°C),
						'other' => q({0}°C),
					},
					# Core Unit Identifier
					'celsius' => {
						'name' => q(deg. C),
						'one' => q({0}°C),
						'other' => q({0}°C),
					},
					# Long Unit Identifier
					'temperature-fahrenheit' => {
						'name' => q(deg. F),
						'one' => q({0}°F),
						'other' => q({0}°F),
					},
					# Core Unit Identifier
					'fahrenheit' => {
						'name' => q(deg. F),
						'one' => q({0}°F),
						'other' => q({0}°F),
					},
					# Long Unit Identifier
					'temperature-generic' => {
						'name' => q(°),
						'one' => q({0}°),
						'other' => q({0}°),
					},
					# Core Unit Identifier
					'generic' => {
						'name' => q(°),
						'one' => q({0}°),
						'other' => q({0}°),
					},
					# Long Unit Identifier
					'temperature-kelvin' => {
						'name' => q(K),
						'one' => q({0} K),
						'other' => q({0} K),
					},
					# Core Unit Identifier
					'kelvin' => {
						'name' => q(K),
						'one' => q({0} K),
						'other' => q({0} K),
					},
					# Long Unit Identifier
					'volume-acre-foot' => {
						'name' => q(acre ft),
						'one' => q({0} ac ft),
						'other' => q({0} ac ft),
					},
					# Core Unit Identifier
					'acre-foot' => {
						'name' => q(acre ft),
						'one' => q({0} ac ft),
						'other' => q({0} ac ft),
					},
					# Long Unit Identifier
					'volume-barrel' => {
						'name' => q(بېرل),
					},
					# Core Unit Identifier
					'barrel' => {
						'name' => q(بېرل),
					},
					# Long Unit Identifier
					'volume-bushel' => {
						'name' => q(بوشیل),
						'one' => q({0} bu),
						'other' => q({0} bu),
					},
					# Core Unit Identifier
					'bushel' => {
						'name' => q(بوشیل),
						'one' => q({0} bu),
						'other' => q({0} bu),
					},
					# Long Unit Identifier
					'volume-centiliter' => {
						'name' => q(cL),
						'one' => q({0} cL),
						'other' => q({0} cL),
					},
					# Core Unit Identifier
					'centiliter' => {
						'name' => q(cL),
						'one' => q({0} cL),
						'other' => q({0} cL),
					},
					# Long Unit Identifier
					'volume-cubic-centimeter' => {
						'name' => q(cm³),
						'one' => q({0} cm³),
						'other' => q({0} cm³),
						'per' => q({0}/cm³),
					},
					# Core Unit Identifier
					'cubic-centimeter' => {
						'name' => q(cm³),
						'one' => q({0} cm³),
						'other' => q({0} cm³),
						'per' => q({0}/cm³),
					},
					# Long Unit Identifier
					'volume-cubic-foot' => {
						'name' => q(feet³),
						'one' => q({0} ft³),
						'other' => q({0} ft³),
					},
					# Core Unit Identifier
					'cubic-foot' => {
						'name' => q(feet³),
						'one' => q({0} ft³),
						'other' => q({0} ft³),
					},
					# Long Unit Identifier
					'volume-cubic-inch' => {
						'name' => q(inches³),
						'one' => q({0} in³),
						'other' => q({0} in³),
					},
					# Core Unit Identifier
					'cubic-inch' => {
						'name' => q(inches³),
						'one' => q({0} in³),
						'other' => q({0} in³),
					},
					# Long Unit Identifier
					'volume-cubic-kilometer' => {
						'name' => q(km³),
						'one' => q({0} km³),
						'other' => q({0} km³),
					},
					# Core Unit Identifier
					'cubic-kilometer' => {
						'name' => q(km³),
						'one' => q({0} km³),
						'other' => q({0} km³),
					},
					# Long Unit Identifier
					'volume-cubic-meter' => {
						'name' => q(m³),
						'one' => q({0} m³),
						'other' => q({0} m³),
						'per' => q({0}/m³),
					},
					# Core Unit Identifier
					'cubic-meter' => {
						'name' => q(m³),
						'one' => q({0} m³),
						'other' => q({0} m³),
						'per' => q({0}/m³),
					},
					# Long Unit Identifier
					'volume-cubic-mile' => {
						'name' => q(mi³),
						'one' => q({0} mi³),
						'other' => q({0} mi³),
					},
					# Core Unit Identifier
					'cubic-mile' => {
						'name' => q(mi³),
						'one' => q({0} mi³),
						'other' => q({0} mi³),
					},
					# Long Unit Identifier
					'volume-cubic-yard' => {
						'name' => q(yards³),
						'one' => q({0} yd³),
						'other' => q({0} yd³),
					},
					# Core Unit Identifier
					'cubic-yard' => {
						'name' => q(yards³),
						'one' => q({0} yd³),
						'other' => q({0} yd³),
					},
					# Long Unit Identifier
					'volume-cup' => {
						'name' => q(پيالې),
						'one' => q({0} c),
						'other' => q({0} c),
					},
					# Core Unit Identifier
					'cup' => {
						'name' => q(پيالې),
						'one' => q({0} c),
						'other' => q({0} c),
					},
					# Long Unit Identifier
					'volume-cup-metric' => {
						'name' => q(mcup),
						'one' => q({0} mc),
						'other' => q({0} mc),
					},
					# Core Unit Identifier
					'cup-metric' => {
						'name' => q(mcup),
						'one' => q({0} mc),
						'other' => q({0} mc),
					},
					# Long Unit Identifier
					'volume-deciliter' => {
						'name' => q(dL),
						'one' => q({0} dL),
						'other' => q({0} dL),
					},
					# Core Unit Identifier
					'deciliter' => {
						'name' => q(dL),
						'one' => q({0} dL),
						'other' => q({0} dL),
					},
					# Long Unit Identifier
					'volume-dessert-spoon' => {
						'name' => q(dstspn),
						'one' => q({0} dstspn),
						'other' => q({0} dstspn),
					},
					# Core Unit Identifier
					'dessert-spoon' => {
						'name' => q(dstspn),
						'one' => q({0} dstspn),
						'other' => q({0} dstspn),
					},
					# Long Unit Identifier
					'volume-dessert-spoon-imperial' => {
						'name' => q(dstspn Imp),
					},
					# Core Unit Identifier
					'dessert-spoon-imperial' => {
						'name' => q(dstspn Imp),
					},
					# Long Unit Identifier
					'volume-dram' => {
						'name' => q(ډرام مایع),
						'one' => q({0} dram fl),
						'other' => q({0} dram fl),
					},
					# Core Unit Identifier
					'dram' => {
						'name' => q(ډرام مایع),
						'one' => q({0} dram fl),
						'other' => q({0} dram fl),
					},
					# Long Unit Identifier
					'volume-drop' => {
						'name' => q(څاڅک),
						'one' => q({0} څاڅک),
						'other' => q({0} څاڅک),
					},
					# Core Unit Identifier
					'drop' => {
						'name' => q(څاڅک),
						'one' => q({0} څاڅک),
						'other' => q({0} څاڅک),
					},
					# Long Unit Identifier
					'volume-fluid-ounce' => {
						'name' => q(fl oz),
						'one' => q({0} fl oz),
						'other' => q({0} fl oz),
					},
					# Core Unit Identifier
					'fluid-ounce' => {
						'name' => q(fl oz),
						'one' => q({0} fl oz),
						'other' => q({0} fl oz),
					},
					# Long Unit Identifier
					'volume-fluid-ounce-imperial' => {
						'name' => q(امپيريل مايع اونس),
					},
					# Core Unit Identifier
					'fluid-ounce-imperial' => {
						'name' => q(امپيريل مايع اونس),
					},
					# Long Unit Identifier
					'volume-gallon' => {
						'name' => q(gal),
						'one' => q({0} gal),
						'other' => q({0} gal),
						'per' => q({0}/gal US),
					},
					# Core Unit Identifier
					'gallon' => {
						'name' => q(gal),
						'one' => q({0} gal),
						'other' => q({0} gal),
						'per' => q({0}/gal US),
					},
					# Long Unit Identifier
					'volume-gallon-imperial' => {
						'name' => q(Imp. gal),
						'one' => q({0} gal Imp.),
						'other' => q({0} gal Imp.),
					},
					# Core Unit Identifier
					'gallon-imperial' => {
						'name' => q(Imp. gal),
						'one' => q({0} gal Imp.),
						'other' => q({0} gal Imp.),
					},
					# Long Unit Identifier
					'volume-hectoliter' => {
						'name' => q(hL),
						'one' => q({0} hL),
						'other' => q({0} hL),
					},
					# Core Unit Identifier
					'hectoliter' => {
						'name' => q(hL),
						'one' => q({0} hL),
						'other' => q({0} hL),
					},
					# Long Unit Identifier
					'volume-jigger' => {
						'one' => q({0} جګر),
						'other' => q({0} جګر),
					},
					# Core Unit Identifier
					'jigger' => {
						'one' => q({0} جګر),
						'other' => q({0} جګر),
					},
					# Long Unit Identifier
					'volume-liter' => {
						'name' => q(ليټرز),
						'one' => q({0} L),
						'other' => q({0} L),
						'per' => q({0}/L),
					},
					# Core Unit Identifier
					'liter' => {
						'name' => q(ليټرز),
						'one' => q({0} L),
						'other' => q({0} L),
						'per' => q({0}/L),
					},
					# Long Unit Identifier
					'volume-megaliter' => {
						'name' => q(ML),
						'one' => q({0} ML),
						'other' => q({0} ML),
					},
					# Core Unit Identifier
					'megaliter' => {
						'name' => q(ML),
						'one' => q({0} ML),
						'other' => q({0} ML),
					},
					# Long Unit Identifier
					'volume-milliliter' => {
						'name' => q(mL),
						'one' => q({0} mL),
						'other' => q({0} mL),
					},
					# Core Unit Identifier
					'milliliter' => {
						'name' => q(mL),
						'one' => q({0} mL),
						'other' => q({0} mL),
					},
					# Long Unit Identifier
					'volume-pinch' => {
						'name' => q(چنه),
						'one' => q({0} چنه),
						'other' => q({0} چنه),
					},
					# Core Unit Identifier
					'pinch' => {
						'name' => q(چنه),
						'one' => q({0} چنه),
						'other' => q({0} چنه),
					},
					# Long Unit Identifier
					'volume-pint' => {
						'name' => q(pints),
						'one' => q({0} pt),
						'other' => q({0} pt),
					},
					# Core Unit Identifier
					'pint' => {
						'name' => q(pints),
						'one' => q({0} pt),
						'other' => q({0} pt),
					},
					# Long Unit Identifier
					'volume-pint-metric' => {
						'name' => q(mpt),
						'one' => q({0} mpt),
						'other' => q({0} mpt),
					},
					# Core Unit Identifier
					'pint-metric' => {
						'name' => q(mpt),
						'one' => q({0} mpt),
						'other' => q({0} mpt),
					},
					# Long Unit Identifier
					'volume-quart' => {
						'name' => q(qts),
						'one' => q({0} qt),
						'other' => q({0} qt),
					},
					# Core Unit Identifier
					'quart' => {
						'name' => q(qts),
						'one' => q({0} qt),
						'other' => q({0} qt),
					},
					# Long Unit Identifier
					'volume-quart-imperial' => {
						'name' => q(qt Imp),
						'one' => q({0} qt Imp.),
						'other' => q({0} qt Imp.),
					},
					# Core Unit Identifier
					'quart-imperial' => {
						'name' => q(qt Imp),
						'one' => q({0} qt Imp.),
						'other' => q({0} qt Imp.),
					},
					# Long Unit Identifier
					'volume-tablespoon' => {
						'name' => q(tbsp),
						'one' => q({0} tbsp),
						'other' => q({0} tbsp),
					},
					# Core Unit Identifier
					'tablespoon' => {
						'name' => q(tbsp),
						'one' => q({0} tbsp),
						'other' => q({0} tbsp),
					},
					# Long Unit Identifier
					'volume-teaspoon' => {
						'name' => q(tsp),
						'one' => q({0} tsp),
						'other' => q({0} tsp),
					},
					# Core Unit Identifier
					'teaspoon' => {
						'name' => q(tsp),
						'one' => q({0} tsp),
						'other' => q({0} tsp),
					},
				},
			} }
);

has 'yesstr' => (
	is			=> 'ro',
	isa			=> RegexpRef,
	init_arg	=> undef,
	default		=> sub { qr'^(?i:هو|ه|yes|y)$' }
);

has 'nostr' => (
	is			=> 'ro',
	isa			=> RegexpRef,
	init_arg	=> undef,
	default		=> sub { qr'^(?i:نه|ن|no|n)$' }
);

has 'listPatterns' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
				start => q({0}, {1}),
				middle => q({0}, {1}),
				end => q({0}, {1}),
				2 => q({0} و {1}),
		} }
);

has 'default_numbering_system' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> 'arabext',
);

has native_numbering_system => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> 'arabext',
);

has 'minimum_grouping_digits' => (
	is			=>'ro',
	isa			=> Int,
	init_arg	=> undef,
	default		=> 1,
);

has 'number_symbols' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'arabext' => {
			'exponential' => q(×۱۰^),
			'infinity' => q(∞),
			'nan' => q(NaN),
			'perMille' => q(؉),
			'percentSign' => q(٪),
			'superscriptingExponent' => q(×),
			'timeSeparator' => q(:),
		},
		'latn' => {
			'decimal' => q(,),
			'exponential' => q(E),
			'group' => q(.),
			'infinity' => q(∞),
			'minusSign' => q(‎−),
			'nan' => q(NaN),
			'perMille' => q(‰),
			'percentSign' => q(%),
			'plusSign' => q(‎+),
			'superscriptingExponent' => q(×),
		},
	} }
);

has 'number_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		decimalFormat => {
			'long' => {
				'1000' => {
					'one' => '0K',
					'other' => '0K',
				},
				'10000' => {
					'one' => '00K',
					'other' => '00K',
				},
				'100000' => {
					'one' => '000K',
					'other' => '000K',
				},
				'1000000' => {
					'one' => '0M',
					'other' => '0M',
				},
				'10000000' => {
					'one' => '00M',
					'other' => '00M',
				},
				'100000000' => {
					'one' => '000M',
					'other' => '000M',
				},
				'1000000000' => {
					'one' => '0G',
					'other' => '0G',
				},
				'10000000000' => {
					'one' => '00G',
					'other' => '00G',
				},
				'100000000000' => {
					'one' => '000G',
					'other' => '000G',
				},
				'1000000000000' => {
					'one' => '0T',
					'other' => '0T',
				},
				'10000000000000' => {
					'one' => '00T',
					'other' => '00T',
				},
				'100000000000000' => {
					'one' => '000T',
					'other' => '000T',
				},
			},
			'short' => {
				'1000' => {
					'one' => '0K',
					'other' => '0K',
				},
				'10000' => {
					'one' => '00K',
					'other' => '00K',
				},
				'100000' => {
					'one' => '000K',
					'other' => '000K',
				},
				'1000000' => {
					'one' => '0M',
					'other' => '0M',
				},
				'10000000' => {
					'one' => '00M',
					'other' => '00M',
				},
				'100000000' => {
					'one' => '000M',
					'other' => '000M',
				},
				'1000000000' => {
					'one' => '0B',
					'other' => '0B',
				},
				'10000000000' => {
					'one' => '00B',
					'other' => '00B',
				},
				'100000000000' => {
					'one' => '000G',
					'other' => '000B',
				},
				'1000000000000' => {
					'one' => '0T',
					'other' => '0T',
				},
				'10000000000000' => {
					'one' => '00T',
					'other' => '00T',
				},
				'100000000000000' => {
					'one' => '000T',
					'other' => '000T',
				},
			},
		},
		percentFormat => {
			'default' => {
				'standard' => {
					'default' => '#,##0%',
				},
			},
		},
		scientificFormat => {
			'default' => {
				'standard' => {
					'default' => '#E0',
				},
			},
		},
} },
);

has 'number_currency_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'arabext' => {
			'pattern' => {
				'default' => {
					'standard' => {
						'positive' => '#,##0.00 ¤',
					},
				},
			},
		},
		'latn' => {
			'pattern' => {
				'default' => {
					'accounting' => {
						'negative' => '(¤#,##0.00)',
						'positive' => '¤#,##0.00',
					},
					'standard' => {
						'positive' => '#,##0.00 ¤',
					},
				},
			},
		},
} },
);

has 'currencies' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'AED' => {
			display_name => {
				'currency' => q(متحده عرب امارات درهم),
				'one' => q(UAE درهم),
				'other' => q(UAE درهمې),
			},
		},
		'AFA' => {
			display_name => {
				'currency' => q(افغانۍ \(1927–2002\)),
				'one' => q(افغانۍ \(1927–2002\)),
				'other' => q(افغانۍ \(1927–2002\)),
			},
		},
		'AFN' => {
			symbol => '؋',
			display_name => {
				'currency' => q(افغانۍ),
				'one' => q(افغانۍ),
				'other' => q(افغانۍ),
			},
		},
		'ALL' => {
			display_name => {
				'currency' => q(البانوي لک),
				'one' => q(البانوي لک),
				'other' => q(البانوي لکي),
			},
		},
		'AMD' => {
			display_name => {
				'currency' => q(ارمينيايي ډرام),
				'one' => q(ارمينيايي ډرام),
				'other' => q(ارمينيايي ډرامز),
			},
		},
		'ANG' => {
			display_name => {
				'currency' => q(هالېنډي انټيليايي ګيلډر),
				'one' => q(هالېنډې انټيليايي ګيلډر),
				'other' => q(هالېنډي انټيليايي ګيلډر),
			},
		},
		'AOA' => {
			display_name => {
				'currency' => q(انګولي کوانزا),
				'one' => q(انګولي کوانزا),
				'other' => q(انګولي کوانزې),
			},
		},
		'ARS' => {
			display_name => {
				'currency' => q(ارجنټاين پسو),
				'one' => q(ارجنټاين پسو),
				'other' => q(ارجنټاين پسوز),
			},
		},
		'AUD' => {
			symbol => 'A$',
			display_name => {
				'currency' => q(آسترالوي ډالر),
				'one' => q(آسترالوي ډالر),
				'other' => q(آسترالوي ډالرې),
			},
		},
		'AWG' => {
			display_name => {
				'currency' => q(اروبايي فلورن),
				'one' => q(اروبايي فلورن),
				'other' => q(اروبايي فلورن),
			},
		},
		'AZN' => {
			display_name => {
				'currency' => q(آزربايجاني منت),
				'one' => q(آزربايجاني منت),
				'other' => q(آزربايجاني منتس),
			},
		},
		'BAM' => {
			display_name => {
				'currency' => q(بوسنيا هرزګوينيايي بدلېدونکې مارک),
				'one' => q(بوسنيا هرزګوينيايي بدلېدونکي مارک),
				'other' => q(بوسنيا هرزګوينيايي بدلېدونکي مارکس),
			},
		},
		'BBD' => {
			display_name => {
				'currency' => q(باربيډين ډالر),
				'one' => q(باربيډين ډالر),
				'other' => q(باربيډين ډالرې),
			},
		},
		'BDT' => {
			display_name => {
				'currency' => q(بنګالۍ ټاکه),
				'one' => q(بنګالۍ ټاکه),
				'other' => q(بنګالۍ ټاکاس),
			},
		},
		'BGN' => {
			display_name => {
				'currency' => q(بلغاري ليو),
				'one' => q(بلغاري ليو),
				'other' => q(بلغاري ليوا),
			},
		},
		'BHD' => {
			display_name => {
				'currency' => q(بحريني دينار),
				'one' => q(بحريني دينار),
				'other' => q(بحريني دينارونه),
			},
		},
		'BIF' => {
			display_name => {
				'currency' => q(برونډي فرانک),
				'one' => q(برونډي فرانک),
				'other' => q(برونډي فرانکس),
			},
		},
		'BMD' => {
			display_name => {
				'currency' => q(برمودا ډالر),
				'one' => q(برمودي ډالر),
				'other' => q(برمودي ډالرې),
			},
		},
		'BND' => {
			display_name => {
				'currency' => q(برونايي ډالر),
				'one' => q(برونايي ډالر),
				'other' => q(برونايي ډالرې),
			},
		},
		'BOB' => {
			display_name => {
				'currency' => q(بوليوي بوليويانو),
				'one' => q(بوليوي بوليويانو),
				'other' => q(بوليوي بوليويانو),
			},
		},
		'BRL' => {
			display_name => {
				'currency' => q(برازيلي ريل),
				'one' => q(برازيلي ريل),
				'other' => q(برازيلي ريلز),
			},
		},
		'BSD' => {
			display_name => {
				'currency' => q(بهاماسي ډالر),
				'one' => q(بهاماسي ډالر),
				'other' => q(بهاماسي ډالرې),
			},
		},
		'BTN' => {
			display_name => {
				'currency' => q(بهوټانۍ انګولټرم),
				'one' => q(بهوټانۍ انګولټرم),
				'other' => q(بهوټانۍ انګولټرمس),
			},
		},
		'BWP' => {
			display_name => {
				'currency' => q(بوټسواني پولا),
				'one' => q(بوټسواني پولا),
				'other' => q(بوټسواني پولاز),
			},
		},
		'BYN' => {
			symbol => 'р.',
			display_name => {
				'currency' => q(بلاروسي روبل),
				'one' => q(بلاروسي روبل),
				'other' => q(بلاروسي روبلز),
			},
		},
		'BZD' => {
			display_name => {
				'currency' => q(بليز ډالر),
				'one' => q(بليز ډالر),
				'other' => q(بليز ډالرې),
			},
		},
		'CAD' => {
			symbol => 'CA$',
			display_name => {
				'currency' => q(کاناډايي ډالر),
				'one' => q(کاناډايي ډالر),
				'other' => q(کاناډايي ډالرې),
			},
		},
		'CDF' => {
			display_name => {
				'currency' => q(کانګولي فرانک),
				'one' => q(کانګولي فرانک),
				'other' => q(کانګولي فرانکس),
			},
		},
		'CHF' => {
			display_name => {
				'currency' => q(سويسي فرانک),
				'one' => q(سويسي فرانک),
				'other' => q(سويسي فرانکس),
			},
		},
		'CLP' => {
			display_name => {
				'currency' => q(چلي پسو),
				'one' => q(چلي پسو),
				'other' => q(چلي پسوز),
			},
		},
		'CNH' => {
			display_name => {
				'currency' => q(چيني يوان \(آف شور\)),
				'one' => q(چيني يوان \(آف شور\)),
				'other' => q(چيني يوان \(آف شور\)),
			},
		},
		'CNY' => {
			display_name => {
				'currency' => q(چيني يوان),
				'one' => q(چيني يوان),
				'other' => q(چيني يوان),
			},
		},
		'COP' => {
			display_name => {
				'currency' => q(کولمبين پسو),
				'one' => q(کولمبين پسو),
				'other' => q(کولمبين پسوز),
			},
		},
		'CRC' => {
			display_name => {
				'currency' => q(کوسټا ريکن کولون),
				'one' => q(کوسټا ريکن کولون),
				'other' => q(کوسټا ريکن کولونز),
			},
		},
		'CUC' => {
			display_name => {
				'currency' => q(کيوبايي بدلېدونکي پسو),
				'one' => q(کيوبايي بدلېدونکې پسو),
				'other' => q(کيوبايي بدلېدونکې پسوز),
			},
		},
		'CUP' => {
			display_name => {
				'currency' => q(کيوبايي پسو),
				'one' => q(کيوبايي پسو),
				'other' => q(کيوبايي پسوز),
			},
		},
		'CVE' => {
			display_name => {
				'currency' => q(کيپ وردين اسکوډو),
				'one' => q(کيپ وردين اسکوډو),
				'other' => q(کيپ وردين اسکوډوز),
			},
		},
		'CZK' => {
			display_name => {
				'currency' => q(چيک کرونا),
				'one' => q(چيک کرونا),
				'other' => q(چيک کروناز),
			},
		},
		'DJF' => {
			display_name => {
				'currency' => q(جبوتي فرانک),
				'one' => q(جبوتي فرانک),
				'other' => q(جبوتي فرانکس),
			},
		},
		'DKK' => {
			display_name => {
				'currency' => q(ډنمارکي کرون),
				'one' => q(ډنمارکي کرون),
				'other' => q(ډنمارکي کرونر),
			},
		},
		'DOP' => {
			display_name => {
				'currency' => q(دومينيکا پسو),
				'one' => q(دومينيکا پسو),
				'other' => q(دومينيکا پسوز),
			},
		},
		'DZD' => {
			display_name => {
				'currency' => q(الجيرين دينار),
				'one' => q(الجيرين دينار),
				'other' => q(الجيرين دينارې),
			},
		},
		'EGP' => {
			display_name => {
				'currency' => q(مصري پونډ),
				'one' => q(مصري پونډ),
				'other' => q(مصري پونډونه),
			},
		},
		'ERN' => {
			display_name => {
				'currency' => q(ايريټرين نکفا),
				'one' => q(ايريټرين نکفا),
				'other' => q(ايريټرين نکفاس),
			},
		},
		'ETB' => {
			display_name => {
				'currency' => q(ايتهوپيايي بر),
				'one' => q(ايتهوپيايي بر),
				'other' => q(ايتهوپيايي برز),
			},
		},
		'EUR' => {
			display_name => {
				'currency' => q(يورو),
				'one' => q(يورو),
				'other' => q(يوروز),
			},
		},
		'FJD' => {
			display_name => {
				'currency' => q(فجي ډالر),
				'one' => q(فجي ډالر),
				'other' => q(فجي ډالرې),
			},
		},
		'FKP' => {
			display_name => {
				'currency' => q(پاکلېنډ ټاپوګانو پونډ),
				'one' => q(پاکلېنډ ټاپوګانو پونډ),
				'other' => q(پاکلېنډ ټاپوګانو پونډز),
			},
		},
		'GBP' => {
			display_name => {
				'currency' => q(برتانوې پونډ),
				'one' => q(برتانوې پونډ),
				'other' => q(برتانوې پونډونه),
			},
		},
		'GEL' => {
			display_name => {
				'currency' => q(جارجیاېي لارې),
				'one' => q(جارجیا لاري),
				'other' => q(جارجیاېي لارېز),
			},
		},
		'GHS' => {
			display_name => {
				'currency' => q(ګانين سيډي),
				'one' => q(ګانين سيډي),
				'other' => q(ګانين سيډيز),
			},
		},
		'GIP' => {
			display_name => {
				'currency' => q(جبل الطارقي پونډ),
				'one' => q(جبل الطارقي پونډ),
				'other' => q(جبل الطارقي پونډونه),
			},
		},
		'GMD' => {
			display_name => {
				'currency' => q(ګيمبين دلاسې),
				'one' => q(ګيمبين دلاسې),
				'other' => q(ګيمبين دلاسېز),
			},
		},
		'GNF' => {
			display_name => {
				'currency' => q(ګنې فرانک),
				'one' => q(ګنې فرانک),
				'other' => q(ګنې فرانکس),
			},
		},
		'GTQ' => {
			display_name => {
				'currency' => q(ګويټيمالن کوټزل),
				'one' => q(ګويټيمالن کوټزل),
				'other' => q(ګويټيمالن کوټزلز),
			},
		},
		'GYD' => {
			display_name => {
				'currency' => q(ګايانيز ډالر),
				'one' => q(ګايانيز ډالر),
				'other' => q(ګايانيز ډالرز),
			},
		},
		'HKD' => {
			display_name => {
				'currency' => q(هانګ کانګ ډالر),
				'one' => q(هانګ کانګ ډالر),
				'other' => q(هانګ کانګ ډالرې),
			},
		},
		'HNL' => {
			display_name => {
				'currency' => q(هونډوران ليمپيرا),
				'one' => q(هونډوران ليمپيرا),
				'other' => q(هونډوران ليمپيراز),
			},
		},
		'HRK' => {
			display_name => {
				'currency' => q(کروشيايي کونا),
				'one' => q(کروشيايي کونا),
				'other' => q(کروشيايي کوناز),
			},
		},
		'HTG' => {
			display_name => {
				'currency' => q(هيټي ګورډ),
				'one' => q(هيټي ګورډ),
				'other' => q(هيټي ګورډز),
			},
		},
		'HUF' => {
			display_name => {
				'currency' => q(هنګري فورنټ),
				'one' => q(هنګري فورنټ),
				'other' => q(هنګري فورنټز),
			},
		},
		'IDR' => {
			display_name => {
				'currency' => q(انډونيشي روپيا),
				'one' => q(انډونيشي روپيا),
				'other' => q(انډونيشي روپۍ),
			},
		},
		'ILS' => {
			display_name => {
				'currency' => q(اسرايلي نيو شيکل),
				'one' => q(اسرايلي نيو شيکل),
				'other' => q(اسرايلي نيو شيکلز),
			},
		},
		'INR' => {
			display_name => {
				'currency' => q(هندي روپۍ),
				'one' => q(هندي روپۍ),
				'other' => q(هندي روپۍ),
			},
		},
		'IQD' => {
			display_name => {
				'currency' => q(عراقي دينار),
				'one' => q(عراقي دينار),
				'other' => q(عراقي دينارونه),
			},
		},
		'IRR' => {
			display_name => {
				'currency' => q(ايراني ريال),
				'one' => q(ايراني ريال),
				'other' => q(ايراني ريالونه),
			},
		},
		'ISK' => {
			display_name => {
				'currency' => q(آيسلېنډي کرونا),
				'one' => q(آيسلېنډي کرونا),
				'other' => q(آيسلېنډي کرونر),
			},
		},
		'JMD' => {
			display_name => {
				'currency' => q(جمايکايي ډالر),
				'one' => q(جمايکايي ډالر),
				'other' => q(جمايکايي ډالرې),
			},
		},
		'JOD' => {
			display_name => {
				'currency' => q(اردني دينار),
				'one' => q(اردني دينار),
				'other' => q(اردني دينارونه),
			},
		},
		'JPY' => {
			display_name => {
				'currency' => q(جاپاني ين),
				'one' => q(جاپاني ين),
				'other' => q(جاپاني ين),
			},
		},
		'KES' => {
			display_name => {
				'currency' => q(کينيايي شيلنګ),
				'one' => q(کينيايي شيلنګ),
				'other' => q(کينيايي شيلنګز),
			},
		},
		'KGS' => {
			display_name => {
				'currency' => q(کرغزستاني سوم),
				'one' => q(کرغزستاني سوم),
				'other' => q(کرغزستاني سومز),
			},
		},
		'KHR' => {
			display_name => {
				'currency' => q(کمبوډي ريل),
				'one' => q(کمبوډي ريل),
				'other' => q(کمبوډي ريلس),
			},
		},
		'KMF' => {
			display_name => {
				'currency' => q(کوموري فرانک),
				'one' => q(کوموري فرانک),
				'other' => q(کوموري فرانکس),
			},
		},
		'KPW' => {
			display_name => {
				'currency' => q(شمالي کوريايي وان),
				'one' => q(شمالي کوريايي وان),
				'other' => q(شمالي کوريايي وان),
			},
		},
		'KRW' => {
			display_name => {
				'currency' => q(جنوبي کوريايي وان),
				'one' => q(جنوبي کوريايي وان),
				'other' => q(جنوبي کوريايي وان),
			},
		},
		'KWD' => {
			display_name => {
				'currency' => q(کويتي دينار),
				'one' => q(کويتي دينار),
				'other' => q(کويتي دينارونه),
			},
		},
		'KYD' => {
			display_name => {
				'currency' => q(کيمن ټاپوګانو ډالر),
				'one' => q(کيمن ټاپوګانو ډالر),
				'other' => q(کيمن ټاپوګانو ډالرې),
			},
		},
		'KZT' => {
			display_name => {
				'currency' => q(قازقستاني ټينج),
				'one' => q(قازقستاني ټينج),
				'other' => q(قازقستاني ټينجز),
			},
		},
		'LAK' => {
			display_name => {
				'currency' => q(لاشې کپ),
				'one' => q(لاشې کپ),
				'other' => q(لاشې کپس),
			},
		},
		'LBP' => {
			display_name => {
				'currency' => q(لبناني پونډ),
				'one' => q(لبناني پونډ),
				'other' => q(لبناني پونډونه),
			},
		},
		'LKR' => {
			display_name => {
				'currency' => q(سري لنکن روپۍ),
				'one' => q(سري لنکن روپۍ),
				'other' => q(سري لنکن روپۍ),
			},
		},
		'LRD' => {
			display_name => {
				'currency' => q(لايبيرين ډالر),
				'one' => q(لايبيرين ډالر),
				'other' => q(لايبيرين ډالرې),
			},
		},
		'LSL' => {
			display_name => {
				'currency' => q(Lesotho Loti),
				'one' => q(Lesotho loti),
				'other' => q(Lesotho lotis),
			},
		},
		'LYD' => {
			display_name => {
				'currency' => q(ليبياېي دينار),
				'one' => q(ليبياېي دينار),
				'other' => q(ليبياېي دينارونه),
			},
		},
		'MAD' => {
			display_name => {
				'currency' => q(مراکشي درهم),
				'one' => q(مراکشي درهم),
				'other' => q(مراکشي درهمونه),
			},
		},
		'MDL' => {
			display_name => {
				'currency' => q(مالډوي ليو),
				'one' => q(مالډوي ليو),
				'other' => q(مالډوي لي),
			},
		},
		'MGA' => {
			display_name => {
				'currency' => q(ملاګاسي ارياري),
				'one' => q(ملاګاسي ارياري),
				'other' => q(ملاګاسي ارياريز),
			},
		},
		'MKD' => {
			display_name => {
				'currency' => q(مسيډونايي دينار),
				'one' => q(مسيډونايي دينار),
				'other' => q(مسيډونايي دينارې),
			},
		},
		'MMK' => {
			display_name => {
				'currency' => q(ميانماري کيات),
				'one' => q(ميانماري کيات),
				'other' => q(ميانماري کياتې),
			},
		},
		'MNT' => {
			display_name => {
				'currency' => q(منګوليايي توګريک),
				'one' => q(منګوليايي توګريک),
				'other' => q(منګوليايي توګريکس),
			},
		},
		'MOP' => {
			display_name => {
				'currency' => q(مکانيس پټاکا),
				'one' => q(مکانيس پټاکا),
				'other' => q(مکانيز پټاکاز),
			},
		},
		'MRU' => {
			display_name => {
				'currency' => q(موريشيسي ډالر),
				'one' => q(موريشيسي ډالر),
				'other' => q(موريشيسي ډالرې),
			},
		},
		'MUR' => {
			display_name => {
				'currency' => q(موريشيسي روپۍ),
				'one' => q(موريشيسي روپۍ),
				'other' => q(موريشيسي روپۍ),
			},
		},
		'MVR' => {
			display_name => {
				'currency' => q(مالديپي روپيا),
				'one' => q(مالديپي روپيا),
				'other' => q(مالديپي روپيا),
			},
		},
		'MWK' => {
			display_name => {
				'currency' => q(ملاوي کواچا),
				'one' => q(ملاوي کواچا),
				'other' => q(ملاوي کواچاز),
			},
		},
		'MXN' => {
			display_name => {
				'currency' => q(ميکسيکن پيسو),
				'one' => q(ميکسيکن پيسو),
				'other' => q(ميکسيکن پيسوز),
			},
		},
		'MYR' => {
			display_name => {
				'currency' => q(ملايشي رنګټ),
				'one' => q(ملايشي رنګټ),
				'other' => q(ملايشي رنګټې),
			},
		},
		'MZN' => {
			display_name => {
				'currency' => q(موزمبيقي ميټيکل),
				'one' => q(موزمبيقي ميټيکل),
				'other' => q(موزمبيقي ميټيکلز),
			},
		},
		'NAD' => {
			display_name => {
				'currency' => q(نيميبيايي ډالر),
				'one' => q(بيميبيايي ډالر),
				'other' => q(نيميبيايي ډالرې),
			},
		},
		'NGN' => {
			display_name => {
				'currency' => q(نايجيري نايرا),
				'one' => q(نايجيري نايرا),
				'other' => q(نايجيري نايراز),
			},
		},
		'NIO' => {
			symbol => 'C$',
			display_name => {
				'currency' => q(نيکاراګون کورډوبا),
				'one' => q(نيکاراګون کورډوبا),
				'other' => q(نيکاراګون کورډوباز),
			},
		},
		'NOK' => {
			display_name => {
				'currency' => q(نارويجين کرون),
				'one' => q(نارويجين کرون),
				'other' => q(نارويجين کرونر),
			},
		},
		'NPR' => {
			display_name => {
				'currency' => q(نيپالي روپۍ),
				'one' => q(نيپالي روپۍ),
				'other' => q(نيپالي روپۍ),
			},
		},
		'NZD' => {
			display_name => {
				'currency' => q(نيوزي لينډي ډالر),
				'one' => q(نيوزي لينډي ډالر),
				'other' => q(نيوزي لينډي ډالرې),
			},
		},
		'OMR' => {
			display_name => {
				'currency' => q(عماني ريال),
				'one' => q(عماني ريال),
				'other' => q(عماني ريالونه),
			},
		},
		'PAB' => {
			display_name => {
				'currency' => q(پانامۍ بالبوا),
				'one' => q(پانامۍ بالبوا),
				'other' => q(پانامۍ بالبوې),
			},
		},
		'PEN' => {
			display_name => {
				'currency' => q(پيروين سول),
				'one' => q(پيروين سول),
				'other' => q(پيروين سولز),
			},
		},
		'PGK' => {
			display_name => {
				'currency' => q(پاپوا نيوګاني کينا),
				'one' => q(پاپوا نيوګاني کينا),
				'other' => q(پاپوا نيوګاني کينا),
			},
		},
		'PHP' => {
			display_name => {
				'currency' => q(فلپاينۍ پسو),
				'one' => q(فلپاينۍ پسو),
				'other' => q(فلپاينۍ پسوز),
			},
		},
		'PKR' => {
			display_name => {
				'currency' => q(پاکستانۍ کلداره),
				'one' => q(پاکستانۍ کلداره),
				'other' => q(پاکستانۍ کلدارې),
			},
		},
		'PLN' => {
			display_name => {
				'currency' => q(پولينډي زلوټي),
				'one' => q(پولينډي زلوټي),
				'other' => q(پولينډي زلوټيز),
			},
		},
		'PYG' => {
			display_name => {
				'currency' => q(پيراګوين ګوراني),
				'one' => q(پيراګوين ګوراني),
				'other' => q(پيراګوين ګوراني),
			},
		},
		'QAR' => {
			display_name => {
				'currency' => q(قطري ريال),
				'one' => q(قطري ريال),
				'other' => q(قطري ريالونه),
			},
		},
		'RON' => {
			display_name => {
				'currency' => q(روماني ليو),
				'one' => q(روماني ليو),
				'other' => q(روماني لي),
			},
		},
		'RSD' => {
			display_name => {
				'currency' => q(سربيايي دينار),
				'one' => q(سربيايي دينار),
				'other' => q(سربيايي دينارې),
			},
		},
		'RUB' => {
			display_name => {
				'currency' => q(روسي روبل),
				'one' => q(روسي روبل),
				'other' => q(روسي روبلز),
			},
		},
		'RWF' => {
			display_name => {
				'currency' => q(روانډي فرانک),
				'one' => q(روانډي فرانک),
				'other' => q(روانډي فرانکس),
			},
		},
		'SAR' => {
			display_name => {
				'currency' => q(سعودي ريال),
				'one' => q(سعودي ريال),
				'other' => q(سعودي ريالونه),
			},
		},
		'SBD' => {
			display_name => {
				'currency' => q(سولومن ټاپوګانو ډالر),
				'one' => q(سولومن ټاپوګانو ډالر),
				'other' => q(سولومن ټاپوګانو ډالرې),
			},
		},
		'SCR' => {
			display_name => {
				'currency' => q(سيچيليسي روپۍ),
				'one' => q(سيچيليسي روپۍ),
				'other' => q(سيچيليسي روپۍ),
			},
		},
		'SDG' => {
			display_name => {
				'currency' => q(سوډاني پونډ),
				'one' => q(سوډاني پونډ),
				'other' => q(سوډاني پونډونه),
			},
		},
		'SEK' => {
			display_name => {
				'currency' => q(سويډني کرونا),
				'one' => q(سويډني کرونا),
				'other' => q(سويډني کرونر),
			},
		},
		'SGD' => {
			symbol => 'SGD',
			display_name => {
				'currency' => q(سنګاپور ډالر),
				'one' => q(سنګاپور ډالر),
				'other' => q(سنګاپور ډالرې),
			},
		},
		'SHP' => {
			display_name => {
				'currency' => q(سينټ هيلينا پونډ),
				'one' => q(سينټ هيلينا پونډ),
				'other' => q(سينټ هيلينا پونډونه),
			},
		},
		'SLL' => {
			display_name => {
				'currency' => q(سيرا ليوني ليون),
				'one' => q(سيرا ليوني ليون),
				'other' => q(سيرا ليوني ليونونه),
			},
		},
		'SOS' => {
			display_name => {
				'currency' => q(سومالي شيلنګ),
				'one' => q(سومالي شيلنګ),
				'other' => q(سومالي شيلنګز),
			},
		},
		'SRD' => {
			display_name => {
				'currency' => q(سورينيمي ډالر),
				'one' => q(سورينيمي ډالر),
				'other' => q(سورينيمي ډالرې),
			},
		},
		'SSP' => {
			display_name => {
				'currency' => q(جنوب سوډاني پونډ),
			},
		},
		'STN' => {
			display_name => {
				'currency' => q(ساو ټوم او پرينسپي ډوبرا),
				'one' => q(ساو ټوم او پرينسپي ډوبرا),
				'other' => q(ساو ټوم او پرينسپي ډوبراس),
			},
		},
		'SYP' => {
			display_name => {
				'currency' => q(سوريايي پونډ),
				'one' => q(سوريايي پونډ),
				'other' => q(سوريايي پونډونه),
			},
		},
		'SZL' => {
			display_name => {
				'currency' => q(سوازي ليلانګيني),
				'one' => q(سوازي ليلانګيني),
				'other' => q(سوازي ايمالانګيني),
			},
		},
		'THB' => {
			symbol => 'THB',
			display_name => {
				'currency' => q(تهايي بات),
				'one' => q(تهايي بات),
				'other' => q(تهايي باتونه),
			},
		},
		'TJS' => {
			display_name => {
				'currency' => q(تاجکستاني سوموني),
				'one' => q(تاجکستاني سوموني),
				'other' => q(تاجکستاني سومونيونه),
			},
		},
		'TMT' => {
			display_name => {
				'currency' => q(ترکمانستاني منت),
				'one' => q(ترکمانستاني منت),
				'other' => q(ترکمانستاني منت),
			},
		},
		'TND' => {
			display_name => {
				'currency' => q(تيونسې دينار),
				'one' => q(تيونسې دينار),
				'other' => q(تونسي دينار),
			},
		},
		'TOP' => {
			display_name => {
				'currency' => q(ټونګن پانګا),
				'one' => q(ټونګن پانګا),
				'other' => q(ټونګن پانګا),
			},
		},
		'TRY' => {
			display_name => {
				'currency' => q(ترکي ليرا),
				'one' => q(ترکي ليرا),
				'other' => q(ترکي ليرا),
			},
		},
		'TTD' => {
			display_name => {
				'currency' => q(ټرينيډاډ او ټوباګو ډالر),
				'one' => q(ټرينيډاډ او ټوباګو ډالر),
				'other' => q(ټرينيډاډ او ټوباګو ډالرې),
			},
		},
		'TWD' => {
			display_name => {
				'currency' => q(نيو تائيواني ډالر),
				'one' => q(نيو تائيواني ډالر),
				'other' => q(نيو تائيواني ډالرې),
			},
		},
		'TZS' => {
			display_name => {
				'currency' => q(تنزاني شيلنګ),
				'one' => q(تنزاني شيلنګ),
				'other' => q(تنزاني شيلنګز),
			},
		},
		'UAH' => {
			display_name => {
				'currency' => q(اوکرايني هريونيا),
				'one' => q(اوکرايني هريونيا),
				'other' => q(اوکرايني هريونياز),
			},
		},
		'UGX' => {
			display_name => {
				'currency' => q(يوګانډي شيلنګ),
				'one' => q(يوګانډي شيلنګ),
				'other' => q(يوګانډي شيلنګز),
			},
		},
		'USD' => {
			symbol => '$',
			display_name => {
				'currency' => q(امريکايي ډالر),
				'one' => q(امريکايي ډالر),
				'other' => q(امريکايي ډالرې),
			},
		},
		'UYU' => {
			display_name => {
				'currency' => q(يوراګوي پسو),
				'one' => q(يوراګوي پسو),
				'other' => q(يوراګوي پسوز),
			},
		},
		'UZS' => {
			display_name => {
				'currency' => q(ازبکستاني سوم),
				'one' => q(ازبکستاني سوم),
				'other' => q(ازبکستاني سوم),
			},
		},
		'VES' => {
			display_name => {
				'currency' => q(وينزويلي بوليوار),
				'one' => q(وينزويلي بوليوار),
				'other' => q(وينزويلي بوليوارز),
			},
		},
		'VND' => {
			symbol => '₫',
			display_name => {
				'currency' => q(ويتنامي ډونګ),
				'one' => q(ويتنامي ډونګ),
				'other' => q(ويتنامي ډونګ),
			},
		},
		'VUV' => {
			display_name => {
				'currency' => q(ونواتو واتو),
				'one' => q(ونواتو واتو),
				'other' => q(ونواتو واتوس),
			},
		},
		'WST' => {
			display_name => {
				'currency' => q(سموون تالا),
				'one' => q(سموون تالا),
				'other' => q(سموون تالا),
			},
		},
		'XAF' => {
			display_name => {
				'currency' => q(مرکزي افريقايي CFA فرانک),
				'one' => q(مرکزي افريقايي CFA فرانک),
				'other' => q(مرکزي افريقايي CFA فرانکس),
			},
		},
		'XCD' => {
			display_name => {
				'currency' => q(ختيځ کربين ډالر),
				'one' => q(ختيځ کربين ډالر),
				'other' => q(ختيځ کربين ډالرې),
			},
		},
		'XOF' => {
			display_name => {
				'currency' => q(ختيځ افريقايي CFA فرانک),
				'one' => q(ختيځ افريقايي CFA فرانک),
				'other' => q(ختيځ افريقايي CFA فرانکس),
			},
		},
		'XPF' => {
			display_name => {
				'currency' => q(CFP فرانک),
				'one' => q(CFP فرانک),
				'other' => q(CFP فرانکس),
			},
		},
		'XXX' => {
			display_name => {
				'currency' => q(نامعلومه مروجه پېسې),
				'one' => q(\(د نامعلومه مروجه پېسو واحد\)),
				'other' => q(\(نامعلومه مروجه پېسې\)),
			},
		},
		'YER' => {
			display_name => {
				'currency' => q(يمني ريال),
				'one' => q(يمني ريال),
				'other' => q(يمني ريالونه),
			},
		},
		'ZAR' => {
			display_name => {
				'currency' => q(جنوبي افريقاېي رنډ),
				'one' => q(جنوبي افريقاېي رنډ),
				'other' => q(جنوبي افريقاېي رنډ),
			},
		},
		'ZMW' => {
			display_name => {
				'currency' => q(زيمبي کواچا),
				'one' => q(زيمبي کواچا),
				'other' => q(زيمبي کواچاز),
			},
		},
	} },
);


has 'calendar_months' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'جنوري',
							'فبروري',
							'مارچ',
							'اپریل',
							'مۍ',
							'جون',
							'جولای',
							'اګست',
							'سېپتمبر',
							'اکتوبر',
							'نومبر',
							'دسمبر'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'ج',
							'ف',
							'م',
							'ا',
							'م',
							'ج',
							'ج',
							'ا',
							'س',
							'ا',
							'ن',
							'د'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'جنوري',
							'فبروري',
							'مارچ',
							'اپریل',
							'مۍ',
							'جون',
							'جولای',
							'اګست',
							'سېپتمبر',
							'اکتوبر',
							'نومبر',
							'دسمبر'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'جنوري',
							'فبروري',
							'مارچ',
							'اپریل',
							'مۍ',
							'جون',
							'جولای',
							'اګست',
							'سپتمبر',
							'اکتوبر',
							'نومبر',
							'دسمبر'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'1',
							'2',
							'3',
							'4',
							'5',
							'6',
							'7',
							'8',
							'9',
							'10',
							'11',
							'12'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'جنوري',
							'فېبروري',
							'مارچ',
							'اپریل',
							'مۍ',
							'جون',
							'جولای',
							'اګست',
							'سپتمبر',
							'اکتوبر',
							'نومبر',
							'دسمبر'
						],
						leap => [
							
						],
					},
				},
			},
			'indian' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'چيترا',
							'ويساکا',
							'جياستا',
							'اسادها',
							'سراوانا',
							'بهادرا',
							'اسوينا',
							'کارتيکا',
							'اگراهايانا',
							'پاوسا',
							'مگها',
							'پهالگونا'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'1',
							'2',
							'3',
							'4',
							'5',
							'6',
							'7',
							'8',
							'9',
							'10',
							'11',
							'12'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'چيترا',
							'ويساکا',
							'جياستا',
							'اسادها',
							'سراوانا',
							'بهادرا',
							'اسوينا',
							'کارتيکا',
							'اگراهايانا',
							'پاوسا',
							'مگها',
							'پهالگونا'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'چيترا',
							'ويساکا',
							'جياستا',
							'اسادها',
							'سراوانا',
							'بهادرا',
							'اسوينا',
							'کارتيکا',
							'اگراهايانا',
							'پاوسا',
							'مگها',
							'پهالگونا'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'1',
							'2',
							'3',
							'4',
							'5',
							'6',
							'7',
							'8',
							'9',
							'10',
							'11',
							'12'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'چيترا',
							'ويساکا',
							'جياستا',
							'اسادها',
							'سراوانا',
							'بهادرا',
							'اسوينا',
							'کارتيکا',
							'اگراهايانا',
							'پاوسا',
							'مگها',
							'پهالگونا'
						],
						leap => [
							
						],
					},
				},
			},
			'islamic' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'محرم',
							'صفر',
							'ربيع',
							'ربيع II',
							'جماد ۱',
							'جماد ۲',
							'رجب',
							'شعبان',
							'رمضان',
							'شوال',
							'دالقاعده',
							'ذي الحج'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'1',
							'2',
							'3',
							'4',
							'5',
							'6',
							'7',
							'8',
							'9',
							'10',
							'11',
							'12'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'محرم',
							'صفر',
							'ربيع',
							'ربيع II',
							'جماعه',
							'جموما II',
							'رجب',
							'شعبان',
							'رمضان',
							'شوال',
							'ذي القعده',
							'ذي الحج'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'محرم',
							'صفر',
							'ربيع',
							'ربيع II',
							'جماعه',
							'جمادي ۲',
							'رجب',
							'شعبان',
							'رمضان',
							'شوال',
							'دالقاعده',
							'ذي الحج'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'1',
							'2',
							'3',
							'4',
							'5',
							'6',
							'7',
							'8',
							'9',
							'10',
							'11',
							'12'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'محرم',
							'صفر',
							'ربيع',
							'ربيع II',
							'جماعه',
							'جموما II',
							'رجب',
							'شعبان',
							'رمضان',
							'شوال',
							'دالقاعده',
							'ذي الحج'
						],
						leap => [
							
						],
					},
				},
			},
			'persian' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'وری',
							'غویی',
							'غبرگولی',
							'چنگاښ',
							'زمری',
							'وږی',
							'تله',
							'لړم',
							'لیندۍ',
							'مرغومی',
							'سلواغه',
							'کب'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'۱',
							'۲',
							'۳',
							'۴',
							'۵',
							'۶',
							'۷',
							'۸',
							'۹',
							'۱۰',
							'۱۱',
							'۱۲'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'وری',
							'غویی',
							'غبرگولی',
							'چنگاښ',
							'زمری',
							'وږی',
							'تله',
							'لړم',
							'لیندۍ',
							'مرغومی',
							'سلواغه',
							'کب'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'وری',
							'غویی',
							'غبرگولی',
							'چنگاښ',
							'زمری',
							'وږی',
							'تله',
							'لړم',
							'لیندۍ',
							'مرغومی',
							'سلواغه',
							'کب'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'۱',
							'۲',
							'۳',
							'۴',
							'۵',
							'۶',
							'۷',
							'۸',
							'۹',
							'۱۰',
							'۱۱',
							'۱۲'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'وری',
							'غویی',
							'غبرگولی',
							'چنگاښ',
							'زمری',
							'وږی',
							'تله',
							'لړم',
							'لیندۍ',
							'مرغومی',
							'سلواغه',
							'کب'
						],
						leap => [
							
						],
					},
				},
			},
	} },
);

has 'calendar_days' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {
						mon => 'دونۍ',
						tue => 'درېنۍ',
						wed => 'څلرنۍ',
						thu => 'پينځنۍ',
						fri => 'جمعه',
						sat => 'اونۍ',
						sun => 'يونۍ'
					},
					narrow => {
						mon => 'M',
						tue => 'T',
						wed => 'W',
						thu => 'T',
						fri => 'F',
						sat => 'S',
						sun => 'S'
					},
					short => {
						mon => 'دونۍ',
						tue => 'درېنۍ',
						wed => 'څلرنۍ',
						thu => 'پينځنۍ',
						fri => 'جمعه',
						sat => 'اونۍ',
						sun => 'يونۍ'
					},
					wide => {
						mon => 'دونۍ',
						tue => 'درېنۍ',
						wed => 'څلرنۍ',
						thu => 'پينځنۍ',
						fri => 'جمعه',
						sat => 'اونۍ',
						sun => 'يونۍ'
					},
				},
				'stand-alone' => {
					abbreviated => {
						mon => 'دونۍ',
						tue => 'درېنۍ',
						wed => 'څلرنۍ',
						thu => 'پينځنۍ',
						fri => 'جمعه',
						sat => 'اونۍ',
						sun => 'يونۍ'
					},
					narrow => {
						mon => 'M',
						tue => 'T',
						wed => 'W',
						thu => 'T',
						fri => 'F',
						sat => 'S',
						sun => 'S'
					},
					short => {
						mon => 'دونۍ',
						tue => 'درېنۍ',
						wed => 'څلرنۍ',
						thu => 'پينځنۍ',
						fri => 'جمعه',
						sat => 'اونۍ',
						sun => 'يونۍ'
					},
					wide => {
						mon => 'دونۍ',
						tue => 'درېنۍ',
						wed => 'څلرنۍ',
						thu => 'پينځنۍ',
						fri => 'جمعه',
						sat => 'اونۍ',
						sun => 'يونۍ'
					},
				},
			},
	} },
);

has 'calendar_quarters' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {0 => 'لومړۍ ربعه',
						1 => '۲مه ربعه',
						2 => '۳مه ربعه',
						3 => '۴مه ربعه'
					},
					narrow => {0 => '1',
						1 => '2',
						2 => '3',
						3 => '4'
					},
					wide => {0 => 'لومړۍ ربعه',
						1 => '۲مه ربعه',
						2 => '۳مه ربعه',
						3 => '۴مه ربعه'
					},
				},
				'stand-alone' => {
					abbreviated => {0 => 'لومړۍ ربعه',
						1 => '۲مه ربعه',
						2 => '۳مه ربعه',
						3 => '۴مه ربعه'
					},
					narrow => {0 => '1',
						1 => '2',
						2 => '3',
						3 => '4'
					},
					wide => {0 => 'لومړۍ ربعه',
						1 => '۲مه ربعه',
						2 => '۳مه ربعه',
						3 => '۴مه ربعه'
					},
				},
			},
	} },
);

has 'day_periods' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			'format' => {
				'abbreviated' => {
					'am' => q{غ.م.},
					'pm' => q{غ.و.},
				},
				'narrow' => {
					'am' => q{غ.م.},
					'pm' => q{غ.و.},
				},
				'wide' => {
					'am' => q{غ.م.},
					'pm' => q{غ.و.},
				},
			},
			'stand-alone' => {
				'abbreviated' => {
					'am' => q{غ.م.},
					'pm' => q{غ.و.},
				},
				'narrow' => {
					'am' => q{غ.م.},
					'pm' => q{غ.و.},
				},
				'wide' => {
					'am' => q{غ.م.},
					'pm' => q{غ.و.},
				},
			},
		},
	} },
);

has 'eras' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
		},
		'gregorian' => {
			abbreviated => {
				'0' => 'له میلاد وړاندې',
				'1' => 'م.'
			},
			narrow => {
				'1' => 'م.'
			},
			wide => {
				'0' => 'له میلاد څخه وړاندې',
				'1' => 'له میلاد څخه وروسته'
			},
		},
		'indian' => {
			abbreviated => {
				'0' => 'ساکا'
			},
			narrow => {
				'0' => 'ساکا'
			},
			wide => {
				'0' => 'ساکا'
			},
		},
		'islamic' => {
			abbreviated => {
				'0' => 'AH'
			},
		},
		'persian' => {
			abbreviated => {
				'0' => 'AP'
			},
		},
	} },
);

has 'date_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			'full' => q{EEEE د G y د MMMM d},
			'long' => q{د G y د MMMM d},
			'medium' => q{G y MMM d},
			'short' => q{GGGGG y/M/d},
		},
		'gregorian' => {
			'full' => q{EEEE د y د MMMM d},
			'long' => q{د y د MMMM d},
			'medium' => q{y MMM d},
			'short' => q{y/M/d},
		},
		'indian' => {
		},
		'islamic' => {
			'full' => q{EEEE د G y د MMMM d},
			'long' => q{د G y د MMMM d},
			'medium' => q{G y MMM d},
			'short' => q{GGGGG y/M/d},
		},
		'persian' => {
		},
	} },
);

has 'time_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
		},
		'gregorian' => {
			'full' => q{H:mm:ss (zzzz)},
			'long' => q{H:mm:ss (z)},
			'medium' => q{H:mm:ss},
			'short' => q{H:mm},
		},
		'indian' => {
		},
		'islamic' => {
		},
		'persian' => {
		},
	} },
);

has 'datetime_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			'full' => q{{1} {0}},
			'long' => q{{1} {0}},
			'medium' => q{{1} {0}},
			'short' => q{{1} {0}},
		},
		'gregorian' => {
			'full' => q{{1} {0}},
			'long' => q{{1} {0}},
			'medium' => q{{1} {0}},
			'short' => q{{1} {0}},
		},
		'indian' => {
		},
		'islamic' => {
		},
		'persian' => {
		},
	} },
);

has 'datetime_formats_available_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			Bhm => q{h:mm B},
			Bhms => q{h:mm:ss B},
			E => q{ccc},
			EBhm => q{E h:mm B},
			EBhms => q{E h:mm:ss B},
			EHm => q{E HH:mm},
			EHms => q{E HH:mm:ss},
			Ed => q{d, E},
			Ehm => q{E h:mm a},
			Ehms => q{E h:mm:ss a},
			Gy => q{G y},
			GyMMM => q{G y MMM},
			GyMMMEd => q{G y MMM d, E},
			GyMMMd => q{G y MMM d},
			H => q{H},
			Hm => q{H:mm},
			Hms => q{H:mm:ss},
			M => q{L},
			MEd => q{MM-dd, E},
			MMM => q{LLL},
			MMMEd => q{MMM d, E},
			MMMMd => q{d MMMM},
			MMMd => q{MMM d},
			Md => q{M/d},
			d => q{d},
			h => q{h a},
			hm => q{h:mm a},
			hms => q{h:mm:ss a},
			ms => q{mm:ss},
			y => q{G y},
			yM => q{G y/M},
			yMMMM => q{د G y د MMMM},
			yyyy => q{G y},
			yyyyM => q{GGGGG y-MM},
			yyyyMEd => q{GGGGG y-MM-dd, E},
			yyyyMMM => q{G y MMM},
			yyyyMMMEd => q{G y MMM d, E},
			yyyyMMMM => q{G y MMMM},
			yyyyMMMd => q{G y MMM d},
			yyyyMd => q{GGGGG y-MM-dd},
			yyyyQQQ => q{G y QQQ},
			yyyyQQQQ => q{G y QQQQ},
		},
		'gregorian' => {
			Bh => q{h B},
			Bhm => q{h:mm B},
			Bhms => q{h:mm:ss B},
			EBhm => q{E h:mm B},
			EBhms => q{E h:mm:ss B},
			EHm => q{E HH:mm},
			EHms => q{E HH:mm:ss},
			Ed => q{d, E},
			Ehm => q{E h:mm a},
			Ehms => q{E h:mm:ss a},
			Gy => q{G y},
			GyMMM => q{G y MMM},
			GyMMMEd => q{G y MMM d, E},
			GyMMMd => q{G y MMM d},
			GyMd => q{M/d/y GGGGG},
			H => q{HH},
			Hm => q{HH:mm},
			Hms => q{HH:mm:ss},
			Hmsv => q{HH:mm:ss v},
			Hmv => q{HH:mm v},
			M => q{L},
			MEd => q{MM-dd, E},
			MMM => q{LLL},
			MMMEd => q{E, MMM d},
			MMMMW => q{اونۍ W د MMMM},
			MMMMd => q{MMMM d},
			MMMd => q{MMM d},
			Md => q{MM-dd},
			h => q{h a},
			hm => q{h:mm a},
			hms => q{h:mm:ss a},
			hmsv => q{h:mm:ss a v},
			hmv => q{h:mm a v},
			ms => q{mm:ss},
			y => q{y},
			yM => q{y-MM},
			yMEd => q{y-MM-dd, E},
			yMMM => q{y MMM},
			yMMMEd => q{y MMM d, E},
			yMMMM => q{y MMMM},
			yMMMd => q{y MMM d},
			yMd => q{y-MM-dd},
			yQQQ => q{y QQQ},
			yQQQQ => q{y QQQQ},
			yw => q{اونۍ w د Y},
		},
		'islamic' => {
			E => q{ccc},
			Ed => q{d, E},
			Gy => q{G y},
			GyMMM => q{G y MMM},
			GyMMMEd => q{G y MMM d, E},
			GyMMMd => q{G y MMM d},
			GyMd => q{M/d/y GGGGG},
			M => q{L},
			MEd => q{MM-dd, E},
			MMM => q{LLL},
			MMMEd => q{MMM d, E},
			MMMMd => q{d MMMM},
			MMMd => q{MMM d},
			Md => q{M/d},
			d => q{d},
			y => q{G y},
			yM => q{G y/M},
			yMMMM => q{د G y د MMMM},
			yyyy => q{G y},
			yyyyM => q{GGGGG y-MM},
			yyyyMEd => q{GGGGG y-MM-dd, E},
			yyyyMMM => q{G y MMM},
			yyyyMMMEd => q{G y MMM d, E},
			yyyyMMMM => q{G y MMMM},
			yyyyMMMd => q{G y MMM d},
			yyyyMd => q{GGGGG y-MM-dd},
			yyyyQQQ => q{G y QQQ},
			yyyyQQQQ => q{G y QQQQ},
		},
	} },
);

has 'datetime_formats_append_item' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			'Timezone' => '{0} ({1})',
		},
	} },
);

has 'datetime_formats_interval' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			Gy => {
				G => q{y G – y G},
				y => q{y – y G},
			},
			GyM => {
				G => q{M/y GGGGG – M/y GGGGG},
				M => q{M/y – M/y GGGGG},
				y => q{M/y – M/y GGGGG},
			},
			GyMEd => {
				G => q{E, M/d/y GGGGG – E, M/d/y GGGGG},
				M => q{E, M/d/y – E, M/d/y GGGGG},
				d => q{E, M/d/y – E, M/d/y GGGGG},
				y => q{E, M/d/y – E, M/d/y GGGGG},
			},
			GyMMM => {
				G => q{MMM y G – MMM y G},
				M => q{MMM – MMM y G},
				y => q{MMM y – MMM y G},
			},
			GyMMMEd => {
				G => q{E, MMM d, y G – E, MMM d, y G},
				M => q{E, MMM d – E, MMM d, y G},
				d => q{E, MMM d – E, MMM d, y G},
				y => q{E, MMM d, y – E, MMM d, y G},
			},
			GyMMMd => {
				G => q{MMM d, y G – MMM d, y G},
				M => q{MMM d – MMM d, y G},
				d => q{MMM d – d, y G},
				y => q{MMM d, y – MMM d, y G},
			},
			GyMd => {
				G => q{M/d/y GGGGG – M/d/y GGGGG},
				M => q{M/d/y – M/d/y GGGGG},
				d => q{M/d/y – M/d/y GGGGG},
				y => q{M/d/y – M/d/y GGGGG},
			},
			M => {
				M => q{MM–MM},
			},
			MEd => {
				M => q{MM-dd, E – MM-dd, E},
				d => q{MM-dd, E – MM-dd, E},
			},
			MMM => {
				M => q{LLL–LLL},
			},
			MMMEd => {
				M => q{MMM d, E – MMM d, E},
				d => q{MMM d, E – MMM d, E},
			},
			MMMd => {
				M => q{MMM d – MMM d},
				d => q{MMM d–d},
			},
			Md => {
				M => q{MM-dd – MM-dd},
				d => q{MM-dd – MM-dd},
			},
			d => {
				d => q{d – d},
			},
			fallback => '{0} – {1}',
			y => {
				y => q{G y–y},
			},
			yM => {
				M => q{GGGGG y-MM – y-MM},
				y => q{GGGGG y-MM – y-MM},
			},
			yMEd => {
				M => q{GGGGG y-MM-dd, E – y-MM-dd, E},
				d => q{GGGGG y-MM-dd, E – y-MM-dd, E},
				y => q{GGGGG y-MM-dd, E – y-MM-dd, E},
			},
			yMMM => {
				M => q{G y MMM–MMM},
				y => q{G y MMM – y MMM},
			},
			yMMMEd => {
				M => q{G y MMM d, E – MMM d, E},
				d => q{G y MMM d, E – MMM d, E},
				y => q{G y MMM d, E – y MMM d, E},
			},
			yMMMM => {
				M => q{G y MMMM–MMMM},
				y => q{G y MMMM – y MMMM},
			},
			yMMMd => {
				M => q{G y MMM d – MMM d},
				d => q{G y MMM d–d},
				y => q{G y MMM d – y MMM d},
			},
			yMd => {
				M => q{GGGGG y-MM-dd – y-MM-dd},
				d => q{GGGGG y-MM-dd – y-MM-dd},
				y => q{GGGGG y-MM-dd – y-MM-dd},
			},
		},
		'gregorian' => {
			H => {
				H => q{HH–HH},
			},
			Hm => {
				H => q{HH:mm–HH:mm},
				m => q{HH:mm–HH:mm},
			},
			Hmv => {
				H => q{HH:mm–HH:mm v},
				m => q{HH:mm–HH:mm v},
			},
			Hv => {
				H => q{HH–HH v},
			},
			M => {
				M => q{MM–MM},
			},
			MEd => {
				M => q{MM-dd, E – MM-dd, E},
				d => q{MM-dd, E – MM-dd, E},
			},
			MMM => {
				M => q{LLL–LLL},
			},
			MMMEd => {
				M => q{MMM d, E – MMM d, E},
				d => q{MMM d, E – MMM d, E},
			},
			MMMd => {
				M => q{MMM d – MMM d},
				d => q{MMM d–d},
			},
			Md => {
				M => q{MM-dd – MM-dd},
				d => q{MM-dd – MM-dd},
			},
			d => {
				d => q{d–d},
			},
			fallback => '{0} – {1}',
			h => {
				a => q{h a – h a},
				h => q{h–h a},
			},
			hm => {
				a => q{h:mm a – h:mm a},
				h => q{h:mm–h:mm a},
				m => q{h:mm–h:mm a},
			},
			hmv => {
				a => q{h:mm a – h:mm a v},
				h => q{h:mm–h:mm a v},
				m => q{h:mm–h:mm a v},
			},
			hv => {
				a => q{h a – h a v},
				h => q{h–h a v},
			},
			y => {
				y => q{y–y},
			},
			yM => {
				M => q{y-MM – y-MM},
				y => q{y-MM – y-MM},
			},
			yMEd => {
				M => q{y-MM-dd, E – y-MM-dd, E},
				d => q{y-MM-dd, E – y-MM-dd, E},
				y => q{y-MM-dd, E – y-MM-dd, E},
			},
			yMMM => {
				M => q{y MMM–MMM},
				y => q{MMM y – MMM y},
			},
			yMMMEd => {
				M => q{y MMM d, E – MMM d, E},
				d => q{y MMM d, E – MMM d, E},
				y => q{y MMM d, E – y MMM d, E},
			},
			yMMMM => {
				M => q{y MMMM–MMMM},
				y => q{y MMMM – y MMMM},
			},
			yMMMd => {
				M => q{y MMM d – MMM d},
				d => q{y MMM d–d},
				y => q{MMM d, y – MMM d, y},
			},
			yMd => {
				M => q{y-MM-dd – y-MM-dd},
				d => q{y-MM-dd – y-MM-dd},
				y => q{y-MM-dd – y-MM-dd},
			},
		},
	} },
);

has 'time_zone_names' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default	=> sub { {
		hourFormat => q(+HH:mm;-HH:mm),
		gmtFormat => q(GMT{0}),
		gmtZeroFormat => q(GMT),
		regionFormat => q(د {0} په وخت),
		regionFormat => q({0} رڼا ورځ وخت),
		regionFormat => q({0} معیاری وخت),
		fallbackFormat => q({1} ({0})),
		'Afghanistan' => {
			long => {
				'standard' => q#افغانستان وخت#,
			},
		},
		'Africa/Abidjan' => {
			exemplarCity => q#ابيجان#,
		},
		'Africa/Accra' => {
			exemplarCity => q#اکرا#,
		},
		'Africa/Addis_Ababa' => {
			exemplarCity => q#اديس ابابا#,
		},
		'Africa/Algiers' => {
			exemplarCity => q#الجييرز#,
		},
		'Africa/Asmera' => {
			exemplarCity => q#اسماره#,
		},
		'Africa/Bamako' => {
			exemplarCity => q#بامیکو#,
		},
		'Africa/Bangui' => {
			exemplarCity => q#بانګوي#,
		},
		'Africa/Banjul' => {
			exemplarCity => q#بانجول#,
		},
		'Africa/Bissau' => {
			exemplarCity => q#بساؤ#,
		},
		'Africa/Blantyre' => {
			exemplarCity => q#بلنټاير#,
		},
		'Africa/Brazzaville' => {
			exemplarCity => q#برازاويل#,
		},
		'Africa/Bujumbura' => {
			exemplarCity => q#بجوګورا#,
		},
		'Africa/Cairo' => {
			exemplarCity => q#قاهره#,
		},
		'Africa/Casablanca' => {
			exemplarCity => q#کاسابلانکا#,
		},
		'Africa/Ceuta' => {
			exemplarCity => q#سيوټا#,
		},
		'Africa/Conakry' => {
			exemplarCity => q#کونکري#,
		},
		'Africa/Dakar' => {
			exemplarCity => q#ډاکار#,
		},
		'Africa/Dar_es_Salaam' => {
			exemplarCity => q#دار السلام#,
		},
		'Africa/Djibouti' => {
			exemplarCity => q#جبوتي#,
		},
		'Africa/Douala' => {
			exemplarCity => q#دوالا#,
		},
		'Africa/El_Aaiun' => {
			exemplarCity => q#الیون#,
		},
		'Africa/Freetown' => {
			exemplarCity => q#فریټون#,
		},
		'Africa/Gaborone' => {
			exemplarCity => q#ګابرون#,
		},
		'Africa/Harare' => {
			exemplarCity => q#هرارې#,
		},
		'Africa/Johannesburg' => {
			exemplarCity => q#جوهانسبرګ#,
		},
		'Africa/Juba' => {
			exemplarCity => q#جوبا#,
		},
		'Africa/Kampala' => {
			exemplarCity => q#کمپاله#,
		},
		'Africa/Khartoum' => {
			exemplarCity => q#خرتوم#,
		},
		'Africa/Kigali' => {
			exemplarCity => q#کيگالي#,
		},
		'Africa/Kinshasa' => {
			exemplarCity => q#کينشاسا#,
		},
		'Africa/Lagos' => {
			exemplarCity => q#لاگوس#,
		},
		'Africa/Libreville' => {
			exemplarCity => q#لیبریل#,
		},
		'Africa/Lome' => {
			exemplarCity => q#لووم#,
		},
		'Africa/Luanda' => {
			exemplarCity => q#لونده#,
		},
		'Africa/Lubumbashi' => {
			exemplarCity => q#لبوباشي#,
		},
		'Africa/Lusaka' => {
			exemplarCity => q#لوساکا#,
		},
		'Africa/Malabo' => {
			exemplarCity => q#مالابو#,
		},
		'Africa/Maputo' => {
			exemplarCity => q#ماپوټو#,
		},
		'Africa/Maseru' => {
			exemplarCity => q#مسيرو#,
		},
		'Africa/Mbabane' => {
			exemplarCity => q#مبابانې#,
		},
		'Africa/Mogadishu' => {
			exemplarCity => q#موگديشو#,
		},
		'Africa/Monrovia' => {
			exemplarCity => q#مونروفیا#,
		},
		'Africa/Nairobi' => {
			exemplarCity => q#نايروبي#,
		},
		'Africa/Ndjamena' => {
			exemplarCity => q#نجامینا#,
		},
		'Africa/Niamey' => {
			exemplarCity => q#نیمي#,
		},
		'Africa/Nouakchott' => {
			exemplarCity => q#نوکوچټ#,
		},
		'Africa/Ouagadougou' => {
			exemplarCity => q#اوګوډوګو#,
		},
		'Africa/Porto-Novo' => {
			exemplarCity => q#پورټو - نوو#,
		},
		'Africa/Sao_Tome' => {
			exemplarCity => q#ساو ټوم#,
		},
		'Africa/Tripoli' => {
			exemplarCity => q#تريپولي#,
		},
		'Africa/Tunis' => {
			exemplarCity => q#تونس#,
		},
		'Africa/Windhoek' => {
			exemplarCity => q#وینهوک#,
		},
		'Africa_Central' => {
			long => {
				'standard' => q#منځنی افريقا وخت#,
			},
		},
		'Africa_Eastern' => {
			long => {
				'standard' => q#ختيځ افريقا وخت#,
			},
		},
		'Africa_Southern' => {
			long => {
				'standard' => q#جنوبي افريقا معياري وخت#,
			},
		},
		'Africa_Western' => {
			long => {
				'daylight' => q#د افریقا افریقا لویدیځ وخت#,
				'generic' => q#لوېديځ افريقا وخت#,
				'standard' => q#لویدیځ افریقایي معیاري وخت#,
			},
		},
		'Alaska' => {
			long => {
				'daylight' => q#الاسکا د ورځې روښانه وخت#,
				'generic' => q#الاسکا وخت#,
				'standard' => q#الاسکا معياري وخت#,
			},
		},
		'Amazon' => {
			long => {
				'daylight' => q#ایمیزون اوړي وخت#,
				'generic' => q#ایمیزون وخت#,
				'standard' => q#ایمیزون معیاری وخت#,
			},
		},
		'America/Adak' => {
			exemplarCity => q#اداک#,
		},
		'America/Anchorage' => {
			exemplarCity => q#اینکریج#,
		},
		'America/Anguilla' => {
			exemplarCity => q#انګیلا#,
		},
		'America/Antigua' => {
			exemplarCity => q#انټيګ#,
		},
		'America/Araguaina' => {
			exemplarCity => q#ارګینیا#,
		},
		'America/Argentina/La_Rioja' => {
			exemplarCity => q#لاريوجا#,
		},
		'America/Argentina/Rio_Gallegos' => {
			exemplarCity => q#ريو ګيليګوس#,
		},
		'America/Argentina/Salta' => {
			exemplarCity => q#سالټا#,
		},
		'America/Argentina/San_Juan' => {
			exemplarCity => q#سان جوان#,
		},
		'America/Argentina/San_Luis' => {
			exemplarCity => q#سان لویس#,
		},
		'America/Argentina/Tucuman' => {
			exemplarCity => q#ټيکووم#,
		},
		'America/Argentina/Ushuaia' => {
			exemplarCity => q#اوشوایا#,
		},
		'America/Aruba' => {
			exemplarCity => q#آروبا#,
		},
		'America/Asuncion' => {
			exemplarCity => q#اسونسيون#,
		},
		'America/Bahia' => {
			exemplarCity => q#بهیا#,
		},
		'America/Bahia_Banderas' => {
			exemplarCity => q#بهیا بینډراس#,
		},
		'America/Barbados' => {
			exemplarCity => q#باربادوس#,
		},
		'America/Belem' => {
			exemplarCity => q#بلم#,
		},
		'America/Belize' => {
			exemplarCity => q#بلیز#,
		},
		'America/Blanc-Sablon' => {
			exemplarCity => q#بلانک-سابلون#,
		},
		'America/Boa_Vista' => {
			exemplarCity => q#بوا ویسټا#,
		},
		'America/Bogota' => {
			exemplarCity => q#بوګټا#,
		},
		'America/Boise' => {
			exemplarCity => q#بوز#,
		},
		'America/Buenos_Aires' => {
			exemplarCity => q#بينوس اييرز#,
		},
		'America/Cambridge_Bay' => {
			exemplarCity => q#کیمبرج بي#,
		},
		'America/Campo_Grande' => {
			exemplarCity => q#کمپو ګرډی#,
		},
		'America/Cancun' => {
			exemplarCity => q#کينکن#,
		},
		'America/Caracas' => {
			exemplarCity => q#کاراکاس#,
		},
		'America/Catamarca' => {
			exemplarCity => q#کټامارکا#,
		},
		'America/Cayenne' => {
			exemplarCity => q#کیین#,
		},
		'America/Cayman' => {
			exemplarCity => q#کیمن#,
		},
		'America/Chicago' => {
			exemplarCity => q#شیکاګو#,
		},
		'America/Chihuahua' => {
			exemplarCity => q#چھواھوا#,
		},
		'America/Coral_Harbour' => {
			exemplarCity => q#اتیکوکن#,
		},
		'America/Cordoba' => {
			exemplarCity => q#کورډوبا#,
		},
		'America/Costa_Rica' => {
			exemplarCity => q#کوستاریکا#,
		},
		'America/Creston' => {
			exemplarCity => q#کرسټون#,
		},
		'America/Cuiaba' => {
			exemplarCity => q#کویابا#,
		},
		'America/Curacao' => {
			exemplarCity => q#کوراکاؤ#,
		},
		'America/Danmarkshavn' => {
			exemplarCity => q#ډنمارکشان#,
		},
		'America/Dawson' => {
			exemplarCity => q#داوسن#,
		},
		'America/Dawson_Creek' => {
			exemplarCity => q#داسن کریک#,
		},
		'America/Denver' => {
			exemplarCity => q#ډنور#,
		},
		'America/Detroit' => {
			exemplarCity => q#ډایټروټ#,
		},
		'America/Dominica' => {
			exemplarCity => q#دومینیکا#,
		},
		'America/Edmonton' => {
			exemplarCity => q#ایډمونټن#,
		},
		'America/Eirunepe' => {
			exemplarCity => q#اییرونپ#,
		},
		'America/El_Salvador' => {
			exemplarCity => q#ايل سلوادور#,
		},
		'America/Fort_Nelson' => {
			exemplarCity => q#فورټ نیلسن#,
		},
		'America/Fortaleza' => {
			exemplarCity => q#فورتیلزا#,
		},
		'America/Glace_Bay' => {
			exemplarCity => q#ګیسس بيی#,
		},
		'America/Godthab' => {
			exemplarCity => q#نووک#,
		},
		'America/Goose_Bay' => {
			exemplarCity => q#گوز بي#,
		},
		'America/Grand_Turk' => {
			exemplarCity => q#لوی ترک#,
		},
		'America/Grenada' => {
			exemplarCity => q#ګرنادا#,
		},
		'America/Guadeloupe' => {
			exemplarCity => q#ګالډیپ#,
		},
		'America/Guatemala' => {
			exemplarCity => q#ګواتمالا#,
		},
		'America/Guayaquil' => {
			exemplarCity => q#ګوياکل#,
		},
		'America/Guyana' => {
			exemplarCity => q#ګیانا#,
		},
		'America/Halifax' => {
			exemplarCity => q#هیلفکس#,
		},
		'America/Havana' => {
			exemplarCity => q#هوانا#,
		},
		'America/Hermosillo' => {
			exemplarCity => q#هرموسیلو#,
		},
		'America/Indiana/Knox' => {
			exemplarCity => q#نوکس انډيانا#,
		},
		'America/Indiana/Marengo' => {
			exemplarCity => q#مورينګو انډيانا#,
		},
		'America/Indiana/Petersburg' => {
			exemplarCity => q#پيټسبرګ، انډيانا#,
		},
		'America/Indiana/Tell_City' => {
			exemplarCity => q#ټل سټي، انډيانا#,
		},
		'America/Indiana/Vevay' => {
			exemplarCity => q#ویوی، انډيانا#,
		},
		'America/Indiana/Vincennes' => {
			exemplarCity => q#وينسينس، انډيانا#,
		},
		'America/Indiana/Winamac' => {
			exemplarCity => q#وينامک انډيانا#,
		},
		'America/Indianapolis' => {
			exemplarCity => q#انډيانا پوليس#,
		},
		'America/Inuvik' => {
			exemplarCity => q#انوک#,
		},
		'America/Iqaluit' => {
			exemplarCity => q#اقلیټ#,
		},
		'America/Jamaica' => {
			exemplarCity => q#جمایکه#,
		},
		'America/Jujuy' => {
			exemplarCity => q#جوجوي#,
		},
		'America/Juneau' => {
			exemplarCity => q#جونو#,
		},
		'America/Kentucky/Monticello' => {
			exemplarCity => q#مونټيسيلو، کونټکی#,
		},
		'America/Kralendijk' => {
			exemplarCity => q#کلینډیزج#,
		},
		'America/La_Paz' => {
			exemplarCity => q#لا پاز#,
		},
		'America/Lima' => {
			exemplarCity => q#لیما#,
		},
		'America/Los_Angeles' => {
			exemplarCity => q#لاس اینجلس#,
		},
		'America/Louisville' => {
			exemplarCity => q#لوئس ویل#,
		},
		'America/Lower_Princes' => {
			exemplarCity => q#لوور پرنس کوارټر#,
		},
		'America/Maceio' => {
			exemplarCity => q#ماسيو#,
		},
		'America/Managua' => {
			exemplarCity => q#منګوا#,
		},
		'America/Manaus' => {
			exemplarCity => q#مناوس#,
		},
		'America/Marigot' => {
			exemplarCity => q#ميريګاټ#,
		},
		'America/Martinique' => {
			exemplarCity => q#مارټینیک#,
		},
		'America/Matamoros' => {
			exemplarCity => q#ميټاموروس#,
		},
		'America/Mazatlan' => {
			exemplarCity => q#مزاتلان#,
		},
		'America/Mendoza' => {
			exemplarCity => q#مینډوزا#,
		},
		'America/Menominee' => {
			exemplarCity => q#مینومین#,
		},
		'America/Merida' => {
			exemplarCity => q#ميريډا#,
		},
		'America/Metlakatla' => {
			exemplarCity => q#میتلاکاټلا#,
		},
		'America/Mexico_City' => {
			exemplarCity => q#مکسيکو ښار#,
		},
		'America/Miquelon' => {
			exemplarCity => q#ميکويلان#,
		},
		'America/Moncton' => {
			exemplarCity => q#مونکټون#,
		},
		'America/Monterrey' => {
			exemplarCity => q#منټرري#,
		},
		'America/Montevideo' => {
			exemplarCity => q#مونټ وډیو#,
		},
		'America/Montserrat' => {
			exemplarCity => q#مانټیسیرت#,
		},
		'America/Nassau' => {
			exemplarCity => q#نیساو#,
		},
		'America/New_York' => {
			exemplarCity => q#نیویارک#,
		},
		'America/Nipigon' => {
			exemplarCity => q#نیپګون#,
		},
		'America/Nome' => {
			exemplarCity => q#نوم#,
		},
		'America/Noronha' => {
			exemplarCity => q#نورونها#,
		},
		'America/North_Dakota/Beulah' => {
			exemplarCity => q#بيولا، شمالي ډاکوټا#,
		},
		'America/North_Dakota/Center' => {
			exemplarCity => q#مرکز، شمالي ډاکوټا#,
		},
		'America/North_Dakota/New_Salem' => {
			exemplarCity => q#نوی سلیم، شمالي داکوتا#,
		},
		'America/Ojinaga' => {
			exemplarCity => q#اوجنګا#,
		},
		'America/Panama' => {
			exemplarCity => q#پاناما#,
		},
		'America/Pangnirtung' => {
			exemplarCity => q#پينګنرچونګ#,
		},
		'America/Paramaribo' => {
			exemplarCity => q#پاراماربو#,
		},
		'America/Phoenix' => {
			exemplarCity => q#فینکس#,
		},
		'America/Port-au-Prince' => {
			exemplarCity => q#پورټ ایو - پرنس#,
		},
		'America/Port_of_Spain' => {
			exemplarCity => q#د اسپانیا بندر#,
		},
		'America/Porto_Velho' => {
			exemplarCity => q#پورټو ویلهو#,
		},
		'America/Puerto_Rico' => {
			exemplarCity => q#پورتو ریکو#,
		},
		'America/Punta_Arenas' => {
			exemplarCity => q#پنټا آریناس#,
		},
		'America/Rainy_River' => {
			exemplarCity => q#د باران باران#,
		},
		'America/Rankin_Inlet' => {
			exemplarCity => q#رينکن انلټ#,
		},
		'America/Recife' => {
			exemplarCity => q#ریسیفي#,
		},
		'America/Regina' => {
			exemplarCity => q#ریګینا#,
		},
		'America/Resolute' => {
			exemplarCity => q#ريسالوټ#,
		},
		'America/Rio_Branco' => {
			exemplarCity => q#ریو برانکو#,
		},
		'America/Santarem' => {
			exemplarCity => q#سناترم#,
		},
		'America/Santiago' => {
			exemplarCity => q#سنتياګو#,
		},
		'America/Santo_Domingo' => {
			exemplarCity => q#سنتو ډومینګو#,
		},
		'America/Sao_Paulo' => {
			exemplarCity => q#ساو پاولو#,
		},
		'America/Scoresbysund' => {
			exemplarCity => q#اټوکوټورمیټ#,
		},
		'America/Sitka' => {
			exemplarCity => q#سیټکا#,
		},
		'America/St_Barthelemy' => {
			exemplarCity => q#سینټ بارټیلیم#,
		},
		'America/St_Johns' => {
			exemplarCity => q#سینټ جانز#,
		},
		'America/St_Kitts' => {
			exemplarCity => q#سینټ کټس#,
		},
		'America/St_Lucia' => {
			exemplarCity => q#سینټ لوسیا#,
		},
		'America/St_Thomas' => {
			exemplarCity => q#سينټ تهامس#,
		},
		'America/St_Vincent' => {
			exemplarCity => q#سېنټ ویسنټ#,
		},
		'America/Swift_Current' => {
			exemplarCity => q#سويفټ کرنټ#,
		},
		'America/Tegucigalpa' => {
			exemplarCity => q#ټګسیګالپا#,
		},
		'America/Thule' => {
			exemplarCity => q#تول#,
		},
		'America/Thunder_Bay' => {
			exemplarCity => q#تنډر بی#,
		},
		'America/Tijuana' => {
			exemplarCity => q#تجوانا#,
		},
		'America/Toronto' => {
			exemplarCity => q#ټورنټو#,
		},
		'America/Tortola' => {
			exemplarCity => q#ټورتولا#,
		},
		'America/Vancouver' => {
			exemplarCity => q#وینکوور#,
		},
		'America/Whitehorse' => {
			exemplarCity => q#وايټ هارس#,
		},
		'America/Winnipeg' => {
			exemplarCity => q#وینپیګ#,
		},
		'America/Yakutat' => {
			exemplarCity => q#ياکوټټ#,
		},
		'America/Yellowknife' => {
			exemplarCity => q#يلونايف#,
		},
		'America_Central' => {
			long => {
				'daylight' => q#مرکزي د ورځې روښانه وخت#,
				'generic' => q#مرکزي وخت#,
				'standard' => q#مرکزي معياري وخت#,
			},
		},
		'America_Eastern' => {
			long => {
				'daylight' => q#ختيځ د رڼا ورځې وخت#,
				'generic' => q#ختیځ وخت#,
				'standard' => q#ختيځ معياري وخت#,
			},
		},
		'America_Mountain' => {
			long => {
				'daylight' => q#د غره د رڼا ورځې وخت#,
				'generic' => q#د غره د وخت#,
				'standard' => q#د غره معياري وخت#,
			},
		},
		'America_Pacific' => {
			long => {
				'daylight' => q#پیسفک د رڼا ورځې وخت#,
				'generic' => q#پیسفک وخت#,
				'standard' => q#د پیسفک معياري وخت#,
			},
		},
		'Antarctica/Casey' => {
			exemplarCity => q#کیسي#,
		},
		'Antarctica/Davis' => {
			exemplarCity => q#ډيوس#,
		},
		'Antarctica/DumontDUrville' => {
			exemplarCity => q#ډومونټ ډي ارول#,
		},
		'Antarctica/Macquarie' => {
			exemplarCity => q#مکواري#,
		},
		'Antarctica/Mawson' => {
			exemplarCity => q#ماوسن#,
		},
		'Antarctica/McMurdo' => {
			exemplarCity => q#مکمرډو#,
		},
		'Antarctica/Palmer' => {
			exemplarCity => q#پالمر#,
		},
		'Antarctica/Rothera' => {
			exemplarCity => q#رودرا#,
		},
		'Antarctica/Syowa' => {
			exemplarCity => q#سیوا#,
		},
		'Antarctica/Troll' => {
			exemplarCity => q#ټرول#,
		},
		'Antarctica/Vostok' => {
			exemplarCity => q#واستوک#,
		},
		'Apia' => {
			long => {
				'daylight' => q#اپيا د ورځې روښانه وخت#,
				'generic' => q#اپیا وخت#,
				'standard' => q#اپیا معياري وخت#,
			},
		},
		'Arabian' => {
			long => {
				'daylight' => q#عربي د ورځې روښانه وخت#,
				'generic' => q#عربي وخت#,
				'standard' => q#عربي معیاري وخت#,
			},
		},
		'Arctic/Longyearbyen' => {
			exemplarCity => q#لانګيربين#,
		},
		'Argentina' => {
			long => {
				'daylight' => q#ارجنټاین اوړي وخت#,
				'generic' => q#ارجنټاین وخت#,
				'standard' => q#ارجنټاین معیاری وخت#,
			},
		},
		'Argentina_Western' => {
			long => {
				'daylight' => q#لوېديځ ارجنټاين اوړي وخت#,
				'generic' => q#لوېديځ ارجنټاين وخت#,
				'standard' => q#لوېديځ ارجنټاين معياري وخت#,
			},
		},
		'Armenia' => {
			long => {
				'daylight' => q#ارمنستان اوړي وخت#,
				'generic' => q#ارمنستان وخت#,
				'standard' => q#ارمنستان معياري وخت#,
			},
		},
		'Asia/Aden' => {
			exemplarCity => q#اډن#,
		},
		'Asia/Almaty' => {
			exemplarCity => q#الماتی#,
		},
		'Asia/Amman' => {
			exemplarCity => q#اممان#,
		},
		'Asia/Anadyr' => {
			exemplarCity => q#اناډير#,
		},
		'Asia/Aqtau' => {
			exemplarCity => q#اکټاو#,
		},
		'Asia/Aqtobe' => {
			exemplarCity => q#اکتوب#,
		},
		'Asia/Ashgabat' => {
			exemplarCity => q#اشغ آباد#,
		},
		'Asia/Atyrau' => {
			exemplarCity => q#اېټراو#,
		},
		'Asia/Baghdad' => {
			exemplarCity => q#بغداد#,
		},
		'Asia/Bahrain' => {
			exemplarCity => q#بحرین#,
		},
		'Asia/Baku' => {
			exemplarCity => q#باکو#,
		},
		'Asia/Bangkok' => {
			exemplarCity => q#بنکاک#,
		},
		'Asia/Barnaul' => {
			exemplarCity => q#برنول#,
		},
		'Asia/Beirut' => {
			exemplarCity => q#بیروت#,
		},
		'Asia/Bishkek' => {
			exemplarCity => q#بشکیک#,
		},
		'Asia/Brunei' => {
			exemplarCity => q#برویني#,
		},
		'Asia/Calcutta' => {
			exemplarCity => q#کولکته#,
		},
		'Asia/Chita' => {
			exemplarCity => q#چيتا#,
		},
		'Asia/Choibalsan' => {
			exemplarCity => q#چويبلسان#,
		},
		'Asia/Colombo' => {
			exemplarCity => q#کولمبو#,
		},
		'Asia/Damascus' => {
			exemplarCity => q#دمشق#,
		},
		'Asia/Dhaka' => {
			exemplarCity => q#ډهاکه#,
		},
		'Asia/Dili' => {
			exemplarCity => q#دلي#,
		},
		'Asia/Dubai' => {
			exemplarCity => q#دوبی#,
		},
		'Asia/Dushanbe' => {
			exemplarCity => q#دوشنبي#,
		},
		'Asia/Famagusta' => {
			exemplarCity => q#فاماګستا#,
		},
		'Asia/Gaza' => {
			exemplarCity => q#غزه#,
		},
		'Asia/Hebron' => {
			exemplarCity => q#هبرون#,
		},
		'Asia/Hong_Kong' => {
			exemplarCity => q#هانګ کانګ#,
		},
		'Asia/Hovd' => {
			exemplarCity => q#هاوډ#,
		},
		'Asia/Irkutsk' => {
			exemplarCity => q#ارکوټسک#,
		},
		'Asia/Jakarta' => {
			exemplarCity => q#جکارتا#,
		},
		'Asia/Jayapura' => {
			exemplarCity => q#جاياپورا#,
		},
		'Asia/Jerusalem' => {
			exemplarCity => q#يروشلم#,
		},
		'Asia/Kabul' => {
			exemplarCity => q#کابل#,
		},
		'Asia/Kamchatka' => {
			exemplarCity => q#کامچاتکا#,
		},
		'Asia/Karachi' => {
			exemplarCity => q#کراچي#,
		},
		'Asia/Katmandu' => {
			exemplarCity => q#کټمنډو#,
		},
		'Asia/Khandyga' => {
			exemplarCity => q#خنديګا#,
		},
		'Asia/Krasnoyarsk' => {
			exemplarCity => q#کريسنويارسک#,
		},
		'Asia/Kuala_Lumpur' => {
			exemplarCity => q#کولالمپور#,
		},
		'Asia/Kuching' => {
			exemplarCity => q#کوچنګ#,
		},
		'Asia/Kuwait' => {
			exemplarCity => q#کوېت#,
		},
		'Asia/Macau' => {
			exemplarCity => q#مکاو#,
		},
		'Asia/Magadan' => {
			exemplarCity => q#مګدان#,
		},
		'Asia/Makassar' => {
			exemplarCity => q#مکاسار#,
		},
		'Asia/Manila' => {
			exemplarCity => q#منیلا#,
		},
		'Asia/Muscat' => {
			exemplarCity => q#مسقط#,
		},
		'Asia/Nicosia' => {
			exemplarCity => q#نیکوسیا#,
		},
		'Asia/Novokuznetsk' => {
			exemplarCity => q#نووکوزنیټک#,
		},
		'Asia/Novosibirsk' => {
			exemplarCity => q#نووسيبرسک#,
		},
		'Asia/Omsk' => {
			exemplarCity => q#اومسک#,
		},
		'Asia/Oral' => {
			exemplarCity => q#اورل#,
		},
		'Asia/Phnom_Penh' => {
			exemplarCity => q#پنوم پن#,
		},
		'Asia/Pontianak' => {
			exemplarCity => q#پونټینیک#,
		},
		'Asia/Pyongyang' => {
			exemplarCity => q#پيانګ يانګ#,
		},
		'Asia/Qatar' => {
			exemplarCity => q#قطر#,
		},
		'Asia/Qostanay' => {
			exemplarCity => q#کوستانې#,
		},
		'Asia/Qyzylorda' => {
			exemplarCity => q#قيزي لورډا#,
		},
		'Asia/Rangoon' => {
			exemplarCity => q#یانګون#,
		},
		'Asia/Riyadh' => {
			exemplarCity => q#رياض#,
		},
		'Asia/Saigon' => {
			exemplarCity => q#هو چي من ښار#,
		},
		'Asia/Sakhalin' => {
			exemplarCity => q#سخالين#,
		},
		'Asia/Samarkand' => {
			exemplarCity => q#سمرقند#,
		},
		'Asia/Seoul' => {
			exemplarCity => q#سیول#,
		},
		'Asia/Shanghai' => {
			exemplarCity => q#شنگھائی#,
		},
		'Asia/Singapore' => {
			exemplarCity => q#سینګاپور#,
		},
		'Asia/Srednekolymsk' => {
			exemplarCity => q#سريډنيکوليمسک#,
		},
		'Asia/Taipei' => {
			exemplarCity => q#تايپي#,
		},
		'Asia/Tashkent' => {
			exemplarCity => q#تاشقند#,
		},
		'Asia/Tbilisi' => {
			exemplarCity => q#تبلیسي#,
		},
		'Asia/Tehran' => {
			exemplarCity => q#تهران#,
		},
		'Asia/Thimphu' => {
			exemplarCity => q#تهيمفو#,
		},
		'Asia/Tokyo' => {
			exemplarCity => q#ټوکیو#,
		},
		'Asia/Tomsk' => {
			exemplarCity => q#توماس#,
		},
		'Asia/Ulaanbaatar' => {
			exemplarCity => q#اولان باټر#,
		},
		'Asia/Urumqi' => {
			exemplarCity => q#اورومقي#,
		},
		'Asia/Ust-Nera' => {
			exemplarCity => q#اوستنيرا#,
		},
		'Asia/Vientiane' => {
			exemplarCity => q#وينټين#,
		},
		'Asia/Vladivostok' => {
			exemplarCity => q#ولادیوستاک#,
		},
		'Asia/Yakutsk' => {
			exemplarCity => q#ياکوټسک#,
		},
		'Asia/Yekaterinburg' => {
			exemplarCity => q#يکاټيرنبرګ#,
		},
		'Asia/Yerevan' => {
			exemplarCity => q#يريوان#,
		},
		'Atlantic' => {
			long => {
				'daylight' => q#اتلانتیک د رڼا ورځې وخت#,
				'generic' => q#اتلانتیک وخت#,
				'standard' => q#اتلانتیک معياري وخت#,
			},
		},
		'Atlantic/Azores' => {
			exemplarCity => q#ايزورس#,
		},
		'Atlantic/Bermuda' => {
			exemplarCity => q#برمودا#,
		},
		'Atlantic/Canary' => {
			exemplarCity => q#کناري#,
		},
		'Atlantic/Cape_Verde' => {
			exemplarCity => q#کيپ ورډ#,
		},
		'Atlantic/Faeroe' => {
			exemplarCity => q#فارو#,
		},
		'Atlantic/Madeira' => {
			exemplarCity => q#مديرا#,
		},
		'Atlantic/Reykjavik' => {
			exemplarCity => q#ريکجاويک#,
		},
		'Atlantic/South_Georgia' => {
			exemplarCity => q#سويلي جورجيا#,
		},
		'Atlantic/St_Helena' => {
			exemplarCity => q#سینټ هیلینا#,
		},
		'Atlantic/Stanley' => {
			exemplarCity => q#سټنلي#,
		},
		'Australia/Adelaide' => {
			exemplarCity => q#اډیلایډ#,
		},
		'Australia/Brisbane' => {
			exemplarCity => q#بریسبن#,
		},
		'Australia/Broken_Hill' => {
			exemplarCity => q#بروکن هل#,
		},
		'Australia/Currie' => {
			exemplarCity => q#کرري#,
		},
		'Australia/Darwin' => {
			exemplarCity => q#ډارون#,
		},
		'Australia/Eucla' => {
			exemplarCity => q#ايوکلا#,
		},
		'Australia/Hobart' => {
			exemplarCity => q#هوبارټ#,
		},
		'Australia/Lindeman' => {
			exemplarCity => q#لینډامین#,
		},
		'Australia/Lord_Howe' => {
			exemplarCity => q#لارډ هوي#,
		},
		'Australia/Melbourne' => {
			exemplarCity => q#میلبورن#,
		},
		'Australia/Perth' => {
			exemplarCity => q#پرت#,
		},
		'Australia/Sydney' => {
			exemplarCity => q#سډني#,
		},
		'Australia_Central' => {
			long => {
				'daylight' => q#آسترالوي مرکزي د ورځې روښانه وخت#,
				'generic' => q#مرکزي آستراليا وخت#,
				'standard' => q#آسترالوي مرکزي معياري وخت#,
			},
		},
		'Australia_CentralWestern' => {
			long => {
				'daylight' => q#آسترالوي مرکزي لوېديځ د ورځې روښانه وخت#,
				'generic' => q#آسترالوي مرکزي لوېديځ وخت#,
				'standard' => q#آسترالوي مرکزي لوېديځ معياري وخت#,
			},
		},
		'Australia_Eastern' => {
			long => {
				'daylight' => q#آسترالوي ختيځ د ورځې روښانه وخت#,
				'generic' => q#ختيځ آستراليا وخت#,
				'standard' => q#آسترالوي ختيځ معياري وخت#,
			},
		},
		'Australia_Western' => {
			long => {
				'daylight' => q#آسترالوي لوېديځ د ورځې روښانه وخت#,
				'generic' => q#لوېديځ آستراليا وخت#,
				'standard' => q#آسترالوي لوېديځ معياري وخت#,
			},
		},
		'Azerbaijan' => {
			long => {
				'daylight' => q#اذرباییجان اوړي وخت#,
				'generic' => q#د آذربايجان وخت#,
				'standard' => q#آذربايجان معياري وخت#,
			},
		},
		'Azores' => {
			long => {
				'daylight' => q#ايزورس اوړي وخت#,
				'generic' => q#ايزورس وخت#,
				'standard' => q#ايزورس معياري وخت#,
			},
		},
		'Bangladesh' => {
			long => {
				'daylight' => q#بنګله ديش اوړي وخت#,
				'generic' => q#بنگله دېش وخت#,
				'standard' => q#بنګلادیش معیاري وخت#,
			},
		},
		'Bhutan' => {
			long => {
				'standard' => q#بهوټان وخت#,
			},
		},
		'Bolivia' => {
			long => {
				'standard' => q#بولیویا وخت#,
			},
		},
		'Brasilia' => {
			long => {
				'daylight' => q#برسلیا اوړي وخت#,
				'generic' => q#برسلیا وخت#,
				'standard' => q#برسلیا معیاری وخت#,
			},
		},
		'Brunei' => {
			long => {
				'standard' => q#برونايي دارالسلام وخت#,
			},
		},
		'Cape_Verde' => {
			long => {
				'daylight' => q#کیپ وردډ سمر وخت#,
				'generic' => q#کیپ وردډ وخت#,
				'standard' => q#کیپ وردډ معياري وخت#,
			},
		},
		'Chamorro' => {
			long => {
				'standard' => q#چمارو معياري وخت#,
			},
		},
		'Chatham' => {
			long => {
				'daylight' => q#چاتام د ورځې روښانه وخت#,
				'generic' => q#چاتام وخت#,
				'standard' => q#چاتام معياري وخت#,
			},
		},
		'Chile' => {
			long => {
				'daylight' => q#چلی اوړي وخت#,
				'generic' => q#چلی وخت#,
				'standard' => q#چلی معیاری وخت#,
			},
		},
		'China' => {
			long => {
				'daylight' => q#د چين د رڼا ورځې وخت#,
				'generic' => q#چين وخت#,
				'standard' => q#چین معیاري وخت#,
			},
		},
		'Choibalsan' => {
			long => {
				'daylight' => q#چوئیبیلسن اوړي وخت#,
				'generic' => q#چوئیبیلسن وخت#,
				'standard' => q#چوئیبیلسن معیاری وخت#,
			},
		},
		'Christmas' => {
			long => {
				'standard' => q#کريسمس ټاپو وخت#,
			},
		},
		'Cocos' => {
			long => {
				'standard' => q#کوکوز ټاپوګانو وخت#,
			},
		},
		'Colombia' => {
			long => {
				'daylight' => q#کولمبیا اوړي وخت#,
				'generic' => q#کولمبیا وخت#,
				'standard' => q#کولمبیا معیاری وخت#,
			},
		},
		'Cook' => {
			long => {
				'daylight' => q#کوک ټاپوګانو نيم اوړي وخت#,
				'generic' => q#کوک ټاپوګانو وخت#,
				'standard' => q#کوک ټاپوګانو معياري وخت#,
			},
		},
		'Cuba' => {
			long => {
				'daylight' => q#کیوبا د رڼا ورځې وخت#,
				'generic' => q#کيوبا وخت#,
				'standard' => q#کیوبا معياري وخت#,
			},
		},
		'Davis' => {
			long => {
				'standard' => q#ډيوس وخت#,
			},
		},
		'DumontDUrville' => {
			long => {
				'standard' => q#ډومونټ ډي ارول#,
			},
		},
		'East_Timor' => {
			long => {
				'standard' => q#ختيځ تيمور وخت#,
			},
		},
		'Easter' => {
			long => {
				'daylight' => q#ايستر ټاپو اوړي وخت#,
				'generic' => q#ايستر ټاپو وخت#,
				'standard' => q#ايستر ټاپو معياري وخت#,
			},
		},
		'Ecuador' => {
			long => {
				'standard' => q#د اکوادور وخت#,
			},
		},
		'Etc/UTC' => {
			long => {
				'standard' => q#همغږى نړیوال وخت#,
			},
		},
		'Etc/Unknown' => {
			exemplarCity => q#نامعلوم ښار#,
		},
		'Europe/Amsterdam' => {
			exemplarCity => q#امستردام#,
		},
		'Europe/Andorra' => {
			exemplarCity => q#اندورا#,
		},
		'Europe/Astrakhan' => {
			exemplarCity => q#استرا خان#,
		},
		'Europe/Athens' => {
			exemplarCity => q#ايتنز#,
		},
		'Europe/Belgrade' => {
			exemplarCity => q#بلغاد#,
		},
		'Europe/Berlin' => {
			exemplarCity => q#برلن#,
		},
		'Europe/Bratislava' => {
			exemplarCity => q#براټسلاوا#,
		},
		'Europe/Brussels' => {
			exemplarCity => q#بروسلز#,
		},
		'Europe/Bucharest' => {
			exemplarCity => q#بخارست#,
		},
		'Europe/Budapest' => {
			exemplarCity => q#بداپسټ#,
		},
		'Europe/Busingen' => {
			exemplarCity => q#بوسينجن#,
		},
		'Europe/Chisinau' => {
			exemplarCity => q#چیسینو#,
		},
		'Europe/Copenhagen' => {
			exemplarCity => q#کوپن هيګن#,
		},
		'Europe/Dublin' => {
			exemplarCity => q#ډبلن#,
			long => {
				'daylight' => q#آيرش معياري وخت#,
			},
		},
		'Europe/Gibraltar' => {
			exemplarCity => q#جبل الطارق#,
		},
		'Europe/Guernsey' => {
			exemplarCity => q#ګرنسي#,
		},
		'Europe/Helsinki' => {
			exemplarCity => q#هیلسنکی#,
		},
		'Europe/Isle_of_Man' => {
			exemplarCity => q#د آئل آف مین#,
		},
		'Europe/Istanbul' => {
			exemplarCity => q#استنبول#,
		},
		'Europe/Jersey' => {
			exemplarCity => q#جرسی#,
		},
		'Europe/Kaliningrad' => {
			exemplarCity => q#کيلنينګراډ#,
		},
		'Europe/Kiev' => {
			exemplarCity => q#کیو#,
		},
		'Europe/Kirov' => {
			exemplarCity => q#کیروف#,
		},
		'Europe/Lisbon' => {
			exemplarCity => q#لیسبون#,
		},
		'Europe/Ljubljana' => {
			exemplarCity => q#لوبجانا#,
		},
		'Europe/London' => {
			exemplarCity => q#لندن#,
			long => {
				'daylight' => q#بريتانوي د اوړي وخت#,
			},
		},
		'Europe/Luxembourg' => {
			exemplarCity => q#لوګزامبورګ#,
		},
		'Europe/Madrid' => {
			exemplarCity => q#میډریډ#,
		},
		'Europe/Malta' => {
			exemplarCity => q#مالټا#,
		},
		'Europe/Mariehamn' => {
			exemplarCity => q#ميريهام#,
		},
		'Europe/Minsk' => {
			exemplarCity => q#منسک#,
		},
		'Europe/Monaco' => {
			exemplarCity => q#موناکو#,
		},
		'Europe/Moscow' => {
			exemplarCity => q#ماسکو#,
		},
		'Europe/Oslo' => {
			exemplarCity => q#اوسلو#,
		},
		'Europe/Paris' => {
			exemplarCity => q#پاریس#,
		},
		'Europe/Podgorica' => {
			exemplarCity => q#پوډګوريکا#,
		},
		'Europe/Prague' => {
			exemplarCity => q#پراګ#,
		},
		'Europe/Riga' => {
			exemplarCity => q#ريګا#,
		},
		'Europe/Rome' => {
			exemplarCity => q#روم#,
		},
		'Europe/Samara' => {
			exemplarCity => q#سمارا#,
		},
		'Europe/San_Marino' => {
			exemplarCity => q#سان مارینو#,
		},
		'Europe/Sarajevo' => {
			exemplarCity => q#سيراجيوا#,
		},
		'Europe/Saratov' => {
			exemplarCity => q#سراتف#,
		},
		'Europe/Simferopol' => {
			exemplarCity => q#سیمفروپول#,
		},
		'Europe/Skopje' => {
			exemplarCity => q#سکپوګ#,
		},
		'Europe/Sofia' => {
			exemplarCity => q#صوفیا#,
		},
		'Europe/Stockholm' => {
			exemplarCity => q#استولوم#,
		},
		'Europe/Tallinn' => {
			exemplarCity => q#تالين#,
		},
		'Europe/Tirane' => {
			exemplarCity => q#تيران#,
		},
		'Europe/Ulyanovsk' => {
			exemplarCity => q#اليانوسک#,
		},
		'Europe/Uzhgorod' => {
			exemplarCity => q#یوژورډ#,
		},
		'Europe/Vaduz' => {
			exemplarCity => q#واډوز#,
		},
		'Europe/Vatican' => {
			exemplarCity => q#ویټیکان#,
		},
		'Europe/Vienna' => {
			exemplarCity => q#ویانا#,
		},
		'Europe/Vilnius' => {
			exemplarCity => q#ويلنيوس#,
		},
		'Europe/Volgograd' => {
			exemplarCity => q#والګوګراډ#,
		},
		'Europe/Warsaw' => {
			exemplarCity => q#وارسا#,
		},
		'Europe/Zagreb' => {
			exemplarCity => q#زګرب#,
		},
		'Europe/Zaporozhye' => {
			exemplarCity => q#زاپوروژی#,
		},
		'Europe/Zurich' => {
			exemplarCity => q#زریچ#,
		},
		'Europe_Central' => {
			long => {
				'daylight' => q#مرکزي اروپايياوړي وخت#,
				'generic' => q#مرکزي اروپايي وخت#,
				'standard' => q#د مرکزي اروپا معیاري وخت#,
			},
		},
		'Europe_Eastern' => {
			long => {
				'daylight' => q#ختيځ اروپايي اوړي وخت#,
				'generic' => q#ختيځ اروپايي وخت#,
				'standard' => q#ختيځ اروپايي معياري وخت#,
			},
		},
		'Europe_Further_Eastern' => {
			long => {
				'standard' => q#لرې ختيځ اروپايي وخت#,
			},
		},
		'Europe_Western' => {
			long => {
				'daylight' => q#لوېديځ اروپايي اوړي وخت#,
				'generic' => q#لوېديځ اروپايي وخت#,
				'standard' => q#لوېديځ اروپايي معياري وخت#,
			},
		},
		'Falkland' => {
			long => {
				'daylight' => q#د فوکلنډ ټاپو اوړي وخت#,
				'generic' => q#فوکلنډ ټاپو وخت#,
				'standard' => q#د فوکلنډ ټاپو معیاری وخت#,
			},
		},
		'Fiji' => {
			long => {
				'daylight' => q#فجي د اوړي وخت#,
				'generic' => q#فجی وخت#,
				'standard' => q#فجی معياري وخت#,
			},
		},
		'French_Guiana' => {
			long => {
				'standard' => q#د فرانسوي ګانا وخت#,
			},
		},
		'French_Southern' => {
			long => {
				'standard' => q#د فرانسې سویل او انټارټيک وخت#,
			},
		},
		'GMT' => {
			long => {
				'standard' => q#ګرينويچ معياري وخت#,
			},
		},
		'Galapagos' => {
			long => {
				'standard' => q#ګالپګوس وخت#,
			},
		},
		'Gambier' => {
			long => {
				'standard' => q#ګيمبير وخت#,
			},
		},
		'Georgia' => {
			long => {
				'daylight' => q#د جورجيا د اوړي وخت#,
				'generic' => q#جورجیا وخت#,
				'standard' => q#جورجیا معیاري وخت#,
			},
		},
		'Gilbert_Islands' => {
			long => {
				'standard' => q#جلبرټ ټاپوګانو وخت#,
			},
		},
		'Greenland_Eastern' => {
			long => {
				'daylight' => q#د ختیځ ګرینلینډ اوړي وخت#,
				'generic' => q#د ختیځ ګرینلینډ وخت#,
				'standard' => q#د ختیځ ګرینلینډ معياري وخت#,
			},
		},
		'Greenland_Western' => {
			long => {
				'daylight' => q#لویدیځ ګرینلینډ اوړي وخت#,
				'generic' => q#لویدیځ ګرینلینډ وخت#,
				'standard' => q#لویدیځ ګرینلینډ معياري وخت#,
			},
		},
		'Gulf' => {
			long => {
				'standard' => q#خلیج معياري وخت#,
			},
		},
		'Guyana' => {
			long => {
				'standard' => q#د ګوانانا وخت#,
			},
		},
		'Hawaii_Aleutian' => {
			long => {
				'daylight' => q#هوایی الیوتین رڼا ورځې وخت#,
				'generic' => q#هوایی الیوتین وخت#,
				'standard' => q#هوایی الیوتین معیاری وخت#,
			},
		},
		'Hong_Kong' => {
			long => {
				'daylight' => q#هانګ کانګ اوړي وخت#,
				'generic' => q#هانګ کانګ وخت#,
				'standard' => q#هانګ کانګ معياري وخت#,
			},
		},
		'Hovd' => {
			long => {
				'daylight' => q#هاوډ اوړي وخت#,
				'generic' => q#هاوډ وخت#,
				'standard' => q#هاوډ معیاری وخت#,
			},
		},
		'India' => {
			long => {
				'standard' => q#هند معیاري وخت#,
			},
		},
		'Indian/Antananarivo' => {
			exemplarCity => q#انتانناريوو#,
		},
		'Indian/Chagos' => {
			exemplarCity => q#چاګوس#,
		},
		'Indian/Christmas' => {
			exemplarCity => q#کريسمس#,
		},
		'Indian/Cocos' => {
			exemplarCity => q#کوکوز#,
		},
		'Indian/Comoro' => {
			exemplarCity => q#کومورو#,
		},
		'Indian/Kerguelen' => {
			exemplarCity => q#کرګولين#,
		},
		'Indian/Mahe' => {
			exemplarCity => q#ماهي#,
		},
		'Indian/Maldives' => {
			exemplarCity => q#مالديپ#,
		},
		'Indian/Mauritius' => {
			exemplarCity => q#ماريشيس#,
		},
		'Indian/Mayotte' => {
			exemplarCity => q#میټوت#,
		},
		'Indian/Reunion' => {
			exemplarCity => q#ري يونين#,
		},
		'Indian_Ocean' => {
			long => {
				'standard' => q#د هند سمندر وخت#,
			},
		},
		'Indochina' => {
			long => {
				'standard' => q#انډوچاینه وخت#,
			},
		},
		'Indonesia_Central' => {
			long => {
				'standard' => q#مرکزي ادونيزيا وخت#,
			},
		},
		'Indonesia_Eastern' => {
			long => {
				'standard' => q#اندونیزیا وخت#,
			},
		},
		'Indonesia_Western' => {
			long => {
				'standard' => q#لویدیځ اندونیزیا وخت#,
			},
		},
		'Iran' => {
			long => {
				'daylight' => q#ايران د ورځې روښانه وخت#,
				'generic' => q#ایران وخت#,
				'standard' => q#ایران معياري وخت#,
			},
		},
		'Irkutsk' => {
			long => {
				'daylight' => q#ارکوټسک اوړي وخت#,
				'generic' => q#ارکوټسک وخت#,
				'standard' => q#ارکوټسک معياري وخت#,
			},
		},
		'Israel' => {
			long => {
				'daylight' => q#اسراييل د ورځې روښانه وخت#,
				'generic' => q#اسراییل وخت#,
				'standard' => q#اسراییل معياري وخت#,
			},
		},
		'Japan' => {
			long => {
				'daylight' => q#جاپان د ورځې روښانه وخت#,
				'generic' => q#جاپان وخت#,
				'standard' => q#جاپان معياري وخت#,
			},
		},
		'Kazakhstan_Eastern' => {
			long => {
				'standard' => q#ختيځ قازقستان وخت#,
			},
		},
		'Kazakhstan_Western' => {
			long => {
				'standard' => q#لویدیځ قزاقستان وخت#,
			},
		},
		'Korea' => {
			long => {
				'daylight' => q#کوريايي د ورځې روښانه وخت#,
				'generic' => q#کوريايي وخت#,
				'standard' => q#کوريايي معياري وخت#,
			},
		},
		'Kosrae' => {
			long => {
				'standard' => q#کوسراي وخت#,
			},
		},
		'Krasnoyarsk' => {
			long => {
				'daylight' => q#کريسنويارسک اوړي وخت#,
				'generic' => q#کريسنويارسک وخت#,
				'standard' => q#کريسنويارسک معياري وخت#,
			},
		},
		'Kyrgystan' => {
			long => {
				'standard' => q#کرغیزستان وخت#,
			},
		},
		'Line_Islands' => {
			long => {
				'standard' => q#لاين ټاپوګانو وخت#,
			},
		},
		'Lord_Howe' => {
			long => {
				'daylight' => q#لارډ هوي د ورځې روښانه وخت#,
				'generic' => q#لارډ هوي وخت#,
				'standard' => q#لارډ هوي معياري وخت#,
			},
		},
		'Macquarie' => {
			long => {
				'standard' => q#مکواري ټاپو وخت#,
			},
		},
		'Magadan' => {
			long => {
				'daylight' => q#ميګډان اوړي وخت#,
				'generic' => q#ميګډان وخت#,
				'standard' => q#ميګډان معياري وخت#,
			},
		},
		'Malaysia' => {
			long => {
				'standard' => q#ملائیشیا وخت#,
			},
		},
		'Maldives' => {
			long => {
				'standard' => q#مالديپ وخت#,
			},
		},
		'Marquesas' => {
			long => {
				'standard' => q#مارکسس وخت#,
			},
		},
		'Marshall_Islands' => {
			long => {
				'standard' => q#مارشل ټاپوګانو وخت#,
			},
		},
		'Mauritius' => {
			long => {
				'daylight' => q#ماريشيس د اوړي وخت#,
				'generic' => q#ماريشيس وخت#,
				'standard' => q#ماریشیس معياري وخت#,
			},
		},
		'Mawson' => {
			long => {
				'standard' => q#ماوسن وخت#,
			},
		},
		'Mexico_Northwest' => {
			long => {
				'daylight' => q#د شمال لویدیځ مکسیکو رڼا ورځې وخت#,
				'generic' => q#د شمال لویدیځ مکسیکو وخت#,
				'standard' => q#د شمال لویدیځ مکسیکو معیاري وخت#,
			},
		},
		'Mexico_Pacific' => {
			long => {
				'daylight' => q#مکسیکن پیسفک رڼا ورځې وخت#,
				'generic' => q#مکسیکن پیسفک وخت#,
				'standard' => q#مکسیکن پیسفک معیاری وخت#,
			},
		},
		'Mongolia' => {
			long => {
				'daylight' => q#اولان باټر اوړي وخت#,
				'generic' => q#اولان باټر وخت#,
				'standard' => q#اولان باټر معیاري وخت#,
			},
		},
		'Moscow' => {
			long => {
				'daylight' => q#ماسکو سمر وخت#,
				'generic' => q#ماسکو وخت#,
				'standard' => q#ماسکو معياري وخت#,
			},
		},
		'Myanmar' => {
			long => {
				'standard' => q#میانمار وخت#,
			},
		},
		'Nauru' => {
			long => {
				'standard' => q#ناورو وخت#,
			},
		},
		'Nepal' => {
			long => {
				'standard' => q#نیپال وخت#,
			},
		},
		'New_Caledonia' => {
			long => {
				'daylight' => q#نيو کايډونيا اوړي وخت#,
				'generic' => q#نیو کالیډونیا وخت#,
				'standard' => q#نيو کالیډونیا معياري وخت#,
			},
		},
		'New_Zealand' => {
			long => {
				'daylight' => q#نيوزي لېنډ د ورځې روښانه وخت#,
				'generic' => q#نيوزي لېنډ وخت#,
				'standard' => q#نيوزي لېنډ معياري وخت#,
			},
		},
		'Newfoundland' => {
			long => {
				'daylight' => q#نيو فاونډلېنډ د ورځې روښانه وخت#,
				'generic' => q#نيو فاونډلېنډ وخت#,
				'standard' => q#د نوي فیلډلینډ معیاری وخت#,
			},
		},
		'Niue' => {
			long => {
				'standard' => q#نییو وخت#,
			},
		},
		'Norfolk' => {
			long => {
				'daylight' => q#د نورفکاس ټاپو اوړي وخت#,
				'generic' => q#نورفوک ټاپو وخت#,
				'standard' => q#د نورفکاس ټاپو معياري وخت#,
			},
		},
		'Noronha' => {
			long => {
				'daylight' => q#فرنانڈو دي نورونھا اوړي وخت#,
				'generic' => q#فرنانڈو دي نورونها وخت#,
				'standard' => q#فرنانڈو دي نورونها معیاری وخت#,
			},
		},
		'Novosibirsk' => {
			long => {
				'daylight' => q#نووسيبرسک اوړي وخت#,
				'generic' => q#نووسيبرسک وخت#,
				'standard' => q#نووسيبرسک معياري وخت#,
			},
		},
		'Omsk' => {
			long => {
				'daylight' => q#اومسک اوړي وخت#,
				'generic' => q#اومسک وخت#,
				'standard' => q#اومسک معياري وخت#,
			},
		},
		'Pacific/Apia' => {
			exemplarCity => q#اپیا#,
		},
		'Pacific/Auckland' => {
			exemplarCity => q#اکلند#,
		},
		'Pacific/Bougainville' => {
			exemplarCity => q#بوګن ویل#,
		},
		'Pacific/Chatham' => {
			exemplarCity => q#چاتام#,
		},
		'Pacific/Easter' => {
			exemplarCity => q#ایسټر#,
		},
		'Pacific/Efate' => {
			exemplarCity => q#عفات#,
		},
		'Pacific/Enderbury' => {
			exemplarCity => q#انډربري#,
		},
		'Pacific/Fakaofo' => {
			exemplarCity => q#فوکافو#,
		},
		'Pacific/Fiji' => {
			exemplarCity => q#فجي#,
		},
		'Pacific/Funafuti' => {
			exemplarCity => q#فونافوتي#,
		},
		'Pacific/Galapagos' => {
			exemplarCity => q#ګالپګوس#,
		},
		'Pacific/Gambier' => {
			exemplarCity => q#ګيمبير#,
		},
		'Pacific/Guadalcanal' => {
			exemplarCity => q#ګواډلکينال#,
		},
		'Pacific/Guam' => {
			exemplarCity => q#ګوام#,
		},
		'Pacific/Honolulu' => {
			exemplarCity => q#هینولولو#,
		},
		'Pacific/Johnston' => {
			exemplarCity => q#جانسټن#,
		},
		'Pacific/Kiritimati' => {
			exemplarCity => q#کيريټماټي#,
		},
		'Pacific/Kosrae' => {
			exemplarCity => q#کوسراي#,
		},
		'Pacific/Kwajalein' => {
			exemplarCity => q#کواجلين#,
		},
		'Pacific/Majuro' => {
			exemplarCity => q#مجورو#,
		},
		'Pacific/Marquesas' => {
			exemplarCity => q#مارکيساس#,
		},
		'Pacific/Midway' => {
			exemplarCity => q#ميډوی#,
		},
		'Pacific/Nauru' => {
			exemplarCity => q#نایرو#,
		},
		'Pacific/Niue' => {
			exemplarCity => q#نیوو#,
		},
		'Pacific/Norfolk' => {
			exemplarCity => q#نورفک#,
		},
		'Pacific/Noumea' => {
			exemplarCity => q#نوميا#,
		},
		'Pacific/Pago_Pago' => {
			exemplarCity => q#پيګو پيګو#,
		},
		'Pacific/Palau' => {
			exemplarCity => q#پلاو#,
		},
		'Pacific/Pitcairn' => {
			exemplarCity => q#پيټيکيرن#,
		},
		'Pacific/Ponape' => {
			exemplarCity => q#پونپي#,
		},
		'Pacific/Port_Moresby' => {
			exemplarCity => q#پورټ مورسبی#,
		},
		'Pacific/Rarotonga' => {
			exemplarCity => q#راروټونګا#,
		},
		'Pacific/Saipan' => {
			exemplarCity => q#سيپان#,
		},
		'Pacific/Tahiti' => {
			exemplarCity => q#ټهيټي#,
		},
		'Pacific/Tarawa' => {
			exemplarCity => q#تاراوا#,
		},
		'Pacific/Tongatapu' => {
			exemplarCity => q#ټونګاتاپو#,
		},
		'Pacific/Truk' => {
			exemplarCity => q#چوک#,
		},
		'Pacific/Wake' => {
			exemplarCity => q#ویک#,
		},
		'Pacific/Wallis' => {
			exemplarCity => q#والس#,
		},
		'Pakistan' => {
			long => {
				'daylight' => q#پاکستان اوړي وخت#,
				'generic' => q#پاکستان وخت#,
				'standard' => q#پاکستان معیاري وخت#,
			},
		},
		'Palau' => {
			long => {
				'standard' => q#پالاو وخت#,
			},
		},
		'Papua_New_Guinea' => {
			long => {
				'standard' => q#پاپوا نیو ګنی وخت#,
			},
		},
		'Paraguay' => {
			long => {
				'daylight' => q#پاراګوای اوړي وخت#,
				'generic' => q#پيراګوای وخت#,
				'standard' => q#پیراګوای معياري وخت#,
			},
		},
		'Peru' => {
			long => {
				'daylight' => q#پیرو اوړي وخت#,
				'generic' => q#پیرو وخت#,
				'standard' => q#پیرو معياري وخت#,
			},
		},
		'Philippines' => {
			long => {
				'daylight' => q#فلپاين اوړي وخت#,
				'generic' => q#فلپاين وخت#,
				'standard' => q#فلپاين معياري وخت#,
			},
		},
		'Phoenix_Islands' => {
			long => {
				'standard' => q#د فینکس ټاپو وخت#,
			},
		},
		'Pierre_Miquelon' => {
			long => {
				'daylight' => q#سینټ پییرا و ميکلين رڼا ورځې وخت#,
				'generic' => q#سینټ پییرا و ميکلين وخت#,
				'standard' => q#سینټ پییرا و ميکلين معیاری وخت#,
			},
		},
		'Pitcairn' => {
			long => {
				'standard' => q#پیټ کارین وخت#,
			},
		},
		'Ponape' => {
			long => {
				'standard' => q#پونيپ وخت#,
			},
		},
		'Pyongyang' => {
			long => {
				'standard' => q#پيانګ يانګ وخت#,
			},
		},
		'Reunion' => {
			long => {
				'standard' => q#ري يونين وخت#,
			},
		},
		'Rothera' => {
			long => {
				'standard' => q#رودرا وخت#,
			},
		},
		'Sakhalin' => {
			long => {
				'daylight' => q#سخلين اوړي وخت#,
				'generic' => q#سخلين وخت#,
				'standard' => q#سخلین معياري وخت#,
			},
		},
		'Samoa' => {
			long => {
				'daylight' => q#سموا د ورځې روښانه وخت#,
				'generic' => q#سموا وخت#,
				'standard' => q#سموا معياري وخت#,
			},
		},
		'Seychelles' => {
			long => {
				'standard' => q#سیچیلس وخت#,
			},
		},
		'Singapore' => {
			long => {
				'standard' => q#سنګاپور معیاري وخت#,
			},
		},
		'Solomon' => {
			long => {
				'standard' => q#سلیمان ټاپوګانو وخت#,
			},
		},
		'South_Georgia' => {
			long => {
				'standard' => q#د سویل جورجیا وخت#,
			},
		},
		'Suriname' => {
			long => {
				'standard' => q#سورینام وخت#,
			},
		},
		'Syowa' => {
			long => {
				'standard' => q#سیوا وخت#,
			},
		},
		'Tahiti' => {
			long => {
				'standard' => q#ټهيټي وخت#,
			},
		},
		'Taipei' => {
			long => {
				'daylight' => q#تايپي د ورځې روښانه وخت#,
				'generic' => q#تايپي وخت#,
				'standard' => q#تايپي معياري وخت#,
			},
		},
		'Tajikistan' => {
			long => {
				'standard' => q#تاجکستان وخت#,
			},
		},
		'Tokelau' => {
			long => {
				'standard' => q#توکیلاو وخت#,
			},
		},
		'Tonga' => {
			long => {
				'daylight' => q#ټونګا اوړي وخت#,
				'generic' => q#ټونګا وخت#,
				'standard' => q#د ټونګ معياري وخت#,
			},
		},
		'Truk' => {
			long => {
				'standard' => q#چوک وخت#,
			},
		},
		'Turkmenistan' => {
			long => {
				'daylight' => q#ترکمنستان اوړي وخت#,
				'generic' => q#ترکمانستان وخت#,
				'standard' => q#ترکمنستان معياري وخت#,
			},
		},
		'Tuvalu' => {
			long => {
				'standard' => q#تووالو وخت#,
			},
		},
		'Uruguay' => {
			long => {
				'daylight' => q#یوروګوای اوړي وخت#,
				'generic' => q#یوروګوای وخت#,
				'standard' => q#یوروګوای معياري وخت#,
			},
		},
		'Uzbekistan' => {
			long => {
				'daylight' => q#ازبکستان اوړي وخت#,
				'generic' => q#ازبکستان وخت#,
				'standard' => q#ازبکستان معياري وخت#,
			},
		},
		'Vanuatu' => {
			long => {
				'daylight' => q#ونواتو اوړي وخت#,
				'generic' => q#د وناتو وخت#,
				'standard' => q#ونواتو معياري وخت#,
			},
		},
		'Venezuela' => {
			long => {
				'standard' => q#وینزویلا وخت#,
			},
		},
		'Vladivostok' => {
			long => {
				'daylight' => q#ولاديوستاک اوړي وخت#,
				'generic' => q#ولادیوستاک وخت#,
				'standard' => q#ولاديوستاک معياري وخت#,
			},
		},
		'Volgograd' => {
			long => {
				'daylight' => q#والګوګراد اوړي وخت#,
				'generic' => q#والګوګراد وخت#,
				'standard' => q#والګوګراد معياري وخت#,
			},
		},
		'Vostok' => {
			long => {
				'standard' => q#واستوک وخت#,
			},
		},
		'Wake' => {
			long => {
				'standard' => q#ويک تاپو وخت#,
			},
		},
		'Wallis' => {
			long => {
				'standard' => q#والس او فوتونا وخت#,
			},
		},
		'Yakutsk' => {
			long => {
				'daylight' => q#ياکوټسک د اوړي وخت#,
				'generic' => q#ياکوټسک وخت#,
				'standard' => q#ياکوټسک معياري وخت#,
			},
		},
		'Yekaterinburg' => {
			long => {
				'daylight' => q#د ياکټرنبرګ د اوړي وخت#,
				'generic' => q#یکاټیرینبرګ وخت#,
				'standard' => q#د ياکيټرنبرګ معياري وخت#,
			},
		},
		'Yukon' => {
			long => {
				'standard' => q#د یوکون وخت#,
			},
		},
	 } }
);
no Moo;

1;

# vim: tabstop=4
