=encoding utf8

=head1 NAME

Locale::CLDR::Locales::Mr - Package for language Marathi

=cut

package Locale::CLDR::Locales::Mr;
# This file auto generated from Data\common\main\mr.xml
#	on Wed 28 Feb 12:16:00 am GMT

use strict;
use warnings;
use version;

our $VERSION = version->declare('v0.44.1');

use v5.10.1;
use mro 'c3';
use utf8;
use if $^V ge v5.12.0, feature => 'unicode_strings';
use Types::Standard qw( Str Int HashRef ArrayRef CodeRef RegexpRef );
use Moo;

extends('Locale::CLDR::Locales::Root');
has 'display_name_language' => (
	is			=> 'ro',
	isa			=> CodeRef,
	init_arg	=> undef,
	default		=> sub {
		 sub {
			 my %languages = (
				'aa' => 'अफार',
 				'ab' => 'अबखेजियन',
 				'ace' => 'अचीनी',
 				'ach' => 'अकोली',
 				'ada' => 'अडांग्मे',
 				'ady' => 'अडिघे',
 				'ae' => 'अवेस्तन',
 				'af' => 'अफ्रिकान्स',
 				'afh' => 'अफ्रिहिली',
 				'agq' => 'अघेम',
 				'ain' => 'ऐनू',
 				'ak' => 'अकान',
 				'akk' => 'अक्केडियन',
 				'ale' => 'अलेउत',
 				'alt' => 'दक्षिणात्य अल्ताई',
 				'am' => 'अम्हारिक',
 				'an' => 'अर्गोनीज',
 				'ang' => 'पुरातन इंग्रजी',
 				'ann' => 'ओबोलो',
 				'anp' => 'अंगिका',
 				'ar' => 'अरबी',
 				'ar_001' => 'आधुनिक प्रमाणित अरबी',
 				'arc' => 'अ‍ॅरेमाइक',
 				'arn' => 'मापुची',
 				'arp' => 'आरापाहो',
 				'ars' => 'नजदी अरबी',
 				'arw' => 'आरावाक',
 				'as' => 'आसामी',
 				'asa' => 'असु',
 				'ast' => 'अस्तुरियन',
 				'atj' => 'अटिकमेक',
 				'av' => 'अ‍ॅव्हेरिक',
 				'awa' => 'अवधी',
 				'ay' => 'ऐमरा',
 				'az' => 'अझरबैजानी',
 				'az@alt=short' => 'अझेरी',
 				'ba' => 'बष्किर',
 				'bal' => 'बलुची',
 				'ban' => 'बालिनीज',
 				'bas' => 'बसा',
 				'be' => 'बेलारुशियन',
 				'bej' => 'बेजा',
 				'bem' => 'बेम्बा',
 				'bez' => 'बेना',
 				'bg' => 'बल्गेरियन',
 				'bgc' => 'हरियाणवी',
 				'bgn' => 'पश्चिमी बालोची',
 				'bho' => 'भोजपुरी',
 				'bi' => 'बिस्लामा',
 				'bik' => 'बिकोल',
 				'bin' => 'बिनी',
 				'bla' => 'सिक्सिका',
 				'bm' => 'बाम्बारा',
 				'bn' => 'बंगाली',
 				'bo' => 'तिबेटी',
 				'br' => 'ब्रेतॉन',
 				'bra' => 'ब्रज',
 				'brx' => 'बोडो',
 				'bs' => 'बोस्नियन',
 				'bua' => 'बुरियात',
 				'bug' => 'बगिनीस',
 				'byn' => 'ब्लिन',
 				'ca' => 'कातालान',
 				'cad' => 'कॅड्डो',
 				'car' => 'कॅरिब',
 				'cay' => 'केयुगा',
 				'cch' => 'अत्सम',
 				'ccp' => 'चाकमा',
 				'ce' => 'चेचेन',
 				'ceb' => 'सिबुआनो',
 				'cgg' => 'किगा',
 				'ch' => 'कॅमोरो',
 				'chb' => 'चिब्चा',
 				'chg' => 'छागाताइ',
 				'chk' => 'चूकीसे',
 				'chm' => 'मारी',
 				'chn' => 'चिनूक जारगॉन',
 				'cho' => 'चोक्तौ',
 				'chp' => 'शिपेव्यान',
 				'chr' => 'चेरोकी',
 				'chy' => 'शेयेन्न',
 				'ckb' => 'मध्य कुर्दिश',
 				'ckb@alt=menu' => 'कुर्दिश, मध्य',
 				'ckb@alt=variant' => 'कुर्दिश, सोरानी',
 				'clc' => 'चिलकोटिन',
 				'co' => 'कॉर्सिकन',
 				'cop' => 'कॉप्टिक',
 				'cr' => 'क्री',
 				'crg' => 'मिचिफो',
 				'crh' => 'क्राइमीन तुर्की',
 				'crj' => 'दक्षिणात्य इस्ट क्री',
 				'crk' => 'प्लेन्स क्री',
 				'crl' => 'नॉर्दर्न ईस्ट क्री',
 				'crm' => 'मूस क्री',
 				'crr' => 'कॅरोलिना अल्गोंक्वियन',
 				'crs' => 'सेसेल्वा क्रिओल फ्रेंच',
 				'cs' => 'झेक',
 				'csb' => 'काशुबियन',
 				'csw' => 'स्वॅम्पी क्री',
 				'cu' => 'चर्च स्लाव्हिक',
 				'cv' => 'चूवाश',
 				'cy' => 'वेल्श',
 				'da' => 'डॅनिश',
 				'dak' => 'डाकोटा',
 				'dar' => 'दार्गवा',
 				'dav' => 'तायता',
 				'de' => 'जर्मन',
 				'de_AT' => 'ऑस्ट्रियन जर्मन',
 				'de_CH' => 'स्विस हाय जर्मन',
 				'del' => 'डेलावेयर',
 				'den' => 'स्लाव्ह',
 				'dgr' => 'डोग्रिब',
 				'din' => 'डिन्का',
 				'dje' => 'झार्मा',
 				'doi' => 'डोगरी',
 				'dsb' => 'लोअर सोर्बियन',
 				'dua' => 'दुआला',
 				'dum' => 'मिडल डच',
 				'dv' => 'दिवेही',
 				'dyo' => 'जोला-फॉन्यी',
 				'dyu' => 'ड्युला',
 				'dz' => 'झोंगखा',
 				'dzg' => 'दाझागा',
 				'ebu' => 'एम्बू',
 				'ee' => 'एवे',
 				'efi' => 'एफिक',
 				'egy' => 'प्राचीन इजिप्शियन',
 				'eka' => 'एकाजुक',
 				'el' => 'ग्रीक',
 				'elx' => 'एलामाइट',
 				'en' => 'इंग्रजी',
 				'en_AU' => 'ऑस्ट्रेलियन इंग्रजी',
 				'en_CA' => 'कॅनडियन इंग्रजी',
 				'en_GB' => 'ब्रिटिश इंग्रजी',
 				'en_GB@alt=short' => 'यू.के. इंग्रजी',
 				'en_US' => 'अमेरिकन इंग्रजी',
 				'en_US@alt=short' => 'यू.एस. इंग्रजी',
 				'enm' => 'मिडल इंग्रजी',
 				'eo' => 'एस्परान्टो',
 				'es' => 'स्पॅनिश',
 				'es_419' => 'लॅटिन अमेरिकन स्पॅनिश',
 				'es_ES' => 'युरोपियन स्पॅनिश',
 				'es_MX' => 'मेक्सिकन स्पॅनिश',
 				'et' => 'इस्टोनियन',
 				'eu' => 'बास्क',
 				'ewo' => 'इवोन्डो',
 				'fa' => 'फारसी',
 				'fa_AF' => 'दारी',
 				'fan' => 'फँग',
 				'fat' => 'फन्टी',
 				'ff' => 'फुलाह',
 				'fi' => 'फिनिश',
 				'fil' => 'फिलिपिनो',
 				'fj' => 'फिजियन',
 				'fo' => 'फरोइज',
 				'fon' => 'फॉन',
 				'fr' => 'फ्रेंच',
 				'fr_CA' => 'कॅनडियन फ्रेंच',
 				'fr_CH' => 'स्विस फ्रेंच',
 				'frc' => 'केजॉन फ्रेंच',
 				'frm' => 'मिडल फ्रेंच',
 				'fro' => 'पुरातन फ्रेंच',
 				'frr' => 'उत्तरी फ्रिशियन',
 				'frs' => 'पौर्वात्य फ्रिशियन',
 				'fur' => 'फ्रियुलियान',
 				'fy' => 'पश्चिमी फ्रिशियन',
 				'ga' => 'आयरिश',
 				'gaa' => 'गा',
 				'gag' => 'गागाउझ',
 				'gan' => 'गॅन चिनी',
 				'gay' => 'गायो',
 				'gba' => 'बाया',
 				'gd' => 'स्कॉटिश गेलिक',
 				'gez' => 'गीझ',
 				'gil' => 'जिल्बरटीज',
 				'gl' => 'गॅलिशियन',
 				'gmh' => 'मिडल हाय जर्मन',
 				'gn' => 'गुआरनी',
 				'goh' => 'पुरातन हाइ जर्मन',
 				'gon' => 'गाँडी',
 				'gor' => 'गोरोन्तालो',
 				'got' => 'गॉथिक',
 				'grb' => 'ग्रेबो',
 				'grc' => 'प्राचीन ग्रीक',
 				'gsw' => 'स्विस जर्मन',
 				'gu' => 'गुजराती',
 				'guz' => 'गसी',
 				'gv' => 'मांक्स',
 				'gwi' => 'ग्विच’इन',
 				'ha' => 'हौसा',
 				'hai' => 'हैडा',
 				'hak' => 'हाक्का चिनी',
 				'haw' => 'हवाईयन',
 				'hax' => 'दक्षिणात्य हैडा',
 				'he' => 'हिब्रू',
 				'hi' => 'हिंदी',
 				'hi_Latn@alt=variant' => 'हिंग्लिश',
 				'hil' => 'हिलीगेनॉन',
 				'hit' => 'हिट्टिते',
 				'hmn' => 'माँग',
 				'ho' => 'हिरी मॉटू',
 				'hr' => 'क्रोएशियन',
 				'hsb' => 'अप्पर सॉर्बियन',
 				'hsn' => 'शियांग चिनी',
 				'ht' => 'हैतीयन क्रेओल',
 				'hu' => 'हंगेरियन',
 				'hup' => 'हूपा',
 				'hur' => 'हॉल्कमेलम',
 				'hy' => 'आर्मेनियन',
 				'hz' => 'हरेरो',
 				'ia' => 'इंटरलिंग्वा',
 				'iba' => 'इबान',
 				'ibb' => 'इबिबिओ',
 				'id' => 'इंडोनेशियन',
 				'ie' => 'इन्टरलिंग',
 				'ig' => 'ईग्बो',
 				'ii' => 'सिचुआन यी',
 				'ik' => 'इनूपियाक',
 				'ikt' => 'वेस्टर्न कॅनेडियन इनुकिटुट',
 				'ilo' => 'इलोको',
 				'inh' => 'इंगुश',
 				'io' => 'इडौ',
 				'is' => 'आईसलँडिक',
 				'it' => 'इटालियन',
 				'iu' => 'इनुक्तीटुट',
 				'ja' => 'जपानी',
 				'jbo' => 'लोज्बान',
 				'jgo' => 'गोम्बा',
 				'jmc' => 'मशामे',
 				'jpr' => 'जुदेओ-फारसी',
 				'jrb' => 'जुदेओ-अरबी',
 				'jv' => 'जावानीज',
 				'ka' => 'जॉर्जियन',
 				'kaa' => 'कारा-कल्पक',
 				'kab' => 'कबाइल',
 				'kac' => 'काचिन',
 				'kaj' => 'ज्जु',
 				'kam' => 'काम्बा',
 				'kaw' => 'कावी',
 				'kbd' => 'कबार्डियन',
 				'kcg' => 'त्याप',
 				'kde' => 'माकोन्दे',
 				'kea' => 'काबवर्दियानु',
 				'kfo' => 'कोरो',
 				'kg' => 'काँगो',
 				'kgp' => 'काइंगांग',
 				'kha' => 'खासी',
 				'kho' => 'खोतानीस',
 				'khq' => 'कोयरा चीनी',
 				'ki' => 'किकुयू',
 				'kj' => 'क्वान्यामा',
 				'kk' => 'कझाक',
 				'kkj' => 'काको',
 				'kl' => 'कलाल्लिसत',
 				'kln' => 'कालेंजीन',
 				'km' => 'ख्मेर',
 				'kmb' => 'किम्बन्दु',
 				'kn' => 'कन्नड',
 				'ko' => 'कोरियन',
 				'koi' => 'कोमी-परम्याक',
 				'kok' => 'कोंकणी',
 				'kos' => 'कोसरियन',
 				'kpe' => 'क्पेल्ले',
 				'kr' => 'कनुरी',
 				'krc' => 'कराचय-बाल्कर',
 				'krl' => 'करेलियन',
 				'kru' => 'कुरूख',
 				'ks' => 'काश्मीरी',
 				'ksb' => 'शांबाला',
 				'ksf' => 'बाफिया',
 				'ksh' => 'कोलोग्नियन',
 				'ku' => 'कुर्दिश',
 				'kum' => 'कुमीक',
 				'kut' => 'कुतेनाई',
 				'kv' => 'कोमी',
 				'kw' => 'कोर्निश',
 				'kwk' => 'क्वक्क्वाला',
 				'ky' => 'किरगीझ',
 				'la' => 'लॅटिन',
 				'lad' => 'लादीनो',
 				'lag' => 'लांगी',
 				'lah' => 'लाह्न्डा',
 				'lam' => 'लाम्बा',
 				'lb' => 'लक्झेंबर्गिश',
 				'lez' => 'लेझ्घीयन',
 				'lg' => 'गांडा',
 				'li' => 'लिंबूर्गिश',
 				'lil' => 'लिलूएट',
 				'lkt' => 'लाकोटा',
 				'ln' => 'लिंगाला',
 				'lo' => 'लाओ',
 				'lol' => 'मोंगो',
 				'lou' => 'ल्युसियाना क्रिओल',
 				'loz' => 'लोझि',
 				'lrc' => 'उत्तरी ल्युरी',
 				'lsm' => 'सामिया',
 				'lt' => 'लिथुआनियन',
 				'lu' => 'ल्यूबा-कटांगा',
 				'lua' => 'लुबा-लुलुआ',
 				'lui' => 'लुइसेनो',
 				'lun' => 'लुन्डा',
 				'luo' => 'ल्युओ',
 				'lus' => 'मिझो',
 				'luy' => 'ल्युइया',
 				'lv' => 'लात्व्हियन',
 				'mad' => 'मादुरीस',
 				'mag' => 'मगही',
 				'mai' => 'मैथिली',
 				'mak' => 'मकस्सर',
 				'man' => 'मन्डिन्गो',
 				'mas' => 'मसाई',
 				'mdf' => 'मोक्ष',
 				'mdr' => 'मंडार',
 				'men' => 'मेन्डे',
 				'mer' => 'मेरू',
 				'mfe' => 'मोरिस्येन',
 				'mg' => 'मलागसी',
 				'mga' => 'मिडल आयरिश',
 				'mgh' => 'माखुव्हा-मीट्टो',
 				'mgo' => 'मीटा',
 				'mh' => 'मार्शलीज',
 				'mi' => 'माओरी',
 				'mic' => 'मिकमॅक',
 				'min' => 'मिनांग्काबाउ',
 				'mk' => 'मॅसेडोनियन',
 				'ml' => 'मल्याळम',
 				'mn' => 'मंगोलियन',
 				'mnc' => 'मान्चु',
 				'mni' => 'मणिपुरी',
 				'moe' => 'इन्नू-ॲमन',
 				'moh' => 'मोहॉक',
 				'mos' => 'मोस्सी',
 				'mr' => 'मराठी',
 				'ms' => 'मलय',
 				'mt' => 'माल्टिज्',
 				'mua' => 'मुंडांग',
 				'mul' => 'एकाधिक भाषा',
 				'mus' => 'क्रीक',
 				'mwl' => 'मिरांडिज्',
 				'mwr' => 'मारवाडी',
 				'my' => 'बर्मी',
 				'myv' => 'एर्झ्या',
 				'mzn' => 'माझानदेरानी',
 				'na' => 'नउरू',
 				'nan' => 'मिन नान चिनी',
 				'nap' => 'नेपोलिटान',
 				'naq' => 'नामा',
 				'nb' => 'नॉर्वेजियन बोकमाल',
 				'nd' => 'उत्तर देबेली',
 				'nds' => 'लो जर्मन',
 				'nds_NL' => 'लो सॅक्सन',
 				'ne' => 'नेपाळी',
 				'new' => 'नेवारी',
 				'ng' => 'डोंगा',
 				'nia' => 'नियास',
 				'niu' => 'नियुआन',
 				'nl' => 'डच',
 				'nl_BE' => 'फ्लेमिश',
 				'nmg' => 'क्वासिओ',
 				'nn' => 'नॉर्वेजियन न्योर्स्क',
 				'nnh' => 'जिएम्बून',
 				'no' => 'नोर्वेजियन',
 				'nog' => 'नोगाई',
 				'non' => 'पुरातन नॉर्स',
 				'nqo' => 'एन्को',
 				'nr' => 'दक्षिणात्य देबेली',
 				'nso' => 'उत्तरी सोथो',
 				'nus' => 'नुएर',
 				'nv' => 'नावाजो',
 				'nwc' => 'अभिजात नेवारी',
 				'ny' => 'न्यान्जा',
 				'nym' => 'न्यामवेझी',
 				'nyn' => 'न्यानकोल',
 				'nyo' => 'न्योरो',
 				'nzi' => 'न्झिमा',
 				'oc' => 'ऑक्सितान',
 				'oj' => 'ओजिब्वा',
 				'ojb' => 'नॉर्थवेस्टर्न ओजिब्वा',
 				'ojc' => 'सेंट्रल ओजिब्वा',
 				'ojs' => 'ओजी-क्री',
 				'ojw' => 'वेस्टर्न ओजिबवा',
 				'oka' => 'ओकनागन',
 				'om' => 'ओरोमो',
 				'or' => 'उडिया',
 				'os' => 'ओस्सेटिक',
 				'osa' => 'ओसेज',
 				'ota' => 'ओटोमान तुर्किश',
 				'pa' => 'पंजाबी',
 				'pag' => 'पंगासीनान',
 				'pal' => 'पहलवी',
 				'pam' => 'पाम्पान्गा',
 				'pap' => 'पापियामेन्टो',
 				'pau' => 'पालाउआन',
 				'pcm' => 'नायजिरिअन पिजिन',
 				'peo' => 'पुरातन फारसी',
 				'phn' => 'फोनिशियन',
 				'pi' => 'पाली',
 				'pis' => 'पिजिन',
 				'pl' => 'पोलिश',
 				'pon' => 'पोह्नपियन',
 				'pqm' => 'मालीसेट-पासामाक्वाड्डी',
 				'prg' => 'प्रुशियन',
 				'pro' => 'पुरातन प्रोव्हेन्सल',
 				'ps' => 'पश्तो',
 				'ps@alt=variant' => 'पुश्तो',
 				'pt' => 'पोर्तुगीज',
 				'pt_BR' => 'ब्राझिलियन पोर्तुगीज',
 				'pt_PT' => 'युरोपियन पोर्तुगीज',
 				'qu' => 'क्वेचुआ',
 				'quc' => 'कीशेइ',
 				'raj' => 'राजस्थानी',
 				'rap' => 'रापानुई',
 				'rar' => 'रारोटोंगन',
 				'rhg' => 'रोहिंग्या',
 				'rm' => 'रोमान्श',
 				'rn' => 'रुन्दी',
 				'ro' => 'रोमानियन',
 				'ro_MD' => 'मोल्डाव्हियन',
 				'rof' => 'रोम्बो',
 				'rom' => 'रोमानी',
 				'ru' => 'रशियन',
 				'rup' => 'अरोमानियन',
 				'rw' => 'किन्यार्वान्डा',
 				'rwk' => 'रव्हा',
 				'sa' => 'संस्कृत',
 				'sad' => 'सँडवे',
 				'sah' => 'साखा',
 				'sam' => 'सामरिटान अरॅमिक',
 				'saq' => 'सांबुरू',
 				'sas' => 'सासाक',
 				'sat' => 'संताली',
 				'sba' => 'गाम्बे',
 				'sbp' => 'सांगु',
 				'sc' => 'सर्दिनियन',
 				'scn' => 'सिसिलियन',
 				'sco' => 'स्कॉट्स',
 				'sd' => 'सिंधी',
 				'sdh' => 'दक्षिणी कुर्दिश',
 				'se' => 'उत्तरी सामी',
 				'seh' => 'सेना',
 				'sel' => 'सेल्कप',
 				'ses' => 'कोयराबोरो सेन्नी',
 				'sg' => 'सांगो',
 				'sga' => 'पुरातन आयरिश',
 				'sh' => 'सर्बो-क्रोएशियन',
 				'shi' => 'ताशेल्हिट',
 				'shn' => 'शॅन',
 				'si' => 'सिंहला',
 				'sid' => 'सिदामो',
 				'sk' => 'स्लोव्हाक',
 				'sl' => 'स्लोव्हेनियन',
 				'slh' => 'दक्षिणात्य लुशूटसीड',
 				'sm' => 'सामोअन',
 				'sma' => 'दक्षिणात्य सामी',
 				'smj' => 'ल्युल सामी',
 				'smn' => 'इनारी सामी',
 				'sms' => 'स्कोल्ट सामी',
 				'sn' => 'शोना',
 				'snk' => 'सोनिन्के',
 				'so' => 'सोमाली',
 				'sog' => 'सोग्डिएन',
 				'sq' => 'अल्बानियन',
 				'sr' => 'सर्बियन',
 				'srn' => 'स्रानान टॉन्गो',
 				'srr' => 'सेरेर',
 				'ss' => 'स्वाती',
 				'ssy' => 'साहो',
 				'st' => 'दक्षिणी सोथो',
 				'str' => 'स्ट्राइट्स सालीश',
 				'su' => 'सुंदानीज',
 				'suk' => 'सुकुमा',
 				'sus' => 'सुसु',
 				'sux' => 'सुमेरियन',
 				'sv' => 'स्वीडिश',
 				'sw' => 'स्वाहिली',
 				'sw_CD' => 'काँगो स्वाहिली',
 				'swb' => 'कोमोरियन',
 				'syc' => 'अभिजात सिरियाक',
 				'syr' => 'सिरियाक',
 				'ta' => 'तामिळ',
 				'tce' => 'दक्षिणात्य टचोन',
 				'te' => 'तेलगू',
 				'tem' => 'टिम्ने',
 				'teo' => 'तेसो',
 				'ter' => 'तेरेनो',
 				'tet' => 'तेतुम',
 				'tg' => 'ताजिक',
 				'tgx' => 'टॅगिश',
 				'th' => 'थाई',
 				'tht' => 'तहल्टन',
 				'ti' => 'तिग्रिन्या',
 				'tig' => 'टाइग्रे',
 				'tiv' => 'तिव',
 				'tk' => 'तुर्कमेन',
 				'tkl' => 'टोकेलाऊ',
 				'tl' => 'टागालोग',
 				'tlh' => 'क्लिंगॉन',
 				'tli' => 'लिंगित',
 				'tmh' => 'तामाशेक',
 				'tn' => 'त्स्वाना',
 				'to' => 'टोंगन',
 				'tog' => 'न्यासा टोन्गा',
 				'tok' => 'टोकि पोना',
 				'tpi' => 'टोक पिसिन',
 				'tr' => 'तुर्की',
 				'trv' => 'तारोको',
 				'ts' => 'सोंगा',
 				'tsi' => 'सिम्शियन',
 				'tt' => 'तातर',
 				'ttm' => 'नॉर्दर्न टचोन',
 				'tum' => 'तुम्बुका',
 				'tvl' => 'टुवालु',
 				'tw' => 'ट्वी',
 				'twq' => 'तासाव्हाक',
 				'ty' => 'ताहितीयन',
 				'tyv' => 'टुवीनियन',
 				'tzm' => 'मध्य अ‍ॅटलास तॅमाझाइट',
 				'udm' => 'उदमुर्त',
 				'ug' => 'उइगुर',
 				'uga' => 'युगॅरिटिक',
 				'uk' => 'युक्रेनियन',
 				'umb' => 'उम्बुन्डु',
 				'und' => 'अज्ञात भाषा',
 				'ur' => 'उर्दू',
 				'uz' => 'उझ्बेक',
 				'vai' => 'वाई',
 				've' => 'व्हेंदा',
 				'vi' => 'व्हिएतनामी',
 				'vo' => 'ओलापुक',
 				'vot' => 'वॉटिक',
 				'vun' => 'वुंजो',
 				'wa' => 'वालून',
 				'wae' => 'वालसेर',
 				'wal' => 'वोलायता',
 				'war' => 'वारे',
 				'was' => 'वाशो',
 				'wbp' => 'वार्लपिरी',
 				'wo' => 'वोलोफ',
 				'wuu' => 'व्हू चिनी',
 				'xal' => 'काल्मिक',
 				'xh' => 'खोसा',
 				'xog' => 'सोगा',
 				'yao' => 'याओ',
 				'yap' => 'यापीस',
 				'yav' => 'यांगबेन',
 				'ybb' => 'येमबा',
 				'yi' => 'यिद्दिश',
 				'yo' => 'योरुबा',
 				'yrl' => 'न्हेंगाटू',
 				'yue' => 'कँटोनीज',
 				'yue@alt=menu' => 'चीनी, कँटोनीज',
 				'za' => 'झुआंग',
 				'zap' => 'झेपोटेक',
 				'zbl' => 'ब्लिसिम्बॉल्स',
 				'zen' => 'झेनान्गा',
 				'zgh' => 'प्रमाण मोरोक्कन तॅमॅझायट',
 				'zh' => 'चीनी',
 				'zh@alt=menu' => 'चीनी, मँडेरिन',
 				'zh_Hans' => 'सरलीकृत चीनी',
 				'zh_Hans@alt=long' => 'सरलीकृत मँडेरिन चीनी',
 				'zh_Hant' => 'पारंपारिक चीनी',
 				'zh_Hant@alt=long' => 'पारंपारिक मँडेरिन चीनी',
 				'zu' => 'झुलू',
 				'zun' => 'झुनी',
 				'zxx' => 'भाषावैज्ञानिक सामग्री नाही',
 				'zza' => 'झाझा',

			);
			if (@_) {
				return $languages{$_[0]};
			}
			return \%languages;
		}
	},
);

has 'display_name_script' => (
	is			=> 'ro',
	isa			=> CodeRef,
	init_arg	=> undef,
	default		=> sub {
		sub {
			my %scripts = (
			'Adlm' => 'अदलम',
 			'Arab' => 'अरबी',
 			'Arab@alt=variant' => 'फारसी-अरबी',
 			'Aran' => 'नस्तालीक',
 			'Armi' => 'इम्पिरियल आर्मेनिक',
 			'Armn' => 'अर्मेनियन',
 			'Avst' => 'अवेस्तान',
 			'Bali' => 'बाली',
 			'Batk' => 'बटाक',
 			'Beng' => 'बंगाली',
 			'Blis' => 'ब्लिसिम्बॉल्स',
 			'Bopo' => 'बोपोमोफो',
 			'Brah' => 'ब्रह्मी',
 			'Brai' => 'ब्रेल',
 			'Bugi' => 'बूगी',
 			'Buhd' => 'बुहिद',
 			'Cakm' => 'चकमा',
 			'Cans' => 'यूनिफाइड कॅनेडियन अ‍ॅबोरिजनल सिलॅबिक्स',
 			'Cari' => 'कॅरियन',
 			'Cham' => 'चाम',
 			'Cher' => 'चेरोकी',
 			'Cirt' => 'किर्थ',
 			'Copt' => 'कॉप्टिक',
 			'Cprt' => 'सायप्रिऑट',
 			'Cyrl' => 'सीरिलिक',
 			'Cyrs' => 'पुरातन चर्च स्लाव्होनिक सिरिलिक',
 			'Deva' => 'देवनागरी',
 			'Dsrt' => 'डेसर्ट',
 			'Egyd' => 'इजिप्शियन डेमोटिक',
 			'Egyh' => 'इजिप्शियन हायरेटिक',
 			'Egyp' => 'इजिप्शियन हायरोग्लिफ्स',
 			'Ethi' => 'ईथिओपिक',
 			'Geok' => 'जॉर्जियन खुत्सुरी',
 			'Geor' => 'जॉर्जियन',
 			'Glag' => 'ग्लॅगोलिटिक',
 			'Goth' => 'गोथिक',
 			'Grek' => 'ग्रीक',
 			'Gujr' => 'गुजराती',
 			'Guru' => 'गुरुमुखी',
 			'Hanb' => 'बोपोमोफोसह हान',
 			'Hang' => 'हंगुल',
 			'Hani' => 'हान',
 			'Hano' => 'हनुनू',
 			'Hans' => 'सरलीकृत',
 			'Hans@alt=stand-alone' => 'सरलीकृत हान',
 			'Hant' => 'पारंपारिक',
 			'Hant@alt=stand-alone' => 'पारंपारिक हान',
 			'Hebr' => 'हिब्रू',
 			'Hira' => 'हिरागाना',
 			'Hmng' => 'पहाउ मंग',
 			'Hrkt' => 'जापानी स्वरलिपी',
 			'Hung' => 'पुरातन हंगेरियन',
 			'Inds' => 'सिन्धु',
 			'Ital' => 'जुनी इटालिक',
 			'Jamo' => 'जामो',
 			'Java' => 'जावानीस',
 			'Jpan' => 'जपानी',
 			'Kali' => 'कायाह ली',
 			'Kana' => 'कॅटाकाना',
 			'Khar' => 'खारोश्थी',
 			'Khmr' => 'ख्मेर',
 			'Knda' => 'कन्नड',
 			'Kore' => 'कोरियन',
 			'Kthi' => 'काइथी',
 			'Lana' => 'लाना',
 			'Laoo' => 'लाओ',
 			'Latf' => 'फ्रॅक्तुर लॅटिन',
 			'Latg' => 'गाएलिक लेटिन',
 			'Latn' => 'लॅटिन',
 			'Lepc' => 'लेपचा',
 			'Limb' => 'लिम्बू',
 			'Lina' => 'लीनियार अ',
 			'Linb' => 'लीनियर बी',
 			'Lyci' => 'लायशियान',
 			'Lydi' => 'लायडियान',
 			'Mand' => 'मान्डायीन',
 			'Mani' => 'मानीचायीन',
 			'Maya' => 'मायान हाइरोग्लिफ्स',
 			'Mero' => 'मेरोइटिक',
 			'Mlym' => 'मल्याळम',
 			'Mong' => 'मंगोलियन',
 			'Moon' => 'मून',
 			'Mtei' => 'मेइतेइ मायेक',
 			'Mymr' => 'म्यानमार',
 			'Nkoo' => 'एन्‘को',
 			'Ogam' => 'ओघाम',
 			'Olck' => 'ओल चिकि',
 			'Orkh' => 'ओर्खोन',
 			'Orya' => 'उडिया',
 			'Osma' => 'उस्मानिया',
 			'Perm' => 'पुरातन पर्मिक',
 			'Phag' => 'फाग्स-पा',
 			'Phli' => 'इन्स्क्रिप्शनल पाहलवी',
 			'Phlp' => 'सॉल्टर पाहलवी',
 			'Phlv' => 'बुक पाहलवी',
 			'Phnx' => 'फोनिशियन',
 			'Plrd' => 'पोलार्ड फोनेटिक',
 			'Prti' => 'इन्स्क्रिप्शनल पर्थियन',
 			'Rjng' => 'रीजांग',
 			'Rohg' => 'हनीफी',
 			'Roro' => 'रोन्गोरोन्गो',
 			'Runr' => 'रूनिक',
 			'Samr' => 'समरिटान',
 			'Sara' => 'सराती',
 			'Saur' => 'सौराष्ट्र',
 			'Sgnw' => 'संकेत लिपी',
 			'Shaw' => 'शॅव्हियन',
 			'Sinh' => 'सिंहला',
 			'Sund' => 'सूदानी',
 			'Sylo' => 'सिलोती नागरी',
 			'Syrc' => 'सिरीयाक',
 			'Syre' => 'एस्त्ट्रेन्जेलो सिरियाक',
 			'Syrj' => 'पश्चिमी सिरियाक',
 			'Syrn' => 'पूर्वी सिरियाक',
 			'Tagb' => 'तगोआन्वा',
 			'Tale' => 'ताई ली',
 			'Talu' => 'नवीन ताई लू',
 			'Taml' => 'तामिळ',
 			'Tavt' => 'ताई विएत',
 			'Telu' => 'तेलगु',
 			'Teng' => 'तेन्गवार',
 			'Tfng' => 'तिफिनाघ',
 			'Tglg' => 'टागालोग',
 			'Thaa' => 'थाना',
 			'Thai' => 'थाई',
 			'Tibt' => 'तिबेटी',
 			'Ugar' => 'युगारिटिक',
 			'Vaii' => 'वाई',
 			'Visp' => 'दृश्य संवाद',
 			'Xpeo' => 'पुरातन फारसी',
 			'Xsux' => 'दृश्यमान भाषा',
 			'Yiii' => 'यी',
 			'Zinh' => 'वंशपरंपरागत',
 			'Zmth' => 'गणितीय संकेतलिपी',
 			'Zsye' => 'इमोजी',
 			'Zsym' => 'प्रतीक',
 			'Zxxx' => 'अलिखित',
 			'Zyyy' => 'सामान्य',
 			'Zzzz' => 'अज्ञात लिपी',

			);
			if ( @_ ) {
				return $scripts{$_[0]};
			}
			return \%scripts;
		}
	}
);

has 'display_name_region' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'001' => 'विश्व',
 			'002' => 'आफ्रिका',
 			'003' => 'उत्तर अमेरिका',
 			'005' => 'दक्षिण अमेरिका',
 			'009' => 'ओशनिया',
 			'011' => 'पश्चिम आफ्रिका',
 			'013' => 'मध्य अमेरिका',
 			'014' => 'पूर्व आफ्रिका',
 			'015' => 'उत्तर आफ्रिका',
 			'017' => 'मध्य आफ्रिका',
 			'018' => 'दक्षिणी आफ्रिका',
 			'019' => 'अमेरिका',
 			'021' => 'उत्तरी अमेरिका',
 			'029' => 'कॅरीबियन',
 			'030' => 'पूर्व आशिया',
 			'034' => 'दक्षिण आशिया',
 			'035' => 'दक्षिण पूर्व आशिया',
 			'039' => 'दक्षिण युरोप',
 			'053' => 'ऑस्‍ट्रेलेशिया',
 			'054' => 'मेलानेशिया',
 			'057' => 'मायक्रोनेशियन प्रदेश',
 			'061' => 'पॉलिनेशिया',
 			'142' => 'आशिया',
 			'143' => 'मध्य आशिया',
 			'145' => 'पश्चिम आशिया',
 			'150' => 'युरोप',
 			'151' => 'पूर्व युरोप',
 			'154' => 'उत्तर युरोप',
 			'155' => 'पश्चिम युरोप',
 			'202' => 'उप-सहारा आफ्रिका',
 			'419' => 'लॅटिन अमेरिका',
 			'AC' => 'अ‍ॅसेन्शियन बेट',
 			'AD' => 'अँडोरा',
 			'AE' => 'संयुक्त अरब अमीरात',
 			'AF' => 'अफगाणिस्तान',
 			'AG' => 'अँटिग्वा आणि बर्बुडा',
 			'AI' => 'अँग्विला',
 			'AL' => 'अल्बानिया',
 			'AM' => 'अर्मेनिया',
 			'AO' => 'अंगोला',
 			'AQ' => 'अंटार्क्टिका',
 			'AR' => 'अर्जेंटिना',
 			'AS' => 'अमेरिकन सामोआ',
 			'AT' => 'ऑस्ट्रिया',
 			'AU' => 'ऑस्ट्रेलिया',
 			'AW' => 'अरुबा',
 			'AX' => 'अ‍ॅलँड बेटे',
 			'AZ' => 'अझरबैजान',
 			'BA' => 'बोस्निया अणि हर्जेगोविना',
 			'BB' => 'बार्बाडोस',
 			'BD' => 'बांगलादेश',
 			'BE' => 'बेल्जियम',
 			'BF' => 'बुर्किना फासो',
 			'BG' => 'बल्गेरिया',
 			'BH' => 'बहारीन',
 			'BI' => 'बुरुंडी',
 			'BJ' => 'बेनिन',
 			'BL' => 'सेंट बार्थेलेमी',
 			'BM' => 'बर्मुडा',
 			'BN' => 'ब्रुनेई',
 			'BO' => 'बोलिव्हिया',
 			'BQ' => 'कॅरिबियन नेदरलँड्स',
 			'BR' => 'ब्राझिल',
 			'BS' => 'बहामाज',
 			'BT' => 'भूतान',
 			'BV' => 'बोउवेट बेट',
 			'BW' => 'बोट्सवाना',
 			'BY' => 'बेलारूस',
 			'BZ' => 'बेलिझे',
 			'CA' => 'कॅनडा',
 			'CC' => 'कोकोस (कीलिंग) बेटे',
 			'CD' => 'काँगो - किंशासा',
 			'CD@alt=variant' => 'काँगो (डीआरसी)',
 			'CF' => 'केंद्रीय अफ्रिकी प्रजासत्ताक',
 			'CG' => 'काँगो - ब्राझाविले',
 			'CG@alt=variant' => 'काँगो (प्रजासत्ताक)',
 			'CH' => 'स्वित्झर्लंड',
 			'CI' => 'कोत द’ईवोआर',
 			'CI@alt=variant' => 'आयव्हरी कोस्ट',
 			'CK' => 'कुक बेटे',
 			'CL' => 'चिली',
 			'CM' => 'कॅमेरून',
 			'CN' => 'चीन',
 			'CO' => 'कोलम्बिया',
 			'CP' => 'क्लिपरटोन बेट',
 			'CR' => 'कोस्टा रिका',
 			'CU' => 'क्यूबा',
 			'CV' => 'केप व्हर्डे',
 			'CW' => 'क्युरासाओ',
 			'CX' => 'ख्रिसमस बेट',
 			'CY' => 'सायप्रस',
 			'CZ' => 'झेकिया',
 			'CZ@alt=variant' => 'झेक प्रजासत्ताक',
 			'DE' => 'जर्मनी',
 			'DG' => 'दिएगो गार्सिया',
 			'DJ' => 'जिबौटी',
 			'DK' => 'डेन्मार्क',
 			'DM' => 'डोमिनिका',
 			'DO' => 'डोमिनिकन प्रजासत्ताक',
 			'DZ' => 'अल्जीरिया',
 			'EA' => 'स्यूटा आणि मेलिला',
 			'EC' => 'इक्वाडोर',
 			'EE' => 'एस्टोनिया',
 			'EG' => 'इजिप्त',
 			'EH' => 'पश्चिम सहारा',
 			'ER' => 'एरिट्रिया',
 			'ES' => 'स्पेन',
 			'ET' => 'इथिओपिया',
 			'EU' => 'युरोपीय संघ',
 			'EZ' => 'युरोझोन',
 			'FI' => 'फिनलंड',
 			'FJ' => 'फिजी',
 			'FK' => 'फॉकलंड बेटे',
 			'FK@alt=variant' => 'फॉकलंड बेटे (इस्लास मालविनास)',
 			'FM' => 'मायक्रोनेशिया',
 			'FO' => 'फेरो बेटे',
 			'FR' => 'फ्रान्स',
 			'GA' => 'गॅबॉन',
 			'GB' => 'युनायटेड किंगडम',
 			'GB@alt=short' => 'यू.के.',
 			'GD' => 'ग्रेनेडा',
 			'GE' => 'जॉर्जिया',
 			'GF' => 'फ्रेंच गयाना',
 			'GG' => 'ग्वेर्नसे',
 			'GH' => 'घाना',
 			'GI' => 'जिब्राल्टर',
 			'GL' => 'ग्रीनलंड',
 			'GM' => 'गाम्बिया',
 			'GN' => 'गिनी',
 			'GP' => 'ग्वाडेलोउपे',
 			'GQ' => 'इक्वेटोरियल गिनी',
 			'GR' => 'ग्रीस',
 			'GS' => 'दक्षिण जॉर्जिया आणि दक्षिण सँडविच बेटे',
 			'GT' => 'ग्वाटेमाला',
 			'GU' => 'गुआम',
 			'GW' => 'गिनी-बिसाउ',
 			'GY' => 'गयाना',
 			'HK' => 'हाँगकाँग एसएआर चीन',
 			'HK@alt=short' => 'हाँगकाँग',
 			'HM' => 'हर्ड आणि मॅक्डोनाल्ड बेटे',
 			'HN' => 'होंडुरास',
 			'HR' => 'क्रोएशिया',
 			'HT' => 'हैती',
 			'HU' => 'हंगेरी',
 			'IC' => 'कॅनरी बेटे',
 			'ID' => 'इंडोनेशिया',
 			'IE' => 'आयर्लंड',
 			'IL' => 'इस्त्राइल',
 			'IM' => 'आयल ऑफ मॅन',
 			'IN' => 'भारत',
 			'IO' => 'ब्रिटिश हिंद महासागर प्रदेश',
 			'IO@alt=chagos' => 'चागोस आर्चिपेलागो',
 			'IQ' => 'इराक',
 			'IR' => 'इराण',
 			'IS' => 'आइसलँड',
 			'IT' => 'इटली',
 			'JE' => 'जर्सी',
 			'JM' => 'जमैका',
 			'JO' => 'जॉर्डन',
 			'JP' => 'जपान',
 			'KE' => 'केनिया',
 			'KG' => 'किरगिझस्तान',
 			'KH' => 'कंबोडिया',
 			'KI' => 'किरीबाटी',
 			'KM' => 'कोमोरोज',
 			'KN' => 'सेंट किट्स आणि नेव्हिस',
 			'KP' => 'उत्तर कोरिया',
 			'KR' => 'दक्षिण कोरिया',
 			'KW' => 'कुवेत',
 			'KY' => 'केमन बेटे',
 			'KZ' => 'कझाकस्तान',
 			'LA' => 'लाओस',
 			'LB' => 'लेबनॉन',
 			'LC' => 'सेंट ल्यूसिया',
 			'LI' => 'लिक्टेनस्टाइन',
 			'LK' => 'श्रीलंका',
 			'LR' => 'लायबेरिया',
 			'LS' => 'लेसोथो',
 			'LT' => 'लिथुआनिया',
 			'LU' => 'लक्झेंबर्ग',
 			'LV' => 'लाटव्हिया',
 			'LY' => 'लिबिया',
 			'MA' => 'मोरोक्को',
 			'MC' => 'मोनॅको',
 			'MD' => 'मोल्डोव्हा',
 			'ME' => 'मोंटेनेग्रो',
 			'MF' => 'सेंट मार्टिन',
 			'MG' => 'मादागास्कर',
 			'MH' => 'मार्शल बेटे',
 			'MK' => 'उत्तर मॅसेडोनिया',
 			'ML' => 'माली',
 			'MM' => 'म्यानमार (बर्मा)',
 			'MN' => 'मंगोलिया',
 			'MO' => 'मकाओ एसएआर चीन',
 			'MO@alt=short' => 'मकाओ',
 			'MP' => 'उत्तरी मारियाना बेटे',
 			'MQ' => 'मार्टिनिक',
 			'MR' => 'मॉरिटानिया',
 			'MS' => 'मॉन्ट्सेराट',
 			'MT' => 'माल्टा',
 			'MU' => 'मॉरिशस',
 			'MV' => 'मालदीव',
 			'MW' => 'मलावी',
 			'MX' => 'मेक्सिको',
 			'MY' => 'मलेशिया',
 			'MZ' => 'मोझाम्बिक',
 			'NA' => 'नामिबिया',
 			'NC' => 'न्यू कॅलेडोनिया',
 			'NE' => 'नाइजर',
 			'NF' => 'नॉरफॉक बेट',
 			'NG' => 'नायजेरिया',
 			'NI' => 'निकाराग्वा',
 			'NL' => 'नेदरलँड',
 			'NO' => 'नॉर्वे',
 			'NP' => 'नेपाळ',
 			'NR' => 'नाउरू',
 			'NU' => 'नीयू',
 			'NZ' => 'न्यूझीलंड',
 			'NZ@alt=variant' => 'औटेरूआ न्यूझीलंड',
 			'OM' => 'ओमान',
 			'PA' => 'पनामा',
 			'PE' => 'पेरू',
 			'PF' => 'फ्रेंच पॉलिनेशिया',
 			'PG' => 'पापुआ न्यू गिनी',
 			'PH' => 'फिलिपिन्स',
 			'PK' => 'पाकिस्तान',
 			'PL' => 'पोलंड',
 			'PM' => 'सेंट पियरे आणि मिक्वेलोन',
 			'PN' => 'पिटकैर्न बेटे',
 			'PR' => 'प्युएर्तो रिको',
 			'PS' => 'पॅलेस्टिनियन प्रदेश',
 			'PS@alt=short' => 'पॅलेस्टाईन',
 			'PT' => 'पोर्तुगाल',
 			'PW' => 'पलाऊ',
 			'PY' => 'पराग्वे',
 			'QA' => 'कतार',
 			'QO' => 'आउटलाईंग ओशनिया',
 			'RE' => 'रियुनियन',
 			'RO' => 'रोमानिया',
 			'RS' => 'सर्बिया',
 			'RU' => 'रशिया',
 			'RW' => 'रवांडा',
 			'SA' => 'सौदी अरब',
 			'SB' => 'सोलोमन बेटे',
 			'SC' => 'सेशेल्स',
 			'SD' => 'सुदान',
 			'SE' => 'स्वीडन',
 			'SG' => 'सिंगापूर',
 			'SH' => 'सेंट हेलेना',
 			'SI' => 'स्लोव्हेनिया',
 			'SJ' => 'स्वालबर्ड आणि जान मायेन',
 			'SK' => 'स्लोव्हाकिया',
 			'SL' => 'सिएरा लिओन',
 			'SM' => 'सॅन मरीनो',
 			'SN' => 'सेनेगल',
 			'SO' => 'सोमालिया',
 			'SR' => 'सुरिनाम',
 			'SS' => 'दक्षिण सुदान',
 			'ST' => 'साओ टोम आणि प्रिंसिपे',
 			'SV' => 'अल साल्वाडोर',
 			'SX' => 'सिंट मार्टेन',
 			'SY' => 'सीरिया',
 			'SZ' => 'इस्वातिनी',
 			'SZ@alt=variant' => 'स्वाझिलँड',
 			'TA' => 'ट्रिस्टन दा कुन्हा',
 			'TC' => 'टर्क्स आणि कैकोस बेटे',
 			'TD' => 'चाड',
 			'TF' => 'फ्रेंच दाक्षिणात्य प्रदेश',
 			'TG' => 'टोगो',
 			'TH' => 'थायलंड',
 			'TJ' => 'ताजिकिस्तान',
 			'TK' => 'तोकेलाउ',
 			'TL' => 'तिमोर-लेस्ते',
 			'TL@alt=variant' => 'पूर्व तिमोर',
 			'TM' => 'तुर्कमेनिस्तान',
 			'TN' => 'ट्यूनिशिया',
 			'TO' => 'टोंगा',
 			'TR' => 'तुर्किये',
 			'TT' => 'त्रिनिदाद आणि टोबॅगो',
 			'TV' => 'टुवालु',
 			'TW' => 'तैवान',
 			'TZ' => 'टांझानिया',
 			'UA' => 'युक्रेन',
 			'UG' => 'युगांडा',
 			'UM' => 'यू.एस. आउटलाइंग बेटे',
 			'UN' => 'संयुक्त राष्ट्र',
 			'UN@alt=short' => 'यूएन',
 			'US' => 'युनायटेड स्टेट्स',
 			'US@alt=short' => 'यू.एस.',
 			'UY' => 'उरुग्वे',
 			'UZ' => 'उझबेकिस्तान',
 			'VA' => 'व्हॅटिकन सिटी',
 			'VC' => 'सेंट व्हिन्सेंट आणि ग्रेनडाइन्स',
 			'VE' => 'व्हेनेझुएला',
 			'VG' => 'ब्रिटिश व्हर्जिन बेटे',
 			'VI' => 'यू.एस. व्हर्जिन बेटे',
 			'VN' => 'व्हिएतनाम',
 			'VU' => 'वानुआतु',
 			'WF' => 'वालिस आणि फ्यूचूना',
 			'WS' => 'सामोआ',
 			'XA' => 'नकली-उच्चारणे',
 			'XB' => 'नकली-बीडी',
 			'XK' => 'कोसोव्हो',
 			'YE' => 'येमेन',
 			'YT' => 'मायोट्टे',
 			'ZA' => 'दक्षिण आफ्रिका',
 			'ZM' => 'झाम्बिया',
 			'ZW' => 'झिम्बाब्वे',
 			'ZZ' => 'अज्ञात प्रदेश',

		}
	},
);

has 'display_name_variant' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'PINYIN' => 'पिनयिन रोमनायझेशन',
 			'WADEGILE' => 'वादे-गिलेस रोमनायझेशन',

		}
	},
);

has 'display_name_key' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'calendar' => 'दिनदर्शिका',
 			'cf' => 'चलन स्वरुप',
 			'colalternate' => 'प्रतीक क्रमवारीकडे दुर्लक्ष करा',
 			'colbackwards' => 'उलट उच्चार क्रमवारी',
 			'colcasefirst' => 'अपरकेस/लोअरकेस क्रम',
 			'colcaselevel' => 'केस संवेदी क्रमवारी',
 			'collation' => 'क्रमवारी क्रम',
 			'colnormalization' => 'सामान्य क्रमवारी',
 			'colnumeric' => 'अंकीय क्रमवारी',
 			'colstrength' => 'क्रमवारी सामर्थ्य',
 			'currency' => 'चलन',
 			'hc' => 'तास चक्र (12 वि 24)',
 			'lb' => 'लाइन ब्रेक शैली',
 			'ms' => 'मापन पद्धती',
 			'numbers' => 'संख्या',
 			'timezone' => 'टाइम झोन',
 			'va' => 'लोकेल व्हेरियंट',
 			'x' => 'खासगी-वापर',

		}
	},
);

has 'display_name_type' => (
	is			=> 'ro',
	isa			=> HashRef[HashRef[Str]],
	init_arg	=> undef,
	default		=> sub {
		{
			'calendar' => {
 				'buddhist' => q{बौद्ध दिनदर्शिका},
 				'chinese' => q{चीनी दिनदर्शिका},
 				'coptic' => q{कॉप्टिक दिनदर्शिका},
 				'dangi' => q{डांगी दिनदर्शिका},
 				'ethiopic' => q{इथिओपिक दिनदर्शिका},
 				'ethiopic-amete-alem' => q{इथियोपिक अमेते अलेम दिनदर्शिका},
 				'gregorian' => q{ग्रेगोरियन दिनदर्शिका},
 				'hebrew' => q{यहूदी दिनदर्शिका},
 				'indian' => q{भारतीय राष्ट्रीय दिनदर्शिका},
 				'islamic' => q{हिजरी दिनदर्शिका},
 				'islamic-civil' => q{हिजरी दिनदर्शिका (टॅब्युलर, सिव्हील ईपॉक्)},
 				'islamic-umalqura' => q{हिजरी दिनदर्शिका (उम-अल-कुरा)},
 				'iso8601' => q{(ISO-8601) दिनदर्शिका},
 				'japanese' => q{जपानी दिनदर्शिका},
 				'persian' => q{फारसी दिनदर्शिका},
 				'roc' => q{मिनगुओ दिनदर्शिका},
 			},
 			'cf' => {
 				'account' => q{अकाउंटिंग चलन स्वरूप},
 				'standard' => q{प्रमाणित चलन स्वरुप},
 			},
 			'colalternate' => {
 				'non-ignorable' => q{प्रतीकांची क्रमवारी लावा},
 				'shifted' => q{दुर्लक्षित प्रतीकांची क्रमवारी लावा},
 			},
 			'colbackwards' => {
 				'no' => q{सामान्यपणे उच्चार क्रमवारी करा},
 				'yes' => q{उलट उच्चार क्रमवारी लावा},
 			},
 			'colcasefirst' => {
 				'lower' => q{प्रथम लोअरकेस क्रमवारी लावा},
 				'no' => q{सामान्य केस क्रमाची क्रमवारी लावा},
 				'upper' => q{प्रथम अपरकेस क्रमवारी लावा},
 			},
 			'colcaselevel' => {
 				'no' => q{केस संवेदी क्रमवारी लावा},
 				'yes' => q{केस संवेदी क्रमवारी लावा},
 			},
 			'collation' => {
 				'big5han' => q{पारंपारिक चिनी क्रमवारी क्रम - Big5},
 				'compat' => q{अनुकूलतेसाठी आधीची क्रमवारी},
 				'dictionary' => q{शब्दकोश अनुक्रम},
 				'ducet' => q{डीफॉल्ट युनिकोड क्रमवारी क्रम},
 				'eor' => q{युरोपियन क्रमवारी नियम},
 				'gb2312han' => q{सरलीकृत चिनी क्रमवारी क्रम - GB2312},
 				'phonebook' => q{फोनबुक अनुक्रम},
 				'phonetic' => q{ध्वनीविचार क्रमवारी क्रम},
 				'pinyin' => q{पिनयिन अनुक्रम},
 				'reformed' => q{पुनर्स्वरूपित अनुक्रम},
 				'search' => q{सामान्य हेतु शोध},
 				'searchjl' => q{हँगुल प्रारंभिक व्यंजनानुसार शोधा},
 				'standard' => q{प्रमाणित क्रमवारी क्रम},
 				'stroke' => q{स्ट्रोक अनुक्रम},
 				'traditional' => q{पारंपारिक अनुक्रम},
 				'unihan' => q{रॅडिकल-स्ट्रोक अनुक्रम},
 			},
 			'colnormalization' => {
 				'no' => q{नेहमीसारखे न करता क्रमवारी लावा},
 				'yes' => q{युनिकोड सामान्यीकृत क्रमवारी लावा},
 			},
 			'colnumeric' => {
 				'no' => q{अंकांची वैयक्तिकरित्या क्रमवारी लावा},
 				'yes' => q{अंकांची संख्‍याक्रमानुसार क्रमवारी लावा},
 			},
 			'colstrength' => {
 				'identical' => q{सर्व क्रमवारी लावा},
 				'primary' => q{केवळ मूळ अक्षरांची क्रमवारी लावा},
 				'quaternary' => q{उच्चार/केस/रुंदी/काना क्रमवारी लावा},
 				'secondary' => q{उच्चार क्रमवारी लावा},
 				'tertiary' => q{उच्चार/केस/रुंदीची क्रमवारी लावा},
 			},
 			'd0' => {
 				'fwidth' => q{पूर्णरुंदी},
 				'hwidth' => q{अर्धीरुंदी},
 				'npinyin' => q{अंकीय},
 			},
 			'hc' => {
 				'h11' => q{12 तास पद्धती (0–11)},
 				'h12' => q{12 तास पद्धती (1–12)},
 				'h23' => q{24 तास पद्धती (0–23)},
 				'h24' => q{24 तास पद्धती (1–24)},
 			},
 			'lb' => {
 				'loose' => q{ढिली लाइन ब्रेक शैली},
 				'normal' => q{सामान्य लाइन ब्रेक शैली},
 				'strict' => q{काटेकोर लाइन ब्रेक},
 			},
 			'm0' => {
 				'bgn' => q{यूएस बीजीएन लिप्यंतरण},
 				'ungegn' => q{यूएन जीईजीएन लिप्यंतरण},
 			},
 			'ms' => {
 				'metric' => q{दशमान पद्धती},
 				'uksystem' => q{ब्रिटिश मापन पद्धती},
 				'ussystem' => q{अमेरिकन मापन पद्धती},
 			},
 			'numbers' => {
 				'arab' => q{अरबी-भारतीय अंक},
 				'arabext' => q{विस्तारित अरबी-भारतीय अंक},
 				'armn' => q{अर्मेनियन अंक},
 				'armnlow' => q{अर्मेनियन छोटी लिपी अंक},
 				'beng' => q{बंगाली अंक},
 				'cakm' => q{चकमा अंक},
 				'deva' => q{देवनागरी अंक},
 				'ethi' => q{इथिओपिक अंक},
 				'finance' => q{वित्तीय संख्‍या},
 				'fullwide' => q{पूर्ण रुंदीचे अंक},
 				'geor' => q{जॉर्जियन अंक},
 				'grek' => q{ग्रीक अंक},
 				'greklow' => q{ग्रीक लहान लिपीचे अंक},
 				'gujr' => q{गुजराती अंक},
 				'guru' => q{गुरमुखी अंक},
 				'hanidec' => q{चीनी दशांश अंक},
 				'hans' => q{सरलीकृत चीनी अंक},
 				'hansfin' => q{सरलीकृत चीनी वित्तीय अंक},
 				'hant' => q{पारंपारिक चीनी अंक},
 				'hantfin' => q{पारंपारिक चीनी वित्तीय अंक},
 				'hebr' => q{हिब्रू अंक},
 				'java' => q{जावानीज अंक},
 				'jpan' => q{जपानी अंक},
 				'jpanfin' => q{जपानी वित्तीय अंक},
 				'khmr' => q{ख्मेर अंक},
 				'knda' => q{कन्नड अंक},
 				'laoo' => q{लाओ अंक},
 				'latn' => q{पश्चिमी अंक},
 				'mlym' => q{मल्याळम अंक},
 				'mong' => q{मंगोलियन अंक},
 				'mtei' => q{मीतेई मायेक अंक},
 				'mymr' => q{म्यानमार अंक},
 				'native' => q{मूळ अंक},
 				'olck' => q{ओलचिकी अंक},
 				'orya' => q{उडिया अंक},
 				'roman' => q{रोमन अंक},
 				'romanlow' => q{रोमन लहान लिपीचे अंक},
 				'taml' => q{पारंपारिक तामिळ अंक},
 				'tamldec' => q{तामिळ अंक},
 				'telu' => q{तेलगु अंक},
 				'thai' => q{थाई अंक},
 				'tibt' => q{तिबेटी अंक},
 				'traditional' => q{पारंपारिक संख्‍या},
 				'vaii' => q{व्हाई अंक},
 			},

		}
	},
);

has 'display_name_measurement_system' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'metric' => q{मेट्रिक},
 			'UK' => q{यूके},
 			'US' => q{यूएस},

		}
	},
);

has 'display_name_code_patterns' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'language' => 'भाषा: {0}',
 			'script' => 'लिपी: {0}',
 			'region' => 'प्रदेश: {0}',

		}
	},
);

has 'characters' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> $^V ge v5.18.0
	? eval <<'EOT'
	sub {
		no warnings 'experimental::regex_sets';
		return {
			auxiliary => qr{[‌‍ ॄ]},
			index => ['\u200D', 'ॐ', 'ं', 'ः', 'अ', 'आ', 'इ', 'ई', 'उ', 'ऊ', 'ऋ', 'ऌ', 'ए', 'ऐ', 'ऑ', 'ओ', 'औ', 'क', 'ख', 'ग', 'घ', 'ङ', 'च', 'छ', 'ज', 'झ', 'ञ', 'ट', 'ठ', 'ड', 'ढ', 'ण', 'त', 'थ', 'द', 'ध', 'न', 'प', 'फ', 'ब', 'भ', 'म', 'य', 'र', 'ल', 'व', 'श', 'ष', 'स', 'ह', 'ळ', 'ऽ', 'ॅ', '्'],
			main => qr{[़ ॐ ं ँ ः अ आ इ ई उ ऊ ऋ ऌ ऍ ए ऐ ऑ ओ औ क ख ग घ ङ च छ ज झ ञ ट ठ ड ढ ण त थ द ध न प फ ब भ म य रऱ ल व श ष स ह ळ ऽ ा ि ी ु ू ृ ॅ े ै ॉ ो ौ ्]},
			numbers => qr{[\- ‑ , . % ‰ + 0० 1१ 2२ 3३ 4४ 5५ 6६ 7७ 8८ 9९]},
			punctuation => qr{[\- ‐‑ – — , ; \: ! ? . … '‘’ "“” ( ) \[ \] @ * / \& # ′ ″]},
		};
	},
EOT
: sub {
		return { index => ['\u200D', 'ॐ', 'ं', 'ः', 'अ', 'आ', 'इ', 'ई', 'उ', 'ऊ', 'ऋ', 'ऌ', 'ए', 'ऐ', 'ऑ', 'ओ', 'औ', 'क', 'ख', 'ग', 'घ', 'ङ', 'च', 'छ', 'ज', 'झ', 'ञ', 'ट', 'ठ', 'ड', 'ढ', 'ण', 'त', 'थ', 'द', 'ध', 'न', 'प', 'फ', 'ब', 'भ', 'म', 'य', 'र', 'ल', 'व', 'श', 'ष', 'स', 'ह', 'ळ', 'ऽ', 'ॅ', '्'], };
},
);


has 'units' => (
	is			=> 'ro',
	isa			=> HashRef[HashRef[HashRef[Str]]],
	init_arg	=> undef,
	default		=> sub { {
				'long' => {
					# Long Unit Identifier
					'' => {
						'name' => q(मुख्य दिशा),
					},
					# Core Unit Identifier
					'' => {
						'name' => q(मुख्य दिशा),
					},
					# Long Unit Identifier
					'1024p1' => {
						'1' => q(kibi{0}),
					},
					# Core Unit Identifier
					'1024p1' => {
						'1' => q(kibi{0}),
					},
					# Long Unit Identifier
					'1024p2' => {
						'1' => q(mebi{0}),
					},
					# Core Unit Identifier
					'1024p2' => {
						'1' => q(mebi{0}),
					},
					# Long Unit Identifier
					'1024p3' => {
						'1' => q(gibi{0}),
					},
					# Core Unit Identifier
					'1024p3' => {
						'1' => q(gibi{0}),
					},
					# Long Unit Identifier
					'1024p4' => {
						'1' => q(tebi{0}),
					},
					# Core Unit Identifier
					'1024p4' => {
						'1' => q(tebi{0}),
					},
					# Long Unit Identifier
					'1024p5' => {
						'1' => q(pebi{0}),
					},
					# Core Unit Identifier
					'1024p5' => {
						'1' => q(pebi{0}),
					},
					# Long Unit Identifier
					'1024p6' => {
						'1' => q(exbi{0}),
					},
					# Core Unit Identifier
					'1024p6' => {
						'1' => q(exbi{0}),
					},
					# Long Unit Identifier
					'1024p7' => {
						'1' => q(zebi{0}),
					},
					# Core Unit Identifier
					'1024p7' => {
						'1' => q(zebi{0}),
					},
					# Long Unit Identifier
					'1024p8' => {
						'1' => q(yobe{0}),
					},
					# Core Unit Identifier
					'1024p8' => {
						'1' => q(yobe{0}),
					},
					# Long Unit Identifier
					'10p-1' => {
						'1' => q(डेसी{0}),
					},
					# Core Unit Identifier
					'1' => {
						'1' => q(डेसी{0}),
					},
					# Long Unit Identifier
					'10p-12' => {
						'1' => q(पिको{0}),
					},
					# Core Unit Identifier
					'12' => {
						'1' => q(पिको{0}),
					},
					# Long Unit Identifier
					'10p-15' => {
						'1' => q(फेमिटो{0}),
					},
					# Core Unit Identifier
					'15' => {
						'1' => q(फेमिटो{0}),
					},
					# Long Unit Identifier
					'10p-18' => {
						'1' => q(अ‍ॅटॉ{0}),
					},
					# Core Unit Identifier
					'18' => {
						'1' => q(अ‍ॅटॉ{0}),
					},
					# Long Unit Identifier
					'10p-2' => {
						'1' => q(सेंटी{0}),
					},
					# Core Unit Identifier
					'2' => {
						'1' => q(सेंटी{0}),
					},
					# Long Unit Identifier
					'10p-21' => {
						'1' => q(झेपटो{0}),
					},
					# Core Unit Identifier
					'21' => {
						'1' => q(झेपटो{0}),
					},
					# Long Unit Identifier
					'10p-24' => {
						'1' => q(योक्टो{0}),
					},
					# Core Unit Identifier
					'24' => {
						'1' => q(योक्टो{0}),
					},
					# Long Unit Identifier
					'10p-27' => {
						'1' => q(रोंटो{0}),
					},
					# Core Unit Identifier
					'27' => {
						'1' => q(रोंटो{0}),
					},
					# Long Unit Identifier
					'10p-3' => {
						'1' => q(मिलि{0}),
					},
					# Core Unit Identifier
					'3' => {
						'1' => q(मिलि{0}),
					},
					# Long Unit Identifier
					'10p-30' => {
						'1' => q(क्वेक्टो{0}),
					},
					# Core Unit Identifier
					'30' => {
						'1' => q(क्वेक्टो{0}),
					},
					# Long Unit Identifier
					'10p-6' => {
						'1' => q(मायक्रो{0}),
					},
					# Core Unit Identifier
					'6' => {
						'1' => q(मायक्रो{0}),
					},
					# Long Unit Identifier
					'10p-9' => {
						'1' => q(नॅनो{0}),
					},
					# Core Unit Identifier
					'9' => {
						'1' => q(नॅनो{0}),
					},
					# Long Unit Identifier
					'10p1' => {
						'1' => q(डेका{0}),
					},
					# Core Unit Identifier
					'10p1' => {
						'1' => q(डेका{0}),
					},
					# Long Unit Identifier
					'10p12' => {
						'1' => q(टेरा{0}),
					},
					# Core Unit Identifier
					'10p12' => {
						'1' => q(टेरा{0}),
					},
					# Long Unit Identifier
					'10p15' => {
						'1' => q(पेटा{0}),
					},
					# Core Unit Identifier
					'10p15' => {
						'1' => q(पेटा{0}),
					},
					# Long Unit Identifier
					'10p18' => {
						'1' => q(एक्सा{0}),
					},
					# Core Unit Identifier
					'10p18' => {
						'1' => q(एक्सा{0}),
					},
					# Long Unit Identifier
					'10p2' => {
						'1' => q(हेक्टो{0}),
					},
					# Core Unit Identifier
					'10p2' => {
						'1' => q(हेक्टो{0}),
					},
					# Long Unit Identifier
					'10p21' => {
						'1' => q(झेट{0}),
					},
					# Core Unit Identifier
					'10p21' => {
						'1' => q(झेट{0}),
					},
					# Long Unit Identifier
					'10p24' => {
						'1' => q(योटा{0}),
					},
					# Core Unit Identifier
					'10p24' => {
						'1' => q(योटा{0}),
					},
					# Long Unit Identifier
					'10p27' => {
						'1' => q(रोंना{0}),
					},
					# Core Unit Identifier
					'10p27' => {
						'1' => q(रोंना{0}),
					},
					# Long Unit Identifier
					'10p3' => {
						'1' => q(किलो{0}),
					},
					# Core Unit Identifier
					'10p3' => {
						'1' => q(किलो{0}),
					},
					# Long Unit Identifier
					'10p30' => {
						'1' => q(क्वेटा{0}),
					},
					# Core Unit Identifier
					'10p30' => {
						'1' => q(क्वेटा{0}),
					},
					# Long Unit Identifier
					'10p6' => {
						'1' => q(मेगा{0}),
					},
					# Core Unit Identifier
					'10p6' => {
						'1' => q(मेगा{0}),
					},
					# Long Unit Identifier
					'10p9' => {
						'1' => q(गीगा{0}),
					},
					# Core Unit Identifier
					'10p9' => {
						'1' => q(गीगा{0}),
					},
					# Long Unit Identifier
					'acceleration-g-force' => {
						'1' => q(masculine),
						'one' => q({0} जी-फोर्स),
						'other' => q({0} जी-फोर्स),
					},
					# Core Unit Identifier
					'g-force' => {
						'1' => q(masculine),
						'one' => q({0} जी-फोर्स),
						'other' => q({0} जी-फोर्स),
					},
					# Long Unit Identifier
					'acceleration-meter-per-square-second' => {
						'1' => q(neuter),
						'name' => q(मीटर प्रति सेकंद चौरस),
						'one' => q({0} मीटर प्रति सेकंद चौरस),
						'other' => q({0} मीटर प्रति सेकंद चौरस),
					},
					# Core Unit Identifier
					'meter-per-square-second' => {
						'1' => q(neuter),
						'name' => q(मीटर प्रति सेकंद चौरस),
						'one' => q({0} मीटर प्रति सेकंद चौरस),
						'other' => q({0} मीटर प्रति सेकंद चौरस),
					},
					# Long Unit Identifier
					'angle-arc-minute' => {
						'1' => q(masculine),
						'name' => q(आर्कमिनिटे),
						'one' => q({0} आर्कमिनिट),
						'other' => q({0} आर्कमिनिटे),
					},
					# Core Unit Identifier
					'arc-minute' => {
						'1' => q(masculine),
						'name' => q(आर्कमिनिटे),
						'one' => q({0} आर्कमिनिट),
						'other' => q({0} आर्कमिनिटे),
					},
					# Long Unit Identifier
					'angle-arc-second' => {
						'1' => q(masculine),
						'name' => q(आर्कसेकंद),
						'one' => q({0} आर्कसेकंद),
						'other' => q({0} आर्कसेकंद),
					},
					# Core Unit Identifier
					'arc-second' => {
						'1' => q(masculine),
						'name' => q(आर्कसेकंद),
						'one' => q({0} आर्कसेकंद),
						'other' => q({0} आर्कसेकंद),
					},
					# Long Unit Identifier
					'angle-degree' => {
						'1' => q(masculine),
						'one' => q({0} अंश),
						'other' => q({0} अंश),
					},
					# Core Unit Identifier
					'degree' => {
						'1' => q(masculine),
						'one' => q({0} अंश),
						'other' => q({0} अंश),
					},
					# Long Unit Identifier
					'angle-radian' => {
						'1' => q(feminine),
						'one' => q({0} रेडियन),
						'other' => q({0} रेडियन),
					},
					# Core Unit Identifier
					'radian' => {
						'1' => q(feminine),
						'one' => q({0} रेडियन),
						'other' => q({0} रेडियन),
					},
					# Long Unit Identifier
					'angle-revolution' => {
						'1' => q(neuter),
						'name' => q(परिभ्रमण),
						'one' => q({0} परिभ्रमण),
						'other' => q({0} परिभ्रमणे),
					},
					# Core Unit Identifier
					'revolution' => {
						'1' => q(neuter),
						'name' => q(परिभ्रमण),
						'one' => q({0} परिभ्रमण),
						'other' => q({0} परिभ्रमणे),
					},
					# Long Unit Identifier
					'area-hectare' => {
						'1' => q(masculine),
						'one' => q({0} हेक्टर),
						'other' => q({0} हेक्टर),
					},
					# Core Unit Identifier
					'hectare' => {
						'1' => q(masculine),
						'one' => q({0} हेक्टर),
						'other' => q({0} हेक्टर),
					},
					# Long Unit Identifier
					'area-square-centimeter' => {
						'1' => q(neuter),
						'name' => q(चौरस सेंटीमीटर),
						'one' => q({0} चौरस सेंटीमीटर),
						'other' => q({0} चौरस सेंटीमीटर),
						'per' => q({0} दर चौरस सेंटीमीटर),
					},
					# Core Unit Identifier
					'square-centimeter' => {
						'1' => q(neuter),
						'name' => q(चौरस सेंटीमीटर),
						'one' => q({0} चौरस सेंटीमीटर),
						'other' => q({0} चौरस सेंटीमीटर),
						'per' => q({0} दर चौरस सेंटीमीटर),
					},
					# Long Unit Identifier
					'area-square-foot' => {
						'one' => q({0} चौरस फूट),
						'other' => q({0} चौरस फूट),
					},
					# Core Unit Identifier
					'square-foot' => {
						'one' => q({0} चौरस फूट),
						'other' => q({0} चौरस फूट),
					},
					# Long Unit Identifier
					'area-square-inch' => {
						'name' => q(चौरस इंच),
						'one' => q({0} चौरस इंच),
						'other' => q({0} चौरस इंच),
						'per' => q({0} दर चौरस इंच),
					},
					# Core Unit Identifier
					'square-inch' => {
						'name' => q(चौरस इंच),
						'one' => q({0} चौरस इंच),
						'other' => q({0} चौरस इंच),
						'per' => q({0} दर चौरस इंच),
					},
					# Long Unit Identifier
					'area-square-kilometer' => {
						'1' => q(neuter),
						'name' => q(चौरस किलोमीटर),
						'one' => q({0} चौरस किलोमीटर),
						'other' => q({0} चौरस किलोमीटर),
						'per' => q({0} पर चौरस किलोमीटर),
					},
					# Core Unit Identifier
					'square-kilometer' => {
						'1' => q(neuter),
						'name' => q(चौरस किलोमीटर),
						'one' => q({0} चौरस किलोमीटर),
						'other' => q({0} चौरस किलोमीटर),
						'per' => q({0} पर चौरस किलोमीटर),
					},
					# Long Unit Identifier
					'area-square-meter' => {
						'1' => q(neuter),
						'name' => q(चौरस मीटर),
						'one' => q({0} चौरस मीटर),
						'other' => q({0} चौरस मीटर),
						'per' => q({0} दर चौरस मीटर),
					},
					# Core Unit Identifier
					'square-meter' => {
						'1' => q(neuter),
						'name' => q(चौरस मीटर),
						'one' => q({0} चौरस मीटर),
						'other' => q({0} चौरस मीटर),
						'per' => q({0} दर चौरस मीटर),
					},
					# Long Unit Identifier
					'area-square-mile' => {
						'one' => q({0} चौरस मैल),
						'other' => q({0} चौरस मैल),
						'per' => q({0} पर चौरस मैल),
					},
					# Core Unit Identifier
					'square-mile' => {
						'one' => q({0} चौरस मैल),
						'other' => q({0} चौरस मैल),
						'per' => q({0} पर चौरस मैल),
					},
					# Long Unit Identifier
					'area-square-yard' => {
						'name' => q(वर्ग यार्ड),
						'one' => q({0} वर्ग यार्ड),
						'other' => q({0} वर्ग यार्ड),
					},
					# Core Unit Identifier
					'square-yard' => {
						'name' => q(वर्ग यार्ड),
						'one' => q({0} वर्ग यार्ड),
						'other' => q({0} वर्ग यार्ड),
					},
					# Long Unit Identifier
					'concentr-item' => {
						'1' => q(masculine),
						'one' => q({0} आयटम),
						'other' => q({0} आयटम),
					},
					# Core Unit Identifier
					'item' => {
						'1' => q(masculine),
						'one' => q({0} आयटम),
						'other' => q({0} आयटम),
					},
					# Long Unit Identifier
					'concentr-karat' => {
						'1' => q(neuter),
						'one' => q({0} कॅरेट),
						'other' => q({0} कॅरेट्स),
					},
					# Core Unit Identifier
					'karat' => {
						'1' => q(neuter),
						'one' => q({0} कॅरेट),
						'other' => q({0} कॅरेट्स),
					},
					# Long Unit Identifier
					'concentr-milligram-ofglucose-per-deciliter' => {
						'name' => q(मिलीग्रामस् पर डेसीलिटर),
						'one' => q({0} मिलीग्राम पर डेसीलिटर),
						'other' => q({0} मिलीग्रामस् पर डेसीलिटर),
					},
					# Core Unit Identifier
					'milligram-ofglucose-per-deciliter' => {
						'name' => q(मिलीग्रामस् पर डेसीलिटर),
						'one' => q({0} मिलीग्राम पर डेसीलिटर),
						'other' => q({0} मिलीग्रामस् पर डेसीलिटर),
					},
					# Long Unit Identifier
					'concentr-millimole-per-liter' => {
						'1' => q(neuter),
						'name' => q(मिलीमोलस् पर लिटर),
						'one' => q({0} मिलीमोल पर लिटर),
						'other' => q({0} मिलीमोलस् पर लिटर),
					},
					# Core Unit Identifier
					'millimole-per-liter' => {
						'1' => q(neuter),
						'name' => q(मिलीमोलस् पर लिटर),
						'one' => q({0} मिलीमोल पर लिटर),
						'other' => q({0} मिलीमोलस् पर लिटर),
					},
					# Long Unit Identifier
					'concentr-mole' => {
						'1' => q(masculine),
						'one' => q({0} मोल),
						'other' => q({0} मोल),
					},
					# Core Unit Identifier
					'mole' => {
						'1' => q(masculine),
						'one' => q({0} मोल),
						'other' => q({0} मोल),
					},
					# Long Unit Identifier
					'concentr-percent' => {
						'1' => q(neuter),
						'one' => q({0} टक्के),
						'other' => q({0} टक्के),
					},
					# Core Unit Identifier
					'percent' => {
						'1' => q(neuter),
						'one' => q({0} टक्के),
						'other' => q({0} टक्के),
					},
					# Long Unit Identifier
					'concentr-permille' => {
						'1' => q(masculine),
						'one' => q({0} प्रतिमैल),
						'other' => q({0} प्रतिमैल),
					},
					# Core Unit Identifier
					'permille' => {
						'1' => q(masculine),
						'one' => q({0} प्रतिमैल),
						'other' => q({0} प्रतिमैल),
					},
					# Long Unit Identifier
					'concentr-permillion' => {
						'1' => q(neuter),
						'name' => q(भाग प्रति दशलक्ष),
						'one' => q({0} भाग प्रति दशलक्ष),
						'other' => q({0} भाग प्रति दशलक्ष),
					},
					# Core Unit Identifier
					'permillion' => {
						'1' => q(neuter),
						'name' => q(भाग प्रति दशलक्ष),
						'one' => q({0} भाग प्रति दशलक्ष),
						'other' => q({0} भाग प्रति दशलक्ष),
					},
					# Long Unit Identifier
					'concentr-permyriad' => {
						'1' => q(masculine),
						'one' => q({0} पर्मिरेड),
						'other' => q({0} पर्मिरेड),
					},
					# Core Unit Identifier
					'permyriad' => {
						'1' => q(masculine),
						'one' => q({0} पर्मिरेड),
						'other' => q({0} पर्मिरेड),
					},
					# Long Unit Identifier
					'consumption-liter-per-100-kilometer' => {
						'1' => q(neuter),
						'name' => q(लीटर प्रति 100 किलोमीटर),
						'one' => q({0} लीटर प्रति 100 किलोमीटर),
						'other' => q({0} लीटर प्रति 100 किलोमीटर),
					},
					# Core Unit Identifier
					'liter-per-100-kilometer' => {
						'1' => q(neuter),
						'name' => q(लीटर प्रति 100 किलोमीटर),
						'one' => q({0} लीटर प्रति 100 किलोमीटर),
						'other' => q({0} लीटर प्रति 100 किलोमीटर),
					},
					# Long Unit Identifier
					'consumption-liter-per-kilometer' => {
						'1' => q(neuter),
						'name' => q(लीटर प्रति किलोमीटर),
						'one' => q({0} लीटर प्रति किलोमीटर),
						'other' => q({0} लीटर प्रति किलोमीटर),
					},
					# Core Unit Identifier
					'liter-per-kilometer' => {
						'1' => q(neuter),
						'name' => q(लीटर प्रति किलोमीटर),
						'one' => q({0} लीटर प्रति किलोमीटर),
						'other' => q({0} लीटर प्रति किलोमीटर),
					},
					# Long Unit Identifier
					'consumption-mile-per-gallon' => {
						'name' => q(मैल प्रति गॅलन),
						'one' => q({0} मैल प्रति गॅलन),
						'other' => q({0} मैल प्रति गॅलन),
					},
					# Core Unit Identifier
					'mile-per-gallon' => {
						'name' => q(मैल प्रति गॅलन),
						'one' => q({0} मैल प्रति गॅलन),
						'other' => q({0} मैल प्रति गॅलन),
					},
					# Long Unit Identifier
					'consumption-mile-per-gallon-imperial' => {
						'name' => q(मैल प्रति इम्पिरिअल गॅलन),
						'one' => q({0} मैल प्रति इम्पि गॅलन),
						'other' => q({0} मैल प्रति इम्पि गॅलन),
					},
					# Core Unit Identifier
					'mile-per-gallon-imperial' => {
						'name' => q(मैल प्रति इम्पिरिअल गॅलन),
						'one' => q({0} मैल प्रति इम्पि गॅलन),
						'other' => q({0} मैल प्रति इम्पि गॅलन),
					},
					# Long Unit Identifier
					'coordinate' => {
						'east' => q({0} पूर्व),
						'north' => q({0} उत्तर),
						'south' => q({0} दक्षिण),
						'west' => q({0} पश्चिम),
					},
					# Core Unit Identifier
					'coordinate' => {
						'east' => q({0} पूर्व),
						'north' => q({0} उत्तर),
						'south' => q({0} दक्षिण),
						'west' => q({0} पश्चिम),
					},
					# Long Unit Identifier
					'digital-bit' => {
						'1' => q(masculine),
						'one' => q({0} बिट),
						'other' => q({0} बिट),
					},
					# Core Unit Identifier
					'bit' => {
						'1' => q(masculine),
						'one' => q({0} बिट),
						'other' => q({0} बिट),
					},
					# Long Unit Identifier
					'digital-byte' => {
						'1' => q(neuter),
						'one' => q({0} बाइट),
						'other' => q({0} बाइट),
					},
					# Core Unit Identifier
					'byte' => {
						'1' => q(neuter),
						'one' => q({0} बाइट),
						'other' => q({0} बाइट),
					},
					# Long Unit Identifier
					'digital-gigabit' => {
						'1' => q(masculine),
						'name' => q(गिगाबिट),
						'one' => q({0} गिगाबिट),
						'other' => q({0} गिगाबिट),
					},
					# Core Unit Identifier
					'gigabit' => {
						'1' => q(masculine),
						'name' => q(गिगाबिट),
						'one' => q({0} गिगाबिट),
						'other' => q({0} गिगाबिट),
					},
					# Long Unit Identifier
					'digital-gigabyte' => {
						'1' => q(masculine),
						'name' => q(गिगाबाइट),
						'one' => q({0} गिगाबाइट),
						'other' => q({0} गिगाबाइट),
					},
					# Core Unit Identifier
					'gigabyte' => {
						'1' => q(masculine),
						'name' => q(गिगाबाइट),
						'one' => q({0} गिगाबाइट),
						'other' => q({0} गिगाबाइट),
					},
					# Long Unit Identifier
					'digital-kilobit' => {
						'1' => q(masculine),
						'name' => q(किलोबिट),
						'one' => q({0} किलोबिट),
						'other' => q({0} किलोबिट),
					},
					# Core Unit Identifier
					'kilobit' => {
						'1' => q(masculine),
						'name' => q(किलोबिट),
						'one' => q({0} किलोबिट),
						'other' => q({0} किलोबिट),
					},
					# Long Unit Identifier
					'digital-kilobyte' => {
						'1' => q(masculine),
						'name' => q(किलोबाइट),
						'one' => q({0} किलोबाइट),
						'other' => q({0} किलोबाइट),
					},
					# Core Unit Identifier
					'kilobyte' => {
						'1' => q(masculine),
						'name' => q(किलोबाइट),
						'one' => q({0} किलोबाइट),
						'other' => q({0} किलोबाइट),
					},
					# Long Unit Identifier
					'digital-megabit' => {
						'1' => q(masculine),
						'name' => q(मेगाबिट),
						'one' => q({0} मेगाबिट),
						'other' => q({0} मेगाबिट),
					},
					# Core Unit Identifier
					'megabit' => {
						'1' => q(masculine),
						'name' => q(मेगाबिट),
						'one' => q({0} मेगाबिट),
						'other' => q({0} मेगाबिट),
					},
					# Long Unit Identifier
					'digital-megabyte' => {
						'1' => q(masculine),
						'name' => q(मेगाबाइट),
						'one' => q({0} मेगाबाइट),
						'other' => q({0} मेगाबाइट),
					},
					# Core Unit Identifier
					'megabyte' => {
						'1' => q(masculine),
						'name' => q(मेगाबाइट),
						'one' => q({0} मेगाबाइट),
						'other' => q({0} मेगाबाइट),
					},
					# Long Unit Identifier
					'digital-petabyte' => {
						'1' => q(masculine),
						'name' => q(पेटाबाइट्स),
						'one' => q({0} पेटाबाइट),
						'other' => q({0} पेटाबाइट्स),
					},
					# Core Unit Identifier
					'petabyte' => {
						'1' => q(masculine),
						'name' => q(पेटाबाइट्स),
						'one' => q({0} पेटाबाइट),
						'other' => q({0} पेटाबाइट्स),
					},
					# Long Unit Identifier
					'digital-terabit' => {
						'1' => q(masculine),
						'name' => q(टेराबिट),
						'one' => q({0} टेराबिट),
						'other' => q({0} टेराबिट),
					},
					# Core Unit Identifier
					'terabit' => {
						'1' => q(masculine),
						'name' => q(टेराबिट),
						'one' => q({0} टेराबिट),
						'other' => q({0} टेराबिट),
					},
					# Long Unit Identifier
					'digital-terabyte' => {
						'1' => q(masculine),
						'name' => q(टेराबाइट्स),
						'one' => q({0} टेराबाइट),
						'other' => q({0} टेराबाइट्स),
					},
					# Core Unit Identifier
					'terabyte' => {
						'1' => q(masculine),
						'name' => q(टेराबाइट्स),
						'one' => q({0} टेराबाइट),
						'other' => q({0} टेराबाइट्स),
					},
					# Long Unit Identifier
					'duration-century' => {
						'1' => q(neuter),
						'name' => q(शतके),
						'one' => q({0} शतक),
						'other' => q({0} शतके),
					},
					# Core Unit Identifier
					'century' => {
						'1' => q(neuter),
						'name' => q(शतके),
						'one' => q({0} शतक),
						'other' => q({0} शतके),
					},
					# Long Unit Identifier
					'duration-day' => {
						'1' => q(masculine),
						'one' => q({0} दिवस),
						'other' => q({0} दिवस),
						'per' => q({0} दर दिवशी),
					},
					# Core Unit Identifier
					'day' => {
						'1' => q(masculine),
						'one' => q({0} दिवस),
						'other' => q({0} दिवस),
						'per' => q({0} दर दिवशी),
					},
					# Long Unit Identifier
					'duration-decade' => {
						'1' => q(neuter),
						'name' => q(दशके),
						'one' => q({0} दशक),
						'other' => q({0} दशके),
					},
					# Core Unit Identifier
					'decade' => {
						'1' => q(neuter),
						'name' => q(दशके),
						'one' => q({0} दशक),
						'other' => q({0} दशके),
					},
					# Long Unit Identifier
					'duration-hour' => {
						'1' => q(masculine),
						'one' => q({0} तास),
						'other' => q({0} तास),
						'per' => q({0} प्रति तास),
					},
					# Core Unit Identifier
					'hour' => {
						'1' => q(masculine),
						'one' => q({0} तास),
						'other' => q({0} तास),
						'per' => q({0} प्रति तास),
					},
					# Long Unit Identifier
					'duration-microsecond' => {
						'1' => q(masculine),
						'name' => q(मायक्रोसेकंद),
						'one' => q({0} मायक्रोसेकंद),
						'other' => q({0} मायक्रोसेकंद),
					},
					# Core Unit Identifier
					'microsecond' => {
						'1' => q(masculine),
						'name' => q(मायक्रोसेकंद),
						'one' => q({0} मायक्रोसेकंद),
						'other' => q({0} मायक्रोसेकंद),
					},
					# Long Unit Identifier
					'duration-millisecond' => {
						'1' => q(masculine),
						'one' => q({0} मिलिसेकंद),
						'other' => q({0} मिलिसेकंद),
					},
					# Core Unit Identifier
					'millisecond' => {
						'1' => q(masculine),
						'one' => q({0} मिलिसेकंद),
						'other' => q({0} मिलिसेकंद),
					},
					# Long Unit Identifier
					'duration-minute' => {
						'1' => q(masculine),
						'one' => q({0} मिनिट),
						'other' => q({0} मिनिटे),
						'per' => q({0} दर मिनिट),
					},
					# Core Unit Identifier
					'minute' => {
						'1' => q(masculine),
						'one' => q({0} मिनिट),
						'other' => q({0} मिनिटे),
						'per' => q({0} दर मिनिट),
					},
					# Long Unit Identifier
					'duration-month' => {
						'1' => q(masculine),
						'one' => q({0} महिना),
						'other' => q({0} महिने),
						'per' => q({0} दर महिना),
					},
					# Core Unit Identifier
					'month' => {
						'1' => q(masculine),
						'one' => q({0} महिना),
						'other' => q({0} महिने),
						'per' => q({0} दर महिना),
					},
					# Long Unit Identifier
					'duration-nanosecond' => {
						'1' => q(masculine),
						'name' => q(नॅनोसेकंद),
						'one' => q({0} नॅनोसेकंद),
						'other' => q({0} नॅनोसेकंद),
					},
					# Core Unit Identifier
					'nanosecond' => {
						'1' => q(masculine),
						'name' => q(नॅनोसेकंद),
						'one' => q({0} नॅनोसेकंद),
						'other' => q({0} नॅनोसेकंद),
					},
					# Long Unit Identifier
					'duration-quarter' => {
						'1' => q(feminine),
						'one' => q({0} तिमाही),
						'other' => q({0} तिमाही),
						'per' => q({0} दर तिमाही),
					},
					# Core Unit Identifier
					'quarter' => {
						'1' => q(feminine),
						'one' => q({0} तिमाही),
						'other' => q({0} तिमाही),
						'per' => q({0} दर तिमाही),
					},
					# Long Unit Identifier
					'duration-second' => {
						'1' => q(masculine),
						'one' => q({0} सेकंद),
						'other' => q({0} सेकंद),
						'per' => q({0} प्रति सेकंद),
					},
					# Core Unit Identifier
					'second' => {
						'1' => q(masculine),
						'one' => q({0} सेकंद),
						'other' => q({0} सेकंद),
						'per' => q({0} प्रति सेकंद),
					},
					# Long Unit Identifier
					'duration-week' => {
						'1' => q(masculine),
						'one' => q({0} आठवडा),
						'other' => q({0} आठवडे),
						'per' => q({0} दर आठवडा),
					},
					# Core Unit Identifier
					'week' => {
						'1' => q(masculine),
						'one' => q({0} आठवडा),
						'other' => q({0} आठवडे),
						'per' => q({0} दर आठवडा),
					},
					# Long Unit Identifier
					'duration-year' => {
						'1' => q(neuter),
						'one' => q({0} वर्ष),
						'other' => q({0} वर्षे),
						'per' => q({0} दर वर्षी),
					},
					# Core Unit Identifier
					'year' => {
						'1' => q(neuter),
						'one' => q({0} वर्ष),
						'other' => q({0} वर्षे),
						'per' => q({0} दर वर्षी),
					},
					# Long Unit Identifier
					'electric-ampere' => {
						'1' => q(masculine),
						'name' => q(अँपियर),
						'one' => q({0} अँपियर),
						'other' => q({0} अँपियर),
					},
					# Core Unit Identifier
					'ampere' => {
						'1' => q(masculine),
						'name' => q(अँपियर),
						'one' => q({0} अँपियर),
						'other' => q({0} अँपियर),
					},
					# Long Unit Identifier
					'electric-milliampere' => {
						'1' => q(neuter),
						'name' => q(मिलिअँपियर),
						'one' => q({0} मिलिअँपियर),
						'other' => q({0} मिलिअँपियर),
					},
					# Core Unit Identifier
					'milliampere' => {
						'1' => q(neuter),
						'name' => q(मिलिअँपियर),
						'one' => q({0} मिलिअँपियर),
						'other' => q({0} मिलिअँपियर),
					},
					# Long Unit Identifier
					'electric-ohm' => {
						'1' => q(masculine),
						'one' => q({0} ओहम),
						'other' => q({0} ओहम),
					},
					# Core Unit Identifier
					'ohm' => {
						'1' => q(masculine),
						'one' => q({0} ओहम),
						'other' => q({0} ओहम),
					},
					# Long Unit Identifier
					'electric-volt' => {
						'1' => q(masculine),
						'one' => q({0} व्होल्ट),
						'other' => q({0} व्होल्ट),
					},
					# Core Unit Identifier
					'volt' => {
						'1' => q(masculine),
						'one' => q({0} व्होल्ट),
						'other' => q({0} व्होल्ट),
					},
					# Long Unit Identifier
					'energy-british-thermal-unit' => {
						'name' => q(ब्रिटिश थर्मल युनिट),
						'one' => q({0} ब्रिटिश थर्मल युनिट),
						'other' => q({0} ब्रिटिश थर्मल युनिट),
					},
					# Core Unit Identifier
					'british-thermal-unit' => {
						'name' => q(ब्रिटिश थर्मल युनिट),
						'one' => q({0} ब्रिटिश थर्मल युनिट),
						'other' => q({0} ब्रिटिश थर्मल युनिट),
					},
					# Long Unit Identifier
					'energy-calorie' => {
						'1' => q(feminine),
						'name' => q(कॅलरीज),
						'one' => q({0} कॅलरी),
						'other' => q({0} कॅलरीज),
					},
					# Core Unit Identifier
					'calorie' => {
						'1' => q(feminine),
						'name' => q(कॅलरीज),
						'one' => q({0} कॅलरी),
						'other' => q({0} कॅलरीज),
					},
					# Long Unit Identifier
					'energy-electronvolt' => {
						'name' => q(इलेक्ट्रॉनव्होल्ट्स),
						'one' => q({0} इलेक्ट्रॉनव्होल्ट),
						'other' => q({0} इलेक्ट्रॉनव्होल्ट्स),
					},
					# Core Unit Identifier
					'electronvolt' => {
						'name' => q(इलेक्ट्रॉनव्होल्ट्स),
						'one' => q({0} इलेक्ट्रॉनव्होल्ट),
						'other' => q({0} इलेक्ट्रॉनव्होल्ट्स),
					},
					# Long Unit Identifier
					'energy-foodcalorie' => {
						'name' => q(कॅलरीज),
						'one' => q({0} कॅलरी),
						'other' => q({0} कॅलरीज),
					},
					# Core Unit Identifier
					'foodcalorie' => {
						'name' => q(कॅलरीज),
						'one' => q({0} कॅलरी),
						'other' => q({0} कॅलरीज),
					},
					# Long Unit Identifier
					'energy-joule' => {
						'1' => q(masculine),
						'one' => q({0} ज्यूल),
						'other' => q({0} ज्यूल),
					},
					# Core Unit Identifier
					'joule' => {
						'1' => q(masculine),
						'one' => q({0} ज्यूल),
						'other' => q({0} ज्यूल),
					},
					# Long Unit Identifier
					'energy-kilocalorie' => {
						'name' => q(किलोकॅलोरी),
						'one' => q({0} किलोकॅलोरी),
						'other' => q({0} किलोकॅलोरी),
					},
					# Core Unit Identifier
					'kilocalorie' => {
						'name' => q(किलोकॅलोरी),
						'one' => q({0} किलोकॅलोरी),
						'other' => q({0} किलोकॅलोरी),
					},
					# Long Unit Identifier
					'energy-kilojoule' => {
						'1' => q(neuter),
						'one' => q({0} किलोज्यूल),
						'other' => q({0} किलोज्यूल),
					},
					# Core Unit Identifier
					'kilojoule' => {
						'1' => q(neuter),
						'one' => q({0} किलोज्यूल),
						'other' => q({0} किलोज्यूल),
					},
					# Long Unit Identifier
					'energy-kilowatt-hour' => {
						'1' => q(neuter),
						'name' => q(किलोवॉट-तास),
						'one' => q({0} किलोवॉट तास),
						'other' => q({0} किलोवॉट-तास),
					},
					# Core Unit Identifier
					'kilowatt-hour' => {
						'1' => q(neuter),
						'name' => q(किलोवॉट-तास),
						'one' => q({0} किलोवॉट तास),
						'other' => q({0} किलोवॉट-तास),
					},
					# Long Unit Identifier
					'force-kilowatt-hour-per-100-kilometer' => {
						'1' => q(neuter),
						'name' => q(किलोवॉट-तास प्रति 100 किलोमीटर),
						'one' => q({0} किलोवॉट-तास प्रति 100 किलोमीटर),
						'other' => q({0} किलोवॉट-तास प्रति 100 किलोमीटर),
					},
					# Core Unit Identifier
					'kilowatt-hour-per-100-kilometer' => {
						'1' => q(neuter),
						'name' => q(किलोवॉट-तास प्रति 100 किलोमीटर),
						'one' => q({0} किलोवॉट-तास प्रति 100 किलोमीटर),
						'other' => q({0} किलोवॉट-तास प्रति 100 किलोमीटर),
					},
					# Long Unit Identifier
					'force-newton' => {
						'1' => q(masculine),
						'name' => q(न्यूटन्स),
						'one' => q({0} न्यूटन),
						'other' => q({0} न्यूटन्स),
					},
					# Core Unit Identifier
					'newton' => {
						'1' => q(masculine),
						'name' => q(न्यूटन्स),
						'one' => q({0} न्यूटन),
						'other' => q({0} न्यूटन्स),
					},
					# Long Unit Identifier
					'force-pound-force' => {
						'name' => q(पाउंड्स ऑफ फोर्स),
						'one' => q({0} पाउंड ऑफ फोर्स),
						'other' => q({0} पाउंड्स ऑफ फोर्स),
					},
					# Core Unit Identifier
					'pound-force' => {
						'name' => q(पाउंड्स ऑफ फोर्स),
						'one' => q({0} पाउंड ऑफ फोर्स),
						'other' => q({0} पाउंड्स ऑफ फोर्स),
					},
					# Long Unit Identifier
					'frequency-gigahertz' => {
						'1' => q(neuter),
						'name' => q(गिगाहर्ट्झ),
						'one' => q({0} गिगाहर्ट्झ),
						'other' => q({0} गिगाहर्ट्झ),
					},
					# Core Unit Identifier
					'gigahertz' => {
						'1' => q(neuter),
						'name' => q(गिगाहर्ट्झ),
						'one' => q({0} गिगाहर्ट्झ),
						'other' => q({0} गिगाहर्ट्झ),
					},
					# Long Unit Identifier
					'frequency-hertz' => {
						'1' => q(neuter),
						'name' => q(हर्ट्झ),
						'one' => q({0} हर्ट्झ),
						'other' => q({0} हर्ट्झ),
					},
					# Core Unit Identifier
					'hertz' => {
						'1' => q(neuter),
						'name' => q(हर्ट्झ),
						'one' => q({0} हर्ट्झ),
						'other' => q({0} हर्ट्झ),
					},
					# Long Unit Identifier
					'frequency-kilohertz' => {
						'1' => q(neuter),
						'name' => q(किलोहर्ट्झ),
						'one' => q({0} किलोहर्ट्झ),
						'other' => q({0} किलोहर्ट्झ),
					},
					# Core Unit Identifier
					'kilohertz' => {
						'1' => q(neuter),
						'name' => q(किलोहर्ट्झ),
						'one' => q({0} किलोहर्ट्झ),
						'other' => q({0} किलोहर्ट्झ),
					},
					# Long Unit Identifier
					'frequency-megahertz' => {
						'1' => q(neuter),
						'name' => q(मेगाहर्ट्झ),
						'one' => q({0} मेगाहर्ट्झ),
						'other' => q({0} मेगाहर्ट्झ),
					},
					# Core Unit Identifier
					'megahertz' => {
						'1' => q(neuter),
						'name' => q(मेगाहर्ट्झ),
						'one' => q({0} मेगाहर्ट्झ),
						'other' => q({0} मेगाहर्ट्झ),
					},
					# Long Unit Identifier
					'graphics-dot-per-centimeter' => {
						'name' => q(पिक्सेल्स प्रति सेंटिमीटर),
						'one' => q(प्रति सेंटिमीटर {0} पिक्सेल्स),
						'other' => q(प्रति सेंटिमीटर {0} पिक्सेल्स),
					},
					# Core Unit Identifier
					'dot-per-centimeter' => {
						'name' => q(पिक्सेल्स प्रति सेंटिमीटर),
						'one' => q(प्रति सेंटिमीटर {0} पिक्सेल्स),
						'other' => q(प्रति सेंटिमीटर {0} पिक्सेल्स),
					},
					# Long Unit Identifier
					'graphics-dot-per-inch' => {
						'name' => q(पिक्सेल्स प्रति इंच),
						'one' => q(प्रति इंच {0} पिक्सेल),
						'other' => q(प्रति इंच {0} पिक्सेल्स),
					},
					# Core Unit Identifier
					'dot-per-inch' => {
						'name' => q(पिक्सेल्स प्रति इंच),
						'one' => q(प्रति इंच {0} पिक्सेल),
						'other' => q(प्रति इंच {0} पिक्सेल्स),
					},
					# Long Unit Identifier
					'graphics-em' => {
						'1' => q(masculine),
						'name' => q(टायपोग्राफिक em),
						'one' => q({0} em),
						'other' => q({0} ems),
					},
					# Core Unit Identifier
					'em' => {
						'1' => q(masculine),
						'name' => q(टायपोग्राफिक em),
						'one' => q({0} em),
						'other' => q({0} ems),
					},
					# Long Unit Identifier
					'graphics-megapixel' => {
						'1' => q(masculine),
						'name' => q(मेगापिक्सेल्स),
						'one' => q({0} मेगापिक्सेल),
						'other' => q({0} मेगापिक्सेल्स),
					},
					# Core Unit Identifier
					'megapixel' => {
						'1' => q(masculine),
						'name' => q(मेगापिक्सेल्स),
						'one' => q({0} मेगापिक्सेल),
						'other' => q({0} मेगापिक्सेल्स),
					},
					# Long Unit Identifier
					'graphics-pixel' => {
						'1' => q(masculine),
						'one' => q({0} पिक्सेल),
						'other' => q({0} पिक्सेल्स),
					},
					# Core Unit Identifier
					'pixel' => {
						'1' => q(masculine),
						'one' => q({0} पिक्सेल),
						'other' => q({0} पिक्सेल्स),
					},
					# Long Unit Identifier
					'graphics-pixel-per-centimeter' => {
						'1' => q(masculine),
						'name' => q(पिक्सेल्स प्रति सेंटीमीटर),
						'one' => q({0} पिक्सेल प्रति सेंटीमीटर),
						'other' => q({0} पिक्सेल्स प्रति सेंटीमीटर),
					},
					# Core Unit Identifier
					'pixel-per-centimeter' => {
						'1' => q(masculine),
						'name' => q(पिक्सेल्स प्रति सेंटीमीटर),
						'one' => q({0} पिक्सेल प्रति सेंटीमीटर),
						'other' => q({0} पिक्सेल्स प्रति सेंटीमीटर),
					},
					# Long Unit Identifier
					'graphics-pixel-per-inch' => {
						'name' => q(पिक्सेल्स प्रति इंच),
						'one' => q({0} पिक्सेल प्रति इंच),
						'other' => q({0} पिक्सेल्स प्रति इंच),
					},
					# Core Unit Identifier
					'pixel-per-inch' => {
						'name' => q(पिक्सेल्स प्रति इंच),
						'one' => q({0} पिक्सेल प्रति इंच),
						'other' => q({0} पिक्सेल्स प्रति इंच),
					},
					# Long Unit Identifier
					'length-astronomical-unit' => {
						'name' => q(खगोलीय एकके),
						'one' => q({0} खगोलीय एकक),
						'other' => q({0} खगोलीय एकके),
					},
					# Core Unit Identifier
					'astronomical-unit' => {
						'name' => q(खगोलीय एकके),
						'one' => q({0} खगोलीय एकक),
						'other' => q({0} खगोलीय एकके),
					},
					# Long Unit Identifier
					'length-centimeter' => {
						'1' => q(neuter),
						'name' => q(सेंटीमीटर),
						'one' => q({0} सेंटीमीटर),
						'other' => q({0} सेंटीमीटर),
						'per' => q({0} दर सेंटीमीटर),
					},
					# Core Unit Identifier
					'centimeter' => {
						'1' => q(neuter),
						'name' => q(सेंटीमीटर),
						'one' => q({0} सेंटीमीटर),
						'other' => q({0} सेंटीमीटर),
						'per' => q({0} दर सेंटीमीटर),
					},
					# Long Unit Identifier
					'length-decimeter' => {
						'1' => q(neuter),
						'name' => q(डेसीमीटर),
						'one' => q({0} डेसीमीटर),
						'other' => q({0} डेसीमीटर),
					},
					# Core Unit Identifier
					'decimeter' => {
						'1' => q(neuter),
						'name' => q(डेसीमीटर),
						'one' => q({0} डेसीमीटर),
						'other' => q({0} डेसीमीटर),
					},
					# Long Unit Identifier
					'length-earth-radius' => {
						'name' => q(पृथ्वी त्रिज्या),
						'one' => q({0} पृथ्वी त्रिज्या),
						'other' => q({0} पृथ्वी त्रिज्या),
					},
					# Core Unit Identifier
					'earth-radius' => {
						'name' => q(पृथ्वी त्रिज्या),
						'one' => q({0} पृथ्वी त्रिज्या),
						'other' => q({0} पृथ्वी त्रिज्या),
					},
					# Long Unit Identifier
					'length-fathom' => {
						'one' => q({0} फॅदम),
						'other' => q({0} फॅदम),
					},
					# Core Unit Identifier
					'fathom' => {
						'one' => q({0} फॅदम),
						'other' => q({0} फॅदम),
					},
					# Long Unit Identifier
					'length-foot' => {
						'per' => q({0} दर फूट),
					},
					# Core Unit Identifier
					'foot' => {
						'per' => q({0} दर फूट),
					},
					# Long Unit Identifier
					'length-furlong' => {
						'one' => q({0} फर्लांग),
						'other' => q({0} फर्लांग),
					},
					# Core Unit Identifier
					'furlong' => {
						'one' => q({0} फर्लांग),
						'other' => q({0} फर्लांग),
					},
					# Long Unit Identifier
					'length-inch' => {
						'per' => q({0} दर इंच),
					},
					# Core Unit Identifier
					'inch' => {
						'per' => q({0} दर इंच),
					},
					# Long Unit Identifier
					'length-kilometer' => {
						'1' => q(neuter),
						'name' => q(किलोमीटर),
						'one' => q({0} किलोमीटर),
						'other' => q({0} किलोमीटर),
						'per' => q({0} दर किलोमीटर),
					},
					# Core Unit Identifier
					'kilometer' => {
						'1' => q(neuter),
						'name' => q(किलोमीटर),
						'one' => q({0} किलोमीटर),
						'other' => q({0} किलोमीटर),
						'per' => q({0} दर किलोमीटर),
					},
					# Long Unit Identifier
					'length-light-year' => {
						'one' => q({0} प्रकाश वर्ष),
						'other' => q({0} प्रकाश वर्षे),
					},
					# Core Unit Identifier
					'light-year' => {
						'one' => q({0} प्रकाश वर्ष),
						'other' => q({0} प्रकाश वर्षे),
					},
					# Long Unit Identifier
					'length-meter' => {
						'1' => q(masculine),
						'one' => q({0} मीटर),
						'other' => q({0} मीटर),
						'per' => q({0} दर मीटर),
					},
					# Core Unit Identifier
					'meter' => {
						'1' => q(masculine),
						'one' => q({0} मीटर),
						'other' => q({0} मीटर),
						'per' => q({0} दर मीटर),
					},
					# Long Unit Identifier
					'length-micrometer' => {
						'1' => q(neuter),
						'one' => q({0} मायक्रोमीटर),
						'other' => q({0} मायक्रोमीटर),
					},
					# Core Unit Identifier
					'micrometer' => {
						'1' => q(neuter),
						'one' => q({0} मायक्रोमीटर),
						'other' => q({0} मायक्रोमीटर),
					},
					# Long Unit Identifier
					'length-mile-scandinavian' => {
						'1' => q(masculine),
						'name' => q(मैल-स्कॅन्डीनेव्हियन),
						'one' => q({0} मैल-स्कॅन्डीनेव्हियन),
						'other' => q({0} मैल-स्कॅन्डीनेव्हियन),
					},
					# Core Unit Identifier
					'mile-scandinavian' => {
						'1' => q(masculine),
						'name' => q(मैल-स्कॅन्डीनेव्हियन),
						'one' => q({0} मैल-स्कॅन्डीनेव्हियन),
						'other' => q({0} मैल-स्कॅन्डीनेव्हियन),
					},
					# Long Unit Identifier
					'length-millimeter' => {
						'1' => q(neuter),
						'name' => q(मिलिमीटर),
						'one' => q({0} मिलिमीटर),
						'other' => q({0} मिलिमीटर),
					},
					# Core Unit Identifier
					'millimeter' => {
						'1' => q(neuter),
						'name' => q(मिलिमीटर),
						'one' => q({0} मिलिमीटर),
						'other' => q({0} मिलिमीटर),
					},
					# Long Unit Identifier
					'length-nanometer' => {
						'1' => q(neuter),
						'name' => q(नॅनोमीटर),
						'one' => q({0} नॅनोमीटर),
						'other' => q({0} नॅनोमीटर),
					},
					# Core Unit Identifier
					'nanometer' => {
						'1' => q(neuter),
						'name' => q(नॅनोमीटर),
						'one' => q({0} नॅनोमीटर),
						'other' => q({0} नॅनोमीटर),
					},
					# Long Unit Identifier
					'length-nautical-mile' => {
						'name' => q(नॉटिकल मैल),
						'one' => q({0} नॉटिकल मैल),
						'other' => q({0} नॉटिकल मैल),
					},
					# Core Unit Identifier
					'nautical-mile' => {
						'name' => q(नॉटिकल मैल),
						'one' => q({0} नॉटिकल मैल),
						'other' => q({0} नॉटिकल मैल),
					},
					# Long Unit Identifier
					'length-parsec' => {
						'one' => q({0} पार्सेक),
						'other' => q({0} पार्सेक),
					},
					# Core Unit Identifier
					'parsec' => {
						'one' => q({0} पार्सेक),
						'other' => q({0} पार्सेक),
					},
					# Long Unit Identifier
					'length-picometer' => {
						'1' => q(neuter),
						'name' => q(पिकोमीटर),
						'one' => q({0} पिकोमीटर),
						'other' => q({0} पिकोमीटर),
					},
					# Core Unit Identifier
					'picometer' => {
						'1' => q(neuter),
						'name' => q(पिकोमीटर),
						'one' => q({0} पिकोमीटर),
						'other' => q({0} पिकोमीटर),
					},
					# Long Unit Identifier
					'length-solar-radius' => {
						'one' => q({0} सौर त्रिज्या),
						'other' => q({0} सौर त्रिज्या),
					},
					# Core Unit Identifier
					'solar-radius' => {
						'one' => q({0} सौर त्रिज्या),
						'other' => q({0} सौर त्रिज्या),
					},
					# Long Unit Identifier
					'light-candela' => {
						'1' => q(feminine),
						'name' => q(कँडेला),
						'one' => q({0} कँडेला),
						'other' => q({0} कँडेला),
					},
					# Core Unit Identifier
					'candela' => {
						'1' => q(feminine),
						'name' => q(कँडेला),
						'one' => q({0} कँडेला),
						'other' => q({0} कँडेला),
					},
					# Long Unit Identifier
					'light-lumen' => {
						'1' => q(masculine),
						'name' => q(लुमेन),
						'one' => q({0} लुमेन),
						'other' => q({0} लुमेन),
					},
					# Core Unit Identifier
					'lumen' => {
						'1' => q(masculine),
						'name' => q(लुमेन),
						'one' => q({0} लुमेन),
						'other' => q({0} लुमेन),
					},
					# Long Unit Identifier
					'light-lux' => {
						'1' => q(feminine),
						'one' => q({0} लक्स),
						'other' => q({0} लक्स),
					},
					# Core Unit Identifier
					'lux' => {
						'1' => q(feminine),
						'one' => q({0} लक्स),
						'other' => q({0} लक्स),
					},
					# Long Unit Identifier
					'light-solar-luminosity' => {
						'one' => q({0} सौर प्रकाश),
						'other' => q({0} सौर प्रकाश),
					},
					# Core Unit Identifier
					'solar-luminosity' => {
						'one' => q({0} सौर प्रकाश),
						'other' => q({0} सौर प्रकाश),
					},
					# Long Unit Identifier
					'mass-carat' => {
						'1' => q(neuter),
						'one' => q({0} कॅरेट),
						'other' => q({0} कॅरेट्स),
					},
					# Core Unit Identifier
					'carat' => {
						'1' => q(neuter),
						'one' => q({0} कॅरेट),
						'other' => q({0} कॅरेट्स),
					},
					# Long Unit Identifier
					'mass-earth-mass' => {
						'one' => q({0} पृथ्वी द्रव्यमान),
						'other' => q({0} पृथ्वी द्रव्यमान),
					},
					# Core Unit Identifier
					'earth-mass' => {
						'one' => q({0} पृथ्वी द्रव्यमान),
						'other' => q({0} पृथ्वी द्रव्यमान),
					},
					# Long Unit Identifier
					'mass-gram' => {
						'1' => q(masculine),
						'one' => q({0} ग्रॅम),
						'other' => q({0} ग्रॅम),
						'per' => q({0} दर ग्रॅम),
					},
					# Core Unit Identifier
					'gram' => {
						'1' => q(masculine),
						'one' => q({0} ग्रॅम),
						'other' => q({0} ग्रॅम),
						'per' => q({0} दर ग्रॅम),
					},
					# Long Unit Identifier
					'mass-kilogram' => {
						'1' => q(masculine),
						'name' => q(किलोग्रॅम),
						'one' => q({0} किलोग्रॅम),
						'other' => q({0} किलोग्रॅम),
						'per' => q({0} दर किलोग्रॅम),
					},
					# Core Unit Identifier
					'kilogram' => {
						'1' => q(masculine),
						'name' => q(किलोग्रॅम),
						'one' => q({0} किलोग्रॅम),
						'other' => q({0} किलोग्रॅम),
						'per' => q({0} दर किलोग्रॅम),
					},
					# Long Unit Identifier
					'mass-microgram' => {
						'1' => q(neuter),
						'name' => q(मायक्रोग्रॅम),
						'one' => q({0} मायक्रोग्रॅम),
						'other' => q({0} मायक्रोग्रॅम),
					},
					# Core Unit Identifier
					'microgram' => {
						'1' => q(neuter),
						'name' => q(मायक्रोग्रॅम),
						'one' => q({0} मायक्रोग्रॅम),
						'other' => q({0} मायक्रोग्रॅम),
					},
					# Long Unit Identifier
					'mass-milligram' => {
						'1' => q(neuter),
						'name' => q(मिलिग्रॅम),
						'one' => q({0} मिलिग्रॅम),
						'other' => q({0} मिलिग्रॅम),
					},
					# Core Unit Identifier
					'milligram' => {
						'1' => q(neuter),
						'name' => q(मिलिग्रॅम),
						'one' => q({0} मिलिग्रॅम),
						'other' => q({0} मिलिग्रॅम),
					},
					# Long Unit Identifier
					'mass-ounce' => {
						'per' => q({0} दर औंस),
					},
					# Core Unit Identifier
					'ounce' => {
						'per' => q({0} दर औंस),
					},
					# Long Unit Identifier
					'mass-ounce-troy' => {
						'name' => q(ट्रॉय औंस),
						'one' => q({0} ट्रॉय औंस),
						'other' => q({0} ट्रॉय औंस),
					},
					# Core Unit Identifier
					'ounce-troy' => {
						'name' => q(ट्रॉय औंस),
						'one' => q({0} ट्रॉय औंस),
						'other' => q({0} ट्रॉय औंस),
					},
					# Long Unit Identifier
					'mass-pound' => {
						'per' => q({0} दर पाउंड),
					},
					# Core Unit Identifier
					'pound' => {
						'per' => q({0} दर पाउंड),
					},
					# Long Unit Identifier
					'mass-solar-mass' => {
						'one' => q({0} सौर द्रव्यमान),
						'other' => q({0} सौर द्रव्यमान),
					},
					# Core Unit Identifier
					'solar-mass' => {
						'one' => q({0} सौर द्रव्यमान),
						'other' => q({0} सौर द्रव्यमान),
					},
					# Long Unit Identifier
					'mass-tonne' => {
						'1' => q(neuter),
						'name' => q(मेट्रिक टन),
						'one' => q({0} मेट्रिक टन),
						'other' => q({0} मेट्रिक टन),
					},
					# Core Unit Identifier
					'tonne' => {
						'1' => q(neuter),
						'name' => q(मेट्रिक टन),
						'one' => q({0} मेट्रिक टन),
						'other' => q({0} मेट्रिक टन),
					},
					# Long Unit Identifier
					'per' => {
						'1' => q({0} प्रति {1}),
					},
					# Core Unit Identifier
					'per' => {
						'1' => q({0} प्रति {1}),
					},
					# Long Unit Identifier
					'power-gigawatt' => {
						'1' => q(neuter),
						'name' => q(गिगावॉट),
						'one' => q({0} गिगावॉट),
						'other' => q({0} गिगावॉट),
					},
					# Core Unit Identifier
					'gigawatt' => {
						'1' => q(neuter),
						'name' => q(गिगावॉट),
						'one' => q({0} गिगावॉट),
						'other' => q({0} गिगावॉट),
					},
					# Long Unit Identifier
					'power-horsepower' => {
						'name' => q(हॉर्सपॉवर),
						'one' => q({0} हॉर्सपॉवर),
						'other' => q({0} हॉर्सपॉवर),
					},
					# Core Unit Identifier
					'horsepower' => {
						'name' => q(हॉर्सपॉवर),
						'one' => q({0} हॉर्सपॉवर),
						'other' => q({0} हॉर्सपॉवर),
					},
					# Long Unit Identifier
					'power-kilowatt' => {
						'1' => q(neuter),
						'name' => q(किलोवॉट),
						'one' => q({0} किलोवॉट),
						'other' => q({0} किलोवॉट),
					},
					# Core Unit Identifier
					'kilowatt' => {
						'1' => q(neuter),
						'name' => q(किलोवॉट),
						'one' => q({0} किलोवॉट),
						'other' => q({0} किलोवॉट),
					},
					# Long Unit Identifier
					'power-megawatt' => {
						'1' => q(neuter),
						'name' => q(मेगावॉट),
						'one' => q({0} मेगावॉट),
						'other' => q({0} मेगावॉट),
					},
					# Core Unit Identifier
					'megawatt' => {
						'1' => q(neuter),
						'name' => q(मेगावॉट),
						'one' => q({0} मेगावॉट),
						'other' => q({0} मेगावॉट),
					},
					# Long Unit Identifier
					'power-milliwatt' => {
						'1' => q(neuter),
						'name' => q(मिलिवॉट),
						'one' => q({0} मिलिवॉट),
						'other' => q({0} मिलिवॉट),
					},
					# Core Unit Identifier
					'milliwatt' => {
						'1' => q(neuter),
						'name' => q(मिलिवॉट),
						'one' => q({0} मिलिवॉट),
						'other' => q({0} मिलिवॉट),
					},
					# Long Unit Identifier
					'power-watt' => {
						'1' => q(masculine),
						'one' => q({0} वॉट),
						'other' => q({0} वॉट),
					},
					# Core Unit Identifier
					'watt' => {
						'1' => q(masculine),
						'one' => q({0} वॉट),
						'other' => q({0} वॉट),
					},
					# Long Unit Identifier
					'power2' => {
						'1' => q(चौरस {0}),
						'one' => q(चौरस {0}),
						'other' => q(चौरस {0}),
					},
					# Core Unit Identifier
					'power2' => {
						'1' => q(चौरस {0}),
						'one' => q(चौरस {0}),
						'other' => q(चौरस {0}),
					},
					# Long Unit Identifier
					'power3' => {
						'1' => q(घन{0}),
						'one' => q(घन{0}),
						'other' => q(घन{0}),
					},
					# Core Unit Identifier
					'power3' => {
						'1' => q(घन{0}),
						'one' => q(घन{0}),
						'other' => q(घन{0}),
					},
					# Long Unit Identifier
					'pressure-atmosphere' => {
						'1' => q(neuter),
						'name' => q(वातावरण),
						'one' => q({0} वातावरण),
						'other' => q({0} वातावरण),
					},
					# Core Unit Identifier
					'atmosphere' => {
						'1' => q(neuter),
						'name' => q(वातावरण),
						'one' => q({0} वातावरण),
						'other' => q({0} वातावरण),
					},
					# Long Unit Identifier
					'pressure-bar' => {
						'1' => q(masculine),
						'one' => q({0} बार),
						'other' => q({0} बार),
					},
					# Core Unit Identifier
					'bar' => {
						'1' => q(masculine),
						'one' => q({0} बार),
						'other' => q({0} बार),
					},
					# Long Unit Identifier
					'pressure-hectopascal' => {
						'1' => q(masculine),
						'name' => q(हेक्टोपास्कल),
						'one' => q({0} हेक्टोपास्कल),
						'other' => q({0} हेक्टोपास्कल),
					},
					# Core Unit Identifier
					'hectopascal' => {
						'1' => q(masculine),
						'name' => q(हेक्टोपास्कल),
						'one' => q({0} हेक्टोपास्कल),
						'other' => q({0} हेक्टोपास्कल),
					},
					# Long Unit Identifier
					'pressure-inch-ofhg' => {
						'name' => q(मर्क्यूरी इंच),
						'one' => q({0} मर्क्यूरी इंच),
						'other' => q({0} मर्क्यूरी इंच),
					},
					# Core Unit Identifier
					'inch-ofhg' => {
						'name' => q(मर्क्यूरी इंच),
						'one' => q({0} मर्क्यूरी इंच),
						'other' => q({0} मर्क्यूरी इंच),
					},
					# Long Unit Identifier
					'pressure-kilopascal' => {
						'1' => q(masculine),
						'name' => q(किलोपास्कल),
						'one' => q({0} किलोपास्कल),
						'other' => q({0} किलोपास्कल),
					},
					# Core Unit Identifier
					'kilopascal' => {
						'1' => q(masculine),
						'name' => q(किलोपास्कल),
						'one' => q({0} किलोपास्कल),
						'other' => q({0} किलोपास्कल),
					},
					# Long Unit Identifier
					'pressure-megapascal' => {
						'1' => q(masculine),
						'name' => q(मेगापास्कल),
						'one' => q({0} मेगापास्कल),
						'other' => q({0} मेगापास्कल्स),
					},
					# Core Unit Identifier
					'megapascal' => {
						'1' => q(masculine),
						'name' => q(मेगापास्कल),
						'one' => q({0} मेगापास्कल),
						'other' => q({0} मेगापास्कल्स),
					},
					# Long Unit Identifier
					'pressure-millibar' => {
						'1' => q(masculine),
						'one' => q({0} मिलिबार),
						'other' => q({0} मिलिबार),
					},
					# Core Unit Identifier
					'millibar' => {
						'1' => q(masculine),
						'one' => q({0} मिलिबार),
						'other' => q({0} मिलिबार),
					},
					# Long Unit Identifier
					'pressure-millimeter-ofhg' => {
						'name' => q(मर्क्यूरी मिलिमीटर),
						'one' => q({0} मर्क्यूरी मिलिमीटर),
						'other' => q({0} मर्क्यूरी मिलिमीटर),
					},
					# Core Unit Identifier
					'millimeter-ofhg' => {
						'name' => q(मर्क्यूरी मिलिमीटर),
						'one' => q({0} मर्क्यूरी मिलिमीटर),
						'other' => q({0} मर्क्यूरी मिलिमीटर),
					},
					# Long Unit Identifier
					'pressure-pascal' => {
						'1' => q(masculine),
						'name' => q(पास्काल),
						'one' => q({0} पास्काल),
						'other' => q({0} पास्काल),
					},
					# Core Unit Identifier
					'pascal' => {
						'1' => q(masculine),
						'name' => q(पास्काल),
						'one' => q({0} पास्काल),
						'other' => q({0} पास्काल),
					},
					# Long Unit Identifier
					'pressure-pound-force-per-square-inch' => {
						'name' => q(प्रति चौरस इंच पाउंड),
						'one' => q({0} प्रति चौरस इंच पाउंड),
						'other' => q({0} प्रति चौरस इंच पाउंड),
					},
					# Core Unit Identifier
					'pound-force-per-square-inch' => {
						'name' => q(प्रति चौरस इंच पाउंड),
						'one' => q({0} प्रति चौरस इंच पाउंड),
						'other' => q({0} प्रति चौरस इंच पाउंड),
					},
					# Long Unit Identifier
					'speed-beaufort' => {
						'name' => q(ब्युफोर्ट),
						'one' => q({0} ब्युफोर्ट),
						'other' => q({0} ब्युफोर्ट),
					},
					# Core Unit Identifier
					'beaufort' => {
						'name' => q(ब्युफोर्ट),
						'one' => q({0} ब्युफोर्ट),
						'other' => q({0} ब्युफोर्ट),
					},
					# Long Unit Identifier
					'speed-kilometer-per-hour' => {
						'1' => q(neuter),
						'name' => q(किलोमीटर प्रति तास),
						'one' => q({0} किलोमीटर प्रति तास),
						'other' => q({0} किलोमीटर प्रति तास),
					},
					# Core Unit Identifier
					'kilometer-per-hour' => {
						'1' => q(neuter),
						'name' => q(किलोमीटर प्रति तास),
						'one' => q({0} किलोमीटर प्रति तास),
						'other' => q({0} किलोमीटर प्रति तास),
					},
					# Long Unit Identifier
					'speed-knot' => {
						'name' => q(नॉट),
						'one' => q({0} नॉट),
						'other' => q({0} नॉट),
					},
					# Core Unit Identifier
					'knot' => {
						'name' => q(नॉट),
						'one' => q({0} नॉट),
						'other' => q({0} नॉट),
					},
					# Long Unit Identifier
					'speed-meter-per-second' => {
						'1' => q(neuter),
						'name' => q(मीटर प्रति सेकंद),
						'one' => q({0} मीटर प्रति सेकंद),
						'other' => q({0} मीटर प्रति सेकंद),
					},
					# Core Unit Identifier
					'meter-per-second' => {
						'1' => q(neuter),
						'name' => q(मीटर प्रति सेकंद),
						'one' => q({0} मीटर प्रति सेकंद),
						'other' => q({0} मीटर प्रति सेकंद),
					},
					# Long Unit Identifier
					'speed-mile-per-hour' => {
						'name' => q(मैल प्रति तास),
						'one' => q({0} मैल प्रति तास),
						'other' => q({0} मैल प्रति तास),
					},
					# Core Unit Identifier
					'mile-per-hour' => {
						'name' => q(मैल प्रति तास),
						'one' => q({0} मैल प्रति तास),
						'other' => q({0} मैल प्रति तास),
					},
					# Long Unit Identifier
					'temperature-celsius' => {
						'1' => q(neuter),
						'one' => q({0} अंश सेल्सिअस),
						'other' => q({0} अंश सेल्सिअस),
					},
					# Core Unit Identifier
					'celsius' => {
						'1' => q(neuter),
						'one' => q({0} अंश सेल्सिअस),
						'other' => q({0} अंश सेल्सिअस),
					},
					# Long Unit Identifier
					'temperature-fahrenheit' => {
						'one' => q({0} अंश फॅरनहाईट),
						'other' => q({0} अंश फॅरनहाईट),
					},
					# Core Unit Identifier
					'fahrenheit' => {
						'one' => q({0} अंश फॅरनहाईट),
						'other' => q({0} अंश फॅरनहाईट),
					},
					# Long Unit Identifier
					'temperature-generic' => {
						'1' => q(masculine),
						'one' => q({0}°),
						'other' => q({0} अंश),
					},
					# Core Unit Identifier
					'generic' => {
						'1' => q(masculine),
						'one' => q({0}°),
						'other' => q({0} अंश),
					},
					# Long Unit Identifier
					'temperature-kelvin' => {
						'1' => q(neuter),
						'one' => q({0} केल्व्हिन),
						'other' => q({0} केल्व्हिन),
					},
					# Core Unit Identifier
					'kelvin' => {
						'1' => q(neuter),
						'one' => q({0} केल्व्हिन),
						'other' => q({0} केल्व्हिन),
					},
					# Long Unit Identifier
					'torque-newton-meter' => {
						'1' => q(neuter),
						'name' => q(न्यूटन-मीटर),
						'one' => q({0} न्यूटन-मीटर),
						'other' => q({0} न्यूटन-मीटर),
					},
					# Core Unit Identifier
					'newton-meter' => {
						'1' => q(neuter),
						'name' => q(न्यूटन-मीटर),
						'one' => q({0} न्यूटन-मीटर),
						'other' => q({0} न्यूटन-मीटर),
					},
					# Long Unit Identifier
					'torque-pound-force-foot' => {
						'name' => q(पाउंड-फूट),
						'one' => q({0} पाउंड-फुट),
						'other' => q({0} पाउंड-फूट),
					},
					# Core Unit Identifier
					'pound-force-foot' => {
						'name' => q(पाउंड-फूट),
						'one' => q({0} पाउंड-फुट),
						'other' => q({0} पाउंड-फूट),
					},
					# Long Unit Identifier
					'volume-acre-foot' => {
						'name' => q(एकर-फूट),
						'one' => q({0} एकर-फूट),
						'other' => q({0} एकर-फूट),
					},
					# Core Unit Identifier
					'acre-foot' => {
						'name' => q(एकर-फूट),
						'one' => q({0} एकर-फूट),
						'other' => q({0} एकर-फूट),
					},
					# Long Unit Identifier
					'volume-barrel' => {
						'one' => q({0} बॅरल),
						'other' => q({0} बॅरल),
					},
					# Core Unit Identifier
					'barrel' => {
						'one' => q({0} बॅरल),
						'other' => q({0} बॅरल),
					},
					# Long Unit Identifier
					'volume-bushel' => {
						'one' => q({0} बुशेल),
						'other' => q({0} बुशेल),
					},
					# Core Unit Identifier
					'bushel' => {
						'one' => q({0} बुशेल),
						'other' => q({0} बुशेल),
					},
					# Long Unit Identifier
					'volume-centiliter' => {
						'1' => q(neuter),
						'name' => q(सेंटीलीटर),
						'one' => q({0} सेंटीलीटर),
						'other' => q({0} सेंटीलीटर),
					},
					# Core Unit Identifier
					'centiliter' => {
						'1' => q(neuter),
						'name' => q(सेंटीलीटर),
						'one' => q({0} सेंटीलीटर),
						'other' => q({0} सेंटीलीटर),
					},
					# Long Unit Identifier
					'volume-cubic-centimeter' => {
						'1' => q(neuter),
						'name' => q(घन सेंटीमीटर),
						'one' => q({0} घन सेंटीमीटर),
						'other' => q({0} घन सेंटीमीटर),
						'per' => q({0} प्रति घन सेंटिमीटर),
					},
					# Core Unit Identifier
					'cubic-centimeter' => {
						'1' => q(neuter),
						'name' => q(घन सेंटीमीटर),
						'one' => q({0} घन सेंटीमीटर),
						'other' => q({0} घन सेंटीमीटर),
						'per' => q({0} प्रति घन सेंटिमीटर),
					},
					# Long Unit Identifier
					'volume-cubic-foot' => {
						'name' => q(घन फूट),
						'one' => q({0} घन फूट),
						'other' => q({0} घन फूट),
					},
					# Core Unit Identifier
					'cubic-foot' => {
						'name' => q(घन फूट),
						'one' => q({0} घन फूट),
						'other' => q({0} घन फूट),
					},
					# Long Unit Identifier
					'volume-cubic-inch' => {
						'name' => q(घन इंच),
						'one' => q({0} घन इंच),
						'other' => q({0} घन इंच),
					},
					# Core Unit Identifier
					'cubic-inch' => {
						'name' => q(घन इंच),
						'one' => q({0} घन इंच),
						'other' => q({0} घन इंच),
					},
					# Long Unit Identifier
					'volume-cubic-kilometer' => {
						'1' => q(neuter),
						'name' => q(घन किलोमीटर),
						'one' => q({0} घन किलोमीटर),
						'other' => q({0} घन किलोमीटर),
					},
					# Core Unit Identifier
					'cubic-kilometer' => {
						'1' => q(neuter),
						'name' => q(घन किलोमीटर),
						'one' => q({0} घन किलोमीटर),
						'other' => q({0} घन किलोमीटर),
					},
					# Long Unit Identifier
					'volume-cubic-meter' => {
						'1' => q(neuter),
						'name' => q(घन मीटर),
						'one' => q({0} घन मीटर),
						'other' => q({0} घन मीटर),
						'per' => q({0} दर घन मीटर),
					},
					# Core Unit Identifier
					'cubic-meter' => {
						'1' => q(neuter),
						'name' => q(घन मीटर),
						'one' => q({0} घन मीटर),
						'other' => q({0} घन मीटर),
						'per' => q({0} दर घन मीटर),
					},
					# Long Unit Identifier
					'volume-cubic-mile' => {
						'name' => q(घन मैल),
						'one' => q({0} घन मैल),
						'other' => q({0} घन मैल),
					},
					# Core Unit Identifier
					'cubic-mile' => {
						'name' => q(घन मैल),
						'one' => q({0} घन मैल),
						'other' => q({0} घन मैल),
					},
					# Long Unit Identifier
					'volume-cubic-yard' => {
						'name' => q(घन यार्ड),
						'one' => q({0} घन यार्ड),
						'other' => q({0} घन यार्ड),
					},
					# Core Unit Identifier
					'cubic-yard' => {
						'name' => q(घन यार्ड),
						'one' => q({0} घन यार्ड),
						'other' => q({0} घन यार्ड),
					},
					# Long Unit Identifier
					'volume-cup' => {
						'one' => q({0} कप),
						'other' => q({0} कप),
					},
					# Core Unit Identifier
					'cup' => {
						'one' => q({0} कप),
						'other' => q({0} कप),
					},
					# Long Unit Identifier
					'volume-cup-metric' => {
						'1' => q(neuter),
						'name' => q(मेट्रिक कप),
						'one' => q({0} मेट्रिक कप),
						'other' => q({0} मेट्रिक कप),
					},
					# Core Unit Identifier
					'cup-metric' => {
						'1' => q(neuter),
						'name' => q(मेट्रिक कप),
						'one' => q({0} मेट्रिक कप),
						'other' => q({0} मेट्रिक कप),
					},
					# Long Unit Identifier
					'volume-deciliter' => {
						'1' => q(neuter),
						'name' => q(डेसीलीटर),
						'one' => q({0} डेसीलीटर),
						'other' => q({0} डेसीलीटर),
					},
					# Core Unit Identifier
					'deciliter' => {
						'1' => q(neuter),
						'name' => q(डेसीलीटर),
						'one' => q({0} डेसीलीटर),
						'other' => q({0} डेसीलीटर),
					},
					# Long Unit Identifier
					'volume-dessert-spoon' => {
						'name' => q(डेझर्ट स्पून),
						'one' => q({0} डेझर्ट स्पून),
						'other' => q({0} डेझर्ट स्पून),
					},
					# Core Unit Identifier
					'dessert-spoon' => {
						'name' => q(डेझर्ट स्पून),
						'one' => q({0} डेझर्ट स्पून),
						'other' => q({0} डेझर्ट स्पून),
					},
					# Long Unit Identifier
					'volume-dessert-spoon-imperial' => {
						'name' => q(इंपि. डेझर्ट स्पून),
						'one' => q({0} इंपि. डेझर्ट स्पून),
						'other' => q({0} इंपि. डेझर्ट स्पून),
					},
					# Core Unit Identifier
					'dessert-spoon-imperial' => {
						'name' => q(इंपि. डेझर्ट स्पून),
						'one' => q({0} इंपि. डेझर्ट स्पून),
						'other' => q({0} इंपि. डेझर्ट स्पून),
					},
					# Long Unit Identifier
					'volume-dram' => {
						'name' => q(ड्रॅम),
						'one' => q({0} ड्रॅम),
						'other' => q({0} ड्रॅम),
					},
					# Core Unit Identifier
					'dram' => {
						'name' => q(ड्रॅम),
						'one' => q({0} ड्रॅम),
						'other' => q({0} ड्रॅम),
					},
					# Long Unit Identifier
					'volume-fluid-ounce' => {
						'name' => q(फ्लूइड औंस),
						'one' => q({0} फ्लूइड औंस),
						'other' => q({0} फ्लूइड औंस),
					},
					# Core Unit Identifier
					'fluid-ounce' => {
						'name' => q(फ्लूइड औंस),
						'one' => q({0} फ्लूइड औंस),
						'other' => q({0} फ्लूइड औंस),
					},
					# Long Unit Identifier
					'volume-fluid-ounce-imperial' => {
						'name' => q(इम्पे. फ्लुईड औंस),
						'one' => q({0} इम्पे. फ्लुईड औंस),
						'other' => q({0} इम्पे. फ्लुईड औंस),
					},
					# Core Unit Identifier
					'fluid-ounce-imperial' => {
						'name' => q(इम्पे. फ्लुईड औंस),
						'one' => q({0} इम्पे. फ्लुईड औंस),
						'other' => q({0} इम्पे. फ्लुईड औंस),
					},
					# Long Unit Identifier
					'volume-gallon' => {
						'name' => q(गॅलन),
						'one' => q({0} गॅलन),
						'other' => q({0} गॅलन),
						'per' => q({0} दर गॅलन),
					},
					# Core Unit Identifier
					'gallon' => {
						'name' => q(गॅलन),
						'one' => q({0} गॅलन),
						'other' => q({0} गॅलन),
						'per' => q({0} दर गॅलन),
					},
					# Long Unit Identifier
					'volume-gallon-imperial' => {
						'name' => q(इम्पिरीयल गॅलन),
						'one' => q({0} इम्पिरीयल गॅलन),
						'other' => q({0} इम्पिरीयल गॅलन),
						'per' => q({0} पर इम्पिरीयल गॅलन),
					},
					# Core Unit Identifier
					'gallon-imperial' => {
						'name' => q(इम्पिरीयल गॅलन),
						'one' => q({0} इम्पिरीयल गॅलन),
						'other' => q({0} इम्पिरीयल गॅलन),
						'per' => q({0} पर इम्पिरीयल गॅलन),
					},
					# Long Unit Identifier
					'volume-hectoliter' => {
						'1' => q(neuter),
						'name' => q(हेक्टोलीटर),
						'one' => q({0} हेक्टोलीटर),
						'other' => q({0} हेक्टोलीटर),
					},
					# Core Unit Identifier
					'hectoliter' => {
						'1' => q(neuter),
						'name' => q(हेक्टोलीटर),
						'one' => q({0} हेक्टोलीटर),
						'other' => q({0} हेक्टोलीटर),
					},
					# Long Unit Identifier
					'volume-liter' => {
						'1' => q(neuter),
						'one' => q({0} लीटर),
						'other' => q({0} लीटर),
						'per' => q({0} दर लीटर),
					},
					# Core Unit Identifier
					'liter' => {
						'1' => q(neuter),
						'one' => q({0} लीटर),
						'other' => q({0} लीटर),
						'per' => q({0} दर लीटर),
					},
					# Long Unit Identifier
					'volume-megaliter' => {
						'1' => q(neuter),
						'name' => q(मेगालीटर),
						'one' => q({0} मेगालीटर),
						'other' => q({0} मेगालीटर),
					},
					# Core Unit Identifier
					'megaliter' => {
						'1' => q(neuter),
						'name' => q(मेगालीटर),
						'one' => q({0} मेगालीटर),
						'other' => q({0} मेगालीटर),
					},
					# Long Unit Identifier
					'volume-milliliter' => {
						'1' => q(neuter),
						'name' => q(मिलीलीटर),
						'one' => q({0} मिलीलीटर),
						'other' => q({0} मिलीलीटर),
					},
					# Core Unit Identifier
					'milliliter' => {
						'1' => q(neuter),
						'name' => q(मिलीलीटर),
						'one' => q({0} मिलीलीटर),
						'other' => q({0} मिलीलीटर),
					},
					# Long Unit Identifier
					'volume-pint' => {
						'one' => q({0} पिंट),
						'other' => q({0} पिंट),
					},
					# Core Unit Identifier
					'pint' => {
						'one' => q({0} पिंट),
						'other' => q({0} पिंट),
					},
					# Long Unit Identifier
					'volume-pint-metric' => {
						'1' => q(neuter),
						'name' => q(मेट्रिक पिंट),
						'one' => q({0} मेट्रिक पिंट),
						'other' => q({0} मेट्रिक पिंट),
					},
					# Core Unit Identifier
					'pint-metric' => {
						'1' => q(neuter),
						'name' => q(मेट्रिक पिंट),
						'one' => q({0} मेट्रिक पिंट),
						'other' => q({0} मेट्रिक पिंट),
					},
					# Long Unit Identifier
					'volume-quart' => {
						'name' => q(क्वार्ट),
						'one' => q({0} क्वार्ट),
						'other' => q({0} क्वार्ट),
					},
					# Core Unit Identifier
					'quart' => {
						'name' => q(क्वार्ट),
						'one' => q({0} क्वार्ट),
						'other' => q({0} क्वार्ट),
					},
					# Long Unit Identifier
					'volume-quart-imperial' => {
						'name' => q(इंपि. क्वार्ट),
						'one' => q({0} इंपि. क्वार्ट),
						'other' => q({0} इंपि. क्वार्ट),
					},
					# Core Unit Identifier
					'quart-imperial' => {
						'name' => q(इंपि. क्वार्ट),
						'one' => q({0} इंपि. क्वार्ट),
						'other' => q({0} इंपि. क्वार्ट),
					},
					# Long Unit Identifier
					'volume-tablespoon' => {
						'name' => q(टेबलस्पून),
						'one' => q({0} टेबलस्पून),
						'other' => q({0} टेबलस्पून),
					},
					# Core Unit Identifier
					'tablespoon' => {
						'name' => q(टेबलस्पून),
						'one' => q({0} टेबलस्पून),
						'other' => q({0} टेबलस्पून),
					},
					# Long Unit Identifier
					'volume-teaspoon' => {
						'name' => q(टीस्पून),
						'one' => q({0} टीस्पून),
						'other' => q({0} टीस्पून),
					},
					# Core Unit Identifier
					'teaspoon' => {
						'name' => q(टीस्पून),
						'one' => q({0} टीस्पून),
						'other' => q({0} टीस्पून),
					},
				},
				'narrow' => {
					# Long Unit Identifier
					'10p-1' => {
						'1' => q(डे{0}),
					},
					# Core Unit Identifier
					'1' => {
						'1' => q(डे{0}),
					},
					# Long Unit Identifier
					'10p-21' => {
						'1' => q(झे{0}),
					},
					# Core Unit Identifier
					'21' => {
						'1' => q(झे{0}),
					},
					# Long Unit Identifier
					'10p-24' => {
						'1' => q(यो{0}),
					},
					# Core Unit Identifier
					'24' => {
						'1' => q(यो{0}),
					},
					# Long Unit Identifier
					'10p-27' => {
						'1' => q(r{0}),
					},
					# Core Unit Identifier
					'27' => {
						'1' => q(r{0}),
					},
					# Long Unit Identifier
					'10p-30' => {
						'1' => q(q{0}),
					},
					# Core Unit Identifier
					'30' => {
						'1' => q(q{0}),
					},
					# Long Unit Identifier
					'10p21' => {
						'1' => q(झे{0}),
					},
					# Core Unit Identifier
					'10p21' => {
						'1' => q(झे{0}),
					},
					# Long Unit Identifier
					'10p24' => {
						'1' => q(यो{0}),
					},
					# Core Unit Identifier
					'10p24' => {
						'1' => q(यो{0}),
					},
					# Long Unit Identifier
					'10p27' => {
						'1' => q(रों{0}),
					},
					# Core Unit Identifier
					'10p27' => {
						'1' => q(रों{0}),
					},
					# Long Unit Identifier
					'10p30' => {
						'1' => q(क्वे{0}),
					},
					# Core Unit Identifier
					'10p30' => {
						'1' => q(क्वे{0}),
					},
					# Long Unit Identifier
					'acceleration-g-force' => {
						'one' => q({0}जी),
						'other' => q({0}जी),
					},
					# Core Unit Identifier
					'g-force' => {
						'one' => q({0}जी),
						'other' => q({0}जी),
					},
					# Long Unit Identifier
					'angle-arc-minute' => {
						'one' => q({0}′),
						'other' => q({0}'),
					},
					# Core Unit Identifier
					'arc-minute' => {
						'one' => q({0}′),
						'other' => q({0}'),
					},
					# Long Unit Identifier
					'angle-arc-second' => {
						'one' => q({0}″),
						'other' => q({0}"),
					},
					# Core Unit Identifier
					'arc-second' => {
						'one' => q({0}″),
						'other' => q({0}"),
					},
					# Long Unit Identifier
					'angle-degree' => {
						'one' => q({0}°),
						'other' => q({0}°),
					},
					# Core Unit Identifier
					'degree' => {
						'one' => q({0}°),
						'other' => q({0}°),
					},
					# Long Unit Identifier
					'area-acre' => {
						'one' => q({0}एकर),
						'other' => q({0}एकर),
					},
					# Core Unit Identifier
					'acre' => {
						'one' => q({0}एकर),
						'other' => q({0}एकर),
					},
					# Long Unit Identifier
					'area-hectare' => {
						'one' => q({0}हेक्टर),
						'other' => q({0}हेक्टर),
					},
					# Core Unit Identifier
					'hectare' => {
						'one' => q({0}हेक्टर),
						'other' => q({0}हेक्टर),
					},
					# Long Unit Identifier
					'area-square-centimeter' => {
						'per' => q({0}/सेंमी²),
					},
					# Core Unit Identifier
					'square-centimeter' => {
						'per' => q({0}/सेंमी²),
					},
					# Long Unit Identifier
					'area-square-foot' => {
						'name' => q(फूट²),
						'one' => q({0} फूट²),
						'other' => q({0}फूट²),
					},
					# Core Unit Identifier
					'square-foot' => {
						'name' => q(फूट²),
						'one' => q({0} फूट²),
						'other' => q({0}फूट²),
					},
					# Long Unit Identifier
					'area-square-kilometer' => {
						'per' => q({0}/किमी²),
					},
					# Core Unit Identifier
					'square-kilometer' => {
						'per' => q({0}/किमी²),
					},
					# Long Unit Identifier
					'area-square-mile' => {
						'name' => q(मै²),
						'one' => q({0}मै²),
						'other' => q({0}मै²),
						'per' => q({0}/मै²),
					},
					# Core Unit Identifier
					'square-mile' => {
						'name' => q(मै²),
						'one' => q({0}मै²),
						'other' => q({0}मै²),
						'per' => q({0}/मै²),
					},
					# Long Unit Identifier
					'concentr-item' => {
						'one' => q({0}आयटम),
						'other' => q({0}आयटम),
					},
					# Core Unit Identifier
					'item' => {
						'one' => q({0}आयटम),
						'other' => q({0}आयटम),
					},
					# Long Unit Identifier
					'concentr-millimole-per-liter' => {
						'name' => q(मिलीमो./लि.),
						'one' => q({0}मिलीमो./लि.),
						'other' => q({0}मिलीमो./लि.),
					},
					# Core Unit Identifier
					'millimole-per-liter' => {
						'name' => q(मिलीमो./लि.),
						'one' => q({0}मिलीमो./लि.),
						'other' => q({0}मिलीमो./लि.),
					},
					# Long Unit Identifier
					'concentr-percent' => {
						'name' => q(%),
					},
					# Core Unit Identifier
					'percent' => {
						'name' => q(%),
					},
					# Long Unit Identifier
					'concentr-permillion' => {
						'name' => q(ppm),
						'one' => q({0}ppm),
						'other' => q({0}ppm),
					},
					# Core Unit Identifier
					'permillion' => {
						'name' => q(ppm),
						'one' => q({0}ppm),
						'other' => q({0}ppm),
					},
					# Long Unit Identifier
					'consumption-mile-per-gallon' => {
						'one' => q({0}mpg),
						'other' => q({0}mpg),
					},
					# Core Unit Identifier
					'mile-per-gallon' => {
						'one' => q({0}mpg),
						'other' => q({0}mpg),
					},
					# Long Unit Identifier
					'consumption-mile-per-gallon-imperial' => {
						'name' => q(mpg UK),
						'one' => q({0}m/gUK),
						'other' => q({0}m/gUK),
					},
					# Core Unit Identifier
					'mile-per-gallon-imperial' => {
						'name' => q(mpg UK),
						'one' => q({0}m/gUK),
						'other' => q({0}m/gUK),
					},
					# Long Unit Identifier
					'digital-byte' => {
						'name' => q(B),
						'one' => q({0}B),
						'other' => q({0}B),
					},
					# Core Unit Identifier
					'byte' => {
						'name' => q(B),
						'one' => q({0}B),
						'other' => q({0}B),
					},
					# Long Unit Identifier
					'digital-gigabit' => {
						'name' => q(Gb),
						'one' => q({0}Gb),
						'other' => q({0}Gb),
					},
					# Core Unit Identifier
					'gigabit' => {
						'name' => q(Gb),
						'one' => q({0}Gb),
						'other' => q({0}Gb),
					},
					# Long Unit Identifier
					'digital-gigabyte' => {
						'name' => q(GB),
						'one' => q({0}GB),
						'other' => q({0}GB),
					},
					# Core Unit Identifier
					'gigabyte' => {
						'name' => q(GB),
						'one' => q({0}GB),
						'other' => q({0}GB),
					},
					# Long Unit Identifier
					'digital-kilobit' => {
						'name' => q(kb),
						'one' => q({0}kb),
						'other' => q({0}kb),
					},
					# Core Unit Identifier
					'kilobit' => {
						'name' => q(kb),
						'one' => q({0}kb),
						'other' => q({0}kb),
					},
					# Long Unit Identifier
					'digital-kilobyte' => {
						'name' => q(kB),
						'one' => q({0}kB),
						'other' => q({0}kB),
					},
					# Core Unit Identifier
					'kilobyte' => {
						'name' => q(kB),
						'one' => q({0}kB),
						'other' => q({0}kB),
					},
					# Long Unit Identifier
					'digital-megabit' => {
						'name' => q(Mb),
						'one' => q({0}Mb),
						'other' => q({0}Mb),
					},
					# Core Unit Identifier
					'megabit' => {
						'name' => q(Mb),
						'one' => q({0}Mb),
						'other' => q({0}Mb),
					},
					# Long Unit Identifier
					'digital-megabyte' => {
						'name' => q(MB),
						'one' => q({0}MB),
						'other' => q({0}MB),
					},
					# Core Unit Identifier
					'megabyte' => {
						'name' => q(MB),
						'one' => q({0}MB),
						'other' => q({0}MB),
					},
					# Long Unit Identifier
					'digital-petabyte' => {
						'name' => q(PB),
						'one' => q({0}PB),
						'other' => q({0}PB),
					},
					# Core Unit Identifier
					'petabyte' => {
						'name' => q(PB),
						'one' => q({0}PB),
						'other' => q({0}PB),
					},
					# Long Unit Identifier
					'digital-terabit' => {
						'name' => q(Tb),
						'one' => q({0}Tb),
						'other' => q({0}Tb),
					},
					# Core Unit Identifier
					'terabit' => {
						'name' => q(Tb),
						'one' => q({0}Tb),
						'other' => q({0}Tb),
					},
					# Long Unit Identifier
					'digital-terabyte' => {
						'name' => q(TB),
						'one' => q({0}TB),
						'other' => q({0}TB),
					},
					# Core Unit Identifier
					'terabyte' => {
						'name' => q(TB),
						'one' => q({0}TB),
						'other' => q({0}TB),
					},
					# Long Unit Identifier
					'duration-day' => {
						'one' => q({0}दि),
						'other' => q({0}दि),
					},
					# Core Unit Identifier
					'day' => {
						'one' => q({0}दि),
						'other' => q({0}दि),
					},
					# Long Unit Identifier
					'duration-hour' => {
						'one' => q({0}ता),
						'other' => q({0}ता),
						'per' => q({0}/ता),
					},
					# Core Unit Identifier
					'hour' => {
						'one' => q({0}ता),
						'other' => q({0}ता),
						'per' => q({0}/ता),
					},
					# Long Unit Identifier
					'duration-minute' => {
						'one' => q({0}मि),
						'other' => q({0}मि),
					},
					# Core Unit Identifier
					'minute' => {
						'one' => q({0}मि),
						'other' => q({0}मि),
					},
					# Long Unit Identifier
					'duration-month' => {
						'name' => q(महिना),
						'one' => q({0}म),
						'other' => q({0}म),
					},
					# Core Unit Identifier
					'month' => {
						'name' => q(महिना),
						'one' => q({0}म),
						'other' => q({0}म),
					},
					# Long Unit Identifier
					'duration-nanosecond' => {
						'name' => q(नॅसे),
					},
					# Core Unit Identifier
					'nanosecond' => {
						'name' => q(नॅसे),
					},
					# Long Unit Identifier
					'duration-quarter' => {
						'one' => q({0}ति),
						'other' => q({0}ति),
					},
					# Core Unit Identifier
					'quarter' => {
						'one' => q({0}ति),
						'other' => q({0}ति),
					},
					# Long Unit Identifier
					'duration-second' => {
						'one' => q({0}से),
						'other' => q({0}से),
						'per' => q({0}/से),
					},
					# Core Unit Identifier
					'second' => {
						'one' => q({0}से),
						'other' => q({0}से),
						'per' => q({0}/से),
					},
					# Long Unit Identifier
					'duration-week' => {
						'name' => q(आ),
						'one' => q({0}आ),
						'other' => q({0}आ),
					},
					# Core Unit Identifier
					'week' => {
						'name' => q(आ),
						'one' => q({0}आ),
						'other' => q({0}आ),
					},
					# Long Unit Identifier
					'duration-year' => {
						'name' => q(वर्ष),
						'one' => q({0}व),
						'other' => q({0}व),
					},
					# Core Unit Identifier
					'year' => {
						'name' => q(वर्ष),
						'one' => q({0}व),
						'other' => q({0}व),
					},
					# Long Unit Identifier
					'energy-british-thermal-unit' => {
						'one' => q({0}Btu),
						'other' => q({0}Btu),
					},
					# Core Unit Identifier
					'british-thermal-unit' => {
						'one' => q({0}Btu),
						'other' => q({0}Btu),
					},
					# Long Unit Identifier
					'force-kilowatt-hour-per-100-kilometer' => {
						'one' => q({0}kWh/100km),
						'other' => q({0}kWh/100km),
					},
					# Core Unit Identifier
					'kilowatt-hour-per-100-kilometer' => {
						'one' => q({0}kWh/100km),
						'other' => q({0}kWh/100km),
					},
					# Long Unit Identifier
					'force-newton' => {
						'name' => q(N),
					},
					# Core Unit Identifier
					'newton' => {
						'name' => q(N),
					},
					# Long Unit Identifier
					'force-pound-force' => {
						'name' => q(lbf),
						'one' => q({0}lbf),
						'other' => q({0}lbf),
					},
					# Core Unit Identifier
					'pound-force' => {
						'name' => q(lbf),
						'one' => q({0}lbf),
						'other' => q({0}lbf),
					},
					# Long Unit Identifier
					'graphics-dot-per-centimeter' => {
						'name' => q(प्र सें बिं),
						'one' => q({0} प्र सें बिं),
						'other' => q({0} पि प्र सेंमी),
					},
					# Core Unit Identifier
					'dot-per-centimeter' => {
						'name' => q(प्र सें बिं),
						'one' => q({0} प्र सें बिं),
						'other' => q({0} पि प्र सेंमी),
					},
					# Long Unit Identifier
					'graphics-dot-per-inch' => {
						'one' => q({0} प्र इं बिं),
						'other' => q({0} प्र इं बिं),
					},
					# Core Unit Identifier
					'dot-per-inch' => {
						'one' => q({0} प्र इं बिं),
						'other' => q({0} प्र इं बिं),
					},
					# Long Unit Identifier
					'graphics-pixel-per-centimeter' => {
						'one' => q({0}ppcm),
						'other' => q({0}ppcm),
					},
					# Core Unit Identifier
					'pixel-per-centimeter' => {
						'one' => q({0}ppcm),
						'other' => q({0}ppcm),
					},
					# Long Unit Identifier
					'length-centimeter' => {
						'one' => q({0}सेंमी),
						'other' => q({0}सेंमी),
					},
					# Core Unit Identifier
					'centimeter' => {
						'one' => q({0}सेंमी),
						'other' => q({0}सेंमी),
					},
					# Long Unit Identifier
					'length-foot' => {
						'one' => q({0}'),
						'other' => q({0}'),
					},
					# Core Unit Identifier
					'foot' => {
						'one' => q({0}'),
						'other' => q({0}'),
					},
					# Long Unit Identifier
					'length-inch' => {
						'one' => q({0}″),
						'other' => q({0}″),
					},
					# Core Unit Identifier
					'inch' => {
						'one' => q({0}″),
						'other' => q({0}″),
					},
					# Long Unit Identifier
					'length-kilometer' => {
						'one' => q({0}किमी),
						'other' => q({0}किमी),
					},
					# Core Unit Identifier
					'kilometer' => {
						'one' => q({0}किमी),
						'other' => q({0}किमी),
					},
					# Long Unit Identifier
					'length-light-year' => {
						'one' => q({0}प्रव),
						'other' => q({0}प्रव),
					},
					# Core Unit Identifier
					'light-year' => {
						'one' => q({0}प्रव),
						'other' => q({0}प्रव),
					},
					# Long Unit Identifier
					'length-meter' => {
						'one' => q({0}मी),
						'other' => q({0}मी),
					},
					# Core Unit Identifier
					'meter' => {
						'one' => q({0}मी),
						'other' => q({0}मी),
					},
					# Long Unit Identifier
					'length-mile' => {
						'one' => q({0}मैल),
						'other' => q({0}मैल),
					},
					# Core Unit Identifier
					'mile' => {
						'one' => q({0}मैल),
						'other' => q({0}मैल),
					},
					# Long Unit Identifier
					'length-millimeter' => {
						'one' => q({0}मिमी),
						'other' => q({0}मिमी),
					},
					# Core Unit Identifier
					'millimeter' => {
						'one' => q({0}मिमी),
						'other' => q({0}मिमी),
					},
					# Long Unit Identifier
					'length-picometer' => {
						'one' => q({0}पिमी),
						'other' => q({0}पिमी),
					},
					# Core Unit Identifier
					'picometer' => {
						'one' => q({0}पिमी),
						'other' => q({0}पिमी),
					},
					# Long Unit Identifier
					'length-yard' => {
						'one' => q({0}यार्ड),
						'other' => q({0}यार्ड),
					},
					# Core Unit Identifier
					'yard' => {
						'one' => q({0}यार्ड),
						'other' => q({0}यार्ड),
					},
					# Long Unit Identifier
					'light-solar-luminosity' => {
						'name' => q(L☉),
					},
					# Core Unit Identifier
					'solar-luminosity' => {
						'name' => q(L☉),
					},
					# Long Unit Identifier
					'mass-earth-mass' => {
						'name' => q(M⊕),
					},
					# Core Unit Identifier
					'earth-mass' => {
						'name' => q(M⊕),
					},
					# Long Unit Identifier
					'mass-gram' => {
						'one' => q({0}ग्रॅ),
						'other' => q({0}ग्रॅ),
					},
					# Core Unit Identifier
					'gram' => {
						'one' => q({0}ग्रॅ),
						'other' => q({0}ग्रॅ),
					},
					# Long Unit Identifier
					'mass-kilogram' => {
						'one' => q({0}किग्रॅ),
						'other' => q({0}किग्रॅ),
					},
					# Core Unit Identifier
					'kilogram' => {
						'one' => q({0}किग्रॅ),
						'other' => q({0}किग्रॅ),
					},
					# Long Unit Identifier
					'mass-ounce' => {
						'one' => q({0}औंस),
						'other' => q({0}औंस),
					},
					# Core Unit Identifier
					'ounce' => {
						'one' => q({0}औंस),
						'other' => q({0}औंस),
					},
					# Long Unit Identifier
					'mass-ounce-troy' => {
						'name' => q(oz t),
					},
					# Core Unit Identifier
					'ounce-troy' => {
						'name' => q(oz t),
					},
					# Long Unit Identifier
					'mass-pound' => {
						'one' => q({0}#),
						'other' => q({0}#),
					},
					# Core Unit Identifier
					'pound' => {
						'one' => q({0}#),
						'other' => q({0}#),
					},
					# Long Unit Identifier
					'mass-solar-mass' => {
						'name' => q(M☉),
					},
					# Core Unit Identifier
					'solar-mass' => {
						'name' => q(M☉),
					},
					# Long Unit Identifier
					'mass-stone' => {
						'one' => q({0}स्टोन),
						'other' => q({0}स्टोन),
					},
					# Core Unit Identifier
					'stone' => {
						'one' => q({0}स्टोन),
						'other' => q({0}स्टोन),
					},
					# Long Unit Identifier
					'power-horsepower' => {
						'one' => q({0} हॉपॉ),
						'other' => q({0}हॉपॉ),
					},
					# Core Unit Identifier
					'horsepower' => {
						'one' => q({0} हॉपॉ),
						'other' => q({0}हॉपॉ),
					},
					# Long Unit Identifier
					'power-kilowatt' => {
						'one' => q({0}किवॉ),
						'other' => q({0}किवॉ),
					},
					# Core Unit Identifier
					'kilowatt' => {
						'one' => q({0}किवॉ),
						'other' => q({0}किवॉ),
					},
					# Long Unit Identifier
					'power-watt' => {
						'one' => q({0}वॉ),
						'other' => q({0}वॉ),
					},
					# Core Unit Identifier
					'watt' => {
						'one' => q({0}वॉ),
						'other' => q({0}वॉ),
					},
					# Long Unit Identifier
					'pressure-hectopascal' => {
						'one' => q({0}हेक्टोपा),
						'other' => q({0}हेक्टोपा),
					},
					# Core Unit Identifier
					'hectopascal' => {
						'one' => q({0}हेक्टोपा),
						'other' => q({0}हेक्टोपा),
					},
					# Long Unit Identifier
					'pressure-inch-ofhg' => {
						'name' => q(″ हेग्रॅ),
						'one' => q({0}" हेग्रॅ),
						'other' => q({0}" हेग्रॅ),
					},
					# Core Unit Identifier
					'inch-ofhg' => {
						'name' => q(″ हेग्रॅ),
						'one' => q({0}" हेग्रॅ),
						'other' => q({0}" हेग्रॅ),
					},
					# Long Unit Identifier
					'pressure-millibar' => {
						'one' => q({0}मिबा),
						'other' => q({0}मिबा),
					},
					# Core Unit Identifier
					'millibar' => {
						'one' => q({0}मिबा),
						'other' => q({0}मिबा),
					},
					# Long Unit Identifier
					'pressure-millimeter-ofhg' => {
						'one' => q({0}mmHg),
						'other' => q({0}mmHg),
					},
					# Core Unit Identifier
					'millimeter-ofhg' => {
						'one' => q({0}mmHg),
						'other' => q({0}mmHg),
					},
					# Long Unit Identifier
					'pressure-pound-force-per-square-inch' => {
						'one' => q({0}psi),
						'other' => q({0}psi),
					},
					# Core Unit Identifier
					'pound-force-per-square-inch' => {
						'one' => q({0}psi),
						'other' => q({0}psi),
					},
					# Long Unit Identifier
					'speed-beaufort' => {
						'one' => q(B{0}),
						'other' => q(B {0}),
					},
					# Core Unit Identifier
					'beaufort' => {
						'one' => q(B{0}),
						'other' => q(B {0}),
					},
					# Long Unit Identifier
					'speed-kilometer-per-hour' => {
						'one' => q({0}किप्रता),
						'other' => q({0}किप्रता),
					},
					# Core Unit Identifier
					'kilometer-per-hour' => {
						'one' => q({0}किप्रता),
						'other' => q({0}किप्रता),
					},
					# Long Unit Identifier
					'speed-meter-per-second' => {
						'one' => q({0}मी/से),
						'other' => q({0}मी/से),
					},
					# Core Unit Identifier
					'meter-per-second' => {
						'one' => q({0}मी/से),
						'other' => q({0}मी/से),
					},
					# Long Unit Identifier
					'speed-mile-per-hour' => {
						'one' => q({0}मैप्रता),
						'other' => q({0}मैप्रता),
					},
					# Core Unit Identifier
					'mile-per-hour' => {
						'one' => q({0}मैप्रता),
						'other' => q({0}मैप्रता),
					},
					# Long Unit Identifier
					'temperature-celsius' => {
						'name' => q(°से),
					},
					# Core Unit Identifier
					'celsius' => {
						'name' => q(°से),
					},
					# Long Unit Identifier
					'temperature-fahrenheit' => {
						'name' => q(°फॅ),
						'one' => q({0}°),
						'other' => q({0}°),
					},
					# Core Unit Identifier
					'fahrenheit' => {
						'name' => q(°फॅ),
						'one' => q({0}°),
						'other' => q({0}°),
					},
					# Long Unit Identifier
					'volume-cubic-kilometer' => {
						'one' => q({0}किमी³),
						'other' => q({0}किमी³),
					},
					# Core Unit Identifier
					'cubic-kilometer' => {
						'one' => q({0}किमी³),
						'other' => q({0}किमी³),
					},
					# Long Unit Identifier
					'volume-cubic-mile' => {
						'one' => q({0}मै³),
						'other' => q({0}मै³),
					},
					# Core Unit Identifier
					'cubic-mile' => {
						'one' => q({0}मै³),
						'other' => q({0}मै³),
					},
					# Long Unit Identifier
					'volume-dessert-spoon-imperial' => {
						'one' => q({0}dsp-Imp),
						'other' => q({0}dsp-Imp),
					},
					# Core Unit Identifier
					'dessert-spoon-imperial' => {
						'one' => q({0}dsp-Imp),
						'other' => q({0}dsp-Imp),
					},
					# Long Unit Identifier
					'volume-dram' => {
						'name' => q(fl.dr.),
						'one' => q({0}fl.dr.),
						'other' => q({0}fl.dr.),
					},
					# Core Unit Identifier
					'dram' => {
						'name' => q(fl.dr.),
						'one' => q({0}fl.dr.),
						'other' => q({0}fl.dr.),
					},
					# Long Unit Identifier
					'volume-fluid-ounce-imperial' => {
						'one' => q({0}fl oz Im),
						'other' => q({0}fl oz Im),
					},
					# Core Unit Identifier
					'fluid-ounce-imperial' => {
						'one' => q({0}fl oz Im),
						'other' => q({0}fl oz Im),
					},
					# Long Unit Identifier
					'volume-liter' => {
						'one' => q({0}ली),
						'other' => q({0}ली),
					},
					# Core Unit Identifier
					'liter' => {
						'one' => q({0}ली),
						'other' => q({0}ली),
					},
					# Long Unit Identifier
					'volume-quart-imperial' => {
						'one' => q({0}qt-Imp.),
						'other' => q({0}qt-Imp.),
					},
					# Core Unit Identifier
					'quart-imperial' => {
						'one' => q({0}qt-Imp.),
						'other' => q({0}qt-Imp.),
					},
				},
				'short' => {
					# Long Unit Identifier
					'' => {
						'name' => q(दिशा),
					},
					# Core Unit Identifier
					'' => {
						'name' => q(दिशा),
					},
					# Long Unit Identifier
					'10p-1' => {
						'1' => q(डेस{0}),
					},
					# Core Unit Identifier
					'1' => {
						'1' => q(डेस{0}),
					},
					# Long Unit Identifier
					'10p-12' => {
						'1' => q(पि{0}),
					},
					# Core Unit Identifier
					'12' => {
						'1' => q(पि{0}),
					},
					# Long Unit Identifier
					'10p-15' => {
						'1' => q(फे{0}),
					},
					# Core Unit Identifier
					'15' => {
						'1' => q(फे{0}),
					},
					# Long Unit Identifier
					'10p-18' => {
						'1' => q(अ‍ॅ{0}),
					},
					# Core Unit Identifier
					'18' => {
						'1' => q(अ‍ॅ{0}),
					},
					# Long Unit Identifier
					'10p-2' => {
						'1' => q(से{0}),
					},
					# Core Unit Identifier
					'2' => {
						'1' => q(से{0}),
					},
					# Long Unit Identifier
					'10p-21' => {
						'1' => q(झेप{0}),
					},
					# Core Unit Identifier
					'21' => {
						'1' => q(झेप{0}),
					},
					# Long Unit Identifier
					'10p-24' => {
						'1' => q(योक{0}),
					},
					# Core Unit Identifier
					'24' => {
						'1' => q(योक{0}),
					},
					# Long Unit Identifier
					'10p-27' => {
						'1' => q(रों{0}),
					},
					# Core Unit Identifier
					'27' => {
						'1' => q(रों{0}),
					},
					# Long Unit Identifier
					'10p-3' => {
						'1' => q(मि{0}),
					},
					# Core Unit Identifier
					'3' => {
						'1' => q(मि{0}),
					},
					# Long Unit Identifier
					'10p-30' => {
						'1' => q(क्वे{0}),
					},
					# Core Unit Identifier
					'30' => {
						'1' => q(क्वे{0}),
					},
					# Long Unit Identifier
					'10p-9' => {
						'1' => q(नॅ{0}),
					},
					# Core Unit Identifier
					'9' => {
						'1' => q(नॅ{0}),
					},
					# Long Unit Identifier
					'10p1' => {
						'1' => q(डे{0}),
					},
					# Core Unit Identifier
					'10p1' => {
						'1' => q(डे{0}),
					},
					# Long Unit Identifier
					'10p12' => {
						'1' => q(टे{0}),
					},
					# Core Unit Identifier
					'10p12' => {
						'1' => q(टे{0}),
					},
					# Long Unit Identifier
					'10p15' => {
						'1' => q(पे{0}),
					},
					# Core Unit Identifier
					'10p15' => {
						'1' => q(पे{0}),
					},
					# Long Unit Identifier
					'10p18' => {
						'1' => q(ए{0}),
					},
					# Core Unit Identifier
					'10p18' => {
						'1' => q(ए{0}),
					},
					# Long Unit Identifier
					'10p2' => {
						'1' => q(हे{0}),
					},
					# Core Unit Identifier
					'10p2' => {
						'1' => q(हे{0}),
					},
					# Long Unit Identifier
					'10p21' => {
						'1' => q(झेटा{0}),
					},
					# Core Unit Identifier
					'10p21' => {
						'1' => q(झेटा{0}),
					},
					# Long Unit Identifier
					'10p24' => {
						'1' => q(योट{0}),
					},
					# Core Unit Identifier
					'10p24' => {
						'1' => q(योट{0}),
					},
					# Long Unit Identifier
					'10p3' => {
						'1' => q(कि{0}),
					},
					# Core Unit Identifier
					'10p3' => {
						'1' => q(कि{0}),
					},
					# Long Unit Identifier
					'10p6' => {
						'1' => q(मे{0}),
					},
					# Core Unit Identifier
					'10p6' => {
						'1' => q(मे{0}),
					},
					# Long Unit Identifier
					'10p9' => {
						'1' => q(गी{0}),
					},
					# Core Unit Identifier
					'10p9' => {
						'1' => q(गी{0}),
					},
					# Long Unit Identifier
					'acceleration-g-force' => {
						'name' => q(जी-फोर्स),
					},
					# Core Unit Identifier
					'g-force' => {
						'name' => q(जी-फोर्स),
					},
					# Long Unit Identifier
					'acceleration-meter-per-square-second' => {
						'name' => q(मीटर/सेक²),
						'one' => q({0} मी/से²),
						'other' => q({0} मी/से²),
					},
					# Core Unit Identifier
					'meter-per-square-second' => {
						'name' => q(मीटर/सेक²),
						'one' => q({0} मी/से²),
						'other' => q({0} मी/से²),
					},
					# Long Unit Identifier
					'angle-arc-minute' => {
						'name' => q(आर्कमिनि),
						'one' => q({0} आर्कमिनि),
						'other' => q({0} आर्कमिनि),
					},
					# Core Unit Identifier
					'arc-minute' => {
						'name' => q(आर्कमिनि),
						'one' => q({0} आर्कमिनि),
						'other' => q({0} आर्कमिनि),
					},
					# Long Unit Identifier
					'angle-arc-second' => {
						'name' => q(आर्कसेक),
						'one' => q({0} आर्कसेक),
						'other' => q({0} आर्कसेक),
					},
					# Core Unit Identifier
					'arc-second' => {
						'name' => q(आर्कसेक),
						'one' => q({0} आर्कसेक),
						'other' => q({0} आर्कसेक),
					},
					# Long Unit Identifier
					'angle-degree' => {
						'name' => q(अंश),
						'one' => q({0} अंश),
						'other' => q({0} अंश),
					},
					# Core Unit Identifier
					'degree' => {
						'name' => q(अंश),
						'one' => q({0} अंश),
						'other' => q({0} अंश),
					},
					# Long Unit Identifier
					'angle-radian' => {
						'name' => q(रेडियन),
					},
					# Core Unit Identifier
					'radian' => {
						'name' => q(रेडियन),
					},
					# Long Unit Identifier
					'angle-revolution' => {
						'name' => q(परिभ्र.),
						'one' => q({0} परिभ्र.),
						'other' => q({0} परिभ्र.),
					},
					# Core Unit Identifier
					'revolution' => {
						'name' => q(परिभ्र.),
						'one' => q({0} परिभ्र.),
						'other' => q({0} परिभ्र.),
					},
					# Long Unit Identifier
					'area-acre' => {
						'name' => q(एकर),
						'one' => q({0} एकर),
						'other' => q({0} एकर),
					},
					# Core Unit Identifier
					'acre' => {
						'name' => q(एकर),
						'one' => q({0} एकर),
						'other' => q({0} एकर),
					},
					# Long Unit Identifier
					'area-dunam' => {
						'name' => q(दुनाम),
						'one' => q({0} दुनाम),
						'other' => q({0} दुनाम),
					},
					# Core Unit Identifier
					'dunam' => {
						'name' => q(दुनाम),
						'one' => q({0} दुनाम),
						'other' => q({0} दुनाम),
					},
					# Long Unit Identifier
					'area-hectare' => {
						'name' => q(हेक्टर),
						'one' => q({0} हेक्टर),
						'other' => q({0} हेक्टर),
					},
					# Core Unit Identifier
					'hectare' => {
						'name' => q(हेक्टर),
						'one' => q({0} हेक्टर),
						'other' => q({0} हेक्टर),
					},
					# Long Unit Identifier
					'area-square-centimeter' => {
						'name' => q(सेंमी²),
						'one' => q({0} सेंमी²),
						'other' => q({0} सेंमी²),
					},
					# Core Unit Identifier
					'square-centimeter' => {
						'name' => q(सेंमी²),
						'one' => q({0} सेंमी²),
						'other' => q({0} सेंमी²),
					},
					# Long Unit Identifier
					'area-square-foot' => {
						'name' => q(चौरस फूट),
						'one' => q({0} चौ फूट),
						'other' => q({0} चौ फूट),
					},
					# Core Unit Identifier
					'square-foot' => {
						'name' => q(चौरस फूट),
						'one' => q({0} चौ फूट),
						'other' => q({0} चौ फूट),
					},
					# Long Unit Identifier
					'area-square-inch' => {
						'name' => q(इंच²),
						'one' => q({0} इंच²),
						'other' => q({0} इंच²),
						'per' => q({0}/इंच²),
					},
					# Core Unit Identifier
					'square-inch' => {
						'name' => q(इंच²),
						'one' => q({0} इंच²),
						'other' => q({0} इंच²),
						'per' => q({0}/इंच²),
					},
					# Long Unit Identifier
					'area-square-kilometer' => {
						'name' => q(किमी²),
						'one' => q({0} किमी²),
						'other' => q({0} किमी²),
					},
					# Core Unit Identifier
					'square-kilometer' => {
						'name' => q(किमी²),
						'one' => q({0} किमी²),
						'other' => q({0} किमी²),
					},
					# Long Unit Identifier
					'area-square-meter' => {
						'name' => q(मीटर²),
						'one' => q({0} मी²),
						'other' => q({0} मी²),
						'per' => q({0}/मी²),
					},
					# Core Unit Identifier
					'square-meter' => {
						'name' => q(मीटर²),
						'one' => q({0} मी²),
						'other' => q({0} मी²),
						'per' => q({0}/मी²),
					},
					# Long Unit Identifier
					'area-square-mile' => {
						'name' => q(चौरस मैल),
						'one' => q({0} चौ मै),
						'other' => q({0} चौ मै),
					},
					# Core Unit Identifier
					'square-mile' => {
						'name' => q(चौरस मैल),
						'one' => q({0} चौ मै),
						'other' => q({0} चौ मै),
					},
					# Long Unit Identifier
					'area-square-yard' => {
						'name' => q(यार्ड²),
						'one' => q({0} यार्ड²),
						'other' => q({0} यार्ड²),
					},
					# Core Unit Identifier
					'square-yard' => {
						'name' => q(यार्ड²),
						'one' => q({0} यार्ड²),
						'other' => q({0} यार्ड²),
					},
					# Long Unit Identifier
					'concentr-item' => {
						'name' => q(आयटम),
						'one' => q({0} आयटम),
						'other' => q({0} आयटम),
					},
					# Core Unit Identifier
					'item' => {
						'name' => q(आयटम),
						'one' => q({0} आयटम),
						'other' => q({0} आयटम),
					},
					# Long Unit Identifier
					'concentr-karat' => {
						'name' => q(कॅरेट्स),
					},
					# Core Unit Identifier
					'karat' => {
						'name' => q(कॅरेट्स),
					},
					# Long Unit Identifier
					'concentr-millimole-per-liter' => {
						'name' => q(मिलीमोल/लिटर),
						'one' => q({0} मिलीमो. /लि.),
						'other' => q({0} मिलीमो. /लि.),
					},
					# Core Unit Identifier
					'millimole-per-liter' => {
						'name' => q(मिलीमोल/लिटर),
						'one' => q({0} मिलीमो. /लि.),
						'other' => q({0} मिलीमो. /लि.),
					},
					# Long Unit Identifier
					'concentr-mole' => {
						'name' => q(मोल),
						'one' => q({0} मोल),
						'other' => q({0} मोल),
					},
					# Core Unit Identifier
					'mole' => {
						'name' => q(मोल),
						'one' => q({0} मोल),
						'other' => q({0} मोल),
					},
					# Long Unit Identifier
					'concentr-percent' => {
						'name' => q(टक्के),
					},
					# Core Unit Identifier
					'percent' => {
						'name' => q(टक्के),
					},
					# Long Unit Identifier
					'concentr-permille' => {
						'name' => q(प्रतिमैल),
					},
					# Core Unit Identifier
					'permille' => {
						'name' => q(प्रतिमैल),
					},
					# Long Unit Identifier
					'concentr-permillion' => {
						'name' => q(भाग/दशलक्ष),
					},
					# Core Unit Identifier
					'permillion' => {
						'name' => q(भाग/दशलक्ष),
					},
					# Long Unit Identifier
					'concentr-permyriad' => {
						'name' => q(पर्मिरेड),
					},
					# Core Unit Identifier
					'permyriad' => {
						'name' => q(पर्मिरेड),
					},
					# Long Unit Identifier
					'consumption-liter-per-100-kilometer' => {
						'name' => q(ली/100किमी),
						'one' => q({0} ली/100किमी),
						'other' => q({0} ली/100किमी),
					},
					# Core Unit Identifier
					'liter-per-100-kilometer' => {
						'name' => q(ली/100किमी),
						'one' => q({0} ली/100किमी),
						'other' => q({0} ली/100किमी),
					},
					# Long Unit Identifier
					'consumption-liter-per-kilometer' => {
						'name' => q(लीटर/किमी),
						'one' => q({0} ली/किमी),
						'other' => q({0} ली/किमी),
					},
					# Core Unit Identifier
					'liter-per-kilometer' => {
						'name' => q(लीटर/किमी),
						'one' => q({0} ली/किमी),
						'other' => q({0} ली/किमी),
					},
					# Long Unit Identifier
					'consumption-mile-per-gallon' => {
						'name' => q(मैल/गॅलन),
						'one' => q({0} mpg),
						'other' => q({0} mpg),
					},
					# Core Unit Identifier
					'mile-per-gallon' => {
						'name' => q(मैल/गॅलन),
						'one' => q({0} mpg),
						'other' => q({0} mpg),
					},
					# Long Unit Identifier
					'consumption-mile-per-gallon-imperial' => {
						'name' => q(मैल/गॅलन इम्पि.),
					},
					# Core Unit Identifier
					'mile-per-gallon-imperial' => {
						'name' => q(मैल/गॅलन इम्पि.),
					},
					# Long Unit Identifier
					'coordinate' => {
						'east' => q({0}पू),
						'north' => q({0}उ),
						'south' => q({0}द),
						'west' => q({0}प),
					},
					# Core Unit Identifier
					'coordinate' => {
						'east' => q({0}पू),
						'north' => q({0}उ),
						'south' => q({0}द),
						'west' => q({0}प),
					},
					# Long Unit Identifier
					'digital-bit' => {
						'name' => q(बिट),
						'one' => q({0} बिट),
						'other' => q({0} बिट),
					},
					# Core Unit Identifier
					'bit' => {
						'name' => q(बिट),
						'one' => q({0} बिट),
						'other' => q({0} बिट),
					},
					# Long Unit Identifier
					'digital-byte' => {
						'name' => q(बाइट),
						'one' => q({0} बाइट),
						'other' => q({0} बाइट),
					},
					# Core Unit Identifier
					'byte' => {
						'name' => q(बाइट),
						'one' => q({0} बाइट),
						'other' => q({0} बाइट),
					},
					# Long Unit Identifier
					'digital-gigabit' => {
						'name' => q(Gbit),
					},
					# Core Unit Identifier
					'gigabit' => {
						'name' => q(Gbit),
					},
					# Long Unit Identifier
					'digital-gigabyte' => {
						'name' => q(GByte),
					},
					# Core Unit Identifier
					'gigabyte' => {
						'name' => q(GByte),
					},
					# Long Unit Identifier
					'digital-kilobit' => {
						'name' => q(kbit),
					},
					# Core Unit Identifier
					'kilobit' => {
						'name' => q(kbit),
					},
					# Long Unit Identifier
					'digital-kilobyte' => {
						'name' => q(kByte),
					},
					# Core Unit Identifier
					'kilobyte' => {
						'name' => q(kByte),
					},
					# Long Unit Identifier
					'digital-megabit' => {
						'name' => q(Mbit),
					},
					# Core Unit Identifier
					'megabit' => {
						'name' => q(Mbit),
					},
					# Long Unit Identifier
					'digital-megabyte' => {
						'name' => q(MByte),
					},
					# Core Unit Identifier
					'megabyte' => {
						'name' => q(MByte),
					},
					# Long Unit Identifier
					'digital-petabyte' => {
						'name' => q(PByte),
					},
					# Core Unit Identifier
					'petabyte' => {
						'name' => q(PByte),
					},
					# Long Unit Identifier
					'digital-terabit' => {
						'name' => q(Tbit),
					},
					# Core Unit Identifier
					'terabit' => {
						'name' => q(Tbit),
					},
					# Long Unit Identifier
					'digital-terabyte' => {
						'name' => q(TByte),
					},
					# Core Unit Identifier
					'terabyte' => {
						'name' => q(TByte),
					},
					# Long Unit Identifier
					'duration-century' => {
						'name' => q(श),
						'one' => q({0} श),
						'other' => q({0} श),
					},
					# Core Unit Identifier
					'century' => {
						'name' => q(श),
						'one' => q({0} श),
						'other' => q({0} श),
					},
					# Long Unit Identifier
					'duration-day' => {
						'name' => q(दिवस),
						'one' => q({0} दिवस),
						'other' => q({0} दिवस),
						'per' => q({0}/दि),
					},
					# Core Unit Identifier
					'day' => {
						'name' => q(दिवस),
						'one' => q({0} दिवस),
						'other' => q({0} दिवस),
						'per' => q({0}/दि),
					},
					# Long Unit Identifier
					'duration-decade' => {
						'name' => q(द),
						'one' => q({0} द),
						'other' => q({0} द),
					},
					# Core Unit Identifier
					'decade' => {
						'name' => q(द),
						'one' => q({0} द),
						'other' => q({0} द),
					},
					# Long Unit Identifier
					'duration-hour' => {
						'name' => q(तास),
						'one' => q({0} ता),
						'other' => q({0} ता),
						'per' => q({0}प्रता),
					},
					# Core Unit Identifier
					'hour' => {
						'name' => q(तास),
						'one' => q({0} ता),
						'other' => q({0} ता),
						'per' => q({0}प्रता),
					},
					# Long Unit Identifier
					'duration-millisecond' => {
						'name' => q(मिलिसेकंद),
						'one' => q({0} मिलिसे),
						'other' => q({0} मिलिसे),
					},
					# Core Unit Identifier
					'millisecond' => {
						'name' => q(मिलिसेकंद),
						'one' => q({0} मिलिसे),
						'other' => q({0} मिलिसे),
					},
					# Long Unit Identifier
					'duration-minute' => {
						'name' => q(मिनिटे),
						'one' => q({0} मिनि),
						'other' => q({0} मिनि),
						'per' => q({0}/मिनि),
					},
					# Core Unit Identifier
					'minute' => {
						'name' => q(मिनिटे),
						'one' => q({0} मिनि),
						'other' => q({0} मिनि),
						'per' => q({0}/मिनि),
					},
					# Long Unit Identifier
					'duration-month' => {
						'name' => q(महिने),
						'one' => q({0} महिना),
						'other' => q({0} महिने),
						'per' => q({0}/म),
					},
					# Core Unit Identifier
					'month' => {
						'name' => q(महिने),
						'one' => q({0} महिना),
						'other' => q({0} महिने),
						'per' => q({0}/म),
					},
					# Long Unit Identifier
					'duration-nanosecond' => {
						'name' => q(नॅनोसेक),
						'one' => q({0} नॅसे),
						'other' => q({0} नॅसे),
					},
					# Core Unit Identifier
					'nanosecond' => {
						'name' => q(नॅनोसेक),
						'one' => q({0} नॅसे),
						'other' => q({0} नॅसे),
					},
					# Long Unit Identifier
					'duration-quarter' => {
						'name' => q(तिमाही),
						'one' => q({0} तिमाही),
						'other' => q({0} तिमाही),
						'per' => q({0}/तिमाही),
					},
					# Core Unit Identifier
					'quarter' => {
						'name' => q(तिमाही),
						'one' => q({0} तिमाही),
						'other' => q({0} तिमाही),
						'per' => q({0}/तिमाही),
					},
					# Long Unit Identifier
					'duration-second' => {
						'name' => q(सेकंद),
						'one' => q({0} से),
						'other' => q({0} से),
						'per' => q({0}प्रसे),
					},
					# Core Unit Identifier
					'second' => {
						'name' => q(सेकंद),
						'one' => q({0} से),
						'other' => q({0} से),
						'per' => q({0}प्रसे),
					},
					# Long Unit Identifier
					'duration-week' => {
						'name' => q(आठवडे),
						'one' => q({0} आ),
						'other' => q({0} आ),
						'per' => q({0}/आ),
					},
					# Core Unit Identifier
					'week' => {
						'name' => q(आठवडे),
						'one' => q({0} आ),
						'other' => q({0} आ),
						'per' => q({0}/आ),
					},
					# Long Unit Identifier
					'duration-year' => {
						'name' => q(वर्षे),
						'one' => q({0} वर्ष),
						'other' => q({0} वर्षे),
						'per' => q({0}/वर्षी),
					},
					# Core Unit Identifier
					'year' => {
						'name' => q(वर्षे),
						'one' => q({0} वर्ष),
						'other' => q({0} वर्षे),
						'per' => q({0}/वर्षी),
					},
					# Long Unit Identifier
					'electric-ampere' => {
						'name' => q(अँप्स),
					},
					# Core Unit Identifier
					'ampere' => {
						'name' => q(अँप्स),
					},
					# Long Unit Identifier
					'electric-milliampere' => {
						'name' => q(मिलिअँप्स),
					},
					# Core Unit Identifier
					'milliampere' => {
						'name' => q(मिलिअँप्स),
					},
					# Long Unit Identifier
					'electric-ohm' => {
						'name' => q(ओहम),
					},
					# Core Unit Identifier
					'ohm' => {
						'name' => q(ओहम),
					},
					# Long Unit Identifier
					'electric-volt' => {
						'name' => q(व्होल्ट),
					},
					# Core Unit Identifier
					'volt' => {
						'name' => q(व्होल्ट),
					},
					# Long Unit Identifier
					'energy-british-thermal-unit' => {
						'name' => q(BTU),
						'one' => q({0} बिटीयू),
						'other' => q({0} बिटीयू),
					},
					# Core Unit Identifier
					'british-thermal-unit' => {
						'name' => q(BTU),
						'one' => q({0} बिटीयू),
						'other' => q({0} बिटीयू),
					},
					# Long Unit Identifier
					'energy-electronvolt' => {
						'name' => q(इलेक्ट्रॉनव्होल्ट),
					},
					# Core Unit Identifier
					'electronvolt' => {
						'name' => q(इलेक्ट्रॉनव्होल्ट),
					},
					# Long Unit Identifier
					'energy-foodcalorie' => {
						'name' => q(Cal),
						'one' => q({0} Cal),
						'other' => q({0} Cal),
					},
					# Core Unit Identifier
					'foodcalorie' => {
						'name' => q(Cal),
						'one' => q({0} Cal),
						'other' => q({0} Cal),
					},
					# Long Unit Identifier
					'energy-joule' => {
						'name' => q(ज्यूल),
					},
					# Core Unit Identifier
					'joule' => {
						'name' => q(ज्यूल),
					},
					# Long Unit Identifier
					'energy-kilojoule' => {
						'name' => q(किलोज्यूल),
					},
					# Core Unit Identifier
					'kilojoule' => {
						'name' => q(किलोज्यूल),
					},
					# Long Unit Identifier
					'energy-kilowatt-hour' => {
						'name' => q(kW-तास),
					},
					# Core Unit Identifier
					'kilowatt-hour' => {
						'name' => q(kW-तास),
					},
					# Long Unit Identifier
					'force-newton' => {
						'name' => q(न्यूटन),
					},
					# Core Unit Identifier
					'newton' => {
						'name' => q(न्यूटन),
					},
					# Long Unit Identifier
					'force-pound-force' => {
						'name' => q(पाउंड-फोर्स),
					},
					# Core Unit Identifier
					'pound-force' => {
						'name' => q(पाउंड-फोर्स),
					},
					# Long Unit Identifier
					'graphics-dot-per-inch' => {
						'one' => q(प्र इं {0} पि),
						'other' => q({0} प्र इं बिं),
					},
					# Core Unit Identifier
					'dot-per-inch' => {
						'one' => q(प्र इं {0} पि),
						'other' => q({0} प्र इं बिं),
					},
					# Long Unit Identifier
					'graphics-megapixel' => {
						'name' => q(मे पि),
						'one' => q({0} मे पि),
						'other' => q({0} मे पि),
					},
					# Core Unit Identifier
					'megapixel' => {
						'name' => q(मे पि),
						'one' => q({0} मे पि),
						'other' => q({0} मे पि),
					},
					# Long Unit Identifier
					'graphics-pixel' => {
						'name' => q(पिक्सेल्स),
						'one' => q({0} पि),
						'other' => q({0} पि),
					},
					# Core Unit Identifier
					'pixel' => {
						'name' => q(पिक्सेल्स),
						'one' => q({0} पि),
						'other' => q({0} पि),
					},
					# Long Unit Identifier
					'graphics-pixel-per-centimeter' => {
						'name' => q(पि प्र सेंमी),
						'one' => q({0} पि प्र सेंमी),
						'other' => q({0} पि प्र सेंमी),
					},
					# Core Unit Identifier
					'pixel-per-centimeter' => {
						'name' => q(पि प्र सेंमी),
						'one' => q({0} पि प्र सेंमी),
						'other' => q({0} पि प्र सेंमी),
					},
					# Long Unit Identifier
					'graphics-pixel-per-inch' => {
						'name' => q(पि प्र इं),
						'one' => q({0} पि प्र इं),
						'other' => q({0} पि प्र इं),
					},
					# Core Unit Identifier
					'pixel-per-inch' => {
						'name' => q(पि प्र इं),
						'one' => q({0} पि प्र इं),
						'other' => q({0} पि प्र इं),
					},
					# Long Unit Identifier
					'length-centimeter' => {
						'name' => q(सेंमी),
						'one' => q({0} सेंमी),
						'other' => q({0} सेंमी),
						'per' => q({0}/सेंमी),
					},
					# Core Unit Identifier
					'centimeter' => {
						'name' => q(सेंमी),
						'one' => q({0} सेंमी),
						'other' => q({0} सेंमी),
						'per' => q({0}/सेंमी),
					},
					# Long Unit Identifier
					'length-decimeter' => {
						'name' => q(डेमी),
					},
					# Core Unit Identifier
					'decimeter' => {
						'name' => q(डेमी),
					},
					# Long Unit Identifier
					'length-fathom' => {
						'name' => q(फॅदम),
					},
					# Core Unit Identifier
					'fathom' => {
						'name' => q(फॅदम),
					},
					# Long Unit Identifier
					'length-foot' => {
						'name' => q(फूट),
						'one' => q({0} फूट),
						'other' => q({0} फूट),
						'per' => q({0}/फूट),
					},
					# Core Unit Identifier
					'foot' => {
						'name' => q(फूट),
						'one' => q({0} फूट),
						'other' => q({0} फूट),
						'per' => q({0}/फूट),
					},
					# Long Unit Identifier
					'length-furlong' => {
						'name' => q(फर्लांग),
					},
					# Core Unit Identifier
					'furlong' => {
						'name' => q(फर्लांग),
					},
					# Long Unit Identifier
					'length-inch' => {
						'name' => q(इंच),
						'one' => q({0} इंच),
						'other' => q({0} इंच),
						'per' => q({0}/इंच),
					},
					# Core Unit Identifier
					'inch' => {
						'name' => q(इंच),
						'one' => q({0} इंच),
						'other' => q({0} इंच),
						'per' => q({0}/इंच),
					},
					# Long Unit Identifier
					'length-kilometer' => {
						'name' => q(किमी),
						'one' => q({0} किमी),
						'other' => q({0} किमी),
						'per' => q({0}/किमी),
					},
					# Core Unit Identifier
					'kilometer' => {
						'name' => q(किमी),
						'one' => q({0} किमी),
						'other' => q({0} किमी),
						'per' => q({0}/किमी),
					},
					# Long Unit Identifier
					'length-light-year' => {
						'name' => q(प्रकाश वर्षे),
						'one' => q({0} प्रव),
						'other' => q({0} प्रव),
					},
					# Core Unit Identifier
					'light-year' => {
						'name' => q(प्रकाश वर्षे),
						'one' => q({0} प्रव),
						'other' => q({0} प्रव),
					},
					# Long Unit Identifier
					'length-meter' => {
						'name' => q(मीटर),
						'one' => q({0} मी),
						'other' => q({0} मी),
						'per' => q({0}/मी),
					},
					# Core Unit Identifier
					'meter' => {
						'name' => q(मीटर),
						'one' => q({0} मी),
						'other' => q({0} मी),
						'per' => q({0}/मी),
					},
					# Long Unit Identifier
					'length-micrometer' => {
						'name' => q(मायक्रोमीटर),
					},
					# Core Unit Identifier
					'micrometer' => {
						'name' => q(मायक्रोमीटर),
					},
					# Long Unit Identifier
					'length-mile' => {
						'name' => q(मैल),
						'one' => q({0} मैल),
						'other' => q({0} मैल),
					},
					# Core Unit Identifier
					'mile' => {
						'name' => q(मैल),
						'one' => q({0} मैल),
						'other' => q({0} मैल),
					},
					# Long Unit Identifier
					'length-millimeter' => {
						'name' => q(मिमी),
						'one' => q({0} मिमी),
						'other' => q({0} मिमी),
					},
					# Core Unit Identifier
					'millimeter' => {
						'name' => q(मिमी),
						'one' => q({0} मिमी),
						'other' => q({0} मिमी),
					},
					# Long Unit Identifier
					'length-nanometer' => {
						'name' => q(नॅमी),
						'one' => q({0} नॅमी),
						'other' => q({0} नॅमी),
					},
					# Core Unit Identifier
					'nanometer' => {
						'name' => q(नॅमी),
						'one' => q({0} नॅमी),
						'other' => q({0} नॅमी),
					},
					# Long Unit Identifier
					'length-parsec' => {
						'name' => q(पार्सेक),
					},
					# Core Unit Identifier
					'parsec' => {
						'name' => q(पार्सेक),
					},
					# Long Unit Identifier
					'length-picometer' => {
						'name' => q(पिमी),
						'one' => q({0} पिमी),
						'other' => q({0} पिमी),
					},
					# Core Unit Identifier
					'picometer' => {
						'name' => q(पिमी),
						'one' => q({0} पिमी),
						'other' => q({0} पिमी),
					},
					# Long Unit Identifier
					'length-point' => {
						'name' => q(बिंदु),
						'one' => q({0} बिंदु),
						'other' => q({0} बिंदु),
					},
					# Core Unit Identifier
					'point' => {
						'name' => q(बिंदु),
						'one' => q({0} बिंदु),
						'other' => q({0} बिंदु),
					},
					# Long Unit Identifier
					'length-solar-radius' => {
						'name' => q(सौर त्रिज्या),
					},
					# Core Unit Identifier
					'solar-radius' => {
						'name' => q(सौर त्रिज्या),
					},
					# Long Unit Identifier
					'length-yard' => {
						'name' => q(यार्ड),
						'one' => q({0} यार्ड),
						'other' => q({0} यार्ड),
					},
					# Core Unit Identifier
					'yard' => {
						'name' => q(यार्ड),
						'one' => q({0} यार्ड),
						'other' => q({0} यार्ड),
					},
					# Long Unit Identifier
					'light-lux' => {
						'name' => q(लक्स),
					},
					# Core Unit Identifier
					'lux' => {
						'name' => q(लक्स),
					},
					# Long Unit Identifier
					'light-solar-luminosity' => {
						'name' => q(सौर प्रकाश),
					},
					# Core Unit Identifier
					'solar-luminosity' => {
						'name' => q(सौर प्रकाश),
					},
					# Long Unit Identifier
					'mass-carat' => {
						'name' => q(कॅरेट्स),
					},
					# Core Unit Identifier
					'carat' => {
						'name' => q(कॅरेट्स),
					},
					# Long Unit Identifier
					'mass-dalton' => {
						'name' => q(डाल्टन),
						'one' => q({0} डाल्टन),
						'other' => q({0} डाल्टन),
					},
					# Core Unit Identifier
					'dalton' => {
						'name' => q(डाल्टन),
						'one' => q({0} डाल्टन),
						'other' => q({0} डाल्टन),
					},
					# Long Unit Identifier
					'mass-earth-mass' => {
						'name' => q(पृथ्वी द्रव्यमान),
					},
					# Core Unit Identifier
					'earth-mass' => {
						'name' => q(पृथ्वी द्रव्यमान),
					},
					# Long Unit Identifier
					'mass-grain' => {
						'name' => q(अल्पांश),
						'one' => q({0} अल्पांश),
						'other' => q({0} अल्पांश),
					},
					# Core Unit Identifier
					'grain' => {
						'name' => q(अल्पांश),
						'one' => q({0} अल्पांश),
						'other' => q({0} अल्पांश),
					},
					# Long Unit Identifier
					'mass-gram' => {
						'name' => q(ग्रॅम),
						'one' => q({0} ग्रॅ),
						'other' => q({0} ग्रॅ),
						'per' => q({0}/ग्रॅ),
					},
					# Core Unit Identifier
					'gram' => {
						'name' => q(ग्रॅम),
						'one' => q({0} ग्रॅ),
						'other' => q({0} ग्रॅ),
						'per' => q({0}/ग्रॅ),
					},
					# Long Unit Identifier
					'mass-kilogram' => {
						'name' => q(किग्रॅ),
						'one' => q({0} किग्रॅ),
						'other' => q({0} किग्रॅ),
						'per' => q({0}/किग्रॅ),
					},
					# Core Unit Identifier
					'kilogram' => {
						'name' => q(किग्रॅ),
						'one' => q({0} किग्रॅ),
						'other' => q({0} किग्रॅ),
						'per' => q({0}/किग्रॅ),
					},
					# Long Unit Identifier
					'mass-milligram' => {
						'name' => q(मिग्रॅ),
						'one' => q({0} मिग्रॅ),
						'other' => q({0} मिग्रॅ),
					},
					# Core Unit Identifier
					'milligram' => {
						'name' => q(मिग्रॅ),
						'one' => q({0} मिग्रॅ),
						'other' => q({0} मिग्रॅ),
					},
					# Long Unit Identifier
					'mass-ounce' => {
						'name' => q(औंस),
						'one' => q({0} औंस),
						'other' => q({0} औंस),
					},
					# Core Unit Identifier
					'ounce' => {
						'name' => q(औंस),
						'one' => q({0} औंस),
						'other' => q({0} औंस),
					},
					# Long Unit Identifier
					'mass-ounce-troy' => {
						'name' => q(oz ट्रॉय),
					},
					# Core Unit Identifier
					'ounce-troy' => {
						'name' => q(oz ट्रॉय),
					},
					# Long Unit Identifier
					'mass-pound' => {
						'name' => q(पाउंड),
						'one' => q({0} पाउंड),
						'other' => q({0} पाउंड),
					},
					# Core Unit Identifier
					'pound' => {
						'name' => q(पाउंड),
						'one' => q({0} पाउंड),
						'other' => q({0} पाउंड),
					},
					# Long Unit Identifier
					'mass-solar-mass' => {
						'name' => q(सौर द्रव्यमान),
					},
					# Core Unit Identifier
					'solar-mass' => {
						'name' => q(सौर द्रव्यमान),
					},
					# Long Unit Identifier
					'mass-stone' => {
						'name' => q(स्टोन),
						'one' => q({0} स्टोन),
						'other' => q({0} स्टोन),
					},
					# Core Unit Identifier
					'stone' => {
						'name' => q(स्टोन),
						'one' => q({0} स्टोन),
						'other' => q({0} स्टोन),
					},
					# Long Unit Identifier
					'mass-ton' => {
						'name' => q(टन),
						'one' => q({0} टन),
						'other' => q({0} टन),
					},
					# Core Unit Identifier
					'ton' => {
						'name' => q(टन),
						'one' => q({0} टन),
						'other' => q({0} टन),
					},
					# Long Unit Identifier
					'power-kilowatt' => {
						'name' => q(किवॉ),
						'one' => q({0} किवॉ),
						'other' => q({0} किवॉ),
					},
					# Core Unit Identifier
					'kilowatt' => {
						'name' => q(किवॉ),
						'one' => q({0} किवॉ),
						'other' => q({0} किवॉ),
					},
					# Long Unit Identifier
					'power-watt' => {
						'name' => q(वॉट),
						'one' => q({0} वॉ),
						'other' => q({0} वॉ),
					},
					# Core Unit Identifier
					'watt' => {
						'name' => q(वॉट),
						'one' => q({0} वॉ),
						'other' => q({0} वॉ),
					},
					# Long Unit Identifier
					'pressure-bar' => {
						'name' => q(बार),
						'one' => q({0} बार),
						'other' => q({0} बार),
					},
					# Core Unit Identifier
					'bar' => {
						'name' => q(बार),
						'one' => q({0} बार),
						'other' => q({0} बार),
					},
					# Long Unit Identifier
					'pressure-inch-ofhg' => {
						'name' => q(in Hg),
					},
					# Core Unit Identifier
					'inch-ofhg' => {
						'name' => q(in Hg),
					},
					# Long Unit Identifier
					'pressure-millibar' => {
						'name' => q(मिलिबार),
					},
					# Core Unit Identifier
					'millibar' => {
						'name' => q(मिलिबार),
					},
					# Long Unit Identifier
					'speed-beaufort' => {
						'one' => q({0} ब्यु),
						'other' => q(B {0}),
					},
					# Core Unit Identifier
					'beaufort' => {
						'one' => q({0} ब्यु),
						'other' => q(B {0}),
					},
					# Long Unit Identifier
					'speed-kilometer-per-hour' => {
						'name' => q(किमी/तास),
						'one' => q({0} किप्रता),
						'other' => q({0} किप्रता),
					},
					# Core Unit Identifier
					'kilometer-per-hour' => {
						'name' => q(किमी/तास),
						'one' => q({0} किप्रता),
						'other' => q({0} किप्रता),
					},
					# Long Unit Identifier
					'speed-meter-per-second' => {
						'name' => q(मीटर/सेक),
						'one' => q({0} मी/से),
						'other' => q({0} मी/से),
					},
					# Core Unit Identifier
					'meter-per-second' => {
						'name' => q(मीटर/सेक),
						'one' => q({0} मी/से),
						'other' => q({0} मी/से),
					},
					# Long Unit Identifier
					'speed-mile-per-hour' => {
						'name' => q(मैल/तास),
						'one' => q({0} मैप्रता),
						'other' => q({0} मैप्रता),
					},
					# Core Unit Identifier
					'mile-per-hour' => {
						'name' => q(मैल/तास),
						'one' => q({0} मैप्रता),
						'other' => q({0} मैप्रता),
					},
					# Long Unit Identifier
					'temperature-celsius' => {
						'name' => q(अंश सेल्सिअस),
						'one' => q({0}°से),
						'other' => q({0}°से),
					},
					# Core Unit Identifier
					'celsius' => {
						'name' => q(अंश सेल्सिअस),
						'one' => q({0}°से),
						'other' => q({0}°से),
					},
					# Long Unit Identifier
					'temperature-fahrenheit' => {
						'name' => q(अंश फॅरनहाईट),
						'one' => q({0}°फॅ),
						'other' => q({0}°फॅ),
					},
					# Core Unit Identifier
					'fahrenheit' => {
						'name' => q(अंश फॅरनहाईट),
						'one' => q({0}°फॅ),
						'other' => q({0}°फॅ),
					},
					# Long Unit Identifier
					'temperature-kelvin' => {
						'name' => q(केल्व्हिन),
					},
					# Core Unit Identifier
					'kelvin' => {
						'name' => q(केल्व्हिन),
					},
					# Long Unit Identifier
					'volume-barrel' => {
						'name' => q(बॅरल),
					},
					# Core Unit Identifier
					'barrel' => {
						'name' => q(बॅरल),
					},
					# Long Unit Identifier
					'volume-bushel' => {
						'name' => q(बुशेल),
					},
					# Core Unit Identifier
					'bushel' => {
						'name' => q(बुशेल),
					},
					# Long Unit Identifier
					'volume-cubic-centimeter' => {
						'name' => q(सेंमी³),
						'one' => q({0} सेंमी³),
						'other' => q({0} सेंमी³),
						'per' => q({0}/सेंमी³),
					},
					# Core Unit Identifier
					'cubic-centimeter' => {
						'name' => q(सेंमी³),
						'one' => q({0} सेंमी³),
						'other' => q({0} सेंमी³),
						'per' => q({0}/सेंमी³),
					},
					# Long Unit Identifier
					'volume-cubic-foot' => {
						'name' => q(फूट³),
						'one' => q({0} फूट³),
						'other' => q({0} फूट³),
					},
					# Core Unit Identifier
					'cubic-foot' => {
						'name' => q(फूट³),
						'one' => q({0} फूट³),
						'other' => q({0} फूट³),
					},
					# Long Unit Identifier
					'volume-cubic-inch' => {
						'name' => q(इंच³),
						'one' => q({0} इंच³),
						'other' => q({0} इंच³),
					},
					# Core Unit Identifier
					'cubic-inch' => {
						'name' => q(इंच³),
						'one' => q({0} इंच³),
						'other' => q({0} इंच³),
					},
					# Long Unit Identifier
					'volume-cubic-kilometer' => {
						'name' => q(किमी³),
						'one' => q({0} किमी³),
						'other' => q({0} किमी³),
					},
					# Core Unit Identifier
					'cubic-kilometer' => {
						'name' => q(किमी³),
						'one' => q({0} किमी³),
						'other' => q({0} किमी³),
					},
					# Long Unit Identifier
					'volume-cubic-meter' => {
						'name' => q(मी³),
						'one' => q({0} मी³),
						'other' => q({0} मी³),
						'per' => q({0}/मी³),
					},
					# Core Unit Identifier
					'cubic-meter' => {
						'name' => q(मी³),
						'one' => q({0} मी³),
						'other' => q({0} मी³),
						'per' => q({0}/मी³),
					},
					# Long Unit Identifier
					'volume-cubic-mile' => {
						'name' => q(मै³),
						'one' => q({0} मै³),
						'other' => q({0} मै³),
					},
					# Core Unit Identifier
					'cubic-mile' => {
						'name' => q(मै³),
						'one' => q({0} मै³),
						'other' => q({0} मै³),
					},
					# Long Unit Identifier
					'volume-cubic-yard' => {
						'name' => q(यार्ड³),
						'one' => q({0} यार्ड³),
						'other' => q({0} यार्ड³),
					},
					# Core Unit Identifier
					'cubic-yard' => {
						'name' => q(यार्ड³),
						'one' => q({0} यार्ड³),
						'other' => q({0} यार्ड³),
					},
					# Long Unit Identifier
					'volume-cup' => {
						'name' => q(कप),
					},
					# Core Unit Identifier
					'cup' => {
						'name' => q(कप),
					},
					# Long Unit Identifier
					'volume-drop' => {
						'name' => q(पात),
						'one' => q({0} पात),
						'other' => q({0} पात),
					},
					# Core Unit Identifier
					'drop' => {
						'name' => q(पात),
						'one' => q({0} पात),
						'other' => q({0} पात),
					},
					# Long Unit Identifier
					'volume-fluid-ounce' => {
						'name' => q(fl oz),
						'one' => q({0} fl oz),
						'other' => q({0} fl oz),
					},
					# Core Unit Identifier
					'fluid-ounce' => {
						'name' => q(fl oz),
						'one' => q({0} fl oz),
						'other' => q({0} fl oz),
					},
					# Long Unit Identifier
					'volume-fluid-ounce-imperial' => {
						'name' => q(इम्पे. फ्लु औं),
					},
					# Core Unit Identifier
					'fluid-ounce-imperial' => {
						'name' => q(इम्पे. फ्लु औं),
					},
					# Long Unit Identifier
					'volume-gallon' => {
						'name' => q(gal),
						'one' => q({0} gal),
						'other' => q({0} gal),
						'per' => q({0}/गॅ),
					},
					# Core Unit Identifier
					'gallon' => {
						'name' => q(gal),
						'one' => q({0} gal),
						'other' => q({0} gal),
						'per' => q({0}/गॅ),
					},
					# Long Unit Identifier
					'volume-gallon-imperial' => {
						'name' => q(इम्पि. गॅ.),
						'one' => q({0} गॅ इम्पि),
						'other' => q({0} गॅ इम्पि),
						'per' => q({0}/गॅ इम्पि),
					},
					# Core Unit Identifier
					'gallon-imperial' => {
						'name' => q(इम्पि. गॅ.),
						'one' => q({0} गॅ इम्पि),
						'other' => q({0} गॅ इम्पि),
						'per' => q({0}/गॅ इम्पि),
					},
					# Long Unit Identifier
					'volume-jigger' => {
						'name' => q(जिगर),
						'one' => q({0} जिगर),
						'other' => q({0} जिगर),
					},
					# Core Unit Identifier
					'jigger' => {
						'name' => q(जिगर),
						'one' => q({0} जिगर),
						'other' => q({0} जिगर),
					},
					# Long Unit Identifier
					'volume-liter' => {
						'name' => q(लीटर),
						'one' => q({0} ली),
						'other' => q({0} ली),
						'per' => q({0}/ली),
					},
					# Core Unit Identifier
					'liter' => {
						'name' => q(लीटर),
						'one' => q({0} ली),
						'other' => q({0} ली),
						'per' => q({0}/ली),
					},
					# Long Unit Identifier
					'volume-milliliter' => {
						'name' => q(मिली),
						'one' => q({0} मिली),
						'other' => q({0} मिली),
					},
					# Core Unit Identifier
					'milliliter' => {
						'name' => q(मिली),
						'one' => q({0} मिली),
						'other' => q({0} मिली),
					},
					# Long Unit Identifier
					'volume-pinch' => {
						'name' => q(आकुंचन),
						'one' => q({0} आकुंचन),
						'other' => q({0} आकुंचन),
					},
					# Core Unit Identifier
					'pinch' => {
						'name' => q(आकुंचन),
						'one' => q({0} आकुंचन),
						'other' => q({0} आकुंचन),
					},
					# Long Unit Identifier
					'volume-pint' => {
						'name' => q(पिंट),
					},
					# Core Unit Identifier
					'pint' => {
						'name' => q(पिंट),
					},
				},
			} }
);

has 'yesstr' => (
	is			=> 'ro',
	isa			=> RegexpRef,
	init_arg	=> undef,
	default		=> sub { qr'^(?i:होयःहो|yes|y)$' }
);

has 'nostr' => (
	is			=> 'ro',
	isa			=> RegexpRef,
	init_arg	=> undef,
	default		=> sub { qr'^(?i:नाहीःना|no|n)$' }
);

has 'listPatterns' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
				end => q({0} आणि {1}),
				2 => q({0} आणि {1}),
		} }
);

has 'default_numbering_system' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> 'deva',
);

has native_numbering_system => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> 'deva',
);

has 'number_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		decimalFormat => {
			'default' => {
				'1000' => {
					'one' => '0 ह',
					'other' => '0 ह',
				},
				'10000' => {
					'one' => '00 ह',
					'other' => '00 ह',
				},
				'100000' => {
					'one' => '0 लाख',
					'other' => '0 लाख',
				},
				'1000000' => {
					'one' => '00 लाख',
					'other' => '00 लाख',
				},
				'10000000' => {
					'one' => '0 कोटी',
					'other' => '0 कोटी',
				},
				'100000000' => {
					'one' => '00 कोटी',
					'other' => '00 कोटी',
				},
				'1000000000' => {
					'one' => '0 अब्ज',
					'other' => '0 अब्ज',
				},
				'10000000000' => {
					'one' => '00 अब्ज',
					'other' => '00 अब्ज',
				},
				'100000000000' => {
					'one' => '0 खर्व',
					'other' => '0 खर्व',
				},
				'1000000000000' => {
					'one' => '00 खर्व',
					'other' => '00 खर्व',
				},
				'10000000000000' => {
					'one' => '0 पद्म',
					'other' => '0 पद्म',
				},
				'100000000000000' => {
					'one' => '00 पद्म',
					'other' => '00 पद्म',
				},
				'standard' => {
					'default' => '#,##,##0.###',
				},
			},
			'long' => {
				'1000' => {
					'one' => '0 हजार',
					'other' => '0 हजार',
				},
				'10000' => {
					'one' => '00 हजार',
					'other' => '00 हजार',
				},
				'100000' => {
					'one' => '0 लाख',
					'other' => '0 लाख',
				},
				'1000000' => {
					'one' => '00 लाख',
					'other' => '00 लाख',
				},
				'10000000' => {
					'one' => '0 कोटी',
					'other' => '0 कोटी',
				},
				'100000000' => {
					'one' => '00 कोटी',
					'other' => '00 कोटी',
				},
				'1000000000' => {
					'one' => '0 अब्ज',
					'other' => '0 अब्ज',
				},
				'10000000000' => {
					'one' => '00 अब्ज',
					'other' => '00 अब्ज',
				},
				'100000000000' => {
					'one' => '0 खर्व',
					'other' => '0 खर्व',
				},
				'1000000000000' => {
					'one' => '00 खर्व',
					'other' => '00 खर्व',
				},
				'10000000000000' => {
					'one' => '0 पद्म',
					'other' => '0 पद्म',
				},
				'100000000000000' => {
					'one' => '00 पद्म',
					'other' => '00 पद्म',
				},
			},
			'short' => {
				'1000' => {
					'one' => '0 ह',
					'other' => '0 ह',
				},
				'10000' => {
					'one' => '00 ह',
					'other' => '00 ह',
				},
				'100000' => {
					'one' => '0 लाख',
					'other' => '0 लाख',
				},
				'1000000' => {
					'one' => '00 लाख',
					'other' => '00 लाख',
				},
				'10000000' => {
					'one' => '0 कोटी',
					'other' => '0 कोटी',
				},
				'100000000' => {
					'one' => '00 कोटी',
					'other' => '00 कोटी',
				},
				'1000000000' => {
					'one' => '0 अब्ज',
					'other' => '0 अब्ज',
				},
				'10000000000' => {
					'one' => '00 अब्ज',
					'other' => '00 अब्ज',
				},
				'100000000000' => {
					'one' => '0 खर्व',
					'other' => '0 खर्व',
				},
				'1000000000000' => {
					'one' => '00 खर्व',
					'other' => '00 खर्व',
				},
				'10000000000000' => {
					'one' => '0 पद्म',
					'other' => '0 पद्म',
				},
				'100000000000000' => {
					'one' => '00 पद्म',
					'other' => '00 पद्म',
				},
			},
		},
		scientificFormat => {
			'default' => {
				'standard' => {
					'default' => '[#E0]',
				},
			},
		},
} },
);

has 'number_currency_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'latn' => {
			'pattern' => {
				'default' => {
					'accounting' => {
						'negative' => '(¤#,##0.00)',
						'positive' => '¤#,##0.00',
					},
					'standard' => {
						'positive' => '¤#,##0.00',
					},
				},
			},
		},
} },
);

has 'currencies' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'AED' => {
			display_name => {
				'currency' => q(संयुक्त अरब अमीरात दिरहॅम),
			},
		},
		'AFN' => {
			display_name => {
				'currency' => q(अफगाण अफगाणी),
			},
		},
		'ALL' => {
			display_name => {
				'currency' => q(अल्बानियन लेक),
				'one' => q(अल्बानियन लेक),
				'other' => q(अल्बानियन लेके),
			},
		},
		'AMD' => {
			display_name => {
				'currency' => q(आर्मेनियन द्रॅम),
			},
		},
		'ANG' => {
			display_name => {
				'currency' => q(नेदरलँडचा अँटिलीन गिल्डर),
				'one' => q(नेदरलँडचा अँटिलीन गिल्डर),
				'other' => q(नेदरलँडचे अँटिलीन गिल्डर्स),
			},
		},
		'AOA' => {
			display_name => {
				'currency' => q(अँगोलन क्वॅन्झा),
				'one' => q(अँगोलन क्वॅन्झा),
				'other' => q(अँगोलन क्वॅन्झास),
			},
		},
		'ARS' => {
			display_name => {
				'currency' => q(अर्जेंटाइन पेसो),
				'one' => q(अर्जेंटाइन पेसो),
				'other' => q(अर्जेंटाइन पेसोज),
			},
		},
		'AUD' => {
			display_name => {
				'currency' => q(ऑस्ट्रेलियन डॉलर),
				'one' => q(ऑस्ट्रेलियन डॉलर),
				'other' => q(ऑस्ट्रेलियन डॉलर्स),
			},
		},
		'AWG' => {
			display_name => {
				'currency' => q(अरुबा फ्लोरिन),
			},
		},
		'AZN' => {
			display_name => {
				'currency' => q(अझरबैझानी मानाट),
			},
		},
		'BAM' => {
			display_name => {
				'currency' => q(बोस्निया-हर्जेगोविना विनिमय मार्क),
				'one' => q(बोस्निया-हर्जेगोविना विनिमय मार्क),
				'other' => q(बोस्निया-हर्जेगोविना विनिमय मार्क्स),
			},
		},
		'BBD' => {
			display_name => {
				'currency' => q(बार्बाडियन डॉलर),
				'one' => q(बार्बाडियन डॉलर),
				'other' => q(बार्बाडियन डॉलर्स),
			},
		},
		'BDT' => {
			display_name => {
				'currency' => q(बांगलादेशी टका),
			},
		},
		'BGN' => {
			display_name => {
				'currency' => q(बल्गेरियन लेव),
				'one' => q(बल्गेरियन लेव),
				'other' => q(बल्गेरियन लेवा),
			},
		},
		'BHD' => {
			display_name => {
				'currency' => q(बाहरिनी दिनार),
			},
		},
		'BIF' => {
			display_name => {
				'currency' => q(बुरुंडियन फ्रँक),
				'one' => q(बुरुंडियन फ्रँक),
				'other' => q(बुरुंडियन फ्रँक्स),
			},
		},
		'BMD' => {
			display_name => {
				'currency' => q(बर्मुडा डॉलर),
				'one' => q(बर्मुडा डॉलर),
				'other' => q(बर्मुडा डॉलर्स),
			},
		},
		'BND' => {
			display_name => {
				'currency' => q(ब्रुनेई डॉलर),
				'one' => q(ब्रुनेई डॉलर),
				'other' => q(ब्रुनेई डॉलर्स),
			},
		},
		'BOB' => {
			display_name => {
				'currency' => q(बोलिव्हियन बोलिव्हियानो),
				'one' => q(बोलिव्हियन बोलिव्हियानो),
				'other' => q(बोलिव्हियन बोलिव्हियानोज),
			},
		},
		'BRL' => {
			display_name => {
				'currency' => q(ब्राझिलियन रियाल),
				'one' => q(ब्राझिलियन रियाल),
				'other' => q(ब्राझिलियन रियाल्स),
			},
		},
		'BSD' => {
			display_name => {
				'currency' => q(बहामी डॉलर),
				'one' => q(बहामी डॉलर),
				'other' => q(बहामी डॉलर्स),
			},
		},
		'BTN' => {
			display_name => {
				'currency' => q(भूतानी एंगल्ट्रम),
			},
		},
		'BWP' => {
			display_name => {
				'currency' => q(बोट्सवानन पुला),
				'one' => q(बोट्सवानन पुला),
				'other' => q(बोट्सवाना पुलाज),
			},
		},
		'BYN' => {
			display_name => {
				'currency' => q(बेलारुशियन रुबल),
				'one' => q(बेलारुशियन रुबल),
				'other' => q(बेलारुशियन रुबल्स),
			},
		},
		'BYR' => {
			display_name => {
				'currency' => q(बेलारुशियन रुबल \(2000–2016\)),
				'one' => q(बेलारुशियन रुबल \(2000–2016\)),
				'other' => q(बेलारुशियन रुबल्स \(2000–2016\)),
			},
		},
		'BZD' => {
			display_name => {
				'currency' => q(बेलीझ डॉलर),
				'one' => q(बेलीझ डॉलर),
				'other' => q(बेलीझ डॉलर्स),
			},
		},
		'CAD' => {
			display_name => {
				'currency' => q(कॅनडियन डॉलर),
				'one' => q(कॅनडियन डॉलर),
				'other' => q(कॅनडियन डॉलर्स),
			},
		},
		'CDF' => {
			display_name => {
				'currency' => q(काँगोलीज फ्रँक),
				'one' => q(काँगोलीज फ्रँक),
				'other' => q(काँगोलीज फ्रँक्स),
			},
		},
		'CHF' => {
			display_name => {
				'currency' => q(स्विस फ्रँक),
				'one' => q(स्विस फ्रँक),
				'other' => q(स्विस फ्रँक्स),
			},
		},
		'CLP' => {
			display_name => {
				'currency' => q(चिली पेसो),
				'one' => q(चिली पेसो),
				'other' => q(चिली पेसोज),
			},
		},
		'CNH' => {
			display_name => {
				'currency' => q(चिनी युआन \(ऑफशोर\)),
			},
		},
		'CNY' => {
			display_name => {
				'currency' => q(चीनी युआन),
			},
		},
		'COP' => {
			display_name => {
				'currency' => q(कोलंबियन पेसो),
				'one' => q(कोलंबियन पेसो),
				'other' => q(कोलंबियन पेसोज),
			},
		},
		'CRC' => {
			display_name => {
				'currency' => q(कोस्टारिकन कोलोन),
				'one' => q(कोस्टारिकन कोलोन),
				'other' => q(कोस्टारिकन कोलोन्स),
			},
		},
		'CUC' => {
			display_name => {
				'currency' => q(क्यूबन विनिमय पेसो),
				'one' => q(क्यूबन विनिमय पेसो),
				'other' => q(क्यूबन विनिमय पेसोज),
			},
		},
		'CUP' => {
			display_name => {
				'currency' => q(क्यूबन पेसो),
				'one' => q(क्यूबन पेसो),
				'other' => q(क्यूबन पेसोज),
			},
		},
		'CVE' => {
			display_name => {
				'currency' => q(केप व्हर्डेयन एस्कुडो),
				'one' => q(केप व्हर्डेयन एस्कुडो),
				'other' => q(केप व्हर्डेयन एस्कुडोज),
			},
		},
		'CZK' => {
			display_name => {
				'currency' => q(झेक प्रजासत्ताक कोरुना),
				'one' => q(झेक प्रजासत्ताक कोरुना),
				'other' => q(झेक प्रजासत्ताक कोरुनाज),
			},
		},
		'DJF' => {
			display_name => {
				'currency' => q(जिबौटियन फ्रँक),
				'one' => q(जिबौटियन फ्रँक),
				'other' => q(जिबौटियन फ्रँक्स),
			},
		},
		'DKK' => {
			display_name => {
				'currency' => q(डॅनिश क्रोन),
			},
		},
		'DOP' => {
			display_name => {
				'currency' => q(डोमिनिकन पेसो),
				'one' => q(डोमिनिकन पेसो),
				'other' => q(डोमिनिकन पेसोज),
			},
		},
		'DZD' => {
			display_name => {
				'currency' => q(अल्जेरियन दिनार),
			},
		},
		'EGP' => {
			display_name => {
				'currency' => q(इजिप्शियन पाउंड),
				'one' => q(इजिप्शियन पाउंड),
				'other' => q(इजिप्शियन पाउंड्स),
			},
		},
		'ERN' => {
			display_name => {
				'currency' => q(इरिट्रियन नाक्फा),
				'one' => q(इरिट्रियन नाक्फा),
				'other' => q(इरिट्रियन नाक्फाज),
			},
		},
		'ETB' => {
			display_name => {
				'currency' => q(इथिओपियन बिर),
				'one' => q(इथिओपियन बिर),
				'other' => q(इथिओपियन बिर्स),
			},
		},
		'EUR' => {
			display_name => {
				'currency' => q(युरो),
			},
		},
		'FJD' => {
			display_name => {
				'currency' => q(फिजियन डॉलर),
				'one' => q(फिजियन डॉलर्स),
				'other' => q(फिजियन डॉलर्स),
			},
		},
		'FKP' => {
			display_name => {
				'currency' => q(फॉकलंड आयलंड पाउंड),
				'one' => q(फॉकलंड आयलंड पाउंड),
				'other' => q(फॉकलंड आयलंड पाउंड्स),
			},
		},
		'GBP' => {
			display_name => {
				'currency' => q(ब्रिटिश पाऊंड),
				'one' => q(ब्रिटिश पाऊंड),
				'other' => q(ब्रिटिश पाऊंड्स),
			},
		},
		'GEL' => {
			symbol => '[₾]',
			display_name => {
				'currency' => q(जॉर्जियन लारी),
			},
		},
		'GHS' => {
			display_name => {
				'currency' => q(घानीयन सेडी),
				'one' => q(घानीयन सेडी),
				'other' => q(घानीयन सेडीस),
			},
		},
		'GIP' => {
			display_name => {
				'currency' => q(जिब्राल्टर पाउंड),
				'one' => q(जिब्राल्टर पाउंड),
				'other' => q(जिब्राल्टर पाउंड्स),
			},
		},
		'GMD' => {
			display_name => {
				'currency' => q(गाम्बियन डालासी),
				'one' => q(गाम्बियन डालासी),
				'other' => q(गाम्बियन डालासीस),
			},
		},
		'GNF' => {
			display_name => {
				'currency' => q(गिनी फ्रँक),
				'one' => q(गिनी फ्रँक),
				'other' => q(गिनी फ्रँक्स),
			},
		},
		'GTQ' => {
			display_name => {
				'currency' => q(ग्वाटेमालाचे क्वेत्झाल),
				'one' => q(ग्वाटेमालाचे क्वेत्झाल),
				'other' => q(ग्वाटेमालाचे क्वेत्झाल्स),
			},
		},
		'GYD' => {
			display_name => {
				'currency' => q(गयाना डॉलर),
				'one' => q(गयाना डॉलर),
				'other' => q(गयाना डॉलर्स),
			},
		},
		'HKD' => {
			display_name => {
				'currency' => q(हाँगकाँग डॉलर),
				'one' => q(हाँगकाँग डॉलर),
				'other' => q(हाँगकाँग डॉलर्स),
			},
		},
		'HNL' => {
			display_name => {
				'currency' => q(होन्डुरन लेंपिरा),
				'one' => q(होन्डुरन लेंपिरा),
				'other' => q(होन्डुरन लेंपिराज),
			},
		},
		'HRK' => {
			display_name => {
				'currency' => q(क्रोएशियन कूना),
				'one' => q(क्रोएशियन कूना),
				'other' => q(क्रोएशियन कूनाज),
			},
		},
		'HTG' => {
			display_name => {
				'currency' => q(हैती गोअर्ड),
				'one' => q(हैती गोअर्ड),
				'other' => q(हैती गोअर्ड्स),
			},
		},
		'HUF' => {
			display_name => {
				'currency' => q(हंगेरियन फॉरिन्ट),
				'one' => q(हंगेरियन फॉरिन्ट),
				'other' => q(हंगेरियन फॉरिन्ट्स),
			},
		},
		'IDR' => {
			display_name => {
				'currency' => q(इंडोनेशियन रुपिया),
			},
		},
		'ILS' => {
			display_name => {
				'currency' => q(ईस्त्रायली न्यू शेकेल),
			},
		},
		'INR' => {
			display_name => {
				'currency' => q(भारतीय रुपया),
				'one' => q(भारतीय रुपया),
				'other' => q(भारतीय रुपये),
			},
		},
		'IQD' => {
			display_name => {
				'currency' => q(इराकी दिनार),
			},
		},
		'IRR' => {
			display_name => {
				'currency' => q(इराणी रियाल),
			},
		},
		'ISK' => {
			display_name => {
				'currency' => q(आइसलँडिक क्रोना),
				'one' => q(आइसलँडिक क्रोना),
				'other' => q(आइसलँडिक क्रोन्युर),
			},
		},
		'JMD' => {
			display_name => {
				'currency' => q(जमैकन डॉलर),
				'one' => q(जमैकन डॉलर),
				'other' => q(जमैकन डॉलर्स),
			},
		},
		'JOD' => {
			display_name => {
				'currency' => q(जॉर्डनियन दिनार),
			},
		},
		'JPY' => {
			display_name => {
				'currency' => q(जपानी येन),
			},
		},
		'KES' => {
			display_name => {
				'currency' => q(केनियन शिलिंग),
				'one' => q(केनियन शिलिंग),
				'other' => q(केनियन शिलिंग्स),
			},
		},
		'KGS' => {
			display_name => {
				'currency' => q(किरगिस्तानी सॉम),
			},
		},
		'KHR' => {
			display_name => {
				'currency' => q(कंबोडियन रियेल),
			},
		},
		'KMF' => {
			display_name => {
				'currency' => q(कोमोरियन फ्रँक),
				'one' => q(कोमोरियन फ्रँक),
				'other' => q(कोमोरियन फ्रँक्स),
			},
		},
		'KPW' => {
			display_name => {
				'currency' => q(उत्तर कोरियन वॉन),
			},
		},
		'KRW' => {
			display_name => {
				'currency' => q(दक्षिण कोरियन वॉन),
			},
		},
		'KWD' => {
			display_name => {
				'currency' => q(कुवैती दिनार),
			},
		},
		'KYD' => {
			display_name => {
				'currency' => q(केमेन आयलॅंड डॉलर),
				'one' => q(केमेन आयलॅंड डॉलर),
				'other' => q(केमेन आयलॅंड डॉलर्स),
			},
		},
		'KZT' => {
			display_name => {
				'currency' => q(कझाकिस्तानी तेंगे),
			},
		},
		'LAK' => {
			display_name => {
				'currency' => q(लाओशियन किप),
			},
		},
		'LBP' => {
			display_name => {
				'currency' => q(लेबनीज पाउंड),
				'one' => q(लेबनीज पाउंड),
				'other' => q(लेबनीज पाउंड्स),
			},
		},
		'LKR' => {
			display_name => {
				'currency' => q(श्रीलंकन रुपया),
				'one' => q(श्रीलंकन रुपया),
				'other' => q(श्रीलंकन रुपये),
			},
		},
		'LRD' => {
			display_name => {
				'currency' => q(लाइबेरियन डॉलर),
				'one' => q(लाइबेरियन डॉलर),
				'other' => q(लाइबेरियन डॉलर्स),
			},
		},
		'LSL' => {
			display_name => {
				'currency' => q(लेसोटो लोटी),
			},
		},
		'LTL' => {
			display_name => {
				'currency' => q(लिथुआनियन लिटास),
				'one' => q(लिथुआनियन लिटास),
				'other' => q(लिथुआनियन लिटाई),
			},
		},
		'LVL' => {
			display_name => {
				'currency' => q(लाट्व्हियन लाट्झ),
				'one' => q(लाट्व्हियन लाट्झ),
				'other' => q(लाट्व्हियन लाटी),
			},
		},
		'LYD' => {
			display_name => {
				'currency' => q(लिबियाचा दिनार),
				'one' => q(लिबियाचा दिनार),
				'other' => q(लिबियन दिनार),
			},
		},
		'MAD' => {
			display_name => {
				'currency' => q(मोरोक्को दिरहॅम),
				'one' => q(मोरोक्को दिरहॅम),
				'other' => q(मोरोक्कन दिरहाम),
			},
		},
		'MDL' => {
			display_name => {
				'currency' => q(मोल्डोवन लेउ),
				'one' => q(मोल्डोवन लेउ),
				'other' => q(मोल्डोवन लेई),
			},
		},
		'MGA' => {
			display_name => {
				'currency' => q(मालागासी एरियारी),
				'one' => q(मालागासी एरियारी),
				'other' => q(मालागासी एरियारीज),
			},
		},
		'MKD' => {
			display_name => {
				'currency' => q(मॅसेडोनियन देनार),
				'one' => q(मॅसेडोनियन देनार),
				'other' => q(मॅसेडोनियन देनारी),
			},
		},
		'MMK' => {
			display_name => {
				'currency' => q(म्यानमार क्याट),
			},
		},
		'MNT' => {
			display_name => {
				'currency' => q(मंगोलियन टुग्रिक),
				'one' => q(मंगोलियन टुग्रिक),
				'other' => q(मंगोलियन टुग्रिक्स),
			},
		},
		'MOP' => {
			display_name => {
				'currency' => q(मॅकॅनीज् पटाका),
				'one' => q(मॅकॅनीज् पटाका),
				'other' => q(मॅकॅनीज् पटाकाज),
			},
		},
		'MRO' => {
			display_name => {
				'currency' => q(मॉरिटानियन ओगिया \(1973–2017\)),
				'one' => q(मॉरिटानियन ओगिया \(1973–2017\)),
				'other' => q(मॉरिटानियन ओगियाज \(1973–2017\)),
			},
		},
		'MRU' => {
			display_name => {
				'currency' => q(मॉरिटानियन ओगिया),
				'one' => q(मॉरिटानियन ओगिया),
				'other' => q(मॉरिटानियन ओगियाज),
			},
		},
		'MUR' => {
			display_name => {
				'currency' => q(मॉरिशियन रुपी),
				'one' => q(मॉरिशियन रुपी),
				'other' => q(मॉरिशियन रुपीज),
			},
		},
		'MVR' => {
			display_name => {
				'currency' => q(मालदीवियन रुफिया),
			},
		},
		'MWK' => {
			display_name => {
				'currency' => q(मालावियन क्वाचा),
				'one' => q(मालावियन क्वाचा),
				'other' => q(मालावियन क्वाचास),
			},
		},
		'MXN' => {
			display_name => {
				'currency' => q(मेक्सिको पेसो),
				'one' => q(मेक्सिको पेसो),
				'other' => q(मेक्सिको पेसोज),
			},
		},
		'MYR' => {
			display_name => {
				'currency' => q(मलेशियन रिंगिट),
			},
		},
		'MZN' => {
			display_name => {
				'currency' => q(मोझांबिकन मेटिकल),
				'one' => q(मोझांबिकन मेटिकल),
				'other' => q(मोझांबिकन मेटिकल्स),
			},
		},
		'NAD' => {
			display_name => {
				'currency' => q(नमिबियन डॉलर),
				'one' => q(नमिबियन डॉलर),
				'other' => q(नमिबियन डॉलर्स),
			},
		},
		'NGN' => {
			display_name => {
				'currency' => q(नायजेरियन नायरा),
				'one' => q(नायजेरियन नायरा),
				'other' => q(नायजेरियन नायराज),
			},
		},
		'NIO' => {
			display_name => {
				'currency' => q(निकाराग्वन कोर्डोबा),
				'one' => q(निकाराग्वन कोर्डोबा),
				'other' => q(निकाराग्वन कोर्डोबाज),
			},
		},
		'NOK' => {
			display_name => {
				'currency' => q(नॉर्वेजियन क्रोन),
				'one' => q(नॉर्वेजियन क्रोन),
				'other' => q(नॉर्वेजियन क्रोनर),
			},
		},
		'NPR' => {
			display_name => {
				'currency' => q(नेपाळी रुपया),
				'one' => q(नेपाळी रुपया),
				'other' => q(नेपाळी रुपये),
			},
		},
		'NZD' => {
			display_name => {
				'currency' => q(न्यूझीलँड डॉलर),
				'one' => q(न्यूझीलँड डॉलर),
				'other' => q(न्यूझीलँड डॉलर्स),
			},
		},
		'OMR' => {
			display_name => {
				'currency' => q(ओमानी रियाल),
			},
		},
		'PAB' => {
			display_name => {
				'currency' => q(पनामा बाल्बोआ),
				'one' => q(पनामा बाल्बोआ),
				'other' => q(पनामा बाल्बोआज),
			},
		},
		'PEN' => {
			display_name => {
				'currency' => q(पेरुवियन सोल),
				'one' => q(पेरुवियन सोल),
				'other' => q(पेरुवियन सोल्स),
			},
		},
		'PGK' => {
			display_name => {
				'currency' => q(पापुआ न्यू गिनीयन किना),
			},
		},
		'PHP' => {
			symbol => 'PHP',
			display_name => {
				'currency' => q(फिलिपिनी पेसो),
				'one' => q(फिलिपिनी पेसो),
				'other' => q(फिलिपिनी पेसोज),
			},
		},
		'PKR' => {
			display_name => {
				'currency' => q(पाकिस्तानी रुपया),
				'one' => q(पाकिस्तानी रुपया),
				'other' => q(पाकिस्तानी रुपये),
			},
		},
		'PLN' => {
			display_name => {
				'currency' => q(पोलिश झ्लॉटी),
				'one' => q(पोलिश झ्लॉटी),
				'other' => q(पोलिश झ्लॉटीज),
			},
		},
		'PYG' => {
			display_name => {
				'currency' => q(पराग्वे ग्वारानी),
				'one' => q(पराग्वे ग्वारानी),
				'other' => q(पराग्वे ग्वारानीज),
			},
		},
		'QAR' => {
			display_name => {
				'currency' => q(कतारी रियाल),
			},
		},
		'RON' => {
			display_name => {
				'currency' => q(रोमानियन लेऊ),
				'one' => q(रोमानियन लेऊ),
				'other' => q(रोमानियन लेई),
			},
		},
		'RSD' => {
			display_name => {
				'currency' => q(सर्बियन दिनार),
			},
		},
		'RUB' => {
			display_name => {
				'currency' => q(रशियन रुबल),
				'one' => q(रशियन रुबल),
				'other' => q(रशियन रुबल्स),
			},
		},
		'RWF' => {
			display_name => {
				'currency' => q(रवांडा फ्रँक),
				'one' => q(रवांडा फ्रँक),
				'other' => q(रवांडा फ्रँक्स),
			},
		},
		'SAR' => {
			display_name => {
				'currency' => q(सौदी रियाल),
			},
		},
		'SBD' => {
			display_name => {
				'currency' => q(सोलोमन आयलँड्स डॉलर),
				'one' => q(सोलोमन आयलँड्स डॉलर),
				'other' => q(सोलोमन आयलँड्स डॉलर्स),
			},
		},
		'SCR' => {
			display_name => {
				'currency' => q(सेशेलोईस रुपी),
				'one' => q(सेशेलोईस रुपी),
				'other' => q(सेशेलोईस रुपीज),
			},
		},
		'SDG' => {
			display_name => {
				'currency' => q(सुदानी पाउंड),
				'one' => q(सुदानी पाउंड),
				'other' => q(सुदानी पाउंड्स),
			},
		},
		'SEK' => {
			display_name => {
				'currency' => q(स्वीडिश क्रोना),
				'one' => q(स्वीडिश क्रोना),
				'other' => q(स्वीडिश क्रोनोर),
			},
		},
		'SGD' => {
			display_name => {
				'currency' => q(सिंगापूर डॉलर),
				'one' => q(सिंगापूर डॉलर),
				'other' => q(सिंगापूर डॉलर्स),
			},
		},
		'SHP' => {
			display_name => {
				'currency' => q(सेंट हेलेना पाउंड),
				'one' => q(सेंट हेलेना पाउंड),
				'other' => q(सेंट हेलेना पाउंड्स),
			},
		},
		'SLE' => {
			display_name => {
				'currency' => q(सिएरा लिऑनचा लिऑन),
				'one' => q(सिएरा लिऑनचा लिऑन),
				'other' => q(सिएरा लिऑनचे लिऑन्स),
			},
		},
		'SLL' => {
			display_name => {
				'currency' => q(सिएरा लिऑनचा लिऑन \(1964—2022\)),
				'one' => q(सिएरा लिऑनचा लिऑन \(1964—2022\)),
				'other' => q(सिएरा लिऑनचे लिऑन्स \(1964—2022\)),
			},
		},
		'SOS' => {
			display_name => {
				'currency' => q(सोमाली शिलिंग),
				'one' => q(सोमाली शिलिंग्स),
				'other' => q(सोमाली शिलिंग),
			},
		},
		'SRD' => {
			display_name => {
				'currency' => q(सुरिनामी डॉलर),
				'one' => q(सुरिनामी डॉलर),
				'other' => q(सुरिनामी डॉलर्स),
			},
		},
		'SSP' => {
			display_name => {
				'currency' => q(दक्षिण सुदानी पाउंड),
				'one' => q(दक्षिण सुदानी पाउंड),
				'other' => q(दक्षिण सुदानी पाउंड्स),
			},
		},
		'STD' => {
			display_name => {
				'currency' => q(साओ टोम आणि प्रिन्सिपे डोबरा \(1977–2017\)),
				'one' => q(साओ टोम आणि प्रिन्सिपे डोबरा \(1977–2017\)),
				'other' => q(साओ टोम आणि प्रिन्सिपे डोबराज \(1977–2017\)),
			},
		},
		'STN' => {
			display_name => {
				'currency' => q(साओ टोम आणि प्रिन्सिपे डोबरा),
				'one' => q(साओ टोम आणि प्रिन्सिपे डोबरा),
				'other' => q(साओ टोम आणि प्रिन्सिपे डोबराज),
			},
		},
		'SYP' => {
			display_name => {
				'currency' => q(सीरियन पाउंड),
				'one' => q(सीरियन पाउंड),
				'other' => q(सीरियन पाउंड्स),
			},
		},
		'SZL' => {
			display_name => {
				'currency' => q(स्वाझी लीलांगेनी),
				'one' => q(स्वाझी लीलांगेनी),
				'other' => q(स्वाझी एमालांगेनी),
			},
		},
		'THB' => {
			symbol => '฿',
			display_name => {
				'currency' => q(थाई बाहत),
			},
		},
		'TJS' => {
			display_name => {
				'currency' => q(ताजकीस्तानी सोमोनी),
				'one' => q(ताजकीस्तानी सोमोनी),
				'other' => q(ताजकीस्तानी सोमोनीज),
			},
		},
		'TMT' => {
			display_name => {
				'currency' => q(तुर्कमेनिस्तानी मानाट),
			},
		},
		'TND' => {
			display_name => {
				'currency' => q(ट्यूनिशियन दिनार),
			},
		},
		'TOP' => {
			display_name => {
				'currency' => q(टोंगन पाआंगा),
			},
		},
		'TRY' => {
			display_name => {
				'currency' => q(तुर्की लिरा),
			},
		},
		'TTD' => {
			display_name => {
				'currency' => q(त्रिनिदाद आणि टोबॅगो डॉलर),
				'one' => q(त्रिनिदाद आणि टोबॅगो डॉलर),
				'other' => q(त्रिनिदाद आणि टोबॅगो डॉलर्स),
			},
		},
		'TWD' => {
			symbol => 'NT$',
			display_name => {
				'currency' => q(न्यू तैवान डॉलर),
				'one' => q(न्यू तैवान डॉलर),
				'other' => q(न्यू तैवान डॉलर्स),
			},
		},
		'TZS' => {
			display_name => {
				'currency' => q(टांझानियन शिलिंग),
				'one' => q(टांझानियन शिलिंग),
				'other' => q(टांझानियन शिलिंग्स),
			},
		},
		'UAH' => {
			display_name => {
				'currency' => q(युक्रेनियन रिवनिया),
				'one' => q(युक्रेनियन रिवनिया),
				'other' => q(युक्रेनियन रिवनियाज),
			},
		},
		'UGX' => {
			display_name => {
				'currency' => q(युगांडा शिलिंग),
				'one' => q(युगांडा शिलिंग),
				'other' => q(युगांडा शिलिंग्स),
			},
		},
		'USD' => {
			symbol => '$',
			display_name => {
				'currency' => q(यूएस डॉलर),
				'one' => q(यूएस डॉलर),
				'other' => q(यूएस डॉलर्स),
			},
		},
		'UYU' => {
			display_name => {
				'currency' => q(उरुग्वेचा पेसो),
				'one' => q(उरुग्वेचा पेसो),
				'other' => q(उरुग्वेचे पेसोज),
			},
		},
		'UZS' => {
			display_name => {
				'currency' => q(उझबेकिस्तानी सोम),
			},
		},
		'VEF' => {
			display_name => {
				'currency' => q(व्हेनेझुएला बोलिव्हार \(2008–2018\)),
				'one' => q(व्हेनेझुएला बोलिव्हार \(2008–2018\)),
				'other' => q(व्हेनेझुएला बोलिव्हार्स \(2008–2018\)),
			},
		},
		'VES' => {
			display_name => {
				'currency' => q(व्हेनेझुएला बोलिव्हार),
				'one' => q(व्हेनेझुएला बोलिव्हार),
				'other' => q(व्हेनेझुएला बोलिव्हार्स),
			},
		},
		'VND' => {
			display_name => {
				'currency' => q(व्हिएतनामी डोंग),
			},
		},
		'VUV' => {
			display_name => {
				'currency' => q(वानुआतु वाटु),
			},
		},
		'WST' => {
			display_name => {
				'currency' => q(सामोअन टाला),
			},
		},
		'XAF' => {
			display_name => {
				'currency' => q(मध्य आफ्रिकन [CFA] फ्रँक),
			},
		},
		'XCD' => {
			display_name => {
				'currency' => q(पूर्व कॅरीबियन डॉलर),
				'one' => q(पूर्व कॅरीबियन डॉलर),
				'other' => q(पूर्व कॅरीबियन डॉलर्स),
			},
		},
		'XOF' => {
			display_name => {
				'currency' => q(पश्चिम आफ्रिकन [CFA] फ्रँक),
				'one' => q(पश्चिम आफ्रिकन [CFA] फ्रँक),
				'other' => q(पश्चिम आफ्रिकन [CFA] फ्रँक्स),
			},
		},
		'XPF' => {
			display_name => {
				'currency' => q([CFP] फ्रँक),
				'one' => q([CFP] फ्रँक),
				'other' => q([CFP] फ्रँक्स),
			},
		},
		'XXX' => {
			display_name => {
				'currency' => q(अज्ञात चलन),
				'one' => q(\(चलनाचे अज्ञात एकक\)),
				'other' => q(\(अज्ञात चलन\)),
			},
		},
		'YER' => {
			display_name => {
				'currency' => q(येमेनी रियाल),
			},
		},
		'ZAR' => {
			display_name => {
				'currency' => q(दक्षिण आफ्रिकी रँड),
			},
		},
		'ZMK' => {
			display_name => {
				'currency' => q(झांबियन क्वाचा \(1968–2012\)),
			},
		},
		'ZMW' => {
			display_name => {
				'currency' => q(झांबियन क्वाचा),
				'one' => q(झांबियन क्वाचा),
				'other' => q(झांबियन क्वाचास),
			},
		},
	} },
);


has 'calendar_months' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'coptic' => {
				'format' => {
					wide => {
						nonleap => [
							'तौत',
							'बाबा',
							'हातोर',
							'कियाहक',
							'तोबा',
							'ऍमशिर',
							'बरामहाट',
							'बरामउदा',
							'बशान्स',
							'पाओना',
							'इपिप',
							'मेस्रा',
							'नासी'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					narrow => {
						nonleap => [
							'१',
							'२',
							'३',
							'४',
							'५',
							'६',
							'७',
							'८',
							'९',
							'१०',
							'११',
							'१२',
							'१३'
						],
						leap => [
							
						],
					},
				},
			},
			'ethiopic' => {
				'format' => {
					wide => {
						nonleap => [
							'मेसकेरेम',
							'तेकेम्त',
							'हेदार',
							'ताहसास',
							'तेर',
							'येकातित',
							'मेगाबित',
							'मियाझिया',
							'गेनबोत',
							'सेने',
							'हाम्ले',
							'नेहास्से',
							'पागुमेन'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					narrow => {
						nonleap => [
							'१',
							'२',
							'३',
							'४',
							'५',
							'६',
							'७',
							'८',
							'९',
							'१०',
							'११',
							'१२',
							'१३'
						],
						leap => [
							
						],
					},
				},
			},
			'gregorian' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'जाने',
							'फेब्रु',
							'मार्च',
							'एप्रि',
							'मे',
							'जून',
							'जुलै',
							'ऑग',
							'सप्टें',
							'ऑक्टो',
							'नोव्हें',
							'डिसें'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'जानेवारी',
							'फेब्रुवारी',
							'मार्च',
							'एप्रिल',
							'मे',
							'जून',
							'जुलै',
							'ऑगस्ट',
							'सप्टेंबर',
							'ऑक्टोबर',
							'नोव्हेंबर',
							'डिसेंबर'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					narrow => {
						nonleap => [
							'जा',
							'फे',
							'मा',
							'ए',
							'मे',
							'जू',
							'जु',
							'ऑ',
							'स',
							'ऑ',
							'नो',
							'डि'
						],
						leap => [
							
						],
					},
				},
			},
			'hebrew' => {
				'format' => {
					wide => {
						nonleap => [
							'तिशरी',
							'हेशवान',
							'किस्लेव',
							'तेवेत',
							'शेवात',
							'अदार I',
							'अदार',
							'निसान',
							'इयार',
							'सिवान',
							'तामुझ',
							'अव',
							'इलुल'
						],
						leap => [
							undef(),
							undef(),
							undef(),
							undef(),
							undef(),
							undef(),
							
						],
					},
				},
				'stand-alone' => {
					narrow => {
						nonleap => [
							'१',
							'२',
							'३',
							'४',
							'५',
							'६',
							'७',
							'८',
							'९',
							'१०',
							'११',
							'१२',
							'१३'
						],
						leap => [
							undef(),
							undef(),
							undef(),
							undef(),
							undef(),
							undef(),
							
						],
					},
				},
			},
			'indian' => {
				'format' => {
					wide => {
						nonleap => [
							'चैत्र',
							'वैशाख',
							'ज्येष्ठ',
							'आषाढ',
							'श्रावण',
							'भाद्र',
							'आश्विन',
							'कार्तिक',
							'मार्गशीर्ष',
							'पौष',
							'माघ',
							'फाल्गुन'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					narrow => {
						nonleap => [
							'१',
							'२',
							'३',
							'४',
							'५',
							'६',
							'७',
							'८',
							'९',
							'१०',
							'११',
							'१२'
						],
						leap => [
							
						],
					},
				},
			},
			'islamic' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'मोह.',
							'सफ.',
							'राबी I',
							'राबी II',
							'जुमा. I',
							'जुमा. II',
							'रझा.',
							'शाबा.',
							'रम.',
							'शव्वा.',
							'धुल-की.',
							'धुल-हि.'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'मोहरम',
							'सफर',
							'राबी I',
							'राबी II',
							'जुमादा I',
							'जुमादा II',
							'रझाब',
							'शाबान',
							'रमजान',
							'शव्वाल',
							'धुल-कीदाह',
							'धुल-हिजाह'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					narrow => {
						nonleap => [
							'१',
							'२',
							'३',
							'४',
							'५',
							'६',
							'७',
							'८',
							'९',
							'१०',
							'११',
							'१२'
						],
						leap => [
							
						],
					},
				},
			},
			'persian' => {
				'format' => {
					wide => {
						nonleap => [
							'फरवरदिन',
							'ओर्दिबेहेश्त',
							'खोरदाद',
							'तिर',
							'मोरदाद',
							'शाहरीवार',
							'मेहेर',
							'अबान',
							'अझार',
							'दे',
							'बाहमान',
							'एसफांद'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					narrow => {
						nonleap => [
							'१',
							'२',
							'३',
							'४',
							'५',
							'६',
							'७',
							'८',
							'९',
							'१०',
							'११',
							'१२'
						],
						leap => [
							
						],
					},
				},
			},
	} },
);

has 'calendar_days' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {
						mon => 'सोम',
						tue => 'मंगळ',
						wed => 'बुध',
						thu => 'गुरु',
						fri => 'शुक्र',
						sat => 'शनि',
						sun => 'रवि'
					},
					short => {
						mon => 'सो',
						tue => 'मं',
						wed => 'बु',
						thu => 'गु',
						fri => 'शु',
						sat => 'श',
						sun => 'र'
					},
					wide => {
						mon => 'सोमवार',
						tue => 'मंगळवार',
						wed => 'बुधवार',
						thu => 'गुरुवार',
						fri => 'शुक्रवार',
						sat => 'शनिवार',
						sun => 'रविवार'
					},
				},
				'stand-alone' => {
					narrow => {
						mon => 'सो',
						tue => 'मं',
						wed => 'बु',
						thu => 'गु',
						fri => 'शु',
						sat => 'श',
						sun => 'र'
					},
				},
			},
	} },
);

has 'calendar_quarters' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {0 => 'ति१',
						1 => 'ति२',
						2 => 'ति३',
						3 => 'ति४'
					},
					wide => {0 => 'प्रथम तिमाही',
						1 => 'द्वितीय तिमाही',
						2 => 'तृतीय तिमाही',
						3 => 'चतुर्थ तिमाही'
					},
				},
				'stand-alone' => {
					narrow => {0 => '१',
						1 => '२',
						2 => '३',
						3 => '४'
					},
				},
			},
	} },
);

has 'day_period_data' => (
	is			=> 'ro',
	isa			=> CodeRef,
	init_arg	=> undef,
	default		=> sub { sub {
		# Time in hhmm format
		my ($self, $type, $time, $day_period_type) = @_;
		$day_period_type //= 'default';
		SWITCH:
		for ($type) {
			if ($_ eq 'buddhist') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'noon' if $time == 1200;
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'evening1' if $time >= 1600
						&& $time < 2100;
					return 'morning1' if $time >= 400
						&& $time < 600;
					return 'morning2' if $time >= 600
						&& $time < 1200;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 400;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'evening1' if $time >= 1600
						&& $time < 2100;
					return 'morning1' if $time >= 400
						&& $time < 600;
					return 'morning2' if $time >= 600
						&& $time < 1200;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 400;
				}
				last SWITCH;
				}
			if ($_ eq 'coptic') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'noon' if $time == 1200;
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'evening1' if $time >= 1600
						&& $time < 2100;
					return 'morning1' if $time >= 400
						&& $time < 600;
					return 'morning2' if $time >= 600
						&& $time < 1200;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 400;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'evening1' if $time >= 1600
						&& $time < 2100;
					return 'morning1' if $time >= 400
						&& $time < 600;
					return 'morning2' if $time >= 600
						&& $time < 1200;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 400;
				}
				last SWITCH;
				}
			if ($_ eq 'ethiopic') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'noon' if $time == 1200;
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'evening1' if $time >= 1600
						&& $time < 2100;
					return 'morning1' if $time >= 400
						&& $time < 600;
					return 'morning2' if $time >= 600
						&& $time < 1200;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 400;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'evening1' if $time >= 1600
						&& $time < 2100;
					return 'morning1' if $time >= 400
						&& $time < 600;
					return 'morning2' if $time >= 600
						&& $time < 1200;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 400;
				}
				last SWITCH;
				}
			if ($_ eq 'generic') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'noon' if $time == 1200;
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'evening1' if $time >= 1600
						&& $time < 2100;
					return 'morning1' if $time >= 400
						&& $time < 600;
					return 'morning2' if $time >= 600
						&& $time < 1200;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 400;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'evening1' if $time >= 1600
						&& $time < 2100;
					return 'morning1' if $time >= 400
						&& $time < 600;
					return 'morning2' if $time >= 600
						&& $time < 1200;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 400;
				}
				last SWITCH;
				}
			if ($_ eq 'gregorian') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'noon' if $time == 1200;
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'evening1' if $time >= 1600
						&& $time < 2100;
					return 'morning1' if $time >= 400
						&& $time < 600;
					return 'morning2' if $time >= 600
						&& $time < 1200;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 400;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'evening1' if $time >= 1600
						&& $time < 2100;
					return 'morning1' if $time >= 400
						&& $time < 600;
					return 'morning2' if $time >= 600
						&& $time < 1200;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 400;
				}
				last SWITCH;
				}
			if ($_ eq 'hebrew') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'noon' if $time == 1200;
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'evening1' if $time >= 1600
						&& $time < 2100;
					return 'morning1' if $time >= 400
						&& $time < 600;
					return 'morning2' if $time >= 600
						&& $time < 1200;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 400;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'evening1' if $time >= 1600
						&& $time < 2100;
					return 'morning1' if $time >= 400
						&& $time < 600;
					return 'morning2' if $time >= 600
						&& $time < 1200;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 400;
				}
				last SWITCH;
				}
			if ($_ eq 'indian') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'noon' if $time == 1200;
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'evening1' if $time >= 1600
						&& $time < 2100;
					return 'morning1' if $time >= 400
						&& $time < 600;
					return 'morning2' if $time >= 600
						&& $time < 1200;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 400;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'evening1' if $time >= 1600
						&& $time < 2100;
					return 'morning1' if $time >= 400
						&& $time < 600;
					return 'morning2' if $time >= 600
						&& $time < 1200;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 400;
				}
				last SWITCH;
				}
			if ($_ eq 'islamic') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'noon' if $time == 1200;
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'evening1' if $time >= 1600
						&& $time < 2100;
					return 'morning1' if $time >= 400
						&& $time < 600;
					return 'morning2' if $time >= 600
						&& $time < 1200;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 400;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'evening1' if $time >= 1600
						&& $time < 2100;
					return 'morning1' if $time >= 400
						&& $time < 600;
					return 'morning2' if $time >= 600
						&& $time < 1200;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 400;
				}
				last SWITCH;
				}
			if ($_ eq 'persian') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'noon' if $time == 1200;
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'evening1' if $time >= 1600
						&& $time < 2100;
					return 'morning1' if $time >= 400
						&& $time < 600;
					return 'morning2' if $time >= 600
						&& $time < 1200;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 400;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'evening1' if $time >= 1600
						&& $time < 2100;
					return 'morning1' if $time >= 400
						&& $time < 600;
					return 'morning2' if $time >= 600
						&& $time < 1200;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 400;
				}
				last SWITCH;
				}
			if ($_ eq 'roc') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'noon' if $time == 1200;
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'evening1' if $time >= 1600
						&& $time < 2100;
					return 'morning1' if $time >= 400
						&& $time < 600;
					return 'morning2' if $time >= 600
						&& $time < 1200;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 400;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'evening1' if $time >= 1600
						&& $time < 2100;
					return 'morning1' if $time >= 400
						&& $time < 600;
					return 'morning2' if $time >= 600
						&& $time < 1200;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 400;
				}
				last SWITCH;
				}
		}
	} },
);

around day_period_data => sub {
    my ($orig, $self) = @_;
    return $self->$orig;
};

has 'day_periods' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			'format' => {
				'abbreviated' => {
					'afternoon1' => q{दुपार},
					'evening1' => q{संध्याकाळ},
					'midnight' => q{मध्यरात्र},
					'morning1' => q{पहाट},
					'morning2' => q{सकाळ},
					'night1' => q{रात्र},
					'noon' => q{मध्यान्ह},
				},
				'narrow' => {
					'afternoon1' => q{दु},
					'am' => q{a},
					'evening1' => q{सं},
					'midnight' => q{म.रा.},
					'morning1' => q{प},
					'morning2' => q{स},
					'night1' => q{रा},
					'noon' => q{दु},
					'pm' => q{p},
				},
			},
			'stand-alone' => {
				'narrow' => {
					'afternoon1' => q{दु},
					'evening1' => q{सं},
					'midnight' => q{म.रा.},
					'morning1' => q{प},
					'morning2' => q{स},
					'night1' => q{रात्र},
					'noon' => q{म},
				},
			},
		},
	} },
);

has 'eras' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'buddhist' => {
			abbreviated => {
				'0' => 'इसपू.'
			},
			wide => {
				'0' => 'इसवीसन पूर्व'
			},
		},
		'coptic' => {
			abbreviated => {
				'0' => 'युग0',
				'1' => 'युग1'
			},
		},
		'ethiopic' => {
			abbreviated => {
				'0' => 'युग0',
				'1' => 'युग1'
			},
		},
		'generic' => {
		},
		'gregorian' => {
			abbreviated => {
				'0' => 'ई. स. पू.',
				'1' => 'इ. स.'
			},
			wide => {
				'0' => 'ईसवीसनपूर्व',
				'1' => 'ईसवीसन'
			},
		},
		'hebrew' => {
			wide => {
				'0' => 'ऍन्नो मुंडी'
			},
		},
		'indian' => {
			abbreviated => {
				'0' => 'शक'
			},
		},
		'islamic' => {
			abbreviated => {
				'0' => 'हि.व.'
			},
			wide => {
				'0' => 'हिजरी वर्ष'
			},
		},
		'persian' => {
		},
		'roc' => {
			abbreviated => {
				'0' => 'आर.ओ.सी. आधी',
				'1' => 'मिंगू'
			},
		},
	} },
);

has 'date_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'buddhist' => {
		},
		'coptic' => {
		},
		'ethiopic' => {
		},
		'generic' => {
			'full' => q{EEEE, d MMMM, y G},
			'long' => q{d MMMM, y G},
			'medium' => q{d MMM, y G},
			'short' => q{d/M/y GGGGG},
		},
		'gregorian' => {
			'full' => q{EEEE, d MMMM, y},
			'long' => q{d MMMM, y},
			'medium' => q{d MMM, y},
			'short' => q{d/M/yy},
		},
		'hebrew' => {
		},
		'indian' => {
		},
		'islamic' => {
		},
		'persian' => {
		},
		'roc' => {
		},
	} },
);

has 'time_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'buddhist' => {
		},
		'coptic' => {
		},
		'ethiopic' => {
		},
		'generic' => {
		},
		'gregorian' => {
			'full' => q{h:mm:ss a zzzz},
			'long' => q{h:mm:ss a z},
			'medium' => q{h:mm:ss a},
			'short' => q{h:mm a},
		},
		'hebrew' => {
		},
		'indian' => {
		},
		'islamic' => {
		},
		'persian' => {
		},
		'roc' => {
		},
	} },
);

has 'datetime_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'buddhist' => {
		},
		'coptic' => {
		},
		'ethiopic' => {
		},
		'generic' => {
			'full' => q{{1}, {0}},
			'long' => q{{1}, {0}},
			'medium' => q{{1}, {0}},
			'short' => q{{1}, {0}},
		},
		'gregorian' => {
			'full' => q{{1}, {0}},
			'long' => q{{1}, {0}},
			'medium' => q{{1}, {0}},
			'short' => q{{1}, {0}},
		},
		'hebrew' => {
		},
		'indian' => {
		},
		'islamic' => {
		},
		'persian' => {
		},
		'roc' => {
		},
	} },
);

has 'datetime_formats_available_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			Bh => q{B h},
			Bhm => q{B h:mm},
			Bhms => q{B h:mm:ss},
			EBhm => q{E B h:mm},
			EBhms => q{E B h:mm:ss},
			Ed => q{E d},
			Gy => q{y G},
			GyMMM => q{MMM y G},
			GyMMMEd => q{E, d MMM, y G},
			GyMMMd => q{d MMM, y G},
			GyMd => q{d/M/y GGGGG},
			Hm => q{H-mm},
			Hms => q{H-mm-ss},
			MEd => q{E, d/M},
			MMMEd => q{E, d MMM},
			MMMMd => q{d MMMM},
			MMMd => q{d MMM},
			MMdd => q{dd-MM},
			Md => q{d/M},
			y => q{y G},
			yyyy => q{y G},
			yyyyM => q{M/y GGGGG},
			yyyyMEd => q{E, d/M/y GGGGG},
			yyyyMM => q{MM-y G},
			yyyyMMM => q{MMM y G},
			yyyyMMMEd => q{E, d MMM, y G},
			yyyyMMMM => q{MMMM y G},
			yyyyMMMd => q{d MMM, y G},
			yyyyMd => q{d/M/y GGGGG},
			yyyyQQQ => q{QQQ y G},
			yyyyQQQQ => q{QQQQ y G},
		},
		'gregorian' => {
			Bh => q{B h},
			Bhm => q{B h:mm},
			Bhms => q{B h:mm:ss},
			EBhm => q{E B h:mm},
			EBhms => q{E B h:mm:ss},
			Ed => q{d E},
			GyMMM => q{MMM G y},
			GyMMMEd => q{E, d MMM, G y},
			GyMMMd => q{d MMM, G y},
			GyMd => q{GGGGG d/M/y},
			Hm => q{H:mm},
			Hms => q{H:mm:ss},
			MEd => q{E, d/M},
			MMMEd => q{E, d MMM},
			MMMMW => q{MMMM चा W रा आठवडा},
			MMMMd => q{d MMMM},
			MMMd => q{d MMM},
			MMdd => q{dd-MM},
			Md => q{d/M},
			yM => q{M/y},
			yMEd => q{E, d/M/y},
			yMM => q{MM-y},
			yMMM => q{MMM y},
			yMMMEd => q{E, d, MMM y},
			yMMMM => q{MMMM y},
			yMMMd => q{d MMM, y},
			yMd => q{d/M/y},
			yQQQ => q{QQQ y},
			yQQQQ => q{QQQQ y},
			yw => q{Y चा w वा आठवडा},
		},
	} },
);

has 'datetime_formats_append_item' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
	} },
);

has 'datetime_formats_interval' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			M => {
				M => q{M – M},
			},
			MEd => {
				M => q{E, d/M – E, d/M},
				d => q{E, d/M – E, d/M},
			},
			MMM => {
				M => q{MMM – MMM},
			},
			MMMEd => {
				M => q{E, d MMM – E, d MMM},
				d => q{E, d MMM – E, d MMM},
			},
			MMMd => {
				M => q{d MMM – d MMM},
				d => q{d – d MMM},
			},
			Md => {
				M => q{d/M – d/M},
				d => q{d/M – d/M},
			},
			d => {
				d => q{d – d},
			},
			fallback => '{0} – {1}',
			y => {
				y => q{y – y G},
			},
			yM => {
				M => q{M/y – M/y GGGGG},
				y => q{M/y – M/y GGGGG},
			},
			yMEd => {
				M => q{E, d/M/y – E, d/M/y GGGGG},
				d => q{E, d/M/y – E, d/M/y GGGGG},
				y => q{E, d/M/y – E, d/M/y GGGGG},
			},
			yMMM => {
				M => q{MMM – MMM y G},
				y => q{MMM y – MMM y G},
			},
			yMMMEd => {
				M => q{E, d MMM – E, d MMM y G},
				d => q{E, d MMM y – E, d MMM, y G},
				y => q{E, d MMM y – E, d MMM y G},
			},
			yMMMM => {
				M => q{MMMM – MMMM y G},
				y => q{MMMM y – MMMM y G},
			},
			yMMMd => {
				M => q{d MMM – d, MMM y G},
				d => q{d – d, MMM y G},
				y => q{d, MMM y – d, MMM y G},
			},
			yMd => {
				M => q{d/M/y – d/M/y GGGGG},
				d => q{d/M/y – d/M/y GGGGG},
				y => q{d/M/y – d/M/y GGGGG},
			},
		},
		'gregorian' => {
			GyMEd => {
				G => q{GGGGG dd-MM-y, E – GGGGG dd-MM-y, E},
				M => q{GGGGG dd-MM-y, E – dd-MM-y, E},
				d => q{GGGGG dd-MM-y, E – dd-MM-y, E},
				y => q{GGGGG dd-MM-y, E – dd-MM-y, E},
			},
			GyMd => {
				y => q{GGGGG dd-MM-y – dd-MM-y},
			},
			H => {
				H => q{HH – HH},
			},
			Hm => {
				H => q{HH:mm – HH:mm},
				m => q{HH:mm – HH:mm},
			},
			Hmv => {
				H => q{HH:mm – HH:mm v},
				m => q{HH:mm – HH:mm v},
			},
			M => {
				M => q{M – M},
			},
			MEd => {
				M => q{E, d/M – E, d/M},
				d => q{E, d/M – E, d/M},
			},
			MMM => {
				M => q{MMM – MMM},
			},
			MMMEd => {
				M => q{E, d MMM – E, d MMM},
				d => q{E, d MMM – E, d MMM},
			},
			MMMd => {
				M => q{d MMM – d MMM},
				d => q{d – d MMM},
			},
			Md => {
				M => q{d/M – d/M},
				d => q{d/M – d/M},
			},
			d => {
				d => q{d – d},
			},
			fallback => '{0} – {1}',
			h => {
				h => q{h – h a},
			},
			hm => {
				h => q{h:mm – h:mm a},
				m => q{h:mm – h:mm a},
			},
			hmv => {
				h => q{h:mm – h:mm a v},
				m => q{h:mm – h:mm a v},
			},
			y => {
				y => q{y – y},
			},
			yM => {
				M => q{M/y – M/y},
				y => q{M/y – M/y},
			},
			yMEd => {
				M => q{E, d/M/y – E, d/M/y},
				d => q{E, d/M/y – E, d/M/y},
				y => q{E, d/M/y – E, d/M/y},
			},
			yMMM => {
				M => q{MMM – MMM y},
				y => q{MMM y – MMM y},
			},
			yMMMEd => {
				M => q{E, d MMM – E, d MMM, y},
				d => q{E, d MMM y – E, d MMM, y},
				y => q{E, d MMM, y – E, d MMM, y},
			},
			yMMMM => {
				M => q{MMMM – MMMM y},
				y => q{MMMM y – MMMM y},
			},
			yMMMd => {
				M => q{d MMM – d MMM, y},
				d => q{d – d MMM, y},
				y => q{d MMM, y – d MMM, y},
			},
			yMd => {
				M => q{d/M/y – d/M/y},
				d => q{d/M/y – d/M/y},
				y => q{d/M/y – d/M/y},
			},
		},
	} },
);

has 'time_zone_names' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default	=> sub { {
		gmtFormat => q([GMT]{0}),
		gmtZeroFormat => q([GMT]),
		regionFormat => q({0} वेळ),
		regionFormat => q({0} सूर्यप्रकाश वेळ),
		regionFormat => q({0} प्रमाण वेळ),
		'Acre' => {
			long => {
				'daylight' => q#ऐकर ग्रीष्म वेळ#,
				'generic' => q#एकर वेळ#,
				'standard' => q#एकर प्रमाणवेळ#,
			},
		},
		'Afghanistan' => {
			long => {
				'standard' => q#अफगाणिस्तान वेळ#,
			},
		},
		'Africa/Abidjan' => {
			exemplarCity => q#अबिद्जान#,
		},
		'Africa/Accra' => {
			exemplarCity => q#अ‍ॅक्रा#,
		},
		'Africa/Addis_Ababa' => {
			exemplarCity => q#आदिस अबाबा#,
		},
		'Africa/Algiers' => {
			exemplarCity => q#अल्जिअर्स#,
		},
		'Africa/Asmera' => {
			exemplarCity => q#एस्मारा#,
		},
		'Africa/Bamako' => {
			exemplarCity => q#बामको#,
		},
		'Africa/Bangui' => {
			exemplarCity => q#बांगुई#,
		},
		'Africa/Banjul' => {
			exemplarCity => q#बंजुल#,
		},
		'Africa/Bissau' => {
			exemplarCity => q#बिसाउ#,
		},
		'Africa/Blantyre' => {
			exemplarCity => q#ब्लँटायर#,
		},
		'Africa/Brazzaville' => {
			exemplarCity => q#ब्राझाव्हिले#,
		},
		'Africa/Bujumbura' => {
			exemplarCity => q#बुजुंबुरा#,
		},
		'Africa/Cairo' => {
			exemplarCity => q#कैरो#,
		},
		'Africa/Casablanca' => {
			exemplarCity => q#कॅसाब्लान्का#,
		},
		'Africa/Ceuta' => {
			exemplarCity => q#सेउटा#,
		},
		'Africa/Conakry' => {
			exemplarCity => q#कोनाक्रि#,
		},
		'Africa/Dakar' => {
			exemplarCity => q#डकर#,
		},
		'Africa/Dar_es_Salaam' => {
			exemplarCity => q#दार ए सलाम#,
		},
		'Africa/Djibouti' => {
			exemplarCity => q#जिबौटी#,
		},
		'Africa/Douala' => {
			exemplarCity => q#दोउआला#,
		},
		'Africa/El_Aaiun' => {
			exemplarCity => q#एल ऐउन#,
		},
		'Africa/Freetown' => {
			exemplarCity => q#फ्रीटाउन#,
		},
		'Africa/Gaborone' => {
			exemplarCity => q#गाबोरोन#,
		},
		'Africa/Harare' => {
			exemplarCity => q#हरारे#,
		},
		'Africa/Johannesburg' => {
			exemplarCity => q#जोहान्सबर्ग#,
		},
		'Africa/Juba' => {
			exemplarCity => q#जुबा#,
		},
		'Africa/Kampala' => {
			exemplarCity => q#कंपाला#,
		},
		'Africa/Khartoum' => {
			exemplarCity => q#खार्टुम#,
		},
		'Africa/Kigali' => {
			exemplarCity => q#कीगाली#,
		},
		'Africa/Kinshasa' => {
			exemplarCity => q#किन्शासा#,
		},
		'Africa/Lagos' => {
			exemplarCity => q#लागोस#,
		},
		'Africa/Libreville' => {
			exemplarCity => q#लिबरव्हिल#,
		},
		'Africa/Lome' => {
			exemplarCity => q#लोम#,
		},
		'Africa/Luanda' => {
			exemplarCity => q#लुआंडा#,
		},
		'Africa/Lubumbashi' => {
			exemplarCity => q#लुबंबाशी#,
		},
		'Africa/Lusaka' => {
			exemplarCity => q#लुसाका#,
		},
		'Africa/Malabo' => {
			exemplarCity => q#मलाबो#,
		},
		'Africa/Maputo' => {
			exemplarCity => q#मापुटो#,
		},
		'Africa/Maseru' => {
			exemplarCity => q#मसेरु#,
		},
		'Africa/Mbabane' => {
			exemplarCity => q#अंबाबाने#,
		},
		'Africa/Mogadishu' => {
			exemplarCity => q#मोगादिशु#,
		},
		'Africa/Monrovia' => {
			exemplarCity => q#मोनरोव्हिया#,
		},
		'Africa/Nairobi' => {
			exemplarCity => q#नैरोबी#,
		},
		'Africa/Ndjamena' => {
			exemplarCity => q#इंजामेना#,
		},
		'Africa/Niamey' => {
			exemplarCity => q#नियामे#,
		},
		'Africa/Nouakchott' => {
			exemplarCity => q#नुवाकसुत#,
		},
		'Africa/Ouagadougou' => {
			exemplarCity => q#वागडूगू#,
		},
		'Africa/Porto-Novo' => {
			exemplarCity => q#पोर्टो-नोव्हो#,
		},
		'Africa/Sao_Tome' => {
			exemplarCity => q#साओ तोमे#,
		},
		'Africa/Tripoli' => {
			exemplarCity => q#त्रिपोली#,
		},
		'Africa/Tunis' => {
			exemplarCity => q#टयूनिस#,
		},
		'Africa/Windhoek' => {
			exemplarCity => q#विंडहोएक#,
		},
		'Africa_Central' => {
			long => {
				'standard' => q#मध्‍य आफ्रिका वेळ#,
			},
		},
		'Africa_Eastern' => {
			long => {
				'standard' => q#पूर्व आफ्रिका वेळ#,
			},
		},
		'Africa_Southern' => {
			long => {
				'standard' => q#दक्षिण आफ्रिका प्रमाण वेळ#,
			},
		},
		'Africa_Western' => {
			long => {
				'daylight' => q#पश्चिम आफ्रिका उन्हाळी वेळ#,
				'generic' => q#पश्चिम आफ्रिका वेळ#,
				'standard' => q#पश्चिम आफ्रिका प्रमाण वेळ#,
			},
		},
		'Alaska' => {
			long => {
				'daylight' => q#अलास्का सूर्यप्रकाश वेळ#,
				'generic' => q#अलास्का वेळ#,
				'standard' => q#अलास्का प्रमाण वेळ#,
			},
		},
		'Almaty' => {
			long => {
				'daylight' => q#अल्माटी ग्रीष्मकालीन वेळ#,
				'generic' => q#अल्माटी वेळ#,
				'standard' => q#अल्माटी प्रमाणवेळ#,
			},
		},
		'Amazon' => {
			long => {
				'daylight' => q#अ‍ॅमेझॉन उन्हाळी वेळ#,
				'generic' => q#अ‍ॅमेझॉन वेळ#,
				'standard' => q#अ‍ॅमेझॉन प्रमाण वेळ#,
			},
		},
		'America/Adak' => {
			exemplarCity => q#अडॅक#,
		},
		'America/Anchorage' => {
			exemplarCity => q#अँकरेज#,
		},
		'America/Anguilla' => {
			exemplarCity => q#अँग्विला#,
		},
		'America/Antigua' => {
			exemplarCity => q#अँटिग्वा#,
		},
		'America/Araguaina' => {
			exemplarCity => q#अरागायना#,
		},
		'America/Argentina/La_Rioja' => {
			exemplarCity => q#ला रियोजा#,
		},
		'America/Argentina/Rio_Gallegos' => {
			exemplarCity => q#रियो गॅलेगॉस#,
		},
		'America/Argentina/Salta' => {
			exemplarCity => q#सॉल्ता#,
		},
		'America/Argentina/San_Juan' => {
			exemplarCity => q#सान जुआन#,
		},
		'America/Argentina/San_Luis' => {
			exemplarCity => q#सान ल्युइस#,
		},
		'America/Argentina/Tucuman' => {
			exemplarCity => q#टुकुमान#,
		},
		'America/Argentina/Ushuaia' => {
			exemplarCity => q#उस्वाइया#,
		},
		'America/Aruba' => {
			exemplarCity => q#अरुबा#,
		},
		'America/Asuncion' => {
			exemplarCity => q#आसुन्सियोन#,
		},
		'America/Bahia' => {
			exemplarCity => q#बहिया#,
		},
		'America/Bahia_Banderas' => {
			exemplarCity => q#बाहिया बांदेरास#,
		},
		'America/Barbados' => {
			exemplarCity => q#बार्बाडोस#,
		},
		'America/Belem' => {
			exemplarCity => q#बेलेम#,
		},
		'America/Belize' => {
			exemplarCity => q#बेलिझे#,
		},
		'America/Blanc-Sablon' => {
			exemplarCity => q#ब्लांक सॅबलोन#,
		},
		'America/Boa_Vista' => {
			exemplarCity => q#बोआ व्हिस्टा#,
		},
		'America/Bogota' => {
			exemplarCity => q#बोगोटा#,
		},
		'America/Boise' => {
			exemplarCity => q#बोइसी#,
		},
		'America/Buenos_Aires' => {
			exemplarCity => q#ब्युनोस आयर्स#,
		},
		'America/Cambridge_Bay' => {
			exemplarCity => q#केंब्रिज उपसागर#,
		},
		'America/Campo_Grande' => {
			exemplarCity => q#कॅम्पो ग्रँडे#,
		},
		'America/Cancun' => {
			exemplarCity => q#कानकुन#,
		},
		'America/Caracas' => {
			exemplarCity => q#कराकास#,
		},
		'America/Catamarca' => {
			exemplarCity => q#कॅटामार्का#,
		},
		'America/Cayenne' => {
			exemplarCity => q#कायेने#,
		},
		'America/Cayman' => {
			exemplarCity => q#केमन#,
		},
		'America/Chicago' => {
			exemplarCity => q#शिकागो#,
		},
		'America/Chihuahua' => {
			exemplarCity => q#चिहुआहुआ#,
		},
		'America/Ciudad_Juarez' => {
			exemplarCity => q#सिउदाद हुआरेझ#,
		},
		'America/Coral_Harbour' => {
			exemplarCity => q#अॅटिकोकन#,
		},
		'America/Cordoba' => {
			exemplarCity => q#कॉर्डोबा#,
		},
		'America/Costa_Rica' => {
			exemplarCity => q#कोस्टा रिका#,
		},
		'America/Creston' => {
			exemplarCity => q#क्रेस्टन#,
		},
		'America/Cuiaba' => {
			exemplarCity => q#कुयाबा#,
		},
		'America/Curacao' => {
			exemplarCity => q#क्युरासाओ#,
		},
		'America/Danmarkshavn' => {
			exemplarCity => q#डेन्मार्कशॉन#,
		},
		'America/Dawson' => {
			exemplarCity => q#डॉसन#,
		},
		'America/Dawson_Creek' => {
			exemplarCity => q#डॉसन क्रीक#,
		},
		'America/Denver' => {
			exemplarCity => q#डेन्व्हर#,
		},
		'America/Detroit' => {
			exemplarCity => q#डेट्रॉइट#,
		},
		'America/Dominica' => {
			exemplarCity => q#डोमिनिका#,
		},
		'America/Edmonton' => {
			exemplarCity => q#एडमाँटन#,
		},
		'America/Eirunepe' => {
			exemplarCity => q#यूरुनीपे#,
		},
		'America/El_Salvador' => {
			exemplarCity => q#एल साल्वाडोर#,
		},
		'America/Fort_Nelson' => {
			exemplarCity => q#फोर्ट नेल्सन#,
		},
		'America/Fortaleza' => {
			exemplarCity => q#फोर्टालेझा#,
		},
		'America/Glace_Bay' => {
			exemplarCity => q#ग्लेस उपसागर#,
		},
		'America/Godthab' => {
			exemplarCity => q#नूक#,
		},
		'America/Goose_Bay' => {
			exemplarCity => q#गूस उपसागर#,
		},
		'America/Grand_Turk' => {
			exemplarCity => q#ग्रँड टर्क#,
		},
		'America/Grenada' => {
			exemplarCity => q#ग्रेनेडा#,
		},
		'America/Guadeloupe' => {
			exemplarCity => q#ग्वाडेलोउपे#,
		},
		'America/Guatemala' => {
			exemplarCity => q#ग्वाटेमाला#,
		},
		'America/Guayaquil' => {
			exemplarCity => q#गयाक्विल#,
		},
		'America/Guyana' => {
			exemplarCity => q#गयाना#,
		},
		'America/Halifax' => {
			exemplarCity => q#हॅलिफॅक्स#,
		},
		'America/Havana' => {
			exemplarCity => q#हवाना#,
		},
		'America/Hermosillo' => {
			exemplarCity => q#हर्मोसिलो#,
		},
		'America/Indiana/Knox' => {
			exemplarCity => q#नॉक्स, इंडियाना#,
		},
		'America/Indiana/Marengo' => {
			exemplarCity => q#मारेंगो, इंडियाना#,
		},
		'America/Indiana/Petersburg' => {
			exemplarCity => q#पीटर्सबर्ग, इंडियाना#,
		},
		'America/Indiana/Tell_City' => {
			exemplarCity => q#टेल सिटी, इंडियाना#,
		},
		'America/Indiana/Vevay' => {
			exemplarCity => q#वेवाय-इंडियाना#,
		},
		'America/Indiana/Vincennes' => {
			exemplarCity => q#विंसेनस, इंडियाना#,
		},
		'America/Indiana/Winamac' => {
			exemplarCity => q#विनमॅक, इंडियाना#,
		},
		'America/Indianapolis' => {
			exemplarCity => q#इंडियानापोलिस#,
		},
		'America/Inuvik' => {
			exemplarCity => q#इनुविक#,
		},
		'America/Iqaluit' => {
			exemplarCity => q#इकालुइत#,
		},
		'America/Jamaica' => {
			exemplarCity => q#जमैका#,
		},
		'America/Jujuy' => {
			exemplarCity => q#जुजुय#,
		},
		'America/Juneau' => {
			exemplarCity => q#ज्यूनौ#,
		},
		'America/Kentucky/Monticello' => {
			exemplarCity => q#माँटिसेलो, केंटुकी#,
		},
		'America/Kralendijk' => {
			exemplarCity => q#क्रालेंदिजिक#,
		},
		'America/La_Paz' => {
			exemplarCity => q#ला पाझ#,
		},
		'America/Lima' => {
			exemplarCity => q#लीमा#,
		},
		'America/Los_Angeles' => {
			exemplarCity => q#लॉस एंजेलिस#,
		},
		'America/Louisville' => {
			exemplarCity => q#ल्युइसव्हिल#,
		},
		'America/Lower_Princes' => {
			exemplarCity => q#लोअर प्रिन्सस क्वार्टर#,
		},
		'America/Maceio' => {
			exemplarCity => q#मेसेइओ#,
		},
		'America/Managua' => {
			exemplarCity => q#मानागुआ#,
		},
		'America/Manaus' => {
			exemplarCity => q#मनौस#,
		},
		'America/Marigot' => {
			exemplarCity => q#मेरीगोट#,
		},
		'America/Martinique' => {
			exemplarCity => q#मार्टिनिक#,
		},
		'America/Matamoros' => {
			exemplarCity => q#माटामोरोस#,
		},
		'America/Mazatlan' => {
			exemplarCity => q#माझातलान#,
		},
		'America/Mendoza' => {
			exemplarCity => q#मेंदोझा#,
		},
		'America/Menominee' => {
			exemplarCity => q#मेनोमिनी#,
		},
		'America/Merida' => {
			exemplarCity => q#मेरिडा#,
		},
		'America/Metlakatla' => {
			exemplarCity => q#मेतलाकतला#,
		},
		'America/Mexico_City' => {
			exemplarCity => q#मेक्सिको सिटी#,
		},
		'America/Miquelon' => {
			exemplarCity => q#मिक्वेलोन#,
		},
		'America/Moncton' => {
			exemplarCity => q#माँकटन#,
		},
		'America/Monterrey' => {
			exemplarCity => q#मॉन्टेरे#,
		},
		'America/Montevideo' => {
			exemplarCity => q#मोन्टेव्हिडियो#,
		},
		'America/Montserrat' => {
			exemplarCity => q#माँन्टसेरात#,
		},
		'America/Nassau' => {
			exemplarCity => q#नसाऊ#,
		},
		'America/New_York' => {
			exemplarCity => q#न्यूयॉर्क#,
		},
		'America/Nipigon' => {
			exemplarCity => q#निपिगोन#,
		},
		'America/Nome' => {
			exemplarCity => q#नोम#,
		},
		'America/Noronha' => {
			exemplarCity => q#नोरोन्हा#,
		},
		'America/North_Dakota/Beulah' => {
			exemplarCity => q#ब्युलाह, उत्तर डकोटा#,
		},
		'America/North_Dakota/Center' => {
			exemplarCity => q#मध्य, उत्तर डकोटा#,
		},
		'America/North_Dakota/New_Salem' => {
			exemplarCity => q#न्यू सालेम, उत्तर डकोटा#,
		},
		'America/Ojinaga' => {
			exemplarCity => q#ओजिनागा#,
		},
		'America/Panama' => {
			exemplarCity => q#पनामा#,
		},
		'America/Pangnirtung' => {
			exemplarCity => q#पँगनिरतुंग#,
		},
		'America/Paramaribo' => {
			exemplarCity => q#पारमरीबो#,
		},
		'America/Phoenix' => {
			exemplarCity => q#फॉनिक्स#,
		},
		'America/Port-au-Prince' => {
			exemplarCity => q#पोर्ट-औ-प्रिंस#,
		},
		'America/Port_of_Spain' => {
			exemplarCity => q#पोर्ट ऑफ स्पेन#,
		},
		'America/Porto_Velho' => {
			exemplarCity => q#पोर्टो वेल्हो#,
		},
		'America/Puerto_Rico' => {
			exemplarCity => q#प्युएर्तो रिको#,
		},
		'America/Punta_Arenas' => {
			exemplarCity => q#पुंता अरीनास#,
		},
		'America/Rainy_River' => {
			exemplarCity => q#रेनी नदी#,
		},
		'America/Rankin_Inlet' => {
			exemplarCity => q#रॅनकिन इनलेट#,
		},
		'America/Recife' => {
			exemplarCity => q#रेसिफे#,
		},
		'America/Regina' => {
			exemplarCity => q#रेजिना#,
		},
		'America/Resolute' => {
			exemplarCity => q#रेजोल्यूट#,
		},
		'America/Rio_Branco' => {
			exemplarCity => q#रियो ब्रांको#,
		},
		'America/Santa_Isabel' => {
			exemplarCity => q#सांता इसाबेल#,
		},
		'America/Santarem' => {
			exemplarCity => q#सँटारेम#,
		},
		'America/Santiago' => {
			exemplarCity => q#सॅन्टिएगो#,
		},
		'America/Santo_Domingo' => {
			exemplarCity => q#सॅन्टो डोमिंगो#,
		},
		'America/Sao_Paulo' => {
			exemplarCity => q#साओ पावलो#,
		},
		'America/Scoresbysund' => {
			exemplarCity => q#इटोकॉरटॉर्मीट#,
		},
		'America/Sitka' => {
			exemplarCity => q#सिटका#,
		},
		'America/St_Barthelemy' => {
			exemplarCity => q#सेंट बार्थेलेमी#,
		},
		'America/St_Johns' => {
			exemplarCity => q#सेंट जॉन्स#,
		},
		'America/St_Kitts' => {
			exemplarCity => q#सेंट किट्स#,
		},
		'America/St_Lucia' => {
			exemplarCity => q#सेंट लुसिया#,
		},
		'America/St_Thomas' => {
			exemplarCity => q#सेंट थॉमस#,
		},
		'America/St_Vincent' => {
			exemplarCity => q#सेंट विन्सेंट#,
		},
		'America/Swift_Current' => {
			exemplarCity => q#स्विफ्ट करंट#,
		},
		'America/Tegucigalpa' => {
			exemplarCity => q#टेगुसिगाल्पा#,
		},
		'America/Thule' => {
			exemplarCity => q#थुले#,
		},
		'America/Thunder_Bay' => {
			exemplarCity => q#थंडर उपसागर#,
		},
		'America/Tijuana' => {
			exemplarCity => q#तिजुआना#,
		},
		'America/Toronto' => {
			exemplarCity => q#टोरोंटो#,
		},
		'America/Tortola' => {
			exemplarCity => q#टोर्टोला#,
		},
		'America/Vancouver' => {
			exemplarCity => q#व्हॅनकुव्हर#,
		},
		'America/Whitehorse' => {
			exemplarCity => q#व्हाइटहॉर्स#,
		},
		'America/Winnipeg' => {
			exemplarCity => q#विनीपेग#,
		},
		'America/Yakutat' => {
			exemplarCity => q#यकुतात#,
		},
		'America/Yellowknife' => {
			exemplarCity => q#यलोनाइफ#,
		},
		'America_Central' => {
			long => {
				'daylight' => q#केंद्रीय सूर्यप्रकाश वेळ#,
				'generic' => q#केंद्रीय वेळ#,
				'standard' => q#केंद्रीय प्रमाण वेळ#,
			},
		},
		'America_Eastern' => {
			long => {
				'daylight' => q#पौर्वात्य सूर्यप्रकाश वेळ#,
				'generic' => q#पौर्वात्य वेळ#,
				'standard' => q#पौर्वात्य प्रमाण वेळ#,
			},
		},
		'America_Mountain' => {
			long => {
				'daylight' => q#पर्वतीय सूर्यप्रकाश वेळ#,
				'generic' => q#पर्वतीय वेळ#,
				'standard' => q#पर्वतीय प्रमाण वेळ#,
			},
		},
		'America_Pacific' => {
			long => {
				'daylight' => q#पॅसिफिक सूर्यप्रकाश वेळ#,
				'generic' => q#पॅसिफिक वेळ#,
				'standard' => q#पॅसिफिक प्रमाण वेळ#,
			},
		},
		'Anadyr' => {
			long => {
				'daylight' => q#अनादीर ग्रीष्मकालीन वेळ#,
				'generic' => q#एनाडीयर वेळ#,
				'standard' => q#अनादीर प्रमाणवेळ#,
			},
		},
		'Antarctica/Casey' => {
			exemplarCity => q#कॅसे#,
		},
		'Antarctica/Davis' => {
			exemplarCity => q#डेव्हिस#,
		},
		'Antarctica/DumontDUrville' => {
			exemplarCity => q#ड्युमॉन्ट ड्युर्विल#,
		},
		'Antarctica/Macquarie' => {
			exemplarCity => q#मॅक्वायर#,
		},
		'Antarctica/Mawson' => {
			exemplarCity => q#मॉसन#,
		},
		'Antarctica/McMurdo' => {
			exemplarCity => q#मॅक्मुरडो#,
		},
		'Antarctica/Palmer' => {
			exemplarCity => q#पामेर#,
		},
		'Antarctica/Rothera' => {
			exemplarCity => q#रोथेरा#,
		},
		'Antarctica/Syowa' => {
			exemplarCity => q#स्योवा#,
		},
		'Antarctica/Troll' => {
			exemplarCity => q#ट्रोल#,
		},
		'Antarctica/Vostok' => {
			exemplarCity => q#वोस्टोक#,
		},
		'Apia' => {
			long => {
				'daylight' => q#एपिया सूर्यप्रकाश वेळ#,
				'generic' => q#एपिया वेळ#,
				'standard' => q#एपिया प्रमाण वेळ#,
			},
		},
		'Aqtau' => {
			long => {
				'daylight' => q#अ‍ॅक्ताउ ग्रीष्मकालीन वेळ#,
				'generic' => q#अ‍ॅक्ताउ वेळ#,
				'standard' => q#अ‍ॅक्ताउ प्रमाणवेळ#,
			},
		},
		'Aqtobe' => {
			long => {
				'daylight' => q#अ‍ॅक्टोबे ग्रीष्मकालीन वेळ#,
				'generic' => q#अ‍ॅक्टोबे वेळ#,
				'standard' => q#अ‍ॅक्टोबे प्रमाणवेळ#,
			},
		},
		'Arabian' => {
			long => {
				'daylight' => q#अरेबियन सूर्यप्रकाश वेळ#,
				'generic' => q#अरेबियन वेळ#,
				'standard' => q#अरेबियन प्रमाण वेळ#,
			},
		},
		'Arctic/Longyearbyen' => {
			exemplarCity => q#लाँगइयरबीयेन#,
		},
		'Argentina' => {
			long => {
				'daylight' => q#अर्जेंटिना उन्हाळी वेळ#,
				'generic' => q#अर्जेंटिना वेळ#,
				'standard' => q#अर्जेंटिना प्रमाण वेळ#,
			},
		},
		'Argentina_Western' => {
			long => {
				'daylight' => q#पश्चिमी अर्जेंटिना उन्हाळी वेळ#,
				'generic' => q#पश्चिमी अर्जेंटिना वेळ#,
				'standard' => q#पश्चिमी अर्जेंटिना प्रमाण वेळ#,
			},
		},
		'Armenia' => {
			long => {
				'daylight' => q#आर्मेनिया उन्हाळी वेळ#,
				'generic' => q#आर्मेनिया वेळ#,
				'standard' => q#आर्मेनिया प्रमाण वेळ#,
			},
		},
		'Asia/Aden' => {
			exemplarCity => q#एडेन#,
		},
		'Asia/Almaty' => {
			exemplarCity => q#अल्माटी#,
		},
		'Asia/Amman' => {
			exemplarCity => q#अम्मान#,
		},
		'Asia/Anadyr' => {
			exemplarCity => q#एनाडीयर#,
		},
		'Asia/Aqtau' => {
			exemplarCity => q#अ‍ॅक्टौ#,
		},
		'Asia/Aqtobe' => {
			exemplarCity => q#अ‍ॅक्टोबे#,
		},
		'Asia/Ashgabat' => {
			exemplarCity => q#अश्गाबात#,
		},
		'Asia/Atyrau' => {
			exemplarCity => q#अतिरॉ#,
		},
		'Asia/Baghdad' => {
			exemplarCity => q#बगदाद#,
		},
		'Asia/Bahrain' => {
			exemplarCity => q#बेहरीन#,
		},
		'Asia/Baku' => {
			exemplarCity => q#बाकु#,
		},
		'Asia/Bangkok' => {
			exemplarCity => q#बँकॉक#,
		},
		'Asia/Barnaul' => {
			exemplarCity => q#बर्नौल#,
		},
		'Asia/Beirut' => {
			exemplarCity => q#बैरुत#,
		},
		'Asia/Bishkek' => {
			exemplarCity => q#बिश्केक#,
		},
		'Asia/Brunei' => {
			exemplarCity => q#ब्रुनेई#,
		},
		'Asia/Calcutta' => {
			exemplarCity => q#कोलकाता#,
		},
		'Asia/Chita' => {
			exemplarCity => q#चिता#,
		},
		'Asia/Choibalsan' => {
			exemplarCity => q#चोईबाल्सन#,
		},
		'Asia/Colombo' => {
			exemplarCity => q#कोलंबो#,
		},
		'Asia/Damascus' => {
			exemplarCity => q#दमास्कस#,
		},
		'Asia/Dhaka' => {
			exemplarCity => q#ढाका#,
		},
		'Asia/Dili' => {
			exemplarCity => q#डिलि#,
		},
		'Asia/Dubai' => {
			exemplarCity => q#दुबई#,
		},
		'Asia/Dushanbe' => {
			exemplarCity => q#दुशान्बे#,
		},
		'Asia/Famagusta' => {
			exemplarCity => q#फॅमगुस्ता#,
		},
		'Asia/Gaza' => {
			exemplarCity => q#गाझा#,
		},
		'Asia/Hebron' => {
			exemplarCity => q#हेब्रॉन#,
		},
		'Asia/Hong_Kong' => {
			exemplarCity => q#हाँगकाँग#,
		},
		'Asia/Hovd' => {
			exemplarCity => q#होव्ड#,
		},
		'Asia/Irkutsk' => {
			exemplarCity => q#ईर्कुत्स्क#,
		},
		'Asia/Jakarta' => {
			exemplarCity => q#जकार्ता#,
		},
		'Asia/Jayapura' => {
			exemplarCity => q#जयापुरा#,
		},
		'Asia/Jerusalem' => {
			exemplarCity => q#जेरुसलेम#,
		},
		'Asia/Kabul' => {
			exemplarCity => q#काबूल#,
		},
		'Asia/Kamchatka' => {
			exemplarCity => q#कॅमचाटका#,
		},
		'Asia/Karachi' => {
			exemplarCity => q#कराची#,
		},
		'Asia/Katmandu' => {
			exemplarCity => q#काठमांडू#,
		},
		'Asia/Khandyga' => {
			exemplarCity => q#खंदिगा#,
		},
		'Asia/Krasnoyarsk' => {
			exemplarCity => q#क्रास्नोयार्स्क#,
		},
		'Asia/Kuala_Lumpur' => {
			exemplarCity => q#क्वालालंपूर#,
		},
		'Asia/Kuching' => {
			exemplarCity => q#कुचिंग#,
		},
		'Asia/Kuwait' => {
			exemplarCity => q#कुवेत#,
		},
		'Asia/Macau' => {
			exemplarCity => q#मकाऊ#,
		},
		'Asia/Magadan' => {
			exemplarCity => q#मेगाडन#,
		},
		'Asia/Makassar' => {
			exemplarCity => q#मकस्सार#,
		},
		'Asia/Manila' => {
			exemplarCity => q#मनिला#,
		},
		'Asia/Muscat' => {
			exemplarCity => q#मस्कत#,
		},
		'Asia/Nicosia' => {
			exemplarCity => q#निकोसिया#,
		},
		'Asia/Novokuznetsk' => {
			exemplarCity => q#नोवोकुझ्नेत्स्क#,
		},
		'Asia/Novosibirsk' => {
			exemplarCity => q#नोवोसिबिर्स्क#,
		},
		'Asia/Omsk' => {
			exemplarCity => q#ओम्स्क#,
		},
		'Asia/Oral' => {
			exemplarCity => q#ओरल#,
		},
		'Asia/Phnom_Penh' => {
			exemplarCity => q#प्नोम पेन्ह#,
		},
		'Asia/Pontianak' => {
			exemplarCity => q#पाँटियानाक#,
		},
		'Asia/Pyongyang' => {
			exemplarCity => q#प्योंगयांग#,
		},
		'Asia/Qatar' => {
			exemplarCity => q#कतार#,
		},
		'Asia/Qostanay' => {
			exemplarCity => q#कोस्टाने#,
		},
		'Asia/Qyzylorda' => {
			exemplarCity => q#किझीलोर्डा#,
		},
		'Asia/Rangoon' => {
			exemplarCity => q#रंगून#,
		},
		'Asia/Riyadh' => {
			exemplarCity => q#रियाध#,
		},
		'Asia/Saigon' => {
			exemplarCity => q#हो चि मिन्ह शहर#,
		},
		'Asia/Sakhalin' => {
			exemplarCity => q#साखालिन#,
		},
		'Asia/Samarkand' => {
			exemplarCity => q#समरकंद#,
		},
		'Asia/Seoul' => {
			exemplarCity => q#सेउल#,
		},
		'Asia/Shanghai' => {
			exemplarCity => q#शांघाय#,
		},
		'Asia/Singapore' => {
			exemplarCity => q#सिंगापूर#,
		},
		'Asia/Srednekolymsk' => {
			exemplarCity => q#स्रेदनेकोलीम्स्क#,
		},
		'Asia/Taipei' => {
			exemplarCity => q#तैपेई#,
		},
		'Asia/Tashkent' => {
			exemplarCity => q#ताश्कंद#,
		},
		'Asia/Tbilisi' => {
			exemplarCity => q#बिलिसी#,
		},
		'Asia/Tehran' => {
			exemplarCity => q#तेहरान#,
		},
		'Asia/Thimphu' => {
			exemplarCity => q#थिंफू#,
		},
		'Asia/Tokyo' => {
			exemplarCity => q#टोकियो#,
		},
		'Asia/Tomsk' => {
			exemplarCity => q#तोमसक#,
		},
		'Asia/Ulaanbaatar' => {
			exemplarCity => q#उलानबातर#,
		},
		'Asia/Urumqi' => {
			exemplarCity => q#उरुम्की#,
		},
		'Asia/Ust-Nera' => {
			exemplarCity => q#उस्त-नेरा#,
		},
		'Asia/Vientiane' => {
			exemplarCity => q#व्हिएन्टाइन#,
		},
		'Asia/Vladivostok' => {
			exemplarCity => q#व्लादिवोस्टोक#,
		},
		'Asia/Yakutsk' => {
			exemplarCity => q#यकुत्स्क#,
		},
		'Asia/Yekaterinburg' => {
			exemplarCity => q#येक्तेरिनबर्ग#,
		},
		'Asia/Yerevan' => {
			exemplarCity => q#येरेवन#,
		},
		'Atlantic' => {
			long => {
				'daylight' => q#अटलांटिक सूर्यप्रकाश वेळ#,
				'generic' => q#अटलांटिक वेळ#,
				'standard' => q#अटलांटिक प्रमाण वेळ#,
			},
		},
		'Atlantic/Azores' => {
			exemplarCity => q#अझोरेस#,
		},
		'Atlantic/Bermuda' => {
			exemplarCity => q#बर्मुडा#,
		},
		'Atlantic/Canary' => {
			exemplarCity => q#कॅनरी#,
		},
		'Atlantic/Cape_Verde' => {
			exemplarCity => q#केप व्हर्डे#,
		},
		'Atlantic/Faeroe' => {
			exemplarCity => q#फॅरो#,
		},
		'Atlantic/Madeira' => {
			exemplarCity => q#मडीयरा#,
		},
		'Atlantic/Reykjavik' => {
			exemplarCity => q#रेयक्जाविक#,
		},
		'Atlantic/South_Georgia' => {
			exemplarCity => q#दक्षिण जॉर्जिया#,
		},
		'Atlantic/St_Helena' => {
			exemplarCity => q#सेंट. हेलेना#,
		},
		'Atlantic/Stanley' => {
			exemplarCity => q#स्टॅनले#,
		},
		'Australia/Adelaide' => {
			exemplarCity => q#एडलेड#,
		},
		'Australia/Brisbane' => {
			exemplarCity => q#ब्रिस्बेन#,
		},
		'Australia/Broken_Hill' => {
			exemplarCity => q#ब्रोकन हिल#,
		},
		'Australia/Currie' => {
			exemplarCity => q#कुह्री#,
		},
		'Australia/Darwin' => {
			exemplarCity => q#डार्विन#,
		},
		'Australia/Eucla' => {
			exemplarCity => q#उक्ला#,
		},
		'Australia/Hobart' => {
			exemplarCity => q#होबार्ट#,
		},
		'Australia/Lindeman' => {
			exemplarCity => q#लिंडेमन#,
		},
		'Australia/Lord_Howe' => {
			exemplarCity => q#लॉर्ड होवे#,
		},
		'Australia/Melbourne' => {
			exemplarCity => q#मेलबोर्न#,
		},
		'Australia/Perth' => {
			exemplarCity => q#पर्थ#,
		},
		'Australia/Sydney' => {
			exemplarCity => q#सिडनी#,
		},
		'Australia_Central' => {
			long => {
				'daylight' => q#ऑस्ट्रेलियन मध्य सूर्यप्रकाश वेळ#,
				'generic' => q#मध्य ऑस्ट्रेलिया वेळ#,
				'standard' => q#ऑस्ट्रेलियन मध्य प्रमाण वेळ#,
			},
		},
		'Australia_CentralWestern' => {
			long => {
				'daylight' => q#ऑस्ट्रेलियन मध्य-पश्चिम सूर्यप्रकाश वेळ#,
				'generic' => q#ऑस्ट्रेलियन मध्य-पश्चिम वेळ#,
				'standard' => q#ऑस्ट्रेलियन मध्य-पश्चिम प्रमाण वेळ#,
			},
		},
		'Australia_Eastern' => {
			long => {
				'daylight' => q#ऑस्ट्रेलियन पूर्व सूर्यप्रकाश वेळ#,
				'generic' => q#पूर्व ऑस्ट्रेलिया वेळ#,
				'standard' => q#ऑस्ट्रेलियन पूर्व प्रमाण वेळ#,
			},
		},
		'Australia_Western' => {
			long => {
				'daylight' => q#ऑस्ट्रेलियन पश्चिम सूर्यप्रकाश वेळ#,
				'generic' => q#पश्चिम ऑस्ट्रेलिया वेळ#,
				'standard' => q#ऑस्ट्रेलियन पश्चिम प्रमाण वेळ#,
			},
		},
		'Azerbaijan' => {
			long => {
				'daylight' => q#अझरबैजान उन्हाळी वेळ#,
				'generic' => q#अझरबैजान वेळ#,
				'standard' => q#अझरबैजान प्रमाण वेळ#,
			},
		},
		'Azores' => {
			long => {
				'daylight' => q#अ‍ॅझोरेस उन्हाळी वेळ#,
				'generic' => q#अ‍ॅझोरेस वेळ#,
				'standard' => q#अ‍ॅझोरेस प्रमाण वेळ#,
			},
		},
		'Bangladesh' => {
			long => {
				'daylight' => q#बांगलादेश उन्हाळी वेळ#,
				'generic' => q#बांगलादेश वेळ#,
				'standard' => q#बांगलादेश प्रमाण वेळ#,
			},
		},
		'Bhutan' => {
			long => {
				'standard' => q#भूतान वेळ#,
			},
		},
		'Bolivia' => {
			long => {
				'standard' => q#बोलिव्हिया वेळ#,
			},
		},
		'Brasilia' => {
			long => {
				'daylight' => q#ब्राझिलिया उन्हाळी वेळ#,
				'generic' => q#ब्राझिलिया वेळ#,
				'standard' => q#ब्राझिलिया प्रमाण वेळ#,
			},
		},
		'Brunei' => {
			long => {
				'standard' => q#ब्रुनेई दारूसलाम वेळ#,
			},
		},
		'Cape_Verde' => {
			long => {
				'daylight' => q#केप व्हर्डे उन्हाळी वेळ#,
				'generic' => q#केप व्हर्डे वेळ#,
				'standard' => q#केप व्हर्डे प्रमाण वेळ#,
			},
		},
		'Chamorro' => {
			long => {
				'standard' => q#चामोरो प्रमाण वेळ#,
			},
		},
		'Chatham' => {
			long => {
				'daylight' => q#चॅथम सूर्यप्रकाश वेळ#,
				'generic' => q#चॅथम वेळ#,
				'standard' => q#चॅथम प्रमाण वेळ#,
			},
		},
		'Chile' => {
			long => {
				'daylight' => q#चिली उन्हाळी वेळ#,
				'generic' => q#चिली वेळ#,
				'standard' => q#चिली प्रमाण वेळ#,
			},
		},
		'China' => {
			long => {
				'daylight' => q#चीनी सूर्यप्रकाश वेळ#,
				'generic' => q#चीनी वेळ#,
				'standard' => q#चीनी प्रमाण वेळ#,
			},
		},
		'Choibalsan' => {
			long => {
				'daylight' => q#चोईबाल्सन उन्हाळी वेळ#,
				'generic' => q#चोईबाल्सन वेळ#,
				'standard' => q#चोईबाल्सन प्रमाण वेळ#,
			},
		},
		'Christmas' => {
			long => {
				'standard' => q#ख्रिसमस बेट वेळ#,
			},
		},
		'Cocos' => {
			long => {
				'standard' => q#कॉकोस बेटे वेळ#,
			},
		},
		'Colombia' => {
			long => {
				'daylight' => q#कोलंबिया उन्हाळी वेळ#,
				'generic' => q#कोलंबिया वेळ#,
				'standard' => q#कोलंबिया प्रमाण वेळ#,
			},
		},
		'Cook' => {
			long => {
				'daylight' => q#कुक बेटे अर्ध उन्हाळी वेळ#,
				'generic' => q#कुक बेटे वेळ#,
				'standard' => q#कुक बेटे प्रमाण वेळ#,
			},
		},
		'Cuba' => {
			long => {
				'daylight' => q#क्यूबा सूर्यप्रकाश वेळ#,
				'generic' => q#क्यूबा वेळ#,
				'standard' => q#क्यूबा प्रमाण वेळ#,
			},
		},
		'Davis' => {
			long => {
				'standard' => q#डेव्हिस वेळ#,
			},
		},
		'DumontDUrville' => {
			long => {
				'standard' => q#ड्युमॉन्ट-ड्युर्विल वेळ#,
			},
		},
		'East_Timor' => {
			long => {
				'standard' => q#पूर्व तिमोर वेळ#,
			},
		},
		'Easter' => {
			long => {
				'daylight' => q#इस्टर बेट उन्हाळी वेळ#,
				'generic' => q#इस्टर बेट वेळ#,
				'standard' => q#इस्टर बेट प्रमाण वेळ#,
			},
		},
		'Ecuador' => {
			long => {
				'standard' => q#इक्वेडोर वेळ#,
			},
		},
		'Etc/UTC' => {
			long => {
				'standard' => q#समन्वित वैश्विक वेळ#,
			},
		},
		'Etc/Unknown' => {
			exemplarCity => q#अज्ञात शहर#,
		},
		'Europe/Amsterdam' => {
			exemplarCity => q#अ‍ॅमस्टरडॅम#,
		},
		'Europe/Andorra' => {
			exemplarCity => q#अँडोरा#,
		},
		'Europe/Astrakhan' => {
			exemplarCity => q#आस्त्राखान#,
		},
		'Europe/Athens' => {
			exemplarCity => q#अथेन्स#,
		},
		'Europe/Belgrade' => {
			exemplarCity => q#बेलग्रेड#,
		},
		'Europe/Berlin' => {
			exemplarCity => q#बर्लिन#,
		},
		'Europe/Bratislava' => {
			exemplarCity => q#ब्रातिस्लाव्हा#,
		},
		'Europe/Brussels' => {
			exemplarCity => q#ब्रुसेल्स#,
		},
		'Europe/Bucharest' => {
			exemplarCity => q#बुखारेस्ट#,
		},
		'Europe/Budapest' => {
			exemplarCity => q#बुडापेस्ट#,
		},
		'Europe/Busingen' => {
			exemplarCity => q#बुसिंजेन#,
		},
		'Europe/Chisinau' => {
			exemplarCity => q#चिसिनौ#,
		},
		'Europe/Copenhagen' => {
			exemplarCity => q#कोपेनहेगन#,
		},
		'Europe/Dublin' => {
			exemplarCity => q#डब्लिन#,
			long => {
				'daylight' => q#आयरिश प्रमाण वेळ#,
			},
		},
		'Europe/Gibraltar' => {
			exemplarCity => q#जिब्राल्टर#,
		},
		'Europe/Guernsey' => {
			exemplarCity => q#ग्वेर्नसे#,
		},
		'Europe/Helsinki' => {
			exemplarCity => q#हेलसिंकी#,
		},
		'Europe/Isle_of_Man' => {
			exemplarCity => q#आयल ऑफ मॅन#,
		},
		'Europe/Istanbul' => {
			exemplarCity => q#इस्तंबूल#,
		},
		'Europe/Jersey' => {
			exemplarCity => q#जर्सी#,
		},
		'Europe/Kaliningrad' => {
			exemplarCity => q#कलिनिनग्राड#,
		},
		'Europe/Kiev' => {
			exemplarCity => q#कीव#,
		},
		'Europe/Kirov' => {
			exemplarCity => q#किरोव#,
		},
		'Europe/Lisbon' => {
			exemplarCity => q#लिस्बन#,
		},
		'Europe/Ljubljana' => {
			exemplarCity => q#लुब्लियाना#,
		},
		'Europe/London' => {
			exemplarCity => q#लंडन#,
			long => {
				'daylight' => q#ब्रिटिश उन्हाळी वेळ#,
			},
		},
		'Europe/Luxembourg' => {
			exemplarCity => q#लक्झेंबर्ग#,
		},
		'Europe/Madrid' => {
			exemplarCity => q#माद्रिद#,
		},
		'Europe/Malta' => {
			exemplarCity => q#माल्टा#,
		},
		'Europe/Mariehamn' => {
			exemplarCity => q#मरियेहामेन#,
		},
		'Europe/Minsk' => {
			exemplarCity => q#मिन्स्क#,
		},
		'Europe/Monaco' => {
			exemplarCity => q#मोनॅको#,
		},
		'Europe/Moscow' => {
			exemplarCity => q#मॉस्को#,
		},
		'Europe/Oslo' => {
			exemplarCity => q#ऑस्लो#,
		},
		'Europe/Paris' => {
			exemplarCity => q#पॅरिस#,
		},
		'Europe/Podgorica' => {
			exemplarCity => q#पॉडगोरिका#,
		},
		'Europe/Prague' => {
			exemplarCity => q#प्राग#,
		},
		'Europe/Riga' => {
			exemplarCity => q#रिगा#,
		},
		'Europe/Rome' => {
			exemplarCity => q#रोम#,
		},
		'Europe/Samara' => {
			exemplarCity => q#समारा#,
		},
		'Europe/San_Marino' => {
			exemplarCity => q#सॅन मरिनो#,
		},
		'Europe/Sarajevo' => {
			exemplarCity => q#साराजेव्हो#,
		},
		'Europe/Saratov' => {
			exemplarCity => q#सारातोव#,
		},
		'Europe/Simferopol' => {
			exemplarCity => q#सिम्फरोपोल#,
		},
		'Europe/Skopje' => {
			exemplarCity => q#स्कॉप्जे#,
		},
		'Europe/Sofia' => {
			exemplarCity => q#सोफिया#,
		},
		'Europe/Stockholm' => {
			exemplarCity => q#स्टॉकहोम#,
		},
		'Europe/Tallinn' => {
			exemplarCity => q#तालिन#,
		},
		'Europe/Tirane' => {
			exemplarCity => q#टिराने#,
		},
		'Europe/Ulyanovsk' => {
			exemplarCity => q#उल्यानोव्स्क#,
		},
		'Europe/Uzhgorod' => {
			exemplarCity => q#उझहोरोड#,
		},
		'Europe/Vaduz' => {
			exemplarCity => q#वडूझ#,
		},
		'Europe/Vatican' => {
			exemplarCity => q#व्हॅटिकन#,
		},
		'Europe/Vienna' => {
			exemplarCity => q#व्हिएन्ना#,
		},
		'Europe/Vilnius' => {
			exemplarCity => q#विलनियस#,
		},
		'Europe/Volgograd' => {
			exemplarCity => q#व्होल्गोग्राड#,
		},
		'Europe/Warsaw' => {
			exemplarCity => q#वॉर्सा#,
		},
		'Europe/Zagreb' => {
			exemplarCity => q#झॅग्रेब#,
		},
		'Europe/Zaporozhye' => {
			exemplarCity => q#झापोरोझे#,
		},
		'Europe/Zurich' => {
			exemplarCity => q#झुरिक#,
		},
		'Europe_Central' => {
			long => {
				'daylight' => q#मध्‍य युरोपियन उन्हाळी वेळ#,
				'generic' => q#मध्‍य युरोपियन वेळ#,
				'standard' => q#मध्‍य युरोपियन प्रमाण वेळ#,
			},
		},
		'Europe_Eastern' => {
			long => {
				'daylight' => q#पूर्व युरोपियन उन्हाळी वेळ#,
				'generic' => q#पूर्व युरोपियन वेळ#,
				'standard' => q#पूर्व युरोपियन प्रमाण वेळ#,
			},
		},
		'Europe_Further_Eastern' => {
			long => {
				'standard' => q#अग्र-पौर्वात्य युरोपीयन वेळ#,
			},
		},
		'Europe_Western' => {
			long => {
				'daylight' => q#पश्चिम युरोपियन उन्हाळी वेळ#,
				'generic' => q#पश्चिम युरोपियन वेळ#,
				'standard' => q#पश्चिम युरोपियन प्रमाण वेळ#,
			},
		},
		'Falkland' => {
			long => {
				'daylight' => q#फॉकलंड बेटे उन्हाळी वेळ#,
				'generic' => q#फॉकलंड बेटे वेळ#,
				'standard' => q#फॉकलंड बेटे प्रमाण वेळ#,
			},
		},
		'Fiji' => {
			long => {
				'daylight' => q#फिजी उन्हाळी वेळ#,
				'generic' => q#फिजी वेळ#,
				'standard' => q#फिजी प्रमाण वेळ#,
			},
		},
		'French_Guiana' => {
			long => {
				'standard' => q#फ्रेंच गयाना वेळ#,
			},
		},
		'French_Southern' => {
			long => {
				'standard' => q#फ्रेंच दक्षिण आणि अंटार्क्टिक वेळ#,
			},
		},
		'GMT' => {
			long => {
				'standard' => q#ग्रीनिच प्रमाण वेळ#,
			},
		},
		'Galapagos' => {
			long => {
				'standard' => q#गॅलापागोस वेळ#,
			},
		},
		'Gambier' => {
			long => {
				'standard' => q#गॅम्बियर वेळ#,
			},
		},
		'Georgia' => {
			long => {
				'daylight' => q#जॉर्जिया उन्हाळी वेळ#,
				'generic' => q#जॉर्जिया वेळ#,
				'standard' => q#जॉर्जिया प्रमाण वेळ#,
			},
		},
		'Gilbert_Islands' => {
			long => {
				'standard' => q#गिल्बर्ट बेटे वेळ#,
			},
		},
		'Greenland_Eastern' => {
			long => {
				'daylight' => q#पूर्व ग्रीनलँड उन्हाळी वेळ#,
				'generic' => q#पूर्व ग्रीनलँड वेळ#,
				'standard' => q#पूर्व ग्रीनलँड प्रमाण वेळ#,
			},
		},
		'Greenland_Western' => {
			long => {
				'daylight' => q#पश्चिम ग्रीनलँड उन्हाळी वेळ#,
				'generic' => q#पश्चिम ग्रीनलँड वेळ#,
				'standard' => q#पश्चिम ग्रीनलँड प्रमाण वेळ#,
			},
		},
		'Guam' => {
			long => {
				'standard' => q#गुआम प्रमाणवेळ#,
			},
		},
		'Gulf' => {
			long => {
				'standard' => q#खाडी प्रमाण वेळ#,
			},
		},
		'Guyana' => {
			long => {
				'standard' => q#गयाना वेळ#,
			},
		},
		'Hawaii_Aleutian' => {
			long => {
				'daylight' => q#हवाई-अलूशन सूर्यप्रकाश वेळ#,
				'generic' => q#हवाई-अलूशन वेळ#,
				'standard' => q#हवाई-अलूशन प्रमाण वेळ#,
			},
		},
		'Hong_Kong' => {
			long => {
				'daylight' => q#हाँग काँग उन्हाळी वेळ#,
				'generic' => q#हाँग काँग वेळ#,
				'standard' => q#हाँग काँग प्रमाण वेळ#,
			},
		},
		'Hovd' => {
			long => {
				'daylight' => q#होव्ह्ड उन्हाळी वेळ#,
				'generic' => q#होव्ह्ड वेळ#,
				'standard' => q#होव्ह्ड प्रमाण वेळ#,
			},
		},
		'India' => {
			long => {
				'standard' => q#भारतीय प्रमाण वेळ#,
			},
			short => {
				'standard' => q#IST#,
			},
		},
		'Indian/Antananarivo' => {
			exemplarCity => q#अंटानानारिवो#,
		},
		'Indian/Chagos' => {
			exemplarCity => q#चागोस#,
		},
		'Indian/Christmas' => {
			exemplarCity => q#ख्रिसमस#,
		},
		'Indian/Cocos' => {
			exemplarCity => q#कोकोस#,
		},
		'Indian/Comoro' => {
			exemplarCity => q#कोमोरो#,
		},
		'Indian/Kerguelen' => {
			exemplarCity => q#करग्यूलेन#,
		},
		'Indian/Mahe' => {
			exemplarCity => q#माहे#,
		},
		'Indian/Maldives' => {
			exemplarCity => q#मालदीव#,
		},
		'Indian/Mauritius' => {
			exemplarCity => q#मॉरिशस#,
		},
		'Indian/Mayotte' => {
			exemplarCity => q#मायोट्टे#,
		},
		'Indian/Reunion' => {
			exemplarCity => q#रियुनियन#,
		},
		'Indian_Ocean' => {
			long => {
				'standard' => q#हिंदमहासागर वेळ#,
			},
		},
		'Indochina' => {
			long => {
				'standard' => q#इंडोचायना वेळ#,
			},
		},
		'Indonesia_Central' => {
			long => {
				'standard' => q#मध्‍य इंडोनेशिया वेळ#,
			},
		},
		'Indonesia_Eastern' => {
			long => {
				'standard' => q#पौर्वात्य इंडोनेशिया वेळ#,
			},
		},
		'Indonesia_Western' => {
			long => {
				'standard' => q#पश्चिमी इंडोनेशिया वेळ#,
			},
		},
		'Iran' => {
			long => {
				'daylight' => q#इराण सूर्यप्रकाश वेळ#,
				'generic' => q#इराण वेळ#,
				'standard' => q#इराण प्रमाण वेळ#,
			},
		},
		'Irkutsk' => {
			long => {
				'daylight' => q#इर्कुत्सक उन्हाळी वेळ#,
				'generic' => q#इर्कुत्सक वेळ#,
				'standard' => q#इर्कुत्सक प्रमाण वेळ#,
			},
		},
		'Israel' => {
			long => {
				'daylight' => q#इस्रायल सूर्यप्रकाश वेळ#,
				'generic' => q#इस्रायल#,
				'standard' => q#इस्रायल प्रमाण वेळ#,
			},
		},
		'Japan' => {
			long => {
				'daylight' => q#जपान सूर्यप्रकाश वेळ#,
				'generic' => q#जपान वेळ#,
				'standard' => q#जपान प्रमाण वेळ#,
			},
		},
		'Kamchatka' => {
			long => {
				'daylight' => q#पेट्रोपाव्हलोस्क- कामचाट्स्की ग्रीष्मकालीन वेळ#,
				'generic' => q#पेट्रोपाव्हलोस्क- कामचाट्स्की वेळ#,
				'standard' => q#पेट्रोपाव्हलोस्क- कामचाट्स्की प्रमाणवेळ#,
			},
		},
		'Kazakhstan_Eastern' => {
			long => {
				'standard' => q#पूर्व कझाकस्तान वेळ#,
			},
		},
		'Kazakhstan_Western' => {
			long => {
				'standard' => q#पश्चिम कझाकस्तान वेळ#,
			},
		},
		'Korea' => {
			long => {
				'daylight' => q#कोरियन सूर्यप्रकाश वेळ#,
				'generic' => q#कोरियन वेळ#,
				'standard' => q#कोरियन प्रमाण वेळ#,
			},
		},
		'Kosrae' => {
			long => {
				'standard' => q#कोस्राई वेळ#,
			},
		},
		'Krasnoyarsk' => {
			long => {
				'daylight' => q#क्रास्नोयार्क्स उन्हाळी वेळ#,
				'generic' => q#क्रास्नोयार्स्क वेळ#,
				'standard' => q#क्रास्नोयार्स्क प्रमाण वेळ#,
			},
		},
		'Kyrgystan' => {
			long => {
				'standard' => q#किरगिस्तान वेळ#,
			},
		},
		'Lanka' => {
			long => {
				'standard' => q#लंका वेळ#,
			},
		},
		'Line_Islands' => {
			long => {
				'standard' => q#लाइन बेटे वेळ#,
			},
		},
		'Lord_Howe' => {
			long => {
				'daylight' => q#लॉर्ड होवे सूर्यप्रकाश वेळ#,
				'generic' => q#लॉर्ड होवे वेळ#,
				'standard' => q#लॉर्ड होवे प्रमाण वेळ#,
			},
		},
		'Macau' => {
			long => {
				'daylight' => q#मकाऊ ग्रीष्मकालीन वेळ#,
				'generic' => q#मकाऊ वेळ#,
				'standard' => q#मकाऊ प्रमाणवेळ#,
			},
		},
		'Macquarie' => {
			long => {
				'standard' => q#मॅक्वेरी बेट वेळ#,
			},
		},
		'Magadan' => {
			long => {
				'daylight' => q#मॅगाडन उन्हाळी वेळ#,
				'generic' => q#मॅगाडन वेळ#,
				'standard' => q#मॅगाडन प्रमाण वेळ#,
			},
		},
		'Malaysia' => {
			long => {
				'standard' => q#मलेशिया वेळ#,
			},
		},
		'Maldives' => {
			long => {
				'standard' => q#मालदिव वेळ#,
			},
		},
		'Marquesas' => {
			long => {
				'standard' => q#मार्क्वेसास वेळ#,
			},
		},
		'Marshall_Islands' => {
			long => {
				'standard' => q#मार्शल बेटे वेळ#,
			},
		},
		'Mauritius' => {
			long => {
				'daylight' => q#मॉरीशस उन्हाळी वेळ#,
				'generic' => q#मॉरीशस वेळ#,
				'standard' => q#मॉरीशस प्रमाण वेळ#,
			},
		},
		'Mawson' => {
			long => {
				'standard' => q#मॉसन वेळ#,
			},
		},
		'Mexico_Northwest' => {
			long => {
				'daylight' => q#वायव्य मेक्सिको सूर्यप्रकाश वेळ#,
				'generic' => q#वायव्य मेक्सिको वेळ#,
				'standard' => q#वायव्य मेक्सिको प्रमाण वेळ#,
			},
		},
		'Mexico_Pacific' => {
			long => {
				'daylight' => q#मेक्सिको पॅसिफिक सूर्यप्रकाश वेळ#,
				'generic' => q#मेक्सिको पॅसिफिक वेळ#,
				'standard' => q#मेक्सिको पॅसिफिक प्रमाण वेळ#,
			},
		},
		'Mongolia' => {
			long => {
				'daylight' => q#उलान बाटोर उन्हाळी वेळ#,
				'generic' => q#उलान बाटोर वेळ#,
				'standard' => q#उलान बाटोर प्रमाण वेळ#,
			},
		},
		'Moscow' => {
			long => {
				'daylight' => q#मॉस्को उन्हाळी वेळ#,
				'generic' => q#मॉस्को वेळ#,
				'standard' => q#मॉस्को प्रमाण वेळ#,
			},
		},
		'Myanmar' => {
			long => {
				'standard' => q#म्यानमार वेळ#,
			},
		},
		'Nauru' => {
			long => {
				'standard' => q#नउरु वेळ#,
			},
		},
		'Nepal' => {
			long => {
				'standard' => q#नेपाळ वेळ#,
			},
		},
		'New_Caledonia' => {
			long => {
				'daylight' => q#न्यू कॅलेडोनिया उन्हाळी वेळ#,
				'generic' => q#न्यू कॅलेडोनिया वेळ#,
				'standard' => q#न्यू कॅलेडोनिया प्रमाण वेळ#,
			},
		},
		'New_Zealand' => {
			long => {
				'daylight' => q#न्यूझीलंड सूर्यप्रकाश वेळ#,
				'generic' => q#न्यूझीलंड वेळ#,
				'standard' => q#न्यूझीलंड प्रमाण वेळ#,
			},
		},
		'Newfoundland' => {
			long => {
				'daylight' => q#न्यू फाउंडलंड सूर्यप्रकाश वेळ#,
				'generic' => q#न्यू फाउंडलंड वेळ#,
				'standard' => q#न्यू फाउंडलंड प्रमाण वेळ#,
			},
		},
		'Niue' => {
			long => {
				'standard' => q#न्युए वेळ#,
			},
		},
		'Norfolk' => {
			long => {
				'daylight' => q#नॉरफोक बेट सूर्यप्रकाश वेळ#,
				'generic' => q#नॉरफोक बेट वेळ#,
				'standard' => q#नॉरफोक बेट प्रमाण वेळ#,
			},
		},
		'Noronha' => {
			long => {
				'daylight' => q#फर्नांडो दी नोरोन्हा उन्हाळी वेळ#,
				'generic' => q#फर्नांडो दी नोरोन्हा वेळ#,
				'standard' => q#फर्नांडो दी नोरोन्हा प्रमाण वेळ#,
			},
		},
		'North_Mariana' => {
			long => {
				'standard' => q#उत्तर मरिना बेटे वेळ#,
			},
		},
		'Novosibirsk' => {
			long => {
				'daylight' => q#नोवोसिबिर्स्क उन्हाळी वेळ#,
				'generic' => q#नोवोसिबिर्स्क वेळ#,
				'standard' => q#नोवोसिबिर्स्क प्रमाण वेळ#,
			},
		},
		'Omsk' => {
			long => {
				'daylight' => q#ओम्स्क उन्हाळी वेळ#,
				'generic' => q#ओम्स्क वेळ#,
				'standard' => q#ओम्स्क प्रमाण वेळ#,
			},
		},
		'Pacific/Apia' => {
			exemplarCity => q#अपिया#,
		},
		'Pacific/Auckland' => {
			exemplarCity => q#ऑकलंड#,
		},
		'Pacific/Bougainville' => {
			exemplarCity => q#बॉगॅनव्हिल#,
		},
		'Pacific/Chatham' => {
			exemplarCity => q#चॅटहॅम#,
		},
		'Pacific/Easter' => {
			exemplarCity => q#ईस्टर#,
		},
		'Pacific/Efate' => {
			exemplarCity => q#इफेट#,
		},
		'Pacific/Enderbury' => {
			exemplarCity => q#एंडरबरी#,
		},
		'Pacific/Fakaofo' => {
			exemplarCity => q#फाकाओफो#,
		},
		'Pacific/Fiji' => {
			exemplarCity => q#फिजी#,
		},
		'Pacific/Funafuti' => {
			exemplarCity => q#फुनाफुती#,
		},
		'Pacific/Galapagos' => {
			exemplarCity => q#गॅलापागोस#,
		},
		'Pacific/Gambier' => {
			exemplarCity => q#गॅम्बियर#,
		},
		'Pacific/Guadalcanal' => {
			exemplarCity => q#ग्वाडलकनाल#,
		},
		'Pacific/Guam' => {
			exemplarCity => q#गुआम#,
		},
		'Pacific/Honolulu' => {
			exemplarCity => q#होनोलुलू#,
		},
		'Pacific/Johnston' => {
			exemplarCity => q#जोहान्स्टन#,
		},
		'Pacific/Kanton' => {
			exemplarCity => q#कँटन#,
		},
		'Pacific/Kiritimati' => {
			exemplarCity => q#किरितिमाती#,
		},
		'Pacific/Kosrae' => {
			exemplarCity => q#कोशाय#,
		},
		'Pacific/Kwajalein' => {
			exemplarCity => q#क्वाजालेईन#,
		},
		'Pacific/Majuro' => {
			exemplarCity => q#मजुरो#,
		},
		'Pacific/Marquesas' => {
			exemplarCity => q#मारक्विसास#,
		},
		'Pacific/Midway' => {
			exemplarCity => q#मिडवे#,
		},
		'Pacific/Nauru' => {
			exemplarCity => q#नउरु#,
		},
		'Pacific/Niue' => {
			exemplarCity => q#न्युए#,
		},
		'Pacific/Norfolk' => {
			exemplarCity => q#नॉरफोक#,
		},
		'Pacific/Noumea' => {
			exemplarCity => q#नौमिआ#,
		},
		'Pacific/Pago_Pago' => {
			exemplarCity => q#पॅगो पॅगो#,
		},
		'Pacific/Palau' => {
			exemplarCity => q#पलाऊ#,
		},
		'Pacific/Pitcairn' => {
			exemplarCity => q#पिटकेर्न#,
		},
		'Pacific/Ponape' => {
			exemplarCity => q#पोनपेई#,
		},
		'Pacific/Port_Moresby' => {
			exemplarCity => q#पोर्ट मोरेस्बे#,
		},
		'Pacific/Rarotonga' => {
			exemplarCity => q#रारोटोंगा#,
		},
		'Pacific/Saipan' => {
			exemplarCity => q#सैपान#,
		},
		'Pacific/Tahiti' => {
			exemplarCity => q#ताहिती#,
		},
		'Pacific/Tarawa' => {
			exemplarCity => q#तारावा#,
		},
		'Pacific/Tongatapu' => {
			exemplarCity => q#टोंगाटापू#,
		},
		'Pacific/Truk' => {
			exemplarCity => q#चूक#,
		},
		'Pacific/Wake' => {
			exemplarCity => q#वेक#,
		},
		'Pacific/Wallis' => {
			exemplarCity => q#वालिस#,
		},
		'Pakistan' => {
			long => {
				'daylight' => q#पाकिस्तान उन्हाळी वेळ#,
				'generic' => q#पाकिस्तान वेळ#,
				'standard' => q#पाकिस्तान प्रमाण वेळ#,
			},
		},
		'Palau' => {
			long => {
				'standard' => q#पलाऊ वेळ#,
			},
		},
		'Papua_New_Guinea' => {
			long => {
				'standard' => q#पापुआ न्यू गिनी वेळ#,
			},
		},
		'Paraguay' => {
			long => {
				'daylight' => q#पॅराग्वे उन्हाळी वेळ#,
				'generic' => q#पॅराग्वे वेळ#,
				'standard' => q#पॅराग्वे प्रमाण वेळ#,
			},
		},
		'Peru' => {
			long => {
				'daylight' => q#पेरु उन्हाळी वेळ#,
				'generic' => q#पेरु वेळ#,
				'standard' => q#पेरु प्रमाण वेळ#,
			},
		},
		'Philippines' => {
			long => {
				'daylight' => q#फिलिपाइन उन्हाळी वेळ#,
				'generic' => q#फिलिपाइन वेळ#,
				'standard' => q#फिलिपाइन प्रमाण वेळ#,
			},
		},
		'Phoenix_Islands' => {
			long => {
				'standard' => q#‍फोनिक्स बेटे वेळ#,
			},
		},
		'Pierre_Miquelon' => {
			long => {
				'daylight' => q#सेंट पियरे आणि मिक्वेलोन सूर्यप्रकाश वेळ#,
				'generic' => q#सेंट पियर आणि मिक्वेलोन वेळ#,
				'standard' => q#सेंट पियरे आणि मिक्वेलोन प्रमाण वेळ#,
			},
		},
		'Pitcairn' => {
			long => {
				'standard' => q#पिटकैर्न वेळ#,
			},
		},
		'Ponape' => {
			long => {
				'standard' => q#पोनॅपे वेळ#,
			},
		},
		'Pyongyang' => {
			long => {
				'standard' => q#प्योंगयांग वेळ#,
			},
		},
		'Qyzylorda' => {
			long => {
				'daylight' => q#क़िझीलोर्डा ग्रीष्मकालीन वेळ#,
				'generic' => q#क़िझीलोर्डा वेळ#,
				'standard' => q#क़िझीलोर्डा प्रमाणवेळ#,
			},
		},
		'Reunion' => {
			long => {
				'standard' => q#रियुनियन वेळ#,
			},
		},
		'Rothera' => {
			long => {
				'standard' => q#रोथेरा वेळ#,
			},
		},
		'Sakhalin' => {
			long => {
				'daylight' => q#सखलिन उन्हाळी वेळ#,
				'generic' => q#सखलिन वेळ#,
				'standard' => q#सखलिन प्रमाण वेळ#,
			},
		},
		'Samara' => {
			long => {
				'daylight' => q#सामरा ग्रीष्मकालीन वेळ#,
				'generic' => q#समारा वेळ#,
				'standard' => q#सामरा प्रमाणवेळ#,
			},
		},
		'Samoa' => {
			long => {
				'daylight' => q#सामोआ सूर्यप्रकाश वेळ#,
				'generic' => q#सामोआ वेळ#,
				'standard' => q#सामोआ प्रमाण वेळ#,
			},
		},
		'Seychelles' => {
			long => {
				'standard' => q#सेशेल्स वेळ#,
			},
		},
		'Singapore' => {
			long => {
				'standard' => q#सिंगापूर प्रमाण वेळ#,
			},
		},
		'Solomon' => {
			long => {
				'standard' => q#सोलोमॉन बेटे वेळ#,
			},
		},
		'South_Georgia' => {
			long => {
				'standard' => q#दक्षिण जॉर्जिया वेळ#,
			},
		},
		'Suriname' => {
			long => {
				'standard' => q#सुरिनाम वेळ#,
			},
		},
		'Syowa' => {
			long => {
				'standard' => q#स्योवा वेळ#,
			},
		},
		'Tahiti' => {
			long => {
				'standard' => q#ताहिती वेळ#,
			},
		},
		'Taipei' => {
			long => {
				'daylight' => q#तैपेई सूर्यप्रकाश वेळ#,
				'generic' => q#तैपेई वेळ#,
				'standard' => q#तैपेई प्रमाण वेळ#,
			},
		},
		'Tajikistan' => {
			long => {
				'standard' => q#ताजिकिस्तान वेळ#,
			},
		},
		'Tokelau' => {
			long => {
				'standard' => q#टोकेलाऊ वेळ#,
			},
		},
		'Tonga' => {
			long => {
				'daylight' => q#टोंगा उन्हाळी वेळ#,
				'generic' => q#टोंगा वेळ#,
				'standard' => q#टोंगा प्रमाण वेळ#,
			},
		},
		'Truk' => {
			long => {
				'standard' => q#चूक वेळ#,
			},
		},
		'Turkmenistan' => {
			long => {
				'daylight' => q#तुर्कमेनिस्तान उन्हाळी वेळ#,
				'generic' => q#तुर्कमेनिस्तान वेळ#,
				'standard' => q#तुर्कमेनिस्तान प्रमाण वेळ#,
			},
		},
		'Tuvalu' => {
			long => {
				'standard' => q#तुवालू वेळ#,
			},
		},
		'Uruguay' => {
			long => {
				'daylight' => q#उरुग्वे उन्हाळी वेळ#,
				'generic' => q#उरुग्वे वेळ#,
				'standard' => q#उरुग्वे प्रमाण वेळ#,
			},
		},
		'Uzbekistan' => {
			long => {
				'daylight' => q#उझबेकिस्तान उन्हाळी वेळ#,
				'generic' => q#उझबेकिस्तान वेळ#,
				'standard' => q#उझबेकिस्तान प्रमाण वेळ#,
			},
		},
		'Vanuatu' => {
			long => {
				'daylight' => q#वानुआतु उन्हाळी वेळ#,
				'generic' => q#वानुआतु वेळ#,
				'standard' => q#वानुआतु प्रमाण वेळ#,
			},
		},
		'Venezuela' => {
			long => {
				'standard' => q#व्हेनेझुएला वेळ#,
			},
		},
		'Vladivostok' => {
			long => {
				'daylight' => q#व्लादिवोस्तोक उन्हाळी वेळ#,
				'generic' => q#व्लादिवोस्तोक वेळ#,
				'standard' => q#व्लादिवोस्तोक प्रमाण वेळ#,
			},
		},
		'Volgograd' => {
			long => {
				'daylight' => q#व्होल्गोग्राड उन्हाळी वेळ#,
				'generic' => q#व्होल्गोग्राड वेळ#,
				'standard' => q#व्होल्गोग्राड प्रमाण वेळ#,
			},
		},
		'Vostok' => {
			long => {
				'standard' => q#व्होस्टॉक वेळ#,
			},
		},
		'Wake' => {
			long => {
				'standard' => q#वेक बेट वेळ#,
			},
		},
		'Wallis' => {
			long => {
				'standard' => q#वॉलिस आणि फुटुना वेळ#,
			},
		},
		'Yakutsk' => {
			long => {
				'daylight' => q#याकुत्सक उन्हाळी वेळ#,
				'generic' => q#याकुत्सक वेळ#,
				'standard' => q#याकुत्सक प्रमाण वेळ#,
			},
		},
		'Yekaterinburg' => {
			long => {
				'daylight' => q#येकतरिनबर्ग उन्हाळी वेळ#,
				'generic' => q#येकतरिनबर्ग वेळ#,
				'standard' => q#येकतरिनबर्ग प्रमाण वेळ#,
			},
		},
		'Yukon' => {
			long => {
				'standard' => q#युकोन वेळ#,
			},
		},
	 } }
);
no Moo;

1;

# vim: tabstop=4
