=encoding utf8

=head1 NAME

Locale::CLDR::Locales::Dz - Package for language Dzongkha

=cut

package Locale::CLDR::Locales::Dz;
# This file auto generated from Data\common\main\dz.xml
#	on Thu 25 Jan  8:49:00 am GMT

use strict;
use warnings;
use version;

our $VERSION = version->declare('v0.44.0');

use v5.10.1;
use mro 'c3';
use utf8;
use if $^V ge v5.12.0, feature => 'unicode_strings';
use Types::Standard qw( Str Int HashRef ArrayRef CodeRef RegexpRef );
use Moo;

extends('Locale::CLDR::Locales::Root');
# Need to add code for Key type pattern
sub display_name_pattern {
	my ($self, $name, $region, $script, $variant) = @_;

	my $display_pattern = '{0}། ({1}།)';
	$display_pattern =~s/\{0\}/$name/g;
	my $subtags = join '{0}་, {1}', grep {$_} (
		$region,
		$script,
		$variant,
	);

	$display_pattern =~s/\{1\}/$subtags/g;
	return $display_pattern;
}

has 'display_name_language' => (
	is			=> 'ro',
	isa			=> CodeRef,
	init_arg	=> undef,
	default		=> sub {
		 sub {
			 my %languages = (
				'aa' => 'ཨ་ཕར་ཁ',
 				'ab' => 'ཨཱབ་ཁ་ཟི་ཡ་ཁ',
 				'af' => 'ཨཕ་རི་ཀཱནས་ཁ',
 				'am' => 'ཨམ་ཧ་རིཀ་ཁ',
 				'ar' => 'ཨེ་ར་བིཀ་ཁ',
 				'as' => 'ཨ་ས་མིས་ཁ',
 				'az' => 'ཨ་ཛར་བྷའི་ཇཱན་ཁ',
 				'be' => 'བེལ་ཨ་རུས་ཁ',
 				'bg' => 'བཱལ་གེ་རི་ཡཱན་ཁ',
 				'bn' => 'བངྒ་ལ་ཁ',
 				'bo' => 'བོད་ཁ',
 				'bs' => 'བྷོས་ནི་ཡཱན་ཁ',
 				'ca' => 'ཀེ་ཊ་ལཱན་ཁ',
 				'cs' => 'ཅེཀ་ཁ',
 				'cy' => 'ཝེལཤ་ཁ',
 				'da' => 'ཌེ་ནིཤ་ཁ',
 				'dak' => 'ད་ཀོ་ཏ་ཁ',
 				'de' => 'ཇཱར་མཱན་ཁ',
 				'de_AT' => 'ཨཱོས་ཊྲི་ཡཱན་ཇཱར་མཱན་ཁ',
 				'de_CH' => 'སུ་ཡིས་གི་མཐོ་སའི་ཇཱར་མཱན་ཁ',
 				'dv' => 'དི་བེ་ཧི་ཁ',
 				'dz' => 'རྫོང་ཁ',
 				'egy' => 'ཨི་ཇིཔ་ཤཱན (སྔ་དུས་ཀྱི)',
 				'el' => 'གྲིཀ་ཁ',
 				'en' => 'ཨིང་ལིཤ་ཁ',
 				'en_AU' => 'ཨཱོས་ཊྲེ་ལི་ཡཱན་ཨིང་ལིཤ་ཁ',
 				'en_CA' => 'ཀེ་ན་ཌི་ཡཱན་ཨིང་ལིཤ་ཁ',
 				'en_GB' => 'བྲི་ཊིཤ་ཨིང་ལིཤ་ཁ',
 				'en_US' => 'ཡུ་ཨེས་ཨིང་ལིཤ་ཁ',
 				'eo' => 'ཨེས་པ་རཱན་ཏོ་ཁ',
 				'es' => 'ཨིས་པེ་ནིཤ་ཁ',
 				'es_419' => 'ལེ་ཊིན་ཨ་མེ་རི་ཀཱན་གི་ཨིས་པེ་ནིཤ་ཁ',
 				'es_ES' => 'ཡུ་རོབ་ཀྱི་ཨིས་པེ་ནིཤ་ཁ',
 				'et' => 'ཨེས་ཊོ་ནི་ཡཱན་ཁ',
 				'eu' => 'བཱསཀ་ཁ',
 				'fa' => 'པར་ཤི་ཡཱན་ཁ',
 				'fi' => 'ཕི་ནིཤ་ཁ',
 				'fil' => 'ཕི་ལི་པི་ནོ་ཁ',
 				'fj' => 'ཕི་ཇི་ཡཱན་ཁ',
 				'fo' => 'ཕཱ་རོ་ཨིས་ཁ',
 				'fr' => 'ཕྲནཅ་ཁ',
 				'fr_CA' => 'ཀེ་ན་ཌི་ཡཱན་ཕྲནཅ་ཁ',
 				'fr_CH' => 'སུ་ཡིས་ཕྲནཅ་ཁ',
 				'fy' => 'ནུབ་ཕྼི་སི་ཡན་ཁ',
 				'ga' => 'ཨཱའི་རིཤ་ཁ',
 				'gl' => 'གལ་ཨིས་ཨི་ཡན་ཁ',
 				'gn' => 'གུ་ཝ་ར་ནི་ཁ',
 				'grc' => 'གིརིཀ, སྔ་དུས་ཀྱི (༡༤༥༣)',
 				'gsw' => 'སུ་ཡིས་ཇཱར་མཱན་ཁ',
 				'gu' => 'གུ་ཇ་ར་ཏི་ཁ',
 				'ha' => 'ཧཝ་ས་ཁ',
 				'haw' => 'ཧ་ཝ་ཡིའི་ཁ',
 				'he' => 'ཧེ་བྲུ་ཁ',
 				'hi' => 'ཧིན་དི་ཁ',
 				'hr' => 'ཀྲོ་ཨེ་ཤི་ཡཱན་ཁ',
 				'ht' => 'ཧེ་ཏི་ཡཱན་ཁ',
 				'hu' => 'ཧཱང་གྷ་རི་ཡཱན་ཁ',
 				'hy' => 'ཨར་མི་ནི་ཡཱན་ཁ',
 				'id' => 'ཨིན་ཌོ་ནེ་ཤི་ཡཱན་ཁ',
 				'ig' => 'ཨིག་བོ་ཁ',
 				'is' => 'ཨ་ཡིས་ལེན་ཌིཀ་ཁ',
 				'it' => 'ཨི་ཊ་ལི་ཡཱན་ཁ',
 				'ja' => 'ཇཱ་པཱ་ནིས་ཁ',
 				'jv' => 'ཇཱ་བ་ནིས་ཁ',
 				'ka' => 'ཇཽ་ཇི་ཡཱན་ཁ',
 				'kac' => 'ཀ་ཆིན་ཁ',
 				'kfo' => 'ཀོ་རོ་ཁ',
 				'kk' => 'ཀ་ཛགས་ཁ',
 				'km' => 'ཁེ་མེར་ཁ',
 				'kn' => 'ཀ་ན་ཌ་ཁ',
 				'ko' => 'ཀོ་རི་ཡཱན་ཁ',
 				'ks' => 'ཀཱཤ་མི་རི་ཁ',
 				'ku' => 'ཀར་ཌིཤ་ཁ',
 				'ky' => 'ཀིར་གིས་ཁ',
 				'la' => 'ལེ་ཊིན་ཁ',
 				'lb' => 'ལག་ཛམ་བོརྒ་ཁ',
 				'lo' => 'ལཱ་ཝོས་ཁ',
 				'lt' => 'ལི་ཐུ་ཝེ་ནི་ཡཱན་ཁ',
 				'lv' => 'ལཊ་བི་ཡཱན་ཁ',
 				'mg' => 'མ་ལ་ག་སི་ཁ',
 				'mi' => 'མ་ཨོ་རི་ཁ',
 				'mk' => 'མ་སེ་ཌོ་ནི་ཡཱན་ཁ',
 				'ml' => 'མ་ལ་ཡ་ལམ་ཁ',
 				'mn' => 'སོག་པོའི་ཁ',
 				'mnc' => 'མན་ཇུ་ཁ',
 				'mni' => 'མ་ནི་པུ་རི',
 				'mr' => 'མ་ར་ཐི་ཁ',
 				'ms' => 'མ་ལེ་ཁ',
 				'mt' => 'མཱལ་ཊ་ཁ',
 				'my' => 'བར་མིས་ཁ',
 				'nb' => 'ནོར་ཝེ་ཇི་ཡཱན་བོཀ་མཱལ་ཁ',
 				'ne' => 'ནེ་པཱལི་ཁ',
 				'new' => 'ནི་ཝ་རི',
 				'nl' => 'ཌཆ་ཁ',
 				'nl_BE' => 'ཕྷེལེ་མིཤ་ཁ',
 				'nn' => 'ནོར་ཝེ་ཇི་ཡཱན་ནོརསཀ་ཁ',
 				'no' => 'ནོར་ཝི་ཇི་ཡན་ཁ',
 				'or' => 'ཨོ་རི་ཡ་ཁ',
 				'pa' => 'པཱན་ཇ་བི་ཁ',
 				'pi' => 'པ་ལི',
 				'pl' => 'པོ་ལིཤ་ཁ',
 				'ps' => 'པཱཤ་ཏོ་ཁ',
 				'pt' => 'པོར་ཅུ་གིས་ཁ',
 				'pt_BR' => 'བྲ་ཛི་ལི་ཡཱན་པོར་ཅུ་གིས་ཁ',
 				'pt_PT' => 'ཨི་བེ་རི་ཡཱན་པོར་ཅུ་གིས་ཁ',
 				'qu' => 'ཀྭེ་ཆུ་ཨ་ཁ',
 				'rm' => 'རོ་མེ་ནིཤ་ཁ',
 				'ro' => 'རོ་མེ་ནི་ཡཱན་ཁ',
 				'ru' => 'ཨུ་རུ་སུའི་ཁ',
 				'sa' => 'སཾསྐྲྀཏ་ཁ',
 				'sd' => 'སིན་དཱི་ཁ',
 				'shn' => 'ཤཱན་ཁ',
 				'si' => 'སིང་ཧ་ལ་ཁ',
 				'sk' => 'སུ་ལོ་བཱཀ་ཁ',
 				'sl' => 'སུ་ལོ་བི་ནི་ཡཱན་ཁ',
 				'so' => 'སོ་མ་ལི་ཁ',
 				'sq' => 'ཨཱལ་བེ་ནི་ཡཱན་ཁ',
 				'sr' => 'སཱར་བྷི་ཡཱན་ཁ',
 				'su' => 'སཱུན་ད་ནིས་ཁ',
 				'sv' => 'སུའི་ཌིཤ་ཁ',
 				'sw' => 'སྭཱ་ཧི་ལི་ཁ',
 				'ta' => 'ཏ་མིལ་ཁ',
 				'te' => 'ཏེ་ལུ་གུ་ཁ',
 				'tg' => 'ཏ་ཇིཀ་ཁ',
 				'th' => 'ཐཱའི་ཁ',
 				'ti' => 'ཏིག་རི་ཉ་ཁ',
 				'tk' => 'ཊཱརཀ་མེན་ཁ',
 				'to' => 'ཊོང་གྷན་ཁ',
 				'tr' => 'ཊཱར་ཀིཤ་ཁ',
 				'tt' => 'ཊ་ཊར་ཁ',
 				'ug' => 'ཝི་གུར་ཁ',
 				'uk' => 'ཡུ་ཀེ་རེ་ནི་ཡཱན་ཁ',
 				'und' => 'ཁ་ངོ་མ་ཤེསཔ',
 				'ur' => 'ཨུར་དུ་ཁ',
 				'uz' => 'ཨུས་བེཀ་ཁ',
 				'vi' => 'བེཊ་ནཱ་མིས་ཁ',
 				'wo' => 'ཝོ་ལོཕ་ཁ',
 				'xh' => 'ཞོ་ས་ཁ',
 				'yo' => 'ཡོ་རུ་བ་ཁ',
 				'zh' => 'རྒྱ་མི་ཁ',
 				'zh_Hans' => 'རྒྱ་མི་ཁ་འཇམ་སངམ',
 				'zh_Hant' => 'སྔ་དུས་ཀྱི་རྒྱ་མི་ཁ',
 				'zu' => 'ཟུ་ལུ་ཁ',
 				'zxx' => 'སྐད་རིག་ནང་དོན་མེདཔ',

			);
			if (@_) {
				return $languages{$_[0]};
			}
			return \%languages;
		}
	},
);

has 'display_name_script' => (
	is			=> 'ro',
	isa			=> CodeRef,
	init_arg	=> undef,
	default		=> sub {
		sub {
			my %scripts = (
			'Arab' => 'ཨེ་ར་བིཀ་ཡིག་གུ',
 			'Armn' => 'ཨར་མི་ནི་ཡཱན་ཡིག་གུ',
 			'Beng' => 'བངྒ་ལ་ཡིག་གུ',
 			'Bopo' => 'བོ་པོ་མོ་ཕཱོ་ཡིག་གུ',
 			'Brai' => 'འབུར་ཡིག',
 			'Cyrl' => 'སིརིལ་ལིཀ་ཡིག་གུ',
 			'Deva' => 'དེ་ཝ་ན་ག་རི་ཡིག་གུ',
 			'Ethi' => 'ཨི་ཐི་ཡོ་པིཀ྄་ཡིག་གུ',
 			'Geor' => 'ཇཽ་ཇི་ཡཱན་ཡིག་གུ',
 			'Grek' => 'གྲིཀ་ཡིག་གུ',
 			'Gujr' => 'གུ་ཇ་ར་ཏི་ཡིག་གུ',
 			'Guru' => 'གུ་རུ་མུ་ཁ་ཡིག་གུ',
 			'Hang' => 'ཧཱན་གུལ་ཡིག་གུ',
 			'Hani' => 'རྒྱ་ནག་ཡིག་གུ',
 			'Hans' => 'རྒྱ་ཡིག་ ལུགས་གསར་',
 			'Hant' => 'ལུགས་རྙིང་ རྒྱ་ཡིག',
 			'Hebr' => 'ཧེ་བྲུ་ཡིག་གུ',
 			'Hira' => 'ཇ་པཱན་གྱི་ཧི་ར་ག་ན་ཡིག་གུ',
 			'Jpan' => 'ཇ་པཱན་ཡིག་གུ',
 			'Kana' => 'ཇ་པཱན་གྱི་ཀ་ཏ་ཀ་ན་ཡིག་གུ',
 			'Khmr' => 'ཁེ་མེར་ཡིག་གུ',
 			'Knda' => 'ཀ་ན་ཌ་ཡིག་གུ',
 			'Kore' => 'ཀོ་རི་ཡཱན་ཡིག་གུ',
 			'Laoo' => 'ལའོ་ཡིག་གུ',
 			'Latn' => 'ལེ་ཊིན་ཡིག་གུ',
 			'Limb' => 'ལིམ་བུ',
 			'Mlym' => 'མ་ལ་ཡ་ལམ་ཡིག་གུ',
 			'Mong' => 'སོག་པོའི་ཡིག་གུ',
 			'Mymr' => 'བར་མིས་ཡིག་གུ',
 			'Orya' => 'ཨོ་རི་ཡ་ཡིག་གུ',
 			'Sinh' => 'སིན་ཧ་ལ་རིག་གུ',
 			'Taml' => 'ཏ་མིལ་ཡིག་གུ',
 			'Telu' => 'ཏེ་ལུ་གུ་ཡིག་གུ',
 			'Thaa' => 'ཐཱ་ན་ཡིག་གུ',
 			'Thai' => 'ཐཱའི་ཡིག་གུ',
 			'Tibt' => 'ང་བཅས་ཀྱི་ཡིག་གུ',
 			'Zinh' => 'སྔར་རྒྱུན',
 			'Zsym' => 'མཚན་རྟགས',
 			'Zxxx' => 'ཡིག་ཐོག་མ་བཀོདཔ',
 			'Zyyy' => 'སྤྱིཡིག',
 			'Zzzz' => 'ངོ་མ་ཤེས་པའི་ཡི་གུ',

			);
			if ( @_ ) {
				return $scripts{$_[0]};
			}
			return \%scripts;
		}
	}
);

has 'display_name_region' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'001' => 'འཛམ་གླིང༌',
 			'002' => 'ཨཕ་རི་ཀ',
 			'003' => 'བྱང་ཨ་མི་རི་ཀ',
 			'005' => 'ལྷོ་ཨ་མི་རི་ཀ',
 			'009' => 'ཨོཤི་ཡཱན་ན',
 			'011' => 'ནུབ་ཕྱོགས་ཀྱི་ཨཕ་རི་ཀ',
 			'013' => 'བར་ཕྱོགས་ཨ་མི་རི་ཀ',
 			'014' => 'ཤར་ཕྱོགས་ཀྱི་ཨཕ་རི་ཀ',
 			'015' => 'བྱང་ཕྱོགས་ཀྱི་ཨཕ་རི་ཀ',
 			'017' => 'སྦུག་ཕྱོགས་ཀྱི་ཨཕ་རི་ཀ',
 			'018' => 'ལྷོའི་ཨཕ་རི་ཀ',
 			'019' => 'ཨ་མི་རི་ཀ་ཚུ',
 			'021' => 'བྱང་ཕྱོགས་ཀྱི་ཨ་མི་རི་ཀ',
 			'029' => 'ཀེ་རི་བི་ཡེན',
 			'030' => 'ཤར་ཕྱོགས་ཀྱི་ཨེ་ཤི་ཡ',
 			'034' => 'ལྷོའི་ཨེ་ཤི་ཡ',
 			'035' => 'ལྷོ་ཤར་ཕྱོགས་ཀྱི་ཨེ་ཤི་ཡ',
 			'039' => 'ལྷོའི་ཡུ་རོབ',
 			'053' => 'ཨཱོས་ཊྲེལ་ཨེ་ཤི་ཡ',
 			'054' => 'མེ་ལ་ནི་ཤི་ཡ',
 			'057' => 'ལུང་ཕྱོགས་མའི་ཀྲོ་ནི་ཤི་ཡ',
 			'061' => 'པོ་ལི་ནི་ཤི་ཡ',
 			'142' => 'ཨེ་ཤི་ཡ',
 			'143' => 'སྦུག་ཕྱོགས་ཀྱི་ཨེ་ཤི་ཡ',
 			'145' => 'ནུབ་ཕྱོགས་ཀྱི་ཨེ་ཤི་ཡ',
 			'150' => 'ཡུ་རོབ',
 			'151' => 'ཤར་ཕྱོགས་ཀྱི་ཡུ་རོབ',
 			'154' => 'བྱང་ཕྱོགས་ཀྱི་ཡུ་རོབ',
 			'155' => 'ནུབ་ཕྱོགས་ཀྱི་ཡུ་རོབ',
 			'419' => 'ལེ་ཊིནཨ་མི་རི་ཀ',
 			'AC' => 'ཨེ་སེན་ཤུན་ཚོ་གླིང༌',
 			'AD' => 'ཨཱན་དོ་ར',
 			'AE' => 'ཡུ་ནཱའི་ཊེཌ་ ཨ་རབ་ ཨེ་མེ་རེཊས',
 			'AF' => 'ཨཕ་གྷ་ནི་སཏཱན',
 			'AG' => 'ཨན་ཊི་གུ་ཝ་ ཨེནཌ་ བྷར་བྷུ་ཌ',
 			'AI' => 'ཨང་གི་ལ',
 			'AL' => 'ཨཱལ་བེ་ནི་ཡ',
 			'AM' => 'ཨར་མི་ནི་ཡ',
 			'AO' => 'ཨང་གྷོ་ལ',
 			'AQ' => 'འཛམ་གླིང་ལྷོ་མཐའི་ཁྱགས་གླིང',
 			'AR' => 'ཨར་ཇེན་ཊི་ན',
 			'AS' => 'ས་མོ་ཨ་ཡུ་ཨེས་ཨེ་མངའ་ཁོངས',
 			'AT' => 'ཨཱོས་ཊྲི་ཡ',
 			'AU' => 'ཨཱོས་ཊྲེལ་ལི་ཡ',
 			'AW' => 'ཨ་རུ་བཱ',
 			'AX' => 'ཨ་ལནཌ་གླིང་ཚོམ',
 			'AZ' => 'ཨ་ཛར་བྷའི་ཇཱན',
 			'BA' => 'བྷོས་ནི་ཡ་ ཨེནཌ་ ཧར་ཛི་གྷོ་བི་ན',
 			'BB' => 'བྷར་བེ་ཌོས',
 			'BD' => 'བངྒ་ལ་དེཤ',
 			'BE' => 'བྷེལ་ཇམ',
 			'BF' => 'བྷར་ཀི་ན་ ཕེ་སོ',
 			'BG' => 'བུལ་ག་རི་ཡ',
 			'BH' => 'བྷ་རེན',
 			'BI' => 'བྷུ་རུན་ཌི',
 			'BJ' => 'བྷེ་ནིན',
 			'BL' => 'སེནཊ་ བར་ཐོ་ལོམ་མིའུ',
 			'BM' => 'བར་མུ་ཌ',
 			'BN' => 'བྷྲུ་ནའི',
 			'BO' => 'བྷེ་ལི་བི་ཡ',
 			'BQ' => 'ཀེ་རི་བི་ཡེན་ནེ་དར་ལནཌས྄',
 			'BR' => 'བྲ་ཛིལ',
 			'BS' => 'བྷ་ཧ་མས྄',
 			'BT' => 'འབྲུག',
 			'BV' => 'བོའུ་ཝེཊ་མཚོ་གླིང',
 			'BW' => 'བྷོཙ་ཝ་ན',
 			'BY' => 'བེལ་ཨ་རུ་སུ',
 			'BZ' => 'བྷེ་ལིཛ',
 			'CA' => 'ཀེ་ན་ཌ',
 			'CC' => 'ཀོ་ཀོས་གླིང་ཚོམ',
 			'CD' => 'ཀོང་གྷོ ཀིན་ཤ་ས',
 			'CD@alt=variant' => 'ཌེ་མོ་ཀེརེ་ཊིཀ་ རི་པབ་ལིཀ་ ཨོཕ་ ཀོང་གྷོ',
 			'CF' => 'སེན་ཊལ་ ཨཕ་རི་ཀཱན་ རི་པབ་ལིཀ',
 			'CG' => 'ཀོང་གྷོ བྷྲ་ཛ་བིལ',
 			'CG@alt=variant' => 'རི་པབ་ལིཀ་ ཨོཕ་ ཀོང་གྷོ',
 			'CH' => 'སུ་ཝིཊ་ཛར་ལེནཌ',
 			'CI' => 'ཀོ་ཊེ་ ཌི་ཨི་ཝོ་རེ',
 			'CI@alt=variant' => 'ཨི་ཝོ་རི་ཀོསཊ',
 			'CK' => 'ཀུག་གླིང་ཚོམ',
 			'CL' => 'ཅི་ལི',
 			'CM' => 'ཀེ་མ་རུན',
 			'CN' => 'རྒྱ་ནག',
 			'CO' => 'ཀོ་ལོམ་བྷི་ཡ',
 			'CP' => 'ཀི་ལི་པེར་ཊོན་མཚོ་གླིང་',
 			'CR' => 'ཀོས་ཊ་རི་ཀ',
 			'CU' => 'ཀིའུ་བྷ',
 			'CV' => 'ཀེཔ་བཱཌ',
 			'CW' => 'ཀྱཱུར་ར་ཀོ',
 			'CX' => 'ཁི་རིསྟ་མེས་མཚོ་གླིང',
 			'CY' => 'སཱའི་པྲས',
 			'CZ' => 'ཅེཀ་ རི་པབ་ལིཀ',
 			'DE' => 'ཇཱར་མ་ནི',
 			'DG' => 'ཌི་ཡེ་གོ་གར་སིའོ',
 			'DJ' => 'ཇི་བྷུ་ཊི',
 			'DK' => 'ཌེན་མཱཀ',
 			'DM' => 'ཌོ་མི་ནི་ཀ',
 			'DO' => 'ཌོ་མི་ནི་ཀཱན་ རི་པབ་ལིཀ',
 			'DZ' => 'ཨཱལ་ཇི་རི་ཡ',
 			'EA' => 'སེ་ཨུ་ཏ་ ཨེནཌ་ མེལ་ལི་ལ',
 			'EC' => 'ཨེ་ཁྭ་ཌོར',
 			'EE' => 'ཨེས་ཊོ་ནི་ཡ',
 			'EG' => 'ཨི་ཇིབཊ',
 			'EH' => 'ནུབ་ཕྱོགས་ ས་ཧཱ་ར',
 			'ER' => 'ཨེ་རི་ཊྲེ་ཡ',
 			'ES' => 'ཨིས་པེན',
 			'ET' => 'ཨི་ཐི་ཡོ་པི་ཡ',
 			'EU' => 'ཡུ་རོབ་གཅིག་བསྡོམས་ཚོགས་པ',
 			'FI' => 'ཕིན་ལེནཌ',
 			'FJ' => 'ཕི་ཇི',
 			'FK' => 'ཕལྐ་ལནྜ་གླིང་ཚོམ',
 			'FK@alt=variant' => 'ཕལྐ་ལནྜ་གླིང་ཚོམ (ཨིས་ལཱས་མལ་བི་ཎཱས)',
 			'FM' => 'མའི་ཀྲོ་ནི་ཤི་ཡ',
 			'FO' => 'ཕཱའེ་རོ་གླིང་ཚོམ',
 			'FR' => 'ཕྲཱནས',
 			'GA' => 'གྷ་བྷོན',
 			'GB' => 'ཡུ་ནཱའི་ཊེཌ་ ཀིང་ཌམ',
 			'GD' => 'གྲྀ་ན་ཌ',
 			'GE' => 'ཇཽར་ཇཱ',
 			'GF' => 'གུའི་ཡ་ན་ ཕྲནས྄་མངའ་ཁོངས',
 			'GG' => 'གུ་ཨེརྣ་སི',
 			'GH' => 'གྷ་ན',
 			'GI' => 'ཇིབ་རཱལ་ཊར',
 			'GL' => 'གིརཱིན་ལནཌ྄',
 			'GM' => 'གྷེམ་བི་ཡ',
 			'GN' => 'གྷི་ནི',
 			'GP' => 'གོ་ཌེ་ལུ་པེ',
 			'GQ' => 'ཨེ་ཀུ་ཊོ་རེལ་ གི་ནི',
 			'GR' => 'གིརིས྄',
 			'GS' => 'སཱའུཐ་ཇཽར་ཇཱ་ དང་ སཱའུཐ་སེནཌ྄་ཝིཅ་གླིང་ཚོམ',
 			'GT' => 'གྷོ་ཊ་མ་ལ',
 			'GU' => 'གུ་འམ་ མཚོ་གླིང',
 			'GW' => 'གྷི་ནི་ བྷི་སཱའུ',
 			'GY' => 'གྷ་ཡ་ན',
 			'HK' => 'ཧོང་ཀོང་ཅཱའི་ན',
 			'HK@alt=short' => 'ཧོང་ཀོང',
 			'HM' => 'ཧཱརཌ་མཚོ་གླིང་ དང་ མེཀ་ཌོ་ནལཌ྄་གླིང་ཚོམ',
 			'HN' => 'ཧཱན་ཌུ་རཱས྄',
 			'HR' => 'ཀྲོ་ཨེ་ཤ',
 			'HT' => 'ཧེ་ཊི',
 			'HU' => 'ཧཱང་གྷ་རི',
 			'IC' => 'ཀ་ནེ་རི་གླིང་ཚོམ',
 			'ID' => 'ཨིན་ཌོ་ནེ་ཤི་ཡ',
 			'IE' => 'ཨཱ་ཡ་ལེནཌ',
 			'IL' => 'ཨིས་ར་ཡེལ',
 			'IM' => 'ཨ་ཡུལ་ ཨོཕ་ མཱན',
 			'IN' => 'རྒྱ་གར',
 			'IO' => 'བྲི་ཊིཤ་རྒྱ་གར་གྱི་རྒྱ་མཚོ་ས་ཁོངས',
 			'IQ' => 'ཨི་རཱཀ',
 			'IR' => 'ཨི་རཱན',
 			'IS' => 'ཨཱའིས་ལེནཌ',
 			'IT' => 'ཨི་ཊ་ལི',
 			'JE' => 'ཇེར་སི',
 			'JM' => 'ཇཱ་མཻ་ཀ',
 			'JO' => 'ཇོར་ཌན',
 			'JP' => 'ཇ་པཱན',
 			'KE' => 'ཀེན་ཡ',
 			'KG' => 'ཀིར་གིས་སཏཱན',
 			'KH' => 'ཀམ་བྷོ་ཌི་ཡ',
 			'KI' => 'ཀི་རི་བ་ཏི་མཚོ་གླིང',
 			'KM' => 'ཀོ་མོ་རོས',
 			'KN' => 'སེནཊ་ ཀིཊས་ དང་ ནེ་བིས',
 			'KP' => 'བྱང་ ཀོ་རི་ཡ',
 			'KR' => 'ལྷོ་ ཀོ་རི་ཡ',
 			'KW' => 'ཀུ་ཝེཊ',
 			'KY' => 'ཁེ་མེན་གླིང་ཚོམ',
 			'KZ' => 'ཀ་ཛགས་སཏཱན',
 			'LA' => 'ལཱ་ཝོས',
 			'LB' => 'ལེ་བ་ནོན',
 			'LC' => 'སེནཊ་ ལུ་སི་ཡ',
 			'LI' => 'ལིཀ་ཏནས་ཏ་ཡིན',
 			'LK' => 'ཤྲཱི་ལང་ཀ',
 			'LR' => 'ལཱའི་བེ་རི་ཡ',
 			'LS' => 'ལཻ་སོ་ཐོ',
 			'LT' => 'ལི་ཐུ་ཝེ་ནི་ཡ',
 			'LU' => 'ལག་ཛམ་བོརྒ',
 			'LV' => 'ལཊ་བི་ཡ',
 			'LY' => 'ལི་བི་ཡ',
 			'MA' => 'མོ་རོ་ཀོ',
 			'MC' => 'མོ་ན་ཀོ',
 			'MD' => 'མོལ་དོ་བཱ',
 			'ME' => 'མོན་ཊི་ནེག་རོ',
 			'MF' => 'སེནཊ་ མཱར་ཊིན',
 			'MG' => 'མ་དཱ་གེས་ཀར',
 			'MH' => 'མར་ཤེལ་གླིང་ཚོམ',
 			'ML' => 'མཱ་ལི',
 			'MM' => 'མི་ཡཱན་མར་ (བྷར་མ)',
 			'MN' => 'སོག་པོ་ཡུལ',
 			'MO' => 'མཀ་ཨའུ་ཅཱའི་ན',
 			'MO@alt=short' => 'མཀ་ཨའུ',
 			'MP' => 'བྱང་ཕྱོགས་ཀྱི་མ་ར་ཡ་ན་གླིང་ཚོམ',
 			'MQ' => 'མཱར་ཊི་ནིཀ',
 			'MR' => 'མོ་རི་ཊེ་ནི་ཡ',
 			'MS' => 'མོན་ས་རཊ',
 			'MT' => 'མཱལ་ཊ',
 			'MU' => 'མོ་རི་ཤཱས',
 			'MV' => 'མཱལ་དིབས',
 			'MW' => 'མ་ལ་ཝི',
 			'MX' => 'མེཀ་སི་ཀོ',
 			'MY' => 'མ་ལེ་ཤི་ཡ',
 			'MZ' => 'མོ་ཛམ་བྷིཀ',
 			'NA' => 'ན་མི་བི་ཡ',
 			'NC' => 'ནིའུ་ཀ་ལི་དོ་ནི་ཡ',
 			'NE' => 'ནཱའི་ཇཱ',
 			'NF' => 'ནོར་ཕོལཀ་མཚོ་གླིང༌',
 			'NG' => 'ནཱའི་ཇི་རི་ཡ',
 			'NI' => 'ནི་ཀྲ་ཝ་ག',
 			'NL' => 'ནེ་དར་ལནཌས྄',
 			'NO' => 'ནོར་ཝེ',
 			'NP' => 'བལ་ཡུལ',
 			'NR' => 'ནའུ་རུ་',
 			'NU' => 'ནི་ཨུ་ཨཻ',
 			'NZ' => 'ནིའུ་ཛི་ལེནཌ',
 			'OM' => 'ཨོ་མཱན',
 			'PA' => 'པ་ན་མ',
 			'PE' => 'པེ་རུ',
 			'PF' => 'ཕྲཱནས྄་ཀྱི་པོ་ལི་ནི་ཤི་ཡ',
 			'PG' => 'པ་པུ་ ནིའུ་གི་ནི',
 			'PH' => 'ཕི་ལི་པིནས',
 			'PK' => 'པ་ཀི་སཏཱན',
 			'PL' => 'པོ་ལེནཌ',
 			'PM' => 'སིནཊ་པི་ཡེར་ ཨེནཌ་ མིཀོ་ལེན',
 			'PN' => 'པིཊ་ཀེ་ཡེརན་གླིང་ཚོམ',
 			'PR' => 'པུ་འེར་ཊོ་རི་ཁོ',
 			'PS' => 'པེ་ལིསི་ཊི་ནི་ཡན་ཊེ་རི་ཐོ་རི',
 			'PT' => 'པོར་ཅུ་གཱལ',
 			'PW' => 'པ་ལའུ',
 			'PY' => 'པ་ར་གུ་ཝའི',
 			'QA' => 'ཀ་ཊར',
 			'QO' => 'ཨོཤི་ཡཱན་ན་གྱི་མཐའ་མཚམས',
 			'RE' => 'རེ་ཡུ་ནི་ཡོན',
 			'RO' => 'རོ་མེ་ནི་ཡ',
 			'RS' => 'སཱར་བྷི་ཡ',
 			'RU' => 'ཨུ་རུ་སུ',
 			'RW' => 'རུ་ཝན་ཌ',
 			'SA' => 'སཱཝ་དི་ ཨ་རེ་བྷི་ཡ',
 			'SB' => 'སོ་ལོ་མོན་ གླིང་ཚོམ',
 			'SC' => 'སེ་ཤཱལས',
 			'SD' => 'སུ་ཌཱན',
 			'SE' => 'སུའི་ཌེན',
 			'SG' => 'སིང་ག་པོར',
 			'SH' => 'སེནཊ་ ཧེ་ལི་ན',
 			'SI' => 'སུ་ལོ་བི་ནི་ཡ',
 			'SJ' => 'སྭཱལ་བྷརྡ་ ཨེནཌ་ ཇཱན་མ་ཡེན',
 			'SK' => 'སུ་ལོ་བཱ་ཀི་ཡ',
 			'SL' => 'སི་ར་ ལི་འོན',
 			'SM' => 'སཱན་མ་རི་ནོ',
 			'SN' => 'སེ་ནི་གྷལ',
 			'SO' => 'སོ་མ་ལི་ཡ',
 			'SR' => 'སུ་རི་ནཱམ',
 			'SS' => 'སཱའུཐ་ སུ་ཌཱན',
 			'ST' => 'སཝ་ ཊོ་མེ་ ཨེནཌ་ པྲྀན་སི་པེ',
 			'SV' => 'ཨེལ་སལ་བ་ཌོར',
 			'SX' => 'སིནཊ་ མཱར་ཊེན',
 			'SY' => 'སི་རི་ཡ',
 			'SZ' => 'སུ་ཝ་ཛི་ལེནཌ',
 			'TA' => 'ཏྲིས་ཏན་ད་ཀུན་ཧ',
 			'TC' => 'ཏུརྐས྄་ ཨེནཌ་ ཀ་ཀོས་གླིང་ཚོམ',
 			'TD' => 'ཅཱཌ',
 			'TF' => 'ཕྲནཅ་གི་ལྷོ་ཕྱོགས་མངའ་ཁོངས',
 			'TG' => 'ཊོ་གྷོ',
 			'TH' => 'ཐཱའི་ལེནཌ',
 			'TJ' => 'ཏ་ཇིག་གི་སཏཱན',
 			'TK' => 'ཏོ་ཀེ་ལའུ་ མཚོ་གླིང',
 			'TL' => 'ཏི་་མོར་ལེ་ཨེསཊ',
 			'TL@alt=variant' => 'ཤར་ཕྱོགས་ཏི་་མོར',
 			'TM' => 'ཊཱརཀ་མེནའི་སཏཱན',
 			'TN' => 'ཊུ་ནི་ཤི་ཡ',
 			'TO' => 'ཊོང་གྷ',
 			'TR' => 'ཊཱར་ཀི',
 			'TT' => 'ཊི་ནི་ཌཱཌ་ ཨེནཌ་ ཊོ་བྷེ་གྷོ',
 			'TV' => 'ཏུ་ཝ་ལུ',
 			'TW' => 'ཊཱའི་ཝཱན',
 			'TZ' => 'ཊཱན་ཛཱ་ནི་ཡ',
 			'UA' => 'ཡུ་ཀརེན',
 			'UG' => 'ཡུ་གྷན་ཌ',
 			'UM' => 'ཡུ་ཨེས་གྱི་མཐའ་མཚམས་མཚོ་གླིང་',
 			'US' => 'ཡུ་ཨེས་ཨེ',
 			'UY' => 'ཡུ་རུ་གུ་ཝའི',
 			'UZ' => 'ཨུས་བེག་གི་སཏཱན',
 			'VA' => 'བ་ཊི་ཀཱན་ སི་ཊི',
 			'VC' => 'སེནཊ་ཝིན་སེནཌ྄ ཨེནཌ་ གི་རེ་ན་དིནས྄',
 			'VE' => 'བེ་ནི་ཛུ་ཝེ་ལ',
 			'VG' => 'ཝརཇིན་གླིང་ཚོམ་ བྲཱི་ཊིཤ་མངའ་ཁོངས',
 			'VI' => 'ཝརཇིན་གླིང་ཚོམ་ ཡུ་ཨེས་ཨེ་མངའ་ཁོངས',
 			'VN' => 'བེཊ་ནཱམ',
 			'VU' => 'ཝ་ནུ་ཨ་ཏུ',
 			'WF' => 'ཝལ་ལིས྄་ ཨེནཌ་ ཕུ་ཏུ་ན་',
 			'WS' => 'ས་མོ་ཨ',
 			'YE' => 'ཡེ་མེན',
 			'YT' => 'མེ་ཡོཊ',
 			'ZA' => 'སཱའུཐ་ ཨཕ་རི་ཀ',
 			'ZM' => 'ཛམ་བྷི་ཡ',
 			'ZW' => 'ཛིམ་བྷབ་ཝེ',
 			'ZZ' => 'ངོ་མ་ཤེས་པའི་ལུང་ཕྱོགས',

		}
	},
);

has 'display_name_key' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'calendar' => 'ཟླ་ཐོ',
 			'collation' => 'གནས་སདུད་རིམ་ སགྲིག',
 			'currency' => 'ཤོག་དངུལ',
 			'numbers' => 'ཨང་ཡིག',

		}
	},
);

has 'display_name_type' => (
	is			=> 'ro',
	isa			=> HashRef[HashRef[Str]],
	init_arg	=> undef,
	default		=> sub {
		{
			'calendar' => {
 				'gregorian' => q{གྲེག་གོ་རི་ཡཱན་ཟླ་ཐོ},
 			},
 			'collation' => {
 				'ducet' => q{སྔ་སྒྲིག་ཡུ་ནི་ཀོཊ་གི་གོ་རིམ},
 				'search' => q{སྤྱི་དོན་འཚོལ་བ},
 				'traditional' => q{ལུགས་སྲོལ},
 			},
 			'numbers' => {
 				'arab' => q{ཨེ་ར་བིཀ་-ཨིན་ཌིཀ་ཨང},
 				'arabext' => q{ཨེ་ར་བིཀ་-ཨིན་ཌིཀ་རྒྱ་སྐྱེད་ཨང},
 				'armn' => q{ཨར་མི་ནི་ཡཱན་ཨང},
 				'armnlow' => q{ཨར་མི་ནི་ཡཱན་གྱི་མགྱོགས་ཡིག་ཨང་རྟགས},
 				'beng' => q{བངྒ་ལི་ཨང},
 				'deva' => q{དེ་ཝ་ན་ག་རི་ཨང},
 				'ethi' => q{ཨི་ཐི་ཡོ་པིཀ་ཨང་རྟགཨ},
 				'fullwide' => q{རྒྱ་ཚད་གང་བའི་ཨང},
 				'geor' => q{ཇཽར་ཇཱི་ཡཱན་ཨང་རྟགས},
 				'grek' => q{གྲིཀ་ཨང་རྟགས},
 				'greklow' => q{གྲིཀ་གི་མགྱོགས་ཡིག་ཨང་རྟགས},
 				'gujr' => q{གུ་ཇ་ར་ཏི་ཨང},
 				'guru' => q{གུ་རུ་མུ་ཁི་ཨང},
 				'hanidec' => q{རྒྱ་མིའི་ཚག་ཅན་མའི་ཨང་རྟགས},
 				'hans' => q{འཇམ་སངམ་རྒྱ་མིའི་ཨང་རྟགས},
 				'hansfin' => q{འཇམ་སངམ་རྒྱ་མི་གི་དངུལ་འབྲེལ་ཨང་རྟགས},
 				'hant' => q{སྔ་དུས་རྒྱ་མིའི་ཨང་རྟགས},
 				'hantfin' => q{སྔ་དུས་རྒྱ་མིའི་གི་དངུལ་འབྲེལ་ཨང་རྟགས},
 				'hebr' => q{ཧེ་བྲུ་ཨང་རྟགས},
 				'jpan' => q{ཇཱ་པཱན་ནིས་ཨང་རྟགས},
 				'jpanfin' => q{ཇཱ་པཱན་ནིས་དངུལ་འབྲེལ་ཨང་རྟགས},
 				'khmr' => q{ཁེ་མར་ཨང},
 				'knda' => q{ཀ་ན་ཌ་ཨང},
 				'laoo' => q{ལཱ་འོས་ཨང་},
 				'latn' => q{ཕྱི་གླིང་པའི་ཨང},
 				'mlym' => q{མ་ལ་ཡ་ལམ་ཨང་},
 				'mymr' => q{མི་ཡཱན་མར་ཨང་},
 				'orya' => q{ཨོ་རི་ཡ་ཨང་},
 				'roman' => q{རོ་མཱན་ཨང་རྟགས},
 				'romanlow' => q{རོ་མཱན་གྱི་མགྱོགས་ཡིག་ཨང་རྟགས},
 				'taml' => q{སྔ་དུས་ཊ་མིལ་ཨང་རྟགས},
 				'tamldec' => q{ཊ་མིལ་ཨང},
 				'telu' => q{ཏེ་ལུ་གུ་ཨང},
 				'thai' => q{ཐཱའི་ཨང},
 				'tibt' => q{ང་བཅས་ཀྱི་ཨང་ཡིག},
 			},

		}
	},
);

has 'display_name_measurement_system' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'metric' => q{མེ་ཊྲིཀ་བརྩི་ལུགས},
 			'UK' => q{བྲི་ཊིཤ་ བརྩི་ལུགས},
 			'US' => q{ཨ་མི་རི་ཀཱན་ བརྩི་ལུགས},

		}
	},
);

has 'display_name_code_patterns' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'language' => 'ཁ་སྐད་: {0}',
 			'script' => 'ཡིག་གཟུགས་: {0}',

		}
	},
);

has 'characters' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> $^V ge v5.18.0
	? eval <<'EOT'
	sub {
		no warnings 'experimental::regex_sets';
		return {
			auxiliary => qr{[྄ ཊ ཋ ཌ ཎ ཾ ཥ ྀ ཻ ཽ ྚ ྛ ྜ ྞ ྺ ྻ ྼ]},
			index => ['ཀ', 'ཁ', 'ག', 'ང', 'ཅ', 'ཆ', 'ཇ', 'ཉ', 'ཏ', 'ཐ', 'ད', 'ན', 'པ', 'ཕ', 'བ', 'མ', 'ཙ', 'ཚ', 'ཛ', 'ཝ', 'ཞ', 'ཟ', 'འ', 'ཡ', 'ར', 'ལ', 'ཤ', 'ས', 'ཧ', 'ཨ'],
			main => qr{[ཀ ཁ ག ང ཅ ཆ ཇ ཉ ཏ ཐ ད ན པ ཕ བ མ ཙ ཚ ཛ ཝ ཞ ཟ འ ཡ ར ལ ཤ ས ཧ ཨ ི ུ ེ ོ ྐ ྑ ྒ ྔ ྗ ྙ ྟ ྠ ྡ ྣ ྤ ྥ ྦ ྨ ྩ ྪ ྫ ྭ ྱ ྲ ླ ྵ ྶ ྷ]},
			numbers => qr{[\- ‑ , . % ‰ + 0༠ 1༡ 2༢ 3༣ 4༤ 5༥ 6༦ 7༧ 8༨ 9༩]},
			punctuation => qr{[\- ‐‑ – — , ; \: ! ? . … '‘’ "“” ( ) \[ \] ༼ ༽ § @ * / \& # † ‡ ༄ ༅ ༆ ༈ ༉ ༊ ࿐ ࿑ ༒ ࿒ ࿓ ࿔ ༶ ྾ ྿ ༌།༎༏༐༑༔༴]},
		};
	},
EOT
: sub {
		return { index => ['ཀ', 'ཁ', 'ག', 'ང', 'ཅ', 'ཆ', 'ཇ', 'ཉ', 'ཏ', 'ཐ', 'ད', 'ན', 'པ', 'ཕ', 'བ', 'མ', 'ཙ', 'ཚ', 'ཛ', 'ཝ', 'ཞ', 'ཟ', 'འ', 'ཡ', 'ར', 'ལ', 'ཤ', 'ས', 'ཧ', 'ཨ'], };
},
);


has 'ellipsis' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub {
		return {
			'final' => '{0}་་་་',
			'initial' => '་་་་{0}',
			'medial' => '{0}་་་་་་ {1}',
		};
	},
);

has 'units' => (
	is			=> 'ro',
	isa			=> HashRef[HashRef[HashRef[Str]]],
	init_arg	=> undef,
	default		=> sub { {
				'long' => {
					# Long Unit Identifier
					'duration-day' => {
						'other' => q(ཉིན་ཞག་ {0}),
					},
					# Core Unit Identifier
					'day' => {
						'other' => q(ཉིན་ཞག་ {0}),
					},
					# Long Unit Identifier
					'duration-hour' => {
						'other' => q(ཆུ་ཚོད་ {0}),
					},
					# Core Unit Identifier
					'hour' => {
						'other' => q(ཆུ་ཚོད་ {0}),
					},
					# Long Unit Identifier
					'duration-minute' => {
						'other' => q(སྐར་མ་ {0}),
					},
					# Core Unit Identifier
					'minute' => {
						'other' => q(སྐར་མ་ {0}),
					},
					# Long Unit Identifier
					'duration-month' => {
						'other' => q(ཟླཝ་ {0}),
					},
					# Core Unit Identifier
					'month' => {
						'other' => q(ཟླཝ་ {0}),
					},
					# Long Unit Identifier
					'duration-second' => {
						'other' => q(སྐར་ཆ་ {0}),
					},
					# Core Unit Identifier
					'second' => {
						'other' => q(སྐར་ཆ་ {0}),
					},
					# Long Unit Identifier
					'duration-week' => {
						'other' => q(བངུན་ཕྲག་ {0}),
					},
					# Core Unit Identifier
					'week' => {
						'other' => q(བངུན་ཕྲག་ {0}),
					},
					# Long Unit Identifier
					'duration-year' => {
						'other' => q(ལོ་འཁོར་ {0}),
					},
					# Core Unit Identifier
					'year' => {
						'other' => q(ལོ་འཁོར་ {0}),
					},
				},
				'short' => {
					# Long Unit Identifier
					'duration-day' => {
						'name' => q(ཉིན་ཞག་),
					},
					# Core Unit Identifier
					'day' => {
						'name' => q(ཉིན་ཞག་),
					},
					# Long Unit Identifier
					'duration-hour' => {
						'name' => q(ཆུ་ཚོད་),
					},
					# Core Unit Identifier
					'hour' => {
						'name' => q(ཆུ་ཚོད་),
					},
					# Long Unit Identifier
					'duration-minute' => {
						'name' => q(སྐར་མ་),
					},
					# Core Unit Identifier
					'minute' => {
						'name' => q(སྐར་མ་),
					},
					# Long Unit Identifier
					'duration-month' => {
						'name' => q(ཟླཝ་),
					},
					# Core Unit Identifier
					'month' => {
						'name' => q(ཟླཝ་),
					},
					# Long Unit Identifier
					'duration-second' => {
						'name' => q(སྐར་ཆ་),
					},
					# Core Unit Identifier
					'second' => {
						'name' => q(སྐར་ཆ་),
					},
					# Long Unit Identifier
					'duration-week' => {
						'name' => q(བངུན་ཕྲག་),
					},
					# Core Unit Identifier
					'week' => {
						'name' => q(བངུན་ཕྲག་),
					},
					# Long Unit Identifier
					'duration-year' => {
						'name' => q(ལོ་འཁོར་),
					},
					# Core Unit Identifier
					'year' => {
						'name' => q(ལོ་འཁོར་),
					},
				},
			} }
);

has 'yesstr' => (
	is			=> 'ro',
	isa			=> RegexpRef,
	init_arg	=> undef,
	default		=> sub { qr'^(?i:ཨིན་|ཨ|yes|y)$' }
);

has 'nostr' => (
	is			=> 'ro',
	isa			=> RegexpRef,
	init_arg	=> undef,
	default		=> sub { qr'^(?i:མེན་|མ|no|n)$' }
);

has 'listPatterns' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
				start => q({0} དང་ {1}),
				middle => q({0} དང་ {1}),
				end => q({0} དང་ {1}),
				2 => q({0} དང་ {1}),
		} }
);

has 'default_numbering_system' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> 'tibt',
);

has native_numbering_system => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> 'tibt',
);

has 'number_symbols' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'tibt' => {
			'infinity' => q(གྲངས་མེད),
			'nan' => q(ཨང་མད),
		},
	} }
);

has 'number_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		decimalFormat => {
			'default' => {
				'1000' => {
					'other' => 'སྟོང་ཕྲག 0',
				},
				'10000' => {
					'other' => 'ཁྲི་ཕྲག 0',
				},
				'100000' => {
					'other' => 'འབུམ་ཕྲག 0',
				},
				'1000000' => {
					'other' => 'ས་ཡ་ 0',
				},
				'10000000' => {
					'other' => 'བྱེ་བ་ 0',
				},
				'100000000' => {
					'other' => 'དུང་ཕྱུར་ 0',
				},
				'1000000000' => {
					'other' => 'དུང་ཕྱུར་ 00',
				},
				'10000000000' => {
					'other' => 'དུང་ཕྱུར་བརྒྱ་ 0',
				},
				'100000000000' => {
					'other' => 'དུང་ཕྱུར་སྟོང 0',
				},
				'1000000000000' => {
					'other' => 'དུང་ཕྱུར་ཁྲི་ 0',
				},
				'10000000000000' => {
					'other' => 'དུང་ཕྱུར་འབུམ་ 0',
				},
				'100000000000000' => {
					'other' => 'དུང་ཕྱུར་ས་ཡ་ 0',
				},
				'standard' => {
					'default' => '#,##,##0.###',
				},
			},
			'long' => {
				'1000' => {
					'other' => 'སྟོང་ཕྲག 0',
				},
				'10000' => {
					'other' => 'ཁྲི་ཕྲག 0',
				},
				'100000' => {
					'other' => 'འབུམ་ཕྲག 0',
				},
				'1000000' => {
					'other' => 'ས་ཡ་ 0',
				},
				'10000000' => {
					'other' => 'བྱེ་བ་ 0',
				},
				'100000000' => {
					'other' => 'དུང་ཕྱུར་ 0',
				},
				'1000000000' => {
					'other' => 'དུང་ཕྱུར་ 00',
				},
				'10000000000' => {
					'other' => 'དུང་ཕྱུར་བརྒྱ་ 0',
				},
				'100000000000' => {
					'other' => 'དུང་ཕྱུར་སྟོང 0',
				},
				'1000000000000' => {
					'other' => 'དུང་ཕྱུར་ཁྲི་ 0',
				},
				'10000000000000' => {
					'other' => 'དུང་ཕྱུར་འབུམ་ 0',
				},
				'100000000000000' => {
					'other' => 'དུང་ཕྱུར་ས་ཡ་ 0',
				},
			},
		},
		percentFormat => {
			'default' => {
				'standard' => {
					'default' => '#,##,##0 %',
				},
			},
		},
} },
);

has 'number_currency_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'latn' => {
			'pattern' => {
				'default' => {
					'standard' => {
						'positive' => '¤#,##,##0.00',
					},
				},
			},
		},
} },
);

has 'currencies' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'AED' => {
			display_name => {
				'currency' => q(ཡུ་ནཱའི་ཊེཌ་ ཨ་རབ་ ཨེ་མེ་རེཊས་ཀྱི་དངུལ་ ཌིར་ཧཱམ),
			},
		},
		'AFN' => {
			display_name => {
				'currency' => q(ཨཕ་གཱན་གྱི་དངུལ་ ཨཕ་ག་ནི),
			},
		},
		'AUD' => {
			symbol => 'AU$',
			display_name => {
				'currency' => q(ཨཱོས་ཊྲེ་ལི་ཡ་གི་དངུལ་ ཌོ་ལར),
			},
		},
		'BDT' => {
			display_name => {
				'currency' => q(བྷང་ལ་དེཤ་གི་དངུལ་ ཏ་ཀ),
			},
		},
		'BMD' => {
			display_name => {
				'currency' => q(བར་མུ་ཌ་གི་དངུལ་ ཌོ་ལར),
			},
		},
		'BRL' => {
			display_name => {
				'currency' => q(བྲ་ཛིལ་གྱི་དངུལ་ རེ་ཡལ),
			},
		},
		'BTN' => {
			symbol => 'Nu.',
			display_name => {
				'currency' => q(དངུལ་ཀྲམ),
			},
		},
		'CAD' => {
			display_name => {
				'currency' => q(ཀེ་ན་ཌ་གི་དངུལ་ ཌོ་ལར),
			},
		},
		'CHF' => {
			display_name => {
				'currency' => q(སུ་ཡིས་ཀྱི་དངུལ་ ཕྲངཀ),
			},
		},
		'CLP' => {
			display_name => {
				'currency' => q(ཅི་ལི་གི་དངུལ་ པེ་སོ),
			},
		},
		'CNY' => {
			display_name => {
				'currency' => q(རྒྱ་ནག་གི་དངུལ་ ཡུ་ཝཱན),
			},
		},
		'COP' => {
			display_name => {
				'currency' => q(ཀོ་ལོམ་བྷི་ཡ་གི་དངུལ་ པེ་སོ),
			},
		},
		'CUP' => {
			display_name => {
				'currency' => q(ཀིའུ་བྷ་གི་དངུལ་ པེ་སོ),
			},
		},
		'DKK' => {
			display_name => {
				'currency' => q(ཌེན་མཱཀ་གི་དངུལ་ ཀྲོན),
			},
		},
		'DZD' => {
			display_name => {
				'currency' => q(ཨཱལ་ཇི་རི་ཡ་གི་དངུལ་ ཌའི་ནར),
			},
		},
		'EGP' => {
			display_name => {
				'currency' => q(ཨི་ཇིབཊ་གི་དངུལ་ པ་འུནཌ),
			},
		},
		'EUR' => {
			display_name => {
				'currency' => q(ཡུ་རོ༌དངུལ་),
			},
		},
		'GBP' => {
			display_name => {
				'currency' => q(བྲི་ཊིཤ་ པ་འུནཌ་ ཨིས་ཊར་ལིང),
			},
		},
		'HKD' => {
			display_name => {
				'currency' => q(ཧོང་ཀོང་གི་དངུལ་ ཌོ་ལར),
			},
		},
		'IDR' => {
			display_name => {
				'currency' => q(ཨིན་ཌོ་ནེ་ཤི་ཡ་གི་དངུལ་ རུ་པི་ཡ),
			},
		},
		'ILS' => {
			symbol => 'ILS',
			display_name => {
				'currency' => q(ཨིས་རེལ་གྱི་དངུལ་གསརཔ་ ཤེ་ཀེལ),
			},
		},
		'INR' => {
			display_name => {
				'currency' => q(རྒྱ་གར་གྱི་དངུལ་ རུ་པི),
			},
		},
		'IQD' => {
			display_name => {
				'currency' => q(ཨི་རཱཀ་གི་དངུལ་ ཌི་ན),
			},
		},
		'IRR' => {
			display_name => {
				'currency' => q(ཨི་རཱན་གྱི་དངུལ་ རི་ཨཱལ),
			},
		},
		'ISK' => {
			display_name => {
				'currency' => q(ཨཱཡིས་ལེནཌ་གི་དངུལ་ ཀྲོ་ན),
			},
		},
		'JMD' => {
			display_name => {
				'currency' => q(ཇཱ་མཻ་ཀ་གི་དངུལ་ ཌོ་ལར),
			},
		},
		'JOD' => {
			display_name => {
				'currency' => q(ཇོར་ཌན་གྱི་དངུལ་ ཌི་ན),
			},
		},
		'JPY' => {
			display_name => {
				'currency' => q(ཇཱ་པཱན་གྱི་དངུལ་ ཡེན),
			},
		},
		'KES' => {
			display_name => {
				'currency' => q(ཀེན་ཡ་གི་དངུལ་ ཤི་ལིང),
			},
		},
		'KHR' => {
			display_name => {
				'currency' => q(ཀེམ་བྷོ་ཌི་ཡ་གི་དངུལ་ རི་ཨཱལ),
			},
		},
		'KPW' => {
			display_name => {
				'currency' => q(ནོརཐ་ ཀོ་རི་ཡ་གི་དངུལ་ ཝོན),
			},
		},
		'KRW' => {
			symbol => 'KR₩',
			display_name => {
				'currency' => q(སཱའུཐ་ ཀོ་རི་ཡ་གི་དངུལ་ ཝོན),
			},
		},
		'KWD' => {
			display_name => {
				'currency' => q(ཀུ་ཝེཊ་གི་དངུལ་ ཌི་ན),
			},
		},
		'KZT' => {
			display_name => {
				'currency' => q(ཀ་ཛགས་ཏཱན་གྱི་དངུལ་ ཏེང་གེ),
			},
		},
		'LAK' => {
			display_name => {
				'currency' => q(ལཱ་ཝོས་ཀྱི་དངུལ་ ཀིཔ),
			},
		},
		'LBP' => {
			display_name => {
				'currency' => q(ལེ་བ་ནོན་གྱི་དངུལ་ པ་འུནཌ),
			},
		},
		'LKR' => {
			display_name => {
				'currency' => q(ཤྲི་ ལང་ཀ་གི་དངུལ་ རུ་པི),
			},
		},
		'LRD' => {
			display_name => {
				'currency' => q(ལཱའི་བེ་རི་ཡ་གི་དངུལ་ ཌོ་ལར),
			},
		},
		'LYD' => {
			display_name => {
				'currency' => q(ལི་བི་ཡ་གི་དངུལ་ ཌི་ན),
			},
		},
		'MAD' => {
			display_name => {
				'currency' => q(མོ་རོ་ཀོ་གི་དངུལ་ ཌིར་ཧཱམ),
			},
		},
		'MMK' => {
			display_name => {
				'currency' => q(མི་ཡཱན་མར་གྱི་དངུལ་ ཅཱཏ),
			},
		},
		'MNT' => {
			display_name => {
				'currency' => q(སོག་པོའི་དངུལ་ ཏུ་གྲིཀ),
			},
		},
		'MVR' => {
			display_name => {
				'currency' => q(མཱལ་དིབས་ཀྱི་དངུལ་ རུ་ཕི་ཡ),
			},
		},
		'MXN' => {
			display_name => {
				'currency' => q(མེཀ་སི་ཀོ་གི་དངུལ་ པེ་སོ),
			},
		},
		'MYR' => {
			display_name => {
				'currency' => q(མ་ལེ་ཤི་ཡ་གི་དངུལ་ རིང་གིཊ),
			},
		},
		'NOK' => {
			display_name => {
				'currency' => q(ནོར་ཝེ་གི་དངུལ་ ཀྲོ་ན),
			},
		},
		'NPR' => {
			display_name => {
				'currency' => q(བལ་པོའི་དངུལ་ རུ་པི),
			},
		},
		'NZD' => {
			display_name => {
				'currency' => q(ནིའུ་ཛི་ལེནཌ་གི་དངུལ་ ཌོ་ལར),
			},
		},
		'OMR' => {
			display_name => {
				'currency' => q(ཨོ་མཱན་གྱི་དངུལ་ རི་ཨཱལ),
			},
		},
		'PAB' => {
			display_name => {
				'currency' => q(པ་ན་མ་གི་དངུལ་ བཱལ་བོ་ཝ),
			},
		},
		'PEN' => {
			display_name => {
				'currency' => q(པ་རུ་གི་དངུལ་ ནུ་བོ་ སཱོལ),
			},
		},
		'PHP' => {
			display_name => {
				'currency' => q(ཕི་ལི་པིནས་གྱི་དངུལ་ པེ་སོ),
			},
		},
		'PKR' => {
			display_name => {
				'currency' => q(པ་ཀིས་ཏཱན་གྱི་དངུལ་ རུ་པི),
			},
		},
		'PLN' => {
			display_name => {
				'currency' => q(པོ་ལེནཌ་ཀྱི་དངུལ ཛ྄ལོ་ཊི),
			},
		},
		'QAR' => {
			display_name => {
				'currency' => q(ཀ་ཊར་གྱི་དངུལ་ རི་ཨཱལ),
			},
		},
		'RUB' => {
			display_name => {
				'currency' => q(ཨུ་རུ་སུ་གི་དངུལ་ རུ་བཱལ),
			},
		},
		'SAR' => {
			display_name => {
				'currency' => q(སཱཝ་དིའི་དངུལ་ རི་ཡཱལ),
			},
		},
		'SCR' => {
			display_name => {
				'currency' => q(སེ་ཤཱལས་ཀྱི་དངུལ་ རུ་པི),
			},
		},
		'SEK' => {
			display_name => {
				'currency' => q(སུའི་ཌེན་གྱི་དངུལ་ ཀྲོ་ན),
			},
		},
		'SGD' => {
			display_name => {
				'currency' => q(སིང་ག་པོར་གྱི་དངུལ་ ཌོ་ལར),
			},
		},
		'SYP' => {
			display_name => {
				'currency' => q(སི་རི་ཡ་གི་དངུལ་ པ་འུནཌ),
			},
		},
		'THB' => {
			symbol => 'TH฿',
			display_name => {
				'currency' => q(ཐཱའི་ལེནཌ་གི་དངུལ་ བཱཏ),
			},
		},
		'TJS' => {
			display_name => {
				'currency' => q(ཏ་ཇི་ཀིས་ཏཱན་གྱི་དངུལ་ སོ་མོ་ནི),
			},
		},
		'TRY' => {
			display_name => {
				'currency' => q(ཊཱར་ཀི་གི་དངུལ་ ལི་ར),
			},
		},
		'TWD' => {
			display_name => {
				'currency' => q(ཊཱའི་ཝཱན་གི་དངུལ ཌོ་ལར),
			},
		},
		'TZS' => {
			display_name => {
				'currency' => q(ཊཱན་ཛཱ་ནི་ཡ་གི་དངུལ་ ཤི་ལིང),
			},
		},
		'UGX' => {
			display_name => {
				'currency' => q(ཡུ་གྷེན་ཌ་གི་དངུལ་ ཤི་ལིང),
			},
		},
		'USD' => {
			display_name => {
				'currency' => q(ཡུ་ཨེས་ ཌོ་ལར),
			},
		},
		'UYU' => {
			display_name => {
				'currency' => q(ཡུ་རུ་གུ་ཝའི་གི་དངུལ་ པེ་སོ),
			},
		},
		'UZS' => {
			display_name => {
				'currency' => q(ཨུས་བེ་ཀིས་ཏཱན་གྱི་དངུལ་ སོམ),
			},
		},
		'VEF' => {
			display_name => {
				'currency' => q(བེ་ནི་ཛུ་ཝེ་ལ་གི་དངུལ་ བོ་ལི་བར \(2008–2018\)),
			},
		},
		'VES' => {
			display_name => {
				'currency' => q(བེ་ནི་ཛུ་ཝེ་ལ་གི་དངུལ་ བོ་ལི་བར),
			},
		},
		'VND' => {
			display_name => {
				'currency' => q(བེཊ་ནཱམ་གྱི་དངུལ་ ཌོང),
			},
		},
		'XAF' => {
			symbol => 'XAF',
		},
		'XXX' => {
			display_name => {
				'currency' => q(མ་ཤེས་པའི་དངུལ),
			},
		},
		'ZAR' => {
			display_name => {
				'currency' => q(སཱའུཐ་ ཨཕ་རི་ཀ་གི་དངུལ་ རཱནད),
			},
		},
	} },
);


has 'calendar_months' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'༡',
							'༢',
							'༣',
							'༤',
							'༥',
							'༦',
							'༧',
							'༨',
							'༩',
							'༡༠',
							'༡༡',
							'12'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'༡',
							'༢',
							'༣',
							'4',
							'༥',
							'༦',
							'༧',
							'༨',
							'9',
							'༡༠',
							'༡༡',
							'༡༢'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'ཟླ་དངཔ་',
							'ཟླ་གཉིས་པ་',
							'ཟླ་གསུམ་པ་',
							'ཟླ་བཞི་པ་',
							'ཟླ་ལྔ་པ་',
							'ཟླ་དྲུག་པ',
							'ཟླ་བདུན་པ་',
							'ཟླ་བརྒྱད་པ་',
							'ཟླ་དགུ་པ་',
							'ཟླ་བཅུ་པ་',
							'ཟླ་བཅུ་གཅིག་པ་',
							'ཟླ་བཅུ་གཉིས་པ་'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'ཟླ་༡',
							'ཟླ་༢',
							'ཟླ་༣',
							'ཟླ་༤',
							'ཟླ་༥',
							'ཟླ་༦',
							'ཟླ་༧',
							'ཟླ་༨',
							'ཟླ་༩',
							'ཟླ་༡༠',
							'ཟླ་༡༡',
							'ཟླ་༡༢'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'༡',
							'༢',
							'༣',
							'༤',
							'༥',
							'༦',
							'༧',
							'༨',
							'༩',
							'༡༠',
							'༡༡',
							'༡༢'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'སྤྱི་ཟླ་དངཔ་',
							'སྤྱི་ཟླ་གཉིས་པ་',
							'སྤྱི་ཟླ་གསུམ་པ་',
							'སྤྱི་ཟླ་བཞི་པ',
							'སྤྱི་ཟླ་ལྔ་པ་',
							'སྤྱི་ཟླ་དྲུག་པ',
							'སྤྱི་ཟླ་བདུན་པ་',
							'སྤྱི་ཟླ་བརྒྱད་པ་',
							'སྤྱི་ཟླ་དགུ་པ་',
							'སྤྱི་ཟླ་བཅུ་པ་',
							'སྤྱི་ཟླ་བཅུ་གཅིག་པ་',
							'སྤྱི་ཟླ་བཅུ་གཉིས་པ་'
						],
						leap => [
							
						],
					},
				},
			},
	} },
);

has 'calendar_days' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {
						mon => 'མིར་',
						tue => 'ལྷག་',
						wed => 'ཕུར་',
						thu => 'སངས་',
						fri => 'སྤེན་',
						sat => 'ཉི་',
						sun => 'ཟླ་'
					},
					wide => {
						mon => 'གཟའ་མིག་དམར་',
						tue => 'གཟའ་ལྷག་པ་',
						wed => 'གཟའ་ཕུར་བུ་',
						thu => 'གཟའ་པ་སངས་',
						fri => 'གཟའ་སྤེན་པ་',
						sat => 'གཟའ་ཉི་མ་',
						sun => 'གཟའ་ཟླ་བ་'
					},
				},
				'stand-alone' => {
					narrow => {
						mon => 'མིར',
						tue => 'ལྷག',
						wed => 'ཕུར',
						thu => 'སངྶ',
						fri => 'སྤེན',
						sat => 'ཉི',
						sun => 'ཟླ'
					},
				},
			},
	} },
);

has 'calendar_quarters' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {0 => 'བཞི་དཔྱ་༡',
						1 => 'བཞི་དཔྱ་༢',
						2 => 'བཞི་དཔྱ་༣',
						3 => 'བཞི་དཔྱ་༤'
					},
					wide => {0 => 'བཞི་དཔྱ་དང་པ་',
						1 => 'བཞི་དཔྱ་གཉིས་པ་',
						2 => 'བཞི་དཔྱ་གསུམ་པ་',
						3 => 'བཞི་དཔྱ་བཞི་པ་'
					},
				},
				'stand-alone' => {
					narrow => {0 => '༡',
						1 => '༢',
						2 => '༣',
						3 => '༤'
					},
				},
			},
	} },
);

has 'day_periods' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			'format' => {
				'abbreviated' => {
					'am' => q{སྔ་ཆ་},
					'pm' => q{ཕྱི་ཆ་},
				},
			},
		},
	} },
);

has 'eras' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
		},
		'gregorian' => {
		},
	} },
);

has 'date_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			'full' => q{EEEE, G སྤྱི་ལོ་y MMMM ཚེས་dd},
			'long' => q{G སྤྱི་ལོ་y MMMM ཚེས་ dd},
			'medium' => q{G སྤྱི་ལོ་y ཟླ་MMM ཚེས་dd},
			'short' => q{GGGGG y-MM-dd},
		},
		'gregorian' => {
			'full' => q{EEEE, སྤྱི་ལོ་y MMMM ཚེས་dd},
			'long' => q{སྤྱི་ལོ་y MMMM ཚེས་ dd},
			'medium' => q{སྤྱི་ལོ་y ཟླ་MMM ཚེས་dd},
			'short' => q{y-MM-dd},
		},
	} },
);

has 'time_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
		},
		'gregorian' => {
			'full' => q{ཆུ་ཚོད་ h སྐར་མ་ mm:ss a zzzz},
			'long' => q{ཆུ་ཚོད་ h སྐར་མ་ mm:ss a z},
			'medium' => q{ཆུ་ཚོད་h:mm:ss a},
			'short' => q{ཆུ་ཚོད་ h སྐར་མ་ mm a},
		},
	} },
);

has 'datetime_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			'full' => q{{1} {0}},
			'long' => q{{1} {0}},
			'medium' => q{{1} {0}},
			'short' => q{{1} {0}},
		},
		'gregorian' => {
			'full' => q{{1} {0}},
			'long' => q{{1} {0}},
			'medium' => q{{1} {0}},
			'short' => q{{1} {0}},
		},
	} },
);

has 'datetime_formats_available_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			Ed => q{d E},
			GyMMM => q{G y སྤྱི་ཟླ་MMM},
			GyMMMEd => q{གཟའ་E, G ལོy ཟླ་MMM ཚེ་d},
			H => q{ཆུ་ཚོད་HH},
			MEd => q{E, M-d},
			MMM => q{སྤྱི་LLL},
			MMMEd => q{E, སྤྱི་LLL ཚེ་d},
			MMMd => q{སྤྱི་LLL ཚེ་d},
			Md => q{M-d},
			h => q{ཆུ་ཚོད་h a},
			yyyyM => q{G y-M},
			yyyyMEd => q{E, G y-M-d},
			yyyyMMM => q{G y སྤྱི་ཟླ་MMM},
			yyyyMMMEd => q{གཟའ་E, G ལོy ཟླ་MMM ཚེ་d},
			yyyyMd => q{G y-M-d},
		},
		'gregorian' => {
			Ed => q{d E},
			GyMMM => q{G y སྤྱི་ཟླ་MMM},
			GyMMMEd => q{གཟའ་E, G ལོy ཟླ་MMM ཚེ་d},
			H => q{ཆུ་ཚོད་HH},
			MEd => q{E, M-d},
			MMM => q{སྤྱི་LLL},
			MMMEd => q{E, སྤྱི་LLL ཚེ་d},
			MMMd => q{སྤྱི་LLL ཚེ་d},
			Md => q{M-d},
			h => q{ཆུ་ཚོད་h a},
			yM => q{y-M},
			yMEd => q{E, y-M-d},
			yMMM => q{y སྤྱི་ཟླ་MMM},
			yMMMEd => q{གཟའ་E, ལོy ཟླ་MMM ཚེ་d},
			yMd => q{y-M-d},
		},
	} },
);

has 'datetime_formats_append_item' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
	} },
);

has 'datetime_formats_interval' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			M => {
				M => q{སྤྱི་ཟླ་M–M},
			},
			MEd => {
				M => q{E, སྤྱི་ཟླ་MM ཚེས་dd–ཟླ་MM ཚེས་dd},
				d => q{E, སྤྱི་ཟླ་MM ཚེས་dd–ཟླ་MM ཚེས་dd},
			},
			MMM => {
				M => q{སྤྱི་LLL–LLL},
			},
			MMMEd => {
				M => q{E, སྤྱི་ཟླ་MM ཚེས་d – E, ཟླ་MM ཚེས་d},
				d => q{E, སྤྱི་ཟླ་MM ཚེས་d – E, ཟླ་MM ཚེས་d},
			},
			MMMd => {
				M => q{སྤྱི་ཟླ་MM ཚེས་d–ཟླ་MM ཚེས་d},
				d => q{སྤྱི་ཟླ་MM ཚེས་d–d},
			},
			Md => {
				M => q{སྤྱི་ཟླ་MM ཚེས་dd–ཟླ་MM ཚེས་dd},
				d => q{སྤྱི་ཟླ་M ཚེས་dd/dd},
			},
			fallback => '{0} – {1}',
			yM => {
				M => q{G y-MM – MM},
				y => q{G y-MM – y-MM},
			},
			yMEd => {
				M => q{E, y-MM-dd – E, y-MM-dd},
				d => q{E, y-MM-dd – E, y-MM-dd},
				y => q{E, y-MM-dd – E, y-MM-dd},
			},
			yMMM => {
				M => q{སྤྱི་ཟླ་MMM/MMM, y},
				y => q{G y-MM – y-MM},
			},
			yMMMEd => {
				M => q{E, y-MM-dd – E, y-MM-dd},
				d => q{E, y-MM-dd – E, y-MM-dd},
				y => q{E, y-MM-dd – E, y-MM-dd},
			},
			yMMMM => {
				M => q{G y-སྤྱི་ཟླ་MM – MM},
				y => q{G y-MM – y-MM},
			},
			yMMMd => {
				M => q{G y-MM-dd – MM-d},
				d => q{G y-MM-d – d},
				y => q{G y-MM-dd – y-MM-dd},
			},
			yMd => {
				M => q{G y-MM-dd – MM-dd},
				d => q{G y-MM-dd – dd},
				y => q{G y-MM-dd – y-MM-dd},
			},
		},
		'gregorian' => {
			M => {
				M => q{སྤྱི་ཟླ་M–M},
			},
			MEd => {
				M => q{E, སྤྱི་ཟླ་MM ཚེས་dd–ཟླ་MM ཚེས་dd},
				d => q{E, སྤྱི་ཟླ་MM ཚེས་dd–ཟླ་MM ཚེས་dd},
			},
			MMM => {
				M => q{སྤྱི་LLL–LLL},
			},
			MMMEd => {
				M => q{E, སྤྱི་ཟླ་MM ཚེས་d – E, ཟླ་MM ཚེས་d},
				d => q{E, སྤྱི་ཟླ་MM ཚེས་d – E, ཟླ་MM ཚེས་d},
			},
			MMMd => {
				M => q{སྤྱི་ཟླ་MM ཚེས་d–ཟླ་MM ཚེས་d},
				d => q{སྤྱི་ཟླ་MM ཚེས་d–d},
			},
			Md => {
				M => q{སྤྱི་ཟླ་MM ཚེས་dd–ཟླ་MM ཚེས་dd},
				d => q{སྤྱི་ཟླ་M ཚེས་dd/dd},
			},
			fallback => '{0} – {1}',
			yM => {
				M => q{y-MM – MM},
			},
			yMEd => {
				M => q{E, y-MM-dd – E, y-MM-dd},
				d => q{E, y-MM-dd – E, y-MM-dd},
				y => q{E, y-MM-dd – E, y-MM-dd},
			},
			yMMM => {
				M => q{སྤྱི་ཟླ་MMM/MMM, y},
				y => q{y-MM – y-MM},
			},
			yMMMEd => {
				M => q{E, y-MM-dd – E, y-MM-dd},
				d => q{E, y-MM-dd – E, y-MM-dd},
				y => q{E, y-MM-dd – E, y-MM-dd},
			},
			yMMMM => {
				M => q{y-སྤྱི་ཟླ་MM – MM},
				y => q{y-MM – y-MM},
			},
			yMMMd => {
				M => q{y-MM-dd – MM-d},
				d => q{y-MM-d – d},
				y => q{y-MM-dd – y-MM-dd},
			},
			yMd => {
				M => q{y-MM-dd – MM-dd},
				d => q{y-MM-dd – dd},
			},
		},
	} },
);

has 'time_zone_names' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default	=> sub { {
		gmtFormat => q(ཇི་ཨེམ་ཏི་{0}),
		gmtZeroFormat => q(ཇི་ཨེམ་ཊི་),
		regionFormat => q({0}་ཆུ་ཚོད།),
		fallbackFormat => q({1}། ({0}་)),
		'Afghanistan' => {
			long => {
				'standard' => q#ཨཕ་ག་ནི་ས྄ཏཱནཆུ་ཚོད#,
			},
		},
		'Africa/Accra' => {
			exemplarCity => q#ཨེཀ་ཀྲ#,
		},
		'Africa/Addis_Ababa' => {
			exemplarCity => q#ཨ་ཌིས་ ཨ་བྷ་བྷ#,
		},
		'Africa/Algiers' => {
			exemplarCity => q#ཨལ་ཇི་ཡས#,
		},
		'Africa/Asmera' => {
			exemplarCity => q#ཨཱས་མ་ར#,
		},
		'Africa/Bamako' => {
			exemplarCity => q#བྷ་མ་ཀོ#,
		},
		'Africa/Bangui' => {
			exemplarCity => q#བྷང་གི#,
		},
		'Africa/Banjul' => {
			exemplarCity => q#བྷཱན་ཇུལ#,
		},
		'Africa/Bissau' => {
			exemplarCity => q#བྷི་སཱའུ#,
		},
		'Africa/Brazzaville' => {
			exemplarCity => q#བྷྲ་ཛ་བིལ#,
		},
		'Africa/Bujumbura' => {
			exemplarCity => q#བྷུ་ཇུམ་བྷུ་ར#,
		},
		'Africa/Cairo' => {
			exemplarCity => q#ཀཱའི་རོ#,
		},
		'Africa/Conakry' => {
			exemplarCity => q#ཀོ་ནཀ་རི#,
		},
		'Africa/Dakar' => {
			exemplarCity => q#ཌཱ་ཀར#,
		},
		'Africa/Djibouti' => {
			exemplarCity => q#ཇི་བྷུ་ཊི#,
		},
		'Africa/Gaborone' => {
			exemplarCity => q#གྷ་བྷོ་རོ་ནེ#,
		},
		'Africa/Harare' => {
			exemplarCity => q#ཧ་རཱ་རེ#,
		},
		'Africa/Kampala' => {
			exemplarCity => q#ཀེམ་པ་ལ#,
		},
		'Africa/Khartoum' => {
			exemplarCity => q#ཁཱར་ཊུམ#,
		},
		'Africa/Kigali' => {
			exemplarCity => q#ཀི་གྷ་ལི#,
		},
		'Africa/Kinshasa' => {
			exemplarCity => q#ཀིན་ཤ་ས#,
		},
		'Africa/Libreville' => {
			exemplarCity => q#ལི་བྷྲ་བིལ#,
		},
		'Africa/Lome' => {
			exemplarCity => q#ལོ་མེ#,
		},
		'Africa/Luanda' => {
			exemplarCity => q#ལུ་ཝེན་ཌ#,
		},
		'Africa/Lusaka' => {
			exemplarCity => q#ལུ་སཱ་ཀ#,
		},
		'Africa/Malabo' => {
			exemplarCity => q#མ་ལ་བྷོ#,
		},
		'Africa/Maputo' => {
			exemplarCity => q#མ་པུ་ཏོ#,
		},
		'Africa/Maseru' => {
			exemplarCity => q#མ་ས་རུ#,
		},
		'Africa/Mbabane' => {
			exemplarCity => q#འུམ་བྷ་བྷ་ནི#,
		},
		'Africa/Mogadishu' => {
			exemplarCity => q#མོ་གཱ་ཌི་ཤུ#,
		},
		'Africa/Monrovia' => {
			exemplarCity => q#མཱན་རོ་བི་ཡ#,
		},
		'Africa/Nairobi' => {
			exemplarCity => q#ནཱའི་རོ་བི#,
		},
		'Africa/Niamey' => {
			exemplarCity => q#ནི་ཡ་མེ#,
		},
		'Africa/Nouakchott' => {
			exemplarCity => q#ནུ་ཨཀ་ཤའོཊ#,
		},
		'Africa/Ouagadougou' => {
			exemplarCity => q#ཝ་གཱ་ཌུ་གུ#,
		},
		'Africa/Sao_Tome' => {
			exemplarCity => q#སཝ་ ཊོ་མེ#,
		},
		'Africa/Tripoli' => {
			exemplarCity => q#ཏྲི་པོ་ལི#,
		},
		'Africa/Tunis' => {
			exemplarCity => q#ཊུ་ནིས྄#,
		},
		'Africa/Windhoek' => {
			exemplarCity => q#ཝིནཌ་ཧུཀ#,
		},
		'Africa_Central' => {
			long => {
				'standard' => q#དབུས་ཕྱོགས་ཨཕ་རི་ཀཱ་ཆུ་ཚོད#,
			},
		},
		'Africa_Eastern' => {
			long => {
				'standard' => q#ཤར་ཕྱོགས་ཨཕ་རི་ཀཱ་ཆུ་ཚོད#,
			},
		},
		'Africa_Southern' => {
			long => {
				'standard' => q#ལྷོ་ཕྱོགས་ཨཕ་རི་ཀཱ་ཆུ་ཚོད#,
			},
		},
		'Africa_Western' => {
			long => {
				'daylight' => q#ནུབ་ཕྱོགས་ཨཕ་རི་ཀཱ་བྱཱར་དུས་ཆུ་ཚོད#,
				'generic' => q#ནུབ་ཕྱོགས་ཨཕ་རི་ཀཱ་ཆུ་ཚོད#,
				'standard' => q#ནུབ་ཕྱོགས་ཨཕ་རི་ཀཱ་ཚད་ལྡན་ཆུ་ཚོད#,
			},
		},
		'Alaska' => {
			long => {
				'daylight' => q#ཨ་ལསི་ཀ་ཉིན་སྲུང་ཆུ་ཚོད#,
				'generic' => q#ཨ་ལསི་ཀ་ཆུ་ཚོད#,
				'standard' => q#ཨ་ལསི་ཀ་ཚད་ལྡན་ཆུ་ཚོད#,
			},
		},
		'Amazon' => {
			long => {
				'daylight' => q#ཨེ་མ་ཛཱོན་བྱཱར་དུས་ཆུ་ཚོད#,
				'generic' => q#ཨེ་མ་ཛཱོན་ཆུ་ཚོད#,
				'standard' => q#ཨེ་མ་ཛཱོན་ཚད་ལྡན་ཆུ་ཚོད#,
			},
		},
		'America/Antigua' => {
			exemplarCity => q#ཨན་ཊི་གུ་ཝ་#,
		},
		'America/Asuncion' => {
			exemplarCity => q#ཨ་སུན་སི་འོན#,
		},
		'America/Barbados' => {
			exemplarCity => q#བྷར་བེ་ཌོས#,
		},
		'America/Belize' => {
			exemplarCity => q#བྷེ་ལིཛ#,
		},
		'America/Bogota' => {
			exemplarCity => q#བྷོ་ག་ཊ#,
		},
		'America/Buenos_Aires' => {
			exemplarCity => q#བྷུའི་ནོས་ ཨའི་རིས#,
		},
		'America/Cambridge_Bay' => {
			exemplarCity => q#ཀེམ་བིརིདཆ་ བའེ#,
		},
		'America/Caracas' => {
			exemplarCity => q#ཀ་ར་ཀཱས#,
		},
		'America/Chicago' => {
			exemplarCity => q#ཅི་ཀཱ་གོ#,
		},
		'America/Coral_Harbour' => {
			exemplarCity => q#ཨ་ཏི་ཀོ་ཀཱན#,
		},
		'America/Costa_Rica' => {
			exemplarCity => q#ཀོས་ཊ་རི་ཀ#,
		},
		'America/Dawson' => {
			exemplarCity => q#དའུ་སཱོན#,
		},
		'America/Dawson_Creek' => {
			exemplarCity => q#དའུ་སཱོན་ ཀིརིཀ#,
		},
		'America/Dominica' => {
			exemplarCity => q#ཌོ་མི་ནི་ཀ#,
		},
		'America/Edmonton' => {
			exemplarCity => q#ཨེཌ་མཱོན་ཊོན#,
		},
		'America/El_Salvador' => {
			exemplarCity => q#ཨེལ་ སཱལ་བ་ཌོ#,
		},
		'America/Goose_Bay' => {
			exemplarCity => q#གཱུསི་ བའེ#,
		},
		'America/Guatemala' => {
			exemplarCity => q#གྷོ་ཊ་མ་ལ#,
		},
		'America/Guyana' => {
			exemplarCity => q#གྷ་ཡ་ན#,
		},
		'America/Halifax' => {
			exemplarCity => q#ཧ་ལི་ཕེགསི#,
		},
		'America/Inuvik' => {
			exemplarCity => q#ཨི་ནུ་ཝིཀ#,
		},
		'America/Jamaica' => {
			exemplarCity => q#ཇཱ་མའེ་ཀ#,
		},
		'America/La_Paz' => {
			exemplarCity => q#ལ་པཱཛ྄#,
		},
		'America/Lima' => {
			exemplarCity => q#ལི་མ#,
		},
		'America/Mexico_City' => {
			exemplarCity => q#མེཀ་སི་ཀོ་ སི་ཊི#,
		},
		'America/Moncton' => {
			exemplarCity => q#མཱོངཀ་ཊོན#,
		},
		'America/Montevideo' => {
			exemplarCity => q#མོན་ཊེ་བྷི་ཌིའོ#,
		},
		'America/Nassau' => {
			exemplarCity => q#ན་སའོ#,
		},
		'America/Nipigon' => {
			exemplarCity => q#ནི་པི་གཱོན#,
		},
		'America/Panama' => {
			exemplarCity => q#པ་ན་མ#,
		},
		'America/Pangnirtung' => {
			exemplarCity => q#པེང་ནིར་ཏུང#,
		},
		'America/Paramaribo' => {
			exemplarCity => q#པ་ར་མ་རི་བྷོ#,
		},
		'America/Rainy_River' => {
			exemplarCity => q#རཱེ་ནི་རི་ཝར#,
		},
		'America/Rankin_Inlet' => {
			exemplarCity => q#རེན་ཀིན་ ཨིན་ལེཊ#,
		},
		'America/Regina' => {
			exemplarCity => q#རི་ཇི་ན#,
		},
		'America/Resolute' => {
			exemplarCity => q#རི་སོ་ལིའུཊ#,
		},
		'America/Santiago' => {
			exemplarCity => q#སཱན་ཊི་ཡ་གྷོ#,
		},
		'America/Santo_Domingo' => {
			exemplarCity => q#སཱན་ཊོ་ ཌོ་མིང་གྷོ#,
		},
		'America/St_Johns' => {
			exemplarCity => q#ཨིསི་ཊེཊ་ ཇཱོནསི་#,
		},
		'America/Swift_Current' => {
			exemplarCity => q#སུ་ཨིཕཊ་ཀ་རེནཊ#,
		},
		'America/Tegucigalpa' => {
			exemplarCity => q#ཊེ་གུ་སི་གཱལ་པ#,
		},
		'America/Thunder_Bay' => {
			exemplarCity => q#ཐན་ཌར་ བའེ#,
		},
		'America/Tijuana' => {
			exemplarCity => q#ཏིའུ་ཝ་ན#,
		},
		'America/Toronto' => {
			exemplarCity => q#ཊོ་རོན་ཊོ#,
		},
		'America/Yakutat' => {
			exemplarCity => q#ཡ་ཀུ་ཏཏ#,
		},
		'America_Central' => {
			long => {
				'daylight' => q#བྱང་ཨ་མི་རི་ཀ་དབུས་ཕྱོགས་ཉིན་སྲུང་ཆུ་ཚོད#,
				'generic' => q#བྱང་ཨ་མི་རི་ཀ་དབུས་ཕྱོགས་ཆུ་ཚོད#,
				'standard' => q#བྱང་ཨ་མི་རི་ཀ་དབུས་ཕྱོགས་ཚད་ལྡན་ཆུ་ཚོད#,
			},
		},
		'America_Eastern' => {
			long => {
				'daylight' => q#བྱང་ཨ་མི་རི་ཀ་ཤར་ཕྱོགས་ཉིན་སྲུང་ཆུ་ཚོད#,
				'generic' => q#བྱང་ཨ་མི་རི་ཀ་ཤར་ཕྱོགས་ཆུ་ཚོད#,
				'standard' => q#བྱང་ཨ་མི་རི་ཀ་ཤར་ཕྱོགས་ཚད་ལྡན་ཆུ་ཚོད#,
			},
		},
		'America_Mountain' => {
			long => {
				'daylight' => q#བྱང་ཨ་མི་རི་ཀ་མའུ་ཊེན་ཉིན་སྲུང་ཆུ་ཚོད#,
				'generic' => q#བྱང་ཨ་མི་རི་ཀ་མའུ་ཊེན་ཆུ་ཚོད#,
				'standard' => q#བྱང་ཨ་མི་རི་ཀ་མའུ་ཊེན་ཚད་ལྡན་ཆུ་ཚོད#,
			},
		},
		'America_Pacific' => {
			long => {
				'daylight' => q#བྱང་ཨ་མི་རི་ཀ་པེ་སི་ཕིག་ཉིན་སྲུང་ཆུ་ཚོད#,
				'generic' => q#བྱང་ཨ་མི་རི་ཀ་པེ་སི་ཕིག་ཆུ་ཚོད#,
				'standard' => q#བྱང་ཨ་མི་རི་ཀ་པེ་སི་ཕིག་ཚད་ལྡན་ཆུ་ཚོད#,
			},
		},
		'Antarctica/Davis' => {
			exemplarCity => q#ཌེ་ཝིས།#,
		},
		'Antarctica/Mawson' => {
			exemplarCity => q#མའུ་སཱོན#,
		},
		'Antarctica/Palmer' => {
			exemplarCity => q#ཕཱལ་མར#,
		},
		'Antarctica/Rothera' => {
			exemplarCity => q#རཱོ་ཐེ་ར#,
		},
		'Antarctica/Vostok' => {
			exemplarCity => q#ཝོསི་ཊོཀ#,
		},
		'Arabian' => {
			long => {
				'daylight' => q#ཨ་རེ་བྷི་ཡན་སྲུང་ཆུ་ཚོད#,
				'generic' => q#ཨ་རེ་བྷི་ཡན་ཆུ་ཚོད#,
				'standard' => q#ཨ་རེ་བྷི་ཡན་ཚད་ལྡན་ཆུ་ཚོད#,
			},
		},
		'Argentina' => {
			long => {
				'daylight' => q#ཨར་ཇེན་ཊི་ན་བྱཱར་དུས་ཆུ་ཚོད#,
				'generic' => q#ཨར་ཇེན་ཊི་ན་ཆུ་ཚོད#,
				'standard' => q#ཨར་ཇེན་ཊི་ན་ཚད་ལྡན་ཆུ་ཚོད#,
			},
		},
		'Argentina_Western' => {
			long => {
				'daylight' => q#ནུབ་ཕྱོགས་ཨར་ཇེན་ཊི་ན་བྱཱར་དུས་ཆུ་ཚོད#,
				'generic' => q#ནུབ་ཕྱོགས་ཨར་ཇེན་ཊི་ན་ཆུ་ཚོད#,
				'standard' => q#ནུབ་ཕྱོགས་ཨར་ཇེན་ཊི་ན་ཚད་ལྡན་ཆུ་ཚོད#,
			},
		},
		'Armenia' => {
			long => {
				'daylight' => q#ཨར་མི་ནི་ཡ་བྱཱར་དུས་ཆུ་ཚོད#,
				'generic' => q#ཨར་མི་ནི་ཡ་ཆུ་ཚོད#,
				'standard' => q#ཨར་མི་ནི་ཡ་ཚད་ལྡན་ཆུ་ཚོད#,
			},
		},
		'Asia/Bahrain' => {
			exemplarCity => q#བྷ་རེན་#,
		},
		'Asia/Brunei' => {
			exemplarCity => q#བྷྲུ་ནའི#,
		},
		'Asia/Calcutta' => {
			exemplarCity => q#ཀཱོལ་ཀ་ཊ#,
		},
		'Asia/Colombo' => {
			exemplarCity => q#ཀོ་ལོམ་བྷོ#,
		},
		'Asia/Dhaka' => {
			exemplarCity => q#ཌཱ་ཀ#,
		},
		'Asia/Jakarta' => {
			exemplarCity => q#ཇཱ་ཀར་ཊ#,
		},
		'Asia/Jayapura' => {
			exemplarCity => q#ཇ་ཡ་པུ་ར#,
		},
		'Asia/Kabul' => {
			exemplarCity => q#ཀ་བྷུལ#,
		},
		'Asia/Karachi' => {
			exemplarCity => q#ཀ་ར་ཅི#,
		},
		'Asia/Katmandu' => {
			exemplarCity => q#ཀཱཊ་མཱན་ཌུ#,
		},
		'Asia/Kuala_Lumpur' => {
			exemplarCity => q#ཀོ་ལ་ ལམ་པུར#,
		},
		'Asia/Pontianak' => {
			exemplarCity => q#པཱོན་ཊའེ་ནཀ#,
		},
		'Asia/Rangoon' => {
			exemplarCity => q#རང་གྷུན#,
		},
		'Asia/Tehran' => {
			exemplarCity => q#ཊེ་རཱན#,
		},
		'Asia/Thimphu' => {
			exemplarCity => q#ཐིམ་ཕུག#,
		},
		'Asia/Vientiane' => {
			exemplarCity => q#བི་ཡཱན་ཊི་ཡཱན#,
		},
		'Atlantic' => {
			long => {
				'daylight' => q#ཨེཊ་ལེན་ཊིཀ་ཉིན་སྲུང་ཆུ་ཚོད#,
				'generic' => q#ཨེཊ་ལེན་ཊིཀ་ཆུ་ཚོད#,
				'standard' => q#ཨེཊ་ལེན་ཊིཀ་ཚད་ལྡན་ཆུ་ཚོད#,
			},
		},
		'Atlantic/Bermuda' => {
			exemplarCity => q#བར་མུ་ད#,
		},
		'Atlantic/Cape_Verde' => {
			exemplarCity => q#ཀེཔ་བཱཌ#,
		},
		'Atlantic/Faeroe' => {
			exemplarCity => q#ཕཱའེ་རོ་#,
		},
		'Atlantic/Reykjavik' => {
			exemplarCity => q#རེ་ཁི་ཡ་བིཀ#,
		},
		'Atlantic/South_Georgia' => {
			exemplarCity => q#སཱའུཐ་ཇོ་ཇཱ#,
		},
		'Australia_Central' => {
			long => {
				'daylight' => q#དབུས་ཕྱོགས་ཨཱོས་ཊྲེལ་ལི་ཡ་ཉིན་སྲུང་ཆུ་ཚོད#,
				'generic' => q#དབུས་ཕྱོགས་ཨཱོས་ཊྲེལ་ལི་ཡ་ཆུ་ཚོད#,
				'standard' => q#དབུས་ཕྱོགས་ཨཱོས་ཊྲེལ་ལི་ཡ་ཚད་ལྡན་ཆུ་ཚོད#,
			},
		},
		'Australia_CentralWestern' => {
			long => {
				'daylight' => q#དབུས་ནུབ་ཕྱོགས་ཨཱོས་ཊྲེལ་ལི་ཡ་ཉིན་སྲུང་ཆུ་ཚོད#,
				'generic' => q#བུས་ནུབ་ཕྱོགས་ཨཱོས་ཊྲེལ་ལི་ཡ་ཆུ་ཚོད#,
				'standard' => q#དབུས་ནུབ་ཕྱོགས་ཨཱོས་ཊྲེལ་ལི་ཡ་ཚད་ལྡན་ཆུ་ཚོད#,
			},
		},
		'Australia_Eastern' => {
			long => {
				'daylight' => q#ཤར་ཕྱོགས་ཕྱོགས་ཨཱོས་ཊྲེལ་ལི་ཡ་ཉིན་སྲུང་ཆུ་ཚོད#,
				'generic' => q#ཤར་ཕྱོགས་ཕྱོགས་ཨཱོས་ཊྲེལ་ལི་ཡ་ཆུ་ཚོད#,
				'standard' => q#ཤར་ཕྱོགས་ཕྱོགས་ཨཱོས་ཊྲེལ་ལི་ཡ་ཚད་ལྡན་ཆུ་ཚོད#,
			},
		},
		'Australia_Western' => {
			long => {
				'daylight' => q#ནུབ་ཕྱོགས་ཨཱོས་ཊྲེལ་ལི་ཡ་ཉིན་སྲུང་ཆུ་ཚོད#,
				'generic' => q#ནུབ་ཕྱོགས་ཨཱོས་ཊྲེལ་ལི་ཡ་ཆུ་ཚོད#,
				'standard' => q#ནུབ་ཕྱོགས་ཨཱོས་ཊྲེལ་ལི་ཡ་ཚད་ལྡན་ཆུ་ཚོད#,
			},
		},
		'Azerbaijan' => {
			long => {
				'daylight' => q#ཨ་ཛར་བྷའི་ཇཱན་བྱཱར་དུས་ཆུ་ཚོད#,
				'generic' => q#ཨ་ཛར་བྷའི་ཇཱན་ཆུ་ཚོད#,
				'standard' => q#ཨ་ཛར་བྷའི་ཇཱན་ཚད་ལྡན་ཆུ་ཚོད#,
			},
		},
		'Azores' => {
			long => {
				'daylight' => q#ཨེ་ཛོརས་བྱཱར་དུས་ཆུ་ཚོད#,
				'generic' => q#ཨེ་ཛོརས་ཆུ་ཚོད#,
				'standard' => q#ཨེ་ཛོརས་ཚད་ལྡན་ཆུ་ཚོད#,
			},
		},
		'Bangladesh' => {
			long => {
				'daylight' => q#བངྒ་ལ་དེཤ་བྱཱར་དུས་ཆུ་ཚོད#,
				'generic' => q#བངྒ་ལ་དེཤ་ཆུ་ཚོད#,
				'standard' => q#བངྒ་ལ་དེཤ་ཚད་ལྡན་ཆུ་ཚོད#,
			},
		},
		'Bhutan' => {
			long => {
				'standard' => q#འབྲུག་ཡུལ་ཆུ་ཚོད#,
			},
			short => {
				'standard' => q#BT#,
			},
		},
		'Bolivia' => {
			long => {
				'standard' => q#བྷོ་ལི་བི་ཡ་ཆུ་ཚོད#,
			},
		},
		'Brasilia' => {
			long => {
				'daylight' => q#བྲ་ཛི་ལི་ཡ་བྱཱར་དུས་ཆུ་ཚོད#,
				'generic' => q#བྲ་ཛི་ལི་ཡ་ཆུ་ཚོད#,
				'standard' => q#བྲ་ཛི་ལི་ཡ་ཚད་ལྡན་ཆུ་ཚོད#,
			},
		},
		'Cape_Verde' => {
			long => {
				'daylight' => q#ཀེཔ་བཱཌ་བྱཱར་དུས་ཆུ་ཚོད#,
				'generic' => q#ཀེཔ་བཱཌ་ཆུ་ཚོད#,
				'standard' => q#ཀེཔ་བཱཌ་ཚད་ལྡན་ཆུ་ཚོད#,
			},
		},
		'Chile' => {
			long => {
				'daylight' => q#ཅི་ལི་བྱཱར་དུས་ཆུ་ཚོད#,
				'generic' => q#ཅི་ལི་ཆུ་ཚོད#,
				'standard' => q#ཅི་ལི་ཚད་ལྡན་ཆུ་ཚོད#,
			},
		},
		'China' => {
			long => {
				'daylight' => q#རྒྱ་ནག་ཉིན་སྲུང་ཆུ་ཚོད#,
				'generic' => q#རྒྱ་ནག་ཆུ་ཚོད#,
				'standard' => q#རྒྱ་ནག་ཚད་ལྡན་ཆུ་ཚོད#,
			},
		},
		'Christmas' => {
			long => {
				'standard' => q#ཁི་རིསྟ་མེས་མཚོ་གླིང་ཆུ་ཚོད#,
			},
		},
		'Colombia' => {
			long => {
				'daylight' => q#ཀོ་ལོམ་བྷི་ཡ་བྱཱར་དུས་ཆུ་ཚོད#,
				'generic' => q#ཀོ་ལོམ་བྷི་ཡ་ཆུ་ཚོད#,
				'standard' => q#ཀོ་ལོམ་བྷི་ཡ་ཚད་ལྡན་ཆུ་ཚོད#,
			},
		},
		'Cuba' => {
			long => {
				'daylight' => q#ཀིའུ་བྷ་ཉིན་སྲུང་ཆུ་ཚོད#,
				'generic' => q#ཀིའུ་བྷ་ཆུ་ཚོད#,
				'standard' => q#ཀིའུ་བྷ་ཚད་ལྡན་ཆུ་ཚོད#,
			},
		},
		'Easter' => {
			long => {
				'daylight' => q#ཨིསི་ཊར་ཨཱའི་ལེནཌ་བྱཱར་དུས་ཆུ་ཚོད#,
				'generic' => q#ཨིསི་ཊར་ཨཱའི་ལེནཌ་ཆུ་ཚོད#,
				'standard' => q#ཨིསི་ཊར་ཨཱའི་ལེནཌ་ཚད་ལྡན་ཆུ་ཚོད#,
			},
		},
		'Ecuador' => {
			long => {
				'standard' => q#ཨེ་ཀུ་ཌཽ་ཆུ་ཚོད#,
			},
		},
		'Etc/Unknown' => {
			exemplarCity => q#མ་ཤེས་པའི་ཁྲོམ་སྡེ#,
		},
		'Europe/Amsterdam' => {
			exemplarCity => q#ཨམས་ཊར་ཌམ#,
		},
		'Europe/Andorra' => {
			exemplarCity => q#ཨཱན་དོ་ར#,
		},
		'Europe/Athens' => {
			exemplarCity => q#ཨེ་ཐེནས་#,
		},
		'Europe/Berlin' => {
			exemplarCity => q#བྷར་ལིན#,
		},
		'Europe/Brussels' => {
			exemplarCity => q#བྲ་སེལས#,
		},
		'Europe/Bucharest' => {
			exemplarCity => q#བྷུ་ཀ་རེསཊ#,
		},
		'Europe/Budapest' => {
			exemplarCity => q#བྷུ་ཌ་པེསཊ#,
		},
		'Europe/Chisinau' => {
			exemplarCity => q#ཀི་ཤི་ནཱཝ#,
		},
		'Europe/Copenhagen' => {
			exemplarCity => q#ཀོ་པེན་ཧེ་གེན#,
		},
		'Europe/Dublin' => {
			exemplarCity => q#ཌབ་ལིན#,
			long => {
				'daylight' => q#ཨཱ་ཡརིཤ་བྱཱར་དུས་ཆུ་ཚོད#,
			},
		},
		'Europe/Helsinki' => {
			exemplarCity => q#ཧེལ་སིང་ཀི#,
		},
		'Europe/London' => {
			exemplarCity => q#ལཱན་ཌཱན#,
			long => {
				'daylight' => q#བྲཱི་ཊིཤ་བྱཱར་དུས་ཆུ་ཚོད#,
			},
		},
		'Europe/Luxembourg' => {
			exemplarCity => q#ལག་སམ་བྷཀ#,
		},
		'Europe/Madrid' => {
			exemplarCity => q#མ་ཌེ་རེཌ#,
		},
		'Europe/Minsk' => {
			exemplarCity => q#མིནསཀ#,
		},
		'Europe/Monaco' => {
			exemplarCity => q#མོ་ན་ཀོ#,
		},
		'Europe/Moscow' => {
			exemplarCity => q#མཱོས་ཀོ#,
		},
		'Europe/Oslo' => {
			exemplarCity => q#ཨོས་ལོ#,
		},
		'Europe/Paris' => {
			exemplarCity => q#པེ་རིས#,
		},
		'Europe/Prague' => {
			exemplarCity => q#པྲག#,
		},
		'Europe/Riga' => {
			exemplarCity => q#རི་གྷ#,
		},
		'Europe/Sarajevo' => {
			exemplarCity => q#ས་ར་ཡེ་བོ#,
		},
		'Europe/Sofia' => {
			exemplarCity => q#སོ་ཕི་ཡ#,
		},
		'Europe/Stockholm' => {
			exemplarCity => q#ཨིས་ཊོཀ་ཧོལམ#,
		},
		'Europe/Tallinn' => {
			exemplarCity => q#ཊཱ་ལཱིན#,
		},
		'Europe/Tirane' => {
			exemplarCity => q#ཊ་ར་ནི#,
		},
		'Europe/Vaduz' => {
			exemplarCity => q#བ་དུདས#,
		},
		'Europe/Vienna' => {
			exemplarCity => q#ཝི་ཡེ་ན#,
		},
		'Europe/Vilnius' => {
			exemplarCity => q#བིལ་ནི་ཡཱས#,
		},
		'Europe/Warsaw' => {
			exemplarCity => q#ཝར་སོ#,
		},
		'Europe/Zurich' => {
			exemplarCity => q#ཛུ་རིཆ#,
		},
		'Europe_Central' => {
			long => {
				'daylight' => q#དབུས་ཕྱོགས་ཡུ་རོ་པེན་བྱཱར་དུས་ཆུ་ཚོད#,
				'generic' => q#དབུས་ཕྱོགས་ཡུ་རོ་པེན་ཆུ་ཚོད#,
				'standard' => q#དབུས་ཕྱོགས་ཡུ་རོ་པེན་ཚད་ལྡན་ཆུ་ཚོད#,
			},
		},
		'Europe_Eastern' => {
			long => {
				'daylight' => q#ཤར་ཕྱོགས་ཡུ་རོ་པེན་བྱཱར་དུས་ཆུ་ཚོད#,
				'generic' => q#ཤར་ཕྱོགས་ཡུ་རོ་པེན་ཆུ་ཚོད#,
				'standard' => q#ཤར་ཕྱོགས་ཡུ་རོ་པེན་ཚད་ལྡན་ཆུ་ཚོད#,
			},
		},
		'Europe_Western' => {
			long => {
				'daylight' => q#ནུབ་ཕྱོགས་ཡུ་རོ་པེན་བྱཱར་དུས་ཆུ་ཚོད#,
				'generic' => q#ནུབ་ཕྱོགས་ཡུ་རོ་པེན་ཆུ་ཚོད#,
				'standard' => q#ནུབ་ཕྱོགས་ཡུ་རོ་པེན་ཚད་ལྡན་ཆུ་ཚོད#,
			},
		},
		'Falkland' => {
			long => {
				'daylight' => q#ཕལཀ་ལེནཌ་ཨཱའི་ལེནཌས་བྱཱར་དུས་ཆུ་ཚོད#,
				'generic' => q#ཕལཀ་ལེནཌ་ཨཱའི་ལེནཌས་ཆུ་ཚོད#,
				'standard' => q#ཕལཀ་ལེནཌ་ཨཱའི་ལེནཌས་ཚད་ལྡན་ཆུ་ཚོད#,
			},
		},
		'French_Guiana' => {
			long => {
				'standard' => q#ཕིརེནཅ་གི་ཡ་ན་ཆུ་ཚོད#,
			},
		},
		'GMT' => {
			long => {
				'standard' => q#གིརིན་ཝིཆ་ལུ་ཡོད་པའི་ཆུ་ཚོད#,
			},
		},
		'Galapagos' => {
			long => {
				'standard' => q#ག་ལ་པ་གོསི་ཆུ་ཚོད#,
			},
		},
		'Georgia' => {
			long => {
				'daylight' => q#ཇཽ་ཇཱ་བྱཱར་དུས་ཆུ་ཚོད#,
				'generic' => q#ཇཽ་ཇཱ་ཆུ་ཚོད#,
				'standard' => q#ཇཽ་ཇཱ་ཚད་ལྡན་ཆུ་ཚོད#,
			},
		},
		'Greenland_Eastern' => {
			long => {
				'daylight' => q#ཤར་ཕྱོགས་གིརིན་ལེནཌ་བྱཱར་དུས་ཆུ་ཚོད#,
				'generic' => q#ཤར་ཕྱོགས་གིརིན་ལེནཌ་ཆུ་ཚོད#,
				'standard' => q#ཤར་ཕྱོགས་གིརིན་ལེནཌ་ཚད་ལྡན་ཆུ་ཚོད#,
			},
		},
		'Greenland_Western' => {
			long => {
				'daylight' => q#ནུབ་ཕྱོགས་གིརིན་ལེནཌ་བྱཱར་དུས་ཆུ་ཚོད#,
				'generic' => q#ནུབ་ཕྱོགས་གིརིན་ལེནཌ་ཆུ་ཚོད#,
				'standard' => q#ནུབ་ཕྱོགས་གིརིན་ལེནཌ་ཚད་ལྡན་ཆུ་ཚོད#,
			},
		},
		'Gulf' => {
			long => {
				'standard' => q#གཱལཕི་ཆུ་ཚོད#,
			},
		},
		'Guyana' => {
			long => {
				'standard' => q#གུ་ཡ་ན་ཆུ་ཚོད#,
			},
		},
		'Hawaii_Aleutian' => {
			long => {
				'daylight' => q#ཧ་ཝའི་-ཨེ་ལིའུ་ཤེན་ཉིན་སྲུང་ཆུ་ཚོད#,
				'generic' => q#ཧ་ཝའི་-ཨེ་ལིའུ་ཤེན་ཆུ་ཚོད#,
				'standard' => q#ཧ་ཝའི་-ཨེ་ལིའུ་ཤེན་ཚད་ལྡན་ཆུ་ཚོད#,
			},
		},
		'India' => {
			long => {
				'standard' => q#རྒྱ་གར་ཆུ་ཚོད#,
			},
		},
		'Indian/Antananarivo' => {
			exemplarCity => q#ཨཱན་ཏ་ན་ན་དི་བོ#,
		},
		'Indian/Christmas' => {
			exemplarCity => q#ཀིརིསཊ་མསི#,
		},
		'Indian/Cocos' => {
			exemplarCity => q#ཀོ་ཀོསི#,
		},
		'Indian/Comoro' => {
			exemplarCity => q#ཀོ་མོ་རོ#,
		},
		'Indian/Kerguelen' => {
			exemplarCity => q#ཀིར་གུ་ལིན#,
		},
		'Indian/Maldives' => {
			exemplarCity => q#མཱལ་དིབས#,
		},
		'Indian/Mauritius' => {
			exemplarCity => q#མོ་རི་ཤཱས#,
		},
		'Indian_Ocean' => {
			long => {
				'standard' => q#རྒྱ་གར་གྱི་རྒྱ་མཚོ་ཆུ་ཚོད#,
			},
		},
		'Indochina' => {
			long => {
				'standard' => q#ཨིན་ཌོ་ཅཱའི་ན་ཆུ་ཚོད#,
			},
		},
		'Indonesia_Central' => {
			long => {
				'standard' => q#དབུས་ཕྱོགས་ཨིན་ཌོ་ནེ་ཤི་ཡ་ཆུ་ཚོད#,
			},
		},
		'Indonesia_Eastern' => {
			long => {
				'standard' => q#ཤར་ཕྱོགས་ཨིན་ཌོ་ནེ་ཤི་ཡ་ཆུ་ཚོད#,
			},
		},
		'Indonesia_Western' => {
			long => {
				'standard' => q#ནུབ་ཕྱོགས་ཨིན་ཌོ་ནེ་ཤི་ཡ་ཆུ་ཚོད#,
			},
		},
		'Iran' => {
			long => {
				'daylight' => q#ཨི་རཱན་ཉིན་སྲུང་ཆུ་ཚོད#,
				'generic' => q#ཨི་རཱན་ཆུ་ཚོད#,
				'standard' => q#ཨི་རཱན་ཚད་ལྡན་ཆུ་ཚོད#,
			},
		},
		'Irkutsk' => {
			long => {
				'daylight' => q#ཨར་ཀུཙི་བྱཱར་དུས་ཆུ་ཚོད#,
				'generic' => q#ཨར་ཀུཙི་ཆུ་ཚོད#,
				'standard' => q#ཨར་ཀུཙི་ཚད་ལྡན་ཆུ་ཚོད#,
			},
		},
		'Israel' => {
			long => {
				'daylight' => q#ཨིས་རེལ་ཉིན་སྲུང་ཆུ་ཚོད#,
				'generic' => q#ཨིས་རེལ་ཆུ་ཚོད#,
				'standard' => q#ཨིས་རེལ་ཚད་ལྡན་ཆུ་ཚོད#,
			},
		},
		'Japan' => {
			long => {
				'daylight' => q#ཇ་པཱན་ཉིན་སྲུང་ཆུ་ཚོད#,
				'generic' => q#ཇ་པཱན་ཆུ་ཚོད#,
				'standard' => q#ཇ་པཱན་ཚད་ལྡན་ཆུ་ཚོད#,
			},
		},
		'Korea' => {
			long => {
				'daylight' => q#ཀོ་རི་ཡ་ཉིན་སྲུང་ཆུ་ཚོད#,
				'generic' => q#ཀོ་རི་ཡ་ཆུ་ཚོད#,
				'standard' => q#ཀོ་རི་ཡ་ཚད་ལྡན་ཆུ་ཚོད#,
			},
		},
		'Krasnoyarsk' => {
			long => {
				'daylight' => q#ཀརསི་ནོ་ཡརསཀི་བྱཱར་དུས་ཆུ་ཚོད#,
				'generic' => q#ཀརསི་ནོ་ཡརསཀི་ཆུ་ཚོད#,
				'standard' => q#ཀརསི་ནོ་ཡརསཀི་ཚད་ལྡན་ཆུ་ཚོད#,
			},
		},
		'Magadan' => {
			long => {
				'daylight' => q#མ་གྷ་དཱན་བྱཱར་དུས་ཆུ་ཚོད#,
				'generic' => q#མ་གྷ་དཱན་ཆུ་ཚོད#,
				'standard' => q#མ་གྷ་དཱན་ཚད་ལྡན་ཆུ་ཚོད#,
			},
		},
		'Maldives' => {
			long => {
				'standard' => q#མཱལ་དིབས་ཆུ་ཚོད#,
			},
		},
		'Mauritius' => {
			long => {
				'daylight' => q#མོ་རི་ཤཱས་བྱཱར་དུས་ཆུ་ཚོད#,
				'generic' => q#མོ་རི་ཤཱས་ཆུ་ཚོད#,
				'standard' => q#མོ་རི་ཤཱས་ཚད་ལྡན་ཆུ་ཚོད#,
			},
		},
		'Moscow' => {
			long => {
				'daylight' => q#མཽས་ཀོ་བྱཱར་དུས་ཆུ་ཚོད#,
				'generic' => q#མཽས་ཀོ་ཆུ་ཚོད#,
				'standard' => q#མཽས་ཀོ་ཚད་ལྡན་ཆུ་ཚོད#,
			},
		},
		'Nepal' => {
			long => {
				'standard' => q#ནེ་པཱལ་ཆུ་ཚོད#,
			},
		},
		'New_Zealand' => {
			long => {
				'daylight' => q#ནིའུ་ཛི་ལེནཌ་ཉིན་སྲུང་ཆུ་ཚོད#,
				'generic' => q#ནིའུ་ཛི་ལེནཌ་ཆུ་ཚོད#,
				'standard' => q#ནིའུ་ཛི་ལེནཌ་ཚད་ལྡན་ཆུ་ཚོད#,
			},
		},
		'Newfoundland' => {
			long => {
				'daylight' => q#ནིའུ་ཕའུནཌ་ལེནཌ་ཉིན་སྲུང་ཆུ་ཚོད#,
				'generic' => q#ནིའུ་ཕའུནཌ་ལེནཌ་ཆུ་ཚོད#,
				'standard' => q#ནིའུ་ཕའུནཌ་ལེནཌ་ཚད་ལྡན་ཆུ་ཚོད#,
			},
		},
		'Noronha' => {
			long => {
				'daylight' => q#ཕར་ནེན་ཌོ་ ཌི་ ནོ་རཱོན་ཧ་བྱཱར་དུས་ཆུ་ཚོད#,
				'generic' => q#ཕར་ནེན་ཌོ་ ཌི་ ནོ་རཱོན་ཧ་ཆུ་ཚོད#,
				'standard' => q#ཕར་ནེན་ཌོ་ ཌི་ ནོ་རཱོན་ཧ་ཚད་ལྡན་ཆུ་ཚོད#,
			},
		},
		'Novosibirsk' => {
			long => {
				'daylight' => q#ནོ་བོ་སི་བིརསཀི་བྱཱར་དུས་ཆུ་ཚོད#,
				'generic' => q#ནོ་བོ་སི་བིརསཀི་ཆུ་ཚོད#,
				'standard' => q#ནོ་བོ་སི་བིརསཀི་ཚད་ལྡན་ཆུ་ཚོད#,
			},
		},
		'Omsk' => {
			long => {
				'daylight' => q#ཨོམསཀི་བྱཱར་དུས་ཆུ་ཚོད#,
				'generic' => q#ཨོམསཀི་ཆུ་ཚོད#,
				'standard' => q#ཨོམསཀི་ཚད་ལྡན་ཆུ་ཚོད#,
			},
		},
		'Pacific/Apia' => {
			exemplarCity => q#ཨ་པི་ཡ#,
		},
		'Pacific/Fakaofo' => {
			exemplarCity => q#ཕ་ཀའོ་ཕོ#,
		},
		'Pacific/Funafuti' => {
			exemplarCity => q#ཕུ་ན་ཕུ་ཊི#,
		},
		'Pacific/Gambier' => {
			exemplarCity => q#གེམ་བིཡར#,
		},
		'Pacific/Johnston' => {
			exemplarCity => q#ཇཱོནསི་ཊོན#,
		},
		'Pacific/Majuro' => {
			exemplarCity => q#མེ་ཇུ་རོ#,
		},
		'Pacific/Midway' => {
			exemplarCity => q#མིཌ་ཝེ#,
		},
		'Pacific/Nauru' => {
			exemplarCity => q#ནཱཝ་རུ#,
		},
		'Pacific/Pago_Pago' => {
			exemplarCity => q#པ་གོ་ པ་གོ#,
		},
		'Pacific/Palau' => {
			exemplarCity => q#པ་ལཱཝ#,
		},
		'Pacific/Rarotonga' => {
			exemplarCity => q#རཱ་རོ་་ཏོང་ག#,
		},
		'Pacific/Saipan' => {
			exemplarCity => q#སཱའེ་ཕཱན#,
		},
		'Pacific/Tongatapu' => {
			exemplarCity => q#ཏོང་ག་ཏ་པུ#,
		},
		'Pacific/Wake' => {
			exemplarCity => q#ཝེཀ#,
		},
		'Pakistan' => {
			long => {
				'daylight' => q#པ་ཀི་ས྄ཏཱན་བྱཱར་དུས་ཆུ་ཚོད#,
				'generic' => q#པ་ཀི་ས྄ཏཱན་ཆུ་ཚོད#,
				'standard' => q#པ་ཀི་ས྄ཏཱན་ཚད་ལྡན་ཆུ་ཚོད#,
			},
		},
		'Paraguay' => {
			long => {
				'daylight' => q#པ་ར་གུ་ཝའི་བྱཱར་དུས་ཆུ་ཚོད#,
				'generic' => q#པ་ར་གུ་ཝའི་ཆུ་ཚོད#,
				'standard' => q#པ་ར་གུ་ཝའི་ཚད་ལྡན་ཆུ་ཚོད#,
			},
		},
		'Peru' => {
			long => {
				'daylight' => q#པ་རུ་བྱཱར་དུས་ཆུ་ཚོད#,
				'generic' => q#པ་རུ་ཆུ་ཚོད#,
				'standard' => q#པ་རུ་ཚད་ལྡན་ཆུ་ཚོད#,
			},
		},
		'Pierre_Miquelon' => {
			long => {
				'daylight' => q#པའི་རི་དང་མི་ཀི་ལཱོན་ཉིན་སྲུང་ཆུ་ཚོད#,
				'generic' => q#པའི་རི་དང་མི་ཀི་ལཱོན་ཆུ་ཚོད#,
				'standard' => q#པའི་རི་དང་མི་ཀི་ལཱོན་ཚད་ལྡན་ཆུ་ཚོད#,
			},
		},
		'Reunion' => {
			long => {
				'standard' => q#རི་ཡུ་ནི་ཡཱན་ཆུ་ཚོད#,
			},
		},
		'Sakhalin' => {
			long => {
				'daylight' => q#ས་ཁ་ལིན་བྱཱར་དུས་ཆུ་ཚོད#,
				'generic' => q#ས་ཁ་ལིན་ཆུ་ཚོད#,
				'standard' => q#ས་ཁ་ལིན་ཚད་ལྡན་ཆུ་ཚོད#,
			},
		},
		'Seychelles' => {
			long => {
				'standard' => q#སེ་ཤཱལས་ཆུ་ཚོད#,
			},
		},
		'Suriname' => {
			long => {
				'standard' => q#སུ་རི་ནཱམ་ཆུ་ཚོད#,
			},
		},
		'Uruguay' => {
			long => {
				'daylight' => q#ཡུ་རུ་གུ་ཝཱའི་བྱཱར་དུས་ཆུ་ཚོད#,
				'generic' => q#ཡུ་རུ་གུ་ཝཱའི་ཆུ་ཚོད#,
				'standard' => q#ཡུ་རུ་གུ་ཝཱའི་ཚད་ལྡན་ཆུ་ཚོད#,
			},
		},
		'Venezuela' => {
			long => {
				'standard' => q#བེ་ནི་ཛུ་ཝེ་ལ་ཆུ་ཚོད#,
			},
		},
		'Vladivostok' => {
			long => {
				'daylight' => q#བ་ལ་ཌི་བོསི་ཏོཀ་བྱཱར་དུས་ཆུ་ཚོད#,
				'generic' => q#བ་ལ་ཌི་བོསི་ཏོཀ་ཆུ་ཚོད#,
				'standard' => q#བ་ལ་ཌི་བོསི་ཏོཀ་ཚད་ལྡན་ཆུ་ཚོད#,
			},
		},
		'Volgograd' => {
			long => {
				'daylight' => q#བཱོལ་གོ་གིརེཌ་བྱཱར་དུས་ཆུ་ཚོད#,
				'generic' => q#བཱོལ་གོ་གིརེཌ་ཆུ་ཚོད#,
				'standard' => q#བཱོལ་གོ་གིརེཌ་ཚད་ལྡན་ཆུ་ཚོད#,
			},
		},
		'Yakutsk' => {
			long => {
				'daylight' => q#ཡ་ཀུཙིཀི་བྱཱར་དུས་ཆུ་ཚོད#,
				'generic' => q#ཡ་ཀུཙིཀི་ཆུ་ཚོད#,
				'standard' => q#ཡ་ཀུཙིཀི་ཚད་ལྡན་ཆུ་ཚོད#,
			},
		},
		'Yekaterinburg' => {
			long => {
				'daylight' => q#ཡེ་ཀ་ཏེ་རིན་བརག་བྱཱར་དུས་ཆུ་ཚོད#,
				'generic' => q#ཡེ་ཀ་ཏེ་རིན་བརག་ཆུ་ཚོད#,
				'standard' => q#ཡེ་ཀ་ཏེ་རིན་བརག་ཚད་ལྡན་ཆུ་ཚོད#,
			},
		},
	 } }
);
no Moo;

1;

# vim: tabstop=4
