#!/usr/bin/perl
# Do not normalise this test file. It has deliberately unnormalised characters in it.
use v5.10;
use strict;
use warnings;
use utf8;
use if $^V ge v5.12.0, feature => 'unicode_strings';

use Test::More tests => 290;
use Test::Exception;

use ok 'Locale::CLDR';

my $locale = Locale::CLDR->new('da_DK');

is($locale->unit(1, 'acre', 'narrow'), '1ac', 'Danish narrow 1 acre');
is($locale->unit(2, 'acre', 'narrow'), '2ac', 'Danish narrow 2 acres');
is($locale->unit(1, 'acre', 'short'), '1 ac', 'Danish short 1 acre');
is($locale->unit(2, 'acre', 'short'), '2 ac', 'Danish short 2 acres');
is($locale->unit(1, 'acre'), '1 acre', 'Danish long 1 acre');
is($locale->unit(2, 'acre'), '2 acres', 'Danish long 2 acres');
is($locale->unit(1, 'arc-minute', 'narrow'), '1′', 'Danish narrow 1 minute');
is($locale->unit(2, 'arc-minute', 'narrow'), '2′', 'Danish narrow 2 minutes');
is($locale->unit(1, 'arc-minute', 'short'), '1′', 'Danish short 1 arc minute');
is($locale->unit(2, 'arc-minute', 'short'), '2′', 'Danish short 2 arc minutes');
is($locale->unit(1, 'arc-minute'), '1 bueminut', 'Danish long 1 arc minute');
is($locale->unit(2, 'arc-minute'), '2 bueminutter', 'Danish long 2 arc minutes');
is($locale->unit(1, 'arc-second', 'narrow'), '1″', 'Danish narrow 1 second');
is($locale->unit(2, 'arc-second', 'narrow'), '2″', 'Danish narrow 2 seconds');
is($locale->unit(1, 'arc-second', 'short'), '1″', 'Danish short 1 arc second');
is($locale->unit(2, 'arc-second', 'short'), '2″', 'Danish short 2 arc seconds');
is($locale->unit(1, 'arc-second'), '1 buesekund', 'Danish long 1 arc second');
is($locale->unit(2, 'arc-second'), '2 buesekunder', 'Danish long 2 arc seconds');
is($locale->unit(1, 'celsius', 'narrow'), '1°C', 'Danish narrow 1 degree Celsius');
is($locale->unit(2, 'celsius', 'narrow'), '2°C', 'Danish narrow 2 degrees Celsius');
is($locale->unit(1, 'celsius', 'short'), '1°C', 'Danish short 1 degree Celsius');
is($locale->unit(2, 'celsius', 'short'), '2°C', 'Danish short 2 degrees Celsius');
is($locale->unit(1, 'celsius'), '1 grad celsius', 'Danish long 1 degree Celsius');
is($locale->unit(2, 'celsius'), '2 grader celsius', 'Danish long 2 degrees Celsius');
is($locale->unit(1, 'centimeter', 'narrow'), '1 cm', 'Danish narrow 1 centimetre');
is($locale->unit(2, 'centimeter', 'narrow'), '2 cm', 'Danish narrow 2 centimetres');
is($locale->unit(1, 'centimeter', 'short'), '1 cm', 'Danish short 1 centimetre');
is($locale->unit(2, 'centimeter', 'short'), '2 cm', 'Danish short 2 centimetres');
is($locale->unit(1, 'centimeter'), '1 centimeter', 'Danish long 1 centimetre');
is($locale->unit(2, 'centimeter'), '2 centimeter', 'Danish long 2 centimetres');
is($locale->unit(1, 'cubic-kilometer', 'narrow'), '1km³', 'Danish narrow 1 cubic kilometre');
is($locale->unit(2, 'cubic-kilometer', 'narrow'), '2km³', 'Danish narrow 2 cubic kilometres');
is($locale->unit(1, 'cubic-kilometer', 'short'), '1 km³', 'Danish short 1 cubic kilometre');
is($locale->unit(2, 'cubic-kilometer', 'short'), '2 km³', 'Danish short 2 cubic kilometres');
is($locale->unit(1, 'cubic-kilometer'), '1 kubikkilometer', 'Danish long 1 cubic kilometre');
is($locale->unit(2, 'cubic-kilometer'), '2 kubikkilometer', 'Danish long 2 cubic kilometres');
is($locale->unit(1, 'cubic-mile', 'narrow'), '1 mi³', 'Danish narrow 1 cubic mile');
is($locale->unit(2, 'cubic-mile', 'narrow'), '2 mi³', 'Danish narrow 2 cubic miles');
is($locale->unit(1, 'cubic-mile', 'short'), '1 mi³', 'Danish short 1 cubic mile');
is($locale->unit(2, 'cubic-mile', 'short'), '2 mi³', 'Danish short 2 cubic miles');
is($locale->unit(1, 'cubic-mile'), '1 kubik-engelsk mil', 'Danish long 1 cubic mile');
is($locale->unit(2, 'cubic-mile'), '2 kubik-engelske mil', 'Danish long 2 cubic miles');
is($locale->unit(1, 'day', 'narrow'), '1 d', 'Danish narrow 1 day');
is($locale->unit(2, 'day', 'narrow'), '2 d', 'Danish narrow 2 days');
is($locale->unit(1, 'day', 'short'), '1 dag', 'Danish short 1 day');
is($locale->unit(2, 'day', 'short'), '2 dage', 'Danish short 2 days');
is($locale->unit(1, 'day'), '1 dag', 'Danish long 1 day');
is($locale->unit(2, 'day'), '2 dage', 'Danish long 2 days');
is($locale->unit(1, 'degree', 'narrow'), '1°', 'Danish narrow 1 degree');
is($locale->unit(2, 'degree', 'narrow'), '2°', 'Danish narrow 2 degrees');
is($locale->unit(1, 'degree', 'short'), '1°', 'Danish short 1 degree');
is($locale->unit(2, 'degree', 'short'), '2°', 'Danish short 2 degree');
is($locale->unit(1, 'degree'), '1 grad', 'Danish long 1 degree');
is($locale->unit(2, 'degree'), '2 grader', 'Danish long 2 degrees');
is($locale->unit(1, 'fahrenheit', 'narrow'), '1°F', 'Danish narrow 1 degree Fahrenheit');
is($locale->unit(2, 'fahrenheit', 'narrow'), '2°F', 'Danish narrow 2 degrees Fahrenheit');
is($locale->unit(1, 'fahrenheit', 'short'), '1°F', 'Danish short 1 degree Fahrenheit');
is($locale->unit(2, 'fahrenheit', 'short'), '2°F', 'Danish short 2 degrees Fahrenheit');
is($locale->unit(1, 'fahrenheit'), '1 grad fahrenheit', 'Danish long 1 degree Fahrenheit');
is($locale->unit(2, 'fahrenheit'), '2 grader fahrenheit', 'Danish long 2 degrees Fahrenheit');
is($locale->unit(1, 'foot', 'narrow'), '1 fod', 'Danish narrow 1 foot');
is($locale->unit(2, 'foot', 'narrow'), '2 fod', 'Danish narrow 2 feet');
is($locale->unit(1, 'foot', 'short'), '1 fod', 'Danish short 1 foot');
is($locale->unit(2, 'foot', 'short'), '2 fod', 'Danish short 2 feet');
is($locale->unit(1, 'foot'), '1 fod', 'Danish long 1 foot');
is($locale->unit(2, 'foot'), '2 fod', 'Danish long 2 feet');
is($locale->unit(1, 'g-force', 'narrow'), '1G', 'Danish narrow 1 g-force');
is($locale->unit(2, 'g-force', 'narrow'), '2G', 'Danish narrow 2 g-force');
is($locale->unit(1, 'g-force', 'short'), '1 G', 'Danish short 1 g-force');
is($locale->unit(2, 'g-force', 'short'), '2 G', 'Danish short 2 g-force');
is($locale->unit(1, 'g-force'), '1 G-kraft', 'Danish long 1 g-force');
is($locale->unit(2, 'g-force'), '2 G-kraft', 'Danish long 2 g-force');
is($locale->unit(1, 'gram', 'narrow'), '1 g', 'Danish narrow 1 gram');
is($locale->unit(2, 'gram', 'narrow'), '2 g', 'Danish narrow 2 grams');
is($locale->unit(1, 'gram', 'short'), '1 g', 'Danish short 1 gram');
is($locale->unit(2, 'gram', 'short'), '2 g', 'Danish short 2 grams');
is($locale->unit(1, 'gram'), '1 gram', 'Danish long 1 gram');
is($locale->unit(2, 'gram'), '2 gram', 'Danish long 2 grams');
is($locale->unit(1, 'hectare', 'narrow'), '1ha', 'Danish narrow 1 hectare');
is($locale->unit(2, 'hectare', 'narrow'), '2ha', 'Danish narrow 2 hectares');
is($locale->unit(1, 'hectare', 'short'), '1 ha', 'Danish short 1 hectare');
is($locale->unit(2, 'hectare', 'short'), '2 ha', 'Danish short 2 hectares');
is($locale->unit(1, 'hectare'), '1 hektar', 'Danish long 1 hectare');
is($locale->unit(2, 'hectare'), '2 hektar', 'Danish long 2 hectares');
is($locale->unit(1, 'hectopascal', 'narrow'), '1hPa', 'Danish narrow 1 hectopascal');
is($locale->unit(2, 'hectopascal', 'narrow'), '2hPa', 'Danish narrow 2 hectopascals');
is($locale->unit(1, 'hectopascal', 'short'), '1 hPa', 'Danish short 1 hectopascal');
is($locale->unit(2, 'hectopascal', 'short'), '2 hPa', 'Danish short 2 hectopascals');
is($locale->unit(1, 'hectopascal'), '1 hektopascal', 'Danish long 1 hectopascal');
is($locale->unit(2, 'hectopascal'), '2 hektopascal', 'Danish long 2 hectopascals');
is($locale->unit(1, 'horsepower', 'narrow'), '1hk', 'Danish narrow 1 horsepower');
is($locale->unit(2, 'horsepower', 'narrow'), '2hk', 'Danish narrow 2 horsepower');
is($locale->unit(1, 'horsepower', 'short'), '1 hk', 'Danish short 1 horsepower');
is($locale->unit(2, 'horsepower', 'short'), '2 hk', 'Danish short 2 horsepower');
is($locale->unit(1, 'horsepower'), '1 hestekraft', 'Danish long 1 horsepower');
is($locale->unit(2, 'horsepower'), '2 hestekræfter', 'Danish long 2 horsepower');
is($locale->unit(1, 'hour', 'narrow'), '1 t', 'Danish narrow 1 hour');
is($locale->unit(2, 'hour', 'narrow'), '2 t', 'Danish narrow 2 hours');
is($locale->unit(1, 'hour', 'short'), '1 t', 'Danish short 1 hour');
is($locale->unit(2, 'hour', 'short'), '2 t', 'Danish short 2 hours');
is($locale->unit(1, 'hour'), '1 time', 'Danish long 1 hour');
is($locale->unit(2, 'hour'), '2 timer', 'Danish long 2 hours');
is($locale->unit(1, 'inch', 'narrow'), '1"', 'Danish narrow 1 inch');
is($locale->unit(2, 'inch', 'narrow'), '2"', 'Danish narrow 2 inches');
is($locale->unit(1, 'inch', 'short'), '1 tomme', 'Danish short 1 inch');
is($locale->unit(2, 'inch', 'short'), '2 tommer', 'Danish short 2 inches');
is($locale->unit(1, 'inch'), '1 tomme', 'Danish long 1 inch');
is($locale->unit(2, 'inch'), '2 tommer', 'Danish long 2 inches');
is($locale->unit(1, 'inch-hg', 'narrow'), '1" Hg', 'Danish narrow 1 inch of mercury');
is($locale->unit(2, 'inch-hg', 'narrow'), '2" Hg', 'Danish narrow 2 inches of mercury');
is($locale->unit(1, 'inch-hg', 'short'), '1 # Hg', 'Danish short 1 inch of mercury');
is($locale->unit(2, 'inch-hg', 'short'), '2 # Hg', 'Danish short 2 inches of mercury');
is($locale->unit(1, 'inch-hg'), '1 tomme kviksølv', 'Danish long 1 inch of mercury');
is($locale->unit(2, 'inch-hg'), '2 tommer kviksølv', 'Danish long 2 inches of mercury');
is($locale->unit(1, 'kilogram', 'narrow'), '1 kg', 'Danish narrow 1 kilogram');
is($locale->unit(2, 'kilogram', 'narrow'), '2 kg', 'Danish narrow 2 kilograms');
is($locale->unit(1, 'kilogram', 'short'), '1 kg', 'Danish short 1 kilogram');
is($locale->unit(2, 'kilogram', 'short'), '2 kg', 'Danish short 2 kilograms');
is($locale->unit(1, 'kilogram'), '1 kilogram', 'Danish long 1 kilogram');
is($locale->unit(2, 'kilogram'), '2 kilogram', 'Danish long 2 kilograms');
is($locale->unit(1, 'kilometer', 'narrow'), '1 km', 'Danish narrow 1 kilometre');
is($locale->unit(2, 'kilometer', 'narrow'), '2 km', 'Danish narrow 2 kilometres');
is($locale->unit(1, 'kilometer', 'short'), '1 km', 'Danish short 1 kilometre');
is($locale->unit(2, 'kilometer', 'short'), '2 km', 'Danish short 2 kilometres');
is($locale->unit(1, 'kilometer'), '1 kilometer', 'Danish long 1 kilometre');
is($locale->unit(2, 'kilometer'), '2 kilometer', 'Danish long 2 kilometres');
is($locale->unit(1, 'kilometer-per-hour', 'narrow'), '1 km/t', 'Danish narrow 1 kilometre per hour');
is($locale->unit(2, 'kilometer-per-hour', 'narrow'), '2 km/t', 'Danish narrow 2 kilometres per hour');
is($locale->unit(1, 'kilometer-per-hour', 'short'), '1 km/t.', 'Danish short 1 kilometre per hour');
is($locale->unit(2, 'kilometer-per-hour', 'short'), '2 km/t.', 'Danish short 2 kilometres per hour');
is($locale->unit(1, 'kilometer-per-hour'), 'kilometer i timen', 'Danish long 1 kilometre per hour');
is($locale->unit(2, 'kilometer-per-hour'), '2 kilometer i timen', 'Danish long 2 kilometres per hour');
is($locale->unit(1, 'kilowatt', 'narrow'), '1kW', 'Danish narrow 1 kilowatt');
is($locale->unit(2, 'kilowatt', 'narrow'), '2kW', 'Danish narrow 2 kilowatts');
is($locale->unit(1, 'kilowatt', 'short'), '1 kW', 'Danish short 1 kilowatt');
is($locale->unit(2, 'kilowatt', 'short'), '2 kW', 'Danish short 2 kilowatts');
is($locale->unit(1, 'kilowatt'), '1 kilowatt', 'Danish long 1 kilowatt');
is($locale->unit(2, 'kilowatt'), '2 kilowatt', 'Danish long 2 kilowatts');
is($locale->unit(1, 'light-year', 'narrow'), '1 lysår', 'Danish narrow 1 light year');
is($locale->unit(2, 'light-year', 'narrow'), '2 lysår', 'Danish narrow 2 light years');
is($locale->unit(1, 'light-year', 'short'), '1 ly', 'Danish short 1 light year');
is($locale->unit(2, 'light-year', 'short'), '2 ly', 'Danish short 2 light years');
is($locale->unit(1, 'light-year'), '1 lysår', 'Danish long 1 light year');
is($locale->unit(2, 'light-year'), '2 lysår', 'Danish long 2 light years');
is($locale->unit(1, 'liter', 'narrow'), '1 l', 'Danish narrow 1 litre');
is($locale->unit(2, 'liter', 'narrow'), '2 l', 'Danish narrow 2 litres');
is($locale->unit(1, 'liter', 'short'), '1 l', 'Danish short 1 litre');
is($locale->unit(2, 'liter', 'short'), '2 l', 'Danish short 2 litres');
is($locale->unit(1, 'liter'), '1 liter', 'Danish long 1 litre');
is($locale->unit(2, 'liter'), '2 liter', 'Danish long 2 litres');
is($locale->unit(1, 'meter', 'narrow'), '1 m', 'Danish narrow 1 meter');
is($locale->unit(2, 'meter', 'narrow'), '2 m', 'Danish narrow 2 meters');
is($locale->unit(1, 'meter', 'short'), '1 m', 'Danish short 1 meter');
is($locale->unit(2, 'meter', 'short'), '2 m', 'Danish short 2 meters');
is($locale->unit(1, 'meter'), '1 meter', 'Danish long 1 meter');
is($locale->unit(2, 'meter'), '2 meter', 'Danish long 2 meters');
is($locale->unit(1, 'meter-per-second', 'narrow'), '1m/s', 'Danish narrow 1 meter per second');
is($locale->unit(2, 'meter-per-second', 'narrow'), '2m/s', 'Danish narrow 2 meters per second');
is($locale->unit(1, 'meter-per-second', 'short'), '1 m/s', 'Danish short 1 meter per second');
is($locale->unit(2, 'meter-per-second', 'short'), '2 m/s', 'Danish short 2 meters per second');
is($locale->unit(1, 'meter-per-second'), '1 meter i sekundet', 'Danish long 1 meter per second');
is($locale->unit(2, 'meter-per-second'), '2 meter i sekundet', 'Danish long 2 meters per second');
is($locale->unit(1, 'mile', 'narrow'), '1 mil', 'Danish narrow 1 mile');
is($locale->unit(2, 'mile', 'narrow'), '2 mil', 'Danish narrow 2 miles');
is($locale->unit(1, 'mile', 'short'), '1 mil', 'Danish short 1 mile');
is($locale->unit(2, 'mile', 'short'), '2 mil', 'Danish short 2 miles');
is($locale->unit(1, 'mile'), '1 engelsk mil', 'Danish long 1 mile');
is($locale->unit(2, 'mile'), '2 engelske mil', 'Danish long 2 miles');
is($locale->unit(1, 'mile-per-hour', 'narrow'), '1 mph', 'Danish narrow 1 mile per hour');
is($locale->unit(2, 'mile-per-hour', 'narrow'), '2 mph', 'Danish narrow 2 miles per hour');
is($locale->unit(1, 'mile-per-hour', 'short'), '1 mph', 'Danish short 1 mile per hour');
is($locale->unit(2, 'mile-per-hour', 'short'), '2 mph', 'Danish short 2 miles per hour');
is($locale->unit(1, 'mile-per-hour'), '1 engelsk mil i timen', 'Danish long 1 mile per hour');
is($locale->unit(2, 'mile-per-hour'), '2 engelske mil i timen', 'Danish long 2 miles per hour');
is($locale->unit(1, 'millibar', 'narrow'), '1mbar', 'Danish narrow 1 millibar');
is($locale->unit(2, 'millibar', 'narrow'), '2mbar', 'Danish narrow 2 millibars');
is($locale->unit(1, 'millibar', 'short'), '1 mbar', 'Danish short 1 millibar');
is($locale->unit(2, 'millibar', 'short'), '2 mbar', 'Danish short 2 millibars');
is($locale->unit(1, 'millibar'), '1 millibar', 'Danish long 1 millibar');
is($locale->unit(2, 'millibar'), '2 millibar', 'Danish long 2 millibars');
is($locale->unit(1, 'millimeter', 'narrow'), '1 mm', 'Danish narrow 1 millimetre');
is($locale->unit(2, 'millimeter', 'narrow'), '2 mm', 'Danish narrow 2 millimetres');
is($locale->unit(1, 'millimeter', 'short'), '1 mm', 'Danish short 1 millimetre');
is($locale->unit(2, 'millimeter', 'short'), '2 mm', 'Danish short 2 millimetres');
is($locale->unit(1, 'millimeter'), '1 millimeter', 'Danish long 1 millimetre');
is($locale->unit(2, 'millimeter'), '2 millimeter', 'Danish long 2 millimetres');
is($locale->unit(1, 'millisecond', 'narrow'), '1 ms', 'Danish narrow 1 millisecond');
is($locale->unit(2, 'millisecond', 'narrow'), '2 ms', 'Danish narrow 2 milliseconds');
is($locale->unit(1, 'millisecond', 'short'), '1 ms', 'Danish short 1 millisecond');
is($locale->unit(2, 'millisecond', 'short'), '2 ms', 'Danish short 2 milliseconds');
is($locale->unit(1, 'millisecond'), '1 millisekund', 'Danish long 1 millisecond');
is($locale->unit(2, 'millisecond'), '2 millisekunder', 'Danish long 2 milliseconds');
is($locale->unit(1, 'minute', 'narrow'), '1 m', 'Danish narrow 1 minute');
is($locale->unit(2, 'minute', 'narrow'), '2 min', 'Danish narrow 2 minutes');
is($locale->unit(1, 'minute', 'short'), '1 min.', 'Danish short 1 minute');
is($locale->unit(2, 'minute', 'short'), '2 min.', 'Danish short 2 minutes');
is($locale->unit(1, 'minute'), '1 minut', 'Danish long 1 minute');
is($locale->unit(2, 'minute'), '2 minutter', 'Danish long 2 minutes');
is($locale->unit(1, 'month', 'narrow'), '1 m', 'Danish narrow 1 month');
is($locale->unit(2, 'month', 'narrow'), '2 m', 'Danish narrow 2 months');
is($locale->unit(1, 'month', 'short'), '1 md.', 'Danish short 1 month');
is($locale->unit(2, 'month', 'short'), '2 mdr.', 'Danish short 2 months');
is($locale->unit(1, 'month'), '1 måned', 'Danish long 1 month');
is($locale->unit(2, 'month'), '2 måneder', 'Danish long 2 months');
is($locale->unit(1, 'ounce', 'narrow'), '1 unse', 'Danish narrow 1 ounce');
is($locale->unit(2, 'ounce', 'narrow'), '2 unser', 'Danish narrow 2 ounces');
is($locale->unit(1, 'ounce', 'short'), '1 oz', 'Danish short 1 ounce');
is($locale->unit(2, 'ounce', 'short'), '2 oz', 'Danish short 2 ounces');
is($locale->unit(1, 'ounce'), '1 ounce', 'Danish long 1 ounce');
is($locale->unit(2, 'ounce'), '2 ounces', 'Danish long 2 ounces');
is($locale->unit(1, 'millimeter-per-second', 'narrow'), '1 mm/sek.', 'Danish narrow 1 millimetre per second');
is($locale->unit(2, 'millimeter-per-second', 'narrow'), '2 mm/sek.', 'Danish narrow 2 millimetres per second');
is($locale->unit(1, 'millimeter-per-second', 'short'), '1 mm/sek.', 'Danish short 1 millimetre per second');
is($locale->unit(2, 'millimeter-per-second', 'short'), '2 mm/sek.', 'Danish short 2 millimetres per second');
is($locale->unit(1, 'millimeter-per-second'), '1 millimeter pr. sekund', 'Danish long 1 millimetre per second');
is($locale->unit(2, 'millimeter-per-second'), '2 millimeter pr. sekund', 'Danish long 2 millimetres per second');
is($locale->unit(1, 'picometer', 'narrow'), '1pm', 'Danish narrow 1 picometre');
is($locale->unit(2, 'picometer', 'narrow'), '2pm', 'Danish narrow 2 picometres');
is($locale->unit(1, 'picometer', 'short'), '1 pm', 'Danish short 1 picometre');
is($locale->unit(2, 'picometer', 'short'), '2 pm', 'Danish short 2 picometres');
is($locale->unit(1, 'picometer'), '1 pikometer', 'Danish long 1 picometre');
is($locale->unit(2, 'picometer'), '2 pikometer', 'Danish long 2 picometres');
is($locale->unit(1, 'pound', 'narrow'), '1 pund', 'Danish narrow 1 pound');
is($locale->unit(2, 'pound', 'narrow'), '2 pund', 'Danish narrow 2 pounds');
is($locale->unit(1, 'pound', 'short'), '1 lb', 'Danish short 1 pound');
is($locale->unit(2, 'pound', 'short'), '2 lb', 'Danish short 2 pounds');
is($locale->unit(1, 'pound'), '1 pund', 'Danish long 1 pound');
is($locale->unit(2, 'pound'), '2 pund', 'Danish long 2 pounds');
is($locale->unit(1, 'second', 'narrow'), '1 s', 'Danish narrow 1 second');
is($locale->unit(2, 'second', 'narrow'), '2 s', 'Danish narrow 2 seconds');
is($locale->unit(1, 'second', 'short'), '1 sek.', 'Danish short 1 second');
is($locale->unit(2, 'second', 'short'), '2 sek.', 'Danish short 2 seconds');
is($locale->unit(1, 'second'), '1 sekund', 'Danish long 1 second');
is($locale->unit(2, 'second'), '2 sekunder', 'Danish long 2 seconds');
is($locale->unit(1, 'square-foot', 'narrow'), '1 ft²', 'Danish narrow 1 square foot');
is($locale->unit(2, 'square-foot', 'narrow'), '2 ft²', 'Danish narrow 2 square feet');
is($locale->unit(1, 'square-foot', 'short'), '1 kvadratfod', 'Danish short 1 square foot');
is($locale->unit(2, 'square-foot', 'short'), '2 kvadratfod', 'Danish short 2 square feet');
is($locale->unit(1, 'square-foot'), '1 kvadratfod', 'Danish long 1 square foot');
is($locale->unit(2, 'square-foot'), '2 kvadratfod', 'Danish long 2 square feet');
is($locale->unit(1, 'square-kilometer', 'narrow'), '1km²', 'Danish narrow 1 square kilometre');
is($locale->unit(2, 'square-kilometer', 'narrow'), '2km²', 'Danish narrow 2 square kilometres');
is($locale->unit(1, 'square-kilometer', 'short'), '1 km²', 'Danish short 1 square kilometre');
is($locale->unit(2, 'square-kilometer', 'short'), '2 km²', 'Danish short 2 square kilometres');
is($locale->unit(1, 'square-kilometer'), '1 kvadratkilometer', 'Danish long 1 square kilometre');
is($locale->unit(2, 'square-kilometer'), '2 kvadratkilometer', 'Danish long 2 square kilometres');
is($locale->unit(1, 'square-meter', 'narrow'), '1m²', 'Danish narrow 1 square meter');
is($locale->unit(2, 'square-meter', 'narrow'), '2m²', 'Danish narrow 2 square meters');
is($locale->unit(1, 'square-meter', 'short'), '1 m²', 'Danish short 1 square meter');
is($locale->unit(2, 'square-meter', 'short'), '2 m²', 'Danish short 2 square metres');
is($locale->unit(1, 'square-meter'), '1 kvadratmeter', 'Danish long 1 square metre');
is($locale->unit(2, 'square-meter'), '2 kvadratmeter', 'Danish long 2 square metres');
is($locale->unit(1, 'square-mile', 'narrow'), '1 mi²', 'Danish narrow 1 square mile');
is($locale->unit(2, 'square-mile', 'narrow'), '2 mi²', 'Danish narrow 2 square miles');
is($locale->unit(1, 'square-mile', 'short'), '1 mi²', 'Danish short 1 square mile');
is($locale->unit(2, 'square-mile', 'short'), '2 mi²', 'Danish short 2 square miles');
is($locale->unit(1, 'square-mile'), '1 kvadrat-engelsk mil', 'Danish long 1 square mile');
is($locale->unit(2, 'square-mile'), '2 kvadrat-engelske mil', 'Danish long 2 square miles');
is($locale->unit(1, 'watt', 'narrow'), '1W', 'Danish narrow 1 watt');
is($locale->unit(2, 'watt', 'narrow'), '2W', 'Danish narrow 2 watts');
is($locale->unit(1, 'watt', 'short'), '1 W', 'Danish short 1 watt');
is($locale->unit(2, 'watt', 'short'), '2 W', 'Danish short 2 watts');
is($locale->unit(1, 'watt'), '1 watt', 'Danish long 1 watt');
is($locale->unit(2, 'watt'), '2 watt', 'Danish long 2 watts');
is($locale->unit(1, 'week', 'narrow'), '1 u', 'Danish narrow 1 week');
is($locale->unit(2, 'week', 'narrow'), '2 u', 'Danish narrow 2 weeks');
is($locale->unit(1, 'week', 'short'), '1 uge', 'Danish short 1 week');
is($locale->unit(2, 'week', 'short'), '2 uger', 'Danish short 2 weeks');
is($locale->unit(1, 'week'), '1 uge', 'Danish long 1 week');
is($locale->unit(2, 'week'), '2 uger', 'Danish long 2 weeks');
is($locale->unit(1, 'yard', 'narrow'), '1 yard', 'Danish narrow 1 yard');
is($locale->unit(2, 'yard', 'narrow'), '2 yard', 'Danish narrow 2 yards');
is($locale->unit(1, 'yard', 'short'), '1 yard', 'Danish short 1 yard');
is($locale->unit(2, 'yard', 'short'), '2 yard', 'Danish short 2 yards');
is($locale->unit(1, 'yard'), '1 engelsk yard', 'Danish long 1 yard');
is($locale->unit(2, 'yard'), '2 engelske yard', 'Danish long 2 yards');
is($locale->unit(1, 'year', 'narrow'), '1 år', 'Danish narrow 1 year');
is($locale->unit(2, 'year', 'narrow'), '2 år', 'Danish narrow 2 years');
is($locale->unit(1, 'year', 'short'), '1 år', 'Danish short 1 year');
is($locale->unit(2, 'year', 'short'), '2 år', 'Danish short 2 years');
is($locale->unit(1, 'year'), '1 år', 'Danish long 1 year');
is($locale->unit(2, 'year'), '2 år', 'Danish long 2 years');
is($locale->duration_unit('hm', 1, 2), '1.02', 'Danish duration hour, minuet');
is($locale->duration_unit('hms', 1, 2, 3 ), '1.02.03', 'Danish duration hour, minuet, second');
is($locale->duration_unit('ms', 1, 2 ), '1.02', 'Danish duration minuet, second');
is($locale->is_yes('Yes'), 1, 'Danish is yes');
is($locale->is_yes('es'), 0, 'Danish is not yes');
is($locale->is_no('nej'), 1, 'Danish is no');
is($locale->is_no('N&'), 0, 'Danish is not no');