#!/usr/local/bin/perl
# Test Geo::Ellipsoid displacement
use Test::More tests => 200;
use Test::Number::Delta relative => 1e-6;
use Geo::Ellipsoid;
use blib;
use strict;
use warnings;

my $e = Geo::Ellipsoid->new(units=>'degrees');
my( $x, $y );
($x, $y) = $e->displacement(-38.369163,190.874558,-38.365617,190.880663);
delta_within( $x, 533.491110768425, 1.0 );
delta_within( $y, 393.690589875524, 1.0 );

($x, $y) = $e->displacement(-14.608137,30.094655,-14.550676,30.100688);
delta_within( $x, 650.150163064444, 1.0 );
delta_within( $y, 6357.79865738502, 1.0 );

($x, $y) = $e->displacement(-41.623677,208.834416,-41.625005,208.853655);
delta_within( $x, 1603.25828998107, 1.0 );
delta_within( $y, -147.740698430105, 1.0 );

($x, $y) = $e->displacement(-67.726400,52.964864,-67.721545,52.981049);
delta_within( $x, 685.045724507767, 1.0 );
delta_within( $y, 541.410394043089, 1.0 );

($x, $y) = $e->displacement(-5.158991,259.931626,-5.199299,259.916210);
delta_within( $x, -1709.08838296406, 1.0 );
delta_within( $y, -4457.45014453434, 1.0 );

($x, $y) = $e->displacement(-0.582762,29.118576,-0.590251,29.143976);
delta_within( $x, 2827.36763205016, 1.0 );
delta_within( $y, -828.182160066125, 1.0 );

($x, $y) = $e->displacement(-26.934636,30.474042,-26.932001,30.483581);
delta_within( $x, 947.389492534727, 1.0 );
delta_within( $y, 291.952216208068, 1.0 );

($x, $y) = $e->displacement(-62.773742,62.342057,-62.738893,62.197306);
delta_within( $x, -7400.40744853939, 1.0 );
delta_within( $y, 3875.89184805396, 1.0 );

($x, $y) = $e->displacement(68.057252,192.858027,68.044404,192.750474);
delta_within( $x, -4489.41916103619, 1.0 );
delta_within( $y, -1429.20302514778, 1.0 );

($x, $y) = $e->displacement(1.348841,276.378914,1.262253,276.398905);
delta_within( $x, 2224.7897786554, 1.0 );
delta_within( $y, -9574.41945175548, 1.0 );

($x, $y) = $e->displacement(27.335146,320.699240,27.336545,320.612990);
delta_within( $x, -8535.15072425082, 1.0 );
delta_within( $y, 157.936548303674, 1.0 );

($x, $y) = $e->displacement(34.623205,31.357288,34.572414,31.419023);
delta_within( $x, 5664.82387546647, 1.0 );
delta_within( $y, -5632.70871934911, 1.0 );

($x, $y) = $e->displacement(-6.856999,130.887597,-6.914531,130.847349);
delta_within( $x, -4447.96592912198, 1.0 );
delta_within( $y, -6362.6410192093, 1.0 );

($x, $y) = $e->displacement(-70.754141,43.777574,-70.782012,43.650760);
delta_within( $x, -4660.66333081761, 1.0 );
delta_within( $y, -3114.52042675951, 1.0 );

($x, $y) = $e->displacement(-69.865357,188.114494,-69.823814,188.297760);
delta_within( $x, 7057.33332640376, 1.0 );
delta_within( $y, 4623.92896337639, 1.0 );

($x, $y) = $e->displacement(-79.523730,324.065787,-79.516236,324.164445);
delta_within( $x, 2004.84197135903, 1.0 );
delta_within( $y, 835.056245996761, 1.0 );

($x, $y) = $e->displacement(74.606774,294.646962,74.552581,294.521663);
delta_within( $x, -3726.78613552441, 1.0 );
delta_within( $y, -6044.7354292335, 1.0 );

($x, $y) = $e->displacement(28.972667,278.549276,28.976797,278.572695);
delta_within( $x, 2282.39634326221, 1.0 );
delta_within( $y, 457.952282732493, 1.0 );

($x, $y) = $e->displacement(-20.359063,296.599967,-20.370270,296.589859);
delta_within( $x, -1055.26813494428, 1.0 );
delta_within( $y, -1240.72392529638, 1.0 );

($x, $y) = $e->displacement(-60.365048,156.813021,-60.365144,156.812998);
delta_within( $x, -1.25069744997964, 1.0 );
delta_within( $y, -10.7357421117642, 1.0 );

($x, $y) = $e->displacement(-6.203945,247.684632,-6.206375,247.686280);
delta_within( $x, 182.386266388347, 1.0 );
delta_within( $y, -268.72880022115, 1.0 );

($x, $y) = $e->displacement(0.611947,100.746342,0.552611,100.813829);
delta_within( $x, 7512.26439232483, 1.0 );
delta_within( $y, -6560.95975342745, 1.0 );

($x, $y) = $e->displacement(-20.725615,342.386744,-20.731167,342.381571);
delta_within( $x, -538.867521998271, 1.0 );
delta_within( $y, -614.748870909366, 1.0 );

($x, $y) = $e->displacement(46.911457,128.191393,46.947211,128.307770);
delta_within( $x, 8859.82533662446, 1.0 );
delta_within( $y, 3981.36230426437, 1.0 );

($x, $y) = $e->displacement(-11.235004,282.756437,-11.245390,282.754171);
delta_within( $x, -247.423508180328, 1.0 );
delta_within( $y, -1148.83285898533, 1.0 );

($x, $y) = $e->displacement(-41.167125,221.956378,-41.138589,222.040926);
delta_within( $x, 7098.52944501878, 1.0 );
delta_within( $y, 3165.70460707349, 1.0 );

($x, $y) = $e->displacement(-1.549886,336.466532,-1.568002,336.488389);
delta_within( $x, 2432.16438177181, 1.0 );
delta_within( $y, -2003.196884366, 1.0 );

($x, $y) = $e->displacement(-63.776699,134.057987,-63.713580,133.947510);
delta_within( $x, -5461.07109624696, 1.0 );
delta_within( $y, 7031.39991023667, 1.0 );

($x, $y) = $e->displacement(77.940951,38.523563,77.953242,38.498324);
delta_within( $x, -588.281718924345, 1.0 );
delta_within( $y, 1372.29108955933, 1.0 );

($x, $y) = $e->displacement(45.339403,315.409130,45.355920,315.432956);
delta_within( $x, 1866.95131432552, 1.0 );
delta_within( $y, 1836.02860724917, 1.0 );

($x, $y) = $e->displacement(6.190847,124.992089,6.166990,125.017473);
delta_within( $x, 2809.54258182225, 1.0 );
delta_within( $y, -2638.18541713075, 1.0 );

($x, $y) = $e->displacement(-4.121498,262.769582,-4.205652,262.771793);
delta_within( $x, 245.486246703651, 1.0 );
delta_within( $y, -9305.72947322115, 1.0 );

($x, $y) = $e->displacement(-4.285155,344.319438,-4.310738,344.328106);
delta_within( $x, 962.149187036087, 1.0 );
delta_within( $y, -2828.96060386737, 1.0 );

($x, $y) = $e->displacement(51.523602,137.628739,51.485778,137.714167);
delta_within( $x, 5934.07068830801, 1.0 );
delta_within( $y, -4204.71851784516, 1.0 );

($x, $y) = $e->displacement(25.726049,310.324628,25.746353,310.262255);
delta_within( $x, -6257.92811145933, 1.0 );
delta_within( $y, 2250.85411079565, 1.0 );

($x, $y) = $e->displacement(68.128342,115.791221,68.089490,115.743185);
delta_within( $x, -2001.18083908821, 1.0 );
delta_within( $y, -4332.66868442251, 1.0 );

($x, $y) = $e->displacement(-11.919645,340.641713,-11.926844,340.645394);
delta_within( $x, 400.975086577028, 1.0 );
delta_within( $y, -796.364783666759, 1.0 );

($x, $y) = $e->displacement(-30.550903,251.787663,-30.582047,251.779583);
delta_within( $x, -775.012580396849, 1.0 );
delta_within( $y, -3452.63873401318, 1.0 );

($x, $y) = $e->displacement(-61.797586,265.384439,-61.744275,265.519702);
delta_within( $x, 7146.86789641561, 1.0 );
delta_within( $y, 5933.55596563617, 1.0 );

($x, $y) = $e->displacement(71.112709,8.834545,71.123788,8.940371);
delta_within( $x, 3822.76720145876, 1.0 );
delta_within( $y, 1239.54643522174, 1.0 );

($x, $y) = $e->displacement(-63.553064,13.025588,-63.587233,13.054037);
delta_within( $x, 1412.58459089993, 1.0 );
delta_within( $y, -3809.12345866723, 1.0 );

($x, $y) = $e->displacement(29.289568,92.918510,29.349021,92.967234);
delta_within( $x, 4731.59651044243, 1.0 );
delta_within( $y, 6590.78621372802, 1.0 );

($x, $y) = $e->displacement(23.630668,183.960989,23.655943,184.001554);
delta_within( $x, 4138.46502323607, 1.0 );
delta_within( $y, 2799.85919268522, 1.0 );

($x, $y) = $e->displacement(21.323022,38.682180,21.337607,38.668693);
delta_within( $x, -1399.05734418232, 1.0 );
delta_within( $y, 1614.93817472111, 1.0 );

($x, $y) = $e->displacement(77.751666,6.954744,77.807559,7.206150);
delta_within( $x, 5929.59652185931, 1.0 );
delta_within( $y, 6252.74614671994, 1.0 );

($x, $y) = $e->displacement(-58.652658,205.140021,-58.644961,205.122979);
delta_within( $x, -989.610010692509, 1.0 );
delta_within( $y, 857.234289734304, 1.0 );

($x, $y) = $e->displacement(7.193705,159.638737,7.167620,159.650791);
delta_within( $x, 1331.48923189869, 1.0 );
delta_within( $y, -2884.77225251153, 1.0 );

($x, $y) = $e->displacement(74.707726,290.854396,74.744182,290.651892);
delta_within( $x, -5950.18809260649, 1.0 );
delta_within( $y, 4079.19011600045, 1.0 );

($x, $y) = $e->displacement(68.994921,41.466113,68.962469,41.539078);
delta_within( $x, 2924.3442406804, 1.0 );
delta_within( $y, -3618.18289201577, 1.0 );

($x, $y) = $e->displacement(-19.222949,91.053479,-19.231565,91.044550);
delta_within( $x, -938.847377000882, 1.0 );
delta_within( $y, -953.71122426068, 1.0 );

($x, $y) = $e->displacement(19.041053,175.994927,19.050225,175.946699);
delta_within( $x, -5076.39561742763, 1.0 );
delta_within( $y, 1015.89451930052, 1.0 );

($x, $y) = $e->displacement(-35.454628,153.274308,-35.453589,153.286051);
delta_within( $x, 1065.9888243201, 1.0 );
delta_within( $y, 115.261142808023, 1.0 );

($x, $y) = $e->displacement(64.324875,209.104753,64.339416,208.939933);
delta_within( $x, -7966.96393627578, 1.0 );
delta_within( $y, 1631.35811372264, 1.0 );

($x, $y) = $e->displacement(33.139375,123.465763,33.161860,123.562434);
delta_within( $x, 9017.72315379817, 1.0 );
delta_within( $y, 2497.95299346437, 1.0 );

($x, $y) = $e->displacement(35.694667,300.725605,35.680284,300.759234);
delta_within( $x, 3044.2462363068, 1.0 );
delta_within( $y, -1595.33813900983, 1.0 );

($x, $y) = $e->displacement(-25.789728,191.087862,-25.739926,191.093314);
delta_within( $x, 546.974168863919, 1.0 );
delta_within( $y, 5517.28342992882, 1.0 );

($x, $y) = $e->displacement(-7.204161,179.885067,-7.226829,179.883563);
delta_within( $x, -166.062017698899, 1.0 );
delta_within( $y, -2506.87128827756, 1.0 );

($x, $y) = $e->displacement(-41.090138,219.595320,-41.067159,219.577277);
delta_within( $x, -1516.57232495974, 1.0 );
delta_within( $y, 2551.75692820557, 1.0 );

($x, $y) = $e->displacement(11.191046,106.356107,11.218345,106.390880);
delta_within( $x, 3797.39956359113, 1.0 );
delta_within( $y, 3019.90679922172, 1.0 );

($x, $y) = $e->displacement(22.955732,47.794852,22.881556,47.787755);
delta_within( $x, -728.235875892211, 1.0 );
delta_within( $y, -8214.4884556146, 1.0 );

($x, $y) = $e->displacement(-15.074589,56.914619,-15.138920,56.922179);
delta_within( $x, 812.601451282506, 1.0 );
delta_within( $y, -7118.19727801096, 1.0 );

($x, $y) = $e->displacement(35.067827,307.917302,34.993494,307.932973);
delta_within( $x, 1430.72001409022, 1.0 );
delta_within( $y, -8246.45256031053, 1.0 );

($x, $y) = $e->displacement(66.084685,30.192264,66.078143,30.159379);
delta_within( $x, -1488.56810134956, 1.0 );
delta_within( $y, -729.098706811658, 1.0 );

($x, $y) = $e->displacement(42.839865,327.847225,42.863817,327.806156);
delta_within( $x, -3356.17076205195, 1.0 );
delta_within( $y, 2661.66562916876, 1.0 );

($x, $y) = $e->displacement(-23.824528,241.336801,-23.844150,241.338414);
delta_within( $x, 164.348889911498, 1.0 );
delta_within( $y, -2173.20304898349, 1.0 );

($x, $y) = $e->displacement(-48.109675,147.804097,-48.085873,147.766528);
delta_within( $x, -2798.93428834874, 1.0 );
delta_within( $y, 2645.89807702746, 1.0 );

($x, $y) = $e->displacement(-17.562152,276.168590,-17.598393,276.206284);
delta_within( $x, 4000.9190273264, 1.0 );
delta_within( $y, -4011.40753167841, 1.0 );

($x, $y) = $e->displacement(64.918979,305.870922,64.935148,305.824711);
delta_within( $x, -2185.35323350086, 1.0 );
delta_within( $y, 1803.46389815916, 1.0 );

($x, $y) = $e->displacement(75.481994,274.248595,75.488003,274.301073);
delta_within( $x, 1468.48543886778, 1.0 );
delta_within( $y, 671.355531564528, 1.0 );

($x, $y) = $e->displacement(3.076206,112.117539,3.058191,112.030896);
delta_within( $x, -9631.38160123659, 1.0 );
delta_within( $y, -1991.68245088251, 1.0 );

($x, $y) = $e->displacement(12.921677,151.249684,12.931945,151.286618);
delta_within( $x, 4007.81424175068, 1.0 );
delta_within( $y, 1136.26395257619, 1.0 );

($x, $y) = $e->displacement(72.833548,317.667505,72.834038,317.668425);
delta_within( $x, 30.3097655310885, 1.0 );
delta_within( $y, 54.6775087783221, 1.0 );

($x, $y) = $e->displacement(-33.041308,313.249683,-33.096312,313.168134);
delta_within( $x, -7612.69582743359, 1.0 );
delta_within( $y, -6103.24474259197, 1.0 );

($x, $y) = $e->displacement(-12.674750,312.909013,-12.646330,312.908099);
delta_within( $x, -99.3361370787423, 1.0 );
delta_within( $y, 3144.11289504781, 1.0 );

($x, $y) = $e->displacement(-67.846380,99.041109,-67.773503,99.082954);
delta_within( $x, 1767.08990217072, 1.0 );
delta_within( $y, 8127.61599254722, 1.0 );

($x, $y) = $e->displacement(41.911754,138.151813,41.931514,138.160441);
delta_within( $x, 715.584704635828, 1.0 );
delta_within( $y, 2194.88853404868, 1.0 );

($x, $y) = $e->displacement(-27.100512,351.279156,-27.155735,351.235891);
delta_within( $x, -4288.35388641779, 1.0 );
delta_within( $y, -6119.80604285187, 1.0 );

($x, $y) = $e->displacement(19.497371,220.383733,19.471564,220.430924);
delta_within( $x, 4954.74739699992, 1.0 );
delta_within( $y, -2856.0491591644, 1.0 );

($x, $y) = $e->displacement(18.396198,143.265994,18.462031,143.275068);
delta_within( $x, 958.381194293679, 1.0 );
delta_within( $y, 7286.76107621273, 1.0 );

($x, $y) = $e->displacement(-18.084386,221.381908,-18.034138,221.361084);
delta_within( $x, -2205.00648076606, 1.0 );
delta_within( $y, 5561.32518565148, 1.0 );

($x, $y) = $e->displacement(46.204817,295.396070,46.149812,295.325078);
delta_within( $x, -5484.4328414883, 1.0 );
delta_within( $y, -6111.55063780206, 1.0 );

($x, $y) = $e->displacement(-30.523088,295.285416,-30.521713,295.289652);
delta_within( $x, 406.600786598683, 1.0 );
delta_within( $y, 152.458263852164, 1.0 );

($x, $y) = $e->displacement(13.742087,63.763606,13.702427,63.762726);
delta_within( $x, -95.1229021041735, 1.0 );
delta_within( $y, -4387.88267126664, 1.0 );

($x, $y) = $e->displacement(1.554684,167.837560,1.569181,167.861738);
delta_within( $x, 2690.4100103253, 1.0 );
delta_within( $y, 1602.97818773517, 1.0 );

($x, $y) = $e->displacement(40.356751,153.160097,40.386450,153.104771);
delta_within( $x, -4697.73231336175, 1.0 );
delta_within( $y, 3299.38895647299, 1.0 );

($x, $y) = $e->displacement(46.867006,44.857631,46.793584,44.800043);
delta_within( $x, -4396.76033676716, 1.0 );
delta_within( $y, -8160.55066556371, 1.0 );

($x, $y) = $e->displacement(-9.089458,237.666143,-9.069840,237.671183);
delta_within( $x, 554.021196648397, 1.0 );
delta_within( $y, 2169.71264530764, 1.0 );

($x, $y) = $e->displacement(-27.107665,34.103508,-27.124307,34.066447);
delta_within( $x, -3674.49829921938, 1.0 );
delta_within( $y, -1844.63377837014, 1.0 );

($x, $y) = $e->displacement(5.067958,24.268528,5.126032,24.314116);
delta_within( $x, 5054.67712322337, 1.0 );
delta_within( $y, 6422.20411670881, 1.0 );

($x, $y) = $e->displacement(-30.360974,322.538048,-30.354172,322.551237);
delta_within( $x, 1267.98901266173, 1.0 );
delta_within( $y, 753.967422315184, 1.0 );

($x, $y) = $e->displacement(54.780139,8.410011,54.697426,8.352324);
delta_within( $x, -3719.33949254859, 1.0 );
delta_within( $y, -9205.90372228412, 1.0 );

($x, $y) = $e->displacement(13.769616,110.113762,13.780933,110.110241);
delta_within( $x, -380.806322268845, 1.0 );
delta_within( $y, 1252.08412928069, 1.0 );

($x, $y) = $e->displacement(-64.270514,45.105873,-64.307413,45.176951);
delta_within( $x, 3439.70922672193, 1.0 );
delta_within( $y, -4115.44667469516, 1.0 );

($x, $y) = $e->displacement(-45.137898,141.541847,-45.120807,141.535744);
delta_within( $x, -480.245739061038, 1.0 );
delta_within( $y, 1899.41377857946, 1.0 );

($x, $y) = $e->displacement(6.782845,255.237805,6.796487,255.210769);
delta_within( $x, -2988.66714518103, 1.0 );
delta_within( $y, 1508.75404879855, 1.0 );

($x, $y) = $e->displacement(6.371687,279.113190,6.374738,279.111955);
delta_within( $x, -136.703313797937, 1.0 );
delta_within( $y, 337.358790144294, 1.0 );

($x, $y) = $e->displacement(44.782374,163.862303,44.840677,163.945679);
delta_within( $x, 6592.1287713044, 1.0 );
delta_within( $y, 6482.4746588666, 1.0 );

($x, $y) = $e->displacement(-70.362274,322.490547,-70.343758,322.449274);
delta_within( $x, -1550.11126555191, 1.0 );
delta_within( $y, 2065.27461062372, 1.0 );

($x, $y) = $e->displacement(-19.715571,5.847281,-19.756866,5.813268);
delta_within( $x, -3564.89009313254, 1.0 );
delta_within( $y, -4571.75406452051, 1.0 );

($x, $y) = $e->displacement(-69.938162,165.492639,-70.001918,165.578716);
delta_within( $x, 3286.68608014059, 1.0 );
delta_within( $y, -7115.04613474963, 1.0 );

