package DateTime::Calendar::FrenchRevolutionary::Locale::fr;

my @months_short  = qw (Vnd Bru Fri Niv Plu Vnt Ger Flo Pra Mes The Fru S-C);
my @add_days_short= qw (Vertu Gnie Trav Raison Rcomp Rvol);
my @months = qw(Vendmiaire Brumaire  Frimaire
                Nivse      Pluvise  Ventse
	        Germinal    Floral   Prairial
	        Messidor    Thermidor Fructidor);
push @months, "jour complmentaire";

my @decade_days = qw (Primidi Duodi Tridi Quartidi Quintidi Sextidi Septidi Octidi Nonidi Dcadi);
my @decade_days_short = qw (Pri Duo Tri Qua Qui Sex Sep Oct Non Dc);

# When initializing an array with lists within lists, it means one of two things:
# Either it is a newbie who does not know how to make multi-dimensional arrays,
# Or it is a (at least mildly) experienced Perl-coder who, for some reason, 
# wants to initialize a flat array with the concatenation of lists.
# I am a (at least mildly) experienced programmer who wants to use qw() and yet insert
# comments in some places.
my @feast = (
# Vendmiaire
	qw(
       0raisin           0safran           1chtaigne        1colchique        0cheval
       1balsamine        1carotte          2amarante         0panais           1cuve
       1pomme_de_terre   2immortelle       0potiron          0rsda           2ne
       1belle_de_nuit    1citrouille       0sarrasin         0tournesol        0pressoir
       0chanvre          1pche            0navet            2amaryllis        0boeuf
       2aubergine        0piment           1tomate           2orge             0tonneau
	),
# Brumaire
	qw(
       1pomme            0cleri           1poire            1betterave        2oie
       2hliotrope       1figue            1scorsonre       2alisier          1charrue
       0salsifis         1macre            0topinambour      2endive           0dindon
       4chervis          0cresson          1dentelaire       1grenade          1herse
       5bacchante        2azerole          1garance          2orange           0faisan
       1pistache         4macjon           0coing            0cormier          0rouleau
	),
# Frimaire
	qw(
       1raiponce         0turneps          1chicore         1nfle            0cochon
       1mche            0chou-fleur       0miel             0genivre         1pioche
       1cire             0raifort          0cdre            0sapin            0chevreuil
       2ajonc            0cyprs           0lierre           1sabine           0hoyau
       2rable-sucre     1bruyre          0roseau           2oseille          0grillon
       0pignon           0lige            1truffe           2olive            1pelle
	),
# Nivse
	qw(
       1tourbe           1houille          0bitume           0soufre           0chien
       1lave             1terre_vgtale   0fumier           0salptre         0flau
       0granit           2argile           2ardoise          0grs             0lapin
       0silex            1marne            1pierre__chaux   0marbre           0van
       1pierre__pltre  0sel              0fer              0cuivre           0chat
       2tain            0plomb            0zinc             0mercure          0crible
	),
# Pluvise
	qw(
       5laurole         1mousse           0fragon           0perce-neige      0taureau
       0laurier-thym     2amadouvier       4mzron         0peuplier         1cogne
       2ellbore         0brocoli          0laurier          2avelinier        1vache
       0buis             0lichen           2if               1pulmonaire       1serpette
       0thlaspi          4thymel          0chiendent        5trainasse        0livre
       1gude            0noisetier        0cyclamen         1chlidoine       0traneau
	),
# Ventse
	qw(
       0tussilage        0cornouiller      0violier          0trone           0bouc
       2asaret           2alaterne         1violette         0marsault         1bche
       0narcisse         2orme             1fumeterre        0vlar            1chvre
       2pinard          0doronic          0mouron           0cerfeuil         0cordeau
       1mandragore       0persil           0cochlaria       1pquerette       0thon
       0pissenlit        1sylvie           0capillaire       0frne            0plantoir
	),
# Germinal
	qw(
       1primevre        0platane          2asperge          1tulipe           1poule
       1blette           0bouleau          1jonquille        2aulne            0couvoir
       1pervenche        0charme           1morille          0htre            2abeille
       1laitue           0mlze           1cigu            0radis            1ruche
       0gainier          1romaine          0marronnier       1roquette         0pigeon
       0lilas            2anmone          1pense           1myrtille         0greffoir
	),
# Floral
	qw(
       1rose             0chne            1fougre          2aubpine         0rossignol
       2ancolie          0muguet           0champignon       1jacinthe         0rateau
       1rhubarbe         0sainfoin         0bton-d'or       4chamrisier      0ver__soie
       1consoude         1pimprenelle      1corbeille-d'or   2arroche          0sarcloir
       0statice          1fritillaire      1bourrache        1valriane        1carpe
       0fusain           1civette          1buglosse         0snev           1houlette
	),
# Prairial
	qw(
       1luzerne          6hmrocalle      0trfle           2anglique        0canard
       1mlisse          0fromental        0martagon         0serpolet         1faux
       1fraise           1btoine          0pois             2acacia           1caille
       2oeillet          0sureau           0pavot            0tilleul          1fourche
       0barbeau          1camomille        0chvrefeuille    0caille-lait      1tanche
       0jasmin           1verveine         0thym             1pivoine          0chariot
	),
# Messidor
	qw(
       0seigle           2avoine           2oignon           1vronique        0mulet
       0romarin          0concombre        2chalotte        2absinthe         1faucille
       0coriandre        2artichaut        1girofle         1lavande          0chamois
       0tabac            1groseille        1gesse            1cerise           0parc
       1menthe           0cumin            0haricot          2orcante         1pintade
       1sauge            2ail              1vesce            0bl              5chalmie
	),
# Thermidor
	qw(
       2pautre          0bouillon-blanc   0melon            2ivraie           0blier
       1prle            2armoise          0carthame         1mre             2arrosoir
       4panis            4salicor          2abricot          0basilic          1brebis
       1guimauve         0lin              2amande           1gentiane         2cluse
       1carline          0cprier          1lentille         2aune            1loutre
       1myrte            0colza            0lupin            0coton            0moulin
	),
# Fructidor
	qw(
       1prune            0millet           0lycoperdon       2escourgeon       0saumon
       1tubreuse        4sucrion          2apocyn           1rglisse         2chelle
       1pastque         0fenouil          2pine-vinette    1noix             1truite
       0citron           1cardre          0nerprun          0tagette          1hotte
       2glantier        1noisette         0houblon          0sorgho           2crevisse
       5bagarade         1verge-d'or       0mas             0marron           0panier
	),
# Jours complmentaires
	qw(
       1vertu            0gnie            0travail          2opinion          3rcompenses
       1rvolution
	 ));
my @prefix = ('jour du ', 'jour de la ', "jour de l'", 'jour des ');

my %event = ();

sub new {
  return bless {},  $_[0];
}

sub month_name {
    my ($self, $date) = @_;
    return $months[$date->month_0]
}

sub month_abbreviation {
    my ($self, $date) = @_;
    return $months_short[$date->month_0]
}

sub day_name {
    my ($self, $date) = @_;
    return $decade_days[$date->day_of_decade_0];
}

sub day_abbreviation {
    my ($self, $date) = @_;
    return $decade_days_short[$date->day_of_decade_0];
}

sub feast_short {
  my ($self, $date) = @_;
  my $lb = $feast[$date->day_of_year_0];
  $lb =~ s/_/ /g;
  return substr($lb, 1);
}

sub feast_long {
  my ($self, $date) = @_;
  my $lb = $feast[$date->day_of_year_0];
  $lb =~ s/_/ /g;
  $lb =~ s/^(\d)/$prefix[$1 % 4]/;
  return $lb;
}

sub feast_caps {
  my ($self, $date) = @_;
  my $lb = $feast[$date->day_of_year_0];
  $lb =~ s/_/ /g;
  $lb =~ s/^(\d)(.)/\u$prefix[$1 % 4]\u$2/;
  return $lb;
}

sub on_date {
  my ($self, $date) = @_;
  _load_events() unless %event;
  $event{$date->strftime('%m%d%n')} || "";
}

sub _load_events {
  %event = ('dummy', split /(\d{4}\n)/, <<'EVENTS');
0101
1 Vendmiaire I entre des troupes franaises en Savoie
1 Vendmiaire III les postes du bois d'Aix-la-Chapelle et de Reckem sont enlevs 
par l'Arme du Nord (Jourdan)
0102
2 Vendmiaire I conqute de Chambry
2 Vendmiaire III prise de la redoute et du camp de Costouge par l'Arme des
Pyrnes orientales (Dugommier).
2 Vendmiaire V l'Arme d'Italie (Kilmaine) met en droute l'ennemi  Governolo.
0103
3 Vendmiaire IV affaire de Garesio (Miolis)
0104
4 Vendmiaire II l'Arme des Alpes (Verdelin) enlve de vive force les retranchements
de Chatillon ; les Pimontais sont mis en droute et repassent la rivire de Giffe.
0105
5 Vendmiaire III dfaite des Espagnols  Olia et Monteilla par l'Arme des Pyrnes
orientales (Charlet).
0106
6 Vendmiaire III capitulation de Crevecoeur devant l'Arme du Nord (Delmas)
6 Vendmiaire III reprise de Kayserlautern, d'Alsborn et autres postes environnants
par l'Arme du Rhin (Michaud)
6 Vendmiaire V l'ennemi attaque l'Arme de Sambre et Meuse (Hardy) sur les
points de Wurstatt, Nider-Ulm, Ober et Nider-Iogelheim ; l'attaque est repousse.
0107
7 Vendmiaire I prise de la ville de Nice et de la forteresse de Montalban 
par les troupes d'Anselme.
7 Vendmiaire II l'Arme des Alpes (Verdelin) dfait l'ennemi dans les gorges
de Sallanges et prend la redoute de Saint-Martin.
0108
8 Vendmiaire V 150 hommes de l'Arme d'Italie font une sortie de Mantoue pour
se procurer du fourrage. Ils doivent se rendre aux habitants de Reggio.
0109
9 Vendmiaire I les Franais de Custines se rendent matres de la ville de Spire
aprs avoir enfonc les portes  coups de canons et subi un feu de mousqueterie
dans les rues de la ville.
9 Vendmiaire II l'Arme des Alpes (Chamberlhac) enlve de vive-force les
retranchements de Mont-Cormet tenus par les Pimontais.
0111
11 Vendmiaire II les troupes de Prisy de l'Arme des Alpes enlvent le poste
de Valmeyer  la bayonette, celles de Saint-Andr et de Chamberlhac enlvent
le poste de Beaufort, celles du gnral-en-chef Kellerman prennent Moutiers et 
le bourg Saint-Maurice et celles de Ledoyen enlvent de vive force le poste
du Col de la Madeleine.
11 Vendmiaire III  la bataille d'Aldenhoven, l'Arme de Sambre-et-Meuse
(Jourdan) provoque la droute des troupes coalises.
11 Vendmiaire V l'Arme du Rhin et Moselle (gnral-en-chef Moreau, 
gnraux de division Desaix et Saint-Cyr) attaque sur toute la ligne et met
l'ennemi en droute.
0112
12 Vendmiaire II les Espagnols sont forcs dans leurs camps du Boulon 
et Argels par l'Arme des Pyrnes orientales (Delatre).
12 Vendmiaire III le pays de Juliers se rend  l'Arme de Sambre-et-Meuse (Jourdan).
0113
13 Vendmiaire I les Autrichiens sont forcs d'vacuer la ville de Worms
et les troupes de Custines y font leur entre.
13 Vendmiaire II Arme des Pyrnes orientales : les troupes de Dagobert prennent
Campredon tandis que la garnison de Colioure (Delatre) combat la cavalerie espagnole
et la met en droute.
13 Vendmiaire II l'Arme des Pyrnes occidentales attaque les postes d'Arau
et de la valle d'Aure sur trois colonnes (Lasalle, Mascaron et Dat) et les enlve.
13 Vendmiaire IV Bonaparte rprime une manifestation royaliste  l'glise Saint-Roch
0115
15 Vendmiaire III Cologne se rend  l'Arme de Sambre-et-Meuse (Jourdan).
0116
16 Vendmiaire V l'ennemi, bloqu  Mantoue par l'Arme d'Italie (Sahuguet) tente
une sortie de 4 600 hommes, sortie qui se solde par un chec.
0117
17 Vendmiaire I  l'approche de l'Arme franaise, les Autrichiens lvent
prcipitamment le sige de Lille.
17 Vendmiaire III combat et prise de Frankenthal par l'Arme du Rhin (Desaix)
0118
18 Vendmiaire II bombardement de Lyon qui ouvre ses portes aux troupes de 
Dubois-de-Cranc.
18 Vendmiaire III prise de Shelaudenbach et de Vollfstein par l'Arme du Rhin (Michaud)
et jonction avec l'Arme de la Moselle  Lautreck.
0119
19 Vendmiaire III devant Maestricht, l'Arme de Sambre-et-Meuse (Duhesme) reprend
le chteau de Mont-Saint-Pierre.
0120
20 Vendmiaire III l'Arme de la Moselle (Moreau) marche sur Birkenfeldt, Oberstein,
Kirn et Meisenheim.
0121
21 Vendmiaire III entre de l'Arme du Nord (Delmas) dans Bois-le-Duc.
0122
22 Vendmiaire I Kellerman force les Prussiens  vacuer la ville de Verdun.
Il y entre et poursuit sa marche contre eux.
0123
23 Vendmiaire III l'Arme du Rhin (Michaud) prend Otterberg, Rockenhausen, 
Landsberg, Alzein et Oberhausen.
0124
24 Vendmiaire II l'Arme de la Moselle (Delaunay) combat et provoque la retraite
prcipite des coaliss qui s'taient ports sur Bitche et Rorbach.
24 Vendmiaire III combat et prise de Gellheim et de Grunstad par 
l'Arme du Rhin (Michaud) ; les Franais reprennent aussi Frankenthal.
0126
26 Vendmiaire I les Autrichiens attaquent plusieurs fois inutilement Hasnon
(Muller commandant) et sont repousss avec perte.
26 Vendmiaire II la bataille de Wattignies prs de Maubeuge est remporte
par l'Arme du Nord (Jourdan) sur les Autrichiens et le blocus de Maubeuge est lev.
26 Vendmiaire III l'Arme des Pyrnes occidentales (Moncey) prend la belle
mture d'Iraty et les superbes fonderies d'Egay et d'Orbaycette.
26 Vendmiaire III Arme de la Moselle : les troupes du gnral-en-chef 
Moreau prennent Creutznach et celles de Custines prennent Worms.
26 Vendmiaire VI Arme d'Italie : trait de paix dfinitif  Campo-Formio
prs d'Udine entre le gnral Bonaparte et les plnipotentiaires de l'Empereur,
roi de Hongrie et de Bohme.
26 Vendmiaire VI congrs  Rastadt pour la conclusion de la paix entre
la Rpublique franaise et l'Empire germanique.
0127
27 Vendmiaire II 600 rpublicains de l'Arme d'Italie (Dugommier) remportent
l'avantage  Gillette sur 4 000 Autrichiens, Croates et Pimontais et les
repoussent.
27 Vendmiaire III l'Arme des Pyrnes occidentales (Delabare) dfait 7 000 
Espagnols prs de Buruet et d'Almandos.
27 Vendmiaire III l'Arme du Rhin (Michaud) met en droute l'ennemi prs
de Kircheim et de Worms et prend ces deux villes.
0128
28 Vendmiaire II l'Arme d'Italie (Dugommier) remporte
une victoire complte  Gilette sur les Pimontais.
28 Vendmiaire III l'Arme du Nord (Souham) dfait l'ennemi prs de Nimgue
et dtruit la lgion de Rohan.
28 Vendmiaire V l'Arme du Rhin et Moselle (gnral-en-chef Moreau et
gnral de division Beaupuis) est attaque  Retzengen et  Simonswald, les 
efforts des ennemis sont vains.
0129
29 Vendmiaire I l'Arme franaise (gnral-en-chef Custines) force les
Autrichiens  vacuer Mayence.
29 Vendmiaire III l'Arme de la Moselle (Moreau) entre dans Bingen
aprs avoir chass les Prussiens des positions qu'ils tenaient en avant
de la ville.
29 Vendmiaire V l'Arme d'Italie (Casalta), dbarque en Corse, se porte
sur Bastia et chasse les Anglais qui s'taient retirs dans le fort.
Prise galement des villes de Saint-Florent et de Bonifacio.
0130
30 Vendmiaire II l'Arme des Pyrnes occidentales (Poncet) met
en droute trois colonnes espagnoles aprs une fusillade de cinq heures.
30 Vendmiaire V Arme de Sambre et Meuse (gnral-en-chef Beurnonville,
gnraux de division Championnet et Grenier) : l'ennemi passe le Rhin sur
six points depuis Bacharach jusqu' Andernach et attaque la tte de pont
de Neuwied et est forc  la retraite.
0201
1 Brumaire I Reprise de la ville de Longwi, les Prussiens vacuent le
territoire franais.
1 Brumaire II Arme des Pyrnes orientales. Avantage sur les
espagnols dans la valle de Baigory.
1 Brumaire II Arme du Nord. Enlvement des postes de Warneton,
Comines, Werwick, Ronek, Alluin, Menin, Furnes et Poperingues.
1 Brumaire II Arme du Rhin, prise d'Alzey et d'Oppenheim.
0202
2 Brumaire II Arme d'Italie. Dfaite  Utel de cinq mille ennemis par
neuf cents rpublicains, aprs onze heures de combat.
2 Brumaire II Arme du Rhin. Attaque du poste de Breitenstein par les
Autrichiens ; l'ennemi repouss avec une perte considrable.
2 Brumaire II Arme de Sambre et Meuse. Prise de Coblentz ; fuite de
l'ennemi au-del du Rhin.
2 Brumaire II Arme des Pyrnes orientales. Combat  Bhaga, dans
lequel les Espagnols sont repousss avec perte considrable.
2 Brumaire II Arme des Pyrnes orientales. Enlvement de vive force
des postes de Dori et Tozas et de sept retranchemens de Casteillan.
0203
3 Brumaire V Trait de paix conclu entre la Rpublique franaise et le
roi de Naples et des deux Siciles.
0204
4 Brumaire VI Arme d'Italie. Trait d'alliance entre la Rpublique
franaise et le roi de Sardaigne.
0205
5 Brumaire III Arme du Nord. Prise de Hultz, Axel et Sas-de-Gand.
5 Brumaire V Arme de Sambre et Meuse. Attaque et prise de Saint
Wendel, Kayserslautern, Kirchenpoland, Bingen et de la montagne de
Saint-Roch.
5 Brumaire V Arme du Rhin et Moselle Passage du Rhin par les
Franais, prise du fort de Khel.
0207
7 Brumaire V Arme d'Italie. Sortie ennemie de Mantoue repousse.
0208
8 Brumaire III Arme du Nord. Prise de Venlo.
0209
9 Brumaire II Arme des Pyrnes orientales. Reprise  la baonnette,
d'une batterie ennemie, en avant de Ville longue.
0211
11 Brumaire III Arme des Pyrnes orientales. Droute des Espagnols
sur les revers de la montagne Noire.
0212
12 Brumaire I Les Autrichiens sont forcs d'vacuer la petite ville de
Lanoy, le seul poste ferm qui leur restt sur le territoire franais.
12 Brumaire III Arme de la Moselle. Entre des Franais dans
Rheinfels, vacu par douze cents ennemis.
12 Brumaire V Arme d'Italie. Prise du village de Saint-Michel ; les
ponts sur l'Adige brls par les Franais. L'ennemi se porte sur le
Lavis, o il est battu et repouss jusque dans le village de
Segonzano.
0214
14 Brumaire V Arme de Sambre et Meuse. Prise de Maestricht aprs
onze jours de tranche ouverte.
0215
15 Brumaire V Arme d'Italie. L'ennemi ayant pass la Brenta est
oblig de la repasser aprs un combat meurtrier.
0216
16 Brumaire I. Bataille de Gemmapes. Par suite de cette victoire
mmorable les Franais entrent dans la ville de Mons.
16 Brumaire III Arme du Nord. Prise du fort de Schenk.
0217
17 Brumaire III Arme du Nord. La sortie de la garnison de
Berg-op-zomm est repousse  la baonnette par les Franais.
0218
18 Brumaire I. Prise de la ville de Tournay par les Franais.
18 Brumaire III Arme du Nord. Entre triomphante des Franais dans
18 Brumaire VIII Coup d'tat de Bonaparte : fin du Directoire, dbut du Consulat
Nimgue.
0219
19 Brumaire IV Arme du Nord. Prise de Burick.
0220
20 Brumaire IV Arme de Sambre et Meuse. Combat prs de Creutzenach,
dans lequel l'ennemi a t forc de repasser la Nahe.
0221
21 Brumaire V Arme d'Italie. L'arme franaise, sur l'Adige,
rencontre l'ennemi entre Saint-Michel et Saint-Martin, le culbute et
le poursuit l'espace de trois milles.
0222
22 Brumaire I Arme du Nord. La ville de Gand ouvre ses portes 
l'arme franaise.
22 Brumaire I. Prise de Charleroy par les Franais.
22 Brumaire III Arme du Rhin. Prise de Monbach et de tous les postes
de la fort en avant de ce village.
22 Brumaire III Arme du Rhin. Prise de Weissenau.
0223
23 Brumaire I. Bataille d'Anderlecht prs Bruxelles. Dfaite
complte de l'ennemi, l'arme franaise fait son entre triomphante
dans Bruxelles.
0224
24 Brumaire I. Prise de la ville de Francfort.
24 Brumaire II Arme de l'Ouest. Dfaite des rebelles de la Vende
sous les murs de Granville.
0225
25 Brumaire V Arme d'Italie. Bataille d'Arcole : cette bataille
mmorable a dur trois jours de suite ; elle a t dcide le 27 par
la prise du village d'Arcole.
0226
26 Brumaire I. Les Franais se rendent matres de la ville et du port
d'Ostende, vacu par les Autrichiens.
26 Brumaire I. Prise de Sainte-Remi.
26 Brumaire I. Capitulation de la ville de Malines.
26 Brumaire II Arme du Rhin L'arme surprend et enlve prs de
Strasbourg trois postes ennemis vaillamment dfendus.
26 Brumaire II Le sige de la ville de Granville est lev.
26 Brumaire IV Combat du champ di Pietri.
0227
27 Brumaire II Arme de la Moselle Dfaite de quatre mille Autrichiens
devant Bitche. Droute complte des Autrichiens prs Lbach. Prise
de Bising et de Blise-Castel.
27 Brumaire III Arme des Pyrnes orientales. Dugommier gnral en
chef, tu d'un coup d'obus dans l'affaire de St. Sbastien de la
Mouga.
27 Brumaire III Arme des Pyrnes orientales. Bataille gagne sur
les Espagnols  Saint-Sbastien.
0228
28 Brumaire I Prise des villes d'Ypres, Furnes et Bruges. Entre des
Franais dans la ville d'Anvers.
28 Brumaire II Arme du Rhin. Enlvement de vive force du poste de
Neuviller, et de quatre autres environnants. Prise d'une forte
redoute et de sept pices de canons prs de Wantzenau.
28 Brumaire V
Trait de paix conclu entre la Rpublique franaise et le duc de
Parme.
0229
29 Brumaire II L'Arme du Rhin enlve deux redoutes formidables prs
de Bouxweiller.
0230
30 Brumaire II Arme des Pyrnes orientales Bataille gagne  Escola,
Liers, Vilartoly, sur cinquante mille Espagnols.
30 Brumaire II Arme de la Moselle. Dfaite de douze cents hommes
d'infanterie, et de trois cents de cavalerie auprs de Blascheidt, et
de Lorentsweiller.
0301
1 Frimaire I Arme des Ardennes. Prise de la ville de Namur par les
Franais.
1 Frimaire III Arme de la Moselle. Dfaite de plus de quatre cents
ennemis dans la fort de Grunnevald, prs Luxembourg.
1 Frimaire V Arme d'Italie. L'ennemi est attaqu et repouss de
position en position ; de Castel-Nobo  Rivoli, la Corona, et le long
de l'Adige jusqu' Dolce.
0302
2 Frimaire I Arme du Rhin. Cinq mille Franais mettent en droute
toute l'arme ennemie devant Tirlemont.
2 Frimaire II Arme du Rhin. Combats successifs et enlvement des
postes de Bouxweiller, Brumpt et Haguenau par les Franais ; droute
de l'ennemi.
2 Frimaire IV Arme d'Italie. Bataille de Loano, droute des
Austro-Sardes ; prise de la Pietra, Loano, Finale, Vado et Savonne.
2 Frimaire V Arme du Rhin et Moselle. Sortie vigoureuse par la
garnison de Kehl ; la ligne ennemie est force sans tirer un coup de
fusil ; une partie de son artillerie encloue.
0303
3 Frimaire IV Arme d'Italie. Combat d'Intrapa et de Garesio.
3 Frimaire V. Sortie faite par la garnison de Mantoue, qui est
brusquement repousse et force de rentrer dans la place.
0304
4 Frimaire II Arme d'Italie. Dfaite de huit cents Pimontais par
cinq cents Franais,  Castel-Genest et  Brec, prise de Figaretto.
4 Frimaire III Arme des Pyrnes occidentales. Victoire remporte 
Osts, aprs un combat de deux jours.
0306
6 Frimaire IV Arme d'Italie. Combat de Spinardo et autres lieux.
0307
7 Frimaire I Arme du Rhin. Prise de la ville de Lige, prcde
d'une victoire complte remports sur les Autrichiens, aprs un combat
de dix heures.
7 Frimaire III Arme des Pyrnes orientales. Prise de la forteresse
de Figuires.
0308
8 Frimaire III Arme des Pyrnes orientales. Bataille gagne sur les
Espagnols  Begara, Ascuatia et Aspetia.
0310
10 Frimaire I Arme du Nord. Capitulation de la citadelle d'Anvers
10 Frimaire II Arme du Nord. Attaque de tous les postes ennemis sur
la Lys ; quinze ennemis tus, cent quarante faits prisonniers.
10 Frimaire IV Arme de Sambre et Meuse. Attaque et prise de
Creutzenach.
0311
11 Frimaire I Arme des Ardennes. Capitulation de la citadelle de
Namur.
11 Frimaire II Arme du Rhin. Enlvement de la redoute du pont de
Landgraben et des retranchemens de Gambsheim.
11 Frimaire III Arme du Rhin et Moselle. Enlvement de la redoute,
dite de Merlin, devant Mayence.
11 Frimaire V. L'ennemi, sur trois colonnes, attaque la tte du pont
d'Huningue et s'empare de la demi-lune ; il en est dlog aprs un vif
combat.
11 Frimaire XIII Napolon Premier est couronn Empereur des Franais
11 Frimaire XIV Bataille d'Austerlitz : l'arme franaise crase l'arme austro-russe
0312
12 Frimaire II Arme des Ardennes. Vigoureuse sortie de la garnison
de Givet, qui tue beaucoup d'ennemis et ne perd que cinq  six hommes,
entre Falmagne et Falmignoule.
12 Frimaire II Arme du Rhin. Combat prs du bois de Gambshein.
0314
14 Frimaire II Arme du Rhin. L'ennemi, chass du village
d'Oppendorff, est poursuivi jusqu' Druzenheim.
14 Frimaire III Arme de la Moselle. Les rpublicains enlvent de
vive force les redoutes de Salbach.
0319
19 Frimaire II Arme du Rhin. Prise des hauteurs de Dawendorff, aprs
une action trs vive.
0321
21 Frimaire I Arme du Nord. Prise des villes de Wezem et de Wert ;
cette conqute est suivie de la prise de la ville de Ruremonde,
capitale de la Gueldre autrichienne, dans laquelle les Franais font
leur entre aux acclamation de tous les habitants.
0322
22 Frimaire II Arme de l'Ouest. Victoire remporte sur les rebelles
de la Vende, prs et dans la ville du Mans.
0323
23 Frimaire II Arme des Pyrnes occidentales. Droute des Espagnols
prs de Saint-Jean-de-Luz ; ils sont forcs de repasser la Bidassoa.
0324
24 Frimaire I. Aprs plusieurs combats, les troupes franaises se
rendent matres des villes de Mertzicq, de Fredembourg et de
Saarbruck.
0325
25 Frimaire II Arme de la Moselle. Enlvement de vive force, par trois
diffrentes divisions de l'arme, des hauteurs de Marsal du Dahubruck
et de Lambach.
25 Frimaire II Arme d'Italie. Les Rpublicains enlvent de vive
force les retranchements et redoutes qui dfendaient Toulon.
0326
26 Frimaire I. Prise de Consarbruck.
26 Frimaire II Arme d'Italie. Prise de Toulon, fuite prcipite des
Anglais et des Espagnols.
26 Frimaire IV Arme de Sambre et Meuse. Combat sur toute la ligne
dans le Hundstruck ; l'ennemi est battu sur tous les points.
0327
27 Frimaire II Arme des Ardennes. Combat prs de Philippeville,
dans le bois de Jamaque, entre une partie de la garnison de Givet et
les Autrichiens ; l'ennemi est repouss avec perte.
0329
29 Frimaire II Arme des Pyrnes orientales. Enlvement  la
baonnette par deux mille cinq cents Franais, des hauteurs prs
Villelongue.
0402
2 Nivse II Arme du Rhin et Moselle. Dfaite de l'ennemi  Werd.
0403
3 Nivse II Arme du Rhin et Moselle.  Enlvement de tous les
retranchements de Bischweiller, Druzenheim et Haguenau.
0405
5 Nivse II Arme du Rhin et Moselle.  Droute de l'ennemi 
Obersebach.  Prise du chteau de Geisberg.
0406
Arme du Rhin et Moselle.  Evacuation force des lignes de la Lauter
et de Weissembourg, et leve du blocus de Landau par l'ennemi.
0407
7 Nivse II Arme du Rhin.  Les Franais enlvent les postes de
Germersheim et Spire.
0408
8 Nivse III Arme du Nord.  Passage du Vaal, prise de Bommel, du fort
Saint-Andr et de quatre postes environnants, reddition de Grave.
0413
13 Nivse I Arme du Nord.  Un dtachement de l'avant-garde franaise
pntre dans le pays de Luxembourg, et s'empare des caisses de
l'Empereur, dans lesquelles se trouvent deux cent mille francs
espces.
0414
14 Nivse II Arme de l'Ouest.  Prise sur les rebelles de la Vende de
l'le de Noirmoutiers.
0417
17 Nivse II Arme du Rhin et Moselle.  Prise de Worms.
17 Nivse III Arme des Pyrnes occidentales.  Prise du fort de la
Trinit.
0420
20 Nivse VI Arme d'Italie.  Deux colonnes de troupes franaises
marchent sur la ville de Rome pour venger la mort du gnral Duphot,
et l'insulte faite  l'ambassadeur de la Rpublique franaise ;  leur
approche, l'insurrection clate dans l'Ombrie ; ses habitants secouent
le joug du gouvernement papal et se dclarent libres et indpendants.
0422
22 Nivse III Arme du Nord.  Prise de Thiel et de six forts.
0423
23 Nivse II Arme des Pyrnes occidentales.  Enlvement de vive
force du poste de la Montagne de Louis XIV par quatre cents
rpublicains.
23 Nivse V Arme d'Italie.  Combat de Saint-Michel devant Vronne.
23 Nivse V Arme d'Italie.  L'ennemi attaque la tte de la ligne de
Montebaldo et est repouss.
0424
24 Nivse III Arme du Nord.  Prise d'Heusdin.
0425
25 Nivse V Arme d'Italie.  Bataille de Rivoli, l'ennemi en droute
complte.
0426
26 Nivse V Arme d'Italie.  Dix mille ennemis forcent le passage
d'Anghiari.
26 Nivse V Arme d'Italie.  Le gnral Provera  la tte de six mille
hommes, attaque le faubourg Saint-Georges de Mantoue pendant toute la
journe, mais inutilement.
0427
27 Nivse II Arme du Rhin et Moselle.  Les ennemis font une sortie du
fort Vauban et sont repousss.
27 Nivse V Bataille de la Favorite (faubourg de Mantoue), Wurmser
choue dans sa sortie de Mantoue et Provera est oblig de capituler.
0428
28 Nivse III Arme du Nord.  Prise d'Utrecht, d'Amersford et des
lignes du Greb, passage de la Lech.
0429
29 Nivse II Arme du Rhin.  Evacuation totale du dpartement du
Bas-Rhin par les coaliss ; reprise du fort Vauban.
29 Nivse III Arme du Nord.  Prise de Gertuydemberg.
0502
2 Pluvise II Arme des Pyrnes occidentales. Deux cents Franais
enlvent  la baonette la redoute d'Harriette prs Ispeguy.
2 Pluvise III Arme du Nord. Les villes de Gorcum, Dordrecht et
d'Amsterdam se rendent aux Franais.
0504
4 Pluvise II Arme du Var. A l'approche des troupes Franaises, les
Anglais abandonnent les les d'Hyres.
0507
7 Pluvise V Arme d'Italie. L'ennemi, chass au-del de la Brenta,
est atteint  Carpenedelo, et est forc  la retraite.
0508
8 Pluvise V Arme d'Italie. L'ennemi poursuivi dans les gorges du
Tyrol est atteint  Avio.
0509
9 Pluvise V Le gnral Murat dbarque  Torgole et chasse les ennemis ; 
le gnral Vial les tourne et leur fait quatre cent cinquante
prisonniers. Entre des Franais dans Roveredo et Trente.
9 Pluvise VI Arme d'Italie. Prise de la ville d'Ancne, par l'arme
franaise ; elle continue sa marche sur Rome par Maurata.
0510
10 Pluvise V Arme du Rhin et Moselle. A trois heures du matin, les
Rpublicains sur deux colonnes, font une sortie de la tte de pont
d'Huningue et chassent l'ennemi des deux premires parallles.
0513
13 Pluvise I La rpublique franaise dclare la guerre au roi
d'Angleterre et au stathouder de Hollande.
13 Pluvise VI Arme d'Italie. Une des colonnes de l'arme d'Italie,
premire division, traverse le territoire Gnvois et tablit son
quartier gnral  Ferney-Voltaire.
0514
14 Pluvise V Arme d'Italie. Les Franais attaquent les dbris de
l'arme autrichienne derrire le Lavis et les repoussent jusqu'
Saint-Michel.
Entre des Franais  Janola, trois  quatre mille hommes du Pape,
retranchs derrire la rivire de Senio sont mis en droute. Entre
des Franais  Faenza et Forli.
Capitulation de Mantoue, la garnison prisonnire de guerre.
0515
15 Pluvise III Arme des Pyrnes occidentales. Prise de Roses,
aprs 27 jours de sige.
Arme du Nord. Conqute de la Hollande : toutes les places fortes et
les vaisseaux de guerre restent au pouvoir des Franais. Entre des
troupes franaises  Midelbourg et  Flesingue.
0517
17 Pluvise III Arme des Pyrnes occidentales. Droute complette
des Espagnols  Sare et Berra.
Droute de quinze mille Espagnols battus  Urrugne et  Chauvin-Dragon
par cinq mille rpublicains ; douze cents ennemis tus.
0518
18 Pluvise V Arme d'Italie. Les avant-postes de l'ennemi repousss
sur la droite de l'Adige ; prise de Derunbano.
0521
21 Pluvise V Arme d'Italie. Les troupes du pape, au nombre de douze
cents hommes, sur les hauteurs en avant d'Ancne, sont enveloppes et
faites prisonnires, sans tirer un coup de fusil.
Prise d'Ancne.
21 Pluvise VI Arme d'Italie. Les troupes franaises continuent leur
marche sur Rome.
0522
22 Pluvise V Arme d'Italie. Prise de Lorette.
0527
27 Pluvise VI Arme d'Italie. Entre des Franais dans Rome ; le
gnral Berthier se rend au capitole, o, au nom de la Rpublique
franaise, il proclame la Rpublique romaine.
0601
1 Ventse II Arme du Rhin.  Les Franais enlvent de vive force le
poste d'Ogersheim.
1 Ventse V Arme d'Italie.  Trait de paix avec le pape, conclu 
Tolentino.
0604
4 Ventse V Arme d'Italie.  Reprise du poste de Treviso.
0605
5 Ventse V Arme d'Italie.  Affaire de Foi : l'ennemi est chass de
ses retranchements ; les Franais tombent ensuite sur un corps de
chasseurs Tyroliens et les dfont.
Les Franais, attaqus  Bidole, battent compltement l'ennemi.
Kellerman passe la Piave  San-Mamma, et met en fuite un poste de
hussards ennemis qui en dfendaient le passage.
0607
7 Ventse X Naissance de Victor Hugo
0611
11 Ventse III Arme des Pyrnes orientales.  Prise de Bezalu.
0612
12 Ventse V Arme d'Italie.  Les Franais attaquent l'ennemi  Monte
di-Savaro et le dfont.
0615
15 Ventse VI Arme en Helvtie.  Capitulation de la ville de Berne.
0616
16 Ventse II Arme des Ardennes.  Combat prs Soumoy et Cerffontaine ; 
dfaite de l'ennemi.
0617
17 Ventse I. Dclaration de guerre au roi d'Espagne.
0618
18 Ventse II Arme de la Moselle.  Dfaite de trois bataillons
autrichiens sur les hauteurs des forges de Joegerthal.
0620
20 Ventse V.  Arme d'Italie.  Une division de l'arme franaise se
rend  Feltre ;  son approche l'ennemi vacue la ligne de Cordevoie
et se porte sur Bellurn.
0622
22 Ventse V.  Arme d'Italie.  La 21e lgre passe la Piave vis--vis
le village de Vidor, culbute l'ennemi qui vouloit s'opposer  son
passage, et le force d'vacuer son camp de la Gampana.
0623
23 Ventse V.  Arme d'Italie.  Combat de Sacile.
Affaire de Bellurn, dans laquelle l'arrire-garde ennemie est
enveloppe et faite prisonnire.
23 Ventse VI Aprs cinq combats successifs et meurtriers, les Suisses
vacuent Morat.
0626
26 Ventse V Arme d'Italie.  Passage du Tagliamento, malgr des
forces suprieures et une rsistance opinitre.
Prise du village de Gradisca.
0627
27 Ventse VI Trait d'alliance et de commerce entre les Rpubliques
franaise et cisalpine.
0628
28 Ventse V Arme d'Italie.  Prise de Palma Nova, que l'ennemi est
forc d'vacuer.
0629
29 Ventse V Arme d'Italie.  Prise de la ville de Gradisca.  Passage
du pont de Casasola.
0630
30 Ventse V Arme d'Italie.  Combat de Lavis. Les troupes ennemies,
aprs un combat opinitre, sont enveloppes par les Franais.
0701
1 Germinal V Arme d'Italie. Entre des Franais dans Geritz.
Affaire de Caminia, entre l'avant-garde franaise et l'arrire-garde
ennemie.
0702
2 Germinal IV Arme d'Italie. Combat de Tramin et Combat de
Caporetto.
0703
3 Germinal V Arme d'Italie. Combat de Clausen. L'ennemi battu 
Botzen, s'enferme dans Clausen, o il est attaqu par les Franais
puis est oblig de cder.
0704
4 Germinal V Arme des Pyrnes orientales. Entre des Franais 
Trieste. Les Franais s'emparent des clbres mines d'Ydria.
0705
5 Germinal II Arme de la Moselle. Avantage remport sur les
Prussiens, qui attaquent les avant-postes d'Apach au nord de Sierck.
5 Germinal V Arme d'Italie. Combat de Tarvis ; aprs une opinitre
rsistance, l'ennemi est mis en droute.
0706
6 Germinal V Arme d'Italie. Affaire de la Chinse ; prise de ce poste
important.
0708
8 Germinal V Arme d'Italie. Des bataillons ennemis, frachement
arrivs du Rhin, entreprennent de dfendre la gorge d'Innsbruck ; ils
sont culbuts par la 85e demi-brigade.
0709
9 Germinal V Arme d'Italie. Les Franais entrent dans la ville de
Clagenfurth, capitale de la haute et basse Carinthie ; le prince
Charles avec les dbris de son arme, extrmement dcourage, fuit
devant eux.
0712
12 Germinal V Arme d'Italie. Combat des gorges de Neumarck ;
l'arrire garde ennemie est culbute par l'avant-garde franaise et
les Franais entrent dans Neumarck et Freissels.
0714
14 Germinal II Arme des Pyrnes occidentales. Les Franais enlvent
de vive force les retranchemens d'Ozon, prs Saint-Jean de Luz, et
mettent en fuite les Espagnols.
14 Germinal V Arme d'Italie. Les Autrichiens, vaincus sur tous les
points, vacuent le Tyrol. Le prince Charles fait sa retraite  marche
force sur la route de Vienne ; il est battu par la division Massena.
0715
15 Germinal V. Combat de Hundsmarck ; l'arrire-garde ennemie est
dfaite par l'avant-garde franaise. Entre des Franais dans
Hundsmark, Kiotenfeld, Mureau et Judembourg.
0716
16 Germinal IV Arme d'Italie. Reconnaissance militaire vers Cairo ;
les postes ennemis sont culbuts.
0717
17 Germinal II Arme des Pyrnes occidentales. Dfaite des Espagnols
prs d'Hendaye.
Arme d'Italie. Prise du camp de Fougasse.
0718
18 Germinal II Arme d'Italie. Enlvement de tous les postes aux
environs de Breglio, dans le comt de Nice.
18 Germinal V Suspension d'armes de cinq jours, entre les armes
franaise en Italie, et impriale.
0719
19 Germinal II Arme d'Italie. Prise d'Oneille.
0720
20 Germinal IV Arme d'Italie. Affaire de Voltry.
0721
21 Germinal II Arme des Pyrnes orientales. Dfaite des Espagnols 
Monteilla ; prise d'Urgel.
Arme des Ardennes. Avantage signal remport par un faible
dtachement sorti de Philippeville, qui chasse l'ennemi du bois situ
entre Villiers et Florence, et le met en droute.
21 Germinal IV Arme d'Italie. Attaque de la redoute de Montelezimo,
dfendue par les Franais ; l'ennemi est repouss.
0722
22 Germinal VI Arme de Mayence. Blocus du fort d'Ehreinbrestein.
0723
23 Germinal IV Arme d'Italie. Bataille de Montenotte ; droute
complte des ennemis.
0725
25 Germinal III Trait de paix entre la Rpublique franaise et le roi
de Prusse.
25 Germinal IV Arme d'Italie. Prise de Cossaria.
0726
26 Germinal II Arme de la Moselle. Combat sur les hauteurs de
Tiperdange, entre une compagnie du 1er bataillon du Haut Rhin et
quatre-vingt chasseurs rpublicains, contre soixante hussards de
Wurmser et quatre cents paysans arms.
26 Germinal IV Arme d'Italie. Bataille de Millesimo, gagne sur les
Austro-Sardes. Combat de Dego, droute de l'ennemi. Combat et prise
de Saint-Jean, dans la valle de la Barmida. Prise de Batisolo, de
Bagnosco et de Pontenocetto. Prise des redoutes de Montezemo.
0727
27 Germinal II Arme de la Moselle. Les Franais occupent les
hauteurs de Mertzig, aprs en avoir chass l'ennemi.
Arme d'Italie. Dfaite de quinze cents Autrichiens  Ponte-di-Nava.
27 Germinal IV Arme d'Italie. Prise du camp retranch de la ville de
Cera.
0728
28 Germinal II Arme d'Italie. Prise d'Ormea.
0729
29 Germinal II Arme de la Moselle. Bataille d'Arlon ; prise de cette
ville, droute complte de l'ennemi.
0802
2 Floral I Arme des Pyrnes occidentales. Affaire de Jurgazza
Mondi, dans laquelle les troupes rpublicaines ont mis dans une
droute complte un corps d'Espagnols.
0803
3 Floral II Arme des Ardennes. Droute complte de l'ennemi 
Aussoy, prs Philippeville, aprs un combat de douze heures.
3 Floral IV Arme d'Italie. Combat et prise de la ville de Mondovi.
0804
2 Floral II Arme du Rhin. Victoire remporte auprs de
Kurweiller.
0805
5 Floral I Arme des Pyrnes orientales. Affaire de Samouragaldi,
dans laquelle deux cents Franais ont battu compltement quatre cents
Espagnols.
Bombardement de Fontarabie.
5 Floral II Arme des Alpes. Enlvement de vive force de toutes
les redoutes des Monts Valaisan et Saint-Bernard et du poste de la
Thuile.
5 Floral IV Arme d'Italie. Entre des Franais dans la ville de
Bne.
0806
6 Floral IV Arme d'Italie. Prise de Fossano, de Cherasco, d'Alba.
0807
7 Floral II Arme des Pyrnes occidentales. Droute des Espagnols
et des migrs, repouss des postes d'Arnguy et d'Irameaca.
Arme des Ardennes. Victoire remporte, aprs quatre heures d'une
rsistance opinitre. Enlvement de vive force, des hauteurs de Bossu ; 
entre et runion des armes des Ardennes et du Nord dans la ville
de Beaumont.
Arme du Nord. Prise de Courtray, aprs une bataille gnrale sur
toute la ligne, depuis Dunkerque jusqu' Givet.
Arme des Pyrnes orientales. Les Franais enlvent de vive force le
poste du rocher d'Arrola.
Droute de quatre mille hommes d'infanterie et de dix escadrons de
cavalerie espagnole  Roqueluche ; perte considrable de l'ennemi.
0808
8 Floral II Arme des Pyrnes orientales. Les Franais, au nombre
de trois mille, chassent dix mille ennemis du village d'Oms ; ils
enlvent les gorges et le pont du Ceret.
0809
9 Floral IV Arme d'Italie. Armistice conclu avec le roi de
Sardaigne.
0810
10 Floral II Arme du Nord. Victoire  Mont-Castel sur vingt mille
Autrichiens.
Prise de Menin et d'une grande quantit d'artillerie.
Arme d'Italie. Victoire sur les Pimontais.
10 Floral IV Entre des Franais dans la cit de Ceva et de Coni.
10 Floral V Trait de paix entre la Rpublique franaise et le pape.
0811
11 Floral II Arme des Pyrnes orientales. Bataille gagne sur les
Espagnols, aux Albres ; enlvement de la fameuse redoute de
Montesquiou.
11 Floral V Arme d'Italie. Prliminaires de paix entre la
Rpublique franaise et l'Empereur, signs  Leoben par le gnral
Buonaparte et les plnipotentiaires de l'Empereur.
0812
12 Floral II Arme du Rhin. Prise de Lambsheim et de Franckental par
les Franais ; les portes de cette dernire ville sont enfonces 
coups de canons.
0815
15 Floral II Arme des Pyrnes orientales. Les Franais occupent
les hauteurs du cap de Bearn et du pays de Las-Daines, o six mille
hommes arrivent  travers les plus nombreux obstacles ; commencement
du sige de Collioure.
15 Floral III Arme des Pyrnes orientales. Les Espagnols attaquant
le camp de Cistella, sont compltement battus et repousss.
0816
16 Floral IV Arme d'Italie. Entre des Franais dans la ville de
Tortonne.
0817
17 Floral III Arme des Pyrnes orientales. Reconnoissance gnrale
faite par les Franais sur les hauteurs de Crespia, de Bascara et sur
la Fluvia.
0818
18 Floral IV Arme d'Italie. Reconnoissance faite sur la rive du P,
vers Plaisance.
0819
19 Floral IV Arme d'Italie. Passage du P par l'avant-garde
rpublicaine, et combat de Fombio.
0820
20 Floral II Arme des Alpes. Prise du fort Mirabouck, aprs
quatorze heures d'attaque, et du poste de Villeneuve-des-Prats.
Prise de la redoute de Maupertuis.
20 Floral III Arme des Pyrnes orientales. Attaque du camp de la
montagne de Musquirachu ; l'ennemi mis en fuite, abandonne son camp
tout tendu et tous les effets de campement ; cent quarante ennemis
tus, cinquante faits prisonniers.
20 Floral IV Arme d'Italie. Les Autrichiens attaquent prs de
Cordogno la division Laharpe, et sont vigoureusement repousss par les
Rpublicains, qui s'emparent de Casale.
Conclusion de l'armistice avec le duc de Parme.
0821
21 Floral II Arme des Ardennes. Prise de Thuin par les Franais,
aprs un combat opinitre : enlvement  la baonnette de tous les
retranchements Autrichiens.
21 Floral IV Arme d'Italie. Bataille de Lody : passage du pont
dfendu par l'arme entire de Beaulieu.
0822
22 Floral II Arme du Nord. Dfaite des ennemis devant Tournay.
Combat de sept heures devant Courtray : droute complte de
l'ennemi. Droute de l'ennemi  Ingelsmunster.
22 Floral IV Arme d'Italie. Buonaparte, gnral en chef. Prise de
Pizzighitone. Entre des Franais dans Crmone.
0823
23 Floral II Arme des Ardennes. Les Franais enlvent tous les
ouvrages du camp de Merbes, d'o l'ennemi est forc de se retirer.
Au passage de la Sambre, les grenadiers du 49e rgiment s'lancent 
l'eau pour soutenir les tirailleurs, et mettent en droute la lgion
de Bourbon.
Le 68e rgiment soutient seul sur un pont l'attaque des Autrichiens
suprieurs en nombre, quoiqu'en butte  l'artillerie, et conserve son
poste.
0824
24 Floral II Arme des Ardennes. Combat opinitre : prise et reprise
trois fois du village de Grandreng prs Beaumont.
0825
25 Floral II Arme des Alpes. Les rpublicains enlvent de vive
force les redoutes de Riveto, de la Ramasse, et autres postes sur le
Mont-Cnis.
0826
26 Floral IV Arme d'Italie. Conclusion de la paix avec le roi de
Sardaigne.
0827
27 Floral II Arme des Pyrnes orientales. Sortie de la garnison de
Collioure : trois mille Espagnols repousss avec perte. Le gnral en
chef bless dans cette action.
0828
28 Floral IV Arme d'Italie. Les Franais occupent Milan, Pavie et
Come.
0829
29 Floral II Arme du Nord. Dfaite de l'ennemi  Moescroen.
Bataille gagne sur les coaliss, entre Menin et Courtray.
Arme des Ardennes. Glorieuse rsistance de quinze cents Franais qui
s'opposent  la marche de quatorze mille Autrichiens vers Cunfoz.
Cent cinquante jeunes gens de la premire rquisition qui tiennent en
chec toute la droite de l'arme de Beaulieu devant Bouillon.
Arme des Pyrnes occidentales. Enlvement de six magasins
ennemis. Rupture des cluses de la grande mture royale : prise d'une
grande quantit de bestiaux.
Droute des Espagnols, repousss  la baonnette jusqu' leur camp de
Berra.
0830
30 Floral II Arme des Pyrnes orientales. Droute des Espagnols
prs de Figuires.
Arme des Ardennes. Belle dfense de cent soixante Franais renferms
et attaqus par de nombreux ennemis dans le chteau de Bouillon.
30 Floral VI Bombardement d'Ostende par les Anglais, et dbarquement
de quatre mille d'entre eux ; les Franais les enveloppent, font deux
mille prisonniers, et forcent le reste  se rembarquer prcipitemment
avec perte de cent hommes tus. Le gnral anglais est lui-mme
grivement bless.
0901E
1 Prairial VII Naissance d'Honor de Balzac
0925
25 Prairial VIII Bataille de Marengo en Italie, Klber est assassin au Caire
1008
8 Messidor II Victoire de Fleurus par Jourdan. Premire utilisation de la
reconnaissance arienne par le capitaine Coutelle,  bord du ballon L'Entreprenant
1103
3 Thermidor III Victoire de Hoche  Quiberon contre les royalistes
1109
9 Thermidor II La chute de Robespierre
1118
18 Thermidor IV Victoire de Bonaparte sur Wurmser  Castiglione
1303
Jour du travail V Mort du gnral Hoche
1305
Jour des rcompenses IV Mort du gnral Marceau, g de 27 ans,  Altenkirchen
EVENTS
  delete $event{dummy};
}

# A module must return a true value. Traditionally, a module returns 1.
# But this module is a revolutionary one, so it discards all old traditions.
"Dansons la carmagnole, vive le son du canon.";
