# $Id: 05_save_load.t,v 1.2 2005/03/30 16:56:04 jettero Exp $

use strict;
use Test;

my ($x, $y) = (25, 25);

plan tests => ($x * $y);

use Games::RolePlay::MapGen;

my $map = new Games::RolePlay::MapGen({bounding_box => join("x", $x, $y) });

generate $map;
save_map $map ("the.map");

my %checksums = ();
for my $i (0..$x-1) {
    for my $j (0..$y-1) {
        $checksums{$i}{$j} = &a_kind_of_checksum( $i, $j, $map );
    }
}

delete $map->{_the_map};
delete $map->{_the_groups};

load_map $map ("the.map");
for my $i (0..$x-1) {
    for my $j (0..$y-1) {
        ok( &a_kind_of_checksum($i, $j, $map), $checksums{$i}{$j} );
    }
}

sub a_kind_of_checksum {
    my ($x, $y, $map) = @_;

    my $tile = $map->{_the_map}[$y][$x];

    return "nothin' there" if not exists $tile->{type};
    return sprintf('%d-%d-%s-%d%d%d%d', $x, $y, $tile->{type}, map($tile->{od}{$_}, qw(n e s w)));
}
