#include <utils/normalizer.h>

normalizer::normalizer(real _min, real _max, real _Min, real _Max) {
    min = _min;
    max = _max;

    Min = _Min;
    Max = _Max;
}

real normalizer::normalize(real r) {
     return ((r-Min) / (Max-Min)) * (max-min) + min;
}

real normalizer::denormalize(real r) {
    return (r*Max - r*Min + Min*max - min*Max)/(max - min);
}

void normalizer::normalize(real *r, int size) {
    for(int i=0; i<size; i++)
        r[i] = normalize(r[i]);
}

void normalizer::denormalize(real *r, int size) {
    for(int i=0; i<size; i++)
        r[i] = denormalize(r[i]);
}
