#include "nwin.h"

void nwin::wipe(int pause) {
    scrollok(messages, TRUE);

    napms(pause);
    for(int i=0; i<LINES-7; i++) {
        scroll(messages);
    }
    scrollok(messages, FALSE);
    position = 0;
    wrefresh(messages);
}

void nwin::wipe() {
    scrollok(messages, TRUE);

    for(int i=0; i<LINES-7; i++) {
        scroll(messages);
    }
    scrollok(messages, FALSE);
    position = 0;
    wrefresh(messages);
}

void nwin::show_str(const char *s) {
    scrollok(messages, TRUE);

    if(position>lastline) {
        scroll(messages);
        wmove(messages, position-1, 0);
    } else {
        wmove(messages, position++, 0);
    }

    scrollok(messages, FALSE);
    waddstr(messages, s);
    wrefresh(messages);
}

void nwin::show_chr(chtype c, int x, int y) {
    wmove(messages, x, y);
    waddch(messages, c);
}

void nwin::done_chr() {
    wrefresh(messages);
}

nwin::nwin(WINDOW *win, int rs, int cs, int r, int c) {
    position = 0;
    lastline = rs-1;
    messages = derwin(win, rs, cs, r, c);
    wrefresh(messages);
}

nwin::~nwin() {
    delwin(messages);
}

