#include "d_walker.h"
#include "nwin.h"
#include "bwin.h"

void walker_display::show_header(char first_state, int states) {
    char *state = new char[states*2];

    for(int i=0; i<states*2; i+=2) {
        state[i]   = first_state + (int)(i/2);
        state[i+1] = ' ';
    }

    state[states*2] = '\0';

    header->show_str(state);
    header2->show_str(state);
    delete state;
}

void walker_display::show_state(char first_state, char last_state) {
    sprintf(msg, "%*s*", (last_state - first_state)*2, "");
    scroller->show_str(msg);
}

void walker_display::show_epsilon(int yn) {
    escroller->show_str((yn) ? "e":" ");
}

void walker_display::show_action(int lr) {
    dscroller->show_str((lr) ? " >":"< ");
}

void walker_display::show_str(const char *s) {
    messages->show_str(s);
    if(f) fprintf(f, "%s\n", s);
}

void walker_display::start_new_episode() {
     scroller->wipe(100);
    dscroller->wipe();
    escroller->wipe();
}

walker_display::walker_display(char first_state, int states) {
    WINDOW *screen = initscr();
    noecho();
    curs_set(0);

    f = fopen("walker.log", "w");

    messages = new bwin(screen, 5, COLS, LINES-5, 0);

    int scols = states*2; int eswdt = 1; int dswdt = 2;
    int m = (COLS-(scols+5))/2;

    header   = new nwin(screen, 1, scols,       0, m);
    header2  = new nwin(screen, 1, scols, LINES-6, m);

    show_header(first_state, states);

    scroller  = new nwin(screen, LINES-7, scols, 1,             m);
    escroller = new nwin(screen, LINES-7, eswdt, 1, scols+dswdt+m);
    dscroller = new nwin(screen, LINES-7, dswdt, 1, scols+    0+m);
}

walker_display::~walker_display() {
    delete header;
    delete scroller;
    delete messages;
    if(f) fclose(f);
    endwin();
}
