#include <utils/real.h>
#ifndef USE_TYPEDEF
#include <stdio.h>
#define __USE_ISOC9X 1
#include <math.h>

#define isnegative(X) ( signbit(X)) 
#define ispositive(X) (!signbit(X)) 

#define sign_same(X,Y) (signbit(X) == signbit(Y))
#define sign_diff(X,Y) (signbit(X) != signbit(Y))

#define EXIT_ON_ERROR 1

real::real()         { rval = 0.0; }
real::real(double d) { rval = d;   }

real::operator double() { return rval; }

int  real::operator  <(double d) { return (rval  < d     ) ? 1:0; }
int  real::operator  <(real   r) { return (rval  < r.rval) ? 1:0; }
int  real::operator  >(double d) { return (rval  > d     ) ? 1:0; }
int  real::operator  >(real   r) { return (rval  > r.rval) ? 1:0; }
int  real::operator ==(double d) { return (rval == d     ) ? 1:0; }
int  real::operator ==(real   r) { return (rval == r.rval) ? 1:0; }
int  real::operator >=(double d) { return (rval >= d     ) ? 1:0; }
int  real::operator >=(real   r) { return (rval >= r.rval) ? 1:0; }
int  real::operator <=(double d) { return (rval <= d     ) ? 1:0; }
int  real::operator <=(real   r) { return (rval <= r.rval) ? 1:0; }
void real::operator +=(double d) { rval += d;                     }
void real::operator +=(real   r) { rval += r.rval;                }
void real::operator -=(double d) { rval -= d;                     }
void real::operator -=(real   r) { rval -= r.rval;                }
void real::operator  =(double d) { rval  = d;                     }
void real::operator  =(real   r) { rval  = r.rval;                }
void real::operator ++(        ) { rval++;                        }
void real::operator --(        ) { rval--;                        }

real real::add(double d) { //printf("+");
    real t(rval+d);
    if(fabs(t) == DBL_MAX) {
        printf("Ceiling reached during addition.\n");
#if EXIT_ON_ERROR
        exit(EXIT_ON_ERROR);
#endif
    }
    return t;
}

real real::mul(double d) { //printf("*");
    real t(rval*d);
    if(rval && d && !isnormal(t)) {
        printf("Overflow/underflow during multiplication.\n");
#if EXIT_ON_ERROR
        exit(EXIT_ON_ERROR);
#endif
    }
    return t;
}

real real::sub(double d) { //printf("-");
    real t(rval-d);
    if(fabs(t) == DBL_MAX) {
        printf("Ceiling reached during subtraction.\n");
#if EXIT_ON_ERROR
        exit(EXIT_ON_ERROR);
#endif
    }
    return t;
}

real real::div(double d) { //printf("/");
    real t(rval/d);
    if(!d) {
        printf("Division by 0.\n");
#if EXIT_ON_ERROR
        exit(EXIT_ON_ERROR);
#endif
    }
    if(rval && !isnormal(t)) {
        printf("Overflow/underflow during division.\n");
#if EXIT_ON_ERROR
        exit(EXIT_ON_ERROR);
#endif
    }
    return t;
}

real real::sbi(double d) {
    real t(d);
    return t.sub(rval);
}

real real::dvi(double d) {
    real t(d);
    return t.div(rval);
}

real operator +(double d1, real   r1) { return r1.add(     d1); }
real operator +(real   r1, double d1) { return r1.add(     d1); }
real operator +(real   r1, real   r2) { return r1.add(r2.rval); }

real operator *(double d1, real   r1) { return r1.mul(     d1); }
real operator *(real   r1, double d1) { return r1.mul(     d1); }
real operator *(real   r1, real   r2) { return r1.mul(r2.rval); }

real operator -(double d1, real   r1) { return r1.sbi(     d1); }
real operator -(real   r1, double d1) { return r1.sub(     d1); }
real operator -(real   r1, real   r2) { return r1.sub(r2.rval); }

real operator /(double d1, real   r1) { return r1.dvi(     d1); }
real operator /(real   r1, double d1) { return r1.div(     d1); }
real operator /(real   r1, real   r2) { return r1.div(r2.rval); }

#endif
