static const char *MARPAESLIFLUA_CONTEXTSTACK =
  "\n"
  "-- By design a context is always either nil, either an array (table in lua terminology)\n"
  "\n"
  "local marpaESLIFContextStack = {}\n"
  "marpaESLIFContextStack.new = function()\n"
  "   local exlen  = NiledTable.exlen  -- Because # does not work on niled array\n"
  "   local delete = NiledTable.delete -- Makes an element non-existant\n"
  "\n"
  "   local stack  = niledarray(nil)   -- Initial context stack contains one element that is nil: stack[1] = nil (and it EXISTS)\n"
  "\n"
  "   local self = {}                  -- The context stack object\n"
  "\n"
  "   function self:get()\n"
  "     local explist = stack[exlen(stack)]\n"
  "\n"
  "     if (explist == nil) then\n"
  "       return nil\n"
  "     else\n"
  "       -- We want nil to be persistent after table.unpack\n"
  "       return niledarray(table.unpack(explist))\n"
  "     end\n"
  "   end\n"
  "\n"
  "   function self:set(context)\n"
  "     stack[exlen(stack)] = context\n"
  "   end\n"
  "\n"
  "   function self:push(context)\n"
  "     -- By construction we always push a table.pack of an expression list\n"
  "     stack[exlen(stack) + 1] = context\n"
  "   end\n"
  "\n"
  "   function self:pop()\n"
  "     delete(stack, exlen(stack))\n"
  "   end\n"
  "\n"
  "   return self\n"
  "end\n"
  "\n"
  "return marpaESLIFContextStack\n"
  "\n";
