/*
 * Decompiled with CFR 0.152.
 */
package com.javonet.sdk;

import com.javonet.core.transmitter.Transmitter;
import com.javonet.sdk.ConfigRuntimeFactory;
import com.javonet.sdk.RuntimeFactory;
import com.javonet.sdk.tools.ActivationHelper;
import com.javonet.sdk.tools.BinariesUnloader;
import com.javonet.sdk.tools.SdkMessageHelper;
import com.javonet.utils.connectiondata.InMemoryConnectionData;
import com.javonet.utils.connectiondata.TcpConnectionData;

public final class Javonet {
    public static RuntimeFactory inMemory() {
        return new RuntimeFactory(new InMemoryConnectionData());
    }

    public static RuntimeFactory tcp(TcpConnectionData connectionData) {
        return new RuntimeFactory(connectionData);
    }

    public static ConfigRuntimeFactory withConfig(String path) {
        try {
            Javonet.extractNativeBinaries();
            Transmitter.setConfigSource(path);
            return new ConfigRuntimeFactory(path);
        }
        catch (Exception e) {
            SdkMessageHelper.GetInstance().sendMessageToAppInsights("SdkException", "WithConfig exception: " + e.getMessage());
            throw e;
        }
    }

    public static int activate(String licenseKey) {
        ActivationHelper.setTemporaryLicenseKey(licenseKey);
        Javonet.extractNativeBinaries();
        SdkMessageHelper.GetInstance().sendMessageToAppInsights("SdkMessage", "Activation");
        return Transmitter.activate(licenseKey);
    }

    private static void extractNativeBinaries() {
        BinariesUnloader.extractBinariesFromJar("Native");
    }

    static {
        SdkMessageHelper.GetInstance().sendMessageToAppInsights("SdkMessage", "Javonet SDK initialized");
    }
}

