/*
 * Decompiled with CFR 0.152.
 */
package com.javonet.sdk;

import com.javonet.core.generator.handler.GeneratorHandler;
import com.javonet.core.interpreter.Interpreter;
import com.javonet.sdk.InvocationContext;
import com.javonet.sdk.internal.AbstractModuleContext;
import com.javonet.sdk.internal.AbstractRuntimeContext;
import com.javonet.sdk.internal.AbstractTypeContext;
import com.javonet.sdk.tools.BinariesUnloader;
import com.javonet.sdk.tools.SdkMessageHelper;
import com.javonet.utils.Command;
import com.javonet.utils.CommandType;
import com.javonet.utils.ConnectionType;
import com.javonet.utils.RuntimeName;
import com.javonet.utils.connectiondata.IConnectionData;
import com.javonet.utils.exceptions.ExceptionThrower;
import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class RuntimeContext
implements AbstractTypeContext,
AbstractModuleContext,
AbstractRuntimeContext {
    private final RuntimeName runtimeName;
    private final IConnectionData connectionData;
    private Command currentCommand;
    private Command responseCommand;
    private final Interpreter interpreter = new Interpreter();
    private static final ConcurrentMap<RuntimeName, RuntimeContext> memoryRuntimeContexts = new ConcurrentHashMap<RuntimeName, RuntimeContext>();
    private static final ConcurrentMap<String, RuntimeContext> networkRuntimeContexts = new ConcurrentHashMap<String, RuntimeContext>();
    private static final ConcurrentMap<String, RuntimeContext> webSocketRuntimeContexts = new ConcurrentHashMap<String, RuntimeContext>();
    private final GeneratorHandler generatorHandler = new GeneratorHandler();

    public static RuntimeContext getInstance(RuntimeName runtimeName, IConnectionData connectionData) {
        switch (connectionData.getConnectionType()) {
            case IN_MEMORY: {
                return memoryRuntimeContexts.computeIfAbsent(runtimeName, k -> new RuntimeContext(runtimeName, connectionData));
            }
            case TCP: {
                String networkRuntimeContextsKey = (Object)((Object)runtimeName) + ":" + connectionData.toString();
                return networkRuntimeContexts.computeIfAbsent(networkRuntimeContextsKey, k -> new RuntimeContext(runtimeName, connectionData));
            }
            case WEB_SOCKET: {
                String webSocketRuntimeContextsKey = (Object)((Object)runtimeName) + ":" + connectionData.toString();
                return webSocketRuntimeContexts.computeIfAbsent(webSocketRuntimeContextsKey, k -> new RuntimeContext(runtimeName, connectionData));
            }
        }
        throw new RuntimeException("Unknown connection type: " + (Object)((Object)connectionData.getConnectionType()));
    }

    private RuntimeContext(RuntimeName runtimeName, IConnectionData connectionData) {
        this.runtimeName = runtimeName;
        this.connectionData = connectionData;
        SdkMessageHelper.GetInstance().sendMessageToAppInsights("SdkMessage", runtimeName.toString());
        BinariesUnloader.extractBinariesFromJar("Native");
        if (RuntimeName.Jvm != runtimeName && connectionData.getConnectionType() == ConnectionType.IN_MEMORY) {
            BinariesUnloader.extractBinariesFromJar(runtimeName.toString());
        }
    }

    @Override
    public void execute() {
        this.responseCommand = this.interpreter.execute(this.currentCommand, this.connectionData);
        this.currentCommand = null;
        if (this.responseCommand.getCommandType() == CommandType.EXCEPTION) {
            ExceptionThrower.throwException(this.responseCommand);
        }
    }

    @Override
    public RuntimeContext loadLibrary(String libraryPath) {
        Command localCommand = new Command(this.runtimeName, CommandType.LOAD_LIBRARY, libraryPath);
        this.currentCommand = this.buildCommand(localCommand);
        this.execute();
        return this;
    }

    @Override
    public InvocationContext getType(String typeName, Object ... args) {
        Command localCommand = new Command(this.runtimeName, CommandType.GET_TYPE, this.createArgsArray(typeName, args));
        this.currentCommand = null;
        return new InvocationContext(this.runtimeName, this.connectionData, this.buildCommand(localCommand));
    }

    public InvocationContext cast(Object ... args) {
        Command localCommand = new Command(this.runtimeName, CommandType.CAST, args);
        this.currentCommand = null;
        return new InvocationContext(this.runtimeName, this.connectionData, this.buildCommand(localCommand));
    }

    public InvocationContext invokeGlobalMethod(Object ... args) {
        Command localCommand = new Command(this.runtimeName, CommandType.INVOKE_GLOBAL_METHOD, args);
        return new InvocationContext(this.runtimeName, this.connectionData, this.buildCommand(localCommand));
    }

    public RuntimeContext generateLibrary(Object ... args) {
        Command localCommand = new Command(this.runtimeName, CommandType.GENERATE_LIB, args);
        this.currentCommand = this.buildCommand(localCommand);
        this.execute();
        this.generatorHandler.generate(this.responseCommand, System.getProperty("user.dir"));
        return this;
    }

    public InvocationContext getEnumItem(Object ... args) {
        Command localCommand = new Command(this.runtimeName, CommandType.GET_ENUM_ITEM, args);
        this.currentCommand = null;
        return new InvocationContext(this.runtimeName, this.connectionData, this.buildCommand(localCommand));
    }

    public InvocationContext asOut(Object ... args) {
        Command localCommand = new Command(this.runtimeName, CommandType.AS_OUT, args);
        this.currentCommand = null;
        return new InvocationContext(this.runtimeName, this.connectionData, this.buildCommand(localCommand));
    }

    public InvocationContext asRef(Object ... args) {
        Command localCommand = new Command(this.runtimeName, CommandType.AS_REF, args);
        this.currentCommand = null;
        return new InvocationContext(this.runtimeName, this.connectionData, this.buildCommand(localCommand));
    }

    private Command buildCommand(Command command) {
        for (int i = 0; i < command.getPayload().length; ++i) {
            command.setPayload(this.encapsulatePayloadItem(command.getPayload()[i]), i);
        }
        return command.prependArgumentToPayload(this.currentCommand);
    }

    private Command encapsulatePayloadItem(Object payloadItem) {
        if (payloadItem == null) {
            return new Command(this.runtimeName, CommandType.VALUE, payloadItem);
        }
        if (payloadItem instanceof Command) {
            for (int i = 0; i < ((Command)payloadItem).getPayload().length; ++i) {
                ((Command)payloadItem).setPayload(this.encapsulatePayloadItem(((Command)payloadItem).getPayload()[i]), i);
            }
            return (Command)payloadItem;
        }
        if (payloadItem instanceof InvocationContext) {
            return ((InvocationContext)payloadItem).getCurrentCommand();
        }
        if (payloadItem.getClass().isArray()) {
            Object[] objectArray = new Object[((Object[])payloadItem).length];
            for (int i = 0; i < ((Object[])payloadItem).length; ++i) {
                objectArray[i] = this.encapsulatePayloadItem(((Object[])payloadItem)[i]);
            }
            return new Command(this.runtimeName, CommandType.ARRAY, objectArray);
        }
        return new Command(this.runtimeName, CommandType.VALUE, payloadItem);
    }

    private Object[] createArgsArray(Object arg1, Object ... args) {
        Object[] argsArray = Arrays.copyOf(new Object[]{arg1}, args.length + 1);
        System.arraycopy(args, 0, argsArray, 1, args.length);
        return argsArray;
    }

    public void healthCheck() {
        Command localCommand = new Command(this.runtimeName, CommandType.VALUE, "health_check");
        this.currentCommand = this.buildCommand(localCommand);
        this.execute();
    }
}

