/*
 * Decompiled with CFR 0.152.
 */
package com.javonet.core.protocol;

import com.javonet.utils.Command;
import com.javonet.utils.StringEncodingMode;
import com.javonet.utils.Type;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public class TypeSerializer {
    public static byte[] serializePrimitive(Object obj) {
        if (obj.getClass() == String.class) {
            return TypeSerializer.serializeString((String)obj);
        }
        if (obj.getClass() == Integer.class) {
            return TypeSerializer.serializeInt((Integer)obj);
        }
        if (obj.getClass() == Boolean.class) {
            return TypeSerializer.serializeBool((Boolean)obj);
        }
        if (obj.getClass() == Float.class) {
            return TypeSerializer.serializeFloat(((Float)obj).floatValue());
        }
        if (obj.getClass() == Byte.class) {
            return TypeSerializer.serializeByte((Byte)obj);
        }
        if (obj.getClass() == Character.class) {
            return TypeSerializer.serializeChar(((Character)obj).charValue());
        }
        if (obj.getClass() == Long.class) {
            return TypeSerializer.serializeLong((Long)obj);
        }
        if (obj.getClass() == Double.class) {
            return TypeSerializer.serializeDouble((Double)obj);
        }
        return new byte[0];
    }

    protected static byte[] serializeCommand(Command cmd) {
        ByteBuffer buffer = ByteBuffer.allocate(7);
        buffer.put((byte)Type.COMMAND.ordinal());
        buffer.put(TypeSerializer.serializeIntValue(cmd.getPayloadSize()));
        buffer.put((byte)cmd.getRuntimeName().ordinal());
        buffer.put((byte)cmd.getCommandType().ordinal());
        return buffer.array();
    }

    protected static byte[] serializeString(String val) {
        byte[] bytes = val.getBytes(StandardCharsets.UTF_8);
        ByteBuffer buffer = ByteBuffer.allocate(bytes.length + 6);
        buffer.put((byte)Type.STRING.ordinal());
        buffer.put((byte)StringEncodingMode.UTF8.ordinal());
        buffer.put(TypeSerializer.serializeIntValue(bytes.length));
        buffer.put(Arrays.copyOfRange(bytes, 0, bytes.length));
        return buffer.array();
    }

    protected static byte[] serializeInt(int val) {
        return new byte[]{(byte)Type.INTEGER.ordinal(), 4, (byte)val, (byte)(val >>> 8 & 0xFF), (byte)(val >>> 16 & 0xFF), (byte)(val >>> 24 & 0xFF)};
    }

    protected static byte[] serializeBool(boolean boolValue) {
        return new byte[]{(byte)Type.BOOLEAN.ordinal(), 1, (byte)(boolValue ? 1 : 0)};
    }

    protected static byte[] serializeFloat(float floatValue) {
        int val = Float.floatToIntBits(floatValue);
        return new byte[]{(byte)Type.FLOAT.ordinal(), 4, (byte)val, (byte)(val >>> 8 & 0xFF), (byte)(val >>> 16 & 0xFF), (byte)(val >>> 24 & 0xFF)};
    }

    protected static byte[] serializeByte(byte byteValue) {
        return new byte[]{(byte)Type.BYTE.ordinal(), 1, byteValue};
    }

    protected static byte[] serializeChar(char charValue) {
        return new byte[]{(byte)Type.CHAR.ordinal(), 1, (byte)charValue};
    }

    protected static byte[] serializeLong(long longValue) {
        return new byte[]{(byte)Type.LONG.ordinal(), 8, (byte)(longValue & 0xFFL), (byte)(longValue >> 8 & 0xFFL), (byte)(longValue >> 16 & 0xFFL), (byte)(longValue >> 24 & 0xFFL), (byte)(longValue >> 32 & 0xFFL), (byte)(longValue >> 40 & 0xFFL), (byte)(longValue >> 48 & 0xFFL), (byte)(longValue >> 56 & 0xFFL)};
    }

    protected static byte[] serializeDouble(double doubleValue) {
        long val = Double.doubleToLongBits(doubleValue);
        return new byte[]{(byte)Type.DOUBLE.ordinal(), 8, (byte)(val & 0xFFL), (byte)(val >> 8 & 0xFFL), (byte)(val >> 16 & 0xFFL), (byte)(val >> 24 & 0xFFL), (byte)(val >> 32 & 0xFFL), (byte)(val >> 40 & 0xFFL), (byte)(val >> 48 & 0xFFL), (byte)(val >> 56 & 0xFFL)};
    }

    private static byte[] serializeIntValue(int intValue) {
        return new byte[]{(byte)(intValue & 0xFF), (byte)(intValue >> 8 & 0xFF), (byte)(intValue >> 16 & 0xFF), (byte)(intValue >> 24 & 0xFF)};
    }
}

