/*
 * Decompiled with CFR 0.152.
 */
package com.javonet.core.protocol;

import com.javonet.utils.Command;
import com.javonet.utils.StringEcodingMode;
import com.javonet.utils.Type;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public class TypeEncoder {
    public static byte[] encodePrimitive(Object obj) {
        if (obj.getClass() == Integer.class) {
            int val = (Integer)obj;
            return TypeEncoder.encodeInt(val);
        }
        if (obj.getClass() == Boolean.class) {
            return TypeEncoder.encodeBoolean((Boolean)obj);
        }
        if (obj.getClass() == String.class) {
            return TypeEncoder.encodeString((String)obj);
        }
        if (obj.getClass() == Float.class) {
            return TypeEncoder.encodeFloat(((Float)obj).floatValue());
        }
        if (obj.getClass() == Byte.class) {
            return TypeEncoder.encodeByte((Byte)obj);
        }
        if (obj.getClass() == Character.class) {
            return TypeEncoder.encodeChar(((Character)obj).charValue());
        }
        if (obj.getClass() == Long.class) {
            return TypeEncoder.encodeLong((Long)obj);
        }
        if (obj.getClass() == Double.class) {
            return TypeEncoder.encodeDouble((Double)obj);
        }
        return new byte[0];
    }

    protected static byte[] encodeInt(int val) {
        return new byte[]{(byte)Type.INTEGER.ordinal(), 4, (byte)val, (byte)(val >>> 8 & 0xFF), (byte)(val >>> 16 & 0xFF), (byte)(val >>> 24 & 0xFF)};
    }

    protected static byte[] encodeCommand(Command cmd) {
        ByteBuffer buffer = ByteBuffer.allocate(7);
        buffer.put((byte)Type.COMMAND.ordinal());
        buffer.put(TypeEncoder.encodeIntValue(cmd.getPayloadSize()));
        buffer.put((byte)cmd.getRuntimeName().ordinal());
        buffer.put((byte)cmd.getCommandType().ordinal());
        return buffer.array();
    }

    protected static byte[] encodeString(String val) {
        byte[] bytes = val.getBytes(StandardCharsets.UTF_8);
        ByteBuffer buffer = ByteBuffer.allocate(bytes.length + 6);
        buffer.put((byte)Type.STRING.ordinal());
        buffer.put((byte)StringEcodingMode.UTF8.ordinal());
        buffer.put(TypeEncoder.encodeIntValue(bytes.length));
        buffer.put(Arrays.copyOfRange(bytes, 0, bytes.length));
        return buffer.array();
    }

    protected static byte[] encodeBoolean(boolean boolValue) {
        return new byte[]{(byte)Type.BOOLEAN.ordinal(), 1, (byte)(boolValue ? 1 : 0)};
    }

    protected static byte[] encodeFloat(float floatValue) {
        int val = Float.floatToIntBits(floatValue);
        return new byte[]{(byte)Type.FLOAT.ordinal(), 4, (byte)val, (byte)(val >>> 8 & 0xFF), (byte)(val >>> 16 & 0xFF), (byte)(val >>> 24 & 0xFF)};
    }

    protected static byte[] encodeByte(byte byteValue) {
        return new byte[]{(byte)Type.BYTE.ordinal(), 1, byteValue};
    }

    protected static byte[] encodeChar(char charValue) {
        return new byte[]{(byte)Type.CHAR.ordinal(), 1, (byte)charValue};
    }

    protected static byte[] encodeLong(long longValue) {
        return new byte[]{(byte)Type.LONG.ordinal(), 8, (byte)(longValue & 0xFFL), (byte)(longValue >> 8 & 0xFFL), (byte)(longValue >> 16 & 0xFFL), (byte)(longValue >> 24 & 0xFFL), (byte)(longValue >> 32 & 0xFFL), (byte)(longValue >> 40 & 0xFFL), (byte)(longValue >> 48 & 0xFFL), (byte)(longValue >> 56 & 0xFFL)};
    }

    private static byte[] encodeIntValue(int intValue) {
        return new byte[]{(byte)(intValue & 0xFF), (byte)(intValue >> 8 & 0xFF), (byte)(intValue >> 16 & 0xFF), (byte)(intValue >> 24 & 0xFF)};
    }

    protected static byte[] encodeDouble(double doubleValue) {
        long val = Double.doubleToLongBits(doubleValue);
        return new byte[]{(byte)Type.DOUBLE.ordinal(), 8, (byte)(val & 0xFFL), (byte)(val >> 8 & 0xFFL), (byte)(val >> 16 & 0xFFL), (byte)(val >> 24 & 0xFFL), (byte)(val >> 32 & 0xFFL), (byte)(val >> 40 & 0xFFL), (byte)(val >> 48 & 0xFFL), (byte)(val >> 56 & 0xFFL)};
    }
}

