/*
 * Decompiled with CFR 0.152.
 */
package com.javonet.core.handler;

import com.javonet.core.handler.AbstractHandler;
import com.javonet.utils.Command;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.List;
import java.util.Map;

public class ArrayGetItemHandler
extends AbstractHandler {
    @Override
    Object process(Command command) throws Exception {
        if (command.getPayload()[0] instanceof Object[]) {
            return this.getArrayElement(command);
        }
        if (command.getPayload()[0] instanceof List) {
            return this.getListElement(command);
        }
        if (command.getPayload()[0] instanceof Map) {
            return this.getMapElement(command);
        }
        if (command.getPayload()[0] instanceof Dictionary) {
            return this.getDictionaryElement(command);
        }
        throw new Exception(String.format("Cannot get element from %s", command.getPayload()[0]).toString());
    }

    private Object getArrayElement(Command command) throws Exception {
        Object[] indexes = Arrays.stream(command.getPayload()).skip(1L).toArray();
        switch (indexes.length) {
            case 1: {
                return ((Object[])command.getPayload()[0])[(Integer)indexes[0]];
            }
            case 2: {
                return ((Object[][])command.getPayload()[0])[(Integer)indexes[0]][(Integer)indexes[1]];
            }
            case 3: {
                return ((Object[][][])command.getPayload()[0])[(Integer)indexes[0]][(Integer)indexes[1]][(Integer)indexes[2]];
            }
        }
        throw new Exception(String.format("Cannot get element from %s", command.getPayload()[0]).toString());
    }

    private Object getListElement(Command command) {
        List list = (List)command.getPayload()[0];
        Integer index = (Integer)command.getPayload()[1];
        return list.get(index);
    }

    private Object getMapElement(Command command) {
        Map map = (Map)command.getPayload()[0];
        Object key = command.getPayload()[1];
        return map.get(key);
    }

    private Object getDictionaryElement(Command command) {
        Dictionary dict = (Dictionary)command.getPayload()[0];
        Object key = command.getPayload()[1];
        return dict.get(key);
    }
}

