#############################################################
# This file was automatically generated on 2020-05-19.      #
#                                                           #
# Perl Bindings Version 2.1.27                              #
#                                                           #
# If you have a bugfix for this file and want to commit it, #
# please fix the bug in the generator. You can find a link  #
# to the generators git repository on tinkerforge.com       #
#############################################################

=pod

=encoding utf8

=head1 NAME

Tinkerforge::BrickletDMX - DMX master and slave

=cut

package Tinkerforge::BrickletDMX;

use strict;
use warnings;
use Carp;
use threads;
use threads::shared;
use parent 'Tinkerforge::Device';
use Tinkerforge::IPConnection;
use Tinkerforge::Error;

=head1 CONSTANTS

=over

=item DEVICE_IDENTIFIER

This constant is used to identify a DMX Bricklet.

The get_identity() subroutine and the CALLBACK_ENUMERATE callback of the
IP Connection have a device_identifier parameter to specify the Brick's or
Bricklet's type.

=cut

use constant DEVICE_IDENTIFIER => 285;

=item DEVICE_DISPLAY_NAME

This constant represents the display name of a DMX Bricklet.

=cut

use constant DEVICE_DISPLAY_NAME => 'DMX Bricklet';

=item CALLBACK_FRAME_STARTED

This constant is used with the register_callback() subroutine to specify
the CALLBACK_FRAME_STARTED callback.

=cut

use constant CALLBACK_FRAME_STARTED => 14;

=item CALLBACK_FRAME_AVAILABLE

This constant is used with the register_callback() subroutine to specify
the CALLBACK_FRAME_AVAILABLE callback.

=cut

use constant CALLBACK_FRAME_AVAILABLE => 15;

=item CALLBACK_FRAME_LOW_LEVEL

This constant is used with the register_callback() subroutine to specify
the CALLBACK_FRAME_LOW_LEVEL callback.

=cut

use constant CALLBACK_FRAME_LOW_LEVEL => 16;

=item CALLBACK_FRAME_ERROR_COUNT

This constant is used with the register_callback() subroutine to specify
the CALLBACK_FRAME_ERROR_COUNT callback.

=cut

use constant CALLBACK_FRAME_ERROR_COUNT => 17;

=item CALLBACK_FRAME

This constant is used with the register_callback() subroutine to specify
the CALLBACK_FRAME callback.

=cut

use constant CALLBACK_FRAME => -16;

=item FUNCTION_SET_DMX_MODE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_DMX_MODE => 1;

=item FUNCTION_GET_DMX_MODE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_DMX_MODE => 2;

=item FUNCTION_WRITE_FRAME_LOW_LEVEL

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_WRITE_FRAME_LOW_LEVEL => 3;

=item FUNCTION_READ_FRAME_LOW_LEVEL

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_READ_FRAME_LOW_LEVEL => 4;

=item FUNCTION_SET_FRAME_DURATION

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_FRAME_DURATION => 5;

=item FUNCTION_GET_FRAME_DURATION

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_FRAME_DURATION => 6;

=item FUNCTION_GET_FRAME_ERROR_COUNT

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_FRAME_ERROR_COUNT => 7;

=item FUNCTION_SET_COMMUNICATION_LED_CONFIG

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_COMMUNICATION_LED_CONFIG => 8;

=item FUNCTION_GET_COMMUNICATION_LED_CONFIG

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_COMMUNICATION_LED_CONFIG => 9;

=item FUNCTION_SET_ERROR_LED_CONFIG

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_ERROR_LED_CONFIG => 10;

=item FUNCTION_GET_ERROR_LED_CONFIG

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_ERROR_LED_CONFIG => 11;

=item FUNCTION_SET_FRAME_CALLBACK_CONFIG

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_FRAME_CALLBACK_CONFIG => 12;

=item FUNCTION_GET_FRAME_CALLBACK_CONFIG

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_FRAME_CALLBACK_CONFIG => 13;

=item FUNCTION_GET_SPITFP_ERROR_COUNT

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_SPITFP_ERROR_COUNT => 234;

=item FUNCTION_SET_BOOTLOADER_MODE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_BOOTLOADER_MODE => 235;

=item FUNCTION_GET_BOOTLOADER_MODE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_BOOTLOADER_MODE => 236;

=item FUNCTION_SET_WRITE_FIRMWARE_POINTER

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_WRITE_FIRMWARE_POINTER => 237;

=item FUNCTION_WRITE_FIRMWARE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_WRITE_FIRMWARE => 238;

=item FUNCTION_SET_STATUS_LED_CONFIG

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_STATUS_LED_CONFIG => 239;

=item FUNCTION_GET_STATUS_LED_CONFIG

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_STATUS_LED_CONFIG => 240;

=item FUNCTION_GET_CHIP_TEMPERATURE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_CHIP_TEMPERATURE => 242;

=item FUNCTION_RESET

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_RESET => 243;

=item FUNCTION_WRITE_UID

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_WRITE_UID => 248;

=item FUNCTION_READ_UID

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_READ_UID => 249;

=item FUNCTION_GET_IDENTITY

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_IDENTITY => 255;
use constant DMX_MODE_MASTER => 0;
use constant DMX_MODE_SLAVE => 1;
use constant COMMUNICATION_LED_CONFIG_OFF => 0;
use constant COMMUNICATION_LED_CONFIG_ON => 1;
use constant COMMUNICATION_LED_CONFIG_SHOW_HEARTBEAT => 2;
use constant COMMUNICATION_LED_CONFIG_SHOW_COMMUNICATION => 3;
use constant ERROR_LED_CONFIG_OFF => 0;
use constant ERROR_LED_CONFIG_ON => 1;
use constant ERROR_LED_CONFIG_SHOW_HEARTBEAT => 2;
use constant ERROR_LED_CONFIG_SHOW_ERROR => 3;
use constant BOOTLOADER_MODE_BOOTLOADER => 0;
use constant BOOTLOADER_MODE_FIRMWARE => 1;
use constant BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT => 2;
use constant BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT => 3;
use constant BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT => 4;
use constant BOOTLOADER_STATUS_OK => 0;
use constant BOOTLOADER_STATUS_INVALID_MODE => 1;
use constant BOOTLOADER_STATUS_NO_CHANGE => 2;
use constant BOOTLOADER_STATUS_ENTRY_FUNCTION_NOT_PRESENT => 3;
use constant BOOTLOADER_STATUS_DEVICE_IDENTIFIER_INCORRECT => 4;
use constant BOOTLOADER_STATUS_CRC_MISMATCH => 5;
use constant STATUS_LED_CONFIG_OFF => 0;
use constant STATUS_LED_CONFIG_ON => 1;
use constant STATUS_LED_CONFIG_SHOW_HEARTBEAT => 2;
use constant STATUS_LED_CONFIG_SHOW_STATUS => 3;


=back

=head1 FUNCTIONS

=over

=item new()

Creates an object with the unique device ID *uid* and adds it to
the IP Connection *ipcon*.

=cut

sub new
{
	my ($class, $uid, $ipcon) = @_;

	my $self = Tinkerforge::Device->_new($uid, $ipcon, [2, 0, 0], &DEVICE_IDENTIFIER, &DEVICE_DISPLAY_NAME);

	$self->{response_expected}->{&FUNCTION_SET_DMX_MODE} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_GET_DMX_MODE} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_WRITE_FRAME_LOW_LEVEL} = Tinkerforge::Device->_RESPONSE_EXPECTED_TRUE;
	$self->{response_expected}->{&FUNCTION_READ_FRAME_LOW_LEVEL} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_FRAME_DURATION} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_GET_FRAME_DURATION} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_FRAME_ERROR_COUNT} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_COMMUNICATION_LED_CONFIG} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_GET_COMMUNICATION_LED_CONFIG} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_ERROR_LED_CONFIG} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_GET_ERROR_LED_CONFIG} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_FRAME_CALLBACK_CONFIG} = Tinkerforge::Device->_RESPONSE_EXPECTED_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_FRAME_CALLBACK_CONFIG} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_SPITFP_ERROR_COUNT} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_BOOTLOADER_MODE} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_BOOTLOADER_MODE} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_WRITE_FIRMWARE_POINTER} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_WRITE_FIRMWARE} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_STATUS_LED_CONFIG} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_GET_STATUS_LED_CONFIG} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_CHIP_TEMPERATURE} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_RESET} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_WRITE_UID} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_READ_UID} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_IDENTITY} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;

	$self->{callback_formats}->{&CALLBACK_FRAME_STARTED} = shared_clone([8, '']);
	$self->{callback_formats}->{&CALLBACK_FRAME_AVAILABLE} = shared_clone([12, 'L']);
	$self->{callback_formats}->{&CALLBACK_FRAME_LOW_LEVEL} = shared_clone([72, 'S S C56 L']);
	$self->{callback_formats}->{&CALLBACK_FRAME_ERROR_COUNT} = shared_clone([16, 'L L']);

	$self->{high_level_callbacks}->{&CALLBACK_FRAME} = shared_clone([shared_clone({stream_length => 0, stream_chunk_offset => 1, stream_chunk_data => 2}), shared_clone(['stream_length', 'stream_chunk_offset', 'stream_chunk_data', undef]), shared_clone({fixed_length => undef, single_chunk => 0}), undef]);

	bless($self, $class);

	$ipcon->_add_device($self);

	return $self;
}


=item set_dmx_mode()

Sets the DMX mode to either master or slave.

Calling this function sets frame number to 0.

=cut

sub set_dmx_mode
{
	my ($self, $dmx_mode) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_SET_DMX_MODE, [$dmx_mode], 'C', 0, '');
}

=item get_dmx_mode()

Returns the DMX mode, as set by :func:`Set DMX Mode`.

=cut

sub get_dmx_mode
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_DMX_MODE, [], '', 9, 'C');
}

=item write_frame_low_level()

Writes a DMX frame. The maximum frame size is 512 byte. Each byte represents one channel.

The next frame can be written after the :cb:`Frame Started` callback was called. The frame
is double buffered, so a new frame can be written as soon as the writing of the prior frame
starts.

The data will be transfered when the next frame duration ends, see :func:`Set Frame Duration`.

Generic approach:

* Set the frame duration to a value that represents the number of frames per second you want to achieve.
* Set channels for first frame.
* Wait for the :cb:`Frame Started` callback.
* Set channels for next frame.
* Wait for the :cb:`Frame Started` callback.
* and so on.

This approach ensures that you can set new DMX data with a fixed frame rate.

This function can only be called in master mode.

=cut

sub write_frame_low_level
{
	my ($self, $frame_length, $frame_chunk_offset, $frame_chunk_data) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_WRITE_FRAME_LOW_LEVEL, [$frame_length, $frame_chunk_offset, $frame_chunk_data], 'S S C60', 0, '');
}

=item read_frame_low_level()

Returns the last frame that was written by the DMX master. The size of the array
is equivalent to the number of channels in the frame. Each byte represents one channel.

The next frame is available after the :cb:`Frame Available` callback was called.

Generic approach:

* Call :func:`Read Frame` to get first frame.
* Wait for the :cb:`Frame Available` callback.
* Call :func:`Read Frame` to get second frame.
* Wait for the :cb:`Frame Available` callback.
* and so on.

Instead of polling this function you can also use the :cb:`Frame` callback.
You can enable it with :func:`Set Frame Callback Config`.

The frame number starts at 0 and it is increased by one with each received frame.

This function can only be called in slave mode.

=cut

sub read_frame_low_level
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_READ_FRAME_LOW_LEVEL, [], '', 72, 'S S C56 L');
}

=item set_frame_duration()

Sets the duration of a frame.

Example: If you want to achieve 20 frames per second, you should
set the frame duration to 50ms (50ms * 20 = 1 second).

If you always want to send a frame as fast as possible you can set
this value to 0.

This setting is only used in master mode.

=cut

sub set_frame_duration
{
	my ($self, $frame_duration) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_SET_FRAME_DURATION, [$frame_duration], 'S', 0, '');
}

=item get_frame_duration()

Returns the frame duration as set by :func:`Set Frame Duration`.

=cut

sub get_frame_duration
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_FRAME_DURATION, [], '', 10, 'S');
}

=item get_frame_error_count()

Returns the current number of overrun and framing errors.

=cut

sub get_frame_error_count
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_FRAME_ERROR_COUNT, [], '', 16, 'L L');
}

=item set_communication_led_config()

Sets the communication LED configuration. By default the LED shows
communication traffic, it flickers once for every 10 received data packets.

You can also turn the LED permanently on/off or show a heartbeat.

If the Bricklet is in bootloader mode, the LED is off.

=cut

sub set_communication_led_config
{
	my ($self, $config) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_SET_COMMUNICATION_LED_CONFIG, [$config], 'C', 0, '');
}

=item get_communication_led_config()

Returns the configuration as set by :func:`Set Communication LED Config`

=cut

sub get_communication_led_config
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_COMMUNICATION_LED_CONFIG, [], '', 9, 'C');
}

=item set_error_led_config()

Sets the error LED configuration.

By default the error LED turns on if there is any error (see :cb:`Frame Error Count`
callback). If you call this function with the Show-Error option again, the LED
will turn off until the next error occurs.

You can also turn the LED permanently on/off or show a heartbeat.

If the Bricklet is in bootloader mode, the LED is off.

=cut

sub set_error_led_config
{
	my ($self, $config) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_SET_ERROR_LED_CONFIG, [$config], 'C', 0, '');
}

=item get_error_led_config()

Returns the configuration as set by :func:`Set Error LED Config`.

=cut

sub get_error_led_config
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_ERROR_LED_CONFIG, [], '', 9, 'C');
}

=item set_frame_callback_config()

Enables/Disables the different callbacks. By default the
:cb:`Frame Started` callback and :cb:`Frame Available` callback are enabled while
the :cb:`Frame` callback and :cb:`Frame Error Count` callback are disabled.

If you want to use the :cb:`Frame` callback you can enable it and disable
the cb:`Frame Available` callback at the same time. It becomes redundant in
this case.

=cut

sub set_frame_callback_config
{
	my ($self, $frame_started_callback_enabled, $frame_available_callback_enabled, $frame_callback_enabled, $frame_error_count_callback_enabled) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_SET_FRAME_CALLBACK_CONFIG, [$frame_started_callback_enabled, $frame_available_callback_enabled, $frame_callback_enabled, $frame_error_count_callback_enabled], '? ? ? ?', 0, '');
}

=item get_frame_callback_config()

Returns the frame callback config as set by :func:`Set Frame Callback Config`.

=cut

sub get_frame_callback_config
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_FRAME_CALLBACK_CONFIG, [], '', 12, '? ? ? ?');
}

=item get_spitfp_error_count()

Returns the error count for the communication between Brick and Bricklet.

The errors are divided into

* ACK checksum errors,
* message checksum errors,
* framing errors and
* overflow errors.

The errors counts are for errors that occur on the Bricklet side. All
Bricks have a similar function that returns the errors on the Brick side.

=cut

sub get_spitfp_error_count
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_SPITFP_ERROR_COUNT, [], '', 24, 'L L L L');
}

=item set_bootloader_mode()

Sets the bootloader mode and returns the status after the requested
mode change was instigated.

You can change from bootloader mode to firmware mode and vice versa. A change
from bootloader mode to firmware mode will only take place if the entry function,
device identifier and CRC are present and correct.

This function is used by Brick Viewer during flashing. It should not be
necessary to call it in a normal user program.

=cut

sub set_bootloader_mode
{
	my ($self, $mode) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_SET_BOOTLOADER_MODE, [$mode], 'C', 9, 'C');
}

=item get_bootloader_mode()

Returns the current bootloader mode, see :func:`Set Bootloader Mode`.

=cut

sub get_bootloader_mode
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_BOOTLOADER_MODE, [], '', 9, 'C');
}

=item set_write_firmware_pointer()

Sets the firmware pointer for :func:`Write Firmware`. The pointer has
to be increased by chunks of size 64. The data is written to flash
every 4 chunks (which equals to one page of size 256).

This function is used by Brick Viewer during flashing. It should not be
necessary to call it in a normal user program.

=cut

sub set_write_firmware_pointer
{
	my ($self, $pointer) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_SET_WRITE_FIRMWARE_POINTER, [$pointer], 'L', 0, '');
}

=item write_firmware()

Writes 64 Bytes of firmware at the position as written by
:func:`Set Write Firmware Pointer` before. The firmware is written
to flash every 4 chunks.

You can only write firmware in bootloader mode.

This function is used by Brick Viewer during flashing. It should not be
necessary to call it in a normal user program.

=cut

sub write_firmware
{
	my ($self, $data) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_WRITE_FIRMWARE, [$data], 'C64', 9, 'C');
}

=item set_status_led_config()

Sets the status LED configuration. By default the LED shows
communication traffic between Brick and Bricklet, it flickers once
for every 10 received data packets.

You can also turn the LED permanently on/off or show a heartbeat.

If the Bricklet is in bootloader mode, the LED is will show heartbeat by default.

=cut

sub set_status_led_config
{
	my ($self, $config) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_SET_STATUS_LED_CONFIG, [$config], 'C', 0, '');
}

=item get_status_led_config()

Returns the configuration as set by :func:`Set Status LED Config`

=cut

sub get_status_led_config
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_STATUS_LED_CONFIG, [], '', 9, 'C');
}

=item get_chip_temperature()

Returns the temperature as measured inside the microcontroller. The
value returned is not the ambient temperature!

The temperature is only proportional to the real temperature and it has bad
accuracy. Practically it is only useful as an indicator for
temperature changes.

=cut

sub get_chip_temperature
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_CHIP_TEMPERATURE, [], '', 10, 's');
}

=item reset()

Calling this function will reset the Bricklet. All configurations
will be lost.

After a reset you have to create new device objects,
calling functions on the existing ones will result in
undefined behavior!

=cut

sub reset
{
	my ($self) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_RESET, [], '', 0, '');
}

=item write_uid()

Writes a new UID into flash. If you want to set a new UID
you have to decode the Base58 encoded UID string into an
integer first.

We recommend that you use Brick Viewer to change the UID.

=cut

sub write_uid
{
	my ($self, $uid) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_WRITE_UID, [$uid], 'L', 0, '');
}

=item read_uid()

Returns the current UID as an integer. Encode as
Base58 to get the usual string version.

=cut

sub read_uid
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_READ_UID, [], '', 12, 'L');
}

=item get_identity()

Returns the UID, the UID where the Bricklet is connected to,
the position, the hardware and firmware version as well as the
device identifier.

The position can be 'a', 'b', 'c', 'd', 'e', 'f', 'g' or 'h' (Bricklet Port).
The Raspberry Pi HAT (Zero) Brick is always at position 'i' and the Bricklet
connected to an :ref:`Isolator Bricklet <isolator_bricklet>` is always as
position 'z'.

The device identifier numbers can be found :ref:`here <device_identifier>`.
|device_identifier_constant|

=cut

sub get_identity
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_IDENTITY, [], '', 33, 'Z8 Z8 a C3 C3 S');
}

=item write_frame()

Writes a DMX frame. The maximum frame size is 512 byte. Each byte represents one channel.

The next frame can be written after the :cb:`Frame Started` callback was called. The frame
is double buffered, so a new frame can be written as soon as the writing of the prior frame
starts.

The data will be transfered when the next frame duration ends, see :func:`Set Frame Duration`.

Generic approach:

* Set the frame duration to a value that represents the number of frames per second you want to achieve.
* Set channels for first frame.
* Wait for the :cb:`Frame Started` callback.
* Set channels for next frame.
* Wait for the :cb:`Frame Started` callback.
* and so on.

This approach ensures that you can set new DMX data with a fixed frame rate.

This function can only be called in master mode.

=cut

sub write_frame
{
    my ($self, $frame) = @_;

    if(scalar(@{$frame}) > 65535)
    {
        croak(Tinkerforge::Error->_new(Tinkerforge::Error->INVALID_PARAMETER, 'Frame can be at most 65535 items long'));
    }

    my $frame_length = scalar(@{$frame});
    my $frame_chunk_offset = 0;

    if($frame_length == 0)
    {
        my $frame_chunk_data = [0] x 60;

        $self->write_frame_low_level($frame_length, $frame_chunk_offset, $frame_chunk_data);
    }
    else
    {
        lock(${$self->{stream_lock_ref}});

        while($frame_chunk_offset < $frame_length)
        {
            my $frame_chunk_data = [];
            my $frame_chunk_length = $frame_length - $frame_chunk_offset;

            if($frame_chunk_length > 60) {
                $frame_chunk_length = 60;
            }

            for(my $i = 0; $i < $frame_chunk_length; $i++) {
                push(@{$frame_chunk_data}, @{$frame}[$frame_chunk_offset + $i]);
            }

            if(scalar(@{$frame_chunk_data}) < 60)
            {
                push(@{$frame_chunk_data}, (0) x (60 - scalar(@{$frame_chunk_data})));
            }

            $self->write_frame_low_level($frame_length, $frame_chunk_offset, $frame_chunk_data);
            $frame_chunk_offset += 60;
        }
    }
}

=item read_frame()

Returns the last frame that was written by the DMX master. The size of the array
is equivalent to the number of channels in the frame. Each byte represents one channel.

The next frame is available after the :cb:`Frame Available` callback was called.

Generic approach:

* Call :func:`Read Frame` to get first frame.
* Wait for the :cb:`Frame Available` callback.
* Call :func:`Read Frame` to get second frame.
* Wait for the :cb:`Frame Available` callback.
* and so on.

Instead of polling this function you can also use the :cb:`Frame` callback.
You can enable it with :func:`Set Frame Callback Config`.

The frame number starts at 0 and it is increased by one with each received frame.

This function can only be called in slave mode.

=cut

sub read_frame
{
    my ($self) = @_;

    lock(${$self->{stream_lock_ref}});

    my @ret = $self->read_frame_low_level();
    my $frame_length = $ret[0];
    my $frame_chunk_offset = $ret[1];
    my $frame_out_of_sync = $frame_chunk_offset != 0;
    my $frame_data = $ret[2];

    while(!$frame_out_of_sync && scalar(@{$frame_data}) < $frame_length)
    {
        @ret = $self->read_frame_low_level();
        $frame_length = $ret[0];
        $frame_chunk_offset = $ret[1];
        $frame_out_of_sync = $frame_chunk_offset != scalar(@{$frame_data});
        push(@{$frame_data}, @{$ret[2]});
    }

    if($frame_out_of_sync) # discard remaining stream to bring it back in-sync
    {
        while($frame_chunk_offset + 56 < $frame_length)
        {
            @ret = $self->read_frame_low_level();
            $frame_length = $ret[0];
            $frame_chunk_offset = $ret[1];
        }

        croak(Tinkerforge::Error->_new(Tinkerforge::Error->STREAM_OUT_OF_SYNC, 'Frame stream is out-of-sync'));
    }

    splice(@{$frame_data}, $frame_length);

    return ($frame_data, $ret[3]);
}

=back
=cut

1;
