#############################################################
# This file was automatically generated on 2019-06-12.      #
#                                                           #
# Perl Bindings Version 2.1.23                              #
#                                                           #
# If you have a bugfix for this file and want to commit it, #
# please fix the bug in the generator. You can find a link  #
# to the generators git repository on tinkerforge.com       #
#############################################################

=pod

=encoding utf8

=head1 NAME

Tinkerforge::BrickletRGBLEDMatrix - RGB LED Matrix with 8x8 pixel

=cut

package Tinkerforge::BrickletRGBLEDMatrix;

use strict;
use warnings;
use Carp;
use threads;
use threads::shared;
use parent 'Tinkerforge::Device';
use Tinkerforge::IPConnection;
use Tinkerforge::Error;

=head1 CONSTANTS

=over

=item DEVICE_IDENTIFIER

This constant is used to identify a RGB LED Matrix Bricklet.

The get_identity() subroutine and the CALLBACK_ENUMERATE callback of the
IP Connection have a device_identifier parameter to specify the Brick's or
Bricklet's type.

=cut

use constant DEVICE_IDENTIFIER => 272;

=item DEVICE_DISPLAY_NAME

This constant represents the display name of a RGB LED Matrix Bricklet.

=cut

use constant DEVICE_DISPLAY_NAME => 'RGB LED Matrix Bricklet';

=item CALLBACK_FRAME_STARTED

This constant is used with the register_callback() subroutine to specify
the CALLBACK_FRAME_STARTED callback.

=cut

use constant CALLBACK_FRAME_STARTED => 11;

=item FUNCTION_SET_RED

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_RED => 1;

=item FUNCTION_GET_RED

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_RED => 2;

=item FUNCTION_SET_GREEN

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_GREEN => 3;

=item FUNCTION_GET_GREEN

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_GREEN => 4;

=item FUNCTION_SET_BLUE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_BLUE => 5;

=item FUNCTION_GET_BLUE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_BLUE => 6;

=item FUNCTION_SET_FRAME_DURATION

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_FRAME_DURATION => 7;

=item FUNCTION_GET_FRAME_DURATION

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_FRAME_DURATION => 8;

=item FUNCTION_DRAW_FRAME

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_DRAW_FRAME => 9;

=item FUNCTION_GET_SUPPLY_VOLTAGE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_SUPPLY_VOLTAGE => 10;

=item FUNCTION_GET_SPITFP_ERROR_COUNT

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_SPITFP_ERROR_COUNT => 234;

=item FUNCTION_SET_BOOTLOADER_MODE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_BOOTLOADER_MODE => 235;

=item FUNCTION_GET_BOOTLOADER_MODE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_BOOTLOADER_MODE => 236;

=item FUNCTION_SET_WRITE_FIRMWARE_POINTER

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_WRITE_FIRMWARE_POINTER => 237;

=item FUNCTION_WRITE_FIRMWARE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_WRITE_FIRMWARE => 238;

=item FUNCTION_SET_STATUS_LED_CONFIG

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_STATUS_LED_CONFIG => 239;

=item FUNCTION_GET_STATUS_LED_CONFIG

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_STATUS_LED_CONFIG => 240;

=item FUNCTION_GET_CHIP_TEMPERATURE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_CHIP_TEMPERATURE => 242;

=item FUNCTION_RESET

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_RESET => 243;

=item FUNCTION_WRITE_UID

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_WRITE_UID => 248;

=item FUNCTION_READ_UID

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_READ_UID => 249;

=item FUNCTION_GET_IDENTITY

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_IDENTITY => 255;
use constant BOOTLOADER_MODE_BOOTLOADER => 0;
use constant BOOTLOADER_MODE_FIRMWARE => 1;
use constant BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT => 2;
use constant BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT => 3;
use constant BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT => 4;
use constant BOOTLOADER_STATUS_OK => 0;
use constant BOOTLOADER_STATUS_INVALID_MODE => 1;
use constant BOOTLOADER_STATUS_NO_CHANGE => 2;
use constant BOOTLOADER_STATUS_ENTRY_FUNCTION_NOT_PRESENT => 3;
use constant BOOTLOADER_STATUS_DEVICE_IDENTIFIER_INCORRECT => 4;
use constant BOOTLOADER_STATUS_CRC_MISMATCH => 5;
use constant STATUS_LED_CONFIG_OFF => 0;
use constant STATUS_LED_CONFIG_ON => 1;
use constant STATUS_LED_CONFIG_SHOW_HEARTBEAT => 2;
use constant STATUS_LED_CONFIG_SHOW_STATUS => 3;


=back

=head1 FUNCTIONS

=over

=item new()

Creates an object with the unique device ID *uid* and adds it to
the IP Connection *ipcon*.

=cut

sub new
{
	my ($class, $uid, $ipcon) = @_;

	my $self = Tinkerforge::Device->_new($uid, $ipcon, [2, 0, 0]);

	$self->{response_expected}->{&FUNCTION_SET_RED} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_GET_RED} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_GREEN} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_GET_GREEN} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_BLUE} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_GET_BLUE} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_FRAME_DURATION} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_GET_FRAME_DURATION} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_DRAW_FRAME} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_GET_SUPPLY_VOLTAGE} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_SPITFP_ERROR_COUNT} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_BOOTLOADER_MODE} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_BOOTLOADER_MODE} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_WRITE_FIRMWARE_POINTER} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_WRITE_FIRMWARE} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_STATUS_LED_CONFIG} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_GET_STATUS_LED_CONFIG} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_CHIP_TEMPERATURE} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_RESET} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_WRITE_UID} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_READ_UID} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_IDENTITY} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;

	$self->{callback_formats}->{&CALLBACK_FRAME_STARTED} = 'L';



	bless($self, $class);

	return $self;
}


=item set_red()

Sets the 64 red LED values of the matrix.

=cut

sub set_red
{
	my ($self, $red) = @_;

	$self->_send_request(&FUNCTION_SET_RED, [$red], 'C64', '');
}

=item get_red()

Returns the red LED values as set by :func:`Set Red`.

=cut

sub get_red
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_RED, [], '', 'C64');
}

=item set_green()

Sets the 64 green LED values of the matrix.

=cut

sub set_green
{
	my ($self, $green) = @_;

	$self->_send_request(&FUNCTION_SET_GREEN, [$green], 'C64', '');
}

=item get_green()

Returns the green LED values as set by :func:`Set Green`.

=cut

sub get_green
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_GREEN, [], '', 'C64');
}

=item set_blue()

Sets the 64 blue LED values of the matrix.

=cut

sub set_blue
{
	my ($self, $blue) = @_;

	$self->_send_request(&FUNCTION_SET_BLUE, [$blue], 'C64', '');
}

=item get_blue()

Returns the blue LED values as set by :func:`Set Blue`.

=cut

sub get_blue
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_BLUE, [], '', 'C64');
}

=item set_frame_duration()

Sets the frame duration in ms.

Example: If you want to achieve 20 frames per second, you should
set the frame duration to 50ms (50ms * 20 = 1 second).

Set this value to 0 to turn the automatic frame write mechanism off.

Approach:

* Call :func:`Set Frame Duration` with value > 0.
* Set LED values for first frame with :func:`Set Red`, :func:`Set Green`, :func:`Set Blue`.
* Wait for :cb:`Frame Started` callback.
* Set LED values for second frame with :func:`Set Red`, :func:`Set Green`, :func:`Set Blue`.
* Wait for :cb:`Frame Started` callback.
* and so on.

For frame duration of 0 see :func:`Draw Frame`.

Default value: 0 = off.

=cut

sub set_frame_duration
{
	my ($self, $frame_duration) = @_;

	$self->_send_request(&FUNCTION_SET_FRAME_DURATION, [$frame_duration], 'S', '');
}

=item get_frame_duration()

Returns the frame duration in ms as set by :func:`Set Frame Duration`.

=cut

sub get_frame_duration
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_FRAME_DURATION, [], '', 'S');
}

=item draw_frame()

If you set the frame duration to 0 (see :func:`Set Frame Duration`), you can use this
function to transfer the frame to the matrix.

Approach:

* Call :func:`Set Frame Duration` with 0.
* Set LED values for first frame with :func:`Set Red`, :func:`Set Green`, :func:`Set Blue`.
* Call :func:`Draw Frame`.
* Wait for :cb:`Frame Started` callback.
* Set LED values for second frame with :func:`Set Red`, :func:`Set Green`, :func:`Set Blue`.
* Call :func:`Draw Frame`.
* Wait for :cb:`Frame Started` callback.
* and so on.

=cut

sub draw_frame
{
	my ($self) = @_;

	$self->_send_request(&FUNCTION_DRAW_FRAME, [], '', '');
}

=item get_supply_voltage()

Returns the current supply voltage of the Bricklet. The voltage is given in mV.

=cut

sub get_supply_voltage
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_SUPPLY_VOLTAGE, [], '', 'S');
}

=item get_spitfp_error_count()

Returns the error count for the communication between Brick and Bricklet.

The errors are divided into

* ACK checksum errors,
* message checksum errors,
* framing errors and
* overflow errors.

The errors counts are for errors that occur on the Bricklet side. All
Bricks have a similar function that returns the errors on the Brick side.

=cut

sub get_spitfp_error_count
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_SPITFP_ERROR_COUNT, [], '', 'L L L L');
}

=item set_bootloader_mode()

Sets the bootloader mode and returns the status after the requested
mode change was instigated.

You can change from bootloader mode to firmware mode and vice versa. A change
from bootloader mode to firmware mode will only take place if the entry function,
device identifier and CRC are present and correct.

This function is used by Brick Viewer during flashing. It should not be
necessary to call it in a normal user program.

=cut

sub set_bootloader_mode
{
	my ($self, $mode) = @_;

	return $self->_send_request(&FUNCTION_SET_BOOTLOADER_MODE, [$mode], 'C', 'C');
}

=item get_bootloader_mode()

Returns the current bootloader mode, see :func:`Set Bootloader Mode`.

=cut

sub get_bootloader_mode
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_BOOTLOADER_MODE, [], '', 'C');
}

=item set_write_firmware_pointer()

Sets the firmware pointer for :func:`Write Firmware`. The pointer has
to be increased by chunks of size 64. The data is written to flash
every 4 chunks (which equals to one page of size 256).

This function is used by Brick Viewer during flashing. It should not be
necessary to call it in a normal user program.

=cut

sub set_write_firmware_pointer
{
	my ($self, $pointer) = @_;

	$self->_send_request(&FUNCTION_SET_WRITE_FIRMWARE_POINTER, [$pointer], 'L', '');
}

=item write_firmware()

Writes 64 Bytes of firmware at the position as written by
:func:`Set Write Firmware Pointer` before. The firmware is written
to flash every 4 chunks.

You can only write firmware in bootloader mode.

This function is used by Brick Viewer during flashing. It should not be
necessary to call it in a normal user program.

=cut

sub write_firmware
{
	my ($self, $data) = @_;

	return $self->_send_request(&FUNCTION_WRITE_FIRMWARE, [$data], 'C64', 'C');
}

=item set_status_led_config()

Sets the status LED configuration. By default the LED shows
communication traffic between Brick and Bricklet, it flickers once
for every 10 received data packets.

You can also turn the LED permanently on/off or show a heartbeat.

If the Bricklet is in bootloader mode, the LED is will show heartbeat by default.

=cut

sub set_status_led_config
{
	my ($self, $config) = @_;

	$self->_send_request(&FUNCTION_SET_STATUS_LED_CONFIG, [$config], 'C', '');
}

=item get_status_led_config()

Returns the configuration as set by :func:`Set Status LED Config`

=cut

sub get_status_led_config
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_STATUS_LED_CONFIG, [], '', 'C');
}

=item get_chip_temperature()

Returns the temperature in °C as measured inside the microcontroller. The
value returned is not the ambient temperature!

The temperature is only proportional to the real temperature and it has bad
accuracy. Practically it is only useful as an indicator for
temperature changes.

=cut

sub get_chip_temperature
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_CHIP_TEMPERATURE, [], '', 's');
}

=item reset()

Calling this function will reset the Bricklet. All configurations
will be lost.

After a reset you have to create new device objects,
calling functions on the existing ones will result in
undefined behavior!

=cut

sub reset
{
	my ($self) = @_;

	$self->_send_request(&FUNCTION_RESET, [], '', '');
}

=item write_uid()

Writes a new UID into flash. If you want to set a new UID
you have to decode the Base58 encoded UID string into an
integer first.

We recommend that you use Brick Viewer to change the UID.

=cut

sub write_uid
{
	my ($self, $uid) = @_;

	$self->_send_request(&FUNCTION_WRITE_UID, [$uid], 'L', '');
}

=item read_uid()

Returns the current UID as an integer. Encode as
Base58 to get the usual string version.

=cut

sub read_uid
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_READ_UID, [], '', 'L');
}

=item get_identity()

Returns the UID, the UID where the Bricklet is connected to,
the position, the hardware and firmware version as well as the
device identifier.

The position can be 'a', 'b', 'c' or 'd'.

The device identifier numbers can be found :ref:`here <device_identifier>`.
|device_identifier_constant|

=cut

sub get_identity
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_IDENTITY, [], '', 'Z8 Z8 a C3 C3 S');
}

=back
=cut

1;
