#############################################################
# This file was automatically generated on 2019-01-29.      #
#                                                           #
# Perl Bindings Version 2.1.21                              #
#                                                           #
# If you have a bugfix for this file and want to commit it, #
# please fix the bug in the generator. You can find a link  #
# to the generators git repository on tinkerforge.com       #
#############################################################

=pod

=encoding utf8

=head1 NAME

Tinkerforge::BrickletLCD128x64 - 7.1cm (2.8") display with 128x64 pixel and touch screen

=cut

package Tinkerforge::BrickletLCD128x64;

use strict;
use warnings;
use Carp;
use threads;
use threads::shared;
use parent 'Tinkerforge::Device';
use Tinkerforge::IPConnection;
use Tinkerforge::Error;

=head1 CONSTANTS

=over

=item DEVICE_IDENTIFIER

This constant is used to identify a LCD 128x64 Bricklet.

The get_identity() subroutine and the CALLBACK_ENUMERATE callback of the
IP Connection have a device_identifier parameter to specify the Brick's or
Bricklet's type.

=cut

use constant DEVICE_IDENTIFIER => 298;

=item DEVICE_DISPLAY_NAME

This constant represents the display name of a LCD 128x64 Bricklet.

=cut

use constant DEVICE_DISPLAY_NAME => 'LCD 128x64 Bricklet';

=item CALLBACK_TOUCH_POSITION

This constant is used with the register_callback() subroutine to specify
the CALLBACK_TOUCH_POSITION callback.

=cut

use constant CALLBACK_TOUCH_POSITION => 11;

=item CALLBACK_TOUCH_GESTURE

This constant is used with the register_callback() subroutine to specify
the CALLBACK_TOUCH_GESTURE callback.

=cut

use constant CALLBACK_TOUCH_GESTURE => 15;

=item CALLBACK_GUI_BUTTON_PRESSED

This constant is used with the register_callback() subroutine to specify
the CALLBACK_GUI_BUTTON_PRESSED callback.

=cut

use constant CALLBACK_GUI_BUTTON_PRESSED => 25;

=item CALLBACK_GUI_SLIDER_VALUE

This constant is used with the register_callback() subroutine to specify
the CALLBACK_GUI_SLIDER_VALUE callback.

=cut

use constant CALLBACK_GUI_SLIDER_VALUE => 32;

=item CALLBACK_GUI_TAB_SELECTED

This constant is used with the register_callback() subroutine to specify
the CALLBACK_GUI_TAB_SELECTED callback.

=cut

use constant CALLBACK_GUI_TAB_SELECTED => 44;

=item FUNCTION_WRITE_PIXELS_LOW_LEVEL

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_WRITE_PIXELS_LOW_LEVEL => 1;

=item FUNCTION_READ_PIXELS_LOW_LEVEL

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_READ_PIXELS_LOW_LEVEL => 2;

=item FUNCTION_CLEAR_DISPLAY

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_CLEAR_DISPLAY => 3;

=item FUNCTION_SET_DISPLAY_CONFIGURATION

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_DISPLAY_CONFIGURATION => 4;

=item FUNCTION_GET_DISPLAY_CONFIGURATION

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_DISPLAY_CONFIGURATION => 5;

=item FUNCTION_WRITE_LINE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_WRITE_LINE => 6;

=item FUNCTION_DRAW_BUFFERED_FRAME

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_DRAW_BUFFERED_FRAME => 7;

=item FUNCTION_GET_TOUCH_POSITION

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_TOUCH_POSITION => 8;

=item FUNCTION_SET_TOUCH_POSITION_CALLBACK_CONFIGURATION

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_TOUCH_POSITION_CALLBACK_CONFIGURATION => 9;

=item FUNCTION_GET_TOUCH_POSITION_CALLBACK_CONFIGURATION

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_TOUCH_POSITION_CALLBACK_CONFIGURATION => 10;

=item FUNCTION_GET_TOUCH_GESTURE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_TOUCH_GESTURE => 12;

=item FUNCTION_SET_TOUCH_GESTURE_CALLBACK_CONFIGURATION

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_TOUCH_GESTURE_CALLBACK_CONFIGURATION => 13;

=item FUNCTION_GET_TOUCH_GESTURE_CALLBACK_CONFIGURATION

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_TOUCH_GESTURE_CALLBACK_CONFIGURATION => 14;

=item FUNCTION_DRAW_LINE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_DRAW_LINE => 16;

=item FUNCTION_DRAW_BOX

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_DRAW_BOX => 17;

=item FUNCTION_DRAW_TEXT

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_DRAW_TEXT => 18;

=item FUNCTION_SET_GUI_BUTTON

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_GUI_BUTTON => 19;

=item FUNCTION_GET_GUI_BUTTON

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_GUI_BUTTON => 20;

=item FUNCTION_REMOVE_GUI_BUTTON

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_REMOVE_GUI_BUTTON => 21;

=item FUNCTION_SET_GUI_BUTTON_PRESSED_CALLBACK_CONFIGURATION

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_GUI_BUTTON_PRESSED_CALLBACK_CONFIGURATION => 22;

=item FUNCTION_GET_GUI_BUTTON_PRESSED_CALLBACK_CONFIGURATION

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_GUI_BUTTON_PRESSED_CALLBACK_CONFIGURATION => 23;

=item FUNCTION_GET_GUI_BUTTON_PRESSED

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_GUI_BUTTON_PRESSED => 24;

=item FUNCTION_SET_GUI_SLIDER

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_GUI_SLIDER => 26;

=item FUNCTION_GET_GUI_SLIDER

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_GUI_SLIDER => 27;

=item FUNCTION_REMOVE_GUI_SLIDER

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_REMOVE_GUI_SLIDER => 28;

=item FUNCTION_SET_GUI_SLIDER_VALUE_CALLBACK_CONFIGURATION

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_GUI_SLIDER_VALUE_CALLBACK_CONFIGURATION => 29;

=item FUNCTION_GET_GUI_SLIDER_VALUE_CALLBACK_CONFIGURATION

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_GUI_SLIDER_VALUE_CALLBACK_CONFIGURATION => 30;

=item FUNCTION_GET_GUI_SLIDER_VALUE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_GUI_SLIDER_VALUE => 31;

=item FUNCTION_SET_GUI_TAB_CONFIGURATION

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_GUI_TAB_CONFIGURATION => 33;

=item FUNCTION_GET_GUI_TAB_CONFIGURATION

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_GUI_TAB_CONFIGURATION => 34;

=item FUNCTION_SET_GUI_TAB_TEXT

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_GUI_TAB_TEXT => 35;

=item FUNCTION_GET_GUI_TAB_TEXT

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_GUI_TAB_TEXT => 36;

=item FUNCTION_SET_GUI_TAB_ICON

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_GUI_TAB_ICON => 37;

=item FUNCTION_GET_GUI_TAB_ICON

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_GUI_TAB_ICON => 38;

=item FUNCTION_REMOVE_GUI_TAB

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_REMOVE_GUI_TAB => 39;

=item FUNCTION_SET_GUI_TAB_SELECTED

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_GUI_TAB_SELECTED => 40;

=item FUNCTION_SET_GUI_TAB_SELECTED_CALLBACK_CONFIGURATION

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_GUI_TAB_SELECTED_CALLBACK_CONFIGURATION => 41;

=item FUNCTION_GET_GUI_TAB_SELECTED_CALLBACK_CONFIGURATION

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_GUI_TAB_SELECTED_CALLBACK_CONFIGURATION => 42;

=item FUNCTION_GET_GUI_TAB_SELECTED

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_GUI_TAB_SELECTED => 43;

=item FUNCTION_SET_GUI_GRAPH_CONFIGURATION

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_GUI_GRAPH_CONFIGURATION => 45;

=item FUNCTION_GET_GUI_GRAPH_CONFIGURATION

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_GUI_GRAPH_CONFIGURATION => 46;

=item FUNCTION_SET_GUI_GRAPH_DATA_LOW_LEVEL

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_GUI_GRAPH_DATA_LOW_LEVEL => 47;

=item FUNCTION_GET_GUI_GRAPH_DATA_LOW_LEVEL

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_GUI_GRAPH_DATA_LOW_LEVEL => 48;

=item FUNCTION_REMOVE_GUI_GRAPH

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_REMOVE_GUI_GRAPH => 49;

=item FUNCTION_REMOVE_ALL_GUI

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_REMOVE_ALL_GUI => 50;

=item FUNCTION_SET_TOUCH_LED_CONFIG

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_TOUCH_LED_CONFIG => 51;

=item FUNCTION_GET_TOUCH_LED_CONFIG

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_TOUCH_LED_CONFIG => 52;

=item FUNCTION_GET_SPITFP_ERROR_COUNT

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_SPITFP_ERROR_COUNT => 234;

=item FUNCTION_SET_BOOTLOADER_MODE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_BOOTLOADER_MODE => 235;

=item FUNCTION_GET_BOOTLOADER_MODE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_BOOTLOADER_MODE => 236;

=item FUNCTION_SET_WRITE_FIRMWARE_POINTER

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_WRITE_FIRMWARE_POINTER => 237;

=item FUNCTION_WRITE_FIRMWARE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_WRITE_FIRMWARE => 238;

=item FUNCTION_SET_STATUS_LED_CONFIG

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_STATUS_LED_CONFIG => 239;

=item FUNCTION_GET_STATUS_LED_CONFIG

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_STATUS_LED_CONFIG => 240;

=item FUNCTION_GET_CHIP_TEMPERATURE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_CHIP_TEMPERATURE => 242;

=item FUNCTION_RESET

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_RESET => 243;

=item FUNCTION_WRITE_UID

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_WRITE_UID => 248;

=item FUNCTION_READ_UID

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_READ_UID => 249;

=item FUNCTION_GET_IDENTITY

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_IDENTITY => 255;
use constant GESTURE_LEFT_TO_RIGHT => 0;
use constant GESTURE_RIGHT_TO_LEFT => 1;
use constant GESTURE_TOP_TO_BOTTOM => 2;
use constant GESTURE_BOTTOM_TO_TOP => 3;
use constant COLOR_WHITE => 0;
use constant COLOR_BLACK => 1;
use constant FONT_6X8 => 0;
use constant FONT_6X16 => 1;
use constant FONT_6X24 => 2;
use constant FONT_6X32 => 3;
use constant FONT_12X16 => 4;
use constant FONT_12X24 => 5;
use constant FONT_12X32 => 6;
use constant FONT_18X24 => 7;
use constant FONT_18X32 => 8;
use constant FONT_24X32 => 9;
use constant DIRECTION_HORIZONTAL => 0;
use constant DIRECTION_VERTICAL => 1;
use constant CHANGE_TAB_ON_CLICK => 1;
use constant CHANGE_TAB_ON_SWIPE => 2;
use constant CHANGE_TAB_ON_CLICK_AND_SWIPE => 3;
use constant GRAPH_TYPE_DOT => 0;
use constant GRAPH_TYPE_LINE => 1;
use constant GRAPH_TYPE_BAR => 2;
use constant TOUCH_LED_CONFIG_OFF => 0;
use constant TOUCH_LED_CONFIG_ON => 1;
use constant TOUCH_LED_CONFIG_SHOW_HEARTBEAT => 2;
use constant TOUCH_LED_CONFIG_SHOW_TOUCH => 3;
use constant BOOTLOADER_MODE_BOOTLOADER => 0;
use constant BOOTLOADER_MODE_FIRMWARE => 1;
use constant BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT => 2;
use constant BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT => 3;
use constant BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT => 4;
use constant BOOTLOADER_STATUS_OK => 0;
use constant BOOTLOADER_STATUS_INVALID_MODE => 1;
use constant BOOTLOADER_STATUS_NO_CHANGE => 2;
use constant BOOTLOADER_STATUS_ENTRY_FUNCTION_NOT_PRESENT => 3;
use constant BOOTLOADER_STATUS_DEVICE_IDENTIFIER_INCORRECT => 4;
use constant BOOTLOADER_STATUS_CRC_MISMATCH => 5;
use constant STATUS_LED_CONFIG_OFF => 0;
use constant STATUS_LED_CONFIG_ON => 1;
use constant STATUS_LED_CONFIG_SHOW_HEARTBEAT => 2;
use constant STATUS_LED_CONFIG_SHOW_STATUS => 3;


=back

=head1 FUNCTIONS

=over

=item new()

Creates an object with the unique device ID *uid* and adds it to
the IP Connection *ipcon*.

=cut

sub new
{
	my ($class, $uid, $ipcon) = @_;

	my $self = Tinkerforge::Device->_new($uid, $ipcon, [2, 0, 1]);

	$self->{response_expected}->{&FUNCTION_WRITE_PIXELS_LOW_LEVEL} = Tinkerforge::Device->_RESPONSE_EXPECTED_TRUE;
	$self->{response_expected}->{&FUNCTION_READ_PIXELS_LOW_LEVEL} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_CLEAR_DISPLAY} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_SET_DISPLAY_CONFIGURATION} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_GET_DISPLAY_CONFIGURATION} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_WRITE_LINE} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_DRAW_BUFFERED_FRAME} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_GET_TOUCH_POSITION} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_TOUCH_POSITION_CALLBACK_CONFIGURATION} = Tinkerforge::Device->_RESPONSE_EXPECTED_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_TOUCH_POSITION_CALLBACK_CONFIGURATION} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_TOUCH_GESTURE} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_TOUCH_GESTURE_CALLBACK_CONFIGURATION} = Tinkerforge::Device->_RESPONSE_EXPECTED_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_TOUCH_GESTURE_CALLBACK_CONFIGURATION} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_DRAW_LINE} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_DRAW_BOX} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_DRAW_TEXT} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_SET_GUI_BUTTON} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_GET_GUI_BUTTON} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_REMOVE_GUI_BUTTON} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_SET_GUI_BUTTON_PRESSED_CALLBACK_CONFIGURATION} = Tinkerforge::Device->_RESPONSE_EXPECTED_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_GUI_BUTTON_PRESSED_CALLBACK_CONFIGURATION} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_GUI_BUTTON_PRESSED} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_GUI_SLIDER} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_GET_GUI_SLIDER} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_REMOVE_GUI_SLIDER} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_SET_GUI_SLIDER_VALUE_CALLBACK_CONFIGURATION} = Tinkerforge::Device->_RESPONSE_EXPECTED_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_GUI_SLIDER_VALUE_CALLBACK_CONFIGURATION} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_GUI_SLIDER_VALUE} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_GUI_TAB_CONFIGURATION} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_GET_GUI_TAB_CONFIGURATION} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_GUI_TAB_TEXT} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_GET_GUI_TAB_TEXT} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_GUI_TAB_ICON} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_GET_GUI_TAB_ICON} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_REMOVE_GUI_TAB} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_SET_GUI_TAB_SELECTED} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_SET_GUI_TAB_SELECTED_CALLBACK_CONFIGURATION} = Tinkerforge::Device->_RESPONSE_EXPECTED_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_GUI_TAB_SELECTED_CALLBACK_CONFIGURATION} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_GUI_TAB_SELECTED} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_GUI_GRAPH_CONFIGURATION} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_GET_GUI_GRAPH_CONFIGURATION} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_GUI_GRAPH_DATA_LOW_LEVEL} = Tinkerforge::Device->_RESPONSE_EXPECTED_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_GUI_GRAPH_DATA_LOW_LEVEL} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_REMOVE_GUI_GRAPH} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_REMOVE_ALL_GUI} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_SET_TOUCH_LED_CONFIG} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_GET_TOUCH_LED_CONFIG} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_SPITFP_ERROR_COUNT} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_BOOTLOADER_MODE} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_BOOTLOADER_MODE} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_WRITE_FIRMWARE_POINTER} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_WRITE_FIRMWARE} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_STATUS_LED_CONFIG} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_GET_STATUS_LED_CONFIG} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_CHIP_TEMPERATURE} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_RESET} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_WRITE_UID} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_READ_UID} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_IDENTITY} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;

	$self->{callback_formats}->{&CALLBACK_TOUCH_POSITION} = 'S S S L';
	$self->{callback_formats}->{&CALLBACK_TOUCH_GESTURE} = 'C L S S S S S L';
	$self->{callback_formats}->{&CALLBACK_GUI_BUTTON_PRESSED} = 'C ?';
	$self->{callback_formats}->{&CALLBACK_GUI_SLIDER_VALUE} = 'C C';
	$self->{callback_formats}->{&CALLBACK_GUI_TAB_SELECTED} = 'c';



	bless($self, $class);

	return $self;
}


=item write_pixels_low_level()

Writes pixels to the specified window.

The x-axis goes from 0 to 127 and the y-axis from 0 to 63. The pixels are written
into the window line by line top to bottom and each line is written from left to
right.

If automatic draw is enabled (default) the pixels are directly written to
the screen. Only pixels that have actually changed are updated on the screen,
the rest stays the same.

If automatic draw is disabled the pixels are written to an internal buffer and
the buffer is transferred to the display only after :func:`Draw Buffered Frame`
is called. This can be used to avoid flicker when drawing a complex frame in
multiple steps.

Automatic draw can be configured with the :func:`Set Display Configuration`
function.

=cut

sub write_pixels_low_level
{
	my ($self, $x_start, $y_start, $x_end, $y_end, $pixels_length, $pixels_chunk_offset, $pixels_chunk_data) = @_;

	$self->_send_request(&FUNCTION_WRITE_PIXELS_LOW_LEVEL, [$x_start, $y_start, $x_end, $y_end, $pixels_length, $pixels_chunk_offset, $pixels_chunk_data], 'C C C C S S ?448', '');
}

=item read_pixels_low_level()

Reads pixels from the specified window.

The x-axis goes from 0 to 127 and the y-axis from 0 to 63. The pixels are read
from the window line by line top to bottom and each line is read from left to
right.

If automatic draw is enabled (default) the pixels that are read are always the
same that are shown on the display.

If automatic draw is disabled the pixels are read from the internal buffer
(see :func:`Draw Buffered Frame`).

Automatic draw can be configured with the :func:`Set Display Configuration`
function.

=cut

sub read_pixels_low_level
{
	my ($self, $x_start, $y_start, $x_end, $y_end) = @_;

	return $self->_send_request(&FUNCTION_READ_PIXELS_LOW_LEVEL, [$x_start, $y_start, $x_end, $y_end], 'C C C C', 'S S ?480');
}

=item clear_display()

Clears the complete content of the display.

=cut

sub clear_display
{
	my ($self) = @_;

	$self->_send_request(&FUNCTION_CLEAR_DISPLAY, [], '', '');
}

=item set_display_configuration()

Sets the configuration of the display.

You can set a contrast value from 0 to 63, a backlight intensity value
from 0 to 100 and you can invert the color (white/black) of the display.

If automatic draw is set to *true*, the display is automatically updated with every
call of :func:`Write Pixels` and :func:`Write Line`. If it is set to false, the
changes are written into an internal buffer and only shown on the display after
a call of :func:`Draw Buffered Frame`.

The default values are contrast 14, backlight intensity 100, inverting off
and automatic draw on.

=cut

sub set_display_configuration
{
	my ($self, $contrast, $backlight, $invert, $automatic_draw) = @_;

	$self->_send_request(&FUNCTION_SET_DISPLAY_CONFIGURATION, [$contrast, $backlight, $invert, $automatic_draw], 'C C ? ?', '');
}

=item get_display_configuration()

Returns the configuration as set by :func:`Set Display Configuration`.

=cut

sub get_display_configuration
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_DISPLAY_CONFIGURATION, [], '', 'C C ? ?');
}

=item write_line()

Writes text to a specific line (0 to 7) with a specific position
(0 to 21). The text can have a maximum of 22 characters.

For example: (1, 10, "Hello") will write *Hello* in the middle of the
second line of the display.

The display uses a special 5x7 pixel charset. You can view the characters
of the charset in Brick Viewer.

This function is a 1:1 replacement for the function with the same name
in the LCD 20x4 Bricklet. You can draw text at a specific pixel position
and with different font sizes with the :func:`Draw Text` function.

=cut

sub write_line
{
	my ($self, $line, $position, $text) = @_;

	$self->_send_request(&FUNCTION_WRITE_LINE, [$line, $position, $text], 'C C Z22', '');
}

=item draw_buffered_frame()

Draws the currently buffered frame. Normally each call of :func:`Write Pixels` and
:func:`Write Line` draws directly onto the display. If you turn automatic draw off
(:func:`Set Display Configuration`), the data is written in an internal buffer and
only transferred to the display by calling this function. This can be used to
avoid flicker when drawing a complex frame in multiple steps.

Set the `force complete redraw` to *true* to redraw the whole display
instead of only the changed parts. Normally it should not be necessary to set this to
*true*. It may only become necessary in case of stuck pixels because of errors.

=cut

sub draw_buffered_frame
{
	my ($self, $force_complete_redraw) = @_;

	$self->_send_request(&FUNCTION_DRAW_BUFFERED_FRAME, [$force_complete_redraw], '?', '');
}

=item get_touch_position()

Returns the last valid touch position:

* Pressure: Amount of pressure applied by the user (0-300)
* X: Touch position on x-axis (0-127)
* Y: Touch position on y-axis (0-63)
* Age: Age of touch press in ms (how long ago it was)

=cut

sub get_touch_position
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_TOUCH_POSITION, [], '', 'S S S L');
}

=item set_touch_position_callback_configuration()

The period in ms is the period with which the :cb:`Touch Position` callback
is triggered periodically. A value of 0 turns the callback off.

If the `value has to change`-parameter is set to true, the callback is only
triggered after the value has changed. If the value didn't change within the
period, the callback is triggered immediately on change.

If it is set to false, the callback is continuously triggered with the period,
independent of the value.

The default value is (0, false).

=cut

sub set_touch_position_callback_configuration
{
	my ($self, $period, $value_has_to_change) = @_;

	$self->_send_request(&FUNCTION_SET_TOUCH_POSITION_CALLBACK_CONFIGURATION, [$period, $value_has_to_change], 'L ?', '');
}

=item get_touch_position_callback_configuration()

Returns the callback configuration as set by
:func:`Set Touch Position Callback Configuration`.

=cut

sub get_touch_position_callback_configuration
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_TOUCH_POSITION_CALLBACK_CONFIGURATION, [], '', 'L ?');
}

=item get_touch_gesture()

Returns one of four touch gestures that can be automatically detected by the Bricklet.

The gestures are swipes from left to right, right to left, top to bottom and bottom to top.

Additionally to the gestures a vector with a start and end position of the gesture is
provided. You can use this vector do determine a more exact location of the gesture (e.g.
the swipe from top to bottom was on the left or right part of the screen).

The age parameter corresponds to the age of gesture in ms (how long ago it was).

=cut

sub get_touch_gesture
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_TOUCH_GESTURE, [], '', 'C L S S S S S L');
}

=item set_touch_gesture_callback_configuration()

The period in ms is the period with which the :cb:`Touch Gesture` callback
is triggered periodically. A value of 0 turns the callback off.

If the `value has to change`-parameter is set to true, the callback is only
triggered after the value has changed. If the value didn't change within the
period, the callback is triggered immediately on change.

If it is set to false, the callback is continuously triggered with the period,
independent of the value.

The default value is (0, false).

=cut

sub set_touch_gesture_callback_configuration
{
	my ($self, $period, $value_has_to_change) = @_;

	$self->_send_request(&FUNCTION_SET_TOUCH_GESTURE_CALLBACK_CONFIGURATION, [$period, $value_has_to_change], 'L ?', '');
}

=item get_touch_gesture_callback_configuration()

Returns the callback configuration as set by
:func:`Set Touch Gesture Callback Configuration`.

=cut

sub get_touch_gesture_callback_configuration
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_TOUCH_GESTURE_CALLBACK_CONFIGURATION, [], '', 'L ?');
}

=item draw_line()

Draws a white or black line from (x, y)-start to (x, y)-end.
The x values have to be within the range of 0 to 127 and the y
values have t be within the range of 0 to 63.

.. versionadded:: 2.0.2$nbsp;(Plugin)

=cut

sub draw_line
{
	my ($self, $position_x_start, $position_y_start, $position_x_end, $position_y_end, $color) = @_;

	$self->_send_request(&FUNCTION_DRAW_LINE, [$position_x_start, $position_y_start, $position_x_end, $position_y_end, $color], 'C C C C ?', '');
}

=item draw_box()

Draws a white or black box from (x, y)-start to (x, y)-end.
The x values have to be within the range of 0 to 127 and the y
values have to be within the range of 0 to 63.

If you set fill to true, the box will be filled with the
color. Otherwise only the outline will be drawn.

.. versionadded:: 2.0.2$nbsp;(Plugin)

=cut

sub draw_box
{
	my ($self, $position_x_start, $position_y_start, $position_x_end, $position_y_end, $fill, $color) = @_;

	$self->_send_request(&FUNCTION_DRAW_BOX, [$position_x_start, $position_y_start, $position_x_end, $position_y_end, $fill, $color], 'C C C C ? ?', '');
}

=item draw_text()

Draws a text with up to 22 characters at the pixel position (x, y).

The x values have to be within the range of 0 to 127 and the y
values have to be within the range of 0 to 63.

You can use one of 9 different font sizes and draw the text in white or black.

.. versionadded:: 2.0.2$nbsp;(Plugin)

=cut

sub draw_text
{
	my ($self, $position_x, $position_y, $font, $color, $text) = @_;

	$self->_send_request(&FUNCTION_DRAW_TEXT, [$position_x, $position_y, $font, $color, $text], 'C C C ? Z22', '');
}

=item set_gui_button()

Draws a clickable button at position (x, y) with the given text
of up to 16 characters.

You can use up to 12 buttons (index 0-11).

The x position + width has to be within the range of 1 to 128 and the y
position + height has to be within the range of 1 to 64.

The minimum useful width/height of a button is 3.

You can enable a callback for a button press with
:func:`Set GUI Button Pressed Callback Configuration`. The callback will
be triggered for press and release-events.

The button is drawn in a separate GUI buffer and the button-frame will
always stay on top of the graphics drawn with :func:`Write Pixels`. To
remove the button use :func:`Remove GUI Button`.

If you want an icon instead of text, you can draw the icon inside of the
button with :func:`Write Pixels`.

.. versionadded:: 2.0.2$nbsp;(Plugin)

=cut

sub set_gui_button
{
	my ($self, $index, $position_x, $position_y, $width, $height, $text) = @_;

	$self->_send_request(&FUNCTION_SET_GUI_BUTTON, [$index, $position_x, $position_y, $width, $height, $text], 'C C C C C Z16', '');
}

=item get_gui_button()

Returns the button properties for a given `Index` as set by :func:`Set GUI Button`.

Additionally the `Active` parameter shows if a button is currently active/visible
or not.

.. versionadded:: 2.0.2$nbsp;(Plugin)

=cut

sub get_gui_button
{
	my ($self, $index) = @_;

	return $self->_send_request(&FUNCTION_GET_GUI_BUTTON, [$index], 'C', '? C C C C Z16');
}

=item remove_gui_button()

Removes the button with the given index.

You can use index 255 to remove all buttons.

.. versionadded:: 2.0.2$nbsp;(Plugin)

=cut

sub remove_gui_button
{
	my ($self, $index) = @_;

	$self->_send_request(&FUNCTION_REMOVE_GUI_BUTTON, [$index], 'C', '');
}

=item set_gui_button_pressed_callback_configuration()

The period in ms is the period with which the :cb:`GUI Button Pressed` callback
is triggered periodically. A value of 0 turns the callback off.

If the `value has to change`-parameter is set to true, the callback is only
triggered after the value has changed. If the value didn't change within the
period, the callback is triggered immediately on change.

If it is set to false, the callback is continuously triggered with the period,
independent of the value.

The default value is (0, false).

.. versionadded:: 2.0.2$nbsp;(Plugin)

=cut

sub set_gui_button_pressed_callback_configuration
{
	my ($self, $period, $value_has_to_change) = @_;

	$self->_send_request(&FUNCTION_SET_GUI_BUTTON_PRESSED_CALLBACK_CONFIGURATION, [$period, $value_has_to_change], 'L ?', '');
}

=item get_gui_button_pressed_callback_configuration()

Returns the callback configuration as set by
:func:`Set GUI Button Pressed Callback Configuration`.

.. versionadded:: 2.0.2$nbsp;(Plugin)

=cut

sub get_gui_button_pressed_callback_configuration
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_GUI_BUTTON_PRESSED_CALLBACK_CONFIGURATION, [], '', 'L ?');
}

=item get_gui_button_pressed()

Returns the state of the button for the given index.

The state can either be pressed (true) or released (false).

.. versionadded:: 2.0.2$nbsp;(Plugin)

=cut

sub get_gui_button_pressed
{
	my ($self, $index) = @_;

	return $self->_send_request(&FUNCTION_GET_GUI_BUTTON_PRESSED, [$index], 'C', '?');
}

=item set_gui_slider()

Draws a slider at position (x, y) with the given length.

You can use up to 6 sliders (index 0-5).

If you use the horizontal direction, the x position + length has to be
within the range of 1 to 128 and the y position has to be within
the range of 0 to 46.

If you use the vertical direction, the y position + length has to be
within the range of 1 to 64 and the x position has to be within
the range of 0 to 110.

The minimum length of a slider is 8.

The parameter value is the start-position of the slider, it can
be between 0 and length-8.

You can enable a callback for the slider value with
:func:`Set GUI Slider Value Callback Configuration`.

The slider is drawn in a separate GUI buffer and it will
always stay on top of the graphics drawn with :func:`Write Pixels`. To
remove the button use :func:`Remove GUI Slider`.

.. versionadded:: 2.0.2$nbsp;(Plugin)

=cut

sub set_gui_slider
{
	my ($self, $index, $position_x, $position_y, $length, $direction, $value) = @_;

	$self->_send_request(&FUNCTION_SET_GUI_SLIDER, [$index, $position_x, $position_y, $length, $direction, $value], 'C C C C C C', '');
}

=item get_gui_slider()

Returns the slider properties for a given `Index` as set by :func:`Set GUI Slider`.

Additionally the `Active` parameter shows if a button is currently active/visible
or not.

.. versionadded:: 2.0.2$nbsp;(Plugin)

=cut

sub get_gui_slider
{
	my ($self, $index) = @_;

	return $self->_send_request(&FUNCTION_GET_GUI_SLIDER, [$index], 'C', '? C C C C C');
}

=item remove_gui_slider()

Removes the slider with the given index.

You can use index 255 to remove all slider.

.. versionadded:: 2.0.2$nbsp;(Plugin)

=cut

sub remove_gui_slider
{
	my ($self, $index) = @_;

	$self->_send_request(&FUNCTION_REMOVE_GUI_SLIDER, [$index], 'C', '');
}

=item set_gui_slider_value_callback_configuration()

The period in ms is the period with which the :cb:`GUI Slider Value` callback
is triggered periodically. A value of 0 turns the callback off.

If the `value has to change`-parameter is set to true, the callback is only
triggered after the value has changed. If the value didn't change within the
period, the callback is triggered immediately on change.

If it is set to false, the callback is continuously triggered with the period,
independent of the value.

The default value is (0, false).

.. versionadded:: 2.0.2$nbsp;(Plugin)

=cut

sub set_gui_slider_value_callback_configuration
{
	my ($self, $period, $value_has_to_change) = @_;

	$self->_send_request(&FUNCTION_SET_GUI_SLIDER_VALUE_CALLBACK_CONFIGURATION, [$period, $value_has_to_change], 'L ?', '');
}

=item get_gui_slider_value_callback_configuration()

Returns the callback configuration as set by
:func:`Set GUI Slider Value Callback Configuration`.

.. versionadded:: 2.0.2$nbsp;(Plugin)

=cut

sub get_gui_slider_value_callback_configuration
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_GUI_SLIDER_VALUE_CALLBACK_CONFIGURATION, [], '', 'L ?');
}

=item get_gui_slider_value()

Returns the current slider value for the given index.

.. versionadded:: 2.0.2$nbsp;(Plugin)

=cut

sub get_gui_slider_value
{
	my ($self, $index) = @_;

	return $self->_send_request(&FUNCTION_GET_GUI_SLIDER_VALUE, [$index], 'C', 'C');
}

=item set_gui_tab_configuration()

Sets the general configuration for tabs. You can configure the tabs to only
accept clicks or only swipes (gesture left/right and right/left) or both.

Additionally, if you set `Clear GUI` to true, all of the GUI elements (buttons,
slider, graphs) will automatically be removed on every tab change.

By default click and swipe as well as automatic GUI clear is enabled.

.. versionadded:: 2.0.2$nbsp;(Plugin)

=cut

sub set_gui_tab_configuration
{
	my ($self, $change_tab_config, $clear_gui) = @_;

	$self->_send_request(&FUNCTION_SET_GUI_TAB_CONFIGURATION, [$change_tab_config, $clear_gui], 'C ?', '');
}

=item get_gui_tab_configuration()

Returns the tab configuration as set by :func:`Set GUI Tab Configuration`.

.. versionadded:: 2.0.2$nbsp;(Plugin)

=cut

sub get_gui_tab_configuration
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_GUI_TAB_CONFIGURATION, [], '', 'C ?');
}

=item set_gui_tab_text()

Adds a text-tab with the given index. The text can have a length of up to 5 characters.

You can use up to 10 tabs (index 0-9).

A text-tab with the same index as a icon-tab will overwrite the icon-tab.

.. versionadded:: 2.0.2$nbsp;(Plugin)

=cut

sub set_gui_tab_text
{
	my ($self, $index, $text) = @_;

	$self->_send_request(&FUNCTION_SET_GUI_TAB_TEXT, [$index, $text], 'C Z5', '');
}

=item get_gui_tab_text()

Returns the text for a given index as set by :func:`Set GUI Tab Text`.

Additionally the `Active` parameter shows if the tab is currently active/visible
or not.

.. versionadded:: 2.0.2$nbsp;(Plugin)

=cut

sub get_gui_tab_text
{
	my ($self, $index) = @_;

	return $self->_send_request(&FUNCTION_GET_GUI_TAB_TEXT, [$index], 'C', '? Z5');
}

=item set_gui_tab_icon()

Adds a icon-tab with the given index. The icon can have a width of 28 pixels
with a height of 6 pixels. It is drawn line-by-line from left to right.

You can use up to 10 tabs (index 0-9).

A icon-tab with the same index as a text-tab will overwrite the text-tab.

.. versionadded:: 2.0.2$nbsp;(Plugin)

=cut

sub set_gui_tab_icon
{
	my ($self, $index, $icon) = @_;

	$self->_send_request(&FUNCTION_SET_GUI_TAB_ICON, [$index, $icon], 'C ?168', '');
}

=item get_gui_tab_icon()

Returns the icon for a given index as set by :func:`Set GUI Tab Icon`.

Additionally the `Active` parameter shows if the tab is currently active/visible
or not.

.. versionadded:: 2.0.2$nbsp;(Plugin)

=cut

sub get_gui_tab_icon
{
	my ($self, $index) = @_;

	return $self->_send_request(&FUNCTION_GET_GUI_TAB_ICON, [$index], 'C', '? ?168');
}

=item remove_gui_tab()

Removes the tab with the given index.

You can use index 255 to remove all tabs.

.. versionadded:: 2.0.2$nbsp;(Plugin)

=cut

sub remove_gui_tab
{
	my ($self, $index) = @_;

	$self->_send_request(&FUNCTION_REMOVE_GUI_TAB, [$index], 'C', '');
}

=item set_gui_tab_selected()

Sets the tab with the given index as selected (drawn as selected on the display).

.. versionadded:: 2.0.2$nbsp;(Plugin)

=cut

sub set_gui_tab_selected
{
	my ($self, $index) = @_;

	$self->_send_request(&FUNCTION_SET_GUI_TAB_SELECTED, [$index], 'C', '');
}

=item set_gui_tab_selected_callback_configuration()

The period in ms is the period with which the :cb:`GUI Tab Selected` callback
is triggered periodically. A value of 0 turns the callback off.

If the `value has to change`-parameter is set to true, the callback is only
triggered after the value has changed. If the value didn't change within the
period, the callback is triggered immediately on change.

If it is set to false, the callback is continuously triggered with the period,
independent of the value.

The default value is (0, false).

.. versionadded:: 2.0.2$nbsp;(Plugin)

=cut

sub set_gui_tab_selected_callback_configuration
{
	my ($self, $period, $value_has_to_change) = @_;

	$self->_send_request(&FUNCTION_SET_GUI_TAB_SELECTED_CALLBACK_CONFIGURATION, [$period, $value_has_to_change], 'L ?', '');
}

=item get_gui_tab_selected_callback_configuration()

Returns the callback configuration as set by
:func:`Set GUI Tab Selected Callback Configuration`.

.. versionadded:: 2.0.2$nbsp;(Plugin)

=cut

sub get_gui_tab_selected_callback_configuration
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_GUI_TAB_SELECTED_CALLBACK_CONFIGURATION, [], '', 'L ?');
}

=item get_gui_tab_selected()

Returns the index of the currently selected tab.
If there are not tabs, the returned index is -1.

.. versionadded:: 2.0.2$nbsp;(Plugin)

=cut

sub get_gui_tab_selected
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_GUI_TAB_SELECTED, [], '', 'c');
}

=item set_gui_graph_configuration()

Sets the configuration for up to four graphs (index 0-3).

The graph type can be dot-, line- or bar-graph.

The x and y position are pixel positions. They have to be within
the range of (0, 0) to (127, 63). The maximum width is 118 and the
maximum height is 63.

You can add a text for the x and y axis with at most 4 characters each.
The text is drawn at the inside of the graph and it can overwrite some
of the graph data. If you need the text outside of the graph you can
leave this text here empty and use :func:`Draw Text` to draw the caption
outside of the graph.

The data of the graph can be set and updated with :func:`Set GUI Graph Data`.

The graph is drawn in a separate GUI buffer and the graph-frame and data will
always stay on top of the graphics drawn with :func:`Write Pixels`. To
remove the graph use :func:`Remove GUI Graph`.

.. versionadded:: 2.0.2$nbsp;(Plugin)

=cut

sub set_gui_graph_configuration
{
	my ($self, $index, $graph_type, $position_x, $position_y, $width, $height, $text_x, $text_y) = @_;

	$self->_send_request(&FUNCTION_SET_GUI_GRAPH_CONFIGURATION, [$index, $graph_type, $position_x, $position_y, $width, $height, $text_x, $text_y], 'C C C C C C Z4 Z4', '');
}

=item get_gui_graph_configuration()

Returns the graph properties for a given `Index` as set by :func:`Set GUI Graph Configuration`.

Additionally the `Active` parameter shows if a graph is currently active/visible
or not.

.. versionadded:: 2.0.2$nbsp;(Plugin)

=cut

sub get_gui_graph_configuration
{
	my ($self, $index) = @_;

	return $self->_send_request(&FUNCTION_GET_GUI_GRAPH_CONFIGURATION, [$index], 'C', '? C C C C C Z4 Z4');
}

=item set_gui_graph_data_low_level()

Sets the data for a graph with the given index. You have to configure the graph with
:func:`Set GUI Graph Configuration` before you can set the first data.

The graph will show the first n values of the data that you set, where
n is the width set with :func:`Set GUI Graph Configuration`. If you set
less then n values it will show the rest of the values as zero.

The maximum number of data-points you can set is 118 (which also corresponds to the
maximum width of the graph).

You have to scale your values to be between 0 and 255. 0 will be shown
at the bottom of the graph and 255 at the top.

.. versionadded:: 2.0.2$nbsp;(Plugin)

=cut

sub set_gui_graph_data_low_level
{
	my ($self, $index, $data_length, $data_chunk_offset, $data_chunk_data) = @_;

	$self->_send_request(&FUNCTION_SET_GUI_GRAPH_DATA_LOW_LEVEL, [$index, $data_length, $data_chunk_offset, $data_chunk_data], 'C S S C59', '');
}

=item get_gui_graph_data_low_level()

Returns the graph data for a given index as set by :func:`Set GUI Graph Data`.

.. versionadded:: 2.0.2$nbsp;(Plugin)

=cut

sub get_gui_graph_data_low_level
{
	my ($self, $index) = @_;

	return $self->_send_request(&FUNCTION_GET_GUI_GRAPH_DATA_LOW_LEVEL, [$index], 'C', 'S S C59');
}

=item remove_gui_graph()

Removes the graph with the given index.

You can use index 255 to remove all graphs.

.. versionadded:: 2.0.2$nbsp;(Plugin)

=cut

sub remove_gui_graph
{
	my ($self, $index) = @_;

	$self->_send_request(&FUNCTION_REMOVE_GUI_GRAPH, [$index], 'C', '');
}

=item remove_all_gui()

Removes all GUI elements (buttons, slider, graphs, tabs).

.. versionadded:: 2.0.2$nbsp;(Plugin)

=cut

sub remove_all_gui
{
	my ($self) = @_;

	$self->_send_request(&FUNCTION_REMOVE_ALL_GUI, [], '', '');
}

=item set_touch_led_config()

Sets the touch LED configuration. By default the LED is on if the
LCD is touched.

You can also turn the LED permanently on/off or show a heartbeat.

If the Bricklet is in bootloader mode, the LED is off.

.. versionadded:: 2.0.2$nbsp;(Plugin)

=cut

sub set_touch_led_config
{
	my ($self, $config) = @_;

	$self->_send_request(&FUNCTION_SET_TOUCH_LED_CONFIG, [$config], 'C', '');
}

=item get_touch_led_config()

Returns the configuration as set by :func:`Set Touch LED Config`

.. versionadded:: 2.0.2$nbsp;(Plugin)

=cut

sub get_touch_led_config
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_TOUCH_LED_CONFIG, [], '', 'C');
}

=item get_spitfp_error_count()

Returns the error count for the communication between Brick and Bricklet.

The errors are divided into

* ACK checksum errors,
* message checksum errors,
* framing errors and
* overflow errors.

The errors counts are for errors that occur on the Bricklet side. All
Bricks have a similar function that returns the errors on the Brick side.

=cut

sub get_spitfp_error_count
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_SPITFP_ERROR_COUNT, [], '', 'L L L L');
}

=item set_bootloader_mode()

Sets the bootloader mode and returns the status after the requested
mode change was instigated.

You can change from bootloader mode to firmware mode and vice versa. A change
from bootloader mode to firmware mode will only take place if the entry function,
device identifier and CRC are present and correct.

This function is used by Brick Viewer during flashing. It should not be
necessary to call it in a normal user program.

=cut

sub set_bootloader_mode
{
	my ($self, $mode) = @_;

	return $self->_send_request(&FUNCTION_SET_BOOTLOADER_MODE, [$mode], 'C', 'C');
}

=item get_bootloader_mode()

Returns the current bootloader mode, see :func:`Set Bootloader Mode`.

=cut

sub get_bootloader_mode
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_BOOTLOADER_MODE, [], '', 'C');
}

=item set_write_firmware_pointer()

Sets the firmware pointer for :func:`Write Firmware`. The pointer has
to be increased by chunks of size 64. The data is written to flash
every 4 chunks (which equals to one page of size 256).

This function is used by Brick Viewer during flashing. It should not be
necessary to call it in a normal user program.

=cut

sub set_write_firmware_pointer
{
	my ($self, $pointer) = @_;

	$self->_send_request(&FUNCTION_SET_WRITE_FIRMWARE_POINTER, [$pointer], 'L', '');
}

=item write_firmware()

Writes 64 Bytes of firmware at the position as written by
:func:`Set Write Firmware Pointer` before. The firmware is written
to flash every 4 chunks.

You can only write firmware in bootloader mode.

This function is used by Brick Viewer during flashing. It should not be
necessary to call it in a normal user program.

=cut

sub write_firmware
{
	my ($self, $data) = @_;

	return $self->_send_request(&FUNCTION_WRITE_FIRMWARE, [$data], 'C64', 'C');
}

=item set_status_led_config()

Sets the status LED configuration. By default the LED shows
communication traffic between Brick and Bricklet, it flickers once
for every 10 received data packets.

You can also turn the LED permanently on/off or show a heartbeat.

If the Bricklet is in bootloader mode, the LED is will show heartbeat by default.

=cut

sub set_status_led_config
{
	my ($self, $config) = @_;

	$self->_send_request(&FUNCTION_SET_STATUS_LED_CONFIG, [$config], 'C', '');
}

=item get_status_led_config()

Returns the configuration as set by :func:`Set Status LED Config`

=cut

sub get_status_led_config
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_STATUS_LED_CONFIG, [], '', 'C');
}

=item get_chip_temperature()

Returns the temperature in °C as measured inside the microcontroller. The
value returned is not the ambient temperature!

The temperature is only proportional to the real temperature and it has bad
accuracy. Practically it is only useful as an indicator for
temperature changes.

=cut

sub get_chip_temperature
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_CHIP_TEMPERATURE, [], '', 's');
}

=item reset()

Calling this function will reset the Bricklet. All configurations
will be lost.

After a reset you have to create new device objects,
calling functions on the existing ones will result in
undefined behavior!

=cut

sub reset
{
	my ($self) = @_;

	$self->_send_request(&FUNCTION_RESET, [], '', '');
}

=item write_uid()

Writes a new UID into flash. If you want to set a new UID
you have to decode the Base58 encoded UID string into an
integer first.

We recommend that you use Brick Viewer to change the UID.

=cut

sub write_uid
{
	my ($self, $uid) = @_;

	$self->_send_request(&FUNCTION_WRITE_UID, [$uid], 'L', '');
}

=item read_uid()

Returns the current UID as an integer. Encode as
Base58 to get the usual string version.

=cut

sub read_uid
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_READ_UID, [], '', 'L');
}

=item get_identity()

Returns the UID, the UID where the Bricklet is connected to,
the position, the hardware and firmware version as well as the
device identifier.

The position can be 'a', 'b', 'c' or 'd'.

The device identifier numbers can be found :ref:`here <device_identifier>`.
|device_identifier_constant|

=cut

sub get_identity
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_IDENTITY, [], '', 'Z8 Z8 a C3 C3 S');
}

=item write_pixels()

Writes pixels to the specified window.

The x-axis goes from 0 to 127 and the y-axis from 0 to 63. The pixels are written
into the window line by line top to bottom and each line is written from left to
right.

If automatic draw is enabled (default) the pixels are directly written to
the screen. Only pixels that have actually changed are updated on the screen,
the rest stays the same.

If automatic draw is disabled the pixels are written to an internal buffer and
the buffer is transferred to the display only after :func:`Draw Buffered Frame`
is called. This can be used to avoid flicker when drawing a complex frame in
multiple steps.

Automatic draw can be configured with the :func:`Set Display Configuration`
function.

=cut

sub write_pixels
{
    my ($self, $x_start, $y_start, $x_end, $y_end, $pixels) = @_;

    if(scalar(@{$pixels}) > 65535)
    {
        croak(Tinkerforge::Error->_new(Tinkerforge::Error->INVALID_PARAMETER, 'Pixels can be at most 65535 items long'));
    }

    my $pixels_length = scalar(@{$pixels});
    my $pixels_chunk_offset = 0;

    if($pixels_length == 0)
    {
        my $pixels_chunk_data = [0] x 448;

        $self->write_pixels_low_level($x_start, $y_start, $x_end, $y_end, $pixels_length, $pixels_chunk_offset, $pixels_chunk_data);
    }
    else
    {
        lock(${$self->{stream_lock_ref}});

        while($pixels_chunk_offset < $pixels_length)
        {
            my $pixels_chunk_data = [];
            my $pixels_chunk_length = $pixels_length - $pixels_chunk_offset;

            if($pixels_chunk_length > 448) {
                $pixels_chunk_length = 448;
            }

            for(my $i = 0; $i < $pixels_chunk_length; $i++) {
                push(@{$pixels_chunk_data}, @{$pixels}[$pixels_chunk_offset + $i]);
            }

            if(scalar(@{$pixels_chunk_data}) < 448)
            {
                push(@{$pixels_chunk_data}, (0) x (448 - scalar(@{$pixels_chunk_data})));
            }

            $self->write_pixels_low_level($x_start, $y_start, $x_end, $y_end, $pixels_length, $pixels_chunk_offset, $pixels_chunk_data);
            $pixels_chunk_offset += 448;
        }
    }
}

=item read_pixels()

Reads pixels from the specified window.

The x-axis goes from 0 to 127 and the y-axis from 0 to 63. The pixels are read
from the window line by line top to bottom and each line is read from left to
right.

If automatic draw is enabled (default) the pixels that are read are always the
same that are shown on the display.

If automatic draw is disabled the pixels are read from the internal buffer
(see :func:`Draw Buffered Frame`).

Automatic draw can be configured with the :func:`Set Display Configuration`
function.

=cut

sub read_pixels
{
    my ($self, $x_start, $y_start, $x_end, $y_end) = @_;

    lock(${$self->{stream_lock_ref}});

    my @ret = $self->read_pixels_low_level($x_start, $y_start, $x_end, $y_end);
    my $pixels_length = $ret[0];
    my $pixels_chunk_offset = $ret[1];
    my $pixels_out_of_sync = $pixels_chunk_offset != 0;
    my $pixels_data = $ret[2];

    while(!$pixels_out_of_sync && scalar(@{$pixels_data}) < $pixels_length)
    {
        @ret = $self->read_pixels_low_level($x_start, $y_start, $x_end, $y_end);
        $pixels_length = $ret[0];
        $pixels_chunk_offset = $ret[1];
        $pixels_out_of_sync = $pixels_chunk_offset != scalar(@{$pixels_data});
        push(@{$pixels_data}, @{$ret[2]});
    }

    if($pixels_out_of_sync) # discard remaining stream to bring it back in-sync
    {
        while($pixels_chunk_offset + 480 < $pixels_length)
        {
            @ret = $self->read_pixels_low_level($x_start, $y_start, $x_end, $y_end);
            $pixels_length = $ret[0];
            $pixels_chunk_offset = $ret[1];
        }

        croak(Tinkerforge::Error->_new(Tinkerforge::Error->STREAM_OUT_OF_SYNC, 'Pixels stream is out-of-sync'));
    }

    splice(@{$pixels_data}, $pixels_length);

    return $pixels_data;
}

=item set_gui_graph_data()

Sets the data for a graph with the given index. You have to configure the graph with
:func:`Set GUI Graph Configuration` before you can set the first data.

The graph will show the first n values of the data that you set, where
n is the width set with :func:`Set GUI Graph Configuration`. If you set
less then n values it will show the rest of the values as zero.

The maximum number of data-points you can set is 118 (which also corresponds to the
maximum width of the graph).

You have to scale your values to be between 0 and 255. 0 will be shown
at the bottom of the graph and 255 at the top.

.. versionadded:: 2.0.2$nbsp;(Plugin)

=cut

sub set_gui_graph_data
{
    my ($self, $index, $data) = @_;

    if(scalar(@{$data}) > 65535)
    {
        croak(Tinkerforge::Error->_new(Tinkerforge::Error->INVALID_PARAMETER, 'Data can be at most 65535 items long'));
    }

    my $data_length = scalar(@{$data});
    my $data_chunk_offset = 0;

    if($data_length == 0)
    {
        my $data_chunk_data = [0] x 59;

        $self->set_gui_graph_data_low_level($index, $data_length, $data_chunk_offset, $data_chunk_data);
    }
    else
    {
        lock(${$self->{stream_lock_ref}});

        while($data_chunk_offset < $data_length)
        {
            my $data_chunk_data = [];
            my $data_chunk_length = $data_length - $data_chunk_offset;

            if($data_chunk_length > 59) {
                $data_chunk_length = 59;
            }

            for(my $i = 0; $i < $data_chunk_length; $i++) {
                push(@{$data_chunk_data}, @{$data}[$data_chunk_offset + $i]);
            }

            if(scalar(@{$data_chunk_data}) < 59)
            {
                push(@{$data_chunk_data}, (0) x (59 - scalar(@{$data_chunk_data})));
            }

            $self->set_gui_graph_data_low_level($index, $data_length, $data_chunk_offset, $data_chunk_data);
            $data_chunk_offset += 59;
        }
    }
}

=item get_gui_graph_data()

Returns the graph data for a given index as set by :func:`Set GUI Graph Data`.

.. versionadded:: 2.0.2$nbsp;(Plugin)

=cut

sub get_gui_graph_data
{
    my ($self, $index) = @_;

    lock(${$self->{stream_lock_ref}});

    my @ret = $self->get_gui_graph_data_low_level($index);
    my $data_length = $ret[0];
    my $data_chunk_offset = $ret[1];
    my $data_out_of_sync = $data_chunk_offset != 0;
    my $data_data = $ret[2];

    while(!$data_out_of_sync && scalar(@{$data_data}) < $data_length)
    {
        @ret = $self->get_gui_graph_data_low_level($index);
        $data_length = $ret[0];
        $data_chunk_offset = $ret[1];
        $data_out_of_sync = $data_chunk_offset != scalar(@{$data_data});
        push(@{$data_data}, @{$ret[2]});
    }

    if($data_out_of_sync) # discard remaining stream to bring it back in-sync
    {
        while($data_chunk_offset + 59 < $data_length)
        {
            @ret = $self->get_gui_graph_data_low_level($index);
            $data_length = $ret[0];
            $data_chunk_offset = $ret[1];
        }

        croak(Tinkerforge::Error->_new(Tinkerforge::Error->STREAM_OUT_OF_SYNC, 'Data stream is out-of-sync'));
    }

    splice(@{$data_data}, $data_length);

    return $data_data;
}

=back
=cut

1;
