#############################################################
# This file was automatically generated on 2018-09-28.      #
#                                                           #
# Perl Bindings Version 2.1.18                              #
#                                                           #
# If you have a bugfix for this file and want to commit it, #
# please fix the bug in the generator. You can find a link  #
# to the generators git repository on tinkerforge.com       #
#############################################################

=pod

=encoding utf8

=head1 NAME

Tinkerforge::BrickletRemoteSwitchV2 - Controls remote mains switches

=cut

package Tinkerforge::BrickletRemoteSwitchV2;

use strict;
use warnings;
use Carp;
use threads;
use threads::shared;
use parent 'Tinkerforge::Device';
use Tinkerforge::IPConnection;
use Tinkerforge::Error;

=head1 CONSTANTS

=over

=item DEVICE_IDENTIFIER

This constant is used to identify a Remote Switch Bricklet 2.0.

The get_identity() subroutine and the CALLBACK_ENUMERATE callback of the
IP Connection have a device_identifier parameter to specify the Brick's or
Bricklet's type.

=cut

use constant DEVICE_IDENTIFIER => 289;

=item DEVICE_DISPLAY_NAME

This constant represents the display name of a Remote Switch Bricklet 2.0.

=cut

use constant DEVICE_DISPLAY_NAME => 'Remote Switch Bricklet 2.0';

=item CALLBACK_SWITCHING_DONE

This constant is used with the register_callback() subroutine to specify
the CALLBACK_SWITCHING_DONE callback.

=cut

use constant CALLBACK_SWITCHING_DONE => 2;

=item CALLBACK_REMOTE_STATUS_A

This constant is used with the register_callback() subroutine to specify
the CALLBACK_REMOTE_STATUS_A callback.

=cut

use constant CALLBACK_REMOTE_STATUS_A => 14;

=item CALLBACK_REMOTE_STATUS_B

This constant is used with the register_callback() subroutine to specify
the CALLBACK_REMOTE_STATUS_B callback.

=cut

use constant CALLBACK_REMOTE_STATUS_B => 15;

=item CALLBACK_REMOTE_STATUS_C

This constant is used with the register_callback() subroutine to specify
the CALLBACK_REMOTE_STATUS_C callback.

=cut

use constant CALLBACK_REMOTE_STATUS_C => 16;

=item FUNCTION_GET_SWITCHING_STATE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_SWITCHING_STATE => 1;

=item FUNCTION_SET_REPEATS

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_REPEATS => 3;

=item FUNCTION_GET_REPEATS

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_REPEATS => 4;

=item FUNCTION_SWITCH_SOCKET_A

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SWITCH_SOCKET_A => 5;

=item FUNCTION_SWITCH_SOCKET_B

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SWITCH_SOCKET_B => 6;

=item FUNCTION_DIM_SOCKET_B

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_DIM_SOCKET_B => 7;

=item FUNCTION_SWITCH_SOCKET_C

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SWITCH_SOCKET_C => 8;

=item FUNCTION_SET_REMOTE_CONFIGURATION

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_REMOTE_CONFIGURATION => 9;

=item FUNCTION_GET_REMOTE_CONFIGURATION

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_REMOTE_CONFIGURATION => 10;

=item FUNCTION_GET_REMOTE_STATUS_A

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_REMOTE_STATUS_A => 11;

=item FUNCTION_GET_REMOTE_STATUS_B

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_REMOTE_STATUS_B => 12;

=item FUNCTION_GET_REMOTE_STATUS_C

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_REMOTE_STATUS_C => 13;

=item FUNCTION_GET_SPITFP_ERROR_COUNT

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_SPITFP_ERROR_COUNT => 234;

=item FUNCTION_SET_BOOTLOADER_MODE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_BOOTLOADER_MODE => 235;

=item FUNCTION_GET_BOOTLOADER_MODE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_BOOTLOADER_MODE => 236;

=item FUNCTION_SET_WRITE_FIRMWARE_POINTER

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_WRITE_FIRMWARE_POINTER => 237;

=item FUNCTION_WRITE_FIRMWARE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_WRITE_FIRMWARE => 238;

=item FUNCTION_SET_STATUS_LED_CONFIG

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_STATUS_LED_CONFIG => 239;

=item FUNCTION_GET_STATUS_LED_CONFIG

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_STATUS_LED_CONFIG => 240;

=item FUNCTION_GET_CHIP_TEMPERATURE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_CHIP_TEMPERATURE => 242;

=item FUNCTION_RESET

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_RESET => 243;

=item FUNCTION_WRITE_UID

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_WRITE_UID => 248;

=item FUNCTION_READ_UID

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_READ_UID => 249;

=item FUNCTION_GET_IDENTITY

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_IDENTITY => 255;
use constant SWITCHING_STATE_READY => 0;
use constant SWITCHING_STATE_BUSY => 1;
use constant SWITCH_TO_OFF => 0;
use constant SWITCH_TO_ON => 1;
use constant REMOTE_TYPE_A => 0;
use constant REMOTE_TYPE_B => 1;
use constant REMOTE_TYPE_C => 2;
use constant BOOTLOADER_MODE_BOOTLOADER => 0;
use constant BOOTLOADER_MODE_FIRMWARE => 1;
use constant BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT => 2;
use constant BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT => 3;
use constant BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT => 4;
use constant BOOTLOADER_STATUS_OK => 0;
use constant BOOTLOADER_STATUS_INVALID_MODE => 1;
use constant BOOTLOADER_STATUS_NO_CHANGE => 2;
use constant BOOTLOADER_STATUS_ENTRY_FUNCTION_NOT_PRESENT => 3;
use constant BOOTLOADER_STATUS_DEVICE_IDENTIFIER_INCORRECT => 4;
use constant BOOTLOADER_STATUS_CRC_MISMATCH => 5;
use constant STATUS_LED_CONFIG_OFF => 0;
use constant STATUS_LED_CONFIG_ON => 1;
use constant STATUS_LED_CONFIG_SHOW_HEARTBEAT => 2;
use constant STATUS_LED_CONFIG_SHOW_STATUS => 3;


=back

=head1 FUNCTIONS

=over

=item new()

Creates an object with the unique device ID *uid* and adds it to
the IP Connection *ipcon*.

=cut

sub new
{
	my ($class, $uid, $ipcon) = @_;

	my $self = Tinkerforge::Device->_new($uid, $ipcon, [2, 0, 0]);

	$self->{response_expected}->{&FUNCTION_GET_SWITCHING_STATE} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_REPEATS} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_GET_REPEATS} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SWITCH_SOCKET_A} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_SWITCH_SOCKET_B} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_DIM_SOCKET_B} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_SWITCH_SOCKET_C} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_SET_REMOTE_CONFIGURATION} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_GET_REMOTE_CONFIGURATION} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_REMOTE_STATUS_A} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_REMOTE_STATUS_B} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_REMOTE_STATUS_C} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_SPITFP_ERROR_COUNT} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_BOOTLOADER_MODE} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_BOOTLOADER_MODE} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_WRITE_FIRMWARE_POINTER} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_WRITE_FIRMWARE} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_STATUS_LED_CONFIG} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_GET_STATUS_LED_CONFIG} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_CHIP_TEMPERATURE} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_RESET} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_WRITE_UID} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_READ_UID} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_IDENTITY} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;

	$self->{callback_formats}->{&CALLBACK_SWITCHING_DONE} = '';
	$self->{callback_formats}->{&CALLBACK_REMOTE_STATUS_A} = 'C C C S';
	$self->{callback_formats}->{&CALLBACK_REMOTE_STATUS_B} = 'L C C C S';
	$self->{callback_formats}->{&CALLBACK_REMOTE_STATUS_C} = 'a C C S';



	bless($self, $class);

	return $self;
}


=item get_switching_state()

Returns the current switching state. If the current state is busy, the
Bricklet is currently sending a code to switch a socket. It will not
accept any calls of switch socket functions until the state changes to ready.

How long the switching takes is dependent on the number of repeats, see
:func:`Set Repeats`.

=cut

sub get_switching_state
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_SWITCHING_STATE, [], '', 'C');
}

=item set_repeats()

Sets the number of times the code is send when one of the Switch Socket
functions is called. The repeats basically correspond to the amount of time
that a button of the remote is pressed.

Some dimmers are controlled by the length of a button pressed,
this can be simulated by increasing the repeats.

The default value is 5.

=cut

sub set_repeats
{
	my ($self, $repeats) = @_;

	$self->_send_request(&FUNCTION_SET_REPEATS, [$repeats], 'C', '');
}

=item get_repeats()

Returns the number of repeats as set by :func:`Set Repeats`.

=cut

sub get_repeats
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_REPEATS, [], '', 'C');
}

=item switch_socket_a()

To switch a type A socket you have to give the house code, receiver code and the
state (on or off) you want to switch to.

The house code and receiver code have a range of 0 to 31 (5bit).

A detailed description on how you can figure out the house and receiver code
can be found :ref:`here <remote_switch_bricklet_type_a_house_and_receiver_code>`.

=cut

sub switch_socket_a
{
	my ($self, $house_code, $receiver_code, $switch_to) = @_;

	$self->_send_request(&FUNCTION_SWITCH_SOCKET_A, [$house_code, $receiver_code, $switch_to], 'C C C', '');
}

=item switch_socket_b()

To switch a type B socket you have to give the address, unit and the state
(on or off) you want to switch to.

The address has a range of 0 to 67108863 (26bit) and the unit has a range
of 0 to 15 (4bit). To switch all devices with the same address use 255 for
the unit.

A detailed description on how you can teach a socket the address and unit can
be found :ref:`here <remote_switch_bricklet_type_b_address_and_unit>`.

=cut

sub switch_socket_b
{
	my ($self, $address, $unit, $switch_to) = @_;

	$self->_send_request(&FUNCTION_SWITCH_SOCKET_B, [$address, $unit, $switch_to], 'L C C', '');
}

=item dim_socket_b()

To control a type B dimmer you have to give the address, unit and the
dim value you want to set the dimmer to.

The address has a range of 0 to 67108863 (26bit), the unit and the dim value
has a range of 0 to 15 (4bit).

A detailed description on how you can teach a dimmer the address and unit can
be found :ref:`here <remote_switch_bricklet_type_b_address_and_unit>`.

=cut

sub dim_socket_b
{
	my ($self, $address, $unit, $dim_value) = @_;

	$self->_send_request(&FUNCTION_DIM_SOCKET_B, [$address, $unit, $dim_value], 'L C C', '');
}

=item switch_socket_c()

To switch a type C socket you have to give the system code, device code and the
state (on or off) you want to switch to.

The system code has a range of 'A' to 'P' (4bit) and the device code has a
range of 1 to 16 (4bit).

A detailed description on how you can figure out the system and device code
can be found :ref:`here <remote_switch_bricklet_type_c_system_and_device_code>`.

=cut

sub switch_socket_c
{
	my ($self, $system_code, $device_code, $switch_to) = @_;

	$self->_send_request(&FUNCTION_SWITCH_SOCKET_C, [$system_code, $device_code, $switch_to], 'a C C', '');
}

=item set_remote_configuration()

Sets the configuration for **receiving** data from a remote of type A, B or C.

* Remote Type: A, B or C depending on the type of remote you want to receive.
* Minimum Repeats: The minimum number of repeated data packets until the callback
  is triggered (if enabled).
* Callback Enabled: Enable or disable callback (see :cb:`Remote Status A` callback,
  :cb:`Remote Status B` callback and :cb:`Remote Status C` callback).

Default is ('A', 2, false).

=cut

sub set_remote_configuration
{
	my ($self, $remote_type, $minimum_repeats, $callback_enabled) = @_;

	$self->_send_request(&FUNCTION_SET_REMOTE_CONFIGURATION, [$remote_type, $minimum_repeats, $callback_enabled], 'C S ?', '');
}

=item get_remote_configuration()

Returns the remote configuration as set by :func:`Set Remote Configuration`

=cut

sub get_remote_configuration
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_REMOTE_CONFIGURATION, [], '', 'C S ?');
}

=item get_remote_status_a()

Returns the house code, receiver code, switch state (on/off) and number of
repeats for remote type A.

Repeats == 0 means there was no button press. Repeats >= 1 means there
was a button press with the specified house/receiver code. The repeats are the
number of received identical data packets. The longer the button is pressed,
the higher the repeat number.

Use the callback to get this data automatically when a button is pressed,
see :func:`Set Remote Configuration` and :cb:`Remote Status A` callback.

=cut

sub get_remote_status_a
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_REMOTE_STATUS_A, [], '', 'C C C S');
}

=item get_remote_status_b()

Returns the address (unique per remote), unit (button number), switch state
(on/off) and number of repeats for remote type B.

If the remote supports dimming the dim value is used instead of the switch state.

If repeats=0 there was no button press. If repeats >= 1 there
was a button press with the specified address/unit. The repeats are the number of received
identical data packets. The longer the button is pressed, the higher the repeat number.

Use the callback to get this data automatically when a button is pressed,
see :func:`Set Remote Configuration` and :cb:`Remote Status B` callback.

=cut

sub get_remote_status_b
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_REMOTE_STATUS_B, [], '', 'L C C C S');
}

=item get_remote_status_c()

Returns the system code, device code, switch state (on/off) and number of repeats for
remote type C.

If repeats=0 there was no button press. If repeats >= 1 there
was a button press with the specified system/device code. The repeats are the number of received
identical data packets. The longer the button is pressed, the higher the repeat number.

Use the callback to get this data automatically when a button is pressed,
see :func:`Set Remote Configuration` and :cb:`Remote Status C` callback.

=cut

sub get_remote_status_c
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_REMOTE_STATUS_C, [], '', 'a C C S');
}

=item get_spitfp_error_count()

Returns the error count for the communication between Brick and Bricklet.

The errors are divided into

* ACK checksum errors,
* message checksum errors,
* framing errors and
* overflow errors.

The errors counts are for errors that occur on the Bricklet side. All
Bricks have a similar function that returns the errors on the Brick side.

=cut

sub get_spitfp_error_count
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_SPITFP_ERROR_COUNT, [], '', 'L L L L');
}

=item set_bootloader_mode()

Sets the bootloader mode and returns the status after the requested
mode change was instigated.

You can change from bootloader mode to firmware mode and vice versa. A change
from bootloader mode to firmware mode will only take place if the entry function,
device identifier and CRC are present and correct.

This function is used by Brick Viewer during flashing. It should not be
necessary to call it in a normal user program.

=cut

sub set_bootloader_mode
{
	my ($self, $mode) = @_;

	return $self->_send_request(&FUNCTION_SET_BOOTLOADER_MODE, [$mode], 'C', 'C');
}

=item get_bootloader_mode()

Returns the current bootloader mode, see :func:`Set Bootloader Mode`.

=cut

sub get_bootloader_mode
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_BOOTLOADER_MODE, [], '', 'C');
}

=item set_write_firmware_pointer()

Sets the firmware pointer for :func:`Write Firmware`. The pointer has
to be increased by chunks of size 64. The data is written to flash
every 4 chunks (which equals to one page of size 256).

This function is used by Brick Viewer during flashing. It should not be
necessary to call it in a normal user program.

=cut

sub set_write_firmware_pointer
{
	my ($self, $pointer) = @_;

	$self->_send_request(&FUNCTION_SET_WRITE_FIRMWARE_POINTER, [$pointer], 'L', '');
}

=item write_firmware()

Writes 64 Bytes of firmware at the position as written by
:func:`Set Write Firmware Pointer` before. The firmware is written
to flash every 4 chunks.

You can only write firmware in bootloader mode.

This function is used by Brick Viewer during flashing. It should not be
necessary to call it in a normal user program.

=cut

sub write_firmware
{
	my ($self, $data) = @_;

	return $self->_send_request(&FUNCTION_WRITE_FIRMWARE, [$data], 'C64', 'C');
}

=item set_status_led_config()

Sets the status LED configuration. By default the LED shows
communication traffic between Brick and Bricklet, it flickers once
for every 10 received data packets.

You can also turn the LED permanently on/off or show a heartbeat.

If the Bricklet is in bootloader mode, the LED is will show heartbeat by default.

=cut

sub set_status_led_config
{
	my ($self, $config) = @_;

	$self->_send_request(&FUNCTION_SET_STATUS_LED_CONFIG, [$config], 'C', '');
}

=item get_status_led_config()

Returns the configuration as set by :func:`Set Status LED Config`

=cut

sub get_status_led_config
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_STATUS_LED_CONFIG, [], '', 'C');
}

=item get_chip_temperature()

Returns the temperature in °C as measured inside the microcontroller. The
value returned is not the ambient temperature!

The temperature is only proportional to the real temperature and it has bad
accuracy. Practically it is only useful as an indicator for
temperature changes.

=cut

sub get_chip_temperature
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_CHIP_TEMPERATURE, [], '', 's');
}

=item reset()

Calling this function will reset the Bricklet. All configurations
will be lost.

After a reset you have to create new device objects,
calling functions on the existing ones will result in
undefined behavior!

=cut

sub reset
{
	my ($self) = @_;

	$self->_send_request(&FUNCTION_RESET, [], '', '');
}

=item write_uid()

Writes a new UID into flash. If you want to set a new UID
you have to decode the Base58 encoded UID string into an
integer first.

We recommend that you use Brick Viewer to change the UID.

=cut

sub write_uid
{
	my ($self, $uid) = @_;

	$self->_send_request(&FUNCTION_WRITE_UID, [$uid], 'L', '');
}

=item read_uid()

Returns the current UID as an integer. Encode as
Base58 to get the usual string version.

=cut

sub read_uid
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_READ_UID, [], '', 'L');
}

=item get_identity()

Returns the UID, the UID where the Bricklet is connected to,
the position, the hardware and firmware version as well as the
device identifier.

The position can be 'a', 'b', 'c' or 'd'.

The device identifier numbers can be found :ref:`here <device_identifier>`.
|device_identifier_constant|

=cut

sub get_identity
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_IDENTITY, [], '', 'Z8 Z8 a C3 C3 S');
}

=back
=cut

1;
