## no critic qw(RequirePodSections)    # -*- cperl -*-
# This file is auto-generated by the Perl TeX::Hyphen::Pattern Suite hyphen
# pattern catalog generator. This code generator comes with the
# TeX::Hyphen::Pattern module distribution in the tools/ directory
#
# Do not edit this file directly.

## no critic qw(ProhibitLongLines)
# $Id: P800Picture.pm 50 2009-01-31 09:22:52Z roland $
# $Revision: 50 $
# $HeadURL: svn+ssh://ipenburg.xs4all.nl/srv/svnroot/debbie/trunk/Date-Extract-P800Picture/lib/Date/Extract/P800Picture.pm$
# $Date: 2009-01-31 10:22:52 +0100 (Sat, 31 Jan 2009) $
## use critic

package TeX::Hyphen::Pattern::Gl;
use strict;
use warnings;
use 5.006000;
use utf8;

our $VERSION = '0.01';

my $pattern_file = q{};
while (<DATA>) {
	 $pattern_file .= $_;
}

use Class::Meta::Express qw(class ctor has meta method);

class {

    ctor 'new';

    method data => sub {
		$pattern_file;
	};

    method version => sub {
		$VERSION;
	};

};

1;
## no critic qw(RequirePodAtEnd RequireASCII)
=encoding utf8

=head1 C<Gl> hyphenation pattern class

=cut

__DATA__
% This is the file hyph-gl.tex, version 2.3a-utf8
% Hyphenation patterns for Galician, written in the utf8 encoding.
%
% Generated with the mkpattern utility (v. 1.1), on 2008/06/22.
% The original source file were glpatter-utf8.tex
% This is a generated file
%
% (c) Javier A. Múgica; 2006, 2007, 2008
% License: LPPL version 1.3
%
% LPPL maintenance status: maintained
% Current Maintainer: Javier A. Múgica
%
% For bug reports and comments:
%
% Javier Múgica, javier at digi21.eu
%
% Note that there is no 'j' nor 'y' in Galician

\patterns{
3ï3a 
a1a e1e o1o zo2o a1á e1é o1ó 
2ai. 2au. 
2ei. 2eu. 
2oi. 2ou. 
%
a1ia a1ie a1io a1iá 
e1ia e1ie e1io e1iá 
o1ia o1ie o1io o1iá 
u1ia u1ie u1io u1iá 
%
2ia. 2ie. 2io. 2iá. 
%
1ñ 
1b 1c 1d 1f 1g 1h 1k 1m 1n 1p 1q 1s 1t 1v 1w 1x 1z 1l 1r 
2bb 2bc 2bd 2bf 2bg 2bh 2bk 2bm 2bn 2bp 2bq 2bs 2bt 2bv 2bw 2bx 2bz 
2cb 2cc 2cd 2cf 2cg     2ck 2cm 2cn 2cp 2cq 2cs 2ct 2cv 2cw 2cx 2cz 
2db 2dc 2dd 2df 2dg 2dh 2dk 2dm 2dn 2dp 2dq 2ds 2dt 2dv 2dw 2dx 2dz 
2fb 2fc 2fd 2ff 2fg 2fh 2fk 2fm 2fn 2fp 2fq 2fs 2ft 2fv 2fw 2fx 2fz 
2gb 2gc 2gd 2gf 2gg     2gk 2gm 2gn 2gp 2gq 2gs 2gt 2gv 2gw 2gx 2gz 
2hb 2hc 2hd 2hf 2hg 2hh 2hk 2hm 2hn 2hp 2hq 2hs 2ht 2hv 2hw 2hx 2hz 
2kb 2kc 2kd 2kf 2kg     2kk 2km 2kn 2kp 2kq 2ks 2kt 2kv 2kw 2kx 2kz 
2mb 2mc 2md 2mf 2mg 2mh 2mk 2mm 2mn 2mp 2mq 2ms 2mt 2mv 2mw 2mx 2mz 
2nb 2nc 2nd 2nf 2ng 2nh 2nk 2nm 2nn 2np 2nq 2ns 2nt 2nv 2nw 2nx 2nz 
2pb 2pc 2pd 2pf 2pg 2ph 2pk 2pm 2pn 2pp 2pq 2ps 2pt 2pv 2pw 2px 2pz 
2qb 2qc 2qd 2qf 2qg 2qh 2qk 2qm 2qn 2qp 2qq 2qs 2qt 2qv 2qw 2qx 2qz 
2sb 2sc 2sd 2sf 2sg 2sh 2sk 2sm 2sn 2sp 2sq 2ss 2st 2sv 2sw 2sx 2sz 
2tb 2tc 2td 2tf 2tg 2th 2tk 2tm 2tn 2tp 2tq 2ts 2tt 2tv 2tw 2tx 2tz 
2vb 2vc 2vd 2vf 2vg 2vh 2vk 2vm 2vn 2vp 2vq 2vs 2vt 2vv 2vw 2vx 2vz 
2wb 2wc 2wd 2wf 2wg 2wh 2wk 2wm 2wn 2wp 2wq 2ws 2wt 2wv 2ww 2wx 2wz 
2xb 2xc 2xd 2xf 2xg 2xh 2xk 2xm 2xn 2xp 2xq 2xs 2xt 2xv 2xw 2xx 2xz 
2zb 2zc 2zd 2zf 2zg 2zh 2zk 2zm 2zn 2zp 2zq 2zs 2zt 2zv 2zw 2zx 2zz 
2lb 2lc 2ld 2lf 2lg 2lh 2lk 2lm 2ln 2lp 2lq 2ls 2lt 2lv 2lw 2lx 2lz 
2rb 2rc 2rd 2rf 2rg 2rh 2rk 2rm 2rn 2rp 2rq 2rs 2rt 2rv 2rw 2rx 2rz 
%
c4h 2ch. 2g2h 2k2h 
%
b2l b2r 
c2l c2r 
d2l d2r 
f2l f2r 
g2l g2r 
k2l k2r 
p2l p2r 
    t2r 
v2l v2r 
%
2bl. 2br. 
2cl. 2cr. 
2dl. 2dr. 
2fl. 2fr. 
2gl. 2gr. 
2kl. 2kr. 
2pl. 2pr. 
     2tr. 
2vl. 2vr. 
%
2ml 2mr 
2nl 2nr 
2ql 2qr 
2sl 2sr 
2xl 2xr 
2yl 2yr 
2zl 2zr 
2hl 2hr 
%
2t2l 
2lr l4l 2ll. 2rl r2r 2rr. 
%
2b3p2t 2c3p2t 2d3p2t 2l3p2t 2m3p2t 2n3p2t 2r3p2t 2s3p2t 2t3p2t 2x3p2t 
2b3c2t 2c3c2t 2d3c2t 2l3c2t 2m3c2t 2n3c2t 2r3c2t 2s3c2t 2t3c2t 2x3c2t 
2b3c2n 2c3c2n 2d3c2n 2l3c2n 2m3c2n 2n3c2n 2r3c2n 2s3c2n 2t3c2n 2x3c2n 
2b3p2s 2c3p2s 2d3p2s 2l3p2s 2m3p2s 2n3p2s 2r3p2s 2s3p2s 2t3p2s 2x3p2s 
2b3m2n 2c3m2n 2d3m2n 2l3m2n 2m3m2n 2n3m2n 2r3m2n 2s3m2n 2t3m2n 2x3m2n 
2b3g2n 2c3g2n 2d3g2n 2l3g2n 2m3g2n 2n3g2n 2r3g2n 2s3g2n 2t3g2n 2x3g2n 
2b3f2t 2c3f2t 2d3f2t 2l3f2t 2m3f2t 2n3f2t 2r3f2t 2s3f2t 2t3f2t 2x3f2t 
2b3p2n 2c3p2n 2d3p2n 2l3p2n 2m3p2n 2n3p2n 2r3p2n 2s3p2n 2t3p2n 2x3p2n 
2b3c2z 2c3c2z 2d3c2z 2l3c2z 2m3c2z 2n3c2z 2r3c2z 2s3c2z 2t3c2z 2x3c2z 
2b3t2s 2c3t2s 2d3t2s 2l3t2s 2m3t2s 2n3t2s 2r3t2s 2s3t2s 2t3t2s 2x3t2s 
san4c5t plan4c5t 
%
4pt. 4ct. 4cn. 4ps. 4mn. 4gn. 4ft. 4pn. 4cz. 4ts. 
un4ha 2non. 3mente. o2hib alde2h 
%
4caca4 4cago4 4caga4 4cagas. 4puta4 4puto4 4meo. 4mea. 
4meable. 4meables. 4peido4 
%
acto1a2 acto1e2 acto1i2 acto1o2 acto1u2 acto1á2 acto1é2 acto1í2 acto1ó2 acto1ú2 
afro1a2 afro1e2 afro1i2 afro1o2 afro1u2 afro1á2 afro1é2 afro1í2 afro1ó2 afro1ú2 
aero1a2 aero1e2 aero1i2 aero1o2 aero1u2 aero1á2 aero1é2 aero1í2 aero1ó2 aero1ú2 
anfi1a2 anfi1e2 anfi1i2 anfi1o2 anfi1u2 anfi1á2 anfi1é2 anfi1í2 anfi1ó2 anfi1ú2 
anglo1a2 anglo1e2 anglo1i2 anglo1o2 anglo1u2 anglo1á2 anglo1é2 anglo1í2 anglo1ó2 anglo1ú2 
.ante1a2 .ante1e2 .ante1i2 .ante1o2 .ante1u2 .ante1á2 .ante1é2 .ante1í2 .ante1ó2 .ante1ú2 
.anti1a2 .anti1e2 .anti1i2 .anti1o2 .anti1u2 .anti1á2 .anti1é2 .anti1í2 .anti1ó2 .anti1ú2 
.arqui1a2 .arqui1e2 .arqui1i2 .arqui1o2 .arqui1u2 .arqui1á2 .arqui1é2 .arqui1í2 .arqui1ó2 .arqui1ú2 
auto1a2 auto1e2 auto1i2 auto1o2 auto1u2 auto1á2 auto1é2 auto1í2 auto1ó2 auto1ú2 
biblio1a2 biblio1e2 biblio1i2 biblio1o2 biblio1u2 biblio1á2 biblio1é2 biblio1í2 biblio1ó2 biblio1ú2 
bio1a2 bio1e2 bio1i2 bio1o2 bio1u2 bio1á2 bio1é2 bio1í2 bio1ó2 bio1ú2 
cardio1a2 cardio1e2 cardio1i2 cardio1o2 cardio1u2 cardio1á2 cardio1é2 cardio1í2 cardio1ó2 cardio1ú2 
cefalo1a2 cefalo1e2 cefalo1i2 cefalo1o2 cefalo1u2 cefalo1á2 cefalo1é2 cefalo1í2 cefalo1ó2 cefalo1ú2 
ciclo1a2 ciclo1e2 ciclo1i2 ciclo1o2 ciclo1u2 ciclo1á2 ciclo1é2 ciclo1í2 ciclo1ó2 ciclo1ú2 
cito1a2 cito1e2 cito1i2 cito1o2 cito1u2 cito1á2 cito1é2 cito1í2 cito1ó2 cito1ú2 
contra1a2 contra1e2 contra1i2 contra1o2 contra1u2 contra1á2 contra1é2 contra1í2 contra1ó2 contra1ú2 
cripto1a2 cripto1e2 cripto1i2 cripto1o2 cripto1u2 cripto1á2 cripto1é2 cripto1í2 cripto1ó2 cripto1ú2 
cromo1a2 cromo1e2 cromo1i2 cromo1o2 cromo1u2 cromo1á2 cromo1é2 cromo1í2 cromo1ó2 cromo1ú2 
crono1a2 crono1e2 crono1i2 crono1o2 crono1u2 crono1á2 crono1é2 crono1í2 crono1ó2 crono1ú2 
deca1a2 deca1e2 deca1i2 deca1o2 deca1u2 deca1á2 deca1é2 deca1í2 deca1ó2 deca1ú2 
.deza1a2 .deza1e2 .deza1i2 .deza1o2 .deza1u2 .deza1á2 .deza1é2 .deza1í2 .deza1ó2 .deza1ú2 
dinamo1a2 dinamo1e2 dinamo1i2 dinamo1o2 dinamo1u2 dinamo1á2 dinamo1é2 dinamo1í2 dinamo1ó2 dinamo1ú2 
ecano1a2 ecano1e2 ecano1i2 ecano1o2 ecano1u2 ecano1á2 ecano1é2 ecano1í2 ecano1ó2 ecano1ú2 
eco1a2 eco1e2 eco1i2 eco1o2 eco1u2 eco1á2 eco1é2 eco1í2 eco1ó2 eco1ú2 
electro1a2 electro1e2 electro1i2 electro1o2 electro1u2 electro1á2 electro1é2 electro1í2 electro1ó2 electro1ú2 
endo1a2 endo1e2 endo1i2 endo1o2 endo1u2 endo1á2 endo1é2 endo1í2 endo1ó2 endo1ú2 
ento1a2 ento1e2 ento1i2 ento1o2 ento1u2 ento1á2 ento1é2 ento1í2 ento1ó2 ento1ú2 
entre1a2 entre1e2 entre1i2 entre1o2 entre1u2 entre1á2 entre1é2 entre1í2 entre1ó2 entre1ú2 
euco1a2 euco1e2 euco1i2 euco1o2 euco1u2 euco1á2 euco1é2 euco1í2 euco1ó2 euco1ú2 
euro1a2 euro1e2 euro1i2 euro1o2 euro1u2 euro1á2 euro1é2 euro1í2 euro1ó2 euro1ú2 
extra1a2 extra1e2 extra1i2 extra1o2 extra1u2 extra1á2 extra1é2 extra1í2 extra1ó2 extra1ú2 
fono1a2 fono1e2 fono1i2 fono1o2 fono1u2 fono1á2 fono1é2 fono1í2 fono1ó2 fono1ú2 
foto1a2 foto1e2 foto1i2 foto1o2 foto1u2 foto1á2 foto1é2 foto1í2 foto1ó2 foto1ú2 
franco1a2 franco1e2 franco1i2 franco1o2 franco1u2 franco1á2 franco1é2 franco1í2 franco1ó2 franco1ú2 
gastro1a2 gastro1e2 gastro1i2 gastro1o2 gastro1u2 gastro1á2 gastro1é2 gastro1í2 gastro1ó2 gastro1ú2 
xeo1a2 xeo1e2 xeo1i2 xeo1o2 xeo1u2 xeo1á2 xeo1é2 xeo1í2 xeo1ó2 xeo1ú2 
hecto1a2 hecto1e2 hecto1i2 hecto1o2 hecto1u2 hecto1á2 hecto1é2 hecto1í2 hecto1ó2 hecto1ú2 
helio1a2 helio1e2 helio1i2 helio1o2 helio1u2 helio1á2 helio1é2 helio1í2 helio1ó2 helio1ú2 
hemato1a2 hemato1e2 hemato1i2 hemato1o2 hemato1u2 hemato1á2 hemato1é2 hemato1í2 hemato1ó2 hemato1ú2 
hemi1a2 hemi1e2 hemi1i2 hemi1o2 hemi1u2 hemi1á2 hemi1é2 hemi1í2 hemi1ó2 hemi1ú2 
hexa1a2 hexa1e2 hexa1i2 hexa1o2 hexa1u2 hexa1á2 hexa1é2 hexa1í2 hexa1ó2 hexa1ú2 
hidro1a2 hidro1e2 hidro1i2 hidro1o2 hidro1u2 hidro1á2 hidro1é2 hidro1í2 hidro1ó2 hidro1ú2 
hipe2r1a2 hipe2r1e2 hipe2r1i2 hipe2r1o2 hipe2r1u2 hipe2r1á2 hipe2r1é2 hipe2r1í2 hipe2r1ó2 hipe2r1ú2 
histo1a2 histo1e2 histo1i2 histo1o2 histo1u2 histo1á2 histo1é2 histo1í2 histo1ó2 histo1ú2 
homeo1a2 homeo1e2 homeo1i2 homeo1o2 homeo1u2 homeo1á2 homeo1é2 homeo1í2 homeo1ó2 homeo1ú2 
homo1a2 homo1e2 homo1i2 homo1o2 homo1u2 homo1á2 homo1é2 homo1í2 homo1ó2 homo1ú2 
ibero1a2 ibero1e2 ibero1i2 ibero1o2 ibero1u2 ibero1á2 ibero1é2 ibero1í2 ibero1ó2 ibero1ú2 
icono1a2 icono1e2 icono1i2 icono1o2 icono1u2 icono1á2 icono1é2 icono1í2 icono1ó2 icono1ú2 
.in1a2 .in1e2 .in1i2 .in1o2 .in1u2 .in1á2 .in1é2 .in1í2 .in1ó2 .in1ú2 
.indo1a2 .indo1e2 .indo1i2 .indo1o2 .indo1u2 .indo1á2 .indo1é2 .indo1í2 .indo1ó2 .indo1ú2 
infra1a2 infra1e2 infra1i2 infra1o2 infra1u2 infra1á2 infra1é2 infra1í2 infra1ó2 infra1ú2 
.inte2r1a2 .inte2r1e2 .inte2r1i2 .inte2r1o2 .inte2r1u2 .inte2r1á2 .inte2r1é2 .inte2r1í2 .inte2r1ó2 .inte2r1ú2 
intra1a2 intra1e2 intra1i2 intra1o2 intra1u2 intra1á2 intra1é2 intra1í2 intra1ó2 intra1ú2 
.iso1a2 .iso1e2 .iso1i2 .iso1o2 .iso1u2 .iso1á2 .iso1é2 .iso1í2 .iso1ó2 .iso1ú2 
kilo1a2 kilo1e2 kilo1i2 kilo1o2 kilo1u2 kilo1á2 kilo1é2 kilo1í2 kilo1ó2 kilo1ú2 
macro1a2 macro1e2 macro1i2 macro1o2 macro1u2 macro1á2 macro1é2 macro1í2 macro1ó2 macro1ú2 
magneto1a2 magneto1e2 magneto1i2 magneto1o2 magneto1u2 magneto1á2 magneto1é2 magneto1í2 magneto1ó2 magneto1ú2 
maxi1a2 maxi1e2 maxi1i2 maxi1o2 maxi1u2 maxi1á2 maxi1é2 maxi1í2 maxi1ó2 maxi1ú2 
mega1a2 mega1e2 mega1i2 mega1o2 mega1u2 mega1á2 mega1é2 mega1í2 mega1ó2 mega1ú2 
megalo1a2 megalo1e2 megalo1i2 megalo1o2 megalo1u2 megalo1á2 megalo1é2 megalo1í2 megalo1ó2 megalo1ú2 
melano1a2 melano1e2 melano1i2 melano1o2 melano1u2 melano1á2 melano1é2 melano1í2 melano1ó2 melano1ú2 
micro1a2 micro1e2 micro1i2 micro1o2 micro1u2 micro1á2 micro1é2 micro1í2 micro1ó2 micro1ú2 
mili1a2 mili1e2 mili1i2 mili1o2 mili1u2 mili1á2 mili1é2 mili1í2 mili1ó2 mili1ú2 
mini1a2 mini1e2 mini1i2 mini1o2 mini1u2 mini1á2 mini1é2 mini1í2 mini1ó2 mini1ú2 
multi1a2 multi1e2 multi1i2 multi1o2 multi1u2 multi1á2 multi1é2 multi1í2 multi1ó2 multi1ú2 
miria1a2 miria1e2 miria1i2 miria1o2 miria1u2 miria1á2 miria1é2 miria1í2 miria1ó2 miria1ú2 
mono1a2 mono1e2 mono1i2 mono1o2 mono1u2 mono1á2 mono1é2 mono1í2 mono1ó2 mono1ú2 
.nano1a2 .nano1e2 .nano1i2 .nano1o2 .nano1u2 .nano1á2 .nano1é2 .nano1í2 .nano1ó2 .nano1ú2 
necro1a2 necro1e2 necro1i2 necro1o2 necro1u2 necro1á2 necro1é2 necro1í2 necro1ó2 necro1ú2 
.neo1a2 .neo1e2 .neo1i2 .neo1o2 .neo1u2 .neo1á2 .neo1é2 .neo1í2 .neo1ó2 .neo1ú2 
norte1a2 norte1e2 norte1i2 norte1o2 norte1u2 norte1á2 norte1é2 norte1í2 norte1ó2 norte1ú2 
octo1a2 octo1e2 octo1i2 octo1o2 octo1u2 octo1á2 octo1é2 octo1í2 octo1ó2 octo1ú2 
octa1a2 octa1e2 octa1i2 octa1o2 octa1u2 octa1á2 octa1é2 octa1í2 octa1ó2 octa1ú2 
omni1a2 omni1e2 omni1i2 omni1o2 omni1u2 omni1á2 omni1é2 omni1í2 omni1ó2 omni1ú2 
paleo1a2 paleo1e2 paleo1i2 paleo1o2 paleo1u2 paleo1á2 paleo1é2 paleo1í2 paleo1ó2 paleo1ú2 
para1a2 para1e2 para1i2 para1o2 para1u2 para1á2 para1é2 para1í2 para1ó2 para1ú2 
penta1a2 penta1e2 penta1i2 penta1o2 penta1u2 penta1á2 penta1é2 penta1í2 penta1ó2 penta1ú2 
piezo1a2 piezo1e2 piezo1i2 piezo1o2 piezo1u2 piezo1á2 piezo1é2 piezo1í2 piezo1ó2 piezo1ú2 
pluri1a2 pluri1e2 pluri1i2 pluri1o2 pluri1u2 pluri1á2 pluri1é2 pluri1í2 pluri1ó2 pluri1ú2 
poli1a2 poli1e2 poli1i2 poli1o2 poli1u2 poli1á2 poli1é2 poli1í2 poli1ó2 poli1ú2 
.pos2t1a2 .pos2t1e2 .pos2t1i2 .pos2t1o2 .pos2t1u2 .pos2t1á2 .pos2t1é2 .pos2t1í2 .pos2t1ó2 .pos2t1ú2 
.pre1a2 .pre1e2 .pre1i2 .pre1o2 .pre1u2          .pre1é2 .pre1í2 .pre1ó2 .pre1ú2 
.pro1a2 .pro1e2 .pro1i2 .pro1o2 .pro1u2 .pro1á2 .pro1é2 .pro1í2 .pro1ó2 .pro1ú2 
proto1a2 proto1e2 proto1i2 proto1o2 proto1u2 proto1á2 proto1é2 proto1í2 proto1ó2 proto1ú2 
pseudo1a2 pseudo1e2 pseudo1i2 pseudo1o2 pseudo1u2 pseudo1á2 pseudo1é2 pseudo1í2 pseudo1ó2 pseudo1ú2 
radio1a2 radio1e2 radio1i2 radio1o2 radio1u2 radio1á2 radio1é2 radio1í2 radio1ó2 radio1ú2 
retro1a2 retro1e2 retro1i2 retro1o2 retro1u2 retro1á2 retro1é2 retro1í2 retro1ó2 retro1ú2 
sobre1a2 sobre1e2 sobre1i2 sobre1o2 sobre1u2 sobre1á2 sobre1é2 sobre1í2 sobre1ó2 sobre1ú2 
semi1a2 semi1e2 semi1i2 semi1o2 semi1u2 semi1á2 semi1é2 semi1í2 semi1ó2 semi1ú2 
socio1a2 socio1e2 socio1i2 socio1o2 socio1u2 socio1á2 socio1é2 socio1í2 socio1ó2 socio1ú2 
.su2b1a2 .su2b1e2          .su2b1o2 .su2b1u2 .su2b1á2 .su2b1é2           .su2b1ó2 .su2b1ú2 
super1a2 super1e2 super1i2 super1o2 super1u2 super1á2 super1é2 super1í2 super1ó2 super1ú2 
supra1a2 supra1e2 supra1i2 supra1o2 supra1u2 supra1á2 supra1é2 supra1í2 supra1ó2 supra1ú2 
.tele1a2 .tele1e2 .tele1i2 .tele1o2 .tele1u2 .tele1á2 .tele1é2 .tele1í2 .tele1ó2 .tele1ú2 
termo1a2 termo1e2 termo1i2 termo1o2 termo1u2 termo1á2 termo1é2 termo1í2 termo1ó2 termo1ú2 
tetra1a2 tetra1e2 tetra1i2 tetra1o2 tetra1u2 tetra1á2 tetra1é2 tetra1í2 tetra1ó2 tetra1ú2 
topo1a2 topo1e2 topo1i2 topo1o2 topo1u2 topo1á2 topo1é2 topo1í2 topo1ó2 topo1ú2 
.tri1a2 .tri1e2 .tri1i2 .tri1o2 .tri1u2 .tri1á2 .tri1é2 .tri1í2 .tri1ó2 .tri1ú2 
tropo1a2 tropo1e2 tropo1i2 tropo1o2 tropo1u2 tropo1á2 tropo1é2 tropo1í2 tropo1ó2 tropo1ú2 
ultra1a2 ultra1e2 ultra1i2 ultra1o2 ultra1u2 ultra1á2 ultra1é2 ultra1í2 ultra1ó2 ultra1ú2 
xeno1a2 xeno1e2 xeno1i2 xeno1o2 xeno1u2 xeno1á2 xeno1é2 xeno1í2 xeno1ó2 xeno1ú2 
%
ti2o3qu ti2o3co bi1u2ní o2i3de o2i3dal deca2e3ment 2al. 2a2is. pe3r2e3mia hiper3r 
famili2a familia3r mini2a3tur para2u3gas paraí3so 
%
%Terceiras persoas do pasado perfecto
libero2u3 
atopo2u3 
enaxeno2u3 
%
2os. 2o3so. 2o3sos. 2o3sa. 2o3sas. 2o3samente. 
2i3co. 2i3cos. 2i3ca. 2i3cas. 
%
%O prefixo co
.co1a2 .co1e2 .co1i2 .co1o2 .co1u2         .co1é2 .co1í2 .co1ó2 .co1ú2 
%
%Formas do verbo coar con pronomes enclíticos
.co2ar 
.co2á2 
.co2abá 
.co2acerv 
.co2andro 
.co2ano 
.co2añar 
.co2año 
.co2art 
.co2etan 
.co2enci 
.co2erci 
.co2inci 
.co2ira 
.co2iro 
.co2ita 
%
co2a3gul 
co2á3gul 
co2a3la. 
co2a3las. 
co2a3lescen 
co2a3lición. 
co2a3licions. 
co2a3na. 
co2a3nas. 
co2antriñ 
co2a3ñadeir 
co2a3tí. 
co2a3tís. 
co2e3ficien 
co2e3lernos. 
co2e3llo. 
co2e3lla. 
co2e3llos. 
co2e3llas. 
co2e3lleir 
co2enll 
co2enxía 
co2e3sita. 
co2e3sitas. 
co2e3táne 
co2e3vo. 
co2e3va. 
co2e3vos. 
co2e3vas. 
co2i3dado 
co2iei 
co2imbra 
co2imbrá 
co2intreau. 
co2í3ña 
co2i3ña 
co2i3ñei 
co2i3pú. 
co2i3pús. 
co2i3ra. 
co2i3ras. 
co2i3raza 
co2i3ro. 
co2i3ros. 
co2i3ta. 
co2i3tas. 
co2i3tado. 
co2i3to. 
co2i3tos. 
co2i3tel 
co2i3tío. 
co2i3tus. 
co2u3c 
co2u3lomb 
co2u3try 
co2u3qui 
co2u3rel 
co2u3sa. 
co2u3sas. 
co2u3so. 
co2u3sos. 
co2u3selo 
co2u3tad 
co2u3to. 
co2u3tos. 
co2u3vini 
co2u3z 
%
%O prefixo des
.de2s1a2 .de2s1e2 .de2s1i2 .de2s1o2 .de2s1u2 .de2s1á2 .de2s1é2 .de2s1í2 .de2s1ó2 .de2s1ú2 
3se. 3s2es. 3sa. 3s2as. de3s2outr 3s2emos. 3s2edes. 3s2en. 
%
de3s2a3crali 
de3s2a3guisa 
de3s2a3lini 
de3s2a3ngr 
de3s2a3ñ 
de3s2a3rrollis 
de3s2astr 
de3s2a3zo 
de3s2e3c 
de3s2e3que 
de3s2e3guid 
de3s2e3la 
de3s2ensib 
de3s2e3ñ 
de3s2ert 
de3s2ért 
de3s2esper de4s3esperanz 
de3s2e3pér 
de3s2e3x 
de3s2é3x 
de3s2i3der 
de3s2ign 
de3s2ígn 
de3s2i3nenc 
de3s2ingr 
de3s2iste 
de3s2isti 
de3s2o3lac 
de3s2o3lad 
de3s2old 
de3s2o3lidari 
de3s2uetud 
de3s2sulf 
%
.des2abor 
.des2afia 
.des2afía 
.des2afío 
.des2air 
.des2emboc 
.des2embóc 
.des2empeñ 
.des2empéñ 
.des2enlac 
.des2enlaz 
.des2enlác 
.des2enláz 
.des2envol 
.des2envól 
.des2idia 
.des2ora 
%
%Excepcións ó prefixo in
%
.in2a3misib. 
.in2a3mov 
.in2a3ne. 
.in2a3nic 
.in2a3nid 
.in2á3nime 
.in2antes. 
.in2au 
.in2e3dia 
.in2é3dit 
.in2e3fab 
.in2e3narr 
.in2epc 
.in2ept 
.in2erc 
.in2ert 
.in2erm 
.in2erv 
.in2e3siv 
.in2e3xora 
.in2i3ci 
.in2i3cu 
.in2i3mig 
.in2i3miza 
.in2i3qui 
.in2o3cen 
.in2o3cui 
.in2o3cuo 
.in2o3cul 
.in2ó3cul 
.in2o3pia. 
.in2o3sili 
.in2o3sit 
.in2o3tróp 
.in2o3trop 
.in2uit 
.in2u3lase 
.in2u3lina 
.in2unda 
.in2u3sita 
.in2ú3til 
in2o4cular 
%
%Excepcións ó prefixo inter
.inter3r 
%
.inte3r2és. .inte3r2e3sa .inte3r2é3sa .inte3r2e3sá .inte3r2e3so .inte3r2é3so .inte3r2e3só .inte3r2ior .inte3r2i3no. .inte3r2i3nos. .inte3r2i3na. .inte3r2i3nas. .inte3r2i3nid 
%
%Os prefixos mal e ben
.be2n1a2 .be2ne2 .be2n1i2 .be2n1o2 .be2n1u2 .be2n1á2        .be2n1í2 .be2n1ó2 .be2n1ú2 
%
be3n2ign 
be3n2i3merí 
be3n2i3nés 
be3n2i3nes 
be3n2i3toíta 
%
.ma2l1a2 .ma2le2 .ma2l1i2 .ma2l1o2 .ma2l1u2 .ma2l1á2        .ma2l1í2 .ma2l1ó2 .ma2l1ú2 
%
.mal2abar 
.mal2abár 
.mal2aco 
.mal2acó 
.mal2armad 
.mal2ogr 
.mal2ura 
.mal2axa 
%
ma3l2a3cía 
ma3l2a3citan 
ma3l2a3gueñ 
ma3l2aio 
ma3l2aia 
ma3l2andrín 
ma3l2andrin 
ma3l2a3quita 
ma3l2ar. 
ma3l2a3res. 
ma3l2a3ria. 
ma3l2a3to. 
ma3l2a3tos. 
ma3l2a3ta. 
ma3l2a3tas. 
ma3l2a3tión 
ma3l2aui 
ma3l2eabl 
ma3l2eabil 
ma3l2eico 
ma3l2eolar 
ma3l2e3ta. 
ma3l2e3tas. 
ma3l2e3tín 
ma3l2e3teiro 
ma3l2eza 
ma3l2ia. 
ma3l2ian 
ma3l2i3cia 
ma3l2i3cios 
ma3l2ign 
ma3l2i3kita 
ma3l2inke 
ma3l2ó3fago 
ma3l2ó3nic 
ma3l2o3nato 
ma3l2o3nilue 
ma4l3ianq 
%
.mal1educ 
.mal1encar 
.mal1ensin 
.mal1entend 
%
%Excepcións ó prefixo poli
%
poli2u3r 
poli2o3me 
poli2arq 
poli2árq 
poli2éste 
poli2andr 
poli2antea 
expoli2 
%Excepcións ó prefixo post
%
pos3t2a. 
pos3t2as. 
pos3t2al. 
pos3t2ais. 
pos3t2a3llo 
pos3t2e. 
pos3t2es. 
pos3t2ear. 
pos3t2e3la. 
pos3t2e3las. 
pos3t2er. 
pos3t2erg 
pos3t2e3rid 
pos3t2e3rior 
pos3t2i3go 
pos3t2i3la 
pos3t2illón 
pos3t2ín. 
pos3t2i3te. 
pos3t2i3zo. 
pos3t2i3zos. 
pos3t2i3za. 
pos3t2i3zas. 
pos3t2os. 
pos3t2oiro 
pos3t2ó3ni 
pos3t2u3la 
pos3t2u3lo 
pos3t2u3le 
pos3t2u3ra. 
pos3t2u3ras. 
%
%Excepcións ó prefixo pre
%
.pre2amar 
%Formas do verbo prear con pronomes enclíticos
.pre2ar 
.pre2á2 
.pre2abá 
%
pre2as. 
pre2a3da. 
pre2a3das. 
pre2á2 
pre2abá 
pre2i3t 
pre2o3cup 
pre2o3cúp 
%
%Excepcións ó prefixo pro
%
pro2e3za 
pro2í3do 
pro2ust 
%
%O prefixo re
.re2a2 .ree2 .re2i2 .re2o2 .re2u2 .re2á2 .reé2 .re2í2 .re2ó2 .re2ú2 
%
%O prefixo sub: l, r e excepcións
.su2b3l .su2b3r 
%
%Formas do verbo subir con pronomes enclíticos
.su2b2i2 
.su2b2í2 
.sub2eriz 
.sub2orna 
%
sub3índic sub3indic sub3indiz 
%
.sub4lev 
.sub4lim 
%
su3b2e3la. 
su3b2e3las. 
su3b2é3rico 
su3b2e3rina. 
su3b2e3rinas. 
su3b2eroso 
su3b2iote 
su3b2ulado 
su3b2orno. 
su3b2ornos. 
su3b2urbio 
%
su3b4liminar 
su3b4repción 
su3b4reptici 
%
%Excepcións ó prefixo tri
%
tri2a3ga. 
tri2a3gas. 
tri2al. 
tri2a3les. 
tri2angul 
tri2á3sico. 
tri2estin 
tri2unf 
tri2unvir 
%
%Excepcións a varios prefixos que son terminacións verbais
%
2a3do. 2i3do. 
2a3da. 2i3da. 
2a3dos. 2i3dos. 
2a3das. 2i3das. 
2ando. 2indo. 
2ar. 2ir. 
%
2a3res. 2e3res. 2i3res. 
2armos. 2ermos. 2irmos. 
2ardes. 2erdes. 2irdes. 
2a3ren. 2e3ren. 2i3ren. 
%
2arme. 2erme. 2irme. 
2arte. 2erte. 2irte. 
2arlle. 2erlle. 2irlle. 
2arnos. 2ernos. 2irnos. 
2arvos. 2ervos. 2irvos. 
2arlles. 2erlles. 2irlles. 
%
2a3dor. 2e3dor. 2i3dor. 
2a3dora. 2e3dora. 2i3dora. 
2a3dores. 2e3dores. 2i3dores. 
2a3doiro. 2e3doiro. 2i3doiro. 
2a3doiros. 2e3doiros. 2i3doiros. 
2a3doira. 2e3doira. 2i3doira. 
2a3doiras. 2e3doiras. 2i3doiras. 
2a3deiro. 2e3deiro. 2i3deiro. 
2a3deiros. 2e3deiros. 2i3deiros. 
2a3deira. 2e3deira. 2i3deira. 
2a3deiras. 2e3deiras. 2i3deiras. 
2a3lo. 2e3lo. 2i3lo. 
2a3los. 2e3los. 2i3los. 
2a3la. 2e3la. 2i3la. 
2a3las. 2e3las. 2i3las. 
2a3rei. 2e3rei. 2i3rei. 
2a3rás. 2e3rás. 2i3rás. 
2a3rá. 2e3rá. 2i3rá. 
2a3remos. 2e3remos. 2i3remos. 
2a3redes. 2e3redes. 2i3redes. 
2a3rán. 2e3rán. 2i3rán. 
%
2a3ría. 2e3ría. 2i3ría. 
2a3rías. 2e3rías. 2i3rías. 
2a3ri1amos. 2e3ri1amos. 2i3ri1amos. 
2a3ri1ades. 2e3ri1ades. 2i3ri1ades. 
2a3rían. 2e3rían. 2i3rían. 
%
2a3de. 2e3de. 2i3de. 
%
2á3deo. 2é3deo. 2í3deo. 
2á3dea. 2é3dea. 2í3dea. 
2á3deos. 2é3deos. 2í3deos. 
2á3deas. 2é3deas. 2í3deas. 
%
2as. 2a3mos. 2a3des. 2an. 
2a3ba. 2a3bas. 2a3bamos. 2a3bades. 2a3ban. 
2a3ches. 2astes. 2a3ron. 
2es. 2e3mos. 2e3des. 2en. 
2a3se. 2a3ses. 2á3semos. 2á3sedes. 2a3sen. 
%
o3ar. o3ado. o3ada. o3ados. o3adas. o3ando. 
o3ares. o3armos. o3ardes. o3aren. 
o3arme. o3arte. o3arlle. o3arnos. o3arvos. o3arlles. 
o3alo. o3alos. o3ala. o3alas. 
o3ade. o3ádeo. o3ádea. o3ádeos. o3ádeas. 
o3as. o3amos. o3ades. o3an. 
o3aba. o3abas. o3abamos. o3abades. o3aban. 
o3aches. o3astes. o3aron. 
o3es. o3emos. o3edes. o3en. 
o3ase. o3ases. o3ásemos. o3ásedes. o3asen. 
%
e3ar. e3ado. e3ada. e3ados. e3adas. e3ando. 
e3ares. e3armos. e3ardes. e3aren. 
e3arme. e3arte. e3arlle. e3arnos. e3arvos. e3arlles. 
e3alo. e3alos. e3ala. e3alas. 
e3ade. e3ádeo. e3ádea. e3ádeos. e3ádeas. 
e3as. e3amos. e3ades. e3an. 
e3aba. e3abas. e3abamos. e3abades. e3aban. 
e3aches. e3astes. e3aron. 
e3es. e3emos. e3edes. e3en. 
e3ase. e3ases. e3ásemos. e3ásedes. e3asen. 
%
2i3mos. 2i3des. 
2ía. 2í3as. 2í3an. 
2ín. 2i3ches. 2iu. 2istes. 2i3ron. 
2i3se. 2i3ses. 2í3semos. 2í3sedes. 2i3sen. 
%
í3do í3da í3dos í3das 
%
.su3bir. .su3bindo. .su3bido. .su3bida. .su3bidos. .su3bidas. 
.su3bires. .su3birmos. .su3birdes. .su3biren. 
.su3bo. .su3bes. .su3be. .su3bimos. .su3bides. .su3ben. 
.su3bía. .su3bías. .su3b2i3amos. .su3b2i3ades. .su3bían. 
.su3bín. .su3biches. .su3biu. .su3bistes. .su3biron. 
.su3birei. .su3birás. .su3birá. .su3biremos. .su3biredes. .su3birán. 
.su3biría. .su3birías. .su3biriamos. .su3biriades. .su3birían. 
.su3ba. .su3bas. .su3bamos. .su3bades. .su3ban. 
.su3bise. .su3bises. .su3bísemos. .su3bísedes. .su3bisen. 
.su3bide. .su3bídeo. .su3bídea. .su3bídeas. 
%
a3er. a3endo. 
a3eres. a3ermos. a3erdes. a3eren. 
a3erme. a3erte. a3erlle. a3ernos. a3ervos. a3erlles. 
a3elo. a3elos. a3ela. a3elas. 
a3ede. a3édeo. a3édea. a3édeos. a3édeas. 
a3emos. a3edes. a3eron. 
a3ese. a3eses. a3esemos. a3esedes. a3esen. 
}

