unit module Bayes::Learn;

use Mathx::Stat;

class Bayes::Learn::Action is DistributionPopulation {

	has $.actionthreshold;

	method BUILD(@actiondistribution) {
		$actionthreshold = 0.0000001;
		.population = @actiondistrib;
	}

	### Bayesian Expected Loss E[A] * Loss(p,a) of action a
	method BayesianLoss($believedp) { ### believedp is about an action between [0,1]

		my $sum = 0.0;

		loop (my $a = 0; $a < $believedp; $a+=.actionthreshold) {
			$sum += 2*($a -$believedp) + 2 * $believedp;
		}

		loop (my $a = $believedp; $a < 1; $a+=.actionthreshold) {
			$sum += ($believedp - $a) + 2 * $believedp;
		}

		return $sum;
	}
}

