use Hypothesis;

class LossFunction {

	has $.hypothesis;

	method BUILD(@ddistribution) {
		
		.hypothesis = new Hypothesis(@ddistribution);

	}

	method loss(@condps) { ### The integral inside loss is a Riemann sum

		my $prob = new Probability(.hypothesis.population);
		my $sum = 0.0;

		loop (my $i = 0.0; $i < .hypothesis.population.length; $i++) {
			$sum += $prob.CondP($i, @condps[$i]);
		}	
		return $sum;
	}

	method BayesisanLoss(@condps) {

		my $prob = new Probability(.hypothesis.population);
		my $sum = 0.0;

		my @array = 0..^.hypothesis.population.length;

		loop (my $i = 0.0; $i < .hypothesis.population.length; $i++) {
			$sum += $prob.Bayes(@array, @condps, $i);
		}	
		return $sum;
	}

}
