class MusicAgent is Agent
{	
	has $.musicdb; 
	
	method BUILD($stat) {
		super.BUILD($stat);

		.musicdb = new MusicDB();
	}

	method ask(%args) {
		my $string = super.ask(%args) . "ask music\n";
		
		return %string;
	}

	method ask_music(%args) {
		my $string = "";

		### if (%args{"ask music"}) {
		
			for %args.kv -> $key,$value {
				$string .= .musicdb.search($key);
			}
			return $string;
		###}
		return "";
	}

	### agent dispatched
	method dispatch_agent($agent) {

		### process music or anything from $agent here

		return &$agent.dispatch;
	} 

	method dispatch($msg, %optargs) {
		given $msg {
		when "ask" { self.ask(%optargs) }
		when "ask music" { self.ask_music(%optargs) }
		when "agent" { self.agent(%optargs); }
		default { $status = 0; return; }
		$status = 1;
	}
}
